// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package webui

import "encoding/json"

// APIConfig for upstream APIs.
type APIConfig struct {
	Enabled bool   `json:"enabled" name:"enabled" description:"Enable this API"`
	BaseURL string `json:"base_url" name:"base-url" description:"Base URL to the HTTP API"`
}

// MarshalJSON implements json.Marshaler.
func (c APIConfig) MarshalJSON() ([]byte, error) {
	out := struct {
		Enabled bool   `json:"enabled"`
		BaseURL string `json:"base_url,omitempty"`
	}{
		Enabled: c.Enabled,
		BaseURL: c.BaseURL,
	}
	if !out.Enabled {
		out.BaseURL = ""
	}
	return json.Marshal(out)
}
