// Copyright © 2022 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import classNames from 'classnames'
import React from 'react'

import PropTypes from '@ttn-lw/lib/prop-types'

import style from './button.styl'

const ButtonGroup = ({ className, children, align }) => (
  <div className={classNames(style.buttonGroup, className, [style[`align-${align}`]])}>
    {children}
  </div>
)

ButtonGroup.propTypes = {
  align: PropTypes.oneOf(['start', 'end', 'center']),
  children: PropTypes.node.isRequired,
  className: PropTypes.string,
}

ButtonGroup.defaultProps = {
  align: 'start',
  className: undefined,
}

export default ButtonGroup
