// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package oauthclient

// Config is the configuration for the OAuth client.
type Config struct {
	AuthorizeURL string `name:"authorize-url" description:"The OAuth Authorize URL"`
	LogoutURL    string `name:"logout-url" description:"The OAuth Logout URL"`
	TokenURL     string `name:"token-url" description:"The OAuth Token Exchange URL"`
	RootURL      string `name:"-"`

	ClientID     string `name:"client-id" description:"The OAuth client ID"`
	ClientSecret string `name:"client-secret" description:"The OAuth client secret" json:"-"`

	CrossSiteCookie bool `name:"cross-site-cookie" description:"Whether to make OAuth cookies accessible cross-site"`

	StateCookieName string `name:"-"`
	AuthCookieName  string `name:"-"`

	customProvider bool
}
