// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.1
// source: ttn/lorawan/v3/user_services.proto

package ttnpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	UserRegistry_Create_FullMethodName                  = "/ttn.lorawan.v3.UserRegistry/Create"
	UserRegistry_Get_FullMethodName                     = "/ttn.lorawan.v3.UserRegistry/Get"
	UserRegistry_List_FullMethodName                    = "/ttn.lorawan.v3.UserRegistry/List"
	UserRegistry_Update_FullMethodName                  = "/ttn.lorawan.v3.UserRegistry/Update"
	UserRegistry_CreateTemporaryPassword_FullMethodName = "/ttn.lorawan.v3.UserRegistry/CreateTemporaryPassword"
	UserRegistry_UpdatePassword_FullMethodName          = "/ttn.lorawan.v3.UserRegistry/UpdatePassword"
	UserRegistry_Delete_FullMethodName                  = "/ttn.lorawan.v3.UserRegistry/Delete"
	UserRegistry_Restore_FullMethodName                 = "/ttn.lorawan.v3.UserRegistry/Restore"
	UserRegistry_Purge_FullMethodName                   = "/ttn.lorawan.v3.UserRegistry/Purge"
)

// UserRegistryClient is the client API for UserRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type UserRegistryClient interface {
	// Register a new user. This method may be restricted by network settings.
	Create(ctx context.Context, in *CreateUserRequest, opts ...grpc.CallOption) (*User, error)
	// Get the user with the given identifiers, selecting the fields given by the
	// field mask. The method may return more or less fields, depending on the rights
	// of the caller.
	Get(ctx context.Context, in *GetUserRequest, opts ...grpc.CallOption) (*User, error)
	// List users of the network. This method is typically restricted to admins only.
	List(ctx context.Context, in *ListUsersRequest, opts ...grpc.CallOption) (*Users, error)
	// Update the user, changing the fields specified by the field mask to the provided values.
	// This method can not be used to change the password, see the UpdatePassword method for that.
	Update(ctx context.Context, in *UpdateUserRequest, opts ...grpc.CallOption) (*User, error)
	// Create a temporary password that can be used for updating a forgotten password.
	// The generated password is sent to the user's email address.
	CreateTemporaryPassword(ctx context.Context, in *CreateTemporaryPasswordRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Update the password of the user.
	UpdatePassword(ctx context.Context, in *UpdateUserPasswordRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Delete the user. This may not release the user ID for reuse.
	Delete(ctx context.Context, in *UserIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Restore a recently deleted user.
	//
	// Deployment configuration may specify if, and for how long after deletion,
	// entities can be restored.
	Restore(ctx context.Context, in *UserIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Purge the user. This will release the user ID for reuse.
	// The user is responsible for clearing data from any (external) integrations
	// that may store and expose data by user or organization ID.
	Purge(ctx context.Context, in *UserIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type userRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewUserRegistryClient(cc grpc.ClientConnInterface) UserRegistryClient {
	return &userRegistryClient{cc}
}

func (c *userRegistryClient) Create(ctx context.Context, in *CreateUserRequest, opts ...grpc.CallOption) (*User, error) {
	out := new(User)
	err := c.cc.Invoke(ctx, UserRegistry_Create_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userRegistryClient) Get(ctx context.Context, in *GetUserRequest, opts ...grpc.CallOption) (*User, error) {
	out := new(User)
	err := c.cc.Invoke(ctx, UserRegistry_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userRegistryClient) List(ctx context.Context, in *ListUsersRequest, opts ...grpc.CallOption) (*Users, error) {
	out := new(Users)
	err := c.cc.Invoke(ctx, UserRegistry_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userRegistryClient) Update(ctx context.Context, in *UpdateUserRequest, opts ...grpc.CallOption) (*User, error) {
	out := new(User)
	err := c.cc.Invoke(ctx, UserRegistry_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userRegistryClient) CreateTemporaryPassword(ctx context.Context, in *CreateTemporaryPasswordRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, UserRegistry_CreateTemporaryPassword_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userRegistryClient) UpdatePassword(ctx context.Context, in *UpdateUserPasswordRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, UserRegistry_UpdatePassword_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userRegistryClient) Delete(ctx context.Context, in *UserIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, UserRegistry_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userRegistryClient) Restore(ctx context.Context, in *UserIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, UserRegistry_Restore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userRegistryClient) Purge(ctx context.Context, in *UserIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, UserRegistry_Purge_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserRegistryServer is the server API for UserRegistry service.
// All implementations must embed UnimplementedUserRegistryServer
// for forward compatibility
type UserRegistryServer interface {
	// Register a new user. This method may be restricted by network settings.
	Create(context.Context, *CreateUserRequest) (*User, error)
	// Get the user with the given identifiers, selecting the fields given by the
	// field mask. The method may return more or less fields, depending on the rights
	// of the caller.
	Get(context.Context, *GetUserRequest) (*User, error)
	// List users of the network. This method is typically restricted to admins only.
	List(context.Context, *ListUsersRequest) (*Users, error)
	// Update the user, changing the fields specified by the field mask to the provided values.
	// This method can not be used to change the password, see the UpdatePassword method for that.
	Update(context.Context, *UpdateUserRequest) (*User, error)
	// Create a temporary password that can be used for updating a forgotten password.
	// The generated password is sent to the user's email address.
	CreateTemporaryPassword(context.Context, *CreateTemporaryPasswordRequest) (*emptypb.Empty, error)
	// Update the password of the user.
	UpdatePassword(context.Context, *UpdateUserPasswordRequest) (*emptypb.Empty, error)
	// Delete the user. This may not release the user ID for reuse.
	Delete(context.Context, *UserIdentifiers) (*emptypb.Empty, error)
	// Restore a recently deleted user.
	//
	// Deployment configuration may specify if, and for how long after deletion,
	// entities can be restored.
	Restore(context.Context, *UserIdentifiers) (*emptypb.Empty, error)
	// Purge the user. This will release the user ID for reuse.
	// The user is responsible for clearing data from any (external) integrations
	// that may store and expose data by user or organization ID.
	Purge(context.Context, *UserIdentifiers) (*emptypb.Empty, error)
	mustEmbedUnimplementedUserRegistryServer()
}

// UnimplementedUserRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedUserRegistryServer struct {
}

func (UnimplementedUserRegistryServer) Create(context.Context, *CreateUserRequest) (*User, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedUserRegistryServer) Get(context.Context, *GetUserRequest) (*User, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedUserRegistryServer) List(context.Context, *ListUsersRequest) (*Users, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedUserRegistryServer) Update(context.Context, *UpdateUserRequest) (*User, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedUserRegistryServer) CreateTemporaryPassword(context.Context, *CreateTemporaryPasswordRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTemporaryPassword not implemented")
}
func (UnimplementedUserRegistryServer) UpdatePassword(context.Context, *UpdateUserPasswordRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePassword not implemented")
}
func (UnimplementedUserRegistryServer) Delete(context.Context, *UserIdentifiers) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedUserRegistryServer) Restore(context.Context, *UserIdentifiers) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Restore not implemented")
}
func (UnimplementedUserRegistryServer) Purge(context.Context, *UserIdentifiers) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Purge not implemented")
}
func (UnimplementedUserRegistryServer) mustEmbedUnimplementedUserRegistryServer() {}

// UnsafeUserRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to UserRegistryServer will
// result in compilation errors.
type UnsafeUserRegistryServer interface {
	mustEmbedUnimplementedUserRegistryServer()
}

func RegisterUserRegistryServer(s grpc.ServiceRegistrar, srv UserRegistryServer) {
	s.RegisterService(&UserRegistry_ServiceDesc, srv)
}

func _UserRegistry_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserRegistryServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserRegistry_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserRegistryServer).Create(ctx, req.(*CreateUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserRegistry_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserRegistryServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserRegistry_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserRegistryServer).Get(ctx, req.(*GetUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserRegistry_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUsersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserRegistryServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserRegistry_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserRegistryServer).List(ctx, req.(*ListUsersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserRegistry_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserRegistryServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserRegistry_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserRegistryServer).Update(ctx, req.(*UpdateUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserRegistry_CreateTemporaryPassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTemporaryPasswordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserRegistryServer).CreateTemporaryPassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserRegistry_CreateTemporaryPassword_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserRegistryServer).CreateTemporaryPassword(ctx, req.(*CreateTemporaryPasswordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserRegistry_UpdatePassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserPasswordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserRegistryServer).UpdatePassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserRegistry_UpdatePassword_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserRegistryServer).UpdatePassword(ctx, req.(*UpdateUserPasswordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserRegistry_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserRegistryServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserRegistry_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserRegistryServer).Delete(ctx, req.(*UserIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserRegistry_Restore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserRegistryServer).Restore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserRegistry_Restore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserRegistryServer).Restore(ctx, req.(*UserIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserRegistry_Purge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserRegistryServer).Purge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserRegistry_Purge_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserRegistryServer).Purge(ctx, req.(*UserIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

// UserRegistry_ServiceDesc is the grpc.ServiceDesc for UserRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var UserRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.UserRegistry",
	HandlerType: (*UserRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _UserRegistry_Create_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _UserRegistry_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _UserRegistry_List_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _UserRegistry_Update_Handler,
		},
		{
			MethodName: "CreateTemporaryPassword",
			Handler:    _UserRegistry_CreateTemporaryPassword_Handler,
		},
		{
			MethodName: "UpdatePassword",
			Handler:    _UserRegistry_UpdatePassword_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _UserRegistry_Delete_Handler,
		},
		{
			MethodName: "Restore",
			Handler:    _UserRegistry_Restore_Handler,
		},
		{
			MethodName: "Purge",
			Handler:    _UserRegistry_Purge_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/user_services.proto",
}

const (
	UserAccess_ListRights_FullMethodName       = "/ttn.lorawan.v3.UserAccess/ListRights"
	UserAccess_CreateAPIKey_FullMethodName     = "/ttn.lorawan.v3.UserAccess/CreateAPIKey"
	UserAccess_ListAPIKeys_FullMethodName      = "/ttn.lorawan.v3.UserAccess/ListAPIKeys"
	UserAccess_GetAPIKey_FullMethodName        = "/ttn.lorawan.v3.UserAccess/GetAPIKey"
	UserAccess_UpdateAPIKey_FullMethodName     = "/ttn.lorawan.v3.UserAccess/UpdateAPIKey"
	UserAccess_DeleteAPIKey_FullMethodName     = "/ttn.lorawan.v3.UserAccess/DeleteAPIKey"
	UserAccess_CreateLoginToken_FullMethodName = "/ttn.lorawan.v3.UserAccess/CreateLoginToken"
)

// UserAccessClient is the client API for UserAccess service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type UserAccessClient interface {
	// List the rights the caller has on this user.
	ListRights(ctx context.Context, in *UserIdentifiers, opts ...grpc.CallOption) (*Rights, error)
	// Create an API key scoped to this user.
	// User API keys can give access to the user itself, as well as
	// any organization, application, gateway and OAuth client this user is a collaborator of.
	CreateAPIKey(ctx context.Context, in *CreateUserAPIKeyRequest, opts ...grpc.CallOption) (*APIKey, error)
	// List the API keys for this user.
	ListAPIKeys(ctx context.Context, in *ListUserAPIKeysRequest, opts ...grpc.CallOption) (*APIKeys, error)
	// Get a single API key of this user.
	GetAPIKey(ctx context.Context, in *GetUserAPIKeyRequest, opts ...grpc.CallOption) (*APIKey, error)
	// Update the rights of an API key of the user.
	// This method can also be used to delete the API key, by giving it no rights.
	// The caller is required to have all assigned or/and removed rights.
	UpdateAPIKey(ctx context.Context, in *UpdateUserAPIKeyRequest, opts ...grpc.CallOption) (*APIKey, error)
	// Delete a single API key of this user.
	DeleteAPIKey(ctx context.Context, in *DeleteUserAPIKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Create a login token that can be used for a one-time login as a user.
	CreateLoginToken(ctx context.Context, in *CreateLoginTokenRequest, opts ...grpc.CallOption) (*CreateLoginTokenResponse, error)
}

type userAccessClient struct {
	cc grpc.ClientConnInterface
}

func NewUserAccessClient(cc grpc.ClientConnInterface) UserAccessClient {
	return &userAccessClient{cc}
}

func (c *userAccessClient) ListRights(ctx context.Context, in *UserIdentifiers, opts ...grpc.CallOption) (*Rights, error) {
	out := new(Rights)
	err := c.cc.Invoke(ctx, UserAccess_ListRights_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userAccessClient) CreateAPIKey(ctx context.Context, in *CreateUserAPIKeyRequest, opts ...grpc.CallOption) (*APIKey, error) {
	out := new(APIKey)
	err := c.cc.Invoke(ctx, UserAccess_CreateAPIKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userAccessClient) ListAPIKeys(ctx context.Context, in *ListUserAPIKeysRequest, opts ...grpc.CallOption) (*APIKeys, error) {
	out := new(APIKeys)
	err := c.cc.Invoke(ctx, UserAccess_ListAPIKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userAccessClient) GetAPIKey(ctx context.Context, in *GetUserAPIKeyRequest, opts ...grpc.CallOption) (*APIKey, error) {
	out := new(APIKey)
	err := c.cc.Invoke(ctx, UserAccess_GetAPIKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userAccessClient) UpdateAPIKey(ctx context.Context, in *UpdateUserAPIKeyRequest, opts ...grpc.CallOption) (*APIKey, error) {
	out := new(APIKey)
	err := c.cc.Invoke(ctx, UserAccess_UpdateAPIKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userAccessClient) DeleteAPIKey(ctx context.Context, in *DeleteUserAPIKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, UserAccess_DeleteAPIKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userAccessClient) CreateLoginToken(ctx context.Context, in *CreateLoginTokenRequest, opts ...grpc.CallOption) (*CreateLoginTokenResponse, error) {
	out := new(CreateLoginTokenResponse)
	err := c.cc.Invoke(ctx, UserAccess_CreateLoginToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserAccessServer is the server API for UserAccess service.
// All implementations must embed UnimplementedUserAccessServer
// for forward compatibility
type UserAccessServer interface {
	// List the rights the caller has on this user.
	ListRights(context.Context, *UserIdentifiers) (*Rights, error)
	// Create an API key scoped to this user.
	// User API keys can give access to the user itself, as well as
	// any organization, application, gateway and OAuth client this user is a collaborator of.
	CreateAPIKey(context.Context, *CreateUserAPIKeyRequest) (*APIKey, error)
	// List the API keys for this user.
	ListAPIKeys(context.Context, *ListUserAPIKeysRequest) (*APIKeys, error)
	// Get a single API key of this user.
	GetAPIKey(context.Context, *GetUserAPIKeyRequest) (*APIKey, error)
	// Update the rights of an API key of the user.
	// This method can also be used to delete the API key, by giving it no rights.
	// The caller is required to have all assigned or/and removed rights.
	UpdateAPIKey(context.Context, *UpdateUserAPIKeyRequest) (*APIKey, error)
	// Delete a single API key of this user.
	DeleteAPIKey(context.Context, *DeleteUserAPIKeyRequest) (*emptypb.Empty, error)
	// Create a login token that can be used for a one-time login as a user.
	CreateLoginToken(context.Context, *CreateLoginTokenRequest) (*CreateLoginTokenResponse, error)
	mustEmbedUnimplementedUserAccessServer()
}

// UnimplementedUserAccessServer must be embedded to have forward compatible implementations.
type UnimplementedUserAccessServer struct {
}

func (UnimplementedUserAccessServer) ListRights(context.Context, *UserIdentifiers) (*Rights, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRights not implemented")
}
func (UnimplementedUserAccessServer) CreateAPIKey(context.Context, *CreateUserAPIKeyRequest) (*APIKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAPIKey not implemented")
}
func (UnimplementedUserAccessServer) ListAPIKeys(context.Context, *ListUserAPIKeysRequest) (*APIKeys, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAPIKeys not implemented")
}
func (UnimplementedUserAccessServer) GetAPIKey(context.Context, *GetUserAPIKeyRequest) (*APIKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIKey not implemented")
}
func (UnimplementedUserAccessServer) UpdateAPIKey(context.Context, *UpdateUserAPIKeyRequest) (*APIKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAPIKey not implemented")
}
func (UnimplementedUserAccessServer) DeleteAPIKey(context.Context, *DeleteUserAPIKeyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAPIKey not implemented")
}
func (UnimplementedUserAccessServer) CreateLoginToken(context.Context, *CreateLoginTokenRequest) (*CreateLoginTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLoginToken not implemented")
}
func (UnimplementedUserAccessServer) mustEmbedUnimplementedUserAccessServer() {}

// UnsafeUserAccessServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to UserAccessServer will
// result in compilation errors.
type UnsafeUserAccessServer interface {
	mustEmbedUnimplementedUserAccessServer()
}

func RegisterUserAccessServer(s grpc.ServiceRegistrar, srv UserAccessServer) {
	s.RegisterService(&UserAccess_ServiceDesc, srv)
}

func _UserAccess_ListRights_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserAccessServer).ListRights(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserAccess_ListRights_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserAccessServer).ListRights(ctx, req.(*UserIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserAccess_CreateAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUserAPIKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserAccessServer).CreateAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserAccess_CreateAPIKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserAccessServer).CreateAPIKey(ctx, req.(*CreateUserAPIKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserAccess_ListAPIKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUserAPIKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserAccessServer).ListAPIKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserAccess_ListAPIKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserAccessServer).ListAPIKeys(ctx, req.(*ListUserAPIKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserAccess_GetAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserAPIKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserAccessServer).GetAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserAccess_GetAPIKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserAccessServer).GetAPIKey(ctx, req.(*GetUserAPIKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserAccess_UpdateAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserAPIKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserAccessServer).UpdateAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserAccess_UpdateAPIKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserAccessServer).UpdateAPIKey(ctx, req.(*UpdateUserAPIKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserAccess_DeleteAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUserAPIKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserAccessServer).DeleteAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserAccess_DeleteAPIKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserAccessServer).DeleteAPIKey(ctx, req.(*DeleteUserAPIKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserAccess_CreateLoginToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLoginTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserAccessServer).CreateLoginToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserAccess_CreateLoginToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserAccessServer).CreateLoginToken(ctx, req.(*CreateLoginTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// UserAccess_ServiceDesc is the grpc.ServiceDesc for UserAccess service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var UserAccess_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.UserAccess",
	HandlerType: (*UserAccessServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListRights",
			Handler:    _UserAccess_ListRights_Handler,
		},
		{
			MethodName: "CreateAPIKey",
			Handler:    _UserAccess_CreateAPIKey_Handler,
		},
		{
			MethodName: "ListAPIKeys",
			Handler:    _UserAccess_ListAPIKeys_Handler,
		},
		{
			MethodName: "GetAPIKey",
			Handler:    _UserAccess_GetAPIKey_Handler,
		},
		{
			MethodName: "UpdateAPIKey",
			Handler:    _UserAccess_UpdateAPIKey_Handler,
		},
		{
			MethodName: "DeleteAPIKey",
			Handler:    _UserAccess_DeleteAPIKey_Handler,
		},
		{
			MethodName: "CreateLoginToken",
			Handler:    _UserAccess_CreateLoginToken_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/user_services.proto",
}

const (
	UserInvitationRegistry_Send_FullMethodName   = "/ttn.lorawan.v3.UserInvitationRegistry/Send"
	UserInvitationRegistry_List_FullMethodName   = "/ttn.lorawan.v3.UserInvitationRegistry/List"
	UserInvitationRegistry_Delete_FullMethodName = "/ttn.lorawan.v3.UserInvitationRegistry/Delete"
)

// UserInvitationRegistryClient is the client API for UserInvitationRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type UserInvitationRegistryClient interface {
	// Invite a user to join the network.
	Send(ctx context.Context, in *SendInvitationRequest, opts ...grpc.CallOption) (*Invitation, error)
	// List the invitations the caller has sent.
	List(ctx context.Context, in *ListInvitationsRequest, opts ...grpc.CallOption) (*Invitations, error)
	// Delete (revoke) a user invitation.
	Delete(ctx context.Context, in *DeleteInvitationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type userInvitationRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewUserInvitationRegistryClient(cc grpc.ClientConnInterface) UserInvitationRegistryClient {
	return &userInvitationRegistryClient{cc}
}

func (c *userInvitationRegistryClient) Send(ctx context.Context, in *SendInvitationRequest, opts ...grpc.CallOption) (*Invitation, error) {
	out := new(Invitation)
	err := c.cc.Invoke(ctx, UserInvitationRegistry_Send_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userInvitationRegistryClient) List(ctx context.Context, in *ListInvitationsRequest, opts ...grpc.CallOption) (*Invitations, error) {
	out := new(Invitations)
	err := c.cc.Invoke(ctx, UserInvitationRegistry_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userInvitationRegistryClient) Delete(ctx context.Context, in *DeleteInvitationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, UserInvitationRegistry_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserInvitationRegistryServer is the server API for UserInvitationRegistry service.
// All implementations must embed UnimplementedUserInvitationRegistryServer
// for forward compatibility
type UserInvitationRegistryServer interface {
	// Invite a user to join the network.
	Send(context.Context, *SendInvitationRequest) (*Invitation, error)
	// List the invitations the caller has sent.
	List(context.Context, *ListInvitationsRequest) (*Invitations, error)
	// Delete (revoke) a user invitation.
	Delete(context.Context, *DeleteInvitationRequest) (*emptypb.Empty, error)
	mustEmbedUnimplementedUserInvitationRegistryServer()
}

// UnimplementedUserInvitationRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedUserInvitationRegistryServer struct {
}

func (UnimplementedUserInvitationRegistryServer) Send(context.Context, *SendInvitationRequest) (*Invitation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Send not implemented")
}
func (UnimplementedUserInvitationRegistryServer) List(context.Context, *ListInvitationsRequest) (*Invitations, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedUserInvitationRegistryServer) Delete(context.Context, *DeleteInvitationRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedUserInvitationRegistryServer) mustEmbedUnimplementedUserInvitationRegistryServer() {
}

// UnsafeUserInvitationRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to UserInvitationRegistryServer will
// result in compilation errors.
type UnsafeUserInvitationRegistryServer interface {
	mustEmbedUnimplementedUserInvitationRegistryServer()
}

func RegisterUserInvitationRegistryServer(s grpc.ServiceRegistrar, srv UserInvitationRegistryServer) {
	s.RegisterService(&UserInvitationRegistry_ServiceDesc, srv)
}

func _UserInvitationRegistry_Send_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendInvitationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserInvitationRegistryServer).Send(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserInvitationRegistry_Send_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserInvitationRegistryServer).Send(ctx, req.(*SendInvitationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserInvitationRegistry_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInvitationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserInvitationRegistryServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserInvitationRegistry_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserInvitationRegistryServer).List(ctx, req.(*ListInvitationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserInvitationRegistry_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInvitationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserInvitationRegistryServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserInvitationRegistry_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserInvitationRegistryServer).Delete(ctx, req.(*DeleteInvitationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// UserInvitationRegistry_ServiceDesc is the grpc.ServiceDesc for UserInvitationRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var UserInvitationRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.UserInvitationRegistry",
	HandlerType: (*UserInvitationRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Send",
			Handler:    _UserInvitationRegistry_Send_Handler,
		},
		{
			MethodName: "List",
			Handler:    _UserInvitationRegistry_List_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _UserInvitationRegistry_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/user_services.proto",
}

const (
	UserSessionRegistry_List_FullMethodName   = "/ttn.lorawan.v3.UserSessionRegistry/List"
	UserSessionRegistry_Delete_FullMethodName = "/ttn.lorawan.v3.UserSessionRegistry/Delete"
)

// UserSessionRegistryClient is the client API for UserSessionRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type UserSessionRegistryClient interface {
	// List the active sessions for the given user.
	List(ctx context.Context, in *ListUserSessionsRequest, opts ...grpc.CallOption) (*UserSessions, error)
	// Delete (revoke) the given user session.
	Delete(ctx context.Context, in *UserSessionIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type userSessionRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewUserSessionRegistryClient(cc grpc.ClientConnInterface) UserSessionRegistryClient {
	return &userSessionRegistryClient{cc}
}

func (c *userSessionRegistryClient) List(ctx context.Context, in *ListUserSessionsRequest, opts ...grpc.CallOption) (*UserSessions, error) {
	out := new(UserSessions)
	err := c.cc.Invoke(ctx, UserSessionRegistry_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userSessionRegistryClient) Delete(ctx context.Context, in *UserSessionIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, UserSessionRegistry_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserSessionRegistryServer is the server API for UserSessionRegistry service.
// All implementations must embed UnimplementedUserSessionRegistryServer
// for forward compatibility
type UserSessionRegistryServer interface {
	// List the active sessions for the given user.
	List(context.Context, *ListUserSessionsRequest) (*UserSessions, error)
	// Delete (revoke) the given user session.
	Delete(context.Context, *UserSessionIdentifiers) (*emptypb.Empty, error)
	mustEmbedUnimplementedUserSessionRegistryServer()
}

// UnimplementedUserSessionRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedUserSessionRegistryServer struct {
}

func (UnimplementedUserSessionRegistryServer) List(context.Context, *ListUserSessionsRequest) (*UserSessions, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedUserSessionRegistryServer) Delete(context.Context, *UserSessionIdentifiers) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedUserSessionRegistryServer) mustEmbedUnimplementedUserSessionRegistryServer() {}

// UnsafeUserSessionRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to UserSessionRegistryServer will
// result in compilation errors.
type UnsafeUserSessionRegistryServer interface {
	mustEmbedUnimplementedUserSessionRegistryServer()
}

func RegisterUserSessionRegistryServer(s grpc.ServiceRegistrar, srv UserSessionRegistryServer) {
	s.RegisterService(&UserSessionRegistry_ServiceDesc, srv)
}

func _UserSessionRegistry_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUserSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserSessionRegistryServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserSessionRegistry_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserSessionRegistryServer).List(ctx, req.(*ListUserSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserSessionRegistry_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserSessionIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserSessionRegistryServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserSessionRegistry_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserSessionRegistryServer).Delete(ctx, req.(*UserSessionIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

// UserSessionRegistry_ServiceDesc is the grpc.ServiceDesc for UserSessionRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var UserSessionRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.UserSessionRegistry",
	HandlerType: (*UserSessionRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "List",
			Handler:    _UserSessionRegistry_List_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _UserSessionRegistry_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/user_services.proto",
}

const (
	UserBookmarkRegistry_Create_FullMethodName      = "/ttn.lorawan.v3.UserBookmarkRegistry/Create"
	UserBookmarkRegistry_List_FullMethodName        = "/ttn.lorawan.v3.UserBookmarkRegistry/List"
	UserBookmarkRegistry_Delete_FullMethodName      = "/ttn.lorawan.v3.UserBookmarkRegistry/Delete"
	UserBookmarkRegistry_BatchDelete_FullMethodName = "/ttn.lorawan.v3.UserBookmarkRegistry/BatchDelete"
)

// UserBookmarkRegistryClient is the client API for UserBookmarkRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type UserBookmarkRegistryClient interface {
	// Create a bookmark for the given user.
	Create(ctx context.Context, in *CreateUserBookmarkRequest, opts ...grpc.CallOption) (*UserBookmark, error)
	// List the bookmarks for the given user.
	List(ctx context.Context, in *ListUserBookmarksRequest, opts ...grpc.CallOption) (*UserBookmarks, error)
	// Delete the given user's bookmark.
	Delete(ctx context.Context, in *DeleteUserBookmarkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Delete a list of bookmarks of the given user.
	// This operation is atomic; either all bookmarks are deleted or none.
	// Bookmarks not found are skipped and no error is returned.
	BatchDelete(ctx context.Context, in *BatchDeleteUserBookmarksRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type userBookmarkRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewUserBookmarkRegistryClient(cc grpc.ClientConnInterface) UserBookmarkRegistryClient {
	return &userBookmarkRegistryClient{cc}
}

func (c *userBookmarkRegistryClient) Create(ctx context.Context, in *CreateUserBookmarkRequest, opts ...grpc.CallOption) (*UserBookmark, error) {
	out := new(UserBookmark)
	err := c.cc.Invoke(ctx, UserBookmarkRegistry_Create_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userBookmarkRegistryClient) List(ctx context.Context, in *ListUserBookmarksRequest, opts ...grpc.CallOption) (*UserBookmarks, error) {
	out := new(UserBookmarks)
	err := c.cc.Invoke(ctx, UserBookmarkRegistry_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userBookmarkRegistryClient) Delete(ctx context.Context, in *DeleteUserBookmarkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, UserBookmarkRegistry_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userBookmarkRegistryClient) BatchDelete(ctx context.Context, in *BatchDeleteUserBookmarksRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, UserBookmarkRegistry_BatchDelete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserBookmarkRegistryServer is the server API for UserBookmarkRegistry service.
// All implementations must embed UnimplementedUserBookmarkRegistryServer
// for forward compatibility
type UserBookmarkRegistryServer interface {
	// Create a bookmark for the given user.
	Create(context.Context, *CreateUserBookmarkRequest) (*UserBookmark, error)
	// List the bookmarks for the given user.
	List(context.Context, *ListUserBookmarksRequest) (*UserBookmarks, error)
	// Delete the given user's bookmark.
	Delete(context.Context, *DeleteUserBookmarkRequest) (*emptypb.Empty, error)
	// Delete a list of bookmarks of the given user.
	// This operation is atomic; either all bookmarks are deleted or none.
	// Bookmarks not found are skipped and no error is returned.
	BatchDelete(context.Context, *BatchDeleteUserBookmarksRequest) (*emptypb.Empty, error)
	mustEmbedUnimplementedUserBookmarkRegistryServer()
}

// UnimplementedUserBookmarkRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedUserBookmarkRegistryServer struct {
}

func (UnimplementedUserBookmarkRegistryServer) Create(context.Context, *CreateUserBookmarkRequest) (*UserBookmark, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedUserBookmarkRegistryServer) List(context.Context, *ListUserBookmarksRequest) (*UserBookmarks, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedUserBookmarkRegistryServer) Delete(context.Context, *DeleteUserBookmarkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedUserBookmarkRegistryServer) BatchDelete(context.Context, *BatchDeleteUserBookmarksRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDelete not implemented")
}
func (UnimplementedUserBookmarkRegistryServer) mustEmbedUnimplementedUserBookmarkRegistryServer() {}

// UnsafeUserBookmarkRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to UserBookmarkRegistryServer will
// result in compilation errors.
type UnsafeUserBookmarkRegistryServer interface {
	mustEmbedUnimplementedUserBookmarkRegistryServer()
}

func RegisterUserBookmarkRegistryServer(s grpc.ServiceRegistrar, srv UserBookmarkRegistryServer) {
	s.RegisterService(&UserBookmarkRegistry_ServiceDesc, srv)
}

func _UserBookmarkRegistry_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUserBookmarkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserBookmarkRegistryServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserBookmarkRegistry_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserBookmarkRegistryServer).Create(ctx, req.(*CreateUserBookmarkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserBookmarkRegistry_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUserBookmarksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserBookmarkRegistryServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserBookmarkRegistry_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserBookmarkRegistryServer).List(ctx, req.(*ListUserBookmarksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserBookmarkRegistry_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUserBookmarkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserBookmarkRegistryServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserBookmarkRegistry_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserBookmarkRegistryServer).Delete(ctx, req.(*DeleteUserBookmarkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserBookmarkRegistry_BatchDelete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteUserBookmarksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserBookmarkRegistryServer).BatchDelete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserBookmarkRegistry_BatchDelete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserBookmarkRegistryServer).BatchDelete(ctx, req.(*BatchDeleteUserBookmarksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// UserBookmarkRegistry_ServiceDesc is the grpc.ServiceDesc for UserBookmarkRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var UserBookmarkRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.UserBookmarkRegistry",
	HandlerType: (*UserBookmarkRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _UserBookmarkRegistry_Create_Handler,
		},
		{
			MethodName: "List",
			Handler:    _UserBookmarkRegistry_List_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _UserBookmarkRegistry_Delete_Handler,
		},
		{
			MethodName: "BatchDelete",
			Handler:    _UserBookmarkRegistry_BatchDelete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/user_services.proto",
}
