// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on EmailNotificationPreferences with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *EmailNotificationPreferences) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EmailNotificationPreferencesFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "types":

			_EmailNotificationPreferences_Types_Unique := make(map[NotificationType]struct{}, len(m.GetTypes()))

			for idx, item := range m.GetTypes() {
				_, _ = idx, item

				if _, exists := _EmailNotificationPreferences_Types_Unique[item]; exists {
					return EmailNotificationPreferencesValidationError{
						field:  fmt.Sprintf("types[%v]", idx),
						reason: "repeated value must contain unique items",
					}
				} else {
					_EmailNotificationPreferences_Types_Unique[item] = struct{}{}
				}

				if _, ok := NotificationType_name[int32(item)]; !ok {
					return EmailNotificationPreferencesValidationError{
						field:  fmt.Sprintf("types[%v]", idx),
						reason: "value must be one of the defined enum values",
					}
				}

			}

		default:
			return EmailNotificationPreferencesValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EmailNotificationPreferencesValidationError is the validation error returned
// by EmailNotificationPreferences.ValidateFields if the designated
// constraints aren't met.
type EmailNotificationPreferencesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EmailNotificationPreferencesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EmailNotificationPreferencesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EmailNotificationPreferencesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EmailNotificationPreferencesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EmailNotificationPreferencesValidationError) ErrorName() string {
	return "EmailNotificationPreferencesValidationError"
}

// Error satisfies the builtin error interface
func (e EmailNotificationPreferencesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEmailNotificationPreferences.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EmailNotificationPreferencesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EmailNotificationPreferencesValidationError{}

// ValidateFields checks the field values on UserConsolePreferences with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UserConsolePreferences) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UserConsolePreferencesFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "console_theme":
			// no validation rules for ConsoleTheme
		case "dashboard_layouts":

			if v, ok := interface{}(m.GetDashboardLayouts()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserConsolePreferencesValidationError{
						field:  "dashboard_layouts",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "sort_by":

			if v, ok := interface{}(m.GetSortBy()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserConsolePreferencesValidationError{
						field:  "sort_by",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "tutorials":

			if v, ok := interface{}(m.GetTutorials()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserConsolePreferencesValidationError{
						field:  "tutorials",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UserConsolePreferencesValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UserConsolePreferencesValidationError is the validation error returned by
// UserConsolePreferences.ValidateFields if the designated constraints aren't met.
type UserConsolePreferencesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserConsolePreferencesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserConsolePreferencesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserConsolePreferencesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserConsolePreferencesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserConsolePreferencesValidationError) ErrorName() string {
	return "UserConsolePreferencesValidationError"
}

// Error satisfies the builtin error interface
func (e UserConsolePreferencesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserConsolePreferences.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserConsolePreferencesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserConsolePreferencesValidationError{}

// ValidateFields checks the field values on User with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *User) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UserFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return UserValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "created_at":

			if v, ok := interface{}(m.GetCreatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserValidationError{
						field:  "created_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "deleted_at":

			if v, ok := interface{}(m.GetDeletedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserValidationError{
						field:  "deleted_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "name":

			if utf8.RuneCountInString(m.GetName()) > 50 {
				return UserValidationError{
					field:  "name",
					reason: "value length must be at most 50 runes",
				}
			}

		case "description":

			if utf8.RuneCountInString(m.GetDescription()) > 2000 {
				return UserValidationError{
					field:  "description",
					reason: "value length must be at most 2000 runes",
				}
			}

		case "attributes":

			if len(m.GetAttributes()) > 10 {
				return UserValidationError{
					field:  "attributes",
					reason: "value must contain no more than 10 pair(s)",
				}
			}

			for key, val := range m.GetAttributes() {
				_ = val

				if utf8.RuneCountInString(key) > 36 {
					return UserValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value length must be at most 36 runes",
					}
				}

				if !_User_Attributes_Pattern.MatchString(key) {
					return UserValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

				if utf8.RuneCountInString(val) > 200 {
					return UserValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value length must be at most 200 runes",
					}
				}

			}

		case "contact_info":

			if len(m.GetContactInfo()) > 10 {
				return UserValidationError{
					field:  "contact_info",
					reason: "value must contain no more than 10 item(s)",
				}
			}

			for idx, item := range m.GetContactInfo() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return UserValidationError{
							field:  fmt.Sprintf("contact_info[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "primary_email_address":

			if err := m._validateEmail(m.GetPrimaryEmailAddress()); err != nil {
				return UserValidationError{
					field:  "primary_email_address",
					reason: "value must be a valid email address",
					cause:  err,
				}
			}

		case "primary_email_address_validated_at":

			if v, ok := interface{}(m.GetPrimaryEmailAddressValidatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserValidationError{
						field:  "primary_email_address_validated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "password":

			if utf8.RuneCountInString(m.GetPassword()) > 1000 {
				return UserValidationError{
					field:  "password",
					reason: "value length must be at most 1000 runes",
				}
			}

		case "password_updated_at":

			if v, ok := interface{}(m.GetPasswordUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserValidationError{
						field:  "password_updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "require_password_update":
			// no validation rules for RequirePasswordUpdate
		case "state":

			if _, ok := State_name[int32(m.GetState())]; !ok {
				return UserValidationError{
					field:  "state",
					reason: "value must be one of the defined enum values",
				}
			}

		case "state_description":

			if utf8.RuneCountInString(m.GetStateDescription()) > 128 {
				return UserValidationError{
					field:  "state_description",
					reason: "value length must be at most 128 runes",
				}
			}

		case "admin":
			// no validation rules for Admin
		case "temporary_password":

			if utf8.RuneCountInString(m.GetTemporaryPassword()) > 1000 {
				return UserValidationError{
					field:  "temporary_password",
					reason: "value length must be at most 1000 runes",
				}
			}

		case "temporary_password_created_at":

			if v, ok := interface{}(m.GetTemporaryPasswordCreatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserValidationError{
						field:  "temporary_password_created_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "temporary_password_expires_at":

			if v, ok := interface{}(m.GetTemporaryPasswordExpiresAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserValidationError{
						field:  "temporary_password_expires_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "profile_picture":

			if v, ok := interface{}(m.GetProfilePicture()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserValidationError{
						field:  "profile_picture",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "console_preferences":

			if v, ok := interface{}(m.GetConsolePreferences()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserValidationError{
						field:  "console_preferences",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "email_notification_preferences":

			if v, ok := interface{}(m.GetEmailNotificationPreferences()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserValidationError{
						field:  "email_notification_preferences",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "universal_rights":

		default:
			return UserValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

func (m *User) _validateHostname(host string) error {
	s := strings.ToLower(strings.TrimSuffix(host, "."))

	if len(host) > 253 {
		return errors.New("hostname cannot exceed 253 characters")
	}

	for _, part := range strings.Split(s, ".") {
		if l := len(part); l == 0 || l > 63 {
			return errors.New("hostname part must be non-empty and cannot exceed 63 characters")
		}

		if part[0] == '-' {
			return errors.New("hostname parts cannot begin with hyphens")
		}

		if part[len(part)-1] == '-' {
			return errors.New("hostname parts cannot end with hyphens")
		}

		for _, r := range part {
			if (r < 'a' || r > 'z') && (r < '0' || r > '9') && r != '-' {
				return fmt.Errorf("hostname parts can only contain alphanumeric characters or hyphens, got %q", string(r))
			}
		}
	}

	return nil
}

func (m *User) _validateEmail(addr string) error {
	a, err := mail.ParseAddress(addr)
	if err != nil {
		return err
	}
	addr = a.Address

	if len(addr) > 254 {
		return errors.New("email addresses cannot exceed 254 characters")
	}

	parts := strings.SplitN(addr, "@", 2)

	if len(parts[0]) > 64 {
		return errors.New("email address local phrase cannot exceed 64 characters")
	}

	return m._validateHostname(parts[1])
}

// UserValidationError is the validation error returned by User.ValidateFields
// if the designated constraints aren't met.
type UserValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserValidationError) ErrorName() string { return "UserValidationError" }

// Error satisfies the builtin error interface
func (e UserValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUser.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserValidationError{}

var _User_Attributes_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on Users with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *Users) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UsersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "users":

			for idx, item := range m.GetUsers() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return UsersValidationError{
							field:  fmt.Sprintf("users[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return UsersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UsersValidationError is the validation error returned by
// Users.ValidateFields if the designated constraints aren't met.
type UsersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UsersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UsersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UsersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UsersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UsersValidationError) ErrorName() string { return "UsersValidationError" }

// Error satisfies the builtin error interface
func (e UsersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUsers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UsersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UsersValidationError{}

// ValidateFields checks the field values on GetUserRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetUserRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetUserRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return GetUserRequestValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetUserRequestValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetUserRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetUserRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetUserRequestValidationError is the validation error returned by
// GetUserRequest.ValidateFields if the designated constraints aren't met.
type GetUserRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetUserRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetUserRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetUserRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetUserRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetUserRequestValidationError) ErrorName() string { return "GetUserRequestValidationError" }

// Error satisfies the builtin error interface
func (e GetUserRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetUserRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetUserRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetUserRequestValidationError{}

// ValidateFields checks the field values on ListUsersRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ListUsersRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListUsersRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListUsersRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "order":

			if _, ok := _ListUsersRequest_Order_InLookup[m.GetOrder()]; !ok {
				return ListUsersRequestValidationError{
					field:  "order",
					reason: "value must be in list [ user_id -user_id name -name primary_email_address -primary_email_address state -state admin -admin created_at -created_at]",
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListUsersRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "deleted":
			// no validation rules for Deleted
		default:
			return ListUsersRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListUsersRequestValidationError is the validation error returned by
// ListUsersRequest.ValidateFields if the designated constraints aren't met.
type ListUsersRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListUsersRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListUsersRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListUsersRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListUsersRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListUsersRequestValidationError) ErrorName() string { return "ListUsersRequestValidationError" }

// Error satisfies the builtin error interface
func (e ListUsersRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListUsersRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListUsersRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListUsersRequestValidationError{}

var _ListUsersRequest_Order_InLookup = map[string]struct{}{
	"":                       {},
	"user_id":                {},
	"-user_id":               {},
	"name":                   {},
	"-name":                  {},
	"primary_email_address":  {},
	"-primary_email_address": {},
	"state":                  {},
	"-state":                 {},
	"admin":                  {},
	"-admin":                 {},
	"created_at":             {},
	"-created_at":            {},
}

// ValidateFields checks the field values on CreateUserRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *CreateUserRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CreateUserRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user":

			if m.GetUser() == nil {
				return CreateUserRequestValidationError{
					field:  "user",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUser()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateUserRequestValidationError{
						field:  "user",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "invitation_token":
			// no validation rules for InvitationToken
		default:
			return CreateUserRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CreateUserRequestValidationError is the validation error returned by
// CreateUserRequest.ValidateFields if the designated constraints aren't met.
type CreateUserRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateUserRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateUserRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateUserRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateUserRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateUserRequestValidationError) ErrorName() string {
	return "CreateUserRequestValidationError"
}

// Error satisfies the builtin error interface
func (e CreateUserRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateUserRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateUserRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateUserRequestValidationError{}

// ValidateFields checks the field values on UpdateUserRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UpdateUserRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UpdateUserRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user":

			if m.GetUser() == nil {
				return UpdateUserRequestValidationError{
					field:  "user",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUser()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateUserRequestValidationError{
						field:  "user",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateUserRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UpdateUserRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UpdateUserRequestValidationError is the validation error returned by
// UpdateUserRequest.ValidateFields if the designated constraints aren't met.
type UpdateUserRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpdateUserRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpdateUserRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpdateUserRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpdateUserRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpdateUserRequestValidationError) ErrorName() string {
	return "UpdateUserRequestValidationError"
}

// Error satisfies the builtin error interface
func (e UpdateUserRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpdateUserRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpdateUserRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpdateUserRequestValidationError{}

// ValidateFields checks the field values on CreateTemporaryPasswordRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *CreateTemporaryPasswordRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CreateTemporaryPasswordRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return CreateTemporaryPasswordRequestValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateTemporaryPasswordRequestValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return CreateTemporaryPasswordRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CreateTemporaryPasswordRequestValidationError is the validation error
// returned by CreateTemporaryPasswordRequest.ValidateFields if the designated
// constraints aren't met.
type CreateTemporaryPasswordRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateTemporaryPasswordRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateTemporaryPasswordRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateTemporaryPasswordRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateTemporaryPasswordRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateTemporaryPasswordRequestValidationError) ErrorName() string {
	return "CreateTemporaryPasswordRequestValidationError"
}

// Error satisfies the builtin error interface
func (e CreateTemporaryPasswordRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateTemporaryPasswordRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateTemporaryPasswordRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateTemporaryPasswordRequestValidationError{}

// ValidateFields checks the field values on UpdateUserPasswordRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UpdateUserPasswordRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UpdateUserPasswordRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return UpdateUserPasswordRequestValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateUserPasswordRequestValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "new":

			if utf8.RuneCountInString(m.GetNew()) > 1000 {
				return UpdateUserPasswordRequestValidationError{
					field:  "new",
					reason: "value length must be at most 1000 runes",
				}
			}

		case "old":

			if utf8.RuneCountInString(m.GetOld()) > 1000 {
				return UpdateUserPasswordRequestValidationError{
					field:  "old",
					reason: "value length must be at most 1000 runes",
				}
			}

		case "revoke_all_access":
			// no validation rules for RevokeAllAccess
		default:
			return UpdateUserPasswordRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UpdateUserPasswordRequestValidationError is the validation error returned by
// UpdateUserPasswordRequest.ValidateFields if the designated constraints
// aren't met.
type UpdateUserPasswordRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpdateUserPasswordRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpdateUserPasswordRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpdateUserPasswordRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpdateUserPasswordRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpdateUserPasswordRequestValidationError) ErrorName() string {
	return "UpdateUserPasswordRequestValidationError"
}

// Error satisfies the builtin error interface
func (e UpdateUserPasswordRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpdateUserPasswordRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpdateUserPasswordRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpdateUserPasswordRequestValidationError{}

// ValidateFields checks the field values on ListUserAPIKeysRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ListUserAPIKeysRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListUserAPIKeysRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return ListUserAPIKeysRequestValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListUserAPIKeysRequestValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "order":

			if _, ok := _ListUserAPIKeysRequest_Order_InLookup[m.GetOrder()]; !ok {
				return ListUserAPIKeysRequestValidationError{
					field:  "order",
					reason: "value must be in list [ api_key_id -api_key_id name -name created_at -created_at expires_at -expires_at]",
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListUserAPIKeysRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		default:
			return ListUserAPIKeysRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListUserAPIKeysRequestValidationError is the validation error returned by
// ListUserAPIKeysRequest.ValidateFields if the designated constraints aren't met.
type ListUserAPIKeysRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListUserAPIKeysRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListUserAPIKeysRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListUserAPIKeysRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListUserAPIKeysRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListUserAPIKeysRequestValidationError) ErrorName() string {
	return "ListUserAPIKeysRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListUserAPIKeysRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListUserAPIKeysRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListUserAPIKeysRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListUserAPIKeysRequestValidationError{}

var _ListUserAPIKeysRequest_Order_InLookup = map[string]struct{}{
	"":            {},
	"api_key_id":  {},
	"-api_key_id": {},
	"name":        {},
	"-name":       {},
	"created_at":  {},
	"-created_at": {},
	"expires_at":  {},
	"-expires_at": {},
}

// ValidateFields checks the field values on GetUserAPIKeyRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetUserAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetUserAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return GetUserAPIKeyRequestValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetUserAPIKeyRequestValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "key_id":
			// no validation rules for KeyId
		default:
			return GetUserAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetUserAPIKeyRequestValidationError is the validation error returned by
// GetUserAPIKeyRequest.ValidateFields if the designated constraints aren't met.
type GetUserAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetUserAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetUserAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetUserAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetUserAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetUserAPIKeyRequestValidationError) ErrorName() string {
	return "GetUserAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetUserAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetUserAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetUserAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetUserAPIKeyRequestValidationError{}

// ValidateFields checks the field values on CreateUserAPIKeyRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *CreateUserAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CreateUserAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return CreateUserAPIKeyRequestValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateUserAPIKeyRequestValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "name":

			if utf8.RuneCountInString(m.GetName()) > 50 {
				return CreateUserAPIKeyRequestValidationError{
					field:  "name",
					reason: "value length must be at most 50 runes",
				}
			}

		case "rights":

			if len(m.GetRights()) < 1 {
				return CreateUserAPIKeyRequestValidationError{
					field:  "rights",
					reason: "value must contain at least 1 item(s)",
				}
			}

			_CreateUserAPIKeyRequest_Rights_Unique := make(map[Right]struct{}, len(m.GetRights()))

			for idx, item := range m.GetRights() {
				_, _ = idx, item

				if _, exists := _CreateUserAPIKeyRequest_Rights_Unique[item]; exists {
					return CreateUserAPIKeyRequestValidationError{
						field:  fmt.Sprintf("rights[%v]", idx),
						reason: "repeated value must contain unique items",
					}
				} else {
					_CreateUserAPIKeyRequest_Rights_Unique[item] = struct{}{}
				}

				if _, ok := Right_name[int32(item)]; !ok {
					return CreateUserAPIKeyRequestValidationError{
						field:  fmt.Sprintf("rights[%v]", idx),
						reason: "value must be one of the defined enum values",
					}
				}

			}

		case "expires_at":

			if t := m.GetExpiresAt(); t != nil {
				ts, err := t.AsTime(), t.CheckValid()
				if err != nil {
					return CreateUserAPIKeyRequestValidationError{
						field:  "expires_at",
						reason: "value is not a valid timestamp",
						cause:  err,
					}
				}

				now := time.Now()

				if ts.Sub(now) <= 0 {
					return CreateUserAPIKeyRequestValidationError{
						field:  "expires_at",
						reason: "value must be greater than now",
					}
				}

			}

		default:
			return CreateUserAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CreateUserAPIKeyRequestValidationError is the validation error returned by
// CreateUserAPIKeyRequest.ValidateFields if the designated constraints aren't met.
type CreateUserAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateUserAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateUserAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateUserAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateUserAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateUserAPIKeyRequestValidationError) ErrorName() string {
	return "CreateUserAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e CreateUserAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateUserAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateUserAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateUserAPIKeyRequestValidationError{}

// ValidateFields checks the field values on UpdateUserAPIKeyRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UpdateUserAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UpdateUserAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return UpdateUserAPIKeyRequestValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateUserAPIKeyRequestValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "api_key":

			if m.GetApiKey() == nil {
				return UpdateUserAPIKeyRequestValidationError{
					field:  "api_key",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApiKey()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateUserAPIKeyRequestValidationError{
						field:  "api_key",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateUserAPIKeyRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UpdateUserAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UpdateUserAPIKeyRequestValidationError is the validation error returned by
// UpdateUserAPIKeyRequest.ValidateFields if the designated constraints aren't met.
type UpdateUserAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpdateUserAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpdateUserAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpdateUserAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpdateUserAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpdateUserAPIKeyRequestValidationError) ErrorName() string {
	return "UpdateUserAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e UpdateUserAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpdateUserAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpdateUserAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpdateUserAPIKeyRequestValidationError{}

// ValidateFields checks the field values on DeleteUserAPIKeyRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DeleteUserAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DeleteUserAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return DeleteUserAPIKeyRequestValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DeleteUserAPIKeyRequestValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "key_id":
			// no validation rules for KeyId
		default:
			return DeleteUserAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DeleteUserAPIKeyRequestValidationError is the validation error returned by
// DeleteUserAPIKeyRequest.ValidateFields if the designated constraints aren't met.
type DeleteUserAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DeleteUserAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DeleteUserAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DeleteUserAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DeleteUserAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DeleteUserAPIKeyRequestValidationError) ErrorName() string {
	return "DeleteUserAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e DeleteUserAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDeleteUserAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DeleteUserAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DeleteUserAPIKeyRequestValidationError{}

// ValidateFields checks the field values on Invitation with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *Invitation) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = InvitationFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "email":

			if err := m._validateEmail(m.GetEmail()); err != nil {
				return InvitationValidationError{
					field:  "email",
					reason: "value must be a valid email address",
					cause:  err,
				}
			}

		case "token":
			// no validation rules for Token
		case "expires_at":

			if v, ok := interface{}(m.GetExpiresAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return InvitationValidationError{
						field:  "expires_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "created_at":

			if v, ok := interface{}(m.GetCreatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return InvitationValidationError{
						field:  "created_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return InvitationValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "accepted_at":

			if v, ok := interface{}(m.GetAcceptedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return InvitationValidationError{
						field:  "accepted_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "accepted_by":

			if v, ok := interface{}(m.GetAcceptedBy()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return InvitationValidationError{
						field:  "accepted_by",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return InvitationValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

func (m *Invitation) _validateHostname(host string) error {
	s := strings.ToLower(strings.TrimSuffix(host, "."))

	if len(host) > 253 {
		return errors.New("hostname cannot exceed 253 characters")
	}

	for _, part := range strings.Split(s, ".") {
		if l := len(part); l == 0 || l > 63 {
			return errors.New("hostname part must be non-empty and cannot exceed 63 characters")
		}

		if part[0] == '-' {
			return errors.New("hostname parts cannot begin with hyphens")
		}

		if part[len(part)-1] == '-' {
			return errors.New("hostname parts cannot end with hyphens")
		}

		for _, r := range part {
			if (r < 'a' || r > 'z') && (r < '0' || r > '9') && r != '-' {
				return fmt.Errorf("hostname parts can only contain alphanumeric characters or hyphens, got %q", string(r))
			}
		}
	}

	return nil
}

func (m *Invitation) _validateEmail(addr string) error {
	a, err := mail.ParseAddress(addr)
	if err != nil {
		return err
	}
	addr = a.Address

	if len(addr) > 254 {
		return errors.New("email addresses cannot exceed 254 characters")
	}

	parts := strings.SplitN(addr, "@", 2)

	if len(parts[0]) > 64 {
		return errors.New("email address local phrase cannot exceed 64 characters")
	}

	return m._validateHostname(parts[1])
}

// InvitationValidationError is the validation error returned by
// Invitation.ValidateFields if the designated constraints aren't met.
type InvitationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e InvitationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e InvitationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e InvitationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e InvitationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e InvitationValidationError) ErrorName() string { return "InvitationValidationError" }

// Error satisfies the builtin error interface
func (e InvitationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sInvitation.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = InvitationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = InvitationValidationError{}

// ValidateFields checks the field values on ListInvitationsRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ListInvitationsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListInvitationsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "limit":

			if m.GetLimit() > 1000 {
				return ListInvitationsRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		default:
			return ListInvitationsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListInvitationsRequestValidationError is the validation error returned by
// ListInvitationsRequest.ValidateFields if the designated constraints aren't met.
type ListInvitationsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListInvitationsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListInvitationsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListInvitationsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListInvitationsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListInvitationsRequestValidationError) ErrorName() string {
	return "ListInvitationsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListInvitationsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListInvitationsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListInvitationsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListInvitationsRequestValidationError{}

// ValidateFields checks the field values on Invitations with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *Invitations) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = InvitationsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "invitations":

			for idx, item := range m.GetInvitations() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return InvitationsValidationError{
							field:  fmt.Sprintf("invitations[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return InvitationsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// InvitationsValidationError is the validation error returned by
// Invitations.ValidateFields if the designated constraints aren't met.
type InvitationsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e InvitationsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e InvitationsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e InvitationsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e InvitationsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e InvitationsValidationError) ErrorName() string { return "InvitationsValidationError" }

// Error satisfies the builtin error interface
func (e InvitationsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sInvitations.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = InvitationsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = InvitationsValidationError{}

// ValidateFields checks the field values on SendInvitationRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *SendInvitationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SendInvitationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "email":

			if err := m._validateEmail(m.GetEmail()); err != nil {
				return SendInvitationRequestValidationError{
					field:  "email",
					reason: "value must be a valid email address",
					cause:  err,
				}
			}

		default:
			return SendInvitationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

func (m *SendInvitationRequest) _validateHostname(host string) error {
	s := strings.ToLower(strings.TrimSuffix(host, "."))

	if len(host) > 253 {
		return errors.New("hostname cannot exceed 253 characters")
	}

	for _, part := range strings.Split(s, ".") {
		if l := len(part); l == 0 || l > 63 {
			return errors.New("hostname part must be non-empty and cannot exceed 63 characters")
		}

		if part[0] == '-' {
			return errors.New("hostname parts cannot begin with hyphens")
		}

		if part[len(part)-1] == '-' {
			return errors.New("hostname parts cannot end with hyphens")
		}

		for _, r := range part {
			if (r < 'a' || r > 'z') && (r < '0' || r > '9') && r != '-' {
				return fmt.Errorf("hostname parts can only contain alphanumeric characters or hyphens, got %q", string(r))
			}
		}
	}

	return nil
}

func (m *SendInvitationRequest) _validateEmail(addr string) error {
	a, err := mail.ParseAddress(addr)
	if err != nil {
		return err
	}
	addr = a.Address

	if len(addr) > 254 {
		return errors.New("email addresses cannot exceed 254 characters")
	}

	parts := strings.SplitN(addr, "@", 2)

	if len(parts[0]) > 64 {
		return errors.New("email address local phrase cannot exceed 64 characters")
	}

	return m._validateHostname(parts[1])
}

// SendInvitationRequestValidationError is the validation error returned by
// SendInvitationRequest.ValidateFields if the designated constraints aren't met.
type SendInvitationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SendInvitationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SendInvitationRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SendInvitationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SendInvitationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SendInvitationRequestValidationError) ErrorName() string {
	return "SendInvitationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SendInvitationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSendInvitationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SendInvitationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SendInvitationRequestValidationError{}

// ValidateFields checks the field values on DeleteInvitationRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DeleteInvitationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DeleteInvitationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "email":

			if err := m._validateEmail(m.GetEmail()); err != nil {
				return DeleteInvitationRequestValidationError{
					field:  "email",
					reason: "value must be a valid email address",
					cause:  err,
				}
			}

		default:
			return DeleteInvitationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

func (m *DeleteInvitationRequest) _validateHostname(host string) error {
	s := strings.ToLower(strings.TrimSuffix(host, "."))

	if len(host) > 253 {
		return errors.New("hostname cannot exceed 253 characters")
	}

	for _, part := range strings.Split(s, ".") {
		if l := len(part); l == 0 || l > 63 {
			return errors.New("hostname part must be non-empty and cannot exceed 63 characters")
		}

		if part[0] == '-' {
			return errors.New("hostname parts cannot begin with hyphens")
		}

		if part[len(part)-1] == '-' {
			return errors.New("hostname parts cannot end with hyphens")
		}

		for _, r := range part {
			if (r < 'a' || r > 'z') && (r < '0' || r > '9') && r != '-' {
				return fmt.Errorf("hostname parts can only contain alphanumeric characters or hyphens, got %q", string(r))
			}
		}
	}

	return nil
}

func (m *DeleteInvitationRequest) _validateEmail(addr string) error {
	a, err := mail.ParseAddress(addr)
	if err != nil {
		return err
	}
	addr = a.Address

	if len(addr) > 254 {
		return errors.New("email addresses cannot exceed 254 characters")
	}

	parts := strings.SplitN(addr, "@", 2)

	if len(parts[0]) > 64 {
		return errors.New("email address local phrase cannot exceed 64 characters")
	}

	return m._validateHostname(parts[1])
}

// DeleteInvitationRequestValidationError is the validation error returned by
// DeleteInvitationRequest.ValidateFields if the designated constraints aren't met.
type DeleteInvitationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DeleteInvitationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DeleteInvitationRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DeleteInvitationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DeleteInvitationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DeleteInvitationRequestValidationError) ErrorName() string {
	return "DeleteInvitationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e DeleteInvitationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDeleteInvitationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DeleteInvitationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DeleteInvitationRequestValidationError{}

// ValidateFields checks the field values on UserSessionIdentifiers with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UserSessionIdentifiers) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UserSessionIdentifiersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return UserSessionIdentifiersValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserSessionIdentifiersValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "session_id":

			if utf8.RuneCountInString(m.GetSessionId()) > 64 {
				return UserSessionIdentifiersValidationError{
					field:  "session_id",
					reason: "value length must be at most 64 runes",
				}
			}

		default:
			return UserSessionIdentifiersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UserSessionIdentifiersValidationError is the validation error returned by
// UserSessionIdentifiers.ValidateFields if the designated constraints aren't met.
type UserSessionIdentifiersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserSessionIdentifiersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserSessionIdentifiersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserSessionIdentifiersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserSessionIdentifiersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserSessionIdentifiersValidationError) ErrorName() string {
	return "UserSessionIdentifiersValidationError"
}

// Error satisfies the builtin error interface
func (e UserSessionIdentifiersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserSessionIdentifiers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserSessionIdentifiersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserSessionIdentifiersValidationError{}

// ValidateFields checks the field values on UserSession with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *UserSession) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UserSessionFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return UserSessionValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserSessionValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "session_id":

			if utf8.RuneCountInString(m.GetSessionId()) > 64 {
				return UserSessionValidationError{
					field:  "session_id",
					reason: "value length must be at most 64 runes",
				}
			}

		case "created_at":

			if v, ok := interface{}(m.GetCreatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserSessionValidationError{
						field:  "created_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserSessionValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "expires_at":

			if v, ok := interface{}(m.GetExpiresAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserSessionValidationError{
						field:  "expires_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "session_secret":
			// no validation rules for SessionSecret
		default:
			return UserSessionValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UserSessionValidationError is the validation error returned by
// UserSession.ValidateFields if the designated constraints aren't met.
type UserSessionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserSessionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserSessionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserSessionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserSessionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserSessionValidationError) ErrorName() string { return "UserSessionValidationError" }

// Error satisfies the builtin error interface
func (e UserSessionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserSession.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserSessionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserSessionValidationError{}

// ValidateFields checks the field values on UserSessions with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UserSessions) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UserSessionsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "sessions":

			for idx, item := range m.GetSessions() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return UserSessionsValidationError{
							field:  fmt.Sprintf("sessions[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return UserSessionsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UserSessionsValidationError is the validation error returned by
// UserSessions.ValidateFields if the designated constraints aren't met.
type UserSessionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserSessionsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserSessionsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserSessionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserSessionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserSessionsValidationError) ErrorName() string { return "UserSessionsValidationError" }

// Error satisfies the builtin error interface
func (e UserSessionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserSessions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserSessionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserSessionsValidationError{}

// ValidateFields checks the field values on ListUserSessionsRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ListUserSessionsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListUserSessionsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return ListUserSessionsRequestValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListUserSessionsRequestValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "order":

			if _, ok := _ListUserSessionsRequest_Order_InLookup[m.GetOrder()]; !ok {
				return ListUserSessionsRequestValidationError{
					field:  "order",
					reason: "value must be in list [ created_at -created_at]",
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListUserSessionsRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		default:
			return ListUserSessionsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListUserSessionsRequestValidationError is the validation error returned by
// ListUserSessionsRequest.ValidateFields if the designated constraints aren't met.
type ListUserSessionsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListUserSessionsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListUserSessionsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListUserSessionsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListUserSessionsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListUserSessionsRequestValidationError) ErrorName() string {
	return "ListUserSessionsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListUserSessionsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListUserSessionsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListUserSessionsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListUserSessionsRequestValidationError{}

var _ListUserSessionsRequest_Order_InLookup = map[string]struct{}{
	"":            {},
	"created_at":  {},
	"-created_at": {},
}

// ValidateFields checks the field values on LoginToken with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *LoginToken) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = LoginTokenFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return LoginTokenValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return LoginTokenValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "created_at":

			if v, ok := interface{}(m.GetCreatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return LoginTokenValidationError{
						field:  "created_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return LoginTokenValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "expires_at":

			if v, ok := interface{}(m.GetExpiresAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return LoginTokenValidationError{
						field:  "expires_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "token":
			// no validation rules for Token
		case "used":
			// no validation rules for Used
		default:
			return LoginTokenValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// LoginTokenValidationError is the validation error returned by
// LoginToken.ValidateFields if the designated constraints aren't met.
type LoginTokenValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LoginTokenValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LoginTokenValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LoginTokenValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LoginTokenValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LoginTokenValidationError) ErrorName() string { return "LoginTokenValidationError" }

// Error satisfies the builtin error interface
func (e LoginTokenValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLoginToken.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LoginTokenValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LoginTokenValidationError{}

// ValidateFields checks the field values on CreateLoginTokenRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *CreateLoginTokenRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CreateLoginTokenRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return CreateLoginTokenRequestValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateLoginTokenRequestValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "skip_email":
			// no validation rules for SkipEmail
		default:
			return CreateLoginTokenRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CreateLoginTokenRequestValidationError is the validation error returned by
// CreateLoginTokenRequest.ValidateFields if the designated constraints aren't met.
type CreateLoginTokenRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateLoginTokenRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateLoginTokenRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateLoginTokenRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateLoginTokenRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateLoginTokenRequestValidationError) ErrorName() string {
	return "CreateLoginTokenRequestValidationError"
}

// Error satisfies the builtin error interface
func (e CreateLoginTokenRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateLoginTokenRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateLoginTokenRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateLoginTokenRequestValidationError{}

// ValidateFields checks the field values on CreateLoginTokenResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *CreateLoginTokenResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CreateLoginTokenResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "token":
			// no validation rules for Token
		default:
			return CreateLoginTokenResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CreateLoginTokenResponseValidationError is the validation error returned by
// CreateLoginTokenResponse.ValidateFields if the designated constraints
// aren't met.
type CreateLoginTokenResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateLoginTokenResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateLoginTokenResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateLoginTokenResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateLoginTokenResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateLoginTokenResponseValidationError) ErrorName() string {
	return "CreateLoginTokenResponseValidationError"
}

// Error satisfies the builtin error interface
func (e CreateLoginTokenResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateLoginTokenResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateLoginTokenResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateLoginTokenResponseValidationError{}

// ValidateFields checks the field values on UserBookmark with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UserBookmark) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UserBookmarkFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return UserBookmarkValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserBookmarkValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "entity_ids":

			if m.GetEntityIds() == nil {
				return UserBookmarkValidationError{
					field:  "entity_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEntityIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserBookmarkValidationError{
						field:  "entity_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "created_at":

			if v, ok := interface{}(m.GetCreatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UserBookmarkValidationError{
						field:  "created_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UserBookmarkValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UserBookmarkValidationError is the validation error returned by
// UserBookmark.ValidateFields if the designated constraints aren't met.
type UserBookmarkValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserBookmarkValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserBookmarkValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserBookmarkValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserBookmarkValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserBookmarkValidationError) ErrorName() string { return "UserBookmarkValidationError" }

// Error satisfies the builtin error interface
func (e UserBookmarkValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserBookmark.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserBookmarkValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserBookmarkValidationError{}

// ValidateFields checks the field values on UserBookmarks with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UserBookmarks) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UserBookmarksFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "bookmarks":

			for idx, item := range m.GetBookmarks() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return UserBookmarksValidationError{
							field:  fmt.Sprintf("bookmarks[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return UserBookmarksValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UserBookmarksValidationError is the validation error returned by
// UserBookmarks.ValidateFields if the designated constraints aren't met.
type UserBookmarksValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserBookmarksValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserBookmarksValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserBookmarksValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserBookmarksValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserBookmarksValidationError) ErrorName() string { return "UserBookmarksValidationError" }

// Error satisfies the builtin error interface
func (e UserBookmarksValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserBookmarks.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserBookmarksValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserBookmarksValidationError{}

// ValidateFields checks the field values on CreateUserBookmarkRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *CreateUserBookmarkRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CreateUserBookmarkRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return CreateUserBookmarkRequestValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateUserBookmarkRequestValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "entity_ids":

			if m.GetEntityIds() == nil {
				return CreateUserBookmarkRequestValidationError{
					field:  "entity_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEntityIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateUserBookmarkRequestValidationError{
						field:  "entity_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return CreateUserBookmarkRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CreateUserBookmarkRequestValidationError is the validation error returned by
// CreateUserBookmarkRequest.ValidateFields if the designated constraints
// aren't met.
type CreateUserBookmarkRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateUserBookmarkRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateUserBookmarkRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateUserBookmarkRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateUserBookmarkRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateUserBookmarkRequestValidationError) ErrorName() string {
	return "CreateUserBookmarkRequestValidationError"
}

// Error satisfies the builtin error interface
func (e CreateUserBookmarkRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateUserBookmarkRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateUserBookmarkRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateUserBookmarkRequestValidationError{}

// ValidateFields checks the field values on ListUserBookmarksRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ListUserBookmarksRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListUserBookmarksRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return ListUserBookmarksRequestValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListUserBookmarksRequestValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListUserBookmarksRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "order":

			if _, ok := _ListUserBookmarksRequest_Order_InLookup[m.GetOrder()]; !ok {
				return ListUserBookmarksRequestValidationError{
					field:  "order",
					reason: "value must be in list [ user_id -user_id entity_type -entity_type entity_id -entity_id created_at -created_at]",
				}
			}

		case "deleted":
			// no validation rules for Deleted
		case "entity_types":

			_ListUserBookmarksRequest_EntityTypes_Unique := make(map[string]struct{}, len(m.GetEntityTypes()))

			for idx, item := range m.GetEntityTypes() {
				_, _ = idx, item

				if _, exists := _ListUserBookmarksRequest_EntityTypes_Unique[item]; exists {
					return ListUserBookmarksRequestValidationError{
						field:  fmt.Sprintf("entity_types[%v]", idx),
						reason: "repeated value must contain unique items",
					}
				} else {
					_ListUserBookmarksRequest_EntityTypes_Unique[item] = struct{}{}
				}

				if _, ok := _ListUserBookmarksRequest_EntityTypes_InLookup[item]; !ok {
					return ListUserBookmarksRequestValidationError{
						field:  fmt.Sprintf("entity_types[%v]", idx),
						reason: "value must be in list [application client end device gateway organization user]",
					}
				}

			}

		default:
			return ListUserBookmarksRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListUserBookmarksRequestValidationError is the validation error returned by
// ListUserBookmarksRequest.ValidateFields if the designated constraints
// aren't met.
type ListUserBookmarksRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListUserBookmarksRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListUserBookmarksRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListUserBookmarksRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListUserBookmarksRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListUserBookmarksRequestValidationError) ErrorName() string {
	return "ListUserBookmarksRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListUserBookmarksRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListUserBookmarksRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListUserBookmarksRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListUserBookmarksRequestValidationError{}

var _ListUserBookmarksRequest_Order_InLookup = map[string]struct{}{
	"":             {},
	"user_id":      {},
	"-user_id":     {},
	"entity_type":  {},
	"-entity_type": {},
	"entity_id":    {},
	"-entity_id":   {},
	"created_at":   {},
	"-created_at":  {},
}

var _ListUserBookmarksRequest_EntityTypes_InLookup = map[string]struct{}{
	"application":  {},
	"client":       {},
	"end device":   {},
	"gateway":      {},
	"organization": {},
	"user":         {},
}

// ValidateFields checks the field values on DeleteUserBookmarkRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DeleteUserBookmarkRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DeleteUserBookmarkRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return DeleteUserBookmarkRequestValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DeleteUserBookmarkRequestValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "entity_ids":

			if m.GetEntityIds() == nil {
				return DeleteUserBookmarkRequestValidationError{
					field:  "entity_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEntityIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DeleteUserBookmarkRequestValidationError{
						field:  "entity_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return DeleteUserBookmarkRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DeleteUserBookmarkRequestValidationError is the validation error returned by
// DeleteUserBookmarkRequest.ValidateFields if the designated constraints
// aren't met.
type DeleteUserBookmarkRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DeleteUserBookmarkRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DeleteUserBookmarkRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DeleteUserBookmarkRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DeleteUserBookmarkRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DeleteUserBookmarkRequestValidationError) ErrorName() string {
	return "DeleteUserBookmarkRequestValidationError"
}

// Error satisfies the builtin error interface
func (e DeleteUserBookmarkRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDeleteUserBookmarkRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DeleteUserBookmarkRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DeleteUserBookmarkRequestValidationError{}

// ValidateFields checks the field values on BatchDeleteUserBookmarksRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *BatchDeleteUserBookmarksRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BatchDeleteUserBookmarksRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "user_ids":

			if m.GetUserIds() == nil {
				return BatchDeleteUserBookmarksRequestValidationError{
					field:  "user_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUserIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BatchDeleteUserBookmarksRequestValidationError{
						field:  "user_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "entity_ids":

			if l := len(m.GetEntityIds()); l < 1 || l > 20 {
				return BatchDeleteUserBookmarksRequestValidationError{
					field:  "entity_ids",
					reason: "value must contain between 1 and 20 items, inclusive",
				}
			}

			for idx, item := range m.GetEntityIds() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return BatchDeleteUserBookmarksRequestValidationError{
							field:  fmt.Sprintf("entity_ids[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return BatchDeleteUserBookmarksRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BatchDeleteUserBookmarksRequestValidationError is the validation error
// returned by BatchDeleteUserBookmarksRequest.ValidateFields if the
// designated constraints aren't met.
type BatchDeleteUserBookmarksRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BatchDeleteUserBookmarksRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BatchDeleteUserBookmarksRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BatchDeleteUserBookmarksRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BatchDeleteUserBookmarksRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BatchDeleteUserBookmarksRequestValidationError) ErrorName() string {
	return "BatchDeleteUserBookmarksRequestValidationError"
}

// Error satisfies the builtin error interface
func (e BatchDeleteUserBookmarksRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBatchDeleteUserBookmarksRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BatchDeleteUserBookmarksRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BatchDeleteUserBookmarksRequestValidationError{}

// ValidateFields checks the field values on
// UserConsolePreferences_DashboardLayouts with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *UserConsolePreferences_DashboardLayouts) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UserConsolePreferences_DashboardLayoutsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "api_key":
			// no validation rules for ApiKey
		case "application":
			// no validation rules for Application
		case "collaborator":
			// no validation rules for Collaborator
		case "end_device":
			// no validation rules for EndDevice
		case "gateway":
			// no validation rules for Gateway
		case "organization":
			// no validation rules for Organization
		case "overview":
			// no validation rules for Overview
		case "user":
			// no validation rules for User
		default:
			return UserConsolePreferences_DashboardLayoutsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UserConsolePreferences_DashboardLayoutsValidationError is the validation
// error returned by UserConsolePreferences_DashboardLayouts.ValidateFields if
// the designated constraints aren't met.
type UserConsolePreferences_DashboardLayoutsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserConsolePreferences_DashboardLayoutsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserConsolePreferences_DashboardLayoutsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserConsolePreferences_DashboardLayoutsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserConsolePreferences_DashboardLayoutsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserConsolePreferences_DashboardLayoutsValidationError) ErrorName() string {
	return "UserConsolePreferences_DashboardLayoutsValidationError"
}

// Error satisfies the builtin error interface
func (e UserConsolePreferences_DashboardLayoutsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserConsolePreferences_DashboardLayouts.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserConsolePreferences_DashboardLayoutsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserConsolePreferences_DashboardLayoutsValidationError{}

// ValidateFields checks the field values on UserConsolePreferences_SortBy with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *UserConsolePreferences_SortBy) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UserConsolePreferences_SortByFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "api_key":

			if _, ok := _UserConsolePreferences_SortBy_ApiKey_InLookup[m.GetApiKey()]; !ok {
				return UserConsolePreferences_SortByValidationError{
					field:  "api_key",
					reason: "value must be in list [ api_key_id -api_key_id name -name created_at -created_at expires_at -expires_at]",
				}
			}

		case "application":

			if _, ok := _UserConsolePreferences_SortBy_Application_InLookup[m.GetApplication()]; !ok {
				return UserConsolePreferences_SortByValidationError{
					field:  "application",
					reason: "value must be in list [ application_id -application_id name -name created_at -created_at]",
				}
			}

		case "collaborator":

			if _, ok := _UserConsolePreferences_SortBy_Collaborator_InLookup[m.GetCollaborator()]; !ok {
				return UserConsolePreferences_SortByValidationError{
					field:  "collaborator",
					reason: "value must be in list [ id -id rights -rights]",
				}
			}

		case "end_device":

			if _, ok := _UserConsolePreferences_SortBy_EndDevice_InLookup[m.GetEndDevice()]; !ok {
				return UserConsolePreferences_SortByValidationError{
					field:  "end_device",
					reason: "value must be in list [ device_id -device_id join_eui -join_eui dev_eui -dev_eui name -name description -description created_at -created_at last_seen_at -last_seen_at]",
				}
			}

		case "gateway":

			if _, ok := _UserConsolePreferences_SortBy_Gateway_InLookup[m.GetGateway()]; !ok {
				return UserConsolePreferences_SortByValidationError{
					field:  "gateway",
					reason: "value must be in list [ gateway_id -gateway_id gateway_eui -gateway_eui name -name created_at -created_at]",
				}
			}

		case "organization":

			if _, ok := _UserConsolePreferences_SortBy_Organization_InLookup[m.GetOrganization()]; !ok {
				return UserConsolePreferences_SortByValidationError{
					field:  "organization",
					reason: "value must be in list [ organization_id -organization_id name -name created_at -created_at]",
				}
			}

		case "user":

			if _, ok := _UserConsolePreferences_SortBy_User_InLookup[m.GetUser()]; !ok {
				return UserConsolePreferences_SortByValidationError{
					field:  "user",
					reason: "value must be in list [ user_id -user_id name -name primary_email_address -primary_email_address state -state admin -admin created_at -created_at]",
				}
			}

		default:
			return UserConsolePreferences_SortByValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UserConsolePreferences_SortByValidationError is the validation error
// returned by UserConsolePreferences_SortBy.ValidateFields if the designated
// constraints aren't met.
type UserConsolePreferences_SortByValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserConsolePreferences_SortByValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserConsolePreferences_SortByValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserConsolePreferences_SortByValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserConsolePreferences_SortByValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserConsolePreferences_SortByValidationError) ErrorName() string {
	return "UserConsolePreferences_SortByValidationError"
}

// Error satisfies the builtin error interface
func (e UserConsolePreferences_SortByValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserConsolePreferences_SortBy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserConsolePreferences_SortByValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserConsolePreferences_SortByValidationError{}

var _UserConsolePreferences_SortBy_ApiKey_InLookup = map[string]struct{}{
	"":            {},
	"api_key_id":  {},
	"-api_key_id": {},
	"name":        {},
	"-name":       {},
	"created_at":  {},
	"-created_at": {},
	"expires_at":  {},
	"-expires_at": {},
}

var _UserConsolePreferences_SortBy_Application_InLookup = map[string]struct{}{
	"":                {},
	"application_id":  {},
	"-application_id": {},
	"name":            {},
	"-name":           {},
	"created_at":      {},
	"-created_at":     {},
}

var _UserConsolePreferences_SortBy_Collaborator_InLookup = map[string]struct{}{
	"":        {},
	"id":      {},
	"-id":     {},
	"rights":  {},
	"-rights": {},
}

var _UserConsolePreferences_SortBy_EndDevice_InLookup = map[string]struct{}{
	"":              {},
	"device_id":     {},
	"-device_id":    {},
	"join_eui":      {},
	"-join_eui":     {},
	"dev_eui":       {},
	"-dev_eui":      {},
	"name":          {},
	"-name":         {},
	"description":   {},
	"-description":  {},
	"created_at":    {},
	"-created_at":   {},
	"last_seen_at":  {},
	"-last_seen_at": {},
}

var _UserConsolePreferences_SortBy_Gateway_InLookup = map[string]struct{}{
	"":             {},
	"gateway_id":   {},
	"-gateway_id":  {},
	"gateway_eui":  {},
	"-gateway_eui": {},
	"name":         {},
	"-name":        {},
	"created_at":   {},
	"-created_at":  {},
}

var _UserConsolePreferences_SortBy_Organization_InLookup = map[string]struct{}{
	"":                 {},
	"organization_id":  {},
	"-organization_id": {},
	"name":             {},
	"-name":            {},
	"created_at":       {},
	"-created_at":      {},
}

var _UserConsolePreferences_SortBy_User_InLookup = map[string]struct{}{
	"":                       {},
	"user_id":                {},
	"-user_id":               {},
	"name":                   {},
	"-name":                  {},
	"primary_email_address":  {},
	"-primary_email_address": {},
	"state":                  {},
	"-state":                 {},
	"admin":                  {},
	"-admin":                 {},
	"created_at":             {},
	"-created_at":            {},
}

// ValidateFields checks the field values on UserConsolePreferences_Tutorials
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *UserConsolePreferences_Tutorials) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UserConsolePreferences_TutorialsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "seen":

			_UserConsolePreferences_Tutorials_Seen_Unique := make(map[Tutorial]struct{}, len(m.GetSeen()))

			for idx, item := range m.GetSeen() {
				_, _ = idx, item

				if _, exists := _UserConsolePreferences_Tutorials_Seen_Unique[item]; exists {
					return UserConsolePreferences_TutorialsValidationError{
						field:  fmt.Sprintf("seen[%v]", idx),
						reason: "repeated value must contain unique items",
					}
				} else {
					_UserConsolePreferences_Tutorials_Seen_Unique[item] = struct{}{}
				}

				if _, ok := Tutorial_name[int32(item)]; !ok {
					return UserConsolePreferences_TutorialsValidationError{
						field:  fmt.Sprintf("seen[%v]", idx),
						reason: "value must be one of the defined enum values",
					}
				}

			}

		default:
			return UserConsolePreferences_TutorialsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UserConsolePreferences_TutorialsValidationError is the validation error
// returned by UserConsolePreferences_Tutorials.ValidateFields if the
// designated constraints aren't met.
type UserConsolePreferences_TutorialsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserConsolePreferences_TutorialsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserConsolePreferences_TutorialsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserConsolePreferences_TutorialsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserConsolePreferences_TutorialsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserConsolePreferences_TutorialsValidationError) ErrorName() string {
	return "UserConsolePreferences_TutorialsValidationError"
}

// Error satisfies the builtin error interface
func (e UserConsolePreferences_TutorialsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserConsolePreferences_Tutorials.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserConsolePreferences_TutorialsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserConsolePreferences_TutorialsValidationError{}
