// Copyright © 2022 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/simulate.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SimulateMetadataParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Rssi              float32                `protobuf:"fixed32,1,opt,name=rssi,proto3" json:"rssi,omitempty"`
	Snr               float32                `protobuf:"fixed32,2,opt,name=snr,proto3" json:"snr,omitempty"`
	Timestamp         uint32                 `protobuf:"varint,3,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Time              *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=time,proto3" json:"time,omitempty"`
	LorawanVersion    MACVersion             `protobuf:"varint,5,opt,name=lorawan_version,json=lorawanVersion,proto3,enum=ttn.lorawan.v3.MACVersion" json:"lorawan_version,omitempty"`
	LorawanPhyVersion PHYVersion             `protobuf:"varint,6,opt,name=lorawan_phy_version,json=lorawanPhyVersion,proto3,enum=ttn.lorawan.v3.PHYVersion" json:"lorawan_phy_version,omitempty"`
	BandId            string                 `protobuf:"bytes,7,opt,name=band_id,json=bandId,proto3" json:"band_id,omitempty"`
	Frequency         uint64                 `protobuf:"varint,8,opt,name=frequency,proto3" json:"frequency,omitempty"`
	ChannelIndex      uint32                 `protobuf:"varint,9,opt,name=channel_index,json=channelIndex,proto3" json:"channel_index,omitempty"`
	Bandwidth         uint32                 `protobuf:"varint,10,opt,name=bandwidth,proto3" json:"bandwidth,omitempty"`
	SpreadingFactor   uint32                 `protobuf:"varint,11,opt,name=spreading_factor,json=spreadingFactor,proto3" json:"spreading_factor,omitempty"`
	DataRateIndex     uint32                 `protobuf:"varint,12,opt,name=data_rate_index,json=dataRateIndex,proto3" json:"data_rate_index,omitempty"`
}

func (x *SimulateMetadataParams) Reset() {
	*x = SimulateMetadataParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_simulate_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulateMetadataParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulateMetadataParams) ProtoMessage() {}

func (x *SimulateMetadataParams) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_simulate_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulateMetadataParams.ProtoReflect.Descriptor instead.
func (*SimulateMetadataParams) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_simulate_proto_rawDescGZIP(), []int{0}
}

func (x *SimulateMetadataParams) GetRssi() float32 {
	if x != nil {
		return x.Rssi
	}
	return 0
}

func (x *SimulateMetadataParams) GetSnr() float32 {
	if x != nil {
		return x.Snr
	}
	return 0
}

func (x *SimulateMetadataParams) GetTimestamp() uint32 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *SimulateMetadataParams) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *SimulateMetadataParams) GetLorawanVersion() MACVersion {
	if x != nil {
		return x.LorawanVersion
	}
	return MACVersion_MAC_UNKNOWN
}

func (x *SimulateMetadataParams) GetLorawanPhyVersion() PHYVersion {
	if x != nil {
		return x.LorawanPhyVersion
	}
	return PHYVersion_PHY_UNKNOWN
}

func (x *SimulateMetadataParams) GetBandId() string {
	if x != nil {
		return x.BandId
	}
	return ""
}

func (x *SimulateMetadataParams) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *SimulateMetadataParams) GetChannelIndex() uint32 {
	if x != nil {
		return x.ChannelIndex
	}
	return 0
}

func (x *SimulateMetadataParams) GetBandwidth() uint32 {
	if x != nil {
		return x.Bandwidth
	}
	return 0
}

func (x *SimulateMetadataParams) GetSpreadingFactor() uint32 {
	if x != nil {
		return x.SpreadingFactor
	}
	return 0
}

func (x *SimulateMetadataParams) GetDataRateIndex() uint32 {
	if x != nil {
		return x.DataRateIndex
	}
	return 0
}

type SimulateJoinRequestParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JoinEui  []byte `protobuf:"bytes,1,opt,name=join_eui,json=joinEui,proto3" json:"join_eui,omitempty"`
	DevEui   []byte `protobuf:"bytes,2,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	DevNonce []byte `protobuf:"bytes,3,opt,name=dev_nonce,json=devNonce,proto3" json:"dev_nonce,omitempty"`
	AppKey   []byte `protobuf:"bytes,4,opt,name=app_key,json=appKey,proto3" json:"app_key,omitempty"`
	NwkKey   []byte `protobuf:"bytes,5,opt,name=nwk_key,json=nwkKey,proto3" json:"nwk_key,omitempty"`
}

func (x *SimulateJoinRequestParams) Reset() {
	*x = SimulateJoinRequestParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_simulate_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulateJoinRequestParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulateJoinRequestParams) ProtoMessage() {}

func (x *SimulateJoinRequestParams) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_simulate_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulateJoinRequestParams.ProtoReflect.Descriptor instead.
func (*SimulateJoinRequestParams) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_simulate_proto_rawDescGZIP(), []int{1}
}

func (x *SimulateJoinRequestParams) GetJoinEui() []byte {
	if x != nil {
		return x.JoinEui
	}
	return nil
}

func (x *SimulateJoinRequestParams) GetDevEui() []byte {
	if x != nil {
		return x.DevEui
	}
	return nil
}

func (x *SimulateJoinRequestParams) GetDevNonce() []byte {
	if x != nil {
		return x.DevNonce
	}
	return nil
}

func (x *SimulateJoinRequestParams) GetAppKey() []byte {
	if x != nil {
		return x.AppKey
	}
	return nil
}

func (x *SimulateJoinRequestParams) GetNwkKey() []byte {
	if x != nil {
		return x.NwkKey
	}
	return nil
}

type SimulateDataUplinkParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DevAddr     []byte `protobuf:"bytes,1,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	FNwkSIntKey []byte `protobuf:"bytes,2,opt,name=f_nwk_s_int_key,json=fNwkSIntKey,proto3" json:"f_nwk_s_int_key,omitempty"`
	SNwkSIntKey []byte `protobuf:"bytes,3,opt,name=s_nwk_s_int_key,json=sNwkSIntKey,proto3" json:"s_nwk_s_int_key,omitempty"`
	NwkSEncKey  []byte `protobuf:"bytes,4,opt,name=nwk_s_enc_key,json=nwkSEncKey,proto3" json:"nwk_s_enc_key,omitempty"`
	AppSKey     []byte `protobuf:"bytes,5,opt,name=app_s_key,json=appSKey,proto3" json:"app_s_key,omitempty"`
	Adr         bool   `protobuf:"varint,6,opt,name=adr,proto3" json:"adr,omitempty"`
	AdrAckReq   bool   `protobuf:"varint,7,opt,name=adr_ack_req,json=adrAckReq,proto3" json:"adr_ack_req,omitempty"`
	Confirmed   bool   `protobuf:"varint,8,opt,name=confirmed,proto3" json:"confirmed,omitempty"`
	Ack         bool   `protobuf:"varint,9,opt,name=ack,proto3" json:"ack,omitempty"`
	FCnt        uint32 `protobuf:"varint,10,opt,name=f_cnt,json=fCnt,proto3" json:"f_cnt,omitempty"`
	FPort       uint32 `protobuf:"varint,11,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	FrmPayload  []byte `protobuf:"bytes,12,opt,name=frm_payload,json=frmPayload,proto3" json:"frm_payload,omitempty"`
	ConfFCnt    uint32 `protobuf:"varint,13,opt,name=conf_f_cnt,json=confFCnt,proto3" json:"conf_f_cnt,omitempty"`
	TxDrIdx     uint32 `protobuf:"varint,14,opt,name=tx_dr_idx,json=txDrIdx,proto3" json:"tx_dr_idx,omitempty"`
	TxChIdx     uint32 `protobuf:"varint,15,opt,name=tx_ch_idx,json=txChIdx,proto3" json:"tx_ch_idx,omitempty"`
	FOpts       []byte `protobuf:"bytes,16,opt,name=f_opts,json=fOpts,proto3" json:"f_opts,omitempty"`
}

func (x *SimulateDataUplinkParams) Reset() {
	*x = SimulateDataUplinkParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_simulate_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulateDataUplinkParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulateDataUplinkParams) ProtoMessage() {}

func (x *SimulateDataUplinkParams) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_simulate_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulateDataUplinkParams.ProtoReflect.Descriptor instead.
func (*SimulateDataUplinkParams) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_simulate_proto_rawDescGZIP(), []int{2}
}

func (x *SimulateDataUplinkParams) GetDevAddr() []byte {
	if x != nil {
		return x.DevAddr
	}
	return nil
}

func (x *SimulateDataUplinkParams) GetFNwkSIntKey() []byte {
	if x != nil {
		return x.FNwkSIntKey
	}
	return nil
}

func (x *SimulateDataUplinkParams) GetSNwkSIntKey() []byte {
	if x != nil {
		return x.SNwkSIntKey
	}
	return nil
}

func (x *SimulateDataUplinkParams) GetNwkSEncKey() []byte {
	if x != nil {
		return x.NwkSEncKey
	}
	return nil
}

func (x *SimulateDataUplinkParams) GetAppSKey() []byte {
	if x != nil {
		return x.AppSKey
	}
	return nil
}

func (x *SimulateDataUplinkParams) GetAdr() bool {
	if x != nil {
		return x.Adr
	}
	return false
}

func (x *SimulateDataUplinkParams) GetAdrAckReq() bool {
	if x != nil {
		return x.AdrAckReq
	}
	return false
}

func (x *SimulateDataUplinkParams) GetConfirmed() bool {
	if x != nil {
		return x.Confirmed
	}
	return false
}

func (x *SimulateDataUplinkParams) GetAck() bool {
	if x != nil {
		return x.Ack
	}
	return false
}

func (x *SimulateDataUplinkParams) GetFCnt() uint32 {
	if x != nil {
		return x.FCnt
	}
	return 0
}

func (x *SimulateDataUplinkParams) GetFPort() uint32 {
	if x != nil {
		return x.FPort
	}
	return 0
}

func (x *SimulateDataUplinkParams) GetFrmPayload() []byte {
	if x != nil {
		return x.FrmPayload
	}
	return nil
}

func (x *SimulateDataUplinkParams) GetConfFCnt() uint32 {
	if x != nil {
		return x.ConfFCnt
	}
	return 0
}

func (x *SimulateDataUplinkParams) GetTxDrIdx() uint32 {
	if x != nil {
		return x.TxDrIdx
	}
	return 0
}

func (x *SimulateDataUplinkParams) GetTxChIdx() uint32 {
	if x != nil {
		return x.TxChIdx
	}
	return 0
}

func (x *SimulateDataUplinkParams) GetFOpts() []byte {
	if x != nil {
		return x.FOpts
	}
	return nil
}

var File_ttn_lorawan_v3_simulate_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_simulate_proto_rawDesc = []byte{
	0x0a, 0x1d, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x0e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65,
	0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x21, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67,
	0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x6a,
	0x73, 0x6f, 0x6e, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf4, 0x03, 0x0a,
	0x16, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x73, 0x73, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04, 0x72, 0x73, 0x73, 0x69, 0x12, 0x10, 0x0a, 0x03, 0x73,
	0x6e, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x03, 0x73, 0x6e, 0x72, 0x12, 0x1c, 0x0a,
	0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x2e, 0x0a, 0x04, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x0f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x0e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x4a, 0x0a, 0x13, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x5f, 0x70, 0x68, 0x79, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50,
	0x48, 0x59, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x50, 0x68, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x07,
	0x62, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62,
	0x61, 0x6e, 0x64, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1c, 0x0a, 0x09, 0x62, 0x61, 0x6e, 0x64,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x62, 0x61, 0x6e,
	0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x70, 0x72, 0x65, 0x61, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0f, 0x73, 0x70, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x74, 0x6f,
	0x72, 0x12, 0x26, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08,
	0x01, 0x10, 0x01, 0x22, 0x91, 0x0f, 0x0a, 0x19, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65,
	0x4a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x12, 0xf5, 0x02, 0x0a, 0x08, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x42, 0xd9, 0x02, 0x92, 0x41, 0x21, 0x4a, 0x12, 0x22, 0x37, 0x30, 0x42,
	0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30, 0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02,
	0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04,
	0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68,
	0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33,
	0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68,
	0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76,
	0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61,
	0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01,
	0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d,
	0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61,
	0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67,
	0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d,
	0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61,
	0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x52, 0x07, 0x6a, 0x6f, 0x69, 0x6e, 0x45, 0x75, 0x69, 0x12, 0xf3, 0x02, 0x0a, 0x07, 0x64, 0x65,
	0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xd9, 0x02, 0x92, 0x41,
	0x21, 0x4a, 0x12, 0x22, 0x37, 0x30, 0x42, 0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30,
	0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01,
	0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74,
	0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63,
	0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x38, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63,
	0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61,
	0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69, 0x12,
	0xeb, 0x02, 0x0a, 0x09, 0x64, 0x65, 0x76, 0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x42, 0xcd, 0x02, 0x92, 0x41, 0x15, 0x4a, 0x06, 0x22, 0x41, 0x42, 0x43, 0x44,
	0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42,
	0x06, 0x7a, 0x04, 0x68, 0x02, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f,
	0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61,
	0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67,
	0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55,
	0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x32, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa,
	0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74,
	0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x32, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46,
	0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74,
	0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63, 0x74, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x52, 0x08, 0x64, 0x65, 0x76, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x85, 0x03,
	0x0a, 0x07, 0x61, 0x70, 0x70, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x42,
	0xeb, 0x02, 0x92, 0x41, 0x31, 0x4a, 0x22, 0x22, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x10, 0x70, 0x01, 0xea,
	0xaa, 0x19, 0x83, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x40, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c,
	0x31, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa1, 0x01, 0x1a, 0x4f, 0x67, 0x6f,
	0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63,
	0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e,
	0x65, 0x77, 0x31, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67,
	0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d,
	0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e,
	0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x06, 0x61,
	0x70, 0x70, 0x4b, 0x65, 0x79, 0x12, 0x85, 0x03, 0x0a, 0x07, 0x6e, 0x77, 0x6b, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xeb, 0x02, 0x92, 0x41, 0x31, 0x4a, 0x22, 0x22,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46,
	0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42,
	0x06, 0x7a, 0x04, 0x68, 0x10, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x83, 0x01, 0x0a, 0x3f, 0x67, 0x6f,
	0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61,
	0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x40, 0x67,
	0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55,
	0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x31, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2,
	0xaa, 0x19, 0xa1, 0x01, 0x1a, 0x4f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f,
	0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x31, 0x36, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64,
	0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63, 0x74,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x06, 0x6e, 0x77, 0x6b, 0x4b, 0x65, 0x79, 0x3a, 0x08, 0xf2,
	0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0x80, 0x12, 0x0a, 0x18, 0x53, 0x69, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x12, 0xed, 0x02, 0x0a, 0x08, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xd1, 0x02, 0x92, 0x41, 0x19, 0x4a, 0x0a, 0x22,
	0x32, 0x36, 0x30, 0x30, 0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x04, 0x70, 0x01, 0xea,
	0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c,
	0x34, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e,
	0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f,
	0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c,
	0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65,
	0x77, 0x34, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e,
	0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f,
	0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c,
	0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65,
	0x74, 0x45, 0x78, 0x61, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x07, 0x64, 0x65, 0x76,
	0x41, 0x64, 0x64, 0x72, 0x12, 0x92, 0x03, 0x0a, 0x0f, 0x66, 0x5f, 0x6e, 0x77, 0x6b, 0x5f, 0x73,
	0x5f, 0x69, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xeb,
	0x02, 0x92, 0x41, 0x31, 0x4a, 0x22, 0x22, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
	0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
	0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x10, 0x70, 0x01, 0xea, 0xaa,
	0x19, 0x83, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x12, 0x40, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x31,
	0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa1, 0x01, 0x1a, 0x4f, 0x67, 0x6f, 0x2e,
	0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f,
	0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c,
	0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65,
	0x77, 0x31, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f,
	0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63,
	0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47,
	0x65, 0x74, 0x45, 0x78, 0x61, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x0b, 0x66, 0x4e,
	0x77, 0x6b, 0x53, 0x49, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x92, 0x03, 0x0a, 0x0f, 0x73, 0x5f,
	0x6e, 0x77, 0x6b, 0x5f, 0x73, 0x5f, 0x69, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x42, 0xeb, 0x02, 0x92, 0x41, 0x31, 0x4a, 0x22, 0x22, 0x30, 0x31, 0x32, 0x33,
	0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x30, 0x31, 0x32, 0x33,
	0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x22, 0x9a, 0x02, 0x01,
	0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68,
	0x10, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x83, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65,
	0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f,
	0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61,
	0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x40, 0x67, 0x6f, 0x2e, 0x74, 0x68,
	0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33,
	0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72,
	0x73, 0x68, 0x61, 0x6c, 0x31, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa1, 0x01,
	0x1a, 0x4f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d,
	0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61,
	0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x31, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61,
	0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e,
	0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c,
	0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x52, 0x0b, 0x73, 0x4e, 0x77, 0x6b, 0x53, 0x49, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x8f,
	0x03, 0x0a, 0x0d, 0x6e, 0x77, 0x6b, 0x5f, 0x73, 0x5f, 0x65, 0x6e, 0x63, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xeb, 0x02, 0x92, 0x41, 0x31, 0x4a, 0x22, 0x22, 0x30,
	0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x30,
	0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x22,
	0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06,
	0x7a, 0x04, 0x68, 0x10, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x83, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e,
	0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f,
	0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72,
	0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x40, 0x67, 0x6f,
	0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e,
	0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x31, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa,
	0x19, 0xa1, 0x01, 0x1a, 0x4f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74,
	0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x31, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f,
	0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63, 0x74, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x52, 0x0a, 0x6e, 0x77, 0x6b, 0x53, 0x45, 0x6e, 0x63, 0x4b, 0x65, 0x79,
	0x12, 0x88, 0x03, 0x0a, 0x09, 0x61, 0x70, 0x70, 0x5f, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0c, 0x42, 0xeb, 0x02, 0x92, 0x41, 0x31, 0x4a, 0x22, 0x22, 0x30, 0x31, 0x32,
	0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x30, 0x31, 0x32,
	0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x22, 0x9a, 0x02,
	0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04,
	0x68, 0x10, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x83, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68,
	0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33,
	0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68,
	0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x40, 0x67, 0x6f, 0x2e, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76,
	0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61,
	0x72, 0x73, 0x68, 0x61, 0x6c, 0x31, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa1,
	0x01, 0x1a, 0x4f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e,
	0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c,
	0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x31, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c,
	0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74,
	0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66,
	0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63, 0x74, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x52, 0x07, 0x61, 0x70, 0x70, 0x53, 0x4b, 0x65, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x61,
	0x64, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x61, 0x64, 0x72, 0x12, 0x1e, 0x0a,
	0x0b, 0x61, 0x64, 0x72, 0x5f, 0x61, 0x63, 0x6b, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x09, 0x61, 0x64, 0x72, 0x41, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x12, 0x1c, 0x0a,
	0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x61,
	0x63, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x61, 0x63, 0x6b, 0x12, 0x13, 0x0a,
	0x05, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x66, 0x43,
	0x6e, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x66, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x05, 0x66, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x72, 0x6d,
	0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a,
	0x66, 0x72, 0x6d, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1c, 0x0a, 0x0a, 0x63, 0x6f,
	0x6e, 0x66, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08,
	0x63, 0x6f, 0x6e, 0x66, 0x46, 0x43, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x09, 0x74, 0x78, 0x5f, 0x64,
	0x72, 0x5f, 0x69, 0x64, 0x78, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x74, 0x78, 0x44,
	0x72, 0x49, 0x64, 0x78, 0x12, 0x1a, 0x0a, 0x09, 0x74, 0x78, 0x5f, 0x63, 0x68, 0x5f, 0x69, 0x64,
	0x78, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x74, 0x78, 0x43, 0x68, 0x49, 0x64, 0x78,
	0x12, 0x1e, 0x0a, 0x06, 0x66, 0x5f, 0x6f, 0x70, 0x74, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0c,
	0x42, 0x07, 0xfa, 0x42, 0x04, 0x7a, 0x02, 0x18, 0x0f, 0x52, 0x05, 0x66, 0x4f, 0x70, 0x74, 0x73,
	0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f,
	0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_simulate_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_simulate_proto_rawDescData = file_ttn_lorawan_v3_simulate_proto_rawDesc
)

func file_ttn_lorawan_v3_simulate_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_simulate_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_simulate_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_simulate_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_simulate_proto_rawDescData
}

var file_ttn_lorawan_v3_simulate_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_ttn_lorawan_v3_simulate_proto_goTypes = []interface{}{
	(*SimulateMetadataParams)(nil),    // 0: ttn.lorawan.v3.SimulateMetadataParams
	(*SimulateJoinRequestParams)(nil), // 1: ttn.lorawan.v3.SimulateJoinRequestParams
	(*SimulateDataUplinkParams)(nil),  // 2: ttn.lorawan.v3.SimulateDataUplinkParams
	(*timestamppb.Timestamp)(nil),     // 3: google.protobuf.Timestamp
	(MACVersion)(0),                   // 4: ttn.lorawan.v3.MACVersion
	(PHYVersion)(0),                   // 5: ttn.lorawan.v3.PHYVersion
}
var file_ttn_lorawan_v3_simulate_proto_depIdxs = []int32{
	3, // 0: ttn.lorawan.v3.SimulateMetadataParams.time:type_name -> google.protobuf.Timestamp
	4, // 1: ttn.lorawan.v3.SimulateMetadataParams.lorawan_version:type_name -> ttn.lorawan.v3.MACVersion
	5, // 2: ttn.lorawan.v3.SimulateMetadataParams.lorawan_phy_version:type_name -> ttn.lorawan.v3.PHYVersion
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_simulate_proto_init() }
func file_ttn_lorawan_v3_simulate_proto_init() {
	if File_ttn_lorawan_v3_simulate_proto != nil {
		return
	}
	file_ttn_lorawan_v3_lorawan_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_simulate_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SimulateMetadataParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_simulate_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SimulateJoinRequestParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_simulate_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SimulateDataUplinkParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_simulate_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ttn_lorawan_v3_simulate_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_simulate_proto_depIdxs,
		MessageInfos:      file_ttn_lorawan_v3_simulate_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_simulate_proto = out.File
	file_ttn_lorawan_v3_simulate_proto_rawDesc = nil
	file_ttn_lorawan_v3_simulate_proto_goTypes = nil
	file_ttn_lorawan_v3_simulate_proto_depIdxs = nil
}
