// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.1
// source: ttn/lorawan/v3/search_services.proto

package ttnpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	EntityRegistrySearch_SearchApplications_FullMethodName  = "/ttn.lorawan.v3.EntityRegistrySearch/SearchApplications"
	EntityRegistrySearch_SearchClients_FullMethodName       = "/ttn.lorawan.v3.EntityRegistrySearch/SearchClients"
	EntityRegistrySearch_SearchGateways_FullMethodName      = "/ttn.lorawan.v3.EntityRegistrySearch/SearchGateways"
	EntityRegistrySearch_SearchOrganizations_FullMethodName = "/ttn.lorawan.v3.EntityRegistrySearch/SearchOrganizations"
	EntityRegistrySearch_SearchUsers_FullMethodName         = "/ttn.lorawan.v3.EntityRegistrySearch/SearchUsers"
	EntityRegistrySearch_SearchAccounts_FullMethodName      = "/ttn.lorawan.v3.EntityRegistrySearch/SearchAccounts"
)

// EntityRegistrySearchClient is the client API for EntityRegistrySearch service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EntityRegistrySearchClient interface {
	// Search for applications that match the conditions specified in the request.
	// Non-admin users will only match applications that they have rights on.
	SearchApplications(ctx context.Context, in *SearchApplicationsRequest, opts ...grpc.CallOption) (*Applications, error)
	// Search for OAuth clients that match the conditions specified in the request.
	// Non-admin users will only match OAuth clients that they have rights on.
	SearchClients(ctx context.Context, in *SearchClientsRequest, opts ...grpc.CallOption) (*Clients, error)
	// Search for gateways that match the conditions specified in the request.
	// Non-admin users will only match gateways that they have rights on.
	SearchGateways(ctx context.Context, in *SearchGatewaysRequest, opts ...grpc.CallOption) (*Gateways, error)
	// Search for organizations that match the conditions specified in the request.
	// Non-admin users will only match organizations that they have rights on.
	SearchOrganizations(ctx context.Context, in *SearchOrganizationsRequest, opts ...grpc.CallOption) (*Organizations, error)
	// Search for users that match the conditions specified in the request.
	// This is only available to admin users.
	SearchUsers(ctx context.Context, in *SearchUsersRequest, opts ...grpc.CallOption) (*Users, error)
	// Search for accounts that match the conditions specified in the request.
	SearchAccounts(ctx context.Context, in *SearchAccountsRequest, opts ...grpc.CallOption) (*SearchAccountsResponse, error)
}

type entityRegistrySearchClient struct {
	cc grpc.ClientConnInterface
}

func NewEntityRegistrySearchClient(cc grpc.ClientConnInterface) EntityRegistrySearchClient {
	return &entityRegistrySearchClient{cc}
}

func (c *entityRegistrySearchClient) SearchApplications(ctx context.Context, in *SearchApplicationsRequest, opts ...grpc.CallOption) (*Applications, error) {
	out := new(Applications)
	err := c.cc.Invoke(ctx, EntityRegistrySearch_SearchApplications_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityRegistrySearchClient) SearchClients(ctx context.Context, in *SearchClientsRequest, opts ...grpc.CallOption) (*Clients, error) {
	out := new(Clients)
	err := c.cc.Invoke(ctx, EntityRegistrySearch_SearchClients_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityRegistrySearchClient) SearchGateways(ctx context.Context, in *SearchGatewaysRequest, opts ...grpc.CallOption) (*Gateways, error) {
	out := new(Gateways)
	err := c.cc.Invoke(ctx, EntityRegistrySearch_SearchGateways_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityRegistrySearchClient) SearchOrganizations(ctx context.Context, in *SearchOrganizationsRequest, opts ...grpc.CallOption) (*Organizations, error) {
	out := new(Organizations)
	err := c.cc.Invoke(ctx, EntityRegistrySearch_SearchOrganizations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityRegistrySearchClient) SearchUsers(ctx context.Context, in *SearchUsersRequest, opts ...grpc.CallOption) (*Users, error) {
	out := new(Users)
	err := c.cc.Invoke(ctx, EntityRegistrySearch_SearchUsers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityRegistrySearchClient) SearchAccounts(ctx context.Context, in *SearchAccountsRequest, opts ...grpc.CallOption) (*SearchAccountsResponse, error) {
	out := new(SearchAccountsResponse)
	err := c.cc.Invoke(ctx, EntityRegistrySearch_SearchAccounts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EntityRegistrySearchServer is the server API for EntityRegistrySearch service.
// All implementations must embed UnimplementedEntityRegistrySearchServer
// for forward compatibility
type EntityRegistrySearchServer interface {
	// Search for applications that match the conditions specified in the request.
	// Non-admin users will only match applications that they have rights on.
	SearchApplications(context.Context, *SearchApplicationsRequest) (*Applications, error)
	// Search for OAuth clients that match the conditions specified in the request.
	// Non-admin users will only match OAuth clients that they have rights on.
	SearchClients(context.Context, *SearchClientsRequest) (*Clients, error)
	// Search for gateways that match the conditions specified in the request.
	// Non-admin users will only match gateways that they have rights on.
	SearchGateways(context.Context, *SearchGatewaysRequest) (*Gateways, error)
	// Search for organizations that match the conditions specified in the request.
	// Non-admin users will only match organizations that they have rights on.
	SearchOrganizations(context.Context, *SearchOrganizationsRequest) (*Organizations, error)
	// Search for users that match the conditions specified in the request.
	// This is only available to admin users.
	SearchUsers(context.Context, *SearchUsersRequest) (*Users, error)
	// Search for accounts that match the conditions specified in the request.
	SearchAccounts(context.Context, *SearchAccountsRequest) (*SearchAccountsResponse, error)
	mustEmbedUnimplementedEntityRegistrySearchServer()
}

// UnimplementedEntityRegistrySearchServer must be embedded to have forward compatible implementations.
type UnimplementedEntityRegistrySearchServer struct {
}

func (UnimplementedEntityRegistrySearchServer) SearchApplications(context.Context, *SearchApplicationsRequest) (*Applications, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchApplications not implemented")
}
func (UnimplementedEntityRegistrySearchServer) SearchClients(context.Context, *SearchClientsRequest) (*Clients, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchClients not implemented")
}
func (UnimplementedEntityRegistrySearchServer) SearchGateways(context.Context, *SearchGatewaysRequest) (*Gateways, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchGateways not implemented")
}
func (UnimplementedEntityRegistrySearchServer) SearchOrganizations(context.Context, *SearchOrganizationsRequest) (*Organizations, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchOrganizations not implemented")
}
func (UnimplementedEntityRegistrySearchServer) SearchUsers(context.Context, *SearchUsersRequest) (*Users, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchUsers not implemented")
}
func (UnimplementedEntityRegistrySearchServer) SearchAccounts(context.Context, *SearchAccountsRequest) (*SearchAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchAccounts not implemented")
}
func (UnimplementedEntityRegistrySearchServer) mustEmbedUnimplementedEntityRegistrySearchServer() {}

// UnsafeEntityRegistrySearchServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EntityRegistrySearchServer will
// result in compilation errors.
type UnsafeEntityRegistrySearchServer interface {
	mustEmbedUnimplementedEntityRegistrySearchServer()
}

func RegisterEntityRegistrySearchServer(s grpc.ServiceRegistrar, srv EntityRegistrySearchServer) {
	s.RegisterService(&EntityRegistrySearch_ServiceDesc, srv)
}

func _EntityRegistrySearch_SearchApplications_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchApplicationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityRegistrySearchServer).SearchApplications(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityRegistrySearch_SearchApplications_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityRegistrySearchServer).SearchApplications(ctx, req.(*SearchApplicationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityRegistrySearch_SearchClients_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchClientsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityRegistrySearchServer).SearchClients(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityRegistrySearch_SearchClients_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityRegistrySearchServer).SearchClients(ctx, req.(*SearchClientsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityRegistrySearch_SearchGateways_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchGatewaysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityRegistrySearchServer).SearchGateways(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityRegistrySearch_SearchGateways_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityRegistrySearchServer).SearchGateways(ctx, req.(*SearchGatewaysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityRegistrySearch_SearchOrganizations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchOrganizationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityRegistrySearchServer).SearchOrganizations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityRegistrySearch_SearchOrganizations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityRegistrySearchServer).SearchOrganizations(ctx, req.(*SearchOrganizationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityRegistrySearch_SearchUsers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchUsersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityRegistrySearchServer).SearchUsers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityRegistrySearch_SearchUsers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityRegistrySearchServer).SearchUsers(ctx, req.(*SearchUsersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityRegistrySearch_SearchAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityRegistrySearchServer).SearchAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityRegistrySearch_SearchAccounts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityRegistrySearchServer).SearchAccounts(ctx, req.(*SearchAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// EntityRegistrySearch_ServiceDesc is the grpc.ServiceDesc for EntityRegistrySearch service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var EntityRegistrySearch_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.EntityRegistrySearch",
	HandlerType: (*EntityRegistrySearchServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchApplications",
			Handler:    _EntityRegistrySearch_SearchApplications_Handler,
		},
		{
			MethodName: "SearchClients",
			Handler:    _EntityRegistrySearch_SearchClients_Handler,
		},
		{
			MethodName: "SearchGateways",
			Handler:    _EntityRegistrySearch_SearchGateways_Handler,
		},
		{
			MethodName: "SearchOrganizations",
			Handler:    _EntityRegistrySearch_SearchOrganizations_Handler,
		},
		{
			MethodName: "SearchUsers",
			Handler:    _EntityRegistrySearch_SearchUsers_Handler,
		},
		{
			MethodName: "SearchAccounts",
			Handler:    _EntityRegistrySearch_SearchAccounts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/search_services.proto",
}

const (
	EndDeviceRegistrySearch_SearchEndDevices_FullMethodName = "/ttn.lorawan.v3.EndDeviceRegistrySearch/SearchEndDevices"
)

// EndDeviceRegistrySearchClient is the client API for EndDeviceRegistrySearch service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EndDeviceRegistrySearchClient interface {
	// Search for end devices in the given application that match the conditions specified in the request.
	SearchEndDevices(ctx context.Context, in *SearchEndDevicesRequest, opts ...grpc.CallOption) (*EndDevices, error)
}

type endDeviceRegistrySearchClient struct {
	cc grpc.ClientConnInterface
}

func NewEndDeviceRegistrySearchClient(cc grpc.ClientConnInterface) EndDeviceRegistrySearchClient {
	return &endDeviceRegistrySearchClient{cc}
}

func (c *endDeviceRegistrySearchClient) SearchEndDevices(ctx context.Context, in *SearchEndDevicesRequest, opts ...grpc.CallOption) (*EndDevices, error) {
	out := new(EndDevices)
	err := c.cc.Invoke(ctx, EndDeviceRegistrySearch_SearchEndDevices_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EndDeviceRegistrySearchServer is the server API for EndDeviceRegistrySearch service.
// All implementations must embed UnimplementedEndDeviceRegistrySearchServer
// for forward compatibility
type EndDeviceRegistrySearchServer interface {
	// Search for end devices in the given application that match the conditions specified in the request.
	SearchEndDevices(context.Context, *SearchEndDevicesRequest) (*EndDevices, error)
	mustEmbedUnimplementedEndDeviceRegistrySearchServer()
}

// UnimplementedEndDeviceRegistrySearchServer must be embedded to have forward compatible implementations.
type UnimplementedEndDeviceRegistrySearchServer struct {
}

func (UnimplementedEndDeviceRegistrySearchServer) SearchEndDevices(context.Context, *SearchEndDevicesRequest) (*EndDevices, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchEndDevices not implemented")
}
func (UnimplementedEndDeviceRegistrySearchServer) mustEmbedUnimplementedEndDeviceRegistrySearchServer() {
}

// UnsafeEndDeviceRegistrySearchServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EndDeviceRegistrySearchServer will
// result in compilation errors.
type UnsafeEndDeviceRegistrySearchServer interface {
	mustEmbedUnimplementedEndDeviceRegistrySearchServer()
}

func RegisterEndDeviceRegistrySearchServer(s grpc.ServiceRegistrar, srv EndDeviceRegistrySearchServer) {
	s.RegisterService(&EndDeviceRegistrySearch_ServiceDesc, srv)
}

func _EndDeviceRegistrySearch_SearchEndDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchEndDevicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EndDeviceRegistrySearchServer).SearchEndDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EndDeviceRegistrySearch_SearchEndDevices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EndDeviceRegistrySearchServer).SearchEndDevices(ctx, req.(*SearchEndDevicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// EndDeviceRegistrySearch_ServiceDesc is the grpc.ServiceDesc for EndDeviceRegistrySearch service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var EndDeviceRegistrySearch_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.EndDeviceRegistrySearch",
	HandlerType: (*EndDeviceRegistrySearchServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchEndDevices",
			Handler:    _EndDeviceRegistrySearch_SearchEndDevices_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/search_services.proto",
}
