// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/rights.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Right is the enum that defines all the different rights to do something in the network.
type Right int32

const (
	Right_right_invalid Right = 0
	// The right to view user information.
	Right_RIGHT_USER_INFO Right = 1
	// The right to edit basic user settings.
	Right_RIGHT_USER_SETTINGS_BASIC Right = 2
	// The right to list users accounts.
	Right_RIGHT_USER_LIST Right = 87
	// The right to create an user account.
	Right_RIGHT_USER_CREATE Right = 88
	// The right to view and edit user API keys.
	Right_RIGHT_USER_SETTINGS_API_KEYS Right = 3
	// The right to delete user account.
	Right_RIGHT_USER_DELETE Right = 4
	// The right to delete user account.
	Right_RIGHT_USER_PURGE Right = 66
	// The right to view and edit authorized OAuth clients of the user.
	Right_RIGHT_USER_AUTHORIZED_CLIENTS Right = 5
	// The right to list applications the user is a collaborator of.
	Right_RIGHT_USER_APPLICATIONS_LIST Right = 6
	// The right to create an application under the user account.
	Right_RIGHT_USER_APPLICATIONS_CREATE Right = 7
	// The right to list gateways the user is a collaborator of.
	Right_RIGHT_USER_GATEWAYS_LIST Right = 8
	// The right to create a gateway under the account of the user.
	Right_RIGHT_USER_GATEWAYS_CREATE Right = 9
	// The right to list OAuth clients the user is a collaborator of.
	Right_RIGHT_USER_CLIENTS_LIST Right = 10
	// The right to create an OAuth client under the account of the user.
	Right_RIGHT_USER_CLIENTS_CREATE Right = 11
	// The right to list organizations the user is a member of.
	Right_RIGHT_USER_ORGANIZATIONS_LIST Right = 12
	// The right to create an organization under the user account.
	Right_RIGHT_USER_ORGANIZATIONS_CREATE Right = 13
	// The right to read notifications sent to the user.
	Right_RIGHT_USER_NOTIFICATIONS_READ Right = 59
	// The pseudo-right for all (current and future) user rights.
	Right_RIGHT_USER_ALL Right = 14
	// The right to view application information.
	Right_RIGHT_APPLICATION_INFO Right = 15
	// The right to edit basic application settings.
	Right_RIGHT_APPLICATION_SETTINGS_BASIC Right = 16
	// The right to view and edit application API keys.
	Right_RIGHT_APPLICATION_SETTINGS_API_KEYS Right = 17
	// The right to view and edit application collaborators.
	Right_RIGHT_APPLICATION_SETTINGS_COLLABORATORS Right = 18
	// The right to view and edit application packages and associations.
	Right_RIGHT_APPLICATION_SETTINGS_PACKAGES Right = 56
	// The right to delete application.
	Right_RIGHT_APPLICATION_DELETE Right = 19
	// The right to purge application.
	Right_RIGHT_APPLICATION_PURGE Right = 64
	// The right to view devices in application.
	Right_RIGHT_APPLICATION_DEVICES_READ Right = 20
	// The right to create devices in application.
	Right_RIGHT_APPLICATION_DEVICES_WRITE Right = 21
	// The right to view device keys in application.
	// Note that keys may not be stored in a way that supports viewing them.
	Right_RIGHT_APPLICATION_DEVICES_READ_KEYS Right = 22
	// The right to edit device keys in application.
	Right_RIGHT_APPLICATION_DEVICES_WRITE_KEYS Right = 23
	// The right to read application traffic (uplink and downlink).
	Right_RIGHT_APPLICATION_TRAFFIC_READ Right = 24
	// The right to write uplink application traffic.
	Right_RIGHT_APPLICATION_TRAFFIC_UP_WRITE Right = 25
	// The right to write downlink application traffic.
	Right_RIGHT_APPLICATION_TRAFFIC_DOWN_WRITE Right = 26
	// The right to link as Application to a Network Server for traffic exchange,
	// i.e. read uplink and write downlink (API keys only).
	// This right is typically only given to an Application Server.
	// This right implies RIGHT_APPLICATION_INFO, RIGHT_APPLICATION_TRAFFIC_READ,
	// and RIGHT_APPLICATION_TRAFFIC_DOWN_WRITE.
	Right_RIGHT_APPLICATION_LINK Right = 27
	// The pseudo-right for all (current and future) application rights.
	Right_RIGHT_APPLICATION_ALL Right = 28
	// The pseudo-right for all (current and future) OAuth client rights.
	Right_RIGHT_CLIENT_ALL Right = 29
	// The right to read client information.
	Right_RIGHT_CLIENT_INFO Right = 60
	// The right to edit basic client settings.
	Right_RIGHT_CLIENT_SETTINGS_BASIC Right = 61
	// The right to view and edit client collaborators.
	Right_RIGHT_CLIENT_SETTINGS_COLLABORATORS Right = 62
	// The right to delete a client.
	Right_RIGHT_CLIENT_DELETE Right = 63
	// The right to purge a client.
	Right_RIGHT_CLIENT_PURGE Right = 68
	// The right to view gateway information.
	Right_RIGHT_GATEWAY_INFO Right = 30
	// The right to edit basic gateway settings.
	Right_RIGHT_GATEWAY_SETTINGS_BASIC Right = 31
	// The right to view and edit gateway API keys.
	Right_RIGHT_GATEWAY_SETTINGS_API_KEYS Right = 32
	// The right to view and edit gateway collaborators.
	Right_RIGHT_GATEWAY_SETTINGS_COLLABORATORS Right = 33
	// The right to delete gateway.
	Right_RIGHT_GATEWAY_DELETE Right = 34
	// The right to purge gateway.
	Right_RIGHT_GATEWAY_PURGE Right = 67
	// The right to read gateway traffic.
	Right_RIGHT_GATEWAY_TRAFFIC_READ Right = 35
	// The right to write downlink gateway traffic.
	Right_RIGHT_GATEWAY_TRAFFIC_DOWN_WRITE Right = 36
	// The right to link as Gateway to a Gateway Server for traffic exchange,
	// i.e. write uplink and read downlink (API keys only)
	// This right is typically only given to a gateway.
	// This right implies RIGHT_GATEWAY_INFO.
	Right_RIGHT_GATEWAY_LINK Right = 37
	// The right to view gateway status.
	Right_RIGHT_GATEWAY_STATUS_READ Right = 38
	// The right to view view gateway location.
	Right_RIGHT_GATEWAY_LOCATION_READ Right = 39
	// The right to store secrets associated with this gateway.
	Right_RIGHT_GATEWAY_WRITE_SECRETS Right = 57
	// The right to retrieve secrets associated with this gateway.
	Right_RIGHT_GATEWAY_READ_SECRETS Right = 58
	// The pseudo-right for all (current and future) gateway rights.
	Right_RIGHT_GATEWAY_ALL Right = 40
	// The right to view organization information.
	Right_RIGHT_ORGANIZATION_INFO Right = 41
	// The right to edit basic organization settings.
	Right_RIGHT_ORGANIZATION_SETTINGS_BASIC Right = 42
	// The right to view and edit organization API keys.
	Right_RIGHT_ORGANIZATION_SETTINGS_API_KEYS Right = 43
	// The right to view and edit organization members.
	Right_RIGHT_ORGANIZATION_SETTINGS_MEMBERS Right = 44
	// The right to delete organization.
	Right_RIGHT_ORGANIZATION_DELETE Right = 45
	// The right to purge organization.
	Right_RIGHT_ORGANIZATION_PURGE Right = 65
	// The right to list the applications the organization is a collaborator of.
	Right_RIGHT_ORGANIZATION_APPLICATIONS_LIST Right = 46
	// The right to create an application under the organization.
	Right_RIGHT_ORGANIZATION_APPLICATIONS_CREATE Right = 47
	// The right to list the gateways the organization is a collaborator of.
	Right_RIGHT_ORGANIZATION_GATEWAYS_LIST Right = 48
	// The right to create a gateway under the organization.
	Right_RIGHT_ORGANIZATION_GATEWAYS_CREATE Right = 49
	// The right to list the OAuth clients the organization is a collaborator of.
	Right_RIGHT_ORGANIZATION_CLIENTS_LIST Right = 50
	// The right to create an OAuth client under the organization.
	Right_RIGHT_ORGANIZATION_CLIENTS_CREATE Right = 51
	// The right to add the organization as a collaborator on an existing entity.
	Right_RIGHT_ORGANIZATION_ADD_AS_COLLABORATOR Right = 52
	// The pseudo-right for all (current and future) organization rights.
	Right_RIGHT_ORGANIZATION_ALL Right = 53
	// The right to send invites to new users.
	// Note that this is not prefixed with "USER_"; it is not a right on the user entity.
	Right_RIGHT_SEND_INVITES Right = 54
	// The pseudo-right for all (current and future) possible rights.
	Right_RIGHT_ALL Right = 55
)

// Enum value maps for Right.
var (
	Right_name = map[int32]string{
		0:  "right_invalid",
		1:  "RIGHT_USER_INFO",
		2:  "RIGHT_USER_SETTINGS_BASIC",
		87: "RIGHT_USER_LIST",
		88: "RIGHT_USER_CREATE",
		3:  "RIGHT_USER_SETTINGS_API_KEYS",
		4:  "RIGHT_USER_DELETE",
		66: "RIGHT_USER_PURGE",
		5:  "RIGHT_USER_AUTHORIZED_CLIENTS",
		6:  "RIGHT_USER_APPLICATIONS_LIST",
		7:  "RIGHT_USER_APPLICATIONS_CREATE",
		8:  "RIGHT_USER_GATEWAYS_LIST",
		9:  "RIGHT_USER_GATEWAYS_CREATE",
		10: "RIGHT_USER_CLIENTS_LIST",
		11: "RIGHT_USER_CLIENTS_CREATE",
		12: "RIGHT_USER_ORGANIZATIONS_LIST",
		13: "RIGHT_USER_ORGANIZATIONS_CREATE",
		59: "RIGHT_USER_NOTIFICATIONS_READ",
		14: "RIGHT_USER_ALL",
		15: "RIGHT_APPLICATION_INFO",
		16: "RIGHT_APPLICATION_SETTINGS_BASIC",
		17: "RIGHT_APPLICATION_SETTINGS_API_KEYS",
		18: "RIGHT_APPLICATION_SETTINGS_COLLABORATORS",
		56: "RIGHT_APPLICATION_SETTINGS_PACKAGES",
		19: "RIGHT_APPLICATION_DELETE",
		64: "RIGHT_APPLICATION_PURGE",
		20: "RIGHT_APPLICATION_DEVICES_READ",
		21: "RIGHT_APPLICATION_DEVICES_WRITE",
		22: "RIGHT_APPLICATION_DEVICES_READ_KEYS",
		23: "RIGHT_APPLICATION_DEVICES_WRITE_KEYS",
		24: "RIGHT_APPLICATION_TRAFFIC_READ",
		25: "RIGHT_APPLICATION_TRAFFIC_UP_WRITE",
		26: "RIGHT_APPLICATION_TRAFFIC_DOWN_WRITE",
		27: "RIGHT_APPLICATION_LINK",
		28: "RIGHT_APPLICATION_ALL",
		29: "RIGHT_CLIENT_ALL",
		60: "RIGHT_CLIENT_INFO",
		61: "RIGHT_CLIENT_SETTINGS_BASIC",
		62: "RIGHT_CLIENT_SETTINGS_COLLABORATORS",
		63: "RIGHT_CLIENT_DELETE",
		68: "RIGHT_CLIENT_PURGE",
		30: "RIGHT_GATEWAY_INFO",
		31: "RIGHT_GATEWAY_SETTINGS_BASIC",
		32: "RIGHT_GATEWAY_SETTINGS_API_KEYS",
		33: "RIGHT_GATEWAY_SETTINGS_COLLABORATORS",
		34: "RIGHT_GATEWAY_DELETE",
		67: "RIGHT_GATEWAY_PURGE",
		35: "RIGHT_GATEWAY_TRAFFIC_READ",
		36: "RIGHT_GATEWAY_TRAFFIC_DOWN_WRITE",
		37: "RIGHT_GATEWAY_LINK",
		38: "RIGHT_GATEWAY_STATUS_READ",
		39: "RIGHT_GATEWAY_LOCATION_READ",
		57: "RIGHT_GATEWAY_WRITE_SECRETS",
		58: "RIGHT_GATEWAY_READ_SECRETS",
		40: "RIGHT_GATEWAY_ALL",
		41: "RIGHT_ORGANIZATION_INFO",
		42: "RIGHT_ORGANIZATION_SETTINGS_BASIC",
		43: "RIGHT_ORGANIZATION_SETTINGS_API_KEYS",
		44: "RIGHT_ORGANIZATION_SETTINGS_MEMBERS",
		45: "RIGHT_ORGANIZATION_DELETE",
		65: "RIGHT_ORGANIZATION_PURGE",
		46: "RIGHT_ORGANIZATION_APPLICATIONS_LIST",
		47: "RIGHT_ORGANIZATION_APPLICATIONS_CREATE",
		48: "RIGHT_ORGANIZATION_GATEWAYS_LIST",
		49: "RIGHT_ORGANIZATION_GATEWAYS_CREATE",
		50: "RIGHT_ORGANIZATION_CLIENTS_LIST",
		51: "RIGHT_ORGANIZATION_CLIENTS_CREATE",
		52: "RIGHT_ORGANIZATION_ADD_AS_COLLABORATOR",
		53: "RIGHT_ORGANIZATION_ALL",
		54: "RIGHT_SEND_INVITES",
		55: "RIGHT_ALL",
	}
	Right_value = map[string]int32{
		"right_invalid":                            0,
		"RIGHT_USER_INFO":                          1,
		"RIGHT_USER_SETTINGS_BASIC":                2,
		"RIGHT_USER_LIST":                          87,
		"RIGHT_USER_CREATE":                        88,
		"RIGHT_USER_SETTINGS_API_KEYS":             3,
		"RIGHT_USER_DELETE":                        4,
		"RIGHT_USER_PURGE":                         66,
		"RIGHT_USER_AUTHORIZED_CLIENTS":            5,
		"RIGHT_USER_APPLICATIONS_LIST":             6,
		"RIGHT_USER_APPLICATIONS_CREATE":           7,
		"RIGHT_USER_GATEWAYS_LIST":                 8,
		"RIGHT_USER_GATEWAYS_CREATE":               9,
		"RIGHT_USER_CLIENTS_LIST":                  10,
		"RIGHT_USER_CLIENTS_CREATE":                11,
		"RIGHT_USER_ORGANIZATIONS_LIST":            12,
		"RIGHT_USER_ORGANIZATIONS_CREATE":          13,
		"RIGHT_USER_NOTIFICATIONS_READ":            59,
		"RIGHT_USER_ALL":                           14,
		"RIGHT_APPLICATION_INFO":                   15,
		"RIGHT_APPLICATION_SETTINGS_BASIC":         16,
		"RIGHT_APPLICATION_SETTINGS_API_KEYS":      17,
		"RIGHT_APPLICATION_SETTINGS_COLLABORATORS": 18,
		"RIGHT_APPLICATION_SETTINGS_PACKAGES":      56,
		"RIGHT_APPLICATION_DELETE":                 19,
		"RIGHT_APPLICATION_PURGE":                  64,
		"RIGHT_APPLICATION_DEVICES_READ":           20,
		"RIGHT_APPLICATION_DEVICES_WRITE":          21,
		"RIGHT_APPLICATION_DEVICES_READ_KEYS":      22,
		"RIGHT_APPLICATION_DEVICES_WRITE_KEYS":     23,
		"RIGHT_APPLICATION_TRAFFIC_READ":           24,
		"RIGHT_APPLICATION_TRAFFIC_UP_WRITE":       25,
		"RIGHT_APPLICATION_TRAFFIC_DOWN_WRITE":     26,
		"RIGHT_APPLICATION_LINK":                   27,
		"RIGHT_APPLICATION_ALL":                    28,
		"RIGHT_CLIENT_ALL":                         29,
		"RIGHT_CLIENT_INFO":                        60,
		"RIGHT_CLIENT_SETTINGS_BASIC":              61,
		"RIGHT_CLIENT_SETTINGS_COLLABORATORS":      62,
		"RIGHT_CLIENT_DELETE":                      63,
		"RIGHT_CLIENT_PURGE":                       68,
		"RIGHT_GATEWAY_INFO":                       30,
		"RIGHT_GATEWAY_SETTINGS_BASIC":             31,
		"RIGHT_GATEWAY_SETTINGS_API_KEYS":          32,
		"RIGHT_GATEWAY_SETTINGS_COLLABORATORS":     33,
		"RIGHT_GATEWAY_DELETE":                     34,
		"RIGHT_GATEWAY_PURGE":                      67,
		"RIGHT_GATEWAY_TRAFFIC_READ":               35,
		"RIGHT_GATEWAY_TRAFFIC_DOWN_WRITE":         36,
		"RIGHT_GATEWAY_LINK":                       37,
		"RIGHT_GATEWAY_STATUS_READ":                38,
		"RIGHT_GATEWAY_LOCATION_READ":              39,
		"RIGHT_GATEWAY_WRITE_SECRETS":              57,
		"RIGHT_GATEWAY_READ_SECRETS":               58,
		"RIGHT_GATEWAY_ALL":                        40,
		"RIGHT_ORGANIZATION_INFO":                  41,
		"RIGHT_ORGANIZATION_SETTINGS_BASIC":        42,
		"RIGHT_ORGANIZATION_SETTINGS_API_KEYS":     43,
		"RIGHT_ORGANIZATION_SETTINGS_MEMBERS":      44,
		"RIGHT_ORGANIZATION_DELETE":                45,
		"RIGHT_ORGANIZATION_PURGE":                 65,
		"RIGHT_ORGANIZATION_APPLICATIONS_LIST":     46,
		"RIGHT_ORGANIZATION_APPLICATIONS_CREATE":   47,
		"RIGHT_ORGANIZATION_GATEWAYS_LIST":         48,
		"RIGHT_ORGANIZATION_GATEWAYS_CREATE":       49,
		"RIGHT_ORGANIZATION_CLIENTS_LIST":          50,
		"RIGHT_ORGANIZATION_CLIENTS_CREATE":        51,
		"RIGHT_ORGANIZATION_ADD_AS_COLLABORATOR":   52,
		"RIGHT_ORGANIZATION_ALL":                   53,
		"RIGHT_SEND_INVITES":                       54,
		"RIGHT_ALL":                                55,
	}
)

func (x Right) Enum() *Right {
	p := new(Right)
	*p = x
	return p
}

func (x Right) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Right) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_rights_proto_enumTypes[0].Descriptor()
}

func (Right) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_rights_proto_enumTypes[0]
}

func (x Right) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Right.Descriptor instead.
func (Right) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_rights_proto_rawDescGZIP(), []int{0}
}

type Rights struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Rights []Right `protobuf:"varint,1,rep,packed,name=rights,proto3,enum=ttn.lorawan.v3.Right" json:"rights,omitempty"`
}

func (x *Rights) Reset() {
	*x = Rights{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_rights_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rights) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rights) ProtoMessage() {}

func (x *Rights) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_rights_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rights.ProtoReflect.Descriptor instead.
func (*Rights) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_rights_proto_rawDescGZIP(), []int{0}
}

func (x *Rights) GetRights() []Right {
	if x != nil {
		return x.Rights
	}
	return nil
}

type APIKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable and unique public identifier for the API key.
	// Generated by the Access Server.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Immutable and unique secret value of the API key.
	// Generated by the Access Server.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// User-defined (friendly) name for the API key.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Rights that are granted to this API key.
	Rights    []Right                `protobuf:"varint,4,rep,packed,name=rights,proto3,enum=ttn.lorawan.v3.Right" json:"rights,omitempty"`
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	ExpiresAt *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=expires_at,json=expiresAt,proto3" json:"expires_at,omitempty"`
}

func (x *APIKey) Reset() {
	*x = APIKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_rights_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *APIKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*APIKey) ProtoMessage() {}

func (x *APIKey) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_rights_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use APIKey.ProtoReflect.Descriptor instead.
func (*APIKey) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_rights_proto_rawDescGZIP(), []int{1}
}

func (x *APIKey) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *APIKey) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *APIKey) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *APIKey) GetRights() []Right {
	if x != nil {
		return x.Rights
	}
	return nil
}

func (x *APIKey) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *APIKey) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *APIKey) GetExpiresAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpiresAt
	}
	return nil
}

type APIKeys struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApiKeys []*APIKey `protobuf:"bytes,1,rep,name=api_keys,json=apiKeys,proto3" json:"api_keys,omitempty"`
}

func (x *APIKeys) Reset() {
	*x = APIKeys{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_rights_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *APIKeys) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*APIKeys) ProtoMessage() {}

func (x *APIKeys) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_rights_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use APIKeys.ProtoReflect.Descriptor instead.
func (*APIKeys) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_rights_proto_rawDescGZIP(), []int{2}
}

func (x *APIKeys) GetApiKeys() []*APIKey {
	if x != nil {
		return x.ApiKeys
	}
	return nil
}

type Collaborator struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids    *OrganizationOrUserIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	Rights []Right                        `protobuf:"varint,2,rep,packed,name=rights,proto3,enum=ttn.lorawan.v3.Right" json:"rights,omitempty"`
}

func (x *Collaborator) Reset() {
	*x = Collaborator{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_rights_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Collaborator) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Collaborator) ProtoMessage() {}

func (x *Collaborator) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_rights_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Collaborator.ProtoReflect.Descriptor instead.
func (*Collaborator) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_rights_proto_rawDescGZIP(), []int{3}
}

func (x *Collaborator) GetIds() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *Collaborator) GetRights() []Right {
	if x != nil {
		return x.Rights
	}
	return nil
}

type GetCollaboratorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids    *OrganizationOrUserIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	Rights []Right                        `protobuf:"varint,2,rep,packed,name=rights,proto3,enum=ttn.lorawan.v3.Right" json:"rights,omitempty"`
}

func (x *GetCollaboratorResponse) Reset() {
	*x = GetCollaboratorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_rights_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCollaboratorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCollaboratorResponse) ProtoMessage() {}

func (x *GetCollaboratorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_rights_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCollaboratorResponse.ProtoReflect.Descriptor instead.
func (*GetCollaboratorResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_rights_proto_rawDescGZIP(), []int{4}
}

func (x *GetCollaboratorResponse) GetIds() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *GetCollaboratorResponse) GetRights() []Right {
	if x != nil {
		return x.Rights
	}
	return nil
}

type Collaborators struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Collaborators []*Collaborator `protobuf:"bytes,1,rep,name=collaborators,proto3" json:"collaborators,omitempty"`
}

func (x *Collaborators) Reset() {
	*x = Collaborators{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_rights_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Collaborators) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Collaborators) ProtoMessage() {}

func (x *Collaborators) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_rights_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Collaborators.ProtoReflect.Descriptor instead.
func (*Collaborators) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_rights_proto_rawDescGZIP(), []int{5}
}

func (x *Collaborators) GetCollaborators() []*Collaborator {
	if x != nil {
		return x.Collaborators
	}
	return nil
}

var File_ttn_lorawan_v3_rights_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_rights_proto_rawDesc = []byte{
	0x0a, 0x1b, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21,
	0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x6a, 0x73, 0x6f,
	0x6e, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2f, 0x76, 0x33, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x46,
	0x0a, 0x06, 0x52, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0x3c, 0x0a, 0x06, 0x72, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x69, 0x67, 0x68, 0x74, 0x42,
	0x0d, 0xfa, 0x42, 0x0a, 0x92, 0x01, 0x07, 0x22, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x06,
	0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x22, 0xca, 0x02, 0x0a, 0x06, 0x41, 0x50, 0x49, 0x4b, 0x65,
	0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x1b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x32, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x3c, 0x0a, 0x06, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x15, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x52, 0x69, 0x67, 0x68, 0x74, 0x42, 0x0d, 0xfa, 0x42, 0x0a, 0x92, 0x01, 0x07, 0x22,
	0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x06, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0x39,
	0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x64, 0x41, 0x74, 0x12, 0x43, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x5f,
	0x61, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x08, 0xfa, 0x42, 0x05, 0xb2, 0x01, 0x02, 0x40, 0x01, 0x52, 0x09,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x41, 0x74, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08,
	0x01, 0x10, 0x01, 0x22, 0x3c, 0x0a, 0x07, 0x41, 0x50, 0x49, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x31,
	0x0a, 0x08, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x41, 0x50, 0x49, 0x4b, 0x65, 0x79, 0x52, 0x07, 0x61, 0x70, 0x69, 0x4b, 0x65, 0x79,
	0x73, 0x22, 0xaf, 0x01, 0x0a, 0x0c, 0x43, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x12, 0x49, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x3c, 0x0a,
	0x06, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x15, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x69, 0x67, 0x68, 0x74, 0x42, 0x0d, 0xfa, 0x42, 0x0a, 0x92, 0x01, 0x07, 0x22, 0x05, 0x82, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x06, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x4a, 0x04, 0x08, 0x03, 0x10,
	0x04, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x4a, 0x04, 0x08, 0x05, 0x10, 0x06, 0x4a, 0x04, 0x08,
	0x06, 0x10, 0x07, 0x22, 0xa1, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x61,
	0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3f, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x03, 0x69, 0x64, 0x73,
	0x12, 0x2d, 0x0a, 0x06, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x15, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x52, 0x69, 0x67, 0x68, 0x74, 0x52, 0x06, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x4a,
	0x04, 0x08, 0x03, 0x10, 0x04, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x4a, 0x04, 0x08, 0x05, 0x10,
	0x06, 0x4a, 0x04, 0x08, 0x06, 0x10, 0x07, 0x22, 0x53, 0x0a, 0x0d, 0x43, 0x6f, 0x6c, 0x6c, 0x61,
	0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x42, 0x0a, 0x0d, 0x63, 0x6f, 0x6c, 0x6c,
	0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x0d, 0x63,
	0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x2a, 0xf9, 0x12, 0x0a,
	0x05, 0x52, 0x69, 0x67, 0x68, 0x74, 0x12, 0x11, 0x0a, 0x0d, 0x72, 0x69, 0x67, 0x68, 0x74, 0x5f,
	0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x49, 0x47,
	0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x01, 0x12, 0x1d,
	0x0a, 0x19, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x53, 0x45, 0x54,
	0x54, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x02, 0x12, 0x13, 0x0a,
	0x0f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x4c, 0x49, 0x53, 0x54,
	0x10, 0x57, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52,
	0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x58, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x49, 0x47,
	0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53,
	0x5f, 0x41, 0x50, 0x49, 0x5f, 0x4b, 0x45, 0x59, 0x53, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x52,
	0x49, 0x47, 0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45,
	0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52,
	0x5f, 0x50, 0x55, 0x52, 0x47, 0x45, 0x10, 0x42, 0x12, 0x21, 0x0a, 0x1d, 0x52, 0x49, 0x47, 0x48,
	0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x45,
	0x44, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x53, 0x10, 0x05, 0x12, 0x20, 0x0a, 0x1c, 0x52,
	0x49, 0x47, 0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x06, 0x12, 0x22, 0x0a,
	0x1e, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x41, 0x50, 0x50, 0x4c,
	0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10,
	0x07, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f,
	0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x53, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x08, 0x12,
	0x1e, 0x0a, 0x1a, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x47, 0x41,
	0x54, 0x45, 0x57, 0x41, 0x59, 0x53, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x09, 0x12,
	0x1b, 0x0a, 0x17, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x43, 0x4c,
	0x49, 0x45, 0x4e, 0x54, 0x53, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x0a, 0x12, 0x1d, 0x0a, 0x19,
	0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e,
	0x54, 0x53, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x0b, 0x12, 0x21, 0x0a, 0x1d, 0x52,
	0x49, 0x47, 0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49,
	0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x0c, 0x12, 0x23,
	0x0a, 0x1f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x4f, 0x52, 0x47,
	0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x10, 0x0d, 0x12, 0x21, 0x0a, 0x1d, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x55, 0x53, 0x45,
	0x52, 0x5f, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f,
	0x52, 0x45, 0x41, 0x44, 0x10, 0x3b, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f,
	0x55, 0x53, 0x45, 0x52, 0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x0e, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x49,
	0x47, 0x48, 0x54, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x49, 0x4e, 0x46, 0x4f, 0x10, 0x0f, 0x12, 0x24, 0x0a, 0x20, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f,
	0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x45, 0x54, 0x54,
	0x49, 0x4e, 0x47, 0x53, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x10, 0x12, 0x27, 0x0a, 0x23,
	0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x4b,
	0x45, 0x59, 0x53, 0x10, 0x11, 0x12, 0x2c, 0x0a, 0x28, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x41,
	0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49,
	0x4e, 0x47, 0x53, 0x5f, 0x43, 0x4f, 0x4c, 0x4c, 0x41, 0x42, 0x4f, 0x52, 0x41, 0x54, 0x4f, 0x52,
	0x53, 0x10, 0x12, 0x12, 0x27, 0x0a, 0x23, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x41, 0x50, 0x50,
	0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47,
	0x53, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x41, 0x47, 0x45, 0x53, 0x10, 0x38, 0x12, 0x1c, 0x0a, 0x18,
	0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x13, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x49,
	0x47, 0x48, 0x54, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x50, 0x55, 0x52, 0x47, 0x45, 0x10, 0x40, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x49, 0x47, 0x48, 0x54,
	0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x56,
	0x49, 0x43, 0x45, 0x53, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x10, 0x14, 0x12, 0x23, 0x0a, 0x1f, 0x52,
	0x49, 0x47, 0x48, 0x54, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x15,
	0x12, 0x27, 0x0a, 0x23, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f, 0x52, 0x45,
	0x41, 0x44, 0x5f, 0x4b, 0x45, 0x59, 0x53, 0x10, 0x16, 0x12, 0x28, 0x0a, 0x24, 0x52, 0x49, 0x47,
	0x48, 0x54, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44,
	0x45, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x4b, 0x45, 0x59,
	0x53, 0x10, 0x17, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x41, 0x50, 0x50,
	0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43,
	0x5f, 0x52, 0x45, 0x41, 0x44, 0x10, 0x18, 0x12, 0x26, 0x0a, 0x22, 0x52, 0x49, 0x47, 0x48, 0x54,
	0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x52, 0x41,
	0x46, 0x46, 0x49, 0x43, 0x5f, 0x55, 0x50, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x19, 0x12,
	0x28, 0x0a, 0x24, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x44, 0x4f, 0x57,
	0x4e, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x1a, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x49, 0x47,
	0x48, 0x54, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c,
	0x49, 0x4e, 0x4b, 0x10, 0x1b, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x41,
	0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x1c,
	0x12, 0x14, 0x0a, 0x10, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54,
	0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x1d, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f,
	0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x3c, 0x12, 0x1f, 0x0a,
	0x1b, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x45,
	0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x3d, 0x12, 0x27,
	0x0a, 0x23, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x53,
	0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x43, 0x4f, 0x4c, 0x4c, 0x41, 0x42, 0x4f, 0x52,
	0x41, 0x54, 0x4f, 0x52, 0x53, 0x10, 0x3e, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x49, 0x47, 0x48, 0x54,
	0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x3f,
	0x12, 0x16, 0x0a, 0x12, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54,
	0x5f, 0x50, 0x55, 0x52, 0x47, 0x45, 0x10, 0x44, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x49, 0x47, 0x48,
	0x54, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x1e,
	0x12, 0x20, 0x0a, 0x1c, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41,
	0x59, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43,
	0x10, 0x1f, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x47, 0x41, 0x54, 0x45,
	0x57, 0x41, 0x59, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x41, 0x50, 0x49,
	0x5f, 0x4b, 0x45, 0x59, 0x53, 0x10, 0x20, 0x12, 0x28, 0x0a, 0x24, 0x52, 0x49, 0x47, 0x48, 0x54,
	0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47,
	0x53, 0x5f, 0x43, 0x4f, 0x4c, 0x4c, 0x41, 0x42, 0x4f, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x53, 0x10,
	0x21, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57,
	0x41, 0x59, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x22, 0x12, 0x17, 0x0a, 0x13, 0x52,
	0x49, 0x47, 0x48, 0x54, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x5f, 0x50, 0x55, 0x52,
	0x47, 0x45, 0x10, 0x43, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x47, 0x41,
	0x54, 0x45, 0x57, 0x41, 0x59, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x52, 0x45,
	0x41, 0x44, 0x10, 0x23, 0x12, 0x24, 0x0a, 0x20, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x47, 0x41,
	0x54, 0x45, 0x57, 0x41, 0x59, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x44, 0x4f,
	0x57, 0x4e, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x24, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x49,
	0x47, 0x48, 0x54, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x5f, 0x4c, 0x49, 0x4e, 0x4b,
	0x10, 0x25, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x47, 0x41, 0x54, 0x45,
	0x57, 0x41, 0x59, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x10,
	0x26, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57,
	0x41, 0x59, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x41, 0x44,
	0x10, 0x27, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x47, 0x41, 0x54, 0x45,
	0x57, 0x41, 0x59, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54,
	0x53, 0x10, 0x39, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x47, 0x41, 0x54,
	0x45, 0x57, 0x41, 0x59, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54,
	0x53, 0x10, 0x3a, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x47, 0x41, 0x54,
	0x45, 0x57, 0x41, 0x59, 0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x28, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x49,
	0x47, 0x48, 0x54, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x29, 0x12, 0x25, 0x0a, 0x21, 0x52, 0x49, 0x47, 0x48, 0x54,
	0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x45,
	0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x2a, 0x12, 0x28,
	0x0a, 0x24, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x41, 0x50,
	0x49, 0x5f, 0x4b, 0x45, 0x59, 0x53, 0x10, 0x2b, 0x12, 0x27, 0x0a, 0x23, 0x52, 0x49, 0x47, 0x48,
	0x54, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53,
	0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52, 0x53, 0x10,
	0x2c, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e,
	0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x2d,
	0x12, 0x1c, 0x0a, 0x18, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49,
	0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x55, 0x52, 0x47, 0x45, 0x10, 0x41, 0x12, 0x28,
	0x0a, 0x24, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x53, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x2e, 0x12, 0x2a, 0x0a, 0x26, 0x52, 0x49, 0x47, 0x48,
	0x54, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41,
	0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x45, 0x10, 0x2f, 0x12, 0x24, 0x0a, 0x20, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x4f, 0x52,
	0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57,
	0x41, 0x59, 0x53, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x30, 0x12, 0x26, 0x0a, 0x22, 0x52, 0x49,
	0x47, 0x48, 0x54, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x53, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x10, 0x31, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x4f, 0x52, 0x47, 0x41,
	0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x53,
	0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x32, 0x12, 0x25, 0x0a, 0x21, 0x52, 0x49, 0x47, 0x48, 0x54,
	0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4c,
	0x49, 0x45, 0x4e, 0x54, 0x53, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x33, 0x12, 0x2a,
	0x0a, 0x26, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x44, 0x44, 0x5f, 0x41, 0x53, 0x5f, 0x43, 0x4f, 0x4c, 0x4c,
	0x41, 0x42, 0x4f, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x10, 0x34, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x49,
	0x47, 0x48, 0x54, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x35, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f,
	0x53, 0x45, 0x4e, 0x44, 0x5f, 0x49, 0x4e, 0x56, 0x49, 0x54, 0x45, 0x53, 0x10, 0x36, 0x12, 0x0d,
	0x0a, 0x09, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x37, 0x1a, 0x0d, 0xea,
	0xaa, 0x19, 0x09, 0x18, 0x01, 0x2a, 0x05, 0x52, 0x49, 0x47, 0x48, 0x54, 0x22, 0x04, 0x08, 0x45,
	0x10, 0x45, 0x22, 0x04, 0x08, 0x46, 0x10, 0x46, 0x22, 0x04, 0x08, 0x47, 0x10, 0x47, 0x22, 0x04,
	0x08, 0x48, 0x10, 0x48, 0x22, 0x04, 0x08, 0x49, 0x10, 0x49, 0x22, 0x04, 0x08, 0x4a, 0x10, 0x4a,
	0x22, 0x04, 0x08, 0x4b, 0x10, 0x4b, 0x22, 0x04, 0x08, 0x4c, 0x10, 0x4c, 0x22, 0x04, 0x08, 0x4d,
	0x10, 0x4d, 0x22, 0x04, 0x08, 0x4e, 0x10, 0x4e, 0x22, 0x04, 0x08, 0x4f, 0x10, 0x4f, 0x22, 0x04,
	0x08, 0x50, 0x10, 0x50, 0x22, 0x04, 0x08, 0x51, 0x10, 0x51, 0x22, 0x04, 0x08, 0x52, 0x10, 0x52,
	0x22, 0x04, 0x08, 0x53, 0x10, 0x53, 0x22, 0x04, 0x08, 0x54, 0x10, 0x54, 0x22, 0x04, 0x08, 0x55,
	0x10, 0x55, 0x22, 0x04, 0x08, 0x56, 0x10, 0x56, 0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76,
	0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_rights_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_rights_proto_rawDescData = file_ttn_lorawan_v3_rights_proto_rawDesc
)

func file_ttn_lorawan_v3_rights_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_rights_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_rights_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_rights_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_rights_proto_rawDescData
}

var file_ttn_lorawan_v3_rights_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_ttn_lorawan_v3_rights_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_ttn_lorawan_v3_rights_proto_goTypes = []interface{}{
	(Right)(0),                            // 0: ttn.lorawan.v3.Right
	(*Rights)(nil),                        // 1: ttn.lorawan.v3.Rights
	(*APIKey)(nil),                        // 2: ttn.lorawan.v3.APIKey
	(*APIKeys)(nil),                       // 3: ttn.lorawan.v3.APIKeys
	(*Collaborator)(nil),                  // 4: ttn.lorawan.v3.Collaborator
	(*GetCollaboratorResponse)(nil),       // 5: ttn.lorawan.v3.GetCollaboratorResponse
	(*Collaborators)(nil),                 // 6: ttn.lorawan.v3.Collaborators
	(*timestamppb.Timestamp)(nil),         // 7: google.protobuf.Timestamp
	(*OrganizationOrUserIdentifiers)(nil), // 8: ttn.lorawan.v3.OrganizationOrUserIdentifiers
}
var file_ttn_lorawan_v3_rights_proto_depIdxs = []int32{
	0,  // 0: ttn.lorawan.v3.Rights.rights:type_name -> ttn.lorawan.v3.Right
	0,  // 1: ttn.lorawan.v3.APIKey.rights:type_name -> ttn.lorawan.v3.Right
	7,  // 2: ttn.lorawan.v3.APIKey.created_at:type_name -> google.protobuf.Timestamp
	7,  // 3: ttn.lorawan.v3.APIKey.updated_at:type_name -> google.protobuf.Timestamp
	7,  // 4: ttn.lorawan.v3.APIKey.expires_at:type_name -> google.protobuf.Timestamp
	2,  // 5: ttn.lorawan.v3.APIKeys.api_keys:type_name -> ttn.lorawan.v3.APIKey
	8,  // 6: ttn.lorawan.v3.Collaborator.ids:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	0,  // 7: ttn.lorawan.v3.Collaborator.rights:type_name -> ttn.lorawan.v3.Right
	8,  // 8: ttn.lorawan.v3.GetCollaboratorResponse.ids:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	0,  // 9: ttn.lorawan.v3.GetCollaboratorResponse.rights:type_name -> ttn.lorawan.v3.Right
	4,  // 10: ttn.lorawan.v3.Collaborators.collaborators:type_name -> ttn.lorawan.v3.Collaborator
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_rights_proto_init() }
func file_ttn_lorawan_v3_rights_proto_init() {
	if File_ttn_lorawan_v3_rights_proto != nil {
		return
	}
	file_ttn_lorawan_v3_identifiers_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_rights_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rights); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_rights_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*APIKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_rights_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*APIKeys); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_rights_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Collaborator); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_rights_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCollaboratorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_rights_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Collaborators); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_rights_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ttn_lorawan_v3_rights_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_rights_proto_depIdxs,
		EnumInfos:         file_ttn_lorawan_v3_rights_proto_enumTypes,
		MessageInfos:      file_ttn_lorawan_v3_rights_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_rights_proto = out.File
	file_ttn_lorawan_v3_rights_proto_rawDesc = nil
	file_ttn_lorawan_v3_rights_proto_goTypes = nil
	file_ttn_lorawan_v3_rights_proto_depIdxs = nil
}
