// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/regional.proto

package ttnpb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ConcentratorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Channels            []*ConcentratorConfig_Channel           `protobuf:"bytes,1,rep,name=channels,proto3" json:"channels,omitempty"`
	LoraStandardChannel *ConcentratorConfig_LoRaStandardChannel `protobuf:"bytes,2,opt,name=lora_standard_channel,json=loraStandardChannel,proto3" json:"lora_standard_channel,omitempty"`
	FskChannel          *ConcentratorConfig_FSKChannel          `protobuf:"bytes,3,opt,name=fsk_channel,json=fskChannel,proto3" json:"fsk_channel,omitempty"`
	Lbt                 *ConcentratorConfig_LBTConfiguration    `protobuf:"bytes,4,opt,name=lbt,proto3" json:"lbt,omitempty"`
	PingSlot            *ConcentratorConfig_Channel             `protobuf:"bytes,5,opt,name=ping_slot,json=pingSlot,proto3" json:"ping_slot,omitempty"`
	Radios              []*GatewayRadio                         `protobuf:"bytes,6,rep,name=radios,proto3" json:"radios,omitempty"`
	ClockSource         uint32                                  `protobuf:"varint,7,opt,name=clock_source,json=clockSource,proto3" json:"clock_source,omitempty"`
}

func (x *ConcentratorConfig) Reset() {
	*x = ConcentratorConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_regional_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConcentratorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConcentratorConfig) ProtoMessage() {}

func (x *ConcentratorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_regional_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConcentratorConfig.ProtoReflect.Descriptor instead.
func (*ConcentratorConfig) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_regional_proto_rawDescGZIP(), []int{0}
}

func (x *ConcentratorConfig) GetChannels() []*ConcentratorConfig_Channel {
	if x != nil {
		return x.Channels
	}
	return nil
}

func (x *ConcentratorConfig) GetLoraStandardChannel() *ConcentratorConfig_LoRaStandardChannel {
	if x != nil {
		return x.LoraStandardChannel
	}
	return nil
}

func (x *ConcentratorConfig) GetFskChannel() *ConcentratorConfig_FSKChannel {
	if x != nil {
		return x.FskChannel
	}
	return nil
}

func (x *ConcentratorConfig) GetLbt() *ConcentratorConfig_LBTConfiguration {
	if x != nil {
		return x.Lbt
	}
	return nil
}

func (x *ConcentratorConfig) GetPingSlot() *ConcentratorConfig_Channel {
	if x != nil {
		return x.PingSlot
	}
	return nil
}

func (x *ConcentratorConfig) GetRadios() []*GatewayRadio {
	if x != nil {
		return x.Radios
	}
	return nil
}

func (x *ConcentratorConfig) GetClockSource() uint32 {
	if x != nil {
		return x.ClockSource
	}
	return 0
}

type ConcentratorConfig_Channel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Frequency (Hz).
	Frequency uint64 `protobuf:"varint,1,opt,name=frequency,proto3" json:"frequency,omitempty"`
	Radio     uint32 `protobuf:"varint,2,opt,name=radio,proto3" json:"radio,omitempty"`
}

func (x *ConcentratorConfig_Channel) Reset() {
	*x = ConcentratorConfig_Channel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_regional_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConcentratorConfig_Channel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConcentratorConfig_Channel) ProtoMessage() {}

func (x *ConcentratorConfig_Channel) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_regional_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConcentratorConfig_Channel.ProtoReflect.Descriptor instead.
func (*ConcentratorConfig_Channel) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_regional_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ConcentratorConfig_Channel) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *ConcentratorConfig_Channel) GetRadio() uint32 {
	if x != nil {
		return x.Radio
	}
	return 0
}

type ConcentratorConfig_LoRaStandardChannel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Frequency (Hz).
	Frequency uint64 `protobuf:"varint,1,opt,name=frequency,proto3" json:"frequency,omitempty"`
	Radio     uint32 `protobuf:"varint,2,opt,name=radio,proto3" json:"radio,omitempty"`
	// Bandwidth (Hz).
	Bandwidth       uint32 `protobuf:"varint,3,opt,name=bandwidth,proto3" json:"bandwidth,omitempty"`
	SpreadingFactor uint32 `protobuf:"varint,4,opt,name=spreading_factor,json=spreadingFactor,proto3" json:"spreading_factor,omitempty"`
}

func (x *ConcentratorConfig_LoRaStandardChannel) Reset() {
	*x = ConcentratorConfig_LoRaStandardChannel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_regional_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConcentratorConfig_LoRaStandardChannel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConcentratorConfig_LoRaStandardChannel) ProtoMessage() {}

func (x *ConcentratorConfig_LoRaStandardChannel) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_regional_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConcentratorConfig_LoRaStandardChannel.ProtoReflect.Descriptor instead.
func (*ConcentratorConfig_LoRaStandardChannel) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_regional_proto_rawDescGZIP(), []int{0, 1}
}

func (x *ConcentratorConfig_LoRaStandardChannel) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *ConcentratorConfig_LoRaStandardChannel) GetRadio() uint32 {
	if x != nil {
		return x.Radio
	}
	return 0
}

func (x *ConcentratorConfig_LoRaStandardChannel) GetBandwidth() uint32 {
	if x != nil {
		return x.Bandwidth
	}
	return 0
}

func (x *ConcentratorConfig_LoRaStandardChannel) GetSpreadingFactor() uint32 {
	if x != nil {
		return x.SpreadingFactor
	}
	return 0
}

type ConcentratorConfig_FSKChannel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Frequency (Hz).
	Frequency uint64 `protobuf:"varint,1,opt,name=frequency,proto3" json:"frequency,omitempty"`
	Radio     uint32 `protobuf:"varint,2,opt,name=radio,proto3" json:"radio,omitempty"`
}

func (x *ConcentratorConfig_FSKChannel) Reset() {
	*x = ConcentratorConfig_FSKChannel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_regional_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConcentratorConfig_FSKChannel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConcentratorConfig_FSKChannel) ProtoMessage() {}

func (x *ConcentratorConfig_FSKChannel) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_regional_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConcentratorConfig_FSKChannel.ProtoReflect.Descriptor instead.
func (*ConcentratorConfig_FSKChannel) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_regional_proto_rawDescGZIP(), []int{0, 2}
}

func (x *ConcentratorConfig_FSKChannel) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *ConcentratorConfig_FSKChannel) GetRadio() uint32 {
	if x != nil {
		return x.Radio
	}
	return 0
}

type ConcentratorConfig_LBTConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Received signal strength (dBm).
	RssiTarget float32 `protobuf:"fixed32,1,opt,name=rssi_target,json=rssiTarget,proto3" json:"rssi_target,omitempty"`
	// Received signal strength offset (dBm).
	RssiOffset float32              `protobuf:"fixed32,2,opt,name=rssi_offset,json=rssiOffset,proto3" json:"rssi_offset,omitempty"`
	ScanTime   *durationpb.Duration `protobuf:"bytes,3,opt,name=scan_time,json=scanTime,proto3" json:"scan_time,omitempty"`
}

func (x *ConcentratorConfig_LBTConfiguration) Reset() {
	*x = ConcentratorConfig_LBTConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_regional_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConcentratorConfig_LBTConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConcentratorConfig_LBTConfiguration) ProtoMessage() {}

func (x *ConcentratorConfig_LBTConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_regional_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConcentratorConfig_LBTConfiguration.ProtoReflect.Descriptor instead.
func (*ConcentratorConfig_LBTConfiguration) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_regional_proto_rawDescGZIP(), []int{0, 3}
}

func (x *ConcentratorConfig_LBTConfiguration) GetRssiTarget() float32 {
	if x != nil {
		return x.RssiTarget
	}
	return 0
}

func (x *ConcentratorConfig_LBTConfiguration) GetRssiOffset() float32 {
	if x != nil {
		return x.RssiOffset
	}
	return 0
}

func (x *ConcentratorConfig_LBTConfiguration) GetScanTime() *durationpb.Duration {
	if x != nil {
		return x.ScanTime
	}
	return nil
}

var File_ttn_lorawan_v3_regional_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_regional_proto_rawDesc = []byte{
	0x0a, 0x1d, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x0e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa6, 0x07,
	0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x46, 0x0a, 0x08, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x52, 0x08, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x6a, 0x0a, 0x15,
	0x6c, 0x6f, 0x72, 0x61, 0x5f, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4c, 0x6f, 0x52, 0x61, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x52, 0x13, 0x6c, 0x6f, 0x72, 0x61, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72,
	0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x4e, 0x0a, 0x0b, 0x66, 0x73, 0x6b, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x46, 0x53, 0x4b, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x0a, 0x66, 0x73,
	0x6b, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x45, 0x0a, 0x03, 0x6c, 0x62, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x42, 0x54, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x03, 0x6c, 0x62, 0x74, 0x12,
	0x47, 0x0a, 0x09, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x08,
	0x70, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x12, 0x34, 0x0a, 0x06, 0x72, 0x61, 0x64, 0x69,
	0x6f, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x52, 0x61, 0x64, 0x69, 0x6f, 0x52, 0x06, 0x72, 0x61, 0x64, 0x69, 0x6f, 0x73, 0x12, 0x21,
	0x0a, 0x0c, 0x63, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x63, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x1a, 0x3d, 0x0a, 0x07, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x1c, 0x0a, 0x09,
	0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x72, 0x61,
	0x64, 0x69, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x72, 0x61, 0x64, 0x69, 0x6f,
	0x1a, 0x92, 0x01, 0x0a, 0x13, 0x4c, 0x6f, 0x52, 0x61, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72,
	0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x66, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x72, 0x61, 0x64, 0x69, 0x6f, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x72, 0x61, 0x64, 0x69, 0x6f, 0x12, 0x1c, 0x0a, 0x09,
	0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x09, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x70,
	0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x73, 0x70, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x46,
	0x61, 0x63, 0x74, 0x6f, 0x72, 0x1a, 0x40, 0x0a, 0x0a, 0x46, 0x53, 0x4b, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x72, 0x61, 0x64, 0x69, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x05, 0x72, 0x61, 0x64, 0x69, 0x6f, 0x1a, 0x8c, 0x01, 0x0a, 0x10, 0x4c, 0x42, 0x54, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b,
	0x72, 0x73, 0x73, 0x69, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x0a, 0x72, 0x73, 0x73, 0x69, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x1f, 0x0a,
	0x0b, 0x72, 0x73, 0x73, 0x69, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x0a, 0x72, 0x73, 0x73, 0x69, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x36,
	0x0a, 0x09, 0x73, 0x63, 0x61, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x73, 0x63,
	0x61, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65,
	0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f,
	0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_ttn_lorawan_v3_regional_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_regional_proto_rawDescData = file_ttn_lorawan_v3_regional_proto_rawDesc
)

func file_ttn_lorawan_v3_regional_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_regional_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_regional_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_regional_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_regional_proto_rawDescData
}

var file_ttn_lorawan_v3_regional_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_ttn_lorawan_v3_regional_proto_goTypes = []interface{}{
	(*ConcentratorConfig)(nil),                     // 0: ttn.lorawan.v3.ConcentratorConfig
	(*ConcentratorConfig_Channel)(nil),             // 1: ttn.lorawan.v3.ConcentratorConfig.Channel
	(*ConcentratorConfig_LoRaStandardChannel)(nil), // 2: ttn.lorawan.v3.ConcentratorConfig.LoRaStandardChannel
	(*ConcentratorConfig_FSKChannel)(nil),          // 3: ttn.lorawan.v3.ConcentratorConfig.FSKChannel
	(*ConcentratorConfig_LBTConfiguration)(nil),    // 4: ttn.lorawan.v3.ConcentratorConfig.LBTConfiguration
	(*GatewayRadio)(nil),                           // 5: ttn.lorawan.v3.GatewayRadio
	(*durationpb.Duration)(nil),                    // 6: google.protobuf.Duration
}
var file_ttn_lorawan_v3_regional_proto_depIdxs = []int32{
	1, // 0: ttn.lorawan.v3.ConcentratorConfig.channels:type_name -> ttn.lorawan.v3.ConcentratorConfig.Channel
	2, // 1: ttn.lorawan.v3.ConcentratorConfig.lora_standard_channel:type_name -> ttn.lorawan.v3.ConcentratorConfig.LoRaStandardChannel
	3, // 2: ttn.lorawan.v3.ConcentratorConfig.fsk_channel:type_name -> ttn.lorawan.v3.ConcentratorConfig.FSKChannel
	4, // 3: ttn.lorawan.v3.ConcentratorConfig.lbt:type_name -> ttn.lorawan.v3.ConcentratorConfig.LBTConfiguration
	1, // 4: ttn.lorawan.v3.ConcentratorConfig.ping_slot:type_name -> ttn.lorawan.v3.ConcentratorConfig.Channel
	5, // 5: ttn.lorawan.v3.ConcentratorConfig.radios:type_name -> ttn.lorawan.v3.GatewayRadio
	6, // 6: ttn.lorawan.v3.ConcentratorConfig.LBTConfiguration.scan_time:type_name -> google.protobuf.Duration
	7, // [7:7] is the sub-list for method output_type
	7, // [7:7] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_regional_proto_init() }
func file_ttn_lorawan_v3_regional_proto_init() {
	if File_ttn_lorawan_v3_regional_proto != nil {
		return
	}
	file_ttn_lorawan_v3_gateway_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_regional_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConcentratorConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_regional_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConcentratorConfig_Channel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_regional_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConcentratorConfig_LoRaStandardChannel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_regional_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConcentratorConfig_FSKChannel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_regional_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConcentratorConfig_LBTConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_regional_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ttn_lorawan_v3_regional_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_regional_proto_depIdxs,
		MessageInfos:      file_ttn_lorawan_v3_regional_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_regional_proto = out.File
	file_ttn_lorawan_v3_regional_proto_rawDesc = nil
	file_ttn_lorawan_v3_regional_proto_goTypes = nil
	file_ttn_lorawan_v3_regional_proto_depIdxs = nil
}
