// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on Picture with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *Picture) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PictureFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "embedded":

			if v, ok := interface{}(m.GetEmbedded()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PictureValidationError{
						field:  "embedded",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "sizes":

			for key, val := range m.GetSizes() {
				_ = val

				// no validation rules for Sizes[key]

				if _, err := url.Parse(val); err != nil {
					return PictureValidationError{
						field:  fmt.Sprintf("sizes[%v]", key),
						reason: "value must be a valid URI",
						cause:  err,
					}
				}

			}

		default:
			return PictureValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PictureValidationError is the validation error returned by
// Picture.ValidateFields if the designated constraints aren't met.
type PictureValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PictureValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PictureValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PictureValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PictureValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PictureValidationError) ErrorName() string { return "PictureValidationError" }

// Error satisfies the builtin error interface
func (e PictureValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPicture.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PictureValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PictureValidationError{}

// ValidateFields checks the field values on Picture_Embedded with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *Picture_Embedded) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = Picture_EmbeddedFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "mime_type":

			if utf8.RuneCountInString(m.GetMimeType()) > 32 {
				return Picture_EmbeddedValidationError{
					field:  "mime_type",
					reason: "value length must be at most 32 runes",
				}
			}

		case "data":

			if len(m.GetData()) > 8388608 {
				return Picture_EmbeddedValidationError{
					field:  "data",
					reason: "value length must be at most 8388608 bytes",
				}
			}

		default:
			return Picture_EmbeddedValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// Picture_EmbeddedValidationError is the validation error returned by
// Picture_Embedded.ValidateFields if the designated constraints aren't met.
type Picture_EmbeddedValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Picture_EmbeddedValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Picture_EmbeddedValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Picture_EmbeddedValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Picture_EmbeddedValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Picture_EmbeddedValidationError) ErrorName() string { return "Picture_EmbeddedValidationError" }

// Error satisfies the builtin error interface
func (e Picture_EmbeddedValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPicture_Embedded.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Picture_EmbeddedValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Picture_EmbeddedValidationError{}
