// Copyright © 2021 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.1
// source: ttn/lorawan/v3/packetbrokeragent.proto

package ttnpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	GsPba_PublishUplink_FullMethodName = "/ttn.lorawan.v3.GsPba/PublishUplink"
	GsPba_UpdateGateway_FullMethodName = "/ttn.lorawan.v3.GsPba/UpdateGateway"
)

// GsPbaClient is the client API for GsPba service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GsPbaClient interface {
	PublishUplink(ctx context.Context, in *GatewayUplinkMessage, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Update the gateway, changing the fields specified by the field mask to the provided values.
	// To mark a gateway as online, call this rpc setting online to true, include status_public in field_mask and
	// keep calling this rpc before the returned online_ttl passes to keep the gateway online.
	UpdateGateway(ctx context.Context, in *UpdatePacketBrokerGatewayRequest, opts ...grpc.CallOption) (*UpdatePacketBrokerGatewayResponse, error)
}

type gsPbaClient struct {
	cc grpc.ClientConnInterface
}

func NewGsPbaClient(cc grpc.ClientConnInterface) GsPbaClient {
	return &gsPbaClient{cc}
}

func (c *gsPbaClient) PublishUplink(ctx context.Context, in *GatewayUplinkMessage, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, GsPba_PublishUplink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gsPbaClient) UpdateGateway(ctx context.Context, in *UpdatePacketBrokerGatewayRequest, opts ...grpc.CallOption) (*UpdatePacketBrokerGatewayResponse, error) {
	out := new(UpdatePacketBrokerGatewayResponse)
	err := c.cc.Invoke(ctx, GsPba_UpdateGateway_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GsPbaServer is the server API for GsPba service.
// All implementations must embed UnimplementedGsPbaServer
// for forward compatibility
type GsPbaServer interface {
	PublishUplink(context.Context, *GatewayUplinkMessage) (*emptypb.Empty, error)
	// Update the gateway, changing the fields specified by the field mask to the provided values.
	// To mark a gateway as online, call this rpc setting online to true, include status_public in field_mask and
	// keep calling this rpc before the returned online_ttl passes to keep the gateway online.
	UpdateGateway(context.Context, *UpdatePacketBrokerGatewayRequest) (*UpdatePacketBrokerGatewayResponse, error)
	mustEmbedUnimplementedGsPbaServer()
}

// UnimplementedGsPbaServer must be embedded to have forward compatible implementations.
type UnimplementedGsPbaServer struct {
}

func (UnimplementedGsPbaServer) PublishUplink(context.Context, *GatewayUplinkMessage) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PublishUplink not implemented")
}
func (UnimplementedGsPbaServer) UpdateGateway(context.Context, *UpdatePacketBrokerGatewayRequest) (*UpdatePacketBrokerGatewayResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGateway not implemented")
}
func (UnimplementedGsPbaServer) mustEmbedUnimplementedGsPbaServer() {}

// UnsafeGsPbaServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GsPbaServer will
// result in compilation errors.
type UnsafeGsPbaServer interface {
	mustEmbedUnimplementedGsPbaServer()
}

func RegisterGsPbaServer(s grpc.ServiceRegistrar, srv GsPbaServer) {
	s.RegisterService(&GsPba_ServiceDesc, srv)
}

func _GsPba_PublishUplink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GatewayUplinkMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GsPbaServer).PublishUplink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GsPba_PublishUplink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GsPbaServer).PublishUplink(ctx, req.(*GatewayUplinkMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _GsPba_UpdateGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePacketBrokerGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GsPbaServer).UpdateGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GsPba_UpdateGateway_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GsPbaServer).UpdateGateway(ctx, req.(*UpdatePacketBrokerGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GsPba_ServiceDesc is the grpc.ServiceDesc for GsPba service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GsPba_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.GsPba",
	HandlerType: (*GsPbaServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "PublishUplink",
			Handler:    _GsPba_PublishUplink_Handler,
		},
		{
			MethodName: "UpdateGateway",
			Handler:    _GsPba_UpdateGateway_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/packetbrokeragent.proto",
}

const (
	NsPba_PublishDownlink_FullMethodName = "/ttn.lorawan.v3.NsPba/PublishDownlink"
)

// NsPbaClient is the client API for NsPba service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NsPbaClient interface {
	// PublishDownlink instructs the Packet Broker Agent to publish a downlink
	// message to Packet Broker Router.
	PublishDownlink(ctx context.Context, in *DownlinkMessage, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type nsPbaClient struct {
	cc grpc.ClientConnInterface
}

func NewNsPbaClient(cc grpc.ClientConnInterface) NsPbaClient {
	return &nsPbaClient{cc}
}

func (c *nsPbaClient) PublishDownlink(ctx context.Context, in *DownlinkMessage, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, NsPba_PublishDownlink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NsPbaServer is the server API for NsPba service.
// All implementations must embed UnimplementedNsPbaServer
// for forward compatibility
type NsPbaServer interface {
	// PublishDownlink instructs the Packet Broker Agent to publish a downlink
	// message to Packet Broker Router.
	PublishDownlink(context.Context, *DownlinkMessage) (*emptypb.Empty, error)
	mustEmbedUnimplementedNsPbaServer()
}

// UnimplementedNsPbaServer must be embedded to have forward compatible implementations.
type UnimplementedNsPbaServer struct {
}

func (UnimplementedNsPbaServer) PublishDownlink(context.Context, *DownlinkMessage) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PublishDownlink not implemented")
}
func (UnimplementedNsPbaServer) mustEmbedUnimplementedNsPbaServer() {}

// UnsafeNsPbaServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NsPbaServer will
// result in compilation errors.
type UnsafeNsPbaServer interface {
	mustEmbedUnimplementedNsPbaServer()
}

func RegisterNsPbaServer(s grpc.ServiceRegistrar, srv NsPbaServer) {
	s.RegisterService(&NsPba_ServiceDesc, srv)
}

func _NsPba_PublishDownlink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DownlinkMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NsPbaServer).PublishDownlink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NsPba_PublishDownlink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NsPbaServer).PublishDownlink(ctx, req.(*DownlinkMessage))
	}
	return interceptor(ctx, in, info, handler)
}

// NsPba_ServiceDesc is the grpc.ServiceDesc for NsPba service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NsPba_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.NsPba",
	HandlerType: (*NsPbaServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "PublishDownlink",
			Handler:    _NsPba_PublishDownlink_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/packetbrokeragent.proto",
}

const (
	Pba_GetInfo_FullMethodName                                   = "/ttn.lorawan.v3.Pba/GetInfo"
	Pba_Register_FullMethodName                                  = "/ttn.lorawan.v3.Pba/Register"
	Pba_Deregister_FullMethodName                                = "/ttn.lorawan.v3.Pba/Deregister"
	Pba_ListHomeNetworkRoutingPolicies_FullMethodName            = "/ttn.lorawan.v3.Pba/ListHomeNetworkRoutingPolicies"
	Pba_GetHomeNetworkRoutingPolicy_FullMethodName               = "/ttn.lorawan.v3.Pba/GetHomeNetworkRoutingPolicy"
	Pba_SetHomeNetworkRoutingPolicy_FullMethodName               = "/ttn.lorawan.v3.Pba/SetHomeNetworkRoutingPolicy"
	Pba_DeleteHomeNetworkRoutingPolicy_FullMethodName            = "/ttn.lorawan.v3.Pba/DeleteHomeNetworkRoutingPolicy"
	Pba_GetHomeNetworkDefaultRoutingPolicy_FullMethodName        = "/ttn.lorawan.v3.Pba/GetHomeNetworkDefaultRoutingPolicy"
	Pba_SetHomeNetworkDefaultRoutingPolicy_FullMethodName        = "/ttn.lorawan.v3.Pba/SetHomeNetworkDefaultRoutingPolicy"
	Pba_DeleteHomeNetworkDefaultRoutingPolicy_FullMethodName     = "/ttn.lorawan.v3.Pba/DeleteHomeNetworkDefaultRoutingPolicy"
	Pba_GetHomeNetworkDefaultGatewayVisibility_FullMethodName    = "/ttn.lorawan.v3.Pba/GetHomeNetworkDefaultGatewayVisibility"
	Pba_SetHomeNetworkDefaultGatewayVisibility_FullMethodName    = "/ttn.lorawan.v3.Pba/SetHomeNetworkDefaultGatewayVisibility"
	Pba_DeleteHomeNetworkDefaultGatewayVisibility_FullMethodName = "/ttn.lorawan.v3.Pba/DeleteHomeNetworkDefaultGatewayVisibility"
	Pba_ListNetworks_FullMethodName                              = "/ttn.lorawan.v3.Pba/ListNetworks"
	Pba_ListHomeNetworks_FullMethodName                          = "/ttn.lorawan.v3.Pba/ListHomeNetworks"
	Pba_ListForwarderRoutingPolicies_FullMethodName              = "/ttn.lorawan.v3.Pba/ListForwarderRoutingPolicies"
)

// PbaClient is the client API for Pba service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PbaClient interface {
	// Get information about the Packet Broker registration.
	// Viewing Packet Packet information requires administrative access.
	GetInfo(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*PacketBrokerInfo, error)
	// Register with Packet Broker. If no registration exists, it will be created. Any existing registration will be updated.
	// Registration settings not in the request message are taken from Packet Broker Agent configuration and caller context.
	// Packet Broker registration requires administrative access.
	// Packet Broker registration is only supported for tenants and requires Packet Broker Agent to be configured with
	// NetID level authentication. Use rpc GetInfo and check register_enabled to check whether this rpc is enabled.
	Register(ctx context.Context, in *PacketBrokerRegisterRequest, opts ...grpc.CallOption) (*PacketBrokerNetwork, error)
	// Deregister from Packet Broker.
	// Packet Broker deregistration requires administrative access.
	// Packet Broker deregistration is only supported for tenants and requires Packet Broker Agent to be configured with
	// NetID level authentication. Use rpc GetInfo and check register_enabled to check whether this rpc is enabled.
	Deregister(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List the routing policies that Packet Broker Agent as Forwarder configured with Home Networks.
	// Listing routing policies requires administrative access.
	ListHomeNetworkRoutingPolicies(ctx context.Context, in *ListHomeNetworkRoutingPoliciesRequest, opts ...grpc.CallOption) (*PacketBrokerRoutingPolicies, error)
	// Get the routing policy for the given Home Network.
	// Getting routing policies requires administrative access.
	GetHomeNetworkRoutingPolicy(ctx context.Context, in *PacketBrokerNetworkIdentifier, opts ...grpc.CallOption) (*PacketBrokerRoutingPolicy, error)
	// Set the routing policy for the given Home Network.
	// Setting routing policies requires administrative access.
	SetHomeNetworkRoutingPolicy(ctx context.Context, in *SetPacketBrokerRoutingPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Delete the routing policy for the given Home Network.
	// Deleting routing policies requires administrative access.
	DeleteHomeNetworkRoutingPolicy(ctx context.Context, in *PacketBrokerNetworkIdentifier, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Get the default routing policy.
	// Getting routing policies requires administrative access.
	GetHomeNetworkDefaultRoutingPolicy(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*PacketBrokerDefaultRoutingPolicy, error)
	// Set the default routing policy.
	// Setting routing policies requires administrative access.
	SetHomeNetworkDefaultRoutingPolicy(ctx context.Context, in *SetPacketBrokerDefaultRoutingPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes the default routing policy.
	// Deleting routing policies requires administrative access.
	DeleteHomeNetworkDefaultRoutingPolicy(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Get the default gateway visibility.
	// Getting gateway visibilities requires administrative access.
	GetHomeNetworkDefaultGatewayVisibility(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*PacketBrokerDefaultGatewayVisibility, error)
	// Set the default gateway visibility.
	// Setting gateway visibilities requires administrative access.
	SetHomeNetworkDefaultGatewayVisibility(ctx context.Context, in *SetPacketBrokerDefaultGatewayVisibilityRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes the default gateway visibility.
	// Deleting gateway visibilities requires administrative access.
	DeleteHomeNetworkDefaultGatewayVisibility(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List all listed networks.
	// Listing networks requires administrative access.
	ListNetworks(ctx context.Context, in *ListPacketBrokerNetworksRequest, opts ...grpc.CallOption) (*PacketBrokerNetworks, error)
	// List the listed home networks for which routing policies can be configured.
	// Listing home networks requires administrative access.
	ListHomeNetworks(ctx context.Context, in *ListPacketBrokerHomeNetworksRequest, opts ...grpc.CallOption) (*PacketBrokerNetworks, error)
	// List the routing policies that Forwarders configured with Packet Broker Agent as Home Network.
	// Listing routing policies requires administrative access.
	ListForwarderRoutingPolicies(ctx context.Context, in *ListForwarderRoutingPoliciesRequest, opts ...grpc.CallOption) (*PacketBrokerRoutingPolicies, error)
}

type pbaClient struct {
	cc grpc.ClientConnInterface
}

func NewPbaClient(cc grpc.ClientConnInterface) PbaClient {
	return &pbaClient{cc}
}

func (c *pbaClient) GetInfo(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*PacketBrokerInfo, error) {
	out := new(PacketBrokerInfo)
	err := c.cc.Invoke(ctx, Pba_GetInfo_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) Register(ctx context.Context, in *PacketBrokerRegisterRequest, opts ...grpc.CallOption) (*PacketBrokerNetwork, error) {
	out := new(PacketBrokerNetwork)
	err := c.cc.Invoke(ctx, Pba_Register_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) Deregister(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Pba_Deregister_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) ListHomeNetworkRoutingPolicies(ctx context.Context, in *ListHomeNetworkRoutingPoliciesRequest, opts ...grpc.CallOption) (*PacketBrokerRoutingPolicies, error) {
	out := new(PacketBrokerRoutingPolicies)
	err := c.cc.Invoke(ctx, Pba_ListHomeNetworkRoutingPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) GetHomeNetworkRoutingPolicy(ctx context.Context, in *PacketBrokerNetworkIdentifier, opts ...grpc.CallOption) (*PacketBrokerRoutingPolicy, error) {
	out := new(PacketBrokerRoutingPolicy)
	err := c.cc.Invoke(ctx, Pba_GetHomeNetworkRoutingPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) SetHomeNetworkRoutingPolicy(ctx context.Context, in *SetPacketBrokerRoutingPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Pba_SetHomeNetworkRoutingPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) DeleteHomeNetworkRoutingPolicy(ctx context.Context, in *PacketBrokerNetworkIdentifier, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Pba_DeleteHomeNetworkRoutingPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) GetHomeNetworkDefaultRoutingPolicy(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*PacketBrokerDefaultRoutingPolicy, error) {
	out := new(PacketBrokerDefaultRoutingPolicy)
	err := c.cc.Invoke(ctx, Pba_GetHomeNetworkDefaultRoutingPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) SetHomeNetworkDefaultRoutingPolicy(ctx context.Context, in *SetPacketBrokerDefaultRoutingPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Pba_SetHomeNetworkDefaultRoutingPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) DeleteHomeNetworkDefaultRoutingPolicy(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Pba_DeleteHomeNetworkDefaultRoutingPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) GetHomeNetworkDefaultGatewayVisibility(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*PacketBrokerDefaultGatewayVisibility, error) {
	out := new(PacketBrokerDefaultGatewayVisibility)
	err := c.cc.Invoke(ctx, Pba_GetHomeNetworkDefaultGatewayVisibility_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) SetHomeNetworkDefaultGatewayVisibility(ctx context.Context, in *SetPacketBrokerDefaultGatewayVisibilityRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Pba_SetHomeNetworkDefaultGatewayVisibility_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) DeleteHomeNetworkDefaultGatewayVisibility(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Pba_DeleteHomeNetworkDefaultGatewayVisibility_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) ListNetworks(ctx context.Context, in *ListPacketBrokerNetworksRequest, opts ...grpc.CallOption) (*PacketBrokerNetworks, error) {
	out := new(PacketBrokerNetworks)
	err := c.cc.Invoke(ctx, Pba_ListNetworks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) ListHomeNetworks(ctx context.Context, in *ListPacketBrokerHomeNetworksRequest, opts ...grpc.CallOption) (*PacketBrokerNetworks, error) {
	out := new(PacketBrokerNetworks)
	err := c.cc.Invoke(ctx, Pba_ListHomeNetworks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pbaClient) ListForwarderRoutingPolicies(ctx context.Context, in *ListForwarderRoutingPoliciesRequest, opts ...grpc.CallOption) (*PacketBrokerRoutingPolicies, error) {
	out := new(PacketBrokerRoutingPolicies)
	err := c.cc.Invoke(ctx, Pba_ListForwarderRoutingPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PbaServer is the server API for Pba service.
// All implementations must embed UnimplementedPbaServer
// for forward compatibility
type PbaServer interface {
	// Get information about the Packet Broker registration.
	// Viewing Packet Packet information requires administrative access.
	GetInfo(context.Context, *emptypb.Empty) (*PacketBrokerInfo, error)
	// Register with Packet Broker. If no registration exists, it will be created. Any existing registration will be updated.
	// Registration settings not in the request message are taken from Packet Broker Agent configuration and caller context.
	// Packet Broker registration requires administrative access.
	// Packet Broker registration is only supported for tenants and requires Packet Broker Agent to be configured with
	// NetID level authentication. Use rpc GetInfo and check register_enabled to check whether this rpc is enabled.
	Register(context.Context, *PacketBrokerRegisterRequest) (*PacketBrokerNetwork, error)
	// Deregister from Packet Broker.
	// Packet Broker deregistration requires administrative access.
	// Packet Broker deregistration is only supported for tenants and requires Packet Broker Agent to be configured with
	// NetID level authentication. Use rpc GetInfo and check register_enabled to check whether this rpc is enabled.
	Deregister(context.Context, *emptypb.Empty) (*emptypb.Empty, error)
	// List the routing policies that Packet Broker Agent as Forwarder configured with Home Networks.
	// Listing routing policies requires administrative access.
	ListHomeNetworkRoutingPolicies(context.Context, *ListHomeNetworkRoutingPoliciesRequest) (*PacketBrokerRoutingPolicies, error)
	// Get the routing policy for the given Home Network.
	// Getting routing policies requires administrative access.
	GetHomeNetworkRoutingPolicy(context.Context, *PacketBrokerNetworkIdentifier) (*PacketBrokerRoutingPolicy, error)
	// Set the routing policy for the given Home Network.
	// Setting routing policies requires administrative access.
	SetHomeNetworkRoutingPolicy(context.Context, *SetPacketBrokerRoutingPolicyRequest) (*emptypb.Empty, error)
	// Delete the routing policy for the given Home Network.
	// Deleting routing policies requires administrative access.
	DeleteHomeNetworkRoutingPolicy(context.Context, *PacketBrokerNetworkIdentifier) (*emptypb.Empty, error)
	// Get the default routing policy.
	// Getting routing policies requires administrative access.
	GetHomeNetworkDefaultRoutingPolicy(context.Context, *emptypb.Empty) (*PacketBrokerDefaultRoutingPolicy, error)
	// Set the default routing policy.
	// Setting routing policies requires administrative access.
	SetHomeNetworkDefaultRoutingPolicy(context.Context, *SetPacketBrokerDefaultRoutingPolicyRequest) (*emptypb.Empty, error)
	// Deletes the default routing policy.
	// Deleting routing policies requires administrative access.
	DeleteHomeNetworkDefaultRoutingPolicy(context.Context, *emptypb.Empty) (*emptypb.Empty, error)
	// Get the default gateway visibility.
	// Getting gateway visibilities requires administrative access.
	GetHomeNetworkDefaultGatewayVisibility(context.Context, *emptypb.Empty) (*PacketBrokerDefaultGatewayVisibility, error)
	// Set the default gateway visibility.
	// Setting gateway visibilities requires administrative access.
	SetHomeNetworkDefaultGatewayVisibility(context.Context, *SetPacketBrokerDefaultGatewayVisibilityRequest) (*emptypb.Empty, error)
	// Deletes the default gateway visibility.
	// Deleting gateway visibilities requires administrative access.
	DeleteHomeNetworkDefaultGatewayVisibility(context.Context, *emptypb.Empty) (*emptypb.Empty, error)
	// List all listed networks.
	// Listing networks requires administrative access.
	ListNetworks(context.Context, *ListPacketBrokerNetworksRequest) (*PacketBrokerNetworks, error)
	// List the listed home networks for which routing policies can be configured.
	// Listing home networks requires administrative access.
	ListHomeNetworks(context.Context, *ListPacketBrokerHomeNetworksRequest) (*PacketBrokerNetworks, error)
	// List the routing policies that Forwarders configured with Packet Broker Agent as Home Network.
	// Listing routing policies requires administrative access.
	ListForwarderRoutingPolicies(context.Context, *ListForwarderRoutingPoliciesRequest) (*PacketBrokerRoutingPolicies, error)
	mustEmbedUnimplementedPbaServer()
}

// UnimplementedPbaServer must be embedded to have forward compatible implementations.
type UnimplementedPbaServer struct {
}

func (UnimplementedPbaServer) GetInfo(context.Context, *emptypb.Empty) (*PacketBrokerInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInfo not implemented")
}
func (UnimplementedPbaServer) Register(context.Context, *PacketBrokerRegisterRequest) (*PacketBrokerNetwork, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Register not implemented")
}
func (UnimplementedPbaServer) Deregister(context.Context, *emptypb.Empty) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Deregister not implemented")
}
func (UnimplementedPbaServer) ListHomeNetworkRoutingPolicies(context.Context, *ListHomeNetworkRoutingPoliciesRequest) (*PacketBrokerRoutingPolicies, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHomeNetworkRoutingPolicies not implemented")
}
func (UnimplementedPbaServer) GetHomeNetworkRoutingPolicy(context.Context, *PacketBrokerNetworkIdentifier) (*PacketBrokerRoutingPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHomeNetworkRoutingPolicy not implemented")
}
func (UnimplementedPbaServer) SetHomeNetworkRoutingPolicy(context.Context, *SetPacketBrokerRoutingPolicyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetHomeNetworkRoutingPolicy not implemented")
}
func (UnimplementedPbaServer) DeleteHomeNetworkRoutingPolicy(context.Context, *PacketBrokerNetworkIdentifier) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHomeNetworkRoutingPolicy not implemented")
}
func (UnimplementedPbaServer) GetHomeNetworkDefaultRoutingPolicy(context.Context, *emptypb.Empty) (*PacketBrokerDefaultRoutingPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHomeNetworkDefaultRoutingPolicy not implemented")
}
func (UnimplementedPbaServer) SetHomeNetworkDefaultRoutingPolicy(context.Context, *SetPacketBrokerDefaultRoutingPolicyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetHomeNetworkDefaultRoutingPolicy not implemented")
}
func (UnimplementedPbaServer) DeleteHomeNetworkDefaultRoutingPolicy(context.Context, *emptypb.Empty) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHomeNetworkDefaultRoutingPolicy not implemented")
}
func (UnimplementedPbaServer) GetHomeNetworkDefaultGatewayVisibility(context.Context, *emptypb.Empty) (*PacketBrokerDefaultGatewayVisibility, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHomeNetworkDefaultGatewayVisibility not implemented")
}
func (UnimplementedPbaServer) SetHomeNetworkDefaultGatewayVisibility(context.Context, *SetPacketBrokerDefaultGatewayVisibilityRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetHomeNetworkDefaultGatewayVisibility not implemented")
}
func (UnimplementedPbaServer) DeleteHomeNetworkDefaultGatewayVisibility(context.Context, *emptypb.Empty) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHomeNetworkDefaultGatewayVisibility not implemented")
}
func (UnimplementedPbaServer) ListNetworks(context.Context, *ListPacketBrokerNetworksRequest) (*PacketBrokerNetworks, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNetworks not implemented")
}
func (UnimplementedPbaServer) ListHomeNetworks(context.Context, *ListPacketBrokerHomeNetworksRequest) (*PacketBrokerNetworks, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHomeNetworks not implemented")
}
func (UnimplementedPbaServer) ListForwarderRoutingPolicies(context.Context, *ListForwarderRoutingPoliciesRequest) (*PacketBrokerRoutingPolicies, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListForwarderRoutingPolicies not implemented")
}
func (UnimplementedPbaServer) mustEmbedUnimplementedPbaServer() {}

// UnsafePbaServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PbaServer will
// result in compilation errors.
type UnsafePbaServer interface {
	mustEmbedUnimplementedPbaServer()
}

func RegisterPbaServer(s grpc.ServiceRegistrar, srv PbaServer) {
	s.RegisterService(&Pba_ServiceDesc, srv)
}

func _Pba_GetInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).GetInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_GetInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).GetInfo(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_Register_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PacketBrokerRegisterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).Register(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_Register_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).Register(ctx, req.(*PacketBrokerRegisterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_Deregister_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).Deregister(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_Deregister_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).Deregister(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_ListHomeNetworkRoutingPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHomeNetworkRoutingPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).ListHomeNetworkRoutingPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_ListHomeNetworkRoutingPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).ListHomeNetworkRoutingPolicies(ctx, req.(*ListHomeNetworkRoutingPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_GetHomeNetworkRoutingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PacketBrokerNetworkIdentifier)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).GetHomeNetworkRoutingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_GetHomeNetworkRoutingPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).GetHomeNetworkRoutingPolicy(ctx, req.(*PacketBrokerNetworkIdentifier))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_SetHomeNetworkRoutingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetPacketBrokerRoutingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).SetHomeNetworkRoutingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_SetHomeNetworkRoutingPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).SetHomeNetworkRoutingPolicy(ctx, req.(*SetPacketBrokerRoutingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_DeleteHomeNetworkRoutingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PacketBrokerNetworkIdentifier)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).DeleteHomeNetworkRoutingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_DeleteHomeNetworkRoutingPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).DeleteHomeNetworkRoutingPolicy(ctx, req.(*PacketBrokerNetworkIdentifier))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_GetHomeNetworkDefaultRoutingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).GetHomeNetworkDefaultRoutingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_GetHomeNetworkDefaultRoutingPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).GetHomeNetworkDefaultRoutingPolicy(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_SetHomeNetworkDefaultRoutingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetPacketBrokerDefaultRoutingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).SetHomeNetworkDefaultRoutingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_SetHomeNetworkDefaultRoutingPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).SetHomeNetworkDefaultRoutingPolicy(ctx, req.(*SetPacketBrokerDefaultRoutingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_DeleteHomeNetworkDefaultRoutingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).DeleteHomeNetworkDefaultRoutingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_DeleteHomeNetworkDefaultRoutingPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).DeleteHomeNetworkDefaultRoutingPolicy(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_GetHomeNetworkDefaultGatewayVisibility_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).GetHomeNetworkDefaultGatewayVisibility(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_GetHomeNetworkDefaultGatewayVisibility_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).GetHomeNetworkDefaultGatewayVisibility(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_SetHomeNetworkDefaultGatewayVisibility_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetPacketBrokerDefaultGatewayVisibilityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).SetHomeNetworkDefaultGatewayVisibility(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_SetHomeNetworkDefaultGatewayVisibility_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).SetHomeNetworkDefaultGatewayVisibility(ctx, req.(*SetPacketBrokerDefaultGatewayVisibilityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_DeleteHomeNetworkDefaultGatewayVisibility_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).DeleteHomeNetworkDefaultGatewayVisibility(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_DeleteHomeNetworkDefaultGatewayVisibility_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).DeleteHomeNetworkDefaultGatewayVisibility(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_ListNetworks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPacketBrokerNetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).ListNetworks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_ListNetworks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).ListNetworks(ctx, req.(*ListPacketBrokerNetworksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_ListHomeNetworks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPacketBrokerHomeNetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).ListHomeNetworks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_ListHomeNetworks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).ListHomeNetworks(ctx, req.(*ListPacketBrokerHomeNetworksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pba_ListForwarderRoutingPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListForwarderRoutingPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PbaServer).ListForwarderRoutingPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pba_ListForwarderRoutingPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PbaServer).ListForwarderRoutingPolicies(ctx, req.(*ListForwarderRoutingPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Pba_ServiceDesc is the grpc.ServiceDesc for Pba service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Pba_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.Pba",
	HandlerType: (*PbaServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetInfo",
			Handler:    _Pba_GetInfo_Handler,
		},
		{
			MethodName: "Register",
			Handler:    _Pba_Register_Handler,
		},
		{
			MethodName: "Deregister",
			Handler:    _Pba_Deregister_Handler,
		},
		{
			MethodName: "ListHomeNetworkRoutingPolicies",
			Handler:    _Pba_ListHomeNetworkRoutingPolicies_Handler,
		},
		{
			MethodName: "GetHomeNetworkRoutingPolicy",
			Handler:    _Pba_GetHomeNetworkRoutingPolicy_Handler,
		},
		{
			MethodName: "SetHomeNetworkRoutingPolicy",
			Handler:    _Pba_SetHomeNetworkRoutingPolicy_Handler,
		},
		{
			MethodName: "DeleteHomeNetworkRoutingPolicy",
			Handler:    _Pba_DeleteHomeNetworkRoutingPolicy_Handler,
		},
		{
			MethodName: "GetHomeNetworkDefaultRoutingPolicy",
			Handler:    _Pba_GetHomeNetworkDefaultRoutingPolicy_Handler,
		},
		{
			MethodName: "SetHomeNetworkDefaultRoutingPolicy",
			Handler:    _Pba_SetHomeNetworkDefaultRoutingPolicy_Handler,
		},
		{
			MethodName: "DeleteHomeNetworkDefaultRoutingPolicy",
			Handler:    _Pba_DeleteHomeNetworkDefaultRoutingPolicy_Handler,
		},
		{
			MethodName: "GetHomeNetworkDefaultGatewayVisibility",
			Handler:    _Pba_GetHomeNetworkDefaultGatewayVisibility_Handler,
		},
		{
			MethodName: "SetHomeNetworkDefaultGatewayVisibility",
			Handler:    _Pba_SetHomeNetworkDefaultGatewayVisibility_Handler,
		},
		{
			MethodName: "DeleteHomeNetworkDefaultGatewayVisibility",
			Handler:    _Pba_DeleteHomeNetworkDefaultGatewayVisibility_Handler,
		},
		{
			MethodName: "ListNetworks",
			Handler:    _Pba_ListNetworks_Handler,
		},
		{
			MethodName: "ListHomeNetworks",
			Handler:    _Pba_ListHomeNetworks_Handler,
		},
		{
			MethodName: "ListForwarderRoutingPolicies",
			Handler:    _Pba_ListForwarderRoutingPolicies_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/packetbrokeragent.proto",
}
