// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on PacketBrokerGateway with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *PacketBrokerGateway) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerGatewayFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return PacketBrokerGatewayValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerGatewayValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "contact_info":

			if len(m.GetContactInfo()) > 10 {
				return PacketBrokerGatewayValidationError{
					field:  "contact_info",
					reason: "value must contain no more than 10 item(s)",
				}
			}

			for idx, item := range m.GetContactInfo() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return PacketBrokerGatewayValidationError{
							field:  fmt.Sprintf("contact_info[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "administrative_contact":

			if v, ok := interface{}(m.GetAdministrativeContact()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerGatewayValidationError{
						field:  "administrative_contact",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "technical_contact":

			if v, ok := interface{}(m.GetTechnicalContact()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerGatewayValidationError{
						field:  "technical_contact",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "antennas":

			if len(m.GetAntennas()) > 8 {
				return PacketBrokerGatewayValidationError{
					field:  "antennas",
					reason: "value must contain no more than 8 item(s)",
				}
			}

			for idx, item := range m.GetAntennas() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return PacketBrokerGatewayValidationError{
							field:  fmt.Sprintf("antennas[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "status_public":
			// no validation rules for StatusPublic
		case "location_public":
			// no validation rules for LocationPublic
		case "frequency_plan_ids":

			if len(m.GetFrequencyPlanIds()) > 8 {
				return PacketBrokerGatewayValidationError{
					field:  "frequency_plan_ids",
					reason: "value must contain no more than 8 item(s)",
				}
			}

			for idx, item := range m.GetFrequencyPlanIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 64 {
					return PacketBrokerGatewayValidationError{
						field:  fmt.Sprintf("frequency_plan_ids[%v]", idx),
						reason: "value length must be at most 64 runes",
					}
				}

			}

		case "update_location_from_status":
			// no validation rules for UpdateLocationFromStatus
		case "online":
			// no validation rules for Online
		case "rx_rate":

			if v, ok := interface{}(m.GetRxRate()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerGatewayValidationError{
						field:  "rx_rate",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "tx_rate":

			if v, ok := interface{}(m.GetTxRate()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerGatewayValidationError{
						field:  "tx_rate",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return PacketBrokerGatewayValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerGatewayValidationError is the validation error returned by
// PacketBrokerGateway.ValidateFields if the designated constraints aren't met.
type PacketBrokerGatewayValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerGatewayValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerGatewayValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerGatewayValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerGatewayValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerGatewayValidationError) ErrorName() string {
	return "PacketBrokerGatewayValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerGatewayValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerGateway.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerGatewayValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerGatewayValidationError{}

// ValidateFields checks the field values on UpdatePacketBrokerGatewayRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *UpdatePacketBrokerGatewayRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UpdatePacketBrokerGatewayRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway":

			if m.GetGateway() == nil {
				return UpdatePacketBrokerGatewayRequestValidationError{
					field:  "gateway",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGateway()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdatePacketBrokerGatewayRequestValidationError{
						field:  "gateway",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdatePacketBrokerGatewayRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UpdatePacketBrokerGatewayRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UpdatePacketBrokerGatewayRequestValidationError is the validation error
// returned by UpdatePacketBrokerGatewayRequest.ValidateFields if the
// designated constraints aren't met.
type UpdatePacketBrokerGatewayRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpdatePacketBrokerGatewayRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpdatePacketBrokerGatewayRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpdatePacketBrokerGatewayRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpdatePacketBrokerGatewayRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpdatePacketBrokerGatewayRequestValidationError) ErrorName() string {
	return "UpdatePacketBrokerGatewayRequestValidationError"
}

// Error satisfies the builtin error interface
func (e UpdatePacketBrokerGatewayRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpdatePacketBrokerGatewayRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpdatePacketBrokerGatewayRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpdatePacketBrokerGatewayRequestValidationError{}

// ValidateFields checks the field values on UpdatePacketBrokerGatewayResponse
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *UpdatePacketBrokerGatewayResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UpdatePacketBrokerGatewayResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "online_ttl":

			if v, ok := interface{}(m.GetOnlineTtl()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdatePacketBrokerGatewayResponseValidationError{
						field:  "online_ttl",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UpdatePacketBrokerGatewayResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UpdatePacketBrokerGatewayResponseValidationError is the validation error
// returned by UpdatePacketBrokerGatewayResponse.ValidateFields if the
// designated constraints aren't met.
type UpdatePacketBrokerGatewayResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpdatePacketBrokerGatewayResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpdatePacketBrokerGatewayResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpdatePacketBrokerGatewayResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpdatePacketBrokerGatewayResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpdatePacketBrokerGatewayResponseValidationError) ErrorName() string {
	return "UpdatePacketBrokerGatewayResponseValidationError"
}

// Error satisfies the builtin error interface
func (e UpdatePacketBrokerGatewayResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpdatePacketBrokerGatewayResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpdatePacketBrokerGatewayResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpdatePacketBrokerGatewayResponseValidationError{}

// ValidateFields checks the field values on PacketBrokerNetworkIdentifier with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *PacketBrokerNetworkIdentifier) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerNetworkIdentifierFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "net_id":
			// no validation rules for NetId
		case "tenant_id":

			if utf8.RuneCountInString(m.GetTenantId()) > 36 {
				return PacketBrokerNetworkIdentifierValidationError{
					field:  "tenant_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_PacketBrokerNetworkIdentifier_TenantId_Pattern.MatchString(m.GetTenantId()) {
				return PacketBrokerNetworkIdentifierValidationError{
					field:  "tenant_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$|^$\"",
				}
			}

		default:
			return PacketBrokerNetworkIdentifierValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerNetworkIdentifierValidationError is the validation error
// returned by PacketBrokerNetworkIdentifier.ValidateFields if the designated
// constraints aren't met.
type PacketBrokerNetworkIdentifierValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerNetworkIdentifierValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerNetworkIdentifierValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerNetworkIdentifierValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerNetworkIdentifierValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerNetworkIdentifierValidationError) ErrorName() string {
	return "PacketBrokerNetworkIdentifierValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerNetworkIdentifierValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerNetworkIdentifier.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerNetworkIdentifierValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerNetworkIdentifierValidationError{}

var _PacketBrokerNetworkIdentifier_TenantId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$|^$")

// ValidateFields checks the field values on PacketBrokerDevAddrBlock with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *PacketBrokerDevAddrBlock) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerDevAddrBlockFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "dev_addr_prefix":

			if v, ok := interface{}(m.GetDevAddrPrefix()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerDevAddrBlockValidationError{
						field:  "dev_addr_prefix",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "home_network_cluster_id":
			// no validation rules for HomeNetworkClusterId
		default:
			return PacketBrokerDevAddrBlockValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerDevAddrBlockValidationError is the validation error returned by
// PacketBrokerDevAddrBlock.ValidateFields if the designated constraints
// aren't met.
type PacketBrokerDevAddrBlockValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerDevAddrBlockValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerDevAddrBlockValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerDevAddrBlockValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerDevAddrBlockValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerDevAddrBlockValidationError) ErrorName() string {
	return "PacketBrokerDevAddrBlockValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerDevAddrBlockValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerDevAddrBlock.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerDevAddrBlockValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerDevAddrBlockValidationError{}

// ValidateFields checks the field values on PacketBrokerNetwork with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *PacketBrokerNetwork) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerNetworkFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "id":

			if v, ok := interface{}(m.GetId()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerNetworkValidationError{
						field:  "id",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "name":
			// no validation rules for Name
		case "dev_addr_blocks":

			for idx, item := range m.GetDevAddrBlocks() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return PacketBrokerNetworkValidationError{
							field:  fmt.Sprintf("dev_addr_blocks[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "contact_info":

			if len(m.GetContactInfo()) > 10 {
				return PacketBrokerNetworkValidationError{
					field:  "contact_info",
					reason: "value must contain no more than 10 item(s)",
				}
			}

			for idx, item := range m.GetContactInfo() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return PacketBrokerNetworkValidationError{
							field:  fmt.Sprintf("contact_info[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "administrative_contact":

			if v, ok := interface{}(m.GetAdministrativeContact()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerNetworkValidationError{
						field:  "administrative_contact",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "technical_contact":

			if v, ok := interface{}(m.GetTechnicalContact()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerNetworkValidationError{
						field:  "technical_contact",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "listed":
			// no validation rules for Listed
		default:
			return PacketBrokerNetworkValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerNetworkValidationError is the validation error returned by
// PacketBrokerNetwork.ValidateFields if the designated constraints aren't met.
type PacketBrokerNetworkValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerNetworkValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerNetworkValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerNetworkValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerNetworkValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerNetworkValidationError) ErrorName() string {
	return "PacketBrokerNetworkValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerNetworkValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerNetwork.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerNetworkValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerNetworkValidationError{}

// ValidateFields checks the field values on PacketBrokerNetworks with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *PacketBrokerNetworks) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerNetworksFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "networks":

			for idx, item := range m.GetNetworks() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return PacketBrokerNetworksValidationError{
							field:  fmt.Sprintf("networks[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return PacketBrokerNetworksValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerNetworksValidationError is the validation error returned by
// PacketBrokerNetworks.ValidateFields if the designated constraints aren't met.
type PacketBrokerNetworksValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerNetworksValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerNetworksValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerNetworksValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerNetworksValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerNetworksValidationError) ErrorName() string {
	return "PacketBrokerNetworksValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerNetworksValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerNetworks.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerNetworksValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerNetworksValidationError{}

// ValidateFields checks the field values on PacketBrokerInfo with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *PacketBrokerInfo) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerInfoFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "registration":

			if v, ok := interface{}(m.GetRegistration()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerInfoValidationError{
						field:  "registration",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "forwarder_enabled":
			// no validation rules for ForwarderEnabled
		case "home_network_enabled":
			// no validation rules for HomeNetworkEnabled
		case "register_enabled":
			// no validation rules for RegisterEnabled
		default:
			return PacketBrokerInfoValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerInfoValidationError is the validation error returned by
// PacketBrokerInfo.ValidateFields if the designated constraints aren't met.
type PacketBrokerInfoValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerInfoValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerInfoValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerInfoValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerInfoValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerInfoValidationError) ErrorName() string { return "PacketBrokerInfoValidationError" }

// Error satisfies the builtin error interface
func (e PacketBrokerInfoValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerInfo.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerInfoValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerInfoValidationError{}

// ValidateFields checks the field values on PacketBrokerRegisterRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *PacketBrokerRegisterRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerRegisterRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "listed":

			if v, ok := interface{}(m.GetListed()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerRegisterRequestValidationError{
						field:  "listed",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return PacketBrokerRegisterRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerRegisterRequestValidationError is the validation error returned
// by PacketBrokerRegisterRequest.ValidateFields if the designated constraints
// aren't met.
type PacketBrokerRegisterRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerRegisterRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerRegisterRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerRegisterRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerRegisterRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerRegisterRequestValidationError) ErrorName() string {
	return "PacketBrokerRegisterRequestValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerRegisterRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerRegisterRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerRegisterRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerRegisterRequestValidationError{}

// ValidateFields checks the field values on PacketBrokerRoutingPolicyUplink
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *PacketBrokerRoutingPolicyUplink) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerRoutingPolicyUplinkFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "join_request":
			// no validation rules for JoinRequest
		case "mac_data":
			// no validation rules for MacData
		case "application_data":
			// no validation rules for ApplicationData
		case "signal_quality":
			// no validation rules for SignalQuality
		case "localization":
			// no validation rules for Localization
		default:
			return PacketBrokerRoutingPolicyUplinkValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerRoutingPolicyUplinkValidationError is the validation error
// returned by PacketBrokerRoutingPolicyUplink.ValidateFields if the
// designated constraints aren't met.
type PacketBrokerRoutingPolicyUplinkValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerRoutingPolicyUplinkValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerRoutingPolicyUplinkValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerRoutingPolicyUplinkValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerRoutingPolicyUplinkValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerRoutingPolicyUplinkValidationError) ErrorName() string {
	return "PacketBrokerRoutingPolicyUplinkValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerRoutingPolicyUplinkValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerRoutingPolicyUplink.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerRoutingPolicyUplinkValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerRoutingPolicyUplinkValidationError{}

// ValidateFields checks the field values on PacketBrokerRoutingPolicyDownlink
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *PacketBrokerRoutingPolicyDownlink) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerRoutingPolicyDownlinkFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "join_accept":
			// no validation rules for JoinAccept
		case "mac_data":
			// no validation rules for MacData
		case "application_data":
			// no validation rules for ApplicationData
		default:
			return PacketBrokerRoutingPolicyDownlinkValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerRoutingPolicyDownlinkValidationError is the validation error
// returned by PacketBrokerRoutingPolicyDownlink.ValidateFields if the
// designated constraints aren't met.
type PacketBrokerRoutingPolicyDownlinkValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerRoutingPolicyDownlinkValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerRoutingPolicyDownlinkValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerRoutingPolicyDownlinkValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerRoutingPolicyDownlinkValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerRoutingPolicyDownlinkValidationError) ErrorName() string {
	return "PacketBrokerRoutingPolicyDownlinkValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerRoutingPolicyDownlinkValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerRoutingPolicyDownlink.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerRoutingPolicyDownlinkValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerRoutingPolicyDownlinkValidationError{}

// ValidateFields checks the field values on PacketBrokerDefaultRoutingPolicy
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *PacketBrokerDefaultRoutingPolicy) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerDefaultRoutingPolicyFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerDefaultRoutingPolicyValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "uplink":

			if v, ok := interface{}(m.GetUplink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerDefaultRoutingPolicyValidationError{
						field:  "uplink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink":

			if v, ok := interface{}(m.GetDownlink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerDefaultRoutingPolicyValidationError{
						field:  "downlink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return PacketBrokerDefaultRoutingPolicyValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerDefaultRoutingPolicyValidationError is the validation error
// returned by PacketBrokerDefaultRoutingPolicy.ValidateFields if the
// designated constraints aren't met.
type PacketBrokerDefaultRoutingPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerDefaultRoutingPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerDefaultRoutingPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerDefaultRoutingPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerDefaultRoutingPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerDefaultRoutingPolicyValidationError) ErrorName() string {
	return "PacketBrokerDefaultRoutingPolicyValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerDefaultRoutingPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerDefaultRoutingPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerDefaultRoutingPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerDefaultRoutingPolicyValidationError{}

// ValidateFields checks the field values on PacketBrokerRoutingPolicy with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *PacketBrokerRoutingPolicy) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerRoutingPolicyFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "forwarder_id":

			if v, ok := interface{}(m.GetForwarderId()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerRoutingPolicyValidationError{
						field:  "forwarder_id",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "home_network_id":

			if v, ok := interface{}(m.GetHomeNetworkId()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerRoutingPolicyValidationError{
						field:  "home_network_id",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerRoutingPolicyValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "uplink":

			if v, ok := interface{}(m.GetUplink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerRoutingPolicyValidationError{
						field:  "uplink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink":

			if v, ok := interface{}(m.GetDownlink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerRoutingPolicyValidationError{
						field:  "downlink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return PacketBrokerRoutingPolicyValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerRoutingPolicyValidationError is the validation error returned by
// PacketBrokerRoutingPolicy.ValidateFields if the designated constraints
// aren't met.
type PacketBrokerRoutingPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerRoutingPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerRoutingPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerRoutingPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerRoutingPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerRoutingPolicyValidationError) ErrorName() string {
	return "PacketBrokerRoutingPolicyValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerRoutingPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerRoutingPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerRoutingPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerRoutingPolicyValidationError{}

// ValidateFields checks the field values on
// SetPacketBrokerDefaultRoutingPolicyRequest with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *SetPacketBrokerDefaultRoutingPolicyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SetPacketBrokerDefaultRoutingPolicyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "uplink":

			if m.GetUplink() == nil {
				return SetPacketBrokerDefaultRoutingPolicyRequestValidationError{
					field:  "uplink",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUplink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetPacketBrokerDefaultRoutingPolicyRequestValidationError{
						field:  "uplink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink":

			if m.GetDownlink() == nil {
				return SetPacketBrokerDefaultRoutingPolicyRequestValidationError{
					field:  "downlink",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetDownlink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetPacketBrokerDefaultRoutingPolicyRequestValidationError{
						field:  "downlink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return SetPacketBrokerDefaultRoutingPolicyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// SetPacketBrokerDefaultRoutingPolicyRequestValidationError is the validation
// error returned by SetPacketBrokerDefaultRoutingPolicyRequest.ValidateFields
// if the designated constraints aren't met.
type SetPacketBrokerDefaultRoutingPolicyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SetPacketBrokerDefaultRoutingPolicyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SetPacketBrokerDefaultRoutingPolicyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SetPacketBrokerDefaultRoutingPolicyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SetPacketBrokerDefaultRoutingPolicyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SetPacketBrokerDefaultRoutingPolicyRequestValidationError) ErrorName() string {
	return "SetPacketBrokerDefaultRoutingPolicyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SetPacketBrokerDefaultRoutingPolicyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSetPacketBrokerDefaultRoutingPolicyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SetPacketBrokerDefaultRoutingPolicyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SetPacketBrokerDefaultRoutingPolicyRequestValidationError{}

// ValidateFields checks the field values on
// ListHomeNetworkRoutingPoliciesRequest with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *ListHomeNetworkRoutingPoliciesRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListHomeNetworkRoutingPoliciesRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "limit":

			if m.GetLimit() > 1000 {
				return ListHomeNetworkRoutingPoliciesRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		default:
			return ListHomeNetworkRoutingPoliciesRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListHomeNetworkRoutingPoliciesRequestValidationError is the validation error
// returned by ListHomeNetworkRoutingPoliciesRequest.ValidateFields if the
// designated constraints aren't met.
type ListHomeNetworkRoutingPoliciesRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListHomeNetworkRoutingPoliciesRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListHomeNetworkRoutingPoliciesRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListHomeNetworkRoutingPoliciesRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListHomeNetworkRoutingPoliciesRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListHomeNetworkRoutingPoliciesRequestValidationError) ErrorName() string {
	return "ListHomeNetworkRoutingPoliciesRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListHomeNetworkRoutingPoliciesRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListHomeNetworkRoutingPoliciesRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListHomeNetworkRoutingPoliciesRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListHomeNetworkRoutingPoliciesRequestValidationError{}

// ValidateFields checks the field values on PacketBrokerRoutingPolicies with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *PacketBrokerRoutingPolicies) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerRoutingPoliciesFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "policies":

			for idx, item := range m.GetPolicies() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return PacketBrokerRoutingPoliciesValidationError{
							field:  fmt.Sprintf("policies[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return PacketBrokerRoutingPoliciesValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerRoutingPoliciesValidationError is the validation error returned
// by PacketBrokerRoutingPolicies.ValidateFields if the designated constraints
// aren't met.
type PacketBrokerRoutingPoliciesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerRoutingPoliciesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerRoutingPoliciesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerRoutingPoliciesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerRoutingPoliciesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerRoutingPoliciesValidationError) ErrorName() string {
	return "PacketBrokerRoutingPoliciesValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerRoutingPoliciesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerRoutingPolicies.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerRoutingPoliciesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerRoutingPoliciesValidationError{}

// ValidateFields checks the field values on
// SetPacketBrokerRoutingPolicyRequest with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *SetPacketBrokerRoutingPolicyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SetPacketBrokerRoutingPolicyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "home_network_id":

			if v, ok := interface{}(m.GetHomeNetworkId()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetPacketBrokerRoutingPolicyRequestValidationError{
						field:  "home_network_id",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "uplink":

			if m.GetUplink() == nil {
				return SetPacketBrokerRoutingPolicyRequestValidationError{
					field:  "uplink",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetUplink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetPacketBrokerRoutingPolicyRequestValidationError{
						field:  "uplink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink":

			if m.GetDownlink() == nil {
				return SetPacketBrokerRoutingPolicyRequestValidationError{
					field:  "downlink",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetDownlink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetPacketBrokerRoutingPolicyRequestValidationError{
						field:  "downlink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return SetPacketBrokerRoutingPolicyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// SetPacketBrokerRoutingPolicyRequestValidationError is the validation error
// returned by SetPacketBrokerRoutingPolicyRequest.ValidateFields if the
// designated constraints aren't met.
type SetPacketBrokerRoutingPolicyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SetPacketBrokerRoutingPolicyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SetPacketBrokerRoutingPolicyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SetPacketBrokerRoutingPolicyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SetPacketBrokerRoutingPolicyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SetPacketBrokerRoutingPolicyRequestValidationError) ErrorName() string {
	return "SetPacketBrokerRoutingPolicyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SetPacketBrokerRoutingPolicyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSetPacketBrokerRoutingPolicyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SetPacketBrokerRoutingPolicyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SetPacketBrokerRoutingPolicyRequestValidationError{}

// ValidateFields checks the field values on PacketBrokerGatewayVisibility with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *PacketBrokerGatewayVisibility) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerGatewayVisibilityFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "location":
			// no validation rules for Location
		case "antenna_placement":
			// no validation rules for AntennaPlacement
		case "antenna_count":
			// no validation rules for AntennaCount
		case "fine_timestamps":
			// no validation rules for FineTimestamps
		case "contact_info":
			// no validation rules for ContactInfo
		case "status":
			// no validation rules for Status
		case "frequency_plan":
			// no validation rules for FrequencyPlan
		case "packet_rates":
			// no validation rules for PacketRates
		default:
			return PacketBrokerGatewayVisibilityValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerGatewayVisibilityValidationError is the validation error
// returned by PacketBrokerGatewayVisibility.ValidateFields if the designated
// constraints aren't met.
type PacketBrokerGatewayVisibilityValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerGatewayVisibilityValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerGatewayVisibilityValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerGatewayVisibilityValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerGatewayVisibilityValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerGatewayVisibilityValidationError) ErrorName() string {
	return "PacketBrokerGatewayVisibilityValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerGatewayVisibilityValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerGatewayVisibility.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerGatewayVisibilityValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerGatewayVisibilityValidationError{}

// ValidateFields checks the field values on
// PacketBrokerDefaultGatewayVisibility with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *PacketBrokerDefaultGatewayVisibility) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerDefaultGatewayVisibilityFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerDefaultGatewayVisibilityValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "visibility":

			if v, ok := interface{}(m.GetVisibility()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerDefaultGatewayVisibilityValidationError{
						field:  "visibility",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return PacketBrokerDefaultGatewayVisibilityValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerDefaultGatewayVisibilityValidationError is the validation error
// returned by PacketBrokerDefaultGatewayVisibility.ValidateFields if the
// designated constraints aren't met.
type PacketBrokerDefaultGatewayVisibilityValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerDefaultGatewayVisibilityValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerDefaultGatewayVisibilityValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerDefaultGatewayVisibilityValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerDefaultGatewayVisibilityValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerDefaultGatewayVisibilityValidationError) ErrorName() string {
	return "PacketBrokerDefaultGatewayVisibilityValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerDefaultGatewayVisibilityValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerDefaultGatewayVisibility.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerDefaultGatewayVisibilityValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerDefaultGatewayVisibilityValidationError{}

// ValidateFields checks the field values on
// SetPacketBrokerDefaultGatewayVisibilityRequest with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *SetPacketBrokerDefaultGatewayVisibilityRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SetPacketBrokerDefaultGatewayVisibilityRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "visibility":

			if m.GetVisibility() == nil {
				return SetPacketBrokerDefaultGatewayVisibilityRequestValidationError{
					field:  "visibility",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetVisibility()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetPacketBrokerDefaultGatewayVisibilityRequestValidationError{
						field:  "visibility",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return SetPacketBrokerDefaultGatewayVisibilityRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// SetPacketBrokerDefaultGatewayVisibilityRequestValidationError is the
// validation error returned by
// SetPacketBrokerDefaultGatewayVisibilityRequest.ValidateFields if the
// designated constraints aren't met.
type SetPacketBrokerDefaultGatewayVisibilityRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SetPacketBrokerDefaultGatewayVisibilityRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SetPacketBrokerDefaultGatewayVisibilityRequestValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e SetPacketBrokerDefaultGatewayVisibilityRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SetPacketBrokerDefaultGatewayVisibilityRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SetPacketBrokerDefaultGatewayVisibilityRequestValidationError) ErrorName() string {
	return "SetPacketBrokerDefaultGatewayVisibilityRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SetPacketBrokerDefaultGatewayVisibilityRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSetPacketBrokerDefaultGatewayVisibilityRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SetPacketBrokerDefaultGatewayVisibilityRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SetPacketBrokerDefaultGatewayVisibilityRequestValidationError{}

// ValidateFields checks the field values on ListPacketBrokerNetworksRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ListPacketBrokerNetworksRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListPacketBrokerNetworksRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "limit":

			if m.GetLimit() > 1000 {
				return ListPacketBrokerNetworksRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "with_routing_policy":
			// no validation rules for WithRoutingPolicy
		case "tenant_id_contains":

			if utf8.RuneCountInString(m.GetTenantIdContains()) > 100 {
				return ListPacketBrokerNetworksRequestValidationError{
					field:  "tenant_id_contains",
					reason: "value length must be at most 100 runes",
				}
			}

		case "name_contains":

			if utf8.RuneCountInString(m.GetNameContains()) > 100 {
				return ListPacketBrokerNetworksRequestValidationError{
					field:  "name_contains",
					reason: "value length must be at most 100 runes",
				}
			}

		default:
			return ListPacketBrokerNetworksRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListPacketBrokerNetworksRequestValidationError is the validation error
// returned by ListPacketBrokerNetworksRequest.ValidateFields if the
// designated constraints aren't met.
type ListPacketBrokerNetworksRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListPacketBrokerNetworksRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListPacketBrokerNetworksRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListPacketBrokerNetworksRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListPacketBrokerNetworksRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListPacketBrokerNetworksRequestValidationError) ErrorName() string {
	return "ListPacketBrokerNetworksRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListPacketBrokerNetworksRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListPacketBrokerNetworksRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListPacketBrokerNetworksRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListPacketBrokerNetworksRequestValidationError{}

// ValidateFields checks the field values on
// ListPacketBrokerHomeNetworksRequest with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *ListPacketBrokerHomeNetworksRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListPacketBrokerHomeNetworksRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "limit":

			if m.GetLimit() > 1000 {
				return ListPacketBrokerHomeNetworksRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "tenant_id_contains":

			if utf8.RuneCountInString(m.GetTenantIdContains()) > 100 {
				return ListPacketBrokerHomeNetworksRequestValidationError{
					field:  "tenant_id_contains",
					reason: "value length must be at most 100 runes",
				}
			}

		case "name_contains":

			if utf8.RuneCountInString(m.GetNameContains()) > 100 {
				return ListPacketBrokerHomeNetworksRequestValidationError{
					field:  "name_contains",
					reason: "value length must be at most 100 runes",
				}
			}

		default:
			return ListPacketBrokerHomeNetworksRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListPacketBrokerHomeNetworksRequestValidationError is the validation error
// returned by ListPacketBrokerHomeNetworksRequest.ValidateFields if the
// designated constraints aren't met.
type ListPacketBrokerHomeNetworksRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListPacketBrokerHomeNetworksRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListPacketBrokerHomeNetworksRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListPacketBrokerHomeNetworksRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListPacketBrokerHomeNetworksRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListPacketBrokerHomeNetworksRequestValidationError) ErrorName() string {
	return "ListPacketBrokerHomeNetworksRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListPacketBrokerHomeNetworksRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListPacketBrokerHomeNetworksRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListPacketBrokerHomeNetworksRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListPacketBrokerHomeNetworksRequestValidationError{}

// ValidateFields checks the field values on
// ListForwarderRoutingPoliciesRequest with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *ListForwarderRoutingPoliciesRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListForwarderRoutingPoliciesRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "home_network_id":

			if v, ok := interface{}(m.GetHomeNetworkId()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListForwarderRoutingPoliciesRequestValidationError{
						field:  "home_network_id",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "limit":
			// no validation rules for Limit
		case "page":
			// no validation rules for Page
		default:
			return ListForwarderRoutingPoliciesRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListForwarderRoutingPoliciesRequestValidationError is the validation error
// returned by ListForwarderRoutingPoliciesRequest.ValidateFields if the
// designated constraints aren't met.
type ListForwarderRoutingPoliciesRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListForwarderRoutingPoliciesRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListForwarderRoutingPoliciesRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListForwarderRoutingPoliciesRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListForwarderRoutingPoliciesRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListForwarderRoutingPoliciesRequestValidationError) ErrorName() string {
	return "ListForwarderRoutingPoliciesRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListForwarderRoutingPoliciesRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListForwarderRoutingPoliciesRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListForwarderRoutingPoliciesRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListForwarderRoutingPoliciesRequestValidationError{}

// ValidateFields checks the field values on PacketBrokerAgentUplinkToken with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *PacketBrokerAgentUplinkToken) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerAgentUplinkTokenFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "forwarder_net_id":
			// no validation rules for ForwarderNetId
		case "forwarder_tenant_id":
			// no validation rules for ForwarderTenantId
		case "forwarder_cluster_id":
			// no validation rules for ForwarderClusterId
		default:
			return PacketBrokerAgentUplinkTokenValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerAgentUplinkTokenValidationError is the validation error returned
// by PacketBrokerAgentUplinkToken.ValidateFields if the designated
// constraints aren't met.
type PacketBrokerAgentUplinkTokenValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerAgentUplinkTokenValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerAgentUplinkTokenValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerAgentUplinkTokenValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerAgentUplinkTokenValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerAgentUplinkTokenValidationError) ErrorName() string {
	return "PacketBrokerAgentUplinkTokenValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerAgentUplinkTokenValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerAgentUplinkToken.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerAgentUplinkTokenValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerAgentUplinkTokenValidationError{}

// ValidateFields checks the field values on
// PacketBrokerAgentGatewayUplinkToken with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *PacketBrokerAgentGatewayUplinkToken) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerAgentGatewayUplinkTokenFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_uid":
			// no validation rules for GatewayUid
		case "token":
			// no validation rules for Token
		default:
			return PacketBrokerAgentGatewayUplinkTokenValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerAgentGatewayUplinkTokenValidationError is the validation error
// returned by PacketBrokerAgentGatewayUplinkToken.ValidateFields if the
// designated constraints aren't met.
type PacketBrokerAgentGatewayUplinkTokenValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerAgentGatewayUplinkTokenValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerAgentGatewayUplinkTokenValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerAgentGatewayUplinkTokenValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerAgentGatewayUplinkTokenValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerAgentGatewayUplinkTokenValidationError) ErrorName() string {
	return "PacketBrokerAgentGatewayUplinkTokenValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerAgentGatewayUplinkTokenValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerAgentGatewayUplinkToken.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerAgentGatewayUplinkTokenValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerAgentGatewayUplinkTokenValidationError{}

// ValidateFields checks the field values on
// PacketBrokerAgentCompoundUplinkToken with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *PacketBrokerAgentCompoundUplinkToken) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerAgentCompoundUplinkTokenFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway":
			// no validation rules for Gateway
		case "forwarder":
			// no validation rules for Forwarder
		case "agent":

			if v, ok := interface{}(m.GetAgent()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerAgentCompoundUplinkTokenValidationError{
						field:  "agent",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return PacketBrokerAgentCompoundUplinkTokenValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerAgentCompoundUplinkTokenValidationError is the validation error
// returned by PacketBrokerAgentCompoundUplinkToken.ValidateFields if the
// designated constraints aren't met.
type PacketBrokerAgentCompoundUplinkTokenValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerAgentCompoundUplinkTokenValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerAgentCompoundUplinkTokenValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerAgentCompoundUplinkTokenValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerAgentCompoundUplinkTokenValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerAgentCompoundUplinkTokenValidationError) ErrorName() string {
	return "PacketBrokerAgentCompoundUplinkTokenValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerAgentCompoundUplinkTokenValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerAgentCompoundUplinkToken.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerAgentCompoundUplinkTokenValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerAgentCompoundUplinkTokenValidationError{}

// ValidateFields checks the field values on PacketBrokerAgentEncryptedPayload
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *PacketBrokerAgentEncryptedPayload) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerAgentEncryptedPayloadFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ciphertext":
			// no validation rules for Ciphertext
		case "nonce":
			// no validation rules for Nonce
		default:
			return PacketBrokerAgentEncryptedPayloadValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerAgentEncryptedPayloadValidationError is the validation error
// returned by PacketBrokerAgentEncryptedPayload.ValidateFields if the
// designated constraints aren't met.
type PacketBrokerAgentEncryptedPayloadValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerAgentEncryptedPayloadValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerAgentEncryptedPayloadValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerAgentEncryptedPayloadValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerAgentEncryptedPayloadValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerAgentEncryptedPayloadValidationError) ErrorName() string {
	return "PacketBrokerAgentEncryptedPayloadValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerAgentEncryptedPayloadValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerAgentEncryptedPayload.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerAgentEncryptedPayloadValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerAgentEncryptedPayloadValidationError{}

// ValidateFields checks the field values on
// PacketBrokerGateway_GatewayIdentifiers with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *PacketBrokerGateway_GatewayIdentifiers) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerGateway_GatewayIdentifiersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_id":

			if utf8.RuneCountInString(m.GetGatewayId()) > 36 {
				return PacketBrokerGateway_GatewayIdentifiersValidationError{
					field:  "gateway_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_PacketBrokerGateway_GatewayIdentifiers_GatewayId_Pattern.MatchString(m.GetGatewayId()) {
				return PacketBrokerGateway_GatewayIdentifiersValidationError{
					field:  "gateway_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[_-]?[a-z0-9]){2,}$\"",
				}
			}

		case "eui":

			if len(m.GetEui()) > 0 {

				if len(m.GetEui()) != 8 {
					return PacketBrokerGateway_GatewayIdentifiersValidationError{
						field:  "eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		default:
			return PacketBrokerGateway_GatewayIdentifiersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerGateway_GatewayIdentifiersValidationError is the validation
// error returned by PacketBrokerGateway_GatewayIdentifiers.ValidateFields if
// the designated constraints aren't met.
type PacketBrokerGateway_GatewayIdentifiersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerGateway_GatewayIdentifiersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerGateway_GatewayIdentifiersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerGateway_GatewayIdentifiersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerGateway_GatewayIdentifiersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerGateway_GatewayIdentifiersValidationError) ErrorName() string {
	return "PacketBrokerGateway_GatewayIdentifiersValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerGateway_GatewayIdentifiersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerGateway_GatewayIdentifiers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerGateway_GatewayIdentifiersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerGateway_GatewayIdentifiersValidationError{}

var _PacketBrokerGateway_GatewayIdentifiers_GatewayId_Pattern = regexp.MustCompile("^[a-z0-9](?:[_-]?[a-z0-9]){2,}$")
