// Copyright © 2021 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/packetbrokeragent.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Gateway respresentation for Packet Broker.
// This is a subset and superset of the Gateway message using the same data types and field tags to achieve initial wire compatibility.
// There is no (longer) wire compatibility needed; new fields may use any tag.
type PacketBrokerGateway struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids *PacketBrokerGateway_GatewayIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	// This field is deprecated. Use administrative_contact and technical_contact instead.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/packetbrokeragent.proto.
	ContactInfo              []*ContactInfo                 `protobuf:"bytes,7,rep,name=contact_info,json=contactInfo,proto3" json:"contact_info,omitempty"`
	AdministrativeContact    *OrganizationOrUserIdentifiers `protobuf:"bytes,10,opt,name=administrative_contact,json=administrativeContact,proto3" json:"administrative_contact,omitempty"`
	TechnicalContact         *OrganizationOrUserIdentifiers `protobuf:"bytes,11,opt,name=technical_contact,json=technicalContact,proto3" json:"technical_contact,omitempty"`
	Antennas                 []*GatewayAntenna              `protobuf:"bytes,13,rep,name=antennas,proto3" json:"antennas,omitempty"`
	StatusPublic             bool                           `protobuf:"varint,14,opt,name=status_public,json=statusPublic,proto3" json:"status_public,omitempty"`
	LocationPublic           bool                           `protobuf:"varint,15,opt,name=location_public,json=locationPublic,proto3" json:"location_public,omitempty"`
	FrequencyPlanIds         []string                       `protobuf:"bytes,20,rep,name=frequency_plan_ids,json=frequencyPlanIds,proto3" json:"frequency_plan_ids,omitempty"`
	UpdateLocationFromStatus bool                           `protobuf:"varint,21,opt,name=update_location_from_status,json=updateLocationFromStatus,proto3" json:"update_location_from_status,omitempty"`
	Online                   bool                           `protobuf:"varint,28,opt,name=online,proto3" json:"online,omitempty"`
	// Received packets rate (number of packets per hour).
	// This field gets updated when a value is set.
	RxRate *wrapperspb.FloatValue `protobuf:"bytes,29,opt,name=rx_rate,json=rxRate,proto3" json:"rx_rate,omitempty"`
	// Transmitted packets rate (number of packets per hour).
	// This field gets updated when a value is set.
	TxRate *wrapperspb.FloatValue `protobuf:"bytes,30,opt,name=tx_rate,json=txRate,proto3" json:"tx_rate,omitempty"`
}

func (x *PacketBrokerGateway) Reset() {
	*x = PacketBrokerGateway{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerGateway) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerGateway) ProtoMessage() {}

func (x *PacketBrokerGateway) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerGateway.ProtoReflect.Descriptor instead.
func (*PacketBrokerGateway) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{0}
}

func (x *PacketBrokerGateway) GetIds() *PacketBrokerGateway_GatewayIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/packetbrokeragent.proto.
func (x *PacketBrokerGateway) GetContactInfo() []*ContactInfo {
	if x != nil {
		return x.ContactInfo
	}
	return nil
}

func (x *PacketBrokerGateway) GetAdministrativeContact() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.AdministrativeContact
	}
	return nil
}

func (x *PacketBrokerGateway) GetTechnicalContact() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.TechnicalContact
	}
	return nil
}

func (x *PacketBrokerGateway) GetAntennas() []*GatewayAntenna {
	if x != nil {
		return x.Antennas
	}
	return nil
}

func (x *PacketBrokerGateway) GetStatusPublic() bool {
	if x != nil {
		return x.StatusPublic
	}
	return false
}

func (x *PacketBrokerGateway) GetLocationPublic() bool {
	if x != nil {
		return x.LocationPublic
	}
	return false
}

func (x *PacketBrokerGateway) GetFrequencyPlanIds() []string {
	if x != nil {
		return x.FrequencyPlanIds
	}
	return nil
}

func (x *PacketBrokerGateway) GetUpdateLocationFromStatus() bool {
	if x != nil {
		return x.UpdateLocationFromStatus
	}
	return false
}

func (x *PacketBrokerGateway) GetOnline() bool {
	if x != nil {
		return x.Online
	}
	return false
}

func (x *PacketBrokerGateway) GetRxRate() *wrapperspb.FloatValue {
	if x != nil {
		return x.RxRate
	}
	return nil
}

func (x *PacketBrokerGateway) GetTxRate() *wrapperspb.FloatValue {
	if x != nil {
		return x.TxRate
	}
	return nil
}

type UpdatePacketBrokerGatewayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Gateway *PacketBrokerGateway `protobuf:"bytes,1,opt,name=gateway,proto3" json:"gateway,omitempty"`
	// The names of the gateway fields that are considered for update.
	//
	// Online status is only updated if status_public is set. If status_public is set and false, the status will be reset.
	// If status_public is set and true, the online status is taken from the online field. The return message contains
	// the duration online_ttl for how long the gateway is considered online.
	//
	// Location is only updated if location_public is set. If location_public is set and false, the location will be reset.
	// If location_public is set and true, the first antenna location will be used as gateway location.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *UpdatePacketBrokerGatewayRequest) Reset() {
	*x = UpdatePacketBrokerGatewayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePacketBrokerGatewayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePacketBrokerGatewayRequest) ProtoMessage() {}

func (x *UpdatePacketBrokerGatewayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePacketBrokerGatewayRequest.ProtoReflect.Descriptor instead.
func (*UpdatePacketBrokerGatewayRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{1}
}

func (x *UpdatePacketBrokerGatewayRequest) GetGateway() *PacketBrokerGateway {
	if x != nil {
		return x.Gateway
	}
	return nil
}

func (x *UpdatePacketBrokerGatewayRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type UpdatePacketBrokerGatewayResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time to live of the online status.
	OnlineTtl *durationpb.Duration `protobuf:"bytes,1,opt,name=online_ttl,json=onlineTtl,proto3" json:"online_ttl,omitempty"`
}

func (x *UpdatePacketBrokerGatewayResponse) Reset() {
	*x = UpdatePacketBrokerGatewayResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePacketBrokerGatewayResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePacketBrokerGatewayResponse) ProtoMessage() {}

func (x *UpdatePacketBrokerGatewayResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePacketBrokerGatewayResponse.ProtoReflect.Descriptor instead.
func (*UpdatePacketBrokerGatewayResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{2}
}

func (x *UpdatePacketBrokerGatewayResponse) GetOnlineTtl() *durationpb.Duration {
	if x != nil {
		return x.OnlineTtl
	}
	return nil
}

type PacketBrokerNetworkIdentifier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// LoRa Alliance NetID.
	NetId uint32 `protobuf:"varint,1,opt,name=net_id,json=netId,proto3" json:"net_id,omitempty"`
	// Tenant identifier if the registration leases DevAddr blocks from a NetID.
	TenantId string `protobuf:"bytes,2,opt,name=tenant_id,json=tenantId,proto3" json:"tenant_id,omitempty"`
}

func (x *PacketBrokerNetworkIdentifier) Reset() {
	*x = PacketBrokerNetworkIdentifier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerNetworkIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerNetworkIdentifier) ProtoMessage() {}

func (x *PacketBrokerNetworkIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerNetworkIdentifier.ProtoReflect.Descriptor instead.
func (*PacketBrokerNetworkIdentifier) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{3}
}

func (x *PacketBrokerNetworkIdentifier) GetNetId() uint32 {
	if x != nil {
		return x.NetId
	}
	return 0
}

func (x *PacketBrokerNetworkIdentifier) GetTenantId() string {
	if x != nil {
		return x.TenantId
	}
	return ""
}

type PacketBrokerDevAddrBlock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DevAddrPrefix        *DevAddrPrefix `protobuf:"bytes,1,opt,name=dev_addr_prefix,json=devAddrPrefix,proto3" json:"dev_addr_prefix,omitempty"`
	HomeNetworkClusterId string         `protobuf:"bytes,2,opt,name=home_network_cluster_id,json=homeNetworkClusterId,proto3" json:"home_network_cluster_id,omitempty"`
}

func (x *PacketBrokerDevAddrBlock) Reset() {
	*x = PacketBrokerDevAddrBlock{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerDevAddrBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerDevAddrBlock) ProtoMessage() {}

func (x *PacketBrokerDevAddrBlock) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerDevAddrBlock.ProtoReflect.Descriptor instead.
func (*PacketBrokerDevAddrBlock) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{4}
}

func (x *PacketBrokerDevAddrBlock) GetDevAddrPrefix() *DevAddrPrefix {
	if x != nil {
		return x.DevAddrPrefix
	}
	return nil
}

func (x *PacketBrokerDevAddrBlock) GetHomeNetworkClusterId() string {
	if x != nil {
		return x.HomeNetworkClusterId
	}
	return ""
}

type PacketBrokerNetwork struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Packet Broker network identifier.
	Id *PacketBrokerNetworkIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the network.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// DevAddr blocks that are assigned to this registration.
	DevAddrBlocks []*PacketBrokerDevAddrBlock `protobuf:"bytes,3,rep,name=dev_addr_blocks,json=devAddrBlocks,proto3" json:"dev_addr_blocks,omitempty"`
	// Contact information.
	// This field is deprecated. Use administrative_contact and technical_contact instead.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/packetbrokeragent.proto.
	ContactInfo           []*ContactInfo `protobuf:"bytes,4,rep,name=contact_info,json=contactInfo,proto3" json:"contact_info,omitempty"`
	AdministrativeContact *ContactInfo   `protobuf:"bytes,6,opt,name=administrative_contact,json=administrativeContact,proto3" json:"administrative_contact,omitempty"`
	TechnicalContact      *ContactInfo   `protobuf:"bytes,7,opt,name=technical_contact,json=technicalContact,proto3" json:"technical_contact,omitempty"`
	// Whether the network is listed so it can be viewed by other networks.
	Listed bool `protobuf:"varint,5,opt,name=listed,proto3" json:"listed,omitempty"`
}

func (x *PacketBrokerNetwork) Reset() {
	*x = PacketBrokerNetwork{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerNetwork) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerNetwork) ProtoMessage() {}

func (x *PacketBrokerNetwork) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerNetwork.ProtoReflect.Descriptor instead.
func (*PacketBrokerNetwork) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{5}
}

func (x *PacketBrokerNetwork) GetId() *PacketBrokerNetworkIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *PacketBrokerNetwork) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PacketBrokerNetwork) GetDevAddrBlocks() []*PacketBrokerDevAddrBlock {
	if x != nil {
		return x.DevAddrBlocks
	}
	return nil
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/packetbrokeragent.proto.
func (x *PacketBrokerNetwork) GetContactInfo() []*ContactInfo {
	if x != nil {
		return x.ContactInfo
	}
	return nil
}

func (x *PacketBrokerNetwork) GetAdministrativeContact() *ContactInfo {
	if x != nil {
		return x.AdministrativeContact
	}
	return nil
}

func (x *PacketBrokerNetwork) GetTechnicalContact() *ContactInfo {
	if x != nil {
		return x.TechnicalContact
	}
	return nil
}

func (x *PacketBrokerNetwork) GetListed() bool {
	if x != nil {
		return x.Listed
	}
	return false
}

type PacketBrokerNetworks struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Networks []*PacketBrokerNetwork `protobuf:"bytes,1,rep,name=networks,proto3" json:"networks,omitempty"`
}

func (x *PacketBrokerNetworks) Reset() {
	*x = PacketBrokerNetworks{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerNetworks) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerNetworks) ProtoMessage() {}

func (x *PacketBrokerNetworks) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerNetworks.ProtoReflect.Descriptor instead.
func (*PacketBrokerNetworks) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{6}
}

func (x *PacketBrokerNetworks) GetNetworks() []*PacketBrokerNetwork {
	if x != nil {
		return x.Networks
	}
	return nil
}

type PacketBrokerInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current registration, unset if there isn't a registration.
	Registration *PacketBrokerNetwork `protobuf:"bytes,1,opt,name=registration,proto3" json:"registration,omitempty"`
	// Whether the server is configured as Forwarder (with gateways).
	ForwarderEnabled bool `protobuf:"varint,2,opt,name=forwarder_enabled,json=forwarderEnabled,proto3" json:"forwarder_enabled,omitempty"`
	// Whether the server is configured as Home Network (with end devices).
	HomeNetworkEnabled bool `protobuf:"varint,3,opt,name=home_network_enabled,json=homeNetworkEnabled,proto3" json:"home_network_enabled,omitempty"`
	// Whether the registration can be changed.
	RegisterEnabled bool `protobuf:"varint,4,opt,name=register_enabled,json=registerEnabled,proto3" json:"register_enabled,omitempty"`
}

func (x *PacketBrokerInfo) Reset() {
	*x = PacketBrokerInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerInfo) ProtoMessage() {}

func (x *PacketBrokerInfo) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerInfo.ProtoReflect.Descriptor instead.
func (*PacketBrokerInfo) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{7}
}

func (x *PacketBrokerInfo) GetRegistration() *PacketBrokerNetwork {
	if x != nil {
		return x.Registration
	}
	return nil
}

func (x *PacketBrokerInfo) GetForwarderEnabled() bool {
	if x != nil {
		return x.ForwarderEnabled
	}
	return false
}

func (x *PacketBrokerInfo) GetHomeNetworkEnabled() bool {
	if x != nil {
		return x.HomeNetworkEnabled
	}
	return false
}

func (x *PacketBrokerInfo) GetRegisterEnabled() bool {
	if x != nil {
		return x.RegisterEnabled
	}
	return false
}

type PacketBrokerRegisterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the network should be listed in Packet Broker.
	// If unset, the value is taken from the registration settings.
	Listed *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=listed,proto3" json:"listed,omitempty"`
}

func (x *PacketBrokerRegisterRequest) Reset() {
	*x = PacketBrokerRegisterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerRegisterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerRegisterRequest) ProtoMessage() {}

func (x *PacketBrokerRegisterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerRegisterRequest.ProtoReflect.Descriptor instead.
func (*PacketBrokerRegisterRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{8}
}

func (x *PacketBrokerRegisterRequest) GetListed() *wrapperspb.BoolValue {
	if x != nil {
		return x.Listed
	}
	return nil
}

type PacketBrokerRoutingPolicyUplink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Forward join-request messages.
	JoinRequest bool `protobuf:"varint,1,opt,name=join_request,json=joinRequest,proto3" json:"join_request,omitempty"`
	// Forward uplink messages with FPort of 0.
	MacData bool `protobuf:"varint,2,opt,name=mac_data,json=macData,proto3" json:"mac_data,omitempty"`
	// Forward uplink messages with FPort between 1 and 255.
	ApplicationData bool `protobuf:"varint,3,opt,name=application_data,json=applicationData,proto3" json:"application_data,omitempty"`
	// Forward RSSI and SNR.
	SignalQuality bool `protobuf:"varint,4,opt,name=signal_quality,json=signalQuality,proto3" json:"signal_quality,omitempty"`
	// Forward gateway location, RSSI, SNR and fine timestamp.
	Localization bool `protobuf:"varint,5,opt,name=localization,proto3" json:"localization,omitempty"`
}

func (x *PacketBrokerRoutingPolicyUplink) Reset() {
	*x = PacketBrokerRoutingPolicyUplink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerRoutingPolicyUplink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerRoutingPolicyUplink) ProtoMessage() {}

func (x *PacketBrokerRoutingPolicyUplink) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerRoutingPolicyUplink.ProtoReflect.Descriptor instead.
func (*PacketBrokerRoutingPolicyUplink) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{9}
}

func (x *PacketBrokerRoutingPolicyUplink) GetJoinRequest() bool {
	if x != nil {
		return x.JoinRequest
	}
	return false
}

func (x *PacketBrokerRoutingPolicyUplink) GetMacData() bool {
	if x != nil {
		return x.MacData
	}
	return false
}

func (x *PacketBrokerRoutingPolicyUplink) GetApplicationData() bool {
	if x != nil {
		return x.ApplicationData
	}
	return false
}

func (x *PacketBrokerRoutingPolicyUplink) GetSignalQuality() bool {
	if x != nil {
		return x.SignalQuality
	}
	return false
}

func (x *PacketBrokerRoutingPolicyUplink) GetLocalization() bool {
	if x != nil {
		return x.Localization
	}
	return false
}

type PacketBrokerRoutingPolicyDownlink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Allow join-accept messages.
	JoinAccept bool `protobuf:"varint,1,opt,name=join_accept,json=joinAccept,proto3" json:"join_accept,omitempty"`
	// Allow downlink messages with FPort of 0.
	MacData bool `protobuf:"varint,2,opt,name=mac_data,json=macData,proto3" json:"mac_data,omitempty"`
	// Allow downlink messages with FPort between 1 and 255.
	ApplicationData bool `protobuf:"varint,3,opt,name=application_data,json=applicationData,proto3" json:"application_data,omitempty"`
}

func (x *PacketBrokerRoutingPolicyDownlink) Reset() {
	*x = PacketBrokerRoutingPolicyDownlink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerRoutingPolicyDownlink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerRoutingPolicyDownlink) ProtoMessage() {}

func (x *PacketBrokerRoutingPolicyDownlink) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerRoutingPolicyDownlink.ProtoReflect.Descriptor instead.
func (*PacketBrokerRoutingPolicyDownlink) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{10}
}

func (x *PacketBrokerRoutingPolicyDownlink) GetJoinAccept() bool {
	if x != nil {
		return x.JoinAccept
	}
	return false
}

func (x *PacketBrokerRoutingPolicyDownlink) GetMacData() bool {
	if x != nil {
		return x.MacData
	}
	return false
}

func (x *PacketBrokerRoutingPolicyDownlink) GetApplicationData() bool {
	if x != nil {
		return x.ApplicationData
	}
	return false
}

type PacketBrokerDefaultRoutingPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp when the policy got last updated.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Uplink policy.
	Uplink *PacketBrokerRoutingPolicyUplink `protobuf:"bytes,2,opt,name=uplink,proto3" json:"uplink,omitempty"`
	// Downlink policy.
	Downlink *PacketBrokerRoutingPolicyDownlink `protobuf:"bytes,3,opt,name=downlink,proto3" json:"downlink,omitempty"`
}

func (x *PacketBrokerDefaultRoutingPolicy) Reset() {
	*x = PacketBrokerDefaultRoutingPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerDefaultRoutingPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerDefaultRoutingPolicy) ProtoMessage() {}

func (x *PacketBrokerDefaultRoutingPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerDefaultRoutingPolicy.ProtoReflect.Descriptor instead.
func (*PacketBrokerDefaultRoutingPolicy) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{11}
}

func (x *PacketBrokerDefaultRoutingPolicy) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *PacketBrokerDefaultRoutingPolicy) GetUplink() *PacketBrokerRoutingPolicyUplink {
	if x != nil {
		return x.Uplink
	}
	return nil
}

func (x *PacketBrokerDefaultRoutingPolicy) GetDownlink() *PacketBrokerRoutingPolicyDownlink {
	if x != nil {
		return x.Downlink
	}
	return nil
}

type PacketBrokerRoutingPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Packet Broker identifier of the Forwarder.
	ForwarderId *PacketBrokerNetworkIdentifier `protobuf:"bytes,1,opt,name=forwarder_id,json=forwarderId,proto3" json:"forwarder_id,omitempty"`
	// Packet Broker identifier of the Home Network.
	HomeNetworkId *PacketBrokerNetworkIdentifier `protobuf:"bytes,2,opt,name=home_network_id,json=homeNetworkId,proto3" json:"home_network_id,omitempty"`
	// Timestamp when the policy got last updated.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Uplink policy.
	Uplink *PacketBrokerRoutingPolicyUplink `protobuf:"bytes,4,opt,name=uplink,proto3" json:"uplink,omitempty"`
	// Downlink policy.
	Downlink *PacketBrokerRoutingPolicyDownlink `protobuf:"bytes,5,opt,name=downlink,proto3" json:"downlink,omitempty"`
}

func (x *PacketBrokerRoutingPolicy) Reset() {
	*x = PacketBrokerRoutingPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerRoutingPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerRoutingPolicy) ProtoMessage() {}

func (x *PacketBrokerRoutingPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerRoutingPolicy.ProtoReflect.Descriptor instead.
func (*PacketBrokerRoutingPolicy) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{12}
}

func (x *PacketBrokerRoutingPolicy) GetForwarderId() *PacketBrokerNetworkIdentifier {
	if x != nil {
		return x.ForwarderId
	}
	return nil
}

func (x *PacketBrokerRoutingPolicy) GetHomeNetworkId() *PacketBrokerNetworkIdentifier {
	if x != nil {
		return x.HomeNetworkId
	}
	return nil
}

func (x *PacketBrokerRoutingPolicy) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *PacketBrokerRoutingPolicy) GetUplink() *PacketBrokerRoutingPolicyUplink {
	if x != nil {
		return x.Uplink
	}
	return nil
}

func (x *PacketBrokerRoutingPolicy) GetDownlink() *PacketBrokerRoutingPolicyDownlink {
	if x != nil {
		return x.Downlink
	}
	return nil
}

type SetPacketBrokerDefaultRoutingPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uplink policy.
	Uplink *PacketBrokerRoutingPolicyUplink `protobuf:"bytes,1,opt,name=uplink,proto3" json:"uplink,omitempty"`
	// Downlink policy.
	Downlink *PacketBrokerRoutingPolicyDownlink `protobuf:"bytes,2,opt,name=downlink,proto3" json:"downlink,omitempty"`
}

func (x *SetPacketBrokerDefaultRoutingPolicyRequest) Reset() {
	*x = SetPacketBrokerDefaultRoutingPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetPacketBrokerDefaultRoutingPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetPacketBrokerDefaultRoutingPolicyRequest) ProtoMessage() {}

func (x *SetPacketBrokerDefaultRoutingPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetPacketBrokerDefaultRoutingPolicyRequest.ProtoReflect.Descriptor instead.
func (*SetPacketBrokerDefaultRoutingPolicyRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{13}
}

func (x *SetPacketBrokerDefaultRoutingPolicyRequest) GetUplink() *PacketBrokerRoutingPolicyUplink {
	if x != nil {
		return x.Uplink
	}
	return nil
}

func (x *SetPacketBrokerDefaultRoutingPolicyRequest) GetDownlink() *PacketBrokerRoutingPolicyDownlink {
	if x != nil {
		return x.Downlink
	}
	return nil
}

type ListHomeNetworkRoutingPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Limit the number of results per page.
	Limit uint32 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// Page number for pagination. 0 is interpreted as 1.
	Page uint32 `protobuf:"varint,2,opt,name=page,proto3" json:"page,omitempty"`
}

func (x *ListHomeNetworkRoutingPoliciesRequest) Reset() {
	*x = ListHomeNetworkRoutingPoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListHomeNetworkRoutingPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHomeNetworkRoutingPoliciesRequest) ProtoMessage() {}

func (x *ListHomeNetworkRoutingPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHomeNetworkRoutingPoliciesRequest.ProtoReflect.Descriptor instead.
func (*ListHomeNetworkRoutingPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{14}
}

func (x *ListHomeNetworkRoutingPoliciesRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ListHomeNetworkRoutingPoliciesRequest) GetPage() uint32 {
	if x != nil {
		return x.Page
	}
	return 0
}

type PacketBrokerRoutingPolicies struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Policies []*PacketBrokerRoutingPolicy `protobuf:"bytes,1,rep,name=policies,proto3" json:"policies,omitempty"`
}

func (x *PacketBrokerRoutingPolicies) Reset() {
	*x = PacketBrokerRoutingPolicies{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerRoutingPolicies) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerRoutingPolicies) ProtoMessage() {}

func (x *PacketBrokerRoutingPolicies) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerRoutingPolicies.ProtoReflect.Descriptor instead.
func (*PacketBrokerRoutingPolicies) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{15}
}

func (x *PacketBrokerRoutingPolicies) GetPolicies() []*PacketBrokerRoutingPolicy {
	if x != nil {
		return x.Policies
	}
	return nil
}

type SetPacketBrokerRoutingPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Packet Broker identifier of the Home Network.
	HomeNetworkId *PacketBrokerNetworkIdentifier `protobuf:"bytes,1,opt,name=home_network_id,json=homeNetworkId,proto3" json:"home_network_id,omitempty"`
	// Uplink policy.
	Uplink *PacketBrokerRoutingPolicyUplink `protobuf:"bytes,2,opt,name=uplink,proto3" json:"uplink,omitempty"`
	// Downlink policy.
	Downlink *PacketBrokerRoutingPolicyDownlink `protobuf:"bytes,3,opt,name=downlink,proto3" json:"downlink,omitempty"`
}

func (x *SetPacketBrokerRoutingPolicyRequest) Reset() {
	*x = SetPacketBrokerRoutingPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetPacketBrokerRoutingPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetPacketBrokerRoutingPolicyRequest) ProtoMessage() {}

func (x *SetPacketBrokerRoutingPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetPacketBrokerRoutingPolicyRequest.ProtoReflect.Descriptor instead.
func (*SetPacketBrokerRoutingPolicyRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{16}
}

func (x *SetPacketBrokerRoutingPolicyRequest) GetHomeNetworkId() *PacketBrokerNetworkIdentifier {
	if x != nil {
		return x.HomeNetworkId
	}
	return nil
}

func (x *SetPacketBrokerRoutingPolicyRequest) GetUplink() *PacketBrokerRoutingPolicyUplink {
	if x != nil {
		return x.Uplink
	}
	return nil
}

func (x *SetPacketBrokerRoutingPolicyRequest) GetDownlink() *PacketBrokerRoutingPolicyDownlink {
	if x != nil {
		return x.Downlink
	}
	return nil
}

type PacketBrokerGatewayVisibility struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Show location.
	Location bool `protobuf:"varint,1,opt,name=location,proto3" json:"location,omitempty"`
	// Show antenna placement (indoor/outdoor).
	AntennaPlacement bool `protobuf:"varint,2,opt,name=antenna_placement,json=antennaPlacement,proto3" json:"antenna_placement,omitempty"`
	// Show antenna count.
	AntennaCount bool `protobuf:"varint,3,opt,name=antenna_count,json=antennaCount,proto3" json:"antenna_count,omitempty"`
	// Show whether the gateway produces fine timestamps.
	FineTimestamps bool `protobuf:"varint,4,opt,name=fine_timestamps,json=fineTimestamps,proto3" json:"fine_timestamps,omitempty"`
	// Show contact information.
	ContactInfo bool `protobuf:"varint,5,opt,name=contact_info,json=contactInfo,proto3" json:"contact_info,omitempty"`
	// Show status (online/offline).
	Status bool `protobuf:"varint,6,opt,name=status,proto3" json:"status,omitempty"`
	// Show frequency plan.
	FrequencyPlan bool `protobuf:"varint,8,opt,name=frequency_plan,json=frequencyPlan,proto3" json:"frequency_plan,omitempty"`
	// Show receive and transmission packet rates.
	PacketRates bool `protobuf:"varint,9,opt,name=packet_rates,json=packetRates,proto3" json:"packet_rates,omitempty"`
}

func (x *PacketBrokerGatewayVisibility) Reset() {
	*x = PacketBrokerGatewayVisibility{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerGatewayVisibility) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerGatewayVisibility) ProtoMessage() {}

func (x *PacketBrokerGatewayVisibility) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerGatewayVisibility.ProtoReflect.Descriptor instead.
func (*PacketBrokerGatewayVisibility) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{17}
}

func (x *PacketBrokerGatewayVisibility) GetLocation() bool {
	if x != nil {
		return x.Location
	}
	return false
}

func (x *PacketBrokerGatewayVisibility) GetAntennaPlacement() bool {
	if x != nil {
		return x.AntennaPlacement
	}
	return false
}

func (x *PacketBrokerGatewayVisibility) GetAntennaCount() bool {
	if x != nil {
		return x.AntennaCount
	}
	return false
}

func (x *PacketBrokerGatewayVisibility) GetFineTimestamps() bool {
	if x != nil {
		return x.FineTimestamps
	}
	return false
}

func (x *PacketBrokerGatewayVisibility) GetContactInfo() bool {
	if x != nil {
		return x.ContactInfo
	}
	return false
}

func (x *PacketBrokerGatewayVisibility) GetStatus() bool {
	if x != nil {
		return x.Status
	}
	return false
}

func (x *PacketBrokerGatewayVisibility) GetFrequencyPlan() bool {
	if x != nil {
		return x.FrequencyPlan
	}
	return false
}

func (x *PacketBrokerGatewayVisibility) GetPacketRates() bool {
	if x != nil {
		return x.PacketRates
	}
	return false
}

type PacketBrokerDefaultGatewayVisibility struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp when the policy got last updated.
	UpdatedAt  *timestamppb.Timestamp         `protobuf:"bytes,1,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	Visibility *PacketBrokerGatewayVisibility `protobuf:"bytes,2,opt,name=visibility,proto3" json:"visibility,omitempty"`
}

func (x *PacketBrokerDefaultGatewayVisibility) Reset() {
	*x = PacketBrokerDefaultGatewayVisibility{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerDefaultGatewayVisibility) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerDefaultGatewayVisibility) ProtoMessage() {}

func (x *PacketBrokerDefaultGatewayVisibility) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerDefaultGatewayVisibility.ProtoReflect.Descriptor instead.
func (*PacketBrokerDefaultGatewayVisibility) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{18}
}

func (x *PacketBrokerDefaultGatewayVisibility) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *PacketBrokerDefaultGatewayVisibility) GetVisibility() *PacketBrokerGatewayVisibility {
	if x != nil {
		return x.Visibility
	}
	return nil
}

type SetPacketBrokerDefaultGatewayVisibilityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Visibility *PacketBrokerGatewayVisibility `protobuf:"bytes,1,opt,name=visibility,proto3" json:"visibility,omitempty"`
}

func (x *SetPacketBrokerDefaultGatewayVisibilityRequest) Reset() {
	*x = SetPacketBrokerDefaultGatewayVisibilityRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetPacketBrokerDefaultGatewayVisibilityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetPacketBrokerDefaultGatewayVisibilityRequest) ProtoMessage() {}

func (x *SetPacketBrokerDefaultGatewayVisibilityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetPacketBrokerDefaultGatewayVisibilityRequest.ProtoReflect.Descriptor instead.
func (*SetPacketBrokerDefaultGatewayVisibilityRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{19}
}

func (x *SetPacketBrokerDefaultGatewayVisibilityRequest) GetVisibility() *PacketBrokerGatewayVisibility {
	if x != nil {
		return x.Visibility
	}
	return nil
}

type ListPacketBrokerNetworksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Limit the number of results per page.
	Limit uint32 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// Page number for pagination. 0 is interpreted as 1.
	Page uint32 `protobuf:"varint,2,opt,name=page,proto3" json:"page,omitempty"`
	// If true, list only the Forwarders and Home Networks with whom a routing policy has been defined in either direction.
	WithRoutingPolicy bool `protobuf:"varint,3,opt,name=with_routing_policy,json=withRoutingPolicy,proto3" json:"with_routing_policy,omitempty"`
	// Filter by tenant ID.
	TenantIdContains string `protobuf:"bytes,4,opt,name=tenant_id_contains,json=tenantIdContains,proto3" json:"tenant_id_contains,omitempty"`
	// Filter by name.
	NameContains string `protobuf:"bytes,5,opt,name=name_contains,json=nameContains,proto3" json:"name_contains,omitempty"`
}

func (x *ListPacketBrokerNetworksRequest) Reset() {
	*x = ListPacketBrokerNetworksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPacketBrokerNetworksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPacketBrokerNetworksRequest) ProtoMessage() {}

func (x *ListPacketBrokerNetworksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPacketBrokerNetworksRequest.ProtoReflect.Descriptor instead.
func (*ListPacketBrokerNetworksRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{20}
}

func (x *ListPacketBrokerNetworksRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ListPacketBrokerNetworksRequest) GetPage() uint32 {
	if x != nil {
		return x.Page
	}
	return 0
}

func (x *ListPacketBrokerNetworksRequest) GetWithRoutingPolicy() bool {
	if x != nil {
		return x.WithRoutingPolicy
	}
	return false
}

func (x *ListPacketBrokerNetworksRequest) GetTenantIdContains() string {
	if x != nil {
		return x.TenantIdContains
	}
	return ""
}

func (x *ListPacketBrokerNetworksRequest) GetNameContains() string {
	if x != nil {
		return x.NameContains
	}
	return ""
}

type ListPacketBrokerHomeNetworksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Limit the number of results per page.
	Limit uint32 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// Page number for pagination. 0 is interpreted as 1.
	Page uint32 `protobuf:"varint,2,opt,name=page,proto3" json:"page,omitempty"`
	// Filter by tenant ID.
	TenantIdContains string `protobuf:"bytes,3,opt,name=tenant_id_contains,json=tenantIdContains,proto3" json:"tenant_id_contains,omitempty"`
	// Filter by name.
	NameContains string `protobuf:"bytes,4,opt,name=name_contains,json=nameContains,proto3" json:"name_contains,omitempty"`
}

func (x *ListPacketBrokerHomeNetworksRequest) Reset() {
	*x = ListPacketBrokerHomeNetworksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPacketBrokerHomeNetworksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPacketBrokerHomeNetworksRequest) ProtoMessage() {}

func (x *ListPacketBrokerHomeNetworksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPacketBrokerHomeNetworksRequest.ProtoReflect.Descriptor instead.
func (*ListPacketBrokerHomeNetworksRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{21}
}

func (x *ListPacketBrokerHomeNetworksRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ListPacketBrokerHomeNetworksRequest) GetPage() uint32 {
	if x != nil {
		return x.Page
	}
	return 0
}

func (x *ListPacketBrokerHomeNetworksRequest) GetTenantIdContains() string {
	if x != nil {
		return x.TenantIdContains
	}
	return ""
}

func (x *ListPacketBrokerHomeNetworksRequest) GetNameContains() string {
	if x != nil {
		return x.NameContains
	}
	return ""
}

type ListForwarderRoutingPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Packet Broker identifier of the Home Network.
	HomeNetworkId *PacketBrokerNetworkIdentifier `protobuf:"bytes,1,opt,name=home_network_id,json=homeNetworkId,proto3" json:"home_network_id,omitempty"`
	// Limit the number of results per page.
	Limit uint32 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	// Page number for pagination. 0 is interpreted as 1.
	Page uint32 `protobuf:"varint,3,opt,name=page,proto3" json:"page,omitempty"`
}

func (x *ListForwarderRoutingPoliciesRequest) Reset() {
	*x = ListForwarderRoutingPoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListForwarderRoutingPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListForwarderRoutingPoliciesRequest) ProtoMessage() {}

func (x *ListForwarderRoutingPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListForwarderRoutingPoliciesRequest.ProtoReflect.Descriptor instead.
func (*ListForwarderRoutingPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{22}
}

func (x *ListForwarderRoutingPoliciesRequest) GetHomeNetworkId() *PacketBrokerNetworkIdentifier {
	if x != nil {
		return x.HomeNetworkId
	}
	return nil
}

func (x *ListForwarderRoutingPoliciesRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ListForwarderRoutingPoliciesRequest) GetPage() uint32 {
	if x != nil {
		return x.Page
	}
	return 0
}

type PacketBrokerAgentUplinkToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ForwarderNetId     []byte `protobuf:"bytes,1,opt,name=forwarder_net_id,json=forwarderNetId,proto3" json:"forwarder_net_id,omitempty"`
	ForwarderTenantId  string `protobuf:"bytes,2,opt,name=forwarder_tenant_id,json=forwarderTenantId,proto3" json:"forwarder_tenant_id,omitempty"`
	ForwarderClusterId string `protobuf:"bytes,3,opt,name=forwarder_cluster_id,json=forwarderClusterId,proto3" json:"forwarder_cluster_id,omitempty"`
}

func (x *PacketBrokerAgentUplinkToken) Reset() {
	*x = PacketBrokerAgentUplinkToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerAgentUplinkToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerAgentUplinkToken) ProtoMessage() {}

func (x *PacketBrokerAgentUplinkToken) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerAgentUplinkToken.ProtoReflect.Descriptor instead.
func (*PacketBrokerAgentUplinkToken) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{23}
}

func (x *PacketBrokerAgentUplinkToken) GetForwarderNetId() []byte {
	if x != nil {
		return x.ForwarderNetId
	}
	return nil
}

func (x *PacketBrokerAgentUplinkToken) GetForwarderTenantId() string {
	if x != nil {
		return x.ForwarderTenantId
	}
	return ""
}

func (x *PacketBrokerAgentUplinkToken) GetForwarderClusterId() string {
	if x != nil {
		return x.ForwarderClusterId
	}
	return ""
}

type PacketBrokerAgentGatewayUplinkToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayUid string `protobuf:"bytes,1,opt,name=gateway_uid,json=gatewayUid,proto3" json:"gateway_uid,omitempty"`
	Token      []byte `protobuf:"bytes,2,opt,name=token,proto3" json:"token,omitempty"`
}

func (x *PacketBrokerAgentGatewayUplinkToken) Reset() {
	*x = PacketBrokerAgentGatewayUplinkToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerAgentGatewayUplinkToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerAgentGatewayUplinkToken) ProtoMessage() {}

func (x *PacketBrokerAgentGatewayUplinkToken) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerAgentGatewayUplinkToken.ProtoReflect.Descriptor instead.
func (*PacketBrokerAgentGatewayUplinkToken) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{24}
}

func (x *PacketBrokerAgentGatewayUplinkToken) GetGatewayUid() string {
	if x != nil {
		return x.GatewayUid
	}
	return ""
}

func (x *PacketBrokerAgentGatewayUplinkToken) GetToken() []byte {
	if x != nil {
		return x.Token
	}
	return nil
}

type PacketBrokerAgentCompoundUplinkToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Gateway   []byte                        `protobuf:"bytes,1,opt,name=gateway,proto3" json:"gateway,omitempty"`
	Forwarder []byte                        `protobuf:"bytes,2,opt,name=forwarder,proto3" json:"forwarder,omitempty"`
	Agent     *PacketBrokerAgentUplinkToken `protobuf:"bytes,3,opt,name=agent,proto3" json:"agent,omitempty"`
}

func (x *PacketBrokerAgentCompoundUplinkToken) Reset() {
	*x = PacketBrokerAgentCompoundUplinkToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerAgentCompoundUplinkToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerAgentCompoundUplinkToken) ProtoMessage() {}

func (x *PacketBrokerAgentCompoundUplinkToken) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerAgentCompoundUplinkToken.ProtoReflect.Descriptor instead.
func (*PacketBrokerAgentCompoundUplinkToken) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{25}
}

func (x *PacketBrokerAgentCompoundUplinkToken) GetGateway() []byte {
	if x != nil {
		return x.Gateway
	}
	return nil
}

func (x *PacketBrokerAgentCompoundUplinkToken) GetForwarder() []byte {
	if x != nil {
		return x.Forwarder
	}
	return nil
}

func (x *PacketBrokerAgentCompoundUplinkToken) GetAgent() *PacketBrokerAgentUplinkToken {
	if x != nil {
		return x.Agent
	}
	return nil
}

type PacketBrokerAgentEncryptedPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ciphertext []byte `protobuf:"bytes,1,opt,name=ciphertext,proto3" json:"ciphertext,omitempty"`
	Nonce      []byte `protobuf:"bytes,2,opt,name=nonce,proto3" json:"nonce,omitempty"`
}

func (x *PacketBrokerAgentEncryptedPayload) Reset() {
	*x = PacketBrokerAgentEncryptedPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerAgentEncryptedPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerAgentEncryptedPayload) ProtoMessage() {}

func (x *PacketBrokerAgentEncryptedPayload) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerAgentEncryptedPayload.ProtoReflect.Descriptor instead.
func (*PacketBrokerAgentEncryptedPayload) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{26}
}

func (x *PacketBrokerAgentEncryptedPayload) GetCiphertext() []byte {
	if x != nil {
		return x.Ciphertext
	}
	return nil
}

func (x *PacketBrokerAgentEncryptedPayload) GetNonce() []byte {
	if x != nil {
		return x.Nonce
	}
	return nil
}

type PacketBrokerGateway_GatewayIdentifiers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayId string `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	Eui       []byte `protobuf:"bytes,2,opt,name=eui,proto3" json:"eui,omitempty"`
}

func (x *PacketBrokerGateway_GatewayIdentifiers) Reset() {
	*x = PacketBrokerGateway_GatewayIdentifiers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerGateway_GatewayIdentifiers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerGateway_GatewayIdentifiers) ProtoMessage() {}

func (x *PacketBrokerGateway_GatewayIdentifiers) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerGateway_GatewayIdentifiers.ProtoReflect.Descriptor instead.
func (*PacketBrokerGateway_GatewayIdentifiers) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP(), []int{0, 0}
}

func (x *PacketBrokerGateway_GatewayIdentifiers) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *PacketBrokerGateway_GatewayIdentifiers) GetEui() []byte {
	if x != nil {
		return x.Eui
	}
	return nil
}

var File_ttn_lorawan_v3_packetbrokeragent_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_packetbrokeragent_proto_rawDesc = []byte{
	0x0a, 0x26, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67,
	0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2f, 0x6a, 0x73, 0x6f, 0x6e, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x74, 0x74, 0x6e,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x65,
	0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74,
	0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1d, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb6, 0x08, 0x0a, 0x13, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12,
	0x52, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x03,
	0x69, 0x64, 0x73, 0x12, 0x4a, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x0a, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x0a,
	0x18, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x64, 0x0a, 0x16, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x15,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x12, 0x5a, 0x0a, 0x11, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x63,
	0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x72,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52,
	0x10, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x12, 0x44, 0x0a, 0x08, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x73, 0x18, 0x0d, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x6e, 0x74, 0x65,
	0x6e, 0x6e, 0x61, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x08, 0x52, 0x08, 0x61,
	0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x12, 0x27, 0x0a, 0x0f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x12, 0x3c, 0x0a, 0x12, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x0e, 0xfa, 0x42, 0x0b, 0x92, 0x01, 0x08, 0x10, 0x08, 0x22, 0x04, 0x72, 0x02, 0x18,
	0x40, 0x52, 0x10, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x6c, 0x61, 0x6e,
	0x49, 0x64, 0x73, 0x12, 0x3d, 0x0a, 0x1b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x1c, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x06, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x34, 0x0a, 0x07, 0x72, 0x78,
	0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c,
	0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x72, 0x78, 0x52, 0x61, 0x74, 0x65,
	0x12, 0x34, 0x0a, 0x07, 0x74, 0x78, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06,
	0x74, 0x78, 0x52, 0x61, 0x74, 0x65, 0x1a, 0xa7, 0x02, 0x0a, 0x12, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x47, 0x0a,
	0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x28, 0xfa, 0x42, 0x25, 0x72, 0x23, 0x18, 0x24, 0x32, 0x1f, 0x5e, 0x5b, 0x61, 0x2d,
	0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x5f, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d,
	0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x09, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x12, 0xc7, 0x01, 0x0a, 0x03, 0x65, 0x75, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x42, 0xb4, 0x01, 0x92, 0x41, 0x21, 0x4a, 0x12, 0x22, 0x37, 0x30, 0x42,
	0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30, 0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02,
	0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04,
	0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68,
	0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33,
	0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68,
	0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76,
	0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61,
	0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x03, 0x65, 0x75, 0x69,
	0x22, 0xa6, 0x01, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x65,
	0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x07, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x07, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x39,
	0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5d, 0x0a, 0x21, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38,
	0x0a, 0x0a, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x74, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6f,
	0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x74, 0x6c, 0x22, 0x7f, 0x0a, 0x1d, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x15, 0x0a, 0x06, 0x6e, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x6e, 0x65, 0x74, 0x49, 0x64,
	0x12, 0x47, 0x0a, 0x09, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x42, 0x27, 0x72, 0x25, 0x18, 0x24, 0x32, 0x21, 0x5e, 0x5b,
	0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61,
	0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x7c, 0x5e, 0x24, 0x52,
	0x08, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x22, 0x98, 0x01, 0x0a, 0x18, 0x50, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x44, 0x65, 0x76, 0x41, 0x64, 0x64,
	0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x45, 0x0a, 0x0f, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x44, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x0d,
	0x64, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x35, 0x0a,
	0x17, 0x68, 0x6f, 0x6d, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14,
	0x68, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x49, 0x64, 0x22, 0xbc, 0x03, 0x0a, 0x13, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42,
	0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3d, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x50, 0x0a, 0x0f, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x44, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x52, 0x0d, 0x64, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x73, 0x12, 0x4a, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x0a, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x0a, 0x18, 0x01,
	0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x52, 0x0a,
	0x16, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x15, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x12, 0x48, 0x0a, 0x11, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x10, 0x74, 0x65, 0x63, 0x68, 0x6e,
	0x69, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6c,
	0x69, 0x73, 0x74, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x6c, 0x69, 0x73,
	0x74, 0x65, 0x64, 0x22, 0x57, 0x0a, 0x14, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f,
	0x6b, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x3f, 0x0a, 0x08, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50,
	0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x08, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x22, 0xe5, 0x01, 0x0a,
	0x10, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x47, 0x0a, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42,
	0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x0c, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x11, 0x66, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x30, 0x0a, 0x14, 0x68, 0x6f, 0x6d, 0x65, 0x5f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x68, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x22, 0x5b, 0x0a, 0x1b, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x06, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x06, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10,
	0x01, 0x22, 0xd5, 0x01, 0x0a, 0x1f, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b,
	0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x55,
	0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x21, 0x0a, 0x0c, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x6a, 0x6f, 0x69,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x61, 0x63, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x6d, 0x61, 0x63, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x12, 0x25,
	0x0a, 0x0e, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x22, 0x0a, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x6c, 0x6f, 0x63,
	0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8a, 0x01, 0x0a, 0x21, 0x50, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x12,
	0x1f, 0x0a, 0x0b, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x6a, 0x6f, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74,
	0x12, 0x19, 0x0a, 0x08, 0x6d, 0x61, 0x63, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x6d, 0x61, 0x63, 0x44, 0x61, 0x74, 0x61, 0x12, 0x29, 0x0a, 0x10, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x22, 0xf5, 0x01, 0x0a, 0x20, 0x50, 0x61, 0x63, 0x6b, 0x65,
	0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x39, 0x0a, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x12,
	0x4d, 0x0a, 0x08, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x52,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x08, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x97,
	0x03, 0x0a, 0x19, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x52,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x50, 0x0a, 0x0c,
	0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x52, 0x0b, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x55,
	0x0a, 0x0f, 0x68, 0x6f, 0x6d, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42,
	0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x0d, 0x68, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74,
	0x12, 0x47, 0x0a, 0x06, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e,
	0x6b, 0x52, 0x06, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x4d, 0x0a, 0x08, 0x64, 0x6f, 0x77,
	0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63,
	0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x08,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0xd8, 0x01, 0x0a, 0x2a, 0x53, 0x65, 0x74,
	0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x75, 0x70, 0x6c, 0x69, 0x6e,
	0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42,
	0x72, 0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x06, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x57, 0x0a, 0x08, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x64, 0x6f, 0x77, 0x6e, 0x6c,
	0x69, 0x6e, 0x6b, 0x22, 0x5b, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x6f, 0x6d, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x05,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0x2a, 0x03, 0x18, 0xe8, 0x07, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x70, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x61, 0x67, 0x65,
	0x22, 0x64, 0x0a, 0x1b, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72,
	0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12,
	0x45, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x52,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x08, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x22, 0xa8, 0x02, 0x0a, 0x23, 0x53, 0x65, 0x74, 0x50, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55,
	0x0a, 0x0f, 0x68, 0x6f, 0x6d, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42,
	0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x0d, 0x68, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x49, 0x64, 0x12, 0x51, 0x0a, 0x06, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f,
	0x6b, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x06, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x57, 0x0a, 0x08, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e,
	0x6b, 0x22, 0xc5, 0x02, 0x0a, 0x1d, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b,
	0x65, 0x72, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x2b, 0x0a, 0x11, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x61, 0x6e, 0x74, 0x65,
	0x6e, 0x6e, 0x61, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d,
	0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x27, 0x0a, 0x0f, 0x66, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x66, 0x69, 0x6e, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x66,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x21, 0x0a, 0x0c,
	0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x61, 0x74, 0x65, 0x73, 0x3a,
	0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x01, 0x22, 0xb0, 0x01, 0x0a, 0x24, 0x50, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x12, 0x39, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x4d, 0x0a,
	0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x22, 0x89, 0x01, 0x0a,
	0x2e, 0x53, 0x65, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72,
	0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x56, 0x69,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x57, 0x0a, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65,
	0x72, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x76, 0x69,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x22, 0xea, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x05,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0x2a, 0x03, 0x18, 0xe8, 0x07, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x70, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x61, 0x67, 0x65,
	0x12, 0x2e, 0x0a, 0x13, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x77,
	0x69, 0x74, 0x68, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x35, 0x0a, 0x12, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42,
	0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x10, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x2c, 0x0a, 0x0d, 0x6e, 0x61, 0x6d, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07,
	0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x0c, 0x6e, 0x61, 0x6d, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x73, 0x22, 0xbe, 0x01, 0x0a, 0x23, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x48, 0x6f, 0x6d, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a,
	0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x2a, 0x03, 0x18, 0xe8, 0x07, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x70, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x61, 0x67,
	0x65, 0x12, 0x35, 0x0a, 0x12, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa,
	0x42, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x10, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x49, 0x64,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x2c, 0x0a, 0x0d, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x0c, 0x6e, 0x61, 0x6d, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x22, 0xa6, 0x01, 0x0a, 0x23, 0x4c, 0x69, 0x73, 0x74, 0x46,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55,
	0x0a, 0x0f, 0x68, 0x6f, 0x6d, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42,
	0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x0d, 0x68, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70,
	0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x61, 0x67, 0x65, 0x22,
	0xaa, 0x01, 0x0a, 0x1c, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x28, 0x0a, 0x10, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x6e, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x66, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x13, 0x66, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x65, 0x72, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x14, 0x66, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x65, 0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x22, 0x5c, 0x0a, 0x23,
	0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x75,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x55, 0x69, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa2, 0x01, 0x0a, 0x24, 0x50,
	0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x1c, 0x0a,
	0x09, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x09, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x12, 0x42, 0x0a, 0x05, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x22,
	0x59, 0x0a, 0x21, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x74, 0x65,
	0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72,
	0x74, 0x65, 0x78, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x32, 0xeb, 0x02, 0x0a, 0x05, 0x47,
	0x73, 0x50, 0x62, 0x61, 0x12, 0x4d, 0x0a, 0x0d, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x55,
	0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x55, 0x70,
	0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x74, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x12, 0x30, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x1a, 0x9c, 0x01, 0x92, 0x41, 0x98, 0x01,
	0x12, 0x95, 0x01, 0x54, 0x68, 0x65, 0x20, 0x47, 0x73, 0x50, 0x62, 0x61, 0x20, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x73, 0x20, 0x61, 0x20,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x74,
	0x6f, 0x20, 0x61, 0x20, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x20, 0x42, 0x72, 0x6f, 0x6b, 0x65,
	0x72, 0x20, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x20, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73,
	0x20, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x2d, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x20, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x20, 0x61, 0x6e, 0x64, 0x20,
	0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x20,
	0x74, 0x6f, 0x20, 0x62, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x65, 0x6e,
	0x64, 0x20, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2e, 0x32, 0xf2, 0x01, 0x0a, 0x05, 0x4e, 0x73, 0x50,
	0x62, 0x61, 0x12, 0x4a, 0x0a, 0x0f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x1f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x9c,
	0x01, 0x92, 0x41, 0x98, 0x01, 0x12, 0x95, 0x01, 0x54, 0x68, 0x65, 0x20, 0x4e, 0x73, 0x50, 0x62,
	0x61, 0x20, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x73, 0x20, 0x61, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x20, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x20,
	0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x20, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x20, 0x54, 0x68,
	0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x2d, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x20, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x20, 0x61, 0x6e, 0x64, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x64, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20,
	0x62, 0x79, 0x20, 0x65, 0x6e, 0x64, 0x20, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2e, 0x32, 0xc7, 0x16,
	0x0a, 0x03, 0x50, 0x62, 0x61, 0x12, 0x56, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x20, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x11, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x0b, 0x12, 0x09, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x92, 0x01,
	0x0a, 0x08, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x12, 0x2b, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42,
	0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x34, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2e, 0x3a, 0x01, 0x2a, 0x5a, 0x16, 0x3a, 0x01, 0x2a, 0x22, 0x11, 0x2f, 0x70,
	0x62, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0x11, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x0a, 0x44, 0x65, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x19, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x13, 0x2a, 0x11, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xa9, 0x01, 0x0a, 0x1e,
	0x4c, 0x69, 0x73, 0x74, 0x48, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x35,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x48, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f,
	0x6b, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x22, 0x23, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x12, 0x1b, 0x2f, 0x70, 0x62, 0x61,
	0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0xd9, 0x01, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x48,
	0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42,
	0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x1a, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x22, 0x60, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x5a, 0x32, 0x12, 0x30, 0x2f, 0x70, 0x62,
	0x61, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x7b, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x24, 0x2f,
	0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x5f,
	0x69, 0x64, 0x7d, 0x12, 0x96, 0x03, 0x0a, 0x1b, 0x53, 0x65, 0x74, 0x48, 0x6f, 0x6d, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x33, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72,
	0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0xa9, 0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa2, 0x02, 0x3a, 0x01, 0x2a, 0x5a, 0x39, 0x3a,
	0x01, 0x2a, 0x22, 0x34, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2d, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f,
	0x7b, 0x68, 0x6f, 0x6d, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x5a, 0x55, 0x3a, 0x01, 0x2a, 0x1a, 0x50, 0x2f,
	0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x68, 0x6f, 0x6d, 0x65,
	0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x7b, 0x68, 0x6f, 0x6d, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x69, 0x64, 0x2e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x5a,
	0x55, 0x3a, 0x01, 0x2a, 0x22, 0x50, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2d,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x2f, 0x7b, 0x68, 0x6f, 0x6d, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x69, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7b, 0x68, 0x6f, 0x6d, 0x65,
	0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x2e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x1a, 0x34, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f, 0x6d,
	0x65, 0x2d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x2f, 0x7b, 0x68, 0x6f, 0x6d, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x69, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0xc9, 0x01, 0x0a,
	0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x60, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x5a, 0x32,
	0x2a, 0x30, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2d, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x6e,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7b, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x2a, 0x24, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2d, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f,
	0x7b, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x9b, 0x01, 0x0a, 0x22, 0x47, 0x65, 0x74,
	0x48, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x30, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42,
	0x72, 0x6f, 0x6b, 0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x25, 0x12, 0x23, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2d, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x12, 0xd2, 0x01, 0x0a, 0x22, 0x53, 0x65, 0x74, 0x48, 0x6f,
	0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3a, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53,
	0x65, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x3a, 0x01, 0x2a, 0x5a, 0x28, 0x3a, 0x01,
	0x2a, 0x22, 0x23, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2d, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x1a, 0x23, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f, 0x6d,
	0x65, 0x2d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x2f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x12, 0x84, 0x01, 0x0a, 0x25,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x2a, 0x23, 0x2f,
	0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x12, 0xaf, 0x01, 0x0a, 0x26, 0x47, 0x65, 0x74, 0x48, 0x6f, 0x6d, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x34, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f,
	0x6b, 0x65, 0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x22, 0x37, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2d, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2d,
	0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x12, 0xf2, 0x01, 0x0a, 0x26, 0x53, 0x65, 0x74, 0x48, 0x6f, 0x6d, 0x65,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12,
	0x3e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x53, 0x65, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72,
	0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x56, 0x69,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x70, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6a, 0x3a,
	0x01, 0x2a, 0x5a, 0x34, 0x3a, 0x01, 0x2a, 0x22, 0x2f, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f,
	0x6d, 0x65, 0x2d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x2d, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x1a, 0x2f, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x68,
	0x6f, 0x6d, 0x65, 0x2d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x2d, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x12, 0x94, 0x01, 0x0a, 0x29, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x48, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x56, 0x69, 0x73,
	0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a,
	0x2f, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2d, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x2f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2d, 0x76, 0x69, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x12, 0x7c, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x12, 0x2f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b,
	0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x22, 0x15, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x0f, 0x12,
	0x0d, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x89,
	0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x12, 0x33, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42,
	0x72, 0x6f, 0x6b, 0x65, 0x72, 0x48, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x22, 0x1a,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x14, 0x12, 0x12, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x68, 0x6f, 0x6d,
	0x65, 0x2d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0xa2, 0x01, 0x0a, 0x1c, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x33, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x22, 0x20, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x1a, 0x12, 0x18, 0x2f, 0x70, 0x62, 0x61, 0x2f, 0x66, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x1a,
	0x26, 0x92, 0x41, 0x23, 0x12, 0x21, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x20, 0x70, 0x65, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x20, 0x76, 0x69, 0x61, 0x20, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x20,
	0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x2e, 0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68,
	0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33,
	0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescData = file_ttn_lorawan_v3_packetbrokeragent_proto_rawDesc
)

func file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_packetbrokeragent_proto_rawDescData
}

var file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes = make([]protoimpl.MessageInfo, 28)
var file_ttn_lorawan_v3_packetbrokeragent_proto_goTypes = []interface{}{
	(*PacketBrokerGateway)(nil),                            // 0: ttn.lorawan.v3.PacketBrokerGateway
	(*UpdatePacketBrokerGatewayRequest)(nil),               // 1: ttn.lorawan.v3.UpdatePacketBrokerGatewayRequest
	(*UpdatePacketBrokerGatewayResponse)(nil),              // 2: ttn.lorawan.v3.UpdatePacketBrokerGatewayResponse
	(*PacketBrokerNetworkIdentifier)(nil),                  // 3: ttn.lorawan.v3.PacketBrokerNetworkIdentifier
	(*PacketBrokerDevAddrBlock)(nil),                       // 4: ttn.lorawan.v3.PacketBrokerDevAddrBlock
	(*PacketBrokerNetwork)(nil),                            // 5: ttn.lorawan.v3.PacketBrokerNetwork
	(*PacketBrokerNetworks)(nil),                           // 6: ttn.lorawan.v3.PacketBrokerNetworks
	(*PacketBrokerInfo)(nil),                               // 7: ttn.lorawan.v3.PacketBrokerInfo
	(*PacketBrokerRegisterRequest)(nil),                    // 8: ttn.lorawan.v3.PacketBrokerRegisterRequest
	(*PacketBrokerRoutingPolicyUplink)(nil),                // 9: ttn.lorawan.v3.PacketBrokerRoutingPolicyUplink
	(*PacketBrokerRoutingPolicyDownlink)(nil),              // 10: ttn.lorawan.v3.PacketBrokerRoutingPolicyDownlink
	(*PacketBrokerDefaultRoutingPolicy)(nil),               // 11: ttn.lorawan.v3.PacketBrokerDefaultRoutingPolicy
	(*PacketBrokerRoutingPolicy)(nil),                      // 12: ttn.lorawan.v3.PacketBrokerRoutingPolicy
	(*SetPacketBrokerDefaultRoutingPolicyRequest)(nil),     // 13: ttn.lorawan.v3.SetPacketBrokerDefaultRoutingPolicyRequest
	(*ListHomeNetworkRoutingPoliciesRequest)(nil),          // 14: ttn.lorawan.v3.ListHomeNetworkRoutingPoliciesRequest
	(*PacketBrokerRoutingPolicies)(nil),                    // 15: ttn.lorawan.v3.PacketBrokerRoutingPolicies
	(*SetPacketBrokerRoutingPolicyRequest)(nil),            // 16: ttn.lorawan.v3.SetPacketBrokerRoutingPolicyRequest
	(*PacketBrokerGatewayVisibility)(nil),                  // 17: ttn.lorawan.v3.PacketBrokerGatewayVisibility
	(*PacketBrokerDefaultGatewayVisibility)(nil),           // 18: ttn.lorawan.v3.PacketBrokerDefaultGatewayVisibility
	(*SetPacketBrokerDefaultGatewayVisibilityRequest)(nil), // 19: ttn.lorawan.v3.SetPacketBrokerDefaultGatewayVisibilityRequest
	(*ListPacketBrokerNetworksRequest)(nil),                // 20: ttn.lorawan.v3.ListPacketBrokerNetworksRequest
	(*ListPacketBrokerHomeNetworksRequest)(nil),            // 21: ttn.lorawan.v3.ListPacketBrokerHomeNetworksRequest
	(*ListForwarderRoutingPoliciesRequest)(nil),            // 22: ttn.lorawan.v3.ListForwarderRoutingPoliciesRequest
	(*PacketBrokerAgentUplinkToken)(nil),                   // 23: ttn.lorawan.v3.PacketBrokerAgentUplinkToken
	(*PacketBrokerAgentGatewayUplinkToken)(nil),            // 24: ttn.lorawan.v3.PacketBrokerAgentGatewayUplinkToken
	(*PacketBrokerAgentCompoundUplinkToken)(nil),           // 25: ttn.lorawan.v3.PacketBrokerAgentCompoundUplinkToken
	(*PacketBrokerAgentEncryptedPayload)(nil),              // 26: ttn.lorawan.v3.PacketBrokerAgentEncryptedPayload
	(*PacketBrokerGateway_GatewayIdentifiers)(nil),         // 27: ttn.lorawan.v3.PacketBrokerGateway.GatewayIdentifiers
	(*ContactInfo)(nil),                                    // 28: ttn.lorawan.v3.ContactInfo
	(*OrganizationOrUserIdentifiers)(nil),                  // 29: ttn.lorawan.v3.OrganizationOrUserIdentifiers
	(*GatewayAntenna)(nil),                                 // 30: ttn.lorawan.v3.GatewayAntenna
	(*wrapperspb.FloatValue)(nil),                          // 31: google.protobuf.FloatValue
	(*fieldmaskpb.FieldMask)(nil),                          // 32: google.protobuf.FieldMask
	(*durationpb.Duration)(nil),                            // 33: google.protobuf.Duration
	(*DevAddrPrefix)(nil),                                  // 34: ttn.lorawan.v3.DevAddrPrefix
	(*wrapperspb.BoolValue)(nil),                           // 35: google.protobuf.BoolValue
	(*timestamppb.Timestamp)(nil),                          // 36: google.protobuf.Timestamp
	(*GatewayUplinkMessage)(nil),                           // 37: ttn.lorawan.v3.GatewayUplinkMessage
	(*DownlinkMessage)(nil),                                // 38: ttn.lorawan.v3.DownlinkMessage
	(*emptypb.Empty)(nil),                                  // 39: google.protobuf.Empty
}
var file_ttn_lorawan_v3_packetbrokeragent_proto_depIdxs = []int32{
	27, // 0: ttn.lorawan.v3.PacketBrokerGateway.ids:type_name -> ttn.lorawan.v3.PacketBrokerGateway.GatewayIdentifiers
	28, // 1: ttn.lorawan.v3.PacketBrokerGateway.contact_info:type_name -> ttn.lorawan.v3.ContactInfo
	29, // 2: ttn.lorawan.v3.PacketBrokerGateway.administrative_contact:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	29, // 3: ttn.lorawan.v3.PacketBrokerGateway.technical_contact:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	30, // 4: ttn.lorawan.v3.PacketBrokerGateway.antennas:type_name -> ttn.lorawan.v3.GatewayAntenna
	31, // 5: ttn.lorawan.v3.PacketBrokerGateway.rx_rate:type_name -> google.protobuf.FloatValue
	31, // 6: ttn.lorawan.v3.PacketBrokerGateway.tx_rate:type_name -> google.protobuf.FloatValue
	0,  // 7: ttn.lorawan.v3.UpdatePacketBrokerGatewayRequest.gateway:type_name -> ttn.lorawan.v3.PacketBrokerGateway
	32, // 8: ttn.lorawan.v3.UpdatePacketBrokerGatewayRequest.field_mask:type_name -> google.protobuf.FieldMask
	33, // 9: ttn.lorawan.v3.UpdatePacketBrokerGatewayResponse.online_ttl:type_name -> google.protobuf.Duration
	34, // 10: ttn.lorawan.v3.PacketBrokerDevAddrBlock.dev_addr_prefix:type_name -> ttn.lorawan.v3.DevAddrPrefix
	3,  // 11: ttn.lorawan.v3.PacketBrokerNetwork.id:type_name -> ttn.lorawan.v3.PacketBrokerNetworkIdentifier
	4,  // 12: ttn.lorawan.v3.PacketBrokerNetwork.dev_addr_blocks:type_name -> ttn.lorawan.v3.PacketBrokerDevAddrBlock
	28, // 13: ttn.lorawan.v3.PacketBrokerNetwork.contact_info:type_name -> ttn.lorawan.v3.ContactInfo
	28, // 14: ttn.lorawan.v3.PacketBrokerNetwork.administrative_contact:type_name -> ttn.lorawan.v3.ContactInfo
	28, // 15: ttn.lorawan.v3.PacketBrokerNetwork.technical_contact:type_name -> ttn.lorawan.v3.ContactInfo
	5,  // 16: ttn.lorawan.v3.PacketBrokerNetworks.networks:type_name -> ttn.lorawan.v3.PacketBrokerNetwork
	5,  // 17: ttn.lorawan.v3.PacketBrokerInfo.registration:type_name -> ttn.lorawan.v3.PacketBrokerNetwork
	35, // 18: ttn.lorawan.v3.PacketBrokerRegisterRequest.listed:type_name -> google.protobuf.BoolValue
	36, // 19: ttn.lorawan.v3.PacketBrokerDefaultRoutingPolicy.updated_at:type_name -> google.protobuf.Timestamp
	9,  // 20: ttn.lorawan.v3.PacketBrokerDefaultRoutingPolicy.uplink:type_name -> ttn.lorawan.v3.PacketBrokerRoutingPolicyUplink
	10, // 21: ttn.lorawan.v3.PacketBrokerDefaultRoutingPolicy.downlink:type_name -> ttn.lorawan.v3.PacketBrokerRoutingPolicyDownlink
	3,  // 22: ttn.lorawan.v3.PacketBrokerRoutingPolicy.forwarder_id:type_name -> ttn.lorawan.v3.PacketBrokerNetworkIdentifier
	3,  // 23: ttn.lorawan.v3.PacketBrokerRoutingPolicy.home_network_id:type_name -> ttn.lorawan.v3.PacketBrokerNetworkIdentifier
	36, // 24: ttn.lorawan.v3.PacketBrokerRoutingPolicy.updated_at:type_name -> google.protobuf.Timestamp
	9,  // 25: ttn.lorawan.v3.PacketBrokerRoutingPolicy.uplink:type_name -> ttn.lorawan.v3.PacketBrokerRoutingPolicyUplink
	10, // 26: ttn.lorawan.v3.PacketBrokerRoutingPolicy.downlink:type_name -> ttn.lorawan.v3.PacketBrokerRoutingPolicyDownlink
	9,  // 27: ttn.lorawan.v3.SetPacketBrokerDefaultRoutingPolicyRequest.uplink:type_name -> ttn.lorawan.v3.PacketBrokerRoutingPolicyUplink
	10, // 28: ttn.lorawan.v3.SetPacketBrokerDefaultRoutingPolicyRequest.downlink:type_name -> ttn.lorawan.v3.PacketBrokerRoutingPolicyDownlink
	12, // 29: ttn.lorawan.v3.PacketBrokerRoutingPolicies.policies:type_name -> ttn.lorawan.v3.PacketBrokerRoutingPolicy
	3,  // 30: ttn.lorawan.v3.SetPacketBrokerRoutingPolicyRequest.home_network_id:type_name -> ttn.lorawan.v3.PacketBrokerNetworkIdentifier
	9,  // 31: ttn.lorawan.v3.SetPacketBrokerRoutingPolicyRequest.uplink:type_name -> ttn.lorawan.v3.PacketBrokerRoutingPolicyUplink
	10, // 32: ttn.lorawan.v3.SetPacketBrokerRoutingPolicyRequest.downlink:type_name -> ttn.lorawan.v3.PacketBrokerRoutingPolicyDownlink
	36, // 33: ttn.lorawan.v3.PacketBrokerDefaultGatewayVisibility.updated_at:type_name -> google.protobuf.Timestamp
	17, // 34: ttn.lorawan.v3.PacketBrokerDefaultGatewayVisibility.visibility:type_name -> ttn.lorawan.v3.PacketBrokerGatewayVisibility
	17, // 35: ttn.lorawan.v3.SetPacketBrokerDefaultGatewayVisibilityRequest.visibility:type_name -> ttn.lorawan.v3.PacketBrokerGatewayVisibility
	3,  // 36: ttn.lorawan.v3.ListForwarderRoutingPoliciesRequest.home_network_id:type_name -> ttn.lorawan.v3.PacketBrokerNetworkIdentifier
	23, // 37: ttn.lorawan.v3.PacketBrokerAgentCompoundUplinkToken.agent:type_name -> ttn.lorawan.v3.PacketBrokerAgentUplinkToken
	37, // 38: ttn.lorawan.v3.GsPba.PublishUplink:input_type -> ttn.lorawan.v3.GatewayUplinkMessage
	1,  // 39: ttn.lorawan.v3.GsPba.UpdateGateway:input_type -> ttn.lorawan.v3.UpdatePacketBrokerGatewayRequest
	38, // 40: ttn.lorawan.v3.NsPba.PublishDownlink:input_type -> ttn.lorawan.v3.DownlinkMessage
	39, // 41: ttn.lorawan.v3.Pba.GetInfo:input_type -> google.protobuf.Empty
	8,  // 42: ttn.lorawan.v3.Pba.Register:input_type -> ttn.lorawan.v3.PacketBrokerRegisterRequest
	39, // 43: ttn.lorawan.v3.Pba.Deregister:input_type -> google.protobuf.Empty
	14, // 44: ttn.lorawan.v3.Pba.ListHomeNetworkRoutingPolicies:input_type -> ttn.lorawan.v3.ListHomeNetworkRoutingPoliciesRequest
	3,  // 45: ttn.lorawan.v3.Pba.GetHomeNetworkRoutingPolicy:input_type -> ttn.lorawan.v3.PacketBrokerNetworkIdentifier
	16, // 46: ttn.lorawan.v3.Pba.SetHomeNetworkRoutingPolicy:input_type -> ttn.lorawan.v3.SetPacketBrokerRoutingPolicyRequest
	3,  // 47: ttn.lorawan.v3.Pba.DeleteHomeNetworkRoutingPolicy:input_type -> ttn.lorawan.v3.PacketBrokerNetworkIdentifier
	39, // 48: ttn.lorawan.v3.Pba.GetHomeNetworkDefaultRoutingPolicy:input_type -> google.protobuf.Empty
	13, // 49: ttn.lorawan.v3.Pba.SetHomeNetworkDefaultRoutingPolicy:input_type -> ttn.lorawan.v3.SetPacketBrokerDefaultRoutingPolicyRequest
	39, // 50: ttn.lorawan.v3.Pba.DeleteHomeNetworkDefaultRoutingPolicy:input_type -> google.protobuf.Empty
	39, // 51: ttn.lorawan.v3.Pba.GetHomeNetworkDefaultGatewayVisibility:input_type -> google.protobuf.Empty
	19, // 52: ttn.lorawan.v3.Pba.SetHomeNetworkDefaultGatewayVisibility:input_type -> ttn.lorawan.v3.SetPacketBrokerDefaultGatewayVisibilityRequest
	39, // 53: ttn.lorawan.v3.Pba.DeleteHomeNetworkDefaultGatewayVisibility:input_type -> google.protobuf.Empty
	20, // 54: ttn.lorawan.v3.Pba.ListNetworks:input_type -> ttn.lorawan.v3.ListPacketBrokerNetworksRequest
	21, // 55: ttn.lorawan.v3.Pba.ListHomeNetworks:input_type -> ttn.lorawan.v3.ListPacketBrokerHomeNetworksRequest
	22, // 56: ttn.lorawan.v3.Pba.ListForwarderRoutingPolicies:input_type -> ttn.lorawan.v3.ListForwarderRoutingPoliciesRequest
	39, // 57: ttn.lorawan.v3.GsPba.PublishUplink:output_type -> google.protobuf.Empty
	2,  // 58: ttn.lorawan.v3.GsPba.UpdateGateway:output_type -> ttn.lorawan.v3.UpdatePacketBrokerGatewayResponse
	39, // 59: ttn.lorawan.v3.NsPba.PublishDownlink:output_type -> google.protobuf.Empty
	7,  // 60: ttn.lorawan.v3.Pba.GetInfo:output_type -> ttn.lorawan.v3.PacketBrokerInfo
	5,  // 61: ttn.lorawan.v3.Pba.Register:output_type -> ttn.lorawan.v3.PacketBrokerNetwork
	39, // 62: ttn.lorawan.v3.Pba.Deregister:output_type -> google.protobuf.Empty
	15, // 63: ttn.lorawan.v3.Pba.ListHomeNetworkRoutingPolicies:output_type -> ttn.lorawan.v3.PacketBrokerRoutingPolicies
	12, // 64: ttn.lorawan.v3.Pba.GetHomeNetworkRoutingPolicy:output_type -> ttn.lorawan.v3.PacketBrokerRoutingPolicy
	39, // 65: ttn.lorawan.v3.Pba.SetHomeNetworkRoutingPolicy:output_type -> google.protobuf.Empty
	39, // 66: ttn.lorawan.v3.Pba.DeleteHomeNetworkRoutingPolicy:output_type -> google.protobuf.Empty
	11, // 67: ttn.lorawan.v3.Pba.GetHomeNetworkDefaultRoutingPolicy:output_type -> ttn.lorawan.v3.PacketBrokerDefaultRoutingPolicy
	39, // 68: ttn.lorawan.v3.Pba.SetHomeNetworkDefaultRoutingPolicy:output_type -> google.protobuf.Empty
	39, // 69: ttn.lorawan.v3.Pba.DeleteHomeNetworkDefaultRoutingPolicy:output_type -> google.protobuf.Empty
	18, // 70: ttn.lorawan.v3.Pba.GetHomeNetworkDefaultGatewayVisibility:output_type -> ttn.lorawan.v3.PacketBrokerDefaultGatewayVisibility
	39, // 71: ttn.lorawan.v3.Pba.SetHomeNetworkDefaultGatewayVisibility:output_type -> google.protobuf.Empty
	39, // 72: ttn.lorawan.v3.Pba.DeleteHomeNetworkDefaultGatewayVisibility:output_type -> google.protobuf.Empty
	6,  // 73: ttn.lorawan.v3.Pba.ListNetworks:output_type -> ttn.lorawan.v3.PacketBrokerNetworks
	6,  // 74: ttn.lorawan.v3.Pba.ListHomeNetworks:output_type -> ttn.lorawan.v3.PacketBrokerNetworks
	15, // 75: ttn.lorawan.v3.Pba.ListForwarderRoutingPolicies:output_type -> ttn.lorawan.v3.PacketBrokerRoutingPolicies
	57, // [57:76] is the sub-list for method output_type
	38, // [38:57] is the sub-list for method input_type
	38, // [38:38] is the sub-list for extension type_name
	38, // [38:38] is the sub-list for extension extendee
	0,  // [0:38] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_packetbrokeragent_proto_init() }
func file_ttn_lorawan_v3_packetbrokeragent_proto_init() {
	if File_ttn_lorawan_v3_packetbrokeragent_proto != nil {
		return
	}
	file_ttn_lorawan_v3_contact_info_proto_init()
	file_ttn_lorawan_v3_end_device_proto_init()
	file_ttn_lorawan_v3_gateway_proto_init()
	file_ttn_lorawan_v3_identifiers_proto_init()
	file_ttn_lorawan_v3_messages_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerGateway); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePacketBrokerGatewayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePacketBrokerGatewayResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerNetworkIdentifier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerDevAddrBlock); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerNetwork); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerNetworks); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerRegisterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerRoutingPolicyUplink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerRoutingPolicyDownlink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerDefaultRoutingPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerRoutingPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetPacketBrokerDefaultRoutingPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListHomeNetworkRoutingPoliciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerRoutingPolicies); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetPacketBrokerRoutingPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerGatewayVisibility); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerDefaultGatewayVisibility); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetPacketBrokerDefaultGatewayVisibilityRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPacketBrokerNetworksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPacketBrokerHomeNetworksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListForwarderRoutingPoliciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerAgentUplinkToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerAgentGatewayUplinkToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerAgentCompoundUplinkToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerAgentEncryptedPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerGateway_GatewayIdentifiers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_packetbrokeragent_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   28,
			NumExtensions: 0,
			NumServices:   3,
		},
		GoTypes:           file_ttn_lorawan_v3_packetbrokeragent_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_packetbrokeragent_proto_depIdxs,
		MessageInfos:      file_ttn_lorawan_v3_packetbrokeragent_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_packetbrokeragent_proto = out.File
	file_ttn_lorawan_v3_packetbrokeragent_proto_rawDesc = nil
	file_ttn_lorawan_v3_packetbrokeragent_proto_goTypes = nil
	file_ttn_lorawan_v3_packetbrokeragent_proto_depIdxs = nil
}
