// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on Organization with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *Organization) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = OrganizationFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return OrganizationValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return OrganizationValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "created_at":

			if v, ok := interface{}(m.GetCreatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return OrganizationValidationError{
						field:  "created_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return OrganizationValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "deleted_at":

			if v, ok := interface{}(m.GetDeletedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return OrganizationValidationError{
						field:  "deleted_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "name":

			if utf8.RuneCountInString(m.GetName()) > 50 {
				return OrganizationValidationError{
					field:  "name",
					reason: "value length must be at most 50 runes",
				}
			}

		case "description":

			if utf8.RuneCountInString(m.GetDescription()) > 2000 {
				return OrganizationValidationError{
					field:  "description",
					reason: "value length must be at most 2000 runes",
				}
			}

		case "attributes":

			if len(m.GetAttributes()) > 10 {
				return OrganizationValidationError{
					field:  "attributes",
					reason: "value must contain no more than 10 pair(s)",
				}
			}

			for key, val := range m.GetAttributes() {
				_ = val

				if utf8.RuneCountInString(key) > 36 {
					return OrganizationValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value length must be at most 36 runes",
					}
				}

				if !_Organization_Attributes_Pattern.MatchString(key) {
					return OrganizationValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

				if utf8.RuneCountInString(val) > 200 {
					return OrganizationValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value length must be at most 200 runes",
					}
				}

			}

		case "contact_info":

			if len(m.GetContactInfo()) > 10 {
				return OrganizationValidationError{
					field:  "contact_info",
					reason: "value must contain no more than 10 item(s)",
				}
			}

			for idx, item := range m.GetContactInfo() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return OrganizationValidationError{
							field:  fmt.Sprintf("contact_info[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "administrative_contact":

			if v, ok := interface{}(m.GetAdministrativeContact()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return OrganizationValidationError{
						field:  "administrative_contact",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "technical_contact":

			if v, ok := interface{}(m.GetTechnicalContact()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return OrganizationValidationError{
						field:  "technical_contact",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "fanout_notifications":
			// no validation rules for FanoutNotifications
		default:
			return OrganizationValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// OrganizationValidationError is the validation error returned by
// Organization.ValidateFields if the designated constraints aren't met.
type OrganizationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e OrganizationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e OrganizationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e OrganizationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e OrganizationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e OrganizationValidationError) ErrorName() string { return "OrganizationValidationError" }

// Error satisfies the builtin error interface
func (e OrganizationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOrganization.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = OrganizationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = OrganizationValidationError{}

var _Organization_Attributes_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on Organizations with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *Organizations) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = OrganizationsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "organizations":

			for idx, item := range m.GetOrganizations() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return OrganizationsValidationError{
							field:  fmt.Sprintf("organizations[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return OrganizationsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// OrganizationsValidationError is the validation error returned by
// Organizations.ValidateFields if the designated constraints aren't met.
type OrganizationsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e OrganizationsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e OrganizationsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e OrganizationsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e OrganizationsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e OrganizationsValidationError) ErrorName() string { return "OrganizationsValidationError" }

// Error satisfies the builtin error interface
func (e OrganizationsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOrganizations.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = OrganizationsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = OrganizationsValidationError{}

// ValidateFields checks the field values on GetOrganizationRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetOrganizationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetOrganizationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "organization_ids":

			if m.GetOrganizationIds() == nil {
				return GetOrganizationRequestValidationError{
					field:  "organization_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetOrganizationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetOrganizationRequestValidationError{
						field:  "organization_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetOrganizationRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetOrganizationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetOrganizationRequestValidationError is the validation error returned by
// GetOrganizationRequest.ValidateFields if the designated constraints aren't met.
type GetOrganizationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetOrganizationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetOrganizationRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetOrganizationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetOrganizationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetOrganizationRequestValidationError) ErrorName() string {
	return "GetOrganizationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetOrganizationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetOrganizationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetOrganizationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetOrganizationRequestValidationError{}

// ValidateFields checks the field values on ListOrganizationsRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ListOrganizationsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListOrganizationsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "collaborator":

			if v, ok := interface{}(m.GetCollaborator()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListOrganizationsRequestValidationError{
						field:  "collaborator",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListOrganizationsRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "order":

			if _, ok := _ListOrganizationsRequest_Order_InLookup[m.GetOrder()]; !ok {
				return ListOrganizationsRequestValidationError{
					field:  "order",
					reason: "value must be in list [ organization_id -organization_id name -name created_at -created_at]",
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListOrganizationsRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "deleted":
			// no validation rules for Deleted
		default:
			return ListOrganizationsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListOrganizationsRequestValidationError is the validation error returned by
// ListOrganizationsRequest.ValidateFields if the designated constraints
// aren't met.
type ListOrganizationsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListOrganizationsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListOrganizationsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListOrganizationsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListOrganizationsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListOrganizationsRequestValidationError) ErrorName() string {
	return "ListOrganizationsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListOrganizationsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListOrganizationsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListOrganizationsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListOrganizationsRequestValidationError{}

var _ListOrganizationsRequest_Order_InLookup = map[string]struct{}{
	"":                 {},
	"organization_id":  {},
	"-organization_id": {},
	"name":             {},
	"-name":            {},
	"created_at":       {},
	"-created_at":      {},
}

// ValidateFields checks the field values on CreateOrganizationRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *CreateOrganizationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CreateOrganizationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "organization":

			if m.GetOrganization() == nil {
				return CreateOrganizationRequestValidationError{
					field:  "organization",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetOrganization()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateOrganizationRequestValidationError{
						field:  "organization",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "collaborator":

			if m.GetCollaborator() == nil {
				return CreateOrganizationRequestValidationError{
					field:  "collaborator",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetCollaborator()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateOrganizationRequestValidationError{
						field:  "collaborator",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return CreateOrganizationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CreateOrganizationRequestValidationError is the validation error returned by
// CreateOrganizationRequest.ValidateFields if the designated constraints
// aren't met.
type CreateOrganizationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateOrganizationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateOrganizationRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateOrganizationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateOrganizationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateOrganizationRequestValidationError) ErrorName() string {
	return "CreateOrganizationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e CreateOrganizationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateOrganizationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateOrganizationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateOrganizationRequestValidationError{}

// ValidateFields checks the field values on UpdateOrganizationRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UpdateOrganizationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UpdateOrganizationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "organization":

			if m.GetOrganization() == nil {
				return UpdateOrganizationRequestValidationError{
					field:  "organization",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetOrganization()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateOrganizationRequestValidationError{
						field:  "organization",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateOrganizationRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UpdateOrganizationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UpdateOrganizationRequestValidationError is the validation error returned by
// UpdateOrganizationRequest.ValidateFields if the designated constraints
// aren't met.
type UpdateOrganizationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpdateOrganizationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpdateOrganizationRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpdateOrganizationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpdateOrganizationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpdateOrganizationRequestValidationError) ErrorName() string {
	return "UpdateOrganizationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e UpdateOrganizationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpdateOrganizationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpdateOrganizationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpdateOrganizationRequestValidationError{}

// ValidateFields checks the field values on ListOrganizationAPIKeysRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ListOrganizationAPIKeysRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListOrganizationAPIKeysRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "organization_ids":

			if m.GetOrganizationIds() == nil {
				return ListOrganizationAPIKeysRequestValidationError{
					field:  "organization_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetOrganizationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListOrganizationAPIKeysRequestValidationError{
						field:  "organization_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "order":

			if _, ok := _ListOrganizationAPIKeysRequest_Order_InLookup[m.GetOrder()]; !ok {
				return ListOrganizationAPIKeysRequestValidationError{
					field:  "order",
					reason: "value must be in list [ api_key_id -api_key_id name -name created_at -created_at expires_at -expires_at]",
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListOrganizationAPIKeysRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		default:
			return ListOrganizationAPIKeysRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListOrganizationAPIKeysRequestValidationError is the validation error
// returned by ListOrganizationAPIKeysRequest.ValidateFields if the designated
// constraints aren't met.
type ListOrganizationAPIKeysRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListOrganizationAPIKeysRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListOrganizationAPIKeysRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListOrganizationAPIKeysRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListOrganizationAPIKeysRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListOrganizationAPIKeysRequestValidationError) ErrorName() string {
	return "ListOrganizationAPIKeysRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListOrganizationAPIKeysRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListOrganizationAPIKeysRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListOrganizationAPIKeysRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListOrganizationAPIKeysRequestValidationError{}

var _ListOrganizationAPIKeysRequest_Order_InLookup = map[string]struct{}{
	"":            {},
	"api_key_id":  {},
	"-api_key_id": {},
	"name":        {},
	"-name":       {},
	"created_at":  {},
	"-created_at": {},
	"expires_at":  {},
	"-expires_at": {},
}

// ValidateFields checks the field values on GetOrganizationAPIKeyRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *GetOrganizationAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetOrganizationAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "organization_ids":

			if m.GetOrganizationIds() == nil {
				return GetOrganizationAPIKeyRequestValidationError{
					field:  "organization_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetOrganizationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetOrganizationAPIKeyRequestValidationError{
						field:  "organization_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "key_id":
			// no validation rules for KeyId
		default:
			return GetOrganizationAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetOrganizationAPIKeyRequestValidationError is the validation error returned
// by GetOrganizationAPIKeyRequest.ValidateFields if the designated
// constraints aren't met.
type GetOrganizationAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetOrganizationAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetOrganizationAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetOrganizationAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetOrganizationAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetOrganizationAPIKeyRequestValidationError) ErrorName() string {
	return "GetOrganizationAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetOrganizationAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetOrganizationAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetOrganizationAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetOrganizationAPIKeyRequestValidationError{}

// ValidateFields checks the field values on CreateOrganizationAPIKeyRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *CreateOrganizationAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CreateOrganizationAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "organization_ids":

			if m.GetOrganizationIds() == nil {
				return CreateOrganizationAPIKeyRequestValidationError{
					field:  "organization_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetOrganizationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateOrganizationAPIKeyRequestValidationError{
						field:  "organization_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "name":

			if utf8.RuneCountInString(m.GetName()) > 50 {
				return CreateOrganizationAPIKeyRequestValidationError{
					field:  "name",
					reason: "value length must be at most 50 runes",
				}
			}

		case "rights":

			if len(m.GetRights()) < 1 {
				return CreateOrganizationAPIKeyRequestValidationError{
					field:  "rights",
					reason: "value must contain at least 1 item(s)",
				}
			}

			_CreateOrganizationAPIKeyRequest_Rights_Unique := make(map[Right]struct{}, len(m.GetRights()))

			for idx, item := range m.GetRights() {
				_, _ = idx, item

				if _, exists := _CreateOrganizationAPIKeyRequest_Rights_Unique[item]; exists {
					return CreateOrganizationAPIKeyRequestValidationError{
						field:  fmt.Sprintf("rights[%v]", idx),
						reason: "repeated value must contain unique items",
					}
				} else {
					_CreateOrganizationAPIKeyRequest_Rights_Unique[item] = struct{}{}
				}

				if _, ok := Right_name[int32(item)]; !ok {
					return CreateOrganizationAPIKeyRequestValidationError{
						field:  fmt.Sprintf("rights[%v]", idx),
						reason: "value must be one of the defined enum values",
					}
				}

			}

		case "expires_at":

			if t := m.GetExpiresAt(); t != nil {
				ts, err := t.AsTime(), t.CheckValid()
				if err != nil {
					return CreateOrganizationAPIKeyRequestValidationError{
						field:  "expires_at",
						reason: "value is not a valid timestamp",
						cause:  err,
					}
				}

				now := time.Now()

				if ts.Sub(now) <= 0 {
					return CreateOrganizationAPIKeyRequestValidationError{
						field:  "expires_at",
						reason: "value must be greater than now",
					}
				}

			}

		default:
			return CreateOrganizationAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CreateOrganizationAPIKeyRequestValidationError is the validation error
// returned by CreateOrganizationAPIKeyRequest.ValidateFields if the
// designated constraints aren't met.
type CreateOrganizationAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateOrganizationAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateOrganizationAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateOrganizationAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateOrganizationAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateOrganizationAPIKeyRequestValidationError) ErrorName() string {
	return "CreateOrganizationAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e CreateOrganizationAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateOrganizationAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateOrganizationAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateOrganizationAPIKeyRequestValidationError{}

// ValidateFields checks the field values on UpdateOrganizationAPIKeyRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *UpdateOrganizationAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UpdateOrganizationAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "organization_ids":

			if m.GetOrganizationIds() == nil {
				return UpdateOrganizationAPIKeyRequestValidationError{
					field:  "organization_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetOrganizationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateOrganizationAPIKeyRequestValidationError{
						field:  "organization_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "api_key":

			if m.GetApiKey() == nil {
				return UpdateOrganizationAPIKeyRequestValidationError{
					field:  "api_key",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApiKey()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateOrganizationAPIKeyRequestValidationError{
						field:  "api_key",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateOrganizationAPIKeyRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UpdateOrganizationAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UpdateOrganizationAPIKeyRequestValidationError is the validation error
// returned by UpdateOrganizationAPIKeyRequest.ValidateFields if the
// designated constraints aren't met.
type UpdateOrganizationAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpdateOrganizationAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpdateOrganizationAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpdateOrganizationAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpdateOrganizationAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpdateOrganizationAPIKeyRequestValidationError) ErrorName() string {
	return "UpdateOrganizationAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e UpdateOrganizationAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpdateOrganizationAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpdateOrganizationAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpdateOrganizationAPIKeyRequestValidationError{}

// ValidateFields checks the field values on DeleteOrganizationAPIKeyRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *DeleteOrganizationAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DeleteOrganizationAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "organization_ids":

			if m.GetOrganizationIds() == nil {
				return DeleteOrganizationAPIKeyRequestValidationError{
					field:  "organization_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetOrganizationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DeleteOrganizationAPIKeyRequestValidationError{
						field:  "organization_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "key_id":
			// no validation rules for KeyId
		default:
			return DeleteOrganizationAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DeleteOrganizationAPIKeyRequestValidationError is the validation error
// returned by DeleteOrganizationAPIKeyRequest.ValidateFields if the
// designated constraints aren't met.
type DeleteOrganizationAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DeleteOrganizationAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DeleteOrganizationAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DeleteOrganizationAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DeleteOrganizationAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DeleteOrganizationAPIKeyRequestValidationError) ErrorName() string {
	return "DeleteOrganizationAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e DeleteOrganizationAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDeleteOrganizationAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DeleteOrganizationAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DeleteOrganizationAPIKeyRequestValidationError{}

// ValidateFields checks the field values on
// ListOrganizationCollaboratorsRequest with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *ListOrganizationCollaboratorsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListOrganizationCollaboratorsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "organization_ids":

			if m.GetOrganizationIds() == nil {
				return ListOrganizationCollaboratorsRequestValidationError{
					field:  "organization_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetOrganizationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListOrganizationCollaboratorsRequestValidationError{
						field:  "organization_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListOrganizationCollaboratorsRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "order":

			if _, ok := _ListOrganizationCollaboratorsRequest_Order_InLookup[m.GetOrder()]; !ok {
				return ListOrganizationCollaboratorsRequestValidationError{
					field:  "order",
					reason: "value must be in list [ id -id -rights rights]",
				}
			}

		default:
			return ListOrganizationCollaboratorsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListOrganizationCollaboratorsRequestValidationError is the validation error
// returned by ListOrganizationCollaboratorsRequest.ValidateFields if the
// designated constraints aren't met.
type ListOrganizationCollaboratorsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListOrganizationCollaboratorsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListOrganizationCollaboratorsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListOrganizationCollaboratorsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListOrganizationCollaboratorsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListOrganizationCollaboratorsRequestValidationError) ErrorName() string {
	return "ListOrganizationCollaboratorsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListOrganizationCollaboratorsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListOrganizationCollaboratorsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListOrganizationCollaboratorsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListOrganizationCollaboratorsRequestValidationError{}

var _ListOrganizationCollaboratorsRequest_Order_InLookup = map[string]struct{}{
	"":        {},
	"id":      {},
	"-id":     {},
	"-rights": {},
	"rights":  {},
}

// ValidateFields checks the field values on GetOrganizationCollaboratorRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *GetOrganizationCollaboratorRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetOrganizationCollaboratorRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "organization_ids":

			if m.GetOrganizationIds() == nil {
				return GetOrganizationCollaboratorRequestValidationError{
					field:  "organization_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetOrganizationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetOrganizationCollaboratorRequestValidationError{
						field:  "organization_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "collaborator":

			if m.GetCollaborator() == nil {
				return GetOrganizationCollaboratorRequestValidationError{
					field:  "collaborator",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetCollaborator()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetOrganizationCollaboratorRequestValidationError{
						field:  "collaborator",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetOrganizationCollaboratorRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetOrganizationCollaboratorRequestValidationError is the validation error
// returned by GetOrganizationCollaboratorRequest.ValidateFields if the
// designated constraints aren't met.
type GetOrganizationCollaboratorRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetOrganizationCollaboratorRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetOrganizationCollaboratorRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetOrganizationCollaboratorRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetOrganizationCollaboratorRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetOrganizationCollaboratorRequestValidationError) ErrorName() string {
	return "GetOrganizationCollaboratorRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetOrganizationCollaboratorRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetOrganizationCollaboratorRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetOrganizationCollaboratorRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetOrganizationCollaboratorRequestValidationError{}

// ValidateFields checks the field values on SetOrganizationCollaboratorRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *SetOrganizationCollaboratorRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SetOrganizationCollaboratorRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "organization_ids":

			if m.GetOrganizationIds() == nil {
				return SetOrganizationCollaboratorRequestValidationError{
					field:  "organization_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetOrganizationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetOrganizationCollaboratorRequestValidationError{
						field:  "organization_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "collaborator":

			if m.GetCollaborator() == nil {
				return SetOrganizationCollaboratorRequestValidationError{
					field:  "collaborator",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetCollaborator()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetOrganizationCollaboratorRequestValidationError{
						field:  "collaborator",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return SetOrganizationCollaboratorRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// SetOrganizationCollaboratorRequestValidationError is the validation error
// returned by SetOrganizationCollaboratorRequest.ValidateFields if the
// designated constraints aren't met.
type SetOrganizationCollaboratorRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SetOrganizationCollaboratorRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SetOrganizationCollaboratorRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SetOrganizationCollaboratorRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SetOrganizationCollaboratorRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SetOrganizationCollaboratorRequestValidationError) ErrorName() string {
	return "SetOrganizationCollaboratorRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SetOrganizationCollaboratorRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSetOrganizationCollaboratorRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SetOrganizationCollaboratorRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SetOrganizationCollaboratorRequestValidationError{}

// ValidateFields checks the field values on
// DeleteOrganizationCollaboratorRequest with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *DeleteOrganizationCollaboratorRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DeleteOrganizationCollaboratorRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "organization_ids":

			if m.GetOrganizationIds() == nil {
				return DeleteOrganizationCollaboratorRequestValidationError{
					field:  "organization_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetOrganizationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DeleteOrganizationCollaboratorRequestValidationError{
						field:  "organization_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "collaborator_ids":

			if m.GetCollaboratorIds() == nil {
				return DeleteOrganizationCollaboratorRequestValidationError{
					field:  "collaborator_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetCollaboratorIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DeleteOrganizationCollaboratorRequestValidationError{
						field:  "collaborator_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return DeleteOrganizationCollaboratorRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DeleteOrganizationCollaboratorRequestValidationError is the validation error
// returned by DeleteOrganizationCollaboratorRequest.ValidateFields if the
// designated constraints aren't met.
type DeleteOrganizationCollaboratorRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DeleteOrganizationCollaboratorRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DeleteOrganizationCollaboratorRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DeleteOrganizationCollaboratorRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DeleteOrganizationCollaboratorRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DeleteOrganizationCollaboratorRequestValidationError) ErrorName() string {
	return "DeleteOrganizationCollaboratorRequestValidationError"
}

// Error satisfies the builtin error interface
func (e DeleteOrganizationCollaboratorRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDeleteOrganizationCollaboratorRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DeleteOrganizationCollaboratorRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DeleteOrganizationCollaboratorRequestValidationError{}
