// Copyright © 2022 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/notification_service.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type NotificationType int32

const (
	NotificationType_UNKNOWN              NotificationType = 0
	NotificationType_API_KEY_CREATED      NotificationType = 1
	NotificationType_API_KEY_CHANGED      NotificationType = 2
	NotificationType_CLIENT_REQUESTED     NotificationType = 3
	NotificationType_COLLABORATOR_CHANGED NotificationType = 4
	NotificationType_ENTITY_STATE_CHANGED NotificationType = 5
	NotificationType_INVITATION           NotificationType = 6
	NotificationType_LOGIN_TOKEN          NotificationType = 7
	NotificationType_PASSWORD_CHANGED     NotificationType = 8
	NotificationType_TEMPORARY_PASSWORD   NotificationType = 9
	NotificationType_USER_REQUESTED       NotificationType = 10
	NotificationType_VALIDATE             NotificationType = 11
)

// Enum value maps for NotificationType.
var (
	NotificationType_name = map[int32]string{
		0:  "UNKNOWN",
		1:  "API_KEY_CREATED",
		2:  "API_KEY_CHANGED",
		3:  "CLIENT_REQUESTED",
		4:  "COLLABORATOR_CHANGED",
		5:  "ENTITY_STATE_CHANGED",
		6:  "INVITATION",
		7:  "LOGIN_TOKEN",
		8:  "PASSWORD_CHANGED",
		9:  "TEMPORARY_PASSWORD",
		10: "USER_REQUESTED",
		11: "VALIDATE",
	}
	NotificationType_value = map[string]int32{
		"UNKNOWN":              0,
		"API_KEY_CREATED":      1,
		"API_KEY_CHANGED":      2,
		"CLIENT_REQUESTED":     3,
		"COLLABORATOR_CHANGED": 4,
		"ENTITY_STATE_CHANGED": 5,
		"INVITATION":           6,
		"LOGIN_TOKEN":          7,
		"PASSWORD_CHANGED":     8,
		"TEMPORARY_PASSWORD":   9,
		"USER_REQUESTED":       10,
		"VALIDATE":             11,
	}
)

func (x NotificationType) Enum() *NotificationType {
	p := new(NotificationType)
	*p = x
	return p
}

func (x NotificationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NotificationType) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_notification_service_proto_enumTypes[0].Descriptor()
}

func (NotificationType) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_notification_service_proto_enumTypes[0]
}

func (x NotificationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NotificationType.Descriptor instead.
func (NotificationType) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_notification_service_proto_rawDescGZIP(), []int{0}
}

type NotificationReceiver int32

const (
	NotificationReceiver_NOTIFICATION_RECEIVER_UNKNOWN NotificationReceiver = 0
	// Notification is received by collaborators of the entity.
	// If the collaborator is an organization, the notification is received by organization members.
	NotificationReceiver_NOTIFICATION_RECEIVER_COLLABORATOR NotificationReceiver = 1
	// Notification is received by administrative contact of the entity.
	// If this is an organization, the notification is received by organization members.
	NotificationReceiver_NOTIFICATION_RECEIVER_ADMINISTRATIVE_CONTACT NotificationReceiver = 3
	// Notification is received by technical contact of the entity.
	// If this is an organization, the notification is received by organization members.
	NotificationReceiver_NOTIFICATION_RECEIVER_TECHNICAL_CONTACT NotificationReceiver = 4
)

// Enum value maps for NotificationReceiver.
var (
	NotificationReceiver_name = map[int32]string{
		0: "NOTIFICATION_RECEIVER_UNKNOWN",
		1: "NOTIFICATION_RECEIVER_COLLABORATOR",
		3: "NOTIFICATION_RECEIVER_ADMINISTRATIVE_CONTACT",
		4: "NOTIFICATION_RECEIVER_TECHNICAL_CONTACT",
	}
	NotificationReceiver_value = map[string]int32{
		"NOTIFICATION_RECEIVER_UNKNOWN":                0,
		"NOTIFICATION_RECEIVER_COLLABORATOR":           1,
		"NOTIFICATION_RECEIVER_ADMINISTRATIVE_CONTACT": 3,
		"NOTIFICATION_RECEIVER_TECHNICAL_CONTACT":      4,
	}
)

func (x NotificationReceiver) Enum() *NotificationReceiver {
	p := new(NotificationReceiver)
	*p = x
	return p
}

func (x NotificationReceiver) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NotificationReceiver) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_notification_service_proto_enumTypes[1].Descriptor()
}

func (NotificationReceiver) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_notification_service_proto_enumTypes[1]
}

func (x NotificationReceiver) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NotificationReceiver.Descriptor instead.
func (NotificationReceiver) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_notification_service_proto_rawDescGZIP(), []int{1}
}

type NotificationStatus int32

const (
	NotificationStatus_NOTIFICATION_STATUS_UNSEEN   NotificationStatus = 0
	NotificationStatus_NOTIFICATION_STATUS_SEEN     NotificationStatus = 1
	NotificationStatus_NOTIFICATION_STATUS_ARCHIVED NotificationStatus = 2
)

// Enum value maps for NotificationStatus.
var (
	NotificationStatus_name = map[int32]string{
		0: "NOTIFICATION_STATUS_UNSEEN",
		1: "NOTIFICATION_STATUS_SEEN",
		2: "NOTIFICATION_STATUS_ARCHIVED",
	}
	NotificationStatus_value = map[string]int32{
		"NOTIFICATION_STATUS_UNSEEN":   0,
		"NOTIFICATION_STATUS_SEEN":     1,
		"NOTIFICATION_STATUS_ARCHIVED": 2,
	}
)

func (x NotificationStatus) Enum() *NotificationStatus {
	p := new(NotificationStatus)
	*p = x
	return p
}

func (x NotificationStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NotificationStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_notification_service_proto_enumTypes[2].Descriptor()
}

func (NotificationStatus) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_notification_service_proto_enumTypes[2]
}

func (x NotificationStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NotificationStatus.Descriptor instead.
func (NotificationStatus) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_notification_service_proto_rawDescGZIP(), []int{2}
}

type Notification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The immutable ID of the notification. Generated by the server.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The time when the notification was triggered.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The entity this notification is about.
	EntityIds *EntityIdentifiers `protobuf:"bytes,3,opt,name=entity_ids,json=entityIds,proto3" json:"entity_ids,omitempty"`
	// The type of this notification.
	// TODO: Replace with type NotificationType in v4 https://github.com/TheThingsNetwork/lorawan-stack/issues/7384.
	NotificationType string `protobuf:"bytes,4,opt,name=notification_type,json=notificationType,proto3" json:"notification_type,omitempty"`
	// The data related to the notification.
	Data *anypb.Any `protobuf:"bytes,5,opt,name=data,proto3" json:"data,omitempty"`
	// If the notification was triggered by a user action, this contains the identifiers of the user that triggered the notification.
	SenderIds *UserIdentifiers `protobuf:"bytes,6,opt,name=sender_ids,json=senderIds,proto3" json:"sender_ids,omitempty"`
	// Relation of the notification receiver to the entity.
	Receivers []NotificationReceiver `protobuf:"varint,8,rep,packed,name=receivers,proto3,enum=ttn.lorawan.v3.NotificationReceiver" json:"receivers,omitempty"`
	// Whether an email was sent for the notification.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/notification_service.proto.
	Email bool `protobuf:"varint,9,opt,name=email,proto3" json:"email,omitempty"`
	// The status of the notification.
	Status NotificationStatus `protobuf:"varint,10,opt,name=status,proto3,enum=ttn.lorawan.v3.NotificationStatus" json:"status,omitempty"`
	// The time when the notification status was updated.
	StatusUpdatedAt *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=status_updated_at,json=statusUpdatedAt,proto3" json:"status_updated_at,omitempty"`
}

func (x *Notification) Reset() {
	*x = Notification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_notification_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Notification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Notification) ProtoMessage() {}

func (x *Notification) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_notification_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Notification.ProtoReflect.Descriptor instead.
func (*Notification) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_notification_service_proto_rawDescGZIP(), []int{0}
}

func (x *Notification) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Notification) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Notification) GetEntityIds() *EntityIdentifiers {
	if x != nil {
		return x.EntityIds
	}
	return nil
}

func (x *Notification) GetNotificationType() string {
	if x != nil {
		return x.NotificationType
	}
	return ""
}

func (x *Notification) GetData() *anypb.Any {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Notification) GetSenderIds() *UserIdentifiers {
	if x != nil {
		return x.SenderIds
	}
	return nil
}

func (x *Notification) GetReceivers() []NotificationReceiver {
	if x != nil {
		return x.Receivers
	}
	return nil
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/notification_service.proto.
func (x *Notification) GetEmail() bool {
	if x != nil {
		return x.Email
	}
	return false
}

func (x *Notification) GetStatus() NotificationStatus {
	if x != nil {
		return x.Status
	}
	return NotificationStatus_NOTIFICATION_STATUS_UNSEEN
}

func (x *Notification) GetStatusUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.StatusUpdatedAt
	}
	return nil
}

type CreateNotificationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The entity this notification is about.
	EntityIds *EntityIdentifiers `protobuf:"bytes,1,opt,name=entity_ids,json=entityIds,proto3" json:"entity_ids,omitempty"`
	// The type of this notification.
	NotificationType string `protobuf:"bytes,2,opt,name=notification_type,json=notificationType,proto3" json:"notification_type,omitempty"`
	// The data related to the notification.
	Data *anypb.Any `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	// If the notification was triggered by a user action, this contains the identifiers of the user that triggered the notification.
	SenderIds *UserIdentifiers `protobuf:"bytes,4,opt,name=sender_ids,json=senderIds,proto3" json:"sender_ids,omitempty"`
	// Receivers of the notification.
	Receivers []NotificationReceiver `protobuf:"varint,5,rep,packed,name=receivers,proto3,enum=ttn.lorawan.v3.NotificationReceiver" json:"receivers,omitempty"`
	// Whether an email should be sent for the notification.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/notification_service.proto.
	Email bool `protobuf:"varint,6,opt,name=email,proto3" json:"email,omitempty"`
}

func (x *CreateNotificationRequest) Reset() {
	*x = CreateNotificationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_notification_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateNotificationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateNotificationRequest) ProtoMessage() {}

func (x *CreateNotificationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_notification_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateNotificationRequest.ProtoReflect.Descriptor instead.
func (*CreateNotificationRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_notification_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateNotificationRequest) GetEntityIds() *EntityIdentifiers {
	if x != nil {
		return x.EntityIds
	}
	return nil
}

func (x *CreateNotificationRequest) GetNotificationType() string {
	if x != nil {
		return x.NotificationType
	}
	return ""
}

func (x *CreateNotificationRequest) GetData() *anypb.Any {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *CreateNotificationRequest) GetSenderIds() *UserIdentifiers {
	if x != nil {
		return x.SenderIds
	}
	return nil
}

func (x *CreateNotificationRequest) GetReceivers() []NotificationReceiver {
	if x != nil {
		return x.Receivers
	}
	return nil
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/notification_service.proto.
func (x *CreateNotificationRequest) GetEmail() bool {
	if x != nil {
		return x.Email
	}
	return false
}

type CreateNotificationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *CreateNotificationResponse) Reset() {
	*x = CreateNotificationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_notification_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateNotificationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateNotificationResponse) ProtoMessage() {}

func (x *CreateNotificationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_notification_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateNotificationResponse.ProtoReflect.Descriptor instead.
func (*CreateNotificationResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_notification_service_proto_rawDescGZIP(), []int{2}
}

func (x *CreateNotificationResponse) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type ListNotificationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IDs of the receiving user.
	ReceiverIds *UserIdentifiers `protobuf:"bytes,1,opt,name=receiver_ids,json=receiverIds,proto3" json:"receiver_ids,omitempty"`
	// Select notifications with these statuses.
	// An empty list is interpreted as "all".
	Status []NotificationStatus `protobuf:"varint,2,rep,packed,name=status,proto3,enum=ttn.lorawan.v3.NotificationStatus" json:"status,omitempty"`
	// Limit the number of results per page.
	Limit uint32 `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
	// Page number for pagination. 0 is interpreted as 1.
	Page uint32 `protobuf:"varint,4,opt,name=page,proto3" json:"page,omitempty"`
}

func (x *ListNotificationsRequest) Reset() {
	*x = ListNotificationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_notification_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotificationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotificationsRequest) ProtoMessage() {}

func (x *ListNotificationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_notification_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotificationsRequest.ProtoReflect.Descriptor instead.
func (*ListNotificationsRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_notification_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListNotificationsRequest) GetReceiverIds() *UserIdentifiers {
	if x != nil {
		return x.ReceiverIds
	}
	return nil
}

func (x *ListNotificationsRequest) GetStatus() []NotificationStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *ListNotificationsRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ListNotificationsRequest) GetPage() uint32 {
	if x != nil {
		return x.Page
	}
	return 0
}

type ListNotificationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Notifications []*Notification `protobuf:"bytes,1,rep,name=notifications,proto3" json:"notifications,omitempty"`
}

func (x *ListNotificationsResponse) Reset() {
	*x = ListNotificationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_notification_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotificationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotificationsResponse) ProtoMessage() {}

func (x *ListNotificationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_notification_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotificationsResponse.ProtoReflect.Descriptor instead.
func (*ListNotificationsResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_notification_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListNotificationsResponse) GetNotifications() []*Notification {
	if x != nil {
		return x.Notifications
	}
	return nil
}

type UpdateNotificationStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IDs of the receiving user.
	ReceiverIds *UserIdentifiers `protobuf:"bytes,1,opt,name=receiver_ids,json=receiverIds,proto3" json:"receiver_ids,omitempty"`
	// The IDs of the notifications to update the status of.
	Ids []string `protobuf:"bytes,2,rep,name=ids,proto3" json:"ids,omitempty"`
	// The status to set on the notifications.
	Status NotificationStatus `protobuf:"varint,3,opt,name=status,proto3,enum=ttn.lorawan.v3.NotificationStatus" json:"status,omitempty"`
}

func (x *UpdateNotificationStatusRequest) Reset() {
	*x = UpdateNotificationStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_notification_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateNotificationStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateNotificationStatusRequest) ProtoMessage() {}

func (x *UpdateNotificationStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_notification_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateNotificationStatusRequest.ProtoReflect.Descriptor instead.
func (*UpdateNotificationStatusRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_notification_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateNotificationStatusRequest) GetReceiverIds() *UserIdentifiers {
	if x != nil {
		return x.ReceiverIds
	}
	return nil
}

func (x *UpdateNotificationStatusRequest) GetIds() []string {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *UpdateNotificationStatusRequest) GetStatus() NotificationStatus {
	if x != nil {
		return x.Status
	}
	return NotificationStatus_NOTIFICATION_STATUS_UNSEEN
}

type EntityStateChangedNotification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	State            State  `protobuf:"varint,1,opt,name=state,proto3,enum=ttn.lorawan.v3.State" json:"state,omitempty"`
	StateDescription string `protobuf:"bytes,2,opt,name=state_description,json=stateDescription,proto3" json:"state_description,omitempty"`
}

func (x *EntityStateChangedNotification) Reset() {
	*x = EntityStateChangedNotification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_notification_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityStateChangedNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityStateChangedNotification) ProtoMessage() {}

func (x *EntityStateChangedNotification) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_notification_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityStateChangedNotification.ProtoReflect.Descriptor instead.
func (*EntityStateChangedNotification) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_notification_service_proto_rawDescGZIP(), []int{6}
}

func (x *EntityStateChangedNotification) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_REQUESTED
}

func (x *EntityStateChangedNotification) GetStateDescription() string {
	if x != nil {
		return x.StateDescription
	}
	return ""
}

var File_ttn_lorawan_v3_notification_service_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_notification_service_proto_rawDesc = []byte{
	0x0a, 0x29, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f,
	0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x21, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x66, 0x6c,
	0x61, 0x67, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x2f, 0x6a, 0x73, 0x6f, 0x6e, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2f, 0x76, 0x33, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfb,
	0x05, 0x0a, 0x0c, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x39, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x40, 0x0a, 0x0a, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x52, 0x09, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x73, 0x12, 0xf7, 0x01, 0x0a,
	0x11, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0xc9, 0x01, 0xfa, 0x42, 0xc5, 0x01, 0x72,
	0xc2, 0x01, 0x52, 0x07, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x52, 0x0f, 0x61, 0x70, 0x69,
	0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x52, 0x0f, 0x61, 0x70,
	0x69, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x52, 0x10, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x52,
	0x14, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x64, 0x52, 0x14, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x52, 0x0a, 0x69, 0x6e, 0x76,
	0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x10, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x52, 0x12, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72,
	0x79, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x52, 0x08, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x10, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x49, 0x64, 0x73,
	0x12, 0x42, 0x0a, 0x09, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x52, 0x09, 0x72, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x72, 0x73, 0x12, 0x18, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x3a,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x46, 0x0a, 0x11, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64,
	0x41, 0x74, 0x4a, 0x04, 0x08, 0x07, 0x10, 0x08, 0x52, 0x12, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x22, 0xbc, 0x04, 0x0a,
	0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x0a, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x09, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x49, 0x64, 0x73, 0x12, 0xf7, 0x01, 0x0a, 0x11, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0xc9, 0x01, 0xfa, 0x42, 0xc5, 0x01, 0x72, 0xc2, 0x01, 0x52, 0x07, 0x75, 0x6e,
	0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x52, 0x0f, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x52, 0x0f, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x52, 0x10, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x52, 0x14, 0x63, 0x6f, 0x6c, 0x6c, 0x61,
	0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x52,
	0x14, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x64, 0x52, 0x0a, 0x69, 0x6e, 0x76, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0b, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x10,
	0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64,
	0x52, 0x12, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x73, 0x73,
	0x77, 0x6f, 0x72, 0x64, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x52, 0x08, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x52, 0x10,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x28, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x41, 0x6e, 0x79, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x65,
	0x6e, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52,
	0x09, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x49, 0x64, 0x73, 0x12, 0x55, 0x0a, 0x09, 0x72, 0x65,
	0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x24, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x72, 0x42, 0x11, 0xfa, 0x42, 0x0e, 0x92, 0x01, 0x0b, 0x08, 0x01, 0x18, 0x01, 0x22,
	0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x09, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72,
	0x73, 0x12, 0x18, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x22, 0x2c, 0x0a, 0x1a, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0xf3, 0x01, 0x0a, 0x18, 0x4c, 0x69,
	0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x0c, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65,
	0x72, 0x49, 0x64, 0x73, 0x12, 0x4b, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x0f, 0xfa, 0x42, 0x0c, 0x92, 0x01, 0x09,
	0x18, 0x01, 0x22, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x1e, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xe8, 0x07, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x04, 0x70, 0x61, 0x67, 0x65, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x01, 0x22,
	0x5f, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x0d,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xe7, 0x01, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x0c, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x49,
	0x64, 0x73, 0x12, 0x26, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x14, 0xfa, 0x42, 0x11, 0x92, 0x01, 0x0e, 0x08, 0x01, 0x10, 0xe8, 0x07, 0x18, 0x01, 0x22, 0x05,
	0x72, 0x03, 0x98, 0x01, 0x24, 0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x44, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x01, 0x22, 0x8e, 0x01, 0x0a, 0x1e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x64, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x35, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x18, 0x80, 0x01, 0x52, 0x10, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2a, 0x8c, 0x02, 0x0a, 0x10,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x13, 0x0a,
	0x0f, 0x41, 0x50, 0x49, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x50, 0x49, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x43, 0x48,
	0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4c, 0x49, 0x45, 0x4e,
	0x54, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x18, 0x0a,
	0x14, 0x43, 0x4f, 0x4c, 0x4c, 0x41, 0x42, 0x4f, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x43, 0x48,
	0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x4e, 0x54, 0x49, 0x54,
	0x59, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10,
	0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x4e, 0x56, 0x49, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x06, 0x12, 0x0f, 0x0a, 0x0b, 0x4c, 0x4f, 0x47, 0x49, 0x4e, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e,
	0x10, 0x07, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x5f, 0x43,
	0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x08, 0x12, 0x16, 0x0a, 0x12, 0x54, 0x45, 0x4d, 0x50,
	0x4f, 0x52, 0x41, 0x52, 0x59, 0x5f, 0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x10, 0x09,
	0x12, 0x12, 0x0a, 0x0e, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54,
	0x45, 0x44, 0x10, 0x0a, 0x12, 0x0c, 0x0a, 0x08, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x45,
	0x10, 0x0b, 0x1a, 0x06, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0x2a, 0xdf, 0x01, 0x0a, 0x14, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x1d, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x26, 0x0a, 0x22, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49,
	0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x52, 0x5f,
	0x43, 0x4f, 0x4c, 0x4c, 0x41, 0x42, 0x4f, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x10, 0x01, 0x12, 0x30,
	0x0a, 0x2c, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52,
	0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x52, 0x5f, 0x41, 0x44, 0x4d, 0x49, 0x4e, 0x49, 0x53, 0x54,
	0x52, 0x41, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x43, 0x54, 0x10, 0x03,
	0x12, 0x2b, 0x0a, 0x27, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x52, 0x5f, 0x54, 0x45, 0x43, 0x48, 0x4e, 0x49,
	0x43, 0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x43, 0x54, 0x10, 0x04, 0x1a, 0x1d, 0xea,
	0xaa, 0x19, 0x19, 0x18, 0x01, 0x2a, 0x15, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x52, 0x2a, 0x91, 0x01, 0x0a,
	0x12, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x1e, 0x0a, 0x1a, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x45, 0x45,
	0x4e, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x53, 0x45, 0x45, 0x4e, 0x10,
	0x01, 0x12, 0x20, 0x0a, 0x1c, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x45,
	0x44, 0x10, 0x02, 0x1a, 0x1b, 0xea, 0xaa, 0x19, 0x17, 0x18, 0x01, 0x2a, 0x13, 0x4e, 0x4f, 0x54,
	0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53,
	0x32, 0xc2, 0x03, 0x0a, 0x13, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x5f, 0x0a, 0x06, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x12, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x92, 0x01, 0x0a, 0x04, 0x4c, 0x69,
	0x73, 0x74, 0x12, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x5a,
	0x2d, 0x12, 0x2b, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x8f,
	0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x2f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x36, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30,
	0x3a, 0x01, 0x2a, 0x32, 0x2b, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x63,
	0x65, 0x69, 0x76, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x1a, 0x23, 0x92, 0x41, 0x20, 0x12, 0x1e, 0x52, 0x65, 0x61, 0x64, 0x20, 0x61, 0x6e, 0x64, 0x20,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x20, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70,
	0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_notification_service_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_notification_service_proto_rawDescData = file_ttn_lorawan_v3_notification_service_proto_rawDesc
)

func file_ttn_lorawan_v3_notification_service_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_notification_service_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_notification_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_notification_service_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_notification_service_proto_rawDescData
}

var file_ttn_lorawan_v3_notification_service_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_ttn_lorawan_v3_notification_service_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_ttn_lorawan_v3_notification_service_proto_goTypes = []interface{}{
	(NotificationType)(0),                   // 0: ttn.lorawan.v3.NotificationType
	(NotificationReceiver)(0),               // 1: ttn.lorawan.v3.NotificationReceiver
	(NotificationStatus)(0),                 // 2: ttn.lorawan.v3.NotificationStatus
	(*Notification)(nil),                    // 3: ttn.lorawan.v3.Notification
	(*CreateNotificationRequest)(nil),       // 4: ttn.lorawan.v3.CreateNotificationRequest
	(*CreateNotificationResponse)(nil),      // 5: ttn.lorawan.v3.CreateNotificationResponse
	(*ListNotificationsRequest)(nil),        // 6: ttn.lorawan.v3.ListNotificationsRequest
	(*ListNotificationsResponse)(nil),       // 7: ttn.lorawan.v3.ListNotificationsResponse
	(*UpdateNotificationStatusRequest)(nil), // 8: ttn.lorawan.v3.UpdateNotificationStatusRequest
	(*EntityStateChangedNotification)(nil),  // 9: ttn.lorawan.v3.EntityStateChangedNotification
	(*timestamppb.Timestamp)(nil),           // 10: google.protobuf.Timestamp
	(*EntityIdentifiers)(nil),               // 11: ttn.lorawan.v3.EntityIdentifiers
	(*anypb.Any)(nil),                       // 12: google.protobuf.Any
	(*UserIdentifiers)(nil),                 // 13: ttn.lorawan.v3.UserIdentifiers
	(State)(0),                              // 14: ttn.lorawan.v3.State
	(*emptypb.Empty)(nil),                   // 15: google.protobuf.Empty
}
var file_ttn_lorawan_v3_notification_service_proto_depIdxs = []int32{
	10, // 0: ttn.lorawan.v3.Notification.created_at:type_name -> google.protobuf.Timestamp
	11, // 1: ttn.lorawan.v3.Notification.entity_ids:type_name -> ttn.lorawan.v3.EntityIdentifiers
	12, // 2: ttn.lorawan.v3.Notification.data:type_name -> google.protobuf.Any
	13, // 3: ttn.lorawan.v3.Notification.sender_ids:type_name -> ttn.lorawan.v3.UserIdentifiers
	1,  // 4: ttn.lorawan.v3.Notification.receivers:type_name -> ttn.lorawan.v3.NotificationReceiver
	2,  // 5: ttn.lorawan.v3.Notification.status:type_name -> ttn.lorawan.v3.NotificationStatus
	10, // 6: ttn.lorawan.v3.Notification.status_updated_at:type_name -> google.protobuf.Timestamp
	11, // 7: ttn.lorawan.v3.CreateNotificationRequest.entity_ids:type_name -> ttn.lorawan.v3.EntityIdentifiers
	12, // 8: ttn.lorawan.v3.CreateNotificationRequest.data:type_name -> google.protobuf.Any
	13, // 9: ttn.lorawan.v3.CreateNotificationRequest.sender_ids:type_name -> ttn.lorawan.v3.UserIdentifiers
	1,  // 10: ttn.lorawan.v3.CreateNotificationRequest.receivers:type_name -> ttn.lorawan.v3.NotificationReceiver
	13, // 11: ttn.lorawan.v3.ListNotificationsRequest.receiver_ids:type_name -> ttn.lorawan.v3.UserIdentifiers
	2,  // 12: ttn.lorawan.v3.ListNotificationsRequest.status:type_name -> ttn.lorawan.v3.NotificationStatus
	3,  // 13: ttn.lorawan.v3.ListNotificationsResponse.notifications:type_name -> ttn.lorawan.v3.Notification
	13, // 14: ttn.lorawan.v3.UpdateNotificationStatusRequest.receiver_ids:type_name -> ttn.lorawan.v3.UserIdentifiers
	2,  // 15: ttn.lorawan.v3.UpdateNotificationStatusRequest.status:type_name -> ttn.lorawan.v3.NotificationStatus
	14, // 16: ttn.lorawan.v3.EntityStateChangedNotification.state:type_name -> ttn.lorawan.v3.State
	4,  // 17: ttn.lorawan.v3.NotificationService.Create:input_type -> ttn.lorawan.v3.CreateNotificationRequest
	6,  // 18: ttn.lorawan.v3.NotificationService.List:input_type -> ttn.lorawan.v3.ListNotificationsRequest
	8,  // 19: ttn.lorawan.v3.NotificationService.UpdateStatus:input_type -> ttn.lorawan.v3.UpdateNotificationStatusRequest
	5,  // 20: ttn.lorawan.v3.NotificationService.Create:output_type -> ttn.lorawan.v3.CreateNotificationResponse
	7,  // 21: ttn.lorawan.v3.NotificationService.List:output_type -> ttn.lorawan.v3.ListNotificationsResponse
	15, // 22: ttn.lorawan.v3.NotificationService.UpdateStatus:output_type -> google.protobuf.Empty
	20, // [20:23] is the sub-list for method output_type
	17, // [17:20] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_notification_service_proto_init() }
func file_ttn_lorawan_v3_notification_service_proto_init() {
	if File_ttn_lorawan_v3_notification_service_proto != nil {
		return
	}
	file_ttn_lorawan_v3_enums_proto_init()
	file_ttn_lorawan_v3_identifiers_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_notification_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Notification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_notification_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateNotificationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_notification_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateNotificationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_notification_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNotificationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_notification_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNotificationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_notification_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateNotificationStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_notification_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntityStateChangedNotification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_notification_service_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_ttn_lorawan_v3_notification_service_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_notification_service_proto_depIdxs,
		EnumInfos:         file_ttn_lorawan_v3_notification_service_proto_enumTypes,
		MessageInfos:      file_ttn_lorawan_v3_notification_service_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_notification_service_proto = out.File
	file_ttn_lorawan_v3_notification_service_proto_rawDesc = nil
	file_ttn_lorawan_v3_notification_service_proto_goTypes = nil
	file_ttn_lorawan_v3_notification_service_proto_depIdxs = nil
}
