// Copyright © 2023 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/networkserver_relay.proto

package ttnpb

import (
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CreateRelayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// End device identifiers of the relay.
	EndDeviceIds *EndDeviceIdentifiers `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	// Relay configuration.
	Settings *RelaySettings `protobuf:"bytes,2,opt,name=settings,proto3" json:"settings,omitempty"`
}

func (x *CreateRelayRequest) Reset() {
	*x = CreateRelayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRelayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRelayRequest) ProtoMessage() {}

func (x *CreateRelayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRelayRequest.ProtoReflect.Descriptor instead.
func (*CreateRelayRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{0}
}

func (x *CreateRelayRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *CreateRelayRequest) GetSettings() *RelaySettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

type CreateRelayResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Relay configuration.
	Settings *RelaySettings `protobuf:"bytes,1,opt,name=settings,proto3" json:"settings,omitempty"`
}

func (x *CreateRelayResponse) Reset() {
	*x = CreateRelayResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRelayResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRelayResponse) ProtoMessage() {}

func (x *CreateRelayResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRelayResponse.ProtoReflect.Descriptor instead.
func (*CreateRelayResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{1}
}

func (x *CreateRelayResponse) GetSettings() *RelaySettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

type GetRelayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// End device identifiers of the relay.
	EndDeviceIds *EndDeviceIdentifiers `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	// Field mask of the fields to return.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetRelayRequest) Reset() {
	*x = GetRelayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRelayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRelayRequest) ProtoMessage() {}

func (x *GetRelayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRelayRequest.ProtoReflect.Descriptor instead.
func (*GetRelayRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{2}
}

func (x *GetRelayRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *GetRelayRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type GetRelayResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Relay configuration.
	Settings *RelaySettings `protobuf:"bytes,1,opt,name=settings,proto3" json:"settings,omitempty"`
}

func (x *GetRelayResponse) Reset() {
	*x = GetRelayResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRelayResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRelayResponse) ProtoMessage() {}

func (x *GetRelayResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRelayResponse.ProtoReflect.Descriptor instead.
func (*GetRelayResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{3}
}

func (x *GetRelayResponse) GetSettings() *RelaySettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

type UpdateRelayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// End device identifiers of the relay.
	EndDeviceIds *EndDeviceIdentifiers `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	// Relay configuration.
	Settings *RelaySettings `protobuf:"bytes,2,opt,name=settings,proto3" json:"settings,omitempty"`
	// Field mask of the fields to update.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *UpdateRelayRequest) Reset() {
	*x = UpdateRelayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRelayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRelayRequest) ProtoMessage() {}

func (x *UpdateRelayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRelayRequest.ProtoReflect.Descriptor instead.
func (*UpdateRelayRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateRelayRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *UpdateRelayRequest) GetSettings() *RelaySettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *UpdateRelayRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type UpdateRelayResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Relay configuration.
	Settings *RelaySettings `protobuf:"bytes,1,opt,name=settings,proto3" json:"settings,omitempty"`
}

func (x *UpdateRelayResponse) Reset() {
	*x = UpdateRelayResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRelayResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRelayResponse) ProtoMessage() {}

func (x *UpdateRelayResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRelayResponse.ProtoReflect.Descriptor instead.
func (*UpdateRelayResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateRelayResponse) GetSettings() *RelaySettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

type DeleteRelayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// End device identifiers of the relay.
	EndDeviceIds *EndDeviceIdentifiers `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
}

func (x *DeleteRelayRequest) Reset() {
	*x = DeleteRelayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRelayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRelayRequest) ProtoMessage() {}

func (x *DeleteRelayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRelayRequest.ProtoReflect.Descriptor instead.
func (*DeleteRelayRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteRelayRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

type DeleteRelayResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteRelayResponse) Reset() {
	*x = DeleteRelayResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRelayResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRelayResponse) ProtoMessage() {}

func (x *DeleteRelayResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRelayResponse.ProtoReflect.Descriptor instead.
func (*DeleteRelayResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{7}
}

type CreateRelayUplinkForwardingRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// End device identifiers of the relay.
	EndDeviceIds *EndDeviceIdentifiers `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	// Index of the uplink forwarding rule.
	Index uint32 `protobuf:"varint,2,opt,name=index,proto3" json:"index,omitempty"`
	// Uplink forwarding rule.
	Rule *RelayUplinkForwardingRule `protobuf:"bytes,3,opt,name=rule,proto3" json:"rule,omitempty"`
}

func (x *CreateRelayUplinkForwardingRuleRequest) Reset() {
	*x = CreateRelayUplinkForwardingRuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRelayUplinkForwardingRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRelayUplinkForwardingRuleRequest) ProtoMessage() {}

func (x *CreateRelayUplinkForwardingRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRelayUplinkForwardingRuleRequest.ProtoReflect.Descriptor instead.
func (*CreateRelayUplinkForwardingRuleRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{8}
}

func (x *CreateRelayUplinkForwardingRuleRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *CreateRelayUplinkForwardingRuleRequest) GetIndex() uint32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *CreateRelayUplinkForwardingRuleRequest) GetRule() *RelayUplinkForwardingRule {
	if x != nil {
		return x.Rule
	}
	return nil
}

type CreateRelayUplinkForwardingRuleResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uplink forwarding rule.
	Rule *RelayUplinkForwardingRule `protobuf:"bytes,1,opt,name=rule,proto3" json:"rule,omitempty"`
}

func (x *CreateRelayUplinkForwardingRuleResponse) Reset() {
	*x = CreateRelayUplinkForwardingRuleResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRelayUplinkForwardingRuleResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRelayUplinkForwardingRuleResponse) ProtoMessage() {}

func (x *CreateRelayUplinkForwardingRuleResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRelayUplinkForwardingRuleResponse.ProtoReflect.Descriptor instead.
func (*CreateRelayUplinkForwardingRuleResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{9}
}

func (x *CreateRelayUplinkForwardingRuleResponse) GetRule() *RelayUplinkForwardingRule {
	if x != nil {
		return x.Rule
	}
	return nil
}

type GetRelayUplinkForwardingRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// End device identifiers of the relay.
	EndDeviceIds *EndDeviceIdentifiers `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	// Index of the uplink forwarding rule.
	Index uint32 `protobuf:"varint,2,opt,name=index,proto3" json:"index,omitempty"`
	// Field mask of the fields to return.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetRelayUplinkForwardingRuleRequest) Reset() {
	*x = GetRelayUplinkForwardingRuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRelayUplinkForwardingRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRelayUplinkForwardingRuleRequest) ProtoMessage() {}

func (x *GetRelayUplinkForwardingRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRelayUplinkForwardingRuleRequest.ProtoReflect.Descriptor instead.
func (*GetRelayUplinkForwardingRuleRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{10}
}

func (x *GetRelayUplinkForwardingRuleRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *GetRelayUplinkForwardingRuleRequest) GetIndex() uint32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *GetRelayUplinkForwardingRuleRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type GetRelayUplinkForwardingRuleResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uplink forwarding rule.
	Rule *RelayUplinkForwardingRule `protobuf:"bytes,1,opt,name=rule,proto3" json:"rule,omitempty"`
}

func (x *GetRelayUplinkForwardingRuleResponse) Reset() {
	*x = GetRelayUplinkForwardingRuleResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRelayUplinkForwardingRuleResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRelayUplinkForwardingRuleResponse) ProtoMessage() {}

func (x *GetRelayUplinkForwardingRuleResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRelayUplinkForwardingRuleResponse.ProtoReflect.Descriptor instead.
func (*GetRelayUplinkForwardingRuleResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{11}
}

func (x *GetRelayUplinkForwardingRuleResponse) GetRule() *RelayUplinkForwardingRule {
	if x != nil {
		return x.Rule
	}
	return nil
}

type ListRelayUplinkForwardingRulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// End device identifiers of the relay.
	EndDeviceIds *EndDeviceIdentifiers `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	// Field mask of the fields to return.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *ListRelayUplinkForwardingRulesRequest) Reset() {
	*x = ListRelayUplinkForwardingRulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRelayUplinkForwardingRulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRelayUplinkForwardingRulesRequest) ProtoMessage() {}

func (x *ListRelayUplinkForwardingRulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRelayUplinkForwardingRulesRequest.ProtoReflect.Descriptor instead.
func (*ListRelayUplinkForwardingRulesRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{12}
}

func (x *ListRelayUplinkForwardingRulesRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *ListRelayUplinkForwardingRulesRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type ListRelayUplinkForwardingRulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uplink forwarding rules.
	Rules []*RelayUplinkForwardingRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *ListRelayUplinkForwardingRulesResponse) Reset() {
	*x = ListRelayUplinkForwardingRulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRelayUplinkForwardingRulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRelayUplinkForwardingRulesResponse) ProtoMessage() {}

func (x *ListRelayUplinkForwardingRulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRelayUplinkForwardingRulesResponse.ProtoReflect.Descriptor instead.
func (*ListRelayUplinkForwardingRulesResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{13}
}

func (x *ListRelayUplinkForwardingRulesResponse) GetRules() []*RelayUplinkForwardingRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

type UpdateRelayUplinkForwardingRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// End device identifiers of the relay.
	EndDeviceIds *EndDeviceIdentifiers `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	// Index of the uplink forwarding rule.
	Index uint32 `protobuf:"varint,2,opt,name=index,proto3" json:"index,omitempty"`
	// Uplink forwarding rule.
	Rule *RelayUplinkForwardingRule `protobuf:"bytes,3,opt,name=rule,proto3" json:"rule,omitempty"`
	// Field mask of the fields to update.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *UpdateRelayUplinkForwardingRuleRequest) Reset() {
	*x = UpdateRelayUplinkForwardingRuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRelayUplinkForwardingRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRelayUplinkForwardingRuleRequest) ProtoMessage() {}

func (x *UpdateRelayUplinkForwardingRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRelayUplinkForwardingRuleRequest.ProtoReflect.Descriptor instead.
func (*UpdateRelayUplinkForwardingRuleRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateRelayUplinkForwardingRuleRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *UpdateRelayUplinkForwardingRuleRequest) GetIndex() uint32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *UpdateRelayUplinkForwardingRuleRequest) GetRule() *RelayUplinkForwardingRule {
	if x != nil {
		return x.Rule
	}
	return nil
}

func (x *UpdateRelayUplinkForwardingRuleRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type UpdateRelayUplinkForwardingRuleResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uplink forwarding rule.
	Rule *RelayUplinkForwardingRule `protobuf:"bytes,1,opt,name=rule,proto3" json:"rule,omitempty"`
}

func (x *UpdateRelayUplinkForwardingRuleResponse) Reset() {
	*x = UpdateRelayUplinkForwardingRuleResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRelayUplinkForwardingRuleResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRelayUplinkForwardingRuleResponse) ProtoMessage() {}

func (x *UpdateRelayUplinkForwardingRuleResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRelayUplinkForwardingRuleResponse.ProtoReflect.Descriptor instead.
func (*UpdateRelayUplinkForwardingRuleResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{15}
}

func (x *UpdateRelayUplinkForwardingRuleResponse) GetRule() *RelayUplinkForwardingRule {
	if x != nil {
		return x.Rule
	}
	return nil
}

type DeleteRelayUplinkForwardingRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// End device identifiers of the relay.
	EndDeviceIds *EndDeviceIdentifiers `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	// Index of the uplink forwarding rule.
	Index uint32 `protobuf:"varint,2,opt,name=index,proto3" json:"index,omitempty"`
}

func (x *DeleteRelayUplinkForwardingRuleRequest) Reset() {
	*x = DeleteRelayUplinkForwardingRuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRelayUplinkForwardingRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRelayUplinkForwardingRuleRequest) ProtoMessage() {}

func (x *DeleteRelayUplinkForwardingRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRelayUplinkForwardingRuleRequest.ProtoReflect.Descriptor instead.
func (*DeleteRelayUplinkForwardingRuleRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{16}
}

func (x *DeleteRelayUplinkForwardingRuleRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *DeleteRelayUplinkForwardingRuleRequest) GetIndex() uint32 {
	if x != nil {
		return x.Index
	}
	return 0
}

type DeleteRelayUplinkForwardingRuleResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteRelayUplinkForwardingRuleResponse) Reset() {
	*x = DeleteRelayUplinkForwardingRuleResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRelayUplinkForwardingRuleResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRelayUplinkForwardingRuleResponse) ProtoMessage() {}

func (x *DeleteRelayUplinkForwardingRuleResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRelayUplinkForwardingRuleResponse.ProtoReflect.Descriptor instead.
func (*DeleteRelayUplinkForwardingRuleResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP(), []int{17}
}

var File_ttn_lorawan_v3_networkserver_relay_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_networkserver_relay_proto_rawDesc = []byte{
	0x0a, 0x28, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x72,
	0x65, 0x6c, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32,
	0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x74, 0x74, 0x6e, 0x2f,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x64, 0x5f, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x74, 0x6e,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaf, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a,
	0x0e, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x49, 0x64, 0x73, 0x12, 0x43, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x50, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x39, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xa2, 0x01, 0x0a, 0x0f, 0x47,
	0x65, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54,
	0x0a, 0x0e, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x49, 0x64, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x4d, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xea,
	0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45,
	0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x65,
	0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x43, 0x0a, 0x08, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x50, 0x0a, 0x13, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x39, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x6a, 0x0a,
	0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x65, 0x6e, 0x64,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x22, 0x15, 0x0a, 0x13, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0xe6, 0x01, 0x0a, 0x26, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79,
	0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x65,
	0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64,
	0x73, 0x12, 0x1d, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x18, 0x0f, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x47, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x22, 0x68, 0x0a, 0x27, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x72,
	0x75, 0x6c, 0x65, 0x22, 0xd5, 0x01, 0x0a, 0x23, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x79,
	0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x65,
	0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64,
	0x73, 0x12, 0x1d, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x18, 0x0f, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x65, 0x0a, 0x24, 0x47,
	0x65, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72,
	0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x75,
	0x6c, 0x65, 0x22, 0xb8, 0x01, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x79,
	0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0e,
	0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49,
	0x64, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x69, 0x0a,
	0x26, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c,
	0x65, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xa1, 0x02, 0x0a, 0x26, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x65, 0x6e, 0x64,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x1d, 0x0a, 0x05, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x18,
	0x0f, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x47, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c,
	0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x04, 0x72, 0x75, 0x6c,
	0x65, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x68, 0x0a, 0x27,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e,
	0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69,
	0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65,
	0x52, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x22, 0x9d, 0x01, 0x0a, 0x26, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x54, 0x0a, 0x0e, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x1d, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x18, 0x0f, 0x52,
	0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x29, 0x0a, 0x27, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x32, 0xe4, 0x11, 0x0a, 0x1b, 0x4e, 0x73, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0xaa, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61,
	0x79, 0x12, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c,
	0x61, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4c, 0x3a, 0x01, 0x2a, 0x22, 0x47, 0x2f, 0x6e, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x73, 0x12, 0xb9,
	0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x1f, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74,
	0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6a,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x64, 0x12, 0x62, 0x2f, 0x6e, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x73, 0x2f,
	0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0xc5, 0x01, 0x0a, 0x0b, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x22, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x6d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x67, 0x3a, 0x01, 0x2a, 0x1a, 0x62,
	0x2f, 0x6e, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73,
	0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73,
	0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x7d, 0x12, 0xc2, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x6c,
	0x61, 0x79, 0x12, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x6c, 0x61, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6a, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x64, 0x2a, 0x62, 0x2f, 0x6e, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x73, 0x2f, 0x7b, 0x65, 0x6e,
	0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x9a, 0x02, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72,
	0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x36, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79,
	0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x85, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x7f, 0x3a, 0x01, 0x2a, 0x22, 0x7a, 0x2f, 0x6e, 0x73, 0x2f, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x61, 0x79,
	0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x73, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x75, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x2d, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x2d, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x12, 0x98, 0x02, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6c, 0x61,
	0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x33, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55,
	0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52,
	0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x8c, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x85, 0x01, 0x12, 0x82, 0x01, 0x2f, 0x6e, 0x73,
	0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65,
	0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x72, 0x65,
	0x6c, 0x61, 0x79, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x73, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f,
	0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x2d, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x2d, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x7d, 0x12,
	0x94, 0x02, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c,
	0x65, 0x73, 0x12, 0x35, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x82, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7c, 0x12, 0x7a, 0x2f, 0x6e, 0x73, 0x2f,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x6e,
	0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x72, 0x65, 0x6c,
	0x61, 0x79, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x73, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x75,
	0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x2d, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x2d, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x12, 0xa4, 0x02, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x36, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72,
	0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x37, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55,
	0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52,
	0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8f, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x88, 0x01, 0x3a, 0x01, 0x2a, 0x1a, 0x82, 0x01, 0x2f, 0x6e, 0x73, 0x2f, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64,
	0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x61,
	0x79, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x73, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x75, 0x70,
	0x6c, 0x69, 0x6e, 0x6b, 0x2d, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x2d,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x7d, 0x12, 0xa1, 0x02,
	0x0a, 0x1f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c,
	0x65, 0x12, 0x36, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70,
	0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75,
	0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x8c, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x85, 0x01, 0x2a, 0x82, 0x01, 0x2f,
	0x6e, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f,
	0x72, 0x65, 0x6c, 0x61, 0x79, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x2d, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x2d, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x7d, 0x1a, 0x35, 0x92, 0x41, 0x32, 0x12, 0x30, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x20, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20,
	0x4c, 0x6f, 0x52, 0x61, 0x57, 0x41, 0x4e, 0xc2, 0xae, 0x20, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x20,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76,
	0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_networkserver_relay_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_networkserver_relay_proto_rawDescData = file_ttn_lorawan_v3_networkserver_relay_proto_rawDesc
)

func file_ttn_lorawan_v3_networkserver_relay_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_networkserver_relay_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_networkserver_relay_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_networkserver_relay_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_networkserver_relay_proto_rawDescData
}

var file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_ttn_lorawan_v3_networkserver_relay_proto_goTypes = []interface{}{
	(*CreateRelayRequest)(nil),                      // 0: ttn.lorawan.v3.CreateRelayRequest
	(*CreateRelayResponse)(nil),                     // 1: ttn.lorawan.v3.CreateRelayResponse
	(*GetRelayRequest)(nil),                         // 2: ttn.lorawan.v3.GetRelayRequest
	(*GetRelayResponse)(nil),                        // 3: ttn.lorawan.v3.GetRelayResponse
	(*UpdateRelayRequest)(nil),                      // 4: ttn.lorawan.v3.UpdateRelayRequest
	(*UpdateRelayResponse)(nil),                     // 5: ttn.lorawan.v3.UpdateRelayResponse
	(*DeleteRelayRequest)(nil),                      // 6: ttn.lorawan.v3.DeleteRelayRequest
	(*DeleteRelayResponse)(nil),                     // 7: ttn.lorawan.v3.DeleteRelayResponse
	(*CreateRelayUplinkForwardingRuleRequest)(nil),  // 8: ttn.lorawan.v3.CreateRelayUplinkForwardingRuleRequest
	(*CreateRelayUplinkForwardingRuleResponse)(nil), // 9: ttn.lorawan.v3.CreateRelayUplinkForwardingRuleResponse
	(*GetRelayUplinkForwardingRuleRequest)(nil),     // 10: ttn.lorawan.v3.GetRelayUplinkForwardingRuleRequest
	(*GetRelayUplinkForwardingRuleResponse)(nil),    // 11: ttn.lorawan.v3.GetRelayUplinkForwardingRuleResponse
	(*ListRelayUplinkForwardingRulesRequest)(nil),   // 12: ttn.lorawan.v3.ListRelayUplinkForwardingRulesRequest
	(*ListRelayUplinkForwardingRulesResponse)(nil),  // 13: ttn.lorawan.v3.ListRelayUplinkForwardingRulesResponse
	(*UpdateRelayUplinkForwardingRuleRequest)(nil),  // 14: ttn.lorawan.v3.UpdateRelayUplinkForwardingRuleRequest
	(*UpdateRelayUplinkForwardingRuleResponse)(nil), // 15: ttn.lorawan.v3.UpdateRelayUplinkForwardingRuleResponse
	(*DeleteRelayUplinkForwardingRuleRequest)(nil),  // 16: ttn.lorawan.v3.DeleteRelayUplinkForwardingRuleRequest
	(*DeleteRelayUplinkForwardingRuleResponse)(nil), // 17: ttn.lorawan.v3.DeleteRelayUplinkForwardingRuleResponse
	(*EndDeviceIdentifiers)(nil),                    // 18: ttn.lorawan.v3.EndDeviceIdentifiers
	(*RelaySettings)(nil),                           // 19: ttn.lorawan.v3.RelaySettings
	(*fieldmaskpb.FieldMask)(nil),                   // 20: google.protobuf.FieldMask
	(*RelayUplinkForwardingRule)(nil),               // 21: ttn.lorawan.v3.RelayUplinkForwardingRule
}
var file_ttn_lorawan_v3_networkserver_relay_proto_depIdxs = []int32{
	18, // 0: ttn.lorawan.v3.CreateRelayRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	19, // 1: ttn.lorawan.v3.CreateRelayRequest.settings:type_name -> ttn.lorawan.v3.RelaySettings
	19, // 2: ttn.lorawan.v3.CreateRelayResponse.settings:type_name -> ttn.lorawan.v3.RelaySettings
	18, // 3: ttn.lorawan.v3.GetRelayRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	20, // 4: ttn.lorawan.v3.GetRelayRequest.field_mask:type_name -> google.protobuf.FieldMask
	19, // 5: ttn.lorawan.v3.GetRelayResponse.settings:type_name -> ttn.lorawan.v3.RelaySettings
	18, // 6: ttn.lorawan.v3.UpdateRelayRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	19, // 7: ttn.lorawan.v3.UpdateRelayRequest.settings:type_name -> ttn.lorawan.v3.RelaySettings
	20, // 8: ttn.lorawan.v3.UpdateRelayRequest.field_mask:type_name -> google.protobuf.FieldMask
	19, // 9: ttn.lorawan.v3.UpdateRelayResponse.settings:type_name -> ttn.lorawan.v3.RelaySettings
	18, // 10: ttn.lorawan.v3.DeleteRelayRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	18, // 11: ttn.lorawan.v3.CreateRelayUplinkForwardingRuleRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	21, // 12: ttn.lorawan.v3.CreateRelayUplinkForwardingRuleRequest.rule:type_name -> ttn.lorawan.v3.RelayUplinkForwardingRule
	21, // 13: ttn.lorawan.v3.CreateRelayUplinkForwardingRuleResponse.rule:type_name -> ttn.lorawan.v3.RelayUplinkForwardingRule
	18, // 14: ttn.lorawan.v3.GetRelayUplinkForwardingRuleRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	20, // 15: ttn.lorawan.v3.GetRelayUplinkForwardingRuleRequest.field_mask:type_name -> google.protobuf.FieldMask
	21, // 16: ttn.lorawan.v3.GetRelayUplinkForwardingRuleResponse.rule:type_name -> ttn.lorawan.v3.RelayUplinkForwardingRule
	18, // 17: ttn.lorawan.v3.ListRelayUplinkForwardingRulesRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	20, // 18: ttn.lorawan.v3.ListRelayUplinkForwardingRulesRequest.field_mask:type_name -> google.protobuf.FieldMask
	21, // 19: ttn.lorawan.v3.ListRelayUplinkForwardingRulesResponse.rules:type_name -> ttn.lorawan.v3.RelayUplinkForwardingRule
	18, // 20: ttn.lorawan.v3.UpdateRelayUplinkForwardingRuleRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	21, // 21: ttn.lorawan.v3.UpdateRelayUplinkForwardingRuleRequest.rule:type_name -> ttn.lorawan.v3.RelayUplinkForwardingRule
	20, // 22: ttn.lorawan.v3.UpdateRelayUplinkForwardingRuleRequest.field_mask:type_name -> google.protobuf.FieldMask
	21, // 23: ttn.lorawan.v3.UpdateRelayUplinkForwardingRuleResponse.rule:type_name -> ttn.lorawan.v3.RelayUplinkForwardingRule
	18, // 24: ttn.lorawan.v3.DeleteRelayUplinkForwardingRuleRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	0,  // 25: ttn.lorawan.v3.NsRelayConfigurationService.CreateRelay:input_type -> ttn.lorawan.v3.CreateRelayRequest
	2,  // 26: ttn.lorawan.v3.NsRelayConfigurationService.GetRelay:input_type -> ttn.lorawan.v3.GetRelayRequest
	4,  // 27: ttn.lorawan.v3.NsRelayConfigurationService.UpdateRelay:input_type -> ttn.lorawan.v3.UpdateRelayRequest
	6,  // 28: ttn.lorawan.v3.NsRelayConfigurationService.DeleteRelay:input_type -> ttn.lorawan.v3.DeleteRelayRequest
	8,  // 29: ttn.lorawan.v3.NsRelayConfigurationService.CreateRelayUplinkForwardingRule:input_type -> ttn.lorawan.v3.CreateRelayUplinkForwardingRuleRequest
	10, // 30: ttn.lorawan.v3.NsRelayConfigurationService.GetRelayUplinkForwardingRule:input_type -> ttn.lorawan.v3.GetRelayUplinkForwardingRuleRequest
	12, // 31: ttn.lorawan.v3.NsRelayConfigurationService.ListRelayUplinkForwardingRules:input_type -> ttn.lorawan.v3.ListRelayUplinkForwardingRulesRequest
	14, // 32: ttn.lorawan.v3.NsRelayConfigurationService.UpdateRelayUplinkForwardingRule:input_type -> ttn.lorawan.v3.UpdateRelayUplinkForwardingRuleRequest
	16, // 33: ttn.lorawan.v3.NsRelayConfigurationService.DeleteRelayUplinkForwardingRule:input_type -> ttn.lorawan.v3.DeleteRelayUplinkForwardingRuleRequest
	1,  // 34: ttn.lorawan.v3.NsRelayConfigurationService.CreateRelay:output_type -> ttn.lorawan.v3.CreateRelayResponse
	3,  // 35: ttn.lorawan.v3.NsRelayConfigurationService.GetRelay:output_type -> ttn.lorawan.v3.GetRelayResponse
	5,  // 36: ttn.lorawan.v3.NsRelayConfigurationService.UpdateRelay:output_type -> ttn.lorawan.v3.UpdateRelayResponse
	7,  // 37: ttn.lorawan.v3.NsRelayConfigurationService.DeleteRelay:output_type -> ttn.lorawan.v3.DeleteRelayResponse
	9,  // 38: ttn.lorawan.v3.NsRelayConfigurationService.CreateRelayUplinkForwardingRule:output_type -> ttn.lorawan.v3.CreateRelayUplinkForwardingRuleResponse
	11, // 39: ttn.lorawan.v3.NsRelayConfigurationService.GetRelayUplinkForwardingRule:output_type -> ttn.lorawan.v3.GetRelayUplinkForwardingRuleResponse
	13, // 40: ttn.lorawan.v3.NsRelayConfigurationService.ListRelayUplinkForwardingRules:output_type -> ttn.lorawan.v3.ListRelayUplinkForwardingRulesResponse
	15, // 41: ttn.lorawan.v3.NsRelayConfigurationService.UpdateRelayUplinkForwardingRule:output_type -> ttn.lorawan.v3.UpdateRelayUplinkForwardingRuleResponse
	17, // 42: ttn.lorawan.v3.NsRelayConfigurationService.DeleteRelayUplinkForwardingRule:output_type -> ttn.lorawan.v3.DeleteRelayUplinkForwardingRuleResponse
	34, // [34:43] is the sub-list for method output_type
	25, // [25:34] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_networkserver_relay_proto_init() }
func file_ttn_lorawan_v3_networkserver_relay_proto_init() {
	if File_ttn_lorawan_v3_networkserver_relay_proto != nil {
		return
	}
	file_ttn_lorawan_v3_end_device_proto_init()
	file_ttn_lorawan_v3_identifiers_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRelayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRelayResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRelayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRelayResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRelayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRelayResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRelayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRelayResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRelayUplinkForwardingRuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRelayUplinkForwardingRuleResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRelayUplinkForwardingRuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRelayUplinkForwardingRuleResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRelayUplinkForwardingRulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRelayUplinkForwardingRulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRelayUplinkForwardingRuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRelayUplinkForwardingRuleResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRelayUplinkForwardingRuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRelayUplinkForwardingRuleResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_networkserver_relay_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_ttn_lorawan_v3_networkserver_relay_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_networkserver_relay_proto_depIdxs,
		MessageInfos:      file_ttn_lorawan_v3_networkserver_relay_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_networkserver_relay_proto = out.File
	file_ttn_lorawan_v3_networkserver_relay_proto_rawDesc = nil
	file_ttn_lorawan_v3_networkserver_relay_proto_goTypes = nil
	file_ttn_lorawan_v3_networkserver_relay_proto_depIdxs = nil
}
