// Copyright © 2024 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.1
// source: ttn/lorawan/v3/networkserver_mac_settings_profile.proto

package ttnpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	NsMACSettingsProfileRegistry_Create_FullMethodName = "/ttn.lorawan.v3.NsMACSettingsProfileRegistry/Create"
	NsMACSettingsProfileRegistry_Get_FullMethodName    = "/ttn.lorawan.v3.NsMACSettingsProfileRegistry/Get"
	NsMACSettingsProfileRegistry_Update_FullMethodName = "/ttn.lorawan.v3.NsMACSettingsProfileRegistry/Update"
	NsMACSettingsProfileRegistry_Delete_FullMethodName = "/ttn.lorawan.v3.NsMACSettingsProfileRegistry/Delete"
	NsMACSettingsProfileRegistry_List_FullMethodName   = "/ttn.lorawan.v3.NsMACSettingsProfileRegistry/List"
)

// NsMACSettingsProfileRegistryClient is the client API for NsMACSettingsProfileRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NsMACSettingsProfileRegistryClient interface {
	// Create creates a new MAC settings profile.
	Create(ctx context.Context, in *CreateMACSettingsProfileRequest, opts ...grpc.CallOption) (*CreateMACSettingsProfileResponse, error)
	// Get returns the MAC settings profile that matches the given identifiers.
	Get(ctx context.Context, in *GetMACSettingsProfileRequest, opts ...grpc.CallOption) (*GetMACSettingsProfileResponse, error)
	// Update updates the MAC settings profile that matches the given identifiers.
	Update(ctx context.Context, in *UpdateMACSettingsProfileRequest, opts ...grpc.CallOption) (*UpdateMACSettingsProfileResponse, error)
	// Delete deletes the MAC settings profile that matches the given identifiers.
	Delete(ctx context.Context, in *DeleteMACSettingsProfileRequest, opts ...grpc.CallOption) (*DeleteMACSettingsProfileResponse, error)
	// List lists the MAC settings profiles.
	List(ctx context.Context, in *ListMACSettingsProfilesRequest, opts ...grpc.CallOption) (*ListMACSettingsProfilesResponse, error)
}

type nsMACSettingsProfileRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewNsMACSettingsProfileRegistryClient(cc grpc.ClientConnInterface) NsMACSettingsProfileRegistryClient {
	return &nsMACSettingsProfileRegistryClient{cc}
}

func (c *nsMACSettingsProfileRegistryClient) Create(ctx context.Context, in *CreateMACSettingsProfileRequest, opts ...grpc.CallOption) (*CreateMACSettingsProfileResponse, error) {
	out := new(CreateMACSettingsProfileResponse)
	err := c.cc.Invoke(ctx, NsMACSettingsProfileRegistry_Create_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nsMACSettingsProfileRegistryClient) Get(ctx context.Context, in *GetMACSettingsProfileRequest, opts ...grpc.CallOption) (*GetMACSettingsProfileResponse, error) {
	out := new(GetMACSettingsProfileResponse)
	err := c.cc.Invoke(ctx, NsMACSettingsProfileRegistry_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nsMACSettingsProfileRegistryClient) Update(ctx context.Context, in *UpdateMACSettingsProfileRequest, opts ...grpc.CallOption) (*UpdateMACSettingsProfileResponse, error) {
	out := new(UpdateMACSettingsProfileResponse)
	err := c.cc.Invoke(ctx, NsMACSettingsProfileRegistry_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nsMACSettingsProfileRegistryClient) Delete(ctx context.Context, in *DeleteMACSettingsProfileRequest, opts ...grpc.CallOption) (*DeleteMACSettingsProfileResponse, error) {
	out := new(DeleteMACSettingsProfileResponse)
	err := c.cc.Invoke(ctx, NsMACSettingsProfileRegistry_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nsMACSettingsProfileRegistryClient) List(ctx context.Context, in *ListMACSettingsProfilesRequest, opts ...grpc.CallOption) (*ListMACSettingsProfilesResponse, error) {
	out := new(ListMACSettingsProfilesResponse)
	err := c.cc.Invoke(ctx, NsMACSettingsProfileRegistry_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NsMACSettingsProfileRegistryServer is the server API for NsMACSettingsProfileRegistry service.
// All implementations must embed UnimplementedNsMACSettingsProfileRegistryServer
// for forward compatibility
type NsMACSettingsProfileRegistryServer interface {
	// Create creates a new MAC settings profile.
	Create(context.Context, *CreateMACSettingsProfileRequest) (*CreateMACSettingsProfileResponse, error)
	// Get returns the MAC settings profile that matches the given identifiers.
	Get(context.Context, *GetMACSettingsProfileRequest) (*GetMACSettingsProfileResponse, error)
	// Update updates the MAC settings profile that matches the given identifiers.
	Update(context.Context, *UpdateMACSettingsProfileRequest) (*UpdateMACSettingsProfileResponse, error)
	// Delete deletes the MAC settings profile that matches the given identifiers.
	Delete(context.Context, *DeleteMACSettingsProfileRequest) (*DeleteMACSettingsProfileResponse, error)
	// List lists the MAC settings profiles.
	List(context.Context, *ListMACSettingsProfilesRequest) (*ListMACSettingsProfilesResponse, error)
	mustEmbedUnimplementedNsMACSettingsProfileRegistryServer()
}

// UnimplementedNsMACSettingsProfileRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedNsMACSettingsProfileRegistryServer struct {
}

func (UnimplementedNsMACSettingsProfileRegistryServer) Create(context.Context, *CreateMACSettingsProfileRequest) (*CreateMACSettingsProfileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedNsMACSettingsProfileRegistryServer) Get(context.Context, *GetMACSettingsProfileRequest) (*GetMACSettingsProfileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedNsMACSettingsProfileRegistryServer) Update(context.Context, *UpdateMACSettingsProfileRequest) (*UpdateMACSettingsProfileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedNsMACSettingsProfileRegistryServer) Delete(context.Context, *DeleteMACSettingsProfileRequest) (*DeleteMACSettingsProfileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedNsMACSettingsProfileRegistryServer) List(context.Context, *ListMACSettingsProfilesRequest) (*ListMACSettingsProfilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedNsMACSettingsProfileRegistryServer) mustEmbedUnimplementedNsMACSettingsProfileRegistryServer() {
}

// UnsafeNsMACSettingsProfileRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NsMACSettingsProfileRegistryServer will
// result in compilation errors.
type UnsafeNsMACSettingsProfileRegistryServer interface {
	mustEmbedUnimplementedNsMACSettingsProfileRegistryServer()
}

func RegisterNsMACSettingsProfileRegistryServer(s grpc.ServiceRegistrar, srv NsMACSettingsProfileRegistryServer) {
	s.RegisterService(&NsMACSettingsProfileRegistry_ServiceDesc, srv)
}

func _NsMACSettingsProfileRegistry_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMACSettingsProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NsMACSettingsProfileRegistryServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NsMACSettingsProfileRegistry_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NsMACSettingsProfileRegistryServer).Create(ctx, req.(*CreateMACSettingsProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NsMACSettingsProfileRegistry_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMACSettingsProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NsMACSettingsProfileRegistryServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NsMACSettingsProfileRegistry_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NsMACSettingsProfileRegistryServer).Get(ctx, req.(*GetMACSettingsProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NsMACSettingsProfileRegistry_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMACSettingsProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NsMACSettingsProfileRegistryServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NsMACSettingsProfileRegistry_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NsMACSettingsProfileRegistryServer).Update(ctx, req.(*UpdateMACSettingsProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NsMACSettingsProfileRegistry_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMACSettingsProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NsMACSettingsProfileRegistryServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NsMACSettingsProfileRegistry_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NsMACSettingsProfileRegistryServer).Delete(ctx, req.(*DeleteMACSettingsProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NsMACSettingsProfileRegistry_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMACSettingsProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NsMACSettingsProfileRegistryServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NsMACSettingsProfileRegistry_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NsMACSettingsProfileRegistryServer).List(ctx, req.(*ListMACSettingsProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NsMACSettingsProfileRegistry_ServiceDesc is the grpc.ServiceDesc for NsMACSettingsProfileRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NsMACSettingsProfileRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.NsMACSettingsProfileRegistry",
	HandlerType: (*NsMACSettingsProfileRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _NsMACSettingsProfileRegistry_Create_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _NsMACSettingsProfileRegistry_Get_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _NsMACSettingsProfileRegistry_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _NsMACSettingsProfileRegistry_Delete_Handler,
		},
		{
			MethodName: "List",
			Handler:    _NsMACSettingsProfileRegistry_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/networkserver_mac_settings_profile.proto",
}
