// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on GenerateDevAddrResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GenerateDevAddrResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GenerateDevAddrResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "dev_addr":

			if len(m.GetDevAddr()) > 0 {

				if len(m.GetDevAddr()) != 4 {
					return GenerateDevAddrResponseValidationError{
						field:  "dev_addr",
						reason: "value length must be 4 bytes",
					}
				}

			}

		default:
			return GenerateDevAddrResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GenerateDevAddrResponseValidationError is the validation error returned by
// GenerateDevAddrResponse.ValidateFields if the designated constraints aren't met.
type GenerateDevAddrResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GenerateDevAddrResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GenerateDevAddrResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GenerateDevAddrResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GenerateDevAddrResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GenerateDevAddrResponseValidationError) ErrorName() string {
	return "GenerateDevAddrResponseValidationError"
}

// Error satisfies the builtin error interface
func (e GenerateDevAddrResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGenerateDevAddrResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GenerateDevAddrResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GenerateDevAddrResponseValidationError{}

// ValidateFields checks the field values on GetDefaultMACSettingsRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *GetDefaultMACSettingsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetDefaultMACSettingsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "frequency_plan_id":

			if utf8.RuneCountInString(m.GetFrequencyPlanId()) > 64 {
				return GetDefaultMACSettingsRequestValidationError{
					field:  "frequency_plan_id",
					reason: "value length must be at most 64 runes",
				}
			}

		case "lorawan_phy_version":

			if _, ok := PHYVersion_name[int32(m.GetLorawanPhyVersion())]; !ok {
				return GetDefaultMACSettingsRequestValidationError{
					field:  "lorawan_phy_version",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return GetDefaultMACSettingsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetDefaultMACSettingsRequestValidationError is the validation error returned
// by GetDefaultMACSettingsRequest.ValidateFields if the designated
// constraints aren't met.
type GetDefaultMACSettingsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetDefaultMACSettingsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetDefaultMACSettingsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetDefaultMACSettingsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetDefaultMACSettingsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetDefaultMACSettingsRequestValidationError) ErrorName() string {
	return "GetDefaultMACSettingsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetDefaultMACSettingsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetDefaultMACSettingsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetDefaultMACSettingsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetDefaultMACSettingsRequestValidationError{}

// ValidateFields checks the field values on GetNetIDResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetNetIDResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetNetIDResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "net_id":

			if len(m.GetNetId()) > 0 {

				if len(m.GetNetId()) != 3 {
					return GetNetIDResponseValidationError{
						field:  "net_id",
						reason: "value length must be 3 bytes",
					}
				}

			}

		default:
			return GetNetIDResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetNetIDResponseValidationError is the validation error returned by
// GetNetIDResponse.ValidateFields if the designated constraints aren't met.
type GetNetIDResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetNetIDResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetNetIDResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetNetIDResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetNetIDResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetNetIDResponseValidationError) ErrorName() string { return "GetNetIDResponseValidationError" }

// Error satisfies the builtin error interface
func (e GetNetIDResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetNetIDResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetNetIDResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetNetIDResponseValidationError{}

// ValidateFields checks the field values on GetDeviceAdressPrefixesResponse
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *GetDeviceAdressPrefixesResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetDeviceAdressPrefixesResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "dev_addr_prefixes":

			for idx, item := range m.GetDevAddrPrefixes() {
				_, _ = idx, item

				if len(item) != 5 {
					return GetDeviceAdressPrefixesResponseValidationError{
						field:  fmt.Sprintf("dev_addr_prefixes[%v]", idx),
						reason: "value length must be 5 bytes",
					}
				}

			}

		default:
			return GetDeviceAdressPrefixesResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetDeviceAdressPrefixesResponseValidationError is the validation error
// returned by GetDeviceAdressPrefixesResponse.ValidateFields if the
// designated constraints aren't met.
type GetDeviceAdressPrefixesResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetDeviceAdressPrefixesResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetDeviceAdressPrefixesResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetDeviceAdressPrefixesResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetDeviceAdressPrefixesResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetDeviceAdressPrefixesResponseValidationError) ErrorName() string {
	return "GetDeviceAdressPrefixesResponseValidationError"
}

// Error satisfies the builtin error interface
func (e GetDeviceAdressPrefixesResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetDeviceAdressPrefixesResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetDeviceAdressPrefixesResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetDeviceAdressPrefixesResponseValidationError{}
