// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on RxMetadata with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *RxMetadata) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RxMetadataFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return RxMetadataValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return RxMetadataValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "packet_broker":

			if v, ok := interface{}(m.GetPacketBroker()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return RxMetadataValidationError{
						field:  "packet_broker",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "relay":

			if v, ok := interface{}(m.GetRelay()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return RxMetadataValidationError{
						field:  "relay",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "antenna_index":
			// no validation rules for AntennaIndex
		case "time":

			if v, ok := interface{}(m.GetTime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return RxMetadataValidationError{
						field:  "time",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "timestamp":
			// no validation rules for Timestamp
		case "fine_timestamp":
			// no validation rules for FineTimestamp
		case "encrypted_fine_timestamp":
			// no validation rules for EncryptedFineTimestamp
		case "encrypted_fine_timestamp_key_id":
			// no validation rules for EncryptedFineTimestampKeyId
		case "rssi":
			// no validation rules for Rssi
		case "signal_rssi":

			if v, ok := interface{}(m.GetSignalRssi()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return RxMetadataValidationError{
						field:  "signal_rssi",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "channel_rssi":
			// no validation rules for ChannelRssi
		case "rssi_standard_deviation":
			// no validation rules for RssiStandardDeviation
		case "snr":
			// no validation rules for Snr
		case "frequency_offset":
			// no validation rules for FrequencyOffset
		case "location":

			if v, ok := interface{}(m.GetLocation()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return RxMetadataValidationError{
						field:  "location",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_path_constraint":

			if _, ok := DownlinkPathConstraint_name[int32(m.GetDownlinkPathConstraint())]; !ok {
				return RxMetadataValidationError{
					field:  "downlink_path_constraint",
					reason: "value must be one of the defined enum values",
				}
			}

		case "uplink_token":
			// no validation rules for UplinkToken
		case "channel_index":

			if m.GetChannelIndex() > 255 {
				return RxMetadataValidationError{
					field:  "channel_index",
					reason: "value must be less than or equal to 255",
				}
			}

		case "hopping_width":
			// no validation rules for HoppingWidth
		case "frequency_drift":
			// no validation rules for FrequencyDrift
		case "gps_time":

			if v, ok := interface{}(m.GetGpsTime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return RxMetadataValidationError{
						field:  "gps_time",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "received_at":

			if v, ok := interface{}(m.GetReceivedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return RxMetadataValidationError{
						field:  "received_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "advanced":

			if v, ok := interface{}(m.GetAdvanced()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return RxMetadataValidationError{
						field:  "advanced",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return RxMetadataValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RxMetadataValidationError is the validation error returned by
// RxMetadata.ValidateFields if the designated constraints aren't met.
type RxMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RxMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RxMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RxMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RxMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RxMetadataValidationError) ErrorName() string { return "RxMetadataValidationError" }

// Error satisfies the builtin error interface
func (e RxMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRxMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RxMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RxMetadataValidationError{}

// ValidateFields checks the field values on Location with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *Location) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = LocationFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "latitude":

			if val := m.GetLatitude(); val < -90 || val > 90 {
				return LocationValidationError{
					field:  "latitude",
					reason: "value must be inside range [-90, 90]",
				}
			}

		case "longitude":

			if val := m.GetLongitude(); val < -180 || val > 180 {
				return LocationValidationError{
					field:  "longitude",
					reason: "value must be inside range [-180, 180]",
				}
			}

		case "altitude":
			// no validation rules for Altitude
		case "accuracy":
			// no validation rules for Accuracy
		case "source":

			if _, ok := LocationSource_name[int32(m.GetSource())]; !ok {
				return LocationValidationError{
					field:  "source",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return LocationValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// LocationValidationError is the validation error returned by
// Location.ValidateFields if the designated constraints aren't met.
type LocationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LocationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LocationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LocationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LocationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LocationValidationError) ErrorName() string { return "LocationValidationError" }

// Error satisfies the builtin error interface
func (e LocationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLocation.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LocationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LocationValidationError{}

// ValidateFields checks the field values on PacketBrokerMetadata with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *PacketBrokerMetadata) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerMetadataFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "message_id":
			// no validation rules for MessageId
		case "forwarder_net_id":

			if len(m.GetForwarderNetId()) > 0 {

				if len(m.GetForwarderNetId()) != 3 {
					return PacketBrokerMetadataValidationError{
						field:  "forwarder_net_id",
						reason: "value length must be 3 bytes",
					}
				}

			}

		case "forwarder_tenant_id":
			// no validation rules for ForwarderTenantId
		case "forwarder_cluster_id":
			// no validation rules for ForwarderClusterId
		case "forwarder_gateway_eui":

			if len(m.GetForwarderGatewayEui()) > 0 {

				if len(m.GetForwarderGatewayEui()) != 8 {
					return PacketBrokerMetadataValidationError{
						field:  "forwarder_gateway_eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		case "forwarder_gateway_id":

			if v, ok := interface{}(m.GetForwarderGatewayId()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerMetadataValidationError{
						field:  "forwarder_gateway_id",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "home_network_net_id":

			if len(m.GetHomeNetworkNetId()) > 0 {

				if len(m.GetHomeNetworkNetId()) != 3 {
					return PacketBrokerMetadataValidationError{
						field:  "home_network_net_id",
						reason: "value length must be 3 bytes",
					}
				}

			}

		case "home_network_tenant_id":
			// no validation rules for HomeNetworkTenantId
		case "home_network_cluster_id":
			// no validation rules for HomeNetworkClusterId
		case "hops":

			for idx, item := range m.GetHops() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return PacketBrokerMetadataValidationError{
							field:  fmt.Sprintf("hops[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return PacketBrokerMetadataValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerMetadataValidationError is the validation error returned by
// PacketBrokerMetadata.ValidateFields if the designated constraints aren't met.
type PacketBrokerMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerMetadataValidationError) ErrorName() string {
	return "PacketBrokerMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerMetadataValidationError{}

// ValidateFields checks the field values on PacketBrokerRouteHop with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *PacketBrokerRouteHop) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PacketBrokerRouteHopFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "received_at":

			if v, ok := interface{}(m.GetReceivedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return PacketBrokerRouteHopValidationError{
						field:  "received_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "sender_name":
			// no validation rules for SenderName
		case "sender_address":
			// no validation rules for SenderAddress
		case "receiver_name":
			// no validation rules for ReceiverName
		case "receiver_agent":
			// no validation rules for ReceiverAgent
		default:
			return PacketBrokerRouteHopValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PacketBrokerRouteHopValidationError is the validation error returned by
// PacketBrokerRouteHop.ValidateFields if the designated constraints aren't met.
type PacketBrokerRouteHopValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PacketBrokerRouteHopValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PacketBrokerRouteHopValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PacketBrokerRouteHopValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PacketBrokerRouteHopValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PacketBrokerRouteHopValidationError) ErrorName() string {
	return "PacketBrokerRouteHopValidationError"
}

// Error satisfies the builtin error interface
func (e PacketBrokerRouteHopValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPacketBrokerRouteHop.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PacketBrokerRouteHopValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PacketBrokerRouteHopValidationError{}

// ValidateFields checks the field values on RelayMetadata with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RelayMetadata) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RelayMetadataFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "device_id":

			if utf8.RuneCountInString(m.GetDeviceId()) > 36 {
				return RelayMetadataValidationError{
					field:  "device_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_RelayMetadata_DeviceId_Pattern.MatchString(m.GetDeviceId()) {
				return RelayMetadataValidationError{
					field:  "device_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "wor_channel":

			if _, ok := RelayWORChannel_name[int32(m.GetWorChannel())]; !ok {
				return RelayMetadataValidationError{
					field:  "wor_channel",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return RelayMetadataValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RelayMetadataValidationError is the validation error returned by
// RelayMetadata.ValidateFields if the designated constraints aren't met.
type RelayMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelayMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelayMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelayMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelayMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelayMetadataValidationError) ErrorName() string { return "RelayMetadataValidationError" }

// Error satisfies the builtin error interface
func (e RelayMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelayMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelayMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelayMetadataValidationError{}

var _RelayMetadata_DeviceId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")
