// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/metadata.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type LocationSource int32

const (
	// The source of the location is not known or not set.
	LocationSource_SOURCE_UNKNOWN LocationSource = 0
	// The location is determined by GPS.
	LocationSource_SOURCE_GPS LocationSource = 1
	// The location is set in and updated from a registry.
	LocationSource_SOURCE_REGISTRY LocationSource = 3
	// The location is estimated with IP geolocation.
	LocationSource_SOURCE_IP_GEOLOCATION LocationSource = 4
	// The location is estimated with WiFi RSSI geolocation.
	LocationSource_SOURCE_WIFI_RSSI_GEOLOCATION LocationSource = 5
	// The location is estimated with BT/BLE RSSI geolocation.
	LocationSource_SOURCE_BT_RSSI_GEOLOCATION LocationSource = 6
	// The location is estimated with LoRa RSSI geolocation.
	LocationSource_SOURCE_LORA_RSSI_GEOLOCATION LocationSource = 7
	// The location is estimated with LoRa TDOA geolocation.
	LocationSource_SOURCE_LORA_TDOA_GEOLOCATION LocationSource = 8
	// The location is estimated by a combination of geolocation sources.
	LocationSource_SOURCE_COMBINED_GEOLOCATION LocationSource = 9 // More estimation methods can be added.
)

// Enum value maps for LocationSource.
var (
	LocationSource_name = map[int32]string{
		0: "SOURCE_UNKNOWN",
		1: "SOURCE_GPS",
		3: "SOURCE_REGISTRY",
		4: "SOURCE_IP_GEOLOCATION",
		5: "SOURCE_WIFI_RSSI_GEOLOCATION",
		6: "SOURCE_BT_RSSI_GEOLOCATION",
		7: "SOURCE_LORA_RSSI_GEOLOCATION",
		8: "SOURCE_LORA_TDOA_GEOLOCATION",
		9: "SOURCE_COMBINED_GEOLOCATION",
	}
	LocationSource_value = map[string]int32{
		"SOURCE_UNKNOWN":               0,
		"SOURCE_GPS":                   1,
		"SOURCE_REGISTRY":              3,
		"SOURCE_IP_GEOLOCATION":        4,
		"SOURCE_WIFI_RSSI_GEOLOCATION": 5,
		"SOURCE_BT_RSSI_GEOLOCATION":   6,
		"SOURCE_LORA_RSSI_GEOLOCATION": 7,
		"SOURCE_LORA_TDOA_GEOLOCATION": 8,
		"SOURCE_COMBINED_GEOLOCATION":  9,
	}
)

func (x LocationSource) Enum() *LocationSource {
	p := new(LocationSource)
	*p = x
	return p
}

func (x LocationSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LocationSource) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_metadata_proto_enumTypes[0].Descriptor()
}

func (LocationSource) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_metadata_proto_enumTypes[0]
}

func (x LocationSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LocationSource.Descriptor instead.
func (LocationSource) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_metadata_proto_rawDescGZIP(), []int{0}
}

// Contains metadata for a received message. Each antenna that receives
// a message corresponds to one RxMetadata.
type RxMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds   *GatewayIdentifiers   `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	PacketBroker *PacketBrokerMetadata `protobuf:"bytes,18,opt,name=packet_broker,json=packetBroker,proto3" json:"packet_broker,omitempty"`
	Relay        *RelayMetadata        `protobuf:"bytes,23,opt,name=relay,proto3" json:"relay,omitempty"`
	AntennaIndex uint32                `protobuf:"varint,2,opt,name=antenna_index,json=antennaIndex,proto3" json:"antenna_index,omitempty"`
	// Timestamp at the end of the transmission, provided by the gateway. The accuracy is undefined.
	Time *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
	// Gateway concentrator timestamp when the Rx finished (microseconds).
	Timestamp uint32 `protobuf:"varint,4,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Gateway's internal fine timestamp when the Rx finished (nanoseconds).
	FineTimestamp uint64 `protobuf:"varint,5,opt,name=fine_timestamp,json=fineTimestamp,proto3" json:"fine_timestamp,omitempty"`
	// Encrypted gateway's internal fine timestamp when the Rx finished (nanoseconds).
	EncryptedFineTimestamp      []byte `protobuf:"bytes,6,opt,name=encrypted_fine_timestamp,json=encryptedFineTimestamp,proto3" json:"encrypted_fine_timestamp,omitempty"`
	EncryptedFineTimestampKeyId string `protobuf:"bytes,7,opt,name=encrypted_fine_timestamp_key_id,json=encryptedFineTimestampKeyId,proto3" json:"encrypted_fine_timestamp_key_id,omitempty"`
	// Received signal strength indicator (dBm).
	// This value equals `channel_rssi`.
	Rssi float32 `protobuf:"fixed32,8,opt,name=rssi,proto3" json:"rssi,omitempty"`
	// Received signal strength indicator of the signal (dBm).
	SignalRssi *wrapperspb.FloatValue `protobuf:"bytes,16,opt,name=signal_rssi,json=signalRssi,proto3" json:"signal_rssi,omitempty"`
	// Received signal strength indicator of the channel (dBm).
	ChannelRssi float32 `protobuf:"fixed32,9,opt,name=channel_rssi,json=channelRssi,proto3" json:"channel_rssi,omitempty"`
	// Standard deviation of the RSSI during preamble.
	RssiStandardDeviation float32 `protobuf:"fixed32,10,opt,name=rssi_standard_deviation,json=rssiStandardDeviation,proto3" json:"rssi_standard_deviation,omitempty"`
	// Signal-to-noise ratio (dB).
	Snr float32 `protobuf:"fixed32,11,opt,name=snr,proto3" json:"snr,omitempty"`
	// Frequency offset (Hz).
	FrequencyOffset int64 `protobuf:"varint,12,opt,name=frequency_offset,json=frequencyOffset,proto3" json:"frequency_offset,omitempty"`
	// Antenna location; injected by the Gateway Server.
	Location *Location `protobuf:"bytes,13,opt,name=location,proto3" json:"location,omitempty"`
	// Gateway downlink path constraint; injected by the Gateway Server.
	DownlinkPathConstraint DownlinkPathConstraint `protobuf:"varint,14,opt,name=downlink_path_constraint,json=downlinkPathConstraint,proto3,enum=ttn.lorawan.v3.DownlinkPathConstraint" json:"downlink_path_constraint,omitempty"`
	// Uplink token to be included in the Tx request in class A downlink; injected by gateway, Gateway Server or fNS.
	UplinkToken []byte `protobuf:"bytes,15,opt,name=uplink_token,json=uplinkToken,proto3" json:"uplink_token,omitempty"`
	// Index of the gateway channel that received the message.
	ChannelIndex uint32 `protobuf:"varint,17,opt,name=channel_index,json=channelIndex,proto3" json:"channel_index,omitempty"`
	// Hopping width; a number describing the number of steps of the LR-FHSS grid.
	HoppingWidth uint32 `protobuf:"varint,19,opt,name=hopping_width,json=hoppingWidth,proto3" json:"hopping_width,omitempty"`
	// Frequency drift in Hz between start and end of an LR-FHSS packet (signed).
	FrequencyDrift int32 `protobuf:"varint,20,opt,name=frequency_drift,json=frequencyDrift,proto3" json:"frequency_drift,omitempty"`
	// Timestamp at the end of the transmission, provided by the gateway.
	// Guaranteed to be based on a GPS PPS signal, with an accuracy of 1 millisecond.
	GpsTime *timestamppb.Timestamp `protobuf:"bytes,21,opt,name=gps_time,json=gpsTime,proto3" json:"gps_time,omitempty"`
	// Timestamp at which the Gateway Server has received the message.
	ReceivedAt *timestamppb.Timestamp `protobuf:"bytes,22,opt,name=received_at,json=receivedAt,proto3" json:"received_at,omitempty"`
	// Advanced metadata fields
	// - can be used for advanced information or experimental features that are not yet formally defined in the API
	// - field names are written in snake_case
	Advanced *structpb.Struct `protobuf:"bytes,99,opt,name=advanced,proto3" json:"advanced,omitempty"`
}

func (x *RxMetadata) Reset() {
	*x = RxMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_metadata_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RxMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RxMetadata) ProtoMessage() {}

func (x *RxMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_metadata_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RxMetadata.ProtoReflect.Descriptor instead.
func (*RxMetadata) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_metadata_proto_rawDescGZIP(), []int{0}
}

func (x *RxMetadata) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *RxMetadata) GetPacketBroker() *PacketBrokerMetadata {
	if x != nil {
		return x.PacketBroker
	}
	return nil
}

func (x *RxMetadata) GetRelay() *RelayMetadata {
	if x != nil {
		return x.Relay
	}
	return nil
}

func (x *RxMetadata) GetAntennaIndex() uint32 {
	if x != nil {
		return x.AntennaIndex
	}
	return 0
}

func (x *RxMetadata) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *RxMetadata) GetTimestamp() uint32 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *RxMetadata) GetFineTimestamp() uint64 {
	if x != nil {
		return x.FineTimestamp
	}
	return 0
}

func (x *RxMetadata) GetEncryptedFineTimestamp() []byte {
	if x != nil {
		return x.EncryptedFineTimestamp
	}
	return nil
}

func (x *RxMetadata) GetEncryptedFineTimestampKeyId() string {
	if x != nil {
		return x.EncryptedFineTimestampKeyId
	}
	return ""
}

func (x *RxMetadata) GetRssi() float32 {
	if x != nil {
		return x.Rssi
	}
	return 0
}

func (x *RxMetadata) GetSignalRssi() *wrapperspb.FloatValue {
	if x != nil {
		return x.SignalRssi
	}
	return nil
}

func (x *RxMetadata) GetChannelRssi() float32 {
	if x != nil {
		return x.ChannelRssi
	}
	return 0
}

func (x *RxMetadata) GetRssiStandardDeviation() float32 {
	if x != nil {
		return x.RssiStandardDeviation
	}
	return 0
}

func (x *RxMetadata) GetSnr() float32 {
	if x != nil {
		return x.Snr
	}
	return 0
}

func (x *RxMetadata) GetFrequencyOffset() int64 {
	if x != nil {
		return x.FrequencyOffset
	}
	return 0
}

func (x *RxMetadata) GetLocation() *Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *RxMetadata) GetDownlinkPathConstraint() DownlinkPathConstraint {
	if x != nil {
		return x.DownlinkPathConstraint
	}
	return DownlinkPathConstraint_DOWNLINK_PATH_CONSTRAINT_NONE
}

func (x *RxMetadata) GetUplinkToken() []byte {
	if x != nil {
		return x.UplinkToken
	}
	return nil
}

func (x *RxMetadata) GetChannelIndex() uint32 {
	if x != nil {
		return x.ChannelIndex
	}
	return 0
}

func (x *RxMetadata) GetHoppingWidth() uint32 {
	if x != nil {
		return x.HoppingWidth
	}
	return 0
}

func (x *RxMetadata) GetFrequencyDrift() int32 {
	if x != nil {
		return x.FrequencyDrift
	}
	return 0
}

func (x *RxMetadata) GetGpsTime() *timestamppb.Timestamp {
	if x != nil {
		return x.GpsTime
	}
	return nil
}

func (x *RxMetadata) GetReceivedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ReceivedAt
	}
	return nil
}

func (x *RxMetadata) GetAdvanced() *structpb.Struct {
	if x != nil {
		return x.Advanced
	}
	return nil
}

type Location struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The North–South position (degrees; -90 to +90), where 0 is the equator, North pole is positive, South pole is negative.
	Latitude float64 `protobuf:"fixed64,1,opt,name=latitude,proto3" json:"latitude,omitempty"`
	// The East-West position (degrees; -180 to +180), where 0 is the Prime Meridian (Greenwich), East is positive , West is negative.
	Longitude float64 `protobuf:"fixed64,2,opt,name=longitude,proto3" json:"longitude,omitempty"`
	// The altitude (meters), where 0 is the mean sea level.
	Altitude int32 `protobuf:"varint,3,opt,name=altitude,proto3" json:"altitude,omitempty"`
	// The accuracy of the location (meters).
	Accuracy int32 `protobuf:"varint,4,opt,name=accuracy,proto3" json:"accuracy,omitempty"`
	// Source of the location information.
	Source LocationSource `protobuf:"varint,5,opt,name=source,proto3,enum=ttn.lorawan.v3.LocationSource" json:"source,omitempty"`
}

func (x *Location) Reset() {
	*x = Location{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_metadata_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_metadata_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Location.ProtoReflect.Descriptor instead.
func (*Location) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_metadata_proto_rawDescGZIP(), []int{1}
}

func (x *Location) GetLatitude() float64 {
	if x != nil {
		return x.Latitude
	}
	return 0
}

func (x *Location) GetLongitude() float64 {
	if x != nil {
		return x.Longitude
	}
	return 0
}

func (x *Location) GetAltitude() int32 {
	if x != nil {
		return x.Altitude
	}
	return 0
}

func (x *Location) GetAccuracy() int32 {
	if x != nil {
		return x.Accuracy
	}
	return 0
}

func (x *Location) GetSource() LocationSource {
	if x != nil {
		return x.Source
	}
	return LocationSource_SOURCE_UNKNOWN
}

type PacketBrokerMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Message identifier generated by Packet Broker Router.
	MessageId string `protobuf:"bytes,1,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	// LoRa Alliance NetID of the Packet Broker Forwarder Member.
	ForwarderNetId []byte `protobuf:"bytes,2,opt,name=forwarder_net_id,json=forwarderNetId,proto3" json:"forwarder_net_id,omitempty"`
	// Tenant ID managed by the Packet Broker Forwarder Member.
	ForwarderTenantId string `protobuf:"bytes,3,opt,name=forwarder_tenant_id,json=forwarderTenantId,proto3" json:"forwarder_tenant_id,omitempty"`
	// Forwarder Cluster ID of the Packet Broker Forwarder.
	ForwarderClusterId string `protobuf:"bytes,4,opt,name=forwarder_cluster_id,json=forwarderClusterId,proto3" json:"forwarder_cluster_id,omitempty"`
	// Forwarder gateway EUI.
	ForwarderGatewayEui []byte `protobuf:"bytes,9,opt,name=forwarder_gateway_eui,json=forwarderGatewayEui,proto3" json:"forwarder_gateway_eui,omitempty"`
	// Forwarder gateway ID.
	ForwarderGatewayId *wrapperspb.StringValue `protobuf:"bytes,10,opt,name=forwarder_gateway_id,json=forwarderGatewayId,proto3" json:"forwarder_gateway_id,omitempty"`
	// LoRa Alliance NetID of the Packet Broker Home Network Member.
	HomeNetworkNetId []byte `protobuf:"bytes,5,opt,name=home_network_net_id,json=homeNetworkNetId,proto3" json:"home_network_net_id,omitempty"`
	// Tenant ID managed by the Packet Broker Home Network Member.
	// This value is empty if it cannot be determined by the Packet Broker Router.
	HomeNetworkTenantId string `protobuf:"bytes,6,opt,name=home_network_tenant_id,json=homeNetworkTenantId,proto3" json:"home_network_tenant_id,omitempty"`
	// Home Network Cluster ID of the Packet Broker Home Network.
	HomeNetworkClusterId string `protobuf:"bytes,8,opt,name=home_network_cluster_id,json=homeNetworkClusterId,proto3" json:"home_network_cluster_id,omitempty"`
	// Hops that the message passed. Each Packet Broker Router service appends an entry.
	Hops []*PacketBrokerRouteHop `protobuf:"bytes,7,rep,name=hops,proto3" json:"hops,omitempty"`
}

func (x *PacketBrokerMetadata) Reset() {
	*x = PacketBrokerMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_metadata_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerMetadata) ProtoMessage() {}

func (x *PacketBrokerMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_metadata_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerMetadata.ProtoReflect.Descriptor instead.
func (*PacketBrokerMetadata) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_metadata_proto_rawDescGZIP(), []int{2}
}

func (x *PacketBrokerMetadata) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *PacketBrokerMetadata) GetForwarderNetId() []byte {
	if x != nil {
		return x.ForwarderNetId
	}
	return nil
}

func (x *PacketBrokerMetadata) GetForwarderTenantId() string {
	if x != nil {
		return x.ForwarderTenantId
	}
	return ""
}

func (x *PacketBrokerMetadata) GetForwarderClusterId() string {
	if x != nil {
		return x.ForwarderClusterId
	}
	return ""
}

func (x *PacketBrokerMetadata) GetForwarderGatewayEui() []byte {
	if x != nil {
		return x.ForwarderGatewayEui
	}
	return nil
}

func (x *PacketBrokerMetadata) GetForwarderGatewayId() *wrapperspb.StringValue {
	if x != nil {
		return x.ForwarderGatewayId
	}
	return nil
}

func (x *PacketBrokerMetadata) GetHomeNetworkNetId() []byte {
	if x != nil {
		return x.HomeNetworkNetId
	}
	return nil
}

func (x *PacketBrokerMetadata) GetHomeNetworkTenantId() string {
	if x != nil {
		return x.HomeNetworkTenantId
	}
	return ""
}

func (x *PacketBrokerMetadata) GetHomeNetworkClusterId() string {
	if x != nil {
		return x.HomeNetworkClusterId
	}
	return ""
}

func (x *PacketBrokerMetadata) GetHops() []*PacketBrokerRouteHop {
	if x != nil {
		return x.Hops
	}
	return nil
}

type PacketBrokerRouteHop struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time when the service received the message.
	ReceivedAt *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=received_at,json=receivedAt,proto3" json:"received_at,omitempty"`
	// Sender of the message, typically the authorized client identifier.
	SenderName string `protobuf:"bytes,2,opt,name=sender_name,json=senderName,proto3" json:"sender_name,omitempty"`
	// Sender IP address or host name.
	SenderAddress string `protobuf:"bytes,3,opt,name=sender_address,json=senderAddress,proto3" json:"sender_address,omitempty"`
	// Receiver of the message.
	ReceiverName string `protobuf:"bytes,4,opt,name=receiver_name,json=receiverName,proto3" json:"receiver_name,omitempty"`
	// Receiver agent.
	ReceiverAgent string `protobuf:"bytes,5,opt,name=receiver_agent,json=receiverAgent,proto3" json:"receiver_agent,omitempty"`
}

func (x *PacketBrokerRouteHop) Reset() {
	*x = PacketBrokerRouteHop{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_metadata_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketBrokerRouteHop) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketBrokerRouteHop) ProtoMessage() {}

func (x *PacketBrokerRouteHop) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_metadata_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketBrokerRouteHop.ProtoReflect.Descriptor instead.
func (*PacketBrokerRouteHop) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_metadata_proto_rawDescGZIP(), []int{3}
}

func (x *PacketBrokerRouteHop) GetReceivedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ReceivedAt
	}
	return nil
}

func (x *PacketBrokerRouteHop) GetSenderName() string {
	if x != nil {
		return x.SenderName
	}
	return ""
}

func (x *PacketBrokerRouteHop) GetSenderAddress() string {
	if x != nil {
		return x.SenderAddress
	}
	return ""
}

func (x *PacketBrokerRouteHop) GetReceiverName() string {
	if x != nil {
		return x.ReceiverName
	}
	return ""
}

func (x *PacketBrokerRouteHop) GetReceiverAgent() string {
	if x != nil {
		return x.ReceiverAgent
	}
	return ""
}

type RelayMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// End device identifiers of the relay.
	DeviceId string `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// Wake on radio channel.
	WorChannel RelayWORChannel `protobuf:"varint,2,opt,name=wor_channel,json=worChannel,proto3,enum=ttn.lorawan.v3.RelayWORChannel" json:"wor_channel,omitempty"`
}

func (x *RelayMetadata) Reset() {
	*x = RelayMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_metadata_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelayMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelayMetadata) ProtoMessage() {}

func (x *RelayMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_metadata_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelayMetadata.ProtoReflect.Descriptor instead.
func (*RelayMetadata) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_metadata_proto_rawDescGZIP(), []int{4}
}

func (x *RelayMetadata) GetDeviceId() string {
	if x != nil {
		return x.DeviceId
	}
	return ""
}

func (x *RelayMetadata) GetWorChannel() RelayWORChannel {
	if x != nil {
		return x.WorChannel
	}
	return RelayWORChannel_RELAY_WOR_CHANNEL_DEFAULT
}

var File_ttn_lorawan_v3_metadata_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_metadata_proto_rawDesc = []byte{
	0x0a, 0x1d, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x0e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61,
	0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21,
	0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x6a, 0x73, 0x6f,
	0x6e, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1c, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76,
	0x33, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xca, 0x09, 0x0a, 0x0a, 0x52, 0x78, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4d, 0x0a, 0x0b, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12, 0x49, 0x0a, 0x0d, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x5f, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50,
	0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65,
	0x72, 0x12, 0x33, 0x0a, 0x05, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x05, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e,
	0x61, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x61,
	0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2e, 0x0a, 0x04, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x69, 0x6e,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0d, 0x66, 0x69, 0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x12, 0x38, 0x0a, 0x18, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x69,
	0x6e, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x16, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6e,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x44, 0x0a, 0x1f, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x1b, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x46, 0x69,
	0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4b, 0x65, 0x79, 0x49, 0x64,
	0x12, 0x12, 0x0a, 0x04, 0x72, 0x73, 0x73, 0x69, 0x18, 0x08, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04,
	0x72, 0x73, 0x73, 0x69, 0x12, 0x3c, 0x0a, 0x0b, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x5f, 0x72,
	0x73, 0x73, 0x69, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52, 0x73,
	0x73, 0x69, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x72, 0x73,
	0x73, 0x69, 0x18, 0x09, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x52, 0x73, 0x73, 0x69, 0x12, 0x36, 0x0a, 0x17, 0x72, 0x73, 0x73, 0x69, 0x5f, 0x73, 0x74,
	0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x02, 0x52, 0x15, 0x72, 0x73, 0x73, 0x69, 0x53, 0x74, 0x61, 0x6e,
	0x64, 0x61, 0x72, 0x64, 0x44, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a,
	0x03, 0x73, 0x6e, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x02, 0x52, 0x03, 0x73, 0x6e, 0x72, 0x12,
	0x29, 0x0a, 0x10, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x34, 0x0a, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x6a, 0x0a, 0x18, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x61, 0x74, 0x68,
	0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x16, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x61,
	0x74, 0x68, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c,
	0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0b, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x2d, 0x0a, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xff, 0x01,
	0x52, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x23,
	0x0a, 0x0d, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18,
	0x13, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x57, 0x69,
	0x64, 0x74, 0x68, 0x12, 0x27, 0x0a, 0x0f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x5f, 0x64, 0x72, 0x69, 0x66, 0x74, 0x18, 0x14, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x66, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x44, 0x72, 0x69, 0x66, 0x74, 0x12, 0x35, 0x0a, 0x08,
	0x67, 0x70, 0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x67, 0x70, 0x73, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x5f,
	0x61, 0x74, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x41, 0x74,
	0x12, 0x33, 0x0a, 0x08, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x18, 0x63, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x08, 0x61, 0x64, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x64, 0x22, 0x80, 0x02, 0x0a, 0x08, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x08, 0x6c, 0x61, 0x74, 0x69, 0x74, 0x75, 0x64, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x42, 0x17, 0xfa, 0x42, 0x14, 0x12, 0x12, 0x19, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x80, 0x56, 0x40, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x56, 0xc0, 0x52, 0x08, 0x6c,
	0x61, 0x74, 0x69, 0x74, 0x75, 0x64, 0x65, 0x12, 0x35, 0x0a, 0x09, 0x6c, 0x6f, 0x6e, 0x67, 0x69,
	0x74, 0x75, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42, 0x17, 0xfa, 0x42, 0x14, 0x12,
	0x12, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x66, 0x40, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x80, 0x66, 0xc0, 0x52, 0x09, 0x6c, 0x6f, 0x6e, 0x67, 0x69, 0x74, 0x75, 0x64, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x61, 0x6c, 0x74, 0x69, 0x74, 0x75, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x61, 0x6c, 0x74, 0x69, 0x74, 0x75, 0x64, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x63,
	0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x61, 0x63,
	0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x12, 0x46, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x0e, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01,
	0xf2, 0xaa, 0x19, 0x02, 0x10, 0x00, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3a, 0x08,
	0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0xae, 0x08, 0x0a, 0x14, 0x50, 0x61, 0x63,
	0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64,
	0x12, 0xd5, 0x01, 0x0a, 0x10, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x6e,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xaa, 0x01, 0x92, 0x41,
	0x17, 0x4a, 0x08, 0x22, 0x30, 0x30, 0x30, 0x30, 0x31, 0x33, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2,
	0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x03, 0x70,
	0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b,
	0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48,
	0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70,
	0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68,
	0x61, 0x6c, 0x33, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x0e, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x13, 0x66, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72,
	0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x14, 0x66, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65,
	0x72, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0xe9, 0x01, 0x0a, 0x15, 0x66,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x5f, 0x65, 0x75, 0x69, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xb4, 0x01, 0x92, 0x41, 0x21,
	0x4a, 0x12, 0x22, 0x37, 0x30, 0x42, 0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30, 0x41,
	0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a,
	0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x52, 0x13, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x45, 0x75, 0x69, 0x12, 0x4e, 0x0a, 0x14, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x65, 0x72, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x12, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x72, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x12, 0xda, 0x01, 0x0a, 0x13, 0x68, 0x6f, 0x6d, 0x65, 0x5f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0c, 0x42, 0xaa, 0x01, 0x92, 0x41, 0x17, 0x4a, 0x08, 0x22, 0x30, 0x30, 0x30,
	0x30, 0x31, 0x33, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x03, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a,
	0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x33, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x52, 0x10, 0x68, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4e, 0x65,
	0x74, 0x49, 0x64, 0x12, 0x33, 0x0a, 0x16, 0x68, 0x6f, 0x6d, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x13, 0x68, 0x6f, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x35, 0x0a, 0x17, 0x68, 0x6f, 0x6d, 0x65,
	0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x68, 0x6f, 0x6d, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x38, 0x0a, 0x04, 0x68, 0x6f, 0x70, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50,
	0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x48, 0x6f, 0x70, 0x52, 0x04, 0x68, 0x6f, 0x70, 0x73, 0x22, 0xe7, 0x01, 0x0a, 0x14, 0x50, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x48,
	0x6f, 0x70, 0x12, 0x3b, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x61,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x41, 0x74, 0x12,
	0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e,
	0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x22, 0xa1, 0x01, 0x0a, 0x0d, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x44, 0x0a, 0x09, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x42, 0x24, 0x72, 0x22, 0x18,
	0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b,
	0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d,
	0x24, 0x52, 0x08, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x0b, 0x77,
	0x6f, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x57, 0x4f, 0x52, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x77, 0x6f, 0x72,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2a, 0x9b, 0x02, 0x0a, 0x0e, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x47, 0x50, 0x53, 0x10, 0x01, 0x12, 0x13,
	0x0a, 0x0f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52,
	0x59, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x49, 0x50,
	0x5f, 0x47, 0x45, 0x4f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x20,
	0x0a, 0x1c, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x57, 0x49, 0x46, 0x49, 0x5f, 0x52, 0x53,
	0x53, 0x49, 0x5f, 0x47, 0x45, 0x4f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05,
	0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x42, 0x54, 0x5f, 0x52, 0x53,
	0x53, 0x49, 0x5f, 0x47, 0x45, 0x4f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06,
	0x12, 0x20, 0x0a, 0x1c, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4c, 0x4f, 0x52, 0x41, 0x5f,
	0x52, 0x53, 0x53, 0x49, 0x5f, 0x47, 0x45, 0x4f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x07, 0x12, 0x20, 0x0a, 0x1c, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4c, 0x4f, 0x52,
	0x41, 0x5f, 0x54, 0x44, 0x4f, 0x41, 0x5f, 0x47, 0x45, 0x4f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x08, 0x12, 0x1f, 0x0a, 0x1b, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x43,
	0x4f, 0x4d, 0x42, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x47, 0x45, 0x4f, 0x4c, 0x4f, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x09, 0x1a, 0x0e, 0xea, 0xaa, 0x19, 0x0a, 0x18, 0x01, 0x2a, 0x06, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70,
	0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_metadata_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_metadata_proto_rawDescData = file_ttn_lorawan_v3_metadata_proto_rawDesc
)

func file_ttn_lorawan_v3_metadata_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_metadata_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_metadata_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_metadata_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_metadata_proto_rawDescData
}

var file_ttn_lorawan_v3_metadata_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_ttn_lorawan_v3_metadata_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_ttn_lorawan_v3_metadata_proto_goTypes = []interface{}{
	(LocationSource)(0),            // 0: ttn.lorawan.v3.LocationSource
	(*RxMetadata)(nil),             // 1: ttn.lorawan.v3.RxMetadata
	(*Location)(nil),               // 2: ttn.lorawan.v3.Location
	(*PacketBrokerMetadata)(nil),   // 3: ttn.lorawan.v3.PacketBrokerMetadata
	(*PacketBrokerRouteHop)(nil),   // 4: ttn.lorawan.v3.PacketBrokerRouteHop
	(*RelayMetadata)(nil),          // 5: ttn.lorawan.v3.RelayMetadata
	(*GatewayIdentifiers)(nil),     // 6: ttn.lorawan.v3.GatewayIdentifiers
	(*timestamppb.Timestamp)(nil),  // 7: google.protobuf.Timestamp
	(*wrapperspb.FloatValue)(nil),  // 8: google.protobuf.FloatValue
	(DownlinkPathConstraint)(0),    // 9: ttn.lorawan.v3.DownlinkPathConstraint
	(*structpb.Struct)(nil),        // 10: google.protobuf.Struct
	(*wrapperspb.StringValue)(nil), // 11: google.protobuf.StringValue
	(RelayWORChannel)(0),           // 12: ttn.lorawan.v3.RelayWORChannel
}
var file_ttn_lorawan_v3_metadata_proto_depIdxs = []int32{
	6,  // 0: ttn.lorawan.v3.RxMetadata.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	3,  // 1: ttn.lorawan.v3.RxMetadata.packet_broker:type_name -> ttn.lorawan.v3.PacketBrokerMetadata
	5,  // 2: ttn.lorawan.v3.RxMetadata.relay:type_name -> ttn.lorawan.v3.RelayMetadata
	7,  // 3: ttn.lorawan.v3.RxMetadata.time:type_name -> google.protobuf.Timestamp
	8,  // 4: ttn.lorawan.v3.RxMetadata.signal_rssi:type_name -> google.protobuf.FloatValue
	2,  // 5: ttn.lorawan.v3.RxMetadata.location:type_name -> ttn.lorawan.v3.Location
	9,  // 6: ttn.lorawan.v3.RxMetadata.downlink_path_constraint:type_name -> ttn.lorawan.v3.DownlinkPathConstraint
	7,  // 7: ttn.lorawan.v3.RxMetadata.gps_time:type_name -> google.protobuf.Timestamp
	7,  // 8: ttn.lorawan.v3.RxMetadata.received_at:type_name -> google.protobuf.Timestamp
	10, // 9: ttn.lorawan.v3.RxMetadata.advanced:type_name -> google.protobuf.Struct
	0,  // 10: ttn.lorawan.v3.Location.source:type_name -> ttn.lorawan.v3.LocationSource
	11, // 11: ttn.lorawan.v3.PacketBrokerMetadata.forwarder_gateway_id:type_name -> google.protobuf.StringValue
	4,  // 12: ttn.lorawan.v3.PacketBrokerMetadata.hops:type_name -> ttn.lorawan.v3.PacketBrokerRouteHop
	7,  // 13: ttn.lorawan.v3.PacketBrokerRouteHop.received_at:type_name -> google.protobuf.Timestamp
	12, // 14: ttn.lorawan.v3.RelayMetadata.wor_channel:type_name -> ttn.lorawan.v3.RelayWORChannel
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_metadata_proto_init() }
func file_ttn_lorawan_v3_metadata_proto_init() {
	if File_ttn_lorawan_v3_metadata_proto != nil {
		return
	}
	file_ttn_lorawan_v3_enums_proto_init()
	file_ttn_lorawan_v3_identifiers_proto_init()
	file_ttn_lorawan_v3_lorawan_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_metadata_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RxMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_metadata_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Location); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_metadata_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_metadata_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketBrokerRouteHop); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_metadata_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelayMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_metadata_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ttn_lorawan_v3_metadata_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_metadata_proto_depIdxs,
		EnumInfos:         file_ttn_lorawan_v3_metadata_proto_enumTypes,
		MessageInfos:      file_ttn_lorawan_v3_metadata_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_metadata_proto = out.File
	file_ttn_lorawan_v3_metadata_proto_rawDesc = nil
	file_ttn_lorawan_v3_metadata_proto_goTypes = nil
	file_ttn_lorawan_v3_metadata_proto_depIdxs = nil
}
