// Code generated by protoc-gen-go-json. DO NOT EDIT.
// versions:
// - protoc-gen-go-json v1.6.0
// - protoc             v4.23.4
// source: ttn/lorawan/v3/messages.proto

package ttnpb

import (
	golang "github.com/TheThingsIndustries/protoc-gen-go-json/golang"
	jsonplugin "github.com/TheThingsIndustries/protoc-gen-go-json/jsonplugin"
	types "go.thethings.network/lorawan-stack/v3/pkg/types"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

// MarshalProtoJSON marshals the PayloadFormatter to JSON.
func (x PayloadFormatter) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	s.WriteEnumString(int32(x), PayloadFormatter_name)
}

// MarshalText marshals the PayloadFormatter to text.
func (x PayloadFormatter) MarshalText() ([]byte, error) {
	return []byte(jsonplugin.GetEnumString(int32(x), PayloadFormatter_name)), nil
}

// MarshalJSON marshals the PayloadFormatter to JSON.
func (x PayloadFormatter) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// PayloadFormatter_customvalue contains custom string values that extend PayloadFormatter_value.
var PayloadFormatter_customvalue = map[string]int32{
	"NONE":         0,
	"REPOSITORY":   1,
	"GRPC_SERVICE": 2,
	"JAVASCRIPT":   3,
	"CAYENNELPP":   4,
}

// UnmarshalProtoJSON unmarshals the PayloadFormatter from JSON.
func (x *PayloadFormatter) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	v := s.ReadEnum(PayloadFormatter_value, PayloadFormatter_customvalue)
	if err := s.Err(); err != nil {
		s.SetErrorf("could not read PayloadFormatter enum: %v", err)
		return
	}
	*x = PayloadFormatter(v)
}

// UnmarshalText unmarshals the PayloadFormatter from text.
func (x *PayloadFormatter) UnmarshalText(b []byte) error {
	i, err := jsonplugin.ParseEnumString(string(b), PayloadFormatter_customvalue, PayloadFormatter_value)
	if err != nil {
		return err
	}
	*x = PayloadFormatter(i)
	return nil
}

// UnmarshalJSON unmarshals the PayloadFormatter from JSON.
func (x *PayloadFormatter) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the UplinkMessage message to JSON.
func (x *UplinkMessage) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.RawPayload) > 0 || s.HasField("raw_payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("raw_payload")
		s.WriteBytes(x.RawPayload)
	}
	if x.Payload != nil || s.HasField("payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("payload")
		x.Payload.MarshalProtoJSON(s.WithField("payload"))
	}
	if x.Settings != nil || s.HasField("settings") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("settings")
		// NOTE: TxSettings does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.Settings)
	}
	if len(x.RxMetadata) > 0 || s.HasField("rx_metadata") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rx_metadata")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.RxMetadata {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("rx_metadata"))
		}
		s.WriteArrayEnd()
	}
	if x.ReceivedAt != nil || s.HasField("received_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("received_at")
		if x.ReceivedAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.ReceivedAt)
		}
	}
	if len(x.CorrelationIds) > 0 || s.HasField("correlation_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("correlation_ids")
		s.WriteStringArray(x.CorrelationIds)
	}
	if x.DeviceChannelIndex != 0 || s.HasField("device_channel_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("device_channel_index")
		s.WriteUint32(x.DeviceChannelIndex)
	}
	if x.ConsumedAirtime != nil || s.HasField("consumed_airtime") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("consumed_airtime")
		if x.ConsumedAirtime == nil {
			s.WriteNil()
		} else {
			golang.MarshalDuration(s, x.ConsumedAirtime)
		}
	}
	if x.CrcStatus != nil || s.HasField("crc_status") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("crc_status")
		if x.CrcStatus == nil {
			s.WriteNil()
		} else {
			s.WriteBool(x.CrcStatus.Value)
		}
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the UplinkMessage to JSON.
func (x *UplinkMessage) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the UplinkMessage message from JSON.
func (x *UplinkMessage) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "raw_payload", "rawPayload":
			s.AddField("raw_payload")
			x.RawPayload = s.ReadBytes()
		case "payload":
			if s.ReadNil() {
				x.Payload = nil
				return
			}
			x.Payload = &Message{}
			x.Payload.UnmarshalProtoJSON(s.WithField("payload", true))
		case "settings":
			s.AddField("settings")
			if s.ReadNil() {
				x.Settings = nil
				return
			}
			// NOTE: TxSettings does not seem to implement UnmarshalProtoJSON.
			var v TxSettings
			golang.UnmarshalMessage(s, &v)
			x.Settings = &v
		case "rx_metadata", "rxMetadata":
			s.AddField("rx_metadata")
			if s.ReadNil() {
				x.RxMetadata = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.RxMetadata = append(x.RxMetadata, nil)
					return
				}
				v := &RxMetadata{}
				v.UnmarshalProtoJSON(s.WithField("rx_metadata", false))
				if s.Err() != nil {
					return
				}
				x.RxMetadata = append(x.RxMetadata, v)
			})
		case "received_at", "receivedAt":
			s.AddField("received_at")
			if s.ReadNil() {
				x.ReceivedAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.ReceivedAt = v
		case "correlation_ids", "correlationIds":
			s.AddField("correlation_ids")
			if s.ReadNil() {
				x.CorrelationIds = nil
				return
			}
			x.CorrelationIds = s.ReadStringArray()
		case "device_channel_index", "deviceChannelIndex":
			s.AddField("device_channel_index")
			x.DeviceChannelIndex = s.ReadUint32()
		case "consumed_airtime", "consumedAirtime":
			s.AddField("consumed_airtime")
			if s.ReadNil() {
				x.ConsumedAirtime = nil
				return
			}
			v := golang.UnmarshalDuration(s)
			if s.Err() != nil {
				return
			}
			x.ConsumedAirtime = v
		case "crc_status", "crcStatus":
			s.AddField("crc_status")
			if s.ReadNil() {
				x.CrcStatus = nil
				return
			}
			v := s.ReadWrappedBool()
			if s.Err() != nil {
				return
			}
			x.CrcStatus = &wrapperspb.BoolValue{Value: v}
		}
	})
}

// UnmarshalJSON unmarshals the UplinkMessage from JSON.
func (x *UplinkMessage) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the DownlinkMessage message to JSON.
func (x *DownlinkMessage) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.RawPayload) > 0 || s.HasField("raw_payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("raw_payload")
		s.WriteBytes(x.RawPayload)
	}
	if x.Payload != nil || s.HasField("payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("payload")
		x.Payload.MarshalProtoJSON(s.WithField("payload"))
	}
	if x.EndDeviceIds != nil || s.HasField("end_device_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("end_device_ids")
		x.EndDeviceIds.MarshalProtoJSON(s.WithField("end_device_ids"))
	}
	if x.Settings != nil {
		switch ov := x.Settings.(type) {
		case *DownlinkMessage_Request:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("request")
			ov.Request.MarshalProtoJSON(s.WithField("request"))
		case *DownlinkMessage_Scheduled:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("scheduled")
			// NOTE: TxSettings does not seem to implement MarshalProtoJSON.
			golang.MarshalMessage(s, ov.Scheduled)
		}
	}
	if len(x.CorrelationIds) > 0 || s.HasField("correlation_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("correlation_ids")
		s.WriteStringArray(x.CorrelationIds)
	}
	if len(x.SessionKeyId) > 0 || s.HasField("session_key_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("session_key_id")
		s.WriteBytes(x.SessionKeyId)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the DownlinkMessage to JSON.
func (x *DownlinkMessage) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the DownlinkMessage message from JSON.
func (x *DownlinkMessage) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "raw_payload", "rawPayload":
			s.AddField("raw_payload")
			x.RawPayload = s.ReadBytes()
		case "payload":
			if s.ReadNil() {
				x.Payload = nil
				return
			}
			x.Payload = &Message{}
			x.Payload.UnmarshalProtoJSON(s.WithField("payload", true))
		case "end_device_ids", "endDeviceIds":
			if s.ReadNil() {
				x.EndDeviceIds = nil
				return
			}
			x.EndDeviceIds = &EndDeviceIdentifiers{}
			x.EndDeviceIds.UnmarshalProtoJSON(s.WithField("end_device_ids", true))
		case "request":
			ov := &DownlinkMessage_Request{}
			x.Settings = ov
			if s.ReadNil() {
				ov.Request = nil
				return
			}
			ov.Request = &TxRequest{}
			ov.Request.UnmarshalProtoJSON(s.WithField("request", true))
		case "scheduled":
			s.AddField("scheduled")
			ov := &DownlinkMessage_Scheduled{}
			x.Settings = ov
			if s.ReadNil() {
				ov.Scheduled = nil
				return
			}
			// NOTE: TxSettings does not seem to implement UnmarshalProtoJSON.
			var v TxSettings
			golang.UnmarshalMessage(s, &v)
			ov.Scheduled = &v
		case "correlation_ids", "correlationIds":
			s.AddField("correlation_ids")
			if s.ReadNil() {
				x.CorrelationIds = nil
				return
			}
			x.CorrelationIds = s.ReadStringArray()
		case "session_key_id", "sessionKeyId":
			s.AddField("session_key_id")
			x.SessionKeyId = s.ReadBytes()
		}
	})
}

// UnmarshalJSON unmarshals the DownlinkMessage from JSON.
func (x *DownlinkMessage) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the TxAcknowledgment_Result to JSON.
func (x TxAcknowledgment_Result) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	s.WriteEnumString(int32(x), TxAcknowledgment_Result_name)
}

// MarshalText marshals the TxAcknowledgment_Result to text.
func (x TxAcknowledgment_Result) MarshalText() ([]byte, error) {
	return []byte(jsonplugin.GetEnumString(int32(x), TxAcknowledgment_Result_name)), nil
}

// MarshalJSON marshals the TxAcknowledgment_Result to JSON.
func (x TxAcknowledgment_Result) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the TxAcknowledgment_Result from JSON.
func (x *TxAcknowledgment_Result) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	v := s.ReadEnum(TxAcknowledgment_Result_value)
	if err := s.Err(); err != nil {
		s.SetErrorf("could not read Result enum: %v", err)
		return
	}
	*x = TxAcknowledgment_Result(v)
}

// UnmarshalText unmarshals the TxAcknowledgment_Result from text.
func (x *TxAcknowledgment_Result) UnmarshalText(b []byte) error {
	i, err := jsonplugin.ParseEnumString(string(b), TxAcknowledgment_Result_value)
	if err != nil {
		return err
	}
	*x = TxAcknowledgment_Result(i)
	return nil
}

// UnmarshalJSON unmarshals the TxAcknowledgment_Result from JSON.
func (x *TxAcknowledgment_Result) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the TxAcknowledgment message to JSON.
func (x *TxAcknowledgment) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.CorrelationIds) > 0 || s.HasField("correlation_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("correlation_ids")
		s.WriteStringArray(x.CorrelationIds)
	}
	if x.Result != 0 || s.HasField("result") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("result")
		x.Result.MarshalProtoJSON(s)
	}
	if x.DownlinkMessage != nil || s.HasField("downlink_message") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("downlink_message")
		x.DownlinkMessage.MarshalProtoJSON(s.WithField("downlink_message"))
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the TxAcknowledgment to JSON.
func (x *TxAcknowledgment) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the TxAcknowledgment message from JSON.
func (x *TxAcknowledgment) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "correlation_ids", "correlationIds":
			s.AddField("correlation_ids")
			if s.ReadNil() {
				x.CorrelationIds = nil
				return
			}
			x.CorrelationIds = s.ReadStringArray()
		case "result":
			s.AddField("result")
			x.Result.UnmarshalProtoJSON(s)
		case "downlink_message", "downlinkMessage":
			if s.ReadNil() {
				x.DownlinkMessage = nil
				return
			}
			x.DownlinkMessage = &DownlinkMessage{}
			x.DownlinkMessage.UnmarshalProtoJSON(s.WithField("downlink_message", true))
		}
	})
}

// UnmarshalJSON unmarshals the TxAcknowledgment from JSON.
func (x *TxAcknowledgment) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the GatewayTxAcknowledgment message to JSON.
func (x *GatewayTxAcknowledgment) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.GatewayIds != nil || s.HasField("gateway_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("gateway_ids")
		x.GatewayIds.MarshalProtoJSON(s.WithField("gateway_ids"))
	}
	if x.TxAck != nil || s.HasField("tx_ack") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("tx_ack")
		x.TxAck.MarshalProtoJSON(s.WithField("tx_ack"))
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the GatewayTxAcknowledgment to JSON.
func (x *GatewayTxAcknowledgment) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the GatewayTxAcknowledgment message from JSON.
func (x *GatewayTxAcknowledgment) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "gateway_ids", "gatewayIds":
			if s.ReadNil() {
				x.GatewayIds = nil
				return
			}
			x.GatewayIds = &GatewayIdentifiers{}
			x.GatewayIds.UnmarshalProtoJSON(s.WithField("gateway_ids", true))
		case "tx_ack", "txAck":
			if s.ReadNil() {
				x.TxAck = nil
				return
			}
			x.TxAck = &TxAcknowledgment{}
			x.TxAck.UnmarshalProtoJSON(s.WithField("tx_ack", true))
		}
	})
}

// UnmarshalJSON unmarshals the GatewayTxAcknowledgment from JSON.
func (x *GatewayTxAcknowledgment) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the GatewayUplinkMessage message to JSON.
func (x *GatewayUplinkMessage) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Message != nil || s.HasField("message") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("message")
		x.Message.MarshalProtoJSON(s.WithField("message"))
	}
	if x.BandId != "" || s.HasField("band_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("band_id")
		s.WriteString(x.BandId)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the GatewayUplinkMessage to JSON.
func (x *GatewayUplinkMessage) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the GatewayUplinkMessage message from JSON.
func (x *GatewayUplinkMessage) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "message":
			if s.ReadNil() {
				x.Message = nil
				return
			}
			x.Message = &UplinkMessage{}
			x.Message.UnmarshalProtoJSON(s.WithField("message", true))
		case "band_id", "bandId":
			s.AddField("band_id")
			x.BandId = s.ReadString()
		}
	})
}

// UnmarshalJSON unmarshals the GatewayUplinkMessage from JSON.
func (x *GatewayUplinkMessage) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ApplicationUplink message to JSON.
func (x *ApplicationUplink) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.SessionKeyId) > 0 || s.HasField("session_key_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("session_key_id")
		s.WriteBytes(x.SessionKeyId)
	}
	if x.FPort != 0 || s.HasField("f_port") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("f_port")
		s.WriteUint32(x.FPort)
	}
	if x.FCnt != 0 || s.HasField("f_cnt") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("f_cnt")
		s.WriteUint32(x.FCnt)
	}
	if len(x.FrmPayload) > 0 || s.HasField("frm_payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("frm_payload")
		s.WriteBytes(x.FrmPayload)
	}
	if x.DecodedPayload != nil || s.HasField("decoded_payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("decoded_payload")
		if x.DecodedPayload == nil {
			s.WriteNil()
		} else {
			golang.MarshalStruct(s, x.DecodedPayload)
		}
	}
	if len(x.DecodedPayloadWarnings) > 0 || s.HasField("decoded_payload_warnings") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("decoded_payload_warnings")
		s.WriteStringArray(x.DecodedPayloadWarnings)
	}
	if len(x.NormalizedPayload) > 0 || s.HasField("normalized_payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("normalized_payload")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.NormalizedPayload {
			s.WriteMoreIf(&wroteElement)
			if element == nil {
				s.WriteNil()
			} else {
				golang.MarshalStruct(s, element)
			}
		}
		s.WriteArrayEnd()
	}
	if len(x.NormalizedPayloadWarnings) > 0 || s.HasField("normalized_payload_warnings") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("normalized_payload_warnings")
		s.WriteStringArray(x.NormalizedPayloadWarnings)
	}
	if len(x.RxMetadata) > 0 || s.HasField("rx_metadata") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rx_metadata")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.RxMetadata {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("rx_metadata"))
		}
		s.WriteArrayEnd()
	}
	if x.Settings != nil || s.HasField("settings") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("settings")
		// NOTE: TxSettings does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.Settings)
	}
	if x.ReceivedAt != nil || s.HasField("received_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("received_at")
		if x.ReceivedAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.ReceivedAt)
		}
	}
	if x.AppSKey != nil || s.HasField("app_s_key") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("app_s_key")
		x.AppSKey.MarshalProtoJSON(s.WithField("app_s_key"))
	}
	if x.LastAFCntDown != 0 || s.HasField("last_a_f_cnt_down") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_a_f_cnt_down")
		s.WriteUint32(x.LastAFCntDown)
	}
	if x.Confirmed || s.HasField("confirmed") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("confirmed")
		s.WriteBool(x.Confirmed)
	}
	if x.ConsumedAirtime != nil || s.HasField("consumed_airtime") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("consumed_airtime")
		if x.ConsumedAirtime == nil {
			s.WriteNil()
		} else {
			golang.MarshalDuration(s, x.ConsumedAirtime)
		}
	}
	if x.PacketErrorRate != 0 || s.HasField("packet_error_rate") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("packet_error_rate")
		s.WriteFloat32(x.PacketErrorRate)
	}
	if x.Locations != nil || s.HasField("locations") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("locations")
		s.WriteObjectStart()
		var wroteElement bool
		for k, v := range x.Locations {
			s.WriteMoreIf(&wroteElement)
			s.WriteObjectStringField(k)
			v.MarshalProtoJSON(s.WithField("locations"))
		}
		s.WriteObjectEnd()
	}
	if x.VersionIds != nil || s.HasField("version_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("version_ids")
		// NOTE: EndDeviceVersionIdentifiers does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.VersionIds)
	}
	if x.NetworkIds != nil || s.HasField("network_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("network_ids")
		x.NetworkIds.MarshalProtoJSON(s.WithField("network_ids"))
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ApplicationUplink to JSON.
func (x *ApplicationUplink) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ApplicationUplink message from JSON.
func (x *ApplicationUplink) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "session_key_id", "sessionKeyId":
			s.AddField("session_key_id")
			x.SessionKeyId = s.ReadBytes()
		case "f_port", "fPort":
			s.AddField("f_port")
			x.FPort = s.ReadUint32()
		case "f_cnt", "fCnt":
			s.AddField("f_cnt")
			x.FCnt = s.ReadUint32()
		case "frm_payload", "frmPayload":
			s.AddField("frm_payload")
			x.FrmPayload = s.ReadBytes()
		case "decoded_payload", "decodedPayload":
			s.AddField("decoded_payload")
			if s.ReadNil() {
				x.DecodedPayload = nil
				return
			}
			v := golang.UnmarshalStruct(s)
			if s.Err() != nil {
				return
			}
			x.DecodedPayload = v
		case "decoded_payload_warnings", "decodedPayloadWarnings":
			s.AddField("decoded_payload_warnings")
			if s.ReadNil() {
				x.DecodedPayloadWarnings = nil
				return
			}
			x.DecodedPayloadWarnings = s.ReadStringArray()
		case "normalized_payload", "normalizedPayload":
			s.AddField("normalized_payload")
			if s.ReadNil() {
				x.NormalizedPayload = nil
				return
			}
			s.ReadArray(func() {
				v := golang.UnmarshalStruct(s)
				if s.Err() != nil {
					return
				}
				x.NormalizedPayload = append(x.NormalizedPayload, v)
			})
		case "normalized_payload_warnings", "normalizedPayloadWarnings":
			s.AddField("normalized_payload_warnings")
			if s.ReadNil() {
				x.NormalizedPayloadWarnings = nil
				return
			}
			x.NormalizedPayloadWarnings = s.ReadStringArray()
		case "rx_metadata", "rxMetadata":
			s.AddField("rx_metadata")
			if s.ReadNil() {
				x.RxMetadata = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.RxMetadata = append(x.RxMetadata, nil)
					return
				}
				v := &RxMetadata{}
				v.UnmarshalProtoJSON(s.WithField("rx_metadata", false))
				if s.Err() != nil {
					return
				}
				x.RxMetadata = append(x.RxMetadata, v)
			})
		case "settings":
			s.AddField("settings")
			if s.ReadNil() {
				x.Settings = nil
				return
			}
			// NOTE: TxSettings does not seem to implement UnmarshalProtoJSON.
			var v TxSettings
			golang.UnmarshalMessage(s, &v)
			x.Settings = &v
		case "received_at", "receivedAt":
			s.AddField("received_at")
			if s.ReadNil() {
				x.ReceivedAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.ReceivedAt = v
		case "app_s_key", "appSKey":
			if s.ReadNil() {
				x.AppSKey = nil
				return
			}
			x.AppSKey = &KeyEnvelope{}
			x.AppSKey.UnmarshalProtoJSON(s.WithField("app_s_key", true))
		case "last_a_f_cnt_down", "lastAFCntDown":
			s.AddField("last_a_f_cnt_down")
			x.LastAFCntDown = s.ReadUint32()
		case "confirmed":
			s.AddField("confirmed")
			x.Confirmed = s.ReadBool()
		case "consumed_airtime", "consumedAirtime":
			s.AddField("consumed_airtime")
			if s.ReadNil() {
				x.ConsumedAirtime = nil
				return
			}
			v := golang.UnmarshalDuration(s)
			if s.Err() != nil {
				return
			}
			x.ConsumedAirtime = v
		case "packet_error_rate", "packetErrorRate":
			s.AddField("packet_error_rate")
			x.PacketErrorRate = s.ReadFloat32()
		case "locations":
			s.AddField("locations")
			if s.ReadNil() {
				x.Locations = nil
				return
			}
			x.Locations = make(map[string]*Location)
			s.ReadStringMap(func(key string) {
				var v Location
				v.UnmarshalProtoJSON(s)
				x.Locations[key] = &v
			})
		case "version_ids", "versionIds":
			s.AddField("version_ids")
			if s.ReadNil() {
				x.VersionIds = nil
				return
			}
			// NOTE: EndDeviceVersionIdentifiers does not seem to implement UnmarshalProtoJSON.
			var v EndDeviceVersionIdentifiers
			golang.UnmarshalMessage(s, &v)
			x.VersionIds = &v
		case "network_ids", "networkIds":
			if s.ReadNil() {
				x.NetworkIds = nil
				return
			}
			x.NetworkIds = &NetworkIdentifiers{}
			x.NetworkIds.UnmarshalProtoJSON(s.WithField("network_ids", true))
		}
	})
}

// UnmarshalJSON unmarshals the ApplicationUplink from JSON.
func (x *ApplicationUplink) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ApplicationUplinkNormalized message to JSON.
func (x *ApplicationUplinkNormalized) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.SessionKeyId) > 0 || s.HasField("session_key_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("session_key_id")
		s.WriteBytes(x.SessionKeyId)
	}
	if x.FPort != 0 || s.HasField("f_port") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("f_port")
		s.WriteUint32(x.FPort)
	}
	if x.FCnt != 0 || s.HasField("f_cnt") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("f_cnt")
		s.WriteUint32(x.FCnt)
	}
	if len(x.FrmPayload) > 0 || s.HasField("frm_payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("frm_payload")
		s.WriteBytes(x.FrmPayload)
	}
	if x.NormalizedPayload != nil || s.HasField("normalized_payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("normalized_payload")
		if x.NormalizedPayload == nil {
			s.WriteNil()
		} else {
			golang.MarshalStruct(s, x.NormalizedPayload)
		}
	}
	if len(x.NormalizedPayloadWarnings) > 0 || s.HasField("normalized_payload_warnings") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("normalized_payload_warnings")
		s.WriteStringArray(x.NormalizedPayloadWarnings)
	}
	if len(x.RxMetadata) > 0 || s.HasField("rx_metadata") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rx_metadata")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.RxMetadata {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("rx_metadata"))
		}
		s.WriteArrayEnd()
	}
	if x.Settings != nil || s.HasField("settings") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("settings")
		// NOTE: TxSettings does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.Settings)
	}
	if x.ReceivedAt != nil || s.HasField("received_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("received_at")
		if x.ReceivedAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.ReceivedAt)
		}
	}
	if x.Confirmed || s.HasField("confirmed") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("confirmed")
		s.WriteBool(x.Confirmed)
	}
	if x.ConsumedAirtime != nil || s.HasField("consumed_airtime") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("consumed_airtime")
		if x.ConsumedAirtime == nil {
			s.WriteNil()
		} else {
			golang.MarshalDuration(s, x.ConsumedAirtime)
		}
	}
	if x.Locations != nil || s.HasField("locations") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("locations")
		s.WriteObjectStart()
		var wroteElement bool
		for k, v := range x.Locations {
			s.WriteMoreIf(&wroteElement)
			s.WriteObjectStringField(k)
			v.MarshalProtoJSON(s.WithField("locations"))
		}
		s.WriteObjectEnd()
	}
	if x.VersionIds != nil || s.HasField("version_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("version_ids")
		// NOTE: EndDeviceVersionIdentifiers does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.VersionIds)
	}
	if x.NetworkIds != nil || s.HasField("network_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("network_ids")
		x.NetworkIds.MarshalProtoJSON(s.WithField("network_ids"))
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ApplicationUplinkNormalized to JSON.
func (x *ApplicationUplinkNormalized) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ApplicationUplinkNormalized message from JSON.
func (x *ApplicationUplinkNormalized) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "session_key_id", "sessionKeyId":
			s.AddField("session_key_id")
			x.SessionKeyId = s.ReadBytes()
		case "f_port", "fPort":
			s.AddField("f_port")
			x.FPort = s.ReadUint32()
		case "f_cnt", "fCnt":
			s.AddField("f_cnt")
			x.FCnt = s.ReadUint32()
		case "frm_payload", "frmPayload":
			s.AddField("frm_payload")
			x.FrmPayload = s.ReadBytes()
		case "normalized_payload", "normalizedPayload":
			s.AddField("normalized_payload")
			if s.ReadNil() {
				x.NormalizedPayload = nil
				return
			}
			v := golang.UnmarshalStruct(s)
			if s.Err() != nil {
				return
			}
			x.NormalizedPayload = v
		case "normalized_payload_warnings", "normalizedPayloadWarnings":
			s.AddField("normalized_payload_warnings")
			if s.ReadNil() {
				x.NormalizedPayloadWarnings = nil
				return
			}
			x.NormalizedPayloadWarnings = s.ReadStringArray()
		case "rx_metadata", "rxMetadata":
			s.AddField("rx_metadata")
			if s.ReadNil() {
				x.RxMetadata = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.RxMetadata = append(x.RxMetadata, nil)
					return
				}
				v := &RxMetadata{}
				v.UnmarshalProtoJSON(s.WithField("rx_metadata", false))
				if s.Err() != nil {
					return
				}
				x.RxMetadata = append(x.RxMetadata, v)
			})
		case "settings":
			s.AddField("settings")
			if s.ReadNil() {
				x.Settings = nil
				return
			}
			// NOTE: TxSettings does not seem to implement UnmarshalProtoJSON.
			var v TxSettings
			golang.UnmarshalMessage(s, &v)
			x.Settings = &v
		case "received_at", "receivedAt":
			s.AddField("received_at")
			if s.ReadNil() {
				x.ReceivedAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.ReceivedAt = v
		case "confirmed":
			s.AddField("confirmed")
			x.Confirmed = s.ReadBool()
		case "consumed_airtime", "consumedAirtime":
			s.AddField("consumed_airtime")
			if s.ReadNil() {
				x.ConsumedAirtime = nil
				return
			}
			v := golang.UnmarshalDuration(s)
			if s.Err() != nil {
				return
			}
			x.ConsumedAirtime = v
		case "locations":
			s.AddField("locations")
			if s.ReadNil() {
				x.Locations = nil
				return
			}
			x.Locations = make(map[string]*Location)
			s.ReadStringMap(func(key string) {
				var v Location
				v.UnmarshalProtoJSON(s)
				x.Locations[key] = &v
			})
		case "version_ids", "versionIds":
			s.AddField("version_ids")
			if s.ReadNil() {
				x.VersionIds = nil
				return
			}
			// NOTE: EndDeviceVersionIdentifiers does not seem to implement UnmarshalProtoJSON.
			var v EndDeviceVersionIdentifiers
			golang.UnmarshalMessage(s, &v)
			x.VersionIds = &v
		case "network_ids", "networkIds":
			if s.ReadNil() {
				x.NetworkIds = nil
				return
			}
			x.NetworkIds = &NetworkIdentifiers{}
			x.NetworkIds.UnmarshalProtoJSON(s.WithField("network_ids", true))
		}
	})
}

// UnmarshalJSON unmarshals the ApplicationUplinkNormalized from JSON.
func (x *ApplicationUplinkNormalized) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ApplicationLocation message to JSON.
func (x *ApplicationLocation) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Service != "" || s.HasField("service") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("service")
		s.WriteString(x.Service)
	}
	if x.Location != nil || s.HasField("location") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("location")
		x.Location.MarshalProtoJSON(s.WithField("location"))
	}
	if x.Attributes != nil || s.HasField("attributes") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("attributes")
		s.WriteObjectStart()
		var wroteElement bool
		for k, v := range x.Attributes {
			s.WriteMoreIf(&wroteElement)
			s.WriteObjectStringField(k)
			s.WriteString(v)
		}
		s.WriteObjectEnd()
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ApplicationLocation to JSON.
func (x *ApplicationLocation) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ApplicationLocation message from JSON.
func (x *ApplicationLocation) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "service":
			s.AddField("service")
			x.Service = s.ReadString()
		case "location":
			if s.ReadNil() {
				x.Location = nil
				return
			}
			x.Location = &Location{}
			x.Location.UnmarshalProtoJSON(s.WithField("location", true))
		case "attributes":
			s.AddField("attributes")
			if s.ReadNil() {
				x.Attributes = nil
				return
			}
			x.Attributes = make(map[string]string)
			s.ReadStringMap(func(key string) {
				x.Attributes[key] = s.ReadString()
			})
		}
	})
}

// UnmarshalJSON unmarshals the ApplicationLocation from JSON.
func (x *ApplicationLocation) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ApplicationJoinAccept message to JSON.
func (x *ApplicationJoinAccept) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.SessionKeyId) > 0 || s.HasField("session_key_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("session_key_id")
		s.WriteBytes(x.SessionKeyId)
	}
	if x.AppSKey != nil || s.HasField("app_s_key") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("app_s_key")
		x.AppSKey.MarshalProtoJSON(s.WithField("app_s_key"))
	}
	if len(x.InvalidatedDownlinks) > 0 || s.HasField("invalidated_downlinks") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("invalidated_downlinks")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.InvalidatedDownlinks {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("invalidated_downlinks"))
		}
		s.WriteArrayEnd()
	}
	if x.PendingSession || s.HasField("pending_session") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("pending_session")
		s.WriteBool(x.PendingSession)
	}
	if x.ReceivedAt != nil || s.HasField("received_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("received_at")
		if x.ReceivedAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.ReceivedAt)
		}
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ApplicationJoinAccept to JSON.
func (x *ApplicationJoinAccept) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ApplicationJoinAccept message from JSON.
func (x *ApplicationJoinAccept) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "session_key_id", "sessionKeyId":
			s.AddField("session_key_id")
			x.SessionKeyId = s.ReadBytes()
		case "app_s_key", "appSKey":
			if s.ReadNil() {
				x.AppSKey = nil
				return
			}
			x.AppSKey = &KeyEnvelope{}
			x.AppSKey.UnmarshalProtoJSON(s.WithField("app_s_key", true))
		case "invalidated_downlinks", "invalidatedDownlinks":
			s.AddField("invalidated_downlinks")
			if s.ReadNil() {
				x.InvalidatedDownlinks = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.InvalidatedDownlinks = append(x.InvalidatedDownlinks, nil)
					return
				}
				v := &ApplicationDownlink{}
				v.UnmarshalProtoJSON(s.WithField("invalidated_downlinks", false))
				if s.Err() != nil {
					return
				}
				x.InvalidatedDownlinks = append(x.InvalidatedDownlinks, v)
			})
		case "pending_session", "pendingSession":
			s.AddField("pending_session")
			x.PendingSession = s.ReadBool()
		case "received_at", "receivedAt":
			s.AddField("received_at")
			if s.ReadNil() {
				x.ReceivedAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.ReceivedAt = v
		}
	})
}

// UnmarshalJSON unmarshals the ApplicationJoinAccept from JSON.
func (x *ApplicationJoinAccept) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ApplicationDownlink_ClassBC message to JSON.
func (x *ApplicationDownlink_ClassBC) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.Gateways) > 0 || s.HasField("gateways") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("gateways")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.Gateways {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("gateways"))
		}
		s.WriteArrayEnd()
	}
	if x.AbsoluteTime != nil || s.HasField("absolute_time") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("absolute_time")
		if x.AbsoluteTime == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.AbsoluteTime)
		}
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ApplicationDownlink_ClassBC to JSON.
func (x *ApplicationDownlink_ClassBC) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ApplicationDownlink_ClassBC message from JSON.
func (x *ApplicationDownlink_ClassBC) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "gateways":
			s.AddField("gateways")
			if s.ReadNil() {
				x.Gateways = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.Gateways = append(x.Gateways, nil)
					return
				}
				v := &ClassBCGatewayIdentifiers{}
				v.UnmarshalProtoJSON(s.WithField("gateways", false))
				if s.Err() != nil {
					return
				}
				x.Gateways = append(x.Gateways, v)
			})
		case "absolute_time", "absoluteTime":
			s.AddField("absolute_time")
			if s.ReadNil() {
				x.AbsoluteTime = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.AbsoluteTime = v
		}
	})
}

// UnmarshalJSON unmarshals the ApplicationDownlink_ClassBC from JSON.
func (x *ApplicationDownlink_ClassBC) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ApplicationDownlink message to JSON.
func (x *ApplicationDownlink) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.SessionKeyId) > 0 || s.HasField("session_key_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("session_key_id")
		s.WriteBytes(x.SessionKeyId)
	}
	if x.FPort != 0 || s.HasField("f_port") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("f_port")
		s.WriteUint32(x.FPort)
	}
	if x.FCnt != 0 || s.HasField("f_cnt") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("f_cnt")
		s.WriteUint32(x.FCnt)
	}
	if len(x.FrmPayload) > 0 || s.HasField("frm_payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("frm_payload")
		s.WriteBytes(x.FrmPayload)
	}
	if x.DecodedPayload != nil || s.HasField("decoded_payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("decoded_payload")
		if x.DecodedPayload == nil {
			s.WriteNil()
		} else {
			golang.MarshalStruct(s, x.DecodedPayload)
		}
	}
	if len(x.DecodedPayloadWarnings) > 0 || s.HasField("decoded_payload_warnings") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("decoded_payload_warnings")
		s.WriteStringArray(x.DecodedPayloadWarnings)
	}
	if x.Confirmed || s.HasField("confirmed") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("confirmed")
		s.WriteBool(x.Confirmed)
	}
	if x.ClassBC != nil || s.HasField("class_b_c") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("class_b_c")
		x.ClassBC.MarshalProtoJSON(s.WithField("class_b_c"))
	}
	if x.Priority != 0 || s.HasField("priority") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("priority")
		x.Priority.MarshalProtoJSON(s)
	}
	if len(x.CorrelationIds) > 0 || s.HasField("correlation_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("correlation_ids")
		s.WriteStringArray(x.CorrelationIds)
	}
	if x.ConfirmedRetry != nil || s.HasField("confirmed_retry") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("confirmed_retry")
		// NOTE: ApplicationDownlink_ConfirmedRetry does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.ConfirmedRetry)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ApplicationDownlink to JSON.
func (x *ApplicationDownlink) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ApplicationDownlink message from JSON.
func (x *ApplicationDownlink) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "session_key_id", "sessionKeyId":
			s.AddField("session_key_id")
			x.SessionKeyId = s.ReadBytes()
		case "f_port", "fPort":
			s.AddField("f_port")
			x.FPort = s.ReadUint32()
		case "f_cnt", "fCnt":
			s.AddField("f_cnt")
			x.FCnt = s.ReadUint32()
		case "frm_payload", "frmPayload":
			s.AddField("frm_payload")
			x.FrmPayload = s.ReadBytes()
		case "decoded_payload", "decodedPayload":
			s.AddField("decoded_payload")
			if s.ReadNil() {
				x.DecodedPayload = nil
				return
			}
			v := golang.UnmarshalStruct(s)
			if s.Err() != nil {
				return
			}
			x.DecodedPayload = v
		case "decoded_payload_warnings", "decodedPayloadWarnings":
			s.AddField("decoded_payload_warnings")
			if s.ReadNil() {
				x.DecodedPayloadWarnings = nil
				return
			}
			x.DecodedPayloadWarnings = s.ReadStringArray()
		case "confirmed":
			s.AddField("confirmed")
			x.Confirmed = s.ReadBool()
		case "class_b_c", "classBC":
			if s.ReadNil() {
				x.ClassBC = nil
				return
			}
			x.ClassBC = &ApplicationDownlink_ClassBC{}
			x.ClassBC.UnmarshalProtoJSON(s.WithField("class_b_c", true))
		case "priority":
			s.AddField("priority")
			x.Priority.UnmarshalProtoJSON(s)
		case "correlation_ids", "correlationIds":
			s.AddField("correlation_ids")
			if s.ReadNil() {
				x.CorrelationIds = nil
				return
			}
			x.CorrelationIds = s.ReadStringArray()
		case "confirmed_retry", "confirmedRetry":
			s.AddField("confirmed_retry")
			if s.ReadNil() {
				x.ConfirmedRetry = nil
				return
			}
			// NOTE: ApplicationDownlink_ConfirmedRetry does not seem to implement UnmarshalProtoJSON.
			var v ApplicationDownlink_ConfirmedRetry
			golang.UnmarshalMessage(s, &v)
			x.ConfirmedRetry = &v
		}
	})
}

// UnmarshalJSON unmarshals the ApplicationDownlink from JSON.
func (x *ApplicationDownlink) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ApplicationDownlinks message to JSON.
func (x *ApplicationDownlinks) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.Downlinks) > 0 || s.HasField("downlinks") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("downlinks")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.Downlinks {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("downlinks"))
		}
		s.WriteArrayEnd()
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ApplicationDownlinks to JSON.
func (x *ApplicationDownlinks) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ApplicationDownlinks message from JSON.
func (x *ApplicationDownlinks) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "downlinks":
			s.AddField("downlinks")
			if s.ReadNil() {
				x.Downlinks = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.Downlinks = append(x.Downlinks, nil)
					return
				}
				v := &ApplicationDownlink{}
				v.UnmarshalProtoJSON(s.WithField("downlinks", false))
				if s.Err() != nil {
					return
				}
				x.Downlinks = append(x.Downlinks, v)
			})
		}
	})
}

// UnmarshalJSON unmarshals the ApplicationDownlinks from JSON.
func (x *ApplicationDownlinks) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ApplicationDownlinkFailed message to JSON.
func (x *ApplicationDownlinkFailed) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Downlink != nil || s.HasField("downlink") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("downlink")
		x.Downlink.MarshalProtoJSON(s.WithField("downlink"))
	}
	if x.Error != nil || s.HasField("error") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("error")
		// NOTE: ErrorDetails does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.Error)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ApplicationDownlinkFailed to JSON.
func (x *ApplicationDownlinkFailed) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ApplicationDownlinkFailed message from JSON.
func (x *ApplicationDownlinkFailed) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "downlink":
			if s.ReadNil() {
				x.Downlink = nil
				return
			}
			x.Downlink = &ApplicationDownlink{}
			x.Downlink.UnmarshalProtoJSON(s.WithField("downlink", true))
		case "error":
			s.AddField("error")
			if s.ReadNil() {
				x.Error = nil
				return
			}
			// NOTE: ErrorDetails does not seem to implement UnmarshalProtoJSON.
			var v ErrorDetails
			golang.UnmarshalMessage(s, &v)
			x.Error = &v
		}
	})
}

// UnmarshalJSON unmarshals the ApplicationDownlinkFailed from JSON.
func (x *ApplicationDownlinkFailed) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ApplicationInvalidatedDownlinks message to JSON.
func (x *ApplicationInvalidatedDownlinks) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.Downlinks) > 0 || s.HasField("downlinks") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("downlinks")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.Downlinks {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("downlinks"))
		}
		s.WriteArrayEnd()
	}
	if x.LastFCntDown != 0 || s.HasField("last_f_cnt_down") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_f_cnt_down")
		s.WriteUint32(x.LastFCntDown)
	}
	if len(x.SessionKeyId) > 0 || s.HasField("session_key_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("session_key_id")
		s.WriteBytes(x.SessionKeyId)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ApplicationInvalidatedDownlinks to JSON.
func (x *ApplicationInvalidatedDownlinks) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ApplicationInvalidatedDownlinks message from JSON.
func (x *ApplicationInvalidatedDownlinks) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "downlinks":
			s.AddField("downlinks")
			if s.ReadNil() {
				x.Downlinks = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.Downlinks = append(x.Downlinks, nil)
					return
				}
				v := &ApplicationDownlink{}
				v.UnmarshalProtoJSON(s.WithField("downlinks", false))
				if s.Err() != nil {
					return
				}
				x.Downlinks = append(x.Downlinks, v)
			})
		case "last_f_cnt_down", "lastFCntDown":
			s.AddField("last_f_cnt_down")
			x.LastFCntDown = s.ReadUint32()
		case "session_key_id", "sessionKeyId":
			s.AddField("session_key_id")
			x.SessionKeyId = s.ReadBytes()
		}
	})
}

// UnmarshalJSON unmarshals the ApplicationInvalidatedDownlinks from JSON.
func (x *ApplicationInvalidatedDownlinks) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the DownlinkQueueOperationErrorDetails message to JSON.
func (x *DownlinkQueueOperationErrorDetails) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.DevAddr) > 0 || s.HasField("dev_addr") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("dev_addr")
		types.MarshalHEXBytes(s.WithField("dev_addr"), x.DevAddr)
	}
	if len(x.SessionKeyId) > 0 || s.HasField("session_key_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("session_key_id")
		s.WriteBytes(x.SessionKeyId)
	}
	if x.MinFCntDown != 0 || s.HasField("min_f_cnt_down") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("min_f_cnt_down")
		s.WriteUint32(x.MinFCntDown)
	}
	if len(x.PendingDevAddr) > 0 || s.HasField("pending_dev_addr") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("pending_dev_addr")
		types.MarshalHEXBytes(s.WithField("pending_dev_addr"), x.PendingDevAddr)
	}
	if len(x.PendingSessionKeyId) > 0 || s.HasField("pending_session_key_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("pending_session_key_id")
		s.WriteBytes(x.PendingSessionKeyId)
	}
	if x.PendingMinFCntDown != 0 || s.HasField("pending_min_f_cnt_down") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("pending_min_f_cnt_down")
		s.WriteUint32(x.PendingMinFCntDown)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the DownlinkQueueOperationErrorDetails to JSON.
func (x *DownlinkQueueOperationErrorDetails) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the DownlinkQueueOperationErrorDetails message from JSON.
func (x *DownlinkQueueOperationErrorDetails) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "dev_addr", "devAddr":
			s.AddField("dev_addr")
			x.DevAddr = types.Unmarshal4Bytes(s.WithField("dev_addr", false))
		case "session_key_id", "sessionKeyId":
			s.AddField("session_key_id")
			x.SessionKeyId = s.ReadBytes()
		case "min_f_cnt_down", "minFCntDown":
			s.AddField("min_f_cnt_down")
			x.MinFCntDown = s.ReadUint32()
		case "pending_dev_addr", "pendingDevAddr":
			s.AddField("pending_dev_addr")
			x.PendingDevAddr = types.Unmarshal4Bytes(s.WithField("pending_dev_addr", false))
		case "pending_session_key_id", "pendingSessionKeyId":
			s.AddField("pending_session_key_id")
			x.PendingSessionKeyId = s.ReadBytes()
		case "pending_min_f_cnt_down", "pendingMinFCntDown":
			s.AddField("pending_min_f_cnt_down")
			x.PendingMinFCntDown = s.ReadUint32()
		}
	})
}

// UnmarshalJSON unmarshals the DownlinkQueueOperationErrorDetails from JSON.
func (x *DownlinkQueueOperationErrorDetails) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ApplicationUp message to JSON.
func (x *ApplicationUp) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.EndDeviceIds != nil || s.HasField("end_device_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("end_device_ids")
		x.EndDeviceIds.MarshalProtoJSON(s.WithField("end_device_ids"))
	}
	if len(x.CorrelationIds) > 0 || s.HasField("correlation_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("correlation_ids")
		s.WriteStringArray(x.CorrelationIds)
	}
	if x.ReceivedAt != nil || s.HasField("received_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("received_at")
		if x.ReceivedAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.ReceivedAt)
		}
	}
	if x.Up != nil {
		switch ov := x.Up.(type) {
		case *ApplicationUp_UplinkMessage:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("uplink_message")
			ov.UplinkMessage.MarshalProtoJSON(s.WithField("uplink_message"))
		case *ApplicationUp_UplinkNormalized:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("uplink_normalized")
			ov.UplinkNormalized.MarshalProtoJSON(s.WithField("uplink_normalized"))
		case *ApplicationUp_JoinAccept:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("join_accept")
			ov.JoinAccept.MarshalProtoJSON(s.WithField("join_accept"))
		case *ApplicationUp_DownlinkAck:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("downlink_ack")
			ov.DownlinkAck.MarshalProtoJSON(s.WithField("downlink_ack"))
		case *ApplicationUp_DownlinkNack:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("downlink_nack")
			ov.DownlinkNack.MarshalProtoJSON(s.WithField("downlink_nack"))
		case *ApplicationUp_DownlinkSent:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("downlink_sent")
			ov.DownlinkSent.MarshalProtoJSON(s.WithField("downlink_sent"))
		case *ApplicationUp_DownlinkFailed:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("downlink_failed")
			ov.DownlinkFailed.MarshalProtoJSON(s.WithField("downlink_failed"))
		case *ApplicationUp_DownlinkQueued:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("downlink_queued")
			ov.DownlinkQueued.MarshalProtoJSON(s.WithField("downlink_queued"))
		case *ApplicationUp_DownlinkQueueInvalidated:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("downlink_queue_invalidated")
			ov.DownlinkQueueInvalidated.MarshalProtoJSON(s.WithField("downlink_queue_invalidated"))
		case *ApplicationUp_LocationSolved:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("location_solved")
			ov.LocationSolved.MarshalProtoJSON(s.WithField("location_solved"))
		case *ApplicationUp_ServiceData:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("service_data")
			// NOTE: ApplicationServiceData does not seem to implement MarshalProtoJSON.
			golang.MarshalMessage(s, ov.ServiceData)
		}
	}
	if x.Simulated || s.HasField("simulated") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("simulated")
		s.WriteBool(x.Simulated)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ApplicationUp to JSON.
func (x *ApplicationUp) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ApplicationUp message from JSON.
func (x *ApplicationUp) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "end_device_ids", "endDeviceIds":
			if s.ReadNil() {
				x.EndDeviceIds = nil
				return
			}
			x.EndDeviceIds = &EndDeviceIdentifiers{}
			x.EndDeviceIds.UnmarshalProtoJSON(s.WithField("end_device_ids", true))
		case "correlation_ids", "correlationIds":
			s.AddField("correlation_ids")
			if s.ReadNil() {
				x.CorrelationIds = nil
				return
			}
			x.CorrelationIds = s.ReadStringArray()
		case "received_at", "receivedAt":
			s.AddField("received_at")
			if s.ReadNil() {
				x.ReceivedAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.ReceivedAt = v
		case "uplink_message", "uplinkMessage":
			ov := &ApplicationUp_UplinkMessage{}
			x.Up = ov
			if s.ReadNil() {
				ov.UplinkMessage = nil
				return
			}
			ov.UplinkMessage = &ApplicationUplink{}
			ov.UplinkMessage.UnmarshalProtoJSON(s.WithField("uplink_message", true))
		case "uplink_normalized", "uplinkNormalized":
			ov := &ApplicationUp_UplinkNormalized{}
			x.Up = ov
			if s.ReadNil() {
				ov.UplinkNormalized = nil
				return
			}
			ov.UplinkNormalized = &ApplicationUplinkNormalized{}
			ov.UplinkNormalized.UnmarshalProtoJSON(s.WithField("uplink_normalized", true))
		case "join_accept", "joinAccept":
			ov := &ApplicationUp_JoinAccept{}
			x.Up = ov
			if s.ReadNil() {
				ov.JoinAccept = nil
				return
			}
			ov.JoinAccept = &ApplicationJoinAccept{}
			ov.JoinAccept.UnmarshalProtoJSON(s.WithField("join_accept", true))
		case "downlink_ack", "downlinkAck":
			ov := &ApplicationUp_DownlinkAck{}
			x.Up = ov
			if s.ReadNil() {
				ov.DownlinkAck = nil
				return
			}
			ov.DownlinkAck = &ApplicationDownlink{}
			ov.DownlinkAck.UnmarshalProtoJSON(s.WithField("downlink_ack", true))
		case "downlink_nack", "downlinkNack":
			ov := &ApplicationUp_DownlinkNack{}
			x.Up = ov
			if s.ReadNil() {
				ov.DownlinkNack = nil
				return
			}
			ov.DownlinkNack = &ApplicationDownlink{}
			ov.DownlinkNack.UnmarshalProtoJSON(s.WithField("downlink_nack", true))
		case "downlink_sent", "downlinkSent":
			ov := &ApplicationUp_DownlinkSent{}
			x.Up = ov
			if s.ReadNil() {
				ov.DownlinkSent = nil
				return
			}
			ov.DownlinkSent = &ApplicationDownlink{}
			ov.DownlinkSent.UnmarshalProtoJSON(s.WithField("downlink_sent", true))
		case "downlink_failed", "downlinkFailed":
			ov := &ApplicationUp_DownlinkFailed{}
			x.Up = ov
			if s.ReadNil() {
				ov.DownlinkFailed = nil
				return
			}
			ov.DownlinkFailed = &ApplicationDownlinkFailed{}
			ov.DownlinkFailed.UnmarshalProtoJSON(s.WithField("downlink_failed", true))
		case "downlink_queued", "downlinkQueued":
			ov := &ApplicationUp_DownlinkQueued{}
			x.Up = ov
			if s.ReadNil() {
				ov.DownlinkQueued = nil
				return
			}
			ov.DownlinkQueued = &ApplicationDownlink{}
			ov.DownlinkQueued.UnmarshalProtoJSON(s.WithField("downlink_queued", true))
		case "downlink_queue_invalidated", "downlinkQueueInvalidated":
			ov := &ApplicationUp_DownlinkQueueInvalidated{}
			x.Up = ov
			if s.ReadNil() {
				ov.DownlinkQueueInvalidated = nil
				return
			}
			ov.DownlinkQueueInvalidated = &ApplicationInvalidatedDownlinks{}
			ov.DownlinkQueueInvalidated.UnmarshalProtoJSON(s.WithField("downlink_queue_invalidated", true))
		case "location_solved", "locationSolved":
			ov := &ApplicationUp_LocationSolved{}
			x.Up = ov
			if s.ReadNil() {
				ov.LocationSolved = nil
				return
			}
			ov.LocationSolved = &ApplicationLocation{}
			ov.LocationSolved.UnmarshalProtoJSON(s.WithField("location_solved", true))
		case "service_data", "serviceData":
			s.AddField("service_data")
			ov := &ApplicationUp_ServiceData{}
			x.Up = ov
			if s.ReadNil() {
				ov.ServiceData = nil
				return
			}
			// NOTE: ApplicationServiceData does not seem to implement UnmarshalProtoJSON.
			var v ApplicationServiceData
			golang.UnmarshalMessage(s, &v)
			ov.ServiceData = &v
		case "simulated":
			s.AddField("simulated")
			x.Simulated = s.ReadBool()
		}
	})
}

// UnmarshalJSON unmarshals the ApplicationUp from JSON.
func (x *ApplicationUp) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MessagePayloadFormatters message to JSON.
func (x *MessagePayloadFormatters) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.UpFormatter != 0 || s.HasField("up_formatter") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("up_formatter")
		x.UpFormatter.MarshalProtoJSON(s)
	}
	if x.UpFormatterParameter != "" || s.HasField("up_formatter_parameter") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("up_formatter_parameter")
		s.WriteString(x.UpFormatterParameter)
	}
	if x.DownFormatter != 0 || s.HasField("down_formatter") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("down_formatter")
		x.DownFormatter.MarshalProtoJSON(s)
	}
	if x.DownFormatterParameter != "" || s.HasField("down_formatter_parameter") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("down_formatter_parameter")
		s.WriteString(x.DownFormatterParameter)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MessagePayloadFormatters to JSON.
func (x *MessagePayloadFormatters) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MessagePayloadFormatters message from JSON.
func (x *MessagePayloadFormatters) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "up_formatter", "upFormatter":
			s.AddField("up_formatter")
			x.UpFormatter.UnmarshalProtoJSON(s)
		case "up_formatter_parameter", "upFormatterParameter":
			s.AddField("up_formatter_parameter")
			x.UpFormatterParameter = s.ReadString()
		case "down_formatter", "downFormatter":
			s.AddField("down_formatter")
			x.DownFormatter.UnmarshalProtoJSON(s)
		case "down_formatter_parameter", "downFormatterParameter":
			s.AddField("down_formatter_parameter")
			x.DownFormatterParameter = s.ReadString()
		}
	})
}

// UnmarshalJSON unmarshals the MessagePayloadFormatters from JSON.
func (x *MessagePayloadFormatters) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the DownlinkQueueRequest message to JSON.
func (x *DownlinkQueueRequest) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.EndDeviceIds != nil || s.HasField("end_device_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("end_device_ids")
		x.EndDeviceIds.MarshalProtoJSON(s.WithField("end_device_ids"))
	}
	if len(x.Downlinks) > 0 || s.HasField("downlinks") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("downlinks")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.Downlinks {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("downlinks"))
		}
		s.WriteArrayEnd()
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the DownlinkQueueRequest to JSON.
func (x *DownlinkQueueRequest) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the DownlinkQueueRequest message from JSON.
func (x *DownlinkQueueRequest) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "end_device_ids", "endDeviceIds":
			if s.ReadNil() {
				x.EndDeviceIds = nil
				return
			}
			x.EndDeviceIds = &EndDeviceIdentifiers{}
			x.EndDeviceIds.UnmarshalProtoJSON(s.WithField("end_device_ids", true))
		case "downlinks":
			s.AddField("downlinks")
			if s.ReadNil() {
				x.Downlinks = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.Downlinks = append(x.Downlinks, nil)
					return
				}
				v := &ApplicationDownlink{}
				v.UnmarshalProtoJSON(s.WithField("downlinks", false))
				if s.Err() != nil {
					return
				}
				x.Downlinks = append(x.Downlinks, v)
			})
		}
	})
}

// UnmarshalJSON unmarshals the DownlinkQueueRequest from JSON.
func (x *DownlinkQueueRequest) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}
