// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on UplinkMessage with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UplinkMessage) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UplinkMessageFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "raw_payload":
			// no validation rules for RawPayload
		case "payload":

			if v, ok := interface{}(m.GetPayload()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UplinkMessageValidationError{
						field:  "payload",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "settings":

			if m.GetSettings() == nil {
				return UplinkMessageValidationError{
					field:  "settings",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetSettings()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UplinkMessageValidationError{
						field:  "settings",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "rx_metadata":

			for idx, item := range m.GetRxMetadata() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return UplinkMessageValidationError{
							field:  fmt.Sprintf("rx_metadata[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "received_at":

			if v, ok := interface{}(m.GetReceivedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UplinkMessageValidationError{
						field:  "received_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "correlation_ids":

			for idx, item := range m.GetCorrelationIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 100 {
					return UplinkMessageValidationError{
						field:  fmt.Sprintf("correlation_ids[%v]", idx),
						reason: "value length must be at most 100 runes",
					}
				}

			}

		case "device_channel_index":

			if m.GetDeviceChannelIndex() > 255 {
				return UplinkMessageValidationError{
					field:  "device_channel_index",
					reason: "value must be less than or equal to 255",
				}
			}

		case "consumed_airtime":

			if v, ok := interface{}(m.GetConsumedAirtime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UplinkMessageValidationError{
						field:  "consumed_airtime",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "crc_status":

			if v, ok := interface{}(m.GetCrcStatus()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UplinkMessageValidationError{
						field:  "crc_status",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UplinkMessageValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UplinkMessageValidationError is the validation error returned by
// UplinkMessage.ValidateFields if the designated constraints aren't met.
type UplinkMessageValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UplinkMessageValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UplinkMessageValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UplinkMessageValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UplinkMessageValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UplinkMessageValidationError) ErrorName() string { return "UplinkMessageValidationError" }

// Error satisfies the builtin error interface
func (e UplinkMessageValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUplinkMessage.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UplinkMessageValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UplinkMessageValidationError{}

// ValidateFields checks the field values on DownlinkMessage with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DownlinkMessage) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DownlinkMessageFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "raw_payload":
			// no validation rules for RawPayload
		case "payload":

			if v, ok := interface{}(m.GetPayload()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DownlinkMessageValidationError{
						field:  "payload",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "end_device_ids":

			if v, ok := interface{}(m.GetEndDeviceIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DownlinkMessageValidationError{
						field:  "end_device_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "correlation_ids":

			for idx, item := range m.GetCorrelationIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 100 {
					return DownlinkMessageValidationError{
						field:  fmt.Sprintf("correlation_ids[%v]", idx),
						reason: "value length must be at most 100 runes",
					}
				}

			}

		case "session_key_id":

			if len(m.GetSessionKeyId()) > 2048 {
				return DownlinkMessageValidationError{
					field:  "session_key_id",
					reason: "value length must be at most 2048 bytes",
				}
			}

		case "settings":
			if m.Settings == nil {
				return DownlinkMessageValidationError{
					field:  "settings",
					reason: "value is required",
				}
			}
			if len(subs) == 0 {
				subs = []string{
					"request", "scheduled",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "request":
					w, ok := m.Settings.(*DownlinkMessage_Request)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRequest()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return DownlinkMessageValidationError{
								field:  "request",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "scheduled":
					w, ok := m.Settings.(*DownlinkMessage_Scheduled)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetScheduled()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return DownlinkMessageValidationError{
								field:  "scheduled",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return DownlinkMessageValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DownlinkMessageValidationError is the validation error returned by
// DownlinkMessage.ValidateFields if the designated constraints aren't met.
type DownlinkMessageValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DownlinkMessageValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DownlinkMessageValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DownlinkMessageValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DownlinkMessageValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DownlinkMessageValidationError) ErrorName() string { return "DownlinkMessageValidationError" }

// Error satisfies the builtin error interface
func (e DownlinkMessageValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDownlinkMessage.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DownlinkMessageValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DownlinkMessageValidationError{}

// ValidateFields checks the field values on TxAcknowledgment with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *TxAcknowledgment) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = TxAcknowledgmentFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "correlation_ids":

			for idx, item := range m.GetCorrelationIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 100 {
					return TxAcknowledgmentValidationError{
						field:  fmt.Sprintf("correlation_ids[%v]", idx),
						reason: "value length must be at most 100 runes",
					}
				}

			}

		case "result":

			if _, ok := TxAcknowledgment_Result_name[int32(m.GetResult())]; !ok {
				return TxAcknowledgmentValidationError{
					field:  "result",
					reason: "value must be one of the defined enum values",
				}
			}

		case "downlink_message":

			if v, ok := interface{}(m.GetDownlinkMessage()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return TxAcknowledgmentValidationError{
						field:  "downlink_message",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return TxAcknowledgmentValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// TxAcknowledgmentValidationError is the validation error returned by
// TxAcknowledgment.ValidateFields if the designated constraints aren't met.
type TxAcknowledgmentValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TxAcknowledgmentValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TxAcknowledgmentValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TxAcknowledgmentValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TxAcknowledgmentValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TxAcknowledgmentValidationError) ErrorName() string { return "TxAcknowledgmentValidationError" }

// Error satisfies the builtin error interface
func (e TxAcknowledgmentValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTxAcknowledgment.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TxAcknowledgmentValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TxAcknowledgmentValidationError{}

// ValidateFields checks the field values on GatewayTxAcknowledgment with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GatewayTxAcknowledgment) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayTxAcknowledgmentFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayTxAcknowledgmentValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "tx_ack":

			if v, ok := interface{}(m.GetTxAck()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayTxAcknowledgmentValidationError{
						field:  "tx_ack",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GatewayTxAcknowledgmentValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayTxAcknowledgmentValidationError is the validation error returned by
// GatewayTxAcknowledgment.ValidateFields if the designated constraints aren't met.
type GatewayTxAcknowledgmentValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayTxAcknowledgmentValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayTxAcknowledgmentValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayTxAcknowledgmentValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayTxAcknowledgmentValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayTxAcknowledgmentValidationError) ErrorName() string {
	return "GatewayTxAcknowledgmentValidationError"
}

// Error satisfies the builtin error interface
func (e GatewayTxAcknowledgmentValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayTxAcknowledgment.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayTxAcknowledgmentValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayTxAcknowledgmentValidationError{}

// ValidateFields checks the field values on GatewayUplinkMessage with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GatewayUplinkMessage) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayUplinkMessageFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "message":

			if m.GetMessage() == nil {
				return GatewayUplinkMessageValidationError{
					field:  "message",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetMessage()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayUplinkMessageValidationError{
						field:  "message",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "band_id":
			// no validation rules for BandId
		default:
			return GatewayUplinkMessageValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayUplinkMessageValidationError is the validation error returned by
// GatewayUplinkMessage.ValidateFields if the designated constraints aren't met.
type GatewayUplinkMessageValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayUplinkMessageValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayUplinkMessageValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayUplinkMessageValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayUplinkMessageValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayUplinkMessageValidationError) ErrorName() string {
	return "GatewayUplinkMessageValidationError"
}

// Error satisfies the builtin error interface
func (e GatewayUplinkMessageValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayUplinkMessage.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayUplinkMessageValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayUplinkMessageValidationError{}

// ValidateFields checks the field values on ApplicationUplink with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationUplink) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationUplinkFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "session_key_id":

			if len(m.GetSessionKeyId()) > 2048 {
				return ApplicationUplinkValidationError{
					field:  "session_key_id",
					reason: "value length must be at most 2048 bytes",
				}
			}

		case "f_port":

			if m.GetFPort() > 255 {
				return ApplicationUplinkValidationError{
					field:  "f_port",
					reason: "value must be less than or equal to 255",
				}
			}

			if _, ok := _ApplicationUplink_FPort_NotInLookup[m.GetFPort()]; ok {
				return ApplicationUplinkValidationError{
					field:  "f_port",
					reason: "value must not be in list [224]",
				}
			}

		case "f_cnt":
			// no validation rules for FCnt
		case "frm_payload":
			// no validation rules for FrmPayload
		case "decoded_payload":

			if v, ok := interface{}(m.GetDecodedPayload()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationUplinkValidationError{
						field:  "decoded_payload",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "decoded_payload_warnings":

		case "normalized_payload":

			for idx, item := range m.GetNormalizedPayload() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationUplinkValidationError{
							field:  fmt.Sprintf("normalized_payload[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "normalized_payload_warnings":

		case "rx_metadata":

			for idx, item := range m.GetRxMetadata() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationUplinkValidationError{
							field:  fmt.Sprintf("rx_metadata[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "settings":

			if m.GetSettings() == nil {
				return ApplicationUplinkValidationError{
					field:  "settings",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetSettings()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationUplinkValidationError{
						field:  "settings",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "received_at":

			if v, ok := interface{}(m.GetReceivedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationUplinkValidationError{
						field:  "received_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "app_s_key":

			if v, ok := interface{}(m.GetAppSKey()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationUplinkValidationError{
						field:  "app_s_key",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "last_a_f_cnt_down":
			// no validation rules for LastAFCntDown
		case "confirmed":
			// no validation rules for Confirmed
		case "consumed_airtime":

			if v, ok := interface{}(m.GetConsumedAirtime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationUplinkValidationError{
						field:  "consumed_airtime",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "packet_error_rate":
			// no validation rules for PacketErrorRate
		case "locations":

			for key, val := range m.GetLocations() {
				_ = val

				// no validation rules for Locations[key]

				if v, ok := interface{}(val).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationUplinkValidationError{
							field:  fmt.Sprintf("locations[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "version_ids":

			if v, ok := interface{}(m.GetVersionIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationUplinkValidationError{
						field:  "version_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "network_ids":

			if v, ok := interface{}(m.GetNetworkIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationUplinkValidationError{
						field:  "network_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ApplicationUplinkValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationUplinkValidationError is the validation error returned by
// ApplicationUplink.ValidateFields if the designated constraints aren't met.
type ApplicationUplinkValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationUplinkValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationUplinkValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationUplinkValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationUplinkValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationUplinkValidationError) ErrorName() string {
	return "ApplicationUplinkValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationUplinkValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationUplink.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationUplinkValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationUplinkValidationError{}

var _ApplicationUplink_FPort_NotInLookup = map[uint32]struct{}{
	224: {},
}

// ValidateFields checks the field values on ApplicationUplinkNormalized with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ApplicationUplinkNormalized) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationUplinkNormalizedFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "session_key_id":

			if len(m.GetSessionKeyId()) > 2048 {
				return ApplicationUplinkNormalizedValidationError{
					field:  "session_key_id",
					reason: "value length must be at most 2048 bytes",
				}
			}

		case "f_port":

			if val := m.GetFPort(); val < 1 || val > 255 {
				return ApplicationUplinkNormalizedValidationError{
					field:  "f_port",
					reason: "value must be inside range [1, 255]",
				}
			}

			if _, ok := _ApplicationUplinkNormalized_FPort_NotInLookup[m.GetFPort()]; ok {
				return ApplicationUplinkNormalizedValidationError{
					field:  "f_port",
					reason: "value must not be in list [224]",
				}
			}

		case "f_cnt":
			// no validation rules for FCnt
		case "frm_payload":
			// no validation rules for FrmPayload
		case "normalized_payload":

			if m.GetNormalizedPayload() == nil {
				return ApplicationUplinkNormalizedValidationError{
					field:  "normalized_payload",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetNormalizedPayload()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationUplinkNormalizedValidationError{
						field:  "normalized_payload",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "normalized_payload_warnings":

		case "rx_metadata":

			for idx, item := range m.GetRxMetadata() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationUplinkNormalizedValidationError{
							field:  fmt.Sprintf("rx_metadata[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "settings":

			if m.GetSettings() == nil {
				return ApplicationUplinkNormalizedValidationError{
					field:  "settings",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetSettings()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationUplinkNormalizedValidationError{
						field:  "settings",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "received_at":

			if m.GetReceivedAt() == nil {
				return ApplicationUplinkNormalizedValidationError{
					field:  "received_at",
					reason: "value is required",
				}
			}

		case "confirmed":
			// no validation rules for Confirmed
		case "consumed_airtime":

			if v, ok := interface{}(m.GetConsumedAirtime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationUplinkNormalizedValidationError{
						field:  "consumed_airtime",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "locations":

			for key, val := range m.GetLocations() {
				_ = val

				// no validation rules for Locations[key]

				if v, ok := interface{}(val).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationUplinkNormalizedValidationError{
							field:  fmt.Sprintf("locations[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "version_ids":

			if v, ok := interface{}(m.GetVersionIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationUplinkNormalizedValidationError{
						field:  "version_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "network_ids":

			if v, ok := interface{}(m.GetNetworkIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationUplinkNormalizedValidationError{
						field:  "network_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ApplicationUplinkNormalizedValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationUplinkNormalizedValidationError is the validation error returned
// by ApplicationUplinkNormalized.ValidateFields if the designated constraints
// aren't met.
type ApplicationUplinkNormalizedValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationUplinkNormalizedValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationUplinkNormalizedValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationUplinkNormalizedValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationUplinkNormalizedValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationUplinkNormalizedValidationError) ErrorName() string {
	return "ApplicationUplinkNormalizedValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationUplinkNormalizedValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationUplinkNormalized.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationUplinkNormalizedValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationUplinkNormalizedValidationError{}

var _ApplicationUplinkNormalized_FPort_NotInLookup = map[uint32]struct{}{
	224: {},
}

// ValidateFields checks the field values on ApplicationLocation with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationLocation) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationLocationFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "service":
			// no validation rules for Service
		case "location":

			if m.GetLocation() == nil {
				return ApplicationLocationValidationError{
					field:  "location",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetLocation()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationLocationValidationError{
						field:  "location",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "attributes":

			if len(m.GetAttributes()) > 10 {
				return ApplicationLocationValidationError{
					field:  "attributes",
					reason: "value must contain no more than 10 pair(s)",
				}
			}

			for key, val := range m.GetAttributes() {
				_ = val

				if utf8.RuneCountInString(key) > 36 {
					return ApplicationLocationValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value length must be at most 36 runes",
					}
				}

				if !_ApplicationLocation_Attributes_Pattern.MatchString(key) {
					return ApplicationLocationValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

				if utf8.RuneCountInString(val) > 200 {
					return ApplicationLocationValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value length must be at most 200 runes",
					}
				}

			}

		default:
			return ApplicationLocationValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationLocationValidationError is the validation error returned by
// ApplicationLocation.ValidateFields if the designated constraints aren't met.
type ApplicationLocationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationLocationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationLocationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationLocationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationLocationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationLocationValidationError) ErrorName() string {
	return "ApplicationLocationValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationLocationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationLocation.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationLocationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationLocationValidationError{}

var _ApplicationLocation_Attributes_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on ApplicationJoinAccept with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationJoinAccept) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationJoinAcceptFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "session_key_id":

			if len(m.GetSessionKeyId()) > 2048 {
				return ApplicationJoinAcceptValidationError{
					field:  "session_key_id",
					reason: "value length must be at most 2048 bytes",
				}
			}

		case "app_s_key":

			if v, ok := interface{}(m.GetAppSKey()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationJoinAcceptValidationError{
						field:  "app_s_key",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "invalidated_downlinks":

			for idx, item := range m.GetInvalidatedDownlinks() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationJoinAcceptValidationError{
							field:  fmt.Sprintf("invalidated_downlinks[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "pending_session":
			// no validation rules for PendingSession
		case "received_at":

			if m.GetReceivedAt() == nil {
				return ApplicationJoinAcceptValidationError{
					field:  "received_at",
					reason: "value is required",
				}
			}

		default:
			return ApplicationJoinAcceptValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationJoinAcceptValidationError is the validation error returned by
// ApplicationJoinAccept.ValidateFields if the designated constraints aren't met.
type ApplicationJoinAcceptValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationJoinAcceptValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationJoinAcceptValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationJoinAcceptValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationJoinAcceptValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationJoinAcceptValidationError) ErrorName() string {
	return "ApplicationJoinAcceptValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationJoinAcceptValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationJoinAccept.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationJoinAcceptValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationJoinAcceptValidationError{}

// ValidateFields checks the field values on ApplicationDownlink with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationDownlink) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationDownlinkFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "session_key_id":

			if len(m.GetSessionKeyId()) > 2048 {
				return ApplicationDownlinkValidationError{
					field:  "session_key_id",
					reason: "value length must be at most 2048 bytes",
				}
			}

		case "f_port":

			if m.GetFPort() > 255 {
				return ApplicationDownlinkValidationError{
					field:  "f_port",
					reason: "value must be less than or equal to 255",
				}
			}

			if _, ok := _ApplicationDownlink_FPort_NotInLookup[m.GetFPort()]; ok {
				return ApplicationDownlinkValidationError{
					field:  "f_port",
					reason: "value must not be in list [224]",
				}
			}

		case "f_cnt":
			// no validation rules for FCnt
		case "frm_payload":

			if len(m.GetFrmPayload()) > 255 {
				return ApplicationDownlinkValidationError{
					field:  "frm_payload",
					reason: "value length must be at most 255 bytes",
				}
			}

		case "decoded_payload":

			if v, ok := interface{}(m.GetDecodedPayload()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationDownlinkValidationError{
						field:  "decoded_payload",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "decoded_payload_warnings":

		case "confirmed":
			// no validation rules for Confirmed
		case "class_b_c":

			if v, ok := interface{}(m.GetClassBC()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationDownlinkValidationError{
						field:  "class_b_c",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "priority":

			if _, ok := TxSchedulePriority_name[int32(m.GetPriority())]; !ok {
				return ApplicationDownlinkValidationError{
					field:  "priority",
					reason: "value must be one of the defined enum values",
				}
			}

		case "correlation_ids":

			for idx, item := range m.GetCorrelationIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 100 {
					return ApplicationDownlinkValidationError{
						field:  fmt.Sprintf("correlation_ids[%v]", idx),
						reason: "value length must be at most 100 runes",
					}
				}

			}

		case "confirmed_retry":

			if v, ok := interface{}(m.GetConfirmedRetry()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationDownlinkValidationError{
						field:  "confirmed_retry",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ApplicationDownlinkValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationDownlinkValidationError is the validation error returned by
// ApplicationDownlink.ValidateFields if the designated constraints aren't met.
type ApplicationDownlinkValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationDownlinkValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationDownlinkValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationDownlinkValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationDownlinkValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationDownlinkValidationError) ErrorName() string {
	return "ApplicationDownlinkValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationDownlinkValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationDownlink.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationDownlinkValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationDownlinkValidationError{}

var _ApplicationDownlink_FPort_NotInLookup = map[uint32]struct{}{
	224: {},
}

// ValidateFields checks the field values on ApplicationDownlinks with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationDownlinks) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationDownlinksFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "downlinks":

			for idx, item := range m.GetDownlinks() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationDownlinksValidationError{
							field:  fmt.Sprintf("downlinks[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ApplicationDownlinksValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationDownlinksValidationError is the validation error returned by
// ApplicationDownlinks.ValidateFields if the designated constraints aren't met.
type ApplicationDownlinksValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationDownlinksValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationDownlinksValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationDownlinksValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationDownlinksValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationDownlinksValidationError) ErrorName() string {
	return "ApplicationDownlinksValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationDownlinksValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationDownlinks.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationDownlinksValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationDownlinksValidationError{}

// ValidateFields checks the field values on ApplicationDownlinkFailed with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationDownlinkFailed) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationDownlinkFailedFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "downlink":

			if m.GetDownlink() == nil {
				return ApplicationDownlinkFailedValidationError{
					field:  "downlink",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetDownlink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationDownlinkFailedValidationError{
						field:  "downlink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "error":

			if m.GetError() == nil {
				return ApplicationDownlinkFailedValidationError{
					field:  "error",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetError()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationDownlinkFailedValidationError{
						field:  "error",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ApplicationDownlinkFailedValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationDownlinkFailedValidationError is the validation error returned by
// ApplicationDownlinkFailed.ValidateFields if the designated constraints
// aren't met.
type ApplicationDownlinkFailedValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationDownlinkFailedValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationDownlinkFailedValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationDownlinkFailedValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationDownlinkFailedValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationDownlinkFailedValidationError) ErrorName() string {
	return "ApplicationDownlinkFailedValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationDownlinkFailedValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationDownlinkFailed.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationDownlinkFailedValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationDownlinkFailedValidationError{}

// ValidateFields checks the field values on ApplicationInvalidatedDownlinks
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ApplicationInvalidatedDownlinks) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationInvalidatedDownlinksFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "downlinks":

			for idx, item := range m.GetDownlinks() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationInvalidatedDownlinksValidationError{
							field:  fmt.Sprintf("downlinks[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "last_f_cnt_down":
			// no validation rules for LastFCntDown
		case "session_key_id":

			if len(m.GetSessionKeyId()) > 2048 {
				return ApplicationInvalidatedDownlinksValidationError{
					field:  "session_key_id",
					reason: "value length must be at most 2048 bytes",
				}
			}

		default:
			return ApplicationInvalidatedDownlinksValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationInvalidatedDownlinksValidationError is the validation error
// returned by ApplicationInvalidatedDownlinks.ValidateFields if the
// designated constraints aren't met.
type ApplicationInvalidatedDownlinksValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationInvalidatedDownlinksValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationInvalidatedDownlinksValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationInvalidatedDownlinksValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationInvalidatedDownlinksValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationInvalidatedDownlinksValidationError) ErrorName() string {
	return "ApplicationInvalidatedDownlinksValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationInvalidatedDownlinksValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationInvalidatedDownlinks.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationInvalidatedDownlinksValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationInvalidatedDownlinksValidationError{}

// ValidateFields checks the field values on DownlinkQueueOperationErrorDetails
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *DownlinkQueueOperationErrorDetails) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DownlinkQueueOperationErrorDetailsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "dev_addr":

			if len(m.GetDevAddr()) > 0 {

				if len(m.GetDevAddr()) != 4 {
					return DownlinkQueueOperationErrorDetailsValidationError{
						field:  "dev_addr",
						reason: "value length must be 4 bytes",
					}
				}

			}

		case "session_key_id":

			if len(m.GetSessionKeyId()) > 2048 {
				return DownlinkQueueOperationErrorDetailsValidationError{
					field:  "session_key_id",
					reason: "value length must be at most 2048 bytes",
				}
			}

		case "min_f_cnt_down":
			// no validation rules for MinFCntDown
		case "pending_dev_addr":

			if len(m.GetPendingDevAddr()) > 0 {

				if len(m.GetPendingDevAddr()) != 4 {
					return DownlinkQueueOperationErrorDetailsValidationError{
						field:  "pending_dev_addr",
						reason: "value length must be 4 bytes",
					}
				}

			}

		case "pending_session_key_id":

			if len(m.GetPendingSessionKeyId()) > 2048 {
				return DownlinkQueueOperationErrorDetailsValidationError{
					field:  "pending_session_key_id",
					reason: "value length must be at most 2048 bytes",
				}
			}

		case "pending_min_f_cnt_down":
			// no validation rules for PendingMinFCntDown
		default:
			return DownlinkQueueOperationErrorDetailsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DownlinkQueueOperationErrorDetailsValidationError is the validation error
// returned by DownlinkQueueOperationErrorDetails.ValidateFields if the
// designated constraints aren't met.
type DownlinkQueueOperationErrorDetailsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DownlinkQueueOperationErrorDetailsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DownlinkQueueOperationErrorDetailsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DownlinkQueueOperationErrorDetailsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DownlinkQueueOperationErrorDetailsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DownlinkQueueOperationErrorDetailsValidationError) ErrorName() string {
	return "DownlinkQueueOperationErrorDetailsValidationError"
}

// Error satisfies the builtin error interface
func (e DownlinkQueueOperationErrorDetailsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDownlinkQueueOperationErrorDetails.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DownlinkQueueOperationErrorDetailsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DownlinkQueueOperationErrorDetailsValidationError{}

// ValidateFields checks the field values on ApplicationServiceData with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationServiceData) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationServiceDataFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "service":
			// no validation rules for Service
		case "data":

			if v, ok := interface{}(m.GetData()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationServiceDataValidationError{
						field:  "data",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ApplicationServiceDataValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationServiceDataValidationError is the validation error returned by
// ApplicationServiceData.ValidateFields if the designated constraints aren't met.
type ApplicationServiceDataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationServiceDataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationServiceDataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationServiceDataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationServiceDataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationServiceDataValidationError) ErrorName() string {
	return "ApplicationServiceDataValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationServiceDataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationServiceData.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationServiceDataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationServiceDataValidationError{}

// ValidateFields checks the field values on ApplicationUp with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationUp) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationUpFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "end_device_ids":

			if m.GetEndDeviceIds() == nil {
				return ApplicationUpValidationError{
					field:  "end_device_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEndDeviceIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationUpValidationError{
						field:  "end_device_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "correlation_ids":

			for idx, item := range m.GetCorrelationIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 100 {
					return ApplicationUpValidationError{
						field:  fmt.Sprintf("correlation_ids[%v]", idx),
						reason: "value length must be at most 100 runes",
					}
				}

			}

		case "received_at":

			if v, ok := interface{}(m.GetReceivedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationUpValidationError{
						field:  "received_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "simulated":
			// no validation rules for Simulated
		case "up":
			if m.Up == nil {
				return ApplicationUpValidationError{
					field:  "up",
					reason: "value is required",
				}
			}
			if len(subs) == 0 {
				subs = []string{
					"uplink_message", "uplink_normalized", "join_accept", "downlink_ack", "downlink_nack", "downlink_sent", "downlink_failed", "downlink_queued", "downlink_queue_invalidated", "location_solved", "service_data",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "uplink_message":
					w, ok := m.Up.(*ApplicationUp_UplinkMessage)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetUplinkMessage()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationUpValidationError{
								field:  "uplink_message",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "uplink_normalized":
					w, ok := m.Up.(*ApplicationUp_UplinkNormalized)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetUplinkNormalized()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationUpValidationError{
								field:  "uplink_normalized",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "join_accept":
					w, ok := m.Up.(*ApplicationUp_JoinAccept)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetJoinAccept()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationUpValidationError{
								field:  "join_accept",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "downlink_ack":
					w, ok := m.Up.(*ApplicationUp_DownlinkAck)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDownlinkAck()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationUpValidationError{
								field:  "downlink_ack",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "downlink_nack":
					w, ok := m.Up.(*ApplicationUp_DownlinkNack)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDownlinkNack()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationUpValidationError{
								field:  "downlink_nack",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "downlink_sent":
					w, ok := m.Up.(*ApplicationUp_DownlinkSent)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDownlinkSent()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationUpValidationError{
								field:  "downlink_sent",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "downlink_failed":
					w, ok := m.Up.(*ApplicationUp_DownlinkFailed)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDownlinkFailed()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationUpValidationError{
								field:  "downlink_failed",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "downlink_queued":
					w, ok := m.Up.(*ApplicationUp_DownlinkQueued)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDownlinkQueued()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationUpValidationError{
								field:  "downlink_queued",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "downlink_queue_invalidated":
					w, ok := m.Up.(*ApplicationUp_DownlinkQueueInvalidated)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDownlinkQueueInvalidated()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationUpValidationError{
								field:  "downlink_queue_invalidated",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "location_solved":
					w, ok := m.Up.(*ApplicationUp_LocationSolved)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetLocationSolved()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationUpValidationError{
								field:  "location_solved",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "service_data":
					w, ok := m.Up.(*ApplicationUp_ServiceData)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetServiceData()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationUpValidationError{
								field:  "service_data",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return ApplicationUpValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationUpValidationError is the validation error returned by
// ApplicationUp.ValidateFields if the designated constraints aren't met.
type ApplicationUpValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationUpValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationUpValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationUpValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationUpValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationUpValidationError) ErrorName() string { return "ApplicationUpValidationError" }

// Error satisfies the builtin error interface
func (e ApplicationUpValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationUp.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationUpValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationUpValidationError{}

// ValidateFields checks the field values on MessagePayloadFormatters with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MessagePayloadFormatters) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MessagePayloadFormattersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "up_formatter":

			if _, ok := PayloadFormatter_name[int32(m.GetUpFormatter())]; !ok {
				return MessagePayloadFormattersValidationError{
					field:  "up_formatter",
					reason: "value must be one of the defined enum values",
				}
			}

		case "up_formatter_parameter":

			if utf8.RuneCountInString(m.GetUpFormatterParameter()) > 40960 {
				return MessagePayloadFormattersValidationError{
					field:  "up_formatter_parameter",
					reason: "value length must be at most 40960 runes",
				}
			}

		case "down_formatter":

			if _, ok := PayloadFormatter_name[int32(m.GetDownFormatter())]; !ok {
				return MessagePayloadFormattersValidationError{
					field:  "down_formatter",
					reason: "value must be one of the defined enum values",
				}
			}

		case "down_formatter_parameter":

			if utf8.RuneCountInString(m.GetDownFormatterParameter()) > 40960 {
				return MessagePayloadFormattersValidationError{
					field:  "down_formatter_parameter",
					reason: "value length must be at most 40960 runes",
				}
			}

		default:
			return MessagePayloadFormattersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MessagePayloadFormattersValidationError is the validation error returned by
// MessagePayloadFormatters.ValidateFields if the designated constraints
// aren't met.
type MessagePayloadFormattersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MessagePayloadFormattersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MessagePayloadFormattersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MessagePayloadFormattersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MessagePayloadFormattersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MessagePayloadFormattersValidationError) ErrorName() string {
	return "MessagePayloadFormattersValidationError"
}

// Error satisfies the builtin error interface
func (e MessagePayloadFormattersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMessagePayloadFormatters.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MessagePayloadFormattersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MessagePayloadFormattersValidationError{}

// ValidateFields checks the field values on DownlinkQueueRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DownlinkQueueRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DownlinkQueueRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "end_device_ids":

			if m.GetEndDeviceIds() == nil {
				return DownlinkQueueRequestValidationError{
					field:  "end_device_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEndDeviceIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DownlinkQueueRequestValidationError{
						field:  "end_device_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlinks":

			if len(m.GetDownlinks()) > 100000 {
				return DownlinkQueueRequestValidationError{
					field:  "downlinks",
					reason: "value must contain no more than 100000 item(s)",
				}
			}

			for idx, item := range m.GetDownlinks() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return DownlinkQueueRequestValidationError{
							field:  fmt.Sprintf("downlinks[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return DownlinkQueueRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DownlinkQueueRequestValidationError is the validation error returned by
// DownlinkQueueRequest.ValidateFields if the designated constraints aren't met.
type DownlinkQueueRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DownlinkQueueRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DownlinkQueueRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DownlinkQueueRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DownlinkQueueRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DownlinkQueueRequestValidationError) ErrorName() string {
	return "DownlinkQueueRequestValidationError"
}

// Error satisfies the builtin error interface
func (e DownlinkQueueRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDownlinkQueueRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DownlinkQueueRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DownlinkQueueRequestValidationError{}

// ValidateFields checks the field values on ApplicationDownlink_ClassBC with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ApplicationDownlink_ClassBC) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationDownlink_ClassBCFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateways":

			for idx, item := range m.GetGateways() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationDownlink_ClassBCValidationError{
							field:  fmt.Sprintf("gateways[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "absolute_time":

			if v, ok := interface{}(m.GetAbsoluteTime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationDownlink_ClassBCValidationError{
						field:  "absolute_time",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ApplicationDownlink_ClassBCValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationDownlink_ClassBCValidationError is the validation error returned
// by ApplicationDownlink_ClassBC.ValidateFields if the designated constraints
// aren't met.
type ApplicationDownlink_ClassBCValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationDownlink_ClassBCValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationDownlink_ClassBCValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationDownlink_ClassBCValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationDownlink_ClassBCValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationDownlink_ClassBCValidationError) ErrorName() string {
	return "ApplicationDownlink_ClassBCValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationDownlink_ClassBCValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationDownlink_ClassBC.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationDownlink_ClassBCValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationDownlink_ClassBCValidationError{}

// ValidateFields checks the field values on ApplicationDownlink_ConfirmedRetry
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ApplicationDownlink_ConfirmedRetry) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationDownlink_ConfirmedRetryFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "attempt":
			// no validation rules for Attempt
		case "max_attempts":

			if wrapper := m.GetMaxAttempts(); wrapper != nil {

				if val := wrapper.GetValue(); val <= 0 || val > 100 {
					return ApplicationDownlink_ConfirmedRetryValidationError{
						field:  "max_attempts",
						reason: "value must be inside range (0, 100]",
					}
				}

			}

		default:
			return ApplicationDownlink_ConfirmedRetryValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationDownlink_ConfirmedRetryValidationError is the validation error
// returned by ApplicationDownlink_ConfirmedRetry.ValidateFields if the
// designated constraints aren't met.
type ApplicationDownlink_ConfirmedRetryValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationDownlink_ConfirmedRetryValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationDownlink_ConfirmedRetryValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationDownlink_ConfirmedRetryValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationDownlink_ConfirmedRetryValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationDownlink_ConfirmedRetryValidationError) ErrorName() string {
	return "ApplicationDownlink_ConfirmedRetryValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationDownlink_ConfirmedRetryValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationDownlink_ConfirmedRetry.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationDownlink_ConfirmedRetryValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationDownlink_ConfirmedRetryValidationError{}
