// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/messages.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type PayloadFormatter int32

const (
	// No payload formatter to work with raw payload only.
	PayloadFormatter_FORMATTER_NONE PayloadFormatter = 0
	// Use payload formatter for the end device type from a repository.
	PayloadFormatter_FORMATTER_REPOSITORY PayloadFormatter = 1
	// gRPC service payload formatter. The parameter is the host:port of the service.
	PayloadFormatter_FORMATTER_GRPC_SERVICE PayloadFormatter = 2
	// Custom payload formatter that executes Javascript code. The parameter is a JavaScript filename.
	PayloadFormatter_FORMATTER_JAVASCRIPT PayloadFormatter = 3
	// CayenneLPP payload formatter.
	PayloadFormatter_FORMATTER_CAYENNELPP PayloadFormatter = 4 // More payload formatters can be added.
)

// Enum value maps for PayloadFormatter.
var (
	PayloadFormatter_name = map[int32]string{
		0: "FORMATTER_NONE",
		1: "FORMATTER_REPOSITORY",
		2: "FORMATTER_GRPC_SERVICE",
		3: "FORMATTER_JAVASCRIPT",
		4: "FORMATTER_CAYENNELPP",
	}
	PayloadFormatter_value = map[string]int32{
		"FORMATTER_NONE":         0,
		"FORMATTER_REPOSITORY":   1,
		"FORMATTER_GRPC_SERVICE": 2,
		"FORMATTER_JAVASCRIPT":   3,
		"FORMATTER_CAYENNELPP":   4,
	}
)

func (x PayloadFormatter) Enum() *PayloadFormatter {
	p := new(PayloadFormatter)
	*p = x
	return p
}

func (x PayloadFormatter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PayloadFormatter) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_messages_proto_enumTypes[0].Descriptor()
}

func (PayloadFormatter) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_messages_proto_enumTypes[0]
}

func (x PayloadFormatter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PayloadFormatter.Descriptor instead.
func (PayloadFormatter) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{0}
}

type TxAcknowledgment_Result int32

const (
	TxAcknowledgment_SUCCESS          TxAcknowledgment_Result = 0
	TxAcknowledgment_UNKNOWN_ERROR    TxAcknowledgment_Result = 1
	TxAcknowledgment_TOO_LATE         TxAcknowledgment_Result = 2
	TxAcknowledgment_TOO_EARLY        TxAcknowledgment_Result = 3
	TxAcknowledgment_COLLISION_PACKET TxAcknowledgment_Result = 4
	TxAcknowledgment_COLLISION_BEACON TxAcknowledgment_Result = 5
	TxAcknowledgment_TX_FREQ          TxAcknowledgment_Result = 6
	TxAcknowledgment_TX_POWER         TxAcknowledgment_Result = 7
	TxAcknowledgment_GPS_UNLOCKED     TxAcknowledgment_Result = 8
)

// Enum value maps for TxAcknowledgment_Result.
var (
	TxAcknowledgment_Result_name = map[int32]string{
		0: "SUCCESS",
		1: "UNKNOWN_ERROR",
		2: "TOO_LATE",
		3: "TOO_EARLY",
		4: "COLLISION_PACKET",
		5: "COLLISION_BEACON",
		6: "TX_FREQ",
		7: "TX_POWER",
		8: "GPS_UNLOCKED",
	}
	TxAcknowledgment_Result_value = map[string]int32{
		"SUCCESS":          0,
		"UNKNOWN_ERROR":    1,
		"TOO_LATE":         2,
		"TOO_EARLY":        3,
		"COLLISION_PACKET": 4,
		"COLLISION_BEACON": 5,
		"TX_FREQ":          6,
		"TX_POWER":         7,
		"GPS_UNLOCKED":     8,
	}
)

func (x TxAcknowledgment_Result) Enum() *TxAcknowledgment_Result {
	p := new(TxAcknowledgment_Result)
	*p = x
	return p
}

func (x TxAcknowledgment_Result) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TxAcknowledgment_Result) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_messages_proto_enumTypes[1].Descriptor()
}

func (TxAcknowledgment_Result) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_messages_proto_enumTypes[1]
}

func (x TxAcknowledgment_Result) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TxAcknowledgment_Result.Descriptor instead.
func (TxAcknowledgment_Result) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{2, 0}
}

// Uplink message from the end device to the network
type UplinkMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RawPayload []byte        `protobuf:"bytes,1,opt,name=raw_payload,json=rawPayload,proto3" json:"raw_payload,omitempty"`
	Payload    *Message      `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	Settings   *TxSettings   `protobuf:"bytes,4,opt,name=settings,proto3" json:"settings,omitempty"`
	RxMetadata []*RxMetadata `protobuf:"bytes,5,rep,name=rx_metadata,json=rxMetadata,proto3" json:"rx_metadata,omitempty"`
	// Server time when a component received the message.
	// The Gateway Server and Network Server set this value to their local server time of reception.
	ReceivedAt     *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=received_at,json=receivedAt,proto3" json:"received_at,omitempty"`
	CorrelationIds []string               `protobuf:"bytes,7,rep,name=correlation_ids,json=correlationIds,proto3" json:"correlation_ids,omitempty"`
	// Index of the device channel that received the message.
	// Set by Network Server.
	DeviceChannelIndex uint32 `protobuf:"varint,9,opt,name=device_channel_index,json=deviceChannelIndex,proto3" json:"device_channel_index,omitempty"`
	// Consumed airtime for the transmission of the uplink message. Calculated by Network Server using the RawPayload size and the transmission settings.
	ConsumedAirtime *durationpb.Duration `protobuf:"bytes,10,opt,name=consumed_airtime,json=consumedAirtime,proto3" json:"consumed_airtime,omitempty"`
	// Cyclic Redundancy Check (CRC) status of demodulating the frame.
	// If unset, the modulation does not support CRC or the gateway did not provide a CRC status.
	// If set to false, this message should not be processed.
	CrcStatus *wrapperspb.BoolValue `protobuf:"bytes,11,opt,name=crc_status,json=crcStatus,proto3" json:"crc_status,omitempty"`
}

func (x *UplinkMessage) Reset() {
	*x = UplinkMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UplinkMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UplinkMessage) ProtoMessage() {}

func (x *UplinkMessage) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UplinkMessage.ProtoReflect.Descriptor instead.
func (*UplinkMessage) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{0}
}

func (x *UplinkMessage) GetRawPayload() []byte {
	if x != nil {
		return x.RawPayload
	}
	return nil
}

func (x *UplinkMessage) GetPayload() *Message {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *UplinkMessage) GetSettings() *TxSettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *UplinkMessage) GetRxMetadata() []*RxMetadata {
	if x != nil {
		return x.RxMetadata
	}
	return nil
}

func (x *UplinkMessage) GetReceivedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ReceivedAt
	}
	return nil
}

func (x *UplinkMessage) GetCorrelationIds() []string {
	if x != nil {
		return x.CorrelationIds
	}
	return nil
}

func (x *UplinkMessage) GetDeviceChannelIndex() uint32 {
	if x != nil {
		return x.DeviceChannelIndex
	}
	return 0
}

func (x *UplinkMessage) GetConsumedAirtime() *durationpb.Duration {
	if x != nil {
		return x.ConsumedAirtime
	}
	return nil
}

func (x *UplinkMessage) GetCrcStatus() *wrapperspb.BoolValue {
	if x != nil {
		return x.CrcStatus
	}
	return nil
}

// Downlink message from the network to the end device
type DownlinkMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RawPayload   []byte                `protobuf:"bytes,1,opt,name=raw_payload,json=rawPayload,proto3" json:"raw_payload,omitempty"`
	Payload      *Message              `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	EndDeviceIds *EndDeviceIdentifiers `protobuf:"bytes,3,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	// Types that are assignable to Settings:
	//	*DownlinkMessage_Request
	//	*DownlinkMessage_Scheduled
	Settings       isDownlinkMessage_Settings `protobuf_oneof:"settings"`
	CorrelationIds []string                   `protobuf:"bytes,6,rep,name=correlation_ids,json=correlationIds,proto3" json:"correlation_ids,omitempty"`
	SessionKeyId   []byte                     `protobuf:"bytes,7,opt,name=session_key_id,json=sessionKeyId,proto3" json:"session_key_id,omitempty"`
}

func (x *DownlinkMessage) Reset() {
	*x = DownlinkMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownlinkMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownlinkMessage) ProtoMessage() {}

func (x *DownlinkMessage) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownlinkMessage.ProtoReflect.Descriptor instead.
func (*DownlinkMessage) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{1}
}

func (x *DownlinkMessage) GetRawPayload() []byte {
	if x != nil {
		return x.RawPayload
	}
	return nil
}

func (x *DownlinkMessage) GetPayload() *Message {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *DownlinkMessage) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (m *DownlinkMessage) GetSettings() isDownlinkMessage_Settings {
	if m != nil {
		return m.Settings
	}
	return nil
}

func (x *DownlinkMessage) GetRequest() *TxRequest {
	if x, ok := x.GetSettings().(*DownlinkMessage_Request); ok {
		return x.Request
	}
	return nil
}

func (x *DownlinkMessage) GetScheduled() *TxSettings {
	if x, ok := x.GetSettings().(*DownlinkMessage_Scheduled); ok {
		return x.Scheduled
	}
	return nil
}

func (x *DownlinkMessage) GetCorrelationIds() []string {
	if x != nil {
		return x.CorrelationIds
	}
	return nil
}

func (x *DownlinkMessage) GetSessionKeyId() []byte {
	if x != nil {
		return x.SessionKeyId
	}
	return nil
}

type isDownlinkMessage_Settings interface {
	isDownlinkMessage_Settings()
}

type DownlinkMessage_Request struct {
	Request *TxRequest `protobuf:"bytes,4,opt,name=request,proto3,oneof"`
}

type DownlinkMessage_Scheduled struct {
	Scheduled *TxSettings `protobuf:"bytes,5,opt,name=scheduled,proto3,oneof"`
}

func (*DownlinkMessage_Request) isDownlinkMessage_Settings() {}

func (*DownlinkMessage_Scheduled) isDownlinkMessage_Settings() {}

type TxAcknowledgment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Correlation IDs for the downlink message.
	// Set automatically by the UDP and LBS frontends.
	// For gRPC and the MQTT v3 frontends, the correlation IDs must match the ones of the downlink message the Tx acknowledgment message refers to.
	CorrelationIds []string                `protobuf:"bytes,1,rep,name=correlation_ids,json=correlationIds,proto3" json:"correlation_ids,omitempty"`
	Result         TxAcknowledgment_Result `protobuf:"varint,2,opt,name=result,proto3,enum=ttn.lorawan.v3.TxAcknowledgment_Result" json:"result,omitempty"`
	// The acknowledged downlink message. Set by the Gateway Server.
	DownlinkMessage *DownlinkMessage `protobuf:"bytes,3,opt,name=downlink_message,json=downlinkMessage,proto3" json:"downlink_message,omitempty"`
}

func (x *TxAcknowledgment) Reset() {
	*x = TxAcknowledgment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TxAcknowledgment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TxAcknowledgment) ProtoMessage() {}

func (x *TxAcknowledgment) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TxAcknowledgment.ProtoReflect.Descriptor instead.
func (*TxAcknowledgment) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{2}
}

func (x *TxAcknowledgment) GetCorrelationIds() []string {
	if x != nil {
		return x.CorrelationIds
	}
	return nil
}

func (x *TxAcknowledgment) GetResult() TxAcknowledgment_Result {
	if x != nil {
		return x.Result
	}
	return TxAcknowledgment_SUCCESS
}

func (x *TxAcknowledgment) GetDownlinkMessage() *DownlinkMessage {
	if x != nil {
		return x.DownlinkMessage
	}
	return nil
}

type GatewayTxAcknowledgment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds *GatewayIdentifiers `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	TxAck      *TxAcknowledgment   `protobuf:"bytes,2,opt,name=tx_ack,json=txAck,proto3" json:"tx_ack,omitempty"`
}

func (x *GatewayTxAcknowledgment) Reset() {
	*x = GatewayTxAcknowledgment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayTxAcknowledgment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayTxAcknowledgment) ProtoMessage() {}

func (x *GatewayTxAcknowledgment) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayTxAcknowledgment.ProtoReflect.Descriptor instead.
func (*GatewayTxAcknowledgment) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{3}
}

func (x *GatewayTxAcknowledgment) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *GatewayTxAcknowledgment) GetTxAck() *TxAcknowledgment {
	if x != nil {
		return x.TxAck
	}
	return nil
}

type GatewayUplinkMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Message *UplinkMessage `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// LoRaWAN band ID of the gateway.
	BandId string `protobuf:"bytes,2,opt,name=band_id,json=bandId,proto3" json:"band_id,omitempty"`
}

func (x *GatewayUplinkMessage) Reset() {
	*x = GatewayUplinkMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayUplinkMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayUplinkMessage) ProtoMessage() {}

func (x *GatewayUplinkMessage) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayUplinkMessage.ProtoReflect.Descriptor instead.
func (*GatewayUplinkMessage) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{4}
}

func (x *GatewayUplinkMessage) GetMessage() *UplinkMessage {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *GatewayUplinkMessage) GetBandId() string {
	if x != nil {
		return x.BandId
	}
	return ""
}

type ApplicationUplink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Join Server issued identifier for the session keys used by this uplink.
	SessionKeyId []byte `protobuf:"bytes,1,opt,name=session_key_id,json=sessionKeyId,proto3" json:"session_key_id,omitempty"`
	// LoRaWAN FPort of the uplink message.
	FPort uint32 `protobuf:"varint,2,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	// LoRaWAN FCntUp of the uplink message.
	FCnt uint32 `protobuf:"varint,3,opt,name=f_cnt,json=fCnt,proto3" json:"f_cnt,omitempty"`
	// The frame payload of the uplink message.
	// The payload is still encrypted if the skip_payload_crypto field of the EndDevice
	// is true, which is indicated by the presence of the app_s_key field.
	FrmPayload []byte `protobuf:"bytes,4,opt,name=frm_payload,json=frmPayload,proto3" json:"frm_payload,omitempty"`
	// The decoded frame payload of the uplink message.
	// This field is set by the message processor that is configured for the end device (see formatters) or application (see default_formatters).
	DecodedPayload *structpb.Struct `protobuf:"bytes,5,opt,name=decoded_payload,json=decodedPayload,proto3" json:"decoded_payload,omitempty"`
	// Warnings generated by the message processor while decoding the frm_payload.
	DecodedPayloadWarnings []string `protobuf:"bytes,12,rep,name=decoded_payload_warnings,json=decodedPayloadWarnings,proto3" json:"decoded_payload_warnings,omitempty"`
	// The normalized frame payload of the uplink message.
	// This field is set by the message processor that is configured for the end device (see formatters) or application (see default_formatters).
	// If the message processor is a custom script, there is no uplink normalizer script and the decoded output is valid
	// normalized payload, this field contains the decoded payload.
	NormalizedPayload []*structpb.Struct `protobuf:"bytes,17,rep,name=normalized_payload,json=normalizedPayload,proto3" json:"normalized_payload,omitempty"`
	// Warnings generated by the message processor while normalizing the decoded payload.
	NormalizedPayloadWarnings []string `protobuf:"bytes,18,rep,name=normalized_payload_warnings,json=normalizedPayloadWarnings,proto3" json:"normalized_payload_warnings,omitempty"`
	// A list of metadata for each antenna of each gateway that received this message.
	RxMetadata []*RxMetadata `protobuf:"bytes,6,rep,name=rx_metadata,json=rxMetadata,proto3" json:"rx_metadata,omitempty"`
	// Transmission settings used by the end device.
	Settings *TxSettings `protobuf:"bytes,7,opt,name=settings,proto3" json:"settings,omitempty"`
	// Server time when the Network Server received the message.
	ReceivedAt *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=received_at,json=receivedAt,proto3" json:"received_at,omitempty"`
	// The AppSKey of the current session.
	// This field is only present if the skip_payload_crypto field of the EndDevice
	// is true.
	// Can be used to decrypt uplink payloads and encrypt downlink payloads.
	AppSKey *KeyEnvelope `protobuf:"bytes,9,opt,name=app_s_key,json=appSKey,proto3" json:"app_s_key,omitempty"`
	// The last AFCntDown of the current session.
	// This field is only present if the skip_payload_crypto field of the EndDevice
	// is true.
	// Can be used with app_s_key to encrypt downlink payloads.
	LastAFCntDown uint32 `protobuf:"varint,10,opt,name=last_a_f_cnt_down,json=lastAFCntDown,proto3" json:"last_a_f_cnt_down,omitempty"`
	// Indicates whether the end device used confirmed data uplink.
	Confirmed bool `protobuf:"varint,11,opt,name=confirmed,proto3" json:"confirmed,omitempty"`
	// Consumed airtime for the transmission of the uplink message. Calculated by Network Server using the raw payload size and the transmission settings.
	ConsumedAirtime *durationpb.Duration `protobuf:"bytes,13,opt,name=consumed_airtime,json=consumedAirtime,proto3" json:"consumed_airtime,omitempty"`
	// Packet error rate of the recent uplinks in the current session.
	// Calculated by the Network Server. The value is defined in the [0, 1] interval.
	PacketErrorRate float32 `protobuf:"fixed32,19,opt,name=packet_error_rate,json=packetErrorRate,proto3" json:"packet_error_rate,omitempty"`
	// End device location metadata, set by the Application Server while handling the message.
	Locations map[string]*Location `protobuf:"bytes,14,rep,name=locations,proto3" json:"locations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// End device version identifiers, set by the Application Server while handling the message.
	VersionIds *EndDeviceVersionIdentifiers `protobuf:"bytes,15,opt,name=version_ids,json=versionIds,proto3" json:"version_ids,omitempty"`
	// Network identifiers, set by the Network Server that handles the message.
	NetworkIds *NetworkIdentifiers `protobuf:"bytes,16,opt,name=network_ids,json=networkIds,proto3" json:"network_ids,omitempty"`
}

func (x *ApplicationUplink) Reset() {
	*x = ApplicationUplink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationUplink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationUplink) ProtoMessage() {}

func (x *ApplicationUplink) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationUplink.ProtoReflect.Descriptor instead.
func (*ApplicationUplink) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{5}
}

func (x *ApplicationUplink) GetSessionKeyId() []byte {
	if x != nil {
		return x.SessionKeyId
	}
	return nil
}

func (x *ApplicationUplink) GetFPort() uint32 {
	if x != nil {
		return x.FPort
	}
	return 0
}

func (x *ApplicationUplink) GetFCnt() uint32 {
	if x != nil {
		return x.FCnt
	}
	return 0
}

func (x *ApplicationUplink) GetFrmPayload() []byte {
	if x != nil {
		return x.FrmPayload
	}
	return nil
}

func (x *ApplicationUplink) GetDecodedPayload() *structpb.Struct {
	if x != nil {
		return x.DecodedPayload
	}
	return nil
}

func (x *ApplicationUplink) GetDecodedPayloadWarnings() []string {
	if x != nil {
		return x.DecodedPayloadWarnings
	}
	return nil
}

func (x *ApplicationUplink) GetNormalizedPayload() []*structpb.Struct {
	if x != nil {
		return x.NormalizedPayload
	}
	return nil
}

func (x *ApplicationUplink) GetNormalizedPayloadWarnings() []string {
	if x != nil {
		return x.NormalizedPayloadWarnings
	}
	return nil
}

func (x *ApplicationUplink) GetRxMetadata() []*RxMetadata {
	if x != nil {
		return x.RxMetadata
	}
	return nil
}

func (x *ApplicationUplink) GetSettings() *TxSettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *ApplicationUplink) GetReceivedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ReceivedAt
	}
	return nil
}

func (x *ApplicationUplink) GetAppSKey() *KeyEnvelope {
	if x != nil {
		return x.AppSKey
	}
	return nil
}

func (x *ApplicationUplink) GetLastAFCntDown() uint32 {
	if x != nil {
		return x.LastAFCntDown
	}
	return 0
}

func (x *ApplicationUplink) GetConfirmed() bool {
	if x != nil {
		return x.Confirmed
	}
	return false
}

func (x *ApplicationUplink) GetConsumedAirtime() *durationpb.Duration {
	if x != nil {
		return x.ConsumedAirtime
	}
	return nil
}

func (x *ApplicationUplink) GetPacketErrorRate() float32 {
	if x != nil {
		return x.PacketErrorRate
	}
	return 0
}

func (x *ApplicationUplink) GetLocations() map[string]*Location {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *ApplicationUplink) GetVersionIds() *EndDeviceVersionIdentifiers {
	if x != nil {
		return x.VersionIds
	}
	return nil
}

func (x *ApplicationUplink) GetNetworkIds() *NetworkIdentifiers {
	if x != nil {
		return x.NetworkIds
	}
	return nil
}

type ApplicationUplinkNormalized struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Join Server issued identifier for the session keys used by this uplink.
	SessionKeyId []byte `protobuf:"bytes,1,opt,name=session_key_id,json=sessionKeyId,proto3" json:"session_key_id,omitempty"`
	// LoRaWAN FPort of the uplink message.
	FPort uint32 `protobuf:"varint,2,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	// LoRaWAN FCntUp of the uplink message.
	FCnt uint32 `protobuf:"varint,3,opt,name=f_cnt,json=fCnt,proto3" json:"f_cnt,omitempty"`
	// The frame payload of the uplink message.
	// This field is always decrypted with AppSKey.
	FrmPayload []byte `protobuf:"bytes,4,opt,name=frm_payload,json=frmPayload,proto3" json:"frm_payload,omitempty"`
	// The normalized frame payload of the uplink message.
	// This field is set for each item in normalized_payload in the corresponding ApplicationUplink message.
	NormalizedPayload *structpb.Struct `protobuf:"bytes,5,opt,name=normalized_payload,json=normalizedPayload,proto3" json:"normalized_payload,omitempty"`
	// This field is set to normalized_payload_warnings in the corresponding ApplicationUplink message.
	NormalizedPayloadWarnings []string `protobuf:"bytes,6,rep,name=normalized_payload_warnings,json=normalizedPayloadWarnings,proto3" json:"normalized_payload_warnings,omitempty"`
	// A list of metadata for each antenna of each gateway that received this message.
	RxMetadata []*RxMetadata `protobuf:"bytes,7,rep,name=rx_metadata,json=rxMetadata,proto3" json:"rx_metadata,omitempty"`
	// Transmission settings used by the end device.
	Settings *TxSettings `protobuf:"bytes,8,opt,name=settings,proto3" json:"settings,omitempty"`
	// Server time when the Network Server received the message.
	ReceivedAt *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=received_at,json=receivedAt,proto3" json:"received_at,omitempty"`
	// Indicates whether the end device used confirmed data uplink.
	Confirmed bool `protobuf:"varint,10,opt,name=confirmed,proto3" json:"confirmed,omitempty"`
	// Consumed airtime for the transmission of the uplink message. Calculated by Network Server using the raw payload size and the transmission settings.
	ConsumedAirtime *durationpb.Duration `protobuf:"bytes,11,opt,name=consumed_airtime,json=consumedAirtime,proto3" json:"consumed_airtime,omitempty"`
	// End device location metadata, set by the Application Server while handling the message.
	Locations map[string]*Location `protobuf:"bytes,12,rep,name=locations,proto3" json:"locations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// End device version identifiers, set by the Application Server while handling the message.
	VersionIds *EndDeviceVersionIdentifiers `protobuf:"bytes,13,opt,name=version_ids,json=versionIds,proto3" json:"version_ids,omitempty"`
	// Network identifiers, set by the Network Server that handles the message.
	NetworkIds *NetworkIdentifiers `protobuf:"bytes,14,opt,name=network_ids,json=networkIds,proto3" json:"network_ids,omitempty"`
}

func (x *ApplicationUplinkNormalized) Reset() {
	*x = ApplicationUplinkNormalized{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationUplinkNormalized) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationUplinkNormalized) ProtoMessage() {}

func (x *ApplicationUplinkNormalized) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationUplinkNormalized.ProtoReflect.Descriptor instead.
func (*ApplicationUplinkNormalized) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{6}
}

func (x *ApplicationUplinkNormalized) GetSessionKeyId() []byte {
	if x != nil {
		return x.SessionKeyId
	}
	return nil
}

func (x *ApplicationUplinkNormalized) GetFPort() uint32 {
	if x != nil {
		return x.FPort
	}
	return 0
}

func (x *ApplicationUplinkNormalized) GetFCnt() uint32 {
	if x != nil {
		return x.FCnt
	}
	return 0
}

func (x *ApplicationUplinkNormalized) GetFrmPayload() []byte {
	if x != nil {
		return x.FrmPayload
	}
	return nil
}

func (x *ApplicationUplinkNormalized) GetNormalizedPayload() *structpb.Struct {
	if x != nil {
		return x.NormalizedPayload
	}
	return nil
}

func (x *ApplicationUplinkNormalized) GetNormalizedPayloadWarnings() []string {
	if x != nil {
		return x.NormalizedPayloadWarnings
	}
	return nil
}

func (x *ApplicationUplinkNormalized) GetRxMetadata() []*RxMetadata {
	if x != nil {
		return x.RxMetadata
	}
	return nil
}

func (x *ApplicationUplinkNormalized) GetSettings() *TxSettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *ApplicationUplinkNormalized) GetReceivedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ReceivedAt
	}
	return nil
}

func (x *ApplicationUplinkNormalized) GetConfirmed() bool {
	if x != nil {
		return x.Confirmed
	}
	return false
}

func (x *ApplicationUplinkNormalized) GetConsumedAirtime() *durationpb.Duration {
	if x != nil {
		return x.ConsumedAirtime
	}
	return nil
}

func (x *ApplicationUplinkNormalized) GetLocations() map[string]*Location {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *ApplicationUplinkNormalized) GetVersionIds() *EndDeviceVersionIdentifiers {
	if x != nil {
		return x.VersionIds
	}
	return nil
}

func (x *ApplicationUplinkNormalized) GetNetworkIds() *NetworkIdentifiers {
	if x != nil {
		return x.NetworkIds
	}
	return nil
}

type ApplicationLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Service    string            `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	Location   *Location         `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	Attributes map[string]string `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ApplicationLocation) Reset() {
	*x = ApplicationLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationLocation) ProtoMessage() {}

func (x *ApplicationLocation) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationLocation.ProtoReflect.Descriptor instead.
func (*ApplicationLocation) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{7}
}

func (x *ApplicationLocation) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *ApplicationLocation) GetLocation() *Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *ApplicationLocation) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

type ApplicationJoinAccept struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Join Server issued identifier for the session keys negotiated in this join.
	SessionKeyId []byte `protobuf:"bytes,1,opt,name=session_key_id,json=sessionKeyId,proto3" json:"session_key_id,omitempty"`
	// Encrypted Application Session Key (if Join Server sent it to Network Server).
	AppSKey *KeyEnvelope `protobuf:"bytes,2,opt,name=app_s_key,json=appSKey,proto3" json:"app_s_key,omitempty"`
	// Downlink messages in the queue that got invalidated because of the session change.
	InvalidatedDownlinks []*ApplicationDownlink `protobuf:"bytes,3,rep,name=invalidated_downlinks,json=invalidatedDownlinks,proto3" json:"invalidated_downlinks,omitempty"`
	// Indicates whether the security context refers to the pending session, i.e. when this join-accept is an answer to a
	// rejoin-request.
	PendingSession bool `protobuf:"varint,4,opt,name=pending_session,json=pendingSession,proto3" json:"pending_session,omitempty"`
	// Server time when the Network Server received the message.
	ReceivedAt *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=received_at,json=receivedAt,proto3" json:"received_at,omitempty"`
}

func (x *ApplicationJoinAccept) Reset() {
	*x = ApplicationJoinAccept{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationJoinAccept) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationJoinAccept) ProtoMessage() {}

func (x *ApplicationJoinAccept) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationJoinAccept.ProtoReflect.Descriptor instead.
func (*ApplicationJoinAccept) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{8}
}

func (x *ApplicationJoinAccept) GetSessionKeyId() []byte {
	if x != nil {
		return x.SessionKeyId
	}
	return nil
}

func (x *ApplicationJoinAccept) GetAppSKey() *KeyEnvelope {
	if x != nil {
		return x.AppSKey
	}
	return nil
}

func (x *ApplicationJoinAccept) GetInvalidatedDownlinks() []*ApplicationDownlink {
	if x != nil {
		return x.InvalidatedDownlinks
	}
	return nil
}

func (x *ApplicationJoinAccept) GetPendingSession() bool {
	if x != nil {
		return x.PendingSession
	}
	return false
}

func (x *ApplicationJoinAccept) GetReceivedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ReceivedAt
	}
	return nil
}

type ApplicationDownlink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Join Server issued identifier for the session keys used by this downlink.
	SessionKeyId []byte `protobuf:"bytes,1,opt,name=session_key_id,json=sessionKeyId,proto3" json:"session_key_id,omitempty"`
	FPort        uint32 `protobuf:"varint,2,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	FCnt         uint32 `protobuf:"varint,3,opt,name=f_cnt,json=fCnt,proto3" json:"f_cnt,omitempty"`
	// The frame payload of the downlink message.
	// The payload is encrypted if the skip_payload_crypto field of the EndDevice
	// is true.
	FrmPayload []byte `protobuf:"bytes,4,opt,name=frm_payload,json=frmPayload,proto3" json:"frm_payload,omitempty"`
	// The decoded frame payload of the downlink message.
	// When scheduling downlink with a message processor configured for the end device (see formatters) or application (see default_formatters),
	// this fields acts as input for the downlink encoder, and the output is set to frm_payload.
	// When reading downlink (listing the queue, downlink message events, etc), this fields acts as output of the downlink decoder, and the input is frm_payload.
	DecodedPayload *structpb.Struct `protobuf:"bytes,5,opt,name=decoded_payload,json=decodedPayload,proto3" json:"decoded_payload,omitempty"`
	// Warnings generated by the message processor while encoding frm_payload (scheduling downlink) or decoding the frm_payload (reading downlink).
	DecodedPayloadWarnings []string `protobuf:"bytes,10,rep,name=decoded_payload_warnings,json=decodedPayloadWarnings,proto3" json:"decoded_payload_warnings,omitempty"`
	Confirmed              bool     `protobuf:"varint,6,opt,name=confirmed,proto3" json:"confirmed,omitempty"`
	// Optional gateway and timing information for class B and C.
	// If set, this downlink message will only be transmitted as class B or C downlink.
	// If not set, this downlink message may be transmitted in class A, B and C.
	ClassBC *ApplicationDownlink_ClassBC `protobuf:"bytes,7,opt,name=class_b_c,json=classBC,proto3" json:"class_b_c,omitempty"`
	// Priority for scheduling the downlink message.
	Priority       TxSchedulePriority                  `protobuf:"varint,8,opt,name=priority,proto3,enum=ttn.lorawan.v3.TxSchedulePriority" json:"priority,omitempty"`
	CorrelationIds []string                            `protobuf:"bytes,9,rep,name=correlation_ids,json=correlationIds,proto3" json:"correlation_ids,omitempty"`
	ConfirmedRetry *ApplicationDownlink_ConfirmedRetry `protobuf:"bytes,11,opt,name=confirmed_retry,json=confirmedRetry,proto3" json:"confirmed_retry,omitempty"`
}

func (x *ApplicationDownlink) Reset() {
	*x = ApplicationDownlink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationDownlink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationDownlink) ProtoMessage() {}

func (x *ApplicationDownlink) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationDownlink.ProtoReflect.Descriptor instead.
func (*ApplicationDownlink) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{9}
}

func (x *ApplicationDownlink) GetSessionKeyId() []byte {
	if x != nil {
		return x.SessionKeyId
	}
	return nil
}

func (x *ApplicationDownlink) GetFPort() uint32 {
	if x != nil {
		return x.FPort
	}
	return 0
}

func (x *ApplicationDownlink) GetFCnt() uint32 {
	if x != nil {
		return x.FCnt
	}
	return 0
}

func (x *ApplicationDownlink) GetFrmPayload() []byte {
	if x != nil {
		return x.FrmPayload
	}
	return nil
}

func (x *ApplicationDownlink) GetDecodedPayload() *structpb.Struct {
	if x != nil {
		return x.DecodedPayload
	}
	return nil
}

func (x *ApplicationDownlink) GetDecodedPayloadWarnings() []string {
	if x != nil {
		return x.DecodedPayloadWarnings
	}
	return nil
}

func (x *ApplicationDownlink) GetConfirmed() bool {
	if x != nil {
		return x.Confirmed
	}
	return false
}

func (x *ApplicationDownlink) GetClassBC() *ApplicationDownlink_ClassBC {
	if x != nil {
		return x.ClassBC
	}
	return nil
}

func (x *ApplicationDownlink) GetPriority() TxSchedulePriority {
	if x != nil {
		return x.Priority
	}
	return TxSchedulePriority_LOWEST
}

func (x *ApplicationDownlink) GetCorrelationIds() []string {
	if x != nil {
		return x.CorrelationIds
	}
	return nil
}

func (x *ApplicationDownlink) GetConfirmedRetry() *ApplicationDownlink_ConfirmedRetry {
	if x != nil {
		return x.ConfirmedRetry
	}
	return nil
}

type ApplicationDownlinks struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Downlinks []*ApplicationDownlink `protobuf:"bytes,1,rep,name=downlinks,proto3" json:"downlinks,omitempty"`
}

func (x *ApplicationDownlinks) Reset() {
	*x = ApplicationDownlinks{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationDownlinks) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationDownlinks) ProtoMessage() {}

func (x *ApplicationDownlinks) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationDownlinks.ProtoReflect.Descriptor instead.
func (*ApplicationDownlinks) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{10}
}

func (x *ApplicationDownlinks) GetDownlinks() []*ApplicationDownlink {
	if x != nil {
		return x.Downlinks
	}
	return nil
}

type ApplicationDownlinkFailed struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Downlink *ApplicationDownlink `protobuf:"bytes,1,opt,name=downlink,proto3" json:"downlink,omitempty"`
	Error    *ErrorDetails        `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ApplicationDownlinkFailed) Reset() {
	*x = ApplicationDownlinkFailed{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationDownlinkFailed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationDownlinkFailed) ProtoMessage() {}

func (x *ApplicationDownlinkFailed) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationDownlinkFailed.ProtoReflect.Descriptor instead.
func (*ApplicationDownlinkFailed) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{11}
}

func (x *ApplicationDownlinkFailed) GetDownlink() *ApplicationDownlink {
	if x != nil {
		return x.Downlink
	}
	return nil
}

func (x *ApplicationDownlinkFailed) GetError() *ErrorDetails {
	if x != nil {
		return x.Error
	}
	return nil
}

type ApplicationInvalidatedDownlinks struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Downlinks    []*ApplicationDownlink `protobuf:"bytes,1,rep,name=downlinks,proto3" json:"downlinks,omitempty"`
	LastFCntDown uint32                 `protobuf:"varint,2,opt,name=last_f_cnt_down,json=lastFCntDown,proto3" json:"last_f_cnt_down,omitempty"`
	SessionKeyId []byte                 `protobuf:"bytes,3,opt,name=session_key_id,json=sessionKeyId,proto3" json:"session_key_id,omitempty"`
}

func (x *ApplicationInvalidatedDownlinks) Reset() {
	*x = ApplicationInvalidatedDownlinks{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationInvalidatedDownlinks) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationInvalidatedDownlinks) ProtoMessage() {}

func (x *ApplicationInvalidatedDownlinks) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationInvalidatedDownlinks.ProtoReflect.Descriptor instead.
func (*ApplicationInvalidatedDownlinks) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{12}
}

func (x *ApplicationInvalidatedDownlinks) GetDownlinks() []*ApplicationDownlink {
	if x != nil {
		return x.Downlinks
	}
	return nil
}

func (x *ApplicationInvalidatedDownlinks) GetLastFCntDown() uint32 {
	if x != nil {
		return x.LastFCntDown
	}
	return 0
}

func (x *ApplicationInvalidatedDownlinks) GetSessionKeyId() []byte {
	if x != nil {
		return x.SessionKeyId
	}
	return nil
}

type DownlinkQueueOperationErrorDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DevAddr             []byte `protobuf:"bytes,1,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	SessionKeyId        []byte `protobuf:"bytes,2,opt,name=session_key_id,json=sessionKeyId,proto3" json:"session_key_id,omitempty"`
	MinFCntDown         uint32 `protobuf:"varint,3,opt,name=min_f_cnt_down,json=minFCntDown,proto3" json:"min_f_cnt_down,omitempty"`
	PendingDevAddr      []byte `protobuf:"bytes,4,opt,name=pending_dev_addr,json=pendingDevAddr,proto3" json:"pending_dev_addr,omitempty"`
	PendingSessionKeyId []byte `protobuf:"bytes,5,opt,name=pending_session_key_id,json=pendingSessionKeyId,proto3" json:"pending_session_key_id,omitempty"`
	PendingMinFCntDown  uint32 `protobuf:"varint,6,opt,name=pending_min_f_cnt_down,json=pendingMinFCntDown,proto3" json:"pending_min_f_cnt_down,omitempty"`
}

func (x *DownlinkQueueOperationErrorDetails) Reset() {
	*x = DownlinkQueueOperationErrorDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownlinkQueueOperationErrorDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownlinkQueueOperationErrorDetails) ProtoMessage() {}

func (x *DownlinkQueueOperationErrorDetails) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownlinkQueueOperationErrorDetails.ProtoReflect.Descriptor instead.
func (*DownlinkQueueOperationErrorDetails) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{13}
}

func (x *DownlinkQueueOperationErrorDetails) GetDevAddr() []byte {
	if x != nil {
		return x.DevAddr
	}
	return nil
}

func (x *DownlinkQueueOperationErrorDetails) GetSessionKeyId() []byte {
	if x != nil {
		return x.SessionKeyId
	}
	return nil
}

func (x *DownlinkQueueOperationErrorDetails) GetMinFCntDown() uint32 {
	if x != nil {
		return x.MinFCntDown
	}
	return 0
}

func (x *DownlinkQueueOperationErrorDetails) GetPendingDevAddr() []byte {
	if x != nil {
		return x.PendingDevAddr
	}
	return nil
}

func (x *DownlinkQueueOperationErrorDetails) GetPendingSessionKeyId() []byte {
	if x != nil {
		return x.PendingSessionKeyId
	}
	return nil
}

func (x *DownlinkQueueOperationErrorDetails) GetPendingMinFCntDown() uint32 {
	if x != nil {
		return x.PendingMinFCntDown
	}
	return 0
}

type ApplicationServiceData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Service string           `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	Data    *structpb.Struct `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *ApplicationServiceData) Reset() {
	*x = ApplicationServiceData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationServiceData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationServiceData) ProtoMessage() {}

func (x *ApplicationServiceData) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationServiceData.ProtoReflect.Descriptor instead.
func (*ApplicationServiceData) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{14}
}

func (x *ApplicationServiceData) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *ApplicationServiceData) GetData() *structpb.Struct {
	if x != nil {
		return x.Data
	}
	return nil
}

// Application uplink message.
type ApplicationUp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EndDeviceIds   *EndDeviceIdentifiers `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	CorrelationIds []string              `protobuf:"bytes,2,rep,name=correlation_ids,json=correlationIds,proto3" json:"correlation_ids,omitempty"`
	// Server time when the Application Server received the message.
	ReceivedAt *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=received_at,json=receivedAt,proto3" json:"received_at,omitempty"`
	// Types that are assignable to Up:
	//	*ApplicationUp_UplinkMessage
	//	*ApplicationUp_UplinkNormalized
	//	*ApplicationUp_JoinAccept
	//	*ApplicationUp_DownlinkAck
	//	*ApplicationUp_DownlinkNack
	//	*ApplicationUp_DownlinkSent
	//	*ApplicationUp_DownlinkFailed
	//	*ApplicationUp_DownlinkQueued
	//	*ApplicationUp_DownlinkQueueInvalidated
	//	*ApplicationUp_LocationSolved
	//	*ApplicationUp_ServiceData
	Up isApplicationUp_Up `protobuf_oneof:"up"`
	// Signals if the message is coming from the Network Server or is simulated.
	// The Application Server automatically sets this field, and callers must not manually set it.
	Simulated bool `protobuf:"varint,14,opt,name=simulated,proto3" json:"simulated,omitempty"`
}

func (x *ApplicationUp) Reset() {
	*x = ApplicationUp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationUp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationUp) ProtoMessage() {}

func (x *ApplicationUp) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationUp.ProtoReflect.Descriptor instead.
func (*ApplicationUp) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{15}
}

func (x *ApplicationUp) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *ApplicationUp) GetCorrelationIds() []string {
	if x != nil {
		return x.CorrelationIds
	}
	return nil
}

func (x *ApplicationUp) GetReceivedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ReceivedAt
	}
	return nil
}

func (m *ApplicationUp) GetUp() isApplicationUp_Up {
	if m != nil {
		return m.Up
	}
	return nil
}

func (x *ApplicationUp) GetUplinkMessage() *ApplicationUplink {
	if x, ok := x.GetUp().(*ApplicationUp_UplinkMessage); ok {
		return x.UplinkMessage
	}
	return nil
}

func (x *ApplicationUp) GetUplinkNormalized() *ApplicationUplinkNormalized {
	if x, ok := x.GetUp().(*ApplicationUp_UplinkNormalized); ok {
		return x.UplinkNormalized
	}
	return nil
}

func (x *ApplicationUp) GetJoinAccept() *ApplicationJoinAccept {
	if x, ok := x.GetUp().(*ApplicationUp_JoinAccept); ok {
		return x.JoinAccept
	}
	return nil
}

func (x *ApplicationUp) GetDownlinkAck() *ApplicationDownlink {
	if x, ok := x.GetUp().(*ApplicationUp_DownlinkAck); ok {
		return x.DownlinkAck
	}
	return nil
}

func (x *ApplicationUp) GetDownlinkNack() *ApplicationDownlink {
	if x, ok := x.GetUp().(*ApplicationUp_DownlinkNack); ok {
		return x.DownlinkNack
	}
	return nil
}

func (x *ApplicationUp) GetDownlinkSent() *ApplicationDownlink {
	if x, ok := x.GetUp().(*ApplicationUp_DownlinkSent); ok {
		return x.DownlinkSent
	}
	return nil
}

func (x *ApplicationUp) GetDownlinkFailed() *ApplicationDownlinkFailed {
	if x, ok := x.GetUp().(*ApplicationUp_DownlinkFailed); ok {
		return x.DownlinkFailed
	}
	return nil
}

func (x *ApplicationUp) GetDownlinkQueued() *ApplicationDownlink {
	if x, ok := x.GetUp().(*ApplicationUp_DownlinkQueued); ok {
		return x.DownlinkQueued
	}
	return nil
}

func (x *ApplicationUp) GetDownlinkQueueInvalidated() *ApplicationInvalidatedDownlinks {
	if x, ok := x.GetUp().(*ApplicationUp_DownlinkQueueInvalidated); ok {
		return x.DownlinkQueueInvalidated
	}
	return nil
}

func (x *ApplicationUp) GetLocationSolved() *ApplicationLocation {
	if x, ok := x.GetUp().(*ApplicationUp_LocationSolved); ok {
		return x.LocationSolved
	}
	return nil
}

func (x *ApplicationUp) GetServiceData() *ApplicationServiceData {
	if x, ok := x.GetUp().(*ApplicationUp_ServiceData); ok {
		return x.ServiceData
	}
	return nil
}

func (x *ApplicationUp) GetSimulated() bool {
	if x != nil {
		return x.Simulated
	}
	return false
}

type isApplicationUp_Up interface {
	isApplicationUp_Up()
}

type ApplicationUp_UplinkMessage struct {
	UplinkMessage *ApplicationUplink `protobuf:"bytes,3,opt,name=uplink_message,json=uplinkMessage,proto3,oneof"`
}

type ApplicationUp_UplinkNormalized struct {
	UplinkNormalized *ApplicationUplinkNormalized `protobuf:"bytes,15,opt,name=uplink_normalized,json=uplinkNormalized,proto3,oneof"`
}

type ApplicationUp_JoinAccept struct {
	JoinAccept *ApplicationJoinAccept `protobuf:"bytes,4,opt,name=join_accept,json=joinAccept,proto3,oneof"`
}

type ApplicationUp_DownlinkAck struct {
	DownlinkAck *ApplicationDownlink `protobuf:"bytes,5,opt,name=downlink_ack,json=downlinkAck,proto3,oneof"`
}

type ApplicationUp_DownlinkNack struct {
	DownlinkNack *ApplicationDownlink `protobuf:"bytes,6,opt,name=downlink_nack,json=downlinkNack,proto3,oneof"`
}

type ApplicationUp_DownlinkSent struct {
	DownlinkSent *ApplicationDownlink `protobuf:"bytes,7,opt,name=downlink_sent,json=downlinkSent,proto3,oneof"`
}

type ApplicationUp_DownlinkFailed struct {
	DownlinkFailed *ApplicationDownlinkFailed `protobuf:"bytes,8,opt,name=downlink_failed,json=downlinkFailed,proto3,oneof"`
}

type ApplicationUp_DownlinkQueued struct {
	DownlinkQueued *ApplicationDownlink `protobuf:"bytes,9,opt,name=downlink_queued,json=downlinkQueued,proto3,oneof"`
}

type ApplicationUp_DownlinkQueueInvalidated struct {
	DownlinkQueueInvalidated *ApplicationInvalidatedDownlinks `protobuf:"bytes,10,opt,name=downlink_queue_invalidated,json=downlinkQueueInvalidated,proto3,oneof"`
}

type ApplicationUp_LocationSolved struct {
	LocationSolved *ApplicationLocation `protobuf:"bytes,11,opt,name=location_solved,json=locationSolved,proto3,oneof"`
}

type ApplicationUp_ServiceData struct {
	ServiceData *ApplicationServiceData `protobuf:"bytes,13,opt,name=service_data,json=serviceData,proto3,oneof"`
}

func (*ApplicationUp_UplinkMessage) isApplicationUp_Up() {}

func (*ApplicationUp_UplinkNormalized) isApplicationUp_Up() {}

func (*ApplicationUp_JoinAccept) isApplicationUp_Up() {}

func (*ApplicationUp_DownlinkAck) isApplicationUp_Up() {}

func (*ApplicationUp_DownlinkNack) isApplicationUp_Up() {}

func (*ApplicationUp_DownlinkSent) isApplicationUp_Up() {}

func (*ApplicationUp_DownlinkFailed) isApplicationUp_Up() {}

func (*ApplicationUp_DownlinkQueued) isApplicationUp_Up() {}

func (*ApplicationUp_DownlinkQueueInvalidated) isApplicationUp_Up() {}

func (*ApplicationUp_LocationSolved) isApplicationUp_Up() {}

func (*ApplicationUp_ServiceData) isApplicationUp_Up() {}

type MessagePayloadFormatters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Payload formatter for uplink messages, must be set together with its parameter.
	UpFormatter PayloadFormatter `protobuf:"varint,1,opt,name=up_formatter,json=upFormatter,proto3,enum=ttn.lorawan.v3.PayloadFormatter" json:"up_formatter,omitempty"`
	// Parameter for the up_formatter, must be set together. The API enforces a maximum length of 16KB, but the size may be restricted further by deployment configuration.
	UpFormatterParameter string `protobuf:"bytes,2,opt,name=up_formatter_parameter,json=upFormatterParameter,proto3" json:"up_formatter_parameter,omitempty"`
	// Payload formatter for downlink messages, must be set together with its parameter.
	DownFormatter PayloadFormatter `protobuf:"varint,3,opt,name=down_formatter,json=downFormatter,proto3,enum=ttn.lorawan.v3.PayloadFormatter" json:"down_formatter,omitempty"`
	// Parameter for the down_formatter, must be set together. The API enforces a maximum length of 16KB, but the size may be restricted further by deployment configuration.
	DownFormatterParameter string `protobuf:"bytes,4,opt,name=down_formatter_parameter,json=downFormatterParameter,proto3" json:"down_formatter_parameter,omitempty"`
}

func (x *MessagePayloadFormatters) Reset() {
	*x = MessagePayloadFormatters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessagePayloadFormatters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessagePayloadFormatters) ProtoMessage() {}

func (x *MessagePayloadFormatters) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessagePayloadFormatters.ProtoReflect.Descriptor instead.
func (*MessagePayloadFormatters) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{16}
}

func (x *MessagePayloadFormatters) GetUpFormatter() PayloadFormatter {
	if x != nil {
		return x.UpFormatter
	}
	return PayloadFormatter_FORMATTER_NONE
}

func (x *MessagePayloadFormatters) GetUpFormatterParameter() string {
	if x != nil {
		return x.UpFormatterParameter
	}
	return ""
}

func (x *MessagePayloadFormatters) GetDownFormatter() PayloadFormatter {
	if x != nil {
		return x.DownFormatter
	}
	return PayloadFormatter_FORMATTER_NONE
}

func (x *MessagePayloadFormatters) GetDownFormatterParameter() string {
	if x != nil {
		return x.DownFormatterParameter
	}
	return ""
}

type DownlinkQueueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EndDeviceIds *EndDeviceIdentifiers  `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	Downlinks    []*ApplicationDownlink `protobuf:"bytes,2,rep,name=downlinks,proto3" json:"downlinks,omitempty"`
}

func (x *DownlinkQueueRequest) Reset() {
	*x = DownlinkQueueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownlinkQueueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownlinkQueueRequest) ProtoMessage() {}

func (x *DownlinkQueueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownlinkQueueRequest.ProtoReflect.Descriptor instead.
func (*DownlinkQueueRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{17}
}

func (x *DownlinkQueueRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *DownlinkQueueRequest) GetDownlinks() []*ApplicationDownlink {
	if x != nil {
		return x.Downlinks
	}
	return nil
}

type ApplicationDownlink_ClassBC struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Possible gateway identifiers, antenna index, and group index to use for this downlink message.
	// The Network Server selects one of these gateways for downlink, based on connectivity, signal quality, channel utilization and an available slot.
	// If none of the gateways can be selected, the downlink message fails.
	// If empty, a gateway and antenna is selected automatically from the gateways seen in recent uplinks.
	// If group index is set, gateways will be grouped by the index for the Network Server to select one gateway per group.
	Gateways []*ClassBCGatewayIdentifiers `protobuf:"bytes,7,rep,name=gateways,proto3" json:"gateways,omitempty"`
	// Absolute time when the downlink message should be transmitted.
	// This requires the gateway to have GPS time synchronization.
	// If the time is in the past or if there is a scheduling conflict, the downlink message fails.
	// If null, the time is selected based on slot availability. This is recommended in class B mode.
	AbsoluteTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=absolute_time,json=absoluteTime,proto3" json:"absolute_time,omitempty"`
}

func (x *ApplicationDownlink_ClassBC) Reset() {
	*x = ApplicationDownlink_ClassBC{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationDownlink_ClassBC) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationDownlink_ClassBC) ProtoMessage() {}

func (x *ApplicationDownlink_ClassBC) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationDownlink_ClassBC.ProtoReflect.Descriptor instead.
func (*ApplicationDownlink_ClassBC) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{9, 0}
}

func (x *ApplicationDownlink_ClassBC) GetGateways() []*ClassBCGatewayIdentifiers {
	if x != nil {
		return x.Gateways
	}
	return nil
}

func (x *ApplicationDownlink_ClassBC) GetAbsoluteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.AbsoluteTime
	}
	return nil
}

type ApplicationDownlink_ConfirmedRetry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of attempted confirmed downlink acknowledgements.
	Attempt uint32 `protobuf:"varint,1,opt,name=attempt,proto3" json:"attempt,omitempty"`
	// The maximum number of confirmed downlink acknowledgement attempts.
	// If null, the Application Server configuration is used instead.
	MaxAttempts *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=max_attempts,json=maxAttempts,proto3" json:"max_attempts,omitempty"`
}

func (x *ApplicationDownlink_ConfirmedRetry) Reset() {
	*x = ApplicationDownlink_ConfirmedRetry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationDownlink_ConfirmedRetry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationDownlink_ConfirmedRetry) ProtoMessage() {}

func (x *ApplicationDownlink_ConfirmedRetry) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_messages_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationDownlink_ConfirmedRetry.ProtoReflect.Descriptor instead.
func (*ApplicationDownlink_ConfirmedRetry) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_messages_proto_rawDescGZIP(), []int{9, 1}
}

func (x *ApplicationDownlink_ConfirmedRetry) GetAttempt() uint32 {
	if x != nil {
		return x.Attempt
	}
	return 0
}

func (x *ApplicationDownlink_ConfirmedRetry) GetMaxAttempts() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxAttempts
	}
	return nil
}

var File_ttn_lorawan_v3_messages_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_messages_proto_rawDesc = []byte{
	0x0a, 0x1d, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x0e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61,
	0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21,
	0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x6a, 0x73, 0x6f,
	0x6e, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2f, 0x76, 0x33, 0x2f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76,
	0x33, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x74, 0x74,
	0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x74, 0x74, 0x6e, 0x2f,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x9f, 0x04, 0x0a, 0x0d, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x61, 0x77, 0x5f, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x72, 0x61, 0x77, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x31, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x40, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x78, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x72, 0x78,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x52, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0a, 0x72, 0x78, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76,
	0x65, 0x64, 0x41, 0x74, 0x12, 0x35, 0x0a, 0x0f, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0c, 0xfa,
	0x42, 0x09, 0x92, 0x01, 0x06, 0x22, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x0e, 0x63, 0x6f, 0x72,
	0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x3a, 0x0a, 0x14, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03,
	0x18, 0xff, 0x01, 0x52, 0x12, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x44, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x64, 0x5f, 0x61, 0x69, 0x72, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x41, 0x69, 0x72, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x39, 0x0a,
	0x0a, 0x63, 0x72, 0x63, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x63,
	0x72, 0x63, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x4a, 0x04,
	0x08, 0x08, 0x10, 0x09, 0x22, 0x9c, 0x03, 0x0a, 0x0f, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e,
	0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x61, 0x77, 0x5f,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x72,
	0x61, 0x77, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x31, 0x0a, 0x07, 0x70, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x4a, 0x0a, 0x0e,
	0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x35, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x78, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3a, 0x0a, 0x09, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x54, 0x78, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00,
	0x52, 0x09, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x12, 0x35, 0x0a, 0x0f, 0x63,
	0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x0c, 0xfa, 0x42, 0x09, 0x92, 0x01, 0x06, 0x22, 0x04, 0x72, 0x02,
	0x18, 0x64, 0x52, 0x0e, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x73, 0x12, 0x2e, 0x0a, 0x0e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x7a,
	0x03, 0x18, 0x80, 0x10, 0x52, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x49, 0x64, 0x42, 0x0f, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x03,
	0xf8, 0x42, 0x01, 0x22, 0x89, 0x03, 0x0a, 0x10, 0x54, 0x78, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77,
	0x6c, 0x65, 0x64, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x0f, 0x63, 0x6f, 0x72, 0x72,
	0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x0c, 0xfa, 0x42, 0x09, 0x92, 0x01, 0x06, 0x22, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52,
	0x0e, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12,
	0x49, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x54, 0x78, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x4a, 0x0a, 0x10, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x06, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x00, 0x12, 0x11,
	0x0a, 0x0d, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x54, 0x4f, 0x4f, 0x5f, 0x4c, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12,
	0x0d, 0x0a, 0x09, 0x54, 0x4f, 0x4f, 0x5f, 0x45, 0x41, 0x52, 0x4c, 0x59, 0x10, 0x03, 0x12, 0x14,
	0x0a, 0x10, 0x43, 0x4f, 0x4c, 0x4c, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x43, 0x4b,
	0x45, 0x54, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4c, 0x4c, 0x49, 0x53, 0x49, 0x4f,
	0x4e, 0x5f, 0x42, 0x45, 0x41, 0x43, 0x4f, 0x4e, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x58,
	0x5f, 0x46, 0x52, 0x45, 0x51, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x54, 0x58, 0x5f, 0x50, 0x4f,
	0x57, 0x45, 0x52, 0x10, 0x07, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x50, 0x53, 0x5f, 0x55, 0x4e, 0x4c,
	0x4f, 0x43, 0x4b, 0x45, 0x44, 0x10, 0x08, 0x1a, 0x06, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0x22,
	0x97, 0x01, 0x0a, 0x17, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x54, 0x78, 0x41, 0x63, 0x6b,
	0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x0b, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x52, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73,
	0x12, 0x37, 0x0a, 0x06, 0x74, 0x78, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x54, 0x78, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x05, 0x74, 0x78, 0x41, 0x63, 0x6b, 0x22, 0x72, 0x0a, 0x14, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x41, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x62, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x61, 0x6e, 0x64, 0x49, 0x64, 0x22, 0x95, 0x09,
	0x0a, 0x11, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x12, 0x2e, 0x0a, 0x0e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b,
	0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0x7a, 0x03, 0x18, 0x80, 0x10, 0x52, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65,
	0x79, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x06, 0x66, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x2a, 0x06, 0x18, 0xff, 0x01, 0x38, 0xe0, 0x01,
	0x52, 0x05, 0x66, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x13, 0x0a, 0x05, 0x66, 0x5f, 0x63, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x66, 0x43, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b,
	0x66, 0x72, 0x6d, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0a, 0x66, 0x72, 0x6d, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x40, 0x0a,
	0x0f, 0x64, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x0e, 0x64, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12,
	0x38, 0x0a, 0x18, 0x64, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x16, 0x64, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x46, 0x0a, 0x12, 0x6e, 0x6f, 0x72,
	0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18,
	0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x11,
	0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x12, 0x3e, 0x0a, 0x1b, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x12, 0x20, 0x03, 0x28, 0x09, 0x52, 0x19, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x72, 0x78, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x0a, 0x72, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40,
	0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x54, 0x78, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x3b, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x41, 0x74, 0x12, 0x37, 0x0a,
	0x09, 0x61, 0x70, 0x70, 0x5f, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x52, 0x07, 0x61,
	0x70, 0x70, 0x53, 0x4b, 0x65, 0x79, 0x12, 0x28, 0x0a, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x61,
	0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0d, 0x6c, 0x61, 0x73, 0x74, 0x41, 0x46, 0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77, 0x6e,
	0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x12, 0x44,
	0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x5f, 0x61, 0x69, 0x72, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x41, 0x69, 0x72,
	0x74, 0x69, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x0f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x61, 0x74, 0x65,
	0x12, 0x4e, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x4c, 0x0a, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x73, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x43,
	0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x49, 0x64, 0x73, 0x1a, 0x56, 0x0a, 0x0e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19,
	0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0xb4, 0x07, 0x0a, 0x1b, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4e, 0x6f, 0x72, 0x6d, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x12, 0x2e, 0x0a, 0x0e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x7a, 0x03, 0x18, 0x80, 0x10, 0x52, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x06, 0x66, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x0d, 0xfa, 0x42, 0x0a, 0x2a, 0x08, 0x18, 0xff, 0x01, 0x28,
	0x01, 0x38, 0xe0, 0x01, 0x52, 0x05, 0x66, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x13, 0x0a, 0x05, 0x66,
	0x5f, 0x63, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x66, 0x43, 0x6e, 0x74,
	0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x72, 0x6d, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x66, 0x72, 0x6d, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x12, 0x50, 0x0a, 0x12, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x11, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x12, 0x3e, 0x0a, 0x1b, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x19, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x57, 0x61, 0x72, 0x6e, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x72, 0x78, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x78, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x0a, 0x72, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x40, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x54, 0x78, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x45, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x61,
	0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x08, 0xfa, 0x42, 0x05, 0xb2, 0x01, 0x02, 0x08, 0x01, 0x52, 0x0a, 0x72,
	0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x41, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x12, 0x44, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x64, 0x5f, 0x61, 0x69, 0x72, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x41, 0x69, 0x72, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a,
	0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x43, 0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x0a,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x73, 0x1a, 0x56, 0x0a, 0x0e, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x00, 0x22, 0xc5, 0x02, 0x0a,
	0x13, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x3e,
	0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x18, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8a,
	0x01, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x35, 0xfa, 0x42, 0x32, 0x9a, 0x01, 0x2f,
	0x10, 0x0a, 0x22, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30,
	0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d,
	0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x2a, 0x05, 0x72, 0x03, 0x18, 0xc8, 0x01, 0x52,
	0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04,
	0x08, 0x01, 0x10, 0x00, 0x22, 0xd4, 0x02, 0x0a, 0x15, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x12, 0x2e,
	0x0a, 0x0e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x7a, 0x03, 0x18, 0x80, 0x10,
	0x52, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x37,
	0x0a, 0x09, 0x61, 0x70, 0x70, 0x5f, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x52, 0x07,
	0x61, 0x70, 0x70, 0x53, 0x4b, 0x65, 0x79, 0x12, 0x58, 0x0a, 0x15, 0x69, 0x6e, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x14, 0x69, 0x6e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b,
	0x73, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x70, 0x65, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x0b, 0x72, 0x65,
	0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0xb2, 0x01, 0x02, 0x08, 0x01, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x41,
	0x74, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x00, 0x22, 0xd5, 0x09, 0x0a, 0x13,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c,
	0x69, 0x6e, 0x6b, 0x12, 0xcd, 0x01, 0x0a, 0x0e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xa6, 0x01, 0xfa,
	0x42, 0x05, 0x7a, 0x03, 0x18, 0x80, 0x10, 0xf2, 0xaa, 0x19, 0x99, 0x01, 0x1a, 0x4e, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x68, 0x65, 0x54, 0x68, 0x69, 0x6e,
	0x67, 0x73, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f, 0x2d, 0x66, 0x6c, 0x61, 0x67, 0x73,
	0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x4e, 0x65, 0x77,
	0x48, 0x65, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x47, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x68, 0x65, 0x54, 0x68, 0x69, 0x6e,
	0x67, 0x73, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f, 0x2d, 0x66, 0x6c, 0x61, 0x67, 0x73,
	0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x47, 0x65, 0x74,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65,
	0x79, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x06, 0x66, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x2a, 0x06, 0x18, 0xff, 0x01, 0x38, 0xe0, 0x01,
	0x52, 0x05, 0x66, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x13, 0x0a, 0x05, 0x66, 0x5f, 0x63, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x66, 0x43, 0x6e, 0x74, 0x12, 0xc8, 0x01, 0x0a,
	0x0b, 0x66, 0x72, 0x6d, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0c, 0x42, 0xa6, 0x01, 0xfa, 0x42, 0x05, 0x7a, 0x03, 0x18, 0xff, 0x01, 0xf2, 0xaa, 0x19,
	0x99, 0x01, 0x1a, 0x4e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54,
	0x68, 0x65, 0x54, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f,
	0x2d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x2e, 0x4e, 0x65, 0x77, 0x48, 0x65, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c,
	0x61, 0x67, 0x22, 0x47, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54,
	0x68, 0x65, 0x54, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f,
	0x2d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x0a, 0x66, 0x72, 0x6d,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x40, 0x0a, 0x0f, 0x64, 0x65, 0x63, 0x6f, 0x64,
	0x65, 0x64, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x64, 0x65, 0x63, 0x6f, 0x64,
	0x65, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x38, 0x0a, 0x18, 0x64, 0x65, 0x63,
	0x6f, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x77, 0x61, 0x72,
	0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16, 0x64, 0x65, 0x63,
	0x6f, 0x64, 0x65, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x57, 0x61, 0x72, 0x6e, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65,
	0x64, 0x12, 0x47, 0x0a, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x62, 0x5f, 0x63, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x42,
	0x43, 0x52, 0x07, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x43, 0x12, 0x48, 0x0a, 0x08, 0x70, 0x72,
	0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x78,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x12, 0x35, 0x0a, 0x0f, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0c, 0xfa,
	0x42, 0x09, 0x92, 0x01, 0x06, 0x22, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x0e, 0x63, 0x6f, 0x72,
	0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x5b, 0x0a, 0x0f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x79, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x72,
	0x6d, 0x65, 0x64, 0x52, 0x65, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72,
	0x6d, 0x65, 0x64, 0x52, 0x65, 0x74, 0x72, 0x79, 0x1a, 0x9b, 0x01, 0x0a, 0x07, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x42, 0x43, 0x12, 0x45, 0x0a, 0x08, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x43, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x52, 0x08, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x12, 0x3f, 0x0a, 0x0d, 0x61,
	0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c,
	0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x08, 0xf2, 0xaa,
	0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x1a, 0x80, 0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x72, 0x6d, 0x65, 0x64, 0x52, 0x65, 0x74, 0x72, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x74, 0x74,
	0x65, 0x6d, 0x70, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x61, 0x74, 0x74, 0x65,
	0x6d, 0x70, 0x74, 0x12, 0x4a, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d,
	0x70, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74,
	0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x09, 0xfa, 0x42, 0x06, 0x2a, 0x04, 0x18, 0x64,
	0x20, 0x00, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x3a,
	0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08,
	0x01, 0x10, 0x01, 0x22, 0x59, 0x0a, 0x14, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x41, 0x0a, 0x09, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c,
	0x69, 0x6e, 0x6b, 0x52, 0x09, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0xae,
	0x01, 0x0a, 0x19, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x12, 0x49, 0x0a, 0x08,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c,
	0x69, 0x6e, 0x6b, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x3c, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x00, 0x22,
	0xc5, 0x01, 0x0a, 0x1f, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69,
	0x6e, 0x6b, 0x73, 0x12, 0x41, 0x0a, 0x09, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x09, 0x64, 0x6f, 0x77,
	0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x25, 0x0a, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x66,
	0x5f, 0x63, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0c, 0x6c, 0x61, 0x73, 0x74, 0x46, 0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x12, 0x2e, 0x0a,
	0x0e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x7a, 0x03, 0x18, 0x80, 0x10, 0x52,
	0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x3a, 0x08, 0xf2,
	0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x00, 0x22, 0x91, 0x05, 0x0a, 0x22, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x51, 0x75, 0x65, 0x75, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0xc8,
	0x01, 0x0a, 0x08, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x42, 0xac, 0x01, 0x92, 0x41, 0x19, 0x4a, 0x0a, 0x22, 0x32, 0x36, 0x30, 0x30, 0x41, 0x42,
	0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x04, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f,
	0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e,
	0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12,
	0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x34, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x52, 0x07, 0x64, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x12, 0x2e, 0x0a, 0x0e, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x7a, 0x03, 0x18, 0x80, 0x10, 0x52, 0x0c, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0e, 0x6d, 0x69, 0x6e,
	0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0b, 0x6d, 0x69, 0x6e, 0x46, 0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x12, 0xd7,
	0x01, 0x0a, 0x10, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x65, 0x76, 0x5f, 0x61,
	0x64, 0x64, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xac, 0x01, 0x92, 0x41, 0x19, 0x4a,
	0x0a, 0x22, 0x32, 0x36, 0x30, 0x30, 0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2,
	0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x04, 0x70,
	0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b,
	0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48,
	0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70,
	0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68,
	0x61, 0x6c, 0x34, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x0e, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x44, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x12, 0x3d, 0x0a, 0x16, 0x70, 0x65, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x7a, 0x03, 0x18,
	0x80, 0x10, 0x52, 0x13, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x16, 0x70, 0x65, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x77,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x12, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x4d, 0x69, 0x6e, 0x46, 0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x22, 0x69, 0x0a, 0x16, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x2b, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x3a, 0x08, 0xf2, 0xaa,
	0x19, 0x04, 0x08, 0x01, 0x10, 0x00, 0x22, 0x94, 0x09, 0x0a, 0x0d, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x12, 0x54, 0x0a, 0x0e, 0x65, 0x6e, 0x64, 0x5f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x0c, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x35,
	0x0a, 0x0f, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0c, 0xfa, 0x42, 0x09, 0x92, 0x01, 0x06, 0x22,
	0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x0e, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65,
	0x64, 0x5f, 0x61, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64,
	0x41, 0x74, 0x12, 0x4a, 0x0a, 0x0e, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x48, 0x00, 0x52,
	0x0d, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x5a,
	0x0a, 0x11, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4e, 0x6f, 0x72, 0x6d,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x48, 0x00, 0x52, 0x10, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x12, 0x48, 0x0a, 0x0b, 0x6a, 0x6f,
	0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x69, 0x6e,
	0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x6a, 0x6f, 0x69, 0x6e, 0x41, 0x63,
	0x63, 0x65, 0x70, 0x74, 0x12, 0x48, 0x0a, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b,
	0x5f, 0x61, 0x63, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x48,
	0x00, 0x52, 0x0b, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x41, 0x63, 0x6b, 0x12, 0x4a,
	0x0a, 0x0d, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6e, 0x61, 0x63, 0x6b, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x48, 0x00, 0x52, 0x0c, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x4e, 0x61, 0x63, 0x6b, 0x12, 0x4a, 0x0a, 0x0d, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x48, 0x00, 0x52, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69,
	0x6e, 0x6b, 0x53, 0x65, 0x6e, 0x74, 0x12, 0x54, 0x0a, 0x0f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69,
	0x6e, 0x6b, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0e, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x12, 0x4e, 0x0a, 0x0f,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x48, 0x00, 0x52, 0x0e, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x51, 0x75, 0x65, 0x75, 0x65, 0x64, 0x12, 0x6f, 0x0a, 0x1a,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f, 0x69,
	0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b,
	0x73, 0x48, 0x00, 0x52, 0x18, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x51, 0x75, 0x65,
	0x75, 0x65, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x12, 0x4e, 0x0a,
	0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x12, 0x4b, 0x0a,
	0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73,
	0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01,
	0x10, 0x00, 0x42, 0x09, 0x0a, 0x02, 0x75, 0x70, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x22, 0xcc, 0x02,
	0x0a, 0x18, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4d, 0x0a, 0x0c, 0x75, 0x70,
	0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x20, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0b, 0x75, 0x70,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x12, 0x3f, 0x0a, 0x16, 0x75, 0x70, 0x5f,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xfa, 0x42, 0x06, 0x72, 0x04,
	0x18, 0x80, 0xc0, 0x02, 0x52, 0x14, 0x75, 0x70, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65,
	0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x51, 0x0a, 0x0e, 0x64, 0x6f,
	0x77, 0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x20, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x74, 0x65, 0x72, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0d,
	0x64, 0x6f, 0x77, 0x6e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x12, 0x43, 0x0a,
	0x18, 0x64, 0x6f, 0x77, 0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x09, 0xfa, 0x42, 0x06, 0x72, 0x04, 0x18, 0x80, 0xc0, 0x02, 0x52, 0x16, 0x64, 0x6f, 0x77, 0x6e,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0xbb, 0x01, 0x0a,
	0x14, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45,
	0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x65,
	0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x4d, 0x0a, 0x09, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c,
	0x69, 0x6e, 0x6b, 0x42, 0x0a, 0xfa, 0x42, 0x07, 0x92, 0x01, 0x04, 0x10, 0xa0, 0x8d, 0x06, 0x52,
	0x09, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x2a, 0xa3, 0x01, 0x0a, 0x10, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x12,
	0x12, 0x0a, 0x0e, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x54, 0x45, 0x52, 0x5f, 0x4e, 0x4f, 0x4e,
	0x45, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x54, 0x45, 0x52,
	0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x10, 0x01, 0x12, 0x1a, 0x0a,
	0x16, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x54, 0x45, 0x52, 0x5f, 0x47, 0x52, 0x50, 0x43, 0x5f,
	0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x46, 0x4f, 0x52,
	0x4d, 0x41, 0x54, 0x54, 0x45, 0x52, 0x5f, 0x4a, 0x41, 0x56, 0x41, 0x53, 0x43, 0x52, 0x49, 0x50,
	0x54, 0x10, 0x03, 0x12, 0x18, 0x0a, 0x14, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x54, 0x45, 0x52,
	0x5f, 0x43, 0x41, 0x59, 0x45, 0x4e, 0x4e, 0x45, 0x4c, 0x50, 0x50, 0x10, 0x04, 0x1a, 0x11, 0xea,
	0xaa, 0x19, 0x0d, 0x18, 0x01, 0x2a, 0x09, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x54, 0x45, 0x52,
	0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74,
	0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_messages_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_messages_proto_rawDescData = file_ttn_lorawan_v3_messages_proto_rawDesc
)

func file_ttn_lorawan_v3_messages_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_messages_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_messages_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_messages_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_messages_proto_rawDescData
}

var file_ttn_lorawan_v3_messages_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_ttn_lorawan_v3_messages_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_ttn_lorawan_v3_messages_proto_goTypes = []interface{}{
	(PayloadFormatter)(0),                      // 0: ttn.lorawan.v3.PayloadFormatter
	(TxAcknowledgment_Result)(0),               // 1: ttn.lorawan.v3.TxAcknowledgment.Result
	(*UplinkMessage)(nil),                      // 2: ttn.lorawan.v3.UplinkMessage
	(*DownlinkMessage)(nil),                    // 3: ttn.lorawan.v3.DownlinkMessage
	(*TxAcknowledgment)(nil),                   // 4: ttn.lorawan.v3.TxAcknowledgment
	(*GatewayTxAcknowledgment)(nil),            // 5: ttn.lorawan.v3.GatewayTxAcknowledgment
	(*GatewayUplinkMessage)(nil),               // 6: ttn.lorawan.v3.GatewayUplinkMessage
	(*ApplicationUplink)(nil),                  // 7: ttn.lorawan.v3.ApplicationUplink
	(*ApplicationUplinkNormalized)(nil),        // 8: ttn.lorawan.v3.ApplicationUplinkNormalized
	(*ApplicationLocation)(nil),                // 9: ttn.lorawan.v3.ApplicationLocation
	(*ApplicationJoinAccept)(nil),              // 10: ttn.lorawan.v3.ApplicationJoinAccept
	(*ApplicationDownlink)(nil),                // 11: ttn.lorawan.v3.ApplicationDownlink
	(*ApplicationDownlinks)(nil),               // 12: ttn.lorawan.v3.ApplicationDownlinks
	(*ApplicationDownlinkFailed)(nil),          // 13: ttn.lorawan.v3.ApplicationDownlinkFailed
	(*ApplicationInvalidatedDownlinks)(nil),    // 14: ttn.lorawan.v3.ApplicationInvalidatedDownlinks
	(*DownlinkQueueOperationErrorDetails)(nil), // 15: ttn.lorawan.v3.DownlinkQueueOperationErrorDetails
	(*ApplicationServiceData)(nil),             // 16: ttn.lorawan.v3.ApplicationServiceData
	(*ApplicationUp)(nil),                      // 17: ttn.lorawan.v3.ApplicationUp
	(*MessagePayloadFormatters)(nil),           // 18: ttn.lorawan.v3.MessagePayloadFormatters
	(*DownlinkQueueRequest)(nil),               // 19: ttn.lorawan.v3.DownlinkQueueRequest
	nil,                                        // 20: ttn.lorawan.v3.ApplicationUplink.LocationsEntry
	nil,                                        // 21: ttn.lorawan.v3.ApplicationUplinkNormalized.LocationsEntry
	nil,                                        // 22: ttn.lorawan.v3.ApplicationLocation.AttributesEntry
	(*ApplicationDownlink_ClassBC)(nil),        // 23: ttn.lorawan.v3.ApplicationDownlink.ClassBC
	(*ApplicationDownlink_ConfirmedRetry)(nil), // 24: ttn.lorawan.v3.ApplicationDownlink.ConfirmedRetry
	(*Message)(nil),                            // 25: ttn.lorawan.v3.Message
	(*TxSettings)(nil),                         // 26: ttn.lorawan.v3.TxSettings
	(*RxMetadata)(nil),                         // 27: ttn.lorawan.v3.RxMetadata
	(*timestamppb.Timestamp)(nil),              // 28: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                // 29: google.protobuf.Duration
	(*wrapperspb.BoolValue)(nil),               // 30: google.protobuf.BoolValue
	(*EndDeviceIdentifiers)(nil),               // 31: ttn.lorawan.v3.EndDeviceIdentifiers
	(*TxRequest)(nil),                          // 32: ttn.lorawan.v3.TxRequest
	(*GatewayIdentifiers)(nil),                 // 33: ttn.lorawan.v3.GatewayIdentifiers
	(*structpb.Struct)(nil),                    // 34: google.protobuf.Struct
	(*KeyEnvelope)(nil),                        // 35: ttn.lorawan.v3.KeyEnvelope
	(*EndDeviceVersionIdentifiers)(nil),        // 36: ttn.lorawan.v3.EndDeviceVersionIdentifiers
	(*NetworkIdentifiers)(nil),                 // 37: ttn.lorawan.v3.NetworkIdentifiers
	(*Location)(nil),                           // 38: ttn.lorawan.v3.Location
	(TxSchedulePriority)(0),                    // 39: ttn.lorawan.v3.TxSchedulePriority
	(*ErrorDetails)(nil),                       // 40: ttn.lorawan.v3.ErrorDetails
	(*ClassBCGatewayIdentifiers)(nil),          // 41: ttn.lorawan.v3.ClassBCGatewayIdentifiers
	(*wrapperspb.UInt32Value)(nil),             // 42: google.protobuf.UInt32Value
}
var file_ttn_lorawan_v3_messages_proto_depIdxs = []int32{
	25, // 0: ttn.lorawan.v3.UplinkMessage.payload:type_name -> ttn.lorawan.v3.Message
	26, // 1: ttn.lorawan.v3.UplinkMessage.settings:type_name -> ttn.lorawan.v3.TxSettings
	27, // 2: ttn.lorawan.v3.UplinkMessage.rx_metadata:type_name -> ttn.lorawan.v3.RxMetadata
	28, // 3: ttn.lorawan.v3.UplinkMessage.received_at:type_name -> google.protobuf.Timestamp
	29, // 4: ttn.lorawan.v3.UplinkMessage.consumed_airtime:type_name -> google.protobuf.Duration
	30, // 5: ttn.lorawan.v3.UplinkMessage.crc_status:type_name -> google.protobuf.BoolValue
	25, // 6: ttn.lorawan.v3.DownlinkMessage.payload:type_name -> ttn.lorawan.v3.Message
	31, // 7: ttn.lorawan.v3.DownlinkMessage.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	32, // 8: ttn.lorawan.v3.DownlinkMessage.request:type_name -> ttn.lorawan.v3.TxRequest
	26, // 9: ttn.lorawan.v3.DownlinkMessage.scheduled:type_name -> ttn.lorawan.v3.TxSettings
	1,  // 10: ttn.lorawan.v3.TxAcknowledgment.result:type_name -> ttn.lorawan.v3.TxAcknowledgment.Result
	3,  // 11: ttn.lorawan.v3.TxAcknowledgment.downlink_message:type_name -> ttn.lorawan.v3.DownlinkMessage
	33, // 12: ttn.lorawan.v3.GatewayTxAcknowledgment.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	4,  // 13: ttn.lorawan.v3.GatewayTxAcknowledgment.tx_ack:type_name -> ttn.lorawan.v3.TxAcknowledgment
	2,  // 14: ttn.lorawan.v3.GatewayUplinkMessage.message:type_name -> ttn.lorawan.v3.UplinkMessage
	34, // 15: ttn.lorawan.v3.ApplicationUplink.decoded_payload:type_name -> google.protobuf.Struct
	34, // 16: ttn.lorawan.v3.ApplicationUplink.normalized_payload:type_name -> google.protobuf.Struct
	27, // 17: ttn.lorawan.v3.ApplicationUplink.rx_metadata:type_name -> ttn.lorawan.v3.RxMetadata
	26, // 18: ttn.lorawan.v3.ApplicationUplink.settings:type_name -> ttn.lorawan.v3.TxSettings
	28, // 19: ttn.lorawan.v3.ApplicationUplink.received_at:type_name -> google.protobuf.Timestamp
	35, // 20: ttn.lorawan.v3.ApplicationUplink.app_s_key:type_name -> ttn.lorawan.v3.KeyEnvelope
	29, // 21: ttn.lorawan.v3.ApplicationUplink.consumed_airtime:type_name -> google.protobuf.Duration
	20, // 22: ttn.lorawan.v3.ApplicationUplink.locations:type_name -> ttn.lorawan.v3.ApplicationUplink.LocationsEntry
	36, // 23: ttn.lorawan.v3.ApplicationUplink.version_ids:type_name -> ttn.lorawan.v3.EndDeviceVersionIdentifiers
	37, // 24: ttn.lorawan.v3.ApplicationUplink.network_ids:type_name -> ttn.lorawan.v3.NetworkIdentifiers
	34, // 25: ttn.lorawan.v3.ApplicationUplinkNormalized.normalized_payload:type_name -> google.protobuf.Struct
	27, // 26: ttn.lorawan.v3.ApplicationUplinkNormalized.rx_metadata:type_name -> ttn.lorawan.v3.RxMetadata
	26, // 27: ttn.lorawan.v3.ApplicationUplinkNormalized.settings:type_name -> ttn.lorawan.v3.TxSettings
	28, // 28: ttn.lorawan.v3.ApplicationUplinkNormalized.received_at:type_name -> google.protobuf.Timestamp
	29, // 29: ttn.lorawan.v3.ApplicationUplinkNormalized.consumed_airtime:type_name -> google.protobuf.Duration
	21, // 30: ttn.lorawan.v3.ApplicationUplinkNormalized.locations:type_name -> ttn.lorawan.v3.ApplicationUplinkNormalized.LocationsEntry
	36, // 31: ttn.lorawan.v3.ApplicationUplinkNormalized.version_ids:type_name -> ttn.lorawan.v3.EndDeviceVersionIdentifiers
	37, // 32: ttn.lorawan.v3.ApplicationUplinkNormalized.network_ids:type_name -> ttn.lorawan.v3.NetworkIdentifiers
	38, // 33: ttn.lorawan.v3.ApplicationLocation.location:type_name -> ttn.lorawan.v3.Location
	22, // 34: ttn.lorawan.v3.ApplicationLocation.attributes:type_name -> ttn.lorawan.v3.ApplicationLocation.AttributesEntry
	35, // 35: ttn.lorawan.v3.ApplicationJoinAccept.app_s_key:type_name -> ttn.lorawan.v3.KeyEnvelope
	11, // 36: ttn.lorawan.v3.ApplicationJoinAccept.invalidated_downlinks:type_name -> ttn.lorawan.v3.ApplicationDownlink
	28, // 37: ttn.lorawan.v3.ApplicationJoinAccept.received_at:type_name -> google.protobuf.Timestamp
	34, // 38: ttn.lorawan.v3.ApplicationDownlink.decoded_payload:type_name -> google.protobuf.Struct
	23, // 39: ttn.lorawan.v3.ApplicationDownlink.class_b_c:type_name -> ttn.lorawan.v3.ApplicationDownlink.ClassBC
	39, // 40: ttn.lorawan.v3.ApplicationDownlink.priority:type_name -> ttn.lorawan.v3.TxSchedulePriority
	24, // 41: ttn.lorawan.v3.ApplicationDownlink.confirmed_retry:type_name -> ttn.lorawan.v3.ApplicationDownlink.ConfirmedRetry
	11, // 42: ttn.lorawan.v3.ApplicationDownlinks.downlinks:type_name -> ttn.lorawan.v3.ApplicationDownlink
	11, // 43: ttn.lorawan.v3.ApplicationDownlinkFailed.downlink:type_name -> ttn.lorawan.v3.ApplicationDownlink
	40, // 44: ttn.lorawan.v3.ApplicationDownlinkFailed.error:type_name -> ttn.lorawan.v3.ErrorDetails
	11, // 45: ttn.lorawan.v3.ApplicationInvalidatedDownlinks.downlinks:type_name -> ttn.lorawan.v3.ApplicationDownlink
	34, // 46: ttn.lorawan.v3.ApplicationServiceData.data:type_name -> google.protobuf.Struct
	31, // 47: ttn.lorawan.v3.ApplicationUp.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	28, // 48: ttn.lorawan.v3.ApplicationUp.received_at:type_name -> google.protobuf.Timestamp
	7,  // 49: ttn.lorawan.v3.ApplicationUp.uplink_message:type_name -> ttn.lorawan.v3.ApplicationUplink
	8,  // 50: ttn.lorawan.v3.ApplicationUp.uplink_normalized:type_name -> ttn.lorawan.v3.ApplicationUplinkNormalized
	10, // 51: ttn.lorawan.v3.ApplicationUp.join_accept:type_name -> ttn.lorawan.v3.ApplicationJoinAccept
	11, // 52: ttn.lorawan.v3.ApplicationUp.downlink_ack:type_name -> ttn.lorawan.v3.ApplicationDownlink
	11, // 53: ttn.lorawan.v3.ApplicationUp.downlink_nack:type_name -> ttn.lorawan.v3.ApplicationDownlink
	11, // 54: ttn.lorawan.v3.ApplicationUp.downlink_sent:type_name -> ttn.lorawan.v3.ApplicationDownlink
	13, // 55: ttn.lorawan.v3.ApplicationUp.downlink_failed:type_name -> ttn.lorawan.v3.ApplicationDownlinkFailed
	11, // 56: ttn.lorawan.v3.ApplicationUp.downlink_queued:type_name -> ttn.lorawan.v3.ApplicationDownlink
	14, // 57: ttn.lorawan.v3.ApplicationUp.downlink_queue_invalidated:type_name -> ttn.lorawan.v3.ApplicationInvalidatedDownlinks
	9,  // 58: ttn.lorawan.v3.ApplicationUp.location_solved:type_name -> ttn.lorawan.v3.ApplicationLocation
	16, // 59: ttn.lorawan.v3.ApplicationUp.service_data:type_name -> ttn.lorawan.v3.ApplicationServiceData
	0,  // 60: ttn.lorawan.v3.MessagePayloadFormatters.up_formatter:type_name -> ttn.lorawan.v3.PayloadFormatter
	0,  // 61: ttn.lorawan.v3.MessagePayloadFormatters.down_formatter:type_name -> ttn.lorawan.v3.PayloadFormatter
	31, // 62: ttn.lorawan.v3.DownlinkQueueRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	11, // 63: ttn.lorawan.v3.DownlinkQueueRequest.downlinks:type_name -> ttn.lorawan.v3.ApplicationDownlink
	38, // 64: ttn.lorawan.v3.ApplicationUplink.LocationsEntry.value:type_name -> ttn.lorawan.v3.Location
	38, // 65: ttn.lorawan.v3.ApplicationUplinkNormalized.LocationsEntry.value:type_name -> ttn.lorawan.v3.Location
	41, // 66: ttn.lorawan.v3.ApplicationDownlink.ClassBC.gateways:type_name -> ttn.lorawan.v3.ClassBCGatewayIdentifiers
	28, // 67: ttn.lorawan.v3.ApplicationDownlink.ClassBC.absolute_time:type_name -> google.protobuf.Timestamp
	42, // 68: ttn.lorawan.v3.ApplicationDownlink.ConfirmedRetry.max_attempts:type_name -> google.protobuf.UInt32Value
	69, // [69:69] is the sub-list for method output_type
	69, // [69:69] is the sub-list for method input_type
	69, // [69:69] is the sub-list for extension type_name
	69, // [69:69] is the sub-list for extension extendee
	0,  // [0:69] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_messages_proto_init() }
func file_ttn_lorawan_v3_messages_proto_init() {
	if File_ttn_lorawan_v3_messages_proto != nil {
		return
	}
	file_ttn_lorawan_v3_error_proto_init()
	file_ttn_lorawan_v3_identifiers_proto_init()
	file_ttn_lorawan_v3_keys_proto_init()
	file_ttn_lorawan_v3_lorawan_proto_init()
	file_ttn_lorawan_v3_metadata_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_messages_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UplinkMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DownlinkMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TxAcknowledgment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayTxAcknowledgment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayUplinkMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationUplink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationUplinkNormalized); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationJoinAccept); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationDownlink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationDownlinks); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationDownlinkFailed); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationInvalidatedDownlinks); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DownlinkQueueOperationErrorDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationServiceData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationUp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessagePayloadFormatters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DownlinkQueueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationDownlink_ClassBC); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_messages_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationDownlink_ConfirmedRetry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_ttn_lorawan_v3_messages_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*DownlinkMessage_Request)(nil),
		(*DownlinkMessage_Scheduled)(nil),
	}
	file_ttn_lorawan_v3_messages_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*ApplicationUp_UplinkMessage)(nil),
		(*ApplicationUp_UplinkNormalized)(nil),
		(*ApplicationUp_JoinAccept)(nil),
		(*ApplicationUp_DownlinkAck)(nil),
		(*ApplicationUp_DownlinkNack)(nil),
		(*ApplicationUp_DownlinkSent)(nil),
		(*ApplicationUp_DownlinkFailed)(nil),
		(*ApplicationUp_DownlinkQueued)(nil),
		(*ApplicationUp_DownlinkQueueInvalidated)(nil),
		(*ApplicationUp_LocationSolved)(nil),
		(*ApplicationUp_ServiceData)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_messages_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ttn_lorawan_v3_messages_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_messages_proto_depIdxs,
		EnumInfos:         file_ttn_lorawan_v3_messages_proto_enumTypes,
		MessageInfos:      file_ttn_lorawan_v3_messages_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_messages_proto = out.File
	file_ttn_lorawan_v3_messages_proto_rawDesc = nil
	file_ttn_lorawan_v3_messages_proto_goTypes = nil
	file_ttn_lorawan_v3_messages_proto_depIdxs = nil
}
