// Code generated by protoc-gen-go-flags. DO NOT EDIT.
// versions:
// - protoc-gen-go-flags v1.2.0
// - protoc              v4.23.4
// source: ttn/lorawan/v3/lorawan.proto

package ttnpb

import (
	flagsplugin "github.com/TheThingsIndustries/protoc-gen-go-flags/flagsplugin"
	golang "github.com/TheThingsIndustries/protoc-gen-go-flags/golang"
	pflag "github.com/spf13/pflag"
	customflags "go.thethings.network/lorawan-stack/v3/cmd/ttn-lw-cli/customflags"
)

// AddSelectFlagsForFHDR adds flags to select fields in FHDR.
func AddSelectFlagsForFHDR(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("dev-addr", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("dev-addr", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("f-ctrl", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("f-ctrl", prefix), true), flagsplugin.WithHidden(hidden)))
	// NOTE: f_ctrl (FCtrl) does not seem to have select flags.
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("f-cnt", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("f-cnt", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("f-opts", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("f-opts", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forFHDR message from select flags.
func PathsFromSelectFlagsForFHDR(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("dev_addr", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("dev_addr", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("f_ctrl", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("f_ctrl", prefix))
	}
	// NOTE: f_ctrl (FCtrl) does not seem to have select flags.
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("f_cnt", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("f_cnt", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("f_opts", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("f_opts", prefix))
	}
	return paths, nil
}

// AddSetFlagsForFHDR adds flags to select fields in FHDR.
func AddSetFlagsForFHDR(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(customflags.New4BytesFlag(flagsplugin.Prefix("dev-addr", prefix), "", flagsplugin.WithHidden(hidden)))
	// FIXME: Skipping FCtrl because it does not seem to implement AddSetFlags.
	flags.AddFlag(flagsplugin.NewUint32Flag(flagsplugin.Prefix("f-cnt", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBytesFlag(flagsplugin.Prefix("f-opts", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the FHDR message from flags.
func (m *FHDR) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := customflags.GetExactBytes(flags, flagsplugin.Prefix("dev_addr", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.DevAddr = val
		paths = append(paths, flagsplugin.Prefix("dev_addr", prefix))
	}
	// FIXME: Skipping FCtrl because it does not seem to implement AddSetFlags.
	if val, changed, err := flagsplugin.GetUint32(flags, flagsplugin.Prefix("f_cnt", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.FCnt = val
		paths = append(paths, flagsplugin.Prefix("f_cnt", prefix))
	}
	if val, changed, err := flagsplugin.GetBytes(flags, flagsplugin.Prefix("f_opts", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.FOpts = val
		paths = append(paths, flagsplugin.Prefix("f_opts", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForJoinRequestPayload adds flags to select fields in JoinRequestPayload.
func AddSelectFlagsForJoinRequestPayload(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("join-eui", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("join-eui", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("dev-eui", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("dev-eui", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("dev-nonce", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("dev-nonce", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forJoinRequestPayload message from select flags.
func PathsFromSelectFlagsForJoinRequestPayload(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("join_eui", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("join_eui", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("dev_eui", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("dev_eui", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("dev_nonce", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("dev_nonce", prefix))
	}
	return paths, nil
}

// AddSetFlagsForJoinRequestPayload adds flags to select fields in JoinRequestPayload.
func AddSetFlagsForJoinRequestPayload(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(customflags.New8BytesFlag(flagsplugin.Prefix("join-eui", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(customflags.New8BytesFlag(flagsplugin.Prefix("dev-eui", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(customflags.New2BytesFlag(flagsplugin.Prefix("dev-nonce", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the JoinRequestPayload message from flags.
func (m *JoinRequestPayload) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := customflags.GetExactBytes(flags, flagsplugin.Prefix("join_eui", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.JoinEui = val
		paths = append(paths, flagsplugin.Prefix("join_eui", prefix))
	}
	if val, changed, err := customflags.GetExactBytes(flags, flagsplugin.Prefix("dev_eui", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.DevEui = val
		paths = append(paths, flagsplugin.Prefix("dev_eui", prefix))
	}
	if val, changed, err := customflags.GetExactBytes(flags, flagsplugin.Prefix("dev_nonce", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.DevNonce = val
		paths = append(paths, flagsplugin.Prefix("dev_nonce", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForRejoinRequestPayload adds flags to select fields in RejoinRequestPayload.
func AddSelectFlagsForRejoinRequestPayload(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("rejoin-type", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("rejoin-type", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("net-id", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("net-id", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("join-eui", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("join-eui", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("dev-eui", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("dev-eui", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("rejoin-cnt", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("rejoin-cnt", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forRejoinRequestPayload message from select flags.
func PathsFromSelectFlagsForRejoinRequestPayload(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("rejoin_type", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("rejoin_type", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("net_id", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("net_id", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("join_eui", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("join_eui", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("dev_eui", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("dev_eui", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("rejoin_cnt", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("rejoin_cnt", prefix))
	}
	return paths, nil
}

// AddSetFlagsForRejoinRequestPayload adds flags to select fields in RejoinRequestPayload.
func AddSetFlagsForRejoinRequestPayload(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("rejoin-type", prefix), flagsplugin.EnumValueDesc(RejoinRequestType_value), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(customflags.New3BytesFlag(flagsplugin.Prefix("net-id", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(customflags.New8BytesFlag(flagsplugin.Prefix("join-eui", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(customflags.New8BytesFlag(flagsplugin.Prefix("dev-eui", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewUint32Flag(flagsplugin.Prefix("rejoin-cnt", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the RejoinRequestPayload message from flags.
func (m *RejoinRequestPayload) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("rejoin_type", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, RejoinRequestType_value)
		if err != nil {
			return nil, err
		}
		m.RejoinType = RejoinRequestType(enumValue)
		paths = append(paths, flagsplugin.Prefix("rejoin_type", prefix))
	}
	if val, changed, err := customflags.GetExactBytes(flags, flagsplugin.Prefix("net_id", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.NetId = val
		paths = append(paths, flagsplugin.Prefix("net_id", prefix))
	}
	if val, changed, err := customflags.GetExactBytes(flags, flagsplugin.Prefix("join_eui", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.JoinEui = val
		paths = append(paths, flagsplugin.Prefix("join_eui", prefix))
	}
	if val, changed, err := customflags.GetExactBytes(flags, flagsplugin.Prefix("dev_eui", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.DevEui = val
		paths = append(paths, flagsplugin.Prefix("dev_eui", prefix))
	}
	if val, changed, err := flagsplugin.GetUint32(flags, flagsplugin.Prefix("rejoin_cnt", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.RejoinCnt = val
		paths = append(paths, flagsplugin.Prefix("rejoin_cnt", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForJoinAcceptPayload adds flags to select fields in JoinAcceptPayload.
func AddSelectFlagsForJoinAcceptPayload(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("encrypted", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("encrypted", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("join-nonce", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("join-nonce", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("net-id", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("net-id", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("dev-addr", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("dev-addr", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("dl-settings", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("dl-settings", prefix), true), flagsplugin.WithHidden(hidden)))
	AddSelectFlagsForDLSettings(flags, flagsplugin.Prefix("dl-settings", prefix), hidden)
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("rx-delay", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("rx-delay", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("cf-list", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("cf-list", prefix), true), flagsplugin.WithHidden(hidden)))
	AddSelectFlagsForCFList(flags, flagsplugin.Prefix("cf-list", prefix), hidden)
}

// SelectFromFlags outputs the fieldmask paths forJoinAcceptPayload message from select flags.
func PathsFromSelectFlagsForJoinAcceptPayload(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("encrypted", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("encrypted", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("join_nonce", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("join_nonce", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("net_id", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("net_id", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("dev_addr", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("dev_addr", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("dl_settings", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("dl_settings", prefix))
	}
	if selectPaths, err := PathsFromSelectFlagsForDLSettings(flags, flagsplugin.Prefix("dl_settings", prefix)); err != nil {
		return nil, err
	} else {
		paths = append(paths, selectPaths...)
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("rx_delay", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("rx_delay", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("cf_list", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("cf_list", prefix))
	}
	if selectPaths, err := PathsFromSelectFlagsForCFList(flags, flagsplugin.Prefix("cf_list", prefix)); err != nil {
		return nil, err
	} else {
		paths = append(paths, selectPaths...)
	}
	return paths, nil
}

// AddSetFlagsForJoinAcceptPayload adds flags to select fields in JoinAcceptPayload.
func AddSetFlagsForJoinAcceptPayload(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBytesFlag(flagsplugin.Prefix("encrypted", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(customflags.New3BytesFlag(flagsplugin.Prefix("join-nonce", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(customflags.New3BytesFlag(flagsplugin.Prefix("net-id", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(customflags.New4BytesFlag(flagsplugin.Prefix("dev-addr", prefix), "", flagsplugin.WithHidden(hidden)))
	AddSetFlagsForDLSettings(flags, flagsplugin.Prefix("dl-settings", prefix), hidden)
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("rx-delay", prefix), flagsplugin.EnumValueDesc(RxDelay_value, RxDelay_customvalue), flagsplugin.WithHidden(hidden)))
	AddSetFlagsForCFList(flags, flagsplugin.Prefix("cf-list", prefix), hidden)
}

// SetFromFlags sets the JoinAcceptPayload message from flags.
func (m *JoinAcceptPayload) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetBytes(flags, flagsplugin.Prefix("encrypted", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.Encrypted = val
		paths = append(paths, flagsplugin.Prefix("encrypted", prefix))
	}
	if val, changed, err := customflags.GetExactBytes(flags, flagsplugin.Prefix("join_nonce", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.JoinNonce = val
		paths = append(paths, flagsplugin.Prefix("join_nonce", prefix))
	}
	if val, changed, err := customflags.GetExactBytes(flags, flagsplugin.Prefix("net_id", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.NetId = val
		paths = append(paths, flagsplugin.Prefix("net_id", prefix))
	}
	if val, changed, err := customflags.GetExactBytes(flags, flagsplugin.Prefix("dev_addr", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.DevAddr = val
		paths = append(paths, flagsplugin.Prefix("dev_addr", prefix))
	}
	if changed := flagsplugin.IsAnyPrefixSet(flags, flagsplugin.Prefix("dl_settings", prefix)); changed {
		if m.DlSettings == nil {
			m.DlSettings = &DLSettings{}
		}
		if setPaths, err := m.DlSettings.SetFromFlags(flags, flagsplugin.Prefix("dl_settings", prefix)); err != nil {
			return nil, err
		} else {
			paths = append(paths, setPaths...)
		}
	}
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("rx_delay", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, RxDelay_value, RxDelay_customvalue)
		if err != nil {
			return nil, err
		}
		m.RxDelay = RxDelay(enumValue)
		paths = append(paths, flagsplugin.Prefix("rx_delay", prefix))
	}
	if changed := flagsplugin.IsAnyPrefixSet(flags, flagsplugin.Prefix("cf_list", prefix)); changed {
		if m.CfList == nil {
			m.CfList = &CFList{}
		}
		if setPaths, err := m.CfList.SetFromFlags(flags, flagsplugin.Prefix("cf_list", prefix)); err != nil {
			return nil, err
		} else {
			paths = append(paths, setPaths...)
		}
	}
	return paths, nil
}

// AddSelectFlagsForDLSettings adds flags to select fields in DLSettings.
func AddSelectFlagsForDLSettings(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("rx1-dr-offset", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("rx1-dr-offset", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("rx2-dr", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("rx2-dr", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("opt-neg", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("opt-neg", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forDLSettings message from select flags.
func PathsFromSelectFlagsForDLSettings(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("rx1_dr_offset", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("rx1_dr_offset", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("rx2_dr", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("rx2_dr", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("opt_neg", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("opt_neg", prefix))
	}
	return paths, nil
}

// AddSetFlagsForDLSettings adds flags to select fields in DLSettings.
func AddSetFlagsForDLSettings(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("rx1-dr-offset", prefix), flagsplugin.EnumValueDesc(DataRateOffset_value, DataRateOffset_customvalue), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("rx2-dr", prefix), flagsplugin.EnumValueDesc(DataRateIndex_value, DataRateIndex_customvalue), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("opt-neg", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the DLSettings message from flags.
func (m *DLSettings) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("rx1_dr_offset", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, DataRateOffset_value, DataRateOffset_customvalue)
		if err != nil {
			return nil, err
		}
		m.Rx1DrOffset = DataRateOffset(enumValue)
		paths = append(paths, flagsplugin.Prefix("rx1_dr_offset", prefix))
	}
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("rx2_dr", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, DataRateIndex_value, DataRateIndex_customvalue)
		if err != nil {
			return nil, err
		}
		m.Rx2Dr = DataRateIndex(enumValue)
		paths = append(paths, flagsplugin.Prefix("rx2_dr", prefix))
	}
	if val, changed, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("opt_neg", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.OptNeg = val
		paths = append(paths, flagsplugin.Prefix("opt_neg", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForCFList adds flags to select fields in CFList.
func AddSelectFlagsForCFList(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("type", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("type", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("freq", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("freq", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("ch-masks", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("ch-masks", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forCFList message from select flags.
func PathsFromSelectFlagsForCFList(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("type", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("type", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("freq", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("freq", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("ch_masks", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("ch_masks", prefix))
	}
	return paths, nil
}

// AddSetFlagsForCFList adds flags to select fields in CFList.
func AddSetFlagsForCFList(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("type", prefix), flagsplugin.EnumValueDesc(CFListType_value), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewUint32SliceFlag(flagsplugin.Prefix("freq", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolSliceFlag(flagsplugin.Prefix("ch-masks", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the CFList message from flags.
func (m *CFList) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("type", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, CFListType_value)
		if err != nil {
			return nil, err
		}
		m.Type = CFListType(enumValue)
		paths = append(paths, flagsplugin.Prefix("type", prefix))
	}
	if val, changed, err := flagsplugin.GetUint32Slice(flags, flagsplugin.Prefix("freq", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.Freq = val
		paths = append(paths, flagsplugin.Prefix("freq", prefix))
	}
	if val, changed, err := flagsplugin.GetBoolSlice(flags, flagsplugin.Prefix("ch_masks", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.ChMasks = val
		paths = append(paths, flagsplugin.Prefix("ch_masks", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForLoRaDataRate adds flags to select fields in LoRaDataRate.
func AddSelectFlagsForLoRaDataRate(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("bandwidth", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("bandwidth", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("spreading-factor", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("spreading-factor", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("coding-rate", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("coding-rate", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forLoRaDataRate message from select flags.
func PathsFromSelectFlagsForLoRaDataRate(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("bandwidth", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("bandwidth", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("spreading_factor", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("spreading_factor", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("coding_rate", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("coding_rate", prefix))
	}
	return paths, nil
}

// AddSetFlagsForLoRaDataRate adds flags to select fields in LoRaDataRate.
func AddSetFlagsForLoRaDataRate(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewUint32Flag(flagsplugin.Prefix("bandwidth", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewUint32Flag(flagsplugin.Prefix("spreading-factor", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("coding-rate", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the LoRaDataRate message from flags.
func (m *LoRaDataRate) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetUint32(flags, flagsplugin.Prefix("bandwidth", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.Bandwidth = val
		paths = append(paths, flagsplugin.Prefix("bandwidth", prefix))
	}
	if val, changed, err := flagsplugin.GetUint32(flags, flagsplugin.Prefix("spreading_factor", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.SpreadingFactor = val
		paths = append(paths, flagsplugin.Prefix("spreading_factor", prefix))
	}
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("coding_rate", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.CodingRate = val
		paths = append(paths, flagsplugin.Prefix("coding_rate", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForFSKDataRate adds flags to select fields in FSKDataRate.
func AddSelectFlagsForFSKDataRate(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("bit-rate", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("bit-rate", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forFSKDataRate message from select flags.
func PathsFromSelectFlagsForFSKDataRate(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("bit_rate", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("bit_rate", prefix))
	}
	return paths, nil
}

// AddSetFlagsForFSKDataRate adds flags to select fields in FSKDataRate.
func AddSetFlagsForFSKDataRate(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewUint32Flag(flagsplugin.Prefix("bit-rate", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the FSKDataRate message from flags.
func (m *FSKDataRate) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetUint32(flags, flagsplugin.Prefix("bit_rate", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.BitRate = val
		paths = append(paths, flagsplugin.Prefix("bit_rate", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForLRFHSSDataRate adds flags to select fields in LRFHSSDataRate.
func AddSelectFlagsForLRFHSSDataRate(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("modulation-type", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("modulation-type", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("operating-channel-width", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("operating-channel-width", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("coding-rate", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("coding-rate", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forLRFHSSDataRate message from select flags.
func PathsFromSelectFlagsForLRFHSSDataRate(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("modulation_type", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("modulation_type", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("operating_channel_width", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("operating_channel_width", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("coding_rate", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("coding_rate", prefix))
	}
	return paths, nil
}

// AddSetFlagsForLRFHSSDataRate adds flags to select fields in LRFHSSDataRate.
func AddSetFlagsForLRFHSSDataRate(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewUint32Flag(flagsplugin.Prefix("modulation-type", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewUint32Flag(flagsplugin.Prefix("operating-channel-width", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("coding-rate", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the LRFHSSDataRate message from flags.
func (m *LRFHSSDataRate) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetUint32(flags, flagsplugin.Prefix("modulation_type", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.ModulationType = val
		paths = append(paths, flagsplugin.Prefix("modulation_type", prefix))
	}
	if val, changed, err := flagsplugin.GetUint32(flags, flagsplugin.Prefix("operating_channel_width", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.OperatingChannelWidth = val
		paths = append(paths, flagsplugin.Prefix("operating_channel_width", prefix))
	}
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("coding_rate", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.CodingRate = val
		paths = append(paths, flagsplugin.Prefix("coding_rate", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForDataRate adds flags to select fields in DataRate.
func AddSelectFlagsForDataRate(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("modulation.lora", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("modulation.lora", prefix), true), flagsplugin.WithHidden(hidden)))
	AddSelectFlagsForLoRaDataRate(flags, flagsplugin.Prefix("modulation.lora", prefix), hidden)
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("modulation.fsk", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("modulation.fsk", prefix), true), flagsplugin.WithHidden(hidden)))
	AddSelectFlagsForFSKDataRate(flags, flagsplugin.Prefix("modulation.fsk", prefix), hidden)
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("modulation.lrfhss", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("modulation.lrfhss", prefix), true), flagsplugin.WithHidden(hidden)))
	AddSelectFlagsForLRFHSSDataRate(flags, flagsplugin.Prefix("modulation.lrfhss", prefix), hidden)
}

// SelectFromFlags outputs the fieldmask paths forDataRate message from select flags.
func PathsFromSelectFlagsForDataRate(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("modulation.lora", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("modulation.lora", prefix))
	}
	if selectPaths, err := PathsFromSelectFlagsForLoRaDataRate(flags, flagsplugin.Prefix("modulation.lora", prefix)); err != nil {
		return nil, err
	} else {
		paths = append(paths, selectPaths...)
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("modulation.fsk", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("modulation.fsk", prefix))
	}
	if selectPaths, err := PathsFromSelectFlagsForFSKDataRate(flags, flagsplugin.Prefix("modulation.fsk", prefix)); err != nil {
		return nil, err
	} else {
		paths = append(paths, selectPaths...)
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("modulation.lrfhss", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("modulation.lrfhss", prefix))
	}
	if selectPaths, err := PathsFromSelectFlagsForLRFHSSDataRate(flags, flagsplugin.Prefix("modulation.lrfhss", prefix)); err != nil {
		return nil, err
	} else {
		paths = append(paths, selectPaths...)
	}
	return paths, nil
}

// AddSetFlagsForDataRate adds flags to select fields in DataRate.
func AddSetFlagsForDataRate(flags *pflag.FlagSet, prefix string, hidden bool) {
	AddSetFlagsForLoRaDataRate(flags, flagsplugin.Prefix("modulation.lora", prefix), hidden)
	AddSetFlagsForFSKDataRate(flags, flagsplugin.Prefix("modulation.fsk", prefix), hidden)
	AddSetFlagsForLRFHSSDataRate(flags, flagsplugin.Prefix("modulation.lrfhss", prefix), hidden)
}

// SetFromFlags sets the DataRate message from flags.
func (m *DataRate) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if changed := flagsplugin.IsAnyPrefixSet(flags, flagsplugin.Prefix("modulation.lora", prefix)); changed {
		ov := &DataRate_Lora{}
		if ov.Lora == nil {
			ov.Lora = &LoRaDataRate{}
		}
		if setPaths, err := ov.Lora.SetFromFlags(flags, flagsplugin.Prefix("modulation.lora", prefix)); err != nil {
			return nil, err
		} else {
			paths = append(paths, setPaths...)
		}
		m.Modulation = ov
	}
	if changed := flagsplugin.IsAnyPrefixSet(flags, flagsplugin.Prefix("modulation.fsk", prefix)); changed {
		ov := &DataRate_Fsk{}
		if ov.Fsk == nil {
			ov.Fsk = &FSKDataRate{}
		}
		if setPaths, err := ov.Fsk.SetFromFlags(flags, flagsplugin.Prefix("modulation.fsk", prefix)); err != nil {
			return nil, err
		} else {
			paths = append(paths, setPaths...)
		}
		m.Modulation = ov
	}
	if changed := flagsplugin.IsAnyPrefixSet(flags, flagsplugin.Prefix("modulation.lrfhss", prefix)); changed {
		ov := &DataRate_Lrfhss{}
		if ov.Lrfhss == nil {
			ov.Lrfhss = &LRFHSSDataRate{}
		}
		if setPaths, err := ov.Lrfhss.SetFromFlags(flags, flagsplugin.Prefix("modulation.lrfhss", prefix)); err != nil {
			return nil, err
		} else {
			paths = append(paths, setPaths...)
		}
		m.Modulation = ov
	}
	return paths, nil
}

// AddSelectFlagsForTxSettings_Downlink adds flags to select fields in TxSettings_Downlink.
func AddSelectFlagsForTxSettings_Downlink(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("antenna-index", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("antenna-index", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("tx-power", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("tx-power", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("invert-polarization", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("invert-polarization", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forTxSettings_Downlink message from select flags.
func PathsFromSelectFlagsForTxSettings_Downlink(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("antenna_index", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("antenna_index", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("tx_power", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("tx_power", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("invert_polarization", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("invert_polarization", prefix))
	}
	return paths, nil
}

// AddSetFlagsForTxSettings_Downlink adds flags to select fields in TxSettings_Downlink.
func AddSetFlagsForTxSettings_Downlink(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewUint32Flag(flagsplugin.Prefix("antenna-index", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewFloat32Flag(flagsplugin.Prefix("tx-power", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("invert-polarization", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the TxSettings_Downlink message from flags.
func (m *TxSettings_Downlink) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetUint32(flags, flagsplugin.Prefix("antenna_index", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.AntennaIndex = val
		paths = append(paths, flagsplugin.Prefix("antenna_index", prefix))
	}
	if val, changed, err := flagsplugin.GetFloat32(flags, flagsplugin.Prefix("tx_power", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.TxPower = val
		paths = append(paths, flagsplugin.Prefix("tx_power", prefix))
	}
	if val, changed, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("invert_polarization", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.InvertPolarization = val
		paths = append(paths, flagsplugin.Prefix("invert_polarization", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForTxSettings adds flags to select fields in TxSettings.
func AddSelectFlagsForTxSettings(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("data-rate", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("data-rate", prefix), true), flagsplugin.WithHidden(hidden)))
	AddSelectFlagsForDataRate(flags, flagsplugin.Prefix("data-rate", prefix), hidden)
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("frequency", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("frequency", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("enable-crc", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("enable-crc", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("timestamp", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("timestamp", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("time", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("time", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("downlink", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("downlink", prefix), true), flagsplugin.WithHidden(hidden)))
	AddSelectFlagsForTxSettings_Downlink(flags, flagsplugin.Prefix("downlink", prefix), hidden)
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("concentrator-timestamp", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("concentrator-timestamp", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forTxSettings message from select flags.
func PathsFromSelectFlagsForTxSettings(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("data_rate", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("data_rate", prefix))
	}
	if selectPaths, err := PathsFromSelectFlagsForDataRate(flags, flagsplugin.Prefix("data_rate", prefix)); err != nil {
		return nil, err
	} else {
		paths = append(paths, selectPaths...)
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("frequency", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("frequency", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("enable_crc", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("enable_crc", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("timestamp", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("timestamp", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("time", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("time", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("downlink", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("downlink", prefix))
	}
	if selectPaths, err := PathsFromSelectFlagsForTxSettings_Downlink(flags, flagsplugin.Prefix("downlink", prefix)); err != nil {
		return nil, err
	} else {
		paths = append(paths, selectPaths...)
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("concentrator_timestamp", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("concentrator_timestamp", prefix))
	}
	return paths, nil
}

// AddSetFlagsForTxSettings adds flags to select fields in TxSettings.
func AddSetFlagsForTxSettings(flags *pflag.FlagSet, prefix string, hidden bool) {
	AddSetFlagsForDataRate(flags, flagsplugin.Prefix("data-rate", prefix), hidden)
	flags.AddFlag(flagsplugin.NewUint64Flag(flagsplugin.Prefix("frequency", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("enable-crc", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewUint32Flag(flagsplugin.Prefix("timestamp", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewTimestampFlag(flagsplugin.Prefix("time", prefix), "", flagsplugin.WithHidden(hidden)))
	AddSetFlagsForTxSettings_Downlink(flags, flagsplugin.Prefix("downlink", prefix), hidden)
	flags.AddFlag(flagsplugin.NewInt64Flag(flagsplugin.Prefix("concentrator-timestamp", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the TxSettings message from flags.
func (m *TxSettings) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if changed := flagsplugin.IsAnyPrefixSet(flags, flagsplugin.Prefix("data_rate", prefix)); changed {
		if m.DataRate == nil {
			m.DataRate = &DataRate{}
		}
		if setPaths, err := m.DataRate.SetFromFlags(flags, flagsplugin.Prefix("data_rate", prefix)); err != nil {
			return nil, err
		} else {
			paths = append(paths, setPaths...)
		}
	}
	if val, changed, err := flagsplugin.GetUint64(flags, flagsplugin.Prefix("frequency", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.Frequency = val
		paths = append(paths, flagsplugin.Prefix("frequency", prefix))
	}
	if val, changed, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("enable_crc", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.EnableCrc = val
		paths = append(paths, flagsplugin.Prefix("enable_crc", prefix))
	}
	if val, changed, err := flagsplugin.GetUint32(flags, flagsplugin.Prefix("timestamp", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.Timestamp = val
		paths = append(paths, flagsplugin.Prefix("timestamp", prefix))
	}
	if val, changed, err := flagsplugin.GetTimestamp(flags, flagsplugin.Prefix("time", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.Time = golang.SetTimestamp(val)
		paths = append(paths, flagsplugin.Prefix("time", prefix))
	}
	if changed := flagsplugin.IsAnyPrefixSet(flags, flagsplugin.Prefix("downlink", prefix)); changed {
		if m.Downlink == nil {
			m.Downlink = &TxSettings_Downlink{}
		}
		if setPaths, err := m.Downlink.SetFromFlags(flags, flagsplugin.Prefix("downlink", prefix)); err != nil {
			return nil, err
		} else {
			paths = append(paths, setPaths...)
		}
	}
	if val, changed, err := flagsplugin.GetInt64(flags, flagsplugin.Prefix("concentrator_timestamp", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.ConcentratorTimestamp = val
		paths = append(paths, flagsplugin.Prefix("concentrator_timestamp", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForRelaySecondChannel adds flags to select fields in RelaySecondChannel.
func AddSelectFlagsForRelaySecondChannel(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("ack-offset", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("ack-offset", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("data-rate-index", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("data-rate-index", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("frequency", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("frequency", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forRelaySecondChannel message from select flags.
func PathsFromSelectFlagsForRelaySecondChannel(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("ack_offset", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("ack_offset", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("data_rate_index", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("data_rate_index", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("frequency", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("frequency", prefix))
	}
	return paths, nil
}

// AddSetFlagsForRelaySecondChannel adds flags to select fields in RelaySecondChannel.
func AddSetFlagsForRelaySecondChannel(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("ack-offset", prefix), flagsplugin.EnumValueDesc(RelaySecondChAckOffset_value), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("data-rate-index", prefix), flagsplugin.EnumValueDesc(DataRateIndex_value, DataRateIndex_customvalue), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewUint64Flag(flagsplugin.Prefix("frequency", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the RelaySecondChannel message from flags.
func (m *RelaySecondChannel) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("ack_offset", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, RelaySecondChAckOffset_value)
		if err != nil {
			return nil, err
		}
		m.AckOffset = RelaySecondChAckOffset(enumValue)
		paths = append(paths, flagsplugin.Prefix("ack_offset", prefix))
	}
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("data_rate_index", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, DataRateIndex_value, DataRateIndex_customvalue)
		if err != nil {
			return nil, err
		}
		m.DataRateIndex = DataRateIndex(enumValue)
		paths = append(paths, flagsplugin.Prefix("data_rate_index", prefix))
	}
	if val, changed, err := flagsplugin.GetUint64(flags, flagsplugin.Prefix("frequency", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.Frequency = val
		paths = append(paths, flagsplugin.Prefix("frequency", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForRelayUplinkForwardLimits adds flags to select fields in RelayUplinkForwardLimits.
func AddSelectFlagsForRelayUplinkForwardLimits(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("bucket-size", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("bucket-size", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("reload-rate", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("reload-rate", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forRelayUplinkForwardLimits message from select flags.
func PathsFromSelectFlagsForRelayUplinkForwardLimits(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("bucket_size", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("bucket_size", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("reload_rate", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("reload_rate", prefix))
	}
	return paths, nil
}

// AddSetFlagsForRelayUplinkForwardLimits adds flags to select fields in RelayUplinkForwardLimits.
func AddSetFlagsForRelayUplinkForwardLimits(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("bucket-size", prefix), flagsplugin.EnumValueDesc(RelayLimitBucketSize_value), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewUint32Flag(flagsplugin.Prefix("reload-rate", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the RelayUplinkForwardLimits message from flags.
func (m *RelayUplinkForwardLimits) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("bucket_size", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, RelayLimitBucketSize_value)
		if err != nil {
			return nil, err
		}
		m.BucketSize = RelayLimitBucketSize(enumValue)
		paths = append(paths, flagsplugin.Prefix("bucket_size", prefix))
	}
	if val, changed, err := flagsplugin.GetUint32(flags, flagsplugin.Prefix("reload_rate", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.ReloadRate = val
		paths = append(paths, flagsplugin.Prefix("reload_rate", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForRelayForwardLimits adds flags to select fields in RelayForwardLimits.
func AddSelectFlagsForRelayForwardLimits(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("bucket-size", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("bucket-size", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("reload-rate", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("reload-rate", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forRelayForwardLimits message from select flags.
func PathsFromSelectFlagsForRelayForwardLimits(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("bucket_size", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("bucket_size", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("reload_rate", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("reload_rate", prefix))
	}
	return paths, nil
}

// AddSetFlagsForRelayForwardLimits adds flags to select fields in RelayForwardLimits.
func AddSetFlagsForRelayForwardLimits(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("bucket-size", prefix), flagsplugin.EnumValueDesc(RelayLimitBucketSize_value), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewUint32Flag(flagsplugin.Prefix("reload-rate", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the RelayForwardLimits message from flags.
func (m *RelayForwardLimits) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("bucket_size", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, RelayLimitBucketSize_value)
		if err != nil {
			return nil, err
		}
		m.BucketSize = RelayLimitBucketSize(enumValue)
		paths = append(paths, flagsplugin.Prefix("bucket_size", prefix))
	}
	if val, changed, err := flagsplugin.GetUint32(flags, flagsplugin.Prefix("reload_rate", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.ReloadRate = val
		paths = append(paths, flagsplugin.Prefix("reload_rate", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForRelayEndDeviceAlwaysMode adds flags to select fields in RelayEndDeviceAlwaysMode.
func AddSelectFlagsForRelayEndDeviceAlwaysMode(flags *pflag.FlagSet, prefix string, hidden bool) {
}

// SelectFromFlags outputs the fieldmask paths forRelayEndDeviceAlwaysMode message from select flags.
func PathsFromSelectFlagsForRelayEndDeviceAlwaysMode(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	return paths, nil
}

// AddSetFlagsForRelayEndDeviceAlwaysMode adds flags to select fields in RelayEndDeviceAlwaysMode.
func AddSetFlagsForRelayEndDeviceAlwaysMode(flags *pflag.FlagSet, prefix string, hidden bool) {
}

// SetFromFlags sets the RelayEndDeviceAlwaysMode message from flags.
func (m *RelayEndDeviceAlwaysMode) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	return paths, nil
}

// AddSelectFlagsForRelayEndDeviceDynamicMode adds flags to select fields in RelayEndDeviceDynamicMode.
func AddSelectFlagsForRelayEndDeviceDynamicMode(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("smart-enable-level", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("smart-enable-level", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forRelayEndDeviceDynamicMode message from select flags.
func PathsFromSelectFlagsForRelayEndDeviceDynamicMode(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("smart_enable_level", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("smart_enable_level", prefix))
	}
	return paths, nil
}

// AddSetFlagsForRelayEndDeviceDynamicMode adds flags to select fields in RelayEndDeviceDynamicMode.
func AddSetFlagsForRelayEndDeviceDynamicMode(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("smart-enable-level", prefix), flagsplugin.EnumValueDesc(RelaySmartEnableLevel_value), flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the RelayEndDeviceDynamicMode message from flags.
func (m *RelayEndDeviceDynamicMode) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("smart_enable_level", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, RelaySmartEnableLevel_value)
		if err != nil {
			return nil, err
		}
		m.SmartEnableLevel = RelaySmartEnableLevel(enumValue)
		paths = append(paths, flagsplugin.Prefix("smart_enable_level", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForRelayEndDeviceControlledMode adds flags to select fields in RelayEndDeviceControlledMode.
func AddSelectFlagsForRelayEndDeviceControlledMode(flags *pflag.FlagSet, prefix string, hidden bool) {
}

// SelectFromFlags outputs the fieldmask paths forRelayEndDeviceControlledMode message from select flags.
func PathsFromSelectFlagsForRelayEndDeviceControlledMode(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	return paths, nil
}

// AddSetFlagsForRelayEndDeviceControlledMode adds flags to select fields in RelayEndDeviceControlledMode.
func AddSetFlagsForRelayEndDeviceControlledMode(flags *pflag.FlagSet, prefix string, hidden bool) {
}

// SetFromFlags sets the RelayEndDeviceControlledMode message from flags.
func (m *RelayEndDeviceControlledMode) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	return paths, nil
}

// AddSelectFlagsForMACCommand_RelayUpdateUplinkListReq adds flags to select fields in MACCommand_RelayUpdateUplinkListReq.
func AddSelectFlagsForMACCommand_RelayUpdateUplinkListReq(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("rule-index", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("rule-index", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("forward-limits", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("forward-limits", prefix), true), flagsplugin.WithHidden(hidden)))
	AddSelectFlagsForRelayUplinkForwardLimits(flags, flagsplugin.Prefix("forward-limits", prefix), hidden)
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("dev-addr", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("dev-addr", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("w-f-cnt", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("w-f-cnt", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("root-wor-s-key", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("root-wor-s-key", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("device-id", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("device-id", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("session-key-id", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("session-key-id", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forMACCommand_RelayUpdateUplinkListReq message from select flags.
func PathsFromSelectFlagsForMACCommand_RelayUpdateUplinkListReq(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("rule_index", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("rule_index", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("forward_limits", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("forward_limits", prefix))
	}
	if selectPaths, err := PathsFromSelectFlagsForRelayUplinkForwardLimits(flags, flagsplugin.Prefix("forward_limits", prefix)); err != nil {
		return nil, err
	} else {
		paths = append(paths, selectPaths...)
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("dev_addr", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("dev_addr", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("w_f_cnt", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("w_f_cnt", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("root_wor_s_key", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("root_wor_s_key", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("device_id", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("device_id", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("session_key_id", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("session_key_id", prefix))
	}
	return paths, nil
}

// AddSetFlagsForMACCommand_RelayUpdateUplinkListReq adds flags to select fields in MACCommand_RelayUpdateUplinkListReq.
func AddSetFlagsForMACCommand_RelayUpdateUplinkListReq(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewUint32Flag(flagsplugin.Prefix("rule-index", prefix), "", flagsplugin.WithHidden(hidden)))
	AddSetFlagsForRelayUplinkForwardLimits(flags, flagsplugin.Prefix("forward-limits", prefix), hidden)
	flags.AddFlag(customflags.New4BytesFlag(flagsplugin.Prefix("dev-addr", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewUint32Flag(flagsplugin.Prefix("w-f-cnt", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(customflags.New16BytesFlag(flagsplugin.Prefix("root-wor-s-key", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("device-id", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBytesFlag(flagsplugin.Prefix("session-key-id", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the MACCommand_RelayUpdateUplinkListReq message from flags.
func (m *MACCommand_RelayUpdateUplinkListReq) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetUint32(flags, flagsplugin.Prefix("rule_index", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.RuleIndex = val
		paths = append(paths, flagsplugin.Prefix("rule_index", prefix))
	}
	if changed := flagsplugin.IsAnyPrefixSet(flags, flagsplugin.Prefix("forward_limits", prefix)); changed {
		if m.ForwardLimits == nil {
			m.ForwardLimits = &RelayUplinkForwardLimits{}
		}
		if setPaths, err := m.ForwardLimits.SetFromFlags(flags, flagsplugin.Prefix("forward_limits", prefix)); err != nil {
			return nil, err
		} else {
			paths = append(paths, setPaths...)
		}
	}
	if val, changed, err := customflags.GetExactBytes(flags, flagsplugin.Prefix("dev_addr", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.DevAddr = val
		paths = append(paths, flagsplugin.Prefix("dev_addr", prefix))
	}
	if val, changed, err := flagsplugin.GetUint32(flags, flagsplugin.Prefix("w_f_cnt", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.WFCnt = val
		paths = append(paths, flagsplugin.Prefix("w_f_cnt", prefix))
	}
	if val, changed, err := customflags.GetExactBytes(flags, flagsplugin.Prefix("root_wor_s_key", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.RootWorSKey = val
		paths = append(paths, flagsplugin.Prefix("root_wor_s_key", prefix))
	}
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("device_id", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.DeviceId = val
		paths = append(paths, flagsplugin.Prefix("device_id", prefix))
	}
	if val, changed, err := flagsplugin.GetBytes(flags, flagsplugin.Prefix("session_key_id", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.SessionKeyId = val
		paths = append(paths, flagsplugin.Prefix("session_key_id", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForMACCommand_RelayNotifyNewEndDeviceReq adds flags to select fields in MACCommand_RelayNotifyNewEndDeviceReq.
func AddSelectFlagsForMACCommand_RelayNotifyNewEndDeviceReq(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("dev-addr", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("dev-addr", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("snr", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("snr", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("rssi", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("rssi", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forMACCommand_RelayNotifyNewEndDeviceReq message from select flags.
func PathsFromSelectFlagsForMACCommand_RelayNotifyNewEndDeviceReq(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("dev_addr", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("dev_addr", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("snr", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("snr", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("rssi", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("rssi", prefix))
	}
	return paths, nil
}

// AddSetFlagsForMACCommand_RelayNotifyNewEndDeviceReq adds flags to select fields in MACCommand_RelayNotifyNewEndDeviceReq.
func AddSetFlagsForMACCommand_RelayNotifyNewEndDeviceReq(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(customflags.New4BytesFlag(flagsplugin.Prefix("dev-addr", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewInt32Flag(flagsplugin.Prefix("snr", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewInt32Flag(flagsplugin.Prefix("rssi", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the MACCommand_RelayNotifyNewEndDeviceReq message from flags.
func (m *MACCommand_RelayNotifyNewEndDeviceReq) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := customflags.GetExactBytes(flags, flagsplugin.Prefix("dev_addr", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.DevAddr = val
		paths = append(paths, flagsplugin.Prefix("dev_addr", prefix))
	}
	if val, changed, err := flagsplugin.GetInt32(flags, flagsplugin.Prefix("snr", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.Snr = val
		paths = append(paths, flagsplugin.Prefix("snr", prefix))
	}
	if val, changed, err := flagsplugin.GetInt32(flags, flagsplugin.Prefix("rssi", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.Rssi = val
		paths = append(paths, flagsplugin.Prefix("rssi", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForFrequencyValue adds flags to select fields in FrequencyValue.
func AddSelectFlagsForFrequencyValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("value", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("value", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forFrequencyValue message from select flags.
func PathsFromSelectFlagsForFrequencyValue(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSetFlagsForFrequencyValue adds flags to select fields in FrequencyValue.
func AddSetFlagsForFrequencyValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewUint64Flag(flagsplugin.Prefix("value", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the FrequencyValue message from flags.
func (m *FrequencyValue) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetUint64(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.Value = val
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForZeroableFrequencyValue adds flags to select fields in ZeroableFrequencyValue.
func AddSelectFlagsForZeroableFrequencyValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("value", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("value", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forZeroableFrequencyValue message from select flags.
func PathsFromSelectFlagsForZeroableFrequencyValue(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSetFlagsForZeroableFrequencyValue adds flags to select fields in ZeroableFrequencyValue.
func AddSetFlagsForZeroableFrequencyValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewUint64Flag(flagsplugin.Prefix("value", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the ZeroableFrequencyValue message from flags.
func (m *ZeroableFrequencyValue) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetUint64(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.Value = val
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForDataRateOffsetValue adds flags to select fields in DataRateOffsetValue.
func AddSelectFlagsForDataRateOffsetValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("value", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("value", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forDataRateOffsetValue message from select flags.
func PathsFromSelectFlagsForDataRateOffsetValue(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSetFlagsForDataRateOffsetValue adds flags to select fields in DataRateOffsetValue.
func AddSetFlagsForDataRateOffsetValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("value", prefix), flagsplugin.EnumValueDesc(DataRateOffset_value, DataRateOffset_customvalue), flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the DataRateOffsetValue message from flags.
func (m *DataRateOffsetValue) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, DataRateOffset_value, DataRateOffset_customvalue)
		if err != nil {
			return nil, err
		}
		m.Value = DataRateOffset(enumValue)
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForDataRateIndexValue adds flags to select fields in DataRateIndexValue.
func AddSelectFlagsForDataRateIndexValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("value", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("value", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forDataRateIndexValue message from select flags.
func PathsFromSelectFlagsForDataRateIndexValue(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSetFlagsForDataRateIndexValue adds flags to select fields in DataRateIndexValue.
func AddSetFlagsForDataRateIndexValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("value", prefix), flagsplugin.EnumValueDesc(DataRateIndex_value, DataRateIndex_customvalue), flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the DataRateIndexValue message from flags.
func (m *DataRateIndexValue) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, DataRateIndex_value, DataRateIndex_customvalue)
		if err != nil {
			return nil, err
		}
		m.Value = DataRateIndex(enumValue)
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForPingSlotPeriodValue adds flags to select fields in PingSlotPeriodValue.
func AddSelectFlagsForPingSlotPeriodValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("value", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("value", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forPingSlotPeriodValue message from select flags.
func PathsFromSelectFlagsForPingSlotPeriodValue(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSetFlagsForPingSlotPeriodValue adds flags to select fields in PingSlotPeriodValue.
func AddSetFlagsForPingSlotPeriodValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("value", prefix), flagsplugin.EnumValueDesc(PingSlotPeriod_value), flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the PingSlotPeriodValue message from flags.
func (m *PingSlotPeriodValue) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, PingSlotPeriod_value)
		if err != nil {
			return nil, err
		}
		m.Value = PingSlotPeriod(enumValue)
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForAggregatedDutyCycleValue adds flags to select fields in AggregatedDutyCycleValue.
func AddSelectFlagsForAggregatedDutyCycleValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("value", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("value", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forAggregatedDutyCycleValue message from select flags.
func PathsFromSelectFlagsForAggregatedDutyCycleValue(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSetFlagsForAggregatedDutyCycleValue adds flags to select fields in AggregatedDutyCycleValue.
func AddSetFlagsForAggregatedDutyCycleValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("value", prefix), flagsplugin.EnumValueDesc(AggregatedDutyCycle_value), flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the AggregatedDutyCycleValue message from flags.
func (m *AggregatedDutyCycleValue) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, AggregatedDutyCycle_value)
		if err != nil {
			return nil, err
		}
		m.Value = AggregatedDutyCycle(enumValue)
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForRxDelayValue adds flags to select fields in RxDelayValue.
func AddSelectFlagsForRxDelayValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("value", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("value", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forRxDelayValue message from select flags.
func PathsFromSelectFlagsForRxDelayValue(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSetFlagsForRxDelayValue adds flags to select fields in RxDelayValue.
func AddSetFlagsForRxDelayValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("value", prefix), flagsplugin.EnumValueDesc(RxDelay_value, RxDelay_customvalue), flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the RxDelayValue message from flags.
func (m *RxDelayValue) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, RxDelay_value, RxDelay_customvalue)
		if err != nil {
			return nil, err
		}
		m.Value = RxDelay(enumValue)
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForADRAckLimitExponentValue adds flags to select fields in ADRAckLimitExponentValue.
func AddSelectFlagsForADRAckLimitExponentValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("value", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("value", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forADRAckLimitExponentValue message from select flags.
func PathsFromSelectFlagsForADRAckLimitExponentValue(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSetFlagsForADRAckLimitExponentValue adds flags to select fields in ADRAckLimitExponentValue.
func AddSetFlagsForADRAckLimitExponentValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("value", prefix), flagsplugin.EnumValueDesc(ADRAckLimitExponent_value), flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the ADRAckLimitExponentValue message from flags.
func (m *ADRAckLimitExponentValue) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, ADRAckLimitExponent_value)
		if err != nil {
			return nil, err
		}
		m.Value = ADRAckLimitExponent(enumValue)
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForADRAckDelayExponentValue adds flags to select fields in ADRAckDelayExponentValue.
func AddSelectFlagsForADRAckDelayExponentValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("value", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("value", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forADRAckDelayExponentValue message from select flags.
func PathsFromSelectFlagsForADRAckDelayExponentValue(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSetFlagsForADRAckDelayExponentValue adds flags to select fields in ADRAckDelayExponentValue.
func AddSetFlagsForADRAckDelayExponentValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("value", prefix), flagsplugin.EnumValueDesc(ADRAckDelayExponent_value), flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the ADRAckDelayExponentValue message from flags.
func (m *ADRAckDelayExponentValue) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, ADRAckDelayExponent_value)
		if err != nil {
			return nil, err
		}
		m.Value = ADRAckDelayExponent(enumValue)
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForDeviceEIRPValue adds flags to select fields in DeviceEIRPValue.
func AddSelectFlagsForDeviceEIRPValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("value", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("value", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forDeviceEIRPValue message from select flags.
func PathsFromSelectFlagsForDeviceEIRPValue(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSetFlagsForDeviceEIRPValue adds flags to select fields in DeviceEIRPValue.
func AddSetFlagsForDeviceEIRPValue(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("value", prefix), flagsplugin.EnumValueDesc(DeviceEIRP_value), flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the DeviceEIRPValue message from flags.
func (m *DeviceEIRPValue) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("value", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, DeviceEIRP_value)
		if err != nil {
			return nil, err
		}
		m.Value = DeviceEIRP(enumValue)
		paths = append(paths, flagsplugin.Prefix("value", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForRelayForwardUplinkReq adds flags to select fields in RelayForwardUplinkReq.
func AddSelectFlagsForRelayForwardUplinkReq(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("data-rate", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("data-rate", prefix), true), flagsplugin.WithHidden(hidden)))
	AddSelectFlagsForDataRate(flags, flagsplugin.Prefix("data-rate", prefix), hidden)
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("snr", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("snr", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("rssi", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("rssi", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("wor-channel", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("wor-channel", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("frequency", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("frequency", prefix), false), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("raw-payload", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("raw-payload", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forRelayForwardUplinkReq message from select flags.
func PathsFromSelectFlagsForRelayForwardUplinkReq(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("data_rate", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("data_rate", prefix))
	}
	if selectPaths, err := PathsFromSelectFlagsForDataRate(flags, flagsplugin.Prefix("data_rate", prefix)); err != nil {
		return nil, err
	} else {
		paths = append(paths, selectPaths...)
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("snr", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("snr", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("rssi", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("rssi", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("wor_channel", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("wor_channel", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("frequency", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("frequency", prefix))
	}
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("raw_payload", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("raw_payload", prefix))
	}
	return paths, nil
}

// AddSetFlagsForRelayForwardUplinkReq adds flags to select fields in RelayForwardUplinkReq.
func AddSetFlagsForRelayForwardUplinkReq(flags *pflag.FlagSet, prefix string, hidden bool) {
	AddSetFlagsForDataRate(flags, flagsplugin.Prefix("data-rate", prefix), hidden)
	flags.AddFlag(flagsplugin.NewInt32Flag(flagsplugin.Prefix("snr", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewInt32Flag(flagsplugin.Prefix("rssi", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewStringFlag(flagsplugin.Prefix("wor-channel", prefix), flagsplugin.EnumValueDesc(RelayWORChannel_value), flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewUint64Flag(flagsplugin.Prefix("frequency", prefix), "", flagsplugin.WithHidden(hidden)))
	flags.AddFlag(flagsplugin.NewBytesFlag(flagsplugin.Prefix("raw-payload", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the RelayForwardUplinkReq message from flags.
func (m *RelayForwardUplinkReq) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if changed := flagsplugin.IsAnyPrefixSet(flags, flagsplugin.Prefix("data_rate", prefix)); changed {
		if m.DataRate == nil {
			m.DataRate = &DataRate{}
		}
		if setPaths, err := m.DataRate.SetFromFlags(flags, flagsplugin.Prefix("data_rate", prefix)); err != nil {
			return nil, err
		} else {
			paths = append(paths, setPaths...)
		}
	}
	if val, changed, err := flagsplugin.GetInt32(flags, flagsplugin.Prefix("snr", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.Snr = val
		paths = append(paths, flagsplugin.Prefix("snr", prefix))
	}
	if val, changed, err := flagsplugin.GetInt32(flags, flagsplugin.Prefix("rssi", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.Rssi = val
		paths = append(paths, flagsplugin.Prefix("rssi", prefix))
	}
	if val, changed, err := flagsplugin.GetString(flags, flagsplugin.Prefix("wor_channel", prefix)); err != nil {
		return nil, err
	} else if changed {
		enumValue, err := flagsplugin.SetEnumString(val, RelayWORChannel_value)
		if err != nil {
			return nil, err
		}
		m.WorChannel = RelayWORChannel(enumValue)
		paths = append(paths, flagsplugin.Prefix("wor_channel", prefix))
	}
	if val, changed, err := flagsplugin.GetUint64(flags, flagsplugin.Prefix("frequency", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.Frequency = val
		paths = append(paths, flagsplugin.Prefix("frequency", prefix))
	}
	if val, changed, err := flagsplugin.GetBytes(flags, flagsplugin.Prefix("raw_payload", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.RawPayload = val
		paths = append(paths, flagsplugin.Prefix("raw_payload", prefix))
	}
	return paths, nil
}

// AddSelectFlagsForRelayForwardDownlinkReq adds flags to select fields in RelayForwardDownlinkReq.
func AddSelectFlagsForRelayForwardDownlinkReq(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBoolFlag(flagsplugin.Prefix("raw-payload", prefix), flagsplugin.SelectDesc(flagsplugin.Prefix("raw-payload", prefix), false), flagsplugin.WithHidden(hidden)))
}

// SelectFromFlags outputs the fieldmask paths forRelayForwardDownlinkReq message from select flags.
func PathsFromSelectFlagsForRelayForwardDownlinkReq(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, selected, err := flagsplugin.GetBool(flags, flagsplugin.Prefix("raw_payload", prefix)); err != nil {
		return nil, err
	} else if selected && val {
		paths = append(paths, flagsplugin.Prefix("raw_payload", prefix))
	}
	return paths, nil
}

// AddSetFlagsForRelayForwardDownlinkReq adds flags to select fields in RelayForwardDownlinkReq.
func AddSetFlagsForRelayForwardDownlinkReq(flags *pflag.FlagSet, prefix string, hidden bool) {
	flags.AddFlag(flagsplugin.NewBytesFlag(flagsplugin.Prefix("raw-payload", prefix), "", flagsplugin.WithHidden(hidden)))
}

// SetFromFlags sets the RelayForwardDownlinkReq message from flags.
func (m *RelayForwardDownlinkReq) SetFromFlags(flags *pflag.FlagSet, prefix string) (paths []string, err error) {
	if val, changed, err := flagsplugin.GetBytes(flags, flagsplugin.Prefix("raw_payload", prefix)); err != nil {
		return nil, err
	} else if changed {
		m.RawPayload = val
		paths = append(paths, flagsplugin.Prefix("raw_payload", prefix))
	}
	return paths, nil
}
