// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on Message with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *Message) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MessageFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "m_hdr":

			if m.GetMHdr() == nil {
				return MessageValidationError{
					field:  "m_hdr",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetMHdr()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MessageValidationError{
						field:  "m_hdr",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "mic":

			if l := len(m.GetMic()); l < 0 || l > 4 {
				return MessageValidationError{
					field:  "mic",
					reason: "value length must be between 0 and 4 bytes, inclusive",
				}
			}

		case "Payload":
			if m.Payload == nil {
				return MessageValidationError{
					field:  "Payload",
					reason: "value is required",
				}
			}
			if len(subs) == 0 {
				subs = []string{
					"mac_payload", "join_request_payload", "join_accept_payload", "rejoin_request_payload",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "mac_payload":
					w, ok := m.Payload.(*Message_MacPayload)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetMacPayload()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MessageValidationError{
								field:  "mac_payload",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "join_request_payload":
					w, ok := m.Payload.(*Message_JoinRequestPayload)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetJoinRequestPayload()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MessageValidationError{
								field:  "join_request_payload",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "join_accept_payload":
					w, ok := m.Payload.(*Message_JoinAcceptPayload)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetJoinAcceptPayload()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MessageValidationError{
								field:  "join_accept_payload",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "rejoin_request_payload":
					w, ok := m.Payload.(*Message_RejoinRequestPayload)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRejoinRequestPayload()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MessageValidationError{
								field:  "rejoin_request_payload",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return MessageValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MessageValidationError is the validation error returned by
// Message.ValidateFields if the designated constraints aren't met.
type MessageValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MessageValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MessageValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MessageValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MessageValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MessageValidationError) ErrorName() string { return "MessageValidationError" }

// Error satisfies the builtin error interface
func (e MessageValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMessage.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MessageValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MessageValidationError{}

// ValidateFields checks the field values on MHDR with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *MHDR) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MHDRFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "m_type":

			if _, ok := MType_name[int32(m.GetMType())]; !ok {
				return MHDRValidationError{
					field:  "m_type",
					reason: "value must be one of the defined enum values",
				}
			}

		case "major":

			if _, ok := Major_name[int32(m.GetMajor())]; !ok {
				return MHDRValidationError{
					field:  "major",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MHDRValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MHDRValidationError is the validation error returned by MHDR.ValidateFields
// if the designated constraints aren't met.
type MHDRValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MHDRValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MHDRValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MHDRValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MHDRValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MHDRValidationError) ErrorName() string { return "MHDRValidationError" }

// Error satisfies the builtin error interface
func (e MHDRValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMHDR.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MHDRValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MHDRValidationError{}

// ValidateFields checks the field values on MACPayload with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *MACPayload) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACPayloadFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "f_hdr":

			if m.GetFHdr() == nil {
				return MACPayloadValidationError{
					field:  "f_hdr",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetFHdr()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACPayloadValidationError{
						field:  "f_hdr",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "f_port":

			if m.GetFPort() > 255 {
				return MACPayloadValidationError{
					field:  "f_port",
					reason: "value must be less than or equal to 255",
				}
			}

		case "frm_payload":
			// no validation rules for FrmPayload
		case "decoded_payload":

			if v, ok := interface{}(m.GetDecodedPayload()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACPayloadValidationError{
						field:  "decoded_payload",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "full_f_cnt":
			// no validation rules for FullFCnt
		default:
			return MACPayloadValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACPayloadValidationError is the validation error returned by
// MACPayload.ValidateFields if the designated constraints aren't met.
type MACPayloadValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACPayloadValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACPayloadValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACPayloadValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACPayloadValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACPayloadValidationError) ErrorName() string { return "MACPayloadValidationError" }

// Error satisfies the builtin error interface
func (e MACPayloadValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACPayload.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACPayloadValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACPayloadValidationError{}

// ValidateFields checks the field values on FHDR with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *FHDR) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = FHDRFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "dev_addr":

			if len(m.GetDevAddr()) > 0 {

				if len(m.GetDevAddr()) != 4 {
					return FHDRValidationError{
						field:  "dev_addr",
						reason: "value length must be 4 bytes",
					}
				}

			}

		case "f_ctrl":

			if m.GetFCtrl() == nil {
				return FHDRValidationError{
					field:  "f_ctrl",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetFCtrl()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return FHDRValidationError{
						field:  "f_ctrl",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "f_cnt":

			if m.GetFCnt() > 65535 {
				return FHDRValidationError{
					field:  "f_cnt",
					reason: "value must be less than or equal to 65535",
				}
			}

		case "f_opts":

			if len(m.GetFOpts()) > 15 {
				return FHDRValidationError{
					field:  "f_opts",
					reason: "value length must be at most 15 bytes",
				}
			}

		default:
			return FHDRValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// FHDRValidationError is the validation error returned by FHDR.ValidateFields
// if the designated constraints aren't met.
type FHDRValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FHDRValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FHDRValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FHDRValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FHDRValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FHDRValidationError) ErrorName() string { return "FHDRValidationError" }

// Error satisfies the builtin error interface
func (e FHDRValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFHDR.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FHDRValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FHDRValidationError{}

// ValidateFields checks the field values on FCtrl with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *FCtrl) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = FCtrlFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "adr":
			// no validation rules for Adr
		case "adr_ack_req":
			// no validation rules for AdrAckReq
		case "ack":
			// no validation rules for Ack
		case "f_pending":
			// no validation rules for FPending
		case "class_b":
			// no validation rules for ClassB
		default:
			return FCtrlValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// FCtrlValidationError is the validation error returned by
// FCtrl.ValidateFields if the designated constraints aren't met.
type FCtrlValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FCtrlValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FCtrlValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FCtrlValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FCtrlValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FCtrlValidationError) ErrorName() string { return "FCtrlValidationError" }

// Error satisfies the builtin error interface
func (e FCtrlValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFCtrl.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FCtrlValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FCtrlValidationError{}

// ValidateFields checks the field values on JoinRequestPayload with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *JoinRequestPayload) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = JoinRequestPayloadFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "join_eui":

			if len(m.GetJoinEui()) > 0 {

				if len(m.GetJoinEui()) != 8 {
					return JoinRequestPayloadValidationError{
						field:  "join_eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		case "dev_eui":

			if len(m.GetDevEui()) > 0 {

				if len(m.GetDevEui()) != 8 {
					return JoinRequestPayloadValidationError{
						field:  "dev_eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		case "dev_nonce":

			if len(m.GetDevNonce()) > 0 {

				if len(m.GetDevNonce()) != 2 {
					return JoinRequestPayloadValidationError{
						field:  "dev_nonce",
						reason: "value length must be 2 bytes",
					}
				}

			}

		default:
			return JoinRequestPayloadValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// JoinRequestPayloadValidationError is the validation error returned by
// JoinRequestPayload.ValidateFields if the designated constraints aren't met.
type JoinRequestPayloadValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JoinRequestPayloadValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JoinRequestPayloadValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JoinRequestPayloadValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JoinRequestPayloadValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JoinRequestPayloadValidationError) ErrorName() string {
	return "JoinRequestPayloadValidationError"
}

// Error satisfies the builtin error interface
func (e JoinRequestPayloadValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJoinRequestPayload.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JoinRequestPayloadValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JoinRequestPayloadValidationError{}

// ValidateFields checks the field values on RejoinRequestPayload with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RejoinRequestPayload) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RejoinRequestPayloadFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "rejoin_type":

			if _, ok := RejoinRequestType_name[int32(m.GetRejoinType())]; !ok {
				return RejoinRequestPayloadValidationError{
					field:  "rejoin_type",
					reason: "value must be one of the defined enum values",
				}
			}

		case "net_id":

			if len(m.GetNetId()) > 0 {

				if len(m.GetNetId()) != 3 {
					return RejoinRequestPayloadValidationError{
						field:  "net_id",
						reason: "value length must be 3 bytes",
					}
				}

			}

		case "join_eui":

			if len(m.GetJoinEui()) > 0 {

				if len(m.GetJoinEui()) != 8 {
					return RejoinRequestPayloadValidationError{
						field:  "join_eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		case "dev_eui":

			if len(m.GetDevEui()) > 0 {

				if len(m.GetDevEui()) != 8 {
					return RejoinRequestPayloadValidationError{
						field:  "dev_eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		case "rejoin_cnt":
			// no validation rules for RejoinCnt
		default:
			return RejoinRequestPayloadValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RejoinRequestPayloadValidationError is the validation error returned by
// RejoinRequestPayload.ValidateFields if the designated constraints aren't met.
type RejoinRequestPayloadValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RejoinRequestPayloadValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RejoinRequestPayloadValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RejoinRequestPayloadValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RejoinRequestPayloadValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RejoinRequestPayloadValidationError) ErrorName() string {
	return "RejoinRequestPayloadValidationError"
}

// Error satisfies the builtin error interface
func (e RejoinRequestPayloadValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRejoinRequestPayload.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RejoinRequestPayloadValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RejoinRequestPayloadValidationError{}

// ValidateFields checks the field values on JoinAcceptPayload with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *JoinAcceptPayload) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = JoinAcceptPayloadFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "encrypted":
			// no validation rules for Encrypted
		case "join_nonce":

			if len(m.GetJoinNonce()) > 0 {

				if len(m.GetJoinNonce()) != 3 {
					return JoinAcceptPayloadValidationError{
						field:  "join_nonce",
						reason: "value length must be 3 bytes",
					}
				}

			}

		case "net_id":

			if len(m.GetNetId()) > 0 {

				if len(m.GetNetId()) != 3 {
					return JoinAcceptPayloadValidationError{
						field:  "net_id",
						reason: "value length must be 3 bytes",
					}
				}

			}

		case "dev_addr":

			if len(m.GetDevAddr()) > 0 {

				if len(m.GetDevAddr()) != 4 {
					return JoinAcceptPayloadValidationError{
						field:  "dev_addr",
						reason: "value length must be 4 bytes",
					}
				}

			}

		case "dl_settings":

			if m.GetDlSettings() == nil {
				return JoinAcceptPayloadValidationError{
					field:  "dl_settings",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetDlSettings()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return JoinAcceptPayloadValidationError{
						field:  "dl_settings",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "rx_delay":

			if _, ok := RxDelay_name[int32(m.GetRxDelay())]; !ok {
				return JoinAcceptPayloadValidationError{
					field:  "rx_delay",
					reason: "value must be one of the defined enum values",
				}
			}

		case "cf_list":

			if v, ok := interface{}(m.GetCfList()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return JoinAcceptPayloadValidationError{
						field:  "cf_list",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return JoinAcceptPayloadValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// JoinAcceptPayloadValidationError is the validation error returned by
// JoinAcceptPayload.ValidateFields if the designated constraints aren't met.
type JoinAcceptPayloadValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JoinAcceptPayloadValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JoinAcceptPayloadValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JoinAcceptPayloadValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JoinAcceptPayloadValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JoinAcceptPayloadValidationError) ErrorName() string {
	return "JoinAcceptPayloadValidationError"
}

// Error satisfies the builtin error interface
func (e JoinAcceptPayloadValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJoinAcceptPayload.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JoinAcceptPayloadValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JoinAcceptPayloadValidationError{}

// ValidateFields checks the field values on DLSettings with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *DLSettings) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DLSettingsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "rx1_dr_offset":

			if _, ok := DataRateOffset_name[int32(m.GetRx1DrOffset())]; !ok {
				return DLSettingsValidationError{
					field:  "rx1_dr_offset",
					reason: "value must be one of the defined enum values",
				}
			}

		case "rx2_dr":

			if _, ok := DataRateIndex_name[int32(m.GetRx2Dr())]; !ok {
				return DLSettingsValidationError{
					field:  "rx2_dr",
					reason: "value must be one of the defined enum values",
				}
			}

		case "opt_neg":
			// no validation rules for OptNeg
		default:
			return DLSettingsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DLSettingsValidationError is the validation error returned by
// DLSettings.ValidateFields if the designated constraints aren't met.
type DLSettingsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DLSettingsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DLSettingsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DLSettingsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DLSettingsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DLSettingsValidationError) ErrorName() string { return "DLSettingsValidationError" }

// Error satisfies the builtin error interface
func (e DLSettingsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDLSettings.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DLSettingsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DLSettingsValidationError{}

// ValidateFields checks the field values on CFList with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *CFList) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CFListFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "type":

			if _, ok := CFListType_name[int32(m.GetType())]; !ok {
				return CFListValidationError{
					field:  "type",
					reason: "value must be one of the defined enum values",
				}
			}

		case "freq":

		case "ch_masks":

		default:
			return CFListValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CFListValidationError is the validation error returned by
// CFList.ValidateFields if the designated constraints aren't met.
type CFListValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CFListValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CFListValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CFListValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CFListValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CFListValidationError) ErrorName() string { return "CFListValidationError" }

// Error satisfies the builtin error interface
func (e CFListValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCFList.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CFListValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CFListValidationError{}

// ValidateFields checks the field values on LoRaDataRate with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *LoRaDataRate) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = LoRaDataRateFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "bandwidth":
			// no validation rules for Bandwidth
		case "spreading_factor":
			// no validation rules for SpreadingFactor
		case "coding_rate":
			// no validation rules for CodingRate
		default:
			return LoRaDataRateValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// LoRaDataRateValidationError is the validation error returned by
// LoRaDataRate.ValidateFields if the designated constraints aren't met.
type LoRaDataRateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LoRaDataRateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LoRaDataRateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LoRaDataRateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LoRaDataRateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LoRaDataRateValidationError) ErrorName() string { return "LoRaDataRateValidationError" }

// Error satisfies the builtin error interface
func (e LoRaDataRateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLoRaDataRate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LoRaDataRateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LoRaDataRateValidationError{}

// ValidateFields checks the field values on FSKDataRate with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *FSKDataRate) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = FSKDataRateFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "bit_rate":
			// no validation rules for BitRate
		default:
			return FSKDataRateValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// FSKDataRateValidationError is the validation error returned by
// FSKDataRate.ValidateFields if the designated constraints aren't met.
type FSKDataRateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FSKDataRateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FSKDataRateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FSKDataRateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FSKDataRateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FSKDataRateValidationError) ErrorName() string { return "FSKDataRateValidationError" }

// Error satisfies the builtin error interface
func (e FSKDataRateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFSKDataRate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FSKDataRateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FSKDataRateValidationError{}

// ValidateFields checks the field values on LRFHSSDataRate with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *LRFHSSDataRate) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = LRFHSSDataRateFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "modulation_type":
			// no validation rules for ModulationType
		case "operating_channel_width":
			// no validation rules for OperatingChannelWidth
		case "coding_rate":
			// no validation rules for CodingRate
		default:
			return LRFHSSDataRateValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// LRFHSSDataRateValidationError is the validation error returned by
// LRFHSSDataRate.ValidateFields if the designated constraints aren't met.
type LRFHSSDataRateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LRFHSSDataRateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LRFHSSDataRateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LRFHSSDataRateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LRFHSSDataRateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LRFHSSDataRateValidationError) ErrorName() string { return "LRFHSSDataRateValidationError" }

// Error satisfies the builtin error interface
func (e LRFHSSDataRateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLRFHSSDataRate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LRFHSSDataRateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LRFHSSDataRateValidationError{}

// ValidateFields checks the field values on DataRate with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *DataRate) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DataRateFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "modulation":
			if m.Modulation == nil {
				return DataRateValidationError{
					field:  "modulation",
					reason: "value is required",
				}
			}
			if len(subs) == 0 {
				subs = []string{
					"lora", "fsk", "lrfhss",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "lora":
					w, ok := m.Modulation.(*DataRate_Lora)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetLora()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return DataRateValidationError{
								field:  "lora",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "fsk":
					w, ok := m.Modulation.(*DataRate_Fsk)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetFsk()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return DataRateValidationError{
								field:  "fsk",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "lrfhss":
					w, ok := m.Modulation.(*DataRate_Lrfhss)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetLrfhss()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return DataRateValidationError{
								field:  "lrfhss",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return DataRateValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DataRateValidationError is the validation error returned by
// DataRate.ValidateFields if the designated constraints aren't met.
type DataRateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DataRateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DataRateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DataRateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DataRateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DataRateValidationError) ErrorName() string { return "DataRateValidationError" }

// Error satisfies the builtin error interface
func (e DataRateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDataRate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DataRateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DataRateValidationError{}

// ValidateFields checks the field values on TxSettings with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *TxSettings) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = TxSettingsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "data_rate":

			if m.GetDataRate() == nil {
				return TxSettingsValidationError{
					field:  "data_rate",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetDataRate()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return TxSettingsValidationError{
						field:  "data_rate",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "frequency":

			if m.GetFrequency() < 100000 {
				return TxSettingsValidationError{
					field:  "frequency",
					reason: "value must be greater than or equal to 100000",
				}
			}

		case "enable_crc":
			// no validation rules for EnableCrc
		case "timestamp":
			// no validation rules for Timestamp
		case "time":

			if v, ok := interface{}(m.GetTime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return TxSettingsValidationError{
						field:  "time",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink":

			if v, ok := interface{}(m.GetDownlink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return TxSettingsValidationError{
						field:  "downlink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "concentrator_timestamp":
			// no validation rules for ConcentratorTimestamp
		default:
			return TxSettingsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// TxSettingsValidationError is the validation error returned by
// TxSettings.ValidateFields if the designated constraints aren't met.
type TxSettingsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TxSettingsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TxSettingsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TxSettingsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TxSettingsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TxSettingsValidationError) ErrorName() string { return "TxSettingsValidationError" }

// Error satisfies the builtin error interface
func (e TxSettingsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTxSettings.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TxSettingsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TxSettingsValidationError{}

// ValidateFields checks the field values on GatewayAntennaIdentifiers with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GatewayAntennaIdentifiers) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayAntennaIdentifiersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return GatewayAntennaIdentifiersValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayAntennaIdentifiersValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "antenna_index":
			// no validation rules for AntennaIndex
		default:
			return GatewayAntennaIdentifiersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayAntennaIdentifiersValidationError is the validation error returned by
// GatewayAntennaIdentifiers.ValidateFields if the designated constraints
// aren't met.
type GatewayAntennaIdentifiersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayAntennaIdentifiersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayAntennaIdentifiersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayAntennaIdentifiersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayAntennaIdentifiersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayAntennaIdentifiersValidationError) ErrorName() string {
	return "GatewayAntennaIdentifiersValidationError"
}

// Error satisfies the builtin error interface
func (e GatewayAntennaIdentifiersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayAntennaIdentifiers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayAntennaIdentifiersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayAntennaIdentifiersValidationError{}

// ValidateFields checks the field values on ClassBCGatewayIdentifiers with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ClassBCGatewayIdentifiers) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ClassBCGatewayIdentifiersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return ClassBCGatewayIdentifiersValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ClassBCGatewayIdentifiersValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "antenna_index":
			// no validation rules for AntennaIndex
		case "group_index":
			// no validation rules for GroupIndex
		default:
			return ClassBCGatewayIdentifiersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ClassBCGatewayIdentifiersValidationError is the validation error returned by
// ClassBCGatewayIdentifiers.ValidateFields if the designated constraints
// aren't met.
type ClassBCGatewayIdentifiersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ClassBCGatewayIdentifiersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ClassBCGatewayIdentifiersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ClassBCGatewayIdentifiersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ClassBCGatewayIdentifiersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ClassBCGatewayIdentifiersValidationError) ErrorName() string {
	return "ClassBCGatewayIdentifiersValidationError"
}

// Error satisfies the builtin error interface
func (e ClassBCGatewayIdentifiersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sClassBCGatewayIdentifiers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ClassBCGatewayIdentifiersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ClassBCGatewayIdentifiersValidationError{}

// ValidateFields checks the field values on UplinkToken with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *UplinkToken) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UplinkTokenFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return UplinkTokenValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UplinkTokenValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "timestamp":
			// no validation rules for Timestamp
		case "server_time":

			if v, ok := interface{}(m.GetServerTime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UplinkTokenValidationError{
						field:  "server_time",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "concentrator_time":
			// no validation rules for ConcentratorTime
		case "gateway_time":

			if v, ok := interface{}(m.GetGatewayTime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UplinkTokenValidationError{
						field:  "gateway_time",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UplinkTokenValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UplinkTokenValidationError is the validation error returned by
// UplinkToken.ValidateFields if the designated constraints aren't met.
type UplinkTokenValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UplinkTokenValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UplinkTokenValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UplinkTokenValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UplinkTokenValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UplinkTokenValidationError) ErrorName() string { return "UplinkTokenValidationError" }

// Error satisfies the builtin error interface
func (e UplinkTokenValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUplinkToken.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UplinkTokenValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UplinkTokenValidationError{}

// ValidateFields checks the field values on DownlinkPath with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DownlinkPath) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DownlinkPathFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "path":
			if m.Path == nil {
				return DownlinkPathValidationError{
					field:  "path",
					reason: "value is required",
				}
			}
			if len(subs) == 0 {
				subs = []string{
					"uplink_token", "fixed",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "uplink_token":
					w, ok := m.Path.(*DownlinkPath_UplinkToken)
					if !ok || w == nil {
						continue
					}
					// no validation rules for UplinkToken
				case "fixed":
					w, ok := m.Path.(*DownlinkPath_Fixed)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetFixed()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return DownlinkPathValidationError{
								field:  "fixed",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return DownlinkPathValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DownlinkPathValidationError is the validation error returned by
// DownlinkPath.ValidateFields if the designated constraints aren't met.
type DownlinkPathValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DownlinkPathValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DownlinkPathValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DownlinkPathValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DownlinkPathValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DownlinkPathValidationError) ErrorName() string { return "DownlinkPathValidationError" }

// Error satisfies the builtin error interface
func (e DownlinkPathValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDownlinkPath.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DownlinkPathValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DownlinkPathValidationError{}

// ValidateFields checks the field values on TxRequest with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *TxRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = TxRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "class":
			// no validation rules for Class
		case "downlink_paths":

			for idx, item := range m.GetDownlinkPaths() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return TxRequestValidationError{
							field:  fmt.Sprintf("downlink_paths[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "rx1_delay":

			if _, ok := RxDelay_name[int32(m.GetRx1Delay())]; !ok {
				return TxRequestValidationError{
					field:  "rx1_delay",
					reason: "value must be one of the defined enum values",
				}
			}

		case "rx1_data_rate":

			if v, ok := interface{}(m.GetRx1DataRate()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return TxRequestValidationError{
						field:  "rx1_data_rate",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "rx1_frequency":
			// no validation rules for Rx1Frequency
		case "rx2_data_rate":

			if v, ok := interface{}(m.GetRx2DataRate()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return TxRequestValidationError{
						field:  "rx2_data_rate",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "rx2_frequency":
			// no validation rules for Rx2Frequency
		case "priority":

			if _, ok := TxSchedulePriority_name[int32(m.GetPriority())]; !ok {
				return TxRequestValidationError{
					field:  "priority",
					reason: "value must be one of the defined enum values",
				}
			}

		case "absolute_time":

			if v, ok := interface{}(m.GetAbsoluteTime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return TxRequestValidationError{
						field:  "absolute_time",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "frequency_plan_id":

			if utf8.RuneCountInString(m.GetFrequencyPlanId()) > 64 {
				return TxRequestValidationError{
					field:  "frequency_plan_id",
					reason: "value length must be at most 64 runes",
				}
			}

		case "advanced":

			if v, ok := interface{}(m.GetAdvanced()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return TxRequestValidationError{
						field:  "advanced",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return TxRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// TxRequestValidationError is the validation error returned by
// TxRequest.ValidateFields if the designated constraints aren't met.
type TxRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TxRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TxRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TxRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TxRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TxRequestValidationError) ErrorName() string { return "TxRequestValidationError" }

// Error satisfies the builtin error interface
func (e TxRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTxRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TxRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TxRequestValidationError{}

// ValidateFields checks the field values on RelaySecondChannel with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RelaySecondChannel) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RelaySecondChannelFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ack_offset":

			if _, ok := RelaySecondChAckOffset_name[int32(m.GetAckOffset())]; !ok {
				return RelaySecondChannelValidationError{
					field:  "ack_offset",
					reason: "value must be one of the defined enum values",
				}
			}

		case "data_rate_index":

			if _, ok := DataRateIndex_name[int32(m.GetDataRateIndex())]; !ok {
				return RelaySecondChannelValidationError{
					field:  "data_rate_index",
					reason: "value must be one of the defined enum values",
				}
			}

		case "frequency":

			if m.GetFrequency() < 100000 {
				return RelaySecondChannelValidationError{
					field:  "frequency",
					reason: "value must be greater than or equal to 100000",
				}
			}

		default:
			return RelaySecondChannelValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RelaySecondChannelValidationError is the validation error returned by
// RelaySecondChannel.ValidateFields if the designated constraints aren't met.
type RelaySecondChannelValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelaySecondChannelValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelaySecondChannelValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelaySecondChannelValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelaySecondChannelValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelaySecondChannelValidationError) ErrorName() string {
	return "RelaySecondChannelValidationError"
}

// Error satisfies the builtin error interface
func (e RelaySecondChannelValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelaySecondChannel.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelaySecondChannelValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelaySecondChannelValidationError{}

// ValidateFields checks the field values on RelayUplinkForwardLimits with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RelayUplinkForwardLimits) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RelayUplinkForwardLimitsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "bucket_size":

			if _, ok := RelayLimitBucketSize_name[int32(m.GetBucketSize())]; !ok {
				return RelayUplinkForwardLimitsValidationError{
					field:  "bucket_size",
					reason: "value must be one of the defined enum values",
				}
			}

		case "reload_rate":

			if m.GetReloadRate() > 62 {
				return RelayUplinkForwardLimitsValidationError{
					field:  "reload_rate",
					reason: "value must be less than or equal to 62",
				}
			}

		default:
			return RelayUplinkForwardLimitsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RelayUplinkForwardLimitsValidationError is the validation error returned by
// RelayUplinkForwardLimits.ValidateFields if the designated constraints
// aren't met.
type RelayUplinkForwardLimitsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelayUplinkForwardLimitsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelayUplinkForwardLimitsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelayUplinkForwardLimitsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelayUplinkForwardLimitsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelayUplinkForwardLimitsValidationError) ErrorName() string {
	return "RelayUplinkForwardLimitsValidationError"
}

// Error satisfies the builtin error interface
func (e RelayUplinkForwardLimitsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelayUplinkForwardLimits.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelayUplinkForwardLimitsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelayUplinkForwardLimitsValidationError{}

// ValidateFields checks the field values on RelayForwardLimits with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RelayForwardLimits) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RelayForwardLimitsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "bucket_size":

			if _, ok := RelayLimitBucketSize_name[int32(m.GetBucketSize())]; !ok {
				return RelayForwardLimitsValidationError{
					field:  "bucket_size",
					reason: "value must be one of the defined enum values",
				}
			}

		case "reload_rate":

			if m.GetReloadRate() > 126 {
				return RelayForwardLimitsValidationError{
					field:  "reload_rate",
					reason: "value must be less than or equal to 126",
				}
			}

		default:
			return RelayForwardLimitsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RelayForwardLimitsValidationError is the validation error returned by
// RelayForwardLimits.ValidateFields if the designated constraints aren't met.
type RelayForwardLimitsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelayForwardLimitsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelayForwardLimitsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelayForwardLimitsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelayForwardLimitsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelayForwardLimitsValidationError) ErrorName() string {
	return "RelayForwardLimitsValidationError"
}

// Error satisfies the builtin error interface
func (e RelayForwardLimitsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelayForwardLimits.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelayForwardLimitsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelayForwardLimitsValidationError{}

// ValidateFields checks the field values on RelayEndDeviceAlwaysMode with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RelayEndDeviceAlwaysMode) ValidateFields(paths ...string) error {
	if len(paths) > 0 {
		return fmt.Errorf("message RelayEndDeviceAlwaysMode has no fields, but paths %s were specified", paths)
	}
	return nil
}

// RelayEndDeviceAlwaysModeValidationError is the validation error returned by
// RelayEndDeviceAlwaysMode.ValidateFields if the designated constraints
// aren't met.
type RelayEndDeviceAlwaysModeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelayEndDeviceAlwaysModeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelayEndDeviceAlwaysModeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelayEndDeviceAlwaysModeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelayEndDeviceAlwaysModeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelayEndDeviceAlwaysModeValidationError) ErrorName() string {
	return "RelayEndDeviceAlwaysModeValidationError"
}

// Error satisfies the builtin error interface
func (e RelayEndDeviceAlwaysModeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelayEndDeviceAlwaysMode.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelayEndDeviceAlwaysModeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelayEndDeviceAlwaysModeValidationError{}

// ValidateFields checks the field values on RelayEndDeviceDynamicMode with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RelayEndDeviceDynamicMode) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RelayEndDeviceDynamicModeFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "smart_enable_level":

			if _, ok := RelaySmartEnableLevel_name[int32(m.GetSmartEnableLevel())]; !ok {
				return RelayEndDeviceDynamicModeValidationError{
					field:  "smart_enable_level",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return RelayEndDeviceDynamicModeValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RelayEndDeviceDynamicModeValidationError is the validation error returned by
// RelayEndDeviceDynamicMode.ValidateFields if the designated constraints
// aren't met.
type RelayEndDeviceDynamicModeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelayEndDeviceDynamicModeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelayEndDeviceDynamicModeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelayEndDeviceDynamicModeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelayEndDeviceDynamicModeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelayEndDeviceDynamicModeValidationError) ErrorName() string {
	return "RelayEndDeviceDynamicModeValidationError"
}

// Error satisfies the builtin error interface
func (e RelayEndDeviceDynamicModeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelayEndDeviceDynamicMode.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelayEndDeviceDynamicModeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelayEndDeviceDynamicModeValidationError{}

// ValidateFields checks the field values on RelayEndDeviceControlledMode with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *RelayEndDeviceControlledMode) ValidateFields(paths ...string) error {
	if len(paths) > 0 {
		return fmt.Errorf("message RelayEndDeviceControlledMode has no fields, but paths %s were specified", paths)
	}
	return nil
}

// RelayEndDeviceControlledModeValidationError is the validation error returned
// by RelayEndDeviceControlledMode.ValidateFields if the designated
// constraints aren't met.
type RelayEndDeviceControlledModeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelayEndDeviceControlledModeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelayEndDeviceControlledModeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelayEndDeviceControlledModeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelayEndDeviceControlledModeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelayEndDeviceControlledModeValidationError) ErrorName() string {
	return "RelayEndDeviceControlledModeValidationError"
}

// Error satisfies the builtin error interface
func (e RelayEndDeviceControlledModeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelayEndDeviceControlledMode.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelayEndDeviceControlledModeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelayEndDeviceControlledModeValidationError{}

// ValidateFields checks the field values on MACCommand with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *MACCommand) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommandFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "cid":

			if _, ok := _MACCommand_Cid_NotInLookup[m.GetCid()]; ok {
				return MACCommandValidationError{
					field:  "cid",
					reason: "value must not be in list [0]",
				}
			}

			if _, ok := MACCommandIdentifier_name[int32(m.GetCid())]; !ok {
				return MACCommandValidationError{
					field:  "cid",
					reason: "value must be one of the defined enum values",
				}
			}

		case "payload":
			if len(subs) == 0 {
				subs = []string{
					"raw_payload", "reset_ind", "reset_conf", "link_check_ans", "link_adr_req", "link_adr_ans", "duty_cycle_req", "rx_param_setup_req", "rx_param_setup_ans", "dev_status_ans", "new_channel_req", "new_channel_ans", "dl_channel_req", "dl_channel_ans", "rx_timing_setup_req", "tx_param_setup_req", "rekey_ind", "rekey_conf", "adr_param_setup_req", "device_time_ans", "force_rejoin_req", "rejoin_param_setup_req", "rejoin_param_setup_ans", "ping_slot_info_req", "ping_slot_channel_req", "ping_slot_channel_ans", "beacon_timing_ans", "beacon_freq_req", "beacon_freq_ans", "device_mode_ind", "device_mode_conf", "relay_conf_req", "relay_conf_ans", "relay_end_device_conf_req", "relay_end_device_conf_ans", "relay_update_uplink_list_req", "relay_update_uplink_list_ans", "relay_ctrl_uplink_list_req", "relay_ctrl_uplink_list_ans", "relay_configure_fwd_limit_req", "relay_configure_fwd_limit_ans", "relay_notify_new_end_device_req",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "raw_payload":
					w, ok := m.Payload.(*MACCommand_RawPayload)
					if !ok || w == nil {
						continue
					}
					// no validation rules for RawPayload
				case "reset_ind":
					w, ok := m.Payload.(*MACCommand_ResetInd_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetResetInd()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "reset_ind",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "reset_conf":
					w, ok := m.Payload.(*MACCommand_ResetConf_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetResetConf()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "reset_conf",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "link_check_ans":
					w, ok := m.Payload.(*MACCommand_LinkCheckAns_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetLinkCheckAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "link_check_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "link_adr_req":
					w, ok := m.Payload.(*MACCommand_LinkAdrReq)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetLinkAdrReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "link_adr_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "link_adr_ans":
					w, ok := m.Payload.(*MACCommand_LinkAdrAns)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetLinkAdrAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "link_adr_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "duty_cycle_req":
					w, ok := m.Payload.(*MACCommand_DutyCycleReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDutyCycleReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "duty_cycle_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "rx_param_setup_req":
					w, ok := m.Payload.(*MACCommand_RxParamSetupReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRxParamSetupReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "rx_param_setup_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "rx_param_setup_ans":
					w, ok := m.Payload.(*MACCommand_RxParamSetupAns_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRxParamSetupAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "rx_param_setup_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "dev_status_ans":
					w, ok := m.Payload.(*MACCommand_DevStatusAns_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDevStatusAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "dev_status_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "new_channel_req":
					w, ok := m.Payload.(*MACCommand_NewChannelReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetNewChannelReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "new_channel_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "new_channel_ans":
					w, ok := m.Payload.(*MACCommand_NewChannelAns_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetNewChannelAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "new_channel_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "dl_channel_req":
					w, ok := m.Payload.(*MACCommand_DlChannelReq)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDlChannelReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "dl_channel_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "dl_channel_ans":
					w, ok := m.Payload.(*MACCommand_DlChannelAns)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDlChannelAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "dl_channel_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "rx_timing_setup_req":
					w, ok := m.Payload.(*MACCommand_RxTimingSetupReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRxTimingSetupReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "rx_timing_setup_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "tx_param_setup_req":
					w, ok := m.Payload.(*MACCommand_TxParamSetupReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetTxParamSetupReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "tx_param_setup_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "rekey_ind":
					w, ok := m.Payload.(*MACCommand_RekeyInd_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRekeyInd()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "rekey_ind",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "rekey_conf":
					w, ok := m.Payload.(*MACCommand_RekeyConf_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRekeyConf()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "rekey_conf",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "adr_param_setup_req":
					w, ok := m.Payload.(*MACCommand_AdrParamSetupReq)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetAdrParamSetupReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "adr_param_setup_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "device_time_ans":
					w, ok := m.Payload.(*MACCommand_DeviceTimeAns_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDeviceTimeAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "device_time_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "force_rejoin_req":
					w, ok := m.Payload.(*MACCommand_ForceRejoinReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetForceRejoinReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "force_rejoin_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "rejoin_param_setup_req":
					w, ok := m.Payload.(*MACCommand_RejoinParamSetupReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRejoinParamSetupReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "rejoin_param_setup_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "rejoin_param_setup_ans":
					w, ok := m.Payload.(*MACCommand_RejoinParamSetupAns_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRejoinParamSetupAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "rejoin_param_setup_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "ping_slot_info_req":
					w, ok := m.Payload.(*MACCommand_PingSlotInfoReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetPingSlotInfoReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "ping_slot_info_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "ping_slot_channel_req":
					w, ok := m.Payload.(*MACCommand_PingSlotChannelReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetPingSlotChannelReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "ping_slot_channel_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "ping_slot_channel_ans":
					w, ok := m.Payload.(*MACCommand_PingSlotChannelAns_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetPingSlotChannelAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "ping_slot_channel_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "beacon_timing_ans":
					w, ok := m.Payload.(*MACCommand_BeaconTimingAns_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetBeaconTimingAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "beacon_timing_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "beacon_freq_req":
					w, ok := m.Payload.(*MACCommand_BeaconFreqReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetBeaconFreqReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "beacon_freq_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "beacon_freq_ans":
					w, ok := m.Payload.(*MACCommand_BeaconFreqAns_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetBeaconFreqAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "beacon_freq_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "device_mode_ind":
					w, ok := m.Payload.(*MACCommand_DeviceModeInd_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDeviceModeInd()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "device_mode_ind",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "device_mode_conf":
					w, ok := m.Payload.(*MACCommand_DeviceModeConf_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDeviceModeConf()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "device_mode_conf",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "relay_conf_req":
					w, ok := m.Payload.(*MACCommand_RelayConfReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRelayConfReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "relay_conf_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "relay_conf_ans":
					w, ok := m.Payload.(*MACCommand_RelayConfAns_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRelayConfAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "relay_conf_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "relay_end_device_conf_req":
					w, ok := m.Payload.(*MACCommand_RelayEndDeviceConfReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRelayEndDeviceConfReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "relay_end_device_conf_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "relay_end_device_conf_ans":
					w, ok := m.Payload.(*MACCommand_RelayEndDeviceConfAns_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRelayEndDeviceConfAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "relay_end_device_conf_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "relay_update_uplink_list_req":
					w, ok := m.Payload.(*MACCommand_RelayUpdateUplinkListReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRelayUpdateUplinkListReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "relay_update_uplink_list_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "relay_update_uplink_list_ans":
					w, ok := m.Payload.(*MACCommand_RelayUpdateUplinkListAns_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRelayUpdateUplinkListAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "relay_update_uplink_list_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "relay_ctrl_uplink_list_req":
					w, ok := m.Payload.(*MACCommand_RelayCtrlUplinkListReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRelayCtrlUplinkListReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "relay_ctrl_uplink_list_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "relay_ctrl_uplink_list_ans":
					w, ok := m.Payload.(*MACCommand_RelayCtrlUplinkListAns_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRelayCtrlUplinkListAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "relay_ctrl_uplink_list_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "relay_configure_fwd_limit_req":
					w, ok := m.Payload.(*MACCommand_RelayConfigureFwdLimitReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRelayConfigureFwdLimitReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "relay_configure_fwd_limit_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "relay_configure_fwd_limit_ans":
					w, ok := m.Payload.(*MACCommand_RelayConfigureFwdLimitAns_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRelayConfigureFwdLimitAns()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "relay_configure_fwd_limit_ans",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "relay_notify_new_end_device_req":
					w, ok := m.Payload.(*MACCommand_RelayNotifyNewEndDeviceReq_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetRelayNotifyNewEndDeviceReq()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommandValidationError{
								field:  "relay_notify_new_end_device_req",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return MACCommandValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommandValidationError is the validation error returned by
// MACCommand.ValidateFields if the designated constraints aren't met.
type MACCommandValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommandValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommandValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommandValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommandValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommandValidationError) ErrorName() string { return "MACCommandValidationError" }

// Error satisfies the builtin error interface
func (e MACCommandValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommandValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommandValidationError{}

var _MACCommand_Cid_NotInLookup = map[MACCommandIdentifier]struct{}{
	0: {},
}

// ValidateFields checks the field values on MACCommands with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *MACCommands) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommandsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "commands":

			for idx, item := range m.GetCommands() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return MACCommandsValidationError{
							field:  fmt.Sprintf("commands[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return MACCommandsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommandsValidationError is the validation error returned by
// MACCommands.ValidateFields if the designated constraints aren't met.
type MACCommandsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommandsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommandsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommandsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommandsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommandsValidationError) ErrorName() string { return "MACCommandsValidationError" }

// Error satisfies the builtin error interface
func (e MACCommandsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommands.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommandsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommandsValidationError{}

// ValidateFields checks the field values on FrequencyValue with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *FrequencyValue) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = FrequencyValueFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "value":

			if m.GetValue() < 100000 {
				return FrequencyValueValidationError{
					field:  "value",
					reason: "value must be greater than or equal to 100000",
				}
			}

		default:
			return FrequencyValueValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// FrequencyValueValidationError is the validation error returned by
// FrequencyValue.ValidateFields if the designated constraints aren't met.
type FrequencyValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FrequencyValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FrequencyValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FrequencyValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FrequencyValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FrequencyValueValidationError) ErrorName() string { return "FrequencyValueValidationError" }

// Error satisfies the builtin error interface
func (e FrequencyValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFrequencyValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FrequencyValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FrequencyValueValidationError{}

// ValidateFields checks the field values on ZeroableFrequencyValue with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ZeroableFrequencyValue) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ZeroableFrequencyValueFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "value":

			if val := m.GetValue(); val > 0 && val < 100000 {
				return ZeroableFrequencyValueValidationError{
					field:  "value",
					reason: "value must be outside range (0, 100000)",
				}
			}

		default:
			return ZeroableFrequencyValueValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ZeroableFrequencyValueValidationError is the validation error returned by
// ZeroableFrequencyValue.ValidateFields if the designated constraints aren't met.
type ZeroableFrequencyValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ZeroableFrequencyValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ZeroableFrequencyValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ZeroableFrequencyValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ZeroableFrequencyValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ZeroableFrequencyValueValidationError) ErrorName() string {
	return "ZeroableFrequencyValueValidationError"
}

// Error satisfies the builtin error interface
func (e ZeroableFrequencyValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sZeroableFrequencyValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ZeroableFrequencyValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ZeroableFrequencyValueValidationError{}

// ValidateFields checks the field values on DataRateOffsetValue with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DataRateOffsetValue) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DataRateOffsetValueFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "value":

			if _, ok := DataRateOffset_name[int32(m.GetValue())]; !ok {
				return DataRateOffsetValueValidationError{
					field:  "value",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return DataRateOffsetValueValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DataRateOffsetValueValidationError is the validation error returned by
// DataRateOffsetValue.ValidateFields if the designated constraints aren't met.
type DataRateOffsetValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DataRateOffsetValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DataRateOffsetValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DataRateOffsetValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DataRateOffsetValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DataRateOffsetValueValidationError) ErrorName() string {
	return "DataRateOffsetValueValidationError"
}

// Error satisfies the builtin error interface
func (e DataRateOffsetValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDataRateOffsetValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DataRateOffsetValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DataRateOffsetValueValidationError{}

// ValidateFields checks the field values on DataRateIndexValue with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DataRateIndexValue) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DataRateIndexValueFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "value":

			if _, ok := DataRateIndex_name[int32(m.GetValue())]; !ok {
				return DataRateIndexValueValidationError{
					field:  "value",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return DataRateIndexValueValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DataRateIndexValueValidationError is the validation error returned by
// DataRateIndexValue.ValidateFields if the designated constraints aren't met.
type DataRateIndexValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DataRateIndexValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DataRateIndexValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DataRateIndexValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DataRateIndexValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DataRateIndexValueValidationError) ErrorName() string {
	return "DataRateIndexValueValidationError"
}

// Error satisfies the builtin error interface
func (e DataRateIndexValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDataRateIndexValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DataRateIndexValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DataRateIndexValueValidationError{}

// ValidateFields checks the field values on PingSlotPeriodValue with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *PingSlotPeriodValue) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = PingSlotPeriodValueFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "value":

			if _, ok := PingSlotPeriod_name[int32(m.GetValue())]; !ok {
				return PingSlotPeriodValueValidationError{
					field:  "value",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return PingSlotPeriodValueValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// PingSlotPeriodValueValidationError is the validation error returned by
// PingSlotPeriodValue.ValidateFields if the designated constraints aren't met.
type PingSlotPeriodValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PingSlotPeriodValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PingSlotPeriodValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PingSlotPeriodValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PingSlotPeriodValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PingSlotPeriodValueValidationError) ErrorName() string {
	return "PingSlotPeriodValueValidationError"
}

// Error satisfies the builtin error interface
func (e PingSlotPeriodValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPingSlotPeriodValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PingSlotPeriodValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PingSlotPeriodValueValidationError{}

// ValidateFields checks the field values on AggregatedDutyCycleValue with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *AggregatedDutyCycleValue) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = AggregatedDutyCycleValueFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "value":

			if _, ok := AggregatedDutyCycle_name[int32(m.GetValue())]; !ok {
				return AggregatedDutyCycleValueValidationError{
					field:  "value",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return AggregatedDutyCycleValueValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// AggregatedDutyCycleValueValidationError is the validation error returned by
// AggregatedDutyCycleValue.ValidateFields if the designated constraints
// aren't met.
type AggregatedDutyCycleValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AggregatedDutyCycleValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AggregatedDutyCycleValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AggregatedDutyCycleValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AggregatedDutyCycleValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AggregatedDutyCycleValueValidationError) ErrorName() string {
	return "AggregatedDutyCycleValueValidationError"
}

// Error satisfies the builtin error interface
func (e AggregatedDutyCycleValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAggregatedDutyCycleValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AggregatedDutyCycleValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AggregatedDutyCycleValueValidationError{}

// ValidateFields checks the field values on RxDelayValue with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RxDelayValue) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RxDelayValueFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "value":

			if _, ok := RxDelay_name[int32(m.GetValue())]; !ok {
				return RxDelayValueValidationError{
					field:  "value",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return RxDelayValueValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RxDelayValueValidationError is the validation error returned by
// RxDelayValue.ValidateFields if the designated constraints aren't met.
type RxDelayValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RxDelayValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RxDelayValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RxDelayValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RxDelayValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RxDelayValueValidationError) ErrorName() string { return "RxDelayValueValidationError" }

// Error satisfies the builtin error interface
func (e RxDelayValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRxDelayValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RxDelayValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RxDelayValueValidationError{}

// ValidateFields checks the field values on ADRAckLimitExponentValue with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ADRAckLimitExponentValue) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ADRAckLimitExponentValueFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "value":

			if _, ok := ADRAckLimitExponent_name[int32(m.GetValue())]; !ok {
				return ADRAckLimitExponentValueValidationError{
					field:  "value",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return ADRAckLimitExponentValueValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ADRAckLimitExponentValueValidationError is the validation error returned by
// ADRAckLimitExponentValue.ValidateFields if the designated constraints
// aren't met.
type ADRAckLimitExponentValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ADRAckLimitExponentValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ADRAckLimitExponentValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ADRAckLimitExponentValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ADRAckLimitExponentValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ADRAckLimitExponentValueValidationError) ErrorName() string {
	return "ADRAckLimitExponentValueValidationError"
}

// Error satisfies the builtin error interface
func (e ADRAckLimitExponentValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sADRAckLimitExponentValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ADRAckLimitExponentValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ADRAckLimitExponentValueValidationError{}

// ValidateFields checks the field values on ADRAckDelayExponentValue with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ADRAckDelayExponentValue) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ADRAckDelayExponentValueFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "value":

			if _, ok := ADRAckDelayExponent_name[int32(m.GetValue())]; !ok {
				return ADRAckDelayExponentValueValidationError{
					field:  "value",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return ADRAckDelayExponentValueValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ADRAckDelayExponentValueValidationError is the validation error returned by
// ADRAckDelayExponentValue.ValidateFields if the designated constraints
// aren't met.
type ADRAckDelayExponentValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ADRAckDelayExponentValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ADRAckDelayExponentValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ADRAckDelayExponentValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ADRAckDelayExponentValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ADRAckDelayExponentValueValidationError) ErrorName() string {
	return "ADRAckDelayExponentValueValidationError"
}

// Error satisfies the builtin error interface
func (e ADRAckDelayExponentValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sADRAckDelayExponentValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ADRAckDelayExponentValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ADRAckDelayExponentValueValidationError{}

// ValidateFields checks the field values on DeviceEIRPValue with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DeviceEIRPValue) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DeviceEIRPValueFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "value":

			if _, ok := DeviceEIRP_name[int32(m.GetValue())]; !ok {
				return DeviceEIRPValueValidationError{
					field:  "value",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return DeviceEIRPValueValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DeviceEIRPValueValidationError is the validation error returned by
// DeviceEIRPValue.ValidateFields if the designated constraints aren't met.
type DeviceEIRPValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DeviceEIRPValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DeviceEIRPValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DeviceEIRPValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DeviceEIRPValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DeviceEIRPValueValidationError) ErrorName() string { return "DeviceEIRPValueValidationError" }

// Error satisfies the builtin error interface
func (e DeviceEIRPValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDeviceEIRPValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DeviceEIRPValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DeviceEIRPValueValidationError{}

// ValidateFields checks the field values on RelayForwardUplinkReq with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RelayForwardUplinkReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RelayForwardUplinkReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "data_rate":

			if m.GetDataRate() == nil {
				return RelayForwardUplinkReqValidationError{
					field:  "data_rate",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetDataRate()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return RelayForwardUplinkReqValidationError{
						field:  "data_rate",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "snr":

			if val := m.GetSnr(); val < -20 || val > 11 {
				return RelayForwardUplinkReqValidationError{
					field:  "snr",
					reason: "value must be inside range [-20, 11]",
				}
			}

		case "rssi":

			if val := m.GetRssi(); val < -142 || val > -15 {
				return RelayForwardUplinkReqValidationError{
					field:  "rssi",
					reason: "value must be inside range [-142, -15]",
				}
			}

		case "wor_channel":

			if _, ok := RelayWORChannel_name[int32(m.GetWorChannel())]; !ok {
				return RelayForwardUplinkReqValidationError{
					field:  "wor_channel",
					reason: "value must be one of the defined enum values",
				}
			}

		case "frequency":

			if m.GetFrequency() < 100000 {
				return RelayForwardUplinkReqValidationError{
					field:  "frequency",
					reason: "value must be greater than or equal to 100000",
				}
			}

		case "raw_payload":
			// no validation rules for RawPayload
		default:
			return RelayForwardUplinkReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RelayForwardUplinkReqValidationError is the validation error returned by
// RelayForwardUplinkReq.ValidateFields if the designated constraints aren't met.
type RelayForwardUplinkReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelayForwardUplinkReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelayForwardUplinkReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelayForwardUplinkReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelayForwardUplinkReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelayForwardUplinkReqValidationError) ErrorName() string {
	return "RelayForwardUplinkReqValidationError"
}

// Error satisfies the builtin error interface
func (e RelayForwardUplinkReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelayForwardUplinkReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelayForwardUplinkReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelayForwardUplinkReqValidationError{}

// ValidateFields checks the field values on RelayForwardDownlinkReq with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RelayForwardDownlinkReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RelayForwardDownlinkReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "raw_payload":
			// no validation rules for RawPayload
		default:
			return RelayForwardDownlinkReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RelayForwardDownlinkReqValidationError is the validation error returned by
// RelayForwardDownlinkReq.ValidateFields if the designated constraints aren't met.
type RelayForwardDownlinkReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelayForwardDownlinkReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelayForwardDownlinkReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelayForwardDownlinkReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelayForwardDownlinkReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelayForwardDownlinkReqValidationError) ErrorName() string {
	return "RelayForwardDownlinkReqValidationError"
}

// Error satisfies the builtin error interface
func (e RelayForwardDownlinkReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelayForwardDownlinkReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelayForwardDownlinkReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelayForwardDownlinkReqValidationError{}

// ValidateFields checks the field values on RelayUplinkToken with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RelayUplinkToken) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RelayUplinkTokenFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return RelayUplinkTokenValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return RelayUplinkTokenValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "session_key_id":
			// no validation rules for SessionKeyId
		case "full_f_cnt":
			// no validation rules for FullFCnt
		default:
			return RelayUplinkTokenValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RelayUplinkTokenValidationError is the validation error returned by
// RelayUplinkToken.ValidateFields if the designated constraints aren't met.
type RelayUplinkTokenValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelayUplinkTokenValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelayUplinkTokenValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelayUplinkTokenValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelayUplinkTokenValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelayUplinkTokenValidationError) ErrorName() string { return "RelayUplinkTokenValidationError" }

// Error satisfies the builtin error interface
func (e RelayUplinkTokenValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelayUplinkToken.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelayUplinkTokenValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelayUplinkTokenValidationError{}

// ValidateFields checks the field values on TxSettings_Downlink with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *TxSettings_Downlink) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = TxSettings_DownlinkFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "antenna_index":
			// no validation rules for AntennaIndex
		case "tx_power":
			// no validation rules for TxPower
		case "invert_polarization":
			// no validation rules for InvertPolarization
		default:
			return TxSettings_DownlinkValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// TxSettings_DownlinkValidationError is the validation error returned by
// TxSettings_Downlink.ValidateFields if the designated constraints aren't met.
type TxSettings_DownlinkValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TxSettings_DownlinkValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TxSettings_DownlinkValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TxSettings_DownlinkValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TxSettings_DownlinkValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TxSettings_DownlinkValidationError) ErrorName() string {
	return "TxSettings_DownlinkValidationError"
}

// Error satisfies the builtin error interface
func (e TxSettings_DownlinkValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTxSettings_Downlink.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TxSettings_DownlinkValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TxSettings_DownlinkValidationError{}

// ValidateFields checks the field values on MACCommand_ResetInd with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_ResetInd) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_ResetIndFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "minor_version":

			if _, ok := _MACCommand_ResetInd_MinorVersion_InLookup[m.GetMinorVersion()]; !ok {
				return MACCommand_ResetIndValidationError{
					field:  "minor_version",
					reason: "value must be in list [1]",
				}
			}

			if _, ok := Minor_name[int32(m.GetMinorVersion())]; !ok {
				return MACCommand_ResetIndValidationError{
					field:  "minor_version",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_ResetIndValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_ResetIndValidationError is the validation error returned by
// MACCommand_ResetInd.ValidateFields if the designated constraints aren't met.
type MACCommand_ResetIndValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_ResetIndValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_ResetIndValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_ResetIndValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_ResetIndValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_ResetIndValidationError) ErrorName() string {
	return "MACCommand_ResetIndValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_ResetIndValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_ResetInd.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_ResetIndValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_ResetIndValidationError{}

var _MACCommand_ResetInd_MinorVersion_InLookup = map[Minor]struct{}{
	1: {},
}

// ValidateFields checks the field values on MACCommand_ResetConf with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_ResetConf) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_ResetConfFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "minor_version":

			if _, ok := _MACCommand_ResetConf_MinorVersion_InLookup[m.GetMinorVersion()]; !ok {
				return MACCommand_ResetConfValidationError{
					field:  "minor_version",
					reason: "value must be in list [1]",
				}
			}

			if _, ok := Minor_name[int32(m.GetMinorVersion())]; !ok {
				return MACCommand_ResetConfValidationError{
					field:  "minor_version",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_ResetConfValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_ResetConfValidationError is the validation error returned by
// MACCommand_ResetConf.ValidateFields if the designated constraints aren't met.
type MACCommand_ResetConfValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_ResetConfValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_ResetConfValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_ResetConfValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_ResetConfValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_ResetConfValidationError) ErrorName() string {
	return "MACCommand_ResetConfValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_ResetConfValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_ResetConf.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_ResetConfValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_ResetConfValidationError{}

var _MACCommand_ResetConf_MinorVersion_InLookup = map[Minor]struct{}{
	1: {},
}

// ValidateFields checks the field values on MACCommand_LinkCheckAns with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_LinkCheckAns) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_LinkCheckAnsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "margin":

			if m.GetMargin() > 254 {
				return MACCommand_LinkCheckAnsValidationError{
					field:  "margin",
					reason: "value must be less than or equal to 254",
				}
			}

		case "gateway_count":

			if m.GetGatewayCount() > 255 {
				return MACCommand_LinkCheckAnsValidationError{
					field:  "gateway_count",
					reason: "value must be less than or equal to 255",
				}
			}

		default:
			return MACCommand_LinkCheckAnsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_LinkCheckAnsValidationError is the validation error returned by
// MACCommand_LinkCheckAns.ValidateFields if the designated constraints aren't met.
type MACCommand_LinkCheckAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_LinkCheckAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_LinkCheckAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_LinkCheckAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_LinkCheckAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_LinkCheckAnsValidationError) ErrorName() string {
	return "MACCommand_LinkCheckAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_LinkCheckAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_LinkCheckAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_LinkCheckAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_LinkCheckAnsValidationError{}

// ValidateFields checks the field values on MACCommand_LinkADRReq with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_LinkADRReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_LinkADRReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "data_rate_index":

			if _, ok := DataRateIndex_name[int32(m.GetDataRateIndex())]; !ok {
				return MACCommand_LinkADRReqValidationError{
					field:  "data_rate_index",
					reason: "value must be one of the defined enum values",
				}
			}

		case "tx_power_index":

			if m.GetTxPowerIndex() > 15 {
				return MACCommand_LinkADRReqValidationError{
					field:  "tx_power_index",
					reason: "value must be less than or equal to 15",
				}
			}

		case "channel_mask":

			if len(m.GetChannelMask()) > 16 {
				return MACCommand_LinkADRReqValidationError{
					field:  "channel_mask",
					reason: "value must contain no more than 16 item(s)",
				}
			}

		case "channel_mask_control":

			if m.GetChannelMaskControl() > 7 {
				return MACCommand_LinkADRReqValidationError{
					field:  "channel_mask_control",
					reason: "value must be less than or equal to 7",
				}
			}

		case "nb_trans":

			if m.GetNbTrans() > 15 {
				return MACCommand_LinkADRReqValidationError{
					field:  "nb_trans",
					reason: "value must be less than or equal to 15",
				}
			}

		default:
			return MACCommand_LinkADRReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_LinkADRReqValidationError is the validation error returned by
// MACCommand_LinkADRReq.ValidateFields if the designated constraints aren't met.
type MACCommand_LinkADRReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_LinkADRReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_LinkADRReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_LinkADRReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_LinkADRReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_LinkADRReqValidationError) ErrorName() string {
	return "MACCommand_LinkADRReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_LinkADRReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_LinkADRReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_LinkADRReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_LinkADRReqValidationError{}

// ValidateFields checks the field values on MACCommand_LinkADRAns with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_LinkADRAns) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_LinkADRAnsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "channel_mask_ack":
			// no validation rules for ChannelMaskAck
		case "data_rate_index_ack":
			// no validation rules for DataRateIndexAck
		case "tx_power_index_ack":
			// no validation rules for TxPowerIndexAck
		default:
			return MACCommand_LinkADRAnsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_LinkADRAnsValidationError is the validation error returned by
// MACCommand_LinkADRAns.ValidateFields if the designated constraints aren't met.
type MACCommand_LinkADRAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_LinkADRAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_LinkADRAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_LinkADRAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_LinkADRAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_LinkADRAnsValidationError) ErrorName() string {
	return "MACCommand_LinkADRAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_LinkADRAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_LinkADRAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_LinkADRAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_LinkADRAnsValidationError{}

// ValidateFields checks the field values on MACCommand_DutyCycleReq with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_DutyCycleReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_DutyCycleReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "max_duty_cycle":

			if _, ok := AggregatedDutyCycle_name[int32(m.GetMaxDutyCycle())]; !ok {
				return MACCommand_DutyCycleReqValidationError{
					field:  "max_duty_cycle",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_DutyCycleReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_DutyCycleReqValidationError is the validation error returned by
// MACCommand_DutyCycleReq.ValidateFields if the designated constraints aren't met.
type MACCommand_DutyCycleReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_DutyCycleReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_DutyCycleReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_DutyCycleReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_DutyCycleReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_DutyCycleReqValidationError) ErrorName() string {
	return "MACCommand_DutyCycleReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_DutyCycleReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_DutyCycleReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_DutyCycleReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_DutyCycleReqValidationError{}

// ValidateFields checks the field values on MACCommand_RxParamSetupReq with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *MACCommand_RxParamSetupReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RxParamSetupReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "rx2_data_rate_index":

			if _, ok := DataRateIndex_name[int32(m.GetRx2DataRateIndex())]; !ok {
				return MACCommand_RxParamSetupReqValidationError{
					field:  "rx2_data_rate_index",
					reason: "value must be one of the defined enum values",
				}
			}

		case "rx1_data_rate_offset":

			if _, ok := DataRateOffset_name[int32(m.GetRx1DataRateOffset())]; !ok {
				return MACCommand_RxParamSetupReqValidationError{
					field:  "rx1_data_rate_offset",
					reason: "value must be one of the defined enum values",
				}
			}

		case "rx2_frequency":

			if m.GetRx2Frequency() < 100000 {
				return MACCommand_RxParamSetupReqValidationError{
					field:  "rx2_frequency",
					reason: "value must be greater than or equal to 100000",
				}
			}

		default:
			return MACCommand_RxParamSetupReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RxParamSetupReqValidationError is the validation error returned
// by MACCommand_RxParamSetupReq.ValidateFields if the designated constraints
// aren't met.
type MACCommand_RxParamSetupReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RxParamSetupReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RxParamSetupReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RxParamSetupReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RxParamSetupReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RxParamSetupReqValidationError) ErrorName() string {
	return "MACCommand_RxParamSetupReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RxParamSetupReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RxParamSetupReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RxParamSetupReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RxParamSetupReqValidationError{}

// ValidateFields checks the field values on MACCommand_RxParamSetupAns with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *MACCommand_RxParamSetupAns) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RxParamSetupAnsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "rx2_data_rate_index_ack":
			// no validation rules for Rx2DataRateIndexAck
		case "rx1_data_rate_offset_ack":
			// no validation rules for Rx1DataRateOffsetAck
		case "rx2_frequency_ack":
			// no validation rules for Rx2FrequencyAck
		default:
			return MACCommand_RxParamSetupAnsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RxParamSetupAnsValidationError is the validation error returned
// by MACCommand_RxParamSetupAns.ValidateFields if the designated constraints
// aren't met.
type MACCommand_RxParamSetupAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RxParamSetupAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RxParamSetupAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RxParamSetupAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RxParamSetupAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RxParamSetupAnsValidationError) ErrorName() string {
	return "MACCommand_RxParamSetupAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RxParamSetupAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RxParamSetupAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RxParamSetupAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RxParamSetupAnsValidationError{}

// ValidateFields checks the field values on MACCommand_DevStatusAns with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_DevStatusAns) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_DevStatusAnsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "battery":

			if m.GetBattery() > 255 {
				return MACCommand_DevStatusAnsValidationError{
					field:  "battery",
					reason: "value must be less than or equal to 255",
				}
			}

		case "margin":

			if val := m.GetMargin(); val < -32 || val > 31 {
				return MACCommand_DevStatusAnsValidationError{
					field:  "margin",
					reason: "value must be inside range [-32, 31]",
				}
			}

		default:
			return MACCommand_DevStatusAnsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_DevStatusAnsValidationError is the validation error returned by
// MACCommand_DevStatusAns.ValidateFields if the designated constraints aren't met.
type MACCommand_DevStatusAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_DevStatusAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_DevStatusAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_DevStatusAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_DevStatusAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_DevStatusAnsValidationError) ErrorName() string {
	return "MACCommand_DevStatusAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_DevStatusAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_DevStatusAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_DevStatusAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_DevStatusAnsValidationError{}

// ValidateFields checks the field values on MACCommand_NewChannelReq with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_NewChannelReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_NewChannelReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "channel_index":

			if m.GetChannelIndex() > 255 {
				return MACCommand_NewChannelReqValidationError{
					field:  "channel_index",
					reason: "value must be less than or equal to 255",
				}
			}

		case "frequency":

			if val := m.GetFrequency(); val > 0 && val < 100000 {
				return MACCommand_NewChannelReqValidationError{
					field:  "frequency",
					reason: "value must be outside range (0, 100000)",
				}
			}

		case "min_data_rate_index":

			if _, ok := DataRateIndex_name[int32(m.GetMinDataRateIndex())]; !ok {
				return MACCommand_NewChannelReqValidationError{
					field:  "min_data_rate_index",
					reason: "value must be one of the defined enum values",
				}
			}

		case "max_data_rate_index":

			if _, ok := DataRateIndex_name[int32(m.GetMaxDataRateIndex())]; !ok {
				return MACCommand_NewChannelReqValidationError{
					field:  "max_data_rate_index",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_NewChannelReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_NewChannelReqValidationError is the validation error returned by
// MACCommand_NewChannelReq.ValidateFields if the designated constraints
// aren't met.
type MACCommand_NewChannelReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_NewChannelReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_NewChannelReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_NewChannelReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_NewChannelReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_NewChannelReqValidationError) ErrorName() string {
	return "MACCommand_NewChannelReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_NewChannelReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_NewChannelReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_NewChannelReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_NewChannelReqValidationError{}

// ValidateFields checks the field values on MACCommand_NewChannelAns with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_NewChannelAns) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_NewChannelAnsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "frequency_ack":
			// no validation rules for FrequencyAck
		case "data_rate_ack":
			// no validation rules for DataRateAck
		default:
			return MACCommand_NewChannelAnsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_NewChannelAnsValidationError is the validation error returned by
// MACCommand_NewChannelAns.ValidateFields if the designated constraints
// aren't met.
type MACCommand_NewChannelAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_NewChannelAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_NewChannelAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_NewChannelAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_NewChannelAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_NewChannelAnsValidationError) ErrorName() string {
	return "MACCommand_NewChannelAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_NewChannelAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_NewChannelAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_NewChannelAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_NewChannelAnsValidationError{}

// ValidateFields checks the field values on MACCommand_DLChannelReq with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_DLChannelReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_DLChannelReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "channel_index":

			if m.GetChannelIndex() > 255 {
				return MACCommand_DLChannelReqValidationError{
					field:  "channel_index",
					reason: "value must be less than or equal to 255",
				}
			}

		case "frequency":

			if m.GetFrequency() < 100000 {
				return MACCommand_DLChannelReqValidationError{
					field:  "frequency",
					reason: "value must be greater than or equal to 100000",
				}
			}

		default:
			return MACCommand_DLChannelReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_DLChannelReqValidationError is the validation error returned by
// MACCommand_DLChannelReq.ValidateFields if the designated constraints aren't met.
type MACCommand_DLChannelReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_DLChannelReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_DLChannelReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_DLChannelReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_DLChannelReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_DLChannelReqValidationError) ErrorName() string {
	return "MACCommand_DLChannelReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_DLChannelReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_DLChannelReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_DLChannelReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_DLChannelReqValidationError{}

// ValidateFields checks the field values on MACCommand_DLChannelAns with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_DLChannelAns) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_DLChannelAnsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "channel_index_ack":
			// no validation rules for ChannelIndexAck
		case "frequency_ack":
			// no validation rules for FrequencyAck
		default:
			return MACCommand_DLChannelAnsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_DLChannelAnsValidationError is the validation error returned by
// MACCommand_DLChannelAns.ValidateFields if the designated constraints aren't met.
type MACCommand_DLChannelAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_DLChannelAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_DLChannelAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_DLChannelAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_DLChannelAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_DLChannelAnsValidationError) ErrorName() string {
	return "MACCommand_DLChannelAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_DLChannelAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_DLChannelAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_DLChannelAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_DLChannelAnsValidationError{}

// ValidateFields checks the field values on MACCommand_RxTimingSetupReq with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *MACCommand_RxTimingSetupReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RxTimingSetupReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "delay":

			if _, ok := RxDelay_name[int32(m.GetDelay())]; !ok {
				return MACCommand_RxTimingSetupReqValidationError{
					field:  "delay",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_RxTimingSetupReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RxTimingSetupReqValidationError is the validation error returned
// by MACCommand_RxTimingSetupReq.ValidateFields if the designated constraints
// aren't met.
type MACCommand_RxTimingSetupReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RxTimingSetupReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RxTimingSetupReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RxTimingSetupReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RxTimingSetupReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RxTimingSetupReqValidationError) ErrorName() string {
	return "MACCommand_RxTimingSetupReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RxTimingSetupReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RxTimingSetupReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RxTimingSetupReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RxTimingSetupReqValidationError{}

// ValidateFields checks the field values on MACCommand_TxParamSetupReq with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *MACCommand_TxParamSetupReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_TxParamSetupReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "max_eirp_index":

			if _, ok := DeviceEIRP_name[int32(m.GetMaxEirpIndex())]; !ok {
				return MACCommand_TxParamSetupReqValidationError{
					field:  "max_eirp_index",
					reason: "value must be one of the defined enum values",
				}
			}

		case "uplink_dwell_time":
			// no validation rules for UplinkDwellTime
		case "downlink_dwell_time":
			// no validation rules for DownlinkDwellTime
		default:
			return MACCommand_TxParamSetupReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_TxParamSetupReqValidationError is the validation error returned
// by MACCommand_TxParamSetupReq.ValidateFields if the designated constraints
// aren't met.
type MACCommand_TxParamSetupReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_TxParamSetupReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_TxParamSetupReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_TxParamSetupReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_TxParamSetupReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_TxParamSetupReqValidationError) ErrorName() string {
	return "MACCommand_TxParamSetupReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_TxParamSetupReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_TxParamSetupReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_TxParamSetupReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_TxParamSetupReqValidationError{}

// ValidateFields checks the field values on MACCommand_RekeyInd with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_RekeyInd) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RekeyIndFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "minor_version":

			if _, ok := Minor_name[int32(m.GetMinorVersion())]; !ok {
				return MACCommand_RekeyIndValidationError{
					field:  "minor_version",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_RekeyIndValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RekeyIndValidationError is the validation error returned by
// MACCommand_RekeyInd.ValidateFields if the designated constraints aren't met.
type MACCommand_RekeyIndValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RekeyIndValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RekeyIndValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RekeyIndValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RekeyIndValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RekeyIndValidationError) ErrorName() string {
	return "MACCommand_RekeyIndValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RekeyIndValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RekeyInd.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RekeyIndValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RekeyIndValidationError{}

// ValidateFields checks the field values on MACCommand_RekeyConf with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_RekeyConf) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RekeyConfFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "minor_version":

			if _, ok := Minor_name[int32(m.GetMinorVersion())]; !ok {
				return MACCommand_RekeyConfValidationError{
					field:  "minor_version",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_RekeyConfValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RekeyConfValidationError is the validation error returned by
// MACCommand_RekeyConf.ValidateFields if the designated constraints aren't met.
type MACCommand_RekeyConfValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RekeyConfValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RekeyConfValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RekeyConfValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RekeyConfValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RekeyConfValidationError) ErrorName() string {
	return "MACCommand_RekeyConfValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RekeyConfValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RekeyConf.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RekeyConfValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RekeyConfValidationError{}

// ValidateFields checks the field values on MACCommand_ADRParamSetupReq with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *MACCommand_ADRParamSetupReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_ADRParamSetupReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "adr_ack_limit_exponent":

			if _, ok := ADRAckLimitExponent_name[int32(m.GetAdrAckLimitExponent())]; !ok {
				return MACCommand_ADRParamSetupReqValidationError{
					field:  "adr_ack_limit_exponent",
					reason: "value must be one of the defined enum values",
				}
			}

		case "adr_ack_delay_exponent":

			if _, ok := ADRAckDelayExponent_name[int32(m.GetAdrAckDelayExponent())]; !ok {
				return MACCommand_ADRParamSetupReqValidationError{
					field:  "adr_ack_delay_exponent",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_ADRParamSetupReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_ADRParamSetupReqValidationError is the validation error returned
// by MACCommand_ADRParamSetupReq.ValidateFields if the designated constraints
// aren't met.
type MACCommand_ADRParamSetupReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_ADRParamSetupReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_ADRParamSetupReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_ADRParamSetupReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_ADRParamSetupReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_ADRParamSetupReqValidationError) ErrorName() string {
	return "MACCommand_ADRParamSetupReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_ADRParamSetupReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_ADRParamSetupReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_ADRParamSetupReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_ADRParamSetupReqValidationError{}

// ValidateFields checks the field values on MACCommand_DeviceTimeAns with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_DeviceTimeAns) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_DeviceTimeAnsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "time":

			if m.GetTime() == nil {
				return MACCommand_DeviceTimeAnsValidationError{
					field:  "time",
					reason: "value is required",
				}
			}

		default:
			return MACCommand_DeviceTimeAnsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_DeviceTimeAnsValidationError is the validation error returned by
// MACCommand_DeviceTimeAns.ValidateFields if the designated constraints
// aren't met.
type MACCommand_DeviceTimeAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_DeviceTimeAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_DeviceTimeAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_DeviceTimeAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_DeviceTimeAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_DeviceTimeAnsValidationError) ErrorName() string {
	return "MACCommand_DeviceTimeAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_DeviceTimeAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_DeviceTimeAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_DeviceTimeAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_DeviceTimeAnsValidationError{}

// ValidateFields checks the field values on MACCommand_ForceRejoinReq with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_ForceRejoinReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_ForceRejoinReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "rejoin_type":

			if _, ok := RejoinRequestType_name[int32(m.GetRejoinType())]; !ok {
				return MACCommand_ForceRejoinReqValidationError{
					field:  "rejoin_type",
					reason: "value must be one of the defined enum values",
				}
			}

		case "data_rate_index":

			if _, ok := DataRateIndex_name[int32(m.GetDataRateIndex())]; !ok {
				return MACCommand_ForceRejoinReqValidationError{
					field:  "data_rate_index",
					reason: "value must be one of the defined enum values",
				}
			}

		case "max_retries":

			if m.GetMaxRetries() > 7 {
				return MACCommand_ForceRejoinReqValidationError{
					field:  "max_retries",
					reason: "value must be less than or equal to 7",
				}
			}

		case "period_exponent":

			if _, ok := RejoinPeriodExponent_name[int32(m.GetPeriodExponent())]; !ok {
				return MACCommand_ForceRejoinReqValidationError{
					field:  "period_exponent",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_ForceRejoinReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_ForceRejoinReqValidationError is the validation error returned by
// MACCommand_ForceRejoinReq.ValidateFields if the designated constraints
// aren't met.
type MACCommand_ForceRejoinReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_ForceRejoinReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_ForceRejoinReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_ForceRejoinReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_ForceRejoinReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_ForceRejoinReqValidationError) ErrorName() string {
	return "MACCommand_ForceRejoinReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_ForceRejoinReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_ForceRejoinReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_ForceRejoinReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_ForceRejoinReqValidationError{}

// ValidateFields checks the field values on MACCommand_RejoinParamSetupReq
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *MACCommand_RejoinParamSetupReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RejoinParamSetupReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "max_count_exponent":

			if _, ok := RejoinCountExponent_name[int32(m.GetMaxCountExponent())]; !ok {
				return MACCommand_RejoinParamSetupReqValidationError{
					field:  "max_count_exponent",
					reason: "value must be one of the defined enum values",
				}
			}

		case "max_time_exponent":

			if _, ok := RejoinTimeExponent_name[int32(m.GetMaxTimeExponent())]; !ok {
				return MACCommand_RejoinParamSetupReqValidationError{
					field:  "max_time_exponent",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_RejoinParamSetupReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RejoinParamSetupReqValidationError is the validation error
// returned by MACCommand_RejoinParamSetupReq.ValidateFields if the designated
// constraints aren't met.
type MACCommand_RejoinParamSetupReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RejoinParamSetupReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RejoinParamSetupReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RejoinParamSetupReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RejoinParamSetupReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RejoinParamSetupReqValidationError) ErrorName() string {
	return "MACCommand_RejoinParamSetupReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RejoinParamSetupReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RejoinParamSetupReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RejoinParamSetupReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RejoinParamSetupReqValidationError{}

// ValidateFields checks the field values on MACCommand_RejoinParamSetupAns
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *MACCommand_RejoinParamSetupAns) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RejoinParamSetupAnsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "max_time_exponent_ack":
			// no validation rules for MaxTimeExponentAck
		default:
			return MACCommand_RejoinParamSetupAnsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RejoinParamSetupAnsValidationError is the validation error
// returned by MACCommand_RejoinParamSetupAns.ValidateFields if the designated
// constraints aren't met.
type MACCommand_RejoinParamSetupAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RejoinParamSetupAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RejoinParamSetupAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RejoinParamSetupAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RejoinParamSetupAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RejoinParamSetupAnsValidationError) ErrorName() string {
	return "MACCommand_RejoinParamSetupAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RejoinParamSetupAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RejoinParamSetupAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RejoinParamSetupAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RejoinParamSetupAnsValidationError{}

// ValidateFields checks the field values on MACCommand_PingSlotInfoReq with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *MACCommand_PingSlotInfoReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_PingSlotInfoReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "period":

			if _, ok := PingSlotPeriod_name[int32(m.GetPeriod())]; !ok {
				return MACCommand_PingSlotInfoReqValidationError{
					field:  "period",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_PingSlotInfoReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_PingSlotInfoReqValidationError is the validation error returned
// by MACCommand_PingSlotInfoReq.ValidateFields if the designated constraints
// aren't met.
type MACCommand_PingSlotInfoReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_PingSlotInfoReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_PingSlotInfoReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_PingSlotInfoReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_PingSlotInfoReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_PingSlotInfoReqValidationError) ErrorName() string {
	return "MACCommand_PingSlotInfoReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_PingSlotInfoReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_PingSlotInfoReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_PingSlotInfoReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_PingSlotInfoReqValidationError{}

// ValidateFields checks the field values on MACCommand_PingSlotChannelReq with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *MACCommand_PingSlotChannelReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_PingSlotChannelReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "frequency":

			if val := m.GetFrequency(); val > 0 && val < 100000 {
				return MACCommand_PingSlotChannelReqValidationError{
					field:  "frequency",
					reason: "value must be outside range (0, 100000)",
				}
			}

		case "data_rate_index":

			if _, ok := DataRateIndex_name[int32(m.GetDataRateIndex())]; !ok {
				return MACCommand_PingSlotChannelReqValidationError{
					field:  "data_rate_index",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_PingSlotChannelReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_PingSlotChannelReqValidationError is the validation error
// returned by MACCommand_PingSlotChannelReq.ValidateFields if the designated
// constraints aren't met.
type MACCommand_PingSlotChannelReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_PingSlotChannelReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_PingSlotChannelReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_PingSlotChannelReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_PingSlotChannelReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_PingSlotChannelReqValidationError) ErrorName() string {
	return "MACCommand_PingSlotChannelReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_PingSlotChannelReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_PingSlotChannelReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_PingSlotChannelReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_PingSlotChannelReqValidationError{}

// ValidateFields checks the field values on MACCommand_PingSlotChannelAns with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *MACCommand_PingSlotChannelAns) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_PingSlotChannelAnsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "frequency_ack":
			// no validation rules for FrequencyAck
		case "data_rate_index_ack":
			// no validation rules for DataRateIndexAck
		default:
			return MACCommand_PingSlotChannelAnsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_PingSlotChannelAnsValidationError is the validation error
// returned by MACCommand_PingSlotChannelAns.ValidateFields if the designated
// constraints aren't met.
type MACCommand_PingSlotChannelAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_PingSlotChannelAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_PingSlotChannelAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_PingSlotChannelAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_PingSlotChannelAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_PingSlotChannelAnsValidationError) ErrorName() string {
	return "MACCommand_PingSlotChannelAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_PingSlotChannelAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_PingSlotChannelAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_PingSlotChannelAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_PingSlotChannelAnsValidationError{}

// ValidateFields checks the field values on MACCommand_BeaconTimingAns with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *MACCommand_BeaconTimingAns) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_BeaconTimingAnsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "delay":

			if m.GetDelay() > 65535 {
				return MACCommand_BeaconTimingAnsValidationError{
					field:  "delay",
					reason: "value must be less than or equal to 65535",
				}
			}

		case "channel_index":

			if m.GetChannelIndex() > 255 {
				return MACCommand_BeaconTimingAnsValidationError{
					field:  "channel_index",
					reason: "value must be less than or equal to 255",
				}
			}

		default:
			return MACCommand_BeaconTimingAnsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_BeaconTimingAnsValidationError is the validation error returned
// by MACCommand_BeaconTimingAns.ValidateFields if the designated constraints
// aren't met.
type MACCommand_BeaconTimingAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_BeaconTimingAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_BeaconTimingAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_BeaconTimingAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_BeaconTimingAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_BeaconTimingAnsValidationError) ErrorName() string {
	return "MACCommand_BeaconTimingAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_BeaconTimingAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_BeaconTimingAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_BeaconTimingAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_BeaconTimingAnsValidationError{}

// ValidateFields checks the field values on MACCommand_BeaconFreqReq with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_BeaconFreqReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_BeaconFreqReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "frequency":

			if val := m.GetFrequency(); val > 0 && val < 100000 {
				return MACCommand_BeaconFreqReqValidationError{
					field:  "frequency",
					reason: "value must be outside range (0, 100000)",
				}
			}

		default:
			return MACCommand_BeaconFreqReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_BeaconFreqReqValidationError is the validation error returned by
// MACCommand_BeaconFreqReq.ValidateFields if the designated constraints
// aren't met.
type MACCommand_BeaconFreqReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_BeaconFreqReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_BeaconFreqReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_BeaconFreqReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_BeaconFreqReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_BeaconFreqReqValidationError) ErrorName() string {
	return "MACCommand_BeaconFreqReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_BeaconFreqReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_BeaconFreqReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_BeaconFreqReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_BeaconFreqReqValidationError{}

// ValidateFields checks the field values on MACCommand_BeaconFreqAns with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_BeaconFreqAns) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_BeaconFreqAnsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "frequency_ack":
			// no validation rules for FrequencyAck
		default:
			return MACCommand_BeaconFreqAnsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_BeaconFreqAnsValidationError is the validation error returned by
// MACCommand_BeaconFreqAns.ValidateFields if the designated constraints
// aren't met.
type MACCommand_BeaconFreqAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_BeaconFreqAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_BeaconFreqAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_BeaconFreqAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_BeaconFreqAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_BeaconFreqAnsValidationError) ErrorName() string {
	return "MACCommand_BeaconFreqAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_BeaconFreqAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_BeaconFreqAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_BeaconFreqAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_BeaconFreqAnsValidationError{}

// ValidateFields checks the field values on MACCommand_DeviceModeInd with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_DeviceModeInd) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_DeviceModeIndFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "class":

			if _, ok := Class_name[int32(m.GetClass())]; !ok {
				return MACCommand_DeviceModeIndValidationError{
					field:  "class",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_DeviceModeIndValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_DeviceModeIndValidationError is the validation error returned by
// MACCommand_DeviceModeInd.ValidateFields if the designated constraints
// aren't met.
type MACCommand_DeviceModeIndValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_DeviceModeIndValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_DeviceModeIndValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_DeviceModeIndValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_DeviceModeIndValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_DeviceModeIndValidationError) ErrorName() string {
	return "MACCommand_DeviceModeIndValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_DeviceModeIndValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_DeviceModeInd.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_DeviceModeIndValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_DeviceModeIndValidationError{}

// ValidateFields checks the field values on MACCommand_DeviceModeConf with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_DeviceModeConf) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_DeviceModeConfFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "class":

			if _, ok := Class_name[int32(m.GetClass())]; !ok {
				return MACCommand_DeviceModeConfValidationError{
					field:  "class",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_DeviceModeConfValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_DeviceModeConfValidationError is the validation error returned by
// MACCommand_DeviceModeConf.ValidateFields if the designated constraints
// aren't met.
type MACCommand_DeviceModeConfValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_DeviceModeConfValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_DeviceModeConfValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_DeviceModeConfValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_DeviceModeConfValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_DeviceModeConfValidationError) ErrorName() string {
	return "MACCommand_DeviceModeConfValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_DeviceModeConfValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_DeviceModeConf.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_DeviceModeConfValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_DeviceModeConfValidationError{}

// ValidateFields checks the field values on MACCommand_RelayConfReq with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_RelayConfReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RelayConfReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "configuration":

			if v, ok := interface{}(m.GetConfiguration()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACCommand_RelayConfReqValidationError{
						field:  "configuration",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return MACCommand_RelayConfReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RelayConfReqValidationError is the validation error returned by
// MACCommand_RelayConfReq.ValidateFields if the designated constraints aren't met.
type MACCommand_RelayConfReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RelayConfReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RelayConfReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RelayConfReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RelayConfReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RelayConfReqValidationError) ErrorName() string {
	return "MACCommand_RelayConfReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RelayConfReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RelayConfReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RelayConfReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RelayConfReqValidationError{}

// ValidateFields checks the field values on MACCommand_RelayConfAns with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACCommand_RelayConfAns) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RelayConfAnsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "second_channel_frequency_ack":
			// no validation rules for SecondChannelFrequencyAck
		case "second_channel_ack_offset_ack":
			// no validation rules for SecondChannelAckOffsetAck
		case "second_channel_data_rate_index_ack":
			// no validation rules for SecondChannelDataRateIndexAck
		case "second_channel_index_ack":
			// no validation rules for SecondChannelIndexAck
		case "default_channel_index_ack":
			// no validation rules for DefaultChannelIndexAck
		case "cad_periodicity_ack":
			// no validation rules for CadPeriodicityAck
		default:
			return MACCommand_RelayConfAnsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RelayConfAnsValidationError is the validation error returned by
// MACCommand_RelayConfAns.ValidateFields if the designated constraints aren't met.
type MACCommand_RelayConfAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RelayConfAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RelayConfAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RelayConfAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RelayConfAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RelayConfAnsValidationError) ErrorName() string {
	return "MACCommand_RelayConfAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RelayConfAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RelayConfAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RelayConfAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RelayConfAnsValidationError{}

// ValidateFields checks the field values on MACCommand_RelayEndDeviceConfReq
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *MACCommand_RelayEndDeviceConfReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RelayEndDeviceConfReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "configuration":

			if v, ok := interface{}(m.GetConfiguration()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACCommand_RelayEndDeviceConfReqValidationError{
						field:  "configuration",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return MACCommand_RelayEndDeviceConfReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RelayEndDeviceConfReqValidationError is the validation error
// returned by MACCommand_RelayEndDeviceConfReq.ValidateFields if the
// designated constraints aren't met.
type MACCommand_RelayEndDeviceConfReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RelayEndDeviceConfReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RelayEndDeviceConfReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RelayEndDeviceConfReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RelayEndDeviceConfReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RelayEndDeviceConfReqValidationError) ErrorName() string {
	return "MACCommand_RelayEndDeviceConfReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RelayEndDeviceConfReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RelayEndDeviceConfReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RelayEndDeviceConfReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RelayEndDeviceConfReqValidationError{}

// ValidateFields checks the field values on MACCommand_RelayEndDeviceConfAns
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *MACCommand_RelayEndDeviceConfAns) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RelayEndDeviceConfAnsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "second_channel_frequency_ack":
			// no validation rules for SecondChannelFrequencyAck
		case "second_channel_data_rate_index_ack":
			// no validation rules for SecondChannelDataRateIndexAck
		case "second_channel_index_ack":
			// no validation rules for SecondChannelIndexAck
		case "backoff_ack":
			// no validation rules for BackoffAck
		default:
			return MACCommand_RelayEndDeviceConfAnsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RelayEndDeviceConfAnsValidationError is the validation error
// returned by MACCommand_RelayEndDeviceConfAns.ValidateFields if the
// designated constraints aren't met.
type MACCommand_RelayEndDeviceConfAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RelayEndDeviceConfAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RelayEndDeviceConfAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RelayEndDeviceConfAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RelayEndDeviceConfAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RelayEndDeviceConfAnsValidationError) ErrorName() string {
	return "MACCommand_RelayEndDeviceConfAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RelayEndDeviceConfAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RelayEndDeviceConfAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RelayEndDeviceConfAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RelayEndDeviceConfAnsValidationError{}

// ValidateFields checks the field values on
// MACCommand_RelayUpdateUplinkListReq with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *MACCommand_RelayUpdateUplinkListReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RelayUpdateUplinkListReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "rule_index":

			if m.GetRuleIndex() > 15 {
				return MACCommand_RelayUpdateUplinkListReqValidationError{
					field:  "rule_index",
					reason: "value must be less than or equal to 15",
				}
			}

		case "forward_limits":

			if v, ok := interface{}(m.GetForwardLimits()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACCommand_RelayUpdateUplinkListReqValidationError{
						field:  "forward_limits",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "dev_addr":

			if len(m.GetDevAddr()) > 0 {

				if len(m.GetDevAddr()) != 4 {
					return MACCommand_RelayUpdateUplinkListReqValidationError{
						field:  "dev_addr",
						reason: "value length must be 4 bytes",
					}
				}

			}

		case "w_f_cnt":
			// no validation rules for WFCnt
		case "root_wor_s_key":

			if len(m.GetRootWorSKey()) > 0 {

				if len(m.GetRootWorSKey()) != 16 {
					return MACCommand_RelayUpdateUplinkListReqValidationError{
						field:  "root_wor_s_key",
						reason: "value length must be 16 bytes",
					}
				}

			}

		case "device_id":

			if utf8.RuneCountInString(m.GetDeviceId()) > 36 {
				return MACCommand_RelayUpdateUplinkListReqValidationError{
					field:  "device_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_MACCommand_RelayUpdateUplinkListReq_DeviceId_Pattern.MatchString(m.GetDeviceId()) {
				return MACCommand_RelayUpdateUplinkListReqValidationError{
					field:  "device_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "session_key_id":
			// no validation rules for SessionKeyId
		default:
			return MACCommand_RelayUpdateUplinkListReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RelayUpdateUplinkListReqValidationError is the validation error
// returned by MACCommand_RelayUpdateUplinkListReq.ValidateFields if the
// designated constraints aren't met.
type MACCommand_RelayUpdateUplinkListReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RelayUpdateUplinkListReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RelayUpdateUplinkListReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RelayUpdateUplinkListReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RelayUpdateUplinkListReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RelayUpdateUplinkListReqValidationError) ErrorName() string {
	return "MACCommand_RelayUpdateUplinkListReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RelayUpdateUplinkListReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RelayUpdateUplinkListReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RelayUpdateUplinkListReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RelayUpdateUplinkListReqValidationError{}

var _MACCommand_RelayUpdateUplinkListReq_DeviceId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on
// MACCommand_RelayUpdateUplinkListAns with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *MACCommand_RelayUpdateUplinkListAns) ValidateFields(paths ...string) error {
	if len(paths) > 0 {
		return fmt.Errorf("message MACCommand_RelayUpdateUplinkListAns has no fields, but paths %s were specified", paths)
	}
	return nil
}

// MACCommand_RelayUpdateUplinkListAnsValidationError is the validation error
// returned by MACCommand_RelayUpdateUplinkListAns.ValidateFields if the
// designated constraints aren't met.
type MACCommand_RelayUpdateUplinkListAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RelayUpdateUplinkListAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RelayUpdateUplinkListAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RelayUpdateUplinkListAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RelayUpdateUplinkListAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RelayUpdateUplinkListAnsValidationError) ErrorName() string {
	return "MACCommand_RelayUpdateUplinkListAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RelayUpdateUplinkListAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RelayUpdateUplinkListAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RelayUpdateUplinkListAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RelayUpdateUplinkListAnsValidationError{}

// ValidateFields checks the field values on MACCommand_RelayCtrlUplinkListReq
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *MACCommand_RelayCtrlUplinkListReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RelayCtrlUplinkListReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "rule_index":

			if m.GetRuleIndex() > 15 {
				return MACCommand_RelayCtrlUplinkListReqValidationError{
					field:  "rule_index",
					reason: "value must be less than or equal to 15",
				}
			}

		case "action":
			// no validation rules for Action
		default:
			return MACCommand_RelayCtrlUplinkListReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RelayCtrlUplinkListReqValidationError is the validation error
// returned by MACCommand_RelayCtrlUplinkListReq.ValidateFields if the
// designated constraints aren't met.
type MACCommand_RelayCtrlUplinkListReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RelayCtrlUplinkListReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RelayCtrlUplinkListReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RelayCtrlUplinkListReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RelayCtrlUplinkListReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RelayCtrlUplinkListReqValidationError) ErrorName() string {
	return "MACCommand_RelayCtrlUplinkListReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RelayCtrlUplinkListReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RelayCtrlUplinkListReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RelayCtrlUplinkListReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RelayCtrlUplinkListReqValidationError{}

// ValidateFields checks the field values on MACCommand_RelayCtrlUplinkListAns
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *MACCommand_RelayCtrlUplinkListAns) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RelayCtrlUplinkListAnsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "rule_index_ack":
			// no validation rules for RuleIndexAck
		case "w_f_cnt":
			// no validation rules for WFCnt
		default:
			return MACCommand_RelayCtrlUplinkListAnsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RelayCtrlUplinkListAnsValidationError is the validation error
// returned by MACCommand_RelayCtrlUplinkListAns.ValidateFields if the
// designated constraints aren't met.
type MACCommand_RelayCtrlUplinkListAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RelayCtrlUplinkListAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RelayCtrlUplinkListAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RelayCtrlUplinkListAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RelayCtrlUplinkListAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RelayCtrlUplinkListAnsValidationError) ErrorName() string {
	return "MACCommand_RelayCtrlUplinkListAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RelayCtrlUplinkListAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RelayCtrlUplinkListAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RelayCtrlUplinkListAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RelayCtrlUplinkListAnsValidationError{}

// ValidateFields checks the field values on
// MACCommand_RelayConfigureFwdLimitReq with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *MACCommand_RelayConfigureFwdLimitReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RelayConfigureFwdLimitReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "reset_limit_counter":
			// no validation rules for ResetLimitCounter
		case "join_request_limits":

			if v, ok := interface{}(m.GetJoinRequestLimits()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACCommand_RelayConfigureFwdLimitReqValidationError{
						field:  "join_request_limits",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "notify_limits":

			if v, ok := interface{}(m.GetNotifyLimits()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACCommand_RelayConfigureFwdLimitReqValidationError{
						field:  "notify_limits",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "global_uplink_limits":

			if v, ok := interface{}(m.GetGlobalUplinkLimits()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACCommand_RelayConfigureFwdLimitReqValidationError{
						field:  "global_uplink_limits",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "overall_limits":

			if v, ok := interface{}(m.GetOverallLimits()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACCommand_RelayConfigureFwdLimitReqValidationError{
						field:  "overall_limits",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return MACCommand_RelayConfigureFwdLimitReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RelayConfigureFwdLimitReqValidationError is the validation error
// returned by MACCommand_RelayConfigureFwdLimitReq.ValidateFields if the
// designated constraints aren't met.
type MACCommand_RelayConfigureFwdLimitReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RelayConfigureFwdLimitReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RelayConfigureFwdLimitReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RelayConfigureFwdLimitReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RelayConfigureFwdLimitReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RelayConfigureFwdLimitReqValidationError) ErrorName() string {
	return "MACCommand_RelayConfigureFwdLimitReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RelayConfigureFwdLimitReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RelayConfigureFwdLimitReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RelayConfigureFwdLimitReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RelayConfigureFwdLimitReqValidationError{}

// ValidateFields checks the field values on
// MACCommand_RelayConfigureFwdLimitAns with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *MACCommand_RelayConfigureFwdLimitAns) ValidateFields(paths ...string) error {
	if len(paths) > 0 {
		return fmt.Errorf("message MACCommand_RelayConfigureFwdLimitAns has no fields, but paths %s were specified", paths)
	}
	return nil
}

// MACCommand_RelayConfigureFwdLimitAnsValidationError is the validation error
// returned by MACCommand_RelayConfigureFwdLimitAns.ValidateFields if the
// designated constraints aren't met.
type MACCommand_RelayConfigureFwdLimitAnsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RelayConfigureFwdLimitAnsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RelayConfigureFwdLimitAnsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RelayConfigureFwdLimitAnsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RelayConfigureFwdLimitAnsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RelayConfigureFwdLimitAnsValidationError) ErrorName() string {
	return "MACCommand_RelayConfigureFwdLimitAnsValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RelayConfigureFwdLimitAnsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RelayConfigureFwdLimitAns.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RelayConfigureFwdLimitAnsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RelayConfigureFwdLimitAnsValidationError{}

// ValidateFields checks the field values on
// MACCommand_RelayNotifyNewEndDeviceReq with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *MACCommand_RelayNotifyNewEndDeviceReq) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RelayNotifyNewEndDeviceReqFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "dev_addr":

			if len(m.GetDevAddr()) > 0 {

				if len(m.GetDevAddr()) != 4 {
					return MACCommand_RelayNotifyNewEndDeviceReqValidationError{
						field:  "dev_addr",
						reason: "value length must be 4 bytes",
					}
				}

			}

		case "snr":

			if val := m.GetSnr(); val < -20 || val > 11 {
				return MACCommand_RelayNotifyNewEndDeviceReqValidationError{
					field:  "snr",
					reason: "value must be inside range [-20, 11]",
				}
			}

		case "rssi":

			if val := m.GetRssi(); val < -142 || val > -15 {
				return MACCommand_RelayNotifyNewEndDeviceReqValidationError{
					field:  "rssi",
					reason: "value must be inside range [-142, -15]",
				}
			}

		default:
			return MACCommand_RelayNotifyNewEndDeviceReqValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RelayNotifyNewEndDeviceReqValidationError is the validation error
// returned by MACCommand_RelayNotifyNewEndDeviceReq.ValidateFields if the
// designated constraints aren't met.
type MACCommand_RelayNotifyNewEndDeviceReqValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RelayNotifyNewEndDeviceReqValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RelayNotifyNewEndDeviceReqValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RelayNotifyNewEndDeviceReqValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RelayNotifyNewEndDeviceReqValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RelayNotifyNewEndDeviceReqValidationError) ErrorName() string {
	return "MACCommand_RelayNotifyNewEndDeviceReqValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RelayNotifyNewEndDeviceReqValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RelayNotifyNewEndDeviceReq.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RelayNotifyNewEndDeviceReqValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RelayNotifyNewEndDeviceReqValidationError{}

// ValidateFields checks the field values on
// MACCommand_RelayConfReq_Configuration with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *MACCommand_RelayConfReq_Configuration) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RelayConfReq_ConfigurationFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "second_channel":

			if v, ok := interface{}(m.GetSecondChannel()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACCommand_RelayConfReq_ConfigurationValidationError{
						field:  "second_channel",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "default_channel_index":

			if m.GetDefaultChannelIndex() > 255 {
				return MACCommand_RelayConfReq_ConfigurationValidationError{
					field:  "default_channel_index",
					reason: "value must be less than or equal to 255",
				}
			}

		case "cad_periodicity":

			if _, ok := RelayCADPeriodicity_name[int32(m.GetCadPeriodicity())]; !ok {
				return MACCommand_RelayConfReq_ConfigurationValidationError{
					field:  "cad_periodicity",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACCommand_RelayConfReq_ConfigurationValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RelayConfReq_ConfigurationValidationError is the validation error
// returned by MACCommand_RelayConfReq_Configuration.ValidateFields if the
// designated constraints aren't met.
type MACCommand_RelayConfReq_ConfigurationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RelayConfReq_ConfigurationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RelayConfReq_ConfigurationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACCommand_RelayConfReq_ConfigurationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RelayConfReq_ConfigurationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RelayConfReq_ConfigurationValidationError) ErrorName() string {
	return "MACCommand_RelayConfReq_ConfigurationValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RelayConfReq_ConfigurationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RelayConfReq_Configuration.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RelayConfReq_ConfigurationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RelayConfReq_ConfigurationValidationError{}

// ValidateFields checks the field values on
// MACCommand_RelayEndDeviceConfReq_Configuration with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *MACCommand_RelayEndDeviceConfReq_Configuration) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACCommand_RelayEndDeviceConfReq_ConfigurationFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "backoff":

			if m.GetBackoff() > 63 {
				return MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError{
					field:  "backoff",
					reason: "value must be less than or equal to 63",
				}
			}

		case "second_channel":

			if v, ok := interface{}(m.GetSecondChannel()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError{
						field:  "second_channel",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "serving_device_id":

			if utf8.RuneCountInString(m.GetServingDeviceId()) > 36 {
				return MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError{
					field:  "serving_device_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_MACCommand_RelayEndDeviceConfReq_Configuration_ServingDeviceId_Pattern.MatchString(m.GetServingDeviceId()) {
				return MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError{
					field:  "serving_device_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "mode":
			if m.Mode == nil {
				return MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError{
					field:  "mode",
					reason: "value is required",
				}
			}
			if len(subs) == 0 {
				subs = []string{
					"always", "dynamic", "end_device_controlled",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "always":
					w, ok := m.Mode.(*MACCommand_RelayEndDeviceConfReq_Configuration_Always)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetAlways()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError{
								field:  "always",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "dynamic":
					w, ok := m.Mode.(*MACCommand_RelayEndDeviceConfReq_Configuration_Dynamic)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDynamic()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError{
								field:  "dynamic",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "end_device_controlled":
					w, ok := m.Mode.(*MACCommand_RelayEndDeviceConfReq_Configuration_EndDeviceControlled)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetEndDeviceControlled()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError{
								field:  "end_device_controlled",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError is the
// validation error returned by
// MACCommand_RelayEndDeviceConfReq_Configuration.ValidateFields if the
// designated constraints aren't met.
type MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError) ErrorName() string {
	return "MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError"
}

// Error satisfies the builtin error interface
func (e MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACCommand_RelayEndDeviceConfReq_Configuration.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACCommand_RelayEndDeviceConfReq_ConfigurationValidationError{}

var _MACCommand_RelayEndDeviceConfReq_Configuration_ServingDeviceId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")
