// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/lorawan.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type MType int32

const (
	MType_JOIN_REQUEST     MType = 0
	MType_JOIN_ACCEPT      MType = 1
	MType_UNCONFIRMED_UP   MType = 2
	MType_UNCONFIRMED_DOWN MType = 3
	MType_CONFIRMED_UP     MType = 4
	MType_CONFIRMED_DOWN   MType = 5
	MType_REJOIN_REQUEST   MType = 6
	MType_PROPRIETARY      MType = 7
)

// Enum value maps for MType.
var (
	MType_name = map[int32]string{
		0: "JOIN_REQUEST",
		1: "JOIN_ACCEPT",
		2: "UNCONFIRMED_UP",
		3: "UNCONFIRMED_DOWN",
		4: "CONFIRMED_UP",
		5: "CONFIRMED_DOWN",
		6: "REJOIN_REQUEST",
		7: "PROPRIETARY",
	}
	MType_value = map[string]int32{
		"JOIN_REQUEST":     0,
		"JOIN_ACCEPT":      1,
		"UNCONFIRMED_UP":   2,
		"UNCONFIRMED_DOWN": 3,
		"CONFIRMED_UP":     4,
		"CONFIRMED_DOWN":   5,
		"REJOIN_REQUEST":   6,
		"PROPRIETARY":      7,
	}
)

func (x MType) Enum() *MType {
	p := new(MType)
	*p = x
	return p
}

func (x MType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MType) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[0].Descriptor()
}

func (MType) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[0]
}

func (x MType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MType.Descriptor instead.
func (MType) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{0}
}

type Major int32

const (
	Major_LORAWAN_R1 Major = 0
)

// Enum value maps for Major.
var (
	Major_name = map[int32]string{
		0: "LORAWAN_R1",
	}
	Major_value = map[string]int32{
		"LORAWAN_R1": 0,
	}
)

func (x Major) Enum() *Major {
	p := new(Major)
	*p = x
	return p
}

func (x Major) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Major) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[1].Descriptor()
}

func (Major) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[1]
}

func (x Major) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Major.Descriptor instead.
func (Major) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{1}
}

type MACVersion int32

const (
	MACVersion_MAC_UNKNOWN MACVersion = 0
	MACVersion_MAC_V1_0    MACVersion = 1
	MACVersion_MAC_V1_0_1  MACVersion = 2
	MACVersion_MAC_V1_0_2  MACVersion = 3
	MACVersion_MAC_V1_1    MACVersion = 4
	MACVersion_MAC_V1_0_3  MACVersion = 5
	MACVersion_MAC_V1_0_4  MACVersion = 6
)

// Enum value maps for MACVersion.
var (
	MACVersion_name = map[int32]string{
		0: "MAC_UNKNOWN",
		1: "MAC_V1_0",
		2: "MAC_V1_0_1",
		3: "MAC_V1_0_2",
		4: "MAC_V1_1",
		5: "MAC_V1_0_3",
		6: "MAC_V1_0_4",
	}
	MACVersion_value = map[string]int32{
		"MAC_UNKNOWN": 0,
		"MAC_V1_0":    1,
		"MAC_V1_0_1":  2,
		"MAC_V1_0_2":  3,
		"MAC_V1_1":    4,
		"MAC_V1_0_3":  5,
		"MAC_V1_0_4":  6,
	}
)

func (x MACVersion) Enum() *MACVersion {
	p := new(MACVersion)
	*p = x
	return p
}

func (x MACVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MACVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[2].Descriptor()
}

func (MACVersion) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[2]
}

func (x MACVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MACVersion.Descriptor instead.
func (MACVersion) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{2}
}

type PHYVersion int32

const (
	PHYVersion_PHY_UNKNOWN        PHYVersion = 0
	PHYVersion_PHY_V1_0           PHYVersion = 1
	PHYVersion_TS001_V1_0         PHYVersion = 1
	PHYVersion_PHY_V1_0_1         PHYVersion = 2
	PHYVersion_TS001_V1_0_1       PHYVersion = 2
	PHYVersion_PHY_V1_0_2_REV_A   PHYVersion = 3
	PHYVersion_RP001_V1_0_2       PHYVersion = 3
	PHYVersion_PHY_V1_0_2_REV_B   PHYVersion = 4
	PHYVersion_RP001_V1_0_2_REV_B PHYVersion = 4
	PHYVersion_PHY_V1_1_REV_A     PHYVersion = 5
	PHYVersion_RP001_V1_1_REV_A   PHYVersion = 5
	PHYVersion_PHY_V1_1_REV_B     PHYVersion = 6
	PHYVersion_RP001_V1_1_REV_B   PHYVersion = 6
	PHYVersion_PHY_V1_0_3_REV_A   PHYVersion = 7
	PHYVersion_RP001_V1_0_3_REV_A PHYVersion = 7
	PHYVersion_RP002_V1_0_0       PHYVersion = 8
	PHYVersion_RP002_V1_0_1       PHYVersion = 9
	PHYVersion_RP002_V1_0_2       PHYVersion = 10
	PHYVersion_RP002_V1_0_3       PHYVersion = 11
	PHYVersion_RP002_V1_0_4       PHYVersion = 12
)

// Enum value maps for PHYVersion.
var (
	PHYVersion_name = map[int32]string{
		0: "PHY_UNKNOWN",
		1: "PHY_V1_0",
		// Duplicate value: 1: "TS001_V1_0",
		2: "PHY_V1_0_1",
		// Duplicate value: 2: "TS001_V1_0_1",
		3: "PHY_V1_0_2_REV_A",
		// Duplicate value: 3: "RP001_V1_0_2",
		4: "PHY_V1_0_2_REV_B",
		// Duplicate value: 4: "RP001_V1_0_2_REV_B",
		5: "PHY_V1_1_REV_A",
		// Duplicate value: 5: "RP001_V1_1_REV_A",
		6: "PHY_V1_1_REV_B",
		// Duplicate value: 6: "RP001_V1_1_REV_B",
		7: "PHY_V1_0_3_REV_A",
		// Duplicate value: 7: "RP001_V1_0_3_REV_A",
		8:  "RP002_V1_0_0",
		9:  "RP002_V1_0_1",
		10: "RP002_V1_0_2",
		11: "RP002_V1_0_3",
		12: "RP002_V1_0_4",
	}
	PHYVersion_value = map[string]int32{
		"PHY_UNKNOWN":        0,
		"PHY_V1_0":           1,
		"TS001_V1_0":         1,
		"PHY_V1_0_1":         2,
		"TS001_V1_0_1":       2,
		"PHY_V1_0_2_REV_A":   3,
		"RP001_V1_0_2":       3,
		"PHY_V1_0_2_REV_B":   4,
		"RP001_V1_0_2_REV_B": 4,
		"PHY_V1_1_REV_A":     5,
		"RP001_V1_1_REV_A":   5,
		"PHY_V1_1_REV_B":     6,
		"RP001_V1_1_REV_B":   6,
		"PHY_V1_0_3_REV_A":   7,
		"RP001_V1_0_3_REV_A": 7,
		"RP002_V1_0_0":       8,
		"RP002_V1_0_1":       9,
		"RP002_V1_0_2":       10,
		"RP002_V1_0_3":       11,
		"RP002_V1_0_4":       12,
	}
)

func (x PHYVersion) Enum() *PHYVersion {
	p := new(PHYVersion)
	*p = x
	return p
}

func (x PHYVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PHYVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[3].Descriptor()
}

func (PHYVersion) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[3]
}

func (x PHYVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PHYVersion.Descriptor instead.
func (PHYVersion) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{3}
}

type DataRateIndex int32

const (
	DataRateIndex_DATA_RATE_0  DataRateIndex = 0
	DataRateIndex_DATA_RATE_1  DataRateIndex = 1
	DataRateIndex_DATA_RATE_2  DataRateIndex = 2
	DataRateIndex_DATA_RATE_3  DataRateIndex = 3
	DataRateIndex_DATA_RATE_4  DataRateIndex = 4
	DataRateIndex_DATA_RATE_5  DataRateIndex = 5
	DataRateIndex_DATA_RATE_6  DataRateIndex = 6
	DataRateIndex_DATA_RATE_7  DataRateIndex = 7
	DataRateIndex_DATA_RATE_8  DataRateIndex = 8
	DataRateIndex_DATA_RATE_9  DataRateIndex = 9
	DataRateIndex_DATA_RATE_10 DataRateIndex = 10
	DataRateIndex_DATA_RATE_11 DataRateIndex = 11
	DataRateIndex_DATA_RATE_12 DataRateIndex = 12
	DataRateIndex_DATA_RATE_13 DataRateIndex = 13
	DataRateIndex_DATA_RATE_14 DataRateIndex = 14
	DataRateIndex_DATA_RATE_15 DataRateIndex = 15
)

// Enum value maps for DataRateIndex.
var (
	DataRateIndex_name = map[int32]string{
		0:  "DATA_RATE_0",
		1:  "DATA_RATE_1",
		2:  "DATA_RATE_2",
		3:  "DATA_RATE_3",
		4:  "DATA_RATE_4",
		5:  "DATA_RATE_5",
		6:  "DATA_RATE_6",
		7:  "DATA_RATE_7",
		8:  "DATA_RATE_8",
		9:  "DATA_RATE_9",
		10: "DATA_RATE_10",
		11: "DATA_RATE_11",
		12: "DATA_RATE_12",
		13: "DATA_RATE_13",
		14: "DATA_RATE_14",
		15: "DATA_RATE_15",
	}
	DataRateIndex_value = map[string]int32{
		"DATA_RATE_0":  0,
		"DATA_RATE_1":  1,
		"DATA_RATE_2":  2,
		"DATA_RATE_3":  3,
		"DATA_RATE_4":  4,
		"DATA_RATE_5":  5,
		"DATA_RATE_6":  6,
		"DATA_RATE_7":  7,
		"DATA_RATE_8":  8,
		"DATA_RATE_9":  9,
		"DATA_RATE_10": 10,
		"DATA_RATE_11": 11,
		"DATA_RATE_12": 12,
		"DATA_RATE_13": 13,
		"DATA_RATE_14": 14,
		"DATA_RATE_15": 15,
	}
)

func (x DataRateIndex) Enum() *DataRateIndex {
	p := new(DataRateIndex)
	*p = x
	return p
}

func (x DataRateIndex) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataRateIndex) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[4].Descriptor()
}

func (DataRateIndex) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[4]
}

func (x DataRateIndex) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataRateIndex.Descriptor instead.
func (DataRateIndex) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{4}
}

type DataRateOffset int32

const (
	DataRateOffset_DATA_RATE_OFFSET_0 DataRateOffset = 0
	DataRateOffset_DATA_RATE_OFFSET_1 DataRateOffset = 1
	DataRateOffset_DATA_RATE_OFFSET_2 DataRateOffset = 2
	DataRateOffset_DATA_RATE_OFFSET_3 DataRateOffset = 3
	DataRateOffset_DATA_RATE_OFFSET_4 DataRateOffset = 4
	DataRateOffset_DATA_RATE_OFFSET_5 DataRateOffset = 5
	DataRateOffset_DATA_RATE_OFFSET_6 DataRateOffset = 6
	DataRateOffset_DATA_RATE_OFFSET_7 DataRateOffset = 7
)

// Enum value maps for DataRateOffset.
var (
	DataRateOffset_name = map[int32]string{
		0: "DATA_RATE_OFFSET_0",
		1: "DATA_RATE_OFFSET_1",
		2: "DATA_RATE_OFFSET_2",
		3: "DATA_RATE_OFFSET_3",
		4: "DATA_RATE_OFFSET_4",
		5: "DATA_RATE_OFFSET_5",
		6: "DATA_RATE_OFFSET_6",
		7: "DATA_RATE_OFFSET_7",
	}
	DataRateOffset_value = map[string]int32{
		"DATA_RATE_OFFSET_0": 0,
		"DATA_RATE_OFFSET_1": 1,
		"DATA_RATE_OFFSET_2": 2,
		"DATA_RATE_OFFSET_3": 3,
		"DATA_RATE_OFFSET_4": 4,
		"DATA_RATE_OFFSET_5": 5,
		"DATA_RATE_OFFSET_6": 6,
		"DATA_RATE_OFFSET_7": 7,
	}
)

func (x DataRateOffset) Enum() *DataRateOffset {
	p := new(DataRateOffset)
	*p = x
	return p
}

func (x DataRateOffset) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataRateOffset) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[5].Descriptor()
}

func (DataRateOffset) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[5]
}

func (x DataRateOffset) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataRateOffset.Descriptor instead.
func (DataRateOffset) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{5}
}

type JoinRequestType int32

const (
	JoinRequestType_REJOIN_CONTEXT JoinRequestType = 0   // Resets DevAddr, Session Keys, Frame Counters, Radio Parameters.
	JoinRequestType_REJOIN_SESSION JoinRequestType = 1   // Equivalent to the initial JoinRequest.
	JoinRequestType_REJOIN_KEYS    JoinRequestType = 2   // Resets DevAddr, Session Keys, Frame Counters, while keeping the Radio Parameters.
	JoinRequestType_JOIN           JoinRequestType = 255 // Normal join-request.
)

// Enum value maps for JoinRequestType.
var (
	JoinRequestType_name = map[int32]string{
		0:   "REJOIN_CONTEXT",
		1:   "REJOIN_SESSION",
		2:   "REJOIN_KEYS",
		255: "JOIN",
	}
	JoinRequestType_value = map[string]int32{
		"REJOIN_CONTEXT": 0,
		"REJOIN_SESSION": 1,
		"REJOIN_KEYS":    2,
		"JOIN":           255,
	}
)

func (x JoinRequestType) Enum() *JoinRequestType {
	p := new(JoinRequestType)
	*p = x
	return p
}

func (x JoinRequestType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JoinRequestType) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[6].Descriptor()
}

func (JoinRequestType) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[6]
}

func (x JoinRequestType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JoinRequestType.Descriptor instead.
func (JoinRequestType) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{6}
}

type RejoinRequestType int32

const (
	RejoinRequestType_CONTEXT RejoinRequestType = 0 // Resets DevAddr, Session Keys, Frame Counters, Radio Parameters.
	RejoinRequestType_SESSION RejoinRequestType = 1 // Equivalent to the initial JoinRequest.
	RejoinRequestType_KEYS    RejoinRequestType = 2 // Resets DevAddr, Session Keys, Frame Counters, while keeping the Radio Parameters.
)

// Enum value maps for RejoinRequestType.
var (
	RejoinRequestType_name = map[int32]string{
		0: "CONTEXT",
		1: "SESSION",
		2: "KEYS",
	}
	RejoinRequestType_value = map[string]int32{
		"CONTEXT": 0,
		"SESSION": 1,
		"KEYS":    2,
	}
)

func (x RejoinRequestType) Enum() *RejoinRequestType {
	p := new(RejoinRequestType)
	*p = x
	return p
}

func (x RejoinRequestType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RejoinRequestType) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[7].Descriptor()
}

func (RejoinRequestType) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[7]
}

func (x RejoinRequestType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RejoinRequestType.Descriptor instead.
func (RejoinRequestType) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{7}
}

type CFListType int32

const (
	CFListType_FREQUENCIES   CFListType = 0
	CFListType_CHANNEL_MASKS CFListType = 1
)

// Enum value maps for CFListType.
var (
	CFListType_name = map[int32]string{
		0: "FREQUENCIES",
		1: "CHANNEL_MASKS",
	}
	CFListType_value = map[string]int32{
		"FREQUENCIES":   0,
		"CHANNEL_MASKS": 1,
	}
)

func (x CFListType) Enum() *CFListType {
	p := new(CFListType)
	*p = x
	return p
}

func (x CFListType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CFListType) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[8].Descriptor()
}

func (CFListType) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[8]
}

func (x CFListType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CFListType.Descriptor instead.
func (CFListType) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{8}
}

type Class int32

const (
	Class_CLASS_A Class = 0
	Class_CLASS_B Class = 1
	Class_CLASS_C Class = 2
)

// Enum value maps for Class.
var (
	Class_name = map[int32]string{
		0: "CLASS_A",
		1: "CLASS_B",
		2: "CLASS_C",
	}
	Class_value = map[string]int32{
		"CLASS_A": 0,
		"CLASS_B": 1,
		"CLASS_C": 2,
	}
)

func (x Class) Enum() *Class {
	p := new(Class)
	*p = x
	return p
}

func (x Class) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Class) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[9].Descriptor()
}

func (Class) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[9]
}

func (x Class) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Class.Descriptor instead.
func (Class) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{9}
}

type TxSchedulePriority int32

const (
	TxSchedulePriority_LOWEST       TxSchedulePriority = 0
	TxSchedulePriority_LOW          TxSchedulePriority = 1
	TxSchedulePriority_BELOW_NORMAL TxSchedulePriority = 2
	TxSchedulePriority_NORMAL       TxSchedulePriority = 3
	TxSchedulePriority_ABOVE_NORMAL TxSchedulePriority = 4
	TxSchedulePriority_HIGH         TxSchedulePriority = 5
	TxSchedulePriority_HIGHEST      TxSchedulePriority = 6
)

// Enum value maps for TxSchedulePriority.
var (
	TxSchedulePriority_name = map[int32]string{
		0: "LOWEST",
		1: "LOW",
		2: "BELOW_NORMAL",
		3: "NORMAL",
		4: "ABOVE_NORMAL",
		5: "HIGH",
		6: "HIGHEST",
	}
	TxSchedulePriority_value = map[string]int32{
		"LOWEST":       0,
		"LOW":          1,
		"BELOW_NORMAL": 2,
		"NORMAL":       3,
		"ABOVE_NORMAL": 4,
		"HIGH":         5,
		"HIGHEST":      6,
	}
)

func (x TxSchedulePriority) Enum() *TxSchedulePriority {
	p := new(TxSchedulePriority)
	*p = x
	return p
}

func (x TxSchedulePriority) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TxSchedulePriority) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[10].Descriptor()
}

func (TxSchedulePriority) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[10]
}

func (x TxSchedulePriority) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TxSchedulePriority.Descriptor instead.
func (TxSchedulePriority) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{10}
}

type MACCommandIdentifier int32

const (
	MACCommandIdentifier_CID_RFU_0                       MACCommandIdentifier = 0
	MACCommandIdentifier_CID_RESET                       MACCommandIdentifier = 1
	MACCommandIdentifier_CID_LINK_CHECK                  MACCommandIdentifier = 2
	MACCommandIdentifier_CID_LINK_ADR                    MACCommandIdentifier = 3
	MACCommandIdentifier_CID_DUTY_CYCLE                  MACCommandIdentifier = 4
	MACCommandIdentifier_CID_RX_PARAM_SETUP              MACCommandIdentifier = 5
	MACCommandIdentifier_CID_DEV_STATUS                  MACCommandIdentifier = 6
	MACCommandIdentifier_CID_NEW_CHANNEL                 MACCommandIdentifier = 7
	MACCommandIdentifier_CID_RX_TIMING_SETUP             MACCommandIdentifier = 8
	MACCommandIdentifier_CID_TX_PARAM_SETUP              MACCommandIdentifier = 9
	MACCommandIdentifier_CID_DL_CHANNEL                  MACCommandIdentifier = 10
	MACCommandIdentifier_CID_REKEY                       MACCommandIdentifier = 11
	MACCommandIdentifier_CID_ADR_PARAM_SETUP             MACCommandIdentifier = 12
	MACCommandIdentifier_CID_DEVICE_TIME                 MACCommandIdentifier = 13
	MACCommandIdentifier_CID_FORCE_REJOIN                MACCommandIdentifier = 14
	MACCommandIdentifier_CID_REJOIN_PARAM_SETUP          MACCommandIdentifier = 15
	MACCommandIdentifier_CID_PING_SLOT_INFO              MACCommandIdentifier = 16
	MACCommandIdentifier_CID_PING_SLOT_CHANNEL           MACCommandIdentifier = 17
	MACCommandIdentifier_CID_BEACON_TIMING               MACCommandIdentifier = 18 // Deprecated
	MACCommandIdentifier_CID_BEACON_FREQ                 MACCommandIdentifier = 19
	MACCommandIdentifier_CID_DEVICE_MODE                 MACCommandIdentifier = 32
	MACCommandIdentifier_CID_RELAY_CONF                  MACCommandIdentifier = 64
	MACCommandIdentifier_CID_RELAY_END_DEVICE_CONF       MACCommandIdentifier = 65
	MACCommandIdentifier_CID_RELAY_FILTER_LIST           MACCommandIdentifier = 66
	MACCommandIdentifier_CID_RELAY_UPDATE_UPLINK_LIST    MACCommandIdentifier = 67
	MACCommandIdentifier_CID_RELAY_CTRL_UPLINK_LIST      MACCommandIdentifier = 68
	MACCommandIdentifier_CID_RELAY_CONFIGURE_FWD_LIMIT   MACCommandIdentifier = 69
	MACCommandIdentifier_CID_RELAY_NOTIFY_NEW_END_DEVICE MACCommandIdentifier = 70
)

// Enum value maps for MACCommandIdentifier.
var (
	MACCommandIdentifier_name = map[int32]string{
		0:  "CID_RFU_0",
		1:  "CID_RESET",
		2:  "CID_LINK_CHECK",
		3:  "CID_LINK_ADR",
		4:  "CID_DUTY_CYCLE",
		5:  "CID_RX_PARAM_SETUP",
		6:  "CID_DEV_STATUS",
		7:  "CID_NEW_CHANNEL",
		8:  "CID_RX_TIMING_SETUP",
		9:  "CID_TX_PARAM_SETUP",
		10: "CID_DL_CHANNEL",
		11: "CID_REKEY",
		12: "CID_ADR_PARAM_SETUP",
		13: "CID_DEVICE_TIME",
		14: "CID_FORCE_REJOIN",
		15: "CID_REJOIN_PARAM_SETUP",
		16: "CID_PING_SLOT_INFO",
		17: "CID_PING_SLOT_CHANNEL",
		18: "CID_BEACON_TIMING",
		19: "CID_BEACON_FREQ",
		32: "CID_DEVICE_MODE",
		64: "CID_RELAY_CONF",
		65: "CID_RELAY_END_DEVICE_CONF",
		66: "CID_RELAY_FILTER_LIST",
		67: "CID_RELAY_UPDATE_UPLINK_LIST",
		68: "CID_RELAY_CTRL_UPLINK_LIST",
		69: "CID_RELAY_CONFIGURE_FWD_LIMIT",
		70: "CID_RELAY_NOTIFY_NEW_END_DEVICE",
	}
	MACCommandIdentifier_value = map[string]int32{
		"CID_RFU_0":                       0,
		"CID_RESET":                       1,
		"CID_LINK_CHECK":                  2,
		"CID_LINK_ADR":                    3,
		"CID_DUTY_CYCLE":                  4,
		"CID_RX_PARAM_SETUP":              5,
		"CID_DEV_STATUS":                  6,
		"CID_NEW_CHANNEL":                 7,
		"CID_RX_TIMING_SETUP":             8,
		"CID_TX_PARAM_SETUP":              9,
		"CID_DL_CHANNEL":                  10,
		"CID_REKEY":                       11,
		"CID_ADR_PARAM_SETUP":             12,
		"CID_DEVICE_TIME":                 13,
		"CID_FORCE_REJOIN":                14,
		"CID_REJOIN_PARAM_SETUP":          15,
		"CID_PING_SLOT_INFO":              16,
		"CID_PING_SLOT_CHANNEL":           17,
		"CID_BEACON_TIMING":               18,
		"CID_BEACON_FREQ":                 19,
		"CID_DEVICE_MODE":                 32,
		"CID_RELAY_CONF":                  64,
		"CID_RELAY_END_DEVICE_CONF":       65,
		"CID_RELAY_FILTER_LIST":           66,
		"CID_RELAY_UPDATE_UPLINK_LIST":    67,
		"CID_RELAY_CTRL_UPLINK_LIST":      68,
		"CID_RELAY_CONFIGURE_FWD_LIMIT":   69,
		"CID_RELAY_NOTIFY_NEW_END_DEVICE": 70,
	}
)

func (x MACCommandIdentifier) Enum() *MACCommandIdentifier {
	p := new(MACCommandIdentifier)
	*p = x
	return p
}

func (x MACCommandIdentifier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MACCommandIdentifier) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[11].Descriptor()
}

func (MACCommandIdentifier) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[11]
}

func (x MACCommandIdentifier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MACCommandIdentifier.Descriptor instead.
func (MACCommandIdentifier) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{11}
}

type RelayCADPeriodicity int32

const (
	RelayCADPeriodicity_RELAY_CAD_PERIODICITY_1_SECOND         RelayCADPeriodicity = 0
	RelayCADPeriodicity_RELAY_CAD_PERIODICITY_500_MILLISECONDS RelayCADPeriodicity = 1
	RelayCADPeriodicity_RELAY_CAD_PERIODICITY_250_MILLISECONDS RelayCADPeriodicity = 2
	RelayCADPeriodicity_RELAY_CAD_PERIODICITY_100_MILLISECONDS RelayCADPeriodicity = 3
	RelayCADPeriodicity_RELAY_CAD_PERIODICITY_50_MILLISECONDS  RelayCADPeriodicity = 4
	RelayCADPeriodicity_RELAY_CAD_PERIODICITY_20_MILLISECONDS  RelayCADPeriodicity = 5 // sic
)

// Enum value maps for RelayCADPeriodicity.
var (
	RelayCADPeriodicity_name = map[int32]string{
		0: "RELAY_CAD_PERIODICITY_1_SECOND",
		1: "RELAY_CAD_PERIODICITY_500_MILLISECONDS",
		2: "RELAY_CAD_PERIODICITY_250_MILLISECONDS",
		3: "RELAY_CAD_PERIODICITY_100_MILLISECONDS",
		4: "RELAY_CAD_PERIODICITY_50_MILLISECONDS",
		5: "RELAY_CAD_PERIODICITY_20_MILLISECONDS",
	}
	RelayCADPeriodicity_value = map[string]int32{
		"RELAY_CAD_PERIODICITY_1_SECOND":         0,
		"RELAY_CAD_PERIODICITY_500_MILLISECONDS": 1,
		"RELAY_CAD_PERIODICITY_250_MILLISECONDS": 2,
		"RELAY_CAD_PERIODICITY_100_MILLISECONDS": 3,
		"RELAY_CAD_PERIODICITY_50_MILLISECONDS":  4,
		"RELAY_CAD_PERIODICITY_20_MILLISECONDS":  5,
	}
)

func (x RelayCADPeriodicity) Enum() *RelayCADPeriodicity {
	p := new(RelayCADPeriodicity)
	*p = x
	return p
}

func (x RelayCADPeriodicity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RelayCADPeriodicity) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[12].Descriptor()
}

func (RelayCADPeriodicity) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[12]
}

func (x RelayCADPeriodicity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RelayCADPeriodicity.Descriptor instead.
func (RelayCADPeriodicity) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{12}
}

type RelaySecondChAckOffset int32

const (
	RelaySecondChAckOffset_RELAY_SECOND_CH_ACK_OFFSET_0    RelaySecondChAckOffset = 0 // 0 kHz
	RelaySecondChAckOffset_RELAY_SECOND_CH_ACK_OFFSET_200  RelaySecondChAckOffset = 1 // 200 kHz
	RelaySecondChAckOffset_RELAY_SECOND_CH_ACK_OFFSET_400  RelaySecondChAckOffset = 2 // 400 kHz
	RelaySecondChAckOffset_RELAY_SECOND_CH_ACK_OFFSET_800  RelaySecondChAckOffset = 3 // 800 kHz
	RelaySecondChAckOffset_RELAY_SECOND_CH_ACK_OFFSET_1600 RelaySecondChAckOffset = 4 // 1.6 MHz
	RelaySecondChAckOffset_RELAY_SECOND_CH_ACK_OFFSET_3200 RelaySecondChAckOffset = 5 // 3.2 MHz
)

// Enum value maps for RelaySecondChAckOffset.
var (
	RelaySecondChAckOffset_name = map[int32]string{
		0: "RELAY_SECOND_CH_ACK_OFFSET_0",
		1: "RELAY_SECOND_CH_ACK_OFFSET_200",
		2: "RELAY_SECOND_CH_ACK_OFFSET_400",
		3: "RELAY_SECOND_CH_ACK_OFFSET_800",
		4: "RELAY_SECOND_CH_ACK_OFFSET_1600",
		5: "RELAY_SECOND_CH_ACK_OFFSET_3200",
	}
	RelaySecondChAckOffset_value = map[string]int32{
		"RELAY_SECOND_CH_ACK_OFFSET_0":    0,
		"RELAY_SECOND_CH_ACK_OFFSET_200":  1,
		"RELAY_SECOND_CH_ACK_OFFSET_400":  2,
		"RELAY_SECOND_CH_ACK_OFFSET_800":  3,
		"RELAY_SECOND_CH_ACK_OFFSET_1600": 4,
		"RELAY_SECOND_CH_ACK_OFFSET_3200": 5,
	}
)

func (x RelaySecondChAckOffset) Enum() *RelaySecondChAckOffset {
	p := new(RelaySecondChAckOffset)
	*p = x
	return p
}

func (x RelaySecondChAckOffset) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RelaySecondChAckOffset) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[13].Descriptor()
}

func (RelaySecondChAckOffset) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[13]
}

func (x RelaySecondChAckOffset) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RelaySecondChAckOffset.Descriptor instead.
func (RelaySecondChAckOffset) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{13}
}

type RelayLimitBucketSize int32

const (
	RelayLimitBucketSize_RELAY_LIMIT_BUCKET_SIZE_1  RelayLimitBucketSize = 0
	RelayLimitBucketSize_RELAY_LIMIT_BUCKET_SIZE_2  RelayLimitBucketSize = 1
	RelayLimitBucketSize_RELAY_LIMIT_BUCKET_SIZE_4  RelayLimitBucketSize = 2
	RelayLimitBucketSize_RELAY_LIMIT_BUCKET_SIZE_12 RelayLimitBucketSize = 3 // sic
)

// Enum value maps for RelayLimitBucketSize.
var (
	RelayLimitBucketSize_name = map[int32]string{
		0: "RELAY_LIMIT_BUCKET_SIZE_1",
		1: "RELAY_LIMIT_BUCKET_SIZE_2",
		2: "RELAY_LIMIT_BUCKET_SIZE_4",
		3: "RELAY_LIMIT_BUCKET_SIZE_12",
	}
	RelayLimitBucketSize_value = map[string]int32{
		"RELAY_LIMIT_BUCKET_SIZE_1":  0,
		"RELAY_LIMIT_BUCKET_SIZE_2":  1,
		"RELAY_LIMIT_BUCKET_SIZE_4":  2,
		"RELAY_LIMIT_BUCKET_SIZE_12": 3,
	}
)

func (x RelayLimitBucketSize) Enum() *RelayLimitBucketSize {
	p := new(RelayLimitBucketSize)
	*p = x
	return p
}

func (x RelayLimitBucketSize) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RelayLimitBucketSize) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[14].Descriptor()
}

func (RelayLimitBucketSize) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[14]
}

func (x RelayLimitBucketSize) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RelayLimitBucketSize.Descriptor instead.
func (RelayLimitBucketSize) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{14}
}

type RelaySmartEnableLevel int32

const (
	RelaySmartEnableLevel_RELAY_SMART_ENABLE_LEVEL_8  RelaySmartEnableLevel = 0
	RelaySmartEnableLevel_RELAY_SMART_ENABLE_LEVEL_16 RelaySmartEnableLevel = 1
	RelaySmartEnableLevel_RELAY_SMART_ENABLE_LEVEL_32 RelaySmartEnableLevel = 2
	RelaySmartEnableLevel_RELAY_SMART_ENABLE_LEVEL_64 RelaySmartEnableLevel = 3
)

// Enum value maps for RelaySmartEnableLevel.
var (
	RelaySmartEnableLevel_name = map[int32]string{
		0: "RELAY_SMART_ENABLE_LEVEL_8",
		1: "RELAY_SMART_ENABLE_LEVEL_16",
		2: "RELAY_SMART_ENABLE_LEVEL_32",
		3: "RELAY_SMART_ENABLE_LEVEL_64",
	}
	RelaySmartEnableLevel_value = map[string]int32{
		"RELAY_SMART_ENABLE_LEVEL_8":  0,
		"RELAY_SMART_ENABLE_LEVEL_16": 1,
		"RELAY_SMART_ENABLE_LEVEL_32": 2,
		"RELAY_SMART_ENABLE_LEVEL_64": 3,
	}
)

func (x RelaySmartEnableLevel) Enum() *RelaySmartEnableLevel {
	p := new(RelaySmartEnableLevel)
	*p = x
	return p
}

func (x RelaySmartEnableLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RelaySmartEnableLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[15].Descriptor()
}

func (RelaySmartEnableLevel) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[15]
}

func (x RelaySmartEnableLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RelaySmartEnableLevel.Descriptor instead.
func (RelaySmartEnableLevel) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{15}
}

type RelayWORChannel int32

const (
	RelayWORChannel_RELAY_WOR_CHANNEL_DEFAULT   RelayWORChannel = 0
	RelayWORChannel_RELAY_WOR_CHANNEL_SECONDARY RelayWORChannel = 1
)

// Enum value maps for RelayWORChannel.
var (
	RelayWORChannel_name = map[int32]string{
		0: "RELAY_WOR_CHANNEL_DEFAULT",
		1: "RELAY_WOR_CHANNEL_SECONDARY",
	}
	RelayWORChannel_value = map[string]int32{
		"RELAY_WOR_CHANNEL_DEFAULT":   0,
		"RELAY_WOR_CHANNEL_SECONDARY": 1,
	}
)

func (x RelayWORChannel) Enum() *RelayWORChannel {
	p := new(RelayWORChannel)
	*p = x
	return p
}

func (x RelayWORChannel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RelayWORChannel) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[16].Descriptor()
}

func (RelayWORChannel) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[16]
}

func (x RelayWORChannel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RelayWORChannel.Descriptor instead.
func (RelayWORChannel) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{16}
}

type RelayResetLimitCounter int32

const (
	RelayResetLimitCounter_RELAY_RESET_LIMIT_COUNTER_ZERO        RelayResetLimitCounter = 0
	RelayResetLimitCounter_RELAY_RESET_LIMIT_COUNTER_RELOAD_RATE RelayResetLimitCounter = 1
	RelayResetLimitCounter_RELAY_RESET_LIMIT_COUNTER_MAX_VALUE   RelayResetLimitCounter = 2
	RelayResetLimitCounter_RELAY_RESET_LIMIT_COUNTER_NO_RESET    RelayResetLimitCounter = 3
)

// Enum value maps for RelayResetLimitCounter.
var (
	RelayResetLimitCounter_name = map[int32]string{
		0: "RELAY_RESET_LIMIT_COUNTER_ZERO",
		1: "RELAY_RESET_LIMIT_COUNTER_RELOAD_RATE",
		2: "RELAY_RESET_LIMIT_COUNTER_MAX_VALUE",
		3: "RELAY_RESET_LIMIT_COUNTER_NO_RESET",
	}
	RelayResetLimitCounter_value = map[string]int32{
		"RELAY_RESET_LIMIT_COUNTER_ZERO":        0,
		"RELAY_RESET_LIMIT_COUNTER_RELOAD_RATE": 1,
		"RELAY_RESET_LIMIT_COUNTER_MAX_VALUE":   2,
		"RELAY_RESET_LIMIT_COUNTER_NO_RESET":    3,
	}
)

func (x RelayResetLimitCounter) Enum() *RelayResetLimitCounter {
	p := new(RelayResetLimitCounter)
	*p = x
	return p
}

func (x RelayResetLimitCounter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RelayResetLimitCounter) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[17].Descriptor()
}

func (RelayResetLimitCounter) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[17]
}

func (x RelayResetLimitCounter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RelayResetLimitCounter.Descriptor instead.
func (RelayResetLimitCounter) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{17}
}

type RelayCtrlUplinkListAction int32

const (
	RelayCtrlUplinkListAction_RELAY_CTRL_UPLINK_LIST_ACTION_READ_W_F_CNT              RelayCtrlUplinkListAction = 0
	RelayCtrlUplinkListAction_RELAY_CTRL_UPLINK_LIST_ACTION_REMOVE_TRUSTED_END_DEVICE RelayCtrlUplinkListAction = 1
)

// Enum value maps for RelayCtrlUplinkListAction.
var (
	RelayCtrlUplinkListAction_name = map[int32]string{
		0: "RELAY_CTRL_UPLINK_LIST_ACTION_READ_W_F_CNT",
		1: "RELAY_CTRL_UPLINK_LIST_ACTION_REMOVE_TRUSTED_END_DEVICE",
	}
	RelayCtrlUplinkListAction_value = map[string]int32{
		"RELAY_CTRL_UPLINK_LIST_ACTION_READ_W_F_CNT":              0,
		"RELAY_CTRL_UPLINK_LIST_ACTION_REMOVE_TRUSTED_END_DEVICE": 1,
	}
)

func (x RelayCtrlUplinkListAction) Enum() *RelayCtrlUplinkListAction {
	p := new(RelayCtrlUplinkListAction)
	*p = x
	return p
}

func (x RelayCtrlUplinkListAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RelayCtrlUplinkListAction) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[18].Descriptor()
}

func (RelayCtrlUplinkListAction) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[18]
}

func (x RelayCtrlUplinkListAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RelayCtrlUplinkListAction.Descriptor instead.
func (RelayCtrlUplinkListAction) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{18}
}

type AggregatedDutyCycle int32

const (
	AggregatedDutyCycle_DUTY_CYCLE_1     AggregatedDutyCycle = 0  // 100%.
	AggregatedDutyCycle_DUTY_CYCLE_2     AggregatedDutyCycle = 1  // 50%.
	AggregatedDutyCycle_DUTY_CYCLE_4     AggregatedDutyCycle = 2  // 25%.
	AggregatedDutyCycle_DUTY_CYCLE_8     AggregatedDutyCycle = 3  // 12.5%.
	AggregatedDutyCycle_DUTY_CYCLE_16    AggregatedDutyCycle = 4  // 6.25%.
	AggregatedDutyCycle_DUTY_CYCLE_32    AggregatedDutyCycle = 5  // 3.125%.
	AggregatedDutyCycle_DUTY_CYCLE_64    AggregatedDutyCycle = 6  // 1.5625%.
	AggregatedDutyCycle_DUTY_CYCLE_128   AggregatedDutyCycle = 7  // Roughly 0.781%.
	AggregatedDutyCycle_DUTY_CYCLE_256   AggregatedDutyCycle = 8  // Roughly 0.390%.
	AggregatedDutyCycle_DUTY_CYCLE_512   AggregatedDutyCycle = 9  // Roughly 0.195%.
	AggregatedDutyCycle_DUTY_CYCLE_1024  AggregatedDutyCycle = 10 // Roughly 0.098%.
	AggregatedDutyCycle_DUTY_CYCLE_2048  AggregatedDutyCycle = 11 // Roughly 0.049%.
	AggregatedDutyCycle_DUTY_CYCLE_4096  AggregatedDutyCycle = 12 // Roughly 0.024%.
	AggregatedDutyCycle_DUTY_CYCLE_8192  AggregatedDutyCycle = 13 // Roughly 0.012%.
	AggregatedDutyCycle_DUTY_CYCLE_16384 AggregatedDutyCycle = 14 // Roughly 0.006%.
	AggregatedDutyCycle_DUTY_CYCLE_32768 AggregatedDutyCycle = 15 // Roughly 0.003%.
)

// Enum value maps for AggregatedDutyCycle.
var (
	AggregatedDutyCycle_name = map[int32]string{
		0:  "DUTY_CYCLE_1",
		1:  "DUTY_CYCLE_2",
		2:  "DUTY_CYCLE_4",
		3:  "DUTY_CYCLE_8",
		4:  "DUTY_CYCLE_16",
		5:  "DUTY_CYCLE_32",
		6:  "DUTY_CYCLE_64",
		7:  "DUTY_CYCLE_128",
		8:  "DUTY_CYCLE_256",
		9:  "DUTY_CYCLE_512",
		10: "DUTY_CYCLE_1024",
		11: "DUTY_CYCLE_2048",
		12: "DUTY_CYCLE_4096",
		13: "DUTY_CYCLE_8192",
		14: "DUTY_CYCLE_16384",
		15: "DUTY_CYCLE_32768",
	}
	AggregatedDutyCycle_value = map[string]int32{
		"DUTY_CYCLE_1":     0,
		"DUTY_CYCLE_2":     1,
		"DUTY_CYCLE_4":     2,
		"DUTY_CYCLE_8":     3,
		"DUTY_CYCLE_16":    4,
		"DUTY_CYCLE_32":    5,
		"DUTY_CYCLE_64":    6,
		"DUTY_CYCLE_128":   7,
		"DUTY_CYCLE_256":   8,
		"DUTY_CYCLE_512":   9,
		"DUTY_CYCLE_1024":  10,
		"DUTY_CYCLE_2048":  11,
		"DUTY_CYCLE_4096":  12,
		"DUTY_CYCLE_8192":  13,
		"DUTY_CYCLE_16384": 14,
		"DUTY_CYCLE_32768": 15,
	}
)

func (x AggregatedDutyCycle) Enum() *AggregatedDutyCycle {
	p := new(AggregatedDutyCycle)
	*p = x
	return p
}

func (x AggregatedDutyCycle) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AggregatedDutyCycle) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[19].Descriptor()
}

func (AggregatedDutyCycle) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[19]
}

func (x AggregatedDutyCycle) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AggregatedDutyCycle.Descriptor instead.
func (AggregatedDutyCycle) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{19}
}

type PingSlotPeriod int32

const (
	PingSlotPeriod_PING_EVERY_1S   PingSlotPeriod = 0 // Every second.
	PingSlotPeriod_PING_EVERY_2S   PingSlotPeriod = 1 // Every 2 seconds.
	PingSlotPeriod_PING_EVERY_4S   PingSlotPeriod = 2 // Every 4 seconds.
	PingSlotPeriod_PING_EVERY_8S   PingSlotPeriod = 3 // Every 8 seconds.
	PingSlotPeriod_PING_EVERY_16S  PingSlotPeriod = 4 // Every 16 seconds.
	PingSlotPeriod_PING_EVERY_32S  PingSlotPeriod = 5 // Every 32 seconds.
	PingSlotPeriod_PING_EVERY_64S  PingSlotPeriod = 6 // Every 64 seconds.
	PingSlotPeriod_PING_EVERY_128S PingSlotPeriod = 7 // Every 128 seconds.
)

// Enum value maps for PingSlotPeriod.
var (
	PingSlotPeriod_name = map[int32]string{
		0: "PING_EVERY_1S",
		1: "PING_EVERY_2S",
		2: "PING_EVERY_4S",
		3: "PING_EVERY_8S",
		4: "PING_EVERY_16S",
		5: "PING_EVERY_32S",
		6: "PING_EVERY_64S",
		7: "PING_EVERY_128S",
	}
	PingSlotPeriod_value = map[string]int32{
		"PING_EVERY_1S":   0,
		"PING_EVERY_2S":   1,
		"PING_EVERY_4S":   2,
		"PING_EVERY_8S":   3,
		"PING_EVERY_16S":  4,
		"PING_EVERY_32S":  5,
		"PING_EVERY_64S":  6,
		"PING_EVERY_128S": 7,
	}
)

func (x PingSlotPeriod) Enum() *PingSlotPeriod {
	p := new(PingSlotPeriod)
	*p = x
	return p
}

func (x PingSlotPeriod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PingSlotPeriod) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[20].Descriptor()
}

func (PingSlotPeriod) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[20]
}

func (x PingSlotPeriod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PingSlotPeriod.Descriptor instead.
func (PingSlotPeriod) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{20}
}

type RejoinCountExponent int32

const (
	RejoinCountExponent_REJOIN_COUNT_16     RejoinCountExponent = 0
	RejoinCountExponent_REJOIN_COUNT_32     RejoinCountExponent = 1
	RejoinCountExponent_REJOIN_COUNT_64     RejoinCountExponent = 2
	RejoinCountExponent_REJOIN_COUNT_128    RejoinCountExponent = 3
	RejoinCountExponent_REJOIN_COUNT_256    RejoinCountExponent = 4
	RejoinCountExponent_REJOIN_COUNT_512    RejoinCountExponent = 5
	RejoinCountExponent_REJOIN_COUNT_1024   RejoinCountExponent = 6
	RejoinCountExponent_REJOIN_COUNT_2048   RejoinCountExponent = 7
	RejoinCountExponent_REJOIN_COUNT_4096   RejoinCountExponent = 8
	RejoinCountExponent_REJOIN_COUNT_8192   RejoinCountExponent = 9
	RejoinCountExponent_REJOIN_COUNT_16384  RejoinCountExponent = 10
	RejoinCountExponent_REJOIN_COUNT_32768  RejoinCountExponent = 11
	RejoinCountExponent_REJOIN_COUNT_65536  RejoinCountExponent = 12
	RejoinCountExponent_REJOIN_COUNT_131072 RejoinCountExponent = 13
	RejoinCountExponent_REJOIN_COUNT_262144 RejoinCountExponent = 14
	RejoinCountExponent_REJOIN_COUNT_524288 RejoinCountExponent = 15
)

// Enum value maps for RejoinCountExponent.
var (
	RejoinCountExponent_name = map[int32]string{
		0:  "REJOIN_COUNT_16",
		1:  "REJOIN_COUNT_32",
		2:  "REJOIN_COUNT_64",
		3:  "REJOIN_COUNT_128",
		4:  "REJOIN_COUNT_256",
		5:  "REJOIN_COUNT_512",
		6:  "REJOIN_COUNT_1024",
		7:  "REJOIN_COUNT_2048",
		8:  "REJOIN_COUNT_4096",
		9:  "REJOIN_COUNT_8192",
		10: "REJOIN_COUNT_16384",
		11: "REJOIN_COUNT_32768",
		12: "REJOIN_COUNT_65536",
		13: "REJOIN_COUNT_131072",
		14: "REJOIN_COUNT_262144",
		15: "REJOIN_COUNT_524288",
	}
	RejoinCountExponent_value = map[string]int32{
		"REJOIN_COUNT_16":     0,
		"REJOIN_COUNT_32":     1,
		"REJOIN_COUNT_64":     2,
		"REJOIN_COUNT_128":    3,
		"REJOIN_COUNT_256":    4,
		"REJOIN_COUNT_512":    5,
		"REJOIN_COUNT_1024":   6,
		"REJOIN_COUNT_2048":   7,
		"REJOIN_COUNT_4096":   8,
		"REJOIN_COUNT_8192":   9,
		"REJOIN_COUNT_16384":  10,
		"REJOIN_COUNT_32768":  11,
		"REJOIN_COUNT_65536":  12,
		"REJOIN_COUNT_131072": 13,
		"REJOIN_COUNT_262144": 14,
		"REJOIN_COUNT_524288": 15,
	}
)

func (x RejoinCountExponent) Enum() *RejoinCountExponent {
	p := new(RejoinCountExponent)
	*p = x
	return p
}

func (x RejoinCountExponent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RejoinCountExponent) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[21].Descriptor()
}

func (RejoinCountExponent) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[21]
}

func (x RejoinCountExponent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RejoinCountExponent.Descriptor instead.
func (RejoinCountExponent) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{21}
}

type RejoinTimeExponent int32

const (
	RejoinTimeExponent_REJOIN_TIME_0  RejoinTimeExponent = 0  // Every ~17.1 minutes.
	RejoinTimeExponent_REJOIN_TIME_1  RejoinTimeExponent = 1  // Every ~34.1 minutes.
	RejoinTimeExponent_REJOIN_TIME_2  RejoinTimeExponent = 2  // Every ~1.1 hours.
	RejoinTimeExponent_REJOIN_TIME_3  RejoinTimeExponent = 3  // Every ~2.3 hours.
	RejoinTimeExponent_REJOIN_TIME_4  RejoinTimeExponent = 4  // Every ~4.6 hours.
	RejoinTimeExponent_REJOIN_TIME_5  RejoinTimeExponent = 5  // Every ~9.1 hours.
	RejoinTimeExponent_REJOIN_TIME_6  RejoinTimeExponent = 6  // Every ~18.2 hours.
	RejoinTimeExponent_REJOIN_TIME_7  RejoinTimeExponent = 7  // Every ~1.5 days.
	RejoinTimeExponent_REJOIN_TIME_8  RejoinTimeExponent = 8  // Every ~3.0 days.
	RejoinTimeExponent_REJOIN_TIME_9  RejoinTimeExponent = 9  // Every ~6.1 days.
	RejoinTimeExponent_REJOIN_TIME_10 RejoinTimeExponent = 10 // Every ~12.1 days.
	RejoinTimeExponent_REJOIN_TIME_11 RejoinTimeExponent = 11 // Every ~3.5 weeks.
	RejoinTimeExponent_REJOIN_TIME_12 RejoinTimeExponent = 12 // Every ~1.6 months.
	RejoinTimeExponent_REJOIN_TIME_13 RejoinTimeExponent = 13 // Every ~3.2 months.
	RejoinTimeExponent_REJOIN_TIME_14 RejoinTimeExponent = 14 // Every ~6.4 months.
	RejoinTimeExponent_REJOIN_TIME_15 RejoinTimeExponent = 15 // Every ~1.1 year.
)

// Enum value maps for RejoinTimeExponent.
var (
	RejoinTimeExponent_name = map[int32]string{
		0:  "REJOIN_TIME_0",
		1:  "REJOIN_TIME_1",
		2:  "REJOIN_TIME_2",
		3:  "REJOIN_TIME_3",
		4:  "REJOIN_TIME_4",
		5:  "REJOIN_TIME_5",
		6:  "REJOIN_TIME_6",
		7:  "REJOIN_TIME_7",
		8:  "REJOIN_TIME_8",
		9:  "REJOIN_TIME_9",
		10: "REJOIN_TIME_10",
		11: "REJOIN_TIME_11",
		12: "REJOIN_TIME_12",
		13: "REJOIN_TIME_13",
		14: "REJOIN_TIME_14",
		15: "REJOIN_TIME_15",
	}
	RejoinTimeExponent_value = map[string]int32{
		"REJOIN_TIME_0":  0,
		"REJOIN_TIME_1":  1,
		"REJOIN_TIME_2":  2,
		"REJOIN_TIME_3":  3,
		"REJOIN_TIME_4":  4,
		"REJOIN_TIME_5":  5,
		"REJOIN_TIME_6":  6,
		"REJOIN_TIME_7":  7,
		"REJOIN_TIME_8":  8,
		"REJOIN_TIME_9":  9,
		"REJOIN_TIME_10": 10,
		"REJOIN_TIME_11": 11,
		"REJOIN_TIME_12": 12,
		"REJOIN_TIME_13": 13,
		"REJOIN_TIME_14": 14,
		"REJOIN_TIME_15": 15,
	}
)

func (x RejoinTimeExponent) Enum() *RejoinTimeExponent {
	p := new(RejoinTimeExponent)
	*p = x
	return p
}

func (x RejoinTimeExponent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RejoinTimeExponent) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[22].Descriptor()
}

func (RejoinTimeExponent) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[22]
}

func (x RejoinTimeExponent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RejoinTimeExponent.Descriptor instead.
func (RejoinTimeExponent) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{22}
}

type RejoinPeriodExponent int32

const (
	RejoinPeriodExponent_REJOIN_PERIOD_0 RejoinPeriodExponent = 0 // Every 32 to 64 seconds.
	RejoinPeriodExponent_REJOIN_PERIOD_1 RejoinPeriodExponent = 1 // Every 64 to 96 seconds.
	RejoinPeriodExponent_REJOIN_PERIOD_2 RejoinPeriodExponent = 2 // Every 128 to 160 seconds.
	RejoinPeriodExponent_REJOIN_PERIOD_3 RejoinPeriodExponent = 3 // Every 256 to 288 seconds.
	RejoinPeriodExponent_REJOIN_PERIOD_4 RejoinPeriodExponent = 4 // Every 512 to 544 seconds.
	RejoinPeriodExponent_REJOIN_PERIOD_5 RejoinPeriodExponent = 5 // Every 1024 to 1056 seconds.
	RejoinPeriodExponent_REJOIN_PERIOD_6 RejoinPeriodExponent = 6 // Every 2048 to 2080 seconds.
	RejoinPeriodExponent_REJOIN_PERIOD_7 RejoinPeriodExponent = 7 // Every 4096 to 4128 seconds.
)

// Enum value maps for RejoinPeriodExponent.
var (
	RejoinPeriodExponent_name = map[int32]string{
		0: "REJOIN_PERIOD_0",
		1: "REJOIN_PERIOD_1",
		2: "REJOIN_PERIOD_2",
		3: "REJOIN_PERIOD_3",
		4: "REJOIN_PERIOD_4",
		5: "REJOIN_PERIOD_5",
		6: "REJOIN_PERIOD_6",
		7: "REJOIN_PERIOD_7",
	}
	RejoinPeriodExponent_value = map[string]int32{
		"REJOIN_PERIOD_0": 0,
		"REJOIN_PERIOD_1": 1,
		"REJOIN_PERIOD_2": 2,
		"REJOIN_PERIOD_3": 3,
		"REJOIN_PERIOD_4": 4,
		"REJOIN_PERIOD_5": 5,
		"REJOIN_PERIOD_6": 6,
		"REJOIN_PERIOD_7": 7,
	}
)

func (x RejoinPeriodExponent) Enum() *RejoinPeriodExponent {
	p := new(RejoinPeriodExponent)
	*p = x
	return p
}

func (x RejoinPeriodExponent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RejoinPeriodExponent) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[23].Descriptor()
}

func (RejoinPeriodExponent) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[23]
}

func (x RejoinPeriodExponent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RejoinPeriodExponent.Descriptor instead.
func (RejoinPeriodExponent) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{23}
}

type DeviceEIRP int32

const (
	DeviceEIRP_DEVICE_EIRP_8  DeviceEIRP = 0  // 8 dBm.
	DeviceEIRP_DEVICE_EIRP_10 DeviceEIRP = 1  // 10 dBm.
	DeviceEIRP_DEVICE_EIRP_12 DeviceEIRP = 2  // 12 dBm.
	DeviceEIRP_DEVICE_EIRP_13 DeviceEIRP = 3  // 13 dBm.
	DeviceEIRP_DEVICE_EIRP_14 DeviceEIRP = 4  // 14 dBm.
	DeviceEIRP_DEVICE_EIRP_16 DeviceEIRP = 5  // 16 dBm.
	DeviceEIRP_DEVICE_EIRP_18 DeviceEIRP = 6  // 18 dBm.
	DeviceEIRP_DEVICE_EIRP_20 DeviceEIRP = 7  // 20 dBm.
	DeviceEIRP_DEVICE_EIRP_21 DeviceEIRP = 8  // 21 dBm.
	DeviceEIRP_DEVICE_EIRP_24 DeviceEIRP = 9  // 24 dBm.
	DeviceEIRP_DEVICE_EIRP_26 DeviceEIRP = 10 // 26 dBm.
	DeviceEIRP_DEVICE_EIRP_27 DeviceEIRP = 11 // 27 dBm.
	DeviceEIRP_DEVICE_EIRP_29 DeviceEIRP = 12 // 29 dBm.
	DeviceEIRP_DEVICE_EIRP_30 DeviceEIRP = 13 // 30 dBm.
	DeviceEIRP_DEVICE_EIRP_33 DeviceEIRP = 14 // 33 dBm.
	DeviceEIRP_DEVICE_EIRP_36 DeviceEIRP = 15 // 36 dBm.
)

// Enum value maps for DeviceEIRP.
var (
	DeviceEIRP_name = map[int32]string{
		0:  "DEVICE_EIRP_8",
		1:  "DEVICE_EIRP_10",
		2:  "DEVICE_EIRP_12",
		3:  "DEVICE_EIRP_13",
		4:  "DEVICE_EIRP_14",
		5:  "DEVICE_EIRP_16",
		6:  "DEVICE_EIRP_18",
		7:  "DEVICE_EIRP_20",
		8:  "DEVICE_EIRP_21",
		9:  "DEVICE_EIRP_24",
		10: "DEVICE_EIRP_26",
		11: "DEVICE_EIRP_27",
		12: "DEVICE_EIRP_29",
		13: "DEVICE_EIRP_30",
		14: "DEVICE_EIRP_33",
		15: "DEVICE_EIRP_36",
	}
	DeviceEIRP_value = map[string]int32{
		"DEVICE_EIRP_8":  0,
		"DEVICE_EIRP_10": 1,
		"DEVICE_EIRP_12": 2,
		"DEVICE_EIRP_13": 3,
		"DEVICE_EIRP_14": 4,
		"DEVICE_EIRP_16": 5,
		"DEVICE_EIRP_18": 6,
		"DEVICE_EIRP_20": 7,
		"DEVICE_EIRP_21": 8,
		"DEVICE_EIRP_24": 9,
		"DEVICE_EIRP_26": 10,
		"DEVICE_EIRP_27": 11,
		"DEVICE_EIRP_29": 12,
		"DEVICE_EIRP_30": 13,
		"DEVICE_EIRP_33": 14,
		"DEVICE_EIRP_36": 15,
	}
)

func (x DeviceEIRP) Enum() *DeviceEIRP {
	p := new(DeviceEIRP)
	*p = x
	return p
}

func (x DeviceEIRP) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeviceEIRP) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[24].Descriptor()
}

func (DeviceEIRP) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[24]
}

func (x DeviceEIRP) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeviceEIRP.Descriptor instead.
func (DeviceEIRP) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{24}
}

type ADRAckLimitExponent int32

const (
	ADRAckLimitExponent_ADR_ACK_LIMIT_1     ADRAckLimitExponent = 0
	ADRAckLimitExponent_ADR_ACK_LIMIT_2     ADRAckLimitExponent = 1
	ADRAckLimitExponent_ADR_ACK_LIMIT_4     ADRAckLimitExponent = 2
	ADRAckLimitExponent_ADR_ACK_LIMIT_8     ADRAckLimitExponent = 3
	ADRAckLimitExponent_ADR_ACK_LIMIT_16    ADRAckLimitExponent = 4
	ADRAckLimitExponent_ADR_ACK_LIMIT_32    ADRAckLimitExponent = 5
	ADRAckLimitExponent_ADR_ACK_LIMIT_64    ADRAckLimitExponent = 6
	ADRAckLimitExponent_ADR_ACK_LIMIT_128   ADRAckLimitExponent = 7
	ADRAckLimitExponent_ADR_ACK_LIMIT_256   ADRAckLimitExponent = 8
	ADRAckLimitExponent_ADR_ACK_LIMIT_512   ADRAckLimitExponent = 9
	ADRAckLimitExponent_ADR_ACK_LIMIT_1024  ADRAckLimitExponent = 10
	ADRAckLimitExponent_ADR_ACK_LIMIT_2048  ADRAckLimitExponent = 11
	ADRAckLimitExponent_ADR_ACK_LIMIT_4096  ADRAckLimitExponent = 12
	ADRAckLimitExponent_ADR_ACK_LIMIT_8192  ADRAckLimitExponent = 13
	ADRAckLimitExponent_ADR_ACK_LIMIT_16384 ADRAckLimitExponent = 14
	ADRAckLimitExponent_ADR_ACK_LIMIT_32768 ADRAckLimitExponent = 15
)

// Enum value maps for ADRAckLimitExponent.
var (
	ADRAckLimitExponent_name = map[int32]string{
		0:  "ADR_ACK_LIMIT_1",
		1:  "ADR_ACK_LIMIT_2",
		2:  "ADR_ACK_LIMIT_4",
		3:  "ADR_ACK_LIMIT_8",
		4:  "ADR_ACK_LIMIT_16",
		5:  "ADR_ACK_LIMIT_32",
		6:  "ADR_ACK_LIMIT_64",
		7:  "ADR_ACK_LIMIT_128",
		8:  "ADR_ACK_LIMIT_256",
		9:  "ADR_ACK_LIMIT_512",
		10: "ADR_ACK_LIMIT_1024",
		11: "ADR_ACK_LIMIT_2048",
		12: "ADR_ACK_LIMIT_4096",
		13: "ADR_ACK_LIMIT_8192",
		14: "ADR_ACK_LIMIT_16384",
		15: "ADR_ACK_LIMIT_32768",
	}
	ADRAckLimitExponent_value = map[string]int32{
		"ADR_ACK_LIMIT_1":     0,
		"ADR_ACK_LIMIT_2":     1,
		"ADR_ACK_LIMIT_4":     2,
		"ADR_ACK_LIMIT_8":     3,
		"ADR_ACK_LIMIT_16":    4,
		"ADR_ACK_LIMIT_32":    5,
		"ADR_ACK_LIMIT_64":    6,
		"ADR_ACK_LIMIT_128":   7,
		"ADR_ACK_LIMIT_256":   8,
		"ADR_ACK_LIMIT_512":   9,
		"ADR_ACK_LIMIT_1024":  10,
		"ADR_ACK_LIMIT_2048":  11,
		"ADR_ACK_LIMIT_4096":  12,
		"ADR_ACK_LIMIT_8192":  13,
		"ADR_ACK_LIMIT_16384": 14,
		"ADR_ACK_LIMIT_32768": 15,
	}
)

func (x ADRAckLimitExponent) Enum() *ADRAckLimitExponent {
	p := new(ADRAckLimitExponent)
	*p = x
	return p
}

func (x ADRAckLimitExponent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ADRAckLimitExponent) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[25].Descriptor()
}

func (ADRAckLimitExponent) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[25]
}

func (x ADRAckLimitExponent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ADRAckLimitExponent.Descriptor instead.
func (ADRAckLimitExponent) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{25}
}

type ADRAckDelayExponent int32

const (
	ADRAckDelayExponent_ADR_ACK_DELAY_1     ADRAckDelayExponent = 0
	ADRAckDelayExponent_ADR_ACK_DELAY_2     ADRAckDelayExponent = 1
	ADRAckDelayExponent_ADR_ACK_DELAY_4     ADRAckDelayExponent = 2
	ADRAckDelayExponent_ADR_ACK_DELAY_8     ADRAckDelayExponent = 3
	ADRAckDelayExponent_ADR_ACK_DELAY_16    ADRAckDelayExponent = 4
	ADRAckDelayExponent_ADR_ACK_DELAY_32    ADRAckDelayExponent = 5
	ADRAckDelayExponent_ADR_ACK_DELAY_64    ADRAckDelayExponent = 6
	ADRAckDelayExponent_ADR_ACK_DELAY_128   ADRAckDelayExponent = 7
	ADRAckDelayExponent_ADR_ACK_DELAY_256   ADRAckDelayExponent = 8
	ADRAckDelayExponent_ADR_ACK_DELAY_512   ADRAckDelayExponent = 9
	ADRAckDelayExponent_ADR_ACK_DELAY_1024  ADRAckDelayExponent = 10
	ADRAckDelayExponent_ADR_ACK_DELAY_2048  ADRAckDelayExponent = 11
	ADRAckDelayExponent_ADR_ACK_DELAY_4096  ADRAckDelayExponent = 12
	ADRAckDelayExponent_ADR_ACK_DELAY_8192  ADRAckDelayExponent = 13
	ADRAckDelayExponent_ADR_ACK_DELAY_16384 ADRAckDelayExponent = 14
	ADRAckDelayExponent_ADR_ACK_DELAY_32768 ADRAckDelayExponent = 15
)

// Enum value maps for ADRAckDelayExponent.
var (
	ADRAckDelayExponent_name = map[int32]string{
		0:  "ADR_ACK_DELAY_1",
		1:  "ADR_ACK_DELAY_2",
		2:  "ADR_ACK_DELAY_4",
		3:  "ADR_ACK_DELAY_8",
		4:  "ADR_ACK_DELAY_16",
		5:  "ADR_ACK_DELAY_32",
		6:  "ADR_ACK_DELAY_64",
		7:  "ADR_ACK_DELAY_128",
		8:  "ADR_ACK_DELAY_256",
		9:  "ADR_ACK_DELAY_512",
		10: "ADR_ACK_DELAY_1024",
		11: "ADR_ACK_DELAY_2048",
		12: "ADR_ACK_DELAY_4096",
		13: "ADR_ACK_DELAY_8192",
		14: "ADR_ACK_DELAY_16384",
		15: "ADR_ACK_DELAY_32768",
	}
	ADRAckDelayExponent_value = map[string]int32{
		"ADR_ACK_DELAY_1":     0,
		"ADR_ACK_DELAY_2":     1,
		"ADR_ACK_DELAY_4":     2,
		"ADR_ACK_DELAY_8":     3,
		"ADR_ACK_DELAY_16":    4,
		"ADR_ACK_DELAY_32":    5,
		"ADR_ACK_DELAY_64":    6,
		"ADR_ACK_DELAY_128":   7,
		"ADR_ACK_DELAY_256":   8,
		"ADR_ACK_DELAY_512":   9,
		"ADR_ACK_DELAY_1024":  10,
		"ADR_ACK_DELAY_2048":  11,
		"ADR_ACK_DELAY_4096":  12,
		"ADR_ACK_DELAY_8192":  13,
		"ADR_ACK_DELAY_16384": 14,
		"ADR_ACK_DELAY_32768": 15,
	}
)

func (x ADRAckDelayExponent) Enum() *ADRAckDelayExponent {
	p := new(ADRAckDelayExponent)
	*p = x
	return p
}

func (x ADRAckDelayExponent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ADRAckDelayExponent) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[26].Descriptor()
}

func (ADRAckDelayExponent) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[26]
}

func (x ADRAckDelayExponent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ADRAckDelayExponent.Descriptor instead.
func (ADRAckDelayExponent) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26}
}

type RxDelay int32

const (
	RxDelay_RX_DELAY_0  RxDelay = 0  // 1 second.
	RxDelay_RX_DELAY_1  RxDelay = 1  // 1 second.
	RxDelay_RX_DELAY_2  RxDelay = 2  // 2 seconds.
	RxDelay_RX_DELAY_3  RxDelay = 3  // 3 seconds.
	RxDelay_RX_DELAY_4  RxDelay = 4  // 4 seconds.
	RxDelay_RX_DELAY_5  RxDelay = 5  // 5 seconds.
	RxDelay_RX_DELAY_6  RxDelay = 6  // 6 seconds.
	RxDelay_RX_DELAY_7  RxDelay = 7  // 7 seconds.
	RxDelay_RX_DELAY_8  RxDelay = 8  // 8 seconds.
	RxDelay_RX_DELAY_9  RxDelay = 9  // 9 seconds.
	RxDelay_RX_DELAY_10 RxDelay = 10 // 10 seconds.
	RxDelay_RX_DELAY_11 RxDelay = 11 // 11 seconds.
	RxDelay_RX_DELAY_12 RxDelay = 12 // 12 seconds.
	RxDelay_RX_DELAY_13 RxDelay = 13 // 13 seconds.
	RxDelay_RX_DELAY_14 RxDelay = 14 // 14 seconds.
	RxDelay_RX_DELAY_15 RxDelay = 15 // 15 seconds.
)

// Enum value maps for RxDelay.
var (
	RxDelay_name = map[int32]string{
		0:  "RX_DELAY_0",
		1:  "RX_DELAY_1",
		2:  "RX_DELAY_2",
		3:  "RX_DELAY_3",
		4:  "RX_DELAY_4",
		5:  "RX_DELAY_5",
		6:  "RX_DELAY_6",
		7:  "RX_DELAY_7",
		8:  "RX_DELAY_8",
		9:  "RX_DELAY_9",
		10: "RX_DELAY_10",
		11: "RX_DELAY_11",
		12: "RX_DELAY_12",
		13: "RX_DELAY_13",
		14: "RX_DELAY_14",
		15: "RX_DELAY_15",
	}
	RxDelay_value = map[string]int32{
		"RX_DELAY_0":  0,
		"RX_DELAY_1":  1,
		"RX_DELAY_2":  2,
		"RX_DELAY_3":  3,
		"RX_DELAY_4":  4,
		"RX_DELAY_5":  5,
		"RX_DELAY_6":  6,
		"RX_DELAY_7":  7,
		"RX_DELAY_8":  8,
		"RX_DELAY_9":  9,
		"RX_DELAY_10": 10,
		"RX_DELAY_11": 11,
		"RX_DELAY_12": 12,
		"RX_DELAY_13": 13,
		"RX_DELAY_14": 14,
		"RX_DELAY_15": 15,
	}
)

func (x RxDelay) Enum() *RxDelay {
	p := new(RxDelay)
	*p = x
	return p
}

func (x RxDelay) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RxDelay) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[27].Descriptor()
}

func (RxDelay) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[27]
}

func (x RxDelay) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RxDelay.Descriptor instead.
func (RxDelay) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{27}
}

type Minor int32

const (
	Minor_MINOR_RFU_0  Minor = 0
	Minor_MINOR_1      Minor = 1
	Minor_MINOR_RFU_2  Minor = 2
	Minor_MINOR_RFU_3  Minor = 3
	Minor_MINOR_RFU_4  Minor = 4
	Minor_MINOR_RFU_5  Minor = 5
	Minor_MINOR_RFU_6  Minor = 6
	Minor_MINOR_RFU_7  Minor = 7
	Minor_MINOR_RFU_8  Minor = 8
	Minor_MINOR_RFU_9  Minor = 9
	Minor_MINOR_RFU_10 Minor = 10
	Minor_MINOR_RFU_11 Minor = 11
	Minor_MINOR_RFU_12 Minor = 12
	Minor_MINOR_RFU_13 Minor = 13
	Minor_MINOR_RFU_14 Minor = 14
	Minor_MINOR_RFU_15 Minor = 15
)

// Enum value maps for Minor.
var (
	Minor_name = map[int32]string{
		0:  "MINOR_RFU_0",
		1:  "MINOR_1",
		2:  "MINOR_RFU_2",
		3:  "MINOR_RFU_3",
		4:  "MINOR_RFU_4",
		5:  "MINOR_RFU_5",
		6:  "MINOR_RFU_6",
		7:  "MINOR_RFU_7",
		8:  "MINOR_RFU_8",
		9:  "MINOR_RFU_9",
		10: "MINOR_RFU_10",
		11: "MINOR_RFU_11",
		12: "MINOR_RFU_12",
		13: "MINOR_RFU_13",
		14: "MINOR_RFU_14",
		15: "MINOR_RFU_15",
	}
	Minor_value = map[string]int32{
		"MINOR_RFU_0":  0,
		"MINOR_1":      1,
		"MINOR_RFU_2":  2,
		"MINOR_RFU_3":  3,
		"MINOR_RFU_4":  4,
		"MINOR_RFU_5":  5,
		"MINOR_RFU_6":  6,
		"MINOR_RFU_7":  7,
		"MINOR_RFU_8":  8,
		"MINOR_RFU_9":  9,
		"MINOR_RFU_10": 10,
		"MINOR_RFU_11": 11,
		"MINOR_RFU_12": 12,
		"MINOR_RFU_13": 13,
		"MINOR_RFU_14": 14,
		"MINOR_RFU_15": 15,
	}
)

func (x Minor) Enum() *Minor {
	p := new(Minor)
	*p = x
	return p
}

func (x Minor) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Minor) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_lorawan_proto_enumTypes[28].Descriptor()
}

func (Minor) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_lorawan_proto_enumTypes[28]
}

func (x Minor) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Minor.Descriptor instead.
func (Minor) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{28}
}

// Message represents a LoRaWAN message
type Message struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MHdr *MHDR  `protobuf:"bytes,1,opt,name=m_hdr,json=mHdr,proto3" json:"m_hdr,omitempty"`
	Mic  []byte `protobuf:"bytes,2,opt,name=mic,proto3" json:"mic,omitempty"`
	// Payload represents either MACPayload, RejoinRequestPayload, JoinRequestPayload or JoinAcceptPayload
	// - MACPayload length is in range [7:M] bytes, where M is PHY specific.
	// - JoinRequestPayload length is 18 bytes.
	// - JoinAcceptPayload length is either 12 or 28 bytes.
	// - RejoinRequestPayload length is 14 for Type 0 and 2, 19 for Type 1.
	//
	// Types that are assignable to Payload:
	//	*Message_MacPayload
	//	*Message_JoinRequestPayload
	//	*Message_JoinAcceptPayload
	//	*Message_RejoinRequestPayload
	Payload isMessage_Payload `protobuf_oneof:"Payload"`
}

func (x *Message) Reset() {
	*x = Message{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Message) ProtoMessage() {}

func (x *Message) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Message.ProtoReflect.Descriptor instead.
func (*Message) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{0}
}

func (x *Message) GetMHdr() *MHDR {
	if x != nil {
		return x.MHdr
	}
	return nil
}

func (x *Message) GetMic() []byte {
	if x != nil {
		return x.Mic
	}
	return nil
}

func (m *Message) GetPayload() isMessage_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (x *Message) GetMacPayload() *MACPayload {
	if x, ok := x.GetPayload().(*Message_MacPayload); ok {
		return x.MacPayload
	}
	return nil
}

func (x *Message) GetJoinRequestPayload() *JoinRequestPayload {
	if x, ok := x.GetPayload().(*Message_JoinRequestPayload); ok {
		return x.JoinRequestPayload
	}
	return nil
}

func (x *Message) GetJoinAcceptPayload() *JoinAcceptPayload {
	if x, ok := x.GetPayload().(*Message_JoinAcceptPayload); ok {
		return x.JoinAcceptPayload
	}
	return nil
}

func (x *Message) GetRejoinRequestPayload() *RejoinRequestPayload {
	if x, ok := x.GetPayload().(*Message_RejoinRequestPayload); ok {
		return x.RejoinRequestPayload
	}
	return nil
}

type isMessage_Payload interface {
	isMessage_Payload()
}

type Message_MacPayload struct {
	MacPayload *MACPayload `protobuf:"bytes,3,opt,name=mac_payload,json=macPayload,proto3,oneof"`
}

type Message_JoinRequestPayload struct {
	JoinRequestPayload *JoinRequestPayload `protobuf:"bytes,4,opt,name=join_request_payload,json=joinRequestPayload,proto3,oneof"`
}

type Message_JoinAcceptPayload struct {
	JoinAcceptPayload *JoinAcceptPayload `protobuf:"bytes,5,opt,name=join_accept_payload,json=joinAcceptPayload,proto3,oneof"`
}

type Message_RejoinRequestPayload struct {
	RejoinRequestPayload *RejoinRequestPayload `protobuf:"bytes,6,opt,name=rejoin_request_payload,json=rejoinRequestPayload,proto3,oneof"`
}

func (*Message_MacPayload) isMessage_Payload() {}

func (*Message_JoinRequestPayload) isMessage_Payload() {}

func (*Message_JoinAcceptPayload) isMessage_Payload() {}

func (*Message_RejoinRequestPayload) isMessage_Payload() {}

type MHDR struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MType MType `protobuf:"varint,1,opt,name=m_type,json=mType,proto3,enum=ttn.lorawan.v3.MType" json:"m_type,omitempty"`
	Major Major `protobuf:"varint,2,opt,name=major,proto3,enum=ttn.lorawan.v3.Major" json:"major,omitempty"`
}

func (x *MHDR) Reset() {
	*x = MHDR{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MHDR) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MHDR) ProtoMessage() {}

func (x *MHDR) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MHDR.ProtoReflect.Descriptor instead.
func (*MHDR) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{1}
}

func (x *MHDR) GetMType() MType {
	if x != nil {
		return x.MType
	}
	return MType_JOIN_REQUEST
}

func (x *MHDR) GetMajor() Major {
	if x != nil {
		return x.Major
	}
	return Major_LORAWAN_R1
}

type MACPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FHdr           *FHDR            `protobuf:"bytes,1,opt,name=f_hdr,json=fHdr,proto3" json:"f_hdr,omitempty"`
	FPort          uint32           `protobuf:"varint,2,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	FrmPayload     []byte           `protobuf:"bytes,3,opt,name=frm_payload,json=frmPayload,proto3" json:"frm_payload,omitempty"`
	DecodedPayload *structpb.Struct `protobuf:"bytes,4,opt,name=decoded_payload,json=decodedPayload,proto3" json:"decoded_payload,omitempty"`
	// Full 32-bit FCnt value. Used internally by Network Server.
	FullFCnt uint32 `protobuf:"varint,5,opt,name=full_f_cnt,json=fullFCnt,proto3" json:"full_f_cnt,omitempty"`
}

func (x *MACPayload) Reset() {
	*x = MACPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACPayload) ProtoMessage() {}

func (x *MACPayload) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACPayload.ProtoReflect.Descriptor instead.
func (*MACPayload) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{2}
}

func (x *MACPayload) GetFHdr() *FHDR {
	if x != nil {
		return x.FHdr
	}
	return nil
}

func (x *MACPayload) GetFPort() uint32 {
	if x != nil {
		return x.FPort
	}
	return 0
}

func (x *MACPayload) GetFrmPayload() []byte {
	if x != nil {
		return x.FrmPayload
	}
	return nil
}

func (x *MACPayload) GetDecodedPayload() *structpb.Struct {
	if x != nil {
		return x.DecodedPayload
	}
	return nil
}

func (x *MACPayload) GetFullFCnt() uint32 {
	if x != nil {
		return x.FullFCnt
	}
	return 0
}

type FHDR struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DevAddr []byte `protobuf:"bytes,1,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	FCtrl   *FCtrl `protobuf:"bytes,2,opt,name=f_ctrl,json=fCtrl,proto3" json:"f_ctrl,omitempty"`
	FCnt    uint32 `protobuf:"varint,3,opt,name=f_cnt,json=fCnt,proto3" json:"f_cnt,omitempty"`
	FOpts   []byte `protobuf:"bytes,4,opt,name=f_opts,json=fOpts,proto3" json:"f_opts,omitempty"`
}

func (x *FHDR) Reset() {
	*x = FHDR{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FHDR) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FHDR) ProtoMessage() {}

func (x *FHDR) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FHDR.ProtoReflect.Descriptor instead.
func (*FHDR) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{3}
}

func (x *FHDR) GetDevAddr() []byte {
	if x != nil {
		return x.DevAddr
	}
	return nil
}

func (x *FHDR) GetFCtrl() *FCtrl {
	if x != nil {
		return x.FCtrl
	}
	return nil
}

func (x *FHDR) GetFCnt() uint32 {
	if x != nil {
		return x.FCnt
	}
	return 0
}

func (x *FHDR) GetFOpts() []byte {
	if x != nil {
		return x.FOpts
	}
	return nil
}

type FCtrl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Adr       bool `protobuf:"varint,1,opt,name=adr,proto3" json:"adr,omitempty"`
	AdrAckReq bool `protobuf:"varint,2,opt,name=adr_ack_req,json=adrAckReq,proto3" json:"adr_ack_req,omitempty"` // Only on uplink.
	Ack       bool `protobuf:"varint,3,opt,name=ack,proto3" json:"ack,omitempty"`
	FPending  bool `protobuf:"varint,4,opt,name=f_pending,json=fPending,proto3" json:"f_pending,omitempty"` // Only on downlink.
	ClassB    bool `protobuf:"varint,5,opt,name=class_b,json=classB,proto3" json:"class_b,omitempty"`       // Only on uplink.
}

func (x *FCtrl) Reset() {
	*x = FCtrl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FCtrl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FCtrl) ProtoMessage() {}

func (x *FCtrl) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FCtrl.ProtoReflect.Descriptor instead.
func (*FCtrl) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{4}
}

func (x *FCtrl) GetAdr() bool {
	if x != nil {
		return x.Adr
	}
	return false
}

func (x *FCtrl) GetAdrAckReq() bool {
	if x != nil {
		return x.AdrAckReq
	}
	return false
}

func (x *FCtrl) GetAck() bool {
	if x != nil {
		return x.Ack
	}
	return false
}

func (x *FCtrl) GetFPending() bool {
	if x != nil {
		return x.FPending
	}
	return false
}

func (x *FCtrl) GetClassB() bool {
	if x != nil {
		return x.ClassB
	}
	return false
}

type JoinRequestPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JoinEui  []byte `protobuf:"bytes,1,opt,name=join_eui,json=joinEui,proto3" json:"join_eui,omitempty"`
	DevEui   []byte `protobuf:"bytes,2,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	DevNonce []byte `protobuf:"bytes,3,opt,name=dev_nonce,json=devNonce,proto3" json:"dev_nonce,omitempty"`
}

func (x *JoinRequestPayload) Reset() {
	*x = JoinRequestPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JoinRequestPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JoinRequestPayload) ProtoMessage() {}

func (x *JoinRequestPayload) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JoinRequestPayload.ProtoReflect.Descriptor instead.
func (*JoinRequestPayload) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{5}
}

func (x *JoinRequestPayload) GetJoinEui() []byte {
	if x != nil {
		return x.JoinEui
	}
	return nil
}

func (x *JoinRequestPayload) GetDevEui() []byte {
	if x != nil {
		return x.DevEui
	}
	return nil
}

func (x *JoinRequestPayload) GetDevNonce() []byte {
	if x != nil {
		return x.DevNonce
	}
	return nil
}

type RejoinRequestPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RejoinType RejoinRequestType `protobuf:"varint,1,opt,name=rejoin_type,json=rejoinType,proto3,enum=ttn.lorawan.v3.RejoinRequestType" json:"rejoin_type,omitempty"`
	NetId      []byte            `protobuf:"bytes,2,opt,name=net_id,json=netId,proto3" json:"net_id,omitempty"`
	JoinEui    []byte            `protobuf:"bytes,3,opt,name=join_eui,json=joinEui,proto3" json:"join_eui,omitempty"`
	DevEui     []byte            `protobuf:"bytes,4,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	RejoinCnt  uint32            `protobuf:"varint,5,opt,name=rejoin_cnt,json=rejoinCnt,proto3" json:"rejoin_cnt,omitempty"` // Contains RJCount0 or RJCount1 depending on rejoin_type.
}

func (x *RejoinRequestPayload) Reset() {
	*x = RejoinRequestPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RejoinRequestPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RejoinRequestPayload) ProtoMessage() {}

func (x *RejoinRequestPayload) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RejoinRequestPayload.ProtoReflect.Descriptor instead.
func (*RejoinRequestPayload) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{6}
}

func (x *RejoinRequestPayload) GetRejoinType() RejoinRequestType {
	if x != nil {
		return x.RejoinType
	}
	return RejoinRequestType_CONTEXT
}

func (x *RejoinRequestPayload) GetNetId() []byte {
	if x != nil {
		return x.NetId
	}
	return nil
}

func (x *RejoinRequestPayload) GetJoinEui() []byte {
	if x != nil {
		return x.JoinEui
	}
	return nil
}

func (x *RejoinRequestPayload) GetDevEui() []byte {
	if x != nil {
		return x.DevEui
	}
	return nil
}

func (x *RejoinRequestPayload) GetRejoinCnt() uint32 {
	if x != nil {
		return x.RejoinCnt
	}
	return 0
}

type JoinAcceptPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Encrypted  []byte      `protobuf:"bytes,1,opt,name=encrypted,proto3" json:"encrypted,omitempty"`
	JoinNonce  []byte      `protobuf:"bytes,2,opt,name=join_nonce,json=joinNonce,proto3" json:"join_nonce,omitempty"`
	NetId      []byte      `protobuf:"bytes,3,opt,name=net_id,json=netId,proto3" json:"net_id,omitempty"`
	DevAddr    []byte      `protobuf:"bytes,4,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	DlSettings *DLSettings `protobuf:"bytes,5,opt,name=dl_settings,json=dlSettings,proto3" json:"dl_settings,omitempty"`
	RxDelay    RxDelay     `protobuf:"varint,6,opt,name=rx_delay,json=rxDelay,proto3,enum=ttn.lorawan.v3.RxDelay" json:"rx_delay,omitempty"`
	CfList     *CFList     `protobuf:"bytes,7,opt,name=cf_list,json=cfList,proto3" json:"cf_list,omitempty"`
}

func (x *JoinAcceptPayload) Reset() {
	*x = JoinAcceptPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JoinAcceptPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JoinAcceptPayload) ProtoMessage() {}

func (x *JoinAcceptPayload) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JoinAcceptPayload.ProtoReflect.Descriptor instead.
func (*JoinAcceptPayload) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{7}
}

func (x *JoinAcceptPayload) GetEncrypted() []byte {
	if x != nil {
		return x.Encrypted
	}
	return nil
}

func (x *JoinAcceptPayload) GetJoinNonce() []byte {
	if x != nil {
		return x.JoinNonce
	}
	return nil
}

func (x *JoinAcceptPayload) GetNetId() []byte {
	if x != nil {
		return x.NetId
	}
	return nil
}

func (x *JoinAcceptPayload) GetDevAddr() []byte {
	if x != nil {
		return x.DevAddr
	}
	return nil
}

func (x *JoinAcceptPayload) GetDlSettings() *DLSettings {
	if x != nil {
		return x.DlSettings
	}
	return nil
}

func (x *JoinAcceptPayload) GetRxDelay() RxDelay {
	if x != nil {
		return x.RxDelay
	}
	return RxDelay_RX_DELAY_0
}

func (x *JoinAcceptPayload) GetCfList() *CFList {
	if x != nil {
		return x.CfList
	}
	return nil
}

type DLSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Rx1DrOffset DataRateOffset `protobuf:"varint,1,opt,name=rx1_dr_offset,json=rx1DrOffset,proto3,enum=ttn.lorawan.v3.DataRateOffset" json:"rx1_dr_offset,omitempty"`
	Rx2Dr       DataRateIndex  `protobuf:"varint,2,opt,name=rx2_dr,json=rx2Dr,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"rx2_dr,omitempty"`
	// OptNeg is set if Network Server implements LoRaWAN 1.1 or greater.
	OptNeg bool `protobuf:"varint,3,opt,name=opt_neg,json=optNeg,proto3" json:"opt_neg,omitempty"`
}

func (x *DLSettings) Reset() {
	*x = DLSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DLSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DLSettings) ProtoMessage() {}

func (x *DLSettings) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DLSettings.ProtoReflect.Descriptor instead.
func (*DLSettings) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{8}
}

func (x *DLSettings) GetRx1DrOffset() DataRateOffset {
	if x != nil {
		return x.Rx1DrOffset
	}
	return DataRateOffset_DATA_RATE_OFFSET_0
}

func (x *DLSettings) GetRx2Dr() DataRateIndex {
	if x != nil {
		return x.Rx2Dr
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *DLSettings) GetOptNeg() bool {
	if x != nil {
		return x.OptNeg
	}
	return false
}

type CFList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type CFListType `protobuf:"varint,1,opt,name=type,proto3,enum=ttn.lorawan.v3.CFListType" json:"type,omitempty"`
	// Frequencies to be broadcasted, in hecto-Hz.
	// These values are broadcasted as 24 bits unsigned integers.
	// This field should not contain default values.
	Freq []uint32 `protobuf:"varint,2,rep,packed,name=freq,proto3" json:"freq,omitempty"`
	// ChMasks controlling the channels to be used.
	// Length of this field must be equal to the amount of uplink channels
	// defined by the selected frequency plan.
	ChMasks []bool `protobuf:"varint,3,rep,packed,name=ch_masks,json=chMasks,proto3" json:"ch_masks,omitempty"`
}

func (x *CFList) Reset() {
	*x = CFList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CFList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CFList) ProtoMessage() {}

func (x *CFList) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CFList.ProtoReflect.Descriptor instead.
func (*CFList) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{9}
}

func (x *CFList) GetType() CFListType {
	if x != nil {
		return x.Type
	}
	return CFListType_FREQUENCIES
}

func (x *CFList) GetFreq() []uint32 {
	if x != nil {
		return x.Freq
	}
	return nil
}

func (x *CFList) GetChMasks() []bool {
	if x != nil {
		return x.ChMasks
	}
	return nil
}

type LoRaDataRate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bandwidth (Hz).
	Bandwidth       uint32 `protobuf:"varint,1,opt,name=bandwidth,proto3" json:"bandwidth,omitempty"`
	SpreadingFactor uint32 `protobuf:"varint,2,opt,name=spreading_factor,json=spreadingFactor,proto3" json:"spreading_factor,omitempty"`
	CodingRate      string `protobuf:"bytes,3,opt,name=coding_rate,json=codingRate,proto3" json:"coding_rate,omitempty"`
}

func (x *LoRaDataRate) Reset() {
	*x = LoRaDataRate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoRaDataRate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoRaDataRate) ProtoMessage() {}

func (x *LoRaDataRate) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoRaDataRate.ProtoReflect.Descriptor instead.
func (*LoRaDataRate) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{10}
}

func (x *LoRaDataRate) GetBandwidth() uint32 {
	if x != nil {
		return x.Bandwidth
	}
	return 0
}

func (x *LoRaDataRate) GetSpreadingFactor() uint32 {
	if x != nil {
		return x.SpreadingFactor
	}
	return 0
}

func (x *LoRaDataRate) GetCodingRate() string {
	if x != nil {
		return x.CodingRate
	}
	return ""
}

type FSKDataRate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bit rate (bps).
	BitRate uint32 `protobuf:"varint,1,opt,name=bit_rate,json=bitRate,proto3" json:"bit_rate,omitempty"`
}

func (x *FSKDataRate) Reset() {
	*x = FSKDataRate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FSKDataRate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FSKDataRate) ProtoMessage() {}

func (x *FSKDataRate) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FSKDataRate.ProtoReflect.Descriptor instead.
func (*FSKDataRate) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{11}
}

func (x *FSKDataRate) GetBitRate() uint32 {
	if x != nil {
		return x.BitRate
	}
	return 0
}

type LRFHSSDataRate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ModulationType uint32 `protobuf:"varint,1,opt,name=modulation_type,json=modulationType,proto3" json:"modulation_type,omitempty"`
	// Operating Channel Width (Hz).
	OperatingChannelWidth uint32 `protobuf:"varint,2,opt,name=operating_channel_width,json=operatingChannelWidth,proto3" json:"operating_channel_width,omitempty"`
	CodingRate            string `protobuf:"bytes,3,opt,name=coding_rate,json=codingRate,proto3" json:"coding_rate,omitempty"`
}

func (x *LRFHSSDataRate) Reset() {
	*x = LRFHSSDataRate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LRFHSSDataRate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LRFHSSDataRate) ProtoMessage() {}

func (x *LRFHSSDataRate) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LRFHSSDataRate.ProtoReflect.Descriptor instead.
func (*LRFHSSDataRate) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{12}
}

func (x *LRFHSSDataRate) GetModulationType() uint32 {
	if x != nil {
		return x.ModulationType
	}
	return 0
}

func (x *LRFHSSDataRate) GetOperatingChannelWidth() uint32 {
	if x != nil {
		return x.OperatingChannelWidth
	}
	return 0
}

func (x *LRFHSSDataRate) GetCodingRate() string {
	if x != nil {
		return x.CodingRate
	}
	return ""
}

type DataRate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Modulation:
	//	*DataRate_Lora
	//	*DataRate_Fsk
	//	*DataRate_Lrfhss
	Modulation isDataRate_Modulation `protobuf_oneof:"modulation"`
}

func (x *DataRate) Reset() {
	*x = DataRate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataRate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataRate) ProtoMessage() {}

func (x *DataRate) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataRate.ProtoReflect.Descriptor instead.
func (*DataRate) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{13}
}

func (m *DataRate) GetModulation() isDataRate_Modulation {
	if m != nil {
		return m.Modulation
	}
	return nil
}

func (x *DataRate) GetLora() *LoRaDataRate {
	if x, ok := x.GetModulation().(*DataRate_Lora); ok {
		return x.Lora
	}
	return nil
}

func (x *DataRate) GetFsk() *FSKDataRate {
	if x, ok := x.GetModulation().(*DataRate_Fsk); ok {
		return x.Fsk
	}
	return nil
}

func (x *DataRate) GetLrfhss() *LRFHSSDataRate {
	if x, ok := x.GetModulation().(*DataRate_Lrfhss); ok {
		return x.Lrfhss
	}
	return nil
}

type isDataRate_Modulation interface {
	isDataRate_Modulation()
}

type DataRate_Lora struct {
	Lora *LoRaDataRate `protobuf:"bytes,1,opt,name=lora,proto3,oneof"`
}

type DataRate_Fsk struct {
	Fsk *FSKDataRate `protobuf:"bytes,2,opt,name=fsk,proto3,oneof"`
}

type DataRate_Lrfhss struct {
	Lrfhss *LRFHSSDataRate `protobuf:"bytes,3,opt,name=lrfhss,proto3,oneof"`
}

func (*DataRate_Lora) isDataRate_Modulation() {}

func (*DataRate_Fsk) isDataRate_Modulation() {}

func (*DataRate_Lrfhss) isDataRate_Modulation() {}

// TxSettings contains the settings for a transmission.
// This message is used on both uplink and downlink.
// On downlink, this is a scheduled transmission.
type TxSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data rate.
	DataRate *DataRate `protobuf:"bytes,1,opt,name=data_rate,json=dataRate,proto3" json:"data_rate,omitempty"`
	// Frequency (Hz).
	Frequency uint64 `protobuf:"varint,4,opt,name=frequency,proto3" json:"frequency,omitempty"`
	// Send a CRC in the packet; only on uplink; on downlink, CRC should not be enabled.
	EnableCrc bool `protobuf:"varint,5,opt,name=enable_crc,json=enableCrc,proto3" json:"enable_crc,omitempty"`
	// Timestamp of the gateway concentrator when the uplink message was received, or when the downlink message should be transmitted (microseconds).
	// On downlink, set timestamp to 0 and time to null to use immediate scheduling.
	Timestamp uint32 `protobuf:"varint,6,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Time of the gateway when the uplink message was received, or when the downlink message should be transmitted.
	// For downlink, this requires the gateway to have GPS time synchronization.
	Time *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=time,proto3" json:"time,omitempty"`
	// Transmission settings for downlink.
	Downlink *TxSettings_Downlink `protobuf:"bytes,8,opt,name=downlink,proto3" json:"downlink,omitempty"`
	// Concentrator timestamp for the downlink as calculated by the Gateway Server scheduler.
	// This value takes into account necessary offsets such as the RTT (Round Trip Time) and TOA (Time Of Arrival).
	// This field is set and used only by the Gateway Server.
	ConcentratorTimestamp int64 `protobuf:"varint,9,opt,name=concentrator_timestamp,json=concentratorTimestamp,proto3" json:"concentrator_timestamp,omitempty"`
}

func (x *TxSettings) Reset() {
	*x = TxSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TxSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TxSettings) ProtoMessage() {}

func (x *TxSettings) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TxSettings.ProtoReflect.Descriptor instead.
func (*TxSettings) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{14}
}

func (x *TxSettings) GetDataRate() *DataRate {
	if x != nil {
		return x.DataRate
	}
	return nil
}

func (x *TxSettings) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *TxSettings) GetEnableCrc() bool {
	if x != nil {
		return x.EnableCrc
	}
	return false
}

func (x *TxSettings) GetTimestamp() uint32 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *TxSettings) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *TxSettings) GetDownlink() *TxSettings_Downlink {
	if x != nil {
		return x.Downlink
	}
	return nil
}

func (x *TxSettings) GetConcentratorTimestamp() int64 {
	if x != nil {
		return x.ConcentratorTimestamp
	}
	return 0
}

type GatewayAntennaIdentifiers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds   *GatewayIdentifiers `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	AntennaIndex uint32              `protobuf:"varint,2,opt,name=antenna_index,json=antennaIndex,proto3" json:"antenna_index,omitempty"`
}

func (x *GatewayAntennaIdentifiers) Reset() {
	*x = GatewayAntennaIdentifiers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayAntennaIdentifiers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayAntennaIdentifiers) ProtoMessage() {}

func (x *GatewayAntennaIdentifiers) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayAntennaIdentifiers.ProtoReflect.Descriptor instead.
func (*GatewayAntennaIdentifiers) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{15}
}

func (x *GatewayAntennaIdentifiers) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *GatewayAntennaIdentifiers) GetAntennaIndex() uint32 {
	if x != nil {
		return x.AntennaIndex
	}
	return 0
}

type ClassBCGatewayIdentifiers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds   *GatewayIdentifiers `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	AntennaIndex uint32              `protobuf:"varint,2,opt,name=antenna_index,json=antennaIndex,proto3" json:"antenna_index,omitempty"`
	GroupIndex   uint32              `protobuf:"varint,3,opt,name=group_index,json=groupIndex,proto3" json:"group_index,omitempty"`
}

func (x *ClassBCGatewayIdentifiers) Reset() {
	*x = ClassBCGatewayIdentifiers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClassBCGatewayIdentifiers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClassBCGatewayIdentifiers) ProtoMessage() {}

func (x *ClassBCGatewayIdentifiers) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClassBCGatewayIdentifiers.ProtoReflect.Descriptor instead.
func (*ClassBCGatewayIdentifiers) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{16}
}

func (x *ClassBCGatewayIdentifiers) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *ClassBCGatewayIdentifiers) GetAntennaIndex() uint32 {
	if x != nil {
		return x.AntennaIndex
	}
	return 0
}

func (x *ClassBCGatewayIdentifiers) GetGroupIndex() uint32 {
	if x != nil {
		return x.GroupIndex
	}
	return 0
}

type UplinkToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids       *GatewayAntennaIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	Timestamp uint32                     `protobuf:"varint,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Absolute time observed by the server when the uplink message has been received.
	ServerTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=server_time,json=serverTime,proto3" json:"server_time,omitempty"`
	// Absolute concentrator time as observed by the Gateway Server, accounting for rollovers.
	ConcentratorTime int64 `protobuf:"varint,4,opt,name=concentrator_time,json=concentratorTime,proto3" json:"concentrator_time,omitempty"`
	// Absolute time observed by the gateway when the uplink has been received.
	GatewayTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=gateway_time,json=gatewayTime,proto3" json:"gateway_time,omitempty"`
}

func (x *UplinkToken) Reset() {
	*x = UplinkToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UplinkToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UplinkToken) ProtoMessage() {}

func (x *UplinkToken) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UplinkToken.ProtoReflect.Descriptor instead.
func (*UplinkToken) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{17}
}

func (x *UplinkToken) GetIds() *GatewayAntennaIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *UplinkToken) GetTimestamp() uint32 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *UplinkToken) GetServerTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ServerTime
	}
	return nil
}

func (x *UplinkToken) GetConcentratorTime() int64 {
	if x != nil {
		return x.ConcentratorTime
	}
	return 0
}

func (x *UplinkToken) GetGatewayTime() *timestamppb.Timestamp {
	if x != nil {
		return x.GatewayTime
	}
	return nil
}

type DownlinkPath struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set uplink token for class A, B or C downlink to the uplink token received from the corresponding RxMetadata. Uplink tokens are opaque to the Network Server.
	// Set fixed to force using the specified gateway antenna identifiers for downlink. This can only be used for class B or C downlinks.
	//
	// Types that are assignable to Path:
	//	*DownlinkPath_UplinkToken
	//	*DownlinkPath_Fixed
	Path isDownlinkPath_Path `protobuf_oneof:"path"`
}

func (x *DownlinkPath) Reset() {
	*x = DownlinkPath{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownlinkPath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownlinkPath) ProtoMessage() {}

func (x *DownlinkPath) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownlinkPath.ProtoReflect.Descriptor instead.
func (*DownlinkPath) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{18}
}

func (m *DownlinkPath) GetPath() isDownlinkPath_Path {
	if m != nil {
		return m.Path
	}
	return nil
}

func (x *DownlinkPath) GetUplinkToken() []byte {
	if x, ok := x.GetPath().(*DownlinkPath_UplinkToken); ok {
		return x.UplinkToken
	}
	return nil
}

func (x *DownlinkPath) GetFixed() *GatewayAntennaIdentifiers {
	if x, ok := x.GetPath().(*DownlinkPath_Fixed); ok {
		return x.Fixed
	}
	return nil
}

type isDownlinkPath_Path interface {
	isDownlinkPath_Path()
}

type DownlinkPath_UplinkToken struct {
	UplinkToken []byte `protobuf:"bytes,1,opt,name=uplink_token,json=uplinkToken,proto3,oneof"`
}

type DownlinkPath_Fixed struct {
	Fixed *GatewayAntennaIdentifiers `protobuf:"bytes,2,opt,name=fixed,proto3,oneof"`
}

func (*DownlinkPath_UplinkToken) isDownlinkPath_Path() {}

func (*DownlinkPath_Fixed) isDownlinkPath_Path() {}

// TxRequest is a request for transmission.
// If sent to a roaming partner, this request is used to generate the DLMetadata Object (see Backend Interfaces 1.0, Table 22).
// If the gateway has a scheduler, this request is sent to the gateway, in the order of gateway_ids.
// Otherwise, the Gateway Server attempts to schedule the request and creates the TxSettings.
type TxRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Class Class `protobuf:"varint,1,opt,name=class,proto3,enum=ttn.lorawan.v3.Class" json:"class,omitempty"`
	// Downlink paths used to select a gateway for downlink.
	// In class A, the downlink paths are required to only contain uplink tokens.
	// In class B and C, the downlink paths may contain uplink tokens and fixed gateways antenna identifiers.
	DownlinkPaths []*DownlinkPath `protobuf:"bytes,2,rep,name=downlink_paths,json=downlinkPaths,proto3" json:"downlink_paths,omitempty"`
	// Rx1 delay (Rx2 delay is Rx1 delay + 1 second).
	Rx1Delay RxDelay `protobuf:"varint,3,opt,name=rx1_delay,json=rx1Delay,proto3,enum=ttn.lorawan.v3.RxDelay" json:"rx1_delay,omitempty"`
	// LoRaWAN data rate for Rx1.
	Rx1DataRate *DataRate `protobuf:"bytes,12,opt,name=rx1_data_rate,json=rx1DataRate,proto3" json:"rx1_data_rate,omitempty"`
	// Frequency (Hz) for Rx1.
	Rx1Frequency uint64 `protobuf:"varint,5,opt,name=rx1_frequency,json=rx1Frequency,proto3" json:"rx1_frequency,omitempty"`
	// LoRaWAN data rate for Rx2.
	Rx2DataRate *DataRate `protobuf:"bytes,13,opt,name=rx2_data_rate,json=rx2DataRate,proto3" json:"rx2_data_rate,omitempty"`
	// Frequency (Hz) for Rx2.
	Rx2Frequency uint64 `protobuf:"varint,7,opt,name=rx2_frequency,json=rx2Frequency,proto3" json:"rx2_frequency,omitempty"`
	// Priority for scheduling.
	// Requests with a higher priority are allocated more channel time than messages with a lower priority, in duty-cycle limited regions.
	// A priority of HIGH or higher sets the HiPriorityFlag in the DLMetadata Object.
	Priority TxSchedulePriority `protobuf:"varint,8,opt,name=priority,proto3,enum=ttn.lorawan.v3.TxSchedulePriority" json:"priority,omitempty"`
	// Time when the downlink message should be transmitted.
	// This value is only valid for class C downlink; class A downlink uses uplink tokens and class B downlink is scheduled on ping slots.
	// This requires the gateway to have GPS time sychronization.
	// If the absolute time is not set, the first available time will be used that does not conflict or violate regional limitations.
	AbsoluteTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=absolute_time,json=absoluteTime,proto3" json:"absolute_time,omitempty"`
	// Frequency plan ID from which the frequencies in this message are retrieved.
	FrequencyPlanId string `protobuf:"bytes,10,opt,name=frequency_plan_id,json=frequencyPlanId,proto3" json:"frequency_plan_id,omitempty"`
	// Advanced metadata fields
	// - can be used for advanced information or experimental features that are not yet formally defined in the API
	// - field names are written in snake_case
	Advanced *structpb.Struct `protobuf:"bytes,99,opt,name=advanced,proto3" json:"advanced,omitempty"`
}

func (x *TxRequest) Reset() {
	*x = TxRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TxRequest) ProtoMessage() {}

func (x *TxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TxRequest.ProtoReflect.Descriptor instead.
func (*TxRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{19}
}

func (x *TxRequest) GetClass() Class {
	if x != nil {
		return x.Class
	}
	return Class_CLASS_A
}

func (x *TxRequest) GetDownlinkPaths() []*DownlinkPath {
	if x != nil {
		return x.DownlinkPaths
	}
	return nil
}

func (x *TxRequest) GetRx1Delay() RxDelay {
	if x != nil {
		return x.Rx1Delay
	}
	return RxDelay_RX_DELAY_0
}

func (x *TxRequest) GetRx1DataRate() *DataRate {
	if x != nil {
		return x.Rx1DataRate
	}
	return nil
}

func (x *TxRequest) GetRx1Frequency() uint64 {
	if x != nil {
		return x.Rx1Frequency
	}
	return 0
}

func (x *TxRequest) GetRx2DataRate() *DataRate {
	if x != nil {
		return x.Rx2DataRate
	}
	return nil
}

func (x *TxRequest) GetRx2Frequency() uint64 {
	if x != nil {
		return x.Rx2Frequency
	}
	return 0
}

func (x *TxRequest) GetPriority() TxSchedulePriority {
	if x != nil {
		return x.Priority
	}
	return TxSchedulePriority_LOWEST
}

func (x *TxRequest) GetAbsoluteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.AbsoluteTime
	}
	return nil
}

func (x *TxRequest) GetFrequencyPlanId() string {
	if x != nil {
		return x.FrequencyPlanId
	}
	return ""
}

func (x *TxRequest) GetAdvanced() *structpb.Struct {
	if x != nil {
		return x.Advanced
	}
	return nil
}

type RelaySecondChannel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The frequency (Hz) offset used for the WOR acknowledgement.
	AckOffset RelaySecondChAckOffset `protobuf:"varint,1,opt,name=ack_offset,json=ackOffset,proto3,enum=ttn.lorawan.v3.RelaySecondChAckOffset" json:"ack_offset,omitempty"`
	// The data rate index used by the WOR and WOR acknowledgement.
	DataRateIndex DataRateIndex `protobuf:"varint,2,opt,name=data_rate_index,json=dataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"data_rate_index,omitempty"`
	// The frequency (Hz) used by the wake on radio message.
	Frequency uint64 `protobuf:"varint,3,opt,name=frequency,proto3" json:"frequency,omitempty"`
}

func (x *RelaySecondChannel) Reset() {
	*x = RelaySecondChannel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelaySecondChannel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelaySecondChannel) ProtoMessage() {}

func (x *RelaySecondChannel) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelaySecondChannel.ProtoReflect.Descriptor instead.
func (*RelaySecondChannel) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{20}
}

func (x *RelaySecondChannel) GetAckOffset() RelaySecondChAckOffset {
	if x != nil {
		return x.AckOffset
	}
	return RelaySecondChAckOffset_RELAY_SECOND_CH_ACK_OFFSET_0
}

func (x *RelaySecondChannel) GetDataRateIndex() DataRateIndex {
	if x != nil {
		return x.DataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *RelaySecondChannel) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

type RelayUplinkForwardLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The multiplier used to compute the total bucket size for the limits.
	// The multiplier is multiplied by the reload rate in order to compute the total bucket size.
	BucketSize RelayLimitBucketSize `protobuf:"varint,1,opt,name=bucket_size,json=bucketSize,proto3,enum=ttn.lorawan.v3.RelayLimitBucketSize" json:"bucket_size,omitempty"`
	// The number of tokens which are replenished in the bucket every hour.
	ReloadRate uint32 `protobuf:"varint,2,opt,name=reload_rate,json=reloadRate,proto3" json:"reload_rate,omitempty"`
}

func (x *RelayUplinkForwardLimits) Reset() {
	*x = RelayUplinkForwardLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelayUplinkForwardLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelayUplinkForwardLimits) ProtoMessage() {}

func (x *RelayUplinkForwardLimits) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelayUplinkForwardLimits.ProtoReflect.Descriptor instead.
func (*RelayUplinkForwardLimits) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{21}
}

func (x *RelayUplinkForwardLimits) GetBucketSize() RelayLimitBucketSize {
	if x != nil {
		return x.BucketSize
	}
	return RelayLimitBucketSize_RELAY_LIMIT_BUCKET_SIZE_1
}

func (x *RelayUplinkForwardLimits) GetReloadRate() uint32 {
	if x != nil {
		return x.ReloadRate
	}
	return 0
}

type RelayForwardLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The multiplier used to compute the total bucket size for the limits.
	// The multiplier is multiplied by the reload rate in order to compute the total bucket size.
	BucketSize RelayLimitBucketSize `protobuf:"varint,1,opt,name=bucket_size,json=bucketSize,proto3,enum=ttn.lorawan.v3.RelayLimitBucketSize" json:"bucket_size,omitempty"`
	// The number of tokens which are replenished in the bucket every hour.
	ReloadRate uint32 `protobuf:"varint,2,opt,name=reload_rate,json=reloadRate,proto3" json:"reload_rate,omitempty"`
}

func (x *RelayForwardLimits) Reset() {
	*x = RelayForwardLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelayForwardLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelayForwardLimits) ProtoMessage() {}

func (x *RelayForwardLimits) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelayForwardLimits.ProtoReflect.Descriptor instead.
func (*RelayForwardLimits) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{22}
}

func (x *RelayForwardLimits) GetBucketSize() RelayLimitBucketSize {
	if x != nil {
		return x.BucketSize
	}
	return RelayLimitBucketSize_RELAY_LIMIT_BUCKET_SIZE_1
}

func (x *RelayForwardLimits) GetReloadRate() uint32 {
	if x != nil {
		return x.ReloadRate
	}
	return 0
}

type RelayEndDeviceAlwaysMode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RelayEndDeviceAlwaysMode) Reset() {
	*x = RelayEndDeviceAlwaysMode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelayEndDeviceAlwaysMode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelayEndDeviceAlwaysMode) ProtoMessage() {}

func (x *RelayEndDeviceAlwaysMode) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelayEndDeviceAlwaysMode.ProtoReflect.Descriptor instead.
func (*RelayEndDeviceAlwaysMode) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{23}
}

type RelayEndDeviceDynamicMode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of consecutive uplinks without a valid downlink before the end device attempts
	// to use the relay mode to transmit messages.
	SmartEnableLevel RelaySmartEnableLevel `protobuf:"varint,1,opt,name=smart_enable_level,json=smartEnableLevel,proto3,enum=ttn.lorawan.v3.RelaySmartEnableLevel" json:"smart_enable_level,omitempty"`
}

func (x *RelayEndDeviceDynamicMode) Reset() {
	*x = RelayEndDeviceDynamicMode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelayEndDeviceDynamicMode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelayEndDeviceDynamicMode) ProtoMessage() {}

func (x *RelayEndDeviceDynamicMode) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelayEndDeviceDynamicMode.ProtoReflect.Descriptor instead.
func (*RelayEndDeviceDynamicMode) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{24}
}

func (x *RelayEndDeviceDynamicMode) GetSmartEnableLevel() RelaySmartEnableLevel {
	if x != nil {
		return x.SmartEnableLevel
	}
	return RelaySmartEnableLevel_RELAY_SMART_ENABLE_LEVEL_8
}

type RelayEndDeviceControlledMode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RelayEndDeviceControlledMode) Reset() {
	*x = RelayEndDeviceControlledMode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelayEndDeviceControlledMode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelayEndDeviceControlledMode) ProtoMessage() {}

func (x *RelayEndDeviceControlledMode) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelayEndDeviceControlledMode.ProtoReflect.Descriptor instead.
func (*RelayEndDeviceControlledMode) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{25}
}

type MACCommand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cid MACCommandIdentifier `protobuf:"varint,1,opt,name=cid,proto3,enum=ttn.lorawan.v3.MACCommandIdentifier" json:"cid,omitempty"`
	// Types that are assignable to Payload:
	//	*MACCommand_RawPayload
	//	*MACCommand_ResetInd_
	//	*MACCommand_ResetConf_
	//	*MACCommand_LinkCheckAns_
	//	*MACCommand_LinkAdrReq
	//	*MACCommand_LinkAdrAns
	//	*MACCommand_DutyCycleReq_
	//	*MACCommand_RxParamSetupReq_
	//	*MACCommand_RxParamSetupAns_
	//	*MACCommand_DevStatusAns_
	//	*MACCommand_NewChannelReq_
	//	*MACCommand_NewChannelAns_
	//	*MACCommand_DlChannelReq
	//	*MACCommand_DlChannelAns
	//	*MACCommand_RxTimingSetupReq_
	//	*MACCommand_TxParamSetupReq_
	//	*MACCommand_RekeyInd_
	//	*MACCommand_RekeyConf_
	//	*MACCommand_AdrParamSetupReq
	//	*MACCommand_DeviceTimeAns_
	//	*MACCommand_ForceRejoinReq_
	//	*MACCommand_RejoinParamSetupReq_
	//	*MACCommand_RejoinParamSetupAns_
	//	*MACCommand_PingSlotInfoReq_
	//	*MACCommand_PingSlotChannelReq_
	//	*MACCommand_PingSlotChannelAns_
	//	*MACCommand_BeaconTimingAns_
	//	*MACCommand_BeaconFreqReq_
	//	*MACCommand_BeaconFreqAns_
	//	*MACCommand_DeviceModeInd_
	//	*MACCommand_DeviceModeConf_
	//	*MACCommand_RelayConfReq_
	//	*MACCommand_RelayConfAns_
	//	*MACCommand_RelayEndDeviceConfReq_
	//	*MACCommand_RelayEndDeviceConfAns_
	//	*MACCommand_RelayUpdateUplinkListReq_
	//	*MACCommand_RelayUpdateUplinkListAns_
	//	*MACCommand_RelayCtrlUplinkListReq_
	//	*MACCommand_RelayCtrlUplinkListAns_
	//	*MACCommand_RelayConfigureFwdLimitReq_
	//	*MACCommand_RelayConfigureFwdLimitAns_
	//	*MACCommand_RelayNotifyNewEndDeviceReq_
	Payload isMACCommand_Payload `protobuf_oneof:"payload"`
}

func (x *MACCommand) Reset() {
	*x = MACCommand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand) ProtoMessage() {}

func (x *MACCommand) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand.ProtoReflect.Descriptor instead.
func (*MACCommand) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26}
}

func (x *MACCommand) GetCid() MACCommandIdentifier {
	if x != nil {
		return x.Cid
	}
	return MACCommandIdentifier_CID_RFU_0
}

func (m *MACCommand) GetPayload() isMACCommand_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (x *MACCommand) GetRawPayload() []byte {
	if x, ok := x.GetPayload().(*MACCommand_RawPayload); ok {
		return x.RawPayload
	}
	return nil
}

func (x *MACCommand) GetResetInd() *MACCommand_ResetInd {
	if x, ok := x.GetPayload().(*MACCommand_ResetInd_); ok {
		return x.ResetInd
	}
	return nil
}

func (x *MACCommand) GetResetConf() *MACCommand_ResetConf {
	if x, ok := x.GetPayload().(*MACCommand_ResetConf_); ok {
		return x.ResetConf
	}
	return nil
}

func (x *MACCommand) GetLinkCheckAns() *MACCommand_LinkCheckAns {
	if x, ok := x.GetPayload().(*MACCommand_LinkCheckAns_); ok {
		return x.LinkCheckAns
	}
	return nil
}

func (x *MACCommand) GetLinkAdrReq() *MACCommand_LinkADRReq {
	if x, ok := x.GetPayload().(*MACCommand_LinkAdrReq); ok {
		return x.LinkAdrReq
	}
	return nil
}

func (x *MACCommand) GetLinkAdrAns() *MACCommand_LinkADRAns {
	if x, ok := x.GetPayload().(*MACCommand_LinkAdrAns); ok {
		return x.LinkAdrAns
	}
	return nil
}

func (x *MACCommand) GetDutyCycleReq() *MACCommand_DutyCycleReq {
	if x, ok := x.GetPayload().(*MACCommand_DutyCycleReq_); ok {
		return x.DutyCycleReq
	}
	return nil
}

func (x *MACCommand) GetRxParamSetupReq() *MACCommand_RxParamSetupReq {
	if x, ok := x.GetPayload().(*MACCommand_RxParamSetupReq_); ok {
		return x.RxParamSetupReq
	}
	return nil
}

func (x *MACCommand) GetRxParamSetupAns() *MACCommand_RxParamSetupAns {
	if x, ok := x.GetPayload().(*MACCommand_RxParamSetupAns_); ok {
		return x.RxParamSetupAns
	}
	return nil
}

func (x *MACCommand) GetDevStatusAns() *MACCommand_DevStatusAns {
	if x, ok := x.GetPayload().(*MACCommand_DevStatusAns_); ok {
		return x.DevStatusAns
	}
	return nil
}

func (x *MACCommand) GetNewChannelReq() *MACCommand_NewChannelReq {
	if x, ok := x.GetPayload().(*MACCommand_NewChannelReq_); ok {
		return x.NewChannelReq
	}
	return nil
}

func (x *MACCommand) GetNewChannelAns() *MACCommand_NewChannelAns {
	if x, ok := x.GetPayload().(*MACCommand_NewChannelAns_); ok {
		return x.NewChannelAns
	}
	return nil
}

func (x *MACCommand) GetDlChannelReq() *MACCommand_DLChannelReq {
	if x, ok := x.GetPayload().(*MACCommand_DlChannelReq); ok {
		return x.DlChannelReq
	}
	return nil
}

func (x *MACCommand) GetDlChannelAns() *MACCommand_DLChannelAns {
	if x, ok := x.GetPayload().(*MACCommand_DlChannelAns); ok {
		return x.DlChannelAns
	}
	return nil
}

func (x *MACCommand) GetRxTimingSetupReq() *MACCommand_RxTimingSetupReq {
	if x, ok := x.GetPayload().(*MACCommand_RxTimingSetupReq_); ok {
		return x.RxTimingSetupReq
	}
	return nil
}

func (x *MACCommand) GetTxParamSetupReq() *MACCommand_TxParamSetupReq {
	if x, ok := x.GetPayload().(*MACCommand_TxParamSetupReq_); ok {
		return x.TxParamSetupReq
	}
	return nil
}

func (x *MACCommand) GetRekeyInd() *MACCommand_RekeyInd {
	if x, ok := x.GetPayload().(*MACCommand_RekeyInd_); ok {
		return x.RekeyInd
	}
	return nil
}

func (x *MACCommand) GetRekeyConf() *MACCommand_RekeyConf {
	if x, ok := x.GetPayload().(*MACCommand_RekeyConf_); ok {
		return x.RekeyConf
	}
	return nil
}

func (x *MACCommand) GetAdrParamSetupReq() *MACCommand_ADRParamSetupReq {
	if x, ok := x.GetPayload().(*MACCommand_AdrParamSetupReq); ok {
		return x.AdrParamSetupReq
	}
	return nil
}

func (x *MACCommand) GetDeviceTimeAns() *MACCommand_DeviceTimeAns {
	if x, ok := x.GetPayload().(*MACCommand_DeviceTimeAns_); ok {
		return x.DeviceTimeAns
	}
	return nil
}

func (x *MACCommand) GetForceRejoinReq() *MACCommand_ForceRejoinReq {
	if x, ok := x.GetPayload().(*MACCommand_ForceRejoinReq_); ok {
		return x.ForceRejoinReq
	}
	return nil
}

func (x *MACCommand) GetRejoinParamSetupReq() *MACCommand_RejoinParamSetupReq {
	if x, ok := x.GetPayload().(*MACCommand_RejoinParamSetupReq_); ok {
		return x.RejoinParamSetupReq
	}
	return nil
}

func (x *MACCommand) GetRejoinParamSetupAns() *MACCommand_RejoinParamSetupAns {
	if x, ok := x.GetPayload().(*MACCommand_RejoinParamSetupAns_); ok {
		return x.RejoinParamSetupAns
	}
	return nil
}

func (x *MACCommand) GetPingSlotInfoReq() *MACCommand_PingSlotInfoReq {
	if x, ok := x.GetPayload().(*MACCommand_PingSlotInfoReq_); ok {
		return x.PingSlotInfoReq
	}
	return nil
}

func (x *MACCommand) GetPingSlotChannelReq() *MACCommand_PingSlotChannelReq {
	if x, ok := x.GetPayload().(*MACCommand_PingSlotChannelReq_); ok {
		return x.PingSlotChannelReq
	}
	return nil
}

func (x *MACCommand) GetPingSlotChannelAns() *MACCommand_PingSlotChannelAns {
	if x, ok := x.GetPayload().(*MACCommand_PingSlotChannelAns_); ok {
		return x.PingSlotChannelAns
	}
	return nil
}

func (x *MACCommand) GetBeaconTimingAns() *MACCommand_BeaconTimingAns {
	if x, ok := x.GetPayload().(*MACCommand_BeaconTimingAns_); ok {
		return x.BeaconTimingAns
	}
	return nil
}

func (x *MACCommand) GetBeaconFreqReq() *MACCommand_BeaconFreqReq {
	if x, ok := x.GetPayload().(*MACCommand_BeaconFreqReq_); ok {
		return x.BeaconFreqReq
	}
	return nil
}

func (x *MACCommand) GetBeaconFreqAns() *MACCommand_BeaconFreqAns {
	if x, ok := x.GetPayload().(*MACCommand_BeaconFreqAns_); ok {
		return x.BeaconFreqAns
	}
	return nil
}

func (x *MACCommand) GetDeviceModeInd() *MACCommand_DeviceModeInd {
	if x, ok := x.GetPayload().(*MACCommand_DeviceModeInd_); ok {
		return x.DeviceModeInd
	}
	return nil
}

func (x *MACCommand) GetDeviceModeConf() *MACCommand_DeviceModeConf {
	if x, ok := x.GetPayload().(*MACCommand_DeviceModeConf_); ok {
		return x.DeviceModeConf
	}
	return nil
}

func (x *MACCommand) GetRelayConfReq() *MACCommand_RelayConfReq {
	if x, ok := x.GetPayload().(*MACCommand_RelayConfReq_); ok {
		return x.RelayConfReq
	}
	return nil
}

func (x *MACCommand) GetRelayConfAns() *MACCommand_RelayConfAns {
	if x, ok := x.GetPayload().(*MACCommand_RelayConfAns_); ok {
		return x.RelayConfAns
	}
	return nil
}

func (x *MACCommand) GetRelayEndDeviceConfReq() *MACCommand_RelayEndDeviceConfReq {
	if x, ok := x.GetPayload().(*MACCommand_RelayEndDeviceConfReq_); ok {
		return x.RelayEndDeviceConfReq
	}
	return nil
}

func (x *MACCommand) GetRelayEndDeviceConfAns() *MACCommand_RelayEndDeviceConfAns {
	if x, ok := x.GetPayload().(*MACCommand_RelayEndDeviceConfAns_); ok {
		return x.RelayEndDeviceConfAns
	}
	return nil
}

func (x *MACCommand) GetRelayUpdateUplinkListReq() *MACCommand_RelayUpdateUplinkListReq {
	if x, ok := x.GetPayload().(*MACCommand_RelayUpdateUplinkListReq_); ok {
		return x.RelayUpdateUplinkListReq
	}
	return nil
}

func (x *MACCommand) GetRelayUpdateUplinkListAns() *MACCommand_RelayUpdateUplinkListAns {
	if x, ok := x.GetPayload().(*MACCommand_RelayUpdateUplinkListAns_); ok {
		return x.RelayUpdateUplinkListAns
	}
	return nil
}

func (x *MACCommand) GetRelayCtrlUplinkListReq() *MACCommand_RelayCtrlUplinkListReq {
	if x, ok := x.GetPayload().(*MACCommand_RelayCtrlUplinkListReq_); ok {
		return x.RelayCtrlUplinkListReq
	}
	return nil
}

func (x *MACCommand) GetRelayCtrlUplinkListAns() *MACCommand_RelayCtrlUplinkListAns {
	if x, ok := x.GetPayload().(*MACCommand_RelayCtrlUplinkListAns_); ok {
		return x.RelayCtrlUplinkListAns
	}
	return nil
}

func (x *MACCommand) GetRelayConfigureFwdLimitReq() *MACCommand_RelayConfigureFwdLimitReq {
	if x, ok := x.GetPayload().(*MACCommand_RelayConfigureFwdLimitReq_); ok {
		return x.RelayConfigureFwdLimitReq
	}
	return nil
}

func (x *MACCommand) GetRelayConfigureFwdLimitAns() *MACCommand_RelayConfigureFwdLimitAns {
	if x, ok := x.GetPayload().(*MACCommand_RelayConfigureFwdLimitAns_); ok {
		return x.RelayConfigureFwdLimitAns
	}
	return nil
}

func (x *MACCommand) GetRelayNotifyNewEndDeviceReq() *MACCommand_RelayNotifyNewEndDeviceReq {
	if x, ok := x.GetPayload().(*MACCommand_RelayNotifyNewEndDeviceReq_); ok {
		return x.RelayNotifyNewEndDeviceReq
	}
	return nil
}

type isMACCommand_Payload interface {
	isMACCommand_Payload()
}

type MACCommand_RawPayload struct {
	RawPayload []byte `protobuf:"bytes,2,opt,name=raw_payload,json=rawPayload,proto3,oneof"`
}

type MACCommand_ResetInd_ struct {
	ResetInd *MACCommand_ResetInd `protobuf:"bytes,3,opt,name=reset_ind,json=resetInd,proto3,oneof"`
}

type MACCommand_ResetConf_ struct {
	ResetConf *MACCommand_ResetConf `protobuf:"bytes,4,opt,name=reset_conf,json=resetConf,proto3,oneof"`
}

type MACCommand_LinkCheckAns_ struct {
	LinkCheckAns *MACCommand_LinkCheckAns `protobuf:"bytes,5,opt,name=link_check_ans,json=linkCheckAns,proto3,oneof"`
}

type MACCommand_LinkAdrReq struct {
	LinkAdrReq *MACCommand_LinkADRReq `protobuf:"bytes,6,opt,name=link_adr_req,json=linkAdrReq,proto3,oneof"`
}

type MACCommand_LinkAdrAns struct {
	LinkAdrAns *MACCommand_LinkADRAns `protobuf:"bytes,7,opt,name=link_adr_ans,json=linkAdrAns,proto3,oneof"`
}

type MACCommand_DutyCycleReq_ struct {
	DutyCycleReq *MACCommand_DutyCycleReq `protobuf:"bytes,8,opt,name=duty_cycle_req,json=dutyCycleReq,proto3,oneof"`
}

type MACCommand_RxParamSetupReq_ struct {
	RxParamSetupReq *MACCommand_RxParamSetupReq `protobuf:"bytes,9,opt,name=rx_param_setup_req,json=rxParamSetupReq,proto3,oneof"`
}

type MACCommand_RxParamSetupAns_ struct {
	RxParamSetupAns *MACCommand_RxParamSetupAns `protobuf:"bytes,10,opt,name=rx_param_setup_ans,json=rxParamSetupAns,proto3,oneof"`
}

type MACCommand_DevStatusAns_ struct {
	DevStatusAns *MACCommand_DevStatusAns `protobuf:"bytes,11,opt,name=dev_status_ans,json=devStatusAns,proto3,oneof"`
}

type MACCommand_NewChannelReq_ struct {
	NewChannelReq *MACCommand_NewChannelReq `protobuf:"bytes,12,opt,name=new_channel_req,json=newChannelReq,proto3,oneof"`
}

type MACCommand_NewChannelAns_ struct {
	NewChannelAns *MACCommand_NewChannelAns `protobuf:"bytes,13,opt,name=new_channel_ans,json=newChannelAns,proto3,oneof"`
}

type MACCommand_DlChannelReq struct {
	DlChannelReq *MACCommand_DLChannelReq `protobuf:"bytes,14,opt,name=dl_channel_req,json=dlChannelReq,proto3,oneof"`
}

type MACCommand_DlChannelAns struct {
	DlChannelAns *MACCommand_DLChannelAns `protobuf:"bytes,15,opt,name=dl_channel_ans,json=dlChannelAns,proto3,oneof"`
}

type MACCommand_RxTimingSetupReq_ struct {
	RxTimingSetupReq *MACCommand_RxTimingSetupReq `protobuf:"bytes,16,opt,name=rx_timing_setup_req,json=rxTimingSetupReq,proto3,oneof"`
}

type MACCommand_TxParamSetupReq_ struct {
	TxParamSetupReq *MACCommand_TxParamSetupReq `protobuf:"bytes,17,opt,name=tx_param_setup_req,json=txParamSetupReq,proto3,oneof"`
}

type MACCommand_RekeyInd_ struct {
	RekeyInd *MACCommand_RekeyInd `protobuf:"bytes,18,opt,name=rekey_ind,json=rekeyInd,proto3,oneof"`
}

type MACCommand_RekeyConf_ struct {
	RekeyConf *MACCommand_RekeyConf `protobuf:"bytes,19,opt,name=rekey_conf,json=rekeyConf,proto3,oneof"`
}

type MACCommand_AdrParamSetupReq struct {
	AdrParamSetupReq *MACCommand_ADRParamSetupReq `protobuf:"bytes,20,opt,name=adr_param_setup_req,json=adrParamSetupReq,proto3,oneof"`
}

type MACCommand_DeviceTimeAns_ struct {
	DeviceTimeAns *MACCommand_DeviceTimeAns `protobuf:"bytes,21,opt,name=device_time_ans,json=deviceTimeAns,proto3,oneof"`
}

type MACCommand_ForceRejoinReq_ struct {
	ForceRejoinReq *MACCommand_ForceRejoinReq `protobuf:"bytes,22,opt,name=force_rejoin_req,json=forceRejoinReq,proto3,oneof"`
}

type MACCommand_RejoinParamSetupReq_ struct {
	RejoinParamSetupReq *MACCommand_RejoinParamSetupReq `protobuf:"bytes,23,opt,name=rejoin_param_setup_req,json=rejoinParamSetupReq,proto3,oneof"`
}

type MACCommand_RejoinParamSetupAns_ struct {
	RejoinParamSetupAns *MACCommand_RejoinParamSetupAns `protobuf:"bytes,24,opt,name=rejoin_param_setup_ans,json=rejoinParamSetupAns,proto3,oneof"`
}

type MACCommand_PingSlotInfoReq_ struct {
	PingSlotInfoReq *MACCommand_PingSlotInfoReq `protobuf:"bytes,25,opt,name=ping_slot_info_req,json=pingSlotInfoReq,proto3,oneof"`
}

type MACCommand_PingSlotChannelReq_ struct {
	PingSlotChannelReq *MACCommand_PingSlotChannelReq `protobuf:"bytes,26,opt,name=ping_slot_channel_req,json=pingSlotChannelReq,proto3,oneof"`
}

type MACCommand_PingSlotChannelAns_ struct {
	PingSlotChannelAns *MACCommand_PingSlotChannelAns `protobuf:"bytes,27,opt,name=ping_slot_channel_ans,json=pingSlotChannelAns,proto3,oneof"`
}

type MACCommand_BeaconTimingAns_ struct {
	BeaconTimingAns *MACCommand_BeaconTimingAns `protobuf:"bytes,28,opt,name=beacon_timing_ans,json=beaconTimingAns,proto3,oneof"`
}

type MACCommand_BeaconFreqReq_ struct {
	BeaconFreqReq *MACCommand_BeaconFreqReq `protobuf:"bytes,29,opt,name=beacon_freq_req,json=beaconFreqReq,proto3,oneof"`
}

type MACCommand_BeaconFreqAns_ struct {
	BeaconFreqAns *MACCommand_BeaconFreqAns `protobuf:"bytes,30,opt,name=beacon_freq_ans,json=beaconFreqAns,proto3,oneof"`
}

type MACCommand_DeviceModeInd_ struct {
	DeviceModeInd *MACCommand_DeviceModeInd `protobuf:"bytes,31,opt,name=device_mode_ind,json=deviceModeInd,proto3,oneof"`
}

type MACCommand_DeviceModeConf_ struct {
	DeviceModeConf *MACCommand_DeviceModeConf `protobuf:"bytes,32,opt,name=device_mode_conf,json=deviceModeConf,proto3,oneof"`
}

type MACCommand_RelayConfReq_ struct {
	RelayConfReq *MACCommand_RelayConfReq `protobuf:"bytes,33,opt,name=relay_conf_req,json=relayConfReq,proto3,oneof"`
}

type MACCommand_RelayConfAns_ struct {
	RelayConfAns *MACCommand_RelayConfAns `protobuf:"bytes,34,opt,name=relay_conf_ans,json=relayConfAns,proto3,oneof"`
}

type MACCommand_RelayEndDeviceConfReq_ struct {
	RelayEndDeviceConfReq *MACCommand_RelayEndDeviceConfReq `protobuf:"bytes,35,opt,name=relay_end_device_conf_req,json=relayEndDeviceConfReq,proto3,oneof"`
}

type MACCommand_RelayEndDeviceConfAns_ struct {
	RelayEndDeviceConfAns *MACCommand_RelayEndDeviceConfAns `protobuf:"bytes,36,opt,name=relay_end_device_conf_ans,json=relayEndDeviceConfAns,proto3,oneof"`
}

type MACCommand_RelayUpdateUplinkListReq_ struct {
	RelayUpdateUplinkListReq *MACCommand_RelayUpdateUplinkListReq `protobuf:"bytes,39,opt,name=relay_update_uplink_list_req,json=relayUpdateUplinkListReq,proto3,oneof"`
}

type MACCommand_RelayUpdateUplinkListAns_ struct {
	RelayUpdateUplinkListAns *MACCommand_RelayUpdateUplinkListAns `protobuf:"bytes,40,opt,name=relay_update_uplink_list_ans,json=relayUpdateUplinkListAns,proto3,oneof"`
}

type MACCommand_RelayCtrlUplinkListReq_ struct {
	RelayCtrlUplinkListReq *MACCommand_RelayCtrlUplinkListReq `protobuf:"bytes,41,opt,name=relay_ctrl_uplink_list_req,json=relayCtrlUplinkListReq,proto3,oneof"`
}

type MACCommand_RelayCtrlUplinkListAns_ struct {
	RelayCtrlUplinkListAns *MACCommand_RelayCtrlUplinkListAns `protobuf:"bytes,42,opt,name=relay_ctrl_uplink_list_ans,json=relayCtrlUplinkListAns,proto3,oneof"`
}

type MACCommand_RelayConfigureFwdLimitReq_ struct {
	RelayConfigureFwdLimitReq *MACCommand_RelayConfigureFwdLimitReq `protobuf:"bytes,43,opt,name=relay_configure_fwd_limit_req,json=relayConfigureFwdLimitReq,proto3,oneof"`
}

type MACCommand_RelayConfigureFwdLimitAns_ struct {
	RelayConfigureFwdLimitAns *MACCommand_RelayConfigureFwdLimitAns `protobuf:"bytes,44,opt,name=relay_configure_fwd_limit_ans,json=relayConfigureFwdLimitAns,proto3,oneof"`
}

type MACCommand_RelayNotifyNewEndDeviceReq_ struct {
	RelayNotifyNewEndDeviceReq *MACCommand_RelayNotifyNewEndDeviceReq `protobuf:"bytes,45,opt,name=relay_notify_new_end_device_req,json=relayNotifyNewEndDeviceReq,proto3,oneof"`
}

func (*MACCommand_RawPayload) isMACCommand_Payload() {}

func (*MACCommand_ResetInd_) isMACCommand_Payload() {}

func (*MACCommand_ResetConf_) isMACCommand_Payload() {}

func (*MACCommand_LinkCheckAns_) isMACCommand_Payload() {}

func (*MACCommand_LinkAdrReq) isMACCommand_Payload() {}

func (*MACCommand_LinkAdrAns) isMACCommand_Payload() {}

func (*MACCommand_DutyCycleReq_) isMACCommand_Payload() {}

func (*MACCommand_RxParamSetupReq_) isMACCommand_Payload() {}

func (*MACCommand_RxParamSetupAns_) isMACCommand_Payload() {}

func (*MACCommand_DevStatusAns_) isMACCommand_Payload() {}

func (*MACCommand_NewChannelReq_) isMACCommand_Payload() {}

func (*MACCommand_NewChannelAns_) isMACCommand_Payload() {}

func (*MACCommand_DlChannelReq) isMACCommand_Payload() {}

func (*MACCommand_DlChannelAns) isMACCommand_Payload() {}

func (*MACCommand_RxTimingSetupReq_) isMACCommand_Payload() {}

func (*MACCommand_TxParamSetupReq_) isMACCommand_Payload() {}

func (*MACCommand_RekeyInd_) isMACCommand_Payload() {}

func (*MACCommand_RekeyConf_) isMACCommand_Payload() {}

func (*MACCommand_AdrParamSetupReq) isMACCommand_Payload() {}

func (*MACCommand_DeviceTimeAns_) isMACCommand_Payload() {}

func (*MACCommand_ForceRejoinReq_) isMACCommand_Payload() {}

func (*MACCommand_RejoinParamSetupReq_) isMACCommand_Payload() {}

func (*MACCommand_RejoinParamSetupAns_) isMACCommand_Payload() {}

func (*MACCommand_PingSlotInfoReq_) isMACCommand_Payload() {}

func (*MACCommand_PingSlotChannelReq_) isMACCommand_Payload() {}

func (*MACCommand_PingSlotChannelAns_) isMACCommand_Payload() {}

func (*MACCommand_BeaconTimingAns_) isMACCommand_Payload() {}

func (*MACCommand_BeaconFreqReq_) isMACCommand_Payload() {}

func (*MACCommand_BeaconFreqAns_) isMACCommand_Payload() {}

func (*MACCommand_DeviceModeInd_) isMACCommand_Payload() {}

func (*MACCommand_DeviceModeConf_) isMACCommand_Payload() {}

func (*MACCommand_RelayConfReq_) isMACCommand_Payload() {}

func (*MACCommand_RelayConfAns_) isMACCommand_Payload() {}

func (*MACCommand_RelayEndDeviceConfReq_) isMACCommand_Payload() {}

func (*MACCommand_RelayEndDeviceConfAns_) isMACCommand_Payload() {}

func (*MACCommand_RelayUpdateUplinkListReq_) isMACCommand_Payload() {}

func (*MACCommand_RelayUpdateUplinkListAns_) isMACCommand_Payload() {}

func (*MACCommand_RelayCtrlUplinkListReq_) isMACCommand_Payload() {}

func (*MACCommand_RelayCtrlUplinkListAns_) isMACCommand_Payload() {}

func (*MACCommand_RelayConfigureFwdLimitReq_) isMACCommand_Payload() {}

func (*MACCommand_RelayConfigureFwdLimitAns_) isMACCommand_Payload() {}

func (*MACCommand_RelayNotifyNewEndDeviceReq_) isMACCommand_Payload() {}

type MACCommands struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Commands []*MACCommand `protobuf:"bytes,1,rep,name=commands,proto3" json:"commands,omitempty"`
}

func (x *MACCommands) Reset() {
	*x = MACCommands{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommands) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommands) ProtoMessage() {}

func (x *MACCommands) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommands.ProtoReflect.Descriptor instead.
func (*MACCommands) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{27}
}

func (x *MACCommands) GetCommands() []*MACCommand {
	if x != nil {
		return x.Commands
	}
	return nil
}

type FrequencyValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value uint64 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *FrequencyValue) Reset() {
	*x = FrequencyValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FrequencyValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FrequencyValue) ProtoMessage() {}

func (x *FrequencyValue) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FrequencyValue.ProtoReflect.Descriptor instead.
func (*FrequencyValue) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{28}
}

func (x *FrequencyValue) GetValue() uint64 {
	if x != nil {
		return x.Value
	}
	return 0
}

type ZeroableFrequencyValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value uint64 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *ZeroableFrequencyValue) Reset() {
	*x = ZeroableFrequencyValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ZeroableFrequencyValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ZeroableFrequencyValue) ProtoMessage() {}

func (x *ZeroableFrequencyValue) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ZeroableFrequencyValue.ProtoReflect.Descriptor instead.
func (*ZeroableFrequencyValue) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{29}
}

func (x *ZeroableFrequencyValue) GetValue() uint64 {
	if x != nil {
		return x.Value
	}
	return 0
}

type DataRateOffsetValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value DataRateOffset `protobuf:"varint,1,opt,name=value,proto3,enum=ttn.lorawan.v3.DataRateOffset" json:"value,omitempty"`
}

func (x *DataRateOffsetValue) Reset() {
	*x = DataRateOffsetValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataRateOffsetValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataRateOffsetValue) ProtoMessage() {}

func (x *DataRateOffsetValue) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataRateOffsetValue.ProtoReflect.Descriptor instead.
func (*DataRateOffsetValue) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{30}
}

func (x *DataRateOffsetValue) GetValue() DataRateOffset {
	if x != nil {
		return x.Value
	}
	return DataRateOffset_DATA_RATE_OFFSET_0
}

type DataRateIndexValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value DataRateIndex `protobuf:"varint,1,opt,name=value,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"value,omitempty"`
}

func (x *DataRateIndexValue) Reset() {
	*x = DataRateIndexValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataRateIndexValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataRateIndexValue) ProtoMessage() {}

func (x *DataRateIndexValue) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataRateIndexValue.ProtoReflect.Descriptor instead.
func (*DataRateIndexValue) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{31}
}

func (x *DataRateIndexValue) GetValue() DataRateIndex {
	if x != nil {
		return x.Value
	}
	return DataRateIndex_DATA_RATE_0
}

type PingSlotPeriodValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value PingSlotPeriod `protobuf:"varint,1,opt,name=value,proto3,enum=ttn.lorawan.v3.PingSlotPeriod" json:"value,omitempty"`
}

func (x *PingSlotPeriodValue) Reset() {
	*x = PingSlotPeriodValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PingSlotPeriodValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PingSlotPeriodValue) ProtoMessage() {}

func (x *PingSlotPeriodValue) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PingSlotPeriodValue.ProtoReflect.Descriptor instead.
func (*PingSlotPeriodValue) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{32}
}

func (x *PingSlotPeriodValue) GetValue() PingSlotPeriod {
	if x != nil {
		return x.Value
	}
	return PingSlotPeriod_PING_EVERY_1S
}

type AggregatedDutyCycleValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value AggregatedDutyCycle `protobuf:"varint,1,opt,name=value,proto3,enum=ttn.lorawan.v3.AggregatedDutyCycle" json:"value,omitempty"`
}

func (x *AggregatedDutyCycleValue) Reset() {
	*x = AggregatedDutyCycleValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedDutyCycleValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedDutyCycleValue) ProtoMessage() {}

func (x *AggregatedDutyCycleValue) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedDutyCycleValue.ProtoReflect.Descriptor instead.
func (*AggregatedDutyCycleValue) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{33}
}

func (x *AggregatedDutyCycleValue) GetValue() AggregatedDutyCycle {
	if x != nil {
		return x.Value
	}
	return AggregatedDutyCycle_DUTY_CYCLE_1
}

type RxDelayValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value RxDelay `protobuf:"varint,1,opt,name=value,proto3,enum=ttn.lorawan.v3.RxDelay" json:"value,omitempty"`
}

func (x *RxDelayValue) Reset() {
	*x = RxDelayValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RxDelayValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RxDelayValue) ProtoMessage() {}

func (x *RxDelayValue) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RxDelayValue.ProtoReflect.Descriptor instead.
func (*RxDelayValue) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{34}
}

func (x *RxDelayValue) GetValue() RxDelay {
	if x != nil {
		return x.Value
	}
	return RxDelay_RX_DELAY_0
}

type ADRAckLimitExponentValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value ADRAckLimitExponent `protobuf:"varint,1,opt,name=value,proto3,enum=ttn.lorawan.v3.ADRAckLimitExponent" json:"value,omitempty"`
}

func (x *ADRAckLimitExponentValue) Reset() {
	*x = ADRAckLimitExponentValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ADRAckLimitExponentValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ADRAckLimitExponentValue) ProtoMessage() {}

func (x *ADRAckLimitExponentValue) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ADRAckLimitExponentValue.ProtoReflect.Descriptor instead.
func (*ADRAckLimitExponentValue) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{35}
}

func (x *ADRAckLimitExponentValue) GetValue() ADRAckLimitExponent {
	if x != nil {
		return x.Value
	}
	return ADRAckLimitExponent_ADR_ACK_LIMIT_1
}

type ADRAckDelayExponentValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value ADRAckDelayExponent `protobuf:"varint,1,opt,name=value,proto3,enum=ttn.lorawan.v3.ADRAckDelayExponent" json:"value,omitempty"`
}

func (x *ADRAckDelayExponentValue) Reset() {
	*x = ADRAckDelayExponentValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ADRAckDelayExponentValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ADRAckDelayExponentValue) ProtoMessage() {}

func (x *ADRAckDelayExponentValue) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ADRAckDelayExponentValue.ProtoReflect.Descriptor instead.
func (*ADRAckDelayExponentValue) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{36}
}

func (x *ADRAckDelayExponentValue) GetValue() ADRAckDelayExponent {
	if x != nil {
		return x.Value
	}
	return ADRAckDelayExponent_ADR_ACK_DELAY_1
}

type DeviceEIRPValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value DeviceEIRP `protobuf:"varint,1,opt,name=value,proto3,enum=ttn.lorawan.v3.DeviceEIRP" json:"value,omitempty"`
}

func (x *DeviceEIRPValue) Reset() {
	*x = DeviceEIRPValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeviceEIRPValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceEIRPValue) ProtoMessage() {}

func (x *DeviceEIRPValue) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceEIRPValue.ProtoReflect.Descriptor instead.
func (*DeviceEIRPValue) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{37}
}

func (x *DeviceEIRPValue) GetValue() DeviceEIRP {
	if x != nil {
		return x.Value
	}
	return DeviceEIRP_DEVICE_EIRP_8
}

type RelayForwardUplinkReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataRate   *DataRate       `protobuf:"bytes,1,opt,name=data_rate,json=dataRate,proto3" json:"data_rate,omitempty"`
	Snr        int32           `protobuf:"varint,2,opt,name=snr,proto3" json:"snr,omitempty"`
	Rssi       int32           `protobuf:"varint,3,opt,name=rssi,proto3" json:"rssi,omitempty"`
	WorChannel RelayWORChannel `protobuf:"varint,4,opt,name=wor_channel,json=worChannel,proto3,enum=ttn.lorawan.v3.RelayWORChannel" json:"wor_channel,omitempty"`
	Frequency  uint64          `protobuf:"varint,5,opt,name=frequency,proto3" json:"frequency,omitempty"` // Uplink channel frequency (Hz).
	RawPayload []byte          `protobuf:"bytes,6,opt,name=raw_payload,json=rawPayload,proto3" json:"raw_payload,omitempty"`
}

func (x *RelayForwardUplinkReq) Reset() {
	*x = RelayForwardUplinkReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelayForwardUplinkReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelayForwardUplinkReq) ProtoMessage() {}

func (x *RelayForwardUplinkReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelayForwardUplinkReq.ProtoReflect.Descriptor instead.
func (*RelayForwardUplinkReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{38}
}

func (x *RelayForwardUplinkReq) GetDataRate() *DataRate {
	if x != nil {
		return x.DataRate
	}
	return nil
}

func (x *RelayForwardUplinkReq) GetSnr() int32 {
	if x != nil {
		return x.Snr
	}
	return 0
}

func (x *RelayForwardUplinkReq) GetRssi() int32 {
	if x != nil {
		return x.Rssi
	}
	return 0
}

func (x *RelayForwardUplinkReq) GetWorChannel() RelayWORChannel {
	if x != nil {
		return x.WorChannel
	}
	return RelayWORChannel_RELAY_WOR_CHANNEL_DEFAULT
}

func (x *RelayForwardUplinkReq) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *RelayForwardUplinkReq) GetRawPayload() []byte {
	if x != nil {
		return x.RawPayload
	}
	return nil
}

type RelayForwardDownlinkReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RawPayload []byte `protobuf:"bytes,1,opt,name=raw_payload,json=rawPayload,proto3" json:"raw_payload,omitempty"`
}

func (x *RelayForwardDownlinkReq) Reset() {
	*x = RelayForwardDownlinkReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelayForwardDownlinkReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelayForwardDownlinkReq) ProtoMessage() {}

func (x *RelayForwardDownlinkReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelayForwardDownlinkReq.ProtoReflect.Descriptor instead.
func (*RelayForwardDownlinkReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{39}
}

func (x *RelayForwardDownlinkReq) GetRawPayload() []byte {
	if x != nil {
		return x.RawPayload
	}
	return nil
}

type RelayUplinkToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids          *EndDeviceIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	SessionKeyId []byte                `protobuf:"bytes,2,opt,name=session_key_id,json=sessionKeyId,proto3" json:"session_key_id,omitempty"`
	FullFCnt     uint32                `protobuf:"varint,3,opt,name=full_f_cnt,json=fullFCnt,proto3" json:"full_f_cnt,omitempty"`
}

func (x *RelayUplinkToken) Reset() {
	*x = RelayUplinkToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelayUplinkToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelayUplinkToken) ProtoMessage() {}

func (x *RelayUplinkToken) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelayUplinkToken.ProtoReflect.Descriptor instead.
func (*RelayUplinkToken) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{40}
}

func (x *RelayUplinkToken) GetIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *RelayUplinkToken) GetSessionKeyId() []byte {
	if x != nil {
		return x.SessionKeyId
	}
	return nil
}

func (x *RelayUplinkToken) GetFullFCnt() uint32 {
	if x != nil {
		return x.FullFCnt
	}
	return 0
}

// Transmission settings for downlink.
type TxSettings_Downlink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of the antenna on which the uplink was received and/or downlink must be sent.
	AntennaIndex uint32 `protobuf:"varint,1,opt,name=antenna_index,json=antennaIndex,proto3" json:"antenna_index,omitempty"`
	// Transmission power (dBm). Only on downlink.
	TxPower float32 `protobuf:"fixed32,2,opt,name=tx_power,json=txPower,proto3" json:"tx_power,omitempty"`
	// Invert LoRa polarization; false for LoRaWAN uplink, true for downlink.
	InvertPolarization bool `protobuf:"varint,3,opt,name=invert_polarization,json=invertPolarization,proto3" json:"invert_polarization,omitempty"`
}

func (x *TxSettings_Downlink) Reset() {
	*x = TxSettings_Downlink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TxSettings_Downlink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TxSettings_Downlink) ProtoMessage() {}

func (x *TxSettings_Downlink) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TxSettings_Downlink.ProtoReflect.Descriptor instead.
func (*TxSettings_Downlink) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{14, 0}
}

func (x *TxSettings_Downlink) GetAntennaIndex() uint32 {
	if x != nil {
		return x.AntennaIndex
	}
	return 0
}

func (x *TxSettings_Downlink) GetTxPower() float32 {
	if x != nil {
		return x.TxPower
	}
	return 0
}

func (x *TxSettings_Downlink) GetInvertPolarization() bool {
	if x != nil {
		return x.InvertPolarization
	}
	return false
}

type MACCommand_ResetInd struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinorVersion Minor `protobuf:"varint,1,opt,name=minor_version,json=minorVersion,proto3,enum=ttn.lorawan.v3.Minor" json:"minor_version,omitempty"`
}

func (x *MACCommand_ResetInd) Reset() {
	*x = MACCommand_ResetInd{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_ResetInd) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_ResetInd) ProtoMessage() {}

func (x *MACCommand_ResetInd) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_ResetInd.ProtoReflect.Descriptor instead.
func (*MACCommand_ResetInd) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 0}
}

func (x *MACCommand_ResetInd) GetMinorVersion() Minor {
	if x != nil {
		return x.MinorVersion
	}
	return Minor_MINOR_RFU_0
}

type MACCommand_ResetConf struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinorVersion Minor `protobuf:"varint,1,opt,name=minor_version,json=minorVersion,proto3,enum=ttn.lorawan.v3.Minor" json:"minor_version,omitempty"`
}

func (x *MACCommand_ResetConf) Reset() {
	*x = MACCommand_ResetConf{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_ResetConf) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_ResetConf) ProtoMessage() {}

func (x *MACCommand_ResetConf) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_ResetConf.ProtoReflect.Descriptor instead.
func (*MACCommand_ResetConf) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 1}
}

func (x *MACCommand_ResetConf) GetMinorVersion() Minor {
	if x != nil {
		return x.MinorVersion
	}
	return Minor_MINOR_RFU_0
}

type MACCommand_LinkCheckAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates the link margin in dB of the received LinkCheckReq, relative to the demodulation floor.
	Margin       uint32 `protobuf:"varint,1,opt,name=margin,proto3" json:"margin,omitempty"`
	GatewayCount uint32 `protobuf:"varint,2,opt,name=gateway_count,json=gatewayCount,proto3" json:"gateway_count,omitempty"`
}

func (x *MACCommand_LinkCheckAns) Reset() {
	*x = MACCommand_LinkCheckAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_LinkCheckAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_LinkCheckAns) ProtoMessage() {}

func (x *MACCommand_LinkCheckAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_LinkCheckAns.ProtoReflect.Descriptor instead.
func (*MACCommand_LinkCheckAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 2}
}

func (x *MACCommand_LinkCheckAns) GetMargin() uint32 {
	if x != nil {
		return x.Margin
	}
	return 0
}

func (x *MACCommand_LinkCheckAns) GetGatewayCount() uint32 {
	if x != nil {
		return x.GatewayCount
	}
	return 0
}

type MACCommand_LinkADRReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataRateIndex      DataRateIndex `protobuf:"varint,1,opt,name=data_rate_index,json=dataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"data_rate_index,omitempty"`
	TxPowerIndex       uint32        `protobuf:"varint,2,opt,name=tx_power_index,json=txPowerIndex,proto3" json:"tx_power_index,omitempty"`
	ChannelMask        []bool        `protobuf:"varint,3,rep,packed,name=channel_mask,json=channelMask,proto3" json:"channel_mask,omitempty"`
	ChannelMaskControl uint32        `protobuf:"varint,5,opt,name=channel_mask_control,json=channelMaskControl,proto3" json:"channel_mask_control,omitempty"`
	NbTrans            uint32        `protobuf:"varint,6,opt,name=nb_trans,json=nbTrans,proto3" json:"nb_trans,omitempty"`
}

func (x *MACCommand_LinkADRReq) Reset() {
	*x = MACCommand_LinkADRReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_LinkADRReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_LinkADRReq) ProtoMessage() {}

func (x *MACCommand_LinkADRReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_LinkADRReq.ProtoReflect.Descriptor instead.
func (*MACCommand_LinkADRReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 3}
}

func (x *MACCommand_LinkADRReq) GetDataRateIndex() DataRateIndex {
	if x != nil {
		return x.DataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *MACCommand_LinkADRReq) GetTxPowerIndex() uint32 {
	if x != nil {
		return x.TxPowerIndex
	}
	return 0
}

func (x *MACCommand_LinkADRReq) GetChannelMask() []bool {
	if x != nil {
		return x.ChannelMask
	}
	return nil
}

func (x *MACCommand_LinkADRReq) GetChannelMaskControl() uint32 {
	if x != nil {
		return x.ChannelMaskControl
	}
	return 0
}

func (x *MACCommand_LinkADRReq) GetNbTrans() uint32 {
	if x != nil {
		return x.NbTrans
	}
	return 0
}

type MACCommand_LinkADRAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ChannelMaskAck   bool `protobuf:"varint,1,opt,name=channel_mask_ack,json=channelMaskAck,proto3" json:"channel_mask_ack,omitempty"`
	DataRateIndexAck bool `protobuf:"varint,2,opt,name=data_rate_index_ack,json=dataRateIndexAck,proto3" json:"data_rate_index_ack,omitempty"`
	TxPowerIndexAck  bool `protobuf:"varint,3,opt,name=tx_power_index_ack,json=txPowerIndexAck,proto3" json:"tx_power_index_ack,omitempty"`
}

func (x *MACCommand_LinkADRAns) Reset() {
	*x = MACCommand_LinkADRAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_LinkADRAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_LinkADRAns) ProtoMessage() {}

func (x *MACCommand_LinkADRAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_LinkADRAns.ProtoReflect.Descriptor instead.
func (*MACCommand_LinkADRAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 4}
}

func (x *MACCommand_LinkADRAns) GetChannelMaskAck() bool {
	if x != nil {
		return x.ChannelMaskAck
	}
	return false
}

func (x *MACCommand_LinkADRAns) GetDataRateIndexAck() bool {
	if x != nil {
		return x.DataRateIndexAck
	}
	return false
}

func (x *MACCommand_LinkADRAns) GetTxPowerIndexAck() bool {
	if x != nil {
		return x.TxPowerIndexAck
	}
	return false
}

type MACCommand_DutyCycleReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MaxDutyCycle AggregatedDutyCycle `protobuf:"varint,1,opt,name=max_duty_cycle,json=maxDutyCycle,proto3,enum=ttn.lorawan.v3.AggregatedDutyCycle" json:"max_duty_cycle,omitempty"`
}

func (x *MACCommand_DutyCycleReq) Reset() {
	*x = MACCommand_DutyCycleReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_DutyCycleReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_DutyCycleReq) ProtoMessage() {}

func (x *MACCommand_DutyCycleReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_DutyCycleReq.ProtoReflect.Descriptor instead.
func (*MACCommand_DutyCycleReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 5}
}

func (x *MACCommand_DutyCycleReq) GetMaxDutyCycle() AggregatedDutyCycle {
	if x != nil {
		return x.MaxDutyCycle
	}
	return AggregatedDutyCycle_DUTY_CYCLE_1
}

type MACCommand_RxParamSetupReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Rx2DataRateIndex  DataRateIndex  `protobuf:"varint,1,opt,name=rx2_data_rate_index,json=rx2DataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"rx2_data_rate_index,omitempty"`
	Rx1DataRateOffset DataRateOffset `protobuf:"varint,2,opt,name=rx1_data_rate_offset,json=rx1DataRateOffset,proto3,enum=ttn.lorawan.v3.DataRateOffset" json:"rx1_data_rate_offset,omitempty"`
	Rx2Frequency      uint64         `protobuf:"varint,3,opt,name=rx2_frequency,json=rx2Frequency,proto3" json:"rx2_frequency,omitempty"` // Rx2 frequency (Hz).
}

func (x *MACCommand_RxParamSetupReq) Reset() {
	*x = MACCommand_RxParamSetupReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RxParamSetupReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RxParamSetupReq) ProtoMessage() {}

func (x *MACCommand_RxParamSetupReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RxParamSetupReq.ProtoReflect.Descriptor instead.
func (*MACCommand_RxParamSetupReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 6}
}

func (x *MACCommand_RxParamSetupReq) GetRx2DataRateIndex() DataRateIndex {
	if x != nil {
		return x.Rx2DataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *MACCommand_RxParamSetupReq) GetRx1DataRateOffset() DataRateOffset {
	if x != nil {
		return x.Rx1DataRateOffset
	}
	return DataRateOffset_DATA_RATE_OFFSET_0
}

func (x *MACCommand_RxParamSetupReq) GetRx2Frequency() uint64 {
	if x != nil {
		return x.Rx2Frequency
	}
	return 0
}

type MACCommand_RxParamSetupAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Rx2DataRateIndexAck  bool `protobuf:"varint,1,opt,name=rx2_data_rate_index_ack,json=rx2DataRateIndexAck,proto3" json:"rx2_data_rate_index_ack,omitempty"`
	Rx1DataRateOffsetAck bool `protobuf:"varint,2,opt,name=rx1_data_rate_offset_ack,json=rx1DataRateOffsetAck,proto3" json:"rx1_data_rate_offset_ack,omitempty"`
	Rx2FrequencyAck      bool `protobuf:"varint,3,opt,name=rx2_frequency_ack,json=rx2FrequencyAck,proto3" json:"rx2_frequency_ack,omitempty"`
}

func (x *MACCommand_RxParamSetupAns) Reset() {
	*x = MACCommand_RxParamSetupAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RxParamSetupAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RxParamSetupAns) ProtoMessage() {}

func (x *MACCommand_RxParamSetupAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RxParamSetupAns.ProtoReflect.Descriptor instead.
func (*MACCommand_RxParamSetupAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 7}
}

func (x *MACCommand_RxParamSetupAns) GetRx2DataRateIndexAck() bool {
	if x != nil {
		return x.Rx2DataRateIndexAck
	}
	return false
}

func (x *MACCommand_RxParamSetupAns) GetRx1DataRateOffsetAck() bool {
	if x != nil {
		return x.Rx1DataRateOffsetAck
	}
	return false
}

func (x *MACCommand_RxParamSetupAns) GetRx2FrequencyAck() bool {
	if x != nil {
		return x.Rx2FrequencyAck
	}
	return false
}

type MACCommand_DevStatusAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device battery status.
	// 0 indicates that the device is connected to an external power source.
	// 1..254 indicates a battery level.
	// 255 indicates that the device was not able to measure the battery level.
	Battery uint32 `protobuf:"varint,1,opt,name=battery,proto3" json:"battery,omitempty"`
	// SNR of the last downlink (dB; [-32, +31]).
	Margin int32 `protobuf:"varint,2,opt,name=margin,proto3" json:"margin,omitempty"`
}

func (x *MACCommand_DevStatusAns) Reset() {
	*x = MACCommand_DevStatusAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_DevStatusAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_DevStatusAns) ProtoMessage() {}

func (x *MACCommand_DevStatusAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_DevStatusAns.ProtoReflect.Descriptor instead.
func (*MACCommand_DevStatusAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 8}
}

func (x *MACCommand_DevStatusAns) GetBattery() uint32 {
	if x != nil {
		return x.Battery
	}
	return 0
}

func (x *MACCommand_DevStatusAns) GetMargin() int32 {
	if x != nil {
		return x.Margin
	}
	return 0
}

type MACCommand_NewChannelReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ChannelIndex     uint32        `protobuf:"varint,1,opt,name=channel_index,json=channelIndex,proto3" json:"channel_index,omitempty"`
	Frequency        uint64        `protobuf:"varint,2,opt,name=frequency,proto3" json:"frequency,omitempty"` // Channel frequency (Hz).
	MinDataRateIndex DataRateIndex `protobuf:"varint,3,opt,name=min_data_rate_index,json=minDataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"min_data_rate_index,omitempty"`
	MaxDataRateIndex DataRateIndex `protobuf:"varint,4,opt,name=max_data_rate_index,json=maxDataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"max_data_rate_index,omitempty"`
}

func (x *MACCommand_NewChannelReq) Reset() {
	*x = MACCommand_NewChannelReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_NewChannelReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_NewChannelReq) ProtoMessage() {}

func (x *MACCommand_NewChannelReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_NewChannelReq.ProtoReflect.Descriptor instead.
func (*MACCommand_NewChannelReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 9}
}

func (x *MACCommand_NewChannelReq) GetChannelIndex() uint32 {
	if x != nil {
		return x.ChannelIndex
	}
	return 0
}

func (x *MACCommand_NewChannelReq) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *MACCommand_NewChannelReq) GetMinDataRateIndex() DataRateIndex {
	if x != nil {
		return x.MinDataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *MACCommand_NewChannelReq) GetMaxDataRateIndex() DataRateIndex {
	if x != nil {
		return x.MaxDataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

type MACCommand_NewChannelAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FrequencyAck bool `protobuf:"varint,1,opt,name=frequency_ack,json=frequencyAck,proto3" json:"frequency_ack,omitempty"`
	DataRateAck  bool `protobuf:"varint,2,opt,name=data_rate_ack,json=dataRateAck,proto3" json:"data_rate_ack,omitempty"`
}

func (x *MACCommand_NewChannelAns) Reset() {
	*x = MACCommand_NewChannelAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_NewChannelAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_NewChannelAns) ProtoMessage() {}

func (x *MACCommand_NewChannelAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_NewChannelAns.ProtoReflect.Descriptor instead.
func (*MACCommand_NewChannelAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 10}
}

func (x *MACCommand_NewChannelAns) GetFrequencyAck() bool {
	if x != nil {
		return x.FrequencyAck
	}
	return false
}

func (x *MACCommand_NewChannelAns) GetDataRateAck() bool {
	if x != nil {
		return x.DataRateAck
	}
	return false
}

type MACCommand_DLChannelReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ChannelIndex uint32 `protobuf:"varint,1,opt,name=channel_index,json=channelIndex,proto3" json:"channel_index,omitempty"`
	Frequency    uint64 `protobuf:"varint,2,opt,name=frequency,proto3" json:"frequency,omitempty"` // Downlink channel frequency (Hz).
}

func (x *MACCommand_DLChannelReq) Reset() {
	*x = MACCommand_DLChannelReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_DLChannelReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_DLChannelReq) ProtoMessage() {}

func (x *MACCommand_DLChannelReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_DLChannelReq.ProtoReflect.Descriptor instead.
func (*MACCommand_DLChannelReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 11}
}

func (x *MACCommand_DLChannelReq) GetChannelIndex() uint32 {
	if x != nil {
		return x.ChannelIndex
	}
	return 0
}

func (x *MACCommand_DLChannelReq) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

type MACCommand_DLChannelAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ChannelIndexAck bool `protobuf:"varint,1,opt,name=channel_index_ack,json=channelIndexAck,proto3" json:"channel_index_ack,omitempty"`
	FrequencyAck    bool `protobuf:"varint,2,opt,name=frequency_ack,json=frequencyAck,proto3" json:"frequency_ack,omitempty"`
}

func (x *MACCommand_DLChannelAns) Reset() {
	*x = MACCommand_DLChannelAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_DLChannelAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_DLChannelAns) ProtoMessage() {}

func (x *MACCommand_DLChannelAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_DLChannelAns.ProtoReflect.Descriptor instead.
func (*MACCommand_DLChannelAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 12}
}

func (x *MACCommand_DLChannelAns) GetChannelIndexAck() bool {
	if x != nil {
		return x.ChannelIndexAck
	}
	return false
}

func (x *MACCommand_DLChannelAns) GetFrequencyAck() bool {
	if x != nil {
		return x.FrequencyAck
	}
	return false
}

type MACCommand_RxTimingSetupReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Delay RxDelay `protobuf:"varint,1,opt,name=delay,proto3,enum=ttn.lorawan.v3.RxDelay" json:"delay,omitempty"`
}

func (x *MACCommand_RxTimingSetupReq) Reset() {
	*x = MACCommand_RxTimingSetupReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RxTimingSetupReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RxTimingSetupReq) ProtoMessage() {}

func (x *MACCommand_RxTimingSetupReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RxTimingSetupReq.ProtoReflect.Descriptor instead.
func (*MACCommand_RxTimingSetupReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 13}
}

func (x *MACCommand_RxTimingSetupReq) GetDelay() RxDelay {
	if x != nil {
		return x.Delay
	}
	return RxDelay_RX_DELAY_0
}

type MACCommand_TxParamSetupReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates the maximum EIRP value in dBm, indexed by the following vector:
	// [ 8 10 12 13 14 16 18 20 21 24 26 27 29 30 33 36 ]
	MaxEirpIndex      DeviceEIRP `protobuf:"varint,1,opt,name=max_eirp_index,json=maxEirpIndex,proto3,enum=ttn.lorawan.v3.DeviceEIRP" json:"max_eirp_index,omitempty"`
	UplinkDwellTime   bool       `protobuf:"varint,2,opt,name=uplink_dwell_time,json=uplinkDwellTime,proto3" json:"uplink_dwell_time,omitempty"`
	DownlinkDwellTime bool       `protobuf:"varint,3,opt,name=downlink_dwell_time,json=downlinkDwellTime,proto3" json:"downlink_dwell_time,omitempty"`
}

func (x *MACCommand_TxParamSetupReq) Reset() {
	*x = MACCommand_TxParamSetupReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_TxParamSetupReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_TxParamSetupReq) ProtoMessage() {}

func (x *MACCommand_TxParamSetupReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_TxParamSetupReq.ProtoReflect.Descriptor instead.
func (*MACCommand_TxParamSetupReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 14}
}

func (x *MACCommand_TxParamSetupReq) GetMaxEirpIndex() DeviceEIRP {
	if x != nil {
		return x.MaxEirpIndex
	}
	return DeviceEIRP_DEVICE_EIRP_8
}

func (x *MACCommand_TxParamSetupReq) GetUplinkDwellTime() bool {
	if x != nil {
		return x.UplinkDwellTime
	}
	return false
}

func (x *MACCommand_TxParamSetupReq) GetDownlinkDwellTime() bool {
	if x != nil {
		return x.DownlinkDwellTime
	}
	return false
}

type MACCommand_RekeyInd struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinorVersion Minor `protobuf:"varint,1,opt,name=minor_version,json=minorVersion,proto3,enum=ttn.lorawan.v3.Minor" json:"minor_version,omitempty"`
}

func (x *MACCommand_RekeyInd) Reset() {
	*x = MACCommand_RekeyInd{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RekeyInd) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RekeyInd) ProtoMessage() {}

func (x *MACCommand_RekeyInd) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RekeyInd.ProtoReflect.Descriptor instead.
func (*MACCommand_RekeyInd) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 15}
}

func (x *MACCommand_RekeyInd) GetMinorVersion() Minor {
	if x != nil {
		return x.MinorVersion
	}
	return Minor_MINOR_RFU_0
}

type MACCommand_RekeyConf struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinorVersion Minor `protobuf:"varint,1,opt,name=minor_version,json=minorVersion,proto3,enum=ttn.lorawan.v3.Minor" json:"minor_version,omitempty"`
}

func (x *MACCommand_RekeyConf) Reset() {
	*x = MACCommand_RekeyConf{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RekeyConf) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RekeyConf) ProtoMessage() {}

func (x *MACCommand_RekeyConf) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RekeyConf.ProtoReflect.Descriptor instead.
func (*MACCommand_RekeyConf) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 16}
}

func (x *MACCommand_RekeyConf) GetMinorVersion() Minor {
	if x != nil {
		return x.MinorVersion
	}
	return Minor_MINOR_RFU_0
}

type MACCommand_ADRParamSetupReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exponent e that configures the ADR_ACK_LIMIT = 2^e messages.
	AdrAckLimitExponent ADRAckLimitExponent `protobuf:"varint,1,opt,name=adr_ack_limit_exponent,json=adrAckLimitExponent,proto3,enum=ttn.lorawan.v3.ADRAckLimitExponent" json:"adr_ack_limit_exponent,omitempty"`
	// Exponent e that configures the ADR_ACK_DELAY = 2^e messages.
	AdrAckDelayExponent ADRAckDelayExponent `protobuf:"varint,2,opt,name=adr_ack_delay_exponent,json=adrAckDelayExponent,proto3,enum=ttn.lorawan.v3.ADRAckDelayExponent" json:"adr_ack_delay_exponent,omitempty"`
}

func (x *MACCommand_ADRParamSetupReq) Reset() {
	*x = MACCommand_ADRParamSetupReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_ADRParamSetupReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_ADRParamSetupReq) ProtoMessage() {}

func (x *MACCommand_ADRParamSetupReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_ADRParamSetupReq.ProtoReflect.Descriptor instead.
func (*MACCommand_ADRParamSetupReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 17}
}

func (x *MACCommand_ADRParamSetupReq) GetAdrAckLimitExponent() ADRAckLimitExponent {
	if x != nil {
		return x.AdrAckLimitExponent
	}
	return ADRAckLimitExponent_ADR_ACK_LIMIT_1
}

func (x *MACCommand_ADRParamSetupReq) GetAdrAckDelayExponent() ADRAckDelayExponent {
	if x != nil {
		return x.AdrAckDelayExponent
	}
	return ADRAckDelayExponent_ADR_ACK_DELAY_1
}

type MACCommand_DeviceTimeAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Time *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *MACCommand_DeviceTimeAns) Reset() {
	*x = MACCommand_DeviceTimeAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_DeviceTimeAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_DeviceTimeAns) ProtoMessage() {}

func (x *MACCommand_DeviceTimeAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_DeviceTimeAns.ProtoReflect.Descriptor instead.
func (*MACCommand_DeviceTimeAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 18}
}

func (x *MACCommand_DeviceTimeAns) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type MACCommand_ForceRejoinReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RejoinType    RejoinRequestType `protobuf:"varint,1,opt,name=rejoin_type,json=rejoinType,proto3,enum=ttn.lorawan.v3.RejoinRequestType" json:"rejoin_type,omitempty"`
	DataRateIndex DataRateIndex     `protobuf:"varint,2,opt,name=data_rate_index,json=dataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"data_rate_index,omitempty"`
	MaxRetries    uint32            `protobuf:"varint,3,opt,name=max_retries,json=maxRetries,proto3" json:"max_retries,omitempty"`
	// Exponent e that configures the rejoin period = 32 * 2^e + rand(0,32) seconds.
	PeriodExponent RejoinPeriodExponent `protobuf:"varint,4,opt,name=period_exponent,json=periodExponent,proto3,enum=ttn.lorawan.v3.RejoinPeriodExponent" json:"period_exponent,omitempty"`
}

func (x *MACCommand_ForceRejoinReq) Reset() {
	*x = MACCommand_ForceRejoinReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_ForceRejoinReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_ForceRejoinReq) ProtoMessage() {}

func (x *MACCommand_ForceRejoinReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_ForceRejoinReq.ProtoReflect.Descriptor instead.
func (*MACCommand_ForceRejoinReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 19}
}

func (x *MACCommand_ForceRejoinReq) GetRejoinType() RejoinRequestType {
	if x != nil {
		return x.RejoinType
	}
	return RejoinRequestType_CONTEXT
}

func (x *MACCommand_ForceRejoinReq) GetDataRateIndex() DataRateIndex {
	if x != nil {
		return x.DataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *MACCommand_ForceRejoinReq) GetMaxRetries() uint32 {
	if x != nil {
		return x.MaxRetries
	}
	return 0
}

func (x *MACCommand_ForceRejoinReq) GetPeriodExponent() RejoinPeriodExponent {
	if x != nil {
		return x.PeriodExponent
	}
	return RejoinPeriodExponent_REJOIN_PERIOD_0
}

type MACCommand_RejoinParamSetupReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exponent e that configures the rejoin counter = 2^(e+4) messages.
	MaxCountExponent RejoinCountExponent `protobuf:"varint,1,opt,name=max_count_exponent,json=maxCountExponent,proto3,enum=ttn.lorawan.v3.RejoinCountExponent" json:"max_count_exponent,omitempty"`
	// Exponent e that configures the rejoin timer = 2^(e+10) seconds.
	MaxTimeExponent RejoinTimeExponent `protobuf:"varint,2,opt,name=max_time_exponent,json=maxTimeExponent,proto3,enum=ttn.lorawan.v3.RejoinTimeExponent" json:"max_time_exponent,omitempty"`
}

func (x *MACCommand_RejoinParamSetupReq) Reset() {
	*x = MACCommand_RejoinParamSetupReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RejoinParamSetupReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RejoinParamSetupReq) ProtoMessage() {}

func (x *MACCommand_RejoinParamSetupReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RejoinParamSetupReq.ProtoReflect.Descriptor instead.
func (*MACCommand_RejoinParamSetupReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 20}
}

func (x *MACCommand_RejoinParamSetupReq) GetMaxCountExponent() RejoinCountExponent {
	if x != nil {
		return x.MaxCountExponent
	}
	return RejoinCountExponent_REJOIN_COUNT_16
}

func (x *MACCommand_RejoinParamSetupReq) GetMaxTimeExponent() RejoinTimeExponent {
	if x != nil {
		return x.MaxTimeExponent
	}
	return RejoinTimeExponent_REJOIN_TIME_0
}

type MACCommand_RejoinParamSetupAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MaxTimeExponentAck bool `protobuf:"varint,1,opt,name=max_time_exponent_ack,json=maxTimeExponentAck,proto3" json:"max_time_exponent_ack,omitempty"`
}

func (x *MACCommand_RejoinParamSetupAns) Reset() {
	*x = MACCommand_RejoinParamSetupAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RejoinParamSetupAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RejoinParamSetupAns) ProtoMessage() {}

func (x *MACCommand_RejoinParamSetupAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RejoinParamSetupAns.ProtoReflect.Descriptor instead.
func (*MACCommand_RejoinParamSetupAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 21}
}

func (x *MACCommand_RejoinParamSetupAns) GetMaxTimeExponentAck() bool {
	if x != nil {
		return x.MaxTimeExponentAck
	}
	return false
}

type MACCommand_PingSlotInfoReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Period PingSlotPeriod `protobuf:"varint,1,opt,name=period,proto3,enum=ttn.lorawan.v3.PingSlotPeriod" json:"period,omitempty"`
}

func (x *MACCommand_PingSlotInfoReq) Reset() {
	*x = MACCommand_PingSlotInfoReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_PingSlotInfoReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_PingSlotInfoReq) ProtoMessage() {}

func (x *MACCommand_PingSlotInfoReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_PingSlotInfoReq.ProtoReflect.Descriptor instead.
func (*MACCommand_PingSlotInfoReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 22}
}

func (x *MACCommand_PingSlotInfoReq) GetPeriod() PingSlotPeriod {
	if x != nil {
		return x.Period
	}
	return PingSlotPeriod_PING_EVERY_1S
}

type MACCommand_PingSlotChannelReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Frequency     uint64        `protobuf:"varint,1,opt,name=frequency,proto3" json:"frequency,omitempty"` // Ping slot channel frequency (Hz).
	DataRateIndex DataRateIndex `protobuf:"varint,2,opt,name=data_rate_index,json=dataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"data_rate_index,omitempty"`
}

func (x *MACCommand_PingSlotChannelReq) Reset() {
	*x = MACCommand_PingSlotChannelReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_PingSlotChannelReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_PingSlotChannelReq) ProtoMessage() {}

func (x *MACCommand_PingSlotChannelReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_PingSlotChannelReq.ProtoReflect.Descriptor instead.
func (*MACCommand_PingSlotChannelReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 23}
}

func (x *MACCommand_PingSlotChannelReq) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *MACCommand_PingSlotChannelReq) GetDataRateIndex() DataRateIndex {
	if x != nil {
		return x.DataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

type MACCommand_PingSlotChannelAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FrequencyAck     bool `protobuf:"varint,1,opt,name=frequency_ack,json=frequencyAck,proto3" json:"frequency_ack,omitempty"`
	DataRateIndexAck bool `protobuf:"varint,2,opt,name=data_rate_index_ack,json=dataRateIndexAck,proto3" json:"data_rate_index_ack,omitempty"`
}

func (x *MACCommand_PingSlotChannelAns) Reset() {
	*x = MACCommand_PingSlotChannelAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_PingSlotChannelAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_PingSlotChannelAns) ProtoMessage() {}

func (x *MACCommand_PingSlotChannelAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_PingSlotChannelAns.ProtoReflect.Descriptor instead.
func (*MACCommand_PingSlotChannelAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 24}
}

func (x *MACCommand_PingSlotChannelAns) GetFrequencyAck() bool {
	if x != nil {
		return x.FrequencyAck
	}
	return false
}

func (x *MACCommand_PingSlotChannelAns) GetDataRateIndexAck() bool {
	if x != nil {
		return x.DataRateIndexAck
	}
	return false
}

type MACCommand_BeaconTimingAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Delay        uint32 `protobuf:"varint,1,opt,name=delay,proto3" json:"delay,omitempty"` // (uint16) See LoRaWAN specification.
	ChannelIndex uint32 `protobuf:"varint,2,opt,name=channel_index,json=channelIndex,proto3" json:"channel_index,omitempty"`
}

func (x *MACCommand_BeaconTimingAns) Reset() {
	*x = MACCommand_BeaconTimingAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_BeaconTimingAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_BeaconTimingAns) ProtoMessage() {}

func (x *MACCommand_BeaconTimingAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_BeaconTimingAns.ProtoReflect.Descriptor instead.
func (*MACCommand_BeaconTimingAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 25}
}

func (x *MACCommand_BeaconTimingAns) GetDelay() uint32 {
	if x != nil {
		return x.Delay
	}
	return 0
}

func (x *MACCommand_BeaconTimingAns) GetChannelIndex() uint32 {
	if x != nil {
		return x.ChannelIndex
	}
	return 0
}

type MACCommand_BeaconFreqReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Frequency uint64 `protobuf:"varint,1,opt,name=frequency,proto3" json:"frequency,omitempty"` // Frequency of the Class B beacons (Hz).
}

func (x *MACCommand_BeaconFreqReq) Reset() {
	*x = MACCommand_BeaconFreqReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_BeaconFreqReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_BeaconFreqReq) ProtoMessage() {}

func (x *MACCommand_BeaconFreqReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_BeaconFreqReq.ProtoReflect.Descriptor instead.
func (*MACCommand_BeaconFreqReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 26}
}

func (x *MACCommand_BeaconFreqReq) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

type MACCommand_BeaconFreqAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FrequencyAck bool `protobuf:"varint,1,opt,name=frequency_ack,json=frequencyAck,proto3" json:"frequency_ack,omitempty"`
}

func (x *MACCommand_BeaconFreqAns) Reset() {
	*x = MACCommand_BeaconFreqAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_BeaconFreqAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_BeaconFreqAns) ProtoMessage() {}

func (x *MACCommand_BeaconFreqAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_BeaconFreqAns.ProtoReflect.Descriptor instead.
func (*MACCommand_BeaconFreqAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 27}
}

func (x *MACCommand_BeaconFreqAns) GetFrequencyAck() bool {
	if x != nil {
		return x.FrequencyAck
	}
	return false
}

type MACCommand_DeviceModeInd struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Class Class `protobuf:"varint,1,opt,name=class,proto3,enum=ttn.lorawan.v3.Class" json:"class,omitempty"`
}

func (x *MACCommand_DeviceModeInd) Reset() {
	*x = MACCommand_DeviceModeInd{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_DeviceModeInd) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_DeviceModeInd) ProtoMessage() {}

func (x *MACCommand_DeviceModeInd) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_DeviceModeInd.ProtoReflect.Descriptor instead.
func (*MACCommand_DeviceModeInd) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 28}
}

func (x *MACCommand_DeviceModeInd) GetClass() Class {
	if x != nil {
		return x.Class
	}
	return Class_CLASS_A
}

type MACCommand_DeviceModeConf struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Class Class `protobuf:"varint,1,opt,name=class,proto3,enum=ttn.lorawan.v3.Class" json:"class,omitempty"`
}

func (x *MACCommand_DeviceModeConf) Reset() {
	*x = MACCommand_DeviceModeConf{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_DeviceModeConf) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_DeviceModeConf) ProtoMessage() {}

func (x *MACCommand_DeviceModeConf) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_DeviceModeConf.ProtoReflect.Descriptor instead.
func (*MACCommand_DeviceModeConf) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 29}
}

func (x *MACCommand_DeviceModeConf) GetClass() Class {
	if x != nil {
		return x.Class
	}
	return Class_CLASS_A
}

type MACCommand_RelayConfReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Configuration *MACCommand_RelayConfReq_Configuration `protobuf:"bytes,1,opt,name=configuration,proto3" json:"configuration,omitempty"`
}

func (x *MACCommand_RelayConfReq) Reset() {
	*x = MACCommand_RelayConfReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RelayConfReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RelayConfReq) ProtoMessage() {}

func (x *MACCommand_RelayConfReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RelayConfReq.ProtoReflect.Descriptor instead.
func (*MACCommand_RelayConfReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 30}
}

func (x *MACCommand_RelayConfReq) GetConfiguration() *MACCommand_RelayConfReq_Configuration {
	if x != nil {
		return x.Configuration
	}
	return nil
}

type MACCommand_RelayConfAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SecondChannelFrequencyAck     bool `protobuf:"varint,1,opt,name=second_channel_frequency_ack,json=secondChannelFrequencyAck,proto3" json:"second_channel_frequency_ack,omitempty"`
	SecondChannelAckOffsetAck     bool `protobuf:"varint,2,opt,name=second_channel_ack_offset_ack,json=secondChannelAckOffsetAck,proto3" json:"second_channel_ack_offset_ack,omitempty"`
	SecondChannelDataRateIndexAck bool `protobuf:"varint,3,opt,name=second_channel_data_rate_index_ack,json=secondChannelDataRateIndexAck,proto3" json:"second_channel_data_rate_index_ack,omitempty"`
	SecondChannelIndexAck         bool `protobuf:"varint,4,opt,name=second_channel_index_ack,json=secondChannelIndexAck,proto3" json:"second_channel_index_ack,omitempty"`
	DefaultChannelIndexAck        bool `protobuf:"varint,5,opt,name=default_channel_index_ack,json=defaultChannelIndexAck,proto3" json:"default_channel_index_ack,omitempty"`
	CadPeriodicityAck             bool `protobuf:"varint,6,opt,name=cad_periodicity_ack,json=cadPeriodicityAck,proto3" json:"cad_periodicity_ack,omitempty"`
}

func (x *MACCommand_RelayConfAns) Reset() {
	*x = MACCommand_RelayConfAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RelayConfAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RelayConfAns) ProtoMessage() {}

func (x *MACCommand_RelayConfAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RelayConfAns.ProtoReflect.Descriptor instead.
func (*MACCommand_RelayConfAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 31}
}

func (x *MACCommand_RelayConfAns) GetSecondChannelFrequencyAck() bool {
	if x != nil {
		return x.SecondChannelFrequencyAck
	}
	return false
}

func (x *MACCommand_RelayConfAns) GetSecondChannelAckOffsetAck() bool {
	if x != nil {
		return x.SecondChannelAckOffsetAck
	}
	return false
}

func (x *MACCommand_RelayConfAns) GetSecondChannelDataRateIndexAck() bool {
	if x != nil {
		return x.SecondChannelDataRateIndexAck
	}
	return false
}

func (x *MACCommand_RelayConfAns) GetSecondChannelIndexAck() bool {
	if x != nil {
		return x.SecondChannelIndexAck
	}
	return false
}

func (x *MACCommand_RelayConfAns) GetDefaultChannelIndexAck() bool {
	if x != nil {
		return x.DefaultChannelIndexAck
	}
	return false
}

func (x *MACCommand_RelayConfAns) GetCadPeriodicityAck() bool {
	if x != nil {
		return x.CadPeriodicityAck
	}
	return false
}

type MACCommand_RelayEndDeviceConfReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Configuration *MACCommand_RelayEndDeviceConfReq_Configuration `protobuf:"bytes,1,opt,name=configuration,proto3" json:"configuration,omitempty"`
}

func (x *MACCommand_RelayEndDeviceConfReq) Reset() {
	*x = MACCommand_RelayEndDeviceConfReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RelayEndDeviceConfReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RelayEndDeviceConfReq) ProtoMessage() {}

func (x *MACCommand_RelayEndDeviceConfReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RelayEndDeviceConfReq.ProtoReflect.Descriptor instead.
func (*MACCommand_RelayEndDeviceConfReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 32}
}

func (x *MACCommand_RelayEndDeviceConfReq) GetConfiguration() *MACCommand_RelayEndDeviceConfReq_Configuration {
	if x != nil {
		return x.Configuration
	}
	return nil
}

type MACCommand_RelayEndDeviceConfAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SecondChannelFrequencyAck     bool `protobuf:"varint,1,opt,name=second_channel_frequency_ack,json=secondChannelFrequencyAck,proto3" json:"second_channel_frequency_ack,omitempty"`
	SecondChannelDataRateIndexAck bool `protobuf:"varint,3,opt,name=second_channel_data_rate_index_ack,json=secondChannelDataRateIndexAck,proto3" json:"second_channel_data_rate_index_ack,omitempty"`
	SecondChannelIndexAck         bool `protobuf:"varint,4,opt,name=second_channel_index_ack,json=secondChannelIndexAck,proto3" json:"second_channel_index_ack,omitempty"`
	BackoffAck                    bool `protobuf:"varint,5,opt,name=backoff_ack,json=backoffAck,proto3" json:"backoff_ack,omitempty"`
}

func (x *MACCommand_RelayEndDeviceConfAns) Reset() {
	*x = MACCommand_RelayEndDeviceConfAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RelayEndDeviceConfAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RelayEndDeviceConfAns) ProtoMessage() {}

func (x *MACCommand_RelayEndDeviceConfAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RelayEndDeviceConfAns.ProtoReflect.Descriptor instead.
func (*MACCommand_RelayEndDeviceConfAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 33}
}

func (x *MACCommand_RelayEndDeviceConfAns) GetSecondChannelFrequencyAck() bool {
	if x != nil {
		return x.SecondChannelFrequencyAck
	}
	return false
}

func (x *MACCommand_RelayEndDeviceConfAns) GetSecondChannelDataRateIndexAck() bool {
	if x != nil {
		return x.SecondChannelDataRateIndexAck
	}
	return false
}

func (x *MACCommand_RelayEndDeviceConfAns) GetSecondChannelIndexAck() bool {
	if x != nil {
		return x.SecondChannelIndexAck
	}
	return false
}

func (x *MACCommand_RelayEndDeviceConfAns) GetBackoffAck() bool {
	if x != nil {
		return x.BackoffAck
	}
	return false
}

type MACCommand_RelayUpdateUplinkListReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RuleIndex     uint32                    `protobuf:"varint,1,opt,name=rule_index,json=ruleIndex,proto3" json:"rule_index,omitempty"`
	ForwardLimits *RelayUplinkForwardLimits `protobuf:"bytes,2,opt,name=forward_limits,json=forwardLimits,proto3" json:"forward_limits,omitempty"`
	DevAddr       []byte                    `protobuf:"bytes,3,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	WFCnt         uint32                    `protobuf:"varint,4,opt,name=w_f_cnt,json=wFCnt,proto3" json:"w_f_cnt,omitempty"`
	RootWorSKey   []byte                    `protobuf:"bytes,5,opt,name=root_wor_s_key,json=rootWorSKey,proto3" json:"root_wor_s_key,omitempty"`
	DeviceId      string                    `protobuf:"bytes,6,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	SessionKeyId  []byte                    `protobuf:"bytes,7,opt,name=session_key_id,json=sessionKeyId,proto3" json:"session_key_id,omitempty"`
}

func (x *MACCommand_RelayUpdateUplinkListReq) Reset() {
	*x = MACCommand_RelayUpdateUplinkListReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RelayUpdateUplinkListReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RelayUpdateUplinkListReq) ProtoMessage() {}

func (x *MACCommand_RelayUpdateUplinkListReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RelayUpdateUplinkListReq.ProtoReflect.Descriptor instead.
func (*MACCommand_RelayUpdateUplinkListReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 34}
}

func (x *MACCommand_RelayUpdateUplinkListReq) GetRuleIndex() uint32 {
	if x != nil {
		return x.RuleIndex
	}
	return 0
}

func (x *MACCommand_RelayUpdateUplinkListReq) GetForwardLimits() *RelayUplinkForwardLimits {
	if x != nil {
		return x.ForwardLimits
	}
	return nil
}

func (x *MACCommand_RelayUpdateUplinkListReq) GetDevAddr() []byte {
	if x != nil {
		return x.DevAddr
	}
	return nil
}

func (x *MACCommand_RelayUpdateUplinkListReq) GetWFCnt() uint32 {
	if x != nil {
		return x.WFCnt
	}
	return 0
}

func (x *MACCommand_RelayUpdateUplinkListReq) GetRootWorSKey() []byte {
	if x != nil {
		return x.RootWorSKey
	}
	return nil
}

func (x *MACCommand_RelayUpdateUplinkListReq) GetDeviceId() string {
	if x != nil {
		return x.DeviceId
	}
	return ""
}

func (x *MACCommand_RelayUpdateUplinkListReq) GetSessionKeyId() []byte {
	if x != nil {
		return x.SessionKeyId
	}
	return nil
}

type MACCommand_RelayUpdateUplinkListAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MACCommand_RelayUpdateUplinkListAns) Reset() {
	*x = MACCommand_RelayUpdateUplinkListAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RelayUpdateUplinkListAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RelayUpdateUplinkListAns) ProtoMessage() {}

func (x *MACCommand_RelayUpdateUplinkListAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RelayUpdateUplinkListAns.ProtoReflect.Descriptor instead.
func (*MACCommand_RelayUpdateUplinkListAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 35}
}

type MACCommand_RelayCtrlUplinkListReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RuleIndex uint32                    `protobuf:"varint,1,opt,name=rule_index,json=ruleIndex,proto3" json:"rule_index,omitempty"`
	Action    RelayCtrlUplinkListAction `protobuf:"varint,2,opt,name=action,proto3,enum=ttn.lorawan.v3.RelayCtrlUplinkListAction" json:"action,omitempty"`
}

func (x *MACCommand_RelayCtrlUplinkListReq) Reset() {
	*x = MACCommand_RelayCtrlUplinkListReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RelayCtrlUplinkListReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RelayCtrlUplinkListReq) ProtoMessage() {}

func (x *MACCommand_RelayCtrlUplinkListReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RelayCtrlUplinkListReq.ProtoReflect.Descriptor instead.
func (*MACCommand_RelayCtrlUplinkListReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 36}
}

func (x *MACCommand_RelayCtrlUplinkListReq) GetRuleIndex() uint32 {
	if x != nil {
		return x.RuleIndex
	}
	return 0
}

func (x *MACCommand_RelayCtrlUplinkListReq) GetAction() RelayCtrlUplinkListAction {
	if x != nil {
		return x.Action
	}
	return RelayCtrlUplinkListAction_RELAY_CTRL_UPLINK_LIST_ACTION_READ_W_F_CNT
}

type MACCommand_RelayCtrlUplinkListAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RuleIndexAck bool   `protobuf:"varint,1,opt,name=rule_index_ack,json=ruleIndexAck,proto3" json:"rule_index_ack,omitempty"`
	WFCnt        uint32 `protobuf:"varint,2,opt,name=w_f_cnt,json=wFCnt,proto3" json:"w_f_cnt,omitempty"`
}

func (x *MACCommand_RelayCtrlUplinkListAns) Reset() {
	*x = MACCommand_RelayCtrlUplinkListAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RelayCtrlUplinkListAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RelayCtrlUplinkListAns) ProtoMessage() {}

func (x *MACCommand_RelayCtrlUplinkListAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RelayCtrlUplinkListAns.ProtoReflect.Descriptor instead.
func (*MACCommand_RelayCtrlUplinkListAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 37}
}

func (x *MACCommand_RelayCtrlUplinkListAns) GetRuleIndexAck() bool {
	if x != nil {
		return x.RuleIndexAck
	}
	return false
}

func (x *MACCommand_RelayCtrlUplinkListAns) GetWFCnt() uint32 {
	if x != nil {
		return x.WFCnt
	}
	return 0
}

type MACCommand_RelayConfigureFwdLimitReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ResetLimitCounter  RelayResetLimitCounter `protobuf:"varint,1,opt,name=reset_limit_counter,json=resetLimitCounter,proto3,enum=ttn.lorawan.v3.RelayResetLimitCounter" json:"reset_limit_counter,omitempty"`
	JoinRequestLimits  *RelayForwardLimits    `protobuf:"bytes,2,opt,name=join_request_limits,json=joinRequestLimits,proto3" json:"join_request_limits,omitempty"`
	NotifyLimits       *RelayForwardLimits    `protobuf:"bytes,3,opt,name=notify_limits,json=notifyLimits,proto3" json:"notify_limits,omitempty"`
	GlobalUplinkLimits *RelayForwardLimits    `protobuf:"bytes,4,opt,name=global_uplink_limits,json=globalUplinkLimits,proto3" json:"global_uplink_limits,omitempty"`
	OverallLimits      *RelayForwardLimits    `protobuf:"bytes,5,opt,name=overall_limits,json=overallLimits,proto3" json:"overall_limits,omitempty"`
}

func (x *MACCommand_RelayConfigureFwdLimitReq) Reset() {
	*x = MACCommand_RelayConfigureFwdLimitReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RelayConfigureFwdLimitReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RelayConfigureFwdLimitReq) ProtoMessage() {}

func (x *MACCommand_RelayConfigureFwdLimitReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RelayConfigureFwdLimitReq.ProtoReflect.Descriptor instead.
func (*MACCommand_RelayConfigureFwdLimitReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 38}
}

func (x *MACCommand_RelayConfigureFwdLimitReq) GetResetLimitCounter() RelayResetLimitCounter {
	if x != nil {
		return x.ResetLimitCounter
	}
	return RelayResetLimitCounter_RELAY_RESET_LIMIT_COUNTER_ZERO
}

func (x *MACCommand_RelayConfigureFwdLimitReq) GetJoinRequestLimits() *RelayForwardLimits {
	if x != nil {
		return x.JoinRequestLimits
	}
	return nil
}

func (x *MACCommand_RelayConfigureFwdLimitReq) GetNotifyLimits() *RelayForwardLimits {
	if x != nil {
		return x.NotifyLimits
	}
	return nil
}

func (x *MACCommand_RelayConfigureFwdLimitReq) GetGlobalUplinkLimits() *RelayForwardLimits {
	if x != nil {
		return x.GlobalUplinkLimits
	}
	return nil
}

func (x *MACCommand_RelayConfigureFwdLimitReq) GetOverallLimits() *RelayForwardLimits {
	if x != nil {
		return x.OverallLimits
	}
	return nil
}

type MACCommand_RelayConfigureFwdLimitAns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MACCommand_RelayConfigureFwdLimitAns) Reset() {
	*x = MACCommand_RelayConfigureFwdLimitAns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RelayConfigureFwdLimitAns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RelayConfigureFwdLimitAns) ProtoMessage() {}

func (x *MACCommand_RelayConfigureFwdLimitAns) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RelayConfigureFwdLimitAns.ProtoReflect.Descriptor instead.
func (*MACCommand_RelayConfigureFwdLimitAns) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 39}
}

type MACCommand_RelayNotifyNewEndDeviceReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DevAddr []byte `protobuf:"bytes,1,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	Snr     int32  `protobuf:"varint,2,opt,name=snr,proto3" json:"snr,omitempty"`
	Rssi    int32  `protobuf:"varint,3,opt,name=rssi,proto3" json:"rssi,omitempty"`
}

func (x *MACCommand_RelayNotifyNewEndDeviceReq) Reset() {
	*x = MACCommand_RelayNotifyNewEndDeviceReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RelayNotifyNewEndDeviceReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RelayNotifyNewEndDeviceReq) ProtoMessage() {}

func (x *MACCommand_RelayNotifyNewEndDeviceReq) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RelayNotifyNewEndDeviceReq.ProtoReflect.Descriptor instead.
func (*MACCommand_RelayNotifyNewEndDeviceReq) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 40}
}

func (x *MACCommand_RelayNotifyNewEndDeviceReq) GetDevAddr() []byte {
	if x != nil {
		return x.DevAddr
	}
	return nil
}

func (x *MACCommand_RelayNotifyNewEndDeviceReq) GetSnr() int32 {
	if x != nil {
		return x.Snr
	}
	return 0
}

func (x *MACCommand_RelayNotifyNewEndDeviceReq) GetRssi() int32 {
	if x != nil {
		return x.Rssi
	}
	return 0
}

type MACCommand_RelayConfReq_Configuration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SecondChannel       *RelaySecondChannel `protobuf:"bytes,1,opt,name=second_channel,json=secondChannel,proto3" json:"second_channel,omitempty"`
	DefaultChannelIndex uint32              `protobuf:"varint,2,opt,name=default_channel_index,json=defaultChannelIndex,proto3" json:"default_channel_index,omitempty"`
	CadPeriodicity      RelayCADPeriodicity `protobuf:"varint,3,opt,name=cad_periodicity,json=cadPeriodicity,proto3,enum=ttn.lorawan.v3.RelayCADPeriodicity" json:"cad_periodicity,omitempty"`
}

func (x *MACCommand_RelayConfReq_Configuration) Reset() {
	*x = MACCommand_RelayConfReq_Configuration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RelayConfReq_Configuration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RelayConfReq_Configuration) ProtoMessage() {}

func (x *MACCommand_RelayConfReq_Configuration) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RelayConfReq_Configuration.ProtoReflect.Descriptor instead.
func (*MACCommand_RelayConfReq_Configuration) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 30, 0}
}

func (x *MACCommand_RelayConfReq_Configuration) GetSecondChannel() *RelaySecondChannel {
	if x != nil {
		return x.SecondChannel
	}
	return nil
}

func (x *MACCommand_RelayConfReq_Configuration) GetDefaultChannelIndex() uint32 {
	if x != nil {
		return x.DefaultChannelIndex
	}
	return 0
}

func (x *MACCommand_RelayConfReq_Configuration) GetCadPeriodicity() RelayCADPeriodicity {
	if x != nil {
		return x.CadPeriodicity
	}
	return RelayCADPeriodicity_RELAY_CAD_PERIODICITY_1_SECOND
}

type MACCommand_RelayEndDeviceConfReq_Configuration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Mode:
	//	*MACCommand_RelayEndDeviceConfReq_Configuration_Always
	//	*MACCommand_RelayEndDeviceConfReq_Configuration_Dynamic
	//	*MACCommand_RelayEndDeviceConfReq_Configuration_EndDeviceControlled
	Mode            isMACCommand_RelayEndDeviceConfReq_Configuration_Mode `protobuf_oneof:"mode"`
	Backoff         uint32                                                `protobuf:"varint,4,opt,name=backoff,proto3" json:"backoff,omitempty"`
	SecondChannel   *RelaySecondChannel                                   `protobuf:"bytes,5,opt,name=second_channel,json=secondChannel,proto3" json:"second_channel,omitempty"`
	ServingDeviceId string                                                `protobuf:"bytes,6,opt,name=serving_device_id,json=servingDeviceId,proto3" json:"serving_device_id,omitempty"`
}

func (x *MACCommand_RelayEndDeviceConfReq_Configuration) Reset() {
	*x = MACCommand_RelayEndDeviceConfReq_Configuration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACCommand_RelayEndDeviceConfReq_Configuration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACCommand_RelayEndDeviceConfReq_Configuration) ProtoMessage() {}

func (x *MACCommand_RelayEndDeviceConfReq_Configuration) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_lorawan_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACCommand_RelayEndDeviceConfReq_Configuration.ProtoReflect.Descriptor instead.
func (*MACCommand_RelayEndDeviceConfReq_Configuration) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP(), []int{26, 32, 0}
}

func (m *MACCommand_RelayEndDeviceConfReq_Configuration) GetMode() isMACCommand_RelayEndDeviceConfReq_Configuration_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (x *MACCommand_RelayEndDeviceConfReq_Configuration) GetAlways() *RelayEndDeviceAlwaysMode {
	if x, ok := x.GetMode().(*MACCommand_RelayEndDeviceConfReq_Configuration_Always); ok {
		return x.Always
	}
	return nil
}

func (x *MACCommand_RelayEndDeviceConfReq_Configuration) GetDynamic() *RelayEndDeviceDynamicMode {
	if x, ok := x.GetMode().(*MACCommand_RelayEndDeviceConfReq_Configuration_Dynamic); ok {
		return x.Dynamic
	}
	return nil
}

func (x *MACCommand_RelayEndDeviceConfReq_Configuration) GetEndDeviceControlled() *RelayEndDeviceControlledMode {
	if x, ok := x.GetMode().(*MACCommand_RelayEndDeviceConfReq_Configuration_EndDeviceControlled); ok {
		return x.EndDeviceControlled
	}
	return nil
}

func (x *MACCommand_RelayEndDeviceConfReq_Configuration) GetBackoff() uint32 {
	if x != nil {
		return x.Backoff
	}
	return 0
}

func (x *MACCommand_RelayEndDeviceConfReq_Configuration) GetSecondChannel() *RelaySecondChannel {
	if x != nil {
		return x.SecondChannel
	}
	return nil
}

func (x *MACCommand_RelayEndDeviceConfReq_Configuration) GetServingDeviceId() string {
	if x != nil {
		return x.ServingDeviceId
	}
	return ""
}

type isMACCommand_RelayEndDeviceConfReq_Configuration_Mode interface {
	isMACCommand_RelayEndDeviceConfReq_Configuration_Mode()
}

type MACCommand_RelayEndDeviceConfReq_Configuration_Always struct {
	Always *RelayEndDeviceAlwaysMode `protobuf:"bytes,1,opt,name=always,proto3,oneof"`
}

type MACCommand_RelayEndDeviceConfReq_Configuration_Dynamic struct {
	Dynamic *RelayEndDeviceDynamicMode `protobuf:"bytes,2,opt,name=dynamic,proto3,oneof"`
}

type MACCommand_RelayEndDeviceConfReq_Configuration_EndDeviceControlled struct {
	EndDeviceControlled *RelayEndDeviceControlledMode `protobuf:"bytes,3,opt,name=end_device_controlled,json=endDeviceControlled,proto3,oneof"`
}

func (*MACCommand_RelayEndDeviceConfReq_Configuration_Always) isMACCommand_RelayEndDeviceConfReq_Configuration_Mode() {
}

func (*MACCommand_RelayEndDeviceConfReq_Configuration_Dynamic) isMACCommand_RelayEndDeviceConfReq_Configuration_Mode() {
}

func (*MACCommand_RelayEndDeviceConfReq_Configuration_EndDeviceControlled) isMACCommand_RelayEndDeviceConfReq_Configuration_Mode() {
}

var File_ttn_lorawan_v3_lorawan_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_lorawan_proto_rawDesc = []byte{
	0x0a, 0x1c, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70,
	0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x6a, 0x73, 0x6f, 0x6e,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f,
	0x76, 0x33, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbb, 0x03,
	0x0a, 0x07, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x33, 0x0a, 0x05, 0x6d, 0x5f, 0x68,
	0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x48, 0x44, 0x52, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x04, 0x6d, 0x48, 0x64, 0x72, 0x12, 0x1b,
	0x0a, 0x03, 0x6d, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x09, 0xfa, 0x42, 0x06,
	0x7a, 0x04, 0x10, 0x00, 0x18, 0x04, 0x52, 0x03, 0x6d, 0x69, 0x63, 0x12, 0x3d, 0x0a, 0x0b, 0x6d,
	0x61, 0x63, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4d, 0x41, 0x43, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x0a,
	0x6d, 0x61, 0x63, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x56, 0x0a, 0x14, 0x6a, 0x6f,
	0x69, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4a, 0x6f, 0x69, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x12,
	0x6a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x12, 0x53, 0x0a, 0x13, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x70,
	0x74, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4a, 0x6f, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x48, 0x00, 0x52, 0x11, 0x6a, 0x6f, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x5c, 0x0a, 0x16, 0x72, 0x65, 0x6a, 0x6f, 0x69,
	0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52,
	0x14, 0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x0e, 0x0a, 0x07, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x12, 0x03, 0xf8, 0x42, 0x01, 0x4a, 0x04, 0x08, 0x07, 0x10, 0x08, 0x22, 0x75, 0x0a, 0x04, 0x4d,
	0x48, 0x44, 0x52, 0x12, 0x36, 0x0a, 0x06, 0x6d, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x54, 0x79, 0x70, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x12, 0x35, 0x0a, 0x05, 0x6d,
	0x61, 0x6a, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6a, 0x6f,
	0x72, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x6d, 0x61, 0x6a,
	0x6f, 0x72, 0x22, 0xe3, 0x01, 0x0a, 0x0a, 0x4d, 0x41, 0x43, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x12, 0x33, 0x0a, 0x05, 0x66, 0x5f, 0x68, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x46, 0x48, 0x44, 0x52, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x04, 0x66, 0x48, 0x64, 0x72, 0x12, 0x1f, 0x0a, 0x06, 0x66, 0x5f, 0x70, 0x6f, 0x72, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xff, 0x01,
	0x52, 0x05, 0x66, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x72, 0x6d, 0x5f, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x66, 0x72,
	0x6d, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x40, 0x0a, 0x0f, 0x64, 0x65, 0x63, 0x6f,
	0x64, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x64, 0x65, 0x63, 0x6f,
	0x64, 0x65, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1c, 0x0a, 0x0a, 0x66, 0x75,
	0x6c, 0x6c, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08,
	0x66, 0x75, 0x6c, 0x6c, 0x46, 0x43, 0x6e, 0x74, 0x22, 0xee, 0x03, 0x0a, 0x04, 0x46, 0x48, 0x44,
	0x52, 0x12, 0xed, 0x02, 0x0a, 0x08, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x42, 0xd1, 0x02, 0x92, 0x41, 0x19, 0x4a, 0x0a, 0x22, 0x32, 0x36, 0x30,
	0x30, 0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x04, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82,
	0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x34, 0x42, 0x79,
	0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65,
	0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f,
	0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x34, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65,
	0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f,
	0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78,
	0x61, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x07, 0x64, 0x65, 0x76, 0x41, 0x64, 0x64,
	0x72, 0x12, 0x36, 0x0a, 0x06, 0x66, 0x5f, 0x63, 0x74, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x15, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x46, 0x43, 0x74, 0x72, 0x6c, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x05, 0x66, 0x43, 0x74, 0x72, 0x6c, 0x12, 0x1e, 0x0a, 0x05, 0x66, 0x5f, 0x63,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x09, 0xfa, 0x42, 0x06, 0x2a, 0x04, 0x18,
	0xff, 0xff, 0x03, 0x52, 0x04, 0x66, 0x43, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x06, 0x66, 0x5f, 0x6f,
	0x70, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x7a, 0x02,
	0x18, 0x0f, 0x52, 0x05, 0x66, 0x4f, 0x70, 0x74, 0x73, 0x22, 0x81, 0x01, 0x0a, 0x05, 0x46, 0x43,
	0x74, 0x72, 0x6c, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x03, 0x61, 0x64, 0x72, 0x12, 0x1e, 0x0a, 0x0b, 0x61, 0x64, 0x72, 0x5f, 0x61, 0x63, 0x6b,
	0x5f, 0x72, 0x65, 0x71, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x61, 0x64, 0x72, 0x41,
	0x63, 0x6b, 0x52, 0x65, 0x71, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x03, 0x61, 0x63, 0x6b, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x5f, 0x70, 0x65, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x66, 0x50, 0x65, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x17, 0x0a, 0x07, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x62, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x22, 0xf0, 0x08,
	0x0a, 0x12, 0x4a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0xf5, 0x02, 0x0a, 0x08, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x65, 0x75,
	0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xd9, 0x02, 0x92, 0x41, 0x21, 0x4a, 0x12, 0x22,
	0x37, 0x30, 0x42, 0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30, 0x41, 0x42, 0x43, 0x44,
	0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42,
	0x06, 0x7a, 0x04, 0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f,
	0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61,
	0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67,
	0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55,
	0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa,
	0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74,
	0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46,
	0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74,
	0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63, 0x74, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x52, 0x07, 0x6a, 0x6f, 0x69, 0x6e, 0x45, 0x75, 0x69, 0x12, 0xf3, 0x02, 0x0a,
	0x07, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xd9,
	0x02, 0x92, 0x41, 0x21, 0x4a, 0x12, 0x22, 0x37, 0x30, 0x42, 0x33, 0x44, 0x35, 0x37, 0x45, 0x44,
	0x30, 0x30, 0x30, 0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x08, 0x70, 0x01, 0xea, 0xaa,
	0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x38,
	0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76,
	0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77,
	0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76,
	0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74,
	0x45, 0x78, 0x61, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45,
	0x75, 0x69, 0x12, 0xeb, 0x02, 0x0a, 0x09, 0x64, 0x65, 0x76, 0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xcd, 0x02, 0x92, 0x41, 0x15, 0x4a, 0x06, 0x22, 0x41,
	0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x02, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a,
	0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x32, 0x42, 0x79, 0x74, 0x65,
	0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d,
	0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x32, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d,
	0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63,
	0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x08, 0x64, 0x65, 0x76, 0x4e, 0x6f, 0x6e, 0x63, 0x65,
	0x22, 0xdb, 0x09, 0x0a, 0x14, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x4c, 0x0a, 0x0b, 0x72, 0x65, 0x6a,
	0x6f, 0x69, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x72, 0x65, 0x6a,
	0x6f, 0x69, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0xe7, 0x02, 0x0a, 0x06, 0x6e, 0x65, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xcf, 0x02, 0x92, 0x41, 0x17, 0x4a, 0x08,
	0x22, 0x30, 0x30, 0x30, 0x30, 0x31, 0x33, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x03, 0x70, 0x01, 0xea, 0xaa,
	0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x33,
	0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76,
	0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77,
	0x33, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76,
	0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74,
	0x45, 0x78, 0x61, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x05, 0x6e, 0x65, 0x74, 0x49,
	0x64, 0x12, 0xf5, 0x02, 0x0a, 0x08, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0c, 0x42, 0xd9, 0x02, 0x92, 0x41, 0x21, 0x4a, 0x12, 0x22, 0x37, 0x30, 0x42,
	0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30, 0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02,
	0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04,
	0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68,
	0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33,
	0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68,
	0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76,
	0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61,
	0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01,
	0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d,
	0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61,
	0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67,
	0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d,
	0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61,
	0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x52, 0x07, 0x6a, 0x6f, 0x69, 0x6e, 0x45, 0x75, 0x69, 0x12, 0xf3, 0x02, 0x0a, 0x07, 0x64, 0x65,
	0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xd9, 0x02, 0x92, 0x41,
	0x21, 0x4a, 0x12, 0x22, 0x37, 0x30, 0x42, 0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30,
	0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01,
	0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74,
	0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63,
	0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x38, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63,
	0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61,
	0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69, 0x12,
	0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x63, 0x6e, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x09, 0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x43, 0x6e, 0x74, 0x22, 0xb3,
	0x0a, 0x0a, 0x11, 0x4a, 0x6f, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x65, 0x64, 0x12, 0xef, 0x02, 0x0a, 0x0a, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x6e, 0x6f, 0x6e, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xcf, 0x02, 0x92, 0x41, 0x17, 0x4a, 0x08, 0x22,
	0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x03, 0x70, 0x01, 0xea, 0xaa, 0x19,
	0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x33, 0x42,
	0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68,
	0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33,
	0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x33,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68,
	0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33,
	0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45,
	0x78, 0x61, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x09, 0x6a, 0x6f, 0x69, 0x6e, 0x4e,
	0x6f, 0x6e, 0x63, 0x65, 0x12, 0xe7, 0x02, 0x0a, 0x06, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xcf, 0x02, 0x92, 0x41, 0x17, 0x4a, 0x08, 0x22, 0x30, 0x30,
	0x30, 0x30, 0x31, 0x33, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x03, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01,
	0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x33, 0x42, 0x79, 0x74,
	0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63,
	0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x33, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63,
	0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61,
	0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x05, 0x6e, 0x65, 0x74, 0x49, 0x64, 0x12, 0xed,
	0x02, 0x0a, 0x08, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0c, 0x42, 0xd1, 0x02, 0x92, 0x41, 0x19, 0x4a, 0x0a, 0x22, 0x32, 0x36, 0x30, 0x30, 0x41, 0x42,
	0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x04, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f,
	0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e,
	0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12,
	0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x34, 0x42, 0x79, 0x74, 0x65, 0x73,
	0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64,
	0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x34, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64,
	0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63, 0x74,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x07, 0x64, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x12, 0x45,
	0x0a, 0x0b, 0x64, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x4c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x64, 0x6c, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3c, 0x0a, 0x08, 0x72, 0x78, 0x5f, 0x64, 0x65, 0x6c, 0x61,
	0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x78, 0x44, 0x65, 0x6c, 0x61, 0x79,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x07, 0x72, 0x78, 0x44, 0x65,
	0x6c, 0x61, 0x79, 0x12, 0x2f, 0x0a, 0x07, 0x63, 0x66, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x46, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x06, 0x63, 0x66,
	0x4c, 0x69, 0x73, 0x74, 0x22, 0xbd, 0x01, 0x0a, 0x0a, 0x44, 0x4c, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x4c, 0x0a, 0x0d, 0x72, 0x78, 0x31, 0x5f, 0x64, 0x72, 0x5f, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x61, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x0b, 0x72, 0x78, 0x31, 0x44, 0x72, 0x4f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x12, 0x3e, 0x0a, 0x06, 0x72, 0x78, 0x32, 0x5f, 0x64, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x72, 0x78, 0x32, 0x44,
	0x72, 0x12, 0x17, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x5f, 0x6e, 0x65, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x06, 0x6f, 0x70, 0x74, 0x4e, 0x65, 0x67, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04,
	0x08, 0x01, 0x10, 0x01, 0x22, 0x7b, 0x0a, 0x06, 0x43, 0x46, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x38,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x46,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x72, 0x65, 0x71,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x04, 0x66, 0x72, 0x65, 0x71, 0x12, 0x19, 0x0a, 0x08,
	0x63, 0x68, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x08, 0x52, 0x07,
	0x63, 0x68, 0x4d, 0x61, 0x73, 0x6b, 0x73, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10,
	0x01, 0x22, 0x82, 0x01, 0x0a, 0x0c, 0x4c, 0x6f, 0x52, 0x61, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61,
	0x74, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x12, 0x29, 0x0a, 0x10, 0x73, 0x70, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61,
	0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x73, 0x70, 0x72, 0x65,
	0x61, 0x64, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x74, 0x65, 0x3a, 0x08, 0xf2, 0xaa,
	0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0x32, 0x0a, 0x0b, 0x46, 0x53, 0x4b, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x61, 0x74, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x62, 0x69, 0x74, 0x5f, 0x72, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x62, 0x69, 0x74, 0x52, 0x61, 0x74, 0x65,
	0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0x9c, 0x01, 0x0a, 0x0e, 0x4c,
	0x52, 0x46, 0x48, 0x53, 0x53, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x12, 0x27, 0x0a,
	0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x15, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x57, 0x69, 0x64, 0x74, 0x68, 0x12, 0x1f,
	0x0a, 0x0b, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x74, 0x65, 0x3a,
	0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0xc6, 0x01, 0x0a, 0x08, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x12, 0x32, 0x0a, 0x04, 0x6c, 0x6f, 0x72, 0x61, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x6f, 0x52, 0x61, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61,
	0x74, 0x65, 0x48, 0x00, 0x52, 0x04, 0x6c, 0x6f, 0x72, 0x61, 0x12, 0x2f, 0x0a, 0x03, 0x66, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x46, 0x53, 0x4b, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x03, 0x66, 0x73, 0x6b, 0x12, 0x38, 0x0a, 0x06, 0x6c,
	0x72, 0x66, 0x68, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x52, 0x46,
	0x48, 0x53, 0x53, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x06, 0x6c,
	0x72, 0x66, 0x68, 0x73, 0x73, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x42,
	0x11, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x03, 0xf8,
	0x42, 0x01, 0x22, 0xf9, 0x03, 0x0a, 0x0a, 0x54, 0x78, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x3f, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61,
	0x74, 0x65, 0x12, 0x27, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x04, 0x42, 0x09, 0xfa, 0x42, 0x06, 0x32, 0x04, 0x28, 0xa0, 0x8d, 0x06,
	0x52, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x72, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x09, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x72, 0x63, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x78, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52,
	0x08, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x35, 0x0a, 0x16, 0x63, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x63, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x1a, 0x85, 0x01, 0x0a, 0x08, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x23, 0x0a,
	0x0d, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x78, 0x5f, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x07, 0x74, 0x78, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x12, 0x2f, 0x0a,
	0x13, 0x69, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x61, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x69, 0x6e, 0x76, 0x65,
	0x72, 0x74, 0x50, 0x6f, 0x6c, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x08,
	0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01,
	0x10, 0x01, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x22, 0x8f,
	0x01, 0x0a, 0x19, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x6e, 0x74, 0x65, 0x6e, 0x6e,
	0x61, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x4d, 0x0a, 0x0b,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x61,
	0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x0c, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x22, 0xb0, 0x01, 0x0a, 0x19, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x43, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x4d,
	0x0a, 0x0b, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12, 0x23, 0x0a,
	0x0d, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x12, 0x1f, 0x0a, 0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x22, 0x9b, 0x02, 0x0a, 0x0b, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x45, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x10, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x0c, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x54, 0x69, 0x6d,
	0x65, 0x22, 0x83, 0x01, 0x0a, 0x0c, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x23, 0x0a, 0x0c, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x70, 0x6c, 0x69,
	0x6e, 0x6b, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x41, 0x0a, 0x05, 0x66, 0x69, 0x78, 0x65, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41,
	0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x48, 0x00, 0x52, 0x05, 0x66, 0x69, 0x78, 0x65, 0x64, 0x42, 0x0b, 0x0a, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x22, 0x8a, 0x05, 0x0a, 0x09, 0x54, 0x78, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x05, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x05, 0x63, 0x6c, 0x61,
	0x73, 0x73, 0x12, 0x43, 0x0a, 0x0e, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x52, 0x0d, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69,
	0x6e, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x73, 0x12, 0x3e, 0x0a, 0x09, 0x72, 0x78, 0x31, 0x5f, 0x64,
	0x65, 0x6c, 0x61, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x78, 0x44, 0x65,
	0x6c, 0x61, 0x79, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x72,
	0x78, 0x31, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x3c, 0x0a, 0x0d, 0x72, 0x78, 0x31, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x72, 0x78, 0x31, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x78, 0x31, 0x5f, 0x66, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x72, 0x78,
	0x31, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x3c, 0x0a, 0x0d, 0x72, 0x78,
	0x32, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x72, 0x78, 0x32,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x78, 0x32, 0x5f,
	0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0c, 0x72, 0x78, 0x32, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x48, 0x0a,
	0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x54, 0x78, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x70,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x3f, 0x0a, 0x0d, 0x61, 0x62, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x61, 0x62, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x11, 0x66, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x40, 0x52, 0x0f, 0x66, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x6c, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x33, 0x0a,
	0x08, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x18, 0x63, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x08, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63,
	0x65, 0x64, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x4a, 0x04, 0x08, 0x06, 0x10, 0x07, 0x4a, 0x04,
	0x08, 0x0b, 0x10, 0x0c, 0x22, 0xe9, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x4f, 0x0a, 0x0a, 0x61,
	0x63, 0x6b, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x41, 0x63,
	0x6b, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x09, 0x61, 0x63, 0x6b, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x4f, 0x0a, 0x0f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0d,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x27, 0x0a,
	0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04,
	0x42, 0x09, 0xfa, 0x42, 0x06, 0x32, 0x04, 0x28, 0xa0, 0x8d, 0x06, 0x52, 0x09, 0x66, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01,
	0x22, 0x9f, 0x01, 0x0a, 0x18, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x4f, 0x0a,
	0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x28,
	0x0a, 0x0b, 0x72, 0x65, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x18, 0x3e, 0x52, 0x0a, 0x72, 0x65,
	0x6c, 0x6f, 0x61, 0x64, 0x52, 0x61, 0x74, 0x65, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01,
	0x10, 0x01, 0x22, 0x99, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x46, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x4f, 0x0a, 0x0b, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x52, 0x65, 0x6c, 0x61, 0x79, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x53, 0x69, 0x7a, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x28, 0x0a, 0x0b, 0x72, 0x65,
	0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42,
	0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x18, 0x7e, 0x52, 0x0a, 0x72, 0x65, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x61, 0x74, 0x65, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0x24,
	0x0a, 0x18, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04,
	0x08, 0x01, 0x10, 0x01, 0x22, 0x84, 0x01, 0x0a, 0x19, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x5d, 0x0a, 0x12, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x10, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0x28, 0x0a, 0x1c, 0x52,
	0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x3a, 0x08, 0xf2, 0xaa, 0x19,
	0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0xe5, 0x5b, 0x0a, 0x0a, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x12, 0x42, 0x0a, 0x03, 0x63, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x42, 0x0a, 0xfa, 0x42, 0x07, 0x82, 0x01, 0x04, 0x10,
	0x01, 0x20, 0x00, 0x52, 0x03, 0x63, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0b, 0x72, 0x61, 0x77, 0x5f,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52,
	0x0a, 0x72, 0x61, 0x77, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x42, 0x0a, 0x09, 0x72,
	0x65, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x74,
	0x49, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x08, 0x72, 0x65, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x64, 0x12,
	0x45, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e,
	0x52, 0x65, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x48, 0x00, 0x52, 0x09, 0x72, 0x65, 0x73,
	0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x12, 0x4f, 0x0a, 0x0e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x5f, 0x61, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x41, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x6c, 0x69, 0x6e, 0x6b, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x41, 0x6e, 0x73, 0x12, 0x49, 0x0a, 0x0c, 0x6c, 0x69, 0x6e, 0x6b, 0x5f,
	0x61, 0x64, 0x72, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d,
	0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x41, 0x44,
	0x52, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x0a, 0x6c, 0x69, 0x6e, 0x6b, 0x41, 0x64, 0x72, 0x52,
	0x65, 0x71, 0x12, 0x49, 0x0a, 0x0c, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x61, 0x64, 0x72, 0x5f, 0x61,
	0x6e, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x41, 0x44, 0x52, 0x41, 0x6e, 0x73, 0x48,
	0x00, 0x52, 0x0a, 0x6c, 0x69, 0x6e, 0x6b, 0x41, 0x64, 0x72, 0x41, 0x6e, 0x73, 0x12, 0x4f, 0x0a,
	0x0e, 0x64, 0x75, 0x74, 0x79, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x2e, 0x44, 0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x48, 0x00,
	0x52, 0x0c, 0x64, 0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x12, 0x59,
	0x0a, 0x12, 0x72, 0x78, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x73, 0x65, 0x74, 0x75, 0x70,
	0x5f, 0x72, 0x65, 0x71, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x78, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x65,
	0x74, 0x75, 0x70, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x0f, 0x72, 0x78, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x53, 0x65, 0x74, 0x75, 0x70, 0x52, 0x65, 0x71, 0x12, 0x59, 0x0a, 0x12, 0x72, 0x78, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x73, 0x65, 0x74, 0x75, 0x70, 0x5f, 0x61, 0x6e, 0x73, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x2e, 0x52, 0x78, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x75, 0x70, 0x41, 0x6e,
	0x73, 0x48, 0x00, 0x52, 0x0f, 0x72, 0x78, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x75,
	0x70, 0x41, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x0e, 0x64, 0x65, 0x76, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x5f, 0x61, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41,
	0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x44, 0x65, 0x76, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x41, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x64, 0x65, 0x76, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x41, 0x6e, 0x73, 0x12, 0x52, 0x0a, 0x0f, 0x6e, 0x65, 0x77, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x4e, 0x65, 0x77, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x0d, 0x6e, 0x65, 0x77, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x12, 0x52, 0x0a, 0x0f, 0x6e, 0x65, 0x77,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x61, 0x6e, 0x73, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x4e,
	0x65, 0x77, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x41, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0d,
	0x6e, 0x65, 0x77, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x41, 0x6e, 0x73, 0x12, 0x4f, 0x0a,
	0x0e, 0x64, 0x6c, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x2e, 0x44, 0x4c, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x48, 0x00,
	0x52, 0x0c, 0x64, 0x6c, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x12, 0x4f,
	0x0a, 0x0e, 0x64, 0x6c, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x61, 0x6e, 0x73,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x2e, 0x44, 0x4c, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x41, 0x6e, 0x73, 0x48,
	0x00, 0x52, 0x0c, 0x64, 0x6c, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x41, 0x6e, 0x73, 0x12,
	0x5c, 0x0a, 0x13, 0x72, 0x78, 0x5f, 0x74, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74,
	0x75, 0x70, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41,
	0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x78, 0x54, 0x69, 0x6d, 0x69, 0x6e,
	0x67, 0x53, 0x65, 0x74, 0x75, 0x70, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x10, 0x72, 0x78, 0x54,
	0x69, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x75, 0x70, 0x52, 0x65, 0x71, 0x12, 0x59, 0x0a,
	0x12, 0x74, 0x78, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x73, 0x65, 0x74, 0x75, 0x70, 0x5f,
	0x72, 0x65, 0x71, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x54, 0x78, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x65, 0x74,
	0x75, 0x70, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x0f, 0x74, 0x78, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x53, 0x65, 0x74, 0x75, 0x70, 0x52, 0x65, 0x71, 0x12, 0x42, 0x0a, 0x09, 0x72, 0x65, 0x6b, 0x65,
	0x79, 0x5f, 0x69, 0x6e, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x6b, 0x65, 0x79, 0x49, 0x6e, 0x64,
	0x48, 0x00, 0x52, 0x08, 0x72, 0x65, 0x6b, 0x65, 0x79, 0x49, 0x6e, 0x64, 0x12, 0x45, 0x0a, 0x0a,
	0x72, 0x65, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x6b,
	0x65, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x48, 0x00, 0x52, 0x09, 0x72, 0x65, 0x6b, 0x65, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x12, 0x5c, 0x0a, 0x13, 0x61, 0x64, 0x72, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x5f, 0x73, 0x65, 0x74, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x41, 0x44, 0x52,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x75, 0x70, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52,
	0x10, 0x61, 0x64, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x75, 0x70, 0x52, 0x65,
	0x71, 0x12, 0x52, 0x0a, 0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x61, 0x6e, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x41, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x41, 0x6e, 0x73, 0x12, 0x55, 0x0a, 0x10, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x72,
	0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x46, 0x6f, 0x72, 0x63,
	0x65, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x0e, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x12, 0x65, 0x0a, 0x16,
	0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x73, 0x65, 0x74,
	0x75, 0x70, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41,
	0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x75, 0x70, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x13,
	0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x75, 0x70,
	0x52, 0x65, 0x71, 0x12, 0x65, 0x0a, 0x16, 0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x5f, 0x73, 0x65, 0x74, 0x75, 0x70, 0x5f, 0x61, 0x6e, 0x73, 0x18, 0x18, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e,
	0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x75, 0x70,
	0x41, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x13, 0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x53, 0x65, 0x74, 0x75, 0x70, 0x41, 0x6e, 0x73, 0x12, 0x59, 0x0a, 0x12, 0x70, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x72, 0x65, 0x71,
	0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x2e, 0x50, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x65, 0x71, 0x48, 0x00, 0x52, 0x0f, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x65, 0x71, 0x12, 0x62, 0x0a, 0x15, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6c,
	0x6f, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x1a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x2e, 0x50, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x12, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x12, 0x62, 0x0a, 0x15, 0x70, 0x69, 0x6e,
	0x67, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x61,
	0x6e, 0x73, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x50, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x41, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x12, 0x70, 0x69, 0x6e, 0x67, 0x53,
	0x6c, 0x6f, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x41, 0x6e, 0x73, 0x12, 0x58, 0x0a,
	0x11, 0x62, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x61,
	0x6e, 0x73, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x42, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x69, 0x6e,
	0x67, 0x41, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x62, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x54, 0x69,
	0x6d, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x73, 0x12, 0x52, 0x0a, 0x0f, 0x62, 0x65, 0x61, 0x63, 0x6f,
	0x6e, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x42, 0x65, 0x61,
	0x63, 0x6f, 0x6e, 0x46, 0x72, 0x65, 0x71, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x0d, 0x62, 0x65,
	0x61, 0x63, 0x6f, 0x6e, 0x46, 0x72, 0x65, 0x71, 0x52, 0x65, 0x71, 0x12, 0x52, 0x0a, 0x0f, 0x62,
	0x65, 0x61, 0x63, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x5f, 0x61, 0x6e, 0x73, 0x18, 0x1e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x2e, 0x42, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x46, 0x72, 0x65, 0x71, 0x41, 0x6e, 0x73, 0x48, 0x00,
	0x52, 0x0d, 0x62, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x46, 0x72, 0x65, 0x71, 0x41, 0x6e, 0x73, 0x12,
	0x52, 0x0a, 0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x5f, 0x69,
	0x6e, 0x64, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x49,
	0x6e, 0x64, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x49, 0x6e, 0x64, 0x12, 0x55, 0x0a, 0x10, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d,
	0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x48, 0x00, 0x52, 0x0e, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x12, 0x4f, 0x0a, 0x0e, 0x72, 0x65,
	0x6c, 0x61, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x21, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52,
	0x65, 0x6c, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x0c, 0x72,
	0x65, 0x6c, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x52, 0x65, 0x71, 0x12, 0x4f, 0x0a, 0x0e, 0x72,
	0x65, 0x6c, 0x61, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x5f, 0x61, 0x6e, 0x73, 0x18, 0x22, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e,
	0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x41, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0c,
	0x72, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x41, 0x6e, 0x73, 0x12, 0x6c, 0x0a, 0x19,
	0x72, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x6c, 0x61,
	0x79, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x52, 0x65,
	0x71, 0x48, 0x00, 0x52, 0x15, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x52, 0x65, 0x71, 0x12, 0x6c, 0x0a, 0x19, 0x72, 0x65,
	0x6c, 0x61, 0x79, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x5f, 0x61, 0x6e, 0x73, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d,
	0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x45,
	0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x41, 0x6e, 0x73, 0x48,
	0x00, 0x52, 0x15, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x41, 0x6e, 0x73, 0x12, 0x75, 0x0a, 0x1c, 0x72, 0x65, 0x6c, 0x61,
	0x79, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f,
	0x6c, 0x69, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x18, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x12,
	0x75, 0x0a, 0x1c, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x61, 0x6e, 0x73, 0x18,
	0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x18, 0x72, 0x65,
	0x6c, 0x61, 0x79, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x12, 0x6f, 0x0a, 0x1a, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x5f,
	0x63, 0x74, 0x72, 0x6c, 0x5f, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6c, 0x69, 0x73, 0x74,
	0x5f, 0x72, 0x65, 0x71, 0x18, 0x29, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x74, 0x72, 0x6c,
	0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52,
	0x16, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x74, 0x72, 0x6c, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x12, 0x6f, 0x0a, 0x1a, 0x72, 0x65, 0x6c, 0x61, 0x79,
	0x5f, 0x63, 0x74, 0x72, 0x6c, 0x5f, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6c, 0x69, 0x73,
	0x74, 0x5f, 0x61, 0x6e, 0x73, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x74, 0x72,
	0x6c, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x48, 0x00,
	0x52, 0x16, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x74, 0x72, 0x6c, 0x55, 0x70, 0x6c, 0x69, 0x6e,
	0x6b, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x12, 0x78, 0x0a, 0x1d, 0x72, 0x65, 0x6c, 0x61,
	0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x5f, 0x66, 0x77, 0x64, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x2b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x6c, 0x61,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x46, 0x77, 0x64, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x19, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x46, 0x77, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x52,
	0x65, 0x71, 0x12, 0x78, 0x0a, 0x1d, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x65, 0x5f, 0x66, 0x77, 0x64, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f,
	0x61, 0x6e, 0x73, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x65, 0x46, 0x77, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x41, 0x6e, 0x73, 0x48,
	0x00, 0x52, 0x19, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x65, 0x46, 0x77, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x41, 0x6e, 0x73, 0x12, 0x7c, 0x0a, 0x1f,
	0x72, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x6e, 0x65, 0x77,
	0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x18,
	0x2d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x4e, 0x65, 0x77,
	0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x1a,
	0x72, 0x65, 0x6c, 0x61, 0x79, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x4e, 0x65, 0x77, 0x45, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x1a, 0x52, 0x0a, 0x08, 0x52, 0x65,
	0x73, 0x65, 0x74, 0x49, 0x6e, 0x64, 0x12, 0x46, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d,
	0x69, 0x6e, 0x6f, 0x72, 0x42, 0x0a, 0xfa, 0x42, 0x07, 0x82, 0x01, 0x04, 0x10, 0x01, 0x18, 0x01,
	0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x53,
	0x0a, 0x09, 0x52, 0x65, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x12, 0x46, 0x0a, 0x0d, 0x6d,
	0x69, 0x6e, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x15, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x69, 0x6e, 0x6f, 0x72, 0x42, 0x0a, 0xfa, 0x42, 0x07, 0x82, 0x01,
	0x04, 0x10, 0x01, 0x18, 0x01, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x1a, 0x5f, 0x0a, 0x0c, 0x4c, 0x69, 0x6e, 0x6b, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x41, 0x6e, 0x73, 0x12, 0x20, 0x0a, 0x06, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xfe, 0x01, 0x52, 0x06, 0x6d,
	0x61, 0x72, 0x67, 0x69, 0x6e, 0x12, 0x2d, 0x0a, 0x0d, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x2a, 0x03, 0x18, 0xff, 0x01, 0x52, 0x0c, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x9e, 0x02, 0x0a, 0x0a, 0x4c, 0x69, 0x6e, 0x6b, 0x41, 0x44, 0x52,
	0x52, 0x65, 0x71, 0x12, 0x4f, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x12, 0x2d, 0x0a, 0x0e, 0x74, 0x78, 0x5f, 0x70, 0x6f, 0x77, 0x65, 0x72,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42,
	0x04, 0x2a, 0x02, 0x18, 0x0f, 0x52, 0x0c, 0x74, 0x78, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x2b, 0x0a, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x03, 0x28, 0x08, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01,
	0x02, 0x10, 0x10, 0x52, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4d, 0x61, 0x73, 0x6b,
	0x12, 0x39, 0x0a, 0x14, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07,
	0xfa, 0x42, 0x04, 0x2a, 0x02, 0x18, 0x07, 0x52, 0x12, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x4d, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x22, 0x0a, 0x08, 0x6e,
	0x62, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa,
	0x42, 0x04, 0x2a, 0x02, 0x18, 0x0f, 0x52, 0x07, 0x6e, 0x62, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x4a,
	0x04, 0x08, 0x04, 0x10, 0x05, 0x1a, 0x92, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x6e, 0x6b, 0x41, 0x44,
	0x52, 0x41, 0x6e, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4d, 0x61, 0x73, 0x6b, 0x41, 0x63, 0x6b, 0x12, 0x2d,
	0x0a, 0x13, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x63, 0x6b, 0x12, 0x2b, 0x0a,
	0x12, 0x74, 0x78, 0x5f, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f,
	0x61, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x74, 0x78, 0x50, 0x6f, 0x77,
	0x65, 0x72, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x63, 0x6b, 0x1a, 0x63, 0x0a, 0x0c, 0x44, 0x75,
	0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x12, 0x53, 0x0a, 0x0e, 0x6d, 0x61,
	0x78, 0x5f, 0x64, 0x75, 0x74, 0x79, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x44, 0x75,
	0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x44, 0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x1a,
	0xf4, 0x01, 0x0a, 0x0f, 0x52, 0x78, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x75, 0x70,
	0x52, 0x65, 0x71, 0x12, 0x56, 0x0a, 0x13, 0x72, 0x78, 0x32, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x10, 0x72, 0x78, 0x32, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x59, 0x0a, 0x14, 0x72,
	0x78, 0x31, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x61, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x11, 0x72, 0x78, 0x31, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65,
	0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x2e, 0x0a, 0x0d, 0x72, 0x78, 0x32, 0x5f, 0x66, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x42, 0x09, 0xfa,
	0x42, 0x06, 0x32, 0x04, 0x28, 0xa0, 0x8d, 0x06, 0x52, 0x0c, 0x72, 0x78, 0x32, 0x46, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x1a, 0xab, 0x01, 0x0a, 0x0f, 0x52, 0x78, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x53, 0x65, 0x74, 0x75, 0x70, 0x41, 0x6e, 0x73, 0x12, 0x34, 0x0a, 0x17, 0x72, 0x78,
	0x32, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x72, 0x78, 0x32,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x63, 0x6b,
	0x12, 0x36, 0x0a, 0x18, 0x72, 0x78, 0x31, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x14, 0x72, 0x78, 0x31, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x4f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x41, 0x63, 0x6b, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x78, 0x32, 0x5f,
	0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0f, 0x72, 0x78, 0x32, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x41, 0x63, 0x6b, 0x1a, 0x5e, 0x0a, 0x0c, 0x44, 0x65, 0x76, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x41, 0x6e, 0x73, 0x12, 0x22, 0x0a, 0x07, 0x62, 0x61, 0x74, 0x74, 0x65, 0x72, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xff, 0x01, 0x52,
	0x07, 0x62, 0x61, 0x74, 0x74, 0x65, 0x72, 0x79, 0x12, 0x2a, 0x0a, 0x06, 0x6d, 0x61, 0x72, 0x67,
	0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x12, 0xfa, 0x42, 0x0f, 0x1a, 0x0d, 0x18,
	0x1f, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x52, 0x06, 0x6d, 0x61,
	0x72, 0x67, 0x69, 0x6e, 0x1a, 0x99, 0x02, 0x0a, 0x0d, 0x4e, 0x65, 0x77, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x12, 0x2d, 0x0a, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x2a, 0x03, 0x18, 0xff, 0x01, 0x52, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x29, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x32, 0x06, 0x18,
	0x00, 0x28, 0xa0, 0x8d, 0x06, 0x52, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x12, 0x56, 0x0a, 0x13, 0x6d, 0x69, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74,
	0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x10, 0x6d, 0x69, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x56, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x10,
	0x6d, 0x61, 0x78, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x1a, 0x58, 0x0a, 0x0d, 0x4e, 0x65, 0x77, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x41, 0x6e,
	0x73, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x61,
	0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x41, 0x63, 0x6b, 0x12, 0x22, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x41, 0x63, 0x6b, 0x1a, 0x66, 0x0a, 0x0c, 0x44, 0x4c,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x12, 0x2d, 0x0a, 0x0d, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xff, 0x01, 0x52, 0x0c, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x27, 0x0a, 0x09, 0x66, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x42, 0x09, 0xfa, 0x42,
	0x06, 0x32, 0x04, 0x28, 0xa0, 0x8d, 0x06, 0x52, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x1a, 0x5f, 0x0a, 0x0c, 0x44, 0x4c, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x41,
	0x6e, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x63, 0x6b, 0x12, 0x23,
	0x0a, 0x0d, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x61, 0x63, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x41, 0x63, 0x6b, 0x1a, 0x4b, 0x0a, 0x10, 0x52, 0x78, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x53,
	0x65, 0x74, 0x75, 0x70, 0x52, 0x65, 0x71, 0x12, 0x37, 0x0a, 0x05, 0x64, 0x65, 0x6c, 0x61, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x78, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x64, 0x65, 0x6c, 0x61, 0x79,
	0x1a, 0xb9, 0x01, 0x0a, 0x0f, 0x54, 0x78, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x75,
	0x70, 0x52, 0x65, 0x71, 0x12, 0x4a, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x69, 0x72, 0x70,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x45, 0x49, 0x52, 0x50, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x45, 0x69, 0x72, 0x70, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x2a, 0x0a, 0x11, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x64, 0x77, 0x65, 0x6c, 0x6c,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x75, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x44, 0x77, 0x65, 0x6c, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x13,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x64, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c,
	0x69, 0x6e, 0x6b, 0x44, 0x77, 0x65, 0x6c, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x50, 0x0a, 0x08,
	0x52, 0x65, 0x6b, 0x65, 0x79, 0x49, 0x6e, 0x64, 0x12, 0x44, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x6f,
	0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x15, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4d, 0x69, 0x6e, 0x6f, 0x72, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x51,
	0x0a, 0x09, 0x52, 0x65, 0x6b, 0x65, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x12, 0x44, 0x0a, 0x0d, 0x6d,
	0x69, 0x6e, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x15, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x69, 0x6e, 0x6f, 0x72, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x1a, 0xda, 0x01, 0x0a, 0x10, 0x41, 0x44, 0x52, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x65,
	0x74, 0x75, 0x70, 0x52, 0x65, 0x71, 0x12, 0x62, 0x0a, 0x16, 0x61, 0x64, 0x72, 0x5f, 0x61, 0x63,
	0x6b, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x41, 0x63, 0x6b, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x13, 0x61, 0x64, 0x72, 0x41, 0x63, 0x6b, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x62, 0x0a, 0x16, 0x61, 0x64,
	0x72, 0x5f, 0x61, 0x63, 0x6b, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x41,
	0x63, 0x6b, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x13, 0x61, 0x64, 0x72, 0x41, 0x63,
	0x6b, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x1a, 0x49,
	0x0a, 0x0d, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x41, 0x6e, 0x73, 0x12,
	0x38, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x08, 0xfa, 0x42, 0x05, 0xb2, 0x01,
	0x02, 0x08, 0x01, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x1a, 0xb2, 0x02, 0x0a, 0x0e, 0x46, 0x6f,
	0x72, 0x63, 0x65, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x12, 0x4c, 0x0a, 0x0b,
	0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x21, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a,
	0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4f, 0x0a, 0x0f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0d, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x28, 0x0a, 0x0b, 0x6d,
	0x61, 0x78, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d,
	0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x18, 0x07, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65,
	0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x0f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f,
	0x65, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x45, 0x78, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0e,
	0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x1a, 0xcc,
	0x01, 0x0a, 0x13, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x65,
	0x74, 0x75, 0x70, 0x52, 0x65, 0x71, 0x12, 0x5b, 0x0a, 0x12, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x45,
	0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x10, 0x6d, 0x61, 0x78, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x78, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x12, 0x58, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x65, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0f, 0x6d, 0x61,
	0x78, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x1a, 0x48, 0x0a,
	0x13, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x75,
	0x70, 0x41, 0x6e, 0x73, 0x12, 0x31, 0x0a, 0x15, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x65, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x12, 0x6d, 0x61, 0x78, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x78, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x6b, 0x1a, 0x53, 0x0a, 0x0f, 0x50, 0x69, 0x6e, 0x67, 0x53,
	0x6c, 0x6f, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x69, 0x6e, 0x67,
	0x53, 0x6c, 0x6f, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x06, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x1a, 0x90, 0x01, 0x0a,
	0x12, 0x50, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x52, 0x65, 0x71, 0x12, 0x29, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x32, 0x06, 0x18, 0x00, 0x28,
	0xa0, 0x8d, 0x06, 0x52, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x4f,
	0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x1a,
	0x68, 0x0a, 0x12, 0x50, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x41, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x66, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x41, 0x63, 0x6b, 0x12, 0x2d, 0x0a, 0x13, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x61, 0x63,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x63, 0x6b, 0x1a, 0x61, 0x0a, 0x0f, 0x42, 0x65, 0x61,
	0x63, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x05,
	0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x09, 0xfa, 0x42, 0x06,
	0x2a, 0x04, 0x18, 0xff, 0xff, 0x03, 0x52, 0x05, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x2d, 0x0a,
	0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xff, 0x01, 0x52, 0x0c,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x1a, 0x3a, 0x0a, 0x0d,
	0x42, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x46, 0x72, 0x65, 0x71, 0x52, 0x65, 0x71, 0x12, 0x29, 0x0a,
	0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04,
	0x42, 0x0b, 0xfa, 0x42, 0x08, 0x32, 0x06, 0x18, 0x00, 0x28, 0xa0, 0x8d, 0x06, 0x52, 0x09, 0x66,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x1a, 0x34, 0x0a, 0x0d, 0x42, 0x65, 0x61, 0x63,
	0x6f, 0x6e, 0x46, 0x72, 0x65, 0x71, 0x41, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x41, 0x63, 0x6b, 0x1a, 0x46,
	0x0a, 0x0d, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x64, 0x12,
	0x35, 0x0a, 0x05, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x05, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x1a, 0x47, 0x0a, 0x0e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x12, 0x35, 0x0a, 0x05, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x1a,
	0xde, 0x02, 0x0a, 0x0c, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x52, 0x65, 0x71,
	0x12, 0x5b, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x52, 0x65, 0x71,
	0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xf0, 0x01,
	0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x49, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x0d, 0x73, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x3c, 0x0a, 0x15, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03,
	0x18, 0xff, 0x01, 0x52, 0x13, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x56, 0x0a, 0x0f, 0x63, 0x61, 0x64, 0x5f,
	0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x41, 0x44, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x0e, 0x63, 0x61, 0x64, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74, 0x79,
	0x1a, 0x80, 0x03, 0x0a, 0x0c, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x41, 0x6e,
	0x73, 0x12, 0x3f, 0x0a, 0x1c, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x61, 0x63,
	0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x41,
	0x63, 0x6b, 0x12, 0x40, 0x0a, 0x1d, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x61, 0x63, 0x6b, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x5f,
	0x61, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x73, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x41, 0x63, 0x6b, 0x4f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x41, 0x63, 0x6b, 0x12, 0x49, 0x0a, 0x22, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x1d, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x63, 0x6b, 0x12,
	0x37, 0x0a, 0x18, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x15, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x63, 0x6b, 0x12, 0x39, 0x0a, 0x19, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x41, 0x63, 0x6b, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x61, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x11, 0x63, 0x61, 0x64, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74, 0x79,
	0x41, 0x63, 0x6b, 0x1a, 0xce, 0x04, 0x0a, 0x15, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e, 0x64,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x52, 0x65, 0x71, 0x12, 0x64, 0x0a,
	0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x52, 0x65, 0x71, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0xce, 0x03, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x06, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e, 0x64, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x48,
	0x00, 0x52, 0x06, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x12, 0x45, 0x0a, 0x07, 0x64, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61,
	0x79, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x07, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63,
	0x12, 0x62, 0x0a, 0x15, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52,
	0x13, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x18, 0x3f, 0x52, 0x07,
	0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x12, 0x49, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x12, 0x53, 0x0a, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa,
	0x42, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39,
	0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d,
	0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x42, 0x0b, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12,
	0x03, 0xf8, 0x42, 0x01, 0x1a, 0xa2, 0x02, 0x0a, 0x15, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x41, 0x6e, 0x73, 0x12, 0x3f,
	0x0a, 0x1c, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x41, 0x63, 0x6b, 0x12,
	0x49, 0x0a, 0x22, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1d, 0x73, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x63, 0x6b, 0x12, 0x37, 0x0a, 0x18, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x41, 0x63, 0x6b, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x5f, 0x61,
	0x63, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66,
	0x66, 0x41, 0x63, 0x6b, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x52, 0x1d, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x61, 0x63, 0x6b, 0x5f, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x5f, 0x61, 0x63, 0x6b, 0x1a, 0x9b, 0x08, 0x0a, 0x18, 0x52, 0x65,
	0x6c, 0x61, 0x79, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x12, 0x26, 0x0a, 0x0a, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a,
	0x02, 0x18, 0x0f, 0x52, 0x09, 0x72, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x4f,
	0x0a, 0x0e, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73,
	0x52, 0x0d, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12,
	0xed, 0x02, 0x0a, 0x08, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0c, 0x42, 0xd1, 0x02, 0x92, 0x41, 0x19, 0x4a, 0x0a, 0x22, 0x32, 0x36, 0x30, 0x30, 0x41,
	0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x04, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a,
	0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x34, 0x42, 0x79, 0x74, 0x65,
	0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d,
	0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x34, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d,
	0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63,
	0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x07, 0x64, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x12,
	0x16, 0x0a, 0x07, 0x77, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x05, 0x77, 0x46, 0x43, 0x6e, 0x74, 0x12, 0x91, 0x03, 0x0a, 0x0e, 0x72, 0x6f, 0x6f, 0x74,
	0x5f, 0x77, 0x6f, 0x72, 0x5f, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c,
	0x42, 0xeb, 0x02, 0x92, 0x41, 0x31, 0x4a, 0x22, 0x22, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
	0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
	0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02,
	0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x10, 0x70, 0x01,
	0xea, 0xaa, 0x19, 0x83, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45,
	0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x40, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b,
	0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61,
	0x6c, 0x31, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa1, 0x01, 0x1a, 0x4f, 0x67,
	0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d,
	0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e,
	0x4e, 0x65, 0x77, 0x31, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e,
	0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77,
	0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73,
	0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x0b,
	0x72, 0x6f, 0x6f, 0x74, 0x57, 0x6f, 0x72, 0x53, 0x4b, 0x65, 0x79, 0x12, 0x44, 0x0a, 0x09, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27,
	0xfa, 0x42, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d,
	0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39,
	0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x08, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49,
	0x64, 0x12, 0x24, 0x0a, 0x0e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x1a, 0x1a, 0x0a, 0x18, 0x52, 0x65, 0x6c, 0x61, 0x79,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x6e, 0x73, 0x1a, 0x83, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x74, 0x72,
	0x6c, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x12, 0x26,
	0x0a, 0x0a, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x18, 0x0f, 0x52, 0x09, 0x72, 0x75, 0x6c,
	0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x41, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x74, 0x72,
	0x6c, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x56, 0x0a, 0x16, 0x52, 0x65, 0x6c,
	0x61, 0x79, 0x43, 0x74, 0x72, 0x6c, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x6e, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x72, 0x75, 0x6c,
	0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x63, 0x6b, 0x12, 0x16, 0x0a, 0x07, 0x77, 0x5f, 0x66,
	0x5f, 0x63, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x77, 0x46, 0x43, 0x6e,
	0x74, 0x1a, 0xb1, 0x03, 0x0a, 0x19, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x65, 0x46, 0x77, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x12,
	0x56, 0x0a, 0x13, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65,
	0x6c, 0x61, 0x79, 0x52, 0x65, 0x73, 0x65, 0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x65, 0x72, 0x52, 0x11, 0x72, 0x65, 0x73, 0x65, 0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x52, 0x0a, 0x13, 0x6a, 0x6f, 0x69, 0x6e, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x46, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x11, 0x6a, 0x6f, 0x69, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x47, 0x0a, 0x0d, 0x6e,
	0x6f, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x73, 0x12, 0x54, 0x0a, 0x14, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x75,
	0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x12, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x55, 0x70,
	0x6c, 0x69, 0x6e, 0x6b, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x49, 0x0a, 0x0e, 0x6f, 0x76,
	0x65, 0x72, 0x61, 0x6c, 0x6c, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0d, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x1a, 0x1b, 0x0a, 0x19, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x46, 0x77, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x41,
	0x6e, 0x73, 0x1a, 0xe3, 0x03, 0x0a, 0x1a, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x79, 0x4e, 0x65, 0x77, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x12, 0xed, 0x02, 0x0a, 0x08, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x42, 0xd1, 0x02, 0x92, 0x41, 0x19, 0x4a, 0x0a, 0x22, 0x32, 0x36, 0x30,
	0x30, 0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x04, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82,
	0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x34, 0x42, 0x79,
	0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65,
	0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f,
	0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x34, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65,
	0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f,
	0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78,
	0x61, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x07, 0x64, 0x65, 0x76, 0x41, 0x64, 0x64,
	0x72, 0x12, 0x24, 0x0a, 0x03, 0x73, 0x6e, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x12,
	0xfa, 0x42, 0x0f, 0x1a, 0x0d, 0x18, 0x0b, 0x28, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x01, 0x52, 0x03, 0x73, 0x6e, 0x72, 0x12, 0x2f, 0x0a, 0x04, 0x72, 0x73, 0x73, 0x69, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x1b, 0xfa, 0x42, 0x18, 0x1a, 0x16, 0x18, 0xf1, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x28, 0xf2, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x01, 0x52, 0x04, 0x72, 0x73, 0x73, 0x69, 0x42, 0x09, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x4a, 0x04, 0x08, 0x25, 0x10, 0x26, 0x4a, 0x04, 0x08, 0x26, 0x10, 0x27, 0x52,
	0x15, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x6c, 0x69,
	0x73, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x52, 0x15, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x61, 0x6e, 0x73, 0x22, 0x45, 0x0a,
	0x0b, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x12, 0x36, 0x0a, 0x08,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x22, 0x43, 0x0a, 0x0e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x04, 0x42, 0x09, 0xfa, 0x42, 0x06, 0x32, 0x04, 0x28, 0xa0, 0x8d, 0x06,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x10, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0xf2,
	0xaa, 0x19, 0x06, 0x08, 0x01, 0x10, 0x01, 0x18, 0x01, 0x22, 0x4d, 0x0a, 0x16, 0x5a, 0x65, 0x72,
	0x6f, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x04, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x32, 0x06, 0x18, 0x00, 0x28, 0xa0, 0x8d, 0x06, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x10, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0xf2, 0xaa,
	0x19, 0x06, 0x08, 0x01, 0x10, 0x01, 0x18, 0x01, 0x22, 0x67, 0x0a, 0x13, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x61, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x3e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x10, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0xf2, 0xaa, 0x19, 0x06, 0x08, 0x01, 0x10, 0x01, 0x18,
	0x01, 0x22, 0x65, 0x0a, 0x12, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x10, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0xf2, 0xaa,
	0x19, 0x06, 0x08, 0x01, 0x10, 0x01, 0x18, 0x01, 0x22, 0x67, 0x0a, 0x13, 0x50, 0x69, 0x6e, 0x67,
	0x53, 0x6c, 0x6f, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x3e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x50, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x10, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0xf2, 0xaa, 0x19, 0x06, 0x08, 0x01, 0x10, 0x01, 0x18,
	0x01, 0x22, 0x71, 0x0a, 0x18, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x44,
	0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x43, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x44, 0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c,
	0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x10, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0xf2, 0xaa, 0x19, 0x06, 0x08, 0x01,
	0x10, 0x01, 0x18, 0x01, 0x22, 0x59, 0x0a, 0x0c, 0x52, 0x78, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x37, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x78, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x10, 0xea,
	0xaa, 0x19, 0x02, 0x18, 0x01, 0xf2, 0xaa, 0x19, 0x06, 0x08, 0x01, 0x10, 0x01, 0x18, 0x01, 0x22,
	0x71, 0x0a, 0x18, 0x41, 0x44, 0x52, 0x41, 0x63, 0x6b, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x45, 0x78,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x43, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x41,
	0x63, 0x6b, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x10, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0xf2, 0xaa, 0x19, 0x06, 0x08, 0x01, 0x10, 0x01,
	0x18, 0x01, 0x22, 0x71, 0x0a, 0x18, 0x41, 0x44, 0x52, 0x41, 0x63, 0x6b, 0x44, 0x65, 0x6c, 0x61,
	0x79, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x43,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41,
	0x44, 0x52, 0x41, 0x63, 0x6b, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x10, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0xf2, 0xaa, 0x19, 0x06, 0x08,
	0x01, 0x10, 0x01, 0x18, 0x01, 0x22, 0x5f, 0x0a, 0x0f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x45,
	0x49, 0x52, 0x50, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x45,
	0x49, 0x52, 0x50, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x10, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0xf2, 0xaa, 0x19, 0x06,
	0x08, 0x01, 0x10, 0x01, 0x18, 0x01, 0x22, 0xcf, 0x02, 0x0a, 0x15, 0x52, 0x65, 0x6c, 0x61, 0x79,
	0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x12, 0x3f, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74,
	0x65, 0x12, 0x24, 0x0a, 0x03, 0x73, 0x6e, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x12,
	0xfa, 0x42, 0x0f, 0x1a, 0x0d, 0x18, 0x0b, 0x28, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x01, 0x52, 0x03, 0x73, 0x6e, 0x72, 0x12, 0x2f, 0x0a, 0x04, 0x72, 0x73, 0x73, 0x69, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x1b, 0xfa, 0x42, 0x18, 0x1a, 0x16, 0x18, 0xf1, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x28, 0xf2, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x01, 0x52, 0x04, 0x72, 0x73, 0x73, 0x69, 0x12, 0x4a, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x6c, 0x61, 0x79, 0x57, 0x4f, 0x52, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x27, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x42, 0x09, 0xfa, 0x42, 0x06, 0x32, 0x04, 0x28, 0xa0,
	0x8d, 0x06, 0x52, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x1f, 0x0a,
	0x0b, 0x72, 0x61, 0x77, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0a, 0x72, 0x61, 0x77, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x3a, 0x08,
	0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0x44, 0x0a, 0x17, 0x52, 0x65, 0x6c, 0x61,
	0x79, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b,
	0x52, 0x65, 0x71, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x61, 0x77, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x72, 0x61, 0x77, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0x98,
	0x01, 0x0a, 0x10, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x40, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x0a, 0x66,
	0x75, 0x6c, 0x6c, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x08, 0x66, 0x75, 0x6c, 0x6c, 0x46, 0x43, 0x6e, 0x74, 0x2a, 0xa7, 0x01, 0x0a, 0x05, 0x4d, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x0c, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x52, 0x45, 0x51, 0x55,
	0x45, 0x53, 0x54, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x41, 0x43,
	0x43, 0x45, 0x50, 0x54, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x55, 0x4e, 0x43, 0x4f, 0x4e, 0x46,
	0x49, 0x52, 0x4d, 0x45, 0x44, 0x5f, 0x55, 0x50, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x55, 0x4e,
	0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x45, 0x44, 0x5f, 0x44, 0x4f, 0x57, 0x4e, 0x10, 0x03,
	0x12, 0x10, 0x0a, 0x0c, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x45, 0x44, 0x5f, 0x55, 0x50,
	0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x45, 0x44, 0x5f,
	0x44, 0x4f, 0x57, 0x4e, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e,
	0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x06, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52,
	0x4f, 0x50, 0x52, 0x49, 0x45, 0x54, 0x41, 0x52, 0x59, 0x10, 0x07, 0x1a, 0x06, 0xea, 0xaa, 0x19,
	0x02, 0x18, 0x01, 0x2a, 0x28, 0x0a, 0x05, 0x4d, 0x61, 0x6a, 0x6f, 0x72, 0x12, 0x0e, 0x0a, 0x0a,
	0x4c, 0x4f, 0x52, 0x41, 0x57, 0x41, 0x4e, 0x5f, 0x52, 0x31, 0x10, 0x00, 0x1a, 0x0f, 0xea, 0xaa,
	0x19, 0x0b, 0x18, 0x01, 0x2a, 0x07, 0x4c, 0x4f, 0x52, 0x41, 0x57, 0x41, 0x4e, 0x2a, 0xb9, 0x02,
	0x0a, 0x0a, 0x4d, 0x41, 0x43, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0b,
	0x4d, 0x41, 0x43, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x1a, 0x0d, 0xea,
	0xaa, 0x19, 0x09, 0x12, 0x07, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x12, 0x1e, 0x0a, 0x08,
	0x4d, 0x41, 0x43, 0x5f, 0x56, 0x31, 0x5f, 0x30, 0x10, 0x01, 0x1a, 0x10, 0xea, 0xaa, 0x19, 0x0c,
	0x12, 0x03, 0x31, 0x2e, 0x30, 0x12, 0x05, 0x31, 0x2e, 0x30, 0x2e, 0x30, 0x12, 0x1b, 0x0a, 0x0a,
	0x4d, 0x41, 0x43, 0x5f, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x31, 0x10, 0x02, 0x1a, 0x0b, 0xea, 0xaa,
	0x19, 0x07, 0x12, 0x05, 0x31, 0x2e, 0x30, 0x2e, 0x31, 0x12, 0x1b, 0x0a, 0x0a, 0x4d, 0x41, 0x43,
	0x5f, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x32, 0x10, 0x03, 0x1a, 0x0b, 0xea, 0xaa, 0x19, 0x07, 0x12,
	0x05, 0x31, 0x2e, 0x30, 0x2e, 0x32, 0x12, 0x1e, 0x0a, 0x08, 0x4d, 0x41, 0x43, 0x5f, 0x56, 0x31,
	0x5f, 0x31, 0x10, 0x04, 0x1a, 0x10, 0xea, 0xaa, 0x19, 0x0c, 0x12, 0x03, 0x31, 0x2e, 0x31, 0x12,
	0x05, 0x31, 0x2e, 0x31, 0x2e, 0x30, 0x12, 0x1b, 0x0a, 0x0a, 0x4d, 0x41, 0x43, 0x5f, 0x56, 0x31,
	0x5f, 0x30, 0x5f, 0x33, 0x10, 0x05, 0x1a, 0x0b, 0xea, 0xaa, 0x19, 0x07, 0x12, 0x05, 0x31, 0x2e,
	0x30, 0x2e, 0x33, 0x12, 0x1b, 0x0a, 0x0a, 0x4d, 0x41, 0x43, 0x5f, 0x56, 0x31, 0x5f, 0x30, 0x5f,
	0x34, 0x10, 0x06, 0x1a, 0x0b, 0xea, 0xaa, 0x19, 0x07, 0x12, 0x05, 0x31, 0x2e, 0x30, 0x2e, 0x34,
	0x1a, 0x57, 0xea, 0xaa, 0x19, 0x07, 0x18, 0x01, 0x2a, 0x03, 0x4d, 0x41, 0x43, 0xf2, 0xaa, 0x19,
	0x48, 0x0a, 0x46, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e,
	0x70, 0x62, 0x2e, 0x4d, 0x41, 0x43, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x2a, 0xcb, 0x05, 0x0a, 0x0a, 0x50, 0x48,
	0x59, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0b, 0x50, 0x48, 0x59, 0x5f,
	0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x1a, 0x0d, 0xea, 0xaa, 0x19, 0x09, 0x12,
	0x07, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x12, 0x24, 0x0a, 0x08, 0x50, 0x48, 0x59, 0x5f,
	0x56, 0x31, 0x5f, 0x30, 0x10, 0x01, 0x1a, 0x16, 0xea, 0xaa, 0x19, 0x12, 0x12, 0x03, 0x31, 0x2e,
	0x30, 0x12, 0x05, 0x31, 0x2e, 0x30, 0x2e, 0x30, 0x12, 0x04, 0x56, 0x31, 0x5f, 0x30, 0x12, 0x0e,
	0x0a, 0x0a, 0x54, 0x53, 0x30, 0x30, 0x31, 0x5f, 0x56, 0x31, 0x5f, 0x30, 0x10, 0x01, 0x12, 0x23,
	0x0a, 0x0a, 0x50, 0x48, 0x59, 0x5f, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x31, 0x10, 0x02, 0x1a, 0x13,
	0xea, 0xaa, 0x19, 0x0f, 0x12, 0x05, 0x31, 0x2e, 0x30, 0x2e, 0x31, 0x12, 0x06, 0x56, 0x31, 0x5f,
	0x30, 0x5f, 0x31, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x53, 0x30, 0x30, 0x31, 0x5f, 0x56, 0x31, 0x5f,
	0x30, 0x5f, 0x31, 0x10, 0x02, 0x12, 0x40, 0x0a, 0x10, 0x50, 0x48, 0x59, 0x5f, 0x56, 0x31, 0x5f,
	0x30, 0x5f, 0x32, 0x5f, 0x52, 0x45, 0x56, 0x5f, 0x41, 0x10, 0x03, 0x1a, 0x2a, 0xea, 0xaa, 0x19,
	0x26, 0x12, 0x05, 0x31, 0x2e, 0x30, 0x2e, 0x32, 0x12, 0x07, 0x31, 0x2e, 0x30, 0x2e, 0x32, 0x2d,
	0x61, 0x12, 0x06, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x32, 0x12, 0x0c, 0x56, 0x31, 0x5f, 0x30, 0x5f,
	0x32, 0x5f, 0x52, 0x45, 0x56, 0x5f, 0x41, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x50, 0x30, 0x30, 0x31,
	0x5f, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x32, 0x10, 0x03, 0x12, 0x31, 0x0a, 0x10, 0x50, 0x48, 0x59,
	0x5f, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x32, 0x5f, 0x52, 0x45, 0x56, 0x5f, 0x42, 0x10, 0x04, 0x1a,
	0x1b, 0xea, 0xaa, 0x19, 0x17, 0x12, 0x07, 0x31, 0x2e, 0x30, 0x2e, 0x32, 0x2d, 0x62, 0x12, 0x0c,
	0x56, 0x31, 0x5f, 0x30, 0x5f, 0x32, 0x5f, 0x52, 0x45, 0x56, 0x5f, 0x42, 0x12, 0x16, 0x0a, 0x12,
	0x52, 0x50, 0x30, 0x30, 0x31, 0x5f, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x32, 0x5f, 0x52, 0x45, 0x56,
	0x5f, 0x42, 0x10, 0x04, 0x12, 0x34, 0x0a, 0x0e, 0x50, 0x48, 0x59, 0x5f, 0x56, 0x31, 0x5f, 0x31,
	0x5f, 0x52, 0x45, 0x56, 0x5f, 0x41, 0x10, 0x05, 0x1a, 0x20, 0xea, 0xaa, 0x19, 0x1c, 0x12, 0x05,
	0x31, 0x2e, 0x31, 0x2d, 0x61, 0x12, 0x07, 0x31, 0x2e, 0x31, 0x2e, 0x30, 0x2d, 0x61, 0x12, 0x0a,
	0x56, 0x31, 0x5f, 0x31, 0x5f, 0x52, 0x45, 0x56, 0x5f, 0x41, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x50,
	0x30, 0x30, 0x31, 0x5f, 0x56, 0x31, 0x5f, 0x31, 0x5f, 0x52, 0x45, 0x56, 0x5f, 0x41, 0x10, 0x05,
	0x12, 0x34, 0x0a, 0x0e, 0x50, 0x48, 0x59, 0x5f, 0x56, 0x31, 0x5f, 0x31, 0x5f, 0x52, 0x45, 0x56,
	0x5f, 0x42, 0x10, 0x06, 0x1a, 0x20, 0xea, 0xaa, 0x19, 0x1c, 0x12, 0x05, 0x31, 0x2e, 0x31, 0x2d,
	0x62, 0x12, 0x07, 0x31, 0x2e, 0x31, 0x2e, 0x30, 0x2d, 0x62, 0x12, 0x0a, 0x56, 0x31, 0x5f, 0x31,
	0x5f, 0x52, 0x45, 0x56, 0x5f, 0x42, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x50, 0x30, 0x30, 0x31, 0x5f,
	0x56, 0x31, 0x5f, 0x31, 0x5f, 0x52, 0x45, 0x56, 0x5f, 0x42, 0x10, 0x06, 0x12, 0x31, 0x0a, 0x10,
	0x50, 0x48, 0x59, 0x5f, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x33, 0x5f, 0x52, 0x45, 0x56, 0x5f, 0x41,
	0x10, 0x07, 0x1a, 0x1b, 0xea, 0xaa, 0x19, 0x17, 0x12, 0x07, 0x31, 0x2e, 0x30, 0x2e, 0x33, 0x2d,
	0x61, 0x12, 0x0c, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x33, 0x5f, 0x52, 0x45, 0x56, 0x5f, 0x41, 0x12,
	0x16, 0x0a, 0x12, 0x52, 0x50, 0x30, 0x30, 0x31, 0x5f, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x33, 0x5f,
	0x52, 0x45, 0x56, 0x5f, 0x41, 0x10, 0x07, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x50, 0x30, 0x30, 0x32,
	0x5f, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x30, 0x10, 0x08, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x50, 0x30,
	0x30, 0x32, 0x5f, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x31, 0x10, 0x09, 0x12, 0x10, 0x0a, 0x0c, 0x52,
	0x50, 0x30, 0x30, 0x32, 0x5f, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x32, 0x10, 0x0a, 0x12, 0x10, 0x0a,
	0x0c, 0x52, 0x50, 0x30, 0x30, 0x32, 0x5f, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x33, 0x10, 0x0b, 0x12,
	0x10, 0x0a, 0x0c, 0x52, 0x50, 0x30, 0x30, 0x32, 0x5f, 0x56, 0x31, 0x5f, 0x30, 0x5f, 0x34, 0x10,
	0x0c, 0x1a, 0x54, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0xf2, 0xaa, 0x19, 0x48, 0x0a, 0x46, 0x67,
	0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x2e, 0x50,
	0x48, 0x59, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x10, 0x01, 0x2a, 0x87, 0x03, 0x0a, 0x0d, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x41, 0x54,
	0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x30, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x41,
	0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x31, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x44,
	0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x32, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x33, 0x10, 0x03, 0x12, 0x0f, 0x0a,
	0x0b, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x34, 0x10, 0x04, 0x12, 0x0f,
	0x0a, 0x0b, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x35, 0x10, 0x05, 0x12,
	0x0f, 0x0a, 0x0b, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x36, 0x10, 0x06,
	0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x37, 0x10,
	0x07, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x38,
	0x10, 0x08, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f,
	0x39, 0x10, 0x09, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45,
	0x5f, 0x31, 0x30, 0x10, 0x0a, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41,
	0x54, 0x45, 0x5f, 0x31, 0x31, 0x10, 0x0b, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x41, 0x54, 0x41, 0x5f,
	0x52, 0x41, 0x54, 0x45, 0x5f, 0x31, 0x32, 0x10, 0x0c, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x41, 0x54,
	0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x31, 0x33, 0x10, 0x0d, 0x12, 0x10, 0x0a, 0x0c, 0x44,
	0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x31, 0x34, 0x10, 0x0e, 0x12, 0x10, 0x0a,
	0x0c, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x31, 0x35, 0x10, 0x0f, 0x1a,
	0x60, 0xea, 0xaa, 0x19, 0x0d, 0x10, 0x01, 0x2a, 0x09, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41,
	0x54, 0x45, 0xf2, 0xaa, 0x19, 0x4b, 0x0a, 0x49, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b,
	0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x2a, 0xba, 0x02, 0x0a, 0x0e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x4f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54,
	0x45, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54, 0x5f, 0x30, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54,
	0x5f, 0x31, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54,
	0x45, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54, 0x5f, 0x32, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54,
	0x5f, 0x33, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54,
	0x45, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54, 0x5f, 0x34, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54,
	0x5f, 0x35, 0x10, 0x05, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54,
	0x45, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54, 0x5f, 0x36, 0x10, 0x06, 0x12, 0x16, 0x0a, 0x12,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54,
	0x5f, 0x37, 0x10, 0x07, 0x1a, 0x68, 0xea, 0xaa, 0x19, 0x14, 0x10, 0x01, 0x2a, 0x10, 0x44, 0x41,
	0x54, 0x41, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54, 0xf2, 0xaa,
	0x19, 0x4c, 0x0a, 0x4a, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74,
	0x6e, 0x70, 0x62, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x2a, 0x5d,
	0x0a, 0x0f, 0x4a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x54,
	0x45, 0x58, 0x54, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f,
	0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x4a,
	0x4f, 0x49, 0x4e, 0x5f, 0x4b, 0x45, 0x59, 0x53, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x04, 0x4a, 0x4f,
	0x49, 0x4e, 0x10, 0xff, 0x01, 0x1a, 0x06, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0x2a, 0x3f, 0x0a,
	0x11, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x58, 0x54, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04,
	0x4b, 0x45, 0x59, 0x53, 0x10, 0x02, 0x1a, 0x06, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0x2a, 0x38,
	0x0a, 0x0a, 0x43, 0x46, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0f, 0x0a, 0x0b,
	0x46, 0x52, 0x45, 0x51, 0x55, 0x45, 0x4e, 0x43, 0x49, 0x45, 0x53, 0x10, 0x00, 0x12, 0x11, 0x0a,
	0x0d, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x4d, 0x41, 0x53, 0x4b, 0x53, 0x10, 0x01,
	0x1a, 0x06, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0x2a, 0x3d, 0x0a, 0x05, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x5f, 0x41, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x5f, 0x42, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43,
	0x4c, 0x41, 0x53, 0x53, 0x5f, 0x43, 0x10, 0x02, 0x1a, 0x0d, 0xea, 0xaa, 0x19, 0x09, 0x18, 0x01,
	0x2a, 0x05, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x2a, 0x78, 0x0a, 0x12, 0x54, 0x78, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x0a, 0x0a,
	0x06, 0x4c, 0x4f, 0x57, 0x45, 0x53, 0x54, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57,
	0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x42, 0x45, 0x4c, 0x4f, 0x57, 0x5f, 0x4e, 0x4f, 0x52, 0x4d,
	0x41, 0x4c, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10, 0x03,
	0x12, 0x10, 0x0a, 0x0c, 0x41, 0x42, 0x4f, 0x56, 0x45, 0x5f, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c,
	0x10, 0x04, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47, 0x48, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07,
	0x48, 0x49, 0x47, 0x48, 0x45, 0x53, 0x54, 0x10, 0x06, 0x1a, 0x06, 0xea, 0xaa, 0x19, 0x02, 0x18,
	0x01, 0x2a, 0xbc, 0x05, 0x0a, 0x14, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x49,
	0x44, 0x5f, 0x52, 0x46, 0x55, 0x5f, 0x30, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x49, 0x44,
	0x5f, 0x52, 0x45, 0x53, 0x45, 0x54, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x49, 0x44, 0x5f,
	0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c,
	0x43, 0x49, 0x44, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x41, 0x44, 0x52, 0x10, 0x03, 0x12, 0x12,
	0x0a, 0x0e, 0x43, 0x49, 0x44, 0x5f, 0x44, 0x55, 0x54, 0x59, 0x5f, 0x43, 0x59, 0x43, 0x4c, 0x45,
	0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x49, 0x44, 0x5f, 0x52, 0x58, 0x5f, 0x50, 0x41, 0x52,
	0x41, 0x4d, 0x5f, 0x53, 0x45, 0x54, 0x55, 0x50, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x49,
	0x44, 0x5f, 0x44, 0x45, 0x56, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x10, 0x06, 0x12, 0x13,
	0x0a, 0x0f, 0x43, 0x49, 0x44, 0x5f, 0x4e, 0x45, 0x57, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45,
	0x4c, 0x10, 0x07, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x49, 0x44, 0x5f, 0x52, 0x58, 0x5f, 0x54, 0x49,
	0x4d, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x45, 0x54, 0x55, 0x50, 0x10, 0x08, 0x12, 0x16, 0x0a, 0x12,
	0x43, 0x49, 0x44, 0x5f, 0x54, 0x58, 0x5f, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x5f, 0x53, 0x45, 0x54,
	0x55, 0x50, 0x10, 0x09, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x49, 0x44, 0x5f, 0x44, 0x4c, 0x5f, 0x43,
	0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x10, 0x0a, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x49, 0x44, 0x5f,
	0x52, 0x45, 0x4b, 0x45, 0x59, 0x10, 0x0b, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x49, 0x44, 0x5f, 0x41,
	0x44, 0x52, 0x5f, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x5f, 0x53, 0x45, 0x54, 0x55, 0x50, 0x10, 0x0c,
	0x12, 0x13, 0x0a, 0x0f, 0x43, 0x49, 0x44, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x10, 0x0d, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x49, 0x44, 0x5f, 0x46, 0x4f, 0x52,
	0x43, 0x45, 0x5f, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x10, 0x0e, 0x12, 0x1a, 0x0a, 0x16, 0x43,
	0x49, 0x44, 0x5f, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x5f,
	0x53, 0x45, 0x54, 0x55, 0x50, 0x10, 0x0f, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x49, 0x44, 0x5f, 0x50,
	0x49, 0x4e, 0x47, 0x5f, 0x53, 0x4c, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x10, 0x12,
	0x19, 0x0a, 0x15, 0x43, 0x49, 0x44, 0x5f, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x4c, 0x4f, 0x54,
	0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x10, 0x11, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x49,
	0x44, 0x5f, 0x42, 0x45, 0x41, 0x43, 0x4f, 0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x49, 0x4e, 0x47, 0x10,
	0x12, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x49, 0x44, 0x5f, 0x42, 0x45, 0x41, 0x43, 0x4f, 0x4e, 0x5f,
	0x46, 0x52, 0x45, 0x51, 0x10, 0x13, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x49, 0x44, 0x5f, 0x44, 0x45,
	0x56, 0x49, 0x43, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x10, 0x20, 0x12, 0x12, 0x0a, 0x0e, 0x43,
	0x49, 0x44, 0x5f, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x10, 0x40, 0x12,
	0x1d, 0x0a, 0x19, 0x43, 0x49, 0x44, 0x5f, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x45, 0x4e, 0x44,
	0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x10, 0x41, 0x12, 0x19,
	0x0a, 0x15, 0x43, 0x49, 0x44, 0x5f, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x46, 0x49, 0x4c, 0x54,
	0x45, 0x52, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x42, 0x12, 0x20, 0x0a, 0x1c, 0x43, 0x49, 0x44,
	0x5f, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x50,
	0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x43, 0x12, 0x1e, 0x0a, 0x1a, 0x43,
	0x49, 0x44, 0x5f, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x43, 0x54, 0x52, 0x4c, 0x5f, 0x55, 0x50,
	0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x44, 0x12, 0x21, 0x0a, 0x1d, 0x43,
	0x49, 0x44, 0x5f, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x55,
	0x52, 0x45, 0x5f, 0x46, 0x57, 0x44, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x10, 0x45, 0x12, 0x23,
	0x0a, 0x1f, 0x43, 0x49, 0x44, 0x5f, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x4e, 0x4f, 0x54, 0x49,
	0x46, 0x59, 0x5f, 0x4e, 0x45, 0x57, 0x5f, 0x45, 0x4e, 0x44, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43,
	0x45, 0x10, 0x46, 0x1a, 0x0b, 0xea, 0xaa, 0x19, 0x07, 0x18, 0x01, 0x2a, 0x03, 0x43, 0x49, 0x44,
	0x2a, 0xb2, 0x02, 0x0a, 0x13, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x41, 0x44, 0x50, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x4c, 0x41,
	0x59, 0x5f, 0x43, 0x41, 0x44, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44, 0x49, 0x43, 0x49, 0x54,
	0x59, 0x5f, 0x31, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x10, 0x00, 0x12, 0x2a, 0x0a, 0x26,
	0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x43, 0x41, 0x44, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44,
	0x49, 0x43, 0x49, 0x54, 0x59, 0x5f, 0x35, 0x30, 0x30, 0x5f, 0x4d, 0x49, 0x4c, 0x4c, 0x49, 0x53,
	0x45, 0x43, 0x4f, 0x4e, 0x44, 0x53, 0x10, 0x01, 0x12, 0x2a, 0x0a, 0x26, 0x52, 0x45, 0x4c, 0x41,
	0x59, 0x5f, 0x43, 0x41, 0x44, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44, 0x49, 0x43, 0x49, 0x54,
	0x59, 0x5f, 0x32, 0x35, 0x30, 0x5f, 0x4d, 0x49, 0x4c, 0x4c, 0x49, 0x53, 0x45, 0x43, 0x4f, 0x4e,
	0x44, 0x53, 0x10, 0x02, 0x12, 0x2a, 0x0a, 0x26, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x43, 0x41,
	0x44, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44, 0x49, 0x43, 0x49, 0x54, 0x59, 0x5f, 0x31, 0x30,
	0x30, 0x5f, 0x4d, 0x49, 0x4c, 0x4c, 0x49, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x53, 0x10, 0x03,
	0x12, 0x29, 0x0a, 0x25, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x43, 0x41, 0x44, 0x5f, 0x50, 0x45,
	0x52, 0x49, 0x4f, 0x44, 0x49, 0x43, 0x49, 0x54, 0x59, 0x5f, 0x35, 0x30, 0x5f, 0x4d, 0x49, 0x4c,
	0x4c, 0x49, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x53, 0x10, 0x04, 0x12, 0x29, 0x0a, 0x25, 0x52,
	0x45, 0x4c, 0x41, 0x59, 0x5f, 0x43, 0x41, 0x44, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44, 0x49,
	0x43, 0x49, 0x54, 0x59, 0x5f, 0x32, 0x30, 0x5f, 0x4d, 0x49, 0x4c, 0x4c, 0x49, 0x53, 0x45, 0x43,
	0x4f, 0x4e, 0x44, 0x53, 0x10, 0x05, 0x1a, 0x1d, 0xea, 0xaa, 0x19, 0x19, 0x18, 0x01, 0x2a, 0x15,
	0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x43, 0x41, 0x44, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44,
	0x49, 0x43, 0x49, 0x54, 0x59, 0x2a, 0x94, 0x02, 0x0a, 0x16, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x41, 0x63, 0x6b, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44,
	0x5f, 0x43, 0x48, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54, 0x5f, 0x30,
	0x10, 0x00, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x53, 0x45, 0x43, 0x4f,
	0x4e, 0x44, 0x5f, 0x43, 0x48, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54,
	0x5f, 0x32, 0x30, 0x30, 0x10, 0x01, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f,
	0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x5f, 0x43, 0x48, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4f, 0x46,
	0x46, 0x53, 0x45, 0x54, 0x5f, 0x34, 0x30, 0x30, 0x10, 0x02, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45,
	0x4c, 0x41, 0x59, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x5f, 0x43, 0x48, 0x5f, 0x41, 0x43,
	0x4b, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54, 0x5f, 0x38, 0x30, 0x30, 0x10, 0x03, 0x12, 0x23,
	0x0a, 0x1f, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x5f, 0x43,
	0x48, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54, 0x5f, 0x31, 0x36, 0x30,
	0x30, 0x10, 0x04, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x53, 0x45, 0x43,
	0x4f, 0x4e, 0x44, 0x5f, 0x43, 0x48, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45,
	0x54, 0x5f, 0x33, 0x32, 0x30, 0x30, 0x10, 0x05, 0x1a, 0x22, 0xea, 0xaa, 0x19, 0x1e, 0x18, 0x01,
	0x2a, 0x1a, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x5f, 0x43,
	0x48, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54, 0x2a, 0xb4, 0x01, 0x0a,
	0x14, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x4c,
	0x49, 0x4d, 0x49, 0x54, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x53, 0x49, 0x5a, 0x45,
	0x5f, 0x31, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x4c, 0x49,
	0x4d, 0x49, 0x54, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f,
	0x32, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x4c, 0x49, 0x4d,
	0x49, 0x54, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x34,
	0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x4c, 0x49, 0x4d, 0x49,
	0x54, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x31, 0x32,
	0x10, 0x03, 0x1a, 0x1f, 0xea, 0xaa, 0x19, 0x1b, 0x18, 0x01, 0x2a, 0x17, 0x52, 0x45, 0x4c, 0x41,
	0x59, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x53,
	0x49, 0x5a, 0x45, 0x2a, 0xbc, 0x01, 0x0a, 0x15, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x6d, 0x61,
	0x72, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1e, 0x0a,
	0x1a, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x53, 0x4d, 0x41, 0x52, 0x54, 0x5f, 0x45, 0x4e, 0x41,
	0x42, 0x4c, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x38, 0x10, 0x00, 0x12, 0x1f, 0x0a,
	0x1b, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x53, 0x4d, 0x41, 0x52, 0x54, 0x5f, 0x45, 0x4e, 0x41,
	0x42, 0x4c, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x31, 0x36, 0x10, 0x01, 0x12, 0x1f,
	0x0a, 0x1b, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x53, 0x4d, 0x41, 0x52, 0x54, 0x5f, 0x45, 0x4e,
	0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x33, 0x32, 0x10, 0x02, 0x12,
	0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x53, 0x4d, 0x41, 0x52, 0x54, 0x5f, 0x45,
	0x4e, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x36, 0x34, 0x10, 0x03,
	0x1a, 0x20, 0xea, 0xaa, 0x19, 0x1c, 0x18, 0x01, 0x2a, 0x18, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f,
	0x53, 0x4d, 0x41, 0x52, 0x54, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4c, 0x45, 0x56,
	0x45, 0x4c, 0x2a, 0x6c, 0x0a, 0x0f, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x57, 0x4f, 0x52, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x57,
	0x4f, 0x52, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55,
	0x4c, 0x54, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x57, 0x4f,
	0x52, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44,
	0x41, 0x52, 0x59, 0x10, 0x01, 0x1a, 0x19, 0xea, 0xaa, 0x19, 0x15, 0x18, 0x01, 0x2a, 0x11, 0x52,
	0x45, 0x4c, 0x41, 0x59, 0x5f, 0x57, 0x4f, 0x52, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c,
	0x2a, 0xdb, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x73, 0x65, 0x74, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x1e, 0x52,
	0x45, 0x4c, 0x41, 0x59, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x54, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54,
	0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x45, 0x52, 0x5f, 0x5a, 0x45, 0x52, 0x4f, 0x10, 0x00, 0x12,
	0x29, 0x0a, 0x25, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x54, 0x5f, 0x4c,
	0x49, 0x4d, 0x49, 0x54, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x4c,
	0x4f, 0x41, 0x44, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x27, 0x0a, 0x23, 0x52, 0x45,
	0x4c, 0x41, 0x59, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x54, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f,
	0x43, 0x4f, 0x55, 0x4e, 0x54, 0x45, 0x52, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x56, 0x41, 0x4c, 0x55,
	0x45, 0x10, 0x02, 0x12, 0x26, 0x0a, 0x22, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x52, 0x45, 0x53,
	0x45, 0x54, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x45, 0x52,
	0x5f, 0x4e, 0x4f, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x54, 0x10, 0x03, 0x1a, 0x21, 0xea, 0xaa, 0x19,
	0x1d, 0x18, 0x01, 0x2a, 0x19, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x54,
	0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x45, 0x52, 0x2a, 0xaf,
	0x01, 0x0a, 0x19, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x74, 0x72, 0x6c, 0x55, 0x70, 0x6c, 0x69,
	0x6e, 0x6b, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x2a,
	0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x43, 0x54, 0x52, 0x4c, 0x5f, 0x55, 0x50, 0x4c, 0x49, 0x4e,
	0x4b, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45,
	0x41, 0x44, 0x5f, 0x57, 0x5f, 0x46, 0x5f, 0x43, 0x4e, 0x54, 0x10, 0x00, 0x12, 0x3b, 0x0a, 0x37,
	0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x43, 0x54, 0x52, 0x4c, 0x5f, 0x55, 0x50, 0x4c, 0x49, 0x4e,
	0x4b, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45,
	0x4d, 0x4f, 0x56, 0x45, 0x5f, 0x54, 0x52, 0x55, 0x53, 0x54, 0x45, 0x44, 0x5f, 0x45, 0x4e, 0x44,
	0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x10, 0x01, 0x1a, 0x25, 0xea, 0xaa, 0x19, 0x21, 0x18,
	0x01, 0x2a, 0x1d, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x43, 0x54, 0x52, 0x4c, 0x5f, 0x55, 0x50,
	0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x2a, 0xe6, 0x02, 0x0a, 0x13, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x44,
	0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x55, 0x54, 0x59,
	0x5f, 0x43, 0x59, 0x43, 0x4c, 0x45, 0x5f, 0x31, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x55,
	0x54, 0x59, 0x5f, 0x43, 0x59, 0x43, 0x4c, 0x45, 0x5f, 0x32, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c,
	0x44, 0x55, 0x54, 0x59, 0x5f, 0x43, 0x59, 0x43, 0x4c, 0x45, 0x5f, 0x34, 0x10, 0x02, 0x12, 0x10,
	0x0a, 0x0c, 0x44, 0x55, 0x54, 0x59, 0x5f, 0x43, 0x59, 0x43, 0x4c, 0x45, 0x5f, 0x38, 0x10, 0x03,
	0x12, 0x11, 0x0a, 0x0d, 0x44, 0x55, 0x54, 0x59, 0x5f, 0x43, 0x59, 0x43, 0x4c, 0x45, 0x5f, 0x31,
	0x36, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x55, 0x54, 0x59, 0x5f, 0x43, 0x59, 0x43, 0x4c,
	0x45, 0x5f, 0x33, 0x32, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x55, 0x54, 0x59, 0x5f, 0x43,
	0x59, 0x43, 0x4c, 0x45, 0x5f, 0x36, 0x34, 0x10, 0x06, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x55, 0x54,
	0x59, 0x5f, 0x43, 0x59, 0x43, 0x4c, 0x45, 0x5f, 0x31, 0x32, 0x38, 0x10, 0x07, 0x12, 0x12, 0x0a,
	0x0e, 0x44, 0x55, 0x54, 0x59, 0x5f, 0x43, 0x59, 0x43, 0x4c, 0x45, 0x5f, 0x32, 0x35, 0x36, 0x10,
	0x08, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x55, 0x54, 0x59, 0x5f, 0x43, 0x59, 0x43, 0x4c, 0x45, 0x5f,
	0x35, 0x31, 0x32, 0x10, 0x09, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x55, 0x54, 0x59, 0x5f, 0x43, 0x59,
	0x43, 0x4c, 0x45, 0x5f, 0x31, 0x30, 0x32, 0x34, 0x10, 0x0a, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x55,
	0x54, 0x59, 0x5f, 0x43, 0x59, 0x43, 0x4c, 0x45, 0x5f, 0x32, 0x30, 0x34, 0x38, 0x10, 0x0b, 0x12,
	0x13, 0x0a, 0x0f, 0x44, 0x55, 0x54, 0x59, 0x5f, 0x43, 0x59, 0x43, 0x4c, 0x45, 0x5f, 0x34, 0x30,
	0x39, 0x36, 0x10, 0x0c, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x55, 0x54, 0x59, 0x5f, 0x43, 0x59, 0x43,
	0x4c, 0x45, 0x5f, 0x38, 0x31, 0x39, 0x32, 0x10, 0x0d, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x55, 0x54,
	0x59, 0x5f, 0x43, 0x59, 0x43, 0x4c, 0x45, 0x5f, 0x31, 0x36, 0x33, 0x38, 0x34, 0x10, 0x0e, 0x12,
	0x14, 0x0a, 0x10, 0x44, 0x55, 0x54, 0x59, 0x5f, 0x43, 0x59, 0x43, 0x4c, 0x45, 0x5f, 0x33, 0x32,
	0x37, 0x36, 0x38, 0x10, 0x0f, 0x1a, 0x12, 0xea, 0xaa, 0x19, 0x0e, 0x18, 0x01, 0x2a, 0x0a, 0x44,
	0x55, 0x54, 0x59, 0x5f, 0x43, 0x59, 0x43, 0x4c, 0x45, 0x2a, 0xc1, 0x01, 0x0a, 0x0e, 0x50, 0x69,
	0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x11, 0x0a, 0x0d,
	0x50, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x31, 0x53, 0x10, 0x00, 0x12,
	0x11, 0x0a, 0x0d, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x32, 0x53,
	0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x56, 0x45, 0x52, 0x59,
	0x5f, 0x34, 0x53, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x56,
	0x45, 0x52, 0x59, 0x5f, 0x38, 0x53, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x49, 0x4e, 0x47,
	0x5f, 0x45, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x31, 0x36, 0x53, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e,
	0x50, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x33, 0x32, 0x53, 0x10, 0x05,
	0x12, 0x12, 0x0a, 0x0e, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x36,
	0x34, 0x53, 0x10, 0x06, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x56, 0x45,
	0x52, 0x59, 0x5f, 0x31, 0x32, 0x38, 0x53, 0x10, 0x07, 0x1a, 0x12, 0xea, 0xaa, 0x19, 0x0e, 0x18,
	0x01, 0x2a, 0x0a, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x56, 0x45, 0x52, 0x59, 0x2a, 0x9b, 0x03,
	0x0a, 0x13, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x78, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f,
	0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x31, 0x36, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45,
	0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x33, 0x32, 0x10, 0x01, 0x12,
	0x13, 0x0a, 0x0f, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f,
	0x36, 0x34, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43,
	0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x31, 0x32, 0x38, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45,
	0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x32, 0x35, 0x36, 0x10, 0x04,
	0x12, 0x14, 0x0a, 0x10, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54,
	0x5f, 0x35, 0x31, 0x32, 0x10, 0x05, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e,
	0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x31, 0x30, 0x32, 0x34, 0x10, 0x06, 0x12, 0x15, 0x0a,
	0x11, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x32, 0x30,
	0x34, 0x38, 0x10, 0x07, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43,
	0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x10, 0x08, 0x12, 0x15, 0x0a, 0x11, 0x52,
	0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x38, 0x31, 0x39, 0x32,
	0x10, 0x09, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x55,
	0x4e, 0x54, 0x5f, 0x31, 0x36, 0x33, 0x38, 0x34, 0x10, 0x0a, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45,
	0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x33, 0x32, 0x37, 0x36, 0x38,
	0x10, 0x0b, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x55,
	0x4e, 0x54, 0x5f, 0x36, 0x35, 0x35, 0x33, 0x36, 0x10, 0x0c, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45,
	0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x31, 0x33, 0x31, 0x30, 0x37,
	0x32, 0x10, 0x0d, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43, 0x4f,
	0x55, 0x4e, 0x54, 0x5f, 0x32, 0x36, 0x32, 0x31, 0x34, 0x34, 0x10, 0x0e, 0x12, 0x17, 0x0a, 0x13,
	0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x35, 0x32, 0x34,
	0x32, 0x38, 0x38, 0x10, 0x0f, 0x1a, 0x14, 0xea, 0xaa, 0x19, 0x10, 0x18, 0x01, 0x2a, 0x0c, 0x52,
	0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x2a, 0xdf, 0x02, 0x0a, 0x12,
	0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x49, 0x4d,
	0x45, 0x5f, 0x30, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f,
	0x54, 0x49, 0x4d, 0x45, 0x5f, 0x31, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x4a, 0x4f,
	0x49, 0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x32, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x52,
	0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x33, 0x10, 0x03, 0x12, 0x11,
	0x0a, 0x0d, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x34, 0x10,
	0x04, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x45,
	0x5f, 0x35, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x5f, 0x36, 0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x4a, 0x4f, 0x49,
	0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x37, 0x10, 0x07, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45,
	0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x38, 0x10, 0x08, 0x12, 0x11, 0x0a,
	0x0d, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x39, 0x10, 0x09,
	0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f,
	0x31, 0x30, 0x10, 0x0a, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x5f, 0x31, 0x31, 0x10, 0x0b, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x4a, 0x4f,
	0x49, 0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x31, 0x32, 0x10, 0x0c, 0x12, 0x12, 0x0a, 0x0e,
	0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x31, 0x33, 0x10, 0x0d,
	0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f,
	0x31, 0x34, 0x10, 0x0e, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x5f, 0x31, 0x35, 0x10, 0x0f, 0x1a, 0x13, 0xea, 0xaa, 0x19, 0x0f, 0x18, 0x01,
	0x2a, 0x0b, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x2a, 0xd5, 0x01,
	0x0a, 0x14, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x45, 0x78,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e,
	0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44, 0x5f, 0x30, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x52,
	0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44, 0x5f, 0x31, 0x10, 0x01,
	0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f,
	0x44, 0x5f, 0x32, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f,
	0x50, 0x45, 0x52, 0x49, 0x4f, 0x44, 0x5f, 0x33, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45,
	0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44, 0x5f, 0x34, 0x10, 0x04, 0x12,
	0x13, 0x0a, 0x0f, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44,
	0x5f, 0x35, 0x10, 0x05, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x50,
	0x45, 0x52, 0x49, 0x4f, 0x44, 0x5f, 0x36, 0x10, 0x06, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x4a,
	0x4f, 0x49, 0x4e, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44, 0x5f, 0x37, 0x10, 0x07, 0x1a, 0x15,
	0xea, 0xaa, 0x19, 0x11, 0x18, 0x01, 0x2a, 0x0d, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x50,
	0x45, 0x52, 0x49, 0x4f, 0x44, 0x2a, 0xe0, 0x02, 0x0a, 0x0a, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x45, 0x49, 0x52, 0x50, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x45,
	0x49, 0x52, 0x50, 0x5f, 0x38, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x45, 0x56, 0x49, 0x43,
	0x45, 0x5f, 0x45, 0x49, 0x52, 0x50, 0x5f, 0x31, 0x30, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x44,
	0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x45, 0x49, 0x52, 0x50, 0x5f, 0x31, 0x32, 0x10, 0x02, 0x12,
	0x12, 0x0a, 0x0e, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x45, 0x49, 0x52, 0x50, 0x5f, 0x31,
	0x33, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x45, 0x49,
	0x52, 0x50, 0x5f, 0x31, 0x34, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x45, 0x56, 0x49, 0x43,
	0x45, 0x5f, 0x45, 0x49, 0x52, 0x50, 0x5f, 0x31, 0x36, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e, 0x44,
	0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x45, 0x49, 0x52, 0x50, 0x5f, 0x31, 0x38, 0x10, 0x06, 0x12,
	0x12, 0x0a, 0x0e, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x45, 0x49, 0x52, 0x50, 0x5f, 0x32,
	0x30, 0x10, 0x07, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x45, 0x49,
	0x52, 0x50, 0x5f, 0x32, 0x31, 0x10, 0x08, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x45, 0x56, 0x49, 0x43,
	0x45, 0x5f, 0x45, 0x49, 0x52, 0x50, 0x5f, 0x32, 0x34, 0x10, 0x09, 0x12, 0x12, 0x0a, 0x0e, 0x44,
	0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x45, 0x49, 0x52, 0x50, 0x5f, 0x32, 0x36, 0x10, 0x0a, 0x12,
	0x12, 0x0a, 0x0e, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x45, 0x49, 0x52, 0x50, 0x5f, 0x32,
	0x37, 0x10, 0x0b, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x45, 0x49,
	0x52, 0x50, 0x5f, 0x32, 0x39, 0x10, 0x0c, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x45, 0x56, 0x49, 0x43,
	0x45, 0x5f, 0x45, 0x49, 0x52, 0x50, 0x5f, 0x33, 0x30, 0x10, 0x0d, 0x12, 0x12, 0x0a, 0x0e, 0x44,
	0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x45, 0x49, 0x52, 0x50, 0x5f, 0x33, 0x33, 0x10, 0x0e, 0x12,
	0x12, 0x0a, 0x0e, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x45, 0x49, 0x52, 0x50, 0x5f, 0x33,
	0x36, 0x10, 0x0f, 0x1a, 0x13, 0xea, 0xaa, 0x19, 0x0f, 0x18, 0x01, 0x2a, 0x0b, 0x44, 0x45, 0x56,
	0x49, 0x43, 0x45, 0x5f, 0x45, 0x49, 0x52, 0x50, 0x2a, 0x99, 0x03, 0x0a, 0x13, 0x41, 0x44, 0x52,
	0x41, 0x63, 0x6b, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x12, 0x13, 0x0a, 0x0f, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4c, 0x49, 0x4d, 0x49,
	0x54, 0x5f, 0x31, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b,
	0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x32, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x44,
	0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x34, 0x10, 0x02, 0x12,
	0x13, 0x0a, 0x0f, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54,
	0x5f, 0x38, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f,
	0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x31, 0x36, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x44,
	0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x33, 0x32, 0x10, 0x05,
	0x12, 0x14, 0x0a, 0x10, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4c, 0x49, 0x4d, 0x49,
	0x54, 0x5f, 0x36, 0x34, 0x10, 0x06, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43,
	0x4b, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x31, 0x32, 0x38, 0x10, 0x07, 0x12, 0x15, 0x0a,
	0x11, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x32,
	0x35, 0x36, 0x10, 0x08, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f,
	0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x35, 0x31, 0x32, 0x10, 0x09, 0x12, 0x16, 0x0a, 0x12, 0x41,
	0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x31, 0x30, 0x32,
	0x34, 0x10, 0x0a, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4c,
	0x49, 0x4d, 0x49, 0x54, 0x5f, 0x32, 0x30, 0x34, 0x38, 0x10, 0x0b, 0x12, 0x16, 0x0a, 0x12, 0x41,
	0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x34, 0x30, 0x39,
	0x36, 0x10, 0x0c, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4c,
	0x49, 0x4d, 0x49, 0x54, 0x5f, 0x38, 0x31, 0x39, 0x32, 0x10, 0x0d, 0x12, 0x17, 0x0a, 0x13, 0x41,
	0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x31, 0x36, 0x33,
	0x38, 0x34, 0x10, 0x0e, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f,
	0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x33, 0x32, 0x37, 0x36, 0x38, 0x10, 0x0f, 0x1a, 0x15, 0xea,
	0xaa, 0x19, 0x11, 0x18, 0x01, 0x2a, 0x0d, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x4c,
	0x49, 0x4d, 0x49, 0x54, 0x2a, 0x99, 0x03, 0x0a, 0x13, 0x41, 0x44, 0x52, 0x41, 0x63, 0x6b, 0x44,
	0x65, 0x6c, 0x61, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x13, 0x0a, 0x0f,
	0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x31, 0x10,
	0x00, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x44, 0x45, 0x4c,
	0x41, 0x59, 0x5f, 0x32, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43,
	0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x34, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x41,
	0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x38, 0x10, 0x03,
	0x12, 0x14, 0x0a, 0x10, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41,
	0x59, 0x5f, 0x31, 0x36, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43,
	0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x33, 0x32, 0x10, 0x05, 0x12, 0x14, 0x0a, 0x10,
	0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x36, 0x34,
	0x10, 0x06, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x44, 0x45,
	0x4c, 0x41, 0x59, 0x5f, 0x31, 0x32, 0x38, 0x10, 0x07, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x44, 0x52,
	0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x32, 0x35, 0x36, 0x10, 0x08,
	0x12, 0x15, 0x0a, 0x11, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41,
	0x59, 0x5f, 0x35, 0x31, 0x32, 0x10, 0x09, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x44, 0x52, 0x5f, 0x41,
	0x43, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x31, 0x30, 0x32, 0x34, 0x10, 0x0a, 0x12,
	0x16, 0x0a, 0x12, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59,
	0x5f, 0x32, 0x30, 0x34, 0x38, 0x10, 0x0b, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x44, 0x52, 0x5f, 0x41,
	0x43, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x10, 0x0c, 0x12,
	0x16, 0x0a, 0x12, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59,
	0x5f, 0x38, 0x31, 0x39, 0x32, 0x10, 0x0d, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x44, 0x52, 0x5f, 0x41,
	0x43, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x31, 0x36, 0x33, 0x38, 0x34, 0x10, 0x0e,
	0x12, 0x17, 0x0a, 0x13, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41,
	0x59, 0x5f, 0x33, 0x32, 0x37, 0x36, 0x38, 0x10, 0x0f, 0x1a, 0x15, 0xea, 0xaa, 0x19, 0x11, 0x18,
	0x01, 0x2a, 0x0d, 0x41, 0x44, 0x52, 0x5f, 0x41, 0x43, 0x4b, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59,
	0x2a, 0xea, 0x02, 0x0a, 0x07, 0x52, 0x78, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x30, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x31, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x32, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x33, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x34, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x35, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x36, 0x10, 0x06, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x37, 0x10, 0x07, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x38, 0x10, 0x08, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x39, 0x10, 0x09, 0x12, 0x0f, 0x0a, 0x0b,
	0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x31, 0x30, 0x10, 0x0a, 0x12, 0x0f, 0x0a,
	0x0b, 0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x31, 0x31, 0x10, 0x0b, 0x12, 0x0f,
	0x0a, 0x0b, 0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x31, 0x32, 0x10, 0x0c, 0x12,
	0x0f, 0x0a, 0x0b, 0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x31, 0x33, 0x10, 0x0d,
	0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x31, 0x34, 0x10,
	0x0e, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x58, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x31, 0x35,
	0x10, 0x0f, 0x1a, 0x59, 0xea, 0xaa, 0x19, 0x0c, 0x10, 0x01, 0x2a, 0x08, 0x52, 0x58, 0x5f, 0x44,
	0x45, 0x4c, 0x41, 0x59, 0xf2, 0xaa, 0x19, 0x45, 0x0a, 0x43, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65,
	0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f,
	0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x2e, 0x52, 0x78, 0x44, 0x65, 0x6c, 0x61,
	0x79, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x2a, 0xa8, 0x02,
	0x0a, 0x05, 0x4d, 0x69, 0x6e, 0x6f, 0x72, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x49, 0x4e, 0x4f, 0x52,
	0x5f, 0x52, 0x46, 0x55, 0x5f, 0x30, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x49, 0x4e, 0x4f,
	0x52, 0x5f, 0x31, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x49, 0x4e, 0x4f, 0x52, 0x5f, 0x52,
	0x46, 0x55, 0x5f, 0x32, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x49, 0x4e, 0x4f, 0x52, 0x5f,
	0x52, 0x46, 0x55, 0x5f, 0x33, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x49, 0x4e, 0x4f, 0x52,
	0x5f, 0x52, 0x46, 0x55, 0x5f, 0x34, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x49, 0x4e, 0x4f,
	0x52, 0x5f, 0x52, 0x46, 0x55, 0x5f, 0x35, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x49, 0x4e,
	0x4f, 0x52, 0x5f, 0x52, 0x46, 0x55, 0x5f, 0x36, 0x10, 0x06, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x49,
	0x4e, 0x4f, 0x52, 0x5f, 0x52, 0x46, 0x55, 0x5f, 0x37, 0x10, 0x07, 0x12, 0x0f, 0x0a, 0x0b, 0x4d,
	0x49, 0x4e, 0x4f, 0x52, 0x5f, 0x52, 0x46, 0x55, 0x5f, 0x38, 0x10, 0x08, 0x12, 0x0f, 0x0a, 0x0b,
	0x4d, 0x49, 0x4e, 0x4f, 0x52, 0x5f, 0x52, 0x46, 0x55, 0x5f, 0x39, 0x10, 0x09, 0x12, 0x10, 0x0a,
	0x0c, 0x4d, 0x49, 0x4e, 0x4f, 0x52, 0x5f, 0x52, 0x46, 0x55, 0x5f, 0x31, 0x30, 0x10, 0x0a, 0x12,
	0x10, 0x0a, 0x0c, 0x4d, 0x49, 0x4e, 0x4f, 0x52, 0x5f, 0x52, 0x46, 0x55, 0x5f, 0x31, 0x31, 0x10,
	0x0b, 0x12, 0x10, 0x0a, 0x0c, 0x4d, 0x49, 0x4e, 0x4f, 0x52, 0x5f, 0x52, 0x46, 0x55, 0x5f, 0x31,
	0x32, 0x10, 0x0c, 0x12, 0x10, 0x0a, 0x0c, 0x4d, 0x49, 0x4e, 0x4f, 0x52, 0x5f, 0x52, 0x46, 0x55,
	0x5f, 0x31, 0x33, 0x10, 0x0d, 0x12, 0x10, 0x0a, 0x0c, 0x4d, 0x49, 0x4e, 0x4f, 0x52, 0x5f, 0x52,
	0x46, 0x55, 0x5f, 0x31, 0x34, 0x10, 0x0e, 0x12, 0x10, 0x0a, 0x0c, 0x4d, 0x49, 0x4e, 0x4f, 0x52,
	0x5f, 0x52, 0x46, 0x55, 0x5f, 0x31, 0x35, 0x10, 0x0f, 0x1a, 0x0d, 0xea, 0xaa, 0x19, 0x09, 0x18,
	0x01, 0x2a, 0x05, 0x4d, 0x49, 0x4e, 0x4f, 0x52, 0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76,
	0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_lorawan_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_lorawan_proto_rawDescData = file_ttn_lorawan_v3_lorawan_proto_rawDesc
)

func file_ttn_lorawan_v3_lorawan_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_lorawan_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_lorawan_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_lorawan_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_lorawan_proto_rawDescData
}

var file_ttn_lorawan_v3_lorawan_proto_enumTypes = make([]protoimpl.EnumInfo, 29)
var file_ttn_lorawan_v3_lorawan_proto_msgTypes = make([]protoimpl.MessageInfo, 85)
var file_ttn_lorawan_v3_lorawan_proto_goTypes = []interface{}{
	(MType)(0),                                             // 0: ttn.lorawan.v3.MType
	(Major)(0),                                             // 1: ttn.lorawan.v3.Major
	(MACVersion)(0),                                        // 2: ttn.lorawan.v3.MACVersion
	(PHYVersion)(0),                                        // 3: ttn.lorawan.v3.PHYVersion
	(DataRateIndex)(0),                                     // 4: ttn.lorawan.v3.DataRateIndex
	(DataRateOffset)(0),                                    // 5: ttn.lorawan.v3.DataRateOffset
	(JoinRequestType)(0),                                   // 6: ttn.lorawan.v3.JoinRequestType
	(RejoinRequestType)(0),                                 // 7: ttn.lorawan.v3.RejoinRequestType
	(CFListType)(0),                                        // 8: ttn.lorawan.v3.CFListType
	(Class)(0),                                             // 9: ttn.lorawan.v3.Class
	(TxSchedulePriority)(0),                                // 10: ttn.lorawan.v3.TxSchedulePriority
	(MACCommandIdentifier)(0),                              // 11: ttn.lorawan.v3.MACCommandIdentifier
	(RelayCADPeriodicity)(0),                               // 12: ttn.lorawan.v3.RelayCADPeriodicity
	(RelaySecondChAckOffset)(0),                            // 13: ttn.lorawan.v3.RelaySecondChAckOffset
	(RelayLimitBucketSize)(0),                              // 14: ttn.lorawan.v3.RelayLimitBucketSize
	(RelaySmartEnableLevel)(0),                             // 15: ttn.lorawan.v3.RelaySmartEnableLevel
	(RelayWORChannel)(0),                                   // 16: ttn.lorawan.v3.RelayWORChannel
	(RelayResetLimitCounter)(0),                            // 17: ttn.lorawan.v3.RelayResetLimitCounter
	(RelayCtrlUplinkListAction)(0),                         // 18: ttn.lorawan.v3.RelayCtrlUplinkListAction
	(AggregatedDutyCycle)(0),                               // 19: ttn.lorawan.v3.AggregatedDutyCycle
	(PingSlotPeriod)(0),                                    // 20: ttn.lorawan.v3.PingSlotPeriod
	(RejoinCountExponent)(0),                               // 21: ttn.lorawan.v3.RejoinCountExponent
	(RejoinTimeExponent)(0),                                // 22: ttn.lorawan.v3.RejoinTimeExponent
	(RejoinPeriodExponent)(0),                              // 23: ttn.lorawan.v3.RejoinPeriodExponent
	(DeviceEIRP)(0),                                        // 24: ttn.lorawan.v3.DeviceEIRP
	(ADRAckLimitExponent)(0),                               // 25: ttn.lorawan.v3.ADRAckLimitExponent
	(ADRAckDelayExponent)(0),                               // 26: ttn.lorawan.v3.ADRAckDelayExponent
	(RxDelay)(0),                                           // 27: ttn.lorawan.v3.RxDelay
	(Minor)(0),                                             // 28: ttn.lorawan.v3.Minor
	(*Message)(nil),                                        // 29: ttn.lorawan.v3.Message
	(*MHDR)(nil),                                           // 30: ttn.lorawan.v3.MHDR
	(*MACPayload)(nil),                                     // 31: ttn.lorawan.v3.MACPayload
	(*FHDR)(nil),                                           // 32: ttn.lorawan.v3.FHDR
	(*FCtrl)(nil),                                          // 33: ttn.lorawan.v3.FCtrl
	(*JoinRequestPayload)(nil),                             // 34: ttn.lorawan.v3.JoinRequestPayload
	(*RejoinRequestPayload)(nil),                           // 35: ttn.lorawan.v3.RejoinRequestPayload
	(*JoinAcceptPayload)(nil),                              // 36: ttn.lorawan.v3.JoinAcceptPayload
	(*DLSettings)(nil),                                     // 37: ttn.lorawan.v3.DLSettings
	(*CFList)(nil),                                         // 38: ttn.lorawan.v3.CFList
	(*LoRaDataRate)(nil),                                   // 39: ttn.lorawan.v3.LoRaDataRate
	(*FSKDataRate)(nil),                                    // 40: ttn.lorawan.v3.FSKDataRate
	(*LRFHSSDataRate)(nil),                                 // 41: ttn.lorawan.v3.LRFHSSDataRate
	(*DataRate)(nil),                                       // 42: ttn.lorawan.v3.DataRate
	(*TxSettings)(nil),                                     // 43: ttn.lorawan.v3.TxSettings
	(*GatewayAntennaIdentifiers)(nil),                      // 44: ttn.lorawan.v3.GatewayAntennaIdentifiers
	(*ClassBCGatewayIdentifiers)(nil),                      // 45: ttn.lorawan.v3.ClassBCGatewayIdentifiers
	(*UplinkToken)(nil),                                    // 46: ttn.lorawan.v3.UplinkToken
	(*DownlinkPath)(nil),                                   // 47: ttn.lorawan.v3.DownlinkPath
	(*TxRequest)(nil),                                      // 48: ttn.lorawan.v3.TxRequest
	(*RelaySecondChannel)(nil),                             // 49: ttn.lorawan.v3.RelaySecondChannel
	(*RelayUplinkForwardLimits)(nil),                       // 50: ttn.lorawan.v3.RelayUplinkForwardLimits
	(*RelayForwardLimits)(nil),                             // 51: ttn.lorawan.v3.RelayForwardLimits
	(*RelayEndDeviceAlwaysMode)(nil),                       // 52: ttn.lorawan.v3.RelayEndDeviceAlwaysMode
	(*RelayEndDeviceDynamicMode)(nil),                      // 53: ttn.lorawan.v3.RelayEndDeviceDynamicMode
	(*RelayEndDeviceControlledMode)(nil),                   // 54: ttn.lorawan.v3.RelayEndDeviceControlledMode
	(*MACCommand)(nil),                                     // 55: ttn.lorawan.v3.MACCommand
	(*MACCommands)(nil),                                    // 56: ttn.lorawan.v3.MACCommands
	(*FrequencyValue)(nil),                                 // 57: ttn.lorawan.v3.FrequencyValue
	(*ZeroableFrequencyValue)(nil),                         // 58: ttn.lorawan.v3.ZeroableFrequencyValue
	(*DataRateOffsetValue)(nil),                            // 59: ttn.lorawan.v3.DataRateOffsetValue
	(*DataRateIndexValue)(nil),                             // 60: ttn.lorawan.v3.DataRateIndexValue
	(*PingSlotPeriodValue)(nil),                            // 61: ttn.lorawan.v3.PingSlotPeriodValue
	(*AggregatedDutyCycleValue)(nil),                       // 62: ttn.lorawan.v3.AggregatedDutyCycleValue
	(*RxDelayValue)(nil),                                   // 63: ttn.lorawan.v3.RxDelayValue
	(*ADRAckLimitExponentValue)(nil),                       // 64: ttn.lorawan.v3.ADRAckLimitExponentValue
	(*ADRAckDelayExponentValue)(nil),                       // 65: ttn.lorawan.v3.ADRAckDelayExponentValue
	(*DeviceEIRPValue)(nil),                                // 66: ttn.lorawan.v3.DeviceEIRPValue
	(*RelayForwardUplinkReq)(nil),                          // 67: ttn.lorawan.v3.RelayForwardUplinkReq
	(*RelayForwardDownlinkReq)(nil),                        // 68: ttn.lorawan.v3.RelayForwardDownlinkReq
	(*RelayUplinkToken)(nil),                               // 69: ttn.lorawan.v3.RelayUplinkToken
	(*TxSettings_Downlink)(nil),                            // 70: ttn.lorawan.v3.TxSettings.Downlink
	(*MACCommand_ResetInd)(nil),                            // 71: ttn.lorawan.v3.MACCommand.ResetInd
	(*MACCommand_ResetConf)(nil),                           // 72: ttn.lorawan.v3.MACCommand.ResetConf
	(*MACCommand_LinkCheckAns)(nil),                        // 73: ttn.lorawan.v3.MACCommand.LinkCheckAns
	(*MACCommand_LinkADRReq)(nil),                          // 74: ttn.lorawan.v3.MACCommand.LinkADRReq
	(*MACCommand_LinkADRAns)(nil),                          // 75: ttn.lorawan.v3.MACCommand.LinkADRAns
	(*MACCommand_DutyCycleReq)(nil),                        // 76: ttn.lorawan.v3.MACCommand.DutyCycleReq
	(*MACCommand_RxParamSetupReq)(nil),                     // 77: ttn.lorawan.v3.MACCommand.RxParamSetupReq
	(*MACCommand_RxParamSetupAns)(nil),                     // 78: ttn.lorawan.v3.MACCommand.RxParamSetupAns
	(*MACCommand_DevStatusAns)(nil),                        // 79: ttn.lorawan.v3.MACCommand.DevStatusAns
	(*MACCommand_NewChannelReq)(nil),                       // 80: ttn.lorawan.v3.MACCommand.NewChannelReq
	(*MACCommand_NewChannelAns)(nil),                       // 81: ttn.lorawan.v3.MACCommand.NewChannelAns
	(*MACCommand_DLChannelReq)(nil),                        // 82: ttn.lorawan.v3.MACCommand.DLChannelReq
	(*MACCommand_DLChannelAns)(nil),                        // 83: ttn.lorawan.v3.MACCommand.DLChannelAns
	(*MACCommand_RxTimingSetupReq)(nil),                    // 84: ttn.lorawan.v3.MACCommand.RxTimingSetupReq
	(*MACCommand_TxParamSetupReq)(nil),                     // 85: ttn.lorawan.v3.MACCommand.TxParamSetupReq
	(*MACCommand_RekeyInd)(nil),                            // 86: ttn.lorawan.v3.MACCommand.RekeyInd
	(*MACCommand_RekeyConf)(nil),                           // 87: ttn.lorawan.v3.MACCommand.RekeyConf
	(*MACCommand_ADRParamSetupReq)(nil),                    // 88: ttn.lorawan.v3.MACCommand.ADRParamSetupReq
	(*MACCommand_DeviceTimeAns)(nil),                       // 89: ttn.lorawan.v3.MACCommand.DeviceTimeAns
	(*MACCommand_ForceRejoinReq)(nil),                      // 90: ttn.lorawan.v3.MACCommand.ForceRejoinReq
	(*MACCommand_RejoinParamSetupReq)(nil),                 // 91: ttn.lorawan.v3.MACCommand.RejoinParamSetupReq
	(*MACCommand_RejoinParamSetupAns)(nil),                 // 92: ttn.lorawan.v3.MACCommand.RejoinParamSetupAns
	(*MACCommand_PingSlotInfoReq)(nil),                     // 93: ttn.lorawan.v3.MACCommand.PingSlotInfoReq
	(*MACCommand_PingSlotChannelReq)(nil),                  // 94: ttn.lorawan.v3.MACCommand.PingSlotChannelReq
	(*MACCommand_PingSlotChannelAns)(nil),                  // 95: ttn.lorawan.v3.MACCommand.PingSlotChannelAns
	(*MACCommand_BeaconTimingAns)(nil),                     // 96: ttn.lorawan.v3.MACCommand.BeaconTimingAns
	(*MACCommand_BeaconFreqReq)(nil),                       // 97: ttn.lorawan.v3.MACCommand.BeaconFreqReq
	(*MACCommand_BeaconFreqAns)(nil),                       // 98: ttn.lorawan.v3.MACCommand.BeaconFreqAns
	(*MACCommand_DeviceModeInd)(nil),                       // 99: ttn.lorawan.v3.MACCommand.DeviceModeInd
	(*MACCommand_DeviceModeConf)(nil),                      // 100: ttn.lorawan.v3.MACCommand.DeviceModeConf
	(*MACCommand_RelayConfReq)(nil),                        // 101: ttn.lorawan.v3.MACCommand.RelayConfReq
	(*MACCommand_RelayConfAns)(nil),                        // 102: ttn.lorawan.v3.MACCommand.RelayConfAns
	(*MACCommand_RelayEndDeviceConfReq)(nil),               // 103: ttn.lorawan.v3.MACCommand.RelayEndDeviceConfReq
	(*MACCommand_RelayEndDeviceConfAns)(nil),               // 104: ttn.lorawan.v3.MACCommand.RelayEndDeviceConfAns
	(*MACCommand_RelayUpdateUplinkListReq)(nil),            // 105: ttn.lorawan.v3.MACCommand.RelayUpdateUplinkListReq
	(*MACCommand_RelayUpdateUplinkListAns)(nil),            // 106: ttn.lorawan.v3.MACCommand.RelayUpdateUplinkListAns
	(*MACCommand_RelayCtrlUplinkListReq)(nil),              // 107: ttn.lorawan.v3.MACCommand.RelayCtrlUplinkListReq
	(*MACCommand_RelayCtrlUplinkListAns)(nil),              // 108: ttn.lorawan.v3.MACCommand.RelayCtrlUplinkListAns
	(*MACCommand_RelayConfigureFwdLimitReq)(nil),           // 109: ttn.lorawan.v3.MACCommand.RelayConfigureFwdLimitReq
	(*MACCommand_RelayConfigureFwdLimitAns)(nil),           // 110: ttn.lorawan.v3.MACCommand.RelayConfigureFwdLimitAns
	(*MACCommand_RelayNotifyNewEndDeviceReq)(nil),          // 111: ttn.lorawan.v3.MACCommand.RelayNotifyNewEndDeviceReq
	(*MACCommand_RelayConfReq_Configuration)(nil),          // 112: ttn.lorawan.v3.MACCommand.RelayConfReq.Configuration
	(*MACCommand_RelayEndDeviceConfReq_Configuration)(nil), // 113: ttn.lorawan.v3.MACCommand.RelayEndDeviceConfReq.Configuration
	(*structpb.Struct)(nil),                                // 114: google.protobuf.Struct
	(*timestamppb.Timestamp)(nil),                          // 115: google.protobuf.Timestamp
	(*GatewayIdentifiers)(nil),                             // 116: ttn.lorawan.v3.GatewayIdentifiers
	(*EndDeviceIdentifiers)(nil),                           // 117: ttn.lorawan.v3.EndDeviceIdentifiers
}
var file_ttn_lorawan_v3_lorawan_proto_depIdxs = []int32{
	30,  // 0: ttn.lorawan.v3.Message.m_hdr:type_name -> ttn.lorawan.v3.MHDR
	31,  // 1: ttn.lorawan.v3.Message.mac_payload:type_name -> ttn.lorawan.v3.MACPayload
	34,  // 2: ttn.lorawan.v3.Message.join_request_payload:type_name -> ttn.lorawan.v3.JoinRequestPayload
	36,  // 3: ttn.lorawan.v3.Message.join_accept_payload:type_name -> ttn.lorawan.v3.JoinAcceptPayload
	35,  // 4: ttn.lorawan.v3.Message.rejoin_request_payload:type_name -> ttn.lorawan.v3.RejoinRequestPayload
	0,   // 5: ttn.lorawan.v3.MHDR.m_type:type_name -> ttn.lorawan.v3.MType
	1,   // 6: ttn.lorawan.v3.MHDR.major:type_name -> ttn.lorawan.v3.Major
	32,  // 7: ttn.lorawan.v3.MACPayload.f_hdr:type_name -> ttn.lorawan.v3.FHDR
	114, // 8: ttn.lorawan.v3.MACPayload.decoded_payload:type_name -> google.protobuf.Struct
	33,  // 9: ttn.lorawan.v3.FHDR.f_ctrl:type_name -> ttn.lorawan.v3.FCtrl
	7,   // 10: ttn.lorawan.v3.RejoinRequestPayload.rejoin_type:type_name -> ttn.lorawan.v3.RejoinRequestType
	37,  // 11: ttn.lorawan.v3.JoinAcceptPayload.dl_settings:type_name -> ttn.lorawan.v3.DLSettings
	27,  // 12: ttn.lorawan.v3.JoinAcceptPayload.rx_delay:type_name -> ttn.lorawan.v3.RxDelay
	38,  // 13: ttn.lorawan.v3.JoinAcceptPayload.cf_list:type_name -> ttn.lorawan.v3.CFList
	5,   // 14: ttn.lorawan.v3.DLSettings.rx1_dr_offset:type_name -> ttn.lorawan.v3.DataRateOffset
	4,   // 15: ttn.lorawan.v3.DLSettings.rx2_dr:type_name -> ttn.lorawan.v3.DataRateIndex
	8,   // 16: ttn.lorawan.v3.CFList.type:type_name -> ttn.lorawan.v3.CFListType
	39,  // 17: ttn.lorawan.v3.DataRate.lora:type_name -> ttn.lorawan.v3.LoRaDataRate
	40,  // 18: ttn.lorawan.v3.DataRate.fsk:type_name -> ttn.lorawan.v3.FSKDataRate
	41,  // 19: ttn.lorawan.v3.DataRate.lrfhss:type_name -> ttn.lorawan.v3.LRFHSSDataRate
	42,  // 20: ttn.lorawan.v3.TxSettings.data_rate:type_name -> ttn.lorawan.v3.DataRate
	115, // 21: ttn.lorawan.v3.TxSettings.time:type_name -> google.protobuf.Timestamp
	70,  // 22: ttn.lorawan.v3.TxSettings.downlink:type_name -> ttn.lorawan.v3.TxSettings.Downlink
	116, // 23: ttn.lorawan.v3.GatewayAntennaIdentifiers.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	116, // 24: ttn.lorawan.v3.ClassBCGatewayIdentifiers.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	44,  // 25: ttn.lorawan.v3.UplinkToken.ids:type_name -> ttn.lorawan.v3.GatewayAntennaIdentifiers
	115, // 26: ttn.lorawan.v3.UplinkToken.server_time:type_name -> google.protobuf.Timestamp
	115, // 27: ttn.lorawan.v3.UplinkToken.gateway_time:type_name -> google.protobuf.Timestamp
	44,  // 28: ttn.lorawan.v3.DownlinkPath.fixed:type_name -> ttn.lorawan.v3.GatewayAntennaIdentifiers
	9,   // 29: ttn.lorawan.v3.TxRequest.class:type_name -> ttn.lorawan.v3.Class
	47,  // 30: ttn.lorawan.v3.TxRequest.downlink_paths:type_name -> ttn.lorawan.v3.DownlinkPath
	27,  // 31: ttn.lorawan.v3.TxRequest.rx1_delay:type_name -> ttn.lorawan.v3.RxDelay
	42,  // 32: ttn.lorawan.v3.TxRequest.rx1_data_rate:type_name -> ttn.lorawan.v3.DataRate
	42,  // 33: ttn.lorawan.v3.TxRequest.rx2_data_rate:type_name -> ttn.lorawan.v3.DataRate
	10,  // 34: ttn.lorawan.v3.TxRequest.priority:type_name -> ttn.lorawan.v3.TxSchedulePriority
	115, // 35: ttn.lorawan.v3.TxRequest.absolute_time:type_name -> google.protobuf.Timestamp
	114, // 36: ttn.lorawan.v3.TxRequest.advanced:type_name -> google.protobuf.Struct
	13,  // 37: ttn.lorawan.v3.RelaySecondChannel.ack_offset:type_name -> ttn.lorawan.v3.RelaySecondChAckOffset
	4,   // 38: ttn.lorawan.v3.RelaySecondChannel.data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	14,  // 39: ttn.lorawan.v3.RelayUplinkForwardLimits.bucket_size:type_name -> ttn.lorawan.v3.RelayLimitBucketSize
	14,  // 40: ttn.lorawan.v3.RelayForwardLimits.bucket_size:type_name -> ttn.lorawan.v3.RelayLimitBucketSize
	15,  // 41: ttn.lorawan.v3.RelayEndDeviceDynamicMode.smart_enable_level:type_name -> ttn.lorawan.v3.RelaySmartEnableLevel
	11,  // 42: ttn.lorawan.v3.MACCommand.cid:type_name -> ttn.lorawan.v3.MACCommandIdentifier
	71,  // 43: ttn.lorawan.v3.MACCommand.reset_ind:type_name -> ttn.lorawan.v3.MACCommand.ResetInd
	72,  // 44: ttn.lorawan.v3.MACCommand.reset_conf:type_name -> ttn.lorawan.v3.MACCommand.ResetConf
	73,  // 45: ttn.lorawan.v3.MACCommand.link_check_ans:type_name -> ttn.lorawan.v3.MACCommand.LinkCheckAns
	74,  // 46: ttn.lorawan.v3.MACCommand.link_adr_req:type_name -> ttn.lorawan.v3.MACCommand.LinkADRReq
	75,  // 47: ttn.lorawan.v3.MACCommand.link_adr_ans:type_name -> ttn.lorawan.v3.MACCommand.LinkADRAns
	76,  // 48: ttn.lorawan.v3.MACCommand.duty_cycle_req:type_name -> ttn.lorawan.v3.MACCommand.DutyCycleReq
	77,  // 49: ttn.lorawan.v3.MACCommand.rx_param_setup_req:type_name -> ttn.lorawan.v3.MACCommand.RxParamSetupReq
	78,  // 50: ttn.lorawan.v3.MACCommand.rx_param_setup_ans:type_name -> ttn.lorawan.v3.MACCommand.RxParamSetupAns
	79,  // 51: ttn.lorawan.v3.MACCommand.dev_status_ans:type_name -> ttn.lorawan.v3.MACCommand.DevStatusAns
	80,  // 52: ttn.lorawan.v3.MACCommand.new_channel_req:type_name -> ttn.lorawan.v3.MACCommand.NewChannelReq
	81,  // 53: ttn.lorawan.v3.MACCommand.new_channel_ans:type_name -> ttn.lorawan.v3.MACCommand.NewChannelAns
	82,  // 54: ttn.lorawan.v3.MACCommand.dl_channel_req:type_name -> ttn.lorawan.v3.MACCommand.DLChannelReq
	83,  // 55: ttn.lorawan.v3.MACCommand.dl_channel_ans:type_name -> ttn.lorawan.v3.MACCommand.DLChannelAns
	84,  // 56: ttn.lorawan.v3.MACCommand.rx_timing_setup_req:type_name -> ttn.lorawan.v3.MACCommand.RxTimingSetupReq
	85,  // 57: ttn.lorawan.v3.MACCommand.tx_param_setup_req:type_name -> ttn.lorawan.v3.MACCommand.TxParamSetupReq
	86,  // 58: ttn.lorawan.v3.MACCommand.rekey_ind:type_name -> ttn.lorawan.v3.MACCommand.RekeyInd
	87,  // 59: ttn.lorawan.v3.MACCommand.rekey_conf:type_name -> ttn.lorawan.v3.MACCommand.RekeyConf
	88,  // 60: ttn.lorawan.v3.MACCommand.adr_param_setup_req:type_name -> ttn.lorawan.v3.MACCommand.ADRParamSetupReq
	89,  // 61: ttn.lorawan.v3.MACCommand.device_time_ans:type_name -> ttn.lorawan.v3.MACCommand.DeviceTimeAns
	90,  // 62: ttn.lorawan.v3.MACCommand.force_rejoin_req:type_name -> ttn.lorawan.v3.MACCommand.ForceRejoinReq
	91,  // 63: ttn.lorawan.v3.MACCommand.rejoin_param_setup_req:type_name -> ttn.lorawan.v3.MACCommand.RejoinParamSetupReq
	92,  // 64: ttn.lorawan.v3.MACCommand.rejoin_param_setup_ans:type_name -> ttn.lorawan.v3.MACCommand.RejoinParamSetupAns
	93,  // 65: ttn.lorawan.v3.MACCommand.ping_slot_info_req:type_name -> ttn.lorawan.v3.MACCommand.PingSlotInfoReq
	94,  // 66: ttn.lorawan.v3.MACCommand.ping_slot_channel_req:type_name -> ttn.lorawan.v3.MACCommand.PingSlotChannelReq
	95,  // 67: ttn.lorawan.v3.MACCommand.ping_slot_channel_ans:type_name -> ttn.lorawan.v3.MACCommand.PingSlotChannelAns
	96,  // 68: ttn.lorawan.v3.MACCommand.beacon_timing_ans:type_name -> ttn.lorawan.v3.MACCommand.BeaconTimingAns
	97,  // 69: ttn.lorawan.v3.MACCommand.beacon_freq_req:type_name -> ttn.lorawan.v3.MACCommand.BeaconFreqReq
	98,  // 70: ttn.lorawan.v3.MACCommand.beacon_freq_ans:type_name -> ttn.lorawan.v3.MACCommand.BeaconFreqAns
	99,  // 71: ttn.lorawan.v3.MACCommand.device_mode_ind:type_name -> ttn.lorawan.v3.MACCommand.DeviceModeInd
	100, // 72: ttn.lorawan.v3.MACCommand.device_mode_conf:type_name -> ttn.lorawan.v3.MACCommand.DeviceModeConf
	101, // 73: ttn.lorawan.v3.MACCommand.relay_conf_req:type_name -> ttn.lorawan.v3.MACCommand.RelayConfReq
	102, // 74: ttn.lorawan.v3.MACCommand.relay_conf_ans:type_name -> ttn.lorawan.v3.MACCommand.RelayConfAns
	103, // 75: ttn.lorawan.v3.MACCommand.relay_end_device_conf_req:type_name -> ttn.lorawan.v3.MACCommand.RelayEndDeviceConfReq
	104, // 76: ttn.lorawan.v3.MACCommand.relay_end_device_conf_ans:type_name -> ttn.lorawan.v3.MACCommand.RelayEndDeviceConfAns
	105, // 77: ttn.lorawan.v3.MACCommand.relay_update_uplink_list_req:type_name -> ttn.lorawan.v3.MACCommand.RelayUpdateUplinkListReq
	106, // 78: ttn.lorawan.v3.MACCommand.relay_update_uplink_list_ans:type_name -> ttn.lorawan.v3.MACCommand.RelayUpdateUplinkListAns
	107, // 79: ttn.lorawan.v3.MACCommand.relay_ctrl_uplink_list_req:type_name -> ttn.lorawan.v3.MACCommand.RelayCtrlUplinkListReq
	108, // 80: ttn.lorawan.v3.MACCommand.relay_ctrl_uplink_list_ans:type_name -> ttn.lorawan.v3.MACCommand.RelayCtrlUplinkListAns
	109, // 81: ttn.lorawan.v3.MACCommand.relay_configure_fwd_limit_req:type_name -> ttn.lorawan.v3.MACCommand.RelayConfigureFwdLimitReq
	110, // 82: ttn.lorawan.v3.MACCommand.relay_configure_fwd_limit_ans:type_name -> ttn.lorawan.v3.MACCommand.RelayConfigureFwdLimitAns
	111, // 83: ttn.lorawan.v3.MACCommand.relay_notify_new_end_device_req:type_name -> ttn.lorawan.v3.MACCommand.RelayNotifyNewEndDeviceReq
	55,  // 84: ttn.lorawan.v3.MACCommands.commands:type_name -> ttn.lorawan.v3.MACCommand
	5,   // 85: ttn.lorawan.v3.DataRateOffsetValue.value:type_name -> ttn.lorawan.v3.DataRateOffset
	4,   // 86: ttn.lorawan.v3.DataRateIndexValue.value:type_name -> ttn.lorawan.v3.DataRateIndex
	20,  // 87: ttn.lorawan.v3.PingSlotPeriodValue.value:type_name -> ttn.lorawan.v3.PingSlotPeriod
	19,  // 88: ttn.lorawan.v3.AggregatedDutyCycleValue.value:type_name -> ttn.lorawan.v3.AggregatedDutyCycle
	27,  // 89: ttn.lorawan.v3.RxDelayValue.value:type_name -> ttn.lorawan.v3.RxDelay
	25,  // 90: ttn.lorawan.v3.ADRAckLimitExponentValue.value:type_name -> ttn.lorawan.v3.ADRAckLimitExponent
	26,  // 91: ttn.lorawan.v3.ADRAckDelayExponentValue.value:type_name -> ttn.lorawan.v3.ADRAckDelayExponent
	24,  // 92: ttn.lorawan.v3.DeviceEIRPValue.value:type_name -> ttn.lorawan.v3.DeviceEIRP
	42,  // 93: ttn.lorawan.v3.RelayForwardUplinkReq.data_rate:type_name -> ttn.lorawan.v3.DataRate
	16,  // 94: ttn.lorawan.v3.RelayForwardUplinkReq.wor_channel:type_name -> ttn.lorawan.v3.RelayWORChannel
	117, // 95: ttn.lorawan.v3.RelayUplinkToken.ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	28,  // 96: ttn.lorawan.v3.MACCommand.ResetInd.minor_version:type_name -> ttn.lorawan.v3.Minor
	28,  // 97: ttn.lorawan.v3.MACCommand.ResetConf.minor_version:type_name -> ttn.lorawan.v3.Minor
	4,   // 98: ttn.lorawan.v3.MACCommand.LinkADRReq.data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	19,  // 99: ttn.lorawan.v3.MACCommand.DutyCycleReq.max_duty_cycle:type_name -> ttn.lorawan.v3.AggregatedDutyCycle
	4,   // 100: ttn.lorawan.v3.MACCommand.RxParamSetupReq.rx2_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	5,   // 101: ttn.lorawan.v3.MACCommand.RxParamSetupReq.rx1_data_rate_offset:type_name -> ttn.lorawan.v3.DataRateOffset
	4,   // 102: ttn.lorawan.v3.MACCommand.NewChannelReq.min_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	4,   // 103: ttn.lorawan.v3.MACCommand.NewChannelReq.max_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	27,  // 104: ttn.lorawan.v3.MACCommand.RxTimingSetupReq.delay:type_name -> ttn.lorawan.v3.RxDelay
	24,  // 105: ttn.lorawan.v3.MACCommand.TxParamSetupReq.max_eirp_index:type_name -> ttn.lorawan.v3.DeviceEIRP
	28,  // 106: ttn.lorawan.v3.MACCommand.RekeyInd.minor_version:type_name -> ttn.lorawan.v3.Minor
	28,  // 107: ttn.lorawan.v3.MACCommand.RekeyConf.minor_version:type_name -> ttn.lorawan.v3.Minor
	25,  // 108: ttn.lorawan.v3.MACCommand.ADRParamSetupReq.adr_ack_limit_exponent:type_name -> ttn.lorawan.v3.ADRAckLimitExponent
	26,  // 109: ttn.lorawan.v3.MACCommand.ADRParamSetupReq.adr_ack_delay_exponent:type_name -> ttn.lorawan.v3.ADRAckDelayExponent
	115, // 110: ttn.lorawan.v3.MACCommand.DeviceTimeAns.time:type_name -> google.protobuf.Timestamp
	7,   // 111: ttn.lorawan.v3.MACCommand.ForceRejoinReq.rejoin_type:type_name -> ttn.lorawan.v3.RejoinRequestType
	4,   // 112: ttn.lorawan.v3.MACCommand.ForceRejoinReq.data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	23,  // 113: ttn.lorawan.v3.MACCommand.ForceRejoinReq.period_exponent:type_name -> ttn.lorawan.v3.RejoinPeriodExponent
	21,  // 114: ttn.lorawan.v3.MACCommand.RejoinParamSetupReq.max_count_exponent:type_name -> ttn.lorawan.v3.RejoinCountExponent
	22,  // 115: ttn.lorawan.v3.MACCommand.RejoinParamSetupReq.max_time_exponent:type_name -> ttn.lorawan.v3.RejoinTimeExponent
	20,  // 116: ttn.lorawan.v3.MACCommand.PingSlotInfoReq.period:type_name -> ttn.lorawan.v3.PingSlotPeriod
	4,   // 117: ttn.lorawan.v3.MACCommand.PingSlotChannelReq.data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	9,   // 118: ttn.lorawan.v3.MACCommand.DeviceModeInd.class:type_name -> ttn.lorawan.v3.Class
	9,   // 119: ttn.lorawan.v3.MACCommand.DeviceModeConf.class:type_name -> ttn.lorawan.v3.Class
	112, // 120: ttn.lorawan.v3.MACCommand.RelayConfReq.configuration:type_name -> ttn.lorawan.v3.MACCommand.RelayConfReq.Configuration
	113, // 121: ttn.lorawan.v3.MACCommand.RelayEndDeviceConfReq.configuration:type_name -> ttn.lorawan.v3.MACCommand.RelayEndDeviceConfReq.Configuration
	50,  // 122: ttn.lorawan.v3.MACCommand.RelayUpdateUplinkListReq.forward_limits:type_name -> ttn.lorawan.v3.RelayUplinkForwardLimits
	18,  // 123: ttn.lorawan.v3.MACCommand.RelayCtrlUplinkListReq.action:type_name -> ttn.lorawan.v3.RelayCtrlUplinkListAction
	17,  // 124: ttn.lorawan.v3.MACCommand.RelayConfigureFwdLimitReq.reset_limit_counter:type_name -> ttn.lorawan.v3.RelayResetLimitCounter
	51,  // 125: ttn.lorawan.v3.MACCommand.RelayConfigureFwdLimitReq.join_request_limits:type_name -> ttn.lorawan.v3.RelayForwardLimits
	51,  // 126: ttn.lorawan.v3.MACCommand.RelayConfigureFwdLimitReq.notify_limits:type_name -> ttn.lorawan.v3.RelayForwardLimits
	51,  // 127: ttn.lorawan.v3.MACCommand.RelayConfigureFwdLimitReq.global_uplink_limits:type_name -> ttn.lorawan.v3.RelayForwardLimits
	51,  // 128: ttn.lorawan.v3.MACCommand.RelayConfigureFwdLimitReq.overall_limits:type_name -> ttn.lorawan.v3.RelayForwardLimits
	49,  // 129: ttn.lorawan.v3.MACCommand.RelayConfReq.Configuration.second_channel:type_name -> ttn.lorawan.v3.RelaySecondChannel
	12,  // 130: ttn.lorawan.v3.MACCommand.RelayConfReq.Configuration.cad_periodicity:type_name -> ttn.lorawan.v3.RelayCADPeriodicity
	52,  // 131: ttn.lorawan.v3.MACCommand.RelayEndDeviceConfReq.Configuration.always:type_name -> ttn.lorawan.v3.RelayEndDeviceAlwaysMode
	53,  // 132: ttn.lorawan.v3.MACCommand.RelayEndDeviceConfReq.Configuration.dynamic:type_name -> ttn.lorawan.v3.RelayEndDeviceDynamicMode
	54,  // 133: ttn.lorawan.v3.MACCommand.RelayEndDeviceConfReq.Configuration.end_device_controlled:type_name -> ttn.lorawan.v3.RelayEndDeviceControlledMode
	49,  // 134: ttn.lorawan.v3.MACCommand.RelayEndDeviceConfReq.Configuration.second_channel:type_name -> ttn.lorawan.v3.RelaySecondChannel
	135, // [135:135] is the sub-list for method output_type
	135, // [135:135] is the sub-list for method input_type
	135, // [135:135] is the sub-list for extension type_name
	135, // [135:135] is the sub-list for extension extendee
	0,   // [0:135] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_lorawan_proto_init() }
func file_ttn_lorawan_v3_lorawan_proto_init() {
	if File_ttn_lorawan_v3_lorawan_proto != nil {
		return
	}
	file_ttn_lorawan_v3_identifiers_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Message); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MHDR); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FHDR); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FCtrl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JoinRequestPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RejoinRequestPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JoinAcceptPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DLSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CFList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoRaDataRate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FSKDataRate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LRFHSSDataRate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataRate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TxSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayAntennaIdentifiers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClassBCGatewayIdentifiers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UplinkToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DownlinkPath); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TxRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelaySecondChannel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelayUplinkForwardLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelayForwardLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelayEndDeviceAlwaysMode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelayEndDeviceDynamicMode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelayEndDeviceControlledMode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommands); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FrequencyValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ZeroableFrequencyValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataRateOffsetValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataRateIndexValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PingSlotPeriodValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregatedDutyCycleValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RxDelayValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ADRAckLimitExponentValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ADRAckDelayExponentValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeviceEIRPValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelayForwardUplinkReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelayForwardDownlinkReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelayUplinkToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TxSettings_Downlink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_ResetInd); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_ResetConf); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_LinkCheckAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_LinkADRReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_LinkADRAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_DutyCycleReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RxParamSetupReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RxParamSetupAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_DevStatusAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_NewChannelReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_NewChannelAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_DLChannelReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_DLChannelAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RxTimingSetupReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_TxParamSetupReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RekeyInd); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RekeyConf); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_ADRParamSetupReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_DeviceTimeAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_ForceRejoinReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RejoinParamSetupReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RejoinParamSetupAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_PingSlotInfoReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_PingSlotChannelReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_PingSlotChannelAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_BeaconTimingAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_BeaconFreqReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_BeaconFreqAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_DeviceModeInd); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_DeviceModeConf); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RelayConfReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RelayConfAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RelayEndDeviceConfReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RelayEndDeviceConfAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RelayUpdateUplinkListReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RelayUpdateUplinkListAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RelayCtrlUplinkListReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RelayCtrlUplinkListAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RelayConfigureFwdLimitReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RelayConfigureFwdLimitAns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RelayNotifyNewEndDeviceReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RelayConfReq_Configuration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_lorawan_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACCommand_RelayEndDeviceConfReq_Configuration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_ttn_lorawan_v3_lorawan_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Message_MacPayload)(nil),
		(*Message_JoinRequestPayload)(nil),
		(*Message_JoinAcceptPayload)(nil),
		(*Message_RejoinRequestPayload)(nil),
	}
	file_ttn_lorawan_v3_lorawan_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*DataRate_Lora)(nil),
		(*DataRate_Fsk)(nil),
		(*DataRate_Lrfhss)(nil),
	}
	file_ttn_lorawan_v3_lorawan_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*DownlinkPath_UplinkToken)(nil),
		(*DownlinkPath_Fixed)(nil),
	}
	file_ttn_lorawan_v3_lorawan_proto_msgTypes[26].OneofWrappers = []interface{}{
		(*MACCommand_RawPayload)(nil),
		(*MACCommand_ResetInd_)(nil),
		(*MACCommand_ResetConf_)(nil),
		(*MACCommand_LinkCheckAns_)(nil),
		(*MACCommand_LinkAdrReq)(nil),
		(*MACCommand_LinkAdrAns)(nil),
		(*MACCommand_DutyCycleReq_)(nil),
		(*MACCommand_RxParamSetupReq_)(nil),
		(*MACCommand_RxParamSetupAns_)(nil),
		(*MACCommand_DevStatusAns_)(nil),
		(*MACCommand_NewChannelReq_)(nil),
		(*MACCommand_NewChannelAns_)(nil),
		(*MACCommand_DlChannelReq)(nil),
		(*MACCommand_DlChannelAns)(nil),
		(*MACCommand_RxTimingSetupReq_)(nil),
		(*MACCommand_TxParamSetupReq_)(nil),
		(*MACCommand_RekeyInd_)(nil),
		(*MACCommand_RekeyConf_)(nil),
		(*MACCommand_AdrParamSetupReq)(nil),
		(*MACCommand_DeviceTimeAns_)(nil),
		(*MACCommand_ForceRejoinReq_)(nil),
		(*MACCommand_RejoinParamSetupReq_)(nil),
		(*MACCommand_RejoinParamSetupAns_)(nil),
		(*MACCommand_PingSlotInfoReq_)(nil),
		(*MACCommand_PingSlotChannelReq_)(nil),
		(*MACCommand_PingSlotChannelAns_)(nil),
		(*MACCommand_BeaconTimingAns_)(nil),
		(*MACCommand_BeaconFreqReq_)(nil),
		(*MACCommand_BeaconFreqAns_)(nil),
		(*MACCommand_DeviceModeInd_)(nil),
		(*MACCommand_DeviceModeConf_)(nil),
		(*MACCommand_RelayConfReq_)(nil),
		(*MACCommand_RelayConfAns_)(nil),
		(*MACCommand_RelayEndDeviceConfReq_)(nil),
		(*MACCommand_RelayEndDeviceConfAns_)(nil),
		(*MACCommand_RelayUpdateUplinkListReq_)(nil),
		(*MACCommand_RelayUpdateUplinkListAns_)(nil),
		(*MACCommand_RelayCtrlUplinkListReq_)(nil),
		(*MACCommand_RelayCtrlUplinkListAns_)(nil),
		(*MACCommand_RelayConfigureFwdLimitReq_)(nil),
		(*MACCommand_RelayConfigureFwdLimitAns_)(nil),
		(*MACCommand_RelayNotifyNewEndDeviceReq_)(nil),
	}
	file_ttn_lorawan_v3_lorawan_proto_msgTypes[84].OneofWrappers = []interface{}{
		(*MACCommand_RelayEndDeviceConfReq_Configuration_Always)(nil),
		(*MACCommand_RelayEndDeviceConfReq_Configuration_Dynamic)(nil),
		(*MACCommand_RelayEndDeviceConfReq_Configuration_EndDeviceControlled)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_lorawan_proto_rawDesc,
			NumEnums:      29,
			NumMessages:   85,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ttn_lorawan_v3_lorawan_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_lorawan_proto_depIdxs,
		EnumInfos:         file_ttn_lorawan_v3_lorawan_proto_enumTypes,
		MessageInfos:      file_ttn_lorawan_v3_lorawan_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_lorawan_proto = out.File
	file_ttn_lorawan_v3_lorawan_proto_rawDesc = nil
	file_ttn_lorawan_v3_lorawan_proto_goTypes = nil
	file_ttn_lorawan_v3_lorawan_proto_depIdxs = nil
}
