// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on KeyEnvelope with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *KeyEnvelope) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = KeyEnvelopeFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "key":

			if len(m.GetKey()) > 0 {

				if len(m.GetKey()) != 16 {
					return KeyEnvelopeValidationError{
						field:  "key",
						reason: "value length must be 16 bytes",
					}
				}

			}

		case "kek_label":

			if utf8.RuneCountInString(m.GetKekLabel()) > 2048 {
				return KeyEnvelopeValidationError{
					field:  "kek_label",
					reason: "value length must be at most 2048 runes",
				}
			}

		case "encrypted_key":

			if len(m.GetEncryptedKey()) > 1024 {
				return KeyEnvelopeValidationError{
					field:  "encrypted_key",
					reason: "value length must be at most 1024 bytes",
				}
			}

		default:
			return KeyEnvelopeValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// KeyEnvelopeValidationError is the validation error returned by
// KeyEnvelope.ValidateFields if the designated constraints aren't met.
type KeyEnvelopeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e KeyEnvelopeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e KeyEnvelopeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e KeyEnvelopeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e KeyEnvelopeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e KeyEnvelopeValidationError) ErrorName() string { return "KeyEnvelopeValidationError" }

// Error satisfies the builtin error interface
func (e KeyEnvelopeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sKeyEnvelope.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = KeyEnvelopeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = KeyEnvelopeValidationError{}

// ValidateFields checks the field values on RootKeys with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *RootKeys) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RootKeysFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "root_key_id":

			if utf8.RuneCountInString(m.GetRootKeyId()) > 2048 {
				return RootKeysValidationError{
					field:  "root_key_id",
					reason: "value length must be at most 2048 runes",
				}
			}

		case "app_key":

			if v, ok := interface{}(m.GetAppKey()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return RootKeysValidationError{
						field:  "app_key",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "nwk_key":

			if v, ok := interface{}(m.GetNwkKey()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return RootKeysValidationError{
						field:  "nwk_key",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return RootKeysValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RootKeysValidationError is the validation error returned by
// RootKeys.ValidateFields if the designated constraints aren't met.
type RootKeysValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RootKeysValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RootKeysValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RootKeysValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RootKeysValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RootKeysValidationError) ErrorName() string { return "RootKeysValidationError" }

// Error satisfies the builtin error interface
func (e RootKeysValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRootKeys.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RootKeysValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RootKeysValidationError{}

// ValidateFields checks the field values on SessionKeys with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *SessionKeys) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SessionKeysFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "session_key_id":

			if len(m.GetSessionKeyId()) > 2048 {
				return SessionKeysValidationError{
					field:  "session_key_id",
					reason: "value length must be at most 2048 bytes",
				}
			}

		case "f_nwk_s_int_key":

			if v, ok := interface{}(m.GetFNwkSIntKey()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SessionKeysValidationError{
						field:  "f_nwk_s_int_key",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "s_nwk_s_int_key":

			if v, ok := interface{}(m.GetSNwkSIntKey()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SessionKeysValidationError{
						field:  "s_nwk_s_int_key",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "nwk_s_enc_key":

			if v, ok := interface{}(m.GetNwkSEncKey()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SessionKeysValidationError{
						field:  "nwk_s_enc_key",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "app_s_key":

			if v, ok := interface{}(m.GetAppSKey()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SessionKeysValidationError{
						field:  "app_s_key",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return SessionKeysValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// SessionKeysValidationError is the validation error returned by
// SessionKeys.ValidateFields if the designated constraints aren't met.
type SessionKeysValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SessionKeysValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SessionKeysValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SessionKeysValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SessionKeysValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SessionKeysValidationError) ErrorName() string { return "SessionKeysValidationError" }

// Error satisfies the builtin error interface
func (e SessionKeysValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSessionKeys.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SessionKeysValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SessionKeysValidationError{}
