// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/keys.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type KeyEnvelope struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unencrypted AES key.
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The label of the RFC 3394 key-encryption-key (KEK) that was used to encrypt the key.
	KekLabel     string `protobuf:"bytes,2,opt,name=kek_label,json=kekLabel,proto3" json:"kek_label,omitempty"`
	EncryptedKey []byte `protobuf:"bytes,3,opt,name=encrypted_key,json=encryptedKey,proto3" json:"encrypted_key,omitempty"`
}

func (x *KeyEnvelope) Reset() {
	*x = KeyEnvelope{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_keys_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyEnvelope) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyEnvelope) ProtoMessage() {}

func (x *KeyEnvelope) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_keys_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyEnvelope.ProtoReflect.Descriptor instead.
func (*KeyEnvelope) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_keys_proto_rawDescGZIP(), []int{0}
}

func (x *KeyEnvelope) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *KeyEnvelope) GetKekLabel() string {
	if x != nil {
		return x.KekLabel
	}
	return ""
}

func (x *KeyEnvelope) GetEncryptedKey() []byte {
	if x != nil {
		return x.EncryptedKey
	}
	return nil
}

// Root keys for a LoRaWAN device.
// These are stored on the Join Server.
type RootKeys struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Join Server issued identifier for the root keys.
	RootKeyId string `protobuf:"bytes,1,opt,name=root_key_id,json=rootKeyId,proto3" json:"root_key_id,omitempty"`
	// The (encrypted) Application Key.
	AppKey *KeyEnvelope `protobuf:"bytes,2,opt,name=app_key,json=appKey,proto3" json:"app_key,omitempty"`
	// The (encrypted) Network Key.
	NwkKey *KeyEnvelope `protobuf:"bytes,3,opt,name=nwk_key,json=nwkKey,proto3" json:"nwk_key,omitempty"`
}

func (x *RootKeys) Reset() {
	*x = RootKeys{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_keys_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RootKeys) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RootKeys) ProtoMessage() {}

func (x *RootKeys) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_keys_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RootKeys.ProtoReflect.Descriptor instead.
func (*RootKeys) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_keys_proto_rawDescGZIP(), []int{1}
}

func (x *RootKeys) GetRootKeyId() string {
	if x != nil {
		return x.RootKeyId
	}
	return ""
}

func (x *RootKeys) GetAppKey() *KeyEnvelope {
	if x != nil {
		return x.AppKey
	}
	return nil
}

func (x *RootKeys) GetNwkKey() *KeyEnvelope {
	if x != nil {
		return x.NwkKey
	}
	return nil
}

// Session keys for a LoRaWAN session.
// Only the components for which the keys were meant, will have the key-encryption-key (KEK) to decrypt the individual keys.
type SessionKeys struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Join Server issued identifier for the session keys.
	// This ID can be used to request the keys from the Join Server in case the are lost.
	SessionKeyId []byte `protobuf:"bytes,1,opt,name=session_key_id,json=sessionKeyId,proto3" json:"session_key_id,omitempty"`
	// The (encrypted) Forwarding Network Session Integrity Key (or Network Session Key in 1.0 compatibility mode).
	// This key is stored by the (forwarding) Network Server.
	FNwkSIntKey *KeyEnvelope `protobuf:"bytes,2,opt,name=f_nwk_s_int_key,json=fNwkSIntKey,proto3" json:"f_nwk_s_int_key,omitempty"`
	// The (encrypted) Serving Network Session Integrity Key.
	// This key is stored by the (serving) Network Server.
	SNwkSIntKey *KeyEnvelope `protobuf:"bytes,3,opt,name=s_nwk_s_int_key,json=sNwkSIntKey,proto3" json:"s_nwk_s_int_key,omitempty"`
	// The (encrypted) Network Session Encryption Key.
	// This key is stored by the (serving) Network Server.
	NwkSEncKey *KeyEnvelope `protobuf:"bytes,4,opt,name=nwk_s_enc_key,json=nwkSEncKey,proto3" json:"nwk_s_enc_key,omitempty"`
	// The (encrypted) Application Session Key.
	// This key is stored by the Application Server.
	AppSKey *KeyEnvelope `protobuf:"bytes,5,opt,name=app_s_key,json=appSKey,proto3" json:"app_s_key,omitempty"`
}

func (x *SessionKeys) Reset() {
	*x = SessionKeys{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_keys_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionKeys) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionKeys) ProtoMessage() {}

func (x *SessionKeys) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_keys_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionKeys.ProtoReflect.Descriptor instead.
func (*SessionKeys) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_keys_proto_rawDescGZIP(), []int{2}
}

func (x *SessionKeys) GetSessionKeyId() []byte {
	if x != nil {
		return x.SessionKeyId
	}
	return nil
}

func (x *SessionKeys) GetFNwkSIntKey() *KeyEnvelope {
	if x != nil {
		return x.FNwkSIntKey
	}
	return nil
}

func (x *SessionKeys) GetSNwkSIntKey() *KeyEnvelope {
	if x != nil {
		return x.SNwkSIntKey
	}
	return nil
}

func (x *SessionKeys) GetNwkSEncKey() *KeyEnvelope {
	if x != nil {
		return x.NwkSEncKey
	}
	return nil
}

func (x *SessionKeys) GetAppSKey() *KeyEnvelope {
	if x != nil {
		return x.AppSKey
	}
	return nil
}

var File_ttn_lorawan_v3_keys_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_keys_proto_rawDesc = []byte{
	0x0a, 0x19, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76,
	0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x74, 0x68, 0x65,
	0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x6a, 0x73, 0x6f, 0x6e, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8e, 0x05, 0x0a, 0x0b, 0x4b, 0x65,
	0x79, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x12, 0xfe, 0x02, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xeb, 0x02, 0x92, 0x41, 0x31, 0x4a, 0x22, 0x22,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46,
	0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42,
	0x06, 0x7a, 0x04, 0x68, 0x10, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x83, 0x01, 0x0a, 0x3f, 0x67, 0x6f,
	0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61,
	0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x40, 0x67,
	0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55,
	0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x31, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2,
	0xaa, 0x19, 0xa1, 0x01, 0x1a, 0x4f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f,
	0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x31, 0x36, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64,
	0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63, 0x74,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x25, 0x0a, 0x09, 0x6b, 0x65,
	0x6b, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x72, 0x03, 0x18, 0x80, 0x10, 0x52, 0x08, 0x6b, 0x65, 0x6b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x12, 0xcc, 0x01, 0x0a, 0x0d, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xa6, 0x01, 0xfa, 0x42, 0x05, 0x7a,
	0x03, 0x18, 0x80, 0x08, 0xf2, 0xaa, 0x19, 0x99, 0x01, 0x1a, 0x4e, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x68, 0x65, 0x54, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x49,
	0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f, 0x2d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f, 0x66, 0x6c,
	0x61, 0x67, 0x73, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x4e, 0x65, 0x77, 0x48, 0x65, 0x78,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x47, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x68, 0x65, 0x54, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x49,
	0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f, 0x2d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f, 0x66, 0x6c,
	0x61, 0x67, 0x73, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x52, 0x0c, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x4b, 0x65, 0x79,
	0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0xaa, 0x01, 0x0a, 0x08, 0x52,
	0x6f, 0x6f, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x28, 0x0a, 0x0b, 0x72, 0x6f, 0x6f, 0x74, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x72, 0x03, 0x18, 0x80, 0x10, 0x52, 0x09, 0x72, 0x6f, 0x6f, 0x74, 0x4b, 0x65, 0x79, 0x49,
	0x64, 0x12, 0x34, 0x0a, 0x07, 0x61, 0x70, 0x70, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x52,
	0x06, 0x61, 0x70, 0x70, 0x4b, 0x65, 0x79, 0x12, 0x34, 0x0a, 0x07, 0x6e, 0x77, 0x6b, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x76,
	0x65, 0x6c, 0x6f, 0x70, 0x65, 0x52, 0x06, 0x6e, 0x77, 0x6b, 0x4b, 0x65, 0x79, 0x3a, 0x08, 0xf2,
	0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0xc6, 0x02, 0x0a, 0x0b, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x2e, 0x0a, 0x0e, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x7a, 0x03, 0x18, 0x80, 0x10, 0x52, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x41, 0x0a, 0x0f, 0x66, 0x5f, 0x6e, 0x77, 0x6b,
	0x5f, 0x73, 0x5f, 0x69, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x52, 0x0b, 0x66,
	0x4e, 0x77, 0x6b, 0x53, 0x49, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x41, 0x0a, 0x0f, 0x73, 0x5f,
	0x6e, 0x77, 0x6b, 0x5f, 0x73, 0x5f, 0x69, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65,
	0x52, 0x0b, 0x73, 0x4e, 0x77, 0x6b, 0x53, 0x49, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x3e, 0x0a,
	0x0d, 0x6e, 0x77, 0x6b, 0x5f, 0x73, 0x5f, 0x65, 0x6e, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x52, 0x0a, 0x6e, 0x77, 0x6b, 0x53, 0x45, 0x6e, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x37, 0x0a,
	0x09, 0x61, 0x70, 0x70, 0x5f, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x52, 0x07, 0x61,
	0x70, 0x70, 0x53, 0x4b, 0x65, 0x79, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01,
	0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74,
	0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_keys_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_keys_proto_rawDescData = file_ttn_lorawan_v3_keys_proto_rawDesc
)

func file_ttn_lorawan_v3_keys_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_keys_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_keys_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_keys_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_keys_proto_rawDescData
}

var file_ttn_lorawan_v3_keys_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_ttn_lorawan_v3_keys_proto_goTypes = []interface{}{
	(*KeyEnvelope)(nil), // 0: ttn.lorawan.v3.KeyEnvelope
	(*RootKeys)(nil),    // 1: ttn.lorawan.v3.RootKeys
	(*SessionKeys)(nil), // 2: ttn.lorawan.v3.SessionKeys
}
var file_ttn_lorawan_v3_keys_proto_depIdxs = []int32{
	0, // 0: ttn.lorawan.v3.RootKeys.app_key:type_name -> ttn.lorawan.v3.KeyEnvelope
	0, // 1: ttn.lorawan.v3.RootKeys.nwk_key:type_name -> ttn.lorawan.v3.KeyEnvelope
	0, // 2: ttn.lorawan.v3.SessionKeys.f_nwk_s_int_key:type_name -> ttn.lorawan.v3.KeyEnvelope
	0, // 3: ttn.lorawan.v3.SessionKeys.s_nwk_s_int_key:type_name -> ttn.lorawan.v3.KeyEnvelope
	0, // 4: ttn.lorawan.v3.SessionKeys.nwk_s_enc_key:type_name -> ttn.lorawan.v3.KeyEnvelope
	0, // 5: ttn.lorawan.v3.SessionKeys.app_s_key:type_name -> ttn.lorawan.v3.KeyEnvelope
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_keys_proto_init() }
func file_ttn_lorawan_v3_keys_proto_init() {
	if File_ttn_lorawan_v3_keys_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_keys_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyEnvelope); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_keys_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RootKeys); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_keys_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionKeys); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_keys_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ttn_lorawan_v3_keys_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_keys_proto_depIdxs,
		MessageInfos:      file_ttn_lorawan_v3_keys_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_keys_proto = out.File
	file_ttn_lorawan_v3_keys_proto_rawDesc = nil
	file_ttn_lorawan_v3_keys_proto_goTypes = nil
	file_ttn_lorawan_v3_keys_proto_depIdxs = nil
}
