// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.1
// source: ttn/lorawan/v3/joinserver.proto

package ttnpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	NsJs_HandleJoin_FullMethodName  = "/ttn.lorawan.v3.NsJs/HandleJoin"
	NsJs_GetNwkSKeys_FullMethodName = "/ttn.lorawan.v3.NsJs/GetNwkSKeys"
)

// NsJsClient is the client API for NsJs service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NsJsClient interface {
	// Handle a join-request message.
	HandleJoin(ctx context.Context, in *JoinRequest, opts ...grpc.CallOption) (*JoinResponse, error)
	// Request the network session keys for a particular session.
	GetNwkSKeys(ctx context.Context, in *SessionKeyRequest, opts ...grpc.CallOption) (*NwkSKeysResponse, error)
}

type nsJsClient struct {
	cc grpc.ClientConnInterface
}

func NewNsJsClient(cc grpc.ClientConnInterface) NsJsClient {
	return &nsJsClient{cc}
}

func (c *nsJsClient) HandleJoin(ctx context.Context, in *JoinRequest, opts ...grpc.CallOption) (*JoinResponse, error) {
	out := new(JoinResponse)
	err := c.cc.Invoke(ctx, NsJs_HandleJoin_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nsJsClient) GetNwkSKeys(ctx context.Context, in *SessionKeyRequest, opts ...grpc.CallOption) (*NwkSKeysResponse, error) {
	out := new(NwkSKeysResponse)
	err := c.cc.Invoke(ctx, NsJs_GetNwkSKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NsJsServer is the server API for NsJs service.
// All implementations must embed UnimplementedNsJsServer
// for forward compatibility
type NsJsServer interface {
	// Handle a join-request message.
	HandleJoin(context.Context, *JoinRequest) (*JoinResponse, error)
	// Request the network session keys for a particular session.
	GetNwkSKeys(context.Context, *SessionKeyRequest) (*NwkSKeysResponse, error)
	mustEmbedUnimplementedNsJsServer()
}

// UnimplementedNsJsServer must be embedded to have forward compatible implementations.
type UnimplementedNsJsServer struct {
}

func (UnimplementedNsJsServer) HandleJoin(context.Context, *JoinRequest) (*JoinResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleJoin not implemented")
}
func (UnimplementedNsJsServer) GetNwkSKeys(context.Context, *SessionKeyRequest) (*NwkSKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNwkSKeys not implemented")
}
func (UnimplementedNsJsServer) mustEmbedUnimplementedNsJsServer() {}

// UnsafeNsJsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NsJsServer will
// result in compilation errors.
type UnsafeNsJsServer interface {
	mustEmbedUnimplementedNsJsServer()
}

func RegisterNsJsServer(s grpc.ServiceRegistrar, srv NsJsServer) {
	s.RegisterService(&NsJs_ServiceDesc, srv)
}

func _NsJs_HandleJoin_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(JoinRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NsJsServer).HandleJoin(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NsJs_HandleJoin_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NsJsServer).HandleJoin(ctx, req.(*JoinRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NsJs_GetNwkSKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SessionKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NsJsServer).GetNwkSKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NsJs_GetNwkSKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NsJsServer).GetNwkSKeys(ctx, req.(*SessionKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NsJs_ServiceDesc is the grpc.ServiceDesc for NsJs service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NsJs_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.NsJs",
	HandlerType: (*NsJsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleJoin",
			Handler:    _NsJs_HandleJoin_Handler,
		},
		{
			MethodName: "GetNwkSKeys",
			Handler:    _NsJs_GetNwkSKeys_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/joinserver.proto",
}

const (
	AsJs_GetAppSKey_FullMethodName = "/ttn.lorawan.v3.AsJs/GetAppSKey"
)

// AsJsClient is the client API for AsJs service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AsJsClient interface {
	// Request the application session key for a particular session.
	GetAppSKey(ctx context.Context, in *SessionKeyRequest, opts ...grpc.CallOption) (*AppSKeyResponse, error)
}

type asJsClient struct {
	cc grpc.ClientConnInterface
}

func NewAsJsClient(cc grpc.ClientConnInterface) AsJsClient {
	return &asJsClient{cc}
}

func (c *asJsClient) GetAppSKey(ctx context.Context, in *SessionKeyRequest, opts ...grpc.CallOption) (*AppSKeyResponse, error) {
	out := new(AppSKeyResponse)
	err := c.cc.Invoke(ctx, AsJs_GetAppSKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AsJsServer is the server API for AsJs service.
// All implementations must embed UnimplementedAsJsServer
// for forward compatibility
type AsJsServer interface {
	// Request the application session key for a particular session.
	GetAppSKey(context.Context, *SessionKeyRequest) (*AppSKeyResponse, error)
	mustEmbedUnimplementedAsJsServer()
}

// UnimplementedAsJsServer must be embedded to have forward compatible implementations.
type UnimplementedAsJsServer struct {
}

func (UnimplementedAsJsServer) GetAppSKey(context.Context, *SessionKeyRequest) (*AppSKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAppSKey not implemented")
}
func (UnimplementedAsJsServer) mustEmbedUnimplementedAsJsServer() {}

// UnsafeAsJsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AsJsServer will
// result in compilation errors.
type UnsafeAsJsServer interface {
	mustEmbedUnimplementedAsJsServer()
}

func RegisterAsJsServer(s grpc.ServiceRegistrar, srv AsJsServer) {
	s.RegisterService(&AsJs_ServiceDesc, srv)
}

func _AsJs_GetAppSKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SessionKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AsJsServer).GetAppSKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AsJs_GetAppSKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AsJsServer).GetAppSKey(ctx, req.(*SessionKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AsJs_ServiceDesc is the grpc.ServiceDesc for AsJs service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AsJs_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.AsJs",
	HandlerType: (*AsJsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAppSKey",
			Handler:    _AsJs_GetAppSKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/joinserver.proto",
}

const (
	AppJs_GetAppSKey_FullMethodName = "/ttn.lorawan.v3.AppJs/GetAppSKey"
)

// AppJsClient is the client API for AppJs service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AppJsClient interface {
	// Request the application session key for a particular session.
	GetAppSKey(ctx context.Context, in *SessionKeyRequest, opts ...grpc.CallOption) (*AppSKeyResponse, error)
}

type appJsClient struct {
	cc grpc.ClientConnInterface
}

func NewAppJsClient(cc grpc.ClientConnInterface) AppJsClient {
	return &appJsClient{cc}
}

func (c *appJsClient) GetAppSKey(ctx context.Context, in *SessionKeyRequest, opts ...grpc.CallOption) (*AppSKeyResponse, error) {
	out := new(AppSKeyResponse)
	err := c.cc.Invoke(ctx, AppJs_GetAppSKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AppJsServer is the server API for AppJs service.
// All implementations must embed UnimplementedAppJsServer
// for forward compatibility
type AppJsServer interface {
	// Request the application session key for a particular session.
	GetAppSKey(context.Context, *SessionKeyRequest) (*AppSKeyResponse, error)
	mustEmbedUnimplementedAppJsServer()
}

// UnimplementedAppJsServer must be embedded to have forward compatible implementations.
type UnimplementedAppJsServer struct {
}

func (UnimplementedAppJsServer) GetAppSKey(context.Context, *SessionKeyRequest) (*AppSKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAppSKey not implemented")
}
func (UnimplementedAppJsServer) mustEmbedUnimplementedAppJsServer() {}

// UnsafeAppJsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AppJsServer will
// result in compilation errors.
type UnsafeAppJsServer interface {
	mustEmbedUnimplementedAppJsServer()
}

func RegisterAppJsServer(s grpc.ServiceRegistrar, srv AppJsServer) {
	s.RegisterService(&AppJs_ServiceDesc, srv)
}

func _AppJs_GetAppSKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SessionKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppJsServer).GetAppSKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppJs_GetAppSKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppJsServer).GetAppSKey(ctx, req.(*SessionKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AppJs_ServiceDesc is the grpc.ServiceDesc for AppJs service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AppJs_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.AppJs",
	HandlerType: (*AppJsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAppSKey",
			Handler:    _AppJs_GetAppSKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/joinserver.proto",
}

const (
	NetworkCryptoService_JoinRequestMIC_FullMethodName      = "/ttn.lorawan.v3.NetworkCryptoService/JoinRequestMIC"
	NetworkCryptoService_JoinAcceptMIC_FullMethodName       = "/ttn.lorawan.v3.NetworkCryptoService/JoinAcceptMIC"
	NetworkCryptoService_EncryptJoinAccept_FullMethodName   = "/ttn.lorawan.v3.NetworkCryptoService/EncryptJoinAccept"
	NetworkCryptoService_EncryptRejoinAccept_FullMethodName = "/ttn.lorawan.v3.NetworkCryptoService/EncryptRejoinAccept"
	NetworkCryptoService_DeriveNwkSKeys_FullMethodName      = "/ttn.lorawan.v3.NetworkCryptoService/DeriveNwkSKeys"
	NetworkCryptoService_GetNwkKey_FullMethodName           = "/ttn.lorawan.v3.NetworkCryptoService/GetNwkKey"
)

// NetworkCryptoServiceClient is the client API for NetworkCryptoService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NetworkCryptoServiceClient interface {
	// Calculate the join-request message MIC.
	JoinRequestMIC(ctx context.Context, in *CryptoServicePayloadRequest, opts ...grpc.CallOption) (*CryptoServicePayloadResponse, error)
	// Calculate the join-accept message MIC.
	JoinAcceptMIC(ctx context.Context, in *JoinAcceptMICRequest, opts ...grpc.CallOption) (*CryptoServicePayloadResponse, error)
	// Encrypt the join-accept payload.
	EncryptJoinAccept(ctx context.Context, in *CryptoServicePayloadRequest, opts ...grpc.CallOption) (*CryptoServicePayloadResponse, error)
	// Encrypt the rejoin-accept payload.
	EncryptRejoinAccept(ctx context.Context, in *CryptoServicePayloadRequest, opts ...grpc.CallOption) (*CryptoServicePayloadResponse, error)
	// Derive network session keys (NwkSKey, or FNwkSKey, SNwkSKey and NwkSEncKey)
	DeriveNwkSKeys(ctx context.Context, in *DeriveSessionKeysRequest, opts ...grpc.CallOption) (*NwkSKeysResponse, error)
	// Get the NwkKey. Crypto Servers may return status code FAILED_PRECONDITION when root keys are not exposed.
	GetNwkKey(ctx context.Context, in *GetRootKeysRequest, opts ...grpc.CallOption) (*KeyEnvelope, error)
}

type networkCryptoServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewNetworkCryptoServiceClient(cc grpc.ClientConnInterface) NetworkCryptoServiceClient {
	return &networkCryptoServiceClient{cc}
}

func (c *networkCryptoServiceClient) JoinRequestMIC(ctx context.Context, in *CryptoServicePayloadRequest, opts ...grpc.CallOption) (*CryptoServicePayloadResponse, error) {
	out := new(CryptoServicePayloadResponse)
	err := c.cc.Invoke(ctx, NetworkCryptoService_JoinRequestMIC_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkCryptoServiceClient) JoinAcceptMIC(ctx context.Context, in *JoinAcceptMICRequest, opts ...grpc.CallOption) (*CryptoServicePayloadResponse, error) {
	out := new(CryptoServicePayloadResponse)
	err := c.cc.Invoke(ctx, NetworkCryptoService_JoinAcceptMIC_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkCryptoServiceClient) EncryptJoinAccept(ctx context.Context, in *CryptoServicePayloadRequest, opts ...grpc.CallOption) (*CryptoServicePayloadResponse, error) {
	out := new(CryptoServicePayloadResponse)
	err := c.cc.Invoke(ctx, NetworkCryptoService_EncryptJoinAccept_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkCryptoServiceClient) EncryptRejoinAccept(ctx context.Context, in *CryptoServicePayloadRequest, opts ...grpc.CallOption) (*CryptoServicePayloadResponse, error) {
	out := new(CryptoServicePayloadResponse)
	err := c.cc.Invoke(ctx, NetworkCryptoService_EncryptRejoinAccept_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkCryptoServiceClient) DeriveNwkSKeys(ctx context.Context, in *DeriveSessionKeysRequest, opts ...grpc.CallOption) (*NwkSKeysResponse, error) {
	out := new(NwkSKeysResponse)
	err := c.cc.Invoke(ctx, NetworkCryptoService_DeriveNwkSKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkCryptoServiceClient) GetNwkKey(ctx context.Context, in *GetRootKeysRequest, opts ...grpc.CallOption) (*KeyEnvelope, error) {
	out := new(KeyEnvelope)
	err := c.cc.Invoke(ctx, NetworkCryptoService_GetNwkKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetworkCryptoServiceServer is the server API for NetworkCryptoService service.
// All implementations must embed UnimplementedNetworkCryptoServiceServer
// for forward compatibility
type NetworkCryptoServiceServer interface {
	// Calculate the join-request message MIC.
	JoinRequestMIC(context.Context, *CryptoServicePayloadRequest) (*CryptoServicePayloadResponse, error)
	// Calculate the join-accept message MIC.
	JoinAcceptMIC(context.Context, *JoinAcceptMICRequest) (*CryptoServicePayloadResponse, error)
	// Encrypt the join-accept payload.
	EncryptJoinAccept(context.Context, *CryptoServicePayloadRequest) (*CryptoServicePayloadResponse, error)
	// Encrypt the rejoin-accept payload.
	EncryptRejoinAccept(context.Context, *CryptoServicePayloadRequest) (*CryptoServicePayloadResponse, error)
	// Derive network session keys (NwkSKey, or FNwkSKey, SNwkSKey and NwkSEncKey)
	DeriveNwkSKeys(context.Context, *DeriveSessionKeysRequest) (*NwkSKeysResponse, error)
	// Get the NwkKey. Crypto Servers may return status code FAILED_PRECONDITION when root keys are not exposed.
	GetNwkKey(context.Context, *GetRootKeysRequest) (*KeyEnvelope, error)
	mustEmbedUnimplementedNetworkCryptoServiceServer()
}

// UnimplementedNetworkCryptoServiceServer must be embedded to have forward compatible implementations.
type UnimplementedNetworkCryptoServiceServer struct {
}

func (UnimplementedNetworkCryptoServiceServer) JoinRequestMIC(context.Context, *CryptoServicePayloadRequest) (*CryptoServicePayloadResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method JoinRequestMIC not implemented")
}
func (UnimplementedNetworkCryptoServiceServer) JoinAcceptMIC(context.Context, *JoinAcceptMICRequest) (*CryptoServicePayloadResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method JoinAcceptMIC not implemented")
}
func (UnimplementedNetworkCryptoServiceServer) EncryptJoinAccept(context.Context, *CryptoServicePayloadRequest) (*CryptoServicePayloadResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EncryptJoinAccept not implemented")
}
func (UnimplementedNetworkCryptoServiceServer) EncryptRejoinAccept(context.Context, *CryptoServicePayloadRequest) (*CryptoServicePayloadResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EncryptRejoinAccept not implemented")
}
func (UnimplementedNetworkCryptoServiceServer) DeriveNwkSKeys(context.Context, *DeriveSessionKeysRequest) (*NwkSKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeriveNwkSKeys not implemented")
}
func (UnimplementedNetworkCryptoServiceServer) GetNwkKey(context.Context, *GetRootKeysRequest) (*KeyEnvelope, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNwkKey not implemented")
}
func (UnimplementedNetworkCryptoServiceServer) mustEmbedUnimplementedNetworkCryptoServiceServer() {}

// UnsafeNetworkCryptoServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NetworkCryptoServiceServer will
// result in compilation errors.
type UnsafeNetworkCryptoServiceServer interface {
	mustEmbedUnimplementedNetworkCryptoServiceServer()
}

func RegisterNetworkCryptoServiceServer(s grpc.ServiceRegistrar, srv NetworkCryptoServiceServer) {
	s.RegisterService(&NetworkCryptoService_ServiceDesc, srv)
}

func _NetworkCryptoService_JoinRequestMIC_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CryptoServicePayloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkCryptoServiceServer).JoinRequestMIC(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkCryptoService_JoinRequestMIC_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkCryptoServiceServer).JoinRequestMIC(ctx, req.(*CryptoServicePayloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkCryptoService_JoinAcceptMIC_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(JoinAcceptMICRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkCryptoServiceServer).JoinAcceptMIC(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkCryptoService_JoinAcceptMIC_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkCryptoServiceServer).JoinAcceptMIC(ctx, req.(*JoinAcceptMICRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkCryptoService_EncryptJoinAccept_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CryptoServicePayloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkCryptoServiceServer).EncryptJoinAccept(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkCryptoService_EncryptJoinAccept_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkCryptoServiceServer).EncryptJoinAccept(ctx, req.(*CryptoServicePayloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkCryptoService_EncryptRejoinAccept_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CryptoServicePayloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkCryptoServiceServer).EncryptRejoinAccept(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkCryptoService_EncryptRejoinAccept_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkCryptoServiceServer).EncryptRejoinAccept(ctx, req.(*CryptoServicePayloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkCryptoService_DeriveNwkSKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeriveSessionKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkCryptoServiceServer).DeriveNwkSKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkCryptoService_DeriveNwkSKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkCryptoServiceServer).DeriveNwkSKeys(ctx, req.(*DeriveSessionKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkCryptoService_GetNwkKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRootKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkCryptoServiceServer).GetNwkKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkCryptoService_GetNwkKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkCryptoServiceServer).GetNwkKey(ctx, req.(*GetRootKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NetworkCryptoService_ServiceDesc is the grpc.ServiceDesc for NetworkCryptoService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NetworkCryptoService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.NetworkCryptoService",
	HandlerType: (*NetworkCryptoServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "JoinRequestMIC",
			Handler:    _NetworkCryptoService_JoinRequestMIC_Handler,
		},
		{
			MethodName: "JoinAcceptMIC",
			Handler:    _NetworkCryptoService_JoinAcceptMIC_Handler,
		},
		{
			MethodName: "EncryptJoinAccept",
			Handler:    _NetworkCryptoService_EncryptJoinAccept_Handler,
		},
		{
			MethodName: "EncryptRejoinAccept",
			Handler:    _NetworkCryptoService_EncryptRejoinAccept_Handler,
		},
		{
			MethodName: "DeriveNwkSKeys",
			Handler:    _NetworkCryptoService_DeriveNwkSKeys_Handler,
		},
		{
			MethodName: "GetNwkKey",
			Handler:    _NetworkCryptoService_GetNwkKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/joinserver.proto",
}

const (
	ApplicationCryptoService_DeriveAppSKey_FullMethodName = "/ttn.lorawan.v3.ApplicationCryptoService/DeriveAppSKey"
	ApplicationCryptoService_GetAppKey_FullMethodName     = "/ttn.lorawan.v3.ApplicationCryptoService/GetAppKey"
)

// ApplicationCryptoServiceClient is the client API for ApplicationCryptoService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ApplicationCryptoServiceClient interface {
	// Derive the application session key (AppSKey).
	DeriveAppSKey(ctx context.Context, in *DeriveSessionKeysRequest, opts ...grpc.CallOption) (*AppSKeyResponse, error)
	// Get the AppKey. Crypto Servers may return status code FAILED_PRECONDITION when root keys are not exposed.
	GetAppKey(ctx context.Context, in *GetRootKeysRequest, opts ...grpc.CallOption) (*KeyEnvelope, error)
}

type applicationCryptoServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewApplicationCryptoServiceClient(cc grpc.ClientConnInterface) ApplicationCryptoServiceClient {
	return &applicationCryptoServiceClient{cc}
}

func (c *applicationCryptoServiceClient) DeriveAppSKey(ctx context.Context, in *DeriveSessionKeysRequest, opts ...grpc.CallOption) (*AppSKeyResponse, error) {
	out := new(AppSKeyResponse)
	err := c.cc.Invoke(ctx, ApplicationCryptoService_DeriveAppSKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationCryptoServiceClient) GetAppKey(ctx context.Context, in *GetRootKeysRequest, opts ...grpc.CallOption) (*KeyEnvelope, error) {
	out := new(KeyEnvelope)
	err := c.cc.Invoke(ctx, ApplicationCryptoService_GetAppKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApplicationCryptoServiceServer is the server API for ApplicationCryptoService service.
// All implementations must embed UnimplementedApplicationCryptoServiceServer
// for forward compatibility
type ApplicationCryptoServiceServer interface {
	// Derive the application session key (AppSKey).
	DeriveAppSKey(context.Context, *DeriveSessionKeysRequest) (*AppSKeyResponse, error)
	// Get the AppKey. Crypto Servers may return status code FAILED_PRECONDITION when root keys are not exposed.
	GetAppKey(context.Context, *GetRootKeysRequest) (*KeyEnvelope, error)
	mustEmbedUnimplementedApplicationCryptoServiceServer()
}

// UnimplementedApplicationCryptoServiceServer must be embedded to have forward compatible implementations.
type UnimplementedApplicationCryptoServiceServer struct {
}

func (UnimplementedApplicationCryptoServiceServer) DeriveAppSKey(context.Context, *DeriveSessionKeysRequest) (*AppSKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeriveAppSKey not implemented")
}
func (UnimplementedApplicationCryptoServiceServer) GetAppKey(context.Context, *GetRootKeysRequest) (*KeyEnvelope, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAppKey not implemented")
}
func (UnimplementedApplicationCryptoServiceServer) mustEmbedUnimplementedApplicationCryptoServiceServer() {
}

// UnsafeApplicationCryptoServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ApplicationCryptoServiceServer will
// result in compilation errors.
type UnsafeApplicationCryptoServiceServer interface {
	mustEmbedUnimplementedApplicationCryptoServiceServer()
}

func RegisterApplicationCryptoServiceServer(s grpc.ServiceRegistrar, srv ApplicationCryptoServiceServer) {
	s.RegisterService(&ApplicationCryptoService_ServiceDesc, srv)
}

func _ApplicationCryptoService_DeriveAppSKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeriveSessionKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationCryptoServiceServer).DeriveAppSKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationCryptoService_DeriveAppSKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationCryptoServiceServer).DeriveAppSKey(ctx, req.(*DeriveSessionKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationCryptoService_GetAppKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRootKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationCryptoServiceServer).GetAppKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationCryptoService_GetAppKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationCryptoServiceServer).GetAppKey(ctx, req.(*GetRootKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ApplicationCryptoService_ServiceDesc is the grpc.ServiceDesc for ApplicationCryptoService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ApplicationCryptoService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.ApplicationCryptoService",
	HandlerType: (*ApplicationCryptoServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DeriveAppSKey",
			Handler:    _ApplicationCryptoService_DeriveAppSKey_Handler,
		},
		{
			MethodName: "GetAppKey",
			Handler:    _ApplicationCryptoService_GetAppKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/joinserver.proto",
}

const (
	JsEndDeviceRegistry_Get_FullMethodName       = "/ttn.lorawan.v3.JsEndDeviceRegistry/Get"
	JsEndDeviceRegistry_Set_FullMethodName       = "/ttn.lorawan.v3.JsEndDeviceRegistry/Set"
	JsEndDeviceRegistry_Provision_FullMethodName = "/ttn.lorawan.v3.JsEndDeviceRegistry/Provision"
	JsEndDeviceRegistry_Delete_FullMethodName    = "/ttn.lorawan.v3.JsEndDeviceRegistry/Delete"
)

// JsEndDeviceRegistryClient is the client API for JsEndDeviceRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type JsEndDeviceRegistryClient interface {
	// Get returns the device that matches the given identifiers.
	// If there are multiple matches, an error will be returned.
	Get(ctx context.Context, in *GetEndDeviceRequest, opts ...grpc.CallOption) (*EndDevice, error)
	// Set creates or updates the device.
	Set(ctx context.Context, in *SetEndDeviceRequest, opts ...grpc.CallOption) (*EndDevice, error)
	// Deprecated: Do not use.
	// This rpc is deprecated; use EndDeviceTemplateConverter service instead.
	// TODO: Remove (https://github.com/TheThingsNetwork/lorawan-stack/issues/999)
	Provision(ctx context.Context, in *ProvisionEndDevicesRequest, opts ...grpc.CallOption) (JsEndDeviceRegistry_ProvisionClient, error)
	// Delete deletes the device that matches the given identifiers.
	// If there are multiple matches, an error will be returned.
	Delete(ctx context.Context, in *EndDeviceIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type jsEndDeviceRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewJsEndDeviceRegistryClient(cc grpc.ClientConnInterface) JsEndDeviceRegistryClient {
	return &jsEndDeviceRegistryClient{cc}
}

func (c *jsEndDeviceRegistryClient) Get(ctx context.Context, in *GetEndDeviceRequest, opts ...grpc.CallOption) (*EndDevice, error) {
	out := new(EndDevice)
	err := c.cc.Invoke(ctx, JsEndDeviceRegistry_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jsEndDeviceRegistryClient) Set(ctx context.Context, in *SetEndDeviceRequest, opts ...grpc.CallOption) (*EndDevice, error) {
	out := new(EndDevice)
	err := c.cc.Invoke(ctx, JsEndDeviceRegistry_Set_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *jsEndDeviceRegistryClient) Provision(ctx context.Context, in *ProvisionEndDevicesRequest, opts ...grpc.CallOption) (JsEndDeviceRegistry_ProvisionClient, error) {
	stream, err := c.cc.NewStream(ctx, &JsEndDeviceRegistry_ServiceDesc.Streams[0], JsEndDeviceRegistry_Provision_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &jsEndDeviceRegistryProvisionClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type JsEndDeviceRegistry_ProvisionClient interface {
	Recv() (*EndDevice, error)
	grpc.ClientStream
}

type jsEndDeviceRegistryProvisionClient struct {
	grpc.ClientStream
}

func (x *jsEndDeviceRegistryProvisionClient) Recv() (*EndDevice, error) {
	m := new(EndDevice)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *jsEndDeviceRegistryClient) Delete(ctx context.Context, in *EndDeviceIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, JsEndDeviceRegistry_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JsEndDeviceRegistryServer is the server API for JsEndDeviceRegistry service.
// All implementations must embed UnimplementedJsEndDeviceRegistryServer
// for forward compatibility
type JsEndDeviceRegistryServer interface {
	// Get returns the device that matches the given identifiers.
	// If there are multiple matches, an error will be returned.
	Get(context.Context, *GetEndDeviceRequest) (*EndDevice, error)
	// Set creates or updates the device.
	Set(context.Context, *SetEndDeviceRequest) (*EndDevice, error)
	// Deprecated: Do not use.
	// This rpc is deprecated; use EndDeviceTemplateConverter service instead.
	// TODO: Remove (https://github.com/TheThingsNetwork/lorawan-stack/issues/999)
	Provision(*ProvisionEndDevicesRequest, JsEndDeviceRegistry_ProvisionServer) error
	// Delete deletes the device that matches the given identifiers.
	// If there are multiple matches, an error will be returned.
	Delete(context.Context, *EndDeviceIdentifiers) (*emptypb.Empty, error)
	mustEmbedUnimplementedJsEndDeviceRegistryServer()
}

// UnimplementedJsEndDeviceRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedJsEndDeviceRegistryServer struct {
}

func (UnimplementedJsEndDeviceRegistryServer) Get(context.Context, *GetEndDeviceRequest) (*EndDevice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedJsEndDeviceRegistryServer) Set(context.Context, *SetEndDeviceRequest) (*EndDevice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Set not implemented")
}
func (UnimplementedJsEndDeviceRegistryServer) Provision(*ProvisionEndDevicesRequest, JsEndDeviceRegistry_ProvisionServer) error {
	return status.Errorf(codes.Unimplemented, "method Provision not implemented")
}
func (UnimplementedJsEndDeviceRegistryServer) Delete(context.Context, *EndDeviceIdentifiers) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedJsEndDeviceRegistryServer) mustEmbedUnimplementedJsEndDeviceRegistryServer() {}

// UnsafeJsEndDeviceRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to JsEndDeviceRegistryServer will
// result in compilation errors.
type UnsafeJsEndDeviceRegistryServer interface {
	mustEmbedUnimplementedJsEndDeviceRegistryServer()
}

func RegisterJsEndDeviceRegistryServer(s grpc.ServiceRegistrar, srv JsEndDeviceRegistryServer) {
	s.RegisterService(&JsEndDeviceRegistry_ServiceDesc, srv)
}

func _JsEndDeviceRegistry_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEndDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JsEndDeviceRegistryServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JsEndDeviceRegistry_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JsEndDeviceRegistryServer).Get(ctx, req.(*GetEndDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JsEndDeviceRegistry_Set_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetEndDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JsEndDeviceRegistryServer).Set(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JsEndDeviceRegistry_Set_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JsEndDeviceRegistryServer).Set(ctx, req.(*SetEndDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JsEndDeviceRegistry_Provision_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ProvisionEndDevicesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(JsEndDeviceRegistryServer).Provision(m, &jsEndDeviceRegistryProvisionServer{stream})
}

type JsEndDeviceRegistry_ProvisionServer interface {
	Send(*EndDevice) error
	grpc.ServerStream
}

type jsEndDeviceRegistryProvisionServer struct {
	grpc.ServerStream
}

func (x *jsEndDeviceRegistryProvisionServer) Send(m *EndDevice) error {
	return x.ServerStream.SendMsg(m)
}

func _JsEndDeviceRegistry_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EndDeviceIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JsEndDeviceRegistryServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JsEndDeviceRegistry_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JsEndDeviceRegistryServer).Delete(ctx, req.(*EndDeviceIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

// JsEndDeviceRegistry_ServiceDesc is the grpc.ServiceDesc for JsEndDeviceRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var JsEndDeviceRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.JsEndDeviceRegistry",
	HandlerType: (*JsEndDeviceRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _JsEndDeviceRegistry_Get_Handler,
		},
		{
			MethodName: "Set",
			Handler:    _JsEndDeviceRegistry_Set_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _JsEndDeviceRegistry_Delete_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Provision",
			Handler:       _JsEndDeviceRegistry_Provision_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "ttn/lorawan/v3/joinserver.proto",
}

const (
	JsEndDeviceBatchRegistry_Delete_FullMethodName = "/ttn.lorawan.v3.JsEndDeviceBatchRegistry/Delete"
)

// JsEndDeviceBatchRegistryClient is the client API for JsEndDeviceBatchRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type JsEndDeviceBatchRegistryClient interface {
	// Delete a list of devices within the same application.
	// This operation is atomic; either all devices are deleted or none.
	// Devices not found are skipped and no error is returned.
	Delete(ctx context.Context, in *BatchDeleteEndDevicesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type jsEndDeviceBatchRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewJsEndDeviceBatchRegistryClient(cc grpc.ClientConnInterface) JsEndDeviceBatchRegistryClient {
	return &jsEndDeviceBatchRegistryClient{cc}
}

func (c *jsEndDeviceBatchRegistryClient) Delete(ctx context.Context, in *BatchDeleteEndDevicesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, JsEndDeviceBatchRegistry_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JsEndDeviceBatchRegistryServer is the server API for JsEndDeviceBatchRegistry service.
// All implementations must embed UnimplementedJsEndDeviceBatchRegistryServer
// for forward compatibility
type JsEndDeviceBatchRegistryServer interface {
	// Delete a list of devices within the same application.
	// This operation is atomic; either all devices are deleted or none.
	// Devices not found are skipped and no error is returned.
	Delete(context.Context, *BatchDeleteEndDevicesRequest) (*emptypb.Empty, error)
	mustEmbedUnimplementedJsEndDeviceBatchRegistryServer()
}

// UnimplementedJsEndDeviceBatchRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedJsEndDeviceBatchRegistryServer struct {
}

func (UnimplementedJsEndDeviceBatchRegistryServer) Delete(context.Context, *BatchDeleteEndDevicesRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedJsEndDeviceBatchRegistryServer) mustEmbedUnimplementedJsEndDeviceBatchRegistryServer() {
}

// UnsafeJsEndDeviceBatchRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to JsEndDeviceBatchRegistryServer will
// result in compilation errors.
type UnsafeJsEndDeviceBatchRegistryServer interface {
	mustEmbedUnimplementedJsEndDeviceBatchRegistryServer()
}

func RegisterJsEndDeviceBatchRegistryServer(s grpc.ServiceRegistrar, srv JsEndDeviceBatchRegistryServer) {
	s.RegisterService(&JsEndDeviceBatchRegistry_ServiceDesc, srv)
}

func _JsEndDeviceBatchRegistry_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteEndDevicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JsEndDeviceBatchRegistryServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JsEndDeviceBatchRegistry_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JsEndDeviceBatchRegistryServer).Delete(ctx, req.(*BatchDeleteEndDevicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// JsEndDeviceBatchRegistry_ServiceDesc is the grpc.ServiceDesc for JsEndDeviceBatchRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var JsEndDeviceBatchRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.JsEndDeviceBatchRegistry",
	HandlerType: (*JsEndDeviceBatchRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _JsEndDeviceBatchRegistry_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/joinserver.proto",
}

const (
	ApplicationActivationSettingRegistry_Get_FullMethodName    = "/ttn.lorawan.v3.ApplicationActivationSettingRegistry/Get"
	ApplicationActivationSettingRegistry_Set_FullMethodName    = "/ttn.lorawan.v3.ApplicationActivationSettingRegistry/Set"
	ApplicationActivationSettingRegistry_Delete_FullMethodName = "/ttn.lorawan.v3.ApplicationActivationSettingRegistry/Delete"
)

// ApplicationActivationSettingRegistryClient is the client API for ApplicationActivationSettingRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ApplicationActivationSettingRegistryClient interface {
	// Get returns application activation settings.
	Get(ctx context.Context, in *GetApplicationActivationSettingsRequest, opts ...grpc.CallOption) (*ApplicationActivationSettings, error)
	// Set creates or updates application activation settings.
	Set(ctx context.Context, in *SetApplicationActivationSettingsRequest, opts ...grpc.CallOption) (*ApplicationActivationSettings, error)
	// Delete deletes application activation settings.
	Delete(ctx context.Context, in *DeleteApplicationActivationSettingsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type applicationActivationSettingRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewApplicationActivationSettingRegistryClient(cc grpc.ClientConnInterface) ApplicationActivationSettingRegistryClient {
	return &applicationActivationSettingRegistryClient{cc}
}

func (c *applicationActivationSettingRegistryClient) Get(ctx context.Context, in *GetApplicationActivationSettingsRequest, opts ...grpc.CallOption) (*ApplicationActivationSettings, error) {
	out := new(ApplicationActivationSettings)
	err := c.cc.Invoke(ctx, ApplicationActivationSettingRegistry_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationActivationSettingRegistryClient) Set(ctx context.Context, in *SetApplicationActivationSettingsRequest, opts ...grpc.CallOption) (*ApplicationActivationSettings, error) {
	out := new(ApplicationActivationSettings)
	err := c.cc.Invoke(ctx, ApplicationActivationSettingRegistry_Set_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationActivationSettingRegistryClient) Delete(ctx context.Context, in *DeleteApplicationActivationSettingsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ApplicationActivationSettingRegistry_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApplicationActivationSettingRegistryServer is the server API for ApplicationActivationSettingRegistry service.
// All implementations must embed UnimplementedApplicationActivationSettingRegistryServer
// for forward compatibility
type ApplicationActivationSettingRegistryServer interface {
	// Get returns application activation settings.
	Get(context.Context, *GetApplicationActivationSettingsRequest) (*ApplicationActivationSettings, error)
	// Set creates or updates application activation settings.
	Set(context.Context, *SetApplicationActivationSettingsRequest) (*ApplicationActivationSettings, error)
	// Delete deletes application activation settings.
	Delete(context.Context, *DeleteApplicationActivationSettingsRequest) (*emptypb.Empty, error)
	mustEmbedUnimplementedApplicationActivationSettingRegistryServer()
}

// UnimplementedApplicationActivationSettingRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedApplicationActivationSettingRegistryServer struct {
}

func (UnimplementedApplicationActivationSettingRegistryServer) Get(context.Context, *GetApplicationActivationSettingsRequest) (*ApplicationActivationSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedApplicationActivationSettingRegistryServer) Set(context.Context, *SetApplicationActivationSettingsRequest) (*ApplicationActivationSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Set not implemented")
}
func (UnimplementedApplicationActivationSettingRegistryServer) Delete(context.Context, *DeleteApplicationActivationSettingsRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedApplicationActivationSettingRegistryServer) mustEmbedUnimplementedApplicationActivationSettingRegistryServer() {
}

// UnsafeApplicationActivationSettingRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ApplicationActivationSettingRegistryServer will
// result in compilation errors.
type UnsafeApplicationActivationSettingRegistryServer interface {
	mustEmbedUnimplementedApplicationActivationSettingRegistryServer()
}

func RegisterApplicationActivationSettingRegistryServer(s grpc.ServiceRegistrar, srv ApplicationActivationSettingRegistryServer) {
	s.RegisterService(&ApplicationActivationSettingRegistry_ServiceDesc, srv)
}

func _ApplicationActivationSettingRegistry_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationActivationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationActivationSettingRegistryServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationActivationSettingRegistry_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationActivationSettingRegistryServer).Get(ctx, req.(*GetApplicationActivationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationActivationSettingRegistry_Set_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetApplicationActivationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationActivationSettingRegistryServer).Set(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationActivationSettingRegistry_Set_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationActivationSettingRegistryServer).Set(ctx, req.(*SetApplicationActivationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationActivationSettingRegistry_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApplicationActivationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationActivationSettingRegistryServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationActivationSettingRegistry_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationActivationSettingRegistryServer).Delete(ctx, req.(*DeleteApplicationActivationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ApplicationActivationSettingRegistry_ServiceDesc is the grpc.ServiceDesc for ApplicationActivationSettingRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ApplicationActivationSettingRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.ApplicationActivationSettingRegistry",
	HandlerType: (*ApplicationActivationSettingRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ApplicationActivationSettingRegistry_Get_Handler,
		},
		{
			MethodName: "Set",
			Handler:    _ApplicationActivationSettingRegistry_Set_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ApplicationActivationSettingRegistry_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/joinserver.proto",
}

const (
	Js_GetJoinEUIPrefixes_FullMethodName = "/ttn.lorawan.v3.Js/GetJoinEUIPrefixes"
	Js_GetDefaultJoinEUI_FullMethodName  = "/ttn.lorawan.v3.Js/GetDefaultJoinEUI"
)

// JsClient is the client API for Js service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type JsClient interface {
	// Request the JoinEUI prefixes that are configured for this Join Server.
	GetJoinEUIPrefixes(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*JoinEUIPrefixes, error)
	// Request the default JoinEUI that is configured for this Join Server.
	GetDefaultJoinEUI(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*GetDefaultJoinEUIResponse, error)
}

type jsClient struct {
	cc grpc.ClientConnInterface
}

func NewJsClient(cc grpc.ClientConnInterface) JsClient {
	return &jsClient{cc}
}

func (c *jsClient) GetJoinEUIPrefixes(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*JoinEUIPrefixes, error) {
	out := new(JoinEUIPrefixes)
	err := c.cc.Invoke(ctx, Js_GetJoinEUIPrefixes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jsClient) GetDefaultJoinEUI(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*GetDefaultJoinEUIResponse, error) {
	out := new(GetDefaultJoinEUIResponse)
	err := c.cc.Invoke(ctx, Js_GetDefaultJoinEUI_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JsServer is the server API for Js service.
// All implementations must embed UnimplementedJsServer
// for forward compatibility
type JsServer interface {
	// Request the JoinEUI prefixes that are configured for this Join Server.
	GetJoinEUIPrefixes(context.Context, *emptypb.Empty) (*JoinEUIPrefixes, error)
	// Request the default JoinEUI that is configured for this Join Server.
	GetDefaultJoinEUI(context.Context, *emptypb.Empty) (*GetDefaultJoinEUIResponse, error)
	mustEmbedUnimplementedJsServer()
}

// UnimplementedJsServer must be embedded to have forward compatible implementations.
type UnimplementedJsServer struct {
}

func (UnimplementedJsServer) GetJoinEUIPrefixes(context.Context, *emptypb.Empty) (*JoinEUIPrefixes, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJoinEUIPrefixes not implemented")
}
func (UnimplementedJsServer) GetDefaultJoinEUI(context.Context, *emptypb.Empty) (*GetDefaultJoinEUIResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDefaultJoinEUI not implemented")
}
func (UnimplementedJsServer) mustEmbedUnimplementedJsServer() {}

// UnsafeJsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to JsServer will
// result in compilation errors.
type UnsafeJsServer interface {
	mustEmbedUnimplementedJsServer()
}

func RegisterJsServer(s grpc.ServiceRegistrar, srv JsServer) {
	s.RegisterService(&Js_ServiceDesc, srv)
}

func _Js_GetJoinEUIPrefixes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JsServer).GetJoinEUIPrefixes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Js_GetJoinEUIPrefixes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JsServer).GetJoinEUIPrefixes(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Js_GetDefaultJoinEUI_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JsServer).GetDefaultJoinEUI(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Js_GetDefaultJoinEUI_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JsServer).GetDefaultJoinEUI(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

// Js_ServiceDesc is the grpc.ServiceDesc for Js service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Js_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.Js",
	HandlerType: (*JsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetJoinEUIPrefixes",
			Handler:    _Js_GetJoinEUIPrefixes_Handler,
		},
		{
			MethodName: "GetDefaultJoinEUI",
			Handler:    _Js_GetDefaultJoinEUI_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/joinserver.proto",
}
