// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/identityserver.proto

package ttnpb

import (
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type AuthInfoResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to AccessMethod:
	//	*AuthInfoResponse_ApiKey
	//	*AuthInfoResponse_OauthAccessToken
	//	*AuthInfoResponse_UserSession
	//	*AuthInfoResponse_GatewayToken_
	AccessMethod    isAuthInfoResponse_AccessMethod `protobuf_oneof:"access_method"`
	UniversalRights *Rights                         `protobuf:"bytes,3,opt,name=universal_rights,json=universalRights,proto3" json:"universal_rights,omitempty"`
	IsAdmin         bool                            `protobuf:"varint,4,opt,name=is_admin,json=isAdmin,proto3" json:"is_admin,omitempty"`
}

func (x *AuthInfoResponse) Reset() {
	*x = AuthInfoResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthInfoResponse) ProtoMessage() {}

func (x *AuthInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthInfoResponse.ProtoReflect.Descriptor instead.
func (*AuthInfoResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{0}
}

func (m *AuthInfoResponse) GetAccessMethod() isAuthInfoResponse_AccessMethod {
	if m != nil {
		return m.AccessMethod
	}
	return nil
}

func (x *AuthInfoResponse) GetApiKey() *AuthInfoResponse_APIKeyAccess {
	if x, ok := x.GetAccessMethod().(*AuthInfoResponse_ApiKey); ok {
		return x.ApiKey
	}
	return nil
}

func (x *AuthInfoResponse) GetOauthAccessToken() *OAuthAccessToken {
	if x, ok := x.GetAccessMethod().(*AuthInfoResponse_OauthAccessToken); ok {
		return x.OauthAccessToken
	}
	return nil
}

func (x *AuthInfoResponse) GetUserSession() *UserSession {
	if x, ok := x.GetAccessMethod().(*AuthInfoResponse_UserSession); ok {
		return x.UserSession
	}
	return nil
}

func (x *AuthInfoResponse) GetGatewayToken() *AuthInfoResponse_GatewayToken {
	if x, ok := x.GetAccessMethod().(*AuthInfoResponse_GatewayToken_); ok {
		return x.GatewayToken
	}
	return nil
}

func (x *AuthInfoResponse) GetUniversalRights() *Rights {
	if x != nil {
		return x.UniversalRights
	}
	return nil
}

func (x *AuthInfoResponse) GetIsAdmin() bool {
	if x != nil {
		return x.IsAdmin
	}
	return false
}

type isAuthInfoResponse_AccessMethod interface {
	isAuthInfoResponse_AccessMethod()
}

type AuthInfoResponse_ApiKey struct {
	ApiKey *AuthInfoResponse_APIKeyAccess `protobuf:"bytes,1,opt,name=api_key,json=apiKey,proto3,oneof"`
}

type AuthInfoResponse_OauthAccessToken struct {
	OauthAccessToken *OAuthAccessToken `protobuf:"bytes,2,opt,name=oauth_access_token,json=oauthAccessToken,proto3,oneof"`
}

type AuthInfoResponse_UserSession struct {
	// Warning: A user authorized by session cookie will be granted all
	// current and future rights. When using this auth type, the respective
	// handlers need to ensure thorough CSRF and CORS protection using
	// appropriate middleware.
	UserSession *UserSession `protobuf:"bytes,5,opt,name=user_session,json=userSession,proto3,oneof"`
}

type AuthInfoResponse_GatewayToken_ struct {
	GatewayToken *AuthInfoResponse_GatewayToken `protobuf:"bytes,6,opt,name=gateway_token,json=gatewayToken,proto3,oneof"`
}

func (*AuthInfoResponse_ApiKey) isAuthInfoResponse_AccessMethod() {}

func (*AuthInfoResponse_OauthAccessToken) isAuthInfoResponse_AccessMethod() {}

func (*AuthInfoResponse_UserSession) isAuthInfoResponse_AccessMethod() {}

func (*AuthInfoResponse_GatewayToken_) isAuthInfoResponse_AccessMethod() {}

type GetIsConfigurationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetIsConfigurationRequest) Reset() {
	*x = GetIsConfigurationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIsConfigurationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIsConfigurationRequest) ProtoMessage() {}

func (x *GetIsConfigurationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIsConfigurationRequest.ProtoReflect.Descriptor instead.
func (*GetIsConfigurationRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{1}
}

type IsConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserRegistration   *IsConfiguration_UserRegistration   `protobuf:"bytes,3,opt,name=user_registration,json=userRegistration,proto3" json:"user_registration,omitempty"`
	ProfilePicture     *IsConfiguration_ProfilePicture     `protobuf:"bytes,4,opt,name=profile_picture,json=profilePicture,proto3" json:"profile_picture,omitempty"`
	EndDevicePicture   *IsConfiguration_EndDevicePicture   `protobuf:"bytes,5,opt,name=end_device_picture,json=endDevicePicture,proto3" json:"end_device_picture,omitempty"`
	UserRights         *IsConfiguration_UserRights         `protobuf:"bytes,6,opt,name=user_rights,json=userRights,proto3" json:"user_rights,omitempty"`
	UserLogin          *IsConfiguration_UserLogin          `protobuf:"bytes,7,opt,name=user_login,json=userLogin,proto3" json:"user_login,omitempty"`
	AdminRights        *IsConfiguration_AdminRights        `protobuf:"bytes,8,opt,name=admin_rights,json=adminRights,proto3" json:"admin_rights,omitempty"`
	CollaboratorRights *IsConfiguration_CollaboratorRights `protobuf:"bytes,14,opt,name=collaborator_rights,json=collaboratorRights,proto3" json:"collaborator_rights,omitempty"`
}

func (x *IsConfiguration) Reset() {
	*x = IsConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsConfiguration) ProtoMessage() {}

func (x *IsConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsConfiguration.ProtoReflect.Descriptor instead.
func (*IsConfiguration) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{2}
}

func (x *IsConfiguration) GetUserRegistration() *IsConfiguration_UserRegistration {
	if x != nil {
		return x.UserRegistration
	}
	return nil
}

func (x *IsConfiguration) GetProfilePicture() *IsConfiguration_ProfilePicture {
	if x != nil {
		return x.ProfilePicture
	}
	return nil
}

func (x *IsConfiguration) GetEndDevicePicture() *IsConfiguration_EndDevicePicture {
	if x != nil {
		return x.EndDevicePicture
	}
	return nil
}

func (x *IsConfiguration) GetUserRights() *IsConfiguration_UserRights {
	if x != nil {
		return x.UserRights
	}
	return nil
}

func (x *IsConfiguration) GetUserLogin() *IsConfiguration_UserLogin {
	if x != nil {
		return x.UserLogin
	}
	return nil
}

func (x *IsConfiguration) GetAdminRights() *IsConfiguration_AdminRights {
	if x != nil {
		return x.AdminRights
	}
	return nil
}

func (x *IsConfiguration) GetCollaboratorRights() *IsConfiguration_CollaboratorRights {
	if x != nil {
		return x.CollaboratorRights
	}
	return nil
}

type GetIsConfigurationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Configuration *IsConfiguration `protobuf:"bytes,1,opt,name=configuration,proto3" json:"configuration,omitempty"`
}

func (x *GetIsConfigurationResponse) Reset() {
	*x = GetIsConfigurationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIsConfigurationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIsConfigurationResponse) ProtoMessage() {}

func (x *GetIsConfigurationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIsConfigurationResponse.ProtoReflect.Descriptor instead.
func (*GetIsConfigurationResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{3}
}

func (x *GetIsConfigurationResponse) GetConfiguration() *IsConfiguration {
	if x != nil {
		return x.Configuration
	}
	return nil
}

type AuthInfoResponse_APIKeyAccess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApiKey    *APIKey            `protobuf:"bytes,1,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty"`
	EntityIds *EntityIdentifiers `protobuf:"bytes,2,opt,name=entity_ids,json=entityIds,proto3" json:"entity_ids,omitempty"`
}

func (x *AuthInfoResponse_APIKeyAccess) Reset() {
	*x = AuthInfoResponse_APIKeyAccess{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthInfoResponse_APIKeyAccess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthInfoResponse_APIKeyAccess) ProtoMessage() {}

func (x *AuthInfoResponse_APIKeyAccess) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthInfoResponse_APIKeyAccess.ProtoReflect.Descriptor instead.
func (*AuthInfoResponse_APIKeyAccess) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AuthInfoResponse_APIKeyAccess) GetApiKey() *APIKey {
	if x != nil {
		return x.ApiKey
	}
	return nil
}

func (x *AuthInfoResponse_APIKeyAccess) GetEntityIds() *EntityIdentifiers {
	if x != nil {
		return x.EntityIds
	}
	return nil
}

type AuthInfoResponse_GatewayToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds *GatewayIdentifiers `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	Rights     []Right             `protobuf:"varint,6,rep,packed,name=rights,proto3,enum=ttn.lorawan.v3.Right" json:"rights,omitempty"`
}

func (x *AuthInfoResponse_GatewayToken) Reset() {
	*x = AuthInfoResponse_GatewayToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthInfoResponse_GatewayToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthInfoResponse_GatewayToken) ProtoMessage() {}

func (x *AuthInfoResponse_GatewayToken) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthInfoResponse_GatewayToken.ProtoReflect.Descriptor instead.
func (*AuthInfoResponse_GatewayToken) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{0, 1}
}

func (x *AuthInfoResponse_GatewayToken) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *AuthInfoResponse_GatewayToken) GetRights() []Right {
	if x != nil {
		return x.Rights
	}
	return nil
}

type IsConfiguration_UserRegistration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Invitation            *IsConfiguration_UserRegistration_Invitation            `protobuf:"bytes,1,opt,name=invitation,proto3" json:"invitation,omitempty"`
	ContactInfoValidation *IsConfiguration_UserRegistration_ContactInfoValidation `protobuf:"bytes,2,opt,name=contact_info_validation,json=contactInfoValidation,proto3" json:"contact_info_validation,omitempty"`
	AdminApproval         *IsConfiguration_UserRegistration_AdminApproval         `protobuf:"bytes,3,opt,name=admin_approval,json=adminApproval,proto3" json:"admin_approval,omitempty"`
	PasswordRequirements  *IsConfiguration_UserRegistration_PasswordRequirements  `protobuf:"bytes,4,opt,name=password_requirements,json=passwordRequirements,proto3" json:"password_requirements,omitempty"`
	Enabled               bool                                                    `protobuf:"varint,5,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *IsConfiguration_UserRegistration) Reset() {
	*x = IsConfiguration_UserRegistration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsConfiguration_UserRegistration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsConfiguration_UserRegistration) ProtoMessage() {}

func (x *IsConfiguration_UserRegistration) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsConfiguration_UserRegistration.ProtoReflect.Descriptor instead.
func (*IsConfiguration_UserRegistration) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{2, 0}
}

func (x *IsConfiguration_UserRegistration) GetInvitation() *IsConfiguration_UserRegistration_Invitation {
	if x != nil {
		return x.Invitation
	}
	return nil
}

func (x *IsConfiguration_UserRegistration) GetContactInfoValidation() *IsConfiguration_UserRegistration_ContactInfoValidation {
	if x != nil {
		return x.ContactInfoValidation
	}
	return nil
}

func (x *IsConfiguration_UserRegistration) GetAdminApproval() *IsConfiguration_UserRegistration_AdminApproval {
	if x != nil {
		return x.AdminApproval
	}
	return nil
}

func (x *IsConfiguration_UserRegistration) GetPasswordRequirements() *IsConfiguration_UserRegistration_PasswordRequirements {
	if x != nil {
		return x.PasswordRequirements
	}
	return nil
}

func (x *IsConfiguration_UserRegistration) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

type IsConfiguration_ProfilePicture struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DisableUpload *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=disable_upload,json=disableUpload,proto3" json:"disable_upload,omitempty"`
	UseGravatar   *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=use_gravatar,json=useGravatar,proto3" json:"use_gravatar,omitempty"`
}

func (x *IsConfiguration_ProfilePicture) Reset() {
	*x = IsConfiguration_ProfilePicture{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsConfiguration_ProfilePicture) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsConfiguration_ProfilePicture) ProtoMessage() {}

func (x *IsConfiguration_ProfilePicture) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsConfiguration_ProfilePicture.ProtoReflect.Descriptor instead.
func (*IsConfiguration_ProfilePicture) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{2, 1}
}

func (x *IsConfiguration_ProfilePicture) GetDisableUpload() *wrapperspb.BoolValue {
	if x != nil {
		return x.DisableUpload
	}
	return nil
}

func (x *IsConfiguration_ProfilePicture) GetUseGravatar() *wrapperspb.BoolValue {
	if x != nil {
		return x.UseGravatar
	}
	return nil
}

type IsConfiguration_EndDevicePicture struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DisableUpload *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=disable_upload,json=disableUpload,proto3" json:"disable_upload,omitempty"`
}

func (x *IsConfiguration_EndDevicePicture) Reset() {
	*x = IsConfiguration_EndDevicePicture{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsConfiguration_EndDevicePicture) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsConfiguration_EndDevicePicture) ProtoMessage() {}

func (x *IsConfiguration_EndDevicePicture) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsConfiguration_EndDevicePicture.ProtoReflect.Descriptor instead.
func (*IsConfiguration_EndDevicePicture) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{2, 2}
}

func (x *IsConfiguration_EndDevicePicture) GetDisableUpload() *wrapperspb.BoolValue {
	if x != nil {
		return x.DisableUpload
	}
	return nil
}

type IsConfiguration_UserRights struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CreateApplications  *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=create_applications,json=createApplications,proto3" json:"create_applications,omitempty"`
	CreateClients       *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=create_clients,json=createClients,proto3" json:"create_clients,omitempty"`
	CreateGateways      *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=create_gateways,json=createGateways,proto3" json:"create_gateways,omitempty"`
	CreateOrganizations *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=create_organizations,json=createOrganizations,proto3" json:"create_organizations,omitempty"`
}

func (x *IsConfiguration_UserRights) Reset() {
	*x = IsConfiguration_UserRights{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsConfiguration_UserRights) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsConfiguration_UserRights) ProtoMessage() {}

func (x *IsConfiguration_UserRights) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsConfiguration_UserRights.ProtoReflect.Descriptor instead.
func (*IsConfiguration_UserRights) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{2, 3}
}

func (x *IsConfiguration_UserRights) GetCreateApplications() *wrapperspb.BoolValue {
	if x != nil {
		return x.CreateApplications
	}
	return nil
}

func (x *IsConfiguration_UserRights) GetCreateClients() *wrapperspb.BoolValue {
	if x != nil {
		return x.CreateClients
	}
	return nil
}

func (x *IsConfiguration_UserRights) GetCreateGateways() *wrapperspb.BoolValue {
	if x != nil {
		return x.CreateGateways
	}
	return nil
}

func (x *IsConfiguration_UserRights) GetCreateOrganizations() *wrapperspb.BoolValue {
	if x != nil {
		return x.CreateOrganizations
	}
	return nil
}

type IsConfiguration_UserLogin struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DisableCredentialsLogin *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=disable_credentials_login,json=disableCredentialsLogin,proto3" json:"disable_credentials_login,omitempty"`
}

func (x *IsConfiguration_UserLogin) Reset() {
	*x = IsConfiguration_UserLogin{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsConfiguration_UserLogin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsConfiguration_UserLogin) ProtoMessage() {}

func (x *IsConfiguration_UserLogin) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsConfiguration_UserLogin.ProtoReflect.Descriptor instead.
func (*IsConfiguration_UserLogin) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{2, 4}
}

func (x *IsConfiguration_UserLogin) GetDisableCredentialsLogin() *wrapperspb.BoolValue {
	if x != nil {
		return x.DisableCredentialsLogin
	}
	return nil
}

type IsConfiguration_AdminRights struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	All *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=all,proto3" json:"all,omitempty"`
}

func (x *IsConfiguration_AdminRights) Reset() {
	*x = IsConfiguration_AdminRights{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsConfiguration_AdminRights) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsConfiguration_AdminRights) ProtoMessage() {}

func (x *IsConfiguration_AdminRights) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsConfiguration_AdminRights.ProtoReflect.Descriptor instead.
func (*IsConfiguration_AdminRights) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{2, 5}
}

func (x *IsConfiguration_AdminRights) GetAll() *wrapperspb.BoolValue {
	if x != nil {
		return x.All
	}
	return nil
}

type IsConfiguration_CollaboratorRights struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SetOthersAsContacts *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=set_others_as_contacts,json=setOthersAsContacts,proto3" json:"set_others_as_contacts,omitempty"`
}

func (x *IsConfiguration_CollaboratorRights) Reset() {
	*x = IsConfiguration_CollaboratorRights{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsConfiguration_CollaboratorRights) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsConfiguration_CollaboratorRights) ProtoMessage() {}

func (x *IsConfiguration_CollaboratorRights) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsConfiguration_CollaboratorRights.ProtoReflect.Descriptor instead.
func (*IsConfiguration_CollaboratorRights) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{2, 6}
}

func (x *IsConfiguration_CollaboratorRights) GetSetOthersAsContacts() *wrapperspb.BoolValue {
	if x != nil {
		return x.SetOthersAsContacts
	}
	return nil
}

type IsConfiguration_UserRegistration_Invitation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Required *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=required,proto3" json:"required,omitempty"`
	TokenTtl *durationpb.Duration  `protobuf:"bytes,2,opt,name=token_ttl,json=tokenTtl,proto3" json:"token_ttl,omitempty"`
}

func (x *IsConfiguration_UserRegistration_Invitation) Reset() {
	*x = IsConfiguration_UserRegistration_Invitation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsConfiguration_UserRegistration_Invitation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsConfiguration_UserRegistration_Invitation) ProtoMessage() {}

func (x *IsConfiguration_UserRegistration_Invitation) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsConfiguration_UserRegistration_Invitation.ProtoReflect.Descriptor instead.
func (*IsConfiguration_UserRegistration_Invitation) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{2, 0, 0}
}

func (x *IsConfiguration_UserRegistration_Invitation) GetRequired() *wrapperspb.BoolValue {
	if x != nil {
		return x.Required
	}
	return nil
}

func (x *IsConfiguration_UserRegistration_Invitation) GetTokenTtl() *durationpb.Duration {
	if x != nil {
		return x.TokenTtl
	}
	return nil
}

type IsConfiguration_UserRegistration_ContactInfoValidation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Required *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=required,proto3" json:"required,omitempty"`
	TokenTtl *durationpb.Duration  `protobuf:"bytes,2,opt,name=token_ttl,json=tokenTtl,proto3" json:"token_ttl,omitempty"`
	// The minimum interval between validation emails.
	RetryInterval *durationpb.Duration `protobuf:"bytes,3,opt,name=retry_interval,json=retryInterval,proto3" json:"retry_interval,omitempty"`
}

func (x *IsConfiguration_UserRegistration_ContactInfoValidation) Reset() {
	*x = IsConfiguration_UserRegistration_ContactInfoValidation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsConfiguration_UserRegistration_ContactInfoValidation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsConfiguration_UserRegistration_ContactInfoValidation) ProtoMessage() {}

func (x *IsConfiguration_UserRegistration_ContactInfoValidation) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsConfiguration_UserRegistration_ContactInfoValidation.ProtoReflect.Descriptor instead.
func (*IsConfiguration_UserRegistration_ContactInfoValidation) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{2, 0, 1}
}

func (x *IsConfiguration_UserRegistration_ContactInfoValidation) GetRequired() *wrapperspb.BoolValue {
	if x != nil {
		return x.Required
	}
	return nil
}

func (x *IsConfiguration_UserRegistration_ContactInfoValidation) GetTokenTtl() *durationpb.Duration {
	if x != nil {
		return x.TokenTtl
	}
	return nil
}

func (x *IsConfiguration_UserRegistration_ContactInfoValidation) GetRetryInterval() *durationpb.Duration {
	if x != nil {
		return x.RetryInterval
	}
	return nil
}

type IsConfiguration_UserRegistration_AdminApproval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Required *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=required,proto3" json:"required,omitempty"`
}

func (x *IsConfiguration_UserRegistration_AdminApproval) Reset() {
	*x = IsConfiguration_UserRegistration_AdminApproval{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsConfiguration_UserRegistration_AdminApproval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsConfiguration_UserRegistration_AdminApproval) ProtoMessage() {}

func (x *IsConfiguration_UserRegistration_AdminApproval) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsConfiguration_UserRegistration_AdminApproval.ProtoReflect.Descriptor instead.
func (*IsConfiguration_UserRegistration_AdminApproval) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{2, 0, 2}
}

func (x *IsConfiguration_UserRegistration_AdminApproval) GetRequired() *wrapperspb.BoolValue {
	if x != nil {
		return x.Required
	}
	return nil
}

type IsConfiguration_UserRegistration_PasswordRequirements struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinLength    *wrapperspb.UInt32Value `protobuf:"bytes,1,opt,name=min_length,json=minLength,proto3" json:"min_length,omitempty"`
	MaxLength    *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=max_length,json=maxLength,proto3" json:"max_length,omitempty"`
	MinUppercase *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=min_uppercase,json=minUppercase,proto3" json:"min_uppercase,omitempty"`
	MinDigits    *wrapperspb.UInt32Value `protobuf:"bytes,4,opt,name=min_digits,json=minDigits,proto3" json:"min_digits,omitempty"`
	MinSpecial   *wrapperspb.UInt32Value `protobuf:"bytes,5,opt,name=min_special,json=minSpecial,proto3" json:"min_special,omitempty"`
}

func (x *IsConfiguration_UserRegistration_PasswordRequirements) Reset() {
	*x = IsConfiguration_UserRegistration_PasswordRequirements{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsConfiguration_UserRegistration_PasswordRequirements) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsConfiguration_UserRegistration_PasswordRequirements) ProtoMessage() {}

func (x *IsConfiguration_UserRegistration_PasswordRequirements) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_identityserver_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsConfiguration_UserRegistration_PasswordRequirements.ProtoReflect.Descriptor instead.
func (*IsConfiguration_UserRegistration_PasswordRequirements) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP(), []int{2, 0, 3}
}

func (x *IsConfiguration_UserRegistration_PasswordRequirements) GetMinLength() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MinLength
	}
	return nil
}

func (x *IsConfiguration_UserRegistration_PasswordRequirements) GetMaxLength() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxLength
	}
	return nil
}

func (x *IsConfiguration_UserRegistration_PasswordRequirements) GetMinUppercase() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MinUppercase
	}
	return nil
}

func (x *IsConfiguration_UserRegistration_PasswordRequirements) GetMinDigits() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MinDigits
	}
	return nil
}

func (x *IsConfiguration_UserRegistration_PasswordRequirements) GetMinSpecial() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MinSpecial
	}
	return nil
}

var File_ttn_lorawan_v3_identityserver_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_identityserver_proto_rawDesc = []byte{
	0x0a, 0x23, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65,
	0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1a, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f,
	0x76, 0x33, 0x2f, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b,
	0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x72,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x74, 0x74, 0x6e,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x75, 0x73, 0x65, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xdc, 0x05, 0x0a, 0x10, 0x41, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x07, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x41, 0x50, 0x49, 0x4b, 0x65, 0x79, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x06, 0x61, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x12, 0x50,
	0x0a, 0x12, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x41, 0x75, 0x74,
	0x68, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x48, 0x00, 0x52, 0x10,
	0x6f, 0x61, 0x75, 0x74, 0x68, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x40, 0x0a, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0d, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x48, 0x00, 0x52, 0x0c, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x41, 0x0a, 0x10, 0x75, 0x6e, 0x69, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x6c, 0x5f, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x52, 0x69, 0x67, 0x68, 0x74, 0x73, 0x52, 0x0f, 0x75, 0x6e, 0x69, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x6c, 0x52, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x69,
	0x73, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69,
	0x73, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x1a, 0x95, 0x01, 0x0a, 0x0c, 0x41, 0x50, 0x49, 0x4b, 0x65,
	0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x39, 0x0a, 0x07, 0x61, 0x70, 0x69, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x50, 0x49, 0x4b, 0x65, 0x79,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x06, 0x61, 0x70, 0x69, 0x4b,
	0x65, 0x79, 0x12, 0x4a, 0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x09, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x73, 0x1a, 0x8c,
	0x01, 0x0a, 0x0c, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x4d, 0x0a, 0x0b, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12, 0x2d,
	0x0a, 0x06, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x15,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x52, 0x69, 0x67, 0x68, 0x74, 0x52, 0x06, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x42, 0x0f, 0x0a,
	0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0x1b,
	0x0a, 0x19, 0x47, 0x65, 0x74, 0x49, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x84, 0x16, 0x0a, 0x0f,
	0x49, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5d, 0x0a, 0x11, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x75, 0x73,
	0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57,
	0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x69, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x50, 0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x50, 0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x5e, 0x0a, 0x12, 0x65, 0x6e, 0x64, 0x5f, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x69,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x10, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x52, 0x69, 0x67, 0x68, 0x74, 0x73, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x52, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x12, 0x48, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x67,
	0x69, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x6f,
	0x67, 0x69, 0x6e, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x12, 0x4e,
	0x0a, 0x0c, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x52, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x52, 0x0b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x52, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0x63,
	0x0a, 0x13, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x72,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6c,
	0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x69, 0x67, 0x68, 0x74, 0x73, 0x52,
	0x12, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x1a, 0xd1, 0x09, 0x0a, 0x10, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x0a, 0x69, 0x6e, 0x76, 0x69,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49,
	0x6e, 0x76, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x69, 0x6e, 0x76, 0x69, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7e, 0x0a, 0x17, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x49, 0x6e, 0x66, 0x6f, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x65, 0x0a, 0x0e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55,
	0x73, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x0d, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x12, 0x7a, 0x0a, 0x15,
	0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65,
	0x72, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61,
	0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x14, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x1a, 0x7c, 0x0a, 0x0a, 0x49, 0x6e, 0x76, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x36, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x12, 0x36, 0x0a, 0x09, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x5f, 0x74, 0x74, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x54, 0x74, 0x6c,
	0x1a, 0xc9, 0x01, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x64, 0x12, 0x36, 0x0a, 0x09, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x74, 0x74, 0x6c, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x08, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x54, 0x74, 0x6c, 0x12, 0x40, 0x0a, 0x0e, 0x72, 0x65,
	0x74, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x72,
	0x65, 0x74, 0x72, 0x79, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x1a, 0x47, 0x0a, 0x0d,
	0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x12, 0x36, 0x0a,
	0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x64, 0x1a, 0xcf, 0x02, 0x0a, 0x14, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3b,
	0x0a, 0x0a, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x09, 0x6d, 0x69, 0x6e, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x3b, 0x0a, 0x0a, 0x6d,
	0x61, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x6d,
	0x61, 0x78, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x41, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x5f,
	0x75, 0x70, 0x70, 0x65, 0x72, 0x63, 0x61, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x6d,
	0x69, 0x6e, 0x55, 0x70, 0x70, 0x65, 0x72, 0x63, 0x61, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x0a, 0x6d,
	0x69, 0x6e, 0x5f, 0x64, 0x69, 0x67, 0x69, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x6d,
	0x69, 0x6e, 0x44, 0x69, 0x67, 0x69, 0x74, 0x73, 0x12, 0x3d, 0x0a, 0x0b, 0x6d, 0x69, 0x6e, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x6d, 0x69, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x1a, 0x92, 0x01, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x50, 0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x41, 0x0a, 0x0e, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x3d, 0x0a,
	0x0c, 0x75, 0x73, 0x65, 0x5f, 0x67, 0x72, 0x61, 0x76, 0x61, 0x74, 0x61, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0b, 0x75, 0x73, 0x65, 0x47, 0x72, 0x61, 0x76, 0x61, 0x74, 0x61, 0x72, 0x1a, 0x55, 0x0a, 0x10,
	0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x69, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x12, 0x41, 0x0a, 0x0e, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x75, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x1a, 0xb0, 0x02, 0x0a, 0x0a, 0x55, 0x73, 0x65, 0x72, 0x52, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x12, 0x4b, 0x0a, 0x13, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x41, 0x0a, 0x0e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x43, 0x0a, 0x0f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f,
	0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x12, 0x4d, 0x0a, 0x14, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x13, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x63, 0x0a, 0x09, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x6f,
	0x67, 0x69, 0x6e, 0x12, 0x56, 0x0a, 0x19, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x5f, 0x6c, 0x6f, 0x67, 0x69, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x17, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x72, 0x65, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x1a, 0x3b, 0x0a, 0x0b, 0x41,
	0x64, 0x6d, 0x69, 0x6e, 0x52, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0x2c, 0x0a, 0x03, 0x61, 0x6c,
	0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x03, 0x61, 0x6c, 0x6c, 0x1a, 0x65, 0x0a, 0x12, 0x43, 0x6f, 0x6c, 0x6c,
	0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0x4f,
	0x0a, 0x16, 0x73, 0x65, 0x74, 0x5f, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x73, 0x5f, 0x61, 0x73, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x73, 0x65, 0x74, 0x4f,
	0x74, 0x68, 0x65, 0x72, 0x73, 0x41, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73, 0x4a,
	0x04, 0x08, 0x09, 0x10, 0x0a, 0x4a, 0x04, 0x08, 0x0a, 0x10, 0x0b, 0x4a, 0x04, 0x08, 0x0b, 0x10,
	0x0c, 0x4a, 0x04, 0x08, 0x0c, 0x10, 0x0d, 0x4a, 0x04, 0x08, 0x0d, 0x10, 0x0e, 0x4a, 0x04, 0x08,
	0x0f, 0x10, 0x10, 0x52, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x73, 0x52, 0x12, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x13, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0b, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x12, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x13, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x63, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x49, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x45, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0x95, 0x01, 0x0a, 0x0c, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x58, 0x0a, 0x08, 0x41, 0x75, 0x74, 0x68,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x20, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x75,
	0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x12,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x0c, 0x12, 0x0a, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x1a, 0x2b, 0x92, 0x41, 0x28, 0x12, 0x26, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x20, 0x66, 0x6f, 0x72, 0x20, 0x61, 0x6e, 0x20, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x32,
	0xc9, 0x01, 0x0a, 0x02, 0x49, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74,
	0x49, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x19, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x13, 0x12, 0x11, 0x2f, 0x69, 0x73, 0x2f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x3c, 0x92,
	0x41, 0x39, 0x12, 0x37, 0x47, 0x65, 0x74, 0x20, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x20, 0x54, 0x68, 0x65, 0x20, 0x54, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x20, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x20, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x42, 0x31, 0x5a, 0x2f, 0x67,
	0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_identityserver_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_identityserver_proto_rawDescData = file_ttn_lorawan_v3_identityserver_proto_rawDesc
)

func file_ttn_lorawan_v3_identityserver_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_identityserver_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_identityserver_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_identityserver_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_identityserver_proto_rawDescData
}

var file_ttn_lorawan_v3_identityserver_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_ttn_lorawan_v3_identityserver_proto_goTypes = []interface{}{
	(*AuthInfoResponse)(nil),                                       // 0: ttn.lorawan.v3.AuthInfoResponse
	(*GetIsConfigurationRequest)(nil),                              // 1: ttn.lorawan.v3.GetIsConfigurationRequest
	(*IsConfiguration)(nil),                                        // 2: ttn.lorawan.v3.IsConfiguration
	(*GetIsConfigurationResponse)(nil),                             // 3: ttn.lorawan.v3.GetIsConfigurationResponse
	(*AuthInfoResponse_APIKeyAccess)(nil),                          // 4: ttn.lorawan.v3.AuthInfoResponse.APIKeyAccess
	(*AuthInfoResponse_GatewayToken)(nil),                          // 5: ttn.lorawan.v3.AuthInfoResponse.GatewayToken
	(*IsConfiguration_UserRegistration)(nil),                       // 6: ttn.lorawan.v3.IsConfiguration.UserRegistration
	(*IsConfiguration_ProfilePicture)(nil),                         // 7: ttn.lorawan.v3.IsConfiguration.ProfilePicture
	(*IsConfiguration_EndDevicePicture)(nil),                       // 8: ttn.lorawan.v3.IsConfiguration.EndDevicePicture
	(*IsConfiguration_UserRights)(nil),                             // 9: ttn.lorawan.v3.IsConfiguration.UserRights
	(*IsConfiguration_UserLogin)(nil),                              // 10: ttn.lorawan.v3.IsConfiguration.UserLogin
	(*IsConfiguration_AdminRights)(nil),                            // 11: ttn.lorawan.v3.IsConfiguration.AdminRights
	(*IsConfiguration_CollaboratorRights)(nil),                     // 12: ttn.lorawan.v3.IsConfiguration.CollaboratorRights
	(*IsConfiguration_UserRegistration_Invitation)(nil),            // 13: ttn.lorawan.v3.IsConfiguration.UserRegistration.Invitation
	(*IsConfiguration_UserRegistration_ContactInfoValidation)(nil), // 14: ttn.lorawan.v3.IsConfiguration.UserRegistration.ContactInfoValidation
	(*IsConfiguration_UserRegistration_AdminApproval)(nil),         // 15: ttn.lorawan.v3.IsConfiguration.UserRegistration.AdminApproval
	(*IsConfiguration_UserRegistration_PasswordRequirements)(nil),  // 16: ttn.lorawan.v3.IsConfiguration.UserRegistration.PasswordRequirements
	(*OAuthAccessToken)(nil),                                       // 17: ttn.lorawan.v3.OAuthAccessToken
	(*UserSession)(nil),                                            // 18: ttn.lorawan.v3.UserSession
	(*Rights)(nil),                                                 // 19: ttn.lorawan.v3.Rights
	(*APIKey)(nil),                                                 // 20: ttn.lorawan.v3.APIKey
	(*EntityIdentifiers)(nil),                                      // 21: ttn.lorawan.v3.EntityIdentifiers
	(*GatewayIdentifiers)(nil),                                     // 22: ttn.lorawan.v3.GatewayIdentifiers
	(Right)(0),                                                     // 23: ttn.lorawan.v3.Right
	(*wrapperspb.BoolValue)(nil),                                   // 24: google.protobuf.BoolValue
	(*durationpb.Duration)(nil),                                    // 25: google.protobuf.Duration
	(*wrapperspb.UInt32Value)(nil),                                 // 26: google.protobuf.UInt32Value
	(*emptypb.Empty)(nil),                                          // 27: google.protobuf.Empty
}
var file_ttn_lorawan_v3_identityserver_proto_depIdxs = []int32{
	4,  // 0: ttn.lorawan.v3.AuthInfoResponse.api_key:type_name -> ttn.lorawan.v3.AuthInfoResponse.APIKeyAccess
	17, // 1: ttn.lorawan.v3.AuthInfoResponse.oauth_access_token:type_name -> ttn.lorawan.v3.OAuthAccessToken
	18, // 2: ttn.lorawan.v3.AuthInfoResponse.user_session:type_name -> ttn.lorawan.v3.UserSession
	5,  // 3: ttn.lorawan.v3.AuthInfoResponse.gateway_token:type_name -> ttn.lorawan.v3.AuthInfoResponse.GatewayToken
	19, // 4: ttn.lorawan.v3.AuthInfoResponse.universal_rights:type_name -> ttn.lorawan.v3.Rights
	6,  // 5: ttn.lorawan.v3.IsConfiguration.user_registration:type_name -> ttn.lorawan.v3.IsConfiguration.UserRegistration
	7,  // 6: ttn.lorawan.v3.IsConfiguration.profile_picture:type_name -> ttn.lorawan.v3.IsConfiguration.ProfilePicture
	8,  // 7: ttn.lorawan.v3.IsConfiguration.end_device_picture:type_name -> ttn.lorawan.v3.IsConfiguration.EndDevicePicture
	9,  // 8: ttn.lorawan.v3.IsConfiguration.user_rights:type_name -> ttn.lorawan.v3.IsConfiguration.UserRights
	10, // 9: ttn.lorawan.v3.IsConfiguration.user_login:type_name -> ttn.lorawan.v3.IsConfiguration.UserLogin
	11, // 10: ttn.lorawan.v3.IsConfiguration.admin_rights:type_name -> ttn.lorawan.v3.IsConfiguration.AdminRights
	12, // 11: ttn.lorawan.v3.IsConfiguration.collaborator_rights:type_name -> ttn.lorawan.v3.IsConfiguration.CollaboratorRights
	2,  // 12: ttn.lorawan.v3.GetIsConfigurationResponse.configuration:type_name -> ttn.lorawan.v3.IsConfiguration
	20, // 13: ttn.lorawan.v3.AuthInfoResponse.APIKeyAccess.api_key:type_name -> ttn.lorawan.v3.APIKey
	21, // 14: ttn.lorawan.v3.AuthInfoResponse.APIKeyAccess.entity_ids:type_name -> ttn.lorawan.v3.EntityIdentifiers
	22, // 15: ttn.lorawan.v3.AuthInfoResponse.GatewayToken.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	23, // 16: ttn.lorawan.v3.AuthInfoResponse.GatewayToken.rights:type_name -> ttn.lorawan.v3.Right
	13, // 17: ttn.lorawan.v3.IsConfiguration.UserRegistration.invitation:type_name -> ttn.lorawan.v3.IsConfiguration.UserRegistration.Invitation
	14, // 18: ttn.lorawan.v3.IsConfiguration.UserRegistration.contact_info_validation:type_name -> ttn.lorawan.v3.IsConfiguration.UserRegistration.ContactInfoValidation
	15, // 19: ttn.lorawan.v3.IsConfiguration.UserRegistration.admin_approval:type_name -> ttn.lorawan.v3.IsConfiguration.UserRegistration.AdminApproval
	16, // 20: ttn.lorawan.v3.IsConfiguration.UserRegistration.password_requirements:type_name -> ttn.lorawan.v3.IsConfiguration.UserRegistration.PasswordRequirements
	24, // 21: ttn.lorawan.v3.IsConfiguration.ProfilePicture.disable_upload:type_name -> google.protobuf.BoolValue
	24, // 22: ttn.lorawan.v3.IsConfiguration.ProfilePicture.use_gravatar:type_name -> google.protobuf.BoolValue
	24, // 23: ttn.lorawan.v3.IsConfiguration.EndDevicePicture.disable_upload:type_name -> google.protobuf.BoolValue
	24, // 24: ttn.lorawan.v3.IsConfiguration.UserRights.create_applications:type_name -> google.protobuf.BoolValue
	24, // 25: ttn.lorawan.v3.IsConfiguration.UserRights.create_clients:type_name -> google.protobuf.BoolValue
	24, // 26: ttn.lorawan.v3.IsConfiguration.UserRights.create_gateways:type_name -> google.protobuf.BoolValue
	24, // 27: ttn.lorawan.v3.IsConfiguration.UserRights.create_organizations:type_name -> google.protobuf.BoolValue
	24, // 28: ttn.lorawan.v3.IsConfiguration.UserLogin.disable_credentials_login:type_name -> google.protobuf.BoolValue
	24, // 29: ttn.lorawan.v3.IsConfiguration.AdminRights.all:type_name -> google.protobuf.BoolValue
	24, // 30: ttn.lorawan.v3.IsConfiguration.CollaboratorRights.set_others_as_contacts:type_name -> google.protobuf.BoolValue
	24, // 31: ttn.lorawan.v3.IsConfiguration.UserRegistration.Invitation.required:type_name -> google.protobuf.BoolValue
	25, // 32: ttn.lorawan.v3.IsConfiguration.UserRegistration.Invitation.token_ttl:type_name -> google.protobuf.Duration
	24, // 33: ttn.lorawan.v3.IsConfiguration.UserRegistration.ContactInfoValidation.required:type_name -> google.protobuf.BoolValue
	25, // 34: ttn.lorawan.v3.IsConfiguration.UserRegistration.ContactInfoValidation.token_ttl:type_name -> google.protobuf.Duration
	25, // 35: ttn.lorawan.v3.IsConfiguration.UserRegistration.ContactInfoValidation.retry_interval:type_name -> google.protobuf.Duration
	24, // 36: ttn.lorawan.v3.IsConfiguration.UserRegistration.AdminApproval.required:type_name -> google.protobuf.BoolValue
	26, // 37: ttn.lorawan.v3.IsConfiguration.UserRegistration.PasswordRequirements.min_length:type_name -> google.protobuf.UInt32Value
	26, // 38: ttn.lorawan.v3.IsConfiguration.UserRegistration.PasswordRequirements.max_length:type_name -> google.protobuf.UInt32Value
	26, // 39: ttn.lorawan.v3.IsConfiguration.UserRegistration.PasswordRequirements.min_uppercase:type_name -> google.protobuf.UInt32Value
	26, // 40: ttn.lorawan.v3.IsConfiguration.UserRegistration.PasswordRequirements.min_digits:type_name -> google.protobuf.UInt32Value
	26, // 41: ttn.lorawan.v3.IsConfiguration.UserRegistration.PasswordRequirements.min_special:type_name -> google.protobuf.UInt32Value
	27, // 42: ttn.lorawan.v3.EntityAccess.AuthInfo:input_type -> google.protobuf.Empty
	1,  // 43: ttn.lorawan.v3.Is.GetConfiguration:input_type -> ttn.lorawan.v3.GetIsConfigurationRequest
	0,  // 44: ttn.lorawan.v3.EntityAccess.AuthInfo:output_type -> ttn.lorawan.v3.AuthInfoResponse
	3,  // 45: ttn.lorawan.v3.Is.GetConfiguration:output_type -> ttn.lorawan.v3.GetIsConfigurationResponse
	44, // [44:46] is the sub-list for method output_type
	42, // [42:44] is the sub-list for method input_type
	42, // [42:42] is the sub-list for extension type_name
	42, // [42:42] is the sub-list for extension extendee
	0,  // [0:42] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_identityserver_proto_init() }
func file_ttn_lorawan_v3_identityserver_proto_init() {
	if File_ttn_lorawan_v3_identityserver_proto != nil {
		return
	}
	file_ttn_lorawan_v3_identifiers_proto_init()
	file_ttn_lorawan_v3_oauth_proto_init()
	file_ttn_lorawan_v3_rights_proto_init()
	file_ttn_lorawan_v3_user_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthInfoResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIsConfigurationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIsConfigurationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthInfoResponse_APIKeyAccess); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthInfoResponse_GatewayToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsConfiguration_UserRegistration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsConfiguration_ProfilePicture); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsConfiguration_EndDevicePicture); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsConfiguration_UserRights); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsConfiguration_UserLogin); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsConfiguration_AdminRights); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsConfiguration_CollaboratorRights); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsConfiguration_UserRegistration_Invitation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsConfiguration_UserRegistration_ContactInfoValidation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsConfiguration_UserRegistration_AdminApproval); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_identityserver_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsConfiguration_UserRegistration_PasswordRequirements); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_ttn_lorawan_v3_identityserver_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*AuthInfoResponse_ApiKey)(nil),
		(*AuthInfoResponse_OauthAccessToken)(nil),
		(*AuthInfoResponse_UserSession)(nil),
		(*AuthInfoResponse_GatewayToken_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_identityserver_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_ttn_lorawan_v3_identityserver_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_identityserver_proto_depIdxs,
		MessageInfos:      file_ttn_lorawan_v3_identityserver_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_identityserver_proto = out.File
	file_ttn_lorawan_v3_identityserver_proto_rawDesc = nil
	file_ttn_lorawan_v3_identityserver_proto_goTypes = nil
	file_ttn_lorawan_v3_identityserver_proto_depIdxs = nil
}
