// Copyright © 2022 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.1
// source: ttn/lorawan/v3/gateway_configuration.proto

package ttnpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	GatewayConfigurationService_GetGatewayConfiguration_FullMethodName = "/ttn.lorawan.v3.GatewayConfigurationService/GetGatewayConfiguration"
)

// GatewayConfigurationServiceClient is the client API for GatewayConfigurationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GatewayConfigurationServiceClient interface {
	GetGatewayConfiguration(ctx context.Context, in *GetGatewayConfigurationRequest, opts ...grpc.CallOption) (*GetGatewayConfigurationResponse, error)
}

type gatewayConfigurationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewGatewayConfigurationServiceClient(cc grpc.ClientConnInterface) GatewayConfigurationServiceClient {
	return &gatewayConfigurationServiceClient{cc}
}

func (c *gatewayConfigurationServiceClient) GetGatewayConfiguration(ctx context.Context, in *GetGatewayConfigurationRequest, opts ...grpc.CallOption) (*GetGatewayConfigurationResponse, error) {
	out := new(GetGatewayConfigurationResponse)
	err := c.cc.Invoke(ctx, GatewayConfigurationService_GetGatewayConfiguration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GatewayConfigurationServiceServer is the server API for GatewayConfigurationService service.
// All implementations must embed UnimplementedGatewayConfigurationServiceServer
// for forward compatibility
type GatewayConfigurationServiceServer interface {
	GetGatewayConfiguration(context.Context, *GetGatewayConfigurationRequest) (*GetGatewayConfigurationResponse, error)
	mustEmbedUnimplementedGatewayConfigurationServiceServer()
}

// UnimplementedGatewayConfigurationServiceServer must be embedded to have forward compatible implementations.
type UnimplementedGatewayConfigurationServiceServer struct {
}

func (UnimplementedGatewayConfigurationServiceServer) GetGatewayConfiguration(context.Context, *GetGatewayConfigurationRequest) (*GetGatewayConfigurationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGatewayConfiguration not implemented")
}
func (UnimplementedGatewayConfigurationServiceServer) mustEmbedUnimplementedGatewayConfigurationServiceServer() {
}

// UnsafeGatewayConfigurationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GatewayConfigurationServiceServer will
// result in compilation errors.
type UnsafeGatewayConfigurationServiceServer interface {
	mustEmbedUnimplementedGatewayConfigurationServiceServer()
}

func RegisterGatewayConfigurationServiceServer(s grpc.ServiceRegistrar, srv GatewayConfigurationServiceServer) {
	s.RegisterService(&GatewayConfigurationService_ServiceDesc, srv)
}

func _GatewayConfigurationService_GetGatewayConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGatewayConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayConfigurationServiceServer).GetGatewayConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GatewayConfigurationService_GetGatewayConfiguration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayConfigurationServiceServer).GetGatewayConfiguration(ctx, req.(*GetGatewayConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GatewayConfigurationService_ServiceDesc is the grpc.ServiceDesc for GatewayConfigurationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GatewayConfigurationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.GatewayConfigurationService",
	HandlerType: (*GatewayConfigurationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetGatewayConfiguration",
			Handler:    _GatewayConfigurationService_GetGatewayConfiguration_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/gateway_configuration.proto",
}

const (
	ManagedGatewayConfigurationService_Get_FullMethodName                  = "/ttn.lorawan.v3.ManagedGatewayConfigurationService/Get"
	ManagedGatewayConfigurationService_Update_FullMethodName               = "/ttn.lorawan.v3.ManagedGatewayConfigurationService/Update"
	ManagedGatewayConfigurationService_StreamEvents_FullMethodName         = "/ttn.lorawan.v3.ManagedGatewayConfigurationService/StreamEvents"
	ManagedGatewayConfigurationService_ScanWiFiAccessPoints_FullMethodName = "/ttn.lorawan.v3.ManagedGatewayConfigurationService/ScanWiFiAccessPoints"
)

// ManagedGatewayConfigurationServiceClient is the client API for ManagedGatewayConfigurationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ManagedGatewayConfigurationServiceClient interface {
	Get(ctx context.Context, in *GetGatewayRequest, opts ...grpc.CallOption) (*ManagedGateway, error)
	Update(ctx context.Context, in *UpdateManagedGatewayRequest, opts ...grpc.CallOption) (*ManagedGateway, error)
	StreamEvents(ctx context.Context, in *GatewayIdentifiers, opts ...grpc.CallOption) (ManagedGatewayConfigurationService_StreamEventsClient, error)
	ScanWiFiAccessPoints(ctx context.Context, in *GatewayIdentifiers, opts ...grpc.CallOption) (*ManagedGatewayWiFiAccessPoints, error)
}

type managedGatewayConfigurationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewManagedGatewayConfigurationServiceClient(cc grpc.ClientConnInterface) ManagedGatewayConfigurationServiceClient {
	return &managedGatewayConfigurationServiceClient{cc}
}

func (c *managedGatewayConfigurationServiceClient) Get(ctx context.Context, in *GetGatewayRequest, opts ...grpc.CallOption) (*ManagedGateway, error) {
	out := new(ManagedGateway)
	err := c.cc.Invoke(ctx, ManagedGatewayConfigurationService_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedGatewayConfigurationServiceClient) Update(ctx context.Context, in *UpdateManagedGatewayRequest, opts ...grpc.CallOption) (*ManagedGateway, error) {
	out := new(ManagedGateway)
	err := c.cc.Invoke(ctx, ManagedGatewayConfigurationService_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedGatewayConfigurationServiceClient) StreamEvents(ctx context.Context, in *GatewayIdentifiers, opts ...grpc.CallOption) (ManagedGatewayConfigurationService_StreamEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &ManagedGatewayConfigurationService_ServiceDesc.Streams[0], ManagedGatewayConfigurationService_StreamEvents_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &managedGatewayConfigurationServiceStreamEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ManagedGatewayConfigurationService_StreamEventsClient interface {
	Recv() (*ManagedGatewayEventData, error)
	grpc.ClientStream
}

type managedGatewayConfigurationServiceStreamEventsClient struct {
	grpc.ClientStream
}

func (x *managedGatewayConfigurationServiceStreamEventsClient) Recv() (*ManagedGatewayEventData, error) {
	m := new(ManagedGatewayEventData)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *managedGatewayConfigurationServiceClient) ScanWiFiAccessPoints(ctx context.Context, in *GatewayIdentifiers, opts ...grpc.CallOption) (*ManagedGatewayWiFiAccessPoints, error) {
	out := new(ManagedGatewayWiFiAccessPoints)
	err := c.cc.Invoke(ctx, ManagedGatewayConfigurationService_ScanWiFiAccessPoints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ManagedGatewayConfigurationServiceServer is the server API for ManagedGatewayConfigurationService service.
// All implementations must embed UnimplementedManagedGatewayConfigurationServiceServer
// for forward compatibility
type ManagedGatewayConfigurationServiceServer interface {
	Get(context.Context, *GetGatewayRequest) (*ManagedGateway, error)
	Update(context.Context, *UpdateManagedGatewayRequest) (*ManagedGateway, error)
	StreamEvents(*GatewayIdentifiers, ManagedGatewayConfigurationService_StreamEventsServer) error
	ScanWiFiAccessPoints(context.Context, *GatewayIdentifiers) (*ManagedGatewayWiFiAccessPoints, error)
	mustEmbedUnimplementedManagedGatewayConfigurationServiceServer()
}

// UnimplementedManagedGatewayConfigurationServiceServer must be embedded to have forward compatible implementations.
type UnimplementedManagedGatewayConfigurationServiceServer struct {
}

func (UnimplementedManagedGatewayConfigurationServiceServer) Get(context.Context, *GetGatewayRequest) (*ManagedGateway, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedManagedGatewayConfigurationServiceServer) Update(context.Context, *UpdateManagedGatewayRequest) (*ManagedGateway, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedManagedGatewayConfigurationServiceServer) StreamEvents(*GatewayIdentifiers, ManagedGatewayConfigurationService_StreamEventsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamEvents not implemented")
}
func (UnimplementedManagedGatewayConfigurationServiceServer) ScanWiFiAccessPoints(context.Context, *GatewayIdentifiers) (*ManagedGatewayWiFiAccessPoints, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ScanWiFiAccessPoints not implemented")
}
func (UnimplementedManagedGatewayConfigurationServiceServer) mustEmbedUnimplementedManagedGatewayConfigurationServiceServer() {
}

// UnsafeManagedGatewayConfigurationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ManagedGatewayConfigurationServiceServer will
// result in compilation errors.
type UnsafeManagedGatewayConfigurationServiceServer interface {
	mustEmbedUnimplementedManagedGatewayConfigurationServiceServer()
}

func RegisterManagedGatewayConfigurationServiceServer(s grpc.ServiceRegistrar, srv ManagedGatewayConfigurationServiceServer) {
	s.RegisterService(&ManagedGatewayConfigurationService_ServiceDesc, srv)
}

func _ManagedGatewayConfigurationService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedGatewayConfigurationServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedGatewayConfigurationService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedGatewayConfigurationServiceServer).Get(ctx, req.(*GetGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedGatewayConfigurationService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateManagedGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedGatewayConfigurationServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedGatewayConfigurationService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedGatewayConfigurationServiceServer).Update(ctx, req.(*UpdateManagedGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedGatewayConfigurationService_StreamEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GatewayIdentifiers)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ManagedGatewayConfigurationServiceServer).StreamEvents(m, &managedGatewayConfigurationServiceStreamEventsServer{stream})
}

type ManagedGatewayConfigurationService_StreamEventsServer interface {
	Send(*ManagedGatewayEventData) error
	grpc.ServerStream
}

type managedGatewayConfigurationServiceStreamEventsServer struct {
	grpc.ServerStream
}

func (x *managedGatewayConfigurationServiceStreamEventsServer) Send(m *ManagedGatewayEventData) error {
	return x.ServerStream.SendMsg(m)
}

func _ManagedGatewayConfigurationService_ScanWiFiAccessPoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GatewayIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedGatewayConfigurationServiceServer).ScanWiFiAccessPoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedGatewayConfigurationService_ScanWiFiAccessPoints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedGatewayConfigurationServiceServer).ScanWiFiAccessPoints(ctx, req.(*GatewayIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

// ManagedGatewayConfigurationService_ServiceDesc is the grpc.ServiceDesc for ManagedGatewayConfigurationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ManagedGatewayConfigurationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.ManagedGatewayConfigurationService",
	HandlerType: (*ManagedGatewayConfigurationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ManagedGatewayConfigurationService_Get_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ManagedGatewayConfigurationService_Update_Handler,
		},
		{
			MethodName: "ScanWiFiAccessPoints",
			Handler:    _ManagedGatewayConfigurationService_ScanWiFiAccessPoints_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamEvents",
			Handler:       _ManagedGatewayConfigurationService_StreamEvents_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "ttn/lorawan/v3/gateway_configuration.proto",
}

const (
	ManagedGatewayWiFiProfileConfigurationService_Create_FullMethodName = "/ttn.lorawan.v3.ManagedGatewayWiFiProfileConfigurationService/Create"
	ManagedGatewayWiFiProfileConfigurationService_Update_FullMethodName = "/ttn.lorawan.v3.ManagedGatewayWiFiProfileConfigurationService/Update"
	ManagedGatewayWiFiProfileConfigurationService_List_FullMethodName   = "/ttn.lorawan.v3.ManagedGatewayWiFiProfileConfigurationService/List"
	ManagedGatewayWiFiProfileConfigurationService_Get_FullMethodName    = "/ttn.lorawan.v3.ManagedGatewayWiFiProfileConfigurationService/Get"
	ManagedGatewayWiFiProfileConfigurationService_Delete_FullMethodName = "/ttn.lorawan.v3.ManagedGatewayWiFiProfileConfigurationService/Delete"
)

// ManagedGatewayWiFiProfileConfigurationServiceClient is the client API for ManagedGatewayWiFiProfileConfigurationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ManagedGatewayWiFiProfileConfigurationServiceClient interface {
	Create(ctx context.Context, in *CreateManagedGatewayWiFiProfileRequest, opts ...grpc.CallOption) (*ManagedGatewayWiFiProfile, error)
	Update(ctx context.Context, in *UpdateManagedGatewayWiFiProfileRequest, opts ...grpc.CallOption) (*ManagedGatewayWiFiProfile, error)
	List(ctx context.Context, in *ListManagedGatewayWiFiProfilesRequest, opts ...grpc.CallOption) (*ManagedGatewayWiFiProfiles, error)
	Get(ctx context.Context, in *GetManagedGatewayWiFiProfileRequest, opts ...grpc.CallOption) (*ManagedGatewayWiFiProfile, error)
	Delete(ctx context.Context, in *DeleteManagedGatewayWiFiProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type managedGatewayWiFiProfileConfigurationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewManagedGatewayWiFiProfileConfigurationServiceClient(cc grpc.ClientConnInterface) ManagedGatewayWiFiProfileConfigurationServiceClient {
	return &managedGatewayWiFiProfileConfigurationServiceClient{cc}
}

func (c *managedGatewayWiFiProfileConfigurationServiceClient) Create(ctx context.Context, in *CreateManagedGatewayWiFiProfileRequest, opts ...grpc.CallOption) (*ManagedGatewayWiFiProfile, error) {
	out := new(ManagedGatewayWiFiProfile)
	err := c.cc.Invoke(ctx, ManagedGatewayWiFiProfileConfigurationService_Create_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedGatewayWiFiProfileConfigurationServiceClient) Update(ctx context.Context, in *UpdateManagedGatewayWiFiProfileRequest, opts ...grpc.CallOption) (*ManagedGatewayWiFiProfile, error) {
	out := new(ManagedGatewayWiFiProfile)
	err := c.cc.Invoke(ctx, ManagedGatewayWiFiProfileConfigurationService_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedGatewayWiFiProfileConfigurationServiceClient) List(ctx context.Context, in *ListManagedGatewayWiFiProfilesRequest, opts ...grpc.CallOption) (*ManagedGatewayWiFiProfiles, error) {
	out := new(ManagedGatewayWiFiProfiles)
	err := c.cc.Invoke(ctx, ManagedGatewayWiFiProfileConfigurationService_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedGatewayWiFiProfileConfigurationServiceClient) Get(ctx context.Context, in *GetManagedGatewayWiFiProfileRequest, opts ...grpc.CallOption) (*ManagedGatewayWiFiProfile, error) {
	out := new(ManagedGatewayWiFiProfile)
	err := c.cc.Invoke(ctx, ManagedGatewayWiFiProfileConfigurationService_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedGatewayWiFiProfileConfigurationServiceClient) Delete(ctx context.Context, in *DeleteManagedGatewayWiFiProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ManagedGatewayWiFiProfileConfigurationService_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ManagedGatewayWiFiProfileConfigurationServiceServer is the server API for ManagedGatewayWiFiProfileConfigurationService service.
// All implementations must embed UnimplementedManagedGatewayWiFiProfileConfigurationServiceServer
// for forward compatibility
type ManagedGatewayWiFiProfileConfigurationServiceServer interface {
	Create(context.Context, *CreateManagedGatewayWiFiProfileRequest) (*ManagedGatewayWiFiProfile, error)
	Update(context.Context, *UpdateManagedGatewayWiFiProfileRequest) (*ManagedGatewayWiFiProfile, error)
	List(context.Context, *ListManagedGatewayWiFiProfilesRequest) (*ManagedGatewayWiFiProfiles, error)
	Get(context.Context, *GetManagedGatewayWiFiProfileRequest) (*ManagedGatewayWiFiProfile, error)
	Delete(context.Context, *DeleteManagedGatewayWiFiProfileRequest) (*emptypb.Empty, error)
	mustEmbedUnimplementedManagedGatewayWiFiProfileConfigurationServiceServer()
}

// UnimplementedManagedGatewayWiFiProfileConfigurationServiceServer must be embedded to have forward compatible implementations.
type UnimplementedManagedGatewayWiFiProfileConfigurationServiceServer struct {
}

func (UnimplementedManagedGatewayWiFiProfileConfigurationServiceServer) Create(context.Context, *CreateManagedGatewayWiFiProfileRequest) (*ManagedGatewayWiFiProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedManagedGatewayWiFiProfileConfigurationServiceServer) Update(context.Context, *UpdateManagedGatewayWiFiProfileRequest) (*ManagedGatewayWiFiProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedManagedGatewayWiFiProfileConfigurationServiceServer) List(context.Context, *ListManagedGatewayWiFiProfilesRequest) (*ManagedGatewayWiFiProfiles, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedManagedGatewayWiFiProfileConfigurationServiceServer) Get(context.Context, *GetManagedGatewayWiFiProfileRequest) (*ManagedGatewayWiFiProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedManagedGatewayWiFiProfileConfigurationServiceServer) Delete(context.Context, *DeleteManagedGatewayWiFiProfileRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedManagedGatewayWiFiProfileConfigurationServiceServer) mustEmbedUnimplementedManagedGatewayWiFiProfileConfigurationServiceServer() {
}

// UnsafeManagedGatewayWiFiProfileConfigurationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ManagedGatewayWiFiProfileConfigurationServiceServer will
// result in compilation errors.
type UnsafeManagedGatewayWiFiProfileConfigurationServiceServer interface {
	mustEmbedUnimplementedManagedGatewayWiFiProfileConfigurationServiceServer()
}

func RegisterManagedGatewayWiFiProfileConfigurationServiceServer(s grpc.ServiceRegistrar, srv ManagedGatewayWiFiProfileConfigurationServiceServer) {
	s.RegisterService(&ManagedGatewayWiFiProfileConfigurationService_ServiceDesc, srv)
}

func _ManagedGatewayWiFiProfileConfigurationService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateManagedGatewayWiFiProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedGatewayWiFiProfileConfigurationServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedGatewayWiFiProfileConfigurationService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedGatewayWiFiProfileConfigurationServiceServer).Create(ctx, req.(*CreateManagedGatewayWiFiProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedGatewayWiFiProfileConfigurationService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateManagedGatewayWiFiProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedGatewayWiFiProfileConfigurationServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedGatewayWiFiProfileConfigurationService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedGatewayWiFiProfileConfigurationServiceServer).Update(ctx, req.(*UpdateManagedGatewayWiFiProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedGatewayWiFiProfileConfigurationService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListManagedGatewayWiFiProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedGatewayWiFiProfileConfigurationServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedGatewayWiFiProfileConfigurationService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedGatewayWiFiProfileConfigurationServiceServer).List(ctx, req.(*ListManagedGatewayWiFiProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedGatewayWiFiProfileConfigurationService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetManagedGatewayWiFiProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedGatewayWiFiProfileConfigurationServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedGatewayWiFiProfileConfigurationService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedGatewayWiFiProfileConfigurationServiceServer).Get(ctx, req.(*GetManagedGatewayWiFiProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedGatewayWiFiProfileConfigurationService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteManagedGatewayWiFiProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedGatewayWiFiProfileConfigurationServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedGatewayWiFiProfileConfigurationService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedGatewayWiFiProfileConfigurationServiceServer).Delete(ctx, req.(*DeleteManagedGatewayWiFiProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ManagedGatewayWiFiProfileConfigurationService_ServiceDesc is the grpc.ServiceDesc for ManagedGatewayWiFiProfileConfigurationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ManagedGatewayWiFiProfileConfigurationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.ManagedGatewayWiFiProfileConfigurationService",
	HandlerType: (*ManagedGatewayWiFiProfileConfigurationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _ManagedGatewayWiFiProfileConfigurationService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ManagedGatewayWiFiProfileConfigurationService_Update_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ManagedGatewayWiFiProfileConfigurationService_List_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _ManagedGatewayWiFiProfileConfigurationService_Get_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ManagedGatewayWiFiProfileConfigurationService_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/gateway_configuration.proto",
}

const (
	ManagedGatewayEthernetProfileConfigurationService_Create_FullMethodName = "/ttn.lorawan.v3.ManagedGatewayEthernetProfileConfigurationService/Create"
	ManagedGatewayEthernetProfileConfigurationService_Update_FullMethodName = "/ttn.lorawan.v3.ManagedGatewayEthernetProfileConfigurationService/Update"
	ManagedGatewayEthernetProfileConfigurationService_List_FullMethodName   = "/ttn.lorawan.v3.ManagedGatewayEthernetProfileConfigurationService/List"
	ManagedGatewayEthernetProfileConfigurationService_Get_FullMethodName    = "/ttn.lorawan.v3.ManagedGatewayEthernetProfileConfigurationService/Get"
	ManagedGatewayEthernetProfileConfigurationService_Delete_FullMethodName = "/ttn.lorawan.v3.ManagedGatewayEthernetProfileConfigurationService/Delete"
)

// ManagedGatewayEthernetProfileConfigurationServiceClient is the client API for ManagedGatewayEthernetProfileConfigurationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ManagedGatewayEthernetProfileConfigurationServiceClient interface {
	Create(ctx context.Context, in *CreateManagedGatewayEthernetProfileRequest, opts ...grpc.CallOption) (*ManagedGatewayEthernetProfile, error)
	Update(ctx context.Context, in *UpdateManagedGatewayEthernetProfileRequest, opts ...grpc.CallOption) (*ManagedGatewayEthernetProfile, error)
	List(ctx context.Context, in *ListManagedGatewayEthernetProfilesRequest, opts ...grpc.CallOption) (*ManagedGatewayEthernetProfiles, error)
	Get(ctx context.Context, in *GetManagedGatewayEthernetProfileRequest, opts ...grpc.CallOption) (*ManagedGatewayEthernetProfile, error)
	Delete(ctx context.Context, in *DeleteManagedGatewayEthernetProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type managedGatewayEthernetProfileConfigurationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewManagedGatewayEthernetProfileConfigurationServiceClient(cc grpc.ClientConnInterface) ManagedGatewayEthernetProfileConfigurationServiceClient {
	return &managedGatewayEthernetProfileConfigurationServiceClient{cc}
}

func (c *managedGatewayEthernetProfileConfigurationServiceClient) Create(ctx context.Context, in *CreateManagedGatewayEthernetProfileRequest, opts ...grpc.CallOption) (*ManagedGatewayEthernetProfile, error) {
	out := new(ManagedGatewayEthernetProfile)
	err := c.cc.Invoke(ctx, ManagedGatewayEthernetProfileConfigurationService_Create_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedGatewayEthernetProfileConfigurationServiceClient) Update(ctx context.Context, in *UpdateManagedGatewayEthernetProfileRequest, opts ...grpc.CallOption) (*ManagedGatewayEthernetProfile, error) {
	out := new(ManagedGatewayEthernetProfile)
	err := c.cc.Invoke(ctx, ManagedGatewayEthernetProfileConfigurationService_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedGatewayEthernetProfileConfigurationServiceClient) List(ctx context.Context, in *ListManagedGatewayEthernetProfilesRequest, opts ...grpc.CallOption) (*ManagedGatewayEthernetProfiles, error) {
	out := new(ManagedGatewayEthernetProfiles)
	err := c.cc.Invoke(ctx, ManagedGatewayEthernetProfileConfigurationService_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedGatewayEthernetProfileConfigurationServiceClient) Get(ctx context.Context, in *GetManagedGatewayEthernetProfileRequest, opts ...grpc.CallOption) (*ManagedGatewayEthernetProfile, error) {
	out := new(ManagedGatewayEthernetProfile)
	err := c.cc.Invoke(ctx, ManagedGatewayEthernetProfileConfigurationService_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedGatewayEthernetProfileConfigurationServiceClient) Delete(ctx context.Context, in *DeleteManagedGatewayEthernetProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ManagedGatewayEthernetProfileConfigurationService_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ManagedGatewayEthernetProfileConfigurationServiceServer is the server API for ManagedGatewayEthernetProfileConfigurationService service.
// All implementations must embed UnimplementedManagedGatewayEthernetProfileConfigurationServiceServer
// for forward compatibility
type ManagedGatewayEthernetProfileConfigurationServiceServer interface {
	Create(context.Context, *CreateManagedGatewayEthernetProfileRequest) (*ManagedGatewayEthernetProfile, error)
	Update(context.Context, *UpdateManagedGatewayEthernetProfileRequest) (*ManagedGatewayEthernetProfile, error)
	List(context.Context, *ListManagedGatewayEthernetProfilesRequest) (*ManagedGatewayEthernetProfiles, error)
	Get(context.Context, *GetManagedGatewayEthernetProfileRequest) (*ManagedGatewayEthernetProfile, error)
	Delete(context.Context, *DeleteManagedGatewayEthernetProfileRequest) (*emptypb.Empty, error)
	mustEmbedUnimplementedManagedGatewayEthernetProfileConfigurationServiceServer()
}

// UnimplementedManagedGatewayEthernetProfileConfigurationServiceServer must be embedded to have forward compatible implementations.
type UnimplementedManagedGatewayEthernetProfileConfigurationServiceServer struct {
}

func (UnimplementedManagedGatewayEthernetProfileConfigurationServiceServer) Create(context.Context, *CreateManagedGatewayEthernetProfileRequest) (*ManagedGatewayEthernetProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedManagedGatewayEthernetProfileConfigurationServiceServer) Update(context.Context, *UpdateManagedGatewayEthernetProfileRequest) (*ManagedGatewayEthernetProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedManagedGatewayEthernetProfileConfigurationServiceServer) List(context.Context, *ListManagedGatewayEthernetProfilesRequest) (*ManagedGatewayEthernetProfiles, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedManagedGatewayEthernetProfileConfigurationServiceServer) Get(context.Context, *GetManagedGatewayEthernetProfileRequest) (*ManagedGatewayEthernetProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedManagedGatewayEthernetProfileConfigurationServiceServer) Delete(context.Context, *DeleteManagedGatewayEthernetProfileRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedManagedGatewayEthernetProfileConfigurationServiceServer) mustEmbedUnimplementedManagedGatewayEthernetProfileConfigurationServiceServer() {
}

// UnsafeManagedGatewayEthernetProfileConfigurationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ManagedGatewayEthernetProfileConfigurationServiceServer will
// result in compilation errors.
type UnsafeManagedGatewayEthernetProfileConfigurationServiceServer interface {
	mustEmbedUnimplementedManagedGatewayEthernetProfileConfigurationServiceServer()
}

func RegisterManagedGatewayEthernetProfileConfigurationServiceServer(s grpc.ServiceRegistrar, srv ManagedGatewayEthernetProfileConfigurationServiceServer) {
	s.RegisterService(&ManagedGatewayEthernetProfileConfigurationService_ServiceDesc, srv)
}

func _ManagedGatewayEthernetProfileConfigurationService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateManagedGatewayEthernetProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedGatewayEthernetProfileConfigurationServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedGatewayEthernetProfileConfigurationService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedGatewayEthernetProfileConfigurationServiceServer).Create(ctx, req.(*CreateManagedGatewayEthernetProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedGatewayEthernetProfileConfigurationService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateManagedGatewayEthernetProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedGatewayEthernetProfileConfigurationServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedGatewayEthernetProfileConfigurationService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedGatewayEthernetProfileConfigurationServiceServer).Update(ctx, req.(*UpdateManagedGatewayEthernetProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedGatewayEthernetProfileConfigurationService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListManagedGatewayEthernetProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedGatewayEthernetProfileConfigurationServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedGatewayEthernetProfileConfigurationService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedGatewayEthernetProfileConfigurationServiceServer).List(ctx, req.(*ListManagedGatewayEthernetProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedGatewayEthernetProfileConfigurationService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetManagedGatewayEthernetProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedGatewayEthernetProfileConfigurationServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedGatewayEthernetProfileConfigurationService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedGatewayEthernetProfileConfigurationServiceServer).Get(ctx, req.(*GetManagedGatewayEthernetProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedGatewayEthernetProfileConfigurationService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteManagedGatewayEthernetProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedGatewayEthernetProfileConfigurationServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedGatewayEthernetProfileConfigurationService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedGatewayEthernetProfileConfigurationServiceServer).Delete(ctx, req.(*DeleteManagedGatewayEthernetProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ManagedGatewayEthernetProfileConfigurationService_ServiceDesc is the grpc.ServiceDesc for ManagedGatewayEthernetProfileConfigurationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ManagedGatewayEthernetProfileConfigurationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.ManagedGatewayEthernetProfileConfigurationService",
	HandlerType: (*ManagedGatewayEthernetProfileConfigurationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _ManagedGatewayEthernetProfileConfigurationService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ManagedGatewayEthernetProfileConfigurationService_Update_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ManagedGatewayEthernetProfileConfigurationService_List_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _ManagedGatewayEthernetProfileConfigurationService_Get_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ManagedGatewayEthernetProfileConfigurationService_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/gateway_configuration.proto",
}
