// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// define the regex for a UUID once up-front
var _gateway_uuidPattern = regexp.MustCompile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")

// ValidateFields checks the field values on GatewayBrand with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GatewayBrand) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayBrandFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "id":
			// no validation rules for Id
		case "name":
			// no validation rules for Name
		case "url":
			// no validation rules for Url
		case "logos":

		default:
			return GatewayBrandValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayBrandValidationError is the validation error returned by
// GatewayBrand.ValidateFields if the designated constraints aren't met.
type GatewayBrandValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayBrandValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayBrandValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayBrandValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayBrandValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayBrandValidationError) ErrorName() string { return "GatewayBrandValidationError" }

// Error satisfies the builtin error interface
func (e GatewayBrandValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayBrand.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayBrandValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayBrandValidationError{}

// ValidateFields checks the field values on GatewayModel with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GatewayModel) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayModelFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "brand_id":

			if m.GetBrandId() != "" {

				if utf8.RuneCountInString(m.GetBrandId()) > 36 {
					return GatewayModelValidationError{
						field:  "brand_id",
						reason: "value length must be at most 36 runes",
					}
				}

				if !_GatewayModel_BrandId_Pattern.MatchString(m.GetBrandId()) {
					return GatewayModelValidationError{
						field:  "brand_id",
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

			}

		case "id":

			if m.GetId() != "" {

				if utf8.RuneCountInString(m.GetId()) > 36 {
					return GatewayModelValidationError{
						field:  "id",
						reason: "value length must be at most 36 runes",
					}
				}

				if !_GatewayModel_Id_Pattern.MatchString(m.GetId()) {
					return GatewayModelValidationError{
						field:  "id",
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

			}

		case "name":
			// no validation rules for Name
		default:
			return GatewayModelValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayModelValidationError is the validation error returned by
// GatewayModel.ValidateFields if the designated constraints aren't met.
type GatewayModelValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayModelValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayModelValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayModelValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayModelValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayModelValidationError) ErrorName() string { return "GatewayModelValidationError" }

// Error satisfies the builtin error interface
func (e GatewayModelValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayModel.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayModelValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayModelValidationError{}

var _GatewayModel_BrandId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

var _GatewayModel_Id_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on GatewayVersionIdentifiers with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GatewayVersionIdentifiers) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayVersionIdentifiersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "brand_id":

			if m.GetBrandId() != "" {

				if utf8.RuneCountInString(m.GetBrandId()) > 36 {
					return GatewayVersionIdentifiersValidationError{
						field:  "brand_id",
						reason: "value length must be at most 36 runes",
					}
				}

				if !_GatewayVersionIdentifiers_BrandId_Pattern.MatchString(m.GetBrandId()) {
					return GatewayVersionIdentifiersValidationError{
						field:  "brand_id",
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

			}

		case "model_id":

			if m.GetModelId() != "" {

				if utf8.RuneCountInString(m.GetModelId()) > 36 {
					return GatewayVersionIdentifiersValidationError{
						field:  "model_id",
						reason: "value length must be at most 36 runes",
					}
				}

				if !_GatewayVersionIdentifiers_ModelId_Pattern.MatchString(m.GetModelId()) {
					return GatewayVersionIdentifiersValidationError{
						field:  "model_id",
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

			}

		case "hardware_version":

			if utf8.RuneCountInString(m.GetHardwareVersion()) > 32 {
				return GatewayVersionIdentifiersValidationError{
					field:  "hardware_version",
					reason: "value length must be at most 32 runes",
				}
			}

		case "firmware_version":

			if utf8.RuneCountInString(m.GetFirmwareVersion()) > 32 {
				return GatewayVersionIdentifiersValidationError{
					field:  "firmware_version",
					reason: "value length must be at most 32 runes",
				}
			}

		case "runtime_version":

			if utf8.RuneCountInString(m.GetRuntimeVersion()) > 32 {
				return GatewayVersionIdentifiersValidationError{
					field:  "runtime_version",
					reason: "value length must be at most 32 runes",
				}
			}

		default:
			return GatewayVersionIdentifiersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayVersionIdentifiersValidationError is the validation error returned by
// GatewayVersionIdentifiers.ValidateFields if the designated constraints
// aren't met.
type GatewayVersionIdentifiersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayVersionIdentifiersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayVersionIdentifiersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayVersionIdentifiersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayVersionIdentifiersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayVersionIdentifiersValidationError) ErrorName() string {
	return "GatewayVersionIdentifiersValidationError"
}

// Error satisfies the builtin error interface
func (e GatewayVersionIdentifiersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayVersionIdentifiers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayVersionIdentifiersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayVersionIdentifiersValidationError{}

var _GatewayVersionIdentifiers_BrandId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

var _GatewayVersionIdentifiers_ModelId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on GatewayRadio with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GatewayRadio) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayRadioFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "enable":
			// no validation rules for Enable
		case "chip_type":
			// no validation rules for ChipType
		case "frequency":
			// no validation rules for Frequency
		case "rssi_offset":
			// no validation rules for RssiOffset
		case "tx_configuration":

			if v, ok := interface{}(m.GetTxConfiguration()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayRadioValidationError{
						field:  "tx_configuration",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GatewayRadioValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayRadioValidationError is the validation error returned by
// GatewayRadio.ValidateFields if the designated constraints aren't met.
type GatewayRadioValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayRadioValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayRadioValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayRadioValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayRadioValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayRadioValidationError) ErrorName() string { return "GatewayRadioValidationError" }

// Error satisfies the builtin error interface
func (e GatewayRadioValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayRadio.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayRadioValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayRadioValidationError{}

// ValidateFields checks the field values on GatewayClaimAuthenticationCode
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *GatewayClaimAuthenticationCode) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayClaimAuthenticationCodeFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "secret":

			if v, ok := interface{}(m.GetSecret()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayClaimAuthenticationCodeValidationError{
						field:  "secret",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "valid_from":

			if v, ok := interface{}(m.GetValidFrom()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayClaimAuthenticationCodeValidationError{
						field:  "valid_from",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "valid_to":

			if v, ok := interface{}(m.GetValidTo()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayClaimAuthenticationCodeValidationError{
						field:  "valid_to",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GatewayClaimAuthenticationCodeValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayClaimAuthenticationCodeValidationError is the validation error
// returned by GatewayClaimAuthenticationCode.ValidateFields if the designated
// constraints aren't met.
type GatewayClaimAuthenticationCodeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayClaimAuthenticationCodeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayClaimAuthenticationCodeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayClaimAuthenticationCodeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayClaimAuthenticationCodeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayClaimAuthenticationCodeValidationError) ErrorName() string {
	return "GatewayClaimAuthenticationCodeValidationError"
}

// Error satisfies the builtin error interface
func (e GatewayClaimAuthenticationCodeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayClaimAuthenticationCode.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayClaimAuthenticationCodeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayClaimAuthenticationCodeValidationError{}

// ValidateFields checks the field values on Gateway with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *Gateway) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return GatewayValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "created_at":

			if v, ok := interface{}(m.GetCreatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayValidationError{
						field:  "created_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "deleted_at":

			if v, ok := interface{}(m.GetDeletedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayValidationError{
						field:  "deleted_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "name":

			if utf8.RuneCountInString(m.GetName()) > 50 {
				return GatewayValidationError{
					field:  "name",
					reason: "value length must be at most 50 runes",
				}
			}

		case "description":

			if utf8.RuneCountInString(m.GetDescription()) > 2000 {
				return GatewayValidationError{
					field:  "description",
					reason: "value length must be at most 2000 runes",
				}
			}

		case "attributes":

			if len(m.GetAttributes()) > 10 {
				return GatewayValidationError{
					field:  "attributes",
					reason: "value must contain no more than 10 pair(s)",
				}
			}

			for key, val := range m.GetAttributes() {
				_ = val

				if utf8.RuneCountInString(key) > 36 {
					return GatewayValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value length must be at most 36 runes",
					}
				}

				if !_Gateway_Attributes_Pattern.MatchString(key) {
					return GatewayValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

				if utf8.RuneCountInString(val) > 200 {
					return GatewayValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value length must be at most 200 runes",
					}
				}

			}

		case "contact_info":

			if len(m.GetContactInfo()) > 10 {
				return GatewayValidationError{
					field:  "contact_info",
					reason: "value must contain no more than 10 item(s)",
				}
			}

			for idx, item := range m.GetContactInfo() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return GatewayValidationError{
							field:  fmt.Sprintf("contact_info[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "administrative_contact":

			if v, ok := interface{}(m.GetAdministrativeContact()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayValidationError{
						field:  "administrative_contact",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "technical_contact":

			if v, ok := interface{}(m.GetTechnicalContact()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayValidationError{
						field:  "technical_contact",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "version_ids":

			if v, ok := interface{}(m.GetVersionIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayValidationError{
						field:  "version_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "gateway_server_address":

			if !_Gateway_GatewayServerAddress_Pattern.MatchString(m.GetGatewayServerAddress()) {
				return GatewayValidationError{
					field:  "gateway_server_address",
					reason: "value does not match regex pattern \"^([a-z]{2,5}://)?(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\\\-]*[a-zA-Z0-9])\\\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$\"",
				}
			}

		case "auto_update":
			// no validation rules for AutoUpdate
		case "update_channel":

			if utf8.RuneCountInString(m.GetUpdateChannel()) > 128 {
				return GatewayValidationError{
					field:  "update_channel",
					reason: "value length must be at most 128 runes",
				}
			}

		case "frequency_plan_id":

			if utf8.RuneCountInString(m.GetFrequencyPlanId()) > 64 {
				return GatewayValidationError{
					field:  "frequency_plan_id",
					reason: "value length must be at most 64 runes",
				}
			}

		case "frequency_plan_ids":

			if len(m.GetFrequencyPlanIds()) > 8 {
				return GatewayValidationError{
					field:  "frequency_plan_ids",
					reason: "value must contain no more than 8 item(s)",
				}
			}

			for idx, item := range m.GetFrequencyPlanIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 64 {
					return GatewayValidationError{
						field:  fmt.Sprintf("frequency_plan_ids[%v]", idx),
						reason: "value length must be at most 64 runes",
					}
				}

			}

		case "antennas":

			if len(m.GetAntennas()) > 8 {
				return GatewayValidationError{
					field:  "antennas",
					reason: "value must contain no more than 8 item(s)",
				}
			}

			for idx, item := range m.GetAntennas() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return GatewayValidationError{
							field:  fmt.Sprintf("antennas[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "status_public":
			// no validation rules for StatusPublic
		case "location_public":
			// no validation rules for LocationPublic
		case "schedule_downlink_late":
			// no validation rules for ScheduleDownlinkLate
		case "enforce_duty_cycle":
			// no validation rules for EnforceDutyCycle
		case "downlink_path_constraint":

			if _, ok := DownlinkPathConstraint_name[int32(m.GetDownlinkPathConstraint())]; !ok {
				return GatewayValidationError{
					field:  "downlink_path_constraint",
					reason: "value must be one of the defined enum values",
				}
			}

		case "schedule_anytime_delay":

			if v, ok := interface{}(m.GetScheduleAnytimeDelay()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayValidationError{
						field:  "schedule_anytime_delay",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "update_location_from_status":
			// no validation rules for UpdateLocationFromStatus
		case "lbs_lns_secret":

			if v, ok := interface{}(m.GetLbsLnsSecret()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayValidationError{
						field:  "lbs_lns_secret",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "claim_authentication_code":

			if v, ok := interface{}(m.GetClaimAuthenticationCode()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayValidationError{
						field:  "claim_authentication_code",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "target_cups_uri":

			if m.GetTargetCupsUri() != "" {

				if uri, err := url.Parse(m.GetTargetCupsUri()); err != nil {
					return GatewayValidationError{
						field:  "target_cups_uri",
						reason: "value must be a valid URI",
						cause:  err,
					}
				} else if !uri.IsAbs() {
					return GatewayValidationError{
						field:  "target_cups_uri",
						reason: "value must be absolute",
					}
				}

			}

		case "target_cups_key":

			if v, ok := interface{}(m.GetTargetCupsKey()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayValidationError{
						field:  "target_cups_key",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "require_authenticated_connection":
			// no validation rules for RequireAuthenticatedConnection
		case "lrfhss":

			if v, ok := interface{}(m.GetLrfhss()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayValidationError{
						field:  "lrfhss",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "disable_packet_broker_forwarding":
			// no validation rules for DisablePacketBrokerForwarding
		default:
			return GatewayValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayValidationError is the validation error returned by
// Gateway.ValidateFields if the designated constraints aren't met.
type GatewayValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayValidationError) ErrorName() string { return "GatewayValidationError" }

// Error satisfies the builtin error interface
func (e GatewayValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGateway.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayValidationError{}

var _Gateway_Attributes_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

var _Gateway_GatewayServerAddress_Pattern = regexp.MustCompile("^([a-z]{2,5}://)?(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$")

// ValidateFields checks the field values on Gateways with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *Gateways) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewaysFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateways":

			for idx, item := range m.GetGateways() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return GatewaysValidationError{
							field:  fmt.Sprintf("gateways[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return GatewaysValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewaysValidationError is the validation error returned by
// Gateways.ValidateFields if the designated constraints aren't met.
type GatewaysValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewaysValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewaysValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewaysValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewaysValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewaysValidationError) ErrorName() string { return "GatewaysValidationError" }

// Error satisfies the builtin error interface
func (e GatewaysValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGateways.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewaysValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewaysValidationError{}

// ValidateFields checks the field values on ManagedGateway with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ManagedGateway) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return ManagedGatewayValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ManagedGatewayValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "version_ids":

			if v, ok := interface{}(m.GetVersionIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ManagedGatewayValidationError{
						field:  "version_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "cellular_imei":

			if m.GetCellularImei() != "" {

				if !_ManagedGateway_CellularImei_Pattern.MatchString(m.GetCellularImei()) {
					return ManagedGatewayValidationError{
						field:  "cellular_imei",
						reason: "value does not match regex pattern \"^[0-9]{15}$\"",
					}
				}

			}

		case "cellular_imsi":

			if m.GetCellularImsi() != "" {

				if !_ManagedGateway_CellularImsi_Pattern.MatchString(m.GetCellularImsi()) {
					return ManagedGatewayValidationError{
						field:  "cellular_imsi",
						reason: "value does not match regex pattern \"^[0-9]{15}$\"",
					}
				}

			}

		case "wifi_mac_address":

			if len(m.GetWifiMacAddress()) > 0 {

				if len(m.GetWifiMacAddress()) != 6 {
					return ManagedGatewayValidationError{
						field:  "wifi_mac_address",
						reason: "value length must be 6 bytes",
					}
				}

			}

		case "ethernet_mac_address":

			if len(m.GetEthernetMacAddress()) > 0 {

				if len(m.GetEthernetMacAddress()) != 6 {
					return ManagedGatewayValidationError{
						field:  "ethernet_mac_address",
						reason: "value length must be 6 bytes",
					}
				}

			}

		case "wifi_profile_id":

			if m.GetWifiProfileId() != "" {

				if err := m._validateUuid(m.GetWifiProfileId()); err != nil {
					return ManagedGatewayValidationError{
						field:  "wifi_profile_id",
						reason: "value must be a valid UUID",
						cause:  err,
					}
				}

			}

		case "ethernet_profile_id":

			if m.GetEthernetProfileId() != "" {

				if err := m._validateUuid(m.GetEthernetProfileId()); err != nil {
					return ManagedGatewayValidationError{
						field:  "ethernet_profile_id",
						reason: "value must be a valid UUID",
						cause:  err,
					}
				}

			}

		default:
			return ManagedGatewayValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

func (m *ManagedGateway) _validateUuid(uuid string) error {
	if matched := _gateway_uuidPattern.MatchString(uuid); !matched {
		return errors.New("invalid uuid format")
	}

	return nil
}

// ManagedGatewayValidationError is the validation error returned by
// ManagedGateway.ValidateFields if the designated constraints aren't met.
type ManagedGatewayValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayValidationError) ErrorName() string { return "ManagedGatewayValidationError" }

// Error satisfies the builtin error interface
func (e ManagedGatewayValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGateway.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayValidationError{}

var _ManagedGateway_CellularImei_Pattern = regexp.MustCompile("^[0-9]{15}$")

var _ManagedGateway_CellularImsi_Pattern = regexp.MustCompile("^[0-9]{15}$")

// ValidateFields checks the field values on ManagedGatewayWiFiAccessPoint with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ManagedGatewayWiFiAccessPoint) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayWiFiAccessPointFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ssid":

			if utf8.RuneCountInString(m.GetSsid()) > 32 {
				return ManagedGatewayWiFiAccessPointValidationError{
					field:  "ssid",
					reason: "value length must be at most 32 runes",
				}
			}

		case "bssid":

			if len(m.GetBssid()) != 6 {
				return ManagedGatewayWiFiAccessPointValidationError{
					field:  "bssid",
					reason: "value length must be 6 bytes",
				}
			}

		case "channel":

			if m.GetChannel() < 1 {
				return ManagedGatewayWiFiAccessPointValidationError{
					field:  "channel",
					reason: "value must be greater than or equal to 1",
				}
			}

		case "authentication_mode":
			// no validation rules for AuthenticationMode
		case "rssi":
			// no validation rules for Rssi
		default:
			return ManagedGatewayWiFiAccessPointValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ManagedGatewayWiFiAccessPointValidationError is the validation error
// returned by ManagedGatewayWiFiAccessPoint.ValidateFields if the designated
// constraints aren't met.
type ManagedGatewayWiFiAccessPointValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayWiFiAccessPointValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayWiFiAccessPointValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayWiFiAccessPointValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayWiFiAccessPointValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayWiFiAccessPointValidationError) ErrorName() string {
	return "ManagedGatewayWiFiAccessPointValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewayWiFiAccessPointValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewayWiFiAccessPoint.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayWiFiAccessPointValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayWiFiAccessPointValidationError{}

// ValidateFields checks the field values on ManagedGatewayWiFiAccessPoints
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ManagedGatewayWiFiAccessPoints) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayWiFiAccessPointsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "access_points":

			for idx, item := range m.GetAccessPoints() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ManagedGatewayWiFiAccessPointsValidationError{
							field:  fmt.Sprintf("access_points[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ManagedGatewayWiFiAccessPointsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ManagedGatewayWiFiAccessPointsValidationError is the validation error
// returned by ManagedGatewayWiFiAccessPoints.ValidateFields if the designated
// constraints aren't met.
type ManagedGatewayWiFiAccessPointsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayWiFiAccessPointsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayWiFiAccessPointsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayWiFiAccessPointsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayWiFiAccessPointsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayWiFiAccessPointsValidationError) ErrorName() string {
	return "ManagedGatewayWiFiAccessPointsValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewayWiFiAccessPointsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewayWiFiAccessPoints.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayWiFiAccessPointsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayWiFiAccessPointsValidationError{}

// ValidateFields checks the field values on
// ManagedGatewayNetworkInterfaceAddresses with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *ManagedGatewayNetworkInterfaceAddresses) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayNetworkInterfaceAddressesFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ip_addresses":

			if len(m.GetIpAddresses()) > 2 {
				return ManagedGatewayNetworkInterfaceAddressesValidationError{
					field:  "ip_addresses",
					reason: "value must contain no more than 2 item(s)",
				}
			}

			for idx, item := range m.GetIpAddresses() {
				_, _ = idx, item

				if ip := net.ParseIP(item); ip == nil {
					return ManagedGatewayNetworkInterfaceAddressesValidationError{
						field:  fmt.Sprintf("ip_addresses[%v]", idx),
						reason: "value must be a valid IP address",
					}
				}

			}

		case "subnet_mask":

			if m.GetSubnetMask() != "" {

				if ip := net.ParseIP(m.GetSubnetMask()); ip == nil || ip.To4() == nil {
					return ManagedGatewayNetworkInterfaceAddressesValidationError{
						field:  "subnet_mask",
						reason: "value must be a valid IPv4 address",
					}
				}

			}

		case "gateway":

			if m.GetGateway() != "" {

				if ip := net.ParseIP(m.GetGateway()); ip == nil || ip.To4() == nil {
					return ManagedGatewayNetworkInterfaceAddressesValidationError{
						field:  "gateway",
						reason: "value must be a valid IPv4 address",
					}
				}

			}

		case "dns_servers":

			if len(m.GetDnsServers()) > 2 {
				return ManagedGatewayNetworkInterfaceAddressesValidationError{
					field:  "dns_servers",
					reason: "value must contain no more than 2 item(s)",
				}
			}

			for idx, item := range m.GetDnsServers() {
				_, _ = idx, item

				if ip := net.ParseIP(item); ip == nil || ip.To4() == nil {
					return ManagedGatewayNetworkInterfaceAddressesValidationError{
						field:  fmt.Sprintf("dns_servers[%v]", idx),
						reason: "value must be a valid IPv4 address",
					}
				}

			}

		default:
			return ManagedGatewayNetworkInterfaceAddressesValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ManagedGatewayNetworkInterfaceAddressesValidationError is the validation
// error returned by ManagedGatewayNetworkInterfaceAddresses.ValidateFields if
// the designated constraints aren't met.
type ManagedGatewayNetworkInterfaceAddressesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayNetworkInterfaceAddressesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayNetworkInterfaceAddressesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayNetworkInterfaceAddressesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayNetworkInterfaceAddressesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayNetworkInterfaceAddressesValidationError) ErrorName() string {
	return "ManagedGatewayNetworkInterfaceAddressesValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewayNetworkInterfaceAddressesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewayNetworkInterfaceAddresses.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayNetworkInterfaceAddressesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayNetworkInterfaceAddressesValidationError{}

// ValidateFields checks the field values on ManagedGatewaySystemStatus with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ManagedGatewaySystemStatus) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewaySystemStatusFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "cpu_temperature":

			if v, ok := interface{}(m.GetCpuTemperature()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ManagedGatewaySystemStatusValidationError{
						field:  "cpu_temperature",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ManagedGatewaySystemStatusValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ManagedGatewaySystemStatusValidationError is the validation error returned
// by ManagedGatewaySystemStatus.ValidateFields if the designated constraints
// aren't met.
type ManagedGatewaySystemStatusValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewaySystemStatusValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewaySystemStatusValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewaySystemStatusValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewaySystemStatusValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewaySystemStatusValidationError) ErrorName() string {
	return "ManagedGatewaySystemStatusValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewaySystemStatusValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewaySystemStatus.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewaySystemStatusValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewaySystemStatusValidationError{}

// ValidateFields checks the field values on ManagedGatewayControllerConnection
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ManagedGatewayControllerConnection) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayControllerConnectionFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "network_interface_type":

			if _, ok := ManagedGatewayNetworkInterfaceType_name[int32(m.GetNetworkInterfaceType())]; !ok {
				return ManagedGatewayControllerConnectionValidationError{
					field:  "network_interface_type",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return ManagedGatewayControllerConnectionValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ManagedGatewayControllerConnectionValidationError is the validation error
// returned by ManagedGatewayControllerConnection.ValidateFields if the
// designated constraints aren't met.
type ManagedGatewayControllerConnectionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayControllerConnectionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayControllerConnectionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayControllerConnectionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayControllerConnectionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayControllerConnectionValidationError) ErrorName() string {
	return "ManagedGatewayControllerConnectionValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewayControllerConnectionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewayControllerConnection.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayControllerConnectionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayControllerConnectionValidationError{}

// ValidateFields checks the field values on
// ManagedGatewayGatewayServerConnection with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *ManagedGatewayGatewayServerConnection) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayGatewayServerConnectionFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "network_interface_type":

			if _, ok := ManagedGatewayNetworkInterfaceType_name[int32(m.GetNetworkInterfaceType())]; !ok {
				return ManagedGatewayGatewayServerConnectionValidationError{
					field:  "network_interface_type",
					reason: "value must be one of the defined enum values",
				}
			}

		case "address":
			// no validation rules for Address
		default:
			return ManagedGatewayGatewayServerConnectionValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ManagedGatewayGatewayServerConnectionValidationError is the validation error
// returned by ManagedGatewayGatewayServerConnection.ValidateFields if the
// designated constraints aren't met.
type ManagedGatewayGatewayServerConnectionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayGatewayServerConnectionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayGatewayServerConnectionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayGatewayServerConnectionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayGatewayServerConnectionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayGatewayServerConnectionValidationError) ErrorName() string {
	return "ManagedGatewayGatewayServerConnectionValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewayGatewayServerConnectionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewayGatewayServerConnection.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayGatewayServerConnectionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayGatewayServerConnectionValidationError{}

// ValidateFields checks the field values on ManagedGatewayNetworkInterfaceInfo
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ManagedGatewayNetworkInterfaceInfo) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayNetworkInterfaceInfoFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "status":

			if _, ok := ManagedGatewayNetworkInterfaceStatus_name[int32(m.GetStatus())]; !ok {
				return ManagedGatewayNetworkInterfaceInfoValidationError{
					field:  "status",
					reason: "value must be one of the defined enum values",
				}
			}

		case "dhcp_enabled":
			// no validation rules for DhcpEnabled
		case "addresses":

			if v, ok := interface{}(m.GetAddresses()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ManagedGatewayNetworkInterfaceInfoValidationError{
						field:  "addresses",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ManagedGatewayNetworkInterfaceInfoValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ManagedGatewayNetworkInterfaceInfoValidationError is the validation error
// returned by ManagedGatewayNetworkInterfaceInfo.ValidateFields if the
// designated constraints aren't met.
type ManagedGatewayNetworkInterfaceInfoValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayNetworkInterfaceInfoValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayNetworkInterfaceInfoValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayNetworkInterfaceInfoValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayNetworkInterfaceInfoValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayNetworkInterfaceInfoValidationError) ErrorName() string {
	return "ManagedGatewayNetworkInterfaceInfoValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewayNetworkInterfaceInfoValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewayNetworkInterfaceInfo.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayNetworkInterfaceInfoValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayNetworkInterfaceInfoValidationError{}

// ValidateFields checks the field values on ManagedGatewayCellularBackhaul
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ManagedGatewayCellularBackhaul) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayCellularBackhaulFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "network_interface":

			if v, ok := interface{}(m.GetNetworkInterface()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ManagedGatewayCellularBackhaulValidationError{
						field:  "network_interface",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "operator":

			if utf8.RuneCountInString(m.GetOperator()) > 32 {
				return ManagedGatewayCellularBackhaulValidationError{
					field:  "operator",
					reason: "value length must be at most 32 runes",
				}
			}

		case "rssi":

			if v, ok := interface{}(m.GetRssi()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ManagedGatewayCellularBackhaulValidationError{
						field:  "rssi",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ManagedGatewayCellularBackhaulValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ManagedGatewayCellularBackhaulValidationError is the validation error
// returned by ManagedGatewayCellularBackhaul.ValidateFields if the designated
// constraints aren't met.
type ManagedGatewayCellularBackhaulValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayCellularBackhaulValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayCellularBackhaulValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayCellularBackhaulValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayCellularBackhaulValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayCellularBackhaulValidationError) ErrorName() string {
	return "ManagedGatewayCellularBackhaulValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewayCellularBackhaulValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewayCellularBackhaul.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayCellularBackhaulValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayCellularBackhaulValidationError{}

// ValidateFields checks the field values on ManagedGatewayWiFiBackhaul with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ManagedGatewayWiFiBackhaul) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayWiFiBackhaulFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "network_interface":

			if v, ok := interface{}(m.GetNetworkInterface()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ManagedGatewayWiFiBackhaulValidationError{
						field:  "network_interface",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "ssid":

			if utf8.RuneCountInString(m.GetSsid()) > 32 {
				return ManagedGatewayWiFiBackhaulValidationError{
					field:  "ssid",
					reason: "value length must be at most 32 runes",
				}
			}

		case "bssid":

			if len(m.GetBssid()) != 6 {
				return ManagedGatewayWiFiBackhaulValidationError{
					field:  "bssid",
					reason: "value length must be 6 bytes",
				}
			}

		case "channel":

			if m.GetChannel() < 1 {
				return ManagedGatewayWiFiBackhaulValidationError{
					field:  "channel",
					reason: "value must be greater than or equal to 1",
				}
			}

		case "authentication_mode":
			// no validation rules for AuthenticationMode
		case "rssi":

			if v, ok := interface{}(m.GetRssi()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ManagedGatewayWiFiBackhaulValidationError{
						field:  "rssi",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ManagedGatewayWiFiBackhaulValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ManagedGatewayWiFiBackhaulValidationError is the validation error returned
// by ManagedGatewayWiFiBackhaul.ValidateFields if the designated constraints
// aren't met.
type ManagedGatewayWiFiBackhaulValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayWiFiBackhaulValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayWiFiBackhaulValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayWiFiBackhaulValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayWiFiBackhaulValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayWiFiBackhaulValidationError) ErrorName() string {
	return "ManagedGatewayWiFiBackhaulValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewayWiFiBackhaulValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewayWiFiBackhaul.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayWiFiBackhaulValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayWiFiBackhaulValidationError{}

// ValidateFields checks the field values on ManagedGatewayEthernetBackhaul
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ManagedGatewayEthernetBackhaul) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayEthernetBackhaulFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "network_interface":

			if v, ok := interface{}(m.GetNetworkInterface()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ManagedGatewayEthernetBackhaulValidationError{
						field:  "network_interface",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ManagedGatewayEthernetBackhaulValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ManagedGatewayEthernetBackhaulValidationError is the validation error
// returned by ManagedGatewayEthernetBackhaul.ValidateFields if the designated
// constraints aren't met.
type ManagedGatewayEthernetBackhaulValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayEthernetBackhaulValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayEthernetBackhaulValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayEthernetBackhaulValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayEthernetBackhaulValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayEthernetBackhaulValidationError) ErrorName() string {
	return "ManagedGatewayEthernetBackhaulValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewayEthernetBackhaulValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewayEthernetBackhaul.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayEthernetBackhaulValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayEthernetBackhaulValidationError{}

// ValidateFields checks the field values on ManagedGatewayEventData with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ManagedGatewayEventData) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayEventDataFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "data":
			if len(subs) == 0 {
				subs = []string{
					"entity", "location", "system_status", "controller_connection", "gateway_server_connection", "cellular_backhaul", "wifi_backhaul", "ethernet_backhaul",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "entity":
					w, ok := m.Data.(*ManagedGatewayEventData_Entity)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetEntity()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ManagedGatewayEventDataValidationError{
								field:  "entity",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "location":
					w, ok := m.Data.(*ManagedGatewayEventData_Location)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetLocation()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ManagedGatewayEventDataValidationError{
								field:  "location",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "system_status":
					w, ok := m.Data.(*ManagedGatewayEventData_SystemStatus)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetSystemStatus()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ManagedGatewayEventDataValidationError{
								field:  "system_status",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "controller_connection":
					w, ok := m.Data.(*ManagedGatewayEventData_ControllerConnection)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetControllerConnection()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ManagedGatewayEventDataValidationError{
								field:  "controller_connection",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "gateway_server_connection":
					w, ok := m.Data.(*ManagedGatewayEventData_GatewayServerConnection)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetGatewayServerConnection()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ManagedGatewayEventDataValidationError{
								field:  "gateway_server_connection",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "cellular_backhaul":
					w, ok := m.Data.(*ManagedGatewayEventData_CellularBackhaul)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetCellularBackhaul()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ManagedGatewayEventDataValidationError{
								field:  "cellular_backhaul",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "wifi_backhaul":
					w, ok := m.Data.(*ManagedGatewayEventData_WifiBackhaul)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetWifiBackhaul()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ManagedGatewayEventDataValidationError{
								field:  "wifi_backhaul",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "ethernet_backhaul":
					w, ok := m.Data.(*ManagedGatewayEventData_EthernetBackhaul)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetEthernetBackhaul()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ManagedGatewayEventDataValidationError{
								field:  "ethernet_backhaul",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return ManagedGatewayEventDataValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ManagedGatewayEventDataValidationError is the validation error returned by
// ManagedGatewayEventData.ValidateFields if the designated constraints aren't met.
type ManagedGatewayEventDataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayEventDataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayEventDataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayEventDataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayEventDataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayEventDataValidationError) ErrorName() string {
	return "ManagedGatewayEventDataValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewayEventDataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewayEventData.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayEventDataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayEventDataValidationError{}

// ValidateFields checks the field values on ManagedGatewayWiFiProfile with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ManagedGatewayWiFiProfile) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayWiFiProfileFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "profile_id":

			if m.GetProfileId() != "" {

				if err := m._validateUuid(m.GetProfileId()); err != nil {
					return ManagedGatewayWiFiProfileValidationError{
						field:  "profile_id",
						reason: "value must be a valid UUID",
						cause:  err,
					}
				}

			}

		case "profile_name":

			if utf8.RuneCountInString(m.GetProfileName()) > 32 {
				return ManagedGatewayWiFiProfileValidationError{
					field:  "profile_name",
					reason: "value length must be at most 32 runes",
				}
			}

		case "shared":
			// no validation rules for Shared
		case "ssid":

			if utf8.RuneCountInString(m.GetSsid()) > 32 {
				return ManagedGatewayWiFiProfileValidationError{
					field:  "ssid",
					reason: "value length must be at most 32 runes",
				}
			}

		case "password":

			if utf8.RuneCountInString(m.GetPassword()) > 64 {
				return ManagedGatewayWiFiProfileValidationError{
					field:  "password",
					reason: "value length must be at most 64 runes",
				}
			}

		case "network_interface_addresses":

			if v, ok := interface{}(m.GetNetworkInterfaceAddresses()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ManagedGatewayWiFiProfileValidationError{
						field:  "network_interface_addresses",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ManagedGatewayWiFiProfileValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

func (m *ManagedGatewayWiFiProfile) _validateUuid(uuid string) error {
	if matched := _gateway_uuidPattern.MatchString(uuid); !matched {
		return errors.New("invalid uuid format")
	}

	return nil
}

// ManagedGatewayWiFiProfileValidationError is the validation error returned by
// ManagedGatewayWiFiProfile.ValidateFields if the designated constraints
// aren't met.
type ManagedGatewayWiFiProfileValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayWiFiProfileValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayWiFiProfileValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayWiFiProfileValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayWiFiProfileValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayWiFiProfileValidationError) ErrorName() string {
	return "ManagedGatewayWiFiProfileValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewayWiFiProfileValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewayWiFiProfile.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayWiFiProfileValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayWiFiProfileValidationError{}

// ValidateFields checks the field values on ManagedGatewayWiFiProfiles with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ManagedGatewayWiFiProfiles) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayWiFiProfilesFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "profiles":

			for idx, item := range m.GetProfiles() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ManagedGatewayWiFiProfilesValidationError{
							field:  fmt.Sprintf("profiles[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ManagedGatewayWiFiProfilesValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ManagedGatewayWiFiProfilesValidationError is the validation error returned
// by ManagedGatewayWiFiProfiles.ValidateFields if the designated constraints
// aren't met.
type ManagedGatewayWiFiProfilesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayWiFiProfilesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayWiFiProfilesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayWiFiProfilesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayWiFiProfilesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayWiFiProfilesValidationError) ErrorName() string {
	return "ManagedGatewayWiFiProfilesValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewayWiFiProfilesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewayWiFiProfiles.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayWiFiProfilesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayWiFiProfilesValidationError{}

// ValidateFields checks the field values on ManagedGatewayEthernetProfile with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ManagedGatewayEthernetProfile) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayEthernetProfileFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "profile_id":

			if m.GetProfileId() != "" {

				if err := m._validateUuid(m.GetProfileId()); err != nil {
					return ManagedGatewayEthernetProfileValidationError{
						field:  "profile_id",
						reason: "value must be a valid UUID",
						cause:  err,
					}
				}

			}

		case "profile_name":

			if utf8.RuneCountInString(m.GetProfileName()) > 32 {
				return ManagedGatewayEthernetProfileValidationError{
					field:  "profile_name",
					reason: "value length must be at most 32 runes",
				}
			}

		case "shared":
			// no validation rules for Shared
		case "network_interface_addresses":

			if v, ok := interface{}(m.GetNetworkInterfaceAddresses()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ManagedGatewayEthernetProfileValidationError{
						field:  "network_interface_addresses",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ManagedGatewayEthernetProfileValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

func (m *ManagedGatewayEthernetProfile) _validateUuid(uuid string) error {
	if matched := _gateway_uuidPattern.MatchString(uuid); !matched {
		return errors.New("invalid uuid format")
	}

	return nil
}

// ManagedGatewayEthernetProfileValidationError is the validation error
// returned by ManagedGatewayEthernetProfile.ValidateFields if the designated
// constraints aren't met.
type ManagedGatewayEthernetProfileValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayEthernetProfileValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayEthernetProfileValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayEthernetProfileValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayEthernetProfileValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayEthernetProfileValidationError) ErrorName() string {
	return "ManagedGatewayEthernetProfileValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewayEthernetProfileValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewayEthernetProfile.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayEthernetProfileValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayEthernetProfileValidationError{}

// ValidateFields checks the field values on ManagedGatewayEthernetProfiles
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ManagedGatewayEthernetProfiles) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ManagedGatewayEthernetProfilesFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "profiles":

			for idx, item := range m.GetProfiles() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ManagedGatewayEthernetProfilesValidationError{
							field:  fmt.Sprintf("profiles[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ManagedGatewayEthernetProfilesValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ManagedGatewayEthernetProfilesValidationError is the validation error
// returned by ManagedGatewayEthernetProfiles.ValidateFields if the designated
// constraints aren't met.
type ManagedGatewayEthernetProfilesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManagedGatewayEthernetProfilesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManagedGatewayEthernetProfilesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManagedGatewayEthernetProfilesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManagedGatewayEthernetProfilesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManagedGatewayEthernetProfilesValidationError) ErrorName() string {
	return "ManagedGatewayEthernetProfilesValidationError"
}

// Error satisfies the builtin error interface
func (e ManagedGatewayEthernetProfilesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManagedGatewayEthernetProfiles.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManagedGatewayEthernetProfilesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManagedGatewayEthernetProfilesValidationError{}

// ValidateFields checks the field values on GetGatewayRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetGatewayRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetGatewayRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return GetGatewayRequestValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetGatewayRequestValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetGatewayRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetGatewayRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetGatewayRequestValidationError is the validation error returned by
// GetGatewayRequest.ValidateFields if the designated constraints aren't met.
type GetGatewayRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetGatewayRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetGatewayRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetGatewayRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetGatewayRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetGatewayRequestValidationError) ErrorName() string {
	return "GetGatewayRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetGatewayRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetGatewayRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetGatewayRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetGatewayRequestValidationError{}

// ValidateFields checks the field values on GetGatewayIdentifiersForEUIRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *GetGatewayIdentifiersForEUIRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetGatewayIdentifiersForEUIRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "eui":

			if len(m.GetEui()) > 0 {

				if len(m.GetEui()) != 8 {
					return GetGatewayIdentifiersForEUIRequestValidationError{
						field:  "eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		default:
			return GetGatewayIdentifiersForEUIRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetGatewayIdentifiersForEUIRequestValidationError is the validation error
// returned by GetGatewayIdentifiersForEUIRequest.ValidateFields if the
// designated constraints aren't met.
type GetGatewayIdentifiersForEUIRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetGatewayIdentifiersForEUIRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetGatewayIdentifiersForEUIRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetGatewayIdentifiersForEUIRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetGatewayIdentifiersForEUIRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetGatewayIdentifiersForEUIRequestValidationError) ErrorName() string {
	return "GetGatewayIdentifiersForEUIRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetGatewayIdentifiersForEUIRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetGatewayIdentifiersForEUIRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetGatewayIdentifiersForEUIRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetGatewayIdentifiersForEUIRequestValidationError{}

// ValidateFields checks the field values on ListGatewaysRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ListGatewaysRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListGatewaysRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "collaborator":

			if v, ok := interface{}(m.GetCollaborator()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListGatewaysRequestValidationError{
						field:  "collaborator",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListGatewaysRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "order":

			if _, ok := _ListGatewaysRequest_Order_InLookup[m.GetOrder()]; !ok {
				return ListGatewaysRequestValidationError{
					field:  "order",
					reason: "value must be in list [ gateway_id -gateway_id gateway_eui -gateway_eui name -name created_at -created_at]",
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListGatewaysRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "deleted":
			// no validation rules for Deleted
		case "filters":

			for idx, item := range m.GetFilters() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ListGatewaysRequestValidationError{
							field:  fmt.Sprintf("filters[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ListGatewaysRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListGatewaysRequestValidationError is the validation error returned by
// ListGatewaysRequest.ValidateFields if the designated constraints aren't met.
type ListGatewaysRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListGatewaysRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListGatewaysRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListGatewaysRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListGatewaysRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListGatewaysRequestValidationError) ErrorName() string {
	return "ListGatewaysRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListGatewaysRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListGatewaysRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListGatewaysRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListGatewaysRequestValidationError{}

var _ListGatewaysRequest_Order_InLookup = map[string]struct{}{
	"":             {},
	"gateway_id":   {},
	"-gateway_id":  {},
	"gateway_eui":  {},
	"-gateway_eui": {},
	"name":         {},
	"-name":        {},
	"created_at":   {},
	"-created_at":  {},
}

// ValidateFields checks the field values on CreateGatewayRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *CreateGatewayRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CreateGatewayRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway":

			if m.GetGateway() == nil {
				return CreateGatewayRequestValidationError{
					field:  "gateway",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGateway()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateGatewayRequestValidationError{
						field:  "gateway",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "collaborator":

			if m.GetCollaborator() == nil {
				return CreateGatewayRequestValidationError{
					field:  "collaborator",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetCollaborator()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateGatewayRequestValidationError{
						field:  "collaborator",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return CreateGatewayRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CreateGatewayRequestValidationError is the validation error returned by
// CreateGatewayRequest.ValidateFields if the designated constraints aren't met.
type CreateGatewayRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateGatewayRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateGatewayRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateGatewayRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateGatewayRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateGatewayRequestValidationError) ErrorName() string {
	return "CreateGatewayRequestValidationError"
}

// Error satisfies the builtin error interface
func (e CreateGatewayRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateGatewayRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateGatewayRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateGatewayRequestValidationError{}

// ValidateFields checks the field values on UpdateGatewayRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UpdateGatewayRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UpdateGatewayRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway":

			if m.GetGateway() == nil {
				return UpdateGatewayRequestValidationError{
					field:  "gateway",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGateway()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateGatewayRequestValidationError{
						field:  "gateway",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateGatewayRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UpdateGatewayRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UpdateGatewayRequestValidationError is the validation error returned by
// UpdateGatewayRequest.ValidateFields if the designated constraints aren't met.
type UpdateGatewayRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpdateGatewayRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpdateGatewayRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpdateGatewayRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpdateGatewayRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpdateGatewayRequestValidationError) ErrorName() string {
	return "UpdateGatewayRequestValidationError"
}

// Error satisfies the builtin error interface
func (e UpdateGatewayRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpdateGatewayRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpdateGatewayRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpdateGatewayRequestValidationError{}

// ValidateFields checks the field values on ListGatewayAPIKeysRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ListGatewayAPIKeysRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListGatewayAPIKeysRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return ListGatewayAPIKeysRequestValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListGatewayAPIKeysRequestValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "order":

			if _, ok := _ListGatewayAPIKeysRequest_Order_InLookup[m.GetOrder()]; !ok {
				return ListGatewayAPIKeysRequestValidationError{
					field:  "order",
					reason: "value must be in list [ api_key_id -api_key_id name -name created_at -created_at expires_at -expires_at]",
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListGatewayAPIKeysRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		default:
			return ListGatewayAPIKeysRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListGatewayAPIKeysRequestValidationError is the validation error returned by
// ListGatewayAPIKeysRequest.ValidateFields if the designated constraints
// aren't met.
type ListGatewayAPIKeysRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListGatewayAPIKeysRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListGatewayAPIKeysRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListGatewayAPIKeysRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListGatewayAPIKeysRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListGatewayAPIKeysRequestValidationError) ErrorName() string {
	return "ListGatewayAPIKeysRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListGatewayAPIKeysRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListGatewayAPIKeysRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListGatewayAPIKeysRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListGatewayAPIKeysRequestValidationError{}

var _ListGatewayAPIKeysRequest_Order_InLookup = map[string]struct{}{
	"":            {},
	"api_key_id":  {},
	"-api_key_id": {},
	"name":        {},
	"-name":       {},
	"created_at":  {},
	"-created_at": {},
	"expires_at":  {},
	"-expires_at": {},
}

// ValidateFields checks the field values on GetGatewayAPIKeyRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetGatewayAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetGatewayAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return GetGatewayAPIKeyRequestValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetGatewayAPIKeyRequestValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "key_id":
			// no validation rules for KeyId
		default:
			return GetGatewayAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetGatewayAPIKeyRequestValidationError is the validation error returned by
// GetGatewayAPIKeyRequest.ValidateFields if the designated constraints aren't met.
type GetGatewayAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetGatewayAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetGatewayAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetGatewayAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetGatewayAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetGatewayAPIKeyRequestValidationError) ErrorName() string {
	return "GetGatewayAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetGatewayAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetGatewayAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetGatewayAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetGatewayAPIKeyRequestValidationError{}

// ValidateFields checks the field values on CreateGatewayAPIKeyRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *CreateGatewayAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CreateGatewayAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return CreateGatewayAPIKeyRequestValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateGatewayAPIKeyRequestValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "name":

			if utf8.RuneCountInString(m.GetName()) > 50 {
				return CreateGatewayAPIKeyRequestValidationError{
					field:  "name",
					reason: "value length must be at most 50 runes",
				}
			}

		case "rights":

			if len(m.GetRights()) < 1 {
				return CreateGatewayAPIKeyRequestValidationError{
					field:  "rights",
					reason: "value must contain at least 1 item(s)",
				}
			}

			_CreateGatewayAPIKeyRequest_Rights_Unique := make(map[Right]struct{}, len(m.GetRights()))

			for idx, item := range m.GetRights() {
				_, _ = idx, item

				if _, exists := _CreateGatewayAPIKeyRequest_Rights_Unique[item]; exists {
					return CreateGatewayAPIKeyRequestValidationError{
						field:  fmt.Sprintf("rights[%v]", idx),
						reason: "repeated value must contain unique items",
					}
				} else {
					_CreateGatewayAPIKeyRequest_Rights_Unique[item] = struct{}{}
				}

				if _, ok := Right_name[int32(item)]; !ok {
					return CreateGatewayAPIKeyRequestValidationError{
						field:  fmt.Sprintf("rights[%v]", idx),
						reason: "value must be one of the defined enum values",
					}
				}

			}

		case "expires_at":

			if t := m.GetExpiresAt(); t != nil {
				ts, err := t.AsTime(), t.CheckValid()
				if err != nil {
					return CreateGatewayAPIKeyRequestValidationError{
						field:  "expires_at",
						reason: "value is not a valid timestamp",
						cause:  err,
					}
				}

				now := time.Now()

				if ts.Sub(now) <= 0 {
					return CreateGatewayAPIKeyRequestValidationError{
						field:  "expires_at",
						reason: "value must be greater than now",
					}
				}

			}

		default:
			return CreateGatewayAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CreateGatewayAPIKeyRequestValidationError is the validation error returned
// by CreateGatewayAPIKeyRequest.ValidateFields if the designated constraints
// aren't met.
type CreateGatewayAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateGatewayAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateGatewayAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateGatewayAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateGatewayAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateGatewayAPIKeyRequestValidationError) ErrorName() string {
	return "CreateGatewayAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e CreateGatewayAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateGatewayAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateGatewayAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateGatewayAPIKeyRequestValidationError{}

// ValidateFields checks the field values on UpdateGatewayAPIKeyRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *UpdateGatewayAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UpdateGatewayAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return UpdateGatewayAPIKeyRequestValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateGatewayAPIKeyRequestValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "api_key":

			if m.GetApiKey() == nil {
				return UpdateGatewayAPIKeyRequestValidationError{
					field:  "api_key",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApiKey()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateGatewayAPIKeyRequestValidationError{
						field:  "api_key",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateGatewayAPIKeyRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UpdateGatewayAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UpdateGatewayAPIKeyRequestValidationError is the validation error returned
// by UpdateGatewayAPIKeyRequest.ValidateFields if the designated constraints
// aren't met.
type UpdateGatewayAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpdateGatewayAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpdateGatewayAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpdateGatewayAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpdateGatewayAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpdateGatewayAPIKeyRequestValidationError) ErrorName() string {
	return "UpdateGatewayAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e UpdateGatewayAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpdateGatewayAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpdateGatewayAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpdateGatewayAPIKeyRequestValidationError{}

// ValidateFields checks the field values on DeleteGatewayAPIKeyRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *DeleteGatewayAPIKeyRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DeleteGatewayAPIKeyRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return DeleteGatewayAPIKeyRequestValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DeleteGatewayAPIKeyRequestValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "key_id":
			// no validation rules for KeyId
		default:
			return DeleteGatewayAPIKeyRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DeleteGatewayAPIKeyRequestValidationError is the validation error returned
// by DeleteGatewayAPIKeyRequest.ValidateFields if the designated constraints
// aren't met.
type DeleteGatewayAPIKeyRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DeleteGatewayAPIKeyRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DeleteGatewayAPIKeyRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DeleteGatewayAPIKeyRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DeleteGatewayAPIKeyRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DeleteGatewayAPIKeyRequestValidationError) ErrorName() string {
	return "DeleteGatewayAPIKeyRequestValidationError"
}

// Error satisfies the builtin error interface
func (e DeleteGatewayAPIKeyRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDeleteGatewayAPIKeyRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DeleteGatewayAPIKeyRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DeleteGatewayAPIKeyRequestValidationError{}

// ValidateFields checks the field values on ListGatewayCollaboratorsRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ListGatewayCollaboratorsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListGatewayCollaboratorsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return ListGatewayCollaboratorsRequestValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListGatewayCollaboratorsRequestValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListGatewayCollaboratorsRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "order":

			if _, ok := _ListGatewayCollaboratorsRequest_Order_InLookup[m.GetOrder()]; !ok {
				return ListGatewayCollaboratorsRequestValidationError{
					field:  "order",
					reason: "value must be in list [ id -id -rights rights]",
				}
			}

		default:
			return ListGatewayCollaboratorsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListGatewayCollaboratorsRequestValidationError is the validation error
// returned by ListGatewayCollaboratorsRequest.ValidateFields if the
// designated constraints aren't met.
type ListGatewayCollaboratorsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListGatewayCollaboratorsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListGatewayCollaboratorsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListGatewayCollaboratorsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListGatewayCollaboratorsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListGatewayCollaboratorsRequestValidationError) ErrorName() string {
	return "ListGatewayCollaboratorsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListGatewayCollaboratorsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListGatewayCollaboratorsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListGatewayCollaboratorsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListGatewayCollaboratorsRequestValidationError{}

var _ListGatewayCollaboratorsRequest_Order_InLookup = map[string]struct{}{
	"":        {},
	"id":      {},
	"-id":     {},
	"-rights": {},
	"rights":  {},
}

// ValidateFields checks the field values on GetGatewayCollaboratorRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *GetGatewayCollaboratorRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetGatewayCollaboratorRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return GetGatewayCollaboratorRequestValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetGatewayCollaboratorRequestValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "collaborator":

			if m.GetCollaborator() == nil {
				return GetGatewayCollaboratorRequestValidationError{
					field:  "collaborator",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetCollaborator()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetGatewayCollaboratorRequestValidationError{
						field:  "collaborator",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetGatewayCollaboratorRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetGatewayCollaboratorRequestValidationError is the validation error
// returned by GetGatewayCollaboratorRequest.ValidateFields if the designated
// constraints aren't met.
type GetGatewayCollaboratorRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetGatewayCollaboratorRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetGatewayCollaboratorRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetGatewayCollaboratorRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetGatewayCollaboratorRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetGatewayCollaboratorRequestValidationError) ErrorName() string {
	return "GetGatewayCollaboratorRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetGatewayCollaboratorRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetGatewayCollaboratorRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetGatewayCollaboratorRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetGatewayCollaboratorRequestValidationError{}

// ValidateFields checks the field values on SetGatewayCollaboratorRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *SetGatewayCollaboratorRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SetGatewayCollaboratorRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return SetGatewayCollaboratorRequestValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetGatewayCollaboratorRequestValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "collaborator":

			if m.GetCollaborator() == nil {
				return SetGatewayCollaboratorRequestValidationError{
					field:  "collaborator",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetCollaborator()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetGatewayCollaboratorRequestValidationError{
						field:  "collaborator",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return SetGatewayCollaboratorRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// SetGatewayCollaboratorRequestValidationError is the validation error
// returned by SetGatewayCollaboratorRequest.ValidateFields if the designated
// constraints aren't met.
type SetGatewayCollaboratorRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SetGatewayCollaboratorRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SetGatewayCollaboratorRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SetGatewayCollaboratorRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SetGatewayCollaboratorRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SetGatewayCollaboratorRequestValidationError) ErrorName() string {
	return "SetGatewayCollaboratorRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SetGatewayCollaboratorRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSetGatewayCollaboratorRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SetGatewayCollaboratorRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SetGatewayCollaboratorRequestValidationError{}

// ValidateFields checks the field values on DeleteGatewayCollaboratorRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *DeleteGatewayCollaboratorRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DeleteGatewayCollaboratorRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return DeleteGatewayCollaboratorRequestValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DeleteGatewayCollaboratorRequestValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "collaborator_ids":

			if m.GetCollaboratorIds() == nil {
				return DeleteGatewayCollaboratorRequestValidationError{
					field:  "collaborator_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetCollaboratorIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DeleteGatewayCollaboratorRequestValidationError{
						field:  "collaborator_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return DeleteGatewayCollaboratorRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DeleteGatewayCollaboratorRequestValidationError is the validation error
// returned by DeleteGatewayCollaboratorRequest.ValidateFields if the
// designated constraints aren't met.
type DeleteGatewayCollaboratorRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DeleteGatewayCollaboratorRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DeleteGatewayCollaboratorRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DeleteGatewayCollaboratorRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DeleteGatewayCollaboratorRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DeleteGatewayCollaboratorRequestValidationError) ErrorName() string {
	return "DeleteGatewayCollaboratorRequestValidationError"
}

// Error satisfies the builtin error interface
func (e DeleteGatewayCollaboratorRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDeleteGatewayCollaboratorRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DeleteGatewayCollaboratorRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DeleteGatewayCollaboratorRequestValidationError{}

// ValidateFields checks the field values on GatewayAntenna with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GatewayAntenna) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayAntennaFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gain":
			// no validation rules for Gain
		case "location":

			if v, ok := interface{}(m.GetLocation()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayAntennaValidationError{
						field:  "location",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "attributes":

			if len(m.GetAttributes()) > 10 {
				return GatewayAntennaValidationError{
					field:  "attributes",
					reason: "value must contain no more than 10 pair(s)",
				}
			}

			for key, val := range m.GetAttributes() {
				_ = val

				if utf8.RuneCountInString(key) > 36 {
					return GatewayAntennaValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value length must be at most 36 runes",
					}
				}

				if !_GatewayAntenna_Attributes_Pattern.MatchString(key) {
					return GatewayAntennaValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

				if utf8.RuneCountInString(val) > 200 {
					return GatewayAntennaValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value length must be at most 200 runes",
					}
				}

			}

		case "placement":
			// no validation rules for Placement
		default:
			return GatewayAntennaValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayAntennaValidationError is the validation error returned by
// GatewayAntenna.ValidateFields if the designated constraints aren't met.
type GatewayAntennaValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayAntennaValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayAntennaValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayAntennaValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayAntennaValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayAntennaValidationError) ErrorName() string { return "GatewayAntennaValidationError" }

// Error satisfies the builtin error interface
func (e GatewayAntennaValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayAntenna.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayAntennaValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayAntennaValidationError{}

var _GatewayAntenna_Attributes_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on GatewayStatus with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GatewayStatus) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayStatusFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "time":

			if v, ok := interface{}(m.GetTime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayStatusValidationError{
						field:  "time",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "boot_time":

			if v, ok := interface{}(m.GetBootTime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayStatusValidationError{
						field:  "boot_time",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "versions":

			if len(m.GetVersions()) > 10 {
				return GatewayStatusValidationError{
					field:  "versions",
					reason: "value must contain no more than 10 pair(s)",
				}
			}

			for key, val := range m.GetVersions() {
				_ = val

				if utf8.RuneCountInString(key) > 36 {
					return GatewayStatusValidationError{
						field:  fmt.Sprintf("versions[%v]", key),
						reason: "value length must be at most 36 runes",
					}
				}

				if !_GatewayStatus_Versions_Pattern.MatchString(key) {
					return GatewayStatusValidationError{
						field:  fmt.Sprintf("versions[%v]", key),
						reason: "value does not match regex pattern \"^[a-z0-9](?:[_-]?[a-z0-9]){2,}$\"",
					}
				}

				if utf8.RuneCountInString(val) > 128 {
					return GatewayStatusValidationError{
						field:  fmt.Sprintf("versions[%v]", key),
						reason: "value length must be at most 128 runes",
					}
				}

			}

		case "antenna_locations":

			if len(m.GetAntennaLocations()) > 8 {
				return GatewayStatusValidationError{
					field:  "antenna_locations",
					reason: "value must contain no more than 8 item(s)",
				}
			}

			for idx, item := range m.GetAntennaLocations() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return GatewayStatusValidationError{
							field:  fmt.Sprintf("antenna_locations[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "ip":

			if len(m.GetIp()) > 10 {
				return GatewayStatusValidationError{
					field:  "ip",
					reason: "value must contain no more than 10 item(s)",
				}
			}

			for idx, item := range m.GetIp() {
				_, _ = idx, item

				if ip := net.ParseIP(item); ip == nil {
					return GatewayStatusValidationError{
						field:  fmt.Sprintf("ip[%v]", idx),
						reason: "value must be a valid IP address",
					}
				}

			}

		case "metrics":

			if len(m.GetMetrics()) > 32 {
				return GatewayStatusValidationError{
					field:  "metrics",
					reason: "value must contain no more than 32 pair(s)",
				}
			}

			for key, val := range m.GetMetrics() {
				_ = val

				if utf8.RuneCountInString(key) > 36 {
					return GatewayStatusValidationError{
						field:  fmt.Sprintf("metrics[%v]", key),
						reason: "value length must be at most 36 runes",
					}
				}

				if !_GatewayStatus_Metrics_Pattern.MatchString(key) {
					return GatewayStatusValidationError{
						field:  fmt.Sprintf("metrics[%v]", key),
						reason: "value does not match regex pattern \"^[a-z0-9](?:[_-]?[a-z0-9]){2,}$\"",
					}
				}

				// no validation rules for Metrics[key]
			}

		case "advanced":

			if v, ok := interface{}(m.GetAdvanced()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayStatusValidationError{
						field:  "advanced",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GatewayStatusValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayStatusValidationError is the validation error returned by
// GatewayStatus.ValidateFields if the designated constraints aren't met.
type GatewayStatusValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayStatusValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayStatusValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayStatusValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayStatusValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayStatusValidationError) ErrorName() string { return "GatewayStatusValidationError" }

// Error satisfies the builtin error interface
func (e GatewayStatusValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayStatus.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayStatusValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayStatusValidationError{}

var _GatewayStatus_Versions_Pattern = regexp.MustCompile("^[a-z0-9](?:[_-]?[a-z0-9]){2,}$")

var _GatewayStatus_Metrics_Pattern = regexp.MustCompile("^[a-z0-9](?:[_-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on GatewayRemoteAddress with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GatewayRemoteAddress) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayRemoteAddressFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ip":
			// no validation rules for Ip
		default:
			return GatewayRemoteAddressValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayRemoteAddressValidationError is the validation error returned by
// GatewayRemoteAddress.ValidateFields if the designated constraints aren't met.
type GatewayRemoteAddressValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayRemoteAddressValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayRemoteAddressValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayRemoteAddressValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayRemoteAddressValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayRemoteAddressValidationError) ErrorName() string {
	return "GatewayRemoteAddressValidationError"
}

// Error satisfies the builtin error interface
func (e GatewayRemoteAddressValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayRemoteAddress.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayRemoteAddressValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayRemoteAddressValidationError{}

// ValidateFields checks the field values on GatewayConnectionStats with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GatewayConnectionStats) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayConnectionStatsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "connected_at":

			if v, ok := interface{}(m.GetConnectedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayConnectionStatsValidationError{
						field:  "connected_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "disconnected_at":

			if v, ok := interface{}(m.GetDisconnectedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayConnectionStatsValidationError{
						field:  "disconnected_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "protocol":
			// no validation rules for Protocol
		case "last_status_received_at":

			if v, ok := interface{}(m.GetLastStatusReceivedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayConnectionStatsValidationError{
						field:  "last_status_received_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "last_status":

			if v, ok := interface{}(m.GetLastStatus()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayConnectionStatsValidationError{
						field:  "last_status",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "last_uplink_received_at":

			if v, ok := interface{}(m.GetLastUplinkReceivedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayConnectionStatsValidationError{
						field:  "last_uplink_received_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "uplink_count":
			// no validation rules for UplinkCount
		case "last_downlink_received_at":

			if v, ok := interface{}(m.GetLastDownlinkReceivedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayConnectionStatsValidationError{
						field:  "last_downlink_received_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_count":
			// no validation rules for DownlinkCount
		case "last_tx_acknowledgment_received_at":

			if v, ok := interface{}(m.GetLastTxAcknowledgmentReceivedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayConnectionStatsValidationError{
						field:  "last_tx_acknowledgment_received_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "tx_acknowledgment_count":
			// no validation rules for TxAcknowledgmentCount
		case "round_trip_times":

			if v, ok := interface{}(m.GetRoundTripTimes()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayConnectionStatsValidationError{
						field:  "round_trip_times",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "sub_bands":

			for idx, item := range m.GetSubBands() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return GatewayConnectionStatsValidationError{
							field:  fmt.Sprintf("sub_bands[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "gateway_remote_address":

			if v, ok := interface{}(m.GetGatewayRemoteAddress()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GatewayConnectionStatsValidationError{
						field:  "gateway_remote_address",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GatewayConnectionStatsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayConnectionStatsValidationError is the validation error returned by
// GatewayConnectionStats.ValidateFields if the designated constraints aren't met.
type GatewayConnectionStatsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayConnectionStatsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayConnectionStatsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayConnectionStatsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayConnectionStatsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayConnectionStatsValidationError) ErrorName() string {
	return "GatewayConnectionStatsValidationError"
}

// Error satisfies the builtin error interface
func (e GatewayConnectionStatsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayConnectionStats.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayConnectionStatsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayConnectionStatsValidationError{}

// ValidateFields checks the field values on GatewayRadio_TxConfiguration with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *GatewayRadio_TxConfiguration) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayRadio_TxConfigurationFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "min_frequency":
			// no validation rules for MinFrequency
		case "max_frequency":
			// no validation rules for MaxFrequency
		case "notch_frequency":
			// no validation rules for NotchFrequency
		default:
			return GatewayRadio_TxConfigurationValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayRadio_TxConfigurationValidationError is the validation error returned
// by GatewayRadio_TxConfiguration.ValidateFields if the designated
// constraints aren't met.
type GatewayRadio_TxConfigurationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayRadio_TxConfigurationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayRadio_TxConfigurationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayRadio_TxConfigurationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayRadio_TxConfigurationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayRadio_TxConfigurationValidationError) ErrorName() string {
	return "GatewayRadio_TxConfigurationValidationError"
}

// Error satisfies the builtin error interface
func (e GatewayRadio_TxConfigurationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayRadio_TxConfiguration.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayRadio_TxConfigurationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayRadio_TxConfigurationValidationError{}

// ValidateFields checks the field values on Gateway_LRFHSS with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *Gateway_LRFHSS) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = Gateway_LRFHSSFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "supported":
			// no validation rules for Supported
		default:
			return Gateway_LRFHSSValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// Gateway_LRFHSSValidationError is the validation error returned by
// Gateway_LRFHSS.ValidateFields if the designated constraints aren't met.
type Gateway_LRFHSSValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Gateway_LRFHSSValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Gateway_LRFHSSValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Gateway_LRFHSSValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Gateway_LRFHSSValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Gateway_LRFHSSValidationError) ErrorName() string { return "Gateway_LRFHSSValidationError" }

// Error satisfies the builtin error interface
func (e Gateway_LRFHSSValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGateway_LRFHSS.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Gateway_LRFHSSValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Gateway_LRFHSSValidationError{}

// ValidateFields checks the field values on ListGatewaysRequest_Filter with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ListGatewaysRequest_Filter) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListGatewaysRequest_FilterFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "field":
			if len(subs) == 0 {
				subs = []string{
					"updated_since",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "updated_since":
					w, ok := m.Field.(*ListGatewaysRequest_Filter_UpdatedSince)
					if !ok || w == nil {
						continue
					}

					if t := m.GetUpdatedSince(); t != nil {
						ts, err := t.AsTime(), t.CheckValid()
						if err != nil {
							return ListGatewaysRequest_FilterValidationError{
								field:  "updated_since",
								reason: "value is not a valid timestamp",
								cause:  err,
							}
						}

						now := time.Now()

						if ts.Sub(now) >= 0 {
							return ListGatewaysRequest_FilterValidationError{
								field:  "updated_since",
								reason: "value must be less than now",
							}
						}

					}

				}
			}
		default:
			return ListGatewaysRequest_FilterValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListGatewaysRequest_FilterValidationError is the validation error returned
// by ListGatewaysRequest_Filter.ValidateFields if the designated constraints
// aren't met.
type ListGatewaysRequest_FilterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListGatewaysRequest_FilterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListGatewaysRequest_FilterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListGatewaysRequest_FilterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListGatewaysRequest_FilterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListGatewaysRequest_FilterValidationError) ErrorName() string {
	return "ListGatewaysRequest_FilterValidationError"
}

// Error satisfies the builtin error interface
func (e ListGatewaysRequest_FilterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListGatewaysRequest_Filter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListGatewaysRequest_FilterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListGatewaysRequest_FilterValidationError{}

// ValidateFields checks the field values on
// GatewayConnectionStats_RoundTripTimes with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *GatewayConnectionStats_RoundTripTimes) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayConnectionStats_RoundTripTimesFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "min":

			if m.GetMin() == nil {
				return GatewayConnectionStats_RoundTripTimesValidationError{
					field:  "min",
					reason: "value is required",
				}
			}

		case "max":

			if m.GetMax() == nil {
				return GatewayConnectionStats_RoundTripTimesValidationError{
					field:  "max",
					reason: "value is required",
				}
			}

		case "median":

			if m.GetMedian() == nil {
				return GatewayConnectionStats_RoundTripTimesValidationError{
					field:  "median",
					reason: "value is required",
				}
			}

		case "count":
			// no validation rules for Count
		default:
			return GatewayConnectionStats_RoundTripTimesValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayConnectionStats_RoundTripTimesValidationError is the validation error
// returned by GatewayConnectionStats_RoundTripTimes.ValidateFields if the
// designated constraints aren't met.
type GatewayConnectionStats_RoundTripTimesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayConnectionStats_RoundTripTimesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayConnectionStats_RoundTripTimesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayConnectionStats_RoundTripTimesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayConnectionStats_RoundTripTimesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayConnectionStats_RoundTripTimesValidationError) ErrorName() string {
	return "GatewayConnectionStats_RoundTripTimesValidationError"
}

// Error satisfies the builtin error interface
func (e GatewayConnectionStats_RoundTripTimesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayConnectionStats_RoundTripTimes.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayConnectionStats_RoundTripTimesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayConnectionStats_RoundTripTimesValidationError{}

// ValidateFields checks the field values on GatewayConnectionStats_SubBand
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *GatewayConnectionStats_SubBand) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GatewayConnectionStats_SubBandFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "min_frequency":
			// no validation rules for MinFrequency
		case "max_frequency":
			// no validation rules for MaxFrequency
		case "downlink_utilization_limit":
			// no validation rules for DownlinkUtilizationLimit
		case "downlink_utilization":
			// no validation rules for DownlinkUtilization
		default:
			return GatewayConnectionStats_SubBandValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GatewayConnectionStats_SubBandValidationError is the validation error
// returned by GatewayConnectionStats_SubBand.ValidateFields if the designated
// constraints aren't met.
type GatewayConnectionStats_SubBandValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GatewayConnectionStats_SubBandValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GatewayConnectionStats_SubBandValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GatewayConnectionStats_SubBandValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GatewayConnectionStats_SubBandValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GatewayConnectionStats_SubBandValidationError) ErrorName() string {
	return "GatewayConnectionStats_SubBandValidationError"
}

// Error satisfies the builtin error interface
func (e GatewayConnectionStats_SubBandValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGatewayConnectionStats_SubBand.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GatewayConnectionStats_SubBandValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GatewayConnectionStats_SubBandValidationError{}
