// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/gateway.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ManagedGatewayNetworkInterfaceType int32

const (
	ManagedGatewayNetworkInterfaceType_MANAGED_GATEWAY_NETWORK_INTERFACE_TYPE_UNSPECIFIED ManagedGatewayNetworkInterfaceType = 0
	ManagedGatewayNetworkInterfaceType_MANAGED_GATEWAY_NETWORK_INTERFACE_TYPE_CELLULAR    ManagedGatewayNetworkInterfaceType = 1
	ManagedGatewayNetworkInterfaceType_MANAGED_GATEWAY_NETWORK_INTERFACE_TYPE_WIFI        ManagedGatewayNetworkInterfaceType = 2
	ManagedGatewayNetworkInterfaceType_MANAGED_GATEWAY_NETWORK_INTERFACE_TYPE_ETHERNET    ManagedGatewayNetworkInterfaceType = 3
)

// Enum value maps for ManagedGatewayNetworkInterfaceType.
var (
	ManagedGatewayNetworkInterfaceType_name = map[int32]string{
		0: "MANAGED_GATEWAY_NETWORK_INTERFACE_TYPE_UNSPECIFIED",
		1: "MANAGED_GATEWAY_NETWORK_INTERFACE_TYPE_CELLULAR",
		2: "MANAGED_GATEWAY_NETWORK_INTERFACE_TYPE_WIFI",
		3: "MANAGED_GATEWAY_NETWORK_INTERFACE_TYPE_ETHERNET",
	}
	ManagedGatewayNetworkInterfaceType_value = map[string]int32{
		"MANAGED_GATEWAY_NETWORK_INTERFACE_TYPE_UNSPECIFIED": 0,
		"MANAGED_GATEWAY_NETWORK_INTERFACE_TYPE_CELLULAR":    1,
		"MANAGED_GATEWAY_NETWORK_INTERFACE_TYPE_WIFI":        2,
		"MANAGED_GATEWAY_NETWORK_INTERFACE_TYPE_ETHERNET":    3,
	}
)

func (x ManagedGatewayNetworkInterfaceType) Enum() *ManagedGatewayNetworkInterfaceType {
	p := new(ManagedGatewayNetworkInterfaceType)
	*p = x
	return p
}

func (x ManagedGatewayNetworkInterfaceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagedGatewayNetworkInterfaceType) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_gateway_proto_enumTypes[0].Descriptor()
}

func (ManagedGatewayNetworkInterfaceType) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_gateway_proto_enumTypes[0]
}

func (x ManagedGatewayNetworkInterfaceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagedGatewayNetworkInterfaceType.Descriptor instead.
func (ManagedGatewayNetworkInterfaceType) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{0}
}

type ManagedGatewayNetworkInterfaceStatus int32

const (
	ManagedGatewayNetworkInterfaceStatus_MANAGED_GATEWAY_NETWORK_INTERFACE_STATUS_UNSPECIFIED ManagedGatewayNetworkInterfaceStatus = 0
	ManagedGatewayNetworkInterfaceStatus_MANAGED_GATEWAY_NETWORK_INTERFACE_STATUS_DOWN        ManagedGatewayNetworkInterfaceStatus = 1
	ManagedGatewayNetworkInterfaceStatus_MANAGED_GATEWAY_NETWORK_INTERFACE_STATUS_UP          ManagedGatewayNetworkInterfaceStatus = 2
	ManagedGatewayNetworkInterfaceStatus_MANAGED_GATEWAY_NETWORK_INTERFACE_STATUS_FAILED      ManagedGatewayNetworkInterfaceStatus = 3
)

// Enum value maps for ManagedGatewayNetworkInterfaceStatus.
var (
	ManagedGatewayNetworkInterfaceStatus_name = map[int32]string{
		0: "MANAGED_GATEWAY_NETWORK_INTERFACE_STATUS_UNSPECIFIED",
		1: "MANAGED_GATEWAY_NETWORK_INTERFACE_STATUS_DOWN",
		2: "MANAGED_GATEWAY_NETWORK_INTERFACE_STATUS_UP",
		3: "MANAGED_GATEWAY_NETWORK_INTERFACE_STATUS_FAILED",
	}
	ManagedGatewayNetworkInterfaceStatus_value = map[string]int32{
		"MANAGED_GATEWAY_NETWORK_INTERFACE_STATUS_UNSPECIFIED": 0,
		"MANAGED_GATEWAY_NETWORK_INTERFACE_STATUS_DOWN":        1,
		"MANAGED_GATEWAY_NETWORK_INTERFACE_STATUS_UP":          2,
		"MANAGED_GATEWAY_NETWORK_INTERFACE_STATUS_FAILED":      3,
	}
)

func (x ManagedGatewayNetworkInterfaceStatus) Enum() *ManagedGatewayNetworkInterfaceStatus {
	p := new(ManagedGatewayNetworkInterfaceStatus)
	*p = x
	return p
}

func (x ManagedGatewayNetworkInterfaceStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagedGatewayNetworkInterfaceStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_gateway_proto_enumTypes[1].Descriptor()
}

func (ManagedGatewayNetworkInterfaceStatus) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_gateway_proto_enumTypes[1]
}

func (x ManagedGatewayNetworkInterfaceStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagedGatewayNetworkInterfaceStatus.Descriptor instead.
func (ManagedGatewayNetworkInterfaceStatus) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{1}
}

type GatewayAntennaPlacement int32

const (
	GatewayAntennaPlacement_PLACEMENT_UNKNOWN GatewayAntennaPlacement = 0
	GatewayAntennaPlacement_INDOOR            GatewayAntennaPlacement = 1
	GatewayAntennaPlacement_OUTDOOR           GatewayAntennaPlacement = 2
)

// Enum value maps for GatewayAntennaPlacement.
var (
	GatewayAntennaPlacement_name = map[int32]string{
		0: "PLACEMENT_UNKNOWN",
		1: "INDOOR",
		2: "OUTDOOR",
	}
	GatewayAntennaPlacement_value = map[string]int32{
		"PLACEMENT_UNKNOWN": 0,
		"INDOOR":            1,
		"OUTDOOR":           2,
	}
)

func (x GatewayAntennaPlacement) Enum() *GatewayAntennaPlacement {
	p := new(GatewayAntennaPlacement)
	*p = x
	return p
}

func (x GatewayAntennaPlacement) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GatewayAntennaPlacement) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_gateway_proto_enumTypes[2].Descriptor()
}

func (GatewayAntennaPlacement) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_gateway_proto_enumTypes[2]
}

func (x GatewayAntennaPlacement) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GatewayAntennaPlacement.Descriptor instead.
func (GatewayAntennaPlacement) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{2}
}

type GatewayBrand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id   string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Url  string `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	// Logos contains file names of brand logos.
	Logos []string `protobuf:"bytes,4,rep,name=logos,proto3" json:"logos,omitempty"`
}

func (x *GatewayBrand) Reset() {
	*x = GatewayBrand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayBrand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayBrand) ProtoMessage() {}

func (x *GatewayBrand) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayBrand.ProtoReflect.Descriptor instead.
func (*GatewayBrand) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{0}
}

func (x *GatewayBrand) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *GatewayBrand) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GatewayBrand) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *GatewayBrand) GetLogos() []string {
	if x != nil {
		return x.Logos
	}
	return nil
}

type GatewayModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BrandId string `protobuf:"bytes,1,opt,name=brand_id,json=brandId,proto3" json:"brand_id,omitempty"`
	Id      string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	Name    string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GatewayModel) Reset() {
	*x = GatewayModel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayModel) ProtoMessage() {}

func (x *GatewayModel) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayModel.ProtoReflect.Descriptor instead.
func (*GatewayModel) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{1}
}

func (x *GatewayModel) GetBrandId() string {
	if x != nil {
		return x.BrandId
	}
	return ""
}

func (x *GatewayModel) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *GatewayModel) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Identifies an end device model with version information.
type GatewayVersionIdentifiers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BrandId         string `protobuf:"bytes,1,opt,name=brand_id,json=brandId,proto3" json:"brand_id,omitempty"`
	ModelId         string `protobuf:"bytes,2,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
	HardwareVersion string `protobuf:"bytes,3,opt,name=hardware_version,json=hardwareVersion,proto3" json:"hardware_version,omitempty"`
	FirmwareVersion string `protobuf:"bytes,4,opt,name=firmware_version,json=firmwareVersion,proto3" json:"firmware_version,omitempty"`
	RuntimeVersion  string `protobuf:"bytes,5,opt,name=runtime_version,json=runtimeVersion,proto3" json:"runtime_version,omitempty"`
}

func (x *GatewayVersionIdentifiers) Reset() {
	*x = GatewayVersionIdentifiers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayVersionIdentifiers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayVersionIdentifiers) ProtoMessage() {}

func (x *GatewayVersionIdentifiers) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayVersionIdentifiers.ProtoReflect.Descriptor instead.
func (*GatewayVersionIdentifiers) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{2}
}

func (x *GatewayVersionIdentifiers) GetBrandId() string {
	if x != nil {
		return x.BrandId
	}
	return ""
}

func (x *GatewayVersionIdentifiers) GetModelId() string {
	if x != nil {
		return x.ModelId
	}
	return ""
}

func (x *GatewayVersionIdentifiers) GetHardwareVersion() string {
	if x != nil {
		return x.HardwareVersion
	}
	return ""
}

func (x *GatewayVersionIdentifiers) GetFirmwareVersion() string {
	if x != nil {
		return x.FirmwareVersion
	}
	return ""
}

func (x *GatewayVersionIdentifiers) GetRuntimeVersion() string {
	if x != nil {
		return x.RuntimeVersion
	}
	return ""
}

type GatewayRadio struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enable          bool                          `protobuf:"varint,1,opt,name=enable,proto3" json:"enable,omitempty"`
	ChipType        string                        `protobuf:"bytes,2,opt,name=chip_type,json=chipType,proto3" json:"chip_type,omitempty"`
	Frequency       uint64                        `protobuf:"varint,3,opt,name=frequency,proto3" json:"frequency,omitempty"`
	RssiOffset      float32                       `protobuf:"fixed32,4,opt,name=rssi_offset,json=rssiOffset,proto3" json:"rssi_offset,omitempty"`
	TxConfiguration *GatewayRadio_TxConfiguration `protobuf:"bytes,5,opt,name=tx_configuration,json=txConfiguration,proto3" json:"tx_configuration,omitempty"`
}

func (x *GatewayRadio) Reset() {
	*x = GatewayRadio{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayRadio) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayRadio) ProtoMessage() {}

func (x *GatewayRadio) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayRadio.ProtoReflect.Descriptor instead.
func (*GatewayRadio) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{3}
}

func (x *GatewayRadio) GetEnable() bool {
	if x != nil {
		return x.Enable
	}
	return false
}

func (x *GatewayRadio) GetChipType() string {
	if x != nil {
		return x.ChipType
	}
	return ""
}

func (x *GatewayRadio) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *GatewayRadio) GetRssiOffset() float32 {
	if x != nil {
		return x.RssiOffset
	}
	return 0
}

func (x *GatewayRadio) GetTxConfiguration() *GatewayRadio_TxConfiguration {
	if x != nil {
		return x.TxConfiguration
	}
	return nil
}

// Authentication code for claiming gateways.
type GatewayClaimAuthenticationCode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Secret    *Secret                `protobuf:"bytes,1,opt,name=secret,proto3" json:"secret,omitempty"`
	ValidFrom *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=valid_from,json=validFrom,proto3" json:"valid_from,omitempty"`
	ValidTo   *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=valid_to,json=validTo,proto3" json:"valid_to,omitempty"`
}

func (x *GatewayClaimAuthenticationCode) Reset() {
	*x = GatewayClaimAuthenticationCode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayClaimAuthenticationCode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayClaimAuthenticationCode) ProtoMessage() {}

func (x *GatewayClaimAuthenticationCode) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayClaimAuthenticationCode.ProtoReflect.Descriptor instead.
func (*GatewayClaimAuthenticationCode) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{4}
}

func (x *GatewayClaimAuthenticationCode) GetSecret() *Secret {
	if x != nil {
		return x.Secret
	}
	return nil
}

func (x *GatewayClaimAuthenticationCode) GetValidFrom() *timestamppb.Timestamp {
	if x != nil {
		return x.ValidFrom
	}
	return nil
}

func (x *GatewayClaimAuthenticationCode) GetValidTo() *timestamppb.Timestamp {
	if x != nil {
		return x.ValidTo
	}
	return nil
}

// Gateway is the message that defines a gateway on the network.
type Gateway struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifiers of the gateway. These are public and can be seen by any authenticated user in the network.
	Ids *GatewayIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	// When the gateway was created. This information is public and can be seen by any authenticated user in the network.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// When the gateway was last updated. This information is public and can be seen by any authenticated user in the network.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// When the gateway was deleted. This information is public and can be seen by any authenticated user in the network.
	DeletedAt *timestamppb.Timestamp `protobuf:"bytes,26,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// The name of the gateway. This information is public and can be seen by any authenticated user in the network.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// A description for the gateway. This information is public and can be seen by any authenticated user in the network.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Key-value attributes for this gateway. Typically used for organizing gateways or for storing integration-specific data.
	Attributes map[string]string `protobuf:"bytes,6,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Contact information for this gateway. Typically used to indicate who to contact with technical/security questions about the gateway.
	// This field is deprecated. Use administrative_contact and technical_contact instead.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/gateway.proto.
	ContactInfo           []*ContactInfo                 `protobuf:"bytes,7,rep,name=contact_info,json=contactInfo,proto3" json:"contact_info,omitempty"`
	AdministrativeContact *OrganizationOrUserIdentifiers `protobuf:"bytes,30,opt,name=administrative_contact,json=administrativeContact,proto3" json:"administrative_contact,omitempty"`
	TechnicalContact      *OrganizationOrUserIdentifiers `protobuf:"bytes,31,opt,name=technical_contact,json=technicalContact,proto3" json:"technical_contact,omitempty"`
	VersionIds            *GatewayVersionIdentifiers     `protobuf:"bytes,8,opt,name=version_ids,json=versionIds,proto3" json:"version_ids,omitempty"`
	// The address of the Gateway Server to connect to.
	// This information is public and can be seen by any authenticated user in the network if status_public is true.
	// The typical format of the address is "scheme://host:port". The scheme is optional. If the port is omitted,
	// the normal port inference (with DNS lookup, otherwise defaults) is used.
	// The connection shall be established with transport layer security (TLS).
	// Custom certificate authorities may be configured out-of-band.
	GatewayServerAddress string `protobuf:"bytes,9,opt,name=gateway_server_address,json=gatewayServerAddress,proto3" json:"gateway_server_address,omitempty"`
	AutoUpdate           bool   `protobuf:"varint,10,opt,name=auto_update,json=autoUpdate,proto3" json:"auto_update,omitempty"`
	UpdateChannel        string `protobuf:"bytes,11,opt,name=update_channel,json=updateChannel,proto3" json:"update_channel,omitempty"`
	// Frequency plan ID of the gateway.
	// This information is public and can be seen by any authenticated user in the network.
	// DEPRECATED: use frequency_plan_ids.
	// This equals the first element of the frequency_plan_ids field.
	FrequencyPlanId string `protobuf:"bytes,12,opt,name=frequency_plan_id,json=frequencyPlanId,proto3" json:"frequency_plan_id,omitempty"`
	// Frequency plan IDs of the gateway.
	// This information is public and can be seen by any authenticated user in the network.
	// The first element equals the frequency_plan_id field.
	FrequencyPlanIds []string `protobuf:"bytes,20,rep,name=frequency_plan_ids,json=frequencyPlanIds,proto3" json:"frequency_plan_ids,omitempty"`
	// Antennas of the gateway. Location information of the antennas is public and can be seen by any authenticated user in the network if location_public=true.
	Antennas []*GatewayAntenna `protobuf:"bytes,13,rep,name=antennas,proto3" json:"antennas,omitempty"`
	// The status of this gateway may be publicly displayed.
	StatusPublic bool `protobuf:"varint,14,opt,name=status_public,json=statusPublic,proto3" json:"status_public,omitempty"`
	// The location of this gateway may be publicly displayed.
	LocationPublic bool `protobuf:"varint,15,opt,name=location_public,json=locationPublic,proto3" json:"location_public,omitempty"`
	// Enable server-side buffering of downlink messages. This is recommended for gateways using the Semtech UDP Packet
	// Forwarder v2.x or older, as it does not feature a just-in-time queue. If enabled, the Gateway Server schedules the
	// downlink message late to the gateway so that it does not overwrite previously scheduled downlink messages that have
	// not been transmitted yet.
	ScheduleDownlinkLate bool `protobuf:"varint,16,opt,name=schedule_downlink_late,json=scheduleDownlinkLate,proto3" json:"schedule_downlink_late,omitempty"`
	// Enforcing gateway duty cycle is recommended for all gateways to respect spectrum regulations. Disable enforcing the
	// duty cycle only in controlled research and development environments.
	EnforceDutyCycle       bool                   `protobuf:"varint,17,opt,name=enforce_duty_cycle,json=enforceDutyCycle,proto3" json:"enforce_duty_cycle,omitempty"`
	DownlinkPathConstraint DownlinkPathConstraint `protobuf:"varint,18,opt,name=downlink_path_constraint,json=downlinkPathConstraint,proto3,enum=ttn.lorawan.v3.DownlinkPathConstraint" json:"downlink_path_constraint,omitempty"`
	// Adjust the time that GS schedules class C messages in advance. This is useful for gateways that have a known high latency backhaul, like 3G and satellite.
	ScheduleAnytimeDelay *durationpb.Duration `protobuf:"bytes,19,opt,name=schedule_anytime_delay,json=scheduleAnytimeDelay,proto3" json:"schedule_anytime_delay,omitempty"`
	// Update the location of this gateway from status messages. This only works for gateways connecting with authentication; gateways connected over UDP are not supported.
	UpdateLocationFromStatus bool `protobuf:"varint,21,opt,name=update_location_from_status,json=updateLocationFromStatus,proto3" json:"update_location_from_status,omitempty"`
	// The LoRa Basics Station LNS secret.
	// This is either an auth token (such as an API Key) or a TLS private certificate.
	// Requires the RIGHT_GATEWAY_READ_SECRETS for reading and RIGHT_GATEWAY_WRITE_SECRETS for updating this value.
	LbsLnsSecret *Secret `protobuf:"bytes,22,opt,name=lbs_lns_secret,json=lbsLnsSecret,proto3" json:"lbs_lns_secret,omitempty"`
	// The authentication code for gateway claiming.
	// Requires the RIGHT_GATEWAY_READ_SECRETS for reading and RIGHT_GATEWAY_WRITE_SECRETS for updating this value.
	// The entire field must be used in RPCs since sub-fields are validated wrt to each other. Direct selection/update of sub-fields only are not allowed.
	// Use the top level field mask `claim_authentication_code` even when updating single fields.
	ClaimAuthenticationCode *GatewayClaimAuthenticationCode `protobuf:"bytes,23,opt,name=claim_authentication_code,json=claimAuthenticationCode,proto3" json:"claim_authentication_code,omitempty"`
	// CUPS URI for LoRa Basics Station CUPS redirection.
	// The CUPS Trust field will be automatically fetched from the cert chain presented by the target server.
	TargetCupsUri string `protobuf:"bytes,24,opt,name=target_cups_uri,json=targetCupsUri,proto3" json:"target_cups_uri,omitempty"`
	// CUPS Key for LoRa Basics Station CUPS redirection.
	// If redirecting to another instance of TTS, use the CUPS API Key for the gateway on the target instance.
	// Requires the RIGHT_GATEWAY_READ_SECRETS for reading and RIGHT_GATEWAY_WRITE_SECRETS for updating this value.
	TargetCupsKey *Secret `protobuf:"bytes,25,opt,name=target_cups_key,json=targetCupsKey,proto3" json:"target_cups_key,omitempty"`
	// Require an authenticated gateway connection. This prevents the gateway from using the UDP protocol and requires authentication when using other protocols.
	RequireAuthenticatedConnection bool            `protobuf:"varint,27,opt,name=require_authenticated_connection,json=requireAuthenticatedConnection,proto3" json:"require_authenticated_connection,omitempty"`
	Lrfhss                         *Gateway_LRFHSS `protobuf:"bytes,28,opt,name=lrfhss,proto3" json:"lrfhss,omitempty"`
	DisablePacketBrokerForwarding  bool            `protobuf:"varint,29,opt,name=disable_packet_broker_forwarding,json=disablePacketBrokerForwarding,proto3" json:"disable_packet_broker_forwarding,omitempty"`
}

func (x *Gateway) Reset() {
	*x = Gateway{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Gateway) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Gateway) ProtoMessage() {}

func (x *Gateway) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Gateway.ProtoReflect.Descriptor instead.
func (*Gateway) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{5}
}

func (x *Gateway) GetIds() *GatewayIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *Gateway) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Gateway) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *Gateway) GetDeletedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.DeletedAt
	}
	return nil
}

func (x *Gateway) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Gateway) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Gateway) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/gateway.proto.
func (x *Gateway) GetContactInfo() []*ContactInfo {
	if x != nil {
		return x.ContactInfo
	}
	return nil
}

func (x *Gateway) GetAdministrativeContact() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.AdministrativeContact
	}
	return nil
}

func (x *Gateway) GetTechnicalContact() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.TechnicalContact
	}
	return nil
}

func (x *Gateway) GetVersionIds() *GatewayVersionIdentifiers {
	if x != nil {
		return x.VersionIds
	}
	return nil
}

func (x *Gateway) GetGatewayServerAddress() string {
	if x != nil {
		return x.GatewayServerAddress
	}
	return ""
}

func (x *Gateway) GetAutoUpdate() bool {
	if x != nil {
		return x.AutoUpdate
	}
	return false
}

func (x *Gateway) GetUpdateChannel() string {
	if x != nil {
		return x.UpdateChannel
	}
	return ""
}

func (x *Gateway) GetFrequencyPlanId() string {
	if x != nil {
		return x.FrequencyPlanId
	}
	return ""
}

func (x *Gateway) GetFrequencyPlanIds() []string {
	if x != nil {
		return x.FrequencyPlanIds
	}
	return nil
}

func (x *Gateway) GetAntennas() []*GatewayAntenna {
	if x != nil {
		return x.Antennas
	}
	return nil
}

func (x *Gateway) GetStatusPublic() bool {
	if x != nil {
		return x.StatusPublic
	}
	return false
}

func (x *Gateway) GetLocationPublic() bool {
	if x != nil {
		return x.LocationPublic
	}
	return false
}

func (x *Gateway) GetScheduleDownlinkLate() bool {
	if x != nil {
		return x.ScheduleDownlinkLate
	}
	return false
}

func (x *Gateway) GetEnforceDutyCycle() bool {
	if x != nil {
		return x.EnforceDutyCycle
	}
	return false
}

func (x *Gateway) GetDownlinkPathConstraint() DownlinkPathConstraint {
	if x != nil {
		return x.DownlinkPathConstraint
	}
	return DownlinkPathConstraint_DOWNLINK_PATH_CONSTRAINT_NONE
}

func (x *Gateway) GetScheduleAnytimeDelay() *durationpb.Duration {
	if x != nil {
		return x.ScheduleAnytimeDelay
	}
	return nil
}

func (x *Gateway) GetUpdateLocationFromStatus() bool {
	if x != nil {
		return x.UpdateLocationFromStatus
	}
	return false
}

func (x *Gateway) GetLbsLnsSecret() *Secret {
	if x != nil {
		return x.LbsLnsSecret
	}
	return nil
}

func (x *Gateway) GetClaimAuthenticationCode() *GatewayClaimAuthenticationCode {
	if x != nil {
		return x.ClaimAuthenticationCode
	}
	return nil
}

func (x *Gateway) GetTargetCupsUri() string {
	if x != nil {
		return x.TargetCupsUri
	}
	return ""
}

func (x *Gateway) GetTargetCupsKey() *Secret {
	if x != nil {
		return x.TargetCupsKey
	}
	return nil
}

func (x *Gateway) GetRequireAuthenticatedConnection() bool {
	if x != nil {
		return x.RequireAuthenticatedConnection
	}
	return false
}

func (x *Gateway) GetLrfhss() *Gateway_LRFHSS {
	if x != nil {
		return x.Lrfhss
	}
	return nil
}

func (x *Gateway) GetDisablePacketBrokerForwarding() bool {
	if x != nil {
		return x.DisablePacketBrokerForwarding
	}
	return false
}

type Gateways struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Gateways []*Gateway `protobuf:"bytes,1,rep,name=gateways,proto3" json:"gateways,omitempty"`
}

func (x *Gateways) Reset() {
	*x = Gateways{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Gateways) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Gateways) ProtoMessage() {}

func (x *Gateways) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Gateways.ProtoReflect.Descriptor instead.
func (*Gateways) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{6}
}

func (x *Gateways) GetGateways() []*Gateway {
	if x != nil {
		return x.Gateways
	}
	return nil
}

type ManagedGateway struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids                *GatewayIdentifiers        `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	VersionIds         *GatewayVersionIdentifiers `protobuf:"bytes,2,opt,name=version_ids,json=versionIds,proto3" json:"version_ids,omitempty"`
	CellularImei       string                     `protobuf:"bytes,3,opt,name=cellular_imei,json=cellularImei,proto3" json:"cellular_imei,omitempty"`
	CellularImsi       string                     `protobuf:"bytes,4,opt,name=cellular_imsi,json=cellularImsi,proto3" json:"cellular_imsi,omitempty"`
	WifiMacAddress     []byte                     `protobuf:"bytes,5,opt,name=wifi_mac_address,json=wifiMacAddress,proto3" json:"wifi_mac_address,omitempty"`
	EthernetMacAddress []byte                     `protobuf:"bytes,6,opt,name=ethernet_mac_address,json=ethernetMacAddress,proto3" json:"ethernet_mac_address,omitempty"`
	WifiProfileId      string                     `protobuf:"bytes,7,opt,name=wifi_profile_id,json=wifiProfileId,proto3" json:"wifi_profile_id,omitempty"`
	EthernetProfileId  string                     `protobuf:"bytes,8,opt,name=ethernet_profile_id,json=ethernetProfileId,proto3" json:"ethernet_profile_id,omitempty"`
}

func (x *ManagedGateway) Reset() {
	*x = ManagedGateway{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGateway) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGateway) ProtoMessage() {}

func (x *ManagedGateway) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGateway.ProtoReflect.Descriptor instead.
func (*ManagedGateway) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{7}
}

func (x *ManagedGateway) GetIds() *GatewayIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *ManagedGateway) GetVersionIds() *GatewayVersionIdentifiers {
	if x != nil {
		return x.VersionIds
	}
	return nil
}

func (x *ManagedGateway) GetCellularImei() string {
	if x != nil {
		return x.CellularImei
	}
	return ""
}

func (x *ManagedGateway) GetCellularImsi() string {
	if x != nil {
		return x.CellularImsi
	}
	return ""
}

func (x *ManagedGateway) GetWifiMacAddress() []byte {
	if x != nil {
		return x.WifiMacAddress
	}
	return nil
}

func (x *ManagedGateway) GetEthernetMacAddress() []byte {
	if x != nil {
		return x.EthernetMacAddress
	}
	return nil
}

func (x *ManagedGateway) GetWifiProfileId() string {
	if x != nil {
		return x.WifiProfileId
	}
	return ""
}

func (x *ManagedGateway) GetEthernetProfileId() string {
	if x != nil {
		return x.EthernetProfileId
	}
	return ""
}

type ManagedGatewayWiFiAccessPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ssid               string  `protobuf:"bytes,1,opt,name=ssid,proto3" json:"ssid,omitempty"`
	Bssid              []byte  `protobuf:"bytes,2,opt,name=bssid,proto3" json:"bssid,omitempty"`
	Channel            uint32  `protobuf:"varint,3,opt,name=channel,proto3" json:"channel,omitempty"`
	AuthenticationMode string  `protobuf:"bytes,4,opt,name=authentication_mode,json=authenticationMode,proto3" json:"authentication_mode,omitempty"`
	Rssi               float32 `protobuf:"fixed32,5,opt,name=rssi,proto3" json:"rssi,omitempty"`
}

func (x *ManagedGatewayWiFiAccessPoint) Reset() {
	*x = ManagedGatewayWiFiAccessPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewayWiFiAccessPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewayWiFiAccessPoint) ProtoMessage() {}

func (x *ManagedGatewayWiFiAccessPoint) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewayWiFiAccessPoint.ProtoReflect.Descriptor instead.
func (*ManagedGatewayWiFiAccessPoint) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{8}
}

func (x *ManagedGatewayWiFiAccessPoint) GetSsid() string {
	if x != nil {
		return x.Ssid
	}
	return ""
}

func (x *ManagedGatewayWiFiAccessPoint) GetBssid() []byte {
	if x != nil {
		return x.Bssid
	}
	return nil
}

func (x *ManagedGatewayWiFiAccessPoint) GetChannel() uint32 {
	if x != nil {
		return x.Channel
	}
	return 0
}

func (x *ManagedGatewayWiFiAccessPoint) GetAuthenticationMode() string {
	if x != nil {
		return x.AuthenticationMode
	}
	return ""
}

func (x *ManagedGatewayWiFiAccessPoint) GetRssi() float32 {
	if x != nil {
		return x.Rssi
	}
	return 0
}

type ManagedGatewayWiFiAccessPoints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AccessPoints []*ManagedGatewayWiFiAccessPoint `protobuf:"bytes,1,rep,name=access_points,json=accessPoints,proto3" json:"access_points,omitempty"`
}

func (x *ManagedGatewayWiFiAccessPoints) Reset() {
	*x = ManagedGatewayWiFiAccessPoints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewayWiFiAccessPoints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewayWiFiAccessPoints) ProtoMessage() {}

func (x *ManagedGatewayWiFiAccessPoints) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewayWiFiAccessPoints.ProtoReflect.Descriptor instead.
func (*ManagedGatewayWiFiAccessPoints) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{9}
}

func (x *ManagedGatewayWiFiAccessPoints) GetAccessPoints() []*ManagedGatewayWiFiAccessPoint {
	if x != nil {
		return x.AccessPoints
	}
	return nil
}

type ManagedGatewayNetworkInterfaceAddresses struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IpAddresses []string `protobuf:"bytes,1,rep,name=ip_addresses,json=ipAddresses,proto3" json:"ip_addresses,omitempty"`
	SubnetMask  string   `protobuf:"bytes,2,opt,name=subnet_mask,json=subnetMask,proto3" json:"subnet_mask,omitempty"`
	Gateway     string   `protobuf:"bytes,3,opt,name=gateway,proto3" json:"gateway,omitempty"`
	DnsServers  []string `protobuf:"bytes,4,rep,name=dns_servers,json=dnsServers,proto3" json:"dns_servers,omitempty"`
}

func (x *ManagedGatewayNetworkInterfaceAddresses) Reset() {
	*x = ManagedGatewayNetworkInterfaceAddresses{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewayNetworkInterfaceAddresses) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewayNetworkInterfaceAddresses) ProtoMessage() {}

func (x *ManagedGatewayNetworkInterfaceAddresses) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewayNetworkInterfaceAddresses.ProtoReflect.Descriptor instead.
func (*ManagedGatewayNetworkInterfaceAddresses) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{10}
}

func (x *ManagedGatewayNetworkInterfaceAddresses) GetIpAddresses() []string {
	if x != nil {
		return x.IpAddresses
	}
	return nil
}

func (x *ManagedGatewayNetworkInterfaceAddresses) GetSubnetMask() string {
	if x != nil {
		return x.SubnetMask
	}
	return ""
}

func (x *ManagedGatewayNetworkInterfaceAddresses) GetGateway() string {
	if x != nil {
		return x.Gateway
	}
	return ""
}

func (x *ManagedGatewayNetworkInterfaceAddresses) GetDnsServers() []string {
	if x != nil {
		return x.DnsServers
	}
	return nil
}

type ManagedGatewaySystemStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CPU temperature (Celsius).
	CpuTemperature *wrapperspb.FloatValue `protobuf:"bytes,1,opt,name=cpu_temperature,json=cpuTemperature,proto3" json:"cpu_temperature,omitempty"`
}

func (x *ManagedGatewaySystemStatus) Reset() {
	*x = ManagedGatewaySystemStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewaySystemStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewaySystemStatus) ProtoMessage() {}

func (x *ManagedGatewaySystemStatus) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewaySystemStatus.ProtoReflect.Descriptor instead.
func (*ManagedGatewaySystemStatus) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{11}
}

func (x *ManagedGatewaySystemStatus) GetCpuTemperature() *wrapperspb.FloatValue {
	if x != nil {
		return x.CpuTemperature
	}
	return nil
}

type ManagedGatewayControllerConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NetworkInterfaceType ManagedGatewayNetworkInterfaceType `protobuf:"varint,1,opt,name=network_interface_type,json=networkInterfaceType,proto3,enum=ttn.lorawan.v3.ManagedGatewayNetworkInterfaceType" json:"network_interface_type,omitempty"`
}

func (x *ManagedGatewayControllerConnection) Reset() {
	*x = ManagedGatewayControllerConnection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewayControllerConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewayControllerConnection) ProtoMessage() {}

func (x *ManagedGatewayControllerConnection) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewayControllerConnection.ProtoReflect.Descriptor instead.
func (*ManagedGatewayControllerConnection) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{12}
}

func (x *ManagedGatewayControllerConnection) GetNetworkInterfaceType() ManagedGatewayNetworkInterfaceType {
	if x != nil {
		return x.NetworkInterfaceType
	}
	return ManagedGatewayNetworkInterfaceType_MANAGED_GATEWAY_NETWORK_INTERFACE_TYPE_UNSPECIFIED
}

type ManagedGatewayGatewayServerConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NetworkInterfaceType ManagedGatewayNetworkInterfaceType `protobuf:"varint,1,opt,name=network_interface_type,json=networkInterfaceType,proto3,enum=ttn.lorawan.v3.ManagedGatewayNetworkInterfaceType" json:"network_interface_type,omitempty"`
	Address              string                             `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
}

func (x *ManagedGatewayGatewayServerConnection) Reset() {
	*x = ManagedGatewayGatewayServerConnection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewayGatewayServerConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewayGatewayServerConnection) ProtoMessage() {}

func (x *ManagedGatewayGatewayServerConnection) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewayGatewayServerConnection.ProtoReflect.Descriptor instead.
func (*ManagedGatewayGatewayServerConnection) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{13}
}

func (x *ManagedGatewayGatewayServerConnection) GetNetworkInterfaceType() ManagedGatewayNetworkInterfaceType {
	if x != nil {
		return x.NetworkInterfaceType
	}
	return ManagedGatewayNetworkInterfaceType_MANAGED_GATEWAY_NETWORK_INTERFACE_TYPE_UNSPECIFIED
}

func (x *ManagedGatewayGatewayServerConnection) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

type ManagedGatewayNetworkInterfaceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status      ManagedGatewayNetworkInterfaceStatus     `protobuf:"varint,1,opt,name=status,proto3,enum=ttn.lorawan.v3.ManagedGatewayNetworkInterfaceStatus" json:"status,omitempty"`
	DhcpEnabled bool                                     `protobuf:"varint,2,opt,name=dhcp_enabled,json=dhcpEnabled,proto3" json:"dhcp_enabled,omitempty"`
	Addresses   *ManagedGatewayNetworkInterfaceAddresses `protobuf:"bytes,3,opt,name=addresses,proto3" json:"addresses,omitempty"`
}

func (x *ManagedGatewayNetworkInterfaceInfo) Reset() {
	*x = ManagedGatewayNetworkInterfaceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewayNetworkInterfaceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewayNetworkInterfaceInfo) ProtoMessage() {}

func (x *ManagedGatewayNetworkInterfaceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewayNetworkInterfaceInfo.ProtoReflect.Descriptor instead.
func (*ManagedGatewayNetworkInterfaceInfo) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{14}
}

func (x *ManagedGatewayNetworkInterfaceInfo) GetStatus() ManagedGatewayNetworkInterfaceStatus {
	if x != nil {
		return x.Status
	}
	return ManagedGatewayNetworkInterfaceStatus_MANAGED_GATEWAY_NETWORK_INTERFACE_STATUS_UNSPECIFIED
}

func (x *ManagedGatewayNetworkInterfaceInfo) GetDhcpEnabled() bool {
	if x != nil {
		return x.DhcpEnabled
	}
	return false
}

func (x *ManagedGatewayNetworkInterfaceInfo) GetAddresses() *ManagedGatewayNetworkInterfaceAddresses {
	if x != nil {
		return x.Addresses
	}
	return nil
}

type ManagedGatewayCellularBackhaul struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NetworkInterface *ManagedGatewayNetworkInterfaceInfo `protobuf:"bytes,1,opt,name=network_interface,json=networkInterface,proto3" json:"network_interface,omitempty"`
	Operator         string                              `protobuf:"bytes,2,opt,name=operator,proto3" json:"operator,omitempty"`
	Rssi             *wrapperspb.FloatValue              `protobuf:"bytes,3,opt,name=rssi,proto3" json:"rssi,omitempty"`
}

func (x *ManagedGatewayCellularBackhaul) Reset() {
	*x = ManagedGatewayCellularBackhaul{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewayCellularBackhaul) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewayCellularBackhaul) ProtoMessage() {}

func (x *ManagedGatewayCellularBackhaul) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewayCellularBackhaul.ProtoReflect.Descriptor instead.
func (*ManagedGatewayCellularBackhaul) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{15}
}

func (x *ManagedGatewayCellularBackhaul) GetNetworkInterface() *ManagedGatewayNetworkInterfaceInfo {
	if x != nil {
		return x.NetworkInterface
	}
	return nil
}

func (x *ManagedGatewayCellularBackhaul) GetOperator() string {
	if x != nil {
		return x.Operator
	}
	return ""
}

func (x *ManagedGatewayCellularBackhaul) GetRssi() *wrapperspb.FloatValue {
	if x != nil {
		return x.Rssi
	}
	return nil
}

type ManagedGatewayWiFiBackhaul struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NetworkInterface   *ManagedGatewayNetworkInterfaceInfo `protobuf:"bytes,1,opt,name=network_interface,json=networkInterface,proto3" json:"network_interface,omitempty"`
	Ssid               string                              `protobuf:"bytes,2,opt,name=ssid,proto3" json:"ssid,omitempty"`
	Bssid              []byte                              `protobuf:"bytes,3,opt,name=bssid,proto3" json:"bssid,omitempty"`
	Channel            uint32                              `protobuf:"varint,4,opt,name=channel,proto3" json:"channel,omitempty"`
	AuthenticationMode string                              `protobuf:"bytes,5,opt,name=authentication_mode,json=authenticationMode,proto3" json:"authentication_mode,omitempty"`
	Rssi               *wrapperspb.FloatValue              `protobuf:"bytes,6,opt,name=rssi,proto3" json:"rssi,omitempty"`
}

func (x *ManagedGatewayWiFiBackhaul) Reset() {
	*x = ManagedGatewayWiFiBackhaul{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewayWiFiBackhaul) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewayWiFiBackhaul) ProtoMessage() {}

func (x *ManagedGatewayWiFiBackhaul) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewayWiFiBackhaul.ProtoReflect.Descriptor instead.
func (*ManagedGatewayWiFiBackhaul) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{16}
}

func (x *ManagedGatewayWiFiBackhaul) GetNetworkInterface() *ManagedGatewayNetworkInterfaceInfo {
	if x != nil {
		return x.NetworkInterface
	}
	return nil
}

func (x *ManagedGatewayWiFiBackhaul) GetSsid() string {
	if x != nil {
		return x.Ssid
	}
	return ""
}

func (x *ManagedGatewayWiFiBackhaul) GetBssid() []byte {
	if x != nil {
		return x.Bssid
	}
	return nil
}

func (x *ManagedGatewayWiFiBackhaul) GetChannel() uint32 {
	if x != nil {
		return x.Channel
	}
	return 0
}

func (x *ManagedGatewayWiFiBackhaul) GetAuthenticationMode() string {
	if x != nil {
		return x.AuthenticationMode
	}
	return ""
}

func (x *ManagedGatewayWiFiBackhaul) GetRssi() *wrapperspb.FloatValue {
	if x != nil {
		return x.Rssi
	}
	return nil
}

type ManagedGatewayEthernetBackhaul struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NetworkInterface *ManagedGatewayNetworkInterfaceInfo `protobuf:"bytes,1,opt,name=network_interface,json=networkInterface,proto3" json:"network_interface,omitempty"`
}

func (x *ManagedGatewayEthernetBackhaul) Reset() {
	*x = ManagedGatewayEthernetBackhaul{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewayEthernetBackhaul) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewayEthernetBackhaul) ProtoMessage() {}

func (x *ManagedGatewayEthernetBackhaul) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewayEthernetBackhaul.ProtoReflect.Descriptor instead.
func (*ManagedGatewayEthernetBackhaul) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{17}
}

func (x *ManagedGatewayEthernetBackhaul) GetNetworkInterface() *ManagedGatewayNetworkInterfaceInfo {
	if x != nil {
		return x.NetworkInterface
	}
	return nil
}

type ManagedGatewayEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Data:
	//	*ManagedGatewayEventData_Entity
	//	*ManagedGatewayEventData_Location
	//	*ManagedGatewayEventData_SystemStatus
	//	*ManagedGatewayEventData_ControllerConnection
	//	*ManagedGatewayEventData_GatewayServerConnection
	//	*ManagedGatewayEventData_CellularBackhaul
	//	*ManagedGatewayEventData_WifiBackhaul
	//	*ManagedGatewayEventData_EthernetBackhaul
	Data isManagedGatewayEventData_Data `protobuf_oneof:"data"`
}

func (x *ManagedGatewayEventData) Reset() {
	*x = ManagedGatewayEventData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewayEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewayEventData) ProtoMessage() {}

func (x *ManagedGatewayEventData) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewayEventData.ProtoReflect.Descriptor instead.
func (*ManagedGatewayEventData) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{18}
}

func (m *ManagedGatewayEventData) GetData() isManagedGatewayEventData_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *ManagedGatewayEventData) GetEntity() *ManagedGateway {
	if x, ok := x.GetData().(*ManagedGatewayEventData_Entity); ok {
		return x.Entity
	}
	return nil
}

func (x *ManagedGatewayEventData) GetLocation() *Location {
	if x, ok := x.GetData().(*ManagedGatewayEventData_Location); ok {
		return x.Location
	}
	return nil
}

func (x *ManagedGatewayEventData) GetSystemStatus() *ManagedGatewaySystemStatus {
	if x, ok := x.GetData().(*ManagedGatewayEventData_SystemStatus); ok {
		return x.SystemStatus
	}
	return nil
}

func (x *ManagedGatewayEventData) GetControllerConnection() *ManagedGatewayControllerConnection {
	if x, ok := x.GetData().(*ManagedGatewayEventData_ControllerConnection); ok {
		return x.ControllerConnection
	}
	return nil
}

func (x *ManagedGatewayEventData) GetGatewayServerConnection() *ManagedGatewayGatewayServerConnection {
	if x, ok := x.GetData().(*ManagedGatewayEventData_GatewayServerConnection); ok {
		return x.GatewayServerConnection
	}
	return nil
}

func (x *ManagedGatewayEventData) GetCellularBackhaul() *ManagedGatewayCellularBackhaul {
	if x, ok := x.GetData().(*ManagedGatewayEventData_CellularBackhaul); ok {
		return x.CellularBackhaul
	}
	return nil
}

func (x *ManagedGatewayEventData) GetWifiBackhaul() *ManagedGatewayWiFiBackhaul {
	if x, ok := x.GetData().(*ManagedGatewayEventData_WifiBackhaul); ok {
		return x.WifiBackhaul
	}
	return nil
}

func (x *ManagedGatewayEventData) GetEthernetBackhaul() *ManagedGatewayEthernetBackhaul {
	if x, ok := x.GetData().(*ManagedGatewayEventData_EthernetBackhaul); ok {
		return x.EthernetBackhaul
	}
	return nil
}

type isManagedGatewayEventData_Data interface {
	isManagedGatewayEventData_Data()
}

type ManagedGatewayEventData_Entity struct {
	Entity *ManagedGateway `protobuf:"bytes,1,opt,name=entity,proto3,oneof"`
}

type ManagedGatewayEventData_Location struct {
	Location *Location `protobuf:"bytes,2,opt,name=location,proto3,oneof"`
}

type ManagedGatewayEventData_SystemStatus struct {
	SystemStatus *ManagedGatewaySystemStatus `protobuf:"bytes,3,opt,name=system_status,json=systemStatus,proto3,oneof"`
}

type ManagedGatewayEventData_ControllerConnection struct {
	ControllerConnection *ManagedGatewayControllerConnection `protobuf:"bytes,4,opt,name=controller_connection,json=controllerConnection,proto3,oneof"`
}

type ManagedGatewayEventData_GatewayServerConnection struct {
	GatewayServerConnection *ManagedGatewayGatewayServerConnection `protobuf:"bytes,5,opt,name=gateway_server_connection,json=gatewayServerConnection,proto3,oneof"`
}

type ManagedGatewayEventData_CellularBackhaul struct {
	CellularBackhaul *ManagedGatewayCellularBackhaul `protobuf:"bytes,6,opt,name=cellular_backhaul,json=cellularBackhaul,proto3,oneof"`
}

type ManagedGatewayEventData_WifiBackhaul struct {
	WifiBackhaul *ManagedGatewayWiFiBackhaul `protobuf:"bytes,7,opt,name=wifi_backhaul,json=wifiBackhaul,proto3,oneof"`
}

type ManagedGatewayEventData_EthernetBackhaul struct {
	EthernetBackhaul *ManagedGatewayEthernetBackhaul `protobuf:"bytes,8,opt,name=ethernet_backhaul,json=ethernetBackhaul,proto3,oneof"`
}

func (*ManagedGatewayEventData_Entity) isManagedGatewayEventData_Data() {}

func (*ManagedGatewayEventData_Location) isManagedGatewayEventData_Data() {}

func (*ManagedGatewayEventData_SystemStatus) isManagedGatewayEventData_Data() {}

func (*ManagedGatewayEventData_ControllerConnection) isManagedGatewayEventData_Data() {}

func (*ManagedGatewayEventData_GatewayServerConnection) isManagedGatewayEventData_Data() {}

func (*ManagedGatewayEventData_CellularBackhaul) isManagedGatewayEventData_Data() {}

func (*ManagedGatewayEventData_WifiBackhaul) isManagedGatewayEventData_Data() {}

func (*ManagedGatewayEventData_EthernetBackhaul) isManagedGatewayEventData_Data() {}

type ManagedGatewayWiFiProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProfileId                 string                                   `protobuf:"bytes,1,opt,name=profile_id,json=profileId,proto3" json:"profile_id,omitempty"`
	ProfileName               string                                   `protobuf:"bytes,2,opt,name=profile_name,json=profileName,proto3" json:"profile_name,omitempty"`
	Shared                    bool                                     `protobuf:"varint,6,opt,name=shared,proto3" json:"shared,omitempty"`
	Ssid                      string                                   `protobuf:"bytes,3,opt,name=ssid,proto3" json:"ssid,omitempty"`
	Password                  string                                   `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
	NetworkInterfaceAddresses *ManagedGatewayNetworkInterfaceAddresses `protobuf:"bytes,5,opt,name=network_interface_addresses,json=networkInterfaceAddresses,proto3" json:"network_interface_addresses,omitempty"`
}

func (x *ManagedGatewayWiFiProfile) Reset() {
	*x = ManagedGatewayWiFiProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewayWiFiProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewayWiFiProfile) ProtoMessage() {}

func (x *ManagedGatewayWiFiProfile) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewayWiFiProfile.ProtoReflect.Descriptor instead.
func (*ManagedGatewayWiFiProfile) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{19}
}

func (x *ManagedGatewayWiFiProfile) GetProfileId() string {
	if x != nil {
		return x.ProfileId
	}
	return ""
}

func (x *ManagedGatewayWiFiProfile) GetProfileName() string {
	if x != nil {
		return x.ProfileName
	}
	return ""
}

func (x *ManagedGatewayWiFiProfile) GetShared() bool {
	if x != nil {
		return x.Shared
	}
	return false
}

func (x *ManagedGatewayWiFiProfile) GetSsid() string {
	if x != nil {
		return x.Ssid
	}
	return ""
}

func (x *ManagedGatewayWiFiProfile) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *ManagedGatewayWiFiProfile) GetNetworkInterfaceAddresses() *ManagedGatewayNetworkInterfaceAddresses {
	if x != nil {
		return x.NetworkInterfaceAddresses
	}
	return nil
}

type ManagedGatewayWiFiProfiles struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Profiles []*ManagedGatewayWiFiProfile `protobuf:"bytes,1,rep,name=profiles,proto3" json:"profiles,omitempty"`
}

func (x *ManagedGatewayWiFiProfiles) Reset() {
	*x = ManagedGatewayWiFiProfiles{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewayWiFiProfiles) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewayWiFiProfiles) ProtoMessage() {}

func (x *ManagedGatewayWiFiProfiles) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewayWiFiProfiles.ProtoReflect.Descriptor instead.
func (*ManagedGatewayWiFiProfiles) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{20}
}

func (x *ManagedGatewayWiFiProfiles) GetProfiles() []*ManagedGatewayWiFiProfile {
	if x != nil {
		return x.Profiles
	}
	return nil
}

type ManagedGatewayEthernetProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProfileId                 string                                   `protobuf:"bytes,1,opt,name=profile_id,json=profileId,proto3" json:"profile_id,omitempty"`
	ProfileName               string                                   `protobuf:"bytes,2,opt,name=profile_name,json=profileName,proto3" json:"profile_name,omitempty"`
	Shared                    bool                                     `protobuf:"varint,4,opt,name=shared,proto3" json:"shared,omitempty"`
	NetworkInterfaceAddresses *ManagedGatewayNetworkInterfaceAddresses `protobuf:"bytes,3,opt,name=network_interface_addresses,json=networkInterfaceAddresses,proto3" json:"network_interface_addresses,omitempty"`
}

func (x *ManagedGatewayEthernetProfile) Reset() {
	*x = ManagedGatewayEthernetProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewayEthernetProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewayEthernetProfile) ProtoMessage() {}

func (x *ManagedGatewayEthernetProfile) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewayEthernetProfile.ProtoReflect.Descriptor instead.
func (*ManagedGatewayEthernetProfile) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{21}
}

func (x *ManagedGatewayEthernetProfile) GetProfileId() string {
	if x != nil {
		return x.ProfileId
	}
	return ""
}

func (x *ManagedGatewayEthernetProfile) GetProfileName() string {
	if x != nil {
		return x.ProfileName
	}
	return ""
}

func (x *ManagedGatewayEthernetProfile) GetShared() bool {
	if x != nil {
		return x.Shared
	}
	return false
}

func (x *ManagedGatewayEthernetProfile) GetNetworkInterfaceAddresses() *ManagedGatewayNetworkInterfaceAddresses {
	if x != nil {
		return x.NetworkInterfaceAddresses
	}
	return nil
}

type ManagedGatewayEthernetProfiles struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Profiles []*ManagedGatewayEthernetProfile `protobuf:"bytes,1,rep,name=profiles,proto3" json:"profiles,omitempty"`
}

func (x *ManagedGatewayEthernetProfiles) Reset() {
	*x = ManagedGatewayEthernetProfiles{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGatewayEthernetProfiles) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGatewayEthernetProfiles) ProtoMessage() {}

func (x *ManagedGatewayEthernetProfiles) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGatewayEthernetProfiles.ProtoReflect.Descriptor instead.
func (*ManagedGatewayEthernetProfiles) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{22}
}

func (x *ManagedGatewayEthernetProfiles) GetProfiles() []*ManagedGatewayEthernetProfile {
	if x != nil {
		return x.Profiles
	}
	return nil
}

type GetGatewayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds *GatewayIdentifiers `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	// The names of the gateway fields that should be returned.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetGatewayRequest) Reset() {
	*x = GetGatewayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGatewayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGatewayRequest) ProtoMessage() {}

func (x *GetGatewayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGatewayRequest.ProtoReflect.Descriptor instead.
func (*GetGatewayRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{23}
}

func (x *GetGatewayRequest) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *GetGatewayRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type GetGatewayIdentifiersForEUIRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Eui []byte `protobuf:"bytes,1,opt,name=eui,proto3" json:"eui,omitempty"`
}

func (x *GetGatewayIdentifiersForEUIRequest) Reset() {
	*x = GetGatewayIdentifiersForEUIRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGatewayIdentifiersForEUIRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGatewayIdentifiersForEUIRequest) ProtoMessage() {}

func (x *GetGatewayIdentifiersForEUIRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGatewayIdentifiersForEUIRequest.ProtoReflect.Descriptor instead.
func (*GetGatewayIdentifiersForEUIRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{24}
}

func (x *GetGatewayIdentifiersForEUIRequest) GetEui() []byte {
	if x != nil {
		return x.Eui
	}
	return nil
}

type ListGatewaysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// By default we list all gateways the caller has rights on.
	// Set the user or the organization (not both) to instead list the gateways
	// where the user or organization is collaborator on.
	Collaborator *OrganizationOrUserIdentifiers `protobuf:"bytes,1,opt,name=collaborator,proto3" json:"collaborator,omitempty"`
	// The names of the gateway fields that should be returned.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// Order the results by this field path (must be present in the field mask).
	// Default ordering is by ID. Prepend with a minus (-) to reverse the order.
	Order string `protobuf:"bytes,3,opt,name=order,proto3" json:"order,omitempty"`
	// Limit the number of results per page.
	Limit uint32 `protobuf:"varint,4,opt,name=limit,proto3" json:"limit,omitempty"`
	// Page number for pagination. 0 is interpreted as 1.
	Page uint32 `protobuf:"varint,5,opt,name=page,proto3" json:"page,omitempty"`
	// Only return recently deleted gateways.
	Deleted bool                          `protobuf:"varint,6,opt,name=deleted,proto3" json:"deleted,omitempty"`
	Filters []*ListGatewaysRequest_Filter `protobuf:"bytes,7,rep,name=filters,proto3" json:"filters,omitempty"`
}

func (x *ListGatewaysRequest) Reset() {
	*x = ListGatewaysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGatewaysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGatewaysRequest) ProtoMessage() {}

func (x *ListGatewaysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGatewaysRequest.ProtoReflect.Descriptor instead.
func (*ListGatewaysRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{25}
}

func (x *ListGatewaysRequest) GetCollaborator() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.Collaborator
	}
	return nil
}

func (x *ListGatewaysRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

func (x *ListGatewaysRequest) GetOrder() string {
	if x != nil {
		return x.Order
	}
	return ""
}

func (x *ListGatewaysRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ListGatewaysRequest) GetPage() uint32 {
	if x != nil {
		return x.Page
	}
	return 0
}

func (x *ListGatewaysRequest) GetDeleted() bool {
	if x != nil {
		return x.Deleted
	}
	return false
}

func (x *ListGatewaysRequest) GetFilters() []*ListGatewaysRequest_Filter {
	if x != nil {
		return x.Filters
	}
	return nil
}

type CreateGatewayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Gateway *Gateway `protobuf:"bytes,1,opt,name=gateway,proto3" json:"gateway,omitempty"`
	// Collaborator to grant all rights on the newly created gateway.
	Collaborator *OrganizationOrUserIdentifiers `protobuf:"bytes,2,opt,name=collaborator,proto3" json:"collaborator,omitempty"`
}

func (x *CreateGatewayRequest) Reset() {
	*x = CreateGatewayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGatewayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGatewayRequest) ProtoMessage() {}

func (x *CreateGatewayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGatewayRequest.ProtoReflect.Descriptor instead.
func (*CreateGatewayRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{26}
}

func (x *CreateGatewayRequest) GetGateway() *Gateway {
	if x != nil {
		return x.Gateway
	}
	return nil
}

func (x *CreateGatewayRequest) GetCollaborator() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.Collaborator
	}
	return nil
}

type UpdateGatewayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Gateway *Gateway `protobuf:"bytes,1,opt,name=gateway,proto3" json:"gateway,omitempty"`
	// The names of the gateway fields that should be updated.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *UpdateGatewayRequest) Reset() {
	*x = UpdateGatewayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGatewayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGatewayRequest) ProtoMessage() {}

func (x *UpdateGatewayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGatewayRequest.ProtoReflect.Descriptor instead.
func (*UpdateGatewayRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{27}
}

func (x *UpdateGatewayRequest) GetGateway() *Gateway {
	if x != nil {
		return x.Gateway
	}
	return nil
}

func (x *UpdateGatewayRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type ListGatewayAPIKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds *GatewayIdentifiers `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	// Order the results by this field path.
	// Default ordering is by ID. Prepend with a minus (-) to reverse the order.
	Order string `protobuf:"bytes,4,opt,name=order,proto3" json:"order,omitempty"`
	// Limit the number of results per page.
	Limit uint32 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	// Page number for pagination. 0 is interpreted as 1.
	Page uint32 `protobuf:"varint,3,opt,name=page,proto3" json:"page,omitempty"`
}

func (x *ListGatewayAPIKeysRequest) Reset() {
	*x = ListGatewayAPIKeysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGatewayAPIKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGatewayAPIKeysRequest) ProtoMessage() {}

func (x *ListGatewayAPIKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGatewayAPIKeysRequest.ProtoReflect.Descriptor instead.
func (*ListGatewayAPIKeysRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{28}
}

func (x *ListGatewayAPIKeysRequest) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *ListGatewayAPIKeysRequest) GetOrder() string {
	if x != nil {
		return x.Order
	}
	return ""
}

func (x *ListGatewayAPIKeysRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ListGatewayAPIKeysRequest) GetPage() uint32 {
	if x != nil {
		return x.Page
	}
	return 0
}

type GetGatewayAPIKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds *GatewayIdentifiers `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	// Unique public identifier for the API key.
	KeyId string `protobuf:"bytes,2,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
}

func (x *GetGatewayAPIKeyRequest) Reset() {
	*x = GetGatewayAPIKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGatewayAPIKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGatewayAPIKeyRequest) ProtoMessage() {}

func (x *GetGatewayAPIKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGatewayAPIKeyRequest.ProtoReflect.Descriptor instead.
func (*GetGatewayAPIKeyRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{29}
}

func (x *GetGatewayAPIKeyRequest) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *GetGatewayAPIKeyRequest) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

type CreateGatewayAPIKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds *GatewayIdentifiers    `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	Name       string                 `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Rights     []Right                `protobuf:"varint,3,rep,packed,name=rights,proto3,enum=ttn.lorawan.v3.Right" json:"rights,omitempty"`
	ExpiresAt  *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=expires_at,json=expiresAt,proto3" json:"expires_at,omitempty"`
}

func (x *CreateGatewayAPIKeyRequest) Reset() {
	*x = CreateGatewayAPIKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGatewayAPIKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGatewayAPIKeyRequest) ProtoMessage() {}

func (x *CreateGatewayAPIKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGatewayAPIKeyRequest.ProtoReflect.Descriptor instead.
func (*CreateGatewayAPIKeyRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{30}
}

func (x *CreateGatewayAPIKeyRequest) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *CreateGatewayAPIKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateGatewayAPIKeyRequest) GetRights() []Right {
	if x != nil {
		return x.Rights
	}
	return nil
}

func (x *CreateGatewayAPIKeyRequest) GetExpiresAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpiresAt
	}
	return nil
}

type UpdateGatewayAPIKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds *GatewayIdentifiers `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	ApiKey     *APIKey             `protobuf:"bytes,2,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty"`
	// The names of the api key fields that should be updated.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *UpdateGatewayAPIKeyRequest) Reset() {
	*x = UpdateGatewayAPIKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGatewayAPIKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGatewayAPIKeyRequest) ProtoMessage() {}

func (x *UpdateGatewayAPIKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGatewayAPIKeyRequest.ProtoReflect.Descriptor instead.
func (*UpdateGatewayAPIKeyRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{31}
}

func (x *UpdateGatewayAPIKeyRequest) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *UpdateGatewayAPIKeyRequest) GetApiKey() *APIKey {
	if x != nil {
		return x.ApiKey
	}
	return nil
}

func (x *UpdateGatewayAPIKeyRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type DeleteGatewayAPIKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds *GatewayIdentifiers `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	KeyId      string              `protobuf:"bytes,2,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
}

func (x *DeleteGatewayAPIKeyRequest) Reset() {
	*x = DeleteGatewayAPIKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGatewayAPIKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGatewayAPIKeyRequest) ProtoMessage() {}

func (x *DeleteGatewayAPIKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGatewayAPIKeyRequest.ProtoReflect.Descriptor instead.
func (*DeleteGatewayAPIKeyRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{32}
}

func (x *DeleteGatewayAPIKeyRequest) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *DeleteGatewayAPIKeyRequest) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

type ListGatewayCollaboratorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds *GatewayIdentifiers `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	// Limit the number of results per page.
	Limit uint32 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	// Page number for pagination. 0 is interpreted as 1.
	Page uint32 `protobuf:"varint,3,opt,name=page,proto3" json:"page,omitempty"`
	// Order the results by this field path (must be present in the field mask).
	// Default ordering is by ID. Prepend with a minus (-) to reverse the order.
	Order string `protobuf:"bytes,4,opt,name=order,proto3" json:"order,omitempty"`
}

func (x *ListGatewayCollaboratorsRequest) Reset() {
	*x = ListGatewayCollaboratorsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGatewayCollaboratorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGatewayCollaboratorsRequest) ProtoMessage() {}

func (x *ListGatewayCollaboratorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGatewayCollaboratorsRequest.ProtoReflect.Descriptor instead.
func (*ListGatewayCollaboratorsRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{33}
}

func (x *ListGatewayCollaboratorsRequest) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *ListGatewayCollaboratorsRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ListGatewayCollaboratorsRequest) GetPage() uint32 {
	if x != nil {
		return x.Page
	}
	return 0
}

func (x *ListGatewayCollaboratorsRequest) GetOrder() string {
	if x != nil {
		return x.Order
	}
	return ""
}

type GetGatewayCollaboratorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds   *GatewayIdentifiers            `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	Collaborator *OrganizationOrUserIdentifiers `protobuf:"bytes,2,opt,name=collaborator,proto3" json:"collaborator,omitempty"`
}

func (x *GetGatewayCollaboratorRequest) Reset() {
	*x = GetGatewayCollaboratorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGatewayCollaboratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGatewayCollaboratorRequest) ProtoMessage() {}

func (x *GetGatewayCollaboratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGatewayCollaboratorRequest.ProtoReflect.Descriptor instead.
func (*GetGatewayCollaboratorRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{34}
}

func (x *GetGatewayCollaboratorRequest) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *GetGatewayCollaboratorRequest) GetCollaborator() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.Collaborator
	}
	return nil
}

type SetGatewayCollaboratorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds   *GatewayIdentifiers `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	Collaborator *Collaborator       `protobuf:"bytes,2,opt,name=collaborator,proto3" json:"collaborator,omitempty"`
}

func (x *SetGatewayCollaboratorRequest) Reset() {
	*x = SetGatewayCollaboratorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetGatewayCollaboratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetGatewayCollaboratorRequest) ProtoMessage() {}

func (x *SetGatewayCollaboratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetGatewayCollaboratorRequest.ProtoReflect.Descriptor instead.
func (*SetGatewayCollaboratorRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{35}
}

func (x *SetGatewayCollaboratorRequest) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *SetGatewayCollaboratorRequest) GetCollaborator() *Collaborator {
	if x != nil {
		return x.Collaborator
	}
	return nil
}

type DeleteGatewayCollaboratorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds      *GatewayIdentifiers            `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	CollaboratorIds *OrganizationOrUserIdentifiers `protobuf:"bytes,2,opt,name=collaborator_ids,json=collaboratorIds,proto3" json:"collaborator_ids,omitempty"`
}

func (x *DeleteGatewayCollaboratorRequest) Reset() {
	*x = DeleteGatewayCollaboratorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGatewayCollaboratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGatewayCollaboratorRequest) ProtoMessage() {}

func (x *DeleteGatewayCollaboratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGatewayCollaboratorRequest.ProtoReflect.Descriptor instead.
func (*DeleteGatewayCollaboratorRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{36}
}

func (x *DeleteGatewayCollaboratorRequest) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *DeleteGatewayCollaboratorRequest) GetCollaboratorIds() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.CollaboratorIds
	}
	return nil
}

// GatewayAntenna is the message that defines a gateway antenna.
type GatewayAntenna struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Antenna gain relative to the gateway, in dBi.
	Gain float32 `protobuf:"fixed32,1,opt,name=gain,proto3" json:"gain,omitempty"`
	// location is the antenna's location.
	Location *Location `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/gateway.proto.
	Attributes map[string]string       `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Placement  GatewayAntennaPlacement `protobuf:"varint,4,opt,name=placement,proto3,enum=ttn.lorawan.v3.GatewayAntennaPlacement" json:"placement,omitempty"`
}

func (x *GatewayAntenna) Reset() {
	*x = GatewayAntenna{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayAntenna) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayAntenna) ProtoMessage() {}

func (x *GatewayAntenna) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayAntenna.ProtoReflect.Descriptor instead.
func (*GatewayAntenna) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{37}
}

func (x *GatewayAntenna) GetGain() float32 {
	if x != nil {
		return x.Gain
	}
	return 0
}

func (x *GatewayAntenna) GetLocation() *Location {
	if x != nil {
		return x.Location
	}
	return nil
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/gateway.proto.
func (x *GatewayAntenna) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *GatewayAntenna) GetPlacement() GatewayAntennaPlacement {
	if x != nil {
		return x.Placement
	}
	return GatewayAntennaPlacement_PLACEMENT_UNKNOWN
}

type GatewayStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Current time of the gateway
	Time *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// Boot time of the gateway
	// - can be left out to save bandwidth; old value will be kept
	BootTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=boot_time,json=bootTime,proto3" json:"boot_time,omitempty"`
	// Versions of gateway subsystems
	// - each field can be left out to save bandwidth; old value will be kept
	// - map keys are written in snake_case
	// - for example:
	//     firmware: "2.0.4"
	//     forwarder: "v2-3.3.1"
	//     fpga: "48"
	//     dsp: "27"
	//     hal: "v2-3.5.0"
	Versions map[string]string `protobuf:"bytes,3,rep,name=versions,proto3" json:"versions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Location of each gateway's antenna
	// - if left out, server uses registry-set location as fallback
	AntennaLocations []*Location `protobuf:"bytes,4,rep,name=antenna_locations,json=antennaLocations,proto3" json:"antenna_locations,omitempty"`
	// IP addresses of this gateway.
	// Repeated addresses can be used to communicate addresses of multiple interfaces (LAN, Public IP, ...).
	Ip []string `protobuf:"bytes,5,rep,name=ip,proto3" json:"ip,omitempty"`
	// Metrics
	// - can be used for forwarding gateway metrics such as temperatures or performance metrics
	// - map keys are written in snake_case
	Metrics map[string]float32 `protobuf:"bytes,6,rep,name=metrics,proto3" json:"metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed32,2,opt,name=value,proto3"`
	// Advanced metadata fields
	// - can be used for advanced information or experimental features that are not yet formally defined in the API
	// - field names are written in snake_case
	Advanced *structpb.Struct `protobuf:"bytes,99,opt,name=advanced,proto3" json:"advanced,omitempty"`
}

func (x *GatewayStatus) Reset() {
	*x = GatewayStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayStatus) ProtoMessage() {}

func (x *GatewayStatus) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayStatus.ProtoReflect.Descriptor instead.
func (*GatewayStatus) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{38}
}

func (x *GatewayStatus) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *GatewayStatus) GetBootTime() *timestamppb.Timestamp {
	if x != nil {
		return x.BootTime
	}
	return nil
}

func (x *GatewayStatus) GetVersions() map[string]string {
	if x != nil {
		return x.Versions
	}
	return nil
}

func (x *GatewayStatus) GetAntennaLocations() []*Location {
	if x != nil {
		return x.AntennaLocations
	}
	return nil
}

func (x *GatewayStatus) GetIp() []string {
	if x != nil {
		return x.Ip
	}
	return nil
}

func (x *GatewayStatus) GetMetrics() map[string]float32 {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *GatewayStatus) GetAdvanced() *structpb.Struct {
	if x != nil {
		return x.Advanced
	}
	return nil
}

// Remote Address of the Gateway, as seen by the Gateway Server.
type GatewayRemoteAddress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ip string `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"` // IPv4 or IPv6 address.
}

func (x *GatewayRemoteAddress) Reset() {
	*x = GatewayRemoteAddress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayRemoteAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayRemoteAddress) ProtoMessage() {}

func (x *GatewayRemoteAddress) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayRemoteAddress.ProtoReflect.Descriptor instead.
func (*GatewayRemoteAddress) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{39}
}

func (x *GatewayRemoteAddress) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

// Connection stats as monitored by the Gateway Server.
type GatewayConnectionStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectedAt                    *timestamppb.Timestamp                 `protobuf:"bytes,1,opt,name=connected_at,json=connectedAt,proto3" json:"connected_at,omitempty"`
	DisconnectedAt                 *timestamppb.Timestamp                 `protobuf:"bytes,11,opt,name=disconnected_at,json=disconnectedAt,proto3" json:"disconnected_at,omitempty"`
	Protocol                       string                                 `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"` // Protocol used to connect (for example, udp, mqtt, grpc)
	LastStatusReceivedAt           *timestamppb.Timestamp                 `protobuf:"bytes,3,opt,name=last_status_received_at,json=lastStatusReceivedAt,proto3" json:"last_status_received_at,omitempty"`
	LastStatus                     *GatewayStatus                         `protobuf:"bytes,4,opt,name=last_status,json=lastStatus,proto3" json:"last_status,omitempty"`
	LastUplinkReceivedAt           *timestamppb.Timestamp                 `protobuf:"bytes,5,opt,name=last_uplink_received_at,json=lastUplinkReceivedAt,proto3" json:"last_uplink_received_at,omitempty"`
	UplinkCount                    uint64                                 `protobuf:"varint,6,opt,name=uplink_count,json=uplinkCount,proto3" json:"uplink_count,omitempty"`
	LastDownlinkReceivedAt         *timestamppb.Timestamp                 `protobuf:"bytes,7,opt,name=last_downlink_received_at,json=lastDownlinkReceivedAt,proto3" json:"last_downlink_received_at,omitempty"`
	DownlinkCount                  uint64                                 `protobuf:"varint,8,opt,name=downlink_count,json=downlinkCount,proto3" json:"downlink_count,omitempty"`
	LastTxAcknowledgmentReceivedAt *timestamppb.Timestamp                 `protobuf:"bytes,13,opt,name=last_tx_acknowledgment_received_at,json=lastTxAcknowledgmentReceivedAt,proto3" json:"last_tx_acknowledgment_received_at,omitempty"`
	TxAcknowledgmentCount          uint64                                 `protobuf:"varint,14,opt,name=tx_acknowledgment_count,json=txAcknowledgmentCount,proto3" json:"tx_acknowledgment_count,omitempty"`
	RoundTripTimes                 *GatewayConnectionStats_RoundTripTimes `protobuf:"bytes,9,opt,name=round_trip_times,json=roundTripTimes,proto3" json:"round_trip_times,omitempty"`
	// Statistics for each sub band.
	SubBands []*GatewayConnectionStats_SubBand `protobuf:"bytes,10,rep,name=sub_bands,json=subBands,proto3" json:"sub_bands,omitempty"`
	// Gateway Remote Address.
	GatewayRemoteAddress *GatewayRemoteAddress `protobuf:"bytes,12,opt,name=gateway_remote_address,json=gatewayRemoteAddress,proto3" json:"gateway_remote_address,omitempty"`
}

func (x *GatewayConnectionStats) Reset() {
	*x = GatewayConnectionStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayConnectionStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayConnectionStats) ProtoMessage() {}

func (x *GatewayConnectionStats) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayConnectionStats.ProtoReflect.Descriptor instead.
func (*GatewayConnectionStats) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{40}
}

func (x *GatewayConnectionStats) GetConnectedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ConnectedAt
	}
	return nil
}

func (x *GatewayConnectionStats) GetDisconnectedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.DisconnectedAt
	}
	return nil
}

func (x *GatewayConnectionStats) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *GatewayConnectionStats) GetLastStatusReceivedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastStatusReceivedAt
	}
	return nil
}

func (x *GatewayConnectionStats) GetLastStatus() *GatewayStatus {
	if x != nil {
		return x.LastStatus
	}
	return nil
}

func (x *GatewayConnectionStats) GetLastUplinkReceivedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUplinkReceivedAt
	}
	return nil
}

func (x *GatewayConnectionStats) GetUplinkCount() uint64 {
	if x != nil {
		return x.UplinkCount
	}
	return 0
}

func (x *GatewayConnectionStats) GetLastDownlinkReceivedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastDownlinkReceivedAt
	}
	return nil
}

func (x *GatewayConnectionStats) GetDownlinkCount() uint64 {
	if x != nil {
		return x.DownlinkCount
	}
	return 0
}

func (x *GatewayConnectionStats) GetLastTxAcknowledgmentReceivedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastTxAcknowledgmentReceivedAt
	}
	return nil
}

func (x *GatewayConnectionStats) GetTxAcknowledgmentCount() uint64 {
	if x != nil {
		return x.TxAcknowledgmentCount
	}
	return 0
}

func (x *GatewayConnectionStats) GetRoundTripTimes() *GatewayConnectionStats_RoundTripTimes {
	if x != nil {
		return x.RoundTripTimes
	}
	return nil
}

func (x *GatewayConnectionStats) GetSubBands() []*GatewayConnectionStats_SubBand {
	if x != nil {
		return x.SubBands
	}
	return nil
}

func (x *GatewayConnectionStats) GetGatewayRemoteAddress() *GatewayRemoteAddress {
	if x != nil {
		return x.GatewayRemoteAddress
	}
	return nil
}

type GatewayRadio_TxConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinFrequency   uint64 `protobuf:"varint,1,opt,name=min_frequency,json=minFrequency,proto3" json:"min_frequency,omitempty"`
	MaxFrequency   uint64 `protobuf:"varint,2,opt,name=max_frequency,json=maxFrequency,proto3" json:"max_frequency,omitempty"`
	NotchFrequency uint64 `protobuf:"varint,3,opt,name=notch_frequency,json=notchFrequency,proto3" json:"notch_frequency,omitempty"`
}

func (x *GatewayRadio_TxConfiguration) Reset() {
	*x = GatewayRadio_TxConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayRadio_TxConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayRadio_TxConfiguration) ProtoMessage() {}

func (x *GatewayRadio_TxConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayRadio_TxConfiguration.ProtoReflect.Descriptor instead.
func (*GatewayRadio_TxConfiguration) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{3, 0}
}

func (x *GatewayRadio_TxConfiguration) GetMinFrequency() uint64 {
	if x != nil {
		return x.MinFrequency
	}
	return 0
}

func (x *GatewayRadio_TxConfiguration) GetMaxFrequency() uint64 {
	if x != nil {
		return x.MaxFrequency
	}
	return 0
}

func (x *GatewayRadio_TxConfiguration) GetNotchFrequency() uint64 {
	if x != nil {
		return x.NotchFrequency
	}
	return 0
}

// LR-FHSS gateway capabilities.
type Gateway_LRFHSS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The gateway supports the LR-FHSS uplink channels.
	Supported bool `protobuf:"varint,1,opt,name=supported,proto3" json:"supported,omitempty"`
}

func (x *Gateway_LRFHSS) Reset() {
	*x = Gateway_LRFHSS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Gateway_LRFHSS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Gateway_LRFHSS) ProtoMessage() {}

func (x *Gateway_LRFHSS) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Gateway_LRFHSS.ProtoReflect.Descriptor instead.
func (*Gateway_LRFHSS) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{5, 1}
}

func (x *Gateway_LRFHSS) GetSupported() bool {
	if x != nil {
		return x.Supported
	}
	return false
}

// Filter gateways by fields.
type ListGatewaysRequest_Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Field:
	//	*ListGatewaysRequest_Filter_UpdatedSince
	Field isListGatewaysRequest_Filter_Field `protobuf_oneof:"field"`
}

func (x *ListGatewaysRequest_Filter) Reset() {
	*x = ListGatewaysRequest_Filter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGatewaysRequest_Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGatewaysRequest_Filter) ProtoMessage() {}

func (x *ListGatewaysRequest_Filter) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGatewaysRequest_Filter.ProtoReflect.Descriptor instead.
func (*ListGatewaysRequest_Filter) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{25, 0}
}

func (m *ListGatewaysRequest_Filter) GetField() isListGatewaysRequest_Filter_Field {
	if m != nil {
		return m.Field
	}
	return nil
}

func (x *ListGatewaysRequest_Filter) GetUpdatedSince() *timestamppb.Timestamp {
	if x, ok := x.GetField().(*ListGatewaysRequest_Filter_UpdatedSince); ok {
		return x.UpdatedSince
	}
	return nil
}

type isListGatewaysRequest_Filter_Field interface {
	isListGatewaysRequest_Filter_Field()
}

type ListGatewaysRequest_Filter_UpdatedSince struct {
	UpdatedSince *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=updated_since,json=updatedSince,proto3,oneof"`
}

func (*ListGatewaysRequest_Filter_UpdatedSince) isListGatewaysRequest_Filter_Field() {}

type GatewayConnectionStats_RoundTripTimes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Min    *durationpb.Duration `protobuf:"bytes,1,opt,name=min,proto3" json:"min,omitempty"`
	Max    *durationpb.Duration `protobuf:"bytes,2,opt,name=max,proto3" json:"max,omitempty"`
	Median *durationpb.Duration `protobuf:"bytes,3,opt,name=median,proto3" json:"median,omitempty"`
	Count  uint32               `protobuf:"varint,4,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *GatewayConnectionStats_RoundTripTimes) Reset() {
	*x = GatewayConnectionStats_RoundTripTimes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayConnectionStats_RoundTripTimes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayConnectionStats_RoundTripTimes) ProtoMessage() {}

func (x *GatewayConnectionStats_RoundTripTimes) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayConnectionStats_RoundTripTimes.ProtoReflect.Descriptor instead.
func (*GatewayConnectionStats_RoundTripTimes) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{40, 0}
}

func (x *GatewayConnectionStats_RoundTripTimes) GetMin() *durationpb.Duration {
	if x != nil {
		return x.Min
	}
	return nil
}

func (x *GatewayConnectionStats_RoundTripTimes) GetMax() *durationpb.Duration {
	if x != nil {
		return x.Max
	}
	return nil
}

func (x *GatewayConnectionStats_RoundTripTimes) GetMedian() *durationpb.Duration {
	if x != nil {
		return x.Median
	}
	return nil
}

func (x *GatewayConnectionStats_RoundTripTimes) GetCount() uint32 {
	if x != nil {
		return x.Count
	}
	return 0
}

type GatewayConnectionStats_SubBand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinFrequency uint64 `protobuf:"varint,1,opt,name=min_frequency,json=minFrequency,proto3" json:"min_frequency,omitempty"`
	MaxFrequency uint64 `protobuf:"varint,2,opt,name=max_frequency,json=maxFrequency,proto3" json:"max_frequency,omitempty"`
	// Duty-cycle limit of the sub-band as a fraction of time.
	DownlinkUtilizationLimit float32 `protobuf:"fixed32,3,opt,name=downlink_utilization_limit,json=downlinkUtilizationLimit,proto3" json:"downlink_utilization_limit,omitempty"`
	// Utilization rate of the available duty-cycle. This value should not exceed downlink_utilization_limit.
	DownlinkUtilization float32 `protobuf:"fixed32,4,opt,name=downlink_utilization,json=downlinkUtilization,proto3" json:"downlink_utilization,omitempty"`
}

func (x *GatewayConnectionStats_SubBand) Reset() {
	*x = GatewayConnectionStats_SubBand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayConnectionStats_SubBand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayConnectionStats_SubBand) ProtoMessage() {}

func (x *GatewayConnectionStats_SubBand) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_gateway_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayConnectionStats_SubBand.ProtoReflect.Descriptor instead.
func (*GatewayConnectionStats_SubBand) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_gateway_proto_rawDescGZIP(), []int{40, 1}
}

func (x *GatewayConnectionStats_SubBand) GetMinFrequency() uint64 {
	if x != nil {
		return x.MinFrequency
	}
	return 0
}

func (x *GatewayConnectionStats_SubBand) GetMaxFrequency() uint64 {
	if x != nil {
		return x.MaxFrequency
	}
	return 0
}

func (x *GatewayConnectionStats_SubBand) GetDownlinkUtilizationLimit() float32 {
	if x != nil {
		return x.DownlinkUtilizationLimit
	}
	return 0
}

func (x *GatewayConnectionStats_SubBand) GetDownlinkUtilization() float32 {
	if x != nil {
		return x.DownlinkUtilization
	}
	return 0
}

var File_ttn_lorawan_v3_gateway_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_gateway_proto_rawDesc = []byte{
	0x0a, 0x1c, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e,
	0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x21, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x6a, 0x73,
	0x6f, 0x6e, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2f, 0x76, 0x33, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1c, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76,
	0x33, 0x2f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5a, 0x0a, 0x0c, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x14,
	0x0a, 0x05, 0x6c, 0x6f, 0x67, 0x6f, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x6c,
	0x6f, 0x67, 0x6f, 0x73, 0x22, 0xa5, 0x01, 0x0a, 0x0c, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x45, 0x0a, 0x08, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x42, 0x27, 0x72, 0x25, 0x18, 0x24,
	0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d,
	0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24,
	0xd0, 0x01, 0x01, 0x52, 0x07, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x42, 0x27, 0x72, 0x25, 0x18,
	0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b,
	0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d,
	0x24, 0xd0, 0x01, 0x01, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcd, 0x02, 0x0a,
	0x19, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x45, 0x0a, 0x08, 0x62, 0x72,
	0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x42,
	0x27, 0x72, 0x25, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d,
	0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29,
	0x7b, 0x32, 0x2c, 0x7d, 0x24, 0xd0, 0x01, 0x01, 0x52, 0x07, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x49,
	0x64, 0x12, 0x45, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x42, 0x27, 0x72, 0x25, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b,
	0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61,
	0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0xd0, 0x01, 0x01, 0x52,
	0x07, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x10, 0x68, 0x61, 0x72, 0x64,
	0x77, 0x61, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x20, 0x52, 0x0f, 0x68, 0x61, 0x72,
	0x64, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x10,
	0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x20, 0x52,
	0x0f, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x30, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02,
	0x18, 0x20, 0x52, 0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0xe2, 0x02, 0x0a,
	0x0c, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x61, 0x64, 0x69, 0x6f, 0x12, 0x16, 0x0a,
	0x06, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x68, 0x69, 0x70, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x68, 0x69, 0x70, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x73, 0x73, 0x69, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x72, 0x73, 0x73, 0x69, 0x4f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x12, 0x57, 0x0a, 0x10, 0x74, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x52, 0x61, 0x64, 0x69, 0x6f, 0x2e, 0x54, 0x78, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x74, 0x78, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x84, 0x01, 0x0a, 0x0f, 0x54,
	0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23,
	0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x46,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x6e, 0x6f, 0x74, 0x63,
	0x68, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0e, 0x6e, 0x6f, 0x74, 0x63, 0x68, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x22, 0xcc, 0x01, 0x0a, 0x1e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6c, 0x61,
	0x69, 0x6d, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x2e, 0x0a, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x06, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x66, 0x72,
	0x6f, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x12,
	0x35, 0x0a, 0x08, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x54, 0x6f, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01,
	0x22, 0xb9, 0x12, 0x0a, 0x07, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x46, 0x0a, 0x03,
	0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x10, 0xfa,
	0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x28, 0x01, 0x52,
	0x03, 0x69, 0x64, 0x73, 0x12, 0x43, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x00, 0x52, 0x09,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x43, 0x0a, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08,
	0x00, 0x10, 0x00, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x43,
	0x0a, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x1a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x08,
	0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x00, 0x52, 0x09, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x41, 0x74, 0x12, 0x1b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x32, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x2a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x18, 0xd0, 0x0f, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7e, 0x0a, 0x0a,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x35, 0xfa, 0x42, 0x32, 0x9a, 0x01,
	0x2f, 0x10, 0x0a, 0x22, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a,
	0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30,
	0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x2a, 0x05, 0x72, 0x03, 0x18, 0xc8, 0x01,
	0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x0c,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42,
	0x0a, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x0a, 0x18, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x64, 0x0a, 0x16, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x15, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x12, 0x5a,
	0x0a, 0x11, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x10, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x69,
	0x63, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x12, 0x4a, 0x0a, 0x0b, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0xd5, 0x01, 0x0a, 0x16, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x9e, 0x01, 0xfa, 0x42, 0x9a, 0x01, 0x72, 0x97,
	0x01, 0x32, 0x94, 0x01, 0x5e, 0x28, 0x5b, 0x61, 0x2d, 0x7a, 0x5d, 0x7b, 0x32, 0x2c, 0x35, 0x7d,
	0x3a, 0x2f, 0x2f, 0x29, 0x3f, 0x28, 0x3f, 0x3a, 0x28, 0x3f, 0x3a, 0x5b, 0x61, 0x2d, 0x7a, 0x41,
	0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x7c, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d,
	0x39, 0x5d, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5c, 0x2d, 0x5d, 0x2a,
	0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x5c, 0x2e, 0x29, 0x2a,
	0x28, 0x3f, 0x3a, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x7c, 0x5b,
	0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d,
	0x7a, 0x30, 0x2d, 0x39, 0x5c, 0x2d, 0x5d, 0x2a, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30,
	0x2d, 0x39, 0x5d, 0x29, 0x28, 0x3f, 0x3a, 0x3a, 0x5b, 0x30, 0x2d, 0x39, 0x5d, 0x7b, 0x31, 0x2c,
	0x35, 0x7d, 0x29, 0x3f, 0x24, 0x7c, 0x5e, 0x24, 0x52, 0x14, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1f,
	0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12,
	0x2f, 0x0a, 0x0e, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x18, 0x80,
	0x01, 0x52, 0x0d, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x12, 0x33, 0x0a, 0x11, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x70, 0x6c,
	0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04,
	0x72, 0x02, 0x18, 0x40, 0x52, 0x0f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x50,
	0x6c, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x3c, 0x0a, 0x12, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x0e, 0xfa, 0x42, 0x0b, 0x92, 0x01, 0x08, 0x10, 0x08, 0x22, 0x04, 0x72, 0x02, 0x18,
	0x40, 0x52, 0x10, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x6c, 0x61, 0x6e,
	0x49, 0x64, 0x73, 0x12, 0x44, 0x0a, 0x08, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x73, 0x18,
	0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x6e,
	0x74, 0x65, 0x6e, 0x6e, 0x61, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x08, 0x52,
	0x08, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x12, 0x27,
	0x0a, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x12, 0x34, 0x0a, 0x16, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6c, 0x61, 0x74,
	0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x4c, 0x61, 0x74, 0x65, 0x12, 0x2c, 0x0a,
	0x12, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x75, 0x74, 0x79, 0x5f, 0x63, 0x79,
	0x63, 0x6c, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x65, 0x6e, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x44, 0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x6a, 0x0a, 0x18, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x16, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x43, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x16, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x5f, 0x61, 0x6e, 0x79, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x61,
	0x79, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x14, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x41, 0x6e, 0x79, 0x74,
	0x69, 0x6d, 0x65, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x3d, 0x0a, 0x1b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x6f, 0x6d,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x72, 0x6f,
	0x6d, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x3c, 0x0a, 0x0e, 0x6c, 0x62, 0x73, 0x5f, 0x6c,
	0x6e, 0x73, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x0c, 0x6c, 0x62, 0x73, 0x4c, 0x6e, 0x73, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x6a, 0x0a, 0x19, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x5f, 0x61,
	0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x17, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x41,
	0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x33, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x75, 0x70, 0x73,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72,
	0x06, 0xd0, 0x01, 0x01, 0x88, 0x01, 0x01, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43,
	0x75, 0x70, 0x73, 0x55, 0x72, 0x69, 0x12, 0x3e, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x63, 0x75, 0x70, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43,
	0x75, 0x70, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x48, 0x0a, 0x20, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x1e, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x36, 0x0a, 0x06, 0x6c, 0x72, 0x66, 0x68, 0x73, 0x73, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x4c, 0x52, 0x46, 0x48, 0x53, 0x53,
	0x52, 0x06, 0x6c, 0x72, 0x66, 0x68, 0x73, 0x73, 0x12, 0x47, 0x0a, 0x20, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x62, 0x72, 0x6f, 0x6b, 0x65,
	0x72, 0x5f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x1d, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x1d, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x65,
	0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x1a, 0x3d, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x30, 0x0a, 0x06, 0x4c, 0x52, 0x46, 0x48, 0x53, 0x53, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01,
	0x10, 0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0x3f, 0x0a, 0x08,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x12, 0x33, 0x0a, 0x08, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x52, 0x08, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x22, 0xdc, 0x06,
	0x0a, 0x0e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x12, 0x46, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x42, 0x10, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0xf2, 0xaa, 0x19, 0x04, 0x08,
	0x00, 0x28, 0x01, 0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x4a, 0x0a, 0x0b, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x73, 0x12, 0x3a, 0x0a, 0x0d, 0x63, 0x65, 0x6c, 0x6c, 0x75, 0x6c, 0x61, 0x72,
	0x5f, 0x69, 0x6d, 0x65, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x15, 0xfa, 0x42, 0x12,
	0x72, 0x10, 0x32, 0x0b, 0x5e, 0x5b, 0x30, 0x2d, 0x39, 0x5d, 0x7b, 0x31, 0x35, 0x7d, 0x24, 0xd0,
	0x01, 0x01, 0x52, 0x0c, 0x63, 0x65, 0x6c, 0x6c, 0x75, 0x6c, 0x61, 0x72, 0x49, 0x6d, 0x65, 0x69,
	0x12, 0x3a, 0x0a, 0x0d, 0x63, 0x65, 0x6c, 0x6c, 0x75, 0x6c, 0x61, 0x72, 0x5f, 0x69, 0x6d, 0x73,
	0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x15, 0xfa, 0x42, 0x12, 0x72, 0x10, 0x32, 0x0b,
	0x5e, 0x5b, 0x30, 0x2d, 0x39, 0x5d, 0x7b, 0x31, 0x35, 0x7d, 0x24, 0xd0, 0x01, 0x01, 0x52, 0x0c,
	0x63, 0x65, 0x6c, 0x6c, 0x75, 0x6c, 0x61, 0x72, 0x49, 0x6d, 0x73, 0x69, 0x12, 0xdb, 0x01, 0x0a,
	0x10, 0x77, 0x69, 0x66, 0x69, 0x5f, 0x6d, 0x61, 0x63, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xb0, 0x01, 0x92, 0x41, 0x1d, 0x4a, 0x0e, 0x22,
	0x45, 0x43, 0x36, 0x35, 0x36, 0x45, 0x30, 0x30, 0x30, 0x31, 0x30, 0x30, 0x22, 0x9a, 0x02, 0x01,
	0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68,
	0x06, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65,
	0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f,
	0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61,
	0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68,
	0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33,
	0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72,
	0x73, 0x68, 0x61, 0x6c, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x0e, 0x77, 0x69, 0x66, 0x69,
	0x4d, 0x61, 0x63, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0xe3, 0x01, 0x0a, 0x14, 0x65,
	0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x5f, 0x6d, 0x61, 0x63, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xb0, 0x01, 0x92, 0x41, 0x1d, 0x4a,
	0x0e, 0x22, 0x45, 0x43, 0x36, 0x35, 0x36, 0x45, 0x30, 0x30, 0x30, 0x31, 0x30, 0x30, 0x22, 0x9a,
	0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a,
	0x04, 0x68, 0x06, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76,
	0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73,
	0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e,
	0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f,
	0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d,
	0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x12, 0x65, 0x74,
	0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x4d, 0x61, 0x63, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x33, 0x0a, 0x0f, 0x77, 0x69, 0x66, 0x69, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72, 0x06,
	0xd0, 0x01, 0x01, 0xb0, 0x01, 0x01, 0x52, 0x0d, 0x77, 0x69, 0x66, 0x69, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x13, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72, 0x06, 0xd0, 0x01, 0x01, 0xb0, 0x01, 0x01, 0x52,
	0x11, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x49, 0x64, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0xec, 0x02, 0x0a,
	0x1d, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x57,
	0x69, 0x46, 0x69, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x04, 0x73, 0x73, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42,
	0x04, 0x72, 0x02, 0x18, 0x20, 0x52, 0x04, 0x73, 0x73, 0x69, 0x64, 0x12, 0xc5, 0x01, 0x0a, 0x05,
	0x62, 0x73, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xae, 0x01, 0x92, 0x41,
	0x1d, 0x4a, 0x0e, 0x22, 0x45, 0x43, 0x36, 0x35, 0x36, 0x45, 0x30, 0x30, 0x30, 0x31, 0x30, 0x30,
	0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42,
	0x04, 0x7a, 0x02, 0x68, 0x06, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74,
	0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76,
	0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73,
	0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e,
	0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f,
	0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d,
	0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x05, 0x62, 0x73,
	0x73, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x28, 0x01, 0x52, 0x07, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e,
	0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x73, 0x73, 0x69, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04, 0x72, 0x73, 0x73, 0x69, 0x22, 0x74, 0x0a, 0x1e, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x57, 0x69, 0x46,
	0x69, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x52, 0x0a,
	0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x57, 0x69, 0x46, 0x69, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f,
	0x69, 0x6e, 0x74, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x22, 0xf2, 0x02, 0x0a, 0x27, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x5e, 0x0a,
	0x0c, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x3b, 0x92, 0x41, 0x2a, 0x4a, 0x1b, 0x5b, 0x22, 0x31, 0x39, 0x32, 0x2e,
	0x30, 0x2e, 0x32, 0x2e, 0x30, 0x22, 0x2c, 0x22, 0x32, 0x30, 0x30, 0x31, 0x3a, 0x64, 0x62, 0x38,
	0x3a, 0x3a, 0x31, 0x22, 0x5d, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0xfa, 0x42, 0x0b, 0x92, 0x01, 0x08, 0x10, 0x02, 0x22, 0x04, 0x72, 0x02, 0x70, 0x01,
	0x52, 0x0b, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x48, 0x0a,
	0x0b, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0x92, 0x41, 0x1a, 0x4a, 0x0b, 0x22, 0x31, 0x39, 0x32, 0x2e, 0x30, 0x2e,
	0x32, 0x2e, 0x30, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0xfa, 0x42, 0x07, 0x72, 0x05, 0xd0, 0x01, 0x01, 0x78, 0x01, 0x52, 0x0a, 0x73, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x41, 0x0a, 0x07, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0x92, 0x41, 0x1a, 0x4a, 0x0b, 0x22,
	0x31, 0x39, 0x32, 0x2e, 0x30, 0x2e, 0x32, 0x2e, 0x30, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02,
	0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x07, 0x72, 0x05, 0xd0, 0x01, 0x01, 0x78,
	0x01, 0x52, 0x07, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x5a, 0x0a, 0x0b, 0x64, 0x6e,
	0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x39, 0x92, 0x41, 0x28, 0x4a, 0x19, 0x5b, 0x22, 0x31, 0x39, 0x32, 0x2e, 0x30, 0x2e, 0x32, 0x2e,
	0x30, 0x22, 0x2c, 0x22, 0x31, 0x39, 0x32, 0x2e, 0x30, 0x2e, 0x32, 0x2e, 0x31, 0x22, 0x5d, 0x9a,
	0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x0b, 0x92,
	0x01, 0x08, 0x10, 0x02, 0x22, 0x04, 0x72, 0x02, 0x78, 0x01, 0x52, 0x0a, 0x64, 0x6e, 0x73, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x22, 0x62, 0x0a, 0x1a, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x44, 0x0a, 0x0f, 0x63, 0x70, 0x75, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x63, 0x70, 0x75, 0x54,
	0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x98, 0x01, 0x0a, 0x22, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x72, 0x0a, 0x16, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x14, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0xb5, 0x01, 0x0a, 0x25, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x72, 0x0a, 0x16, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x14, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0xf6, 0x01,
	0x0a, 0x22, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x56, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x68, 0x63, 0x70, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0b, 0x64, 0x68, 0x63, 0x70, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12,
	0x55, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61,
	0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x09, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x22, 0xd7, 0x01, 0x0a, 0x1e, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x65, 0x6c, 0x6c, 0x75, 0x6c, 0x61,
	0x72, 0x42, 0x61, 0x63, 0x6b, 0x68, 0x61, 0x75, 0x6c, 0x12, 0x5f, 0x0a, 0x11, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x10, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x08, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42,
	0x04, 0x72, 0x02, 0x18, 0x20, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12,
	0x2f, 0x0a, 0x04, 0x72, 0x73, 0x73, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x72, 0x73, 0x73, 0x69,
	0x22, 0xe7, 0x03, 0x0a, 0x1a, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x57, 0x69, 0x46, 0x69, 0x42, 0x61, 0x63, 0x6b, 0x68, 0x61, 0x75, 0x6c, 0x12,
	0x5f, 0x0a, 0x11, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x10,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65,
	0x12, 0x1b, 0x0a, 0x04, 0x73, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07,
	0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x20, 0x52, 0x04, 0x73, 0x73, 0x69, 0x64, 0x12, 0xc5, 0x01,
	0x0a, 0x05, 0x62, 0x73, 0x73, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xae, 0x01,
	0x92, 0x41, 0x1d, 0x4a, 0x0e, 0x22, 0x45, 0x43, 0x36, 0x35, 0x36, 0x45, 0x30, 0x30, 0x30, 0x31,
	0x30, 0x30, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0xfa, 0x42, 0x04, 0x7a, 0x02, 0x68, 0x06, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f,
	0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61,
	0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67,
	0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55,
	0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x36, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x05,
	0x62, 0x73, 0x73, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x28, 0x01, 0x52,
	0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68,
	0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x2f, 0x0a, 0x04, 0x72, 0x73, 0x73,
	0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x72, 0x73, 0x73, 0x69, 0x22, 0x81, 0x01, 0x0a, 0x1e, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x45, 0x74, 0x68,
	0x65, 0x72, 0x6e, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x68, 0x61, 0x75, 0x6c, 0x12, 0x5f, 0x0a,
	0x11, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x10, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x22, 0xd7,
	0x05, 0x0a, 0x17, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x38, 0x0a, 0x06, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x48, 0x00, 0x52, 0x06, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x12, 0x36, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0d,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48,
	0x00, 0x52, 0x0c, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x69, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x73, 0x0a, 0x19, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x17, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5d, 0x0a, 0x11, 0x63, 0x65, 0x6c, 0x6c, 0x75, 0x6c, 0x61, 0x72, 0x5f, 0x62, 0x61, 0x63, 0x6b,
	0x68, 0x61, 0x75, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x65, 0x6c, 0x6c, 0x75, 0x6c,
	0x61, 0x72, 0x42, 0x61, 0x63, 0x6b, 0x68, 0x61, 0x75, 0x6c, 0x48, 0x00, 0x52, 0x10, 0x63, 0x65,
	0x6c, 0x6c, 0x75, 0x6c, 0x61, 0x72, 0x42, 0x61, 0x63, 0x6b, 0x68, 0x61, 0x75, 0x6c, 0x12, 0x51,
	0x0a, 0x0d, 0x77, 0x69, 0x66, 0x69, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x68, 0x61, 0x75, 0x6c, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x57, 0x69, 0x46, 0x69, 0x42, 0x61, 0x63, 0x6b, 0x68, 0x61, 0x75,
	0x6c, 0x48, 0x00, 0x52, 0x0c, 0x77, 0x69, 0x66, 0x69, 0x42, 0x61, 0x63, 0x6b, 0x68, 0x61, 0x75,
	0x6c, 0x12, 0x5d, 0x0a, 0x11, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x5f, 0x62, 0x61,
	0x63, 0x6b, 0x68, 0x61, 0x75, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x45, 0x74, 0x68, 0x65,
	0x72, 0x6e, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x68, 0x61, 0x75, 0x6c, 0x48, 0x00, 0x52, 0x10,
	0x65, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x68, 0x61, 0x75, 0x6c,
	0x42, 0x06, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0xd0, 0x02, 0x0a, 0x19, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x57, 0x69, 0x46, 0x69, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72,
	0x06, 0xd0, 0x01, 0x01, 0xb0, 0x01, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x49, 0x64, 0x12, 0x2a, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18,
	0x20, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x12, 0x1b, 0x0a, 0x04, 0x73, 0x73, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x20, 0x52, 0x04, 0x73,
	0x73, 0x69, 0x64, 0x12, 0x23, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x40, 0x52, 0x08,
	0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x77, 0x0a, 0x1b, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x19, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0x63, 0x0a, 0x1a, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x57, 0x69, 0x46,
	0x69, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x08, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x57, 0x69, 0x46, 0x69, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x22, 0x92, 0x02, 0x0a, 0x1d, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x45, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72, 0x06, 0xd0, 0x01, 0x01,
	0xb0, 0x01, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x2a,
	0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x20, 0x52, 0x0b, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x12, 0x77, 0x0a, 0x1b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73,
	0x52, 0x19, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61,
	0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x3a, 0x08, 0xf2, 0xaa, 0x19,
	0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0x6b, 0x0a, 0x1e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x45, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x45, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x65,
	0x74, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x73, 0x22, 0x9d, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0xee, 0x01, 0x0a, 0x22, 0x47, 0x65, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x46, 0x6f, 0x72, 0x45,
	0x55, 0x49, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0xc7, 0x01, 0x0a, 0x03, 0x65, 0x75,
	0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xb4, 0x01, 0x92, 0x41, 0x21, 0x4a, 0x12, 0x22,
	0x37, 0x30, 0x42, 0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30, 0x41, 0x42, 0x43, 0x44,
	0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42,
	0x06, 0x7a, 0x04, 0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f,
	0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61,
	0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67,
	0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55,
	0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x03,
	0x65, 0x75, 0x69, 0x22, 0xa2, 0x04, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0c, 0x63,
	0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73,
	0x42, 0x06, 0xf2, 0xaa, 0x19, 0x02, 0x28, 0x01, 0x52, 0x0c, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62,
	0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x12, 0x77, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x61, 0xfa, 0x42, 0x5e, 0x72, 0x5c, 0x52, 0x00, 0x52, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x5f, 0x69, 0x64, 0x52, 0x0b, 0x2d, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f,
	0x69, 0x64, 0x52, 0x0b, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x65, 0x75, 0x69, 0x52,
	0x0c, 0x2d, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x65, 0x75, 0x69, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x52, 0x05, 0x2d, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x52, 0x0b, 0x2d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x61, 0x74, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x05, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03,
	0x18, 0xe8, 0x07, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61,
	0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x61, 0x67, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x44, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x5e,
	0x0a, 0x06, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4b, 0x0a, 0x0d, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0xb2, 0x01, 0x02, 0x38, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64,
	0x53, 0x69, 0x6e, 0x63, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x3a, 0x08,
	0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x01, 0x22, 0xb0, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3b, 0x0a, 0x07, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x07, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x5b,
	0x0a, 0x0c, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x63,
	0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0x8e, 0x01, 0x0a, 0x14,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x07, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x07, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x9f, 0x02, 0x0a,
	0x19, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x50, 0x49, 0x4b,
	0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12, 0x75, 0x0a, 0x05, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x5f, 0xfa, 0x42, 0x5c, 0x72, 0x5a, 0x52,
	0x00, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x52, 0x0b, 0x2d,
	0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x52, 0x05, 0x2d, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x61, 0x74, 0x52, 0x0b, 0x2d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74,
	0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x61, 0x74, 0x52, 0x0b, 0x2d, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x61, 0x74, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x12, 0x1e, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xe8, 0x07, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04,
	0x70, 0x61, 0x67, 0x65, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x01, 0x22, 0x7f,
	0x0a, 0x17, 0x47, 0x65, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x50, 0x49, 0x4b,
	0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12, 0x15, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x64, 0x22,
	0x8f, 0x02, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x41, 0x50, 0x49, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d,
	0x0a, 0x0b, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12, 0x1b, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04,
	0x72, 0x02, 0x18, 0x32, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x06, 0x72, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x69, 0x67, 0x68,
	0x74, 0x42, 0x11, 0xfa, 0x42, 0x0e, 0x92, 0x01, 0x0b, 0x08, 0x01, 0x18, 0x01, 0x22, 0x05, 0x82,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x06, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0x43, 0x0a, 0x0a,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0xb2, 0x01, 0x02, 0x40, 0x01, 0x52, 0x09, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x41,
	0x74, 0x22, 0xe1, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x41, 0x50, 0x49, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4d, 0x0a, 0x0b, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12,
	0x39, 0x0a, 0x07, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x41, 0x50, 0x49, 0x4b, 0x65, 0x79, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x06, 0x61, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x82, 0x01, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x50, 0x49, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x49, 0x64, 0x73, 0x12, 0x15, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x64, 0x22, 0xdd, 0x01, 0x0a, 0x1f, 0x4c,
	0x69, 0x73, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6c, 0x6c, 0x61, 0x62,
	0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d,
	0x0a, 0x0b, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12, 0x1e, 0x0a,
	0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x2a, 0x03, 0x18, 0xe8, 0x07, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x70, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x61, 0x67,
	0x65, 0x12, 0x37, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x21, 0xfa, 0x42, 0x1e, 0x72, 0x1c, 0x52, 0x00, 0x52, 0x02, 0x69, 0x64, 0x52, 0x03, 0x2d,
	0x69, 0x64, 0x52, 0x07, 0x2d, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x52, 0x06, 0x72, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x22, 0xcb, 0x01, 0x0a, 0x1d, 0x47,
	0x65, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0b,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12, 0x5b, 0x0a, 0x0c, 0x63,
	0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x63, 0x6f, 0x6c, 0x6c,
	0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0xba, 0x01, 0x0a, 0x1d, 0x53, 0x65, 0x74,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12, 0x4a, 0x0a, 0x0c, 0x63, 0x6f, 0x6c,
	0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0xd5, 0x01, 0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12, 0x62, 0x0a, 0x10, 0x63, 0x6f, 0x6c,
	0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0f, 0x63, 0x6f,
	0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x49, 0x64, 0x73, 0x22, 0xf4, 0x02,
	0x0a, 0x0e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61,
	0x12, 0x12, 0x0a, 0x04, 0x67, 0x61, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04,
	0x67, 0x61, 0x69, 0x6e, 0x12, 0x34, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x87, 0x01, 0x0a, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x2e,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x37, 0xfa, 0x42, 0x32, 0x9a, 0x01, 0x2f, 0x10, 0x0a, 0x22, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32,
	0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d,
	0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x2a,
	0x05, 0x72, 0x03, 0x18, 0xc8, 0x01, 0x18, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x09, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x41, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x09, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x3d, 0x0a, 0x0f, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04,
	0x08, 0x01, 0x10, 0x01, 0x22, 0x8f, 0x05, 0x0a, 0x0d, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x09, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x62, 0x6f, 0x6f, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x7f, 0x0a, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x36,
	0xfa, 0x42, 0x33, 0x9a, 0x01, 0x30, 0x10, 0x0a, 0x22, 0x25, 0x72, 0x23, 0x18, 0x24, 0x32, 0x1f,
	0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x5f, 0x2d, 0x5d,
	0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x2a,
	0x05, 0x72, 0x03, 0x18, 0x80, 0x01, 0x52, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x4f, 0x0a, 0x11, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x5f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x08, 0x52,
	0x10, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x1e, 0x0a, 0x02, 0x69, 0x70, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0e, 0xfa,
	0x42, 0x0b, 0x92, 0x01, 0x08, 0x10, 0x0a, 0x22, 0x04, 0x72, 0x02, 0x70, 0x01, 0x52, 0x02, 0x69,
	0x70, 0x12, 0x75, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x2f,
	0xfa, 0x42, 0x2c, 0x9a, 0x01, 0x29, 0x10, 0x20, 0x22, 0x25, 0x72, 0x23, 0x18, 0x24, 0x32, 0x1f,
	0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x5f, 0x2d, 0x5d,
	0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52,
	0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x33, 0x0a, 0x08, 0x61, 0x64, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x18, 0x63, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x52, 0x08, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x1a, 0x3b, 0x0a,
	0x0d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3a, 0x0a, 0x0c, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x26, 0x0a, 0x14, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x70, 0x22, 0x84,
	0x0b, 0x0a, 0x16, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x3d, 0x0a, 0x0c, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x43, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x51, 0x0a, 0x17, 0x6c, 0x61, 0x73,
	0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65,
	0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x14, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x41, 0x74, 0x12, 0x3e, 0x0a, 0x0b,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x51, 0x0a, 0x17,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x72, 0x65, 0x63, 0x65,
	0x69, 0x76, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x14, 0x6c, 0x61, 0x73, 0x74, 0x55,
	0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x41, 0x74, 0x12,
	0x21, 0x0a, 0x0c, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x55, 0x0a, 0x19, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c,
	0x69, 0x6e, 0x6b, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x16, 0x6c, 0x61, 0x73, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x41, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x6f, 0x77,
	0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0d, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x66, 0x0a, 0x22, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x78, 0x5f, 0x61, 0x63, 0x6b, 0x6e,
	0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x1e, 0x6c, 0x61, 0x73, 0x74, 0x54, 0x78,
	0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x41, 0x74, 0x12, 0x36, 0x0a, 0x17, 0x74, 0x78, 0x5f, 0x61,
	0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x04, 0x52, 0x15, 0x74, 0x78, 0x41, 0x63, 0x6b,
	0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x5f, 0x0a, 0x10, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x74, 0x72, 0x69, 0x70, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x2e, 0x52, 0x6f, 0x75, 0x6e, 0x64, 0x54, 0x72, 0x69, 0x70, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x52, 0x0e, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x54, 0x72, 0x69, 0x70, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x12, 0x4b, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x5f, 0x62, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x0a,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x53, 0x75, 0x62,
	0x42, 0x61, 0x6e, 0x64, 0x52, 0x08, 0x73, 0x75, 0x62, 0x42, 0x61, 0x6e, 0x64, 0x73, 0x12, 0x5a,
	0x0a, 0x16, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x52, 0x14, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0xd1, 0x01, 0x0a, 0x0e, 0x52,
	0x6f, 0x75, 0x6e, 0x64, 0x54, 0x72, 0x69, 0x70, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x12, 0x35, 0x0a,
	0x03, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xfa, 0x42, 0x05, 0xaa, 0x01, 0x02, 0x08, 0x01, 0x52,
	0x03, 0x6d, 0x69, 0x6e, 0x12, 0x35, 0x0a, 0x03, 0x6d, 0x61, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0xaa, 0x01, 0x02, 0x08, 0x01, 0x52, 0x03, 0x6d, 0x61, 0x78, 0x12, 0x3b, 0x0a, 0x06, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xfa, 0x42, 0x05, 0xaa, 0x01, 0x02, 0x08, 0x01,
	0x52, 0x06, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xc4,
	0x01, 0x0a, 0x07, 0x53, 0x75, 0x62, 0x42, 0x61, 0x6e, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x69,
	0x6e, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12,
	0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x46, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x12, 0x3c, 0x0a, 0x1a, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b,
	0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x18, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69,
	0x6e, 0x6b, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x12, 0x31, 0x0a, 0x14, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x75,
	0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x13, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2a, 0xa7, 0x02, 0x0a, 0x22, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x36, 0x0a, 0x32,
	0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x5f,
	0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x46, 0x41, 0x43,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x33, 0x0a, 0x2f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f,
	0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f,
	0x49, 0x4e, 0x54, 0x45, 0x52, 0x46, 0x41, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43,
	0x45, 0x4c, 0x4c, 0x55, 0x4c, 0x41, 0x52, 0x10, 0x01, 0x12, 0x2f, 0x0a, 0x2b, 0x4d, 0x41, 0x4e,
	0x41, 0x47, 0x45, 0x44, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x5f, 0x4e, 0x45, 0x54,
	0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x46, 0x41, 0x43, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x57, 0x49, 0x46, 0x49, 0x10, 0x02, 0x12, 0x33, 0x0a, 0x2f, 0x4d, 0x41,
	0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x5f, 0x4e, 0x45,
	0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x46, 0x41, 0x43, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x54, 0x48, 0x45, 0x52, 0x4e, 0x45, 0x54, 0x10, 0x03, 0x1a,
	0x2e, 0xea, 0xaa, 0x19, 0x2a, 0x18, 0x01, 0x2a, 0x26, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44,
	0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b,
	0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x46, 0x41, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x2a,
	0xab, 0x02, 0x0a, 0x24, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61,
	0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x38, 0x0a, 0x34, 0x4d, 0x41, 0x4e, 0x41,
	0x47, 0x45, 0x44, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x5f, 0x4e, 0x45, 0x54, 0x57,
	0x4f, 0x52, 0x4b, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x46, 0x41, 0x43, 0x45, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x31, 0x0a, 0x2d, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x47, 0x41,
	0x54, 0x45, 0x57, 0x41, 0x59, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x49, 0x4e,
	0x54, 0x45, 0x52, 0x46, 0x41, 0x43, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x44,
	0x4f, 0x57, 0x4e, 0x10, 0x01, 0x12, 0x2f, 0x0a, 0x2b, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44,
	0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b,
	0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x46, 0x41, 0x43, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55,
	0x53, 0x5f, 0x55, 0x50, 0x10, 0x02, 0x12, 0x33, 0x0a, 0x2f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45,
	0x44, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52,
	0x4b, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x46, 0x41, 0x43, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x1a, 0x30, 0xea, 0xaa, 0x19,
	0x2c, 0x18, 0x01, 0x2a, 0x28, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x47, 0x41, 0x54,
	0x45, 0x57, 0x41, 0x59, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x46, 0x41, 0x43, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x2a, 0x5c, 0x0a,
	0x17, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x4c, 0x41, 0x43,
	0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x44, 0x4f, 0x4f, 0x52, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x4f,
	0x55, 0x54, 0x44, 0x4f, 0x4f, 0x52, 0x10, 0x02, 0x1a, 0x11, 0xea, 0xaa, 0x19, 0x0d, 0x18, 0x01,
	0x2a, 0x09, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x42, 0x31, 0x5a, 0x2f, 0x67,
	0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_gateway_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_gateway_proto_rawDescData = file_ttn_lorawan_v3_gateway_proto_rawDesc
)

func file_ttn_lorawan_v3_gateway_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_gateway_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_gateway_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_gateway_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_gateway_proto_rawDescData
}

var file_ttn_lorawan_v3_gateway_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_ttn_lorawan_v3_gateway_proto_msgTypes = make([]protoimpl.MessageInfo, 50)
var file_ttn_lorawan_v3_gateway_proto_goTypes = []interface{}{
	(ManagedGatewayNetworkInterfaceType)(0),         // 0: ttn.lorawan.v3.ManagedGatewayNetworkInterfaceType
	(ManagedGatewayNetworkInterfaceStatus)(0),       // 1: ttn.lorawan.v3.ManagedGatewayNetworkInterfaceStatus
	(GatewayAntennaPlacement)(0),                    // 2: ttn.lorawan.v3.GatewayAntennaPlacement
	(*GatewayBrand)(nil),                            // 3: ttn.lorawan.v3.GatewayBrand
	(*GatewayModel)(nil),                            // 4: ttn.lorawan.v3.GatewayModel
	(*GatewayVersionIdentifiers)(nil),               // 5: ttn.lorawan.v3.GatewayVersionIdentifiers
	(*GatewayRadio)(nil),                            // 6: ttn.lorawan.v3.GatewayRadio
	(*GatewayClaimAuthenticationCode)(nil),          // 7: ttn.lorawan.v3.GatewayClaimAuthenticationCode
	(*Gateway)(nil),                                 // 8: ttn.lorawan.v3.Gateway
	(*Gateways)(nil),                                // 9: ttn.lorawan.v3.Gateways
	(*ManagedGateway)(nil),                          // 10: ttn.lorawan.v3.ManagedGateway
	(*ManagedGatewayWiFiAccessPoint)(nil),           // 11: ttn.lorawan.v3.ManagedGatewayWiFiAccessPoint
	(*ManagedGatewayWiFiAccessPoints)(nil),          // 12: ttn.lorawan.v3.ManagedGatewayWiFiAccessPoints
	(*ManagedGatewayNetworkInterfaceAddresses)(nil), // 13: ttn.lorawan.v3.ManagedGatewayNetworkInterfaceAddresses
	(*ManagedGatewaySystemStatus)(nil),              // 14: ttn.lorawan.v3.ManagedGatewaySystemStatus
	(*ManagedGatewayControllerConnection)(nil),      // 15: ttn.lorawan.v3.ManagedGatewayControllerConnection
	(*ManagedGatewayGatewayServerConnection)(nil),   // 16: ttn.lorawan.v3.ManagedGatewayGatewayServerConnection
	(*ManagedGatewayNetworkInterfaceInfo)(nil),      // 17: ttn.lorawan.v3.ManagedGatewayNetworkInterfaceInfo
	(*ManagedGatewayCellularBackhaul)(nil),          // 18: ttn.lorawan.v3.ManagedGatewayCellularBackhaul
	(*ManagedGatewayWiFiBackhaul)(nil),              // 19: ttn.lorawan.v3.ManagedGatewayWiFiBackhaul
	(*ManagedGatewayEthernetBackhaul)(nil),          // 20: ttn.lorawan.v3.ManagedGatewayEthernetBackhaul
	(*ManagedGatewayEventData)(nil),                 // 21: ttn.lorawan.v3.ManagedGatewayEventData
	(*ManagedGatewayWiFiProfile)(nil),               // 22: ttn.lorawan.v3.ManagedGatewayWiFiProfile
	(*ManagedGatewayWiFiProfiles)(nil),              // 23: ttn.lorawan.v3.ManagedGatewayWiFiProfiles
	(*ManagedGatewayEthernetProfile)(nil),           // 24: ttn.lorawan.v3.ManagedGatewayEthernetProfile
	(*ManagedGatewayEthernetProfiles)(nil),          // 25: ttn.lorawan.v3.ManagedGatewayEthernetProfiles
	(*GetGatewayRequest)(nil),                       // 26: ttn.lorawan.v3.GetGatewayRequest
	(*GetGatewayIdentifiersForEUIRequest)(nil),      // 27: ttn.lorawan.v3.GetGatewayIdentifiersForEUIRequest
	(*ListGatewaysRequest)(nil),                     // 28: ttn.lorawan.v3.ListGatewaysRequest
	(*CreateGatewayRequest)(nil),                    // 29: ttn.lorawan.v3.CreateGatewayRequest
	(*UpdateGatewayRequest)(nil),                    // 30: ttn.lorawan.v3.UpdateGatewayRequest
	(*ListGatewayAPIKeysRequest)(nil),               // 31: ttn.lorawan.v3.ListGatewayAPIKeysRequest
	(*GetGatewayAPIKeyRequest)(nil),                 // 32: ttn.lorawan.v3.GetGatewayAPIKeyRequest
	(*CreateGatewayAPIKeyRequest)(nil),              // 33: ttn.lorawan.v3.CreateGatewayAPIKeyRequest
	(*UpdateGatewayAPIKeyRequest)(nil),              // 34: ttn.lorawan.v3.UpdateGatewayAPIKeyRequest
	(*DeleteGatewayAPIKeyRequest)(nil),              // 35: ttn.lorawan.v3.DeleteGatewayAPIKeyRequest
	(*ListGatewayCollaboratorsRequest)(nil),         // 36: ttn.lorawan.v3.ListGatewayCollaboratorsRequest
	(*GetGatewayCollaboratorRequest)(nil),           // 37: ttn.lorawan.v3.GetGatewayCollaboratorRequest
	(*SetGatewayCollaboratorRequest)(nil),           // 38: ttn.lorawan.v3.SetGatewayCollaboratorRequest
	(*DeleteGatewayCollaboratorRequest)(nil),        // 39: ttn.lorawan.v3.DeleteGatewayCollaboratorRequest
	(*GatewayAntenna)(nil),                          // 40: ttn.lorawan.v3.GatewayAntenna
	(*GatewayStatus)(nil),                           // 41: ttn.lorawan.v3.GatewayStatus
	(*GatewayRemoteAddress)(nil),                    // 42: ttn.lorawan.v3.GatewayRemoteAddress
	(*GatewayConnectionStats)(nil),                  // 43: ttn.lorawan.v3.GatewayConnectionStats
	(*GatewayRadio_TxConfiguration)(nil),            // 44: ttn.lorawan.v3.GatewayRadio.TxConfiguration
	nil,                                             // 45: ttn.lorawan.v3.Gateway.AttributesEntry
	(*Gateway_LRFHSS)(nil),                          // 46: ttn.lorawan.v3.Gateway.LRFHSS
	(*ListGatewaysRequest_Filter)(nil),              // 47: ttn.lorawan.v3.ListGatewaysRequest.Filter
	nil,                                             // 48: ttn.lorawan.v3.GatewayAntenna.AttributesEntry
	nil,                                             // 49: ttn.lorawan.v3.GatewayStatus.VersionsEntry
	nil,                                             // 50: ttn.lorawan.v3.GatewayStatus.MetricsEntry
	(*GatewayConnectionStats_RoundTripTimes)(nil),   // 51: ttn.lorawan.v3.GatewayConnectionStats.RoundTripTimes
	(*GatewayConnectionStats_SubBand)(nil),          // 52: ttn.lorawan.v3.GatewayConnectionStats.SubBand
	(*Secret)(nil),                                  // 53: ttn.lorawan.v3.Secret
	(*timestamppb.Timestamp)(nil),                   // 54: google.protobuf.Timestamp
	(*GatewayIdentifiers)(nil),                      // 55: ttn.lorawan.v3.GatewayIdentifiers
	(*ContactInfo)(nil),                             // 56: ttn.lorawan.v3.ContactInfo
	(*OrganizationOrUserIdentifiers)(nil),           // 57: ttn.lorawan.v3.OrganizationOrUserIdentifiers
	(DownlinkPathConstraint)(0),                     // 58: ttn.lorawan.v3.DownlinkPathConstraint
	(*durationpb.Duration)(nil),                     // 59: google.protobuf.Duration
	(*wrapperspb.FloatValue)(nil),                   // 60: google.protobuf.FloatValue
	(*Location)(nil),                                // 61: ttn.lorawan.v3.Location
	(*fieldmaskpb.FieldMask)(nil),                   // 62: google.protobuf.FieldMask
	(Right)(0),                                      // 63: ttn.lorawan.v3.Right
	(*APIKey)(nil),                                  // 64: ttn.lorawan.v3.APIKey
	(*Collaborator)(nil),                            // 65: ttn.lorawan.v3.Collaborator
	(*structpb.Struct)(nil),                         // 66: google.protobuf.Struct
}
var file_ttn_lorawan_v3_gateway_proto_depIdxs = []int32{
	44, // 0: ttn.lorawan.v3.GatewayRadio.tx_configuration:type_name -> ttn.lorawan.v3.GatewayRadio.TxConfiguration
	53, // 1: ttn.lorawan.v3.GatewayClaimAuthenticationCode.secret:type_name -> ttn.lorawan.v3.Secret
	54, // 2: ttn.lorawan.v3.GatewayClaimAuthenticationCode.valid_from:type_name -> google.protobuf.Timestamp
	54, // 3: ttn.lorawan.v3.GatewayClaimAuthenticationCode.valid_to:type_name -> google.protobuf.Timestamp
	55, // 4: ttn.lorawan.v3.Gateway.ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	54, // 5: ttn.lorawan.v3.Gateway.created_at:type_name -> google.protobuf.Timestamp
	54, // 6: ttn.lorawan.v3.Gateway.updated_at:type_name -> google.protobuf.Timestamp
	54, // 7: ttn.lorawan.v3.Gateway.deleted_at:type_name -> google.protobuf.Timestamp
	45, // 8: ttn.lorawan.v3.Gateway.attributes:type_name -> ttn.lorawan.v3.Gateway.AttributesEntry
	56, // 9: ttn.lorawan.v3.Gateway.contact_info:type_name -> ttn.lorawan.v3.ContactInfo
	57, // 10: ttn.lorawan.v3.Gateway.administrative_contact:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	57, // 11: ttn.lorawan.v3.Gateway.technical_contact:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	5,  // 12: ttn.lorawan.v3.Gateway.version_ids:type_name -> ttn.lorawan.v3.GatewayVersionIdentifiers
	40, // 13: ttn.lorawan.v3.Gateway.antennas:type_name -> ttn.lorawan.v3.GatewayAntenna
	58, // 14: ttn.lorawan.v3.Gateway.downlink_path_constraint:type_name -> ttn.lorawan.v3.DownlinkPathConstraint
	59, // 15: ttn.lorawan.v3.Gateway.schedule_anytime_delay:type_name -> google.protobuf.Duration
	53, // 16: ttn.lorawan.v3.Gateway.lbs_lns_secret:type_name -> ttn.lorawan.v3.Secret
	7,  // 17: ttn.lorawan.v3.Gateway.claim_authentication_code:type_name -> ttn.lorawan.v3.GatewayClaimAuthenticationCode
	53, // 18: ttn.lorawan.v3.Gateway.target_cups_key:type_name -> ttn.lorawan.v3.Secret
	46, // 19: ttn.lorawan.v3.Gateway.lrfhss:type_name -> ttn.lorawan.v3.Gateway.LRFHSS
	8,  // 20: ttn.lorawan.v3.Gateways.gateways:type_name -> ttn.lorawan.v3.Gateway
	55, // 21: ttn.lorawan.v3.ManagedGateway.ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	5,  // 22: ttn.lorawan.v3.ManagedGateway.version_ids:type_name -> ttn.lorawan.v3.GatewayVersionIdentifiers
	11, // 23: ttn.lorawan.v3.ManagedGatewayWiFiAccessPoints.access_points:type_name -> ttn.lorawan.v3.ManagedGatewayWiFiAccessPoint
	60, // 24: ttn.lorawan.v3.ManagedGatewaySystemStatus.cpu_temperature:type_name -> google.protobuf.FloatValue
	0,  // 25: ttn.lorawan.v3.ManagedGatewayControllerConnection.network_interface_type:type_name -> ttn.lorawan.v3.ManagedGatewayNetworkInterfaceType
	0,  // 26: ttn.lorawan.v3.ManagedGatewayGatewayServerConnection.network_interface_type:type_name -> ttn.lorawan.v3.ManagedGatewayNetworkInterfaceType
	1,  // 27: ttn.lorawan.v3.ManagedGatewayNetworkInterfaceInfo.status:type_name -> ttn.lorawan.v3.ManagedGatewayNetworkInterfaceStatus
	13, // 28: ttn.lorawan.v3.ManagedGatewayNetworkInterfaceInfo.addresses:type_name -> ttn.lorawan.v3.ManagedGatewayNetworkInterfaceAddresses
	17, // 29: ttn.lorawan.v3.ManagedGatewayCellularBackhaul.network_interface:type_name -> ttn.lorawan.v3.ManagedGatewayNetworkInterfaceInfo
	60, // 30: ttn.lorawan.v3.ManagedGatewayCellularBackhaul.rssi:type_name -> google.protobuf.FloatValue
	17, // 31: ttn.lorawan.v3.ManagedGatewayWiFiBackhaul.network_interface:type_name -> ttn.lorawan.v3.ManagedGatewayNetworkInterfaceInfo
	60, // 32: ttn.lorawan.v3.ManagedGatewayWiFiBackhaul.rssi:type_name -> google.protobuf.FloatValue
	17, // 33: ttn.lorawan.v3.ManagedGatewayEthernetBackhaul.network_interface:type_name -> ttn.lorawan.v3.ManagedGatewayNetworkInterfaceInfo
	10, // 34: ttn.lorawan.v3.ManagedGatewayEventData.entity:type_name -> ttn.lorawan.v3.ManagedGateway
	61, // 35: ttn.lorawan.v3.ManagedGatewayEventData.location:type_name -> ttn.lorawan.v3.Location
	14, // 36: ttn.lorawan.v3.ManagedGatewayEventData.system_status:type_name -> ttn.lorawan.v3.ManagedGatewaySystemStatus
	15, // 37: ttn.lorawan.v3.ManagedGatewayEventData.controller_connection:type_name -> ttn.lorawan.v3.ManagedGatewayControllerConnection
	16, // 38: ttn.lorawan.v3.ManagedGatewayEventData.gateway_server_connection:type_name -> ttn.lorawan.v3.ManagedGatewayGatewayServerConnection
	18, // 39: ttn.lorawan.v3.ManagedGatewayEventData.cellular_backhaul:type_name -> ttn.lorawan.v3.ManagedGatewayCellularBackhaul
	19, // 40: ttn.lorawan.v3.ManagedGatewayEventData.wifi_backhaul:type_name -> ttn.lorawan.v3.ManagedGatewayWiFiBackhaul
	20, // 41: ttn.lorawan.v3.ManagedGatewayEventData.ethernet_backhaul:type_name -> ttn.lorawan.v3.ManagedGatewayEthernetBackhaul
	13, // 42: ttn.lorawan.v3.ManagedGatewayWiFiProfile.network_interface_addresses:type_name -> ttn.lorawan.v3.ManagedGatewayNetworkInterfaceAddresses
	22, // 43: ttn.lorawan.v3.ManagedGatewayWiFiProfiles.profiles:type_name -> ttn.lorawan.v3.ManagedGatewayWiFiProfile
	13, // 44: ttn.lorawan.v3.ManagedGatewayEthernetProfile.network_interface_addresses:type_name -> ttn.lorawan.v3.ManagedGatewayNetworkInterfaceAddresses
	24, // 45: ttn.lorawan.v3.ManagedGatewayEthernetProfiles.profiles:type_name -> ttn.lorawan.v3.ManagedGatewayEthernetProfile
	55, // 46: ttn.lorawan.v3.GetGatewayRequest.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	62, // 47: ttn.lorawan.v3.GetGatewayRequest.field_mask:type_name -> google.protobuf.FieldMask
	57, // 48: ttn.lorawan.v3.ListGatewaysRequest.collaborator:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	62, // 49: ttn.lorawan.v3.ListGatewaysRequest.field_mask:type_name -> google.protobuf.FieldMask
	47, // 50: ttn.lorawan.v3.ListGatewaysRequest.filters:type_name -> ttn.lorawan.v3.ListGatewaysRequest.Filter
	8,  // 51: ttn.lorawan.v3.CreateGatewayRequest.gateway:type_name -> ttn.lorawan.v3.Gateway
	57, // 52: ttn.lorawan.v3.CreateGatewayRequest.collaborator:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	8,  // 53: ttn.lorawan.v3.UpdateGatewayRequest.gateway:type_name -> ttn.lorawan.v3.Gateway
	62, // 54: ttn.lorawan.v3.UpdateGatewayRequest.field_mask:type_name -> google.protobuf.FieldMask
	55, // 55: ttn.lorawan.v3.ListGatewayAPIKeysRequest.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	55, // 56: ttn.lorawan.v3.GetGatewayAPIKeyRequest.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	55, // 57: ttn.lorawan.v3.CreateGatewayAPIKeyRequest.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	63, // 58: ttn.lorawan.v3.CreateGatewayAPIKeyRequest.rights:type_name -> ttn.lorawan.v3.Right
	54, // 59: ttn.lorawan.v3.CreateGatewayAPIKeyRequest.expires_at:type_name -> google.protobuf.Timestamp
	55, // 60: ttn.lorawan.v3.UpdateGatewayAPIKeyRequest.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	64, // 61: ttn.lorawan.v3.UpdateGatewayAPIKeyRequest.api_key:type_name -> ttn.lorawan.v3.APIKey
	62, // 62: ttn.lorawan.v3.UpdateGatewayAPIKeyRequest.field_mask:type_name -> google.protobuf.FieldMask
	55, // 63: ttn.lorawan.v3.DeleteGatewayAPIKeyRequest.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	55, // 64: ttn.lorawan.v3.ListGatewayCollaboratorsRequest.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	55, // 65: ttn.lorawan.v3.GetGatewayCollaboratorRequest.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	57, // 66: ttn.lorawan.v3.GetGatewayCollaboratorRequest.collaborator:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	55, // 67: ttn.lorawan.v3.SetGatewayCollaboratorRequest.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	65, // 68: ttn.lorawan.v3.SetGatewayCollaboratorRequest.collaborator:type_name -> ttn.lorawan.v3.Collaborator
	55, // 69: ttn.lorawan.v3.DeleteGatewayCollaboratorRequest.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	57, // 70: ttn.lorawan.v3.DeleteGatewayCollaboratorRequest.collaborator_ids:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	61, // 71: ttn.lorawan.v3.GatewayAntenna.location:type_name -> ttn.lorawan.v3.Location
	48, // 72: ttn.lorawan.v3.GatewayAntenna.attributes:type_name -> ttn.lorawan.v3.GatewayAntenna.AttributesEntry
	2,  // 73: ttn.lorawan.v3.GatewayAntenna.placement:type_name -> ttn.lorawan.v3.GatewayAntennaPlacement
	54, // 74: ttn.lorawan.v3.GatewayStatus.time:type_name -> google.protobuf.Timestamp
	54, // 75: ttn.lorawan.v3.GatewayStatus.boot_time:type_name -> google.protobuf.Timestamp
	49, // 76: ttn.lorawan.v3.GatewayStatus.versions:type_name -> ttn.lorawan.v3.GatewayStatus.VersionsEntry
	61, // 77: ttn.lorawan.v3.GatewayStatus.antenna_locations:type_name -> ttn.lorawan.v3.Location
	50, // 78: ttn.lorawan.v3.GatewayStatus.metrics:type_name -> ttn.lorawan.v3.GatewayStatus.MetricsEntry
	66, // 79: ttn.lorawan.v3.GatewayStatus.advanced:type_name -> google.protobuf.Struct
	54, // 80: ttn.lorawan.v3.GatewayConnectionStats.connected_at:type_name -> google.protobuf.Timestamp
	54, // 81: ttn.lorawan.v3.GatewayConnectionStats.disconnected_at:type_name -> google.protobuf.Timestamp
	54, // 82: ttn.lorawan.v3.GatewayConnectionStats.last_status_received_at:type_name -> google.protobuf.Timestamp
	41, // 83: ttn.lorawan.v3.GatewayConnectionStats.last_status:type_name -> ttn.lorawan.v3.GatewayStatus
	54, // 84: ttn.lorawan.v3.GatewayConnectionStats.last_uplink_received_at:type_name -> google.protobuf.Timestamp
	54, // 85: ttn.lorawan.v3.GatewayConnectionStats.last_downlink_received_at:type_name -> google.protobuf.Timestamp
	54, // 86: ttn.lorawan.v3.GatewayConnectionStats.last_tx_acknowledgment_received_at:type_name -> google.protobuf.Timestamp
	51, // 87: ttn.lorawan.v3.GatewayConnectionStats.round_trip_times:type_name -> ttn.lorawan.v3.GatewayConnectionStats.RoundTripTimes
	52, // 88: ttn.lorawan.v3.GatewayConnectionStats.sub_bands:type_name -> ttn.lorawan.v3.GatewayConnectionStats.SubBand
	42, // 89: ttn.lorawan.v3.GatewayConnectionStats.gateway_remote_address:type_name -> ttn.lorawan.v3.GatewayRemoteAddress
	54, // 90: ttn.lorawan.v3.ListGatewaysRequest.Filter.updated_since:type_name -> google.protobuf.Timestamp
	59, // 91: ttn.lorawan.v3.GatewayConnectionStats.RoundTripTimes.min:type_name -> google.protobuf.Duration
	59, // 92: ttn.lorawan.v3.GatewayConnectionStats.RoundTripTimes.max:type_name -> google.protobuf.Duration
	59, // 93: ttn.lorawan.v3.GatewayConnectionStats.RoundTripTimes.median:type_name -> google.protobuf.Duration
	94, // [94:94] is the sub-list for method output_type
	94, // [94:94] is the sub-list for method input_type
	94, // [94:94] is the sub-list for extension type_name
	94, // [94:94] is the sub-list for extension extendee
	0,  // [0:94] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_gateway_proto_init() }
func file_ttn_lorawan_v3_gateway_proto_init() {
	if File_ttn_lorawan_v3_gateway_proto != nil {
		return
	}
	file_ttn_lorawan_v3_contact_info_proto_init()
	file_ttn_lorawan_v3_enums_proto_init()
	file_ttn_lorawan_v3_identifiers_proto_init()
	file_ttn_lorawan_v3_metadata_proto_init()
	file_ttn_lorawan_v3_rights_proto_init()
	file_ttn_lorawan_v3_secrets_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_gateway_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayBrand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayModel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayVersionIdentifiers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayRadio); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayClaimAuthenticationCode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Gateway); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Gateways); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGateway); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewayWiFiAccessPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewayWiFiAccessPoints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewayNetworkInterfaceAddresses); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewaySystemStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewayControllerConnection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewayGatewayServerConnection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewayNetworkInterfaceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewayCellularBackhaul); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewayWiFiBackhaul); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewayEthernetBackhaul); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewayEventData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewayWiFiProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewayWiFiProfiles); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewayEthernetProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedGatewayEthernetProfiles); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGatewayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGatewayIdentifiersForEUIRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGatewaysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGatewayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGatewayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGatewayAPIKeysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGatewayAPIKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGatewayAPIKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGatewayAPIKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGatewayAPIKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGatewayCollaboratorsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGatewayCollaboratorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetGatewayCollaboratorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGatewayCollaboratorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayAntenna); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayRemoteAddress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayConnectionStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayRadio_TxConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Gateway_LRFHSS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGatewaysRequest_Filter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayConnectionStats_RoundTripTimes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_gateway_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayConnectionStats_SubBand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_ttn_lorawan_v3_gateway_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*ManagedGatewayEventData_Entity)(nil),
		(*ManagedGatewayEventData_Location)(nil),
		(*ManagedGatewayEventData_SystemStatus)(nil),
		(*ManagedGatewayEventData_ControllerConnection)(nil),
		(*ManagedGatewayEventData_GatewayServerConnection)(nil),
		(*ManagedGatewayEventData_CellularBackhaul)(nil),
		(*ManagedGatewayEventData_WifiBackhaul)(nil),
		(*ManagedGatewayEventData_EthernetBackhaul)(nil),
	}
	file_ttn_lorawan_v3_gateway_proto_msgTypes[44].OneofWrappers = []interface{}{
		(*ListGatewaysRequest_Filter_UpdatedSince)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_gateway_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   50,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ttn_lorawan_v3_gateway_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_gateway_proto_depIdxs,
		EnumInfos:         file_ttn_lorawan_v3_gateway_proto_enumTypes,
		MessageInfos:      file_ttn_lorawan_v3_gateway_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_gateway_proto = out.File
	file_ttn_lorawan_v3_gateway_proto_rawDesc = nil
	file_ttn_lorawan_v3_gateway_proto_goTypes = nil
	file_ttn_lorawan_v3_gateway_proto_depIdxs = nil
}
