// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package ttnpb

import "sort"

func init() {
	sort.Strings(asApplicationLinkFieldPaths)
}

var asApplicationLinkFieldPaths = append(
	ApplicationLinkFieldPathsNested[:],
	"api_key",
	"network_server_address",
	"tls",
)

var isEndDeviceReadFieldPaths = []string{
	"activated_at",
	"application_server_address",
	"attributes",
	"created_at",
	"claim_authentication_code",
	"claim_authentication_code.value",
	"claim_authentication_code.valid_to",
	"claim_authentication_code.valid_from",
	"description",
	"ids",
	"ids.application_ids",
	"ids.application_ids.application_id",
	"ids.dev_eui",
	"ids.device_id",
	"ids.join_eui",
	"join_server_address",
	"locations",
	"name",
	"network_server_address",
	"serial_number",
	"service_profile_id",
	"lora_alliance_profile_ids",
	"lora_alliance_profile_ids.vendor_id",
	"lora_alliance_profile_ids.vendor_profile_id",
	"updated_at",
	"version_ids",
	"version_ids.band_id",
	"version_ids.brand_id",
	"version_ids.firmware_version",
	"version_ids.hardware_version",
	"version_ids.model_id",
	"picture",
	"last_seen_at",
}

var isEndDeviceWriteFieldPaths = []string{
	"activated_at",
	"application_server_address",
	"attributes",
	"claim_authentication_code",
	"claim_authentication_code.value",
	"claim_authentication_code.valid_to",
	"claim_authentication_code.valid_from",
	"description",
	"join_server_address",
	"locations",
	"name",
	"network_server_address",
	"serial_number",
	"service_profile_id",
	"lora_alliance_profile_ids",
	"lora_alliance_profile_ids.vendor_id",
	"lora_alliance_profile_ids.vendor_profile_id",
	"version_ids",
	"version_ids.band_id",
	"version_ids.brand_id",
	"version_ids.firmware_version",
	"version_ids.hardware_version",
	"version_ids.model_id",
	"picture",
	"last_seen_at",
}

var nsEndDeviceReadFieldPaths = [...]string{
	"battery_percentage",
	"created_at",
	"downlink_margin",
	"frequency_plan_id",
	"ids",
	"ids.application_ids",
	"ids.application_ids.application_id",
	"ids.dev_addr",
	"ids.dev_eui",
	"ids.device_id",
	"ids.join_eui",
	"last_dev_status_received_at",
	"lorawan_phy_version",
	"lorawan_version",
	"mac_settings",
	"mac_settings.adr",
	"mac_settings.adr.mode",
	"mac_settings.adr.mode.disabled",
	"mac_settings.adr.mode.dynamic",
	"mac_settings.adr.mode.dynamic.channel_steering",
	"mac_settings.adr.mode.dynamic.channel_steering.mode",
	"mac_settings.adr.mode.dynamic.channel_steering.mode.disabled",
	"mac_settings.adr.mode.dynamic.channel_steering.mode.lora_narrow",
	"mac_settings.adr.mode.dynamic.margin",
	"mac_settings.adr.mode.dynamic.max_data_rate_index",
	"mac_settings.adr.mode.dynamic.max_data_rate_index.value",
	"mac_settings.adr.mode.dynamic.max_nb_trans",
	"mac_settings.adr.mode.dynamic.max_tx_power_index",
	"mac_settings.adr.mode.dynamic.min_data_rate_index",
	"mac_settings.adr.mode.dynamic.min_data_rate_index.value",
	"mac_settings.adr.mode.dynamic.min_nb_trans",
	"mac_settings.adr.mode.dynamic.min_tx_power_index",
	"mac_settings.adr.mode.dynamic.overrides",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_0",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_0.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_0.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_1",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_1.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_1.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_10",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_10.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_10.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_11",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_11.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_11.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_12",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_12.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_12.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_13",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_13.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_13.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_14",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_14.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_14.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_15",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_15.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_15.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_2",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_2.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_2.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_3",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_3.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_3.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_4",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_4.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_4.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_5",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_5.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_5.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_6",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_6.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_6.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_7",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_7.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_7.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_8",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_8.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_8.min_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_9",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_9.max_nb_trans",
	"mac_settings.adr.mode.dynamic.overrides.data_rate_9.min_nb_trans",
	"mac_settings.adr.mode.static",
	"mac_settings.adr.mode.static.data_rate_index",
	"mac_settings.adr.mode.static.nb_trans",
	"mac_settings.adr.mode.static.tx_power_index",
	"mac_settings.adr_margin",
	"mac_settings.beacon_frequency",
	"mac_settings.beacon_frequency.value",
	"mac_settings.class_b_timeout",
	"mac_settings.class_b_c_downlink_interval",
	"mac_settings.class_c_timeout",
	"mac_settings.desired_adr_ack_delay_exponent",
	"mac_settings.desired_adr_ack_delay_exponent.value",
	"mac_settings.desired_adr_ack_limit_exponent",
	"mac_settings.desired_adr_ack_limit_exponent.value",
	"mac_settings.desired_beacon_frequency",
	"mac_settings.desired_beacon_frequency.value",
	"mac_settings.desired_max_duty_cycle",
	"mac_settings.desired_max_duty_cycle.value",
	"mac_settings.desired_max_eirp",
	"mac_settings.desired_max_eirp.value",
	"mac_settings.desired_ping_slot_data_rate_index",
	"mac_settings.desired_ping_slot_data_rate_index.value",
	"mac_settings.desired_ping_slot_frequency",
	"mac_settings.desired_ping_slot_frequency.value",
	"mac_settings.desired_relay",
	"mac_settings.desired_relay.mode",
	"mac_settings.desired_relay.mode.served",
	"mac_settings.desired_relay.mode.served.backoff",
	"mac_settings.desired_relay.mode.served.mode",
	"mac_settings.desired_relay.mode.served.mode.always",
	"mac_settings.desired_relay.mode.served.mode.dynamic",
	"mac_settings.desired_relay.mode.served.mode.dynamic.smart_enable_level",
	"mac_settings.desired_relay.mode.served.mode.end_device_controlled",
	"mac_settings.desired_relay.mode.served.second_channel",
	"mac_settings.desired_relay.mode.served.second_channel.ack_offset",
	"mac_settings.desired_relay.mode.served.second_channel.data_rate_index",
	"mac_settings.desired_relay.mode.served.second_channel.frequency",
	"mac_settings.desired_relay.mode.served.serving_device_id",
	"mac_settings.desired_relay.mode.serving",
	"mac_settings.desired_relay.mode.serving.cad_periodicity",
	"mac_settings.desired_relay.mode.serving.default_channel_index",
	"mac_settings.desired_relay.mode.serving.limits",
	"mac_settings.desired_relay.mode.serving.limits.join_requests",
	"mac_settings.desired_relay.mode.serving.limits.join_requests.bucket_size",
	"mac_settings.desired_relay.mode.serving.limits.join_requests.reload_rate",
	"mac_settings.desired_relay.mode.serving.limits.notifications",
	"mac_settings.desired_relay.mode.serving.limits.notifications.bucket_size",
	"mac_settings.desired_relay.mode.serving.limits.notifications.reload_rate",
	"mac_settings.desired_relay.mode.serving.limits.overall",
	"mac_settings.desired_relay.mode.serving.limits.overall.bucket_size",
	"mac_settings.desired_relay.mode.serving.limits.overall.reload_rate",
	"mac_settings.desired_relay.mode.serving.limits.reset_behavior",
	"mac_settings.desired_relay.mode.serving.limits.uplink_messages",
	"mac_settings.desired_relay.mode.serving.limits.uplink_messages.bucket_size",
	"mac_settings.desired_relay.mode.serving.limits.uplink_messages.reload_rate",
	"mac_settings.desired_relay.mode.serving.second_channel",
	"mac_settings.desired_relay.mode.serving.second_channel.ack_offset",
	"mac_settings.desired_relay.mode.serving.second_channel.data_rate_index",
	"mac_settings.desired_relay.mode.serving.second_channel.frequency",
	"mac_settings.desired_relay.mode.serving.uplink_forwarding_rules",
	"mac_settings.desired_rx1_data_rate_offset",
	"mac_settings.desired_rx1_data_rate_offset.value",
	"mac_settings.desired_rx1_delay",
	"mac_settings.desired_rx1_delay.value",
	"mac_settings.desired_rx2_data_rate_index",
	"mac_settings.desired_rx2_data_rate_index.value",
	"mac_settings.desired_rx2_frequency",
	"mac_settings.desired_rx2_frequency.value",
	"mac_settings.factory_preset_frequencies",
	"mac_settings.max_duty_cycle",
	"mac_settings.max_duty_cycle.value",
	"mac_settings.ping_slot_data_rate_index",
	"mac_settings.ping_slot_data_rate_index.value",
	"mac_settings.ping_slot_frequency",
	"mac_settings.ping_slot_frequency.value",
	"mac_settings.ping_slot_periodicity",
	"mac_settings.ping_slot_periodicity.value",
	"mac_settings.relay",
	"mac_settings.relay.mode",
	"mac_settings.relay.mode.served",
	"mac_settings.relay.mode.served.backoff",
	"mac_settings.relay.mode.served.mode",
	"mac_settings.relay.mode.served.mode.always",
	"mac_settings.relay.mode.served.mode.dynamic",
	"mac_settings.relay.mode.served.mode.dynamic.smart_enable_level",
	"mac_settings.relay.mode.served.mode.end_device_controlled",
	"mac_settings.relay.mode.served.second_channel",
	"mac_settings.relay.mode.served.second_channel.ack_offset",
	"mac_settings.relay.mode.served.second_channel.data_rate_index",
	"mac_settings.relay.mode.served.second_channel.frequency",
	"mac_settings.relay.mode.served.serving_device_id",
	"mac_settings.relay.mode.serving",
	"mac_settings.relay.mode.serving.cad_periodicity",
	"mac_settings.relay.mode.serving.default_channel_index",
	"mac_settings.relay.mode.serving.limits",
	"mac_settings.relay.mode.serving.limits.join_requests",
	"mac_settings.relay.mode.serving.limits.join_requests.bucket_size",
	"mac_settings.relay.mode.serving.limits.join_requests.reload_rate",
	"mac_settings.relay.mode.serving.limits.notifications",
	"mac_settings.relay.mode.serving.limits.notifications.bucket_size",
	"mac_settings.relay.mode.serving.limits.notifications.reload_rate",
	"mac_settings.relay.mode.serving.limits.overall",
	"mac_settings.relay.mode.serving.limits.overall.bucket_size",
	"mac_settings.relay.mode.serving.limits.overall.reload_rate",
	"mac_settings.relay.mode.serving.limits.reset_behavior",
	"mac_settings.relay.mode.serving.limits.uplink_messages",
	"mac_settings.relay.mode.serving.limits.uplink_messages.bucket_size",
	"mac_settings.relay.mode.serving.limits.uplink_messages.reload_rate",
	"mac_settings.relay.mode.serving.second_channel",
	"mac_settings.relay.mode.serving.second_channel.ack_offset",
	"mac_settings.relay.mode.serving.second_channel.data_rate_index",
	"mac_settings.relay.mode.serving.second_channel.frequency",
	"mac_settings.relay.mode.serving.uplink_forwarding_rules",
	"mac_settings.resets_f_cnt",
	"mac_settings.resets_f_cnt.value",
	"mac_settings.rx1_data_rate_offset",
	"mac_settings.rx1_data_rate_offset.value",
	"mac_settings.rx1_delay",
	"mac_settings.rx1_delay.value",
	"mac_settings.rx2_data_rate_index",
	"mac_settings.rx2_data_rate_index.value",
	"mac_settings.rx2_frequency",
	"mac_settings.rx2_frequency.value",
	"mac_settings.schedule_downlinks",
	"mac_settings.schedule_downlinks.value",
	"mac_settings.status_count_periodicity",
	"mac_settings.status_time_periodicity",
	"mac_settings.supports_32_bit_f_cnt",
	"mac_settings.supports_32_bit_f_cnt.value",
	"mac_settings.use_adr",
	"mac_settings.use_adr.value",
	"mac_settings.uplink_dwell_time",
	"mac_settings.uplink_dwell_time.value",
	"mac_settings.downlink_dwell_time",
	"mac_settings.downlink_dwell_time.value",
	"mac_state",
	"mac_state.current_parameters",
	"mac_state.current_parameters.adr_ack_delay_exponent",
	"mac_state.current_parameters.adr_ack_delay_exponent.value",
	"mac_state.current_parameters.adr_ack_limit_exponent",
	"mac_state.current_parameters.adr_ack_limit_exponent.value",
	"mac_state.current_parameters.adr_data_rate_index",
	"mac_state.current_parameters.adr_nb_trans",
	"mac_state.current_parameters.adr_tx_power_index",
	"mac_state.current_parameters.beacon_frequency",
	"mac_state.current_parameters.channels",
	"mac_state.current_parameters.downlink_dwell_time",
	"mac_state.current_parameters.downlink_dwell_time.value",
	"mac_state.current_parameters.max_duty_cycle",
	"mac_state.current_parameters.max_eirp",
	"mac_state.current_parameters.ping_slot_data_rate_index_value",
	"mac_state.current_parameters.ping_slot_data_rate_index_value.value",
	"mac_state.current_parameters.ping_slot_frequency",
	"mac_state.current_parameters.rejoin_count_periodicity",
	"mac_state.current_parameters.rejoin_time_periodicity",
	"mac_state.current_parameters.relay",
	"mac_state.current_parameters.relay.mode",
	"mac_state.current_parameters.relay.mode.served",
	"mac_state.current_parameters.relay.mode.served.backoff",
	"mac_state.current_parameters.relay.mode.served.mode",
	"mac_state.current_parameters.relay.mode.served.mode.always",
	"mac_state.current_parameters.relay.mode.served.mode.dynamic",
	"mac_state.current_parameters.relay.mode.served.mode.dynamic.smart_enable_level",
	"mac_state.current_parameters.relay.mode.served.mode.end_device_controlled",
	"mac_state.current_parameters.relay.mode.served.second_channel",
	"mac_state.current_parameters.relay.mode.served.second_channel.ack_offset",
	"mac_state.current_parameters.relay.mode.served.second_channel.data_rate_index",
	"mac_state.current_parameters.relay.mode.served.second_channel.frequency",
	"mac_state.current_parameters.relay.mode.served.serving_device_id",
	"mac_state.current_parameters.relay.mode.serving",
	"mac_state.current_parameters.relay.mode.serving.cad_periodicity",
	"mac_state.current_parameters.relay.mode.serving.default_channel_index",
	"mac_state.current_parameters.relay.mode.serving.limits",
	"mac_state.current_parameters.relay.mode.serving.limits.join_requests",
	"mac_state.current_parameters.relay.mode.serving.limits.join_requests.bucket_size",
	"mac_state.current_parameters.relay.mode.serving.limits.join_requests.reload_rate",
	"mac_state.current_parameters.relay.mode.serving.limits.notifications",
	"mac_state.current_parameters.relay.mode.serving.limits.notifications.bucket_size",
	"mac_state.current_parameters.relay.mode.serving.limits.notifications.reload_rate",
	"mac_state.current_parameters.relay.mode.serving.limits.overall",
	"mac_state.current_parameters.relay.mode.serving.limits.overall.bucket_size",
	"mac_state.current_parameters.relay.mode.serving.limits.overall.reload_rate",
	"mac_state.current_parameters.relay.mode.serving.limits.reset_behavior",
	"mac_state.current_parameters.relay.mode.serving.limits.uplink_messages",
	"mac_state.current_parameters.relay.mode.serving.limits.uplink_messages.bucket_size",
	"mac_state.current_parameters.relay.mode.serving.limits.uplink_messages.reload_rate",
	"mac_state.current_parameters.relay.mode.serving.second_channel",
	"mac_state.current_parameters.relay.mode.serving.second_channel.ack_offset",
	"mac_state.current_parameters.relay.mode.serving.second_channel.data_rate_index",
	"mac_state.current_parameters.relay.mode.serving.second_channel.frequency",
	"mac_state.current_parameters.relay.mode.serving.uplink_forwarding_rules",
	"mac_state.current_parameters.rx1_data_rate_offset",
	"mac_state.current_parameters.rx1_delay",
	"mac_state.current_parameters.rx2_data_rate_index",
	"mac_state.current_parameters.rx2_frequency",
	"mac_state.current_parameters.uplink_dwell_time",
	"mac_state.current_parameters.uplink_dwell_time.value",
	"mac_state.desired_parameters",
	"mac_state.desired_parameters.adr_ack_delay_exponent",
	"mac_state.desired_parameters.adr_ack_delay_exponent.value",
	"mac_state.desired_parameters.adr_ack_limit_exponent",
	"mac_state.desired_parameters.adr_ack_limit_exponent.value",
	"mac_state.desired_parameters.adr_data_rate_index",
	"mac_state.desired_parameters.adr_nb_trans",
	"mac_state.desired_parameters.adr_tx_power_index",
	"mac_state.desired_parameters.beacon_frequency",
	"mac_state.desired_parameters.channels",
	"mac_state.desired_parameters.downlink_dwell_time",
	"mac_state.desired_parameters.downlink_dwell_time.value",
	"mac_state.desired_parameters.max_duty_cycle",
	"mac_state.desired_parameters.max_eirp",
	"mac_state.desired_parameters.ping_slot_data_rate_index_value",
	"mac_state.desired_parameters.ping_slot_data_rate_index_value.value",
	"mac_state.desired_parameters.ping_slot_frequency",
	"mac_state.desired_parameters.rejoin_count_periodicity",
	"mac_state.desired_parameters.rejoin_time_periodicity",
	"mac_state.desired_parameters.relay",
	"mac_state.desired_parameters.relay.mode",
	"mac_state.desired_parameters.relay.mode.served",
	"mac_state.desired_parameters.relay.mode.served.backoff",
	"mac_state.desired_parameters.relay.mode.served.mode",
	"mac_state.desired_parameters.relay.mode.served.mode.always",
	"mac_state.desired_parameters.relay.mode.served.mode.dynamic",
	"mac_state.desired_parameters.relay.mode.served.mode.dynamic.smart_enable_level",
	"mac_state.desired_parameters.relay.mode.served.mode.end_device_controlled",
	"mac_state.desired_parameters.relay.mode.served.second_channel",
	"mac_state.desired_parameters.relay.mode.served.second_channel.ack_offset",
	"mac_state.desired_parameters.relay.mode.served.second_channel.data_rate_index",
	"mac_state.desired_parameters.relay.mode.served.second_channel.frequency",
	"mac_state.desired_parameters.relay.mode.served.serving_device_id",
	"mac_state.desired_parameters.relay.mode.serving",
	"mac_state.desired_parameters.relay.mode.serving.cad_periodicity",
	"mac_state.desired_parameters.relay.mode.serving.default_channel_index",
	"mac_state.desired_parameters.relay.mode.serving.limits",
	"mac_state.desired_parameters.relay.mode.serving.limits.join_requests",
	"mac_state.desired_parameters.relay.mode.serving.limits.join_requests.bucket_size",
	"mac_state.desired_parameters.relay.mode.serving.limits.join_requests.reload_rate",
	"mac_state.desired_parameters.relay.mode.serving.limits.notifications",
	"mac_state.desired_parameters.relay.mode.serving.limits.notifications.bucket_size",
	"mac_state.desired_parameters.relay.mode.serving.limits.notifications.reload_rate",
	"mac_state.desired_parameters.relay.mode.serving.limits.overall",
	"mac_state.desired_parameters.relay.mode.serving.limits.overall.bucket_size",
	"mac_state.desired_parameters.relay.mode.serving.limits.overall.reload_rate",
	"mac_state.desired_parameters.relay.mode.serving.limits.reset_behavior",
	"mac_state.desired_parameters.relay.mode.serving.limits.uplink_messages",
	"mac_state.desired_parameters.relay.mode.serving.limits.uplink_messages.bucket_size",
	"mac_state.desired_parameters.relay.mode.serving.limits.uplink_messages.reload_rate",
	"mac_state.desired_parameters.relay.mode.serving.second_channel",
	"mac_state.desired_parameters.relay.mode.serving.second_channel.ack_offset",
	"mac_state.desired_parameters.relay.mode.serving.second_channel.data_rate_index",
	"mac_state.desired_parameters.relay.mode.serving.second_channel.frequency",
	"mac_state.desired_parameters.relay.mode.serving.uplink_forwarding_rules",
	"mac_state.desired_parameters.rx1_data_rate_offset",
	"mac_state.desired_parameters.rx1_delay",
	"mac_state.desired_parameters.rx2_data_rate_index",
	"mac_state.desired_parameters.rx2_frequency",
	"mac_state.desired_parameters.uplink_dwell_time",
	"mac_state.desired_parameters.uplink_dwell_time.value",
	"mac_state.device_class",
	"mac_state.last_adr_change_f_cnt_up",
	"mac_state.last_confirmed_downlink_at",
	"mac_state.last_dev_status_f_cnt_up",
	"mac_state.last_downlink_at",
	"mac_state.last_network_initiated_downlink_at",
	"mac_state.lorawan_version",
	"mac_state.pending_application_downlink",
	"mac_state.pending_application_downlink.class_b_c",
	"mac_state.pending_application_downlink.class_b_c.absolute_time",
	"mac_state.pending_application_downlink.class_b_c.gateways",
	"mac_state.pending_application_downlink.confirmed",
	"mac_state.pending_application_downlink.correlation_ids",
	"mac_state.pending_application_downlink.f_cnt",
	"mac_state.pending_application_downlink.f_port",
	"mac_state.pending_application_downlink.frm_payload",
	"mac_state.pending_application_downlink.priority",
	"mac_state.pending_application_downlink.session_key_id",
	"mac_state.pending_relay_downlink",
	"mac_state.pending_relay_downlink.raw_payload",
	"mac_state.pending_requests",
	"mac_state.ping_slot_periodicity",
	"mac_state.ping_slot_periodicity.value",
	"mac_state.queued_responses",
	"mac_state.recent_downlinks",
	"mac_state.recent_mac_command_identifiers",
	"mac_state.recent_uplinks",
	"mac_state.rejected_adr_data_rate_indexes",
	"mac_state.rejected_adr_tx_power_indexes",
	"mac_state.rejected_data_rate_ranges",
	"mac_state.rejected_frequencies",
	"mac_state.rx_windows_available",
	"max_frequency",
	"min_frequency",
	"multicast",
	"pending_mac_state",
	"pending_mac_state.current_parameters",
	"pending_mac_state.current_parameters.adr_ack_delay_exponent",
	"pending_mac_state.current_parameters.adr_ack_delay_exponent.value",
	"pending_mac_state.current_parameters.adr_ack_limit_exponent",
	"pending_mac_state.current_parameters.adr_ack_limit_exponent.value",
	"pending_mac_state.current_parameters.adr_data_rate_index",
	"pending_mac_state.current_parameters.adr_nb_trans",
	"pending_mac_state.current_parameters.adr_tx_power_index",
	"pending_mac_state.current_parameters.beacon_frequency",
	"pending_mac_state.current_parameters.channels",
	"pending_mac_state.current_parameters.downlink_dwell_time",
	"pending_mac_state.current_parameters.downlink_dwell_time.value",
	"pending_mac_state.current_parameters.max_duty_cycle",
	"pending_mac_state.current_parameters.max_eirp",
	"pending_mac_state.current_parameters.ping_slot_data_rate_index_value",
	"pending_mac_state.current_parameters.ping_slot_data_rate_index_value.value",
	"pending_mac_state.current_parameters.ping_slot_frequency",
	"pending_mac_state.current_parameters.rejoin_count_periodicity",
	"pending_mac_state.current_parameters.rejoin_time_periodicity",
	"pending_mac_state.current_parameters.relay",
	"pending_mac_state.current_parameters.relay.mode",
	"pending_mac_state.current_parameters.relay.mode.served",
	"pending_mac_state.current_parameters.relay.mode.served.backoff",
	"pending_mac_state.current_parameters.relay.mode.served.mode",
	"pending_mac_state.current_parameters.relay.mode.served.mode.always",
	"pending_mac_state.current_parameters.relay.mode.served.mode.dynamic",
	"pending_mac_state.current_parameters.relay.mode.served.mode.dynamic.smart_enable_level",
	"pending_mac_state.current_parameters.relay.mode.served.mode.end_device_controlled",
	"pending_mac_state.current_parameters.relay.mode.served.second_channel",
	"pending_mac_state.current_parameters.relay.mode.served.second_channel.ack_offset",
	"pending_mac_state.current_parameters.relay.mode.served.second_channel.data_rate_index",
	"pending_mac_state.current_parameters.relay.mode.served.second_channel.frequency",
	"pending_mac_state.current_parameters.relay.mode.served.serving_device_id",
	"pending_mac_state.current_parameters.relay.mode.serving",
	"pending_mac_state.current_parameters.relay.mode.serving.cad_periodicity",
	"pending_mac_state.current_parameters.relay.mode.serving.default_channel_index",
	"pending_mac_state.current_parameters.relay.mode.serving.limits",
	"pending_mac_state.current_parameters.relay.mode.serving.limits.join_requests",
	"pending_mac_state.current_parameters.relay.mode.serving.limits.join_requests.bucket_size",
	"pending_mac_state.current_parameters.relay.mode.serving.limits.join_requests.reload_rate",
	"pending_mac_state.current_parameters.relay.mode.serving.limits.notifications",
	"pending_mac_state.current_parameters.relay.mode.serving.limits.notifications.bucket_size",
	"pending_mac_state.current_parameters.relay.mode.serving.limits.notifications.reload_rate",
	"pending_mac_state.current_parameters.relay.mode.serving.limits.overall",
	"pending_mac_state.current_parameters.relay.mode.serving.limits.overall.bucket_size",
	"pending_mac_state.current_parameters.relay.mode.serving.limits.overall.reload_rate",
	"pending_mac_state.current_parameters.relay.mode.serving.limits.reset_behavior",
	"pending_mac_state.current_parameters.relay.mode.serving.limits.uplink_messages",
	"pending_mac_state.current_parameters.relay.mode.serving.limits.uplink_messages.bucket_size",
	"pending_mac_state.current_parameters.relay.mode.serving.limits.uplink_messages.reload_rate",
	"pending_mac_state.current_parameters.relay.mode.serving.second_channel",
	"pending_mac_state.current_parameters.relay.mode.serving.second_channel.ack_offset",
	"pending_mac_state.current_parameters.relay.mode.serving.second_channel.data_rate_index",
	"pending_mac_state.current_parameters.relay.mode.serving.second_channel.frequency",
	"pending_mac_state.current_parameters.relay.mode.serving.uplink_forwarding_rules",
	"pending_mac_state.current_parameters.rx1_data_rate_offset",
	"pending_mac_state.current_parameters.rx1_delay",
	"pending_mac_state.current_parameters.rx2_data_rate_index",
	"pending_mac_state.current_parameters.rx2_frequency",
	"pending_mac_state.current_parameters.uplink_dwell_time",
	"pending_mac_state.current_parameters.uplink_dwell_time.value",
	"pending_mac_state.desired_parameters",
	"pending_mac_state.desired_parameters.adr_ack_delay_exponent",
	"pending_mac_state.desired_parameters.adr_ack_delay_exponent.value",
	"pending_mac_state.desired_parameters.adr_ack_limit_exponent",
	"pending_mac_state.desired_parameters.adr_ack_limit_exponent.value",
	"pending_mac_state.desired_parameters.adr_data_rate_index",
	"pending_mac_state.desired_parameters.adr_nb_trans",
	"pending_mac_state.desired_parameters.adr_tx_power_index",
	"pending_mac_state.desired_parameters.beacon_frequency",
	"pending_mac_state.desired_parameters.channels",
	"pending_mac_state.desired_parameters.downlink_dwell_time",
	"pending_mac_state.desired_parameters.downlink_dwell_time.value",
	"pending_mac_state.desired_parameters.max_duty_cycle",
	"pending_mac_state.desired_parameters.max_eirp",
	"pending_mac_state.desired_parameters.ping_slot_data_rate_index_value",
	"pending_mac_state.desired_parameters.ping_slot_data_rate_index_value.value",
	"pending_mac_state.desired_parameters.ping_slot_frequency",
	"pending_mac_state.desired_parameters.rejoin_count_periodicity",
	"pending_mac_state.desired_parameters.rejoin_time_periodicity",
	"pending_mac_state.desired_parameters.relay",
	"pending_mac_state.desired_parameters.relay.mode",
	"pending_mac_state.desired_parameters.relay.mode.served",
	"pending_mac_state.desired_parameters.relay.mode.served.backoff",
	"pending_mac_state.desired_parameters.relay.mode.served.mode",
	"pending_mac_state.desired_parameters.relay.mode.served.mode.always",
	"pending_mac_state.desired_parameters.relay.mode.served.mode.dynamic",
	"pending_mac_state.desired_parameters.relay.mode.served.mode.dynamic.smart_enable_level",
	"pending_mac_state.desired_parameters.relay.mode.served.mode.end_device_controlled",
	"pending_mac_state.desired_parameters.relay.mode.served.second_channel",
	"pending_mac_state.desired_parameters.relay.mode.served.second_channel.ack_offset",
	"pending_mac_state.desired_parameters.relay.mode.served.second_channel.data_rate_index",
	"pending_mac_state.desired_parameters.relay.mode.served.second_channel.frequency",
	"pending_mac_state.desired_parameters.relay.mode.served.serving_device_id",
	"pending_mac_state.desired_parameters.relay.mode.serving",
	"pending_mac_state.desired_parameters.relay.mode.serving.cad_periodicity",
	"pending_mac_state.desired_parameters.relay.mode.serving.default_channel_index",
	"pending_mac_state.desired_parameters.relay.mode.serving.limits",
	"pending_mac_state.desired_parameters.relay.mode.serving.limits.join_requests",
	"pending_mac_state.desired_parameters.relay.mode.serving.limits.join_requests.bucket_size",
	"pending_mac_state.desired_parameters.relay.mode.serving.limits.join_requests.reload_rate",
	"pending_mac_state.desired_parameters.relay.mode.serving.limits.notifications",
	"pending_mac_state.desired_parameters.relay.mode.serving.limits.notifications.bucket_size",
	"pending_mac_state.desired_parameters.relay.mode.serving.limits.notifications.reload_rate",
	"pending_mac_state.desired_parameters.relay.mode.serving.limits.overall",
	"pending_mac_state.desired_parameters.relay.mode.serving.limits.overall.bucket_size",
	"pending_mac_state.desired_parameters.relay.mode.serving.limits.overall.reload_rate",
	"pending_mac_state.desired_parameters.relay.mode.serving.limits.reset_behavior",
	"pending_mac_state.desired_parameters.relay.mode.serving.limits.uplink_messages",
	"pending_mac_state.desired_parameters.relay.mode.serving.limits.uplink_messages.bucket_size",
	"pending_mac_state.desired_parameters.relay.mode.serving.limits.uplink_messages.reload_rate",
	"pending_mac_state.desired_parameters.relay.mode.serving.second_channel",
	"pending_mac_state.desired_parameters.relay.mode.serving.second_channel.ack_offset",
	"pending_mac_state.desired_parameters.relay.mode.serving.second_channel.data_rate_index",
	"pending_mac_state.desired_parameters.relay.mode.serving.second_channel.frequency",
	"pending_mac_state.desired_parameters.relay.mode.serving.uplink_forwarding_rules",
	"pending_mac_state.desired_parameters.rx1_data_rate_offset",
	"pending_mac_state.desired_parameters.rx1_delay",
	"pending_mac_state.desired_parameters.rx2_data_rate_index",
	"pending_mac_state.desired_parameters.rx2_frequency",
	"pending_mac_state.desired_parameters.uplink_dwell_time",
	"pending_mac_state.desired_parameters.uplink_dwell_time.value",
	"pending_mac_state.device_class",
	"pending_mac_state.last_adr_change_f_cnt_up",
	"pending_mac_state.last_confirmed_downlink_at",
	"pending_mac_state.last_dev_status_f_cnt_up",
	"pending_mac_state.last_downlink_at",
	"pending_mac_state.last_network_initiated_downlink_at",
	"pending_mac_state.lorawan_version",
	"pending_mac_state.pending_join_request",
	"pending_mac_state.pending_join_request.cf_list",
	"pending_mac_state.pending_join_request.cf_list.ch_masks",
	"pending_mac_state.pending_join_request.cf_list.freq",
	"pending_mac_state.pending_join_request.cf_list.type",
	"pending_mac_state.pending_join_request.downlink_settings",
	"pending_mac_state.pending_join_request.downlink_settings.opt_neg",
	"pending_mac_state.pending_join_request.downlink_settings.rx1_dr_offset",
	"pending_mac_state.pending_join_request.downlink_settings.rx2_dr",
	"pending_mac_state.pending_join_request.rx_delay",
	"pending_mac_state.ping_slot_periodicity",
	"pending_mac_state.ping_slot_periodicity.value",
	"pending_mac_state.queued_join_accept",
	"pending_mac_state.queued_join_accept.correlation_ids",
	"pending_mac_state.queued_join_accept.dev_addr",
	"pending_mac_state.queued_join_accept.keys",
	"pending_mac_state.queued_join_accept.keys.app_s_key",
	"pending_mac_state.queued_join_accept.keys.app_s_key.encrypted_key",
	"pending_mac_state.queued_join_accept.keys.app_s_key.kek_label",
	"pending_mac_state.queued_join_accept.keys.app_s_key.key",
	"pending_mac_state.queued_join_accept.keys.f_nwk_s_int_key",
	"pending_mac_state.queued_join_accept.keys.f_nwk_s_int_key.key",
	"pending_mac_state.queued_join_accept.keys.nwk_s_enc_key",
	"pending_mac_state.queued_join_accept.keys.nwk_s_enc_key.key",
	"pending_mac_state.queued_join_accept.keys.s_nwk_s_int_key",
	"pending_mac_state.queued_join_accept.keys.s_nwk_s_int_key.key",
	"pending_mac_state.queued_join_accept.keys.session_key_id",
	"pending_mac_state.queued_join_accept.net_id",
	"pending_mac_state.queued_join_accept.payload",
	"pending_mac_state.queued_join_accept.request",
	"pending_mac_state.queued_join_accept.request.cf_list",
	"pending_mac_state.queued_join_accept.request.cf_list.ch_masks",
	"pending_mac_state.queued_join_accept.request.cf_list.freq",
	"pending_mac_state.queued_join_accept.request.cf_list.type",
	"pending_mac_state.queued_join_accept.request.downlink_settings",
	"pending_mac_state.queued_join_accept.request.downlink_settings.opt_neg",
	"pending_mac_state.queued_join_accept.request.downlink_settings.rx1_dr_offset",
	"pending_mac_state.queued_join_accept.request.downlink_settings.rx2_dr",
	"pending_mac_state.queued_join_accept.request.rx_delay",
	"pending_mac_state.recent_downlinks",
	"pending_mac_state.recent_mac_command_identifiers",
	"pending_mac_state.recent_uplinks",
	"pending_mac_state.rejected_adr_data_rate_indexes",
	"pending_mac_state.rejected_adr_tx_power_indexes",
	"pending_mac_state.rejected_data_rate_ranges",
	"pending_mac_state.rejected_frequencies",
	"pending_mac_state.rx_windows_available",
	"pending_session",
	"pending_session.dev_addr",
	"pending_session.keys",
	"pending_session.keys.f_nwk_s_int_key",
	"pending_session.keys.f_nwk_s_int_key.key",
	"pending_session.keys.nwk_s_enc_key",
	"pending_session.keys.nwk_s_enc_key.key",
	"pending_session.keys.s_nwk_s_int_key",
	"pending_session.keys.s_nwk_s_int_key.key",
	"pending_session.keys.session_key_id",
	"power_state",
	"session",
	"session.dev_addr",
	"session.keys",
	"session.keys.f_nwk_s_int_key",
	"session.keys.f_nwk_s_int_key.key",
	"session.keys.nwk_s_enc_key",
	"session.keys.nwk_s_enc_key.key",
	"session.keys.s_nwk_s_int_key",
	"session.keys.s_nwk_s_int_key.key",
	"session.keys.session_key_id",
	"session.last_conf_f_cnt_down",
	"session.last_f_cnt_up",
	"session.last_n_f_cnt_down",
	"session.started_at",
	"supports_class_b",
	"supports_class_c",
	"supports_join",
	"updated_at",
	"version_ids",
	"version_ids.band_id",
	"version_ids.brand_id",
	"version_ids.firmware_version",
	"version_ids.hardware_version",
	"version_ids.model_id",
}

type RPCFieldMaskPathValue struct {
	All     []string
	Allowed []string
	Set     bool
}

// RPCFieldMaskPaths lists the field mask paths for each RPC in this API.
var RPCFieldMaskPaths = map[string]RPCFieldMaskPathValue{
	// Applications:
	"/ttn.lorawan.v3.ApplicationRegistry/Get": {
		All:     ApplicationFieldPathsNested,
		Allowed: ApplicationFieldPathsNested,
	},
	"/ttn.lorawan.v3.ApplicationRegistry/List": {
		All:     ApplicationFieldPathsNested,
		Allowed: ApplicationFieldPathsNested,
	},
	"/ttn.lorawan.v3.ApplicationRegistry/Update": {
		All:     ApplicationFieldPathsNested,
		Allowed: omitFields(ApplicationFieldPathsNested, "dev_eui_counter"),
		Set:     true,
	},
	"/ttn.lorawan.v3.EntityRegistrySearch/SearchApplications": {
		All:     ApplicationFieldPathsNested,
		Allowed: ApplicationFieldPathsNested,
	},

	// Application Activation Settings:
	"/ttn.lorawan.v3.ApplicationActivationSettingRegistry/Get": {
		All:     ApplicationActivationSettingsFieldPathsNested,
		Allowed: ApplicationActivationSettingsFieldPathsNested,
	},
	"/ttn.lorawan.v3.ApplicationActivationSettingRegistry/Set": {
		All:     ApplicationActivationSettingsFieldPathsNested,
		Allowed: ApplicationActivationSettingsFieldPathsNested,
		Set:     true,
	},
	"/ttn.lorawan.v3.ApplicationActivationSettingRegistry/Delete": {
		All:     ApplicationActivationSettingsFieldPathsNested,
		Allowed: ApplicationActivationSettingsFieldPathsNested,
	},

	// Application Webhook Templates:
	"/ttn.lorawan.v3.ApplicationWebhookRegistry/GetTemplate": {
		All:     ApplicationWebhookTemplateFieldPathsNested,
		Allowed: ApplicationWebhookTemplateFieldPathsNested,
	},
	"/ttn.lorawan.v3.ApplicationWebhookRegistry/ListTemplates": {
		All:     ApplicationWebhookTemplateFieldPathsNested,
		Allowed: ApplicationWebhookTemplateFieldPathsNested,
	},

	// Application Webhooks:
	"/ttn.lorawan.v3.ApplicationWebhookRegistry/Get": {
		All:     ApplicationWebhookFieldPathsNested,
		Allowed: ApplicationWebhookFieldPathsNested,
	},
	"/ttn.lorawan.v3.ApplicationWebhookRegistry/List": {
		All:     ApplicationWebhookFieldPathsNested,
		Allowed: ApplicationWebhookFieldPathsNested,
	},
	"/ttn.lorawan.v3.ApplicationWebhookRegistry/Set": {
		All:     ApplicationWebhookFieldPathsNested,
		Allowed: ApplicationWebhookFieldPathsNested,
		Set:     true,
	},

	// Application PubSubs:
	"/ttn.lorawan.v3.ApplicationPubSubRegistry/Get": {
		All:     ApplicationPubSubFieldPathsNested,
		Allowed: ApplicationPubSubFieldPathsNested,
	},
	"/ttn.lorawan.v3.ApplicationPubSubRegistry/List": {
		All:     ApplicationPubSubFieldPathsNested,
		Allowed: ApplicationPubSubFieldPathsNested,
	},
	"/ttn.lorawan.v3.ApplicationPubSubRegistry/Set": {
		All:     ApplicationPubSubFieldPathsNested,
		Allowed: ApplicationPubSubFieldPathsNested,
		Set:     true,
	},

	// Application Packages:
	"/ttn.lorawan.v3.ApplicationPackageRegistry/GetAssociation": {
		All:     ApplicationPackageAssociationFieldPathsNested,
		Allowed: ApplicationPackageAssociationFieldPathsNested,
	},
	"/ttn.lorawan.v3.ApplicationPackageRegistry/ListAssociations": {
		All:     ApplicationPackageAssociationFieldPathsNested,
		Allowed: ApplicationPackageAssociationFieldPathsNested,
	},
	"/ttn.lorawan.v3.ApplicationPackageRegistry/SetAssociation": {
		All:     ApplicationPackageAssociationFieldPathsNested,
		Allowed: ApplicationPackageAssociationFieldPathsNested,
		Set:     true,
	},
	"/ttn.lorawan.v3.ApplicationPackageRegistry/GetDefaultAssociation": {
		All:     ApplicationPackageDefaultAssociationFieldPathsNested,
		Allowed: ApplicationPackageDefaultAssociationFieldPathsNested,
	},
	"/ttn.lorawan.v3.ApplicationPackageRegistry/ListDefaultAssociations": {
		All:     ApplicationPackageDefaultAssociationFieldPathsNested,
		Allowed: ApplicationPackageDefaultAssociationFieldPathsNested,
	},
	"/ttn.lorawan.v3.ApplicationPackageRegistry/SetDefaultAssociation": {
		All:     ApplicationPackageDefaultAssociationFieldPathsNested,
		Allowed: ApplicationPackageDefaultAssociationFieldPathsNested,
		Set:     true,
	},

	// Application Links:
	"/ttn.lorawan.v3.As/GetLink": {
		All:     asApplicationLinkFieldPaths,
		Allowed: asApplicationLinkFieldPaths,
	},
	"/ttn.lorawan.v3.As/SetLink": {
		All:     asApplicationLinkFieldPaths,
		Allowed: asApplicationLinkFieldPaths,
		Set:     true,
	},

	// Application API Keys:
	"/ttn.lorawan.v3.ApplicationAccess/UpdateAPIKey": {
		All:     APIKeyFieldPathsNested,
		Allowed: APIKeyFieldPathsNested,
		Set:     true,
	},

	// Clients:
	"/ttn.lorawan.v3.ClientRegistry/Get": {
		All:     ClientFieldPathsNested,
		Allowed: omitFields(ClientFieldPathsNested, "secret"),
	},
	"/ttn.lorawan.v3.ClientRegistry/List": {
		All:     ClientFieldPathsNested,
		Allowed: omitFields(ClientFieldPathsNested, "secret"),
	},
	"/ttn.lorawan.v3.ClientRegistry/Update": {
		All:     ClientFieldPathsNested,
		Allowed: ClientFieldPathsNested,
		Set:     true,
	},
	"/ttn.lorawan.v3.EntityRegistrySearch/SearchClients": {
		All:     ClientFieldPathsNested,
		Allowed: omitFields(ClientFieldPathsNested, "secret"),
	},

	// End Devices:
	"/ttn.lorawan.v3.AsEndDeviceRegistry/Get": {
		All: EndDeviceFieldPathsNested,
		Allowed: []string{
			"formatters",
			"formatters.down_formatter",
			"formatters.down_formatter_parameter",
			"formatters.up_formatter",
			"formatters.up_formatter_parameter",
			"ids",
			"ids.application_ids",
			"ids.application_ids.application_id",
			"ids.dev_addr",
			"ids.dev_eui",
			"ids.device_id",
			"ids.join_eui",
			"pending_session",
			"pending_session.dev_addr",
			"pending_session.keys",
			"pending_session.keys.app_s_key",
			"pending_session.keys.app_s_key.key",
			"pending_session.keys.session_key_id",
			"pending_session.last_a_f_cnt_down",
			"serial_number",
			"session",
			"session.dev_addr",
			"session.keys",
			"session.keys.app_s_key",
			"session.keys.app_s_key.key",
			"session.keys.session_key_id",
			"session.last_a_f_cnt_down",
			"skip_payload_crypto",
			"skip_payload_crypto_override",
			"lora_alliance_profile_ids",
			"lora_alliance_profile_ids.vendor_id",
			"lora_alliance_profile_ids.vendor_profile_id",
			"version_ids",
			"version_ids.band_id",
			"version_ids.brand_id",
			"version_ids.firmware_version",
			"version_ids.hardware_version",
			"version_ids.model_id",
		},
	},
	"/ttn.lorawan.v3.AsEndDeviceRegistry/Set": {
		All: EndDeviceFieldPathsNested,
		Allowed: []string{
			"formatters",
			"formatters.down_formatter",
			"formatters.down_formatter_parameter",
			"formatters.up_formatter",
			"formatters.up_formatter_parameter",
			"ids",
			"ids.application_ids",
			"ids.application_ids.application_id",
			"ids.dev_eui",
			"ids.device_id",
			"ids.join_eui",
			"serial_number",
			"session.dev_addr",
			"session.keys.app_s_key",
			"session.keys.app_s_key.key",
			"session.keys.session_key_id",
			"session.last_a_f_cnt_down",
			"skip_payload_crypto",
			"skip_payload_crypto_override",
			"lora_alliance_profile_ids",
			"lora_alliance_profile_ids.vendor_id",
			"lora_alliance_profile_ids.vendor_profile_id",
			"version_ids",
			"version_ids.band_id",
			"version_ids.brand_id",
			"version_ids.firmware_version",
			"version_ids.hardware_version",
			"version_ids.model_id",
		},
		Set: true,
	},
	"/ttn.lorawan.v3.EndDeviceRegistry/Get": {
		All:     EndDeviceFieldPathsNested,
		Allowed: isEndDeviceReadFieldPaths,
	},
	"/ttn.lorawan.v3.EndDeviceBatchRegistry/Get": {
		All:     EndDeviceFieldPathsNested,
		Allowed: isEndDeviceReadFieldPaths,
	},
	"/ttn.lorawan.v3.EndDeviceRegistry/List": {
		All:     EndDeviceFieldPathsNested,
		Allowed: isEndDeviceReadFieldPaths,
	},
	"/ttn.lorawan.v3.EndDeviceRegistry/Update": {
		All:     EndDeviceFieldPathsNested,
		Allowed: isEndDeviceWriteFieldPaths,
		Set:     true,
	},
	"/ttn.lorawan.v3.EndDeviceRegistrySearch/SearchEndDevices": {
		All:     EndDeviceFieldPathsNested,
		Allowed: isEndDeviceReadFieldPaths,
	},
	"/ttn.lorawan.v3.JsEndDeviceRegistry/Get": {
		All: EndDeviceFieldPathsNested,
		Allowed: []string{
			"application_server_address",
			"application_server_id",
			"application_server_kek_label",
			"claim_authentication_code",
			"claim_authentication_code.value",
			"claim_authentication_code.valid_to",
			"claim_authentication_code.valid_from",
			"ids",
			"ids.application_ids",
			"ids.application_ids.application_id",
			"ids.dev_addr",
			"ids.dev_eui",
			"ids.device_id",
			"ids.join_eui",
			"last_dev_nonce",
			"last_join_nonce",
			"last_rj_count_0",
			"last_rj_count_1",
			"net_id",
			"network_server_address",
			"network_server_kek_label",
			"provisioner_id",
			"provisioning_data",
			"resets_join_nonces",
			"root_keys",
			"root_keys.app_key",
			"root_keys.app_key.key",
			"root_keys.nwk_key",
			"root_keys.nwk_key.key",
			"root_keys.root_key_id",
			"used_dev_nonces",
		},
	},
	"/ttn.lorawan.v3.JsEndDeviceRegistry/Set": {
		All: EndDeviceFieldPathsNested,
		Allowed: []string{
			"application_server_address",
			"application_server_id",
			"application_server_kek_label",
			"claim_authentication_code",
			"claim_authentication_code.value",
			"claim_authentication_code.valid_to",
			"claim_authentication_code.valid_from",
			"ids",
			"ids.application_ids",
			"ids.application_ids.application_id",
			"ids.dev_eui",
			"ids.device_id",
			"ids.join_eui",
			"last_dev_nonce",
			"last_join_nonce",
			"last_rj_count_0",
			"last_rj_count_1",
			"net_id",
			"network_server_address",
			"network_server_kek_label",
			"provisioner_id",
			"provisioning_data",
			"resets_join_nonces",
			"root_keys",
			"root_keys.app_key",
			"root_keys.app_key.key",
			"root_keys.nwk_key",
			"root_keys.nwk_key.key",
			"root_keys.root_key_id",
			"used_dev_nonces",
		},
		Set: true,
	},
	"/ttn.lorawan.v3.NsEndDeviceRegistry/Get": {
		All:     EndDeviceFieldPathsNested,
		Allowed: nsEndDeviceReadFieldPaths[:],
	},
	"/ttn.lorawan.v3.NsEndDeviceRegistry/Set": {
		All: EndDeviceFieldPathsNested,
		Allowed: []string{
			"battery_percentage",
			"downlink_margin",
			"frequency_plan_id",
			"ids",
			"ids.application_ids",
			"ids.application_ids.application_id",
			"ids.dev_eui",
			"ids.device_id",
			"ids.join_eui",
			"last_dev_status_received_at",
			"lorawan_phy_version",
			"lorawan_version",
			"mac_settings",
			"mac_settings.adr",
			"mac_settings.adr.mode",
			"mac_settings.adr.mode.disabled",
			"mac_settings.adr.mode.dynamic",
			"mac_settings.adr.mode.dynamic.channel_steering",
			"mac_settings.adr.mode.dynamic.channel_steering.mode",
			"mac_settings.adr.mode.dynamic.channel_steering.mode.disabled",
			"mac_settings.adr.mode.dynamic.channel_steering.mode.lora_narrow",
			"mac_settings.adr.mode.dynamic.margin",
			"mac_settings.adr.mode.dynamic.max_data_rate_index",
			"mac_settings.adr.mode.dynamic.max_data_rate_index.value",
			"mac_settings.adr.mode.dynamic.max_nb_trans",
			"mac_settings.adr.mode.dynamic.max_tx_power_index",
			"mac_settings.adr.mode.dynamic.min_data_rate_index",
			"mac_settings.adr.mode.dynamic.min_data_rate_index.value",
			"mac_settings.adr.mode.dynamic.min_nb_trans",
			"mac_settings.adr.mode.dynamic.min_tx_power_index",
			"mac_settings.adr.mode.dynamic.overrides",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_0",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_0.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_0.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_1",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_1.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_1.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_10",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_10.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_10.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_11",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_11.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_11.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_12",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_12.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_12.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_13",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_13.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_13.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_14",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_14.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_14.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_15",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_15.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_15.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_2",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_2.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_2.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_3",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_3.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_3.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_4",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_4.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_4.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_5",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_5.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_5.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_6",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_6.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_6.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_7",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_7.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_7.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_8",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_8.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_8.min_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_9",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_9.max_nb_trans",
			"mac_settings.adr.mode.dynamic.overrides.data_rate_9.min_nb_trans",
			"mac_settings.adr.mode.static",
			"mac_settings.adr.mode.static.data_rate_index",
			"mac_settings.adr.mode.static.nb_trans",
			"mac_settings.adr.mode.static.tx_power_index",
			"mac_settings.adr_margin",
			"mac_settings.beacon_frequency",
			"mac_settings.beacon_frequency.value",
			"mac_settings.class_b_timeout",
			"mac_settings.class_b_c_downlink_interval",
			"mac_settings.class_c_timeout",
			"mac_settings.desired_adr_ack_delay_exponent",
			"mac_settings.desired_adr_ack_delay_exponent.value",
			"mac_settings.desired_adr_ack_limit_exponent",
			"mac_settings.desired_adr_ack_limit_exponent.value",
			"mac_settings.desired_beacon_frequency",
			"mac_settings.desired_beacon_frequency.value",
			"mac_settings.desired_max_duty_cycle",
			"mac_settings.desired_max_duty_cycle.value",
			"mac_settings.desired_max_eirp",
			"mac_settings.desired_max_eirp.value",
			"mac_settings.desired_ping_slot_data_rate_index",
			"mac_settings.desired_ping_slot_data_rate_index.value",
			"mac_settings.desired_ping_slot_frequency",
			"mac_settings.desired_ping_slot_frequency.value",
			"mac_settings.desired_relay",
			"mac_settings.desired_relay.mode",
			"mac_settings.desired_relay.mode.served",
			"mac_settings.desired_relay.mode.served.backoff",
			"mac_settings.desired_relay.mode.served.mode",
			"mac_settings.desired_relay.mode.served.mode.always",
			"mac_settings.desired_relay.mode.served.mode.dynamic",
			"mac_settings.desired_relay.mode.served.mode.dynamic.smart_enable_level",
			"mac_settings.desired_relay.mode.served.mode.end_device_controlled",
			"mac_settings.desired_relay.mode.served.second_channel",
			"mac_settings.desired_relay.mode.served.second_channel.ack_offset",
			"mac_settings.desired_relay.mode.served.second_channel.data_rate_index",
			"mac_settings.desired_relay.mode.served.second_channel.frequency",
			"mac_settings.desired_relay.mode.served.serving_device_id",
			"mac_settings.desired_relay.mode.serving",
			"mac_settings.desired_relay.mode.serving.cad_periodicity",
			"mac_settings.desired_relay.mode.serving.default_channel_index",
			"mac_settings.desired_relay.mode.serving.limits",
			"mac_settings.desired_relay.mode.serving.limits.join_requests",
			"mac_settings.desired_relay.mode.serving.limits.join_requests.bucket_size",
			"mac_settings.desired_relay.mode.serving.limits.join_requests.reload_rate",
			"mac_settings.desired_relay.mode.serving.limits.notifications",
			"mac_settings.desired_relay.mode.serving.limits.notifications.bucket_size",
			"mac_settings.desired_relay.mode.serving.limits.notifications.reload_rate",
			"mac_settings.desired_relay.mode.serving.limits.overall",
			"mac_settings.desired_relay.mode.serving.limits.overall.bucket_size",
			"mac_settings.desired_relay.mode.serving.limits.overall.reload_rate",
			"mac_settings.desired_relay.mode.serving.limits.reset_behavior",
			"mac_settings.desired_relay.mode.serving.limits.uplink_messages",
			"mac_settings.desired_relay.mode.serving.limits.uplink_messages.bucket_size",
			"mac_settings.desired_relay.mode.serving.limits.uplink_messages.reload_rate",
			"mac_settings.desired_relay.mode.serving.second_channel",
			"mac_settings.desired_relay.mode.serving.second_channel.ack_offset",
			"mac_settings.desired_relay.mode.serving.second_channel.data_rate_index",
			"mac_settings.desired_relay.mode.serving.second_channel.frequency",
			"mac_settings.desired_relay.mode.serving.uplink_forwarding_rules",
			"mac_settings.desired_rx1_data_rate_offset",
			"mac_settings.desired_rx1_data_rate_offset.value",
			"mac_settings.desired_rx1_delay",
			"mac_settings.desired_rx1_delay.value",
			"mac_settings.desired_rx2_data_rate_index",
			"mac_settings.desired_rx2_data_rate_index.value",
			"mac_settings.desired_rx2_frequency",
			"mac_settings.desired_rx2_frequency.value",
			"mac_settings.factory_preset_frequencies",
			"mac_settings.max_duty_cycle",
			"mac_settings.max_duty_cycle.value",
			"mac_settings.ping_slot_data_rate_index",
			"mac_settings.ping_slot_data_rate_index.value",
			"mac_settings.ping_slot_frequency",
			"mac_settings.ping_slot_frequency.value",
			"mac_settings.ping_slot_periodicity",
			"mac_settings.ping_slot_periodicity.value",
			"mac_settings.relay",
			"mac_settings.relay.mode",
			"mac_settings.relay.mode.served",
			"mac_settings.relay.mode.served.backoff",
			"mac_settings.relay.mode.served.mode",
			"mac_settings.relay.mode.served.mode.always",
			"mac_settings.relay.mode.served.mode.dynamic",
			"mac_settings.relay.mode.served.mode.dynamic.smart_enable_level",
			"mac_settings.relay.mode.served.mode.end_device_controlled",
			"mac_settings.relay.mode.served.second_channel",
			"mac_settings.relay.mode.served.second_channel.ack_offset",
			"mac_settings.relay.mode.served.second_channel.data_rate_index",
			"mac_settings.relay.mode.served.second_channel.frequency",
			"mac_settings.relay.mode.served.serving_device_id",
			"mac_settings.relay.mode.serving",
			"mac_settings.relay.mode.serving.cad_periodicity",
			"mac_settings.relay.mode.serving.default_channel_index",
			"mac_settings.relay.mode.serving.limits",
			"mac_settings.relay.mode.serving.limits.join_requests",
			"mac_settings.relay.mode.serving.limits.join_requests.bucket_size",
			"mac_settings.relay.mode.serving.limits.join_requests.reload_rate",
			"mac_settings.relay.mode.serving.limits.notifications",
			"mac_settings.relay.mode.serving.limits.notifications.bucket_size",
			"mac_settings.relay.mode.serving.limits.notifications.reload_rate",
			"mac_settings.relay.mode.serving.limits.overall",
			"mac_settings.relay.mode.serving.limits.overall.bucket_size",
			"mac_settings.relay.mode.serving.limits.overall.reload_rate",
			"mac_settings.relay.mode.serving.limits.reset_behavior",
			"mac_settings.relay.mode.serving.limits.uplink_messages",
			"mac_settings.relay.mode.serving.limits.uplink_messages.bucket_size",
			"mac_settings.relay.mode.serving.limits.uplink_messages.reload_rate",
			"mac_settings.relay.mode.serving.second_channel",
			"mac_settings.relay.mode.serving.second_channel.ack_offset",
			"mac_settings.relay.mode.serving.second_channel.data_rate_index",
			"mac_settings.relay.mode.serving.second_channel.frequency",
			"mac_settings.relay.mode.serving.uplink_forwarding_rules",
			"mac_settings.resets_f_cnt",
			"mac_settings.resets_f_cnt.value",
			"mac_settings.rx1_data_rate_offset",
			"mac_settings.rx1_data_rate_offset.value",
			"mac_settings.rx1_delay",
			"mac_settings.rx1_delay.value",
			"mac_settings.rx2_data_rate_index",
			"mac_settings.rx2_data_rate_index.value",
			"mac_settings.rx2_frequency",
			"mac_settings.rx2_frequency.value",
			"mac_settings.schedule_downlinks",
			"mac_settings.schedule_downlinks.value",
			"mac_settings.status_count_periodicity",
			"mac_settings.status_time_periodicity",
			"mac_settings.supports_32_bit_f_cnt",
			"mac_settings.supports_32_bit_f_cnt.value",
			"mac_settings.use_adr",
			"mac_settings.use_adr.value",
			"mac_settings.uplink_dwell_time",
			"mac_settings.uplink_dwell_time.value",
			"mac_settings.downlink_dwell_time",
			"mac_settings.downlink_dwell_time.value",
			"mac_state",
			"mac_state.current_parameters",
			"mac_state.current_parameters.adr_ack_delay_exponent",
			"mac_state.current_parameters.adr_ack_delay_exponent.value",
			"mac_state.current_parameters.adr_ack_limit_exponent",
			"mac_state.current_parameters.adr_ack_limit_exponent.value",
			"mac_state.current_parameters.adr_data_rate_index",
			"mac_state.current_parameters.adr_nb_trans",
			"mac_state.current_parameters.adr_tx_power_index",
			"mac_state.current_parameters.beacon_frequency",
			"mac_state.current_parameters.channels",
			"mac_state.current_parameters.downlink_dwell_time",
			"mac_state.current_parameters.downlink_dwell_time.value",
			"mac_state.current_parameters.max_duty_cycle",
			"mac_state.current_parameters.max_eirp",
			"mac_state.current_parameters.ping_slot_data_rate_index_value",
			"mac_state.current_parameters.ping_slot_data_rate_index_value.value",
			"mac_state.current_parameters.ping_slot_frequency",
			"mac_state.current_parameters.rejoin_count_periodicity",
			"mac_state.current_parameters.rejoin_time_periodicity",
			"mac_state.current_parameters.relay",
			"mac_state.current_parameters.relay.mode",
			"mac_state.current_parameters.relay.mode.served",
			"mac_state.current_parameters.relay.mode.served.backoff",
			"mac_state.current_parameters.relay.mode.served.mode",
			"mac_state.current_parameters.relay.mode.served.mode.always",
			"mac_state.current_parameters.relay.mode.served.mode.dynamic",
			"mac_state.current_parameters.relay.mode.served.mode.dynamic.smart_enable_level",
			"mac_state.current_parameters.relay.mode.served.mode.end_device_controlled",
			"mac_state.current_parameters.relay.mode.served.second_channel",
			"mac_state.current_parameters.relay.mode.served.second_channel.ack_offset",
			"mac_state.current_parameters.relay.mode.served.second_channel.data_rate_index",
			"mac_state.current_parameters.relay.mode.served.second_channel.frequency",
			"mac_state.current_parameters.relay.mode.served.serving_device_id",
			"mac_state.current_parameters.relay.mode.serving",
			"mac_state.current_parameters.relay.mode.serving.cad_periodicity",
			"mac_state.current_parameters.relay.mode.serving.default_channel_index",
			"mac_state.current_parameters.relay.mode.serving.limits",
			"mac_state.current_parameters.relay.mode.serving.limits.join_requests",
			"mac_state.current_parameters.relay.mode.serving.limits.join_requests.bucket_size",
			"mac_state.current_parameters.relay.mode.serving.limits.join_requests.reload_rate",
			"mac_state.current_parameters.relay.mode.serving.limits.notifications",
			"mac_state.current_parameters.relay.mode.serving.limits.notifications.bucket_size",
			"mac_state.current_parameters.relay.mode.serving.limits.notifications.reload_rate",
			"mac_state.current_parameters.relay.mode.serving.limits.overall",
			"mac_state.current_parameters.relay.mode.serving.limits.overall.bucket_size",
			"mac_state.current_parameters.relay.mode.serving.limits.overall.reload_rate",
			"mac_state.current_parameters.relay.mode.serving.limits.reset_behavior",
			"mac_state.current_parameters.relay.mode.serving.limits.uplink_messages",
			"mac_state.current_parameters.relay.mode.serving.limits.uplink_messages.bucket_size",
			"mac_state.current_parameters.relay.mode.serving.limits.uplink_messages.reload_rate",
			"mac_state.current_parameters.relay.mode.serving.second_channel",
			"mac_state.current_parameters.relay.mode.serving.second_channel.ack_offset",
			"mac_state.current_parameters.relay.mode.serving.second_channel.data_rate_index",
			"mac_state.current_parameters.relay.mode.serving.second_channel.frequency",
			"mac_state.current_parameters.relay.mode.serving.uplink_forwarding_rules",
			"mac_state.current_parameters.rx1_data_rate_offset",
			"mac_state.current_parameters.rx1_delay",
			"mac_state.current_parameters.rx2_data_rate_index",
			"mac_state.current_parameters.rx2_frequency",
			"mac_state.current_parameters.uplink_dwell_time",
			"mac_state.current_parameters.uplink_dwell_time.value",
			"mac_state.desired_parameters",
			"mac_state.desired_parameters.adr_ack_delay_exponent",
			"mac_state.desired_parameters.adr_ack_delay_exponent.value",
			"mac_state.desired_parameters.adr_ack_limit_exponent",
			"mac_state.desired_parameters.adr_ack_limit_exponent.value",
			"mac_state.desired_parameters.adr_data_rate_index",
			"mac_state.desired_parameters.adr_nb_trans",
			"mac_state.desired_parameters.adr_tx_power_index",
			"mac_state.desired_parameters.beacon_frequency",
			"mac_state.desired_parameters.channels",
			"mac_state.desired_parameters.downlink_dwell_time",
			"mac_state.desired_parameters.downlink_dwell_time.value",
			"mac_state.desired_parameters.max_duty_cycle",
			"mac_state.desired_parameters.max_eirp",
			"mac_state.desired_parameters.ping_slot_data_rate_index_value",
			"mac_state.desired_parameters.ping_slot_data_rate_index_value.value",
			"mac_state.desired_parameters.ping_slot_frequency",
			"mac_state.desired_parameters.rejoin_count_periodicity",
			"mac_state.desired_parameters.rejoin_time_periodicity",
			"mac_state.desired_parameters.relay",
			"mac_state.desired_parameters.relay.mode",
			"mac_state.desired_parameters.relay.mode.served",
			"mac_state.desired_parameters.relay.mode.served.backoff",
			"mac_state.desired_parameters.relay.mode.served.mode",
			"mac_state.desired_parameters.relay.mode.served.mode.always",
			"mac_state.desired_parameters.relay.mode.served.mode.dynamic",
			"mac_state.desired_parameters.relay.mode.served.mode.dynamic.smart_enable_level",
			"mac_state.desired_parameters.relay.mode.served.mode.end_device_controlled",
			"mac_state.desired_parameters.relay.mode.served.second_channel",
			"mac_state.desired_parameters.relay.mode.served.second_channel.ack_offset",
			"mac_state.desired_parameters.relay.mode.served.second_channel.data_rate_index",
			"mac_state.desired_parameters.relay.mode.served.second_channel.frequency",
			"mac_state.desired_parameters.relay.mode.served.serving_device_id",
			"mac_state.desired_parameters.relay.mode.serving",
			"mac_state.desired_parameters.relay.mode.serving.cad_periodicity",
			"mac_state.desired_parameters.relay.mode.serving.default_channel_index",
			"mac_state.desired_parameters.relay.mode.serving.limits",
			"mac_state.desired_parameters.relay.mode.serving.limits.join_requests",
			"mac_state.desired_parameters.relay.mode.serving.limits.join_requests.bucket_size",
			"mac_state.desired_parameters.relay.mode.serving.limits.join_requests.reload_rate",
			"mac_state.desired_parameters.relay.mode.serving.limits.notifications",
			"mac_state.desired_parameters.relay.mode.serving.limits.notifications.bucket_size",
			"mac_state.desired_parameters.relay.mode.serving.limits.notifications.reload_rate",
			"mac_state.desired_parameters.relay.mode.serving.limits.overall",
			"mac_state.desired_parameters.relay.mode.serving.limits.overall.bucket_size",
			"mac_state.desired_parameters.relay.mode.serving.limits.overall.reload_rate",
			"mac_state.desired_parameters.relay.mode.serving.limits.reset_behavior",
			"mac_state.desired_parameters.relay.mode.serving.limits.uplink_messages",
			"mac_state.desired_parameters.relay.mode.serving.limits.uplink_messages.bucket_size",
			"mac_state.desired_parameters.relay.mode.serving.limits.uplink_messages.reload_rate",
			"mac_state.desired_parameters.relay.mode.serving.second_channel",
			"mac_state.desired_parameters.relay.mode.serving.second_channel.ack_offset",
			"mac_state.desired_parameters.relay.mode.serving.second_channel.data_rate_index",
			"mac_state.desired_parameters.relay.mode.serving.second_channel.frequency",
			"mac_state.desired_parameters.relay.mode.serving.uplink_forwarding_rules",
			"mac_state.desired_parameters.rx1_data_rate_offset",
			"mac_state.desired_parameters.rx1_delay",
			"mac_state.desired_parameters.rx2_data_rate_index",
			"mac_state.desired_parameters.rx2_frequency",
			"mac_state.desired_parameters.uplink_dwell_time",
			"mac_state.desired_parameters.uplink_dwell_time.value",
			"mac_state.device_class",
			"mac_state.last_adr_change_f_cnt_up",
			"mac_state.last_confirmed_downlink_at",
			"mac_state.last_dev_status_f_cnt_up",
			"mac_state.last_downlink_at",
			"mac_state.last_network_initiated_downlink_at",
			"mac_state.lorawan_version",
			"mac_state.pending_application_downlink",
			"mac_state.pending_application_downlink.class_b_c",
			"mac_state.pending_application_downlink.class_b_c.absolute_time",
			"mac_state.pending_application_downlink.class_b_c.gateways",
			"mac_state.pending_application_downlink.confirmed",
			"mac_state.pending_application_downlink.correlation_ids",
			"mac_state.pending_application_downlink.f_cnt",
			"mac_state.pending_application_downlink.f_port",
			"mac_state.pending_application_downlink.frm_payload",
			"mac_state.pending_application_downlink.priority",
			"mac_state.pending_application_downlink.session_key_id",
			"mac_state.pending_relay_downlink",
			"mac_state.pending_relay_downlink.raw_payload",
			"mac_state.pending_requests",
			"mac_state.ping_slot_periodicity",
			"mac_state.ping_slot_periodicity.value",
			"mac_state.queued_responses",
			"mac_state.recent_downlinks",
			"mac_state.recent_mac_command_identifiers",
			"mac_state.recent_uplinks",
			"mac_state.rejected_adr_data_rate_indexes",
			"mac_state.rejected_adr_tx_power_indexes",
			"mac_state.rejected_data_rate_ranges",
			"mac_state.rejected_frequencies",
			"mac_state.rx_windows_available",
			"max_frequency",
			"min_frequency",
			"multicast",
			"pending_mac_state",
			"pending_mac_state.current_parameters",
			"pending_mac_state.current_parameters.adr_ack_delay_exponent",
			"pending_mac_state.current_parameters.adr_ack_delay_exponent.value",
			"pending_mac_state.current_parameters.adr_ack_limit_exponent",
			"pending_mac_state.current_parameters.adr_ack_limit_exponent.value",
			"pending_mac_state.current_parameters.adr_data_rate_index",
			"pending_mac_state.current_parameters.adr_nb_trans",
			"pending_mac_state.current_parameters.adr_tx_power_index",
			"pending_mac_state.current_parameters.beacon_frequency",
			"pending_mac_state.current_parameters.channels",
			"pending_mac_state.current_parameters.downlink_dwell_time",
			"pending_mac_state.current_parameters.downlink_dwell_time.value",
			"pending_mac_state.current_parameters.max_duty_cycle",
			"pending_mac_state.current_parameters.max_eirp",
			"pending_mac_state.current_parameters.ping_slot_data_rate_index_value",
			"pending_mac_state.current_parameters.ping_slot_data_rate_index_value.value",
			"pending_mac_state.current_parameters.ping_slot_frequency",
			"pending_mac_state.current_parameters.rejoin_count_periodicity",
			"pending_mac_state.current_parameters.rejoin_time_periodicity",
			"pending_mac_state.current_parameters.relay",
			"pending_mac_state.current_parameters.relay.mode",
			"pending_mac_state.current_parameters.relay.mode.served",
			"pending_mac_state.current_parameters.relay.mode.served.backoff",
			"pending_mac_state.current_parameters.relay.mode.served.mode",
			"pending_mac_state.current_parameters.relay.mode.served.mode.always",
			"pending_mac_state.current_parameters.relay.mode.served.mode.dynamic",
			"pending_mac_state.current_parameters.relay.mode.served.mode.dynamic.smart_enable_level",
			"pending_mac_state.current_parameters.relay.mode.served.mode.end_device_controlled",
			"pending_mac_state.current_parameters.relay.mode.served.second_channel",
			"pending_mac_state.current_parameters.relay.mode.served.second_channel.ack_offset",
			"pending_mac_state.current_parameters.relay.mode.served.second_channel.data_rate_index",
			"pending_mac_state.current_parameters.relay.mode.served.second_channel.frequency",
			"pending_mac_state.current_parameters.relay.mode.served.serving_device_id",
			"pending_mac_state.current_parameters.relay.mode.serving",
			"pending_mac_state.current_parameters.relay.mode.serving.cad_periodicity",
			"pending_mac_state.current_parameters.relay.mode.serving.default_channel_index",
			"pending_mac_state.current_parameters.relay.mode.serving.limits",
			"pending_mac_state.current_parameters.relay.mode.serving.limits.join_requests",
			"pending_mac_state.current_parameters.relay.mode.serving.limits.join_requests.bucket_size",
			"pending_mac_state.current_parameters.relay.mode.serving.limits.join_requests.reload_rate",
			"pending_mac_state.current_parameters.relay.mode.serving.limits.notifications",
			"pending_mac_state.current_parameters.relay.mode.serving.limits.notifications.bucket_size",
			"pending_mac_state.current_parameters.relay.mode.serving.limits.notifications.reload_rate",
			"pending_mac_state.current_parameters.relay.mode.serving.limits.overall",
			"pending_mac_state.current_parameters.relay.mode.serving.limits.overall.bucket_size",
			"pending_mac_state.current_parameters.relay.mode.serving.limits.overall.reload_rate",
			"pending_mac_state.current_parameters.relay.mode.serving.limits.reset_behavior",
			"pending_mac_state.current_parameters.relay.mode.serving.limits.uplink_messages",
			"pending_mac_state.current_parameters.relay.mode.serving.limits.uplink_messages.bucket_size",
			"pending_mac_state.current_parameters.relay.mode.serving.limits.uplink_messages.reload_rate",
			"pending_mac_state.current_parameters.relay.mode.serving.second_channel",
			"pending_mac_state.current_parameters.relay.mode.serving.second_channel.ack_offset",
			"pending_mac_state.current_parameters.relay.mode.serving.second_channel.data_rate_index",
			"pending_mac_state.current_parameters.relay.mode.serving.second_channel.frequency",
			"pending_mac_state.current_parameters.relay.mode.serving.uplink_forwarding_rules",
			"pending_mac_state.current_parameters.rx1_data_rate_offset",
			"pending_mac_state.current_parameters.rx1_delay",
			"pending_mac_state.current_parameters.rx2_data_rate_index",
			"pending_mac_state.current_parameters.rx2_frequency",
			"pending_mac_state.current_parameters.uplink_dwell_time",
			"pending_mac_state.current_parameters.uplink_dwell_time.value",
			"pending_mac_state.desired_parameters",
			"pending_mac_state.desired_parameters.adr_ack_delay_exponent",
			"pending_mac_state.desired_parameters.adr_ack_delay_exponent.value",
			"pending_mac_state.desired_parameters.adr_ack_limit_exponent",
			"pending_mac_state.desired_parameters.adr_ack_limit_exponent.value",
			"pending_mac_state.desired_parameters.adr_data_rate_index",
			"pending_mac_state.desired_parameters.adr_nb_trans",
			"pending_mac_state.desired_parameters.adr_tx_power_index",
			"pending_mac_state.desired_parameters.beacon_frequency",
			"pending_mac_state.desired_parameters.channels",
			"pending_mac_state.desired_parameters.downlink_dwell_time",
			"pending_mac_state.desired_parameters.downlink_dwell_time.value",
			"pending_mac_state.desired_parameters.max_duty_cycle",
			"pending_mac_state.desired_parameters.max_eirp",
			"pending_mac_state.desired_parameters.ping_slot_data_rate_index_value",
			"pending_mac_state.desired_parameters.ping_slot_data_rate_index_value.value",
			"pending_mac_state.desired_parameters.ping_slot_frequency",
			"pending_mac_state.desired_parameters.rejoin_count_periodicity",
			"pending_mac_state.desired_parameters.rejoin_time_periodicity",
			"pending_mac_state.desired_parameters.relay",
			"pending_mac_state.desired_parameters.relay.mode",
			"pending_mac_state.desired_parameters.relay.mode.served",
			"pending_mac_state.desired_parameters.relay.mode.served.backoff",
			"pending_mac_state.desired_parameters.relay.mode.served.mode",
			"pending_mac_state.desired_parameters.relay.mode.served.mode.always",
			"pending_mac_state.desired_parameters.relay.mode.served.mode.dynamic",
			"pending_mac_state.desired_parameters.relay.mode.served.mode.dynamic.smart_enable_level",
			"pending_mac_state.desired_parameters.relay.mode.served.mode.end_device_controlled",
			"pending_mac_state.desired_parameters.relay.mode.served.second_channel",
			"pending_mac_state.desired_parameters.relay.mode.served.second_channel.ack_offset",
			"pending_mac_state.desired_parameters.relay.mode.served.second_channel.data_rate_index",
			"pending_mac_state.desired_parameters.relay.mode.served.second_channel.frequency",
			"pending_mac_state.desired_parameters.relay.mode.served.serving_device_id",
			"pending_mac_state.desired_parameters.relay.mode.serving",
			"pending_mac_state.desired_parameters.relay.mode.serving.cad_periodicity",
			"pending_mac_state.desired_parameters.relay.mode.serving.default_channel_index",
			"pending_mac_state.desired_parameters.relay.mode.serving.limits",
			"pending_mac_state.desired_parameters.relay.mode.serving.limits.join_requests",
			"pending_mac_state.desired_parameters.relay.mode.serving.limits.join_requests.bucket_size",
			"pending_mac_state.desired_parameters.relay.mode.serving.limits.join_requests.reload_rate",
			"pending_mac_state.desired_parameters.relay.mode.serving.limits.notifications",
			"pending_mac_state.desired_parameters.relay.mode.serving.limits.notifications.bucket_size",
			"pending_mac_state.desired_parameters.relay.mode.serving.limits.notifications.reload_rate",
			"pending_mac_state.desired_parameters.relay.mode.serving.limits.overall",
			"pending_mac_state.desired_parameters.relay.mode.serving.limits.overall.bucket_size",
			"pending_mac_state.desired_parameters.relay.mode.serving.limits.overall.reload_rate",
			"pending_mac_state.desired_parameters.relay.mode.serving.limits.reset_behavior",
			"pending_mac_state.desired_parameters.relay.mode.serving.limits.uplink_messages",
			"pending_mac_state.desired_parameters.relay.mode.serving.limits.uplink_messages.bucket_size",
			"pending_mac_state.desired_parameters.relay.mode.serving.limits.uplink_messages.reload_rate",
			"pending_mac_state.desired_parameters.relay.mode.serving.second_channel",
			"pending_mac_state.desired_parameters.relay.mode.serving.second_channel.ack_offset",
			"pending_mac_state.desired_parameters.relay.mode.serving.second_channel.data_rate_index",
			"pending_mac_state.desired_parameters.relay.mode.serving.second_channel.frequency",
			"pending_mac_state.desired_parameters.relay.mode.serving.uplink_forwarding_rules",
			"pending_mac_state.desired_parameters.rx1_data_rate_offset",
			"pending_mac_state.desired_parameters.rx1_delay",
			"pending_mac_state.desired_parameters.rx2_data_rate_index",
			"pending_mac_state.desired_parameters.rx2_frequency",
			"pending_mac_state.desired_parameters.uplink_dwell_time",
			"pending_mac_state.desired_parameters.uplink_dwell_time.value",
			"pending_mac_state.device_class",
			"pending_mac_state.last_adr_change_f_cnt_up",
			"pending_mac_state.last_confirmed_downlink_at",
			"pending_mac_state.last_dev_status_f_cnt_up",
			"pending_mac_state.last_downlink_at",
			"pending_mac_state.last_network_initiated_downlink_at",
			"pending_mac_state.lorawan_version",
			"pending_mac_state.pending_join_request",
			"pending_mac_state.pending_join_request.cf_list",
			"pending_mac_state.pending_join_request.cf_list.ch_masks",
			"pending_mac_state.pending_join_request.cf_list.freq",
			"pending_mac_state.pending_join_request.cf_list.type",
			"pending_mac_state.pending_join_request.downlink_settings",
			"pending_mac_state.pending_join_request.downlink_settings.opt_neg",
			"pending_mac_state.pending_join_request.downlink_settings.rx1_dr_offset",
			"pending_mac_state.pending_join_request.downlink_settings.rx2_dr",
			"pending_mac_state.pending_join_request.rx_delay",
			"pending_mac_state.ping_slot_periodicity",
			"pending_mac_state.ping_slot_periodicity.value",
			"pending_mac_state.queued_join_accept",
			"pending_mac_state.queued_join_accept.correlation_ids",
			"pending_mac_state.queued_join_accept.dev_addr",
			"pending_mac_state.queued_join_accept.keys",
			"pending_mac_state.queued_join_accept.keys.app_s_key",
			"pending_mac_state.queued_join_accept.keys.app_s_key.encrypted_key",
			"pending_mac_state.queued_join_accept.keys.app_s_key.kek_label",
			"pending_mac_state.queued_join_accept.keys.app_s_key.key",
			"pending_mac_state.queued_join_accept.keys.f_nwk_s_int_key",
			"pending_mac_state.queued_join_accept.keys.f_nwk_s_int_key.key",
			"pending_mac_state.queued_join_accept.keys.nwk_s_enc_key",
			"pending_mac_state.queued_join_accept.keys.nwk_s_enc_key.key",
			"pending_mac_state.queued_join_accept.keys.s_nwk_s_int_key",
			"pending_mac_state.queued_join_accept.keys.s_nwk_s_int_key.key",
			"pending_mac_state.queued_join_accept.keys.session_key_id",
			"pending_mac_state.queued_join_accept.net_id",
			"pending_mac_state.queued_join_accept.payload",
			"pending_mac_state.queued_join_accept.request",
			"pending_mac_state.queued_join_accept.request.cf_list",
			"pending_mac_state.queued_join_accept.request.cf_list.ch_masks",
			"pending_mac_state.queued_join_accept.request.cf_list.freq",
			"pending_mac_state.queued_join_accept.request.cf_list.type",
			"pending_mac_state.queued_join_accept.request.downlink_settings",
			"pending_mac_state.queued_join_accept.request.downlink_settings.opt_neg",
			"pending_mac_state.queued_join_accept.request.downlink_settings.rx1_dr_offset",
			"pending_mac_state.queued_join_accept.request.downlink_settings.rx2_dr",
			"pending_mac_state.queued_join_accept.request.rx_delay",
			"pending_mac_state.recent_downlinks",
			"pending_mac_state.recent_mac_command_identifiers",
			"pending_mac_state.recent_uplinks",
			"pending_mac_state.rejected_adr_data_rate_indexes",
			"pending_mac_state.rejected_adr_tx_power_indexes",
			"pending_mac_state.rejected_data_rate_ranges",
			"pending_mac_state.rejected_frequencies",
			"pending_mac_state.rx_windows_available",
			"pending_session",
			"pending_session.dev_addr",
			"pending_session.keys",
			"pending_session.keys.f_nwk_s_int_key",
			"pending_session.keys.f_nwk_s_int_key.key",
			"pending_session.keys.nwk_s_enc_key",
			"pending_session.keys.nwk_s_enc_key.key",
			"pending_session.keys.s_nwk_s_int_key",
			"pending_session.keys.s_nwk_s_int_key.key",
			"pending_session.keys.session_key_id",
			"serial_number",
			"session",
			"session.dev_addr",
			"session.keys",
			"session.keys.f_nwk_s_int_key",
			"session.keys.f_nwk_s_int_key.key",
			"session.keys.nwk_s_enc_key",
			"session.keys.nwk_s_enc_key.key",
			"session.keys.s_nwk_s_int_key",
			"session.keys.s_nwk_s_int_key.key",
			"session.keys.session_key_id",
			"session.last_conf_f_cnt_down",
			"session.last_f_cnt_up",
			"session.last_n_f_cnt_down",
			"session.started_at",
			"supports_class_b",
			"supports_class_c",
			"supports_join",
			"lora_alliance_profile_ids",
			"lora_alliance_profile_ids.vendor_id",
			"lora_alliance_profile_ids.vendor_profile_id",
			"version_ids",
			"version_ids.band_id",
			"version_ids.brand_id",
			"version_ids.firmware_version",
			"version_ids.hardware_version",
			"version_ids.model_id",
		},
		Set: true,
	},
	"/ttn.lorawan.v3.NsEndDeviceRegistry/ResetFactoryDefaults": {
		All:     EndDeviceFieldPathsNested,
		Allowed: nsEndDeviceReadFieldPaths[:],
	},

	// MAC settings profiles:
	"/ttn.lorawan.v3.NsMACSettingsProfileRegistry/Get": {
		All:     MACSettingsProfileFieldPathsNested,
		Allowed: MACSettingsProfileFieldPathsNested,
	},
	"/ttn.lorawan.v3.NsMACSettingsProfileRegistry/List": {
		All:     MACSettingsProfileFieldPathsNested,
		Allowed: MACSettingsProfileFieldPathsNested,
	},
	"/ttn.lorawan.v3.NsMACSettingsProfileRegistry/Update": {
		All:     MACSettingsProfileFieldPathsNested,
		Allowed: MACSettingsProfileFieldPathsNested,
		Set:     true,
	},

	// Relays:
	"/ttn.lorawan.v3.NsRelayConfigurationService/GetRelay": {
		All:     RelaySettingsFieldPathsNested,
		Allowed: RelaySettingsFieldPathsNested,
	},
	"/ttn.lorawan.v3.NsRelayConfigurationService/UpdateRelay": {
		All:     RelaySettingsFieldPathsNested,
		Allowed: RelaySettingsFieldPathsNested,
		Set:     true,
	},

	// Relay Uplink Forwarding Rules:
	"/ttn.lorawan.v3.NsRelayConfigurationService/GetRelayUplinkForwardingRule": {
		All:     RelayUplinkForwardingRuleFieldPathsNested,
		Allowed: RelayUplinkForwardingRuleFieldPathsNested,
	},
	"/ttn.lorawan.v3.NsRelayConfigurationService/ListRelayUplinkForwardingRules": {
		All:     RelayUplinkForwardingRuleFieldPathsNested,
		Allowed: RelayUplinkForwardingRuleFieldPathsNested,
	},
	"/ttn.lorawan.v3.NsRelayConfigurationService/UpdateRelayUplinkForwardingRule": {
		All:     RelayUplinkForwardingRuleFieldPathsNested,
		Allowed: RelayUplinkForwardingRuleFieldPathsNested,
		Set:     true,
	},

	// Gateways:
	"/ttn.lorawan.v3.EntityRegistrySearch/SearchGateways": {
		All: GatewayFieldPathsNested,
		Allowed: omitFields(GatewayFieldPathsNested,
			"gateway.claim_authentication_code.secret",
			"gateway.claim_authentication_code.secret.key_id",
			"gateway.claim_authentication_code.secret.value",
			"gateway.claim_authentication_code.valid_from",
			"gateway.claim_authentication_code.valid_to"),
	},
	"/ttn.lorawan.v3.GatewayRegistry/Get": {
		All: GatewayFieldPathsNested,
		Allowed: omitFields(GatewayFieldPathsNested,
			"gateway.claim_authentication_code.secret",
			"gateway.claim_authentication_code.secret.key_id",
			"gateway.claim_authentication_code.secret.value",
			"gateway.claim_authentication_code.valid_from",
			"gateway.claim_authentication_code.valid_to"),
	},
	"/ttn.lorawan.v3.GatewayRegistry/List": {
		All: GatewayFieldPathsNested,
		Allowed: omitFields(GatewayFieldPathsNested,
			"gateway.claim_authentication_code.secret",
			"gateway.claim_authentication_code.secret.key_id",
			"gateway.claim_authentication_code.secret.value",
			"gateway.claim_authentication_code.valid_from",
			"gateway.claim_authentication_code.valid_to"),
	},
	"/ttn.lorawan.v3.GatewayRegistry/Update": {
		All: GatewayFieldPathsNested,
		Allowed: omitFields(GatewayFieldPathsNested,
			"gateway.claim_authentication_code.secret",
			"gateway.claim_authentication_code.secret.key_id",
			"gateway.claim_authentication_code.secret.value",
			"gateway.claim_authentication_code.valid_from",
			"gateway.claim_authentication_code.valid_to"),
		Set: true,
	},
	"/ttn.lorawan.v3.GsPba/UpdateGateway": {
		All: PacketBrokerGatewayFieldPathsNested,
		Allowed: []string{
			"administrative_contact",
			"antennas",
			"frequency_plan_ids",
			"ids",
			"ids.eui",
			"ids.gateway_id",
			"location_public",
			"online",
			"rx_rate",
			"status_public",
			"technical_contact",
			"tx_rate",
		},
		Set: true,
	},

	// Gateway Connection Statistics:
	"/ttn.lorawan.v3.Gs/BatchGetGatewayConnectionStats": {
		All:     GatewayConnectionStatsFieldPathsNested,
		Allowed: GatewayConnectionStatsFieldPathsNested,
	},

	// Gateway API Keys:
	"/ttn.lorawan.v3.GatewayAccess/UpdateAPIKey": {
		All:     APIKeyFieldPathsNested,
		Allowed: APIKeyFieldPathsNested,
		Set:     true,
	},

	// Managed Gateway:
	"/ttn.lorawan.v3.ManagedGatewayConfigurationService/Get": {
		All:     ManagedGatewayFieldPathsNested,
		Allowed: ManagedGatewayFieldPathsNested,
	},
	"/ttn.lorawan.v3.ManagedGatewayConfigurationService/Update": {
		All: ManagedGatewayFieldPathsNested,
		Allowed: []string{
			"ethernet_profile_id",
			"wifi_profile_id",
		},
		Set: true,
	},
	"/ttn.lorawan.v3.ManagedGatewayWiFiProfileConfigurationService/Update": {
		All:     ManagedGatewayWiFiProfileFieldPathsNested,
		Allowed: ManagedGatewayWiFiProfileFieldPathsNested,
		Set:     true,
	},
	"/ttn.lorawan.v3.ManagedGatewayWiFiProfileConfigurationService/List": {
		All:     ManagedGatewayWiFiProfileFieldPathsNested,
		Allowed: ManagedGatewayWiFiProfileFieldPathsNested,
	},
	"/ttn.lorawan.v3.ManagedGatewayWiFiProfileConfigurationService/Get": {
		All:     ManagedGatewayWiFiProfileFieldPathsNested,
		Allowed: ManagedGatewayWiFiProfileFieldPathsNested,
	},
	"/ttn.lorawan.v3.ManagedGatewayEthernetProfileConfigurationService/Update": {
		All:     ManagedGatewayEthernetProfileFieldPathsNested,
		Allowed: ManagedGatewayEthernetProfileFieldPathsNested,
		Set:     true,
	},
	"/ttn.lorawan.v3.ManagedGatewayEthernetProfileConfigurationService/List": {
		All:     ManagedGatewayEthernetProfileFieldPathsNested,
		Allowed: ManagedGatewayEthernetProfileFieldPathsNested,
	},
	"/ttn.lorawan.v3.ManagedGatewayEthernetProfileConfigurationService/Get": {
		All:     ManagedGatewayEthernetProfileFieldPathsNested,
		Allowed: ManagedGatewayEthernetProfileFieldPathsNested,
	},

	// Organizations:
	"/ttn.lorawan.v3.OrganizationRegistry/Get": {
		All:     OrganizationFieldPathsNested,
		Allowed: OrganizationFieldPathsNested,
	},
	"/ttn.lorawan.v3.OrganizationRegistry/List": {
		All:     OrganizationFieldPathsNested,
		Allowed: OrganizationFieldPathsNested,
	},
	"/ttn.lorawan.v3.OrganizationRegistry/Update": {
		All:     OrganizationFieldPathsNested,
		Allowed: OrganizationFieldPathsNested,
		Set:     true,
	},
	"/ttn.lorawan.v3.EntityRegistrySearch/SearchOrganizations": {
		All:     OrganizationFieldPathsNested,
		Allowed: OrganizationFieldPathsNested,
	},

	// Organization API Keys:
	"/ttn.lorawan.v3.OrganizationAccess/UpdateAPIKey": {
		All:     APIKeyFieldPathsNested,
		Allowed: APIKeyFieldPathsNested,
		Set:     true,
	},

	// Users:
	"/ttn.lorawan.v3.UserRegistry/Get": {
		All:     UserFieldPathsNested,
		Allowed: omitFields(UserFieldPathsNested, "password", "temporary_password"),
	},
	"/ttn.lorawan.v3.UserRegistry/List": {
		All:     UserFieldPathsNested,
		Allowed: omitFields(UserFieldPathsNested, "password", "temporary_password"),
	},
	"/ttn.lorawan.v3.UserRegistry/Update": {
		All:     UserFieldPathsNested,
		Allowed: omitFields(UserFieldPathsNested, "password", "password_updated_at"),
		Set:     true,
	},
	"/ttn.lorawan.v3.EntityRegistrySearch/SearchUsers": {
		All:     UserFieldPathsNested,
		Allowed: omitFields(UserFieldPathsNested, "password", "temporary_password"),
	},

	// User API Keys:
	"/ttn.lorawan.v3.UserAccess/UpdateAPIKey": {
		All:     APIKeyFieldPathsNested,
		Allowed: APIKeyFieldPathsNested,
		Set:     true,
	},

	// User Bookmarks:
	"/ttn.lorawan.v3.UserBookmarkRegistry/List": {
		All:     UserBookmarkFieldPathsNested,
		Allowed: UserBookmarkFieldPathsNested,
	},

	// Storage Integration:
	"/ttn.lorawan.v3.ApplicationUpStorage/GetStoredApplicationUp": {
		All:     ApplicationUpFieldPathsNested,
		Allowed: ApplicationUpFieldPathsNested,
	},

	// Device Repository:
	"/ttn.lorawan.v3.DeviceRepository/GetBrand": {
		All:     EndDeviceBrandFieldPathsNested,
		Allowed: EndDeviceBrandFieldPathsNested,
	},
	"/ttn.lorawan.v3.DeviceRepository/ListBrands": {
		All:     EndDeviceBrandFieldPathsNested,
		Allowed: EndDeviceBrandFieldPathsNested,
	},
	"/ttn.lorawan.v3.DeviceRepository/GetModel": {
		All:     EndDeviceModelFieldPathsNested,
		Allowed: EndDeviceModelFieldPathsNested,
	},
	"/ttn.lorawan.v3.DeviceRepository/ListModels": {
		All:     EndDeviceModelFieldPathsNested,
		Allowed: EndDeviceModelFieldPathsNested,
	},
	"/ttn.lorawan.v3.DeviceRepository/GetUplinkDecoder": {
		All:     MessagePayloadDecoderFieldPathsNested,
		Allowed: MessagePayloadDecoderFieldPathsNested,
	},
	"/ttn.lorawan.v3.DeviceRepository/GetDownlinkDecoder": {
		All:     MessagePayloadDecoderFieldPathsNested,
		Allowed: MessagePayloadDecoderFieldPathsNested,
	},
	"/ttn.lorawan.v3.DeviceRepository/GetDownlinkEncoder": {
		All:     MessagePayloadEncoderFieldPathsNested,
		Allowed: MessagePayloadEncoderFieldPathsNested,
	},
}

func omitFields(fields []string, fieldsToOmit ...string) []string {
	out := make([]string, 0, len(fields))
nextField:
	for _, field := range fields {
		for _, fieldToOmit := range fieldsToOmit {
			if field == fieldToOmit {
				continue nextField
			}
		}
		out = append(out, field)
	}
	return out
}
