// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on Event with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *Event) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EventFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "name":
			// no validation rules for Name
		case "time":

			if m.GetTime() == nil {
				return EventValidationError{
					field:  "time",
					reason: "value is required",
				}
			}

		case "identifiers":

			for idx, item := range m.GetIdentifiers() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return EventValidationError{
							field:  fmt.Sprintf("identifiers[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "data":

			if v, ok := interface{}(m.GetData()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EventValidationError{
						field:  "data",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "correlation_ids":

			for idx, item := range m.GetCorrelationIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 100 {
					return EventValidationError{
						field:  fmt.Sprintf("correlation_ids[%v]", idx),
						reason: "value length must be at most 100 runes",
					}
				}

			}

		case "origin":
			// no validation rules for Origin
		case "context":
			// no validation rules for Context
		case "visibility":

			if v, ok := interface{}(m.GetVisibility()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EventValidationError{
						field:  "visibility",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "authentication":

			if v, ok := interface{}(m.GetAuthentication()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EventValidationError{
						field:  "authentication",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "remote_ip":
			// no validation rules for RemoteIp
		case "user_agent":
			// no validation rules for UserAgent
		case "unique_id":
			// no validation rules for UniqueId
		default:
			return EventValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EventValidationError is the validation error returned by
// Event.ValidateFields if the designated constraints aren't met.
type EventValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EventValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EventValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EventValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EventValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EventValidationError) ErrorName() string { return "EventValidationError" }

// Error satisfies the builtin error interface
func (e EventValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEvent.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EventValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EventValidationError{}

// ValidateFields checks the field values on StreamEventsRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *StreamEventsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = StreamEventsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "identifiers":

			for idx, item := range m.GetIdentifiers() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return StreamEventsRequestValidationError{
							field:  fmt.Sprintf("identifiers[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "tail":
			// no validation rules for Tail
		case "after":

			if v, ok := interface{}(m.GetAfter()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return StreamEventsRequestValidationError{
						field:  "after",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "names":

		default:
			return StreamEventsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// StreamEventsRequestValidationError is the validation error returned by
// StreamEventsRequest.ValidateFields if the designated constraints aren't met.
type StreamEventsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e StreamEventsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e StreamEventsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e StreamEventsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e StreamEventsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e StreamEventsRequestValidationError) ErrorName() string {
	return "StreamEventsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e StreamEventsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sStreamEventsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = StreamEventsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = StreamEventsRequestValidationError{}

// ValidateFields checks the field values on FindRelatedEventsRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *FindRelatedEventsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = FindRelatedEventsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "correlation_id":

			if l := utf8.RuneCountInString(m.GetCorrelationId()); l < 1 || l > 100 {
				return FindRelatedEventsRequestValidationError{
					field:  "correlation_id",
					reason: "value length must be between 1 and 100 runes, inclusive",
				}
			}

		default:
			return FindRelatedEventsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// FindRelatedEventsRequestValidationError is the validation error returned by
// FindRelatedEventsRequest.ValidateFields if the designated constraints
// aren't met.
type FindRelatedEventsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FindRelatedEventsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FindRelatedEventsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FindRelatedEventsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FindRelatedEventsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FindRelatedEventsRequestValidationError) ErrorName() string {
	return "FindRelatedEventsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e FindRelatedEventsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFindRelatedEventsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FindRelatedEventsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FindRelatedEventsRequestValidationError{}

// ValidateFields checks the field values on FindRelatedEventsResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *FindRelatedEventsResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = FindRelatedEventsResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "events":

			for idx, item := range m.GetEvents() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return FindRelatedEventsResponseValidationError{
							field:  fmt.Sprintf("events[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return FindRelatedEventsResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// FindRelatedEventsResponseValidationError is the validation error returned by
// FindRelatedEventsResponse.ValidateFields if the designated constraints
// aren't met.
type FindRelatedEventsResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FindRelatedEventsResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FindRelatedEventsResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FindRelatedEventsResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FindRelatedEventsResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FindRelatedEventsResponseValidationError) ErrorName() string {
	return "FindRelatedEventsResponseValidationError"
}

// Error satisfies the builtin error interface
func (e FindRelatedEventsResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFindRelatedEventsResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FindRelatedEventsResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FindRelatedEventsResponseValidationError{}

// ValidateFields checks the field values on Event_Authentication with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *Event_Authentication) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = Event_AuthenticationFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "type":
			// no validation rules for Type
		case "token_type":
			// no validation rules for TokenType
		case "token_id":
			// no validation rules for TokenId
		default:
			return Event_AuthenticationValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// Event_AuthenticationValidationError is the validation error returned by
// Event_Authentication.ValidateFields if the designated constraints aren't met.
type Event_AuthenticationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Event_AuthenticationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Event_AuthenticationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Event_AuthenticationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Event_AuthenticationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Event_AuthenticationValidationError) ErrorName() string {
	return "Event_AuthenticationValidationError"
}

// Error satisfies the builtin error interface
func (e Event_AuthenticationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEvent_Authentication.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Event_AuthenticationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Event_AuthenticationValidationError{}
