// Code generated by protoc-gen-go-json. DO NOT EDIT.
// versions:
// - protoc-gen-go-json v1.6.0
// - protoc             v4.23.4
// source: ttn/lorawan/v3/end_device.proto

package ttnpb

import (
	golang "github.com/TheThingsIndustries/protoc-gen-go-json/golang"
	jsonplugin "github.com/TheThingsIndustries/protoc-gen-go-json/jsonplugin"
	types "go.thethings.network/lorawan-stack/v3/pkg/types"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

// MarshalProtoJSON marshals the PowerState to JSON.
func (x PowerState) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	s.WriteEnumString(int32(x), PowerState_name)
}

// MarshalText marshals the PowerState to text.
func (x PowerState) MarshalText() ([]byte, error) {
	return []byte(jsonplugin.GetEnumString(int32(x), PowerState_name)), nil
}

// MarshalJSON marshals the PowerState to JSON.
func (x PowerState) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// PowerState_customvalue contains custom string values that extend PowerState_value.
var PowerState_customvalue = map[string]int32{
	"UNKNOWN":  0,
	"BATTERY":  1,
	"EXTERNAL": 2,
}

// UnmarshalProtoJSON unmarshals the PowerState from JSON.
func (x *PowerState) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	v := s.ReadEnum(PowerState_value, PowerState_customvalue)
	if err := s.Err(); err != nil {
		s.SetErrorf("could not read PowerState enum: %v", err)
		return
	}
	*x = PowerState(v)
}

// UnmarshalText unmarshals the PowerState from text.
func (x *PowerState) UnmarshalText(b []byte) error {
	i, err := jsonplugin.ParseEnumString(string(b), PowerState_customvalue, PowerState_value)
	if err != nil {
		return err
	}
	*x = PowerState(i)
	return nil
}

// UnmarshalJSON unmarshals the PowerState from JSON.
func (x *PowerState) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the Session message to JSON.
func (x *Session) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.DevAddr) > 0 || s.HasField("dev_addr") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("dev_addr")
		types.MarshalHEXBytes(s.WithField("dev_addr"), x.DevAddr)
	}
	if x.Keys != nil || s.HasField("keys") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("keys")
		x.Keys.MarshalProtoJSON(s.WithField("keys"))
	}
	if x.LastFCntUp != 0 || s.HasField("last_f_cnt_up") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_f_cnt_up")
		s.WriteUint32(x.LastFCntUp)
	}
	if x.LastNFCntDown != 0 || s.HasField("last_n_f_cnt_down") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_n_f_cnt_down")
		s.WriteUint32(x.LastNFCntDown)
	}
	if x.LastAFCntDown != 0 || s.HasField("last_a_f_cnt_down") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_a_f_cnt_down")
		s.WriteUint32(x.LastAFCntDown)
	}
	if x.LastConfFCntDown != 0 || s.HasField("last_conf_f_cnt_down") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_conf_f_cnt_down")
		s.WriteUint32(x.LastConfFCntDown)
	}
	if x.StartedAt != nil || s.HasField("started_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("started_at")
		if x.StartedAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.StartedAt)
		}
	}
	if len(x.QueuedApplicationDownlinks) > 0 || s.HasField("queued_application_downlinks") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("queued_application_downlinks")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.QueuedApplicationDownlinks {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("queued_application_downlinks"))
		}
		s.WriteArrayEnd()
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the Session to JSON.
func (x *Session) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the Session message from JSON.
func (x *Session) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "dev_addr", "devAddr":
			s.AddField("dev_addr")
			x.DevAddr = types.Unmarshal4Bytes(s.WithField("dev_addr", false))
		case "keys":
			if s.ReadNil() {
				x.Keys = nil
				return
			}
			x.Keys = &SessionKeys{}
			x.Keys.UnmarshalProtoJSON(s.WithField("keys", true))
		case "last_f_cnt_up", "lastFCntUp":
			s.AddField("last_f_cnt_up")
			x.LastFCntUp = s.ReadUint32()
		case "last_n_f_cnt_down", "lastNFCntDown":
			s.AddField("last_n_f_cnt_down")
			x.LastNFCntDown = s.ReadUint32()
		case "last_a_f_cnt_down", "lastAFCntDown":
			s.AddField("last_a_f_cnt_down")
			x.LastAFCntDown = s.ReadUint32()
		case "last_conf_f_cnt_down", "lastConfFCntDown":
			s.AddField("last_conf_f_cnt_down")
			x.LastConfFCntDown = s.ReadUint32()
		case "started_at", "startedAt":
			s.AddField("started_at")
			if s.ReadNil() {
				x.StartedAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.StartedAt = v
		case "queued_application_downlinks", "queuedApplicationDownlinks":
			s.AddField("queued_application_downlinks")
			if s.ReadNil() {
				x.QueuedApplicationDownlinks = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.QueuedApplicationDownlinks = append(x.QueuedApplicationDownlinks, nil)
					return
				}
				v := &ApplicationDownlink{}
				v.UnmarshalProtoJSON(s.WithField("queued_application_downlinks", false))
				if s.Err() != nil {
					return
				}
				x.QueuedApplicationDownlinks = append(x.QueuedApplicationDownlinks, v)
			})
		}
	})
}

// UnmarshalJSON unmarshals the Session from JSON.
func (x *Session) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the BoolValue message to JSON.
func (x *BoolValue) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteBool(x.Value)
	return
}

// MarshalJSON marshals the BoolValue to JSON.
func (x *BoolValue) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the BoolValue message from JSON.
func (x *BoolValue) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	x.Value = s.ReadBool()
	return
}

// UnmarshalJSON unmarshals the BoolValue from JSON.
func (x *BoolValue) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ServingRelayForwardingLimits message to JSON.
func (x *ServingRelayForwardingLimits) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.ResetBehavior != 0 || s.HasField("reset_behavior") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("reset_behavior")
		x.ResetBehavior.MarshalProtoJSON(s)
	}
	if x.JoinRequests != nil || s.HasField("join_requests") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("join_requests")
		x.JoinRequests.MarshalProtoJSON(s.WithField("join_requests"))
	}
	if x.Notifications != nil || s.HasField("notifications") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("notifications")
		x.Notifications.MarshalProtoJSON(s.WithField("notifications"))
	}
	if x.UplinkMessages != nil || s.HasField("uplink_messages") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("uplink_messages")
		x.UplinkMessages.MarshalProtoJSON(s.WithField("uplink_messages"))
	}
	if x.Overall != nil || s.HasField("overall") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("overall")
		x.Overall.MarshalProtoJSON(s.WithField("overall"))
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ServingRelayForwardingLimits to JSON.
func (x *ServingRelayForwardingLimits) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ServingRelayForwardingLimits message from JSON.
func (x *ServingRelayForwardingLimits) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "reset_behavior", "resetBehavior":
			s.AddField("reset_behavior")
			x.ResetBehavior.UnmarshalProtoJSON(s)
		case "join_requests", "joinRequests":
			if s.ReadNil() {
				x.JoinRequests = nil
				return
			}
			x.JoinRequests = &RelayForwardLimits{}
			x.JoinRequests.UnmarshalProtoJSON(s.WithField("join_requests", true))
		case "notifications":
			if s.ReadNil() {
				x.Notifications = nil
				return
			}
			x.Notifications = &RelayForwardLimits{}
			x.Notifications.UnmarshalProtoJSON(s.WithField("notifications", true))
		case "uplink_messages", "uplinkMessages":
			if s.ReadNil() {
				x.UplinkMessages = nil
				return
			}
			x.UplinkMessages = &RelayForwardLimits{}
			x.UplinkMessages.UnmarshalProtoJSON(s.WithField("uplink_messages", true))
		case "overall":
			if s.ReadNil() {
				x.Overall = nil
				return
			}
			x.Overall = &RelayForwardLimits{}
			x.Overall.UnmarshalProtoJSON(s.WithField("overall", true))
		}
	})
}

// UnmarshalJSON unmarshals the ServingRelayForwardingLimits from JSON.
func (x *ServingRelayForwardingLimits) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the RelayUplinkForwardingRule message to JSON.
func (x *RelayUplinkForwardingRule) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Limits != nil || s.HasField("limits") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("limits")
		x.Limits.MarshalProtoJSON(s.WithField("limits"))
	}
	if x.LastWFCnt != 0 || s.HasField("last_w_f_cnt") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_w_f_cnt")
		s.WriteUint32(x.LastWFCnt)
	}
	if x.DeviceId != "" || s.HasField("device_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("device_id")
		s.WriteString(x.DeviceId)
	}
	if len(x.SessionKeyId) > 0 || s.HasField("session_key_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("session_key_id")
		s.WriteBytes(x.SessionKeyId)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the RelayUplinkForwardingRule to JSON.
func (x *RelayUplinkForwardingRule) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the RelayUplinkForwardingRule message from JSON.
func (x *RelayUplinkForwardingRule) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "limits":
			if s.ReadNil() {
				x.Limits = nil
				return
			}
			x.Limits = &RelayUplinkForwardLimits{}
			x.Limits.UnmarshalProtoJSON(s.WithField("limits", true))
		case "last_w_f_cnt", "lastWFCnt":
			s.AddField("last_w_f_cnt")
			x.LastWFCnt = s.ReadUint32()
		case "device_id", "deviceId":
			s.AddField("device_id")
			x.DeviceId = s.ReadString()
		case "session_key_id", "sessionKeyId":
			s.AddField("session_key_id")
			x.SessionKeyId = s.ReadBytes()
		}
	})
}

// UnmarshalJSON unmarshals the RelayUplinkForwardingRule from JSON.
func (x *RelayUplinkForwardingRule) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ServingRelayParameters message to JSON.
func (x *ServingRelayParameters) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.SecondChannel != nil || s.HasField("second_channel") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("second_channel")
		x.SecondChannel.MarshalProtoJSON(s.WithField("second_channel"))
	}
	if x.DefaultChannelIndex != 0 || s.HasField("default_channel_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("default_channel_index")
		s.WriteUint32(x.DefaultChannelIndex)
	}
	if x.CadPeriodicity != 0 || s.HasField("cad_periodicity") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("cad_periodicity")
		x.CadPeriodicity.MarshalProtoJSON(s)
	}
	if len(x.UplinkForwardingRules) > 0 || s.HasField("uplink_forwarding_rules") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("uplink_forwarding_rules")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.UplinkForwardingRules {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("uplink_forwarding_rules"))
		}
		s.WriteArrayEnd()
	}
	if x.Limits != nil || s.HasField("limits") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("limits")
		x.Limits.MarshalProtoJSON(s.WithField("limits"))
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ServingRelayParameters to JSON.
func (x *ServingRelayParameters) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ServingRelayParameters message from JSON.
func (x *ServingRelayParameters) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "second_channel", "secondChannel":
			if s.ReadNil() {
				x.SecondChannel = nil
				return
			}
			x.SecondChannel = &RelaySecondChannel{}
			x.SecondChannel.UnmarshalProtoJSON(s.WithField("second_channel", true))
		case "default_channel_index", "defaultChannelIndex":
			s.AddField("default_channel_index")
			x.DefaultChannelIndex = s.ReadUint32()
		case "cad_periodicity", "cadPeriodicity":
			s.AddField("cad_periodicity")
			x.CadPeriodicity.UnmarshalProtoJSON(s)
		case "uplink_forwarding_rules", "uplinkForwardingRules":
			s.AddField("uplink_forwarding_rules")
			if s.ReadNil() {
				x.UplinkForwardingRules = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.UplinkForwardingRules = append(x.UplinkForwardingRules, nil)
					return
				}
				v := &RelayUplinkForwardingRule{}
				v.UnmarshalProtoJSON(s.WithField("uplink_forwarding_rules", false))
				if s.Err() != nil {
					return
				}
				x.UplinkForwardingRules = append(x.UplinkForwardingRules, v)
			})
		case "limits":
			if s.ReadNil() {
				x.Limits = nil
				return
			}
			x.Limits = &ServingRelayForwardingLimits{}
			x.Limits.UnmarshalProtoJSON(s.WithField("limits", true))
		}
	})
}

// UnmarshalJSON unmarshals the ServingRelayParameters from JSON.
func (x *ServingRelayParameters) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ServedRelayParameters message to JSON.
func (x *ServedRelayParameters) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Mode != nil {
		switch ov := x.Mode.(type) {
		case *ServedRelayParameters_Always:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("always")
			// NOTE: RelayEndDeviceAlwaysMode does not seem to implement MarshalProtoJSON.
			golang.MarshalMessage(s, ov.Always)
		case *ServedRelayParameters_Dynamic:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("dynamic")
			ov.Dynamic.MarshalProtoJSON(s.WithField("dynamic"))
		case *ServedRelayParameters_EndDeviceControlled:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("end_device_controlled")
			// NOTE: RelayEndDeviceControlledMode does not seem to implement MarshalProtoJSON.
			golang.MarshalMessage(s, ov.EndDeviceControlled)
		}
	}
	if x.Backoff != 0 || s.HasField("backoff") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("backoff")
		s.WriteUint32(x.Backoff)
	}
	if x.SecondChannel != nil || s.HasField("second_channel") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("second_channel")
		x.SecondChannel.MarshalProtoJSON(s.WithField("second_channel"))
	}
	if x.ServingDeviceId != "" || s.HasField("serving_device_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("serving_device_id")
		s.WriteString(x.ServingDeviceId)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ServedRelayParameters to JSON.
func (x *ServedRelayParameters) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ServedRelayParameters message from JSON.
func (x *ServedRelayParameters) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "always":
			s.AddField("always")
			ov := &ServedRelayParameters_Always{}
			x.Mode = ov
			if s.ReadNil() {
				ov.Always = nil
				return
			}
			// NOTE: RelayEndDeviceAlwaysMode does not seem to implement UnmarshalProtoJSON.
			var v RelayEndDeviceAlwaysMode
			golang.UnmarshalMessage(s, &v)
			ov.Always = &v
		case "dynamic":
			ov := &ServedRelayParameters_Dynamic{}
			x.Mode = ov
			if s.ReadNil() {
				ov.Dynamic = nil
				return
			}
			ov.Dynamic = &RelayEndDeviceDynamicMode{}
			ov.Dynamic.UnmarshalProtoJSON(s.WithField("dynamic", true))
		case "end_device_controlled", "endDeviceControlled":
			s.AddField("end_device_controlled")
			ov := &ServedRelayParameters_EndDeviceControlled{}
			x.Mode = ov
			if s.ReadNil() {
				ov.EndDeviceControlled = nil
				return
			}
			// NOTE: RelayEndDeviceControlledMode does not seem to implement UnmarshalProtoJSON.
			var v RelayEndDeviceControlledMode
			golang.UnmarshalMessage(s, &v)
			ov.EndDeviceControlled = &v
		case "backoff":
			s.AddField("backoff")
			x.Backoff = s.ReadUint32()
		case "second_channel", "secondChannel":
			if s.ReadNil() {
				x.SecondChannel = nil
				return
			}
			x.SecondChannel = &RelaySecondChannel{}
			x.SecondChannel.UnmarshalProtoJSON(s.WithField("second_channel", true))
		case "serving_device_id", "servingDeviceId":
			s.AddField("serving_device_id")
			x.ServingDeviceId = s.ReadString()
		}
	})
}

// UnmarshalJSON unmarshals the ServedRelayParameters from JSON.
func (x *ServedRelayParameters) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the RelayParameters message to JSON.
func (x *RelayParameters) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Mode != nil {
		switch ov := x.Mode.(type) {
		case *RelayParameters_Serving:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("serving")
			ov.Serving.MarshalProtoJSON(s.WithField("serving"))
		case *RelayParameters_Served:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("served")
			ov.Served.MarshalProtoJSON(s.WithField("served"))
		}
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the RelayParameters to JSON.
func (x *RelayParameters) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the RelayParameters message from JSON.
func (x *RelayParameters) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "serving":
			ov := &RelayParameters_Serving{}
			x.Mode = ov
			if s.ReadNil() {
				ov.Serving = nil
				return
			}
			ov.Serving = &ServingRelayParameters{}
			ov.Serving.UnmarshalProtoJSON(s.WithField("serving", true))
		case "served":
			ov := &RelayParameters_Served{}
			x.Mode = ov
			if s.ReadNil() {
				ov.Served = nil
				return
			}
			ov.Served = &ServedRelayParameters{}
			ov.Served.UnmarshalProtoJSON(s.WithField("served", true))
		}
	})
}

// UnmarshalJSON unmarshals the RelayParameters from JSON.
func (x *RelayParameters) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ServingRelaySettings message to JSON.
func (x *ServingRelaySettings) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.SecondChannel != nil || s.HasField("second_channel") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("second_channel")
		x.SecondChannel.MarshalProtoJSON(s.WithField("second_channel"))
	}
	if x.DefaultChannelIndex != nil || s.HasField("default_channel_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("default_channel_index")
		if x.DefaultChannelIndex == nil {
			s.WriteNil()
		} else {
			s.WriteUint32(x.DefaultChannelIndex.Value)
		}
	}
	if x.CadPeriodicity != 0 || s.HasField("cad_periodicity") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("cad_periodicity")
		x.CadPeriodicity.MarshalProtoJSON(s)
	}
	if len(x.UplinkForwardingRules) > 0 || s.HasField("uplink_forwarding_rules") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("uplink_forwarding_rules")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.UplinkForwardingRules {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("uplink_forwarding_rules"))
		}
		s.WriteArrayEnd()
	}
	if x.Limits != nil || s.HasField("limits") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("limits")
		x.Limits.MarshalProtoJSON(s.WithField("limits"))
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ServingRelaySettings to JSON.
func (x *ServingRelaySettings) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ServingRelaySettings message from JSON.
func (x *ServingRelaySettings) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "second_channel", "secondChannel":
			if s.ReadNil() {
				x.SecondChannel = nil
				return
			}
			x.SecondChannel = &RelaySecondChannel{}
			x.SecondChannel.UnmarshalProtoJSON(s.WithField("second_channel", true))
		case "default_channel_index", "defaultChannelIndex":
			s.AddField("default_channel_index")
			if s.ReadNil() {
				x.DefaultChannelIndex = nil
				return
			}
			v := s.ReadWrappedUint32()
			if s.Err() != nil {
				return
			}
			x.DefaultChannelIndex = &wrapperspb.UInt32Value{Value: v}
		case "cad_periodicity", "cadPeriodicity":
			s.AddField("cad_periodicity")
			x.CadPeriodicity.UnmarshalProtoJSON(s)
		case "uplink_forwarding_rules", "uplinkForwardingRules":
			s.AddField("uplink_forwarding_rules")
			if s.ReadNil() {
				x.UplinkForwardingRules = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.UplinkForwardingRules = append(x.UplinkForwardingRules, nil)
					return
				}
				v := &RelayUplinkForwardingRule{}
				v.UnmarshalProtoJSON(s.WithField("uplink_forwarding_rules", false))
				if s.Err() != nil {
					return
				}
				x.UplinkForwardingRules = append(x.UplinkForwardingRules, v)
			})
		case "limits":
			if s.ReadNil() {
				x.Limits = nil
				return
			}
			x.Limits = &ServingRelayForwardingLimits{}
			x.Limits.UnmarshalProtoJSON(s.WithField("limits", true))
		}
	})
}

// UnmarshalJSON unmarshals the ServingRelaySettings from JSON.
func (x *ServingRelaySettings) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ServedRelaySettings message to JSON.
func (x *ServedRelaySettings) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Mode != nil {
		switch ov := x.Mode.(type) {
		case *ServedRelaySettings_Always:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("always")
			// NOTE: RelayEndDeviceAlwaysMode does not seem to implement MarshalProtoJSON.
			golang.MarshalMessage(s, ov.Always)
		case *ServedRelaySettings_Dynamic:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("dynamic")
			ov.Dynamic.MarshalProtoJSON(s.WithField("dynamic"))
		case *ServedRelaySettings_EndDeviceControlled:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("end_device_controlled")
			// NOTE: RelayEndDeviceControlledMode does not seem to implement MarshalProtoJSON.
			golang.MarshalMessage(s, ov.EndDeviceControlled)
		}
	}
	if x.Backoff != nil || s.HasField("backoff") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("backoff")
		if x.Backoff == nil {
			s.WriteNil()
		} else {
			s.WriteUint32(x.Backoff.Value)
		}
	}
	if x.SecondChannel != nil || s.HasField("second_channel") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("second_channel")
		x.SecondChannel.MarshalProtoJSON(s.WithField("second_channel"))
	}
	if x.ServingDeviceId != "" || s.HasField("serving_device_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("serving_device_id")
		s.WriteString(x.ServingDeviceId)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ServedRelaySettings to JSON.
func (x *ServedRelaySettings) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ServedRelaySettings message from JSON.
func (x *ServedRelaySettings) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "always":
			s.AddField("always")
			ov := &ServedRelaySettings_Always{}
			x.Mode = ov
			if s.ReadNil() {
				ov.Always = nil
				return
			}
			// NOTE: RelayEndDeviceAlwaysMode does not seem to implement UnmarshalProtoJSON.
			var v RelayEndDeviceAlwaysMode
			golang.UnmarshalMessage(s, &v)
			ov.Always = &v
		case "dynamic":
			ov := &ServedRelaySettings_Dynamic{}
			x.Mode = ov
			if s.ReadNil() {
				ov.Dynamic = nil
				return
			}
			ov.Dynamic = &RelayEndDeviceDynamicMode{}
			ov.Dynamic.UnmarshalProtoJSON(s.WithField("dynamic", true))
		case "end_device_controlled", "endDeviceControlled":
			s.AddField("end_device_controlled")
			ov := &ServedRelaySettings_EndDeviceControlled{}
			x.Mode = ov
			if s.ReadNil() {
				ov.EndDeviceControlled = nil
				return
			}
			// NOTE: RelayEndDeviceControlledMode does not seem to implement UnmarshalProtoJSON.
			var v RelayEndDeviceControlledMode
			golang.UnmarshalMessage(s, &v)
			ov.EndDeviceControlled = &v
		case "backoff":
			s.AddField("backoff")
			if s.ReadNil() {
				x.Backoff = nil
				return
			}
			v := s.ReadWrappedUint32()
			if s.Err() != nil {
				return
			}
			x.Backoff = &wrapperspb.UInt32Value{Value: v}
		case "second_channel", "secondChannel":
			if s.ReadNil() {
				x.SecondChannel = nil
				return
			}
			x.SecondChannel = &RelaySecondChannel{}
			x.SecondChannel.UnmarshalProtoJSON(s.WithField("second_channel", true))
		case "serving_device_id", "servingDeviceId":
			s.AddField("serving_device_id")
			x.ServingDeviceId = s.ReadString()
		}
	})
}

// UnmarshalJSON unmarshals the ServedRelaySettings from JSON.
func (x *ServedRelaySettings) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the RelaySettings message to JSON.
func (x *RelaySettings) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Mode != nil {
		switch ov := x.Mode.(type) {
		case *RelaySettings_Serving:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("serving")
			ov.Serving.MarshalProtoJSON(s.WithField("serving"))
		case *RelaySettings_Served:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("served")
			ov.Served.MarshalProtoJSON(s.WithField("served"))
		}
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the RelaySettings to JSON.
func (x *RelaySettings) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the RelaySettings message from JSON.
func (x *RelaySettings) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "serving":
			ov := &RelaySettings_Serving{}
			x.Mode = ov
			if s.ReadNil() {
				ov.Serving = nil
				return
			}
			ov.Serving = &ServingRelaySettings{}
			ov.Serving.UnmarshalProtoJSON(s.WithField("serving", true))
		case "served":
			ov := &RelaySettings_Served{}
			x.Mode = ov
			if s.ReadNil() {
				ov.Served = nil
				return
			}
			ov.Served = &ServedRelaySettings{}
			ov.Served.UnmarshalProtoJSON(s.WithField("served", true))
		}
	})
}

// UnmarshalJSON unmarshals the RelaySettings from JSON.
func (x *RelaySettings) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MACParameters_Channel message to JSON.
func (x *MACParameters_Channel) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.UplinkFrequency != 0 || s.HasField("uplink_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("uplink_frequency")
		s.WriteUint64(x.UplinkFrequency)
	}
	if x.DownlinkFrequency != 0 || s.HasField("downlink_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("downlink_frequency")
		s.WriteUint64(x.DownlinkFrequency)
	}
	if x.MinDataRateIndex != 0 || s.HasField("min_data_rate_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("min_data_rate_index")
		x.MinDataRateIndex.MarshalProtoJSON(s)
	}
	if x.MaxDataRateIndex != 0 || s.HasField("max_data_rate_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("max_data_rate_index")
		x.MaxDataRateIndex.MarshalProtoJSON(s)
	}
	if x.EnableUplink || s.HasField("enable_uplink") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("enable_uplink")
		s.WriteBool(x.EnableUplink)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MACParameters_Channel to JSON.
func (x *MACParameters_Channel) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MACParameters_Channel message from JSON.
func (x *MACParameters_Channel) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "uplink_frequency", "uplinkFrequency":
			s.AddField("uplink_frequency")
			x.UplinkFrequency = s.ReadUint64()
		case "downlink_frequency", "downlinkFrequency":
			s.AddField("downlink_frequency")
			x.DownlinkFrequency = s.ReadUint64()
		case "min_data_rate_index", "minDataRateIndex":
			s.AddField("min_data_rate_index")
			x.MinDataRateIndex.UnmarshalProtoJSON(s)
		case "max_data_rate_index", "maxDataRateIndex":
			s.AddField("max_data_rate_index")
			x.MaxDataRateIndex.UnmarshalProtoJSON(s)
		case "enable_uplink", "enableUplink":
			s.AddField("enable_uplink")
			x.EnableUplink = s.ReadBool()
		}
	})
}

// UnmarshalJSON unmarshals the MACParameters_Channel from JSON.
func (x *MACParameters_Channel) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MACParameters message to JSON.
func (x *MACParameters) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.MaxEirp != 0 || s.HasField("max_eirp") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("max_eirp")
		s.WriteFloat32(x.MaxEirp)
	}
	if x.AdrDataRateIndex != 0 || s.HasField("adr_data_rate_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("adr_data_rate_index")
		x.AdrDataRateIndex.MarshalProtoJSON(s)
	}
	if x.AdrTxPowerIndex != 0 || s.HasField("adr_tx_power_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("adr_tx_power_index")
		s.WriteUint32(x.AdrTxPowerIndex)
	}
	if x.AdrNbTrans != 0 || s.HasField("adr_nb_trans") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("adr_nb_trans")
		s.WriteUint32(x.AdrNbTrans)
	}
	if x.AdrAckLimit != 0 || s.HasField("adr_ack_limit") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("adr_ack_limit")
		s.WriteUint32(x.AdrAckLimit)
	}
	if x.AdrAckDelay != 0 || s.HasField("adr_ack_delay") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("adr_ack_delay")
		s.WriteUint32(x.AdrAckDelay)
	}
	if x.Rx1Delay != 0 || s.HasField("rx1_delay") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rx1_delay")
		x.Rx1Delay.MarshalProtoJSON(s)
	}
	if x.Rx1DataRateOffset != 0 || s.HasField("rx1_data_rate_offset") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rx1_data_rate_offset")
		x.Rx1DataRateOffset.MarshalProtoJSON(s)
	}
	if x.Rx2DataRateIndex != 0 || s.HasField("rx2_data_rate_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rx2_data_rate_index")
		x.Rx2DataRateIndex.MarshalProtoJSON(s)
	}
	if x.Rx2Frequency != 0 || s.HasField("rx2_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rx2_frequency")
		s.WriteUint64(x.Rx2Frequency)
	}
	if x.MaxDutyCycle != 0 || s.HasField("max_duty_cycle") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("max_duty_cycle")
		x.MaxDutyCycle.MarshalProtoJSON(s)
	}
	if x.RejoinTimePeriodicity != 0 || s.HasField("rejoin_time_periodicity") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rejoin_time_periodicity")
		x.RejoinTimePeriodicity.MarshalProtoJSON(s)
	}
	if x.RejoinCountPeriodicity != 0 || s.HasField("rejoin_count_periodicity") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rejoin_count_periodicity")
		x.RejoinCountPeriodicity.MarshalProtoJSON(s)
	}
	if x.PingSlotFrequency != 0 || s.HasField("ping_slot_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("ping_slot_frequency")
		s.WriteUint64(x.PingSlotFrequency)
	}
	if x.PingSlotDataRateIndex != 0 || s.HasField("ping_slot_data_rate_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("ping_slot_data_rate_index")
		x.PingSlotDataRateIndex.MarshalProtoJSON(s)
	}
	if x.BeaconFrequency != 0 || s.HasField("beacon_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("beacon_frequency")
		s.WriteUint64(x.BeaconFrequency)
	}
	if len(x.Channels) > 0 || s.HasField("channels") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("channels")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.Channels {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("channels"))
		}
		s.WriteArrayEnd()
	}
	if x.UplinkDwellTime != nil || s.HasField("uplink_dwell_time") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("uplink_dwell_time")
		x.UplinkDwellTime.MarshalProtoJSON(s.WithField("uplink_dwell_time"))
	}
	if x.DownlinkDwellTime != nil || s.HasField("downlink_dwell_time") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("downlink_dwell_time")
		x.DownlinkDwellTime.MarshalProtoJSON(s.WithField("downlink_dwell_time"))
	}
	if x.AdrAckLimitExponent != nil || s.HasField("adr_ack_limit_exponent") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("adr_ack_limit_exponent")
		x.AdrAckLimitExponent.MarshalProtoJSON(s.WithField("adr_ack_limit_exponent"))
	}
	if x.AdrAckDelayExponent != nil || s.HasField("adr_ack_delay_exponent") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("adr_ack_delay_exponent")
		x.AdrAckDelayExponent.MarshalProtoJSON(s.WithField("adr_ack_delay_exponent"))
	}
	if x.PingSlotDataRateIndexValue != nil || s.HasField("ping_slot_data_rate_index_value") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("ping_slot_data_rate_index_value")
		x.PingSlotDataRateIndexValue.MarshalProtoJSON(s.WithField("ping_slot_data_rate_index_value"))
	}
	if x.Relay != nil || s.HasField("relay") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("relay")
		x.Relay.MarshalProtoJSON(s.WithField("relay"))
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MACParameters to JSON.
func (x *MACParameters) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MACParameters message from JSON.
func (x *MACParameters) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "max_eirp", "maxEirp":
			s.AddField("max_eirp")
			x.MaxEirp = s.ReadFloat32()
		case "adr_data_rate_index", "adrDataRateIndex":
			s.AddField("adr_data_rate_index")
			x.AdrDataRateIndex.UnmarshalProtoJSON(s)
		case "adr_tx_power_index", "adrTxPowerIndex":
			s.AddField("adr_tx_power_index")
			x.AdrTxPowerIndex = s.ReadUint32()
		case "adr_nb_trans", "adrNbTrans":
			s.AddField("adr_nb_trans")
			x.AdrNbTrans = s.ReadUint32()
		case "adr_ack_limit", "adrAckLimit":
			s.AddField("adr_ack_limit")
			x.AdrAckLimit = s.ReadUint32()
		case "adr_ack_delay", "adrAckDelay":
			s.AddField("adr_ack_delay")
			x.AdrAckDelay = s.ReadUint32()
		case "rx1_delay", "rx1Delay":
			s.AddField("rx1_delay")
			x.Rx1Delay.UnmarshalProtoJSON(s)
		case "rx1_data_rate_offset", "rx1DataRateOffset":
			s.AddField("rx1_data_rate_offset")
			x.Rx1DataRateOffset.UnmarshalProtoJSON(s)
		case "rx2_data_rate_index", "rx2DataRateIndex":
			s.AddField("rx2_data_rate_index")
			x.Rx2DataRateIndex.UnmarshalProtoJSON(s)
		case "rx2_frequency", "rx2Frequency":
			s.AddField("rx2_frequency")
			x.Rx2Frequency = s.ReadUint64()
		case "max_duty_cycle", "maxDutyCycle":
			s.AddField("max_duty_cycle")
			x.MaxDutyCycle.UnmarshalProtoJSON(s)
		case "rejoin_time_periodicity", "rejoinTimePeriodicity":
			s.AddField("rejoin_time_periodicity")
			x.RejoinTimePeriodicity.UnmarshalProtoJSON(s)
		case "rejoin_count_periodicity", "rejoinCountPeriodicity":
			s.AddField("rejoin_count_periodicity")
			x.RejoinCountPeriodicity.UnmarshalProtoJSON(s)
		case "ping_slot_frequency", "pingSlotFrequency":
			s.AddField("ping_slot_frequency")
			x.PingSlotFrequency = s.ReadUint64()
		case "ping_slot_data_rate_index", "pingSlotDataRateIndex":
			s.AddField("ping_slot_data_rate_index")
			x.PingSlotDataRateIndex.UnmarshalProtoJSON(s)
		case "beacon_frequency", "beaconFrequency":
			s.AddField("beacon_frequency")
			x.BeaconFrequency = s.ReadUint64()
		case "channels":
			s.AddField("channels")
			if s.ReadNil() {
				x.Channels = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.Channels = append(x.Channels, nil)
					return
				}
				v := &MACParameters_Channel{}
				v.UnmarshalProtoJSON(s.WithField("channels", false))
				if s.Err() != nil {
					return
				}
				x.Channels = append(x.Channels, v)
			})
		case "uplink_dwell_time", "uplinkDwellTime":
			s.AddField("uplink_dwell_time")
			if s.ReadNil() {
				x.UplinkDwellTime = nil
				return
			}
			x.UplinkDwellTime = &BoolValue{}
			x.UplinkDwellTime.UnmarshalProtoJSON(s.WithField("uplink_dwell_time", false))
		case "downlink_dwell_time", "downlinkDwellTime":
			s.AddField("downlink_dwell_time")
			if s.ReadNil() {
				x.DownlinkDwellTime = nil
				return
			}
			x.DownlinkDwellTime = &BoolValue{}
			x.DownlinkDwellTime.UnmarshalProtoJSON(s.WithField("downlink_dwell_time", false))
		case "adr_ack_limit_exponent", "adrAckLimitExponent":
			s.AddField("adr_ack_limit_exponent")
			if s.ReadNil() {
				x.AdrAckLimitExponent = nil
				return
			}
			x.AdrAckLimitExponent = &ADRAckLimitExponentValue{}
			x.AdrAckLimitExponent.UnmarshalProtoJSON(s.WithField("adr_ack_limit_exponent", false))
		case "adr_ack_delay_exponent", "adrAckDelayExponent":
			s.AddField("adr_ack_delay_exponent")
			if s.ReadNil() {
				x.AdrAckDelayExponent = nil
				return
			}
			x.AdrAckDelayExponent = &ADRAckDelayExponentValue{}
			x.AdrAckDelayExponent.UnmarshalProtoJSON(s.WithField("adr_ack_delay_exponent", false))
		case "ping_slot_data_rate_index_value", "pingSlotDataRateIndexValue":
			s.AddField("ping_slot_data_rate_index_value")
			if s.ReadNil() {
				x.PingSlotDataRateIndexValue = nil
				return
			}
			x.PingSlotDataRateIndexValue = &DataRateIndexValue{}
			x.PingSlotDataRateIndexValue.UnmarshalProtoJSON(s.WithField("ping_slot_data_rate_index_value", false))
		case "relay":
			if s.ReadNil() {
				x.Relay = nil
				return
			}
			x.Relay = &RelayParameters{}
			x.Relay.UnmarshalProtoJSON(s.WithField("relay", true))
		}
	})
}

// UnmarshalJSON unmarshals the MACParameters from JSON.
func (x *MACParameters) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the EndDeviceVersion message to JSON.
func (x *EndDeviceVersion) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Ids != nil || s.HasField("ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("ids")
		// NOTE: EndDeviceVersionIdentifiers does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.Ids)
	}
	if x.LorawanVersion != 0 || s.HasField("lorawan_version") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("lorawan_version")
		x.LorawanVersion.MarshalProtoJSON(s)
	}
	if x.LorawanPhyVersion != 0 || s.HasField("lorawan_phy_version") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("lorawan_phy_version")
		x.LorawanPhyVersion.MarshalProtoJSON(s)
	}
	if x.FrequencyPlanId != "" || s.HasField("frequency_plan_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("frequency_plan_id")
		s.WriteString(x.FrequencyPlanId)
	}
	if len(x.Photos) > 0 || s.HasField("photos") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("photos")
		s.WriteStringArray(x.Photos)
	}
	if x.SupportsClassB || s.HasField("supports_class_b") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("supports_class_b")
		s.WriteBool(x.SupportsClassB)
	}
	if x.SupportsClassC || s.HasField("supports_class_c") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("supports_class_c")
		s.WriteBool(x.SupportsClassC)
	}
	if x.DefaultMacSettings != nil || s.HasField("default_mac_settings") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("default_mac_settings")
		x.DefaultMacSettings.MarshalProtoJSON(s.WithField("default_mac_settings"))
	}
	if x.MinFrequency != 0 || s.HasField("min_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("min_frequency")
		s.WriteUint64(x.MinFrequency)
	}
	if x.MaxFrequency != 0 || s.HasField("max_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("max_frequency")
		s.WriteUint64(x.MaxFrequency)
	}
	if x.SupportsJoin || s.HasField("supports_join") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("supports_join")
		s.WriteBool(x.SupportsJoin)
	}
	if x.ResetsJoinNonces || s.HasField("resets_join_nonces") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("resets_join_nonces")
		s.WriteBool(x.ResetsJoinNonces)
	}
	if x.DefaultFormatters != nil || s.HasField("default_formatters") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("default_formatters")
		x.DefaultFormatters.MarshalProtoJSON(s.WithField("default_formatters"))
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the EndDeviceVersion to JSON.
func (x *EndDeviceVersion) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the EndDeviceVersion message from JSON.
func (x *EndDeviceVersion) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "ids":
			s.AddField("ids")
			if s.ReadNil() {
				x.Ids = nil
				return
			}
			// NOTE: EndDeviceVersionIdentifiers does not seem to implement UnmarshalProtoJSON.
			var v EndDeviceVersionIdentifiers
			golang.UnmarshalMessage(s, &v)
			x.Ids = &v
		case "lorawan_version", "lorawanVersion":
			s.AddField("lorawan_version")
			x.LorawanVersion.UnmarshalProtoJSON(s)
		case "lorawan_phy_version", "lorawanPhyVersion":
			s.AddField("lorawan_phy_version")
			x.LorawanPhyVersion.UnmarshalProtoJSON(s)
		case "frequency_plan_id", "frequencyPlanId":
			s.AddField("frequency_plan_id")
			x.FrequencyPlanId = s.ReadString()
		case "photos":
			s.AddField("photos")
			if s.ReadNil() {
				x.Photos = nil
				return
			}
			x.Photos = s.ReadStringArray()
		case "supports_class_b", "supportsClassB":
			s.AddField("supports_class_b")
			x.SupportsClassB = s.ReadBool()
		case "supports_class_c", "supportsClassC":
			s.AddField("supports_class_c")
			x.SupportsClassC = s.ReadBool()
		case "default_mac_settings", "defaultMacSettings":
			if s.ReadNil() {
				x.DefaultMacSettings = nil
				return
			}
			x.DefaultMacSettings = &MACSettings{}
			x.DefaultMacSettings.UnmarshalProtoJSON(s.WithField("default_mac_settings", true))
		case "min_frequency", "minFrequency":
			s.AddField("min_frequency")
			x.MinFrequency = s.ReadUint64()
		case "max_frequency", "maxFrequency":
			s.AddField("max_frequency")
			x.MaxFrequency = s.ReadUint64()
		case "supports_join", "supportsJoin":
			s.AddField("supports_join")
			x.SupportsJoin = s.ReadBool()
		case "resets_join_nonces", "resetsJoinNonces":
			s.AddField("resets_join_nonces")
			x.ResetsJoinNonces = s.ReadBool()
		case "default_formatters", "defaultFormatters":
			if s.ReadNil() {
				x.DefaultFormatters = nil
				return
			}
			x.DefaultFormatters = &MessagePayloadFormatters{}
			x.DefaultFormatters.UnmarshalProtoJSON(s.WithField("default_formatters", true))
		}
	})
}

// UnmarshalJSON unmarshals the EndDeviceVersion from JSON.
func (x *EndDeviceVersion) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ADRSettings_StaticMode message to JSON.
func (x *ADRSettings_StaticMode) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.DataRateIndex != 0 || s.HasField("data_rate_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("data_rate_index")
		x.DataRateIndex.MarshalProtoJSON(s)
	}
	if x.TxPowerIndex != 0 || s.HasField("tx_power_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("tx_power_index")
		s.WriteUint32(x.TxPowerIndex)
	}
	if x.NbTrans != 0 || s.HasField("nb_trans") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("nb_trans")
		s.WriteUint32(x.NbTrans)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ADRSettings_StaticMode to JSON.
func (x *ADRSettings_StaticMode) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ADRSettings_StaticMode message from JSON.
func (x *ADRSettings_StaticMode) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "data_rate_index", "dataRateIndex":
			s.AddField("data_rate_index")
			x.DataRateIndex.UnmarshalProtoJSON(s)
		case "tx_power_index", "txPowerIndex":
			s.AddField("tx_power_index")
			x.TxPowerIndex = s.ReadUint32()
		case "nb_trans", "nbTrans":
			s.AddField("nb_trans")
			x.NbTrans = s.ReadUint32()
		}
	})
}

// UnmarshalJSON unmarshals the ADRSettings_StaticMode from JSON.
func (x *ADRSettings_StaticMode) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ADRSettings_DynamicMode message to JSON.
func (x *ADRSettings_DynamicMode) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Margin != nil || s.HasField("margin") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("margin")
		if x.Margin == nil {
			s.WriteNil()
		} else {
			s.WriteFloat32(x.Margin.Value)
		}
	}
	if x.MinDataRateIndex != nil || s.HasField("min_data_rate_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("min_data_rate_index")
		x.MinDataRateIndex.MarshalProtoJSON(s.WithField("min_data_rate_index"))
	}
	if x.MaxDataRateIndex != nil || s.HasField("max_data_rate_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("max_data_rate_index")
		x.MaxDataRateIndex.MarshalProtoJSON(s.WithField("max_data_rate_index"))
	}
	if x.MinTxPowerIndex != nil || s.HasField("min_tx_power_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("min_tx_power_index")
		if x.MinTxPowerIndex == nil {
			s.WriteNil()
		} else {
			s.WriteUint32(x.MinTxPowerIndex.Value)
		}
	}
	if x.MaxTxPowerIndex != nil || s.HasField("max_tx_power_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("max_tx_power_index")
		if x.MaxTxPowerIndex == nil {
			s.WriteNil()
		} else {
			s.WriteUint32(x.MaxTxPowerIndex.Value)
		}
	}
	if x.MinNbTrans != nil || s.HasField("min_nb_trans") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("min_nb_trans")
		if x.MinNbTrans == nil {
			s.WriteNil()
		} else {
			s.WriteUint32(x.MinNbTrans.Value)
		}
	}
	if x.MaxNbTrans != nil || s.HasField("max_nb_trans") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("max_nb_trans")
		if x.MaxNbTrans == nil {
			s.WriteNil()
		} else {
			s.WriteUint32(x.MaxNbTrans.Value)
		}
	}
	if x.ChannelSteering != nil || s.HasField("channel_steering") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("channel_steering")
		// NOTE: ADRSettings_DynamicMode_ChannelSteeringSettings does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.ChannelSteering)
	}
	if x.Overrides != nil || s.HasField("overrides") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("overrides")
		// NOTE: ADRSettings_DynamicMode_Overrides does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.Overrides)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ADRSettings_DynamicMode to JSON.
func (x *ADRSettings_DynamicMode) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ADRSettings_DynamicMode message from JSON.
func (x *ADRSettings_DynamicMode) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "margin":
			s.AddField("margin")
			if s.ReadNil() {
				x.Margin = nil
				return
			}
			v := s.ReadWrappedFloat32()
			if s.Err() != nil {
				return
			}
			x.Margin = &wrapperspb.FloatValue{Value: v}
		case "min_data_rate_index", "minDataRateIndex":
			s.AddField("min_data_rate_index")
			if s.ReadNil() {
				x.MinDataRateIndex = nil
				return
			}
			x.MinDataRateIndex = &DataRateIndexValue{}
			x.MinDataRateIndex.UnmarshalProtoJSON(s.WithField("min_data_rate_index", false))
		case "max_data_rate_index", "maxDataRateIndex":
			s.AddField("max_data_rate_index")
			if s.ReadNil() {
				x.MaxDataRateIndex = nil
				return
			}
			x.MaxDataRateIndex = &DataRateIndexValue{}
			x.MaxDataRateIndex.UnmarshalProtoJSON(s.WithField("max_data_rate_index", false))
		case "min_tx_power_index", "minTxPowerIndex":
			s.AddField("min_tx_power_index")
			if s.ReadNil() {
				x.MinTxPowerIndex = nil
				return
			}
			v := s.ReadWrappedUint32()
			if s.Err() != nil {
				return
			}
			x.MinTxPowerIndex = &wrapperspb.UInt32Value{Value: v}
		case "max_tx_power_index", "maxTxPowerIndex":
			s.AddField("max_tx_power_index")
			if s.ReadNil() {
				x.MaxTxPowerIndex = nil
				return
			}
			v := s.ReadWrappedUint32()
			if s.Err() != nil {
				return
			}
			x.MaxTxPowerIndex = &wrapperspb.UInt32Value{Value: v}
		case "min_nb_trans", "minNbTrans":
			s.AddField("min_nb_trans")
			if s.ReadNil() {
				x.MinNbTrans = nil
				return
			}
			v := s.ReadWrappedUint32()
			if s.Err() != nil {
				return
			}
			x.MinNbTrans = &wrapperspb.UInt32Value{Value: v}
		case "max_nb_trans", "maxNbTrans":
			s.AddField("max_nb_trans")
			if s.ReadNil() {
				x.MaxNbTrans = nil
				return
			}
			v := s.ReadWrappedUint32()
			if s.Err() != nil {
				return
			}
			x.MaxNbTrans = &wrapperspb.UInt32Value{Value: v}
		case "channel_steering", "channelSteering":
			s.AddField("channel_steering")
			if s.ReadNil() {
				x.ChannelSteering = nil
				return
			}
			// NOTE: ADRSettings_DynamicMode_ChannelSteeringSettings does not seem to implement UnmarshalProtoJSON.
			var v ADRSettings_DynamicMode_ChannelSteeringSettings
			golang.UnmarshalMessage(s, &v)
			x.ChannelSteering = &v
		case "overrides":
			s.AddField("overrides")
			if s.ReadNil() {
				x.Overrides = nil
				return
			}
			// NOTE: ADRSettings_DynamicMode_Overrides does not seem to implement UnmarshalProtoJSON.
			var v ADRSettings_DynamicMode_Overrides
			golang.UnmarshalMessage(s, &v)
			x.Overrides = &v
		}
	})
}

// UnmarshalJSON unmarshals the ADRSettings_DynamicMode from JSON.
func (x *ADRSettings_DynamicMode) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ADRSettings message to JSON.
func (x *ADRSettings) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Mode != nil {
		switch ov := x.Mode.(type) {
		case *ADRSettings_Static:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("static")
			ov.Static.MarshalProtoJSON(s.WithField("static"))
		case *ADRSettings_Dynamic:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("dynamic")
			ov.Dynamic.MarshalProtoJSON(s.WithField("dynamic"))
		case *ADRSettings_Disabled:
			s.WriteMoreIf(&wroteField)
			s.WriteObjectField("disabled")
			// NOTE: ADRSettings_DisabledMode does not seem to implement MarshalProtoJSON.
			golang.MarshalMessage(s, ov.Disabled)
		}
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ADRSettings to JSON.
func (x *ADRSettings) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ADRSettings message from JSON.
func (x *ADRSettings) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "static":
			ov := &ADRSettings_Static{}
			x.Mode = ov
			if s.ReadNil() {
				ov.Static = nil
				return
			}
			ov.Static = &ADRSettings_StaticMode{}
			ov.Static.UnmarshalProtoJSON(s.WithField("static", true))
		case "dynamic":
			ov := &ADRSettings_Dynamic{}
			x.Mode = ov
			if s.ReadNil() {
				ov.Dynamic = nil
				return
			}
			ov.Dynamic = &ADRSettings_DynamicMode{}
			ov.Dynamic.UnmarshalProtoJSON(s.WithField("dynamic", true))
		case "disabled":
			s.AddField("disabled")
			ov := &ADRSettings_Disabled{}
			x.Mode = ov
			if s.ReadNil() {
				ov.Disabled = nil
				return
			}
			// NOTE: ADRSettings_DisabledMode does not seem to implement UnmarshalProtoJSON.
			var v ADRSettings_DisabledMode
			golang.UnmarshalMessage(s, &v)
			ov.Disabled = &v
		}
	})
}

// UnmarshalJSON unmarshals the ADRSettings from JSON.
func (x *ADRSettings) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MACSettings message to JSON.
func (x *MACSettings) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.ClassBTimeout != nil || s.HasField("class_b_timeout") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("class_b_timeout")
		if x.ClassBTimeout == nil {
			s.WriteNil()
		} else {
			golang.MarshalDuration(s, x.ClassBTimeout)
		}
	}
	if x.PingSlotPeriodicity != nil || s.HasField("ping_slot_periodicity") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("ping_slot_periodicity")
		x.PingSlotPeriodicity.MarshalProtoJSON(s.WithField("ping_slot_periodicity"))
	}
	if x.PingSlotDataRateIndex != nil || s.HasField("ping_slot_data_rate_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("ping_slot_data_rate_index")
		x.PingSlotDataRateIndex.MarshalProtoJSON(s.WithField("ping_slot_data_rate_index"))
	}
	if x.PingSlotFrequency != nil || s.HasField("ping_slot_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("ping_slot_frequency")
		x.PingSlotFrequency.MarshalProtoJSON(s.WithField("ping_slot_frequency"))
	}
	if x.BeaconFrequency != nil || s.HasField("beacon_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("beacon_frequency")
		x.BeaconFrequency.MarshalProtoJSON(s.WithField("beacon_frequency"))
	}
	if x.ClassCTimeout != nil || s.HasField("class_c_timeout") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("class_c_timeout")
		if x.ClassCTimeout == nil {
			s.WriteNil()
		} else {
			golang.MarshalDuration(s, x.ClassCTimeout)
		}
	}
	if x.Rx1Delay != nil || s.HasField("rx1_delay") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rx1_delay")
		x.Rx1Delay.MarshalProtoJSON(s.WithField("rx1_delay"))
	}
	if x.Rx1DataRateOffset != nil || s.HasField("rx1_data_rate_offset") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rx1_data_rate_offset")
		x.Rx1DataRateOffset.MarshalProtoJSON(s.WithField("rx1_data_rate_offset"))
	}
	if x.Rx2DataRateIndex != nil || s.HasField("rx2_data_rate_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rx2_data_rate_index")
		x.Rx2DataRateIndex.MarshalProtoJSON(s.WithField("rx2_data_rate_index"))
	}
	if x.Rx2Frequency != nil || s.HasField("rx2_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rx2_frequency")
		x.Rx2Frequency.MarshalProtoJSON(s.WithField("rx2_frequency"))
	}
	if len(x.FactoryPresetFrequencies) > 0 || s.HasField("factory_preset_frequencies") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("factory_preset_frequencies")
		s.WriteUint64Array(x.FactoryPresetFrequencies)
	}
	if x.MaxDutyCycle != nil || s.HasField("max_duty_cycle") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("max_duty_cycle")
		x.MaxDutyCycle.MarshalProtoJSON(s.WithField("max_duty_cycle"))
	}
	if x.Supports_32BitFCnt != nil || s.HasField("supports_32_bit_f_cnt") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("supports_32_bit_f_cnt")
		x.Supports_32BitFCnt.MarshalProtoJSON(s.WithField("supports_32_bit_f_cnt"))
	}
	if x.UseAdr != nil || s.HasField("use_adr") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("use_adr")
		x.UseAdr.MarshalProtoJSON(s.WithField("use_adr"))
	}
	if x.AdrMargin != nil || s.HasField("adr_margin") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("adr_margin")
		if x.AdrMargin == nil {
			s.WriteNil()
		} else {
			s.WriteFloat32(x.AdrMargin.Value)
		}
	}
	if x.ResetsFCnt != nil || s.HasField("resets_f_cnt") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("resets_f_cnt")
		x.ResetsFCnt.MarshalProtoJSON(s.WithField("resets_f_cnt"))
	}
	if x.StatusTimePeriodicity != nil || s.HasField("status_time_periodicity") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("status_time_periodicity")
		if x.StatusTimePeriodicity == nil {
			s.WriteNil()
		} else {
			golang.MarshalDuration(s, x.StatusTimePeriodicity)
		}
	}
	if x.StatusCountPeriodicity != nil || s.HasField("status_count_periodicity") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("status_count_periodicity")
		if x.StatusCountPeriodicity == nil {
			s.WriteNil()
		} else {
			s.WriteUint32(x.StatusCountPeriodicity.Value)
		}
	}
	if x.DesiredRx1Delay != nil || s.HasField("desired_rx1_delay") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("desired_rx1_delay")
		x.DesiredRx1Delay.MarshalProtoJSON(s.WithField("desired_rx1_delay"))
	}
	if x.DesiredRx1DataRateOffset != nil || s.HasField("desired_rx1_data_rate_offset") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("desired_rx1_data_rate_offset")
		x.DesiredRx1DataRateOffset.MarshalProtoJSON(s.WithField("desired_rx1_data_rate_offset"))
	}
	if x.DesiredRx2DataRateIndex != nil || s.HasField("desired_rx2_data_rate_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("desired_rx2_data_rate_index")
		x.DesiredRx2DataRateIndex.MarshalProtoJSON(s.WithField("desired_rx2_data_rate_index"))
	}
	if x.DesiredRx2Frequency != nil || s.HasField("desired_rx2_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("desired_rx2_frequency")
		x.DesiredRx2Frequency.MarshalProtoJSON(s.WithField("desired_rx2_frequency"))
	}
	if x.DesiredMaxDutyCycle != nil || s.HasField("desired_max_duty_cycle") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("desired_max_duty_cycle")
		x.DesiredMaxDutyCycle.MarshalProtoJSON(s.WithField("desired_max_duty_cycle"))
	}
	if x.DesiredAdrAckLimitExponent != nil || s.HasField("desired_adr_ack_limit_exponent") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("desired_adr_ack_limit_exponent")
		x.DesiredAdrAckLimitExponent.MarshalProtoJSON(s.WithField("desired_adr_ack_limit_exponent"))
	}
	if x.DesiredAdrAckDelayExponent != nil || s.HasField("desired_adr_ack_delay_exponent") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("desired_adr_ack_delay_exponent")
		x.DesiredAdrAckDelayExponent.MarshalProtoJSON(s.WithField("desired_adr_ack_delay_exponent"))
	}
	if x.DesiredPingSlotDataRateIndex != nil || s.HasField("desired_ping_slot_data_rate_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("desired_ping_slot_data_rate_index")
		x.DesiredPingSlotDataRateIndex.MarshalProtoJSON(s.WithField("desired_ping_slot_data_rate_index"))
	}
	if x.DesiredPingSlotFrequency != nil || s.HasField("desired_ping_slot_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("desired_ping_slot_frequency")
		x.DesiredPingSlotFrequency.MarshalProtoJSON(s.WithField("desired_ping_slot_frequency"))
	}
	if x.DesiredBeaconFrequency != nil || s.HasField("desired_beacon_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("desired_beacon_frequency")
		x.DesiredBeaconFrequency.MarshalProtoJSON(s.WithField("desired_beacon_frequency"))
	}
	if x.DesiredMaxEirp != nil || s.HasField("desired_max_eirp") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("desired_max_eirp")
		x.DesiredMaxEirp.MarshalProtoJSON(s.WithField("desired_max_eirp"))
	}
	if x.ClassBCDownlinkInterval != nil || s.HasField("class_b_c_downlink_interval") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("class_b_c_downlink_interval")
		if x.ClassBCDownlinkInterval == nil {
			s.WriteNil()
		} else {
			golang.MarshalDuration(s, x.ClassBCDownlinkInterval)
		}
	}
	if x.UplinkDwellTime != nil || s.HasField("uplink_dwell_time") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("uplink_dwell_time")
		x.UplinkDwellTime.MarshalProtoJSON(s.WithField("uplink_dwell_time"))
	}
	if x.DownlinkDwellTime != nil || s.HasField("downlink_dwell_time") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("downlink_dwell_time")
		x.DownlinkDwellTime.MarshalProtoJSON(s.WithField("downlink_dwell_time"))
	}
	if x.Adr != nil || s.HasField("adr") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("adr")
		x.Adr.MarshalProtoJSON(s.WithField("adr"))
	}
	if x.ScheduleDownlinks != nil || s.HasField("schedule_downlinks") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("schedule_downlinks")
		x.ScheduleDownlinks.MarshalProtoJSON(s.WithField("schedule_downlinks"))
	}
	if x.Relay != nil || s.HasField("relay") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("relay")
		x.Relay.MarshalProtoJSON(s.WithField("relay"))
	}
	if x.DesiredRelay != nil || s.HasField("desired_relay") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("desired_relay")
		x.DesiredRelay.MarshalProtoJSON(s.WithField("desired_relay"))
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MACSettings to JSON.
func (x *MACSettings) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MACSettings message from JSON.
func (x *MACSettings) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "class_b_timeout", "classBTimeout":
			s.AddField("class_b_timeout")
			if s.ReadNil() {
				x.ClassBTimeout = nil
				return
			}
			v := golang.UnmarshalDuration(s)
			if s.Err() != nil {
				return
			}
			x.ClassBTimeout = v
		case "ping_slot_periodicity", "pingSlotPeriodicity":
			s.AddField("ping_slot_periodicity")
			if s.ReadNil() {
				x.PingSlotPeriodicity = nil
				return
			}
			x.PingSlotPeriodicity = &PingSlotPeriodValue{}
			x.PingSlotPeriodicity.UnmarshalProtoJSON(s.WithField("ping_slot_periodicity", false))
		case "ping_slot_data_rate_index", "pingSlotDataRateIndex":
			s.AddField("ping_slot_data_rate_index")
			if s.ReadNil() {
				x.PingSlotDataRateIndex = nil
				return
			}
			x.PingSlotDataRateIndex = &DataRateIndexValue{}
			x.PingSlotDataRateIndex.UnmarshalProtoJSON(s.WithField("ping_slot_data_rate_index", false))
		case "ping_slot_frequency", "pingSlotFrequency":
			s.AddField("ping_slot_frequency")
			if s.ReadNil() {
				x.PingSlotFrequency = nil
				return
			}
			x.PingSlotFrequency = &ZeroableFrequencyValue{}
			x.PingSlotFrequency.UnmarshalProtoJSON(s.WithField("ping_slot_frequency", false))
		case "beacon_frequency", "beaconFrequency":
			s.AddField("beacon_frequency")
			if s.ReadNil() {
				x.BeaconFrequency = nil
				return
			}
			x.BeaconFrequency = &ZeroableFrequencyValue{}
			x.BeaconFrequency.UnmarshalProtoJSON(s.WithField("beacon_frequency", false))
		case "class_c_timeout", "classCTimeout":
			s.AddField("class_c_timeout")
			if s.ReadNil() {
				x.ClassCTimeout = nil
				return
			}
			v := golang.UnmarshalDuration(s)
			if s.Err() != nil {
				return
			}
			x.ClassCTimeout = v
		case "rx1_delay", "rx1Delay":
			s.AddField("rx1_delay")
			if s.ReadNil() {
				x.Rx1Delay = nil
				return
			}
			x.Rx1Delay = &RxDelayValue{}
			x.Rx1Delay.UnmarshalProtoJSON(s.WithField("rx1_delay", false))
		case "rx1_data_rate_offset", "rx1DataRateOffset":
			s.AddField("rx1_data_rate_offset")
			if s.ReadNil() {
				x.Rx1DataRateOffset = nil
				return
			}
			x.Rx1DataRateOffset = &DataRateOffsetValue{}
			x.Rx1DataRateOffset.UnmarshalProtoJSON(s.WithField("rx1_data_rate_offset", false))
		case "rx2_data_rate_index", "rx2DataRateIndex":
			s.AddField("rx2_data_rate_index")
			if s.ReadNil() {
				x.Rx2DataRateIndex = nil
				return
			}
			x.Rx2DataRateIndex = &DataRateIndexValue{}
			x.Rx2DataRateIndex.UnmarshalProtoJSON(s.WithField("rx2_data_rate_index", false))
		case "rx2_frequency", "rx2Frequency":
			s.AddField("rx2_frequency")
			if s.ReadNil() {
				x.Rx2Frequency = nil
				return
			}
			x.Rx2Frequency = &FrequencyValue{}
			x.Rx2Frequency.UnmarshalProtoJSON(s.WithField("rx2_frequency", false))
		case "factory_preset_frequencies", "factoryPresetFrequencies":
			s.AddField("factory_preset_frequencies")
			if s.ReadNil() {
				x.FactoryPresetFrequencies = nil
				return
			}
			x.FactoryPresetFrequencies = s.ReadUint64Array()
		case "max_duty_cycle", "maxDutyCycle":
			s.AddField("max_duty_cycle")
			if s.ReadNil() {
				x.MaxDutyCycle = nil
				return
			}
			x.MaxDutyCycle = &AggregatedDutyCycleValue{}
			x.MaxDutyCycle.UnmarshalProtoJSON(s.WithField("max_duty_cycle", false))
		case "supports_32_bit_f_cnt", "supports32BitFCnt":
			s.AddField("supports_32_bit_f_cnt")
			if s.ReadNil() {
				x.Supports_32BitFCnt = nil
				return
			}
			x.Supports_32BitFCnt = &BoolValue{}
			x.Supports_32BitFCnt.UnmarshalProtoJSON(s.WithField("supports_32_bit_f_cnt", false))
		case "use_adr", "useAdr":
			s.AddField("use_adr")
			if s.ReadNil() {
				x.UseAdr = nil
				return
			}
			x.UseAdr = &BoolValue{}
			x.UseAdr.UnmarshalProtoJSON(s.WithField("use_adr", false))
		case "adr_margin", "adrMargin":
			s.AddField("adr_margin")
			if s.ReadNil() {
				x.AdrMargin = nil
				return
			}
			v := s.ReadWrappedFloat32()
			if s.Err() != nil {
				return
			}
			x.AdrMargin = &wrapperspb.FloatValue{Value: v}
		case "resets_f_cnt", "resetsFCnt":
			s.AddField("resets_f_cnt")
			if s.ReadNil() {
				x.ResetsFCnt = nil
				return
			}
			x.ResetsFCnt = &BoolValue{}
			x.ResetsFCnt.UnmarshalProtoJSON(s.WithField("resets_f_cnt", false))
		case "status_time_periodicity", "statusTimePeriodicity":
			s.AddField("status_time_periodicity")
			if s.ReadNil() {
				x.StatusTimePeriodicity = nil
				return
			}
			v := golang.UnmarshalDuration(s)
			if s.Err() != nil {
				return
			}
			x.StatusTimePeriodicity = v
		case "status_count_periodicity", "statusCountPeriodicity":
			s.AddField("status_count_periodicity")
			if s.ReadNil() {
				x.StatusCountPeriodicity = nil
				return
			}
			v := s.ReadWrappedUint32()
			if s.Err() != nil {
				return
			}
			x.StatusCountPeriodicity = &wrapperspb.UInt32Value{Value: v}
		case "desired_rx1_delay", "desiredRx1Delay":
			s.AddField("desired_rx1_delay")
			if s.ReadNil() {
				x.DesiredRx1Delay = nil
				return
			}
			x.DesiredRx1Delay = &RxDelayValue{}
			x.DesiredRx1Delay.UnmarshalProtoJSON(s.WithField("desired_rx1_delay", false))
		case "desired_rx1_data_rate_offset", "desiredRx1DataRateOffset":
			s.AddField("desired_rx1_data_rate_offset")
			if s.ReadNil() {
				x.DesiredRx1DataRateOffset = nil
				return
			}
			x.DesiredRx1DataRateOffset = &DataRateOffsetValue{}
			x.DesiredRx1DataRateOffset.UnmarshalProtoJSON(s.WithField("desired_rx1_data_rate_offset", false))
		case "desired_rx2_data_rate_index", "desiredRx2DataRateIndex":
			s.AddField("desired_rx2_data_rate_index")
			if s.ReadNil() {
				x.DesiredRx2DataRateIndex = nil
				return
			}
			x.DesiredRx2DataRateIndex = &DataRateIndexValue{}
			x.DesiredRx2DataRateIndex.UnmarshalProtoJSON(s.WithField("desired_rx2_data_rate_index", false))
		case "desired_rx2_frequency", "desiredRx2Frequency":
			s.AddField("desired_rx2_frequency")
			if s.ReadNil() {
				x.DesiredRx2Frequency = nil
				return
			}
			x.DesiredRx2Frequency = &FrequencyValue{}
			x.DesiredRx2Frequency.UnmarshalProtoJSON(s.WithField("desired_rx2_frequency", false))
		case "desired_max_duty_cycle", "desiredMaxDutyCycle":
			s.AddField("desired_max_duty_cycle")
			if s.ReadNil() {
				x.DesiredMaxDutyCycle = nil
				return
			}
			x.DesiredMaxDutyCycle = &AggregatedDutyCycleValue{}
			x.DesiredMaxDutyCycle.UnmarshalProtoJSON(s.WithField("desired_max_duty_cycle", false))
		case "desired_adr_ack_limit_exponent", "desiredAdrAckLimitExponent":
			s.AddField("desired_adr_ack_limit_exponent")
			if s.ReadNil() {
				x.DesiredAdrAckLimitExponent = nil
				return
			}
			x.DesiredAdrAckLimitExponent = &ADRAckLimitExponentValue{}
			x.DesiredAdrAckLimitExponent.UnmarshalProtoJSON(s.WithField("desired_adr_ack_limit_exponent", false))
		case "desired_adr_ack_delay_exponent", "desiredAdrAckDelayExponent":
			s.AddField("desired_adr_ack_delay_exponent")
			if s.ReadNil() {
				x.DesiredAdrAckDelayExponent = nil
				return
			}
			x.DesiredAdrAckDelayExponent = &ADRAckDelayExponentValue{}
			x.DesiredAdrAckDelayExponent.UnmarshalProtoJSON(s.WithField("desired_adr_ack_delay_exponent", false))
		case "desired_ping_slot_data_rate_index", "desiredPingSlotDataRateIndex":
			s.AddField("desired_ping_slot_data_rate_index")
			if s.ReadNil() {
				x.DesiredPingSlotDataRateIndex = nil
				return
			}
			x.DesiredPingSlotDataRateIndex = &DataRateIndexValue{}
			x.DesiredPingSlotDataRateIndex.UnmarshalProtoJSON(s.WithField("desired_ping_slot_data_rate_index", false))
		case "desired_ping_slot_frequency", "desiredPingSlotFrequency":
			s.AddField("desired_ping_slot_frequency")
			if s.ReadNil() {
				x.DesiredPingSlotFrequency = nil
				return
			}
			x.DesiredPingSlotFrequency = &ZeroableFrequencyValue{}
			x.DesiredPingSlotFrequency.UnmarshalProtoJSON(s.WithField("desired_ping_slot_frequency", false))
		case "desired_beacon_frequency", "desiredBeaconFrequency":
			s.AddField("desired_beacon_frequency")
			if s.ReadNil() {
				x.DesiredBeaconFrequency = nil
				return
			}
			x.DesiredBeaconFrequency = &ZeroableFrequencyValue{}
			x.DesiredBeaconFrequency.UnmarshalProtoJSON(s.WithField("desired_beacon_frequency", false))
		case "desired_max_eirp", "desiredMaxEirp":
			s.AddField("desired_max_eirp")
			if s.ReadNil() {
				x.DesiredMaxEirp = nil
				return
			}
			x.DesiredMaxEirp = &DeviceEIRPValue{}
			x.DesiredMaxEirp.UnmarshalProtoJSON(s.WithField("desired_max_eirp", false))
		case "class_b_c_downlink_interval", "classBCDownlinkInterval":
			s.AddField("class_b_c_downlink_interval")
			if s.ReadNil() {
				x.ClassBCDownlinkInterval = nil
				return
			}
			v := golang.UnmarshalDuration(s)
			if s.Err() != nil {
				return
			}
			x.ClassBCDownlinkInterval = v
		case "uplink_dwell_time", "uplinkDwellTime":
			s.AddField("uplink_dwell_time")
			if s.ReadNil() {
				x.UplinkDwellTime = nil
				return
			}
			x.UplinkDwellTime = &BoolValue{}
			x.UplinkDwellTime.UnmarshalProtoJSON(s.WithField("uplink_dwell_time", false))
		case "downlink_dwell_time", "downlinkDwellTime":
			s.AddField("downlink_dwell_time")
			if s.ReadNil() {
				x.DownlinkDwellTime = nil
				return
			}
			x.DownlinkDwellTime = &BoolValue{}
			x.DownlinkDwellTime.UnmarshalProtoJSON(s.WithField("downlink_dwell_time", false))
		case "adr":
			if s.ReadNil() {
				x.Adr = nil
				return
			}
			x.Adr = &ADRSettings{}
			x.Adr.UnmarshalProtoJSON(s.WithField("adr", true))
		case "schedule_downlinks", "scheduleDownlinks":
			s.AddField("schedule_downlinks")
			if s.ReadNil() {
				x.ScheduleDownlinks = nil
				return
			}
			x.ScheduleDownlinks = &BoolValue{}
			x.ScheduleDownlinks.UnmarshalProtoJSON(s.WithField("schedule_downlinks", false))
		case "relay":
			if s.ReadNil() {
				x.Relay = nil
				return
			}
			x.Relay = &RelaySettings{}
			x.Relay.UnmarshalProtoJSON(s.WithField("relay", true))
		case "desired_relay", "desiredRelay":
			if s.ReadNil() {
				x.DesiredRelay = nil
				return
			}
			x.DesiredRelay = &RelaySettings{}
			x.DesiredRelay.UnmarshalProtoJSON(s.WithField("desired_relay", true))
		}
	})
}

// UnmarshalJSON unmarshals the MACSettings from JSON.
func (x *MACSettings) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MACSettingsProfile message to JSON.
func (x *MACSettingsProfile) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Ids != nil || s.HasField("ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("ids")
		// NOTE: MACSettingsProfileIdentifiers does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.Ids)
	}
	if x.MacSettings != nil || s.HasField("mac_settings") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("mac_settings")
		x.MacSettings.MarshalProtoJSON(s.WithField("mac_settings"))
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MACSettingsProfile to JSON.
func (x *MACSettingsProfile) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MACSettingsProfile message from JSON.
func (x *MACSettingsProfile) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "ids":
			s.AddField("ids")
			if s.ReadNil() {
				x.Ids = nil
				return
			}
			// NOTE: MACSettingsProfileIdentifiers does not seem to implement UnmarshalProtoJSON.
			var v MACSettingsProfileIdentifiers
			golang.UnmarshalMessage(s, &v)
			x.Ids = &v
		case "mac_settings", "macSettings":
			if s.ReadNil() {
				x.MacSettings = nil
				return
			}
			x.MacSettings = &MACSettings{}
			x.MacSettings.UnmarshalProtoJSON(s.WithField("mac_settings", true))
		}
	})
}

// UnmarshalJSON unmarshals the MACSettingsProfile from JSON.
func (x *MACSettingsProfile) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MACState_JoinRequest message to JSON.
func (x *MACState_JoinRequest) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.DownlinkSettings != nil || s.HasField("downlink_settings") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("downlink_settings")
		x.DownlinkSettings.MarshalProtoJSON(s.WithField("downlink_settings"))
	}
	if x.RxDelay != 0 || s.HasField("rx_delay") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rx_delay")
		x.RxDelay.MarshalProtoJSON(s)
	}
	if x.CfList != nil || s.HasField("cf_list") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("cf_list")
		x.CfList.MarshalProtoJSON(s.WithField("cf_list"))
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MACState_JoinRequest to JSON.
func (x *MACState_JoinRequest) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MACState_JoinRequest message from JSON.
func (x *MACState_JoinRequest) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "downlink_settings", "downlinkSettings":
			if s.ReadNil() {
				x.DownlinkSettings = nil
				return
			}
			x.DownlinkSettings = &DLSettings{}
			x.DownlinkSettings.UnmarshalProtoJSON(s.WithField("downlink_settings", true))
		case "rx_delay", "rxDelay":
			s.AddField("rx_delay")
			x.RxDelay.UnmarshalProtoJSON(s)
		case "cf_list", "cfList":
			if s.ReadNil() {
				x.CfList = nil
				return
			}
			x.CfList = &CFList{}
			x.CfList.UnmarshalProtoJSON(s.WithField("cf_list", true))
		}
	})
}

// UnmarshalJSON unmarshals the MACState_JoinRequest from JSON.
func (x *MACState_JoinRequest) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MACState_JoinAccept message to JSON.
func (x *MACState_JoinAccept) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.Payload) > 0 || s.HasField("payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("payload")
		s.WriteBytes(x.Payload)
	}
	if x.Request != nil || s.HasField("request") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("request")
		x.Request.MarshalProtoJSON(s.WithField("request"))
	}
	if x.Keys != nil || s.HasField("keys") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("keys")
		x.Keys.MarshalProtoJSON(s.WithField("keys"))
	}
	if len(x.CorrelationIds) > 0 || s.HasField("correlation_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("correlation_ids")
		s.WriteStringArray(x.CorrelationIds)
	}
	if len(x.DevAddr) > 0 || s.HasField("dev_addr") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("dev_addr")
		types.MarshalHEXBytes(s.WithField("dev_addr"), x.DevAddr)
	}
	if len(x.NetId) > 0 || s.HasField("net_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("net_id")
		types.MarshalHEXBytes(s.WithField("net_id"), x.NetId)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MACState_JoinAccept to JSON.
func (x *MACState_JoinAccept) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MACState_JoinAccept message from JSON.
func (x *MACState_JoinAccept) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "payload":
			s.AddField("payload")
			x.Payload = s.ReadBytes()
		case "request":
			if s.ReadNil() {
				x.Request = nil
				return
			}
			x.Request = &MACState_JoinRequest{}
			x.Request.UnmarshalProtoJSON(s.WithField("request", true))
		case "keys":
			if s.ReadNil() {
				x.Keys = nil
				return
			}
			x.Keys = &SessionKeys{}
			x.Keys.UnmarshalProtoJSON(s.WithField("keys", true))
		case "correlation_ids", "correlationIds":
			s.AddField("correlation_ids")
			if s.ReadNil() {
				x.CorrelationIds = nil
				return
			}
			x.CorrelationIds = s.ReadStringArray()
		case "dev_addr", "devAddr":
			s.AddField("dev_addr")
			x.DevAddr = types.Unmarshal4Bytes(s.WithField("dev_addr", false))
		case "net_id", "netId":
			s.AddField("net_id")
			x.NetId = types.Unmarshal3Bytes(s.WithField("net_id", false))
		}
	})
}

// UnmarshalJSON unmarshals the MACState_JoinAccept from JSON.
func (x *MACState_JoinAccept) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MACState_UplinkMessage_RxMetadata message to JSON.
func (x *MACState_UplinkMessage_RxMetadata) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.GatewayIds != nil || s.HasField("gateway_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("gateway_ids")
		x.GatewayIds.MarshalProtoJSON(s.WithField("gateway_ids"))
	}
	if x.ChannelRssi != 0 || s.HasField("channel_rssi") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("channel_rssi")
		s.WriteFloat32(x.ChannelRssi)
	}
	if x.Snr != 0 || s.HasField("snr") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("snr")
		s.WriteFloat32(x.Snr)
	}
	if x.DownlinkPathConstraint != 0 || s.HasField("downlink_path_constraint") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("downlink_path_constraint")
		x.DownlinkPathConstraint.MarshalProtoJSON(s)
	}
	if len(x.UplinkToken) > 0 || s.HasField("uplink_token") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("uplink_token")
		s.WriteBytes(x.UplinkToken)
	}
	if x.PacketBroker != nil || s.HasField("packet_broker") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("packet_broker")
		// NOTE: MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.PacketBroker)
	}
	if x.Relay != nil || s.HasField("relay") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("relay")
		// NOTE: MACState_UplinkMessage_RxMetadata_RelayMetadata does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.Relay)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MACState_UplinkMessage_RxMetadata to JSON.
func (x *MACState_UplinkMessage_RxMetadata) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MACState_UplinkMessage_RxMetadata message from JSON.
func (x *MACState_UplinkMessage_RxMetadata) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "gateway_ids", "gatewayIds":
			if s.ReadNil() {
				x.GatewayIds = nil
				return
			}
			x.GatewayIds = &GatewayIdentifiers{}
			x.GatewayIds.UnmarshalProtoJSON(s.WithField("gateway_ids", true))
		case "channel_rssi", "channelRssi":
			s.AddField("channel_rssi")
			x.ChannelRssi = s.ReadFloat32()
		case "snr":
			s.AddField("snr")
			x.Snr = s.ReadFloat32()
		case "downlink_path_constraint", "downlinkPathConstraint":
			s.AddField("downlink_path_constraint")
			x.DownlinkPathConstraint.UnmarshalProtoJSON(s)
		case "uplink_token", "uplinkToken":
			s.AddField("uplink_token")
			x.UplinkToken = s.ReadBytes()
		case "packet_broker", "packetBroker":
			s.AddField("packet_broker")
			if s.ReadNil() {
				x.PacketBroker = nil
				return
			}
			// NOTE: MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata does not seem to implement UnmarshalProtoJSON.
			var v MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata
			golang.UnmarshalMessage(s, &v)
			x.PacketBroker = &v
		case "relay":
			s.AddField("relay")
			if s.ReadNil() {
				x.Relay = nil
				return
			}
			// NOTE: MACState_UplinkMessage_RxMetadata_RelayMetadata does not seem to implement UnmarshalProtoJSON.
			var v MACState_UplinkMessage_RxMetadata_RelayMetadata
			golang.UnmarshalMessage(s, &v)
			x.Relay = &v
		}
	})
}

// UnmarshalJSON unmarshals the MACState_UplinkMessage_RxMetadata from JSON.
func (x *MACState_UplinkMessage_RxMetadata) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MACState_UplinkMessage message to JSON.
func (x *MACState_UplinkMessage) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Payload != nil || s.HasField("payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("payload")
		x.Payload.MarshalProtoJSON(s.WithField("payload"))
	}
	if x.Settings != nil || s.HasField("settings") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("settings")
		// NOTE: MACState_UplinkMessage_TxSettings does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.Settings)
	}
	if len(x.RxMetadata) > 0 || s.HasField("rx_metadata") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rx_metadata")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.RxMetadata {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("rx_metadata"))
		}
		s.WriteArrayEnd()
	}
	if x.ReceivedAt != nil || s.HasField("received_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("received_at")
		if x.ReceivedAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.ReceivedAt)
		}
	}
	if len(x.CorrelationIds) > 0 || s.HasField("correlation_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("correlation_ids")
		s.WriteStringArray(x.CorrelationIds)
	}
	if x.DeviceChannelIndex != 0 || s.HasField("device_channel_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("device_channel_index")
		s.WriteUint32(x.DeviceChannelIndex)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MACState_UplinkMessage to JSON.
func (x *MACState_UplinkMessage) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MACState_UplinkMessage message from JSON.
func (x *MACState_UplinkMessage) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "payload":
			if s.ReadNil() {
				x.Payload = nil
				return
			}
			x.Payload = &Message{}
			x.Payload.UnmarshalProtoJSON(s.WithField("payload", true))
		case "settings":
			s.AddField("settings")
			if s.ReadNil() {
				x.Settings = nil
				return
			}
			// NOTE: MACState_UplinkMessage_TxSettings does not seem to implement UnmarshalProtoJSON.
			var v MACState_UplinkMessage_TxSettings
			golang.UnmarshalMessage(s, &v)
			x.Settings = &v
		case "rx_metadata", "rxMetadata":
			s.AddField("rx_metadata")
			if s.ReadNil() {
				x.RxMetadata = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.RxMetadata = append(x.RxMetadata, nil)
					return
				}
				v := &MACState_UplinkMessage_RxMetadata{}
				v.UnmarshalProtoJSON(s.WithField("rx_metadata", false))
				if s.Err() != nil {
					return
				}
				x.RxMetadata = append(x.RxMetadata, v)
			})
		case "received_at", "receivedAt":
			s.AddField("received_at")
			if s.ReadNil() {
				x.ReceivedAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.ReceivedAt = v
		case "correlation_ids", "correlationIds":
			s.AddField("correlation_ids")
			if s.ReadNil() {
				x.CorrelationIds = nil
				return
			}
			x.CorrelationIds = s.ReadStringArray()
		case "device_channel_index", "deviceChannelIndex":
			s.AddField("device_channel_index")
			x.DeviceChannelIndex = s.ReadUint32()
		}
	})
}

// UnmarshalJSON unmarshals the MACState_UplinkMessage from JSON.
func (x *MACState_UplinkMessage) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MACState_DownlinkMessage_Message_MHDR message to JSON.
func (x *MACState_DownlinkMessage_Message_MHDR) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.MType != 0 || s.HasField("m_type") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("m_type")
		x.MType.MarshalProtoJSON(s)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MACState_DownlinkMessage_Message_MHDR to JSON.
func (x *MACState_DownlinkMessage_Message_MHDR) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MACState_DownlinkMessage_Message_MHDR message from JSON.
func (x *MACState_DownlinkMessage_Message_MHDR) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "m_type", "mType":
			s.AddField("m_type")
			x.MType.UnmarshalProtoJSON(s)
		}
	})
}

// UnmarshalJSON unmarshals the MACState_DownlinkMessage_Message_MHDR from JSON.
func (x *MACState_DownlinkMessage_Message_MHDR) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MACState_DownlinkMessage_Message message to JSON.
func (x *MACState_DownlinkMessage_Message) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.MHdr != nil || s.HasField("m_hdr") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("m_hdr")
		x.MHdr.MarshalProtoJSON(s.WithField("m_hdr"))
	}
	if x.MacPayload != nil || s.HasField("mac_payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("mac_payload")
		// NOTE: MACState_DownlinkMessage_Message_MACPayload does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.MacPayload)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MACState_DownlinkMessage_Message to JSON.
func (x *MACState_DownlinkMessage_Message) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MACState_DownlinkMessage_Message message from JSON.
func (x *MACState_DownlinkMessage_Message) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "m_hdr", "mHdr":
			if s.ReadNil() {
				x.MHdr = nil
				return
			}
			x.MHdr = &MACState_DownlinkMessage_Message_MHDR{}
			x.MHdr.UnmarshalProtoJSON(s.WithField("m_hdr", true))
		case "mac_payload", "macPayload":
			s.AddField("mac_payload")
			if s.ReadNil() {
				x.MacPayload = nil
				return
			}
			// NOTE: MACState_DownlinkMessage_Message_MACPayload does not seem to implement UnmarshalProtoJSON.
			var v MACState_DownlinkMessage_Message_MACPayload
			golang.UnmarshalMessage(s, &v)
			x.MacPayload = &v
		}
	})
}

// UnmarshalJSON unmarshals the MACState_DownlinkMessage_Message from JSON.
func (x *MACState_DownlinkMessage_Message) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MACState_DownlinkMessage message to JSON.
func (x *MACState_DownlinkMessage) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Payload != nil || s.HasField("payload") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("payload")
		x.Payload.MarshalProtoJSON(s.WithField("payload"))
	}
	if len(x.CorrelationIds) > 0 || s.HasField("correlation_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("correlation_ids")
		s.WriteStringArray(x.CorrelationIds)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MACState_DownlinkMessage to JSON.
func (x *MACState_DownlinkMessage) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MACState_DownlinkMessage message from JSON.
func (x *MACState_DownlinkMessage) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "payload":
			if s.ReadNil() {
				x.Payload = nil
				return
			}
			x.Payload = &MACState_DownlinkMessage_Message{}
			x.Payload.UnmarshalProtoJSON(s.WithField("payload", true))
		case "correlation_ids", "correlationIds":
			s.AddField("correlation_ids")
			if s.ReadNil() {
				x.CorrelationIds = nil
				return
			}
			x.CorrelationIds = s.ReadStringArray()
		}
	})
}

// UnmarshalJSON unmarshals the MACState_DownlinkMessage from JSON.
func (x *MACState_DownlinkMessage) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MACState_DataRateRange message to JSON.
func (x *MACState_DataRateRange) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.MinDataRateIndex != 0 || s.HasField("min_data_rate_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("min_data_rate_index")
		x.MinDataRateIndex.MarshalProtoJSON(s)
	}
	if x.MaxDataRateIndex != 0 || s.HasField("max_data_rate_index") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("max_data_rate_index")
		x.MaxDataRateIndex.MarshalProtoJSON(s)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MACState_DataRateRange to JSON.
func (x *MACState_DataRateRange) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MACState_DataRateRange message from JSON.
func (x *MACState_DataRateRange) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "min_data_rate_index", "minDataRateIndex":
			s.AddField("min_data_rate_index")
			x.MinDataRateIndex.UnmarshalProtoJSON(s)
		case "max_data_rate_index", "maxDataRateIndex":
			s.AddField("max_data_rate_index")
			x.MaxDataRateIndex.UnmarshalProtoJSON(s)
		}
	})
}

// UnmarshalJSON unmarshals the MACState_DataRateRange from JSON.
func (x *MACState_DataRateRange) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MACState_DataRateRanges message to JSON.
func (x *MACState_DataRateRanges) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.Ranges) > 0 || s.HasField("ranges") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("ranges")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.Ranges {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("ranges"))
		}
		s.WriteArrayEnd()
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MACState_DataRateRanges to JSON.
func (x *MACState_DataRateRanges) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MACState_DataRateRanges message from JSON.
func (x *MACState_DataRateRanges) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "ranges":
			s.AddField("ranges")
			if s.ReadNil() {
				x.Ranges = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.Ranges = append(x.Ranges, nil)
					return
				}
				v := &MACState_DataRateRange{}
				v.UnmarshalProtoJSON(s.WithField("ranges", false))
				if s.Err() != nil {
					return
				}
				x.Ranges = append(x.Ranges, v)
			})
		}
	})
}

// UnmarshalJSON unmarshals the MACState_DataRateRanges from JSON.
func (x *MACState_DataRateRanges) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the MACState message to JSON.
func (x *MACState) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.CurrentParameters != nil || s.HasField("current_parameters") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("current_parameters")
		x.CurrentParameters.MarshalProtoJSON(s.WithField("current_parameters"))
	}
	if x.DesiredParameters != nil || s.HasField("desired_parameters") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("desired_parameters")
		x.DesiredParameters.MarshalProtoJSON(s.WithField("desired_parameters"))
	}
	if x.DeviceClass != 0 || s.HasField("device_class") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("device_class")
		x.DeviceClass.MarshalProtoJSON(s)
	}
	if x.LorawanVersion != 0 || s.HasField("lorawan_version") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("lorawan_version")
		x.LorawanVersion.MarshalProtoJSON(s)
	}
	if x.LastConfirmedDownlinkAt != nil || s.HasField("last_confirmed_downlink_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_confirmed_downlink_at")
		if x.LastConfirmedDownlinkAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.LastConfirmedDownlinkAt)
		}
	}
	if x.LastDevStatusFCntUp != 0 || s.HasField("last_dev_status_f_cnt_up") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_dev_status_f_cnt_up")
		s.WriteUint32(x.LastDevStatusFCntUp)
	}
	if x.PingSlotPeriodicity != nil || s.HasField("ping_slot_periodicity") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("ping_slot_periodicity")
		x.PingSlotPeriodicity.MarshalProtoJSON(s.WithField("ping_slot_periodicity"))
	}
	if x.PendingApplicationDownlink != nil || s.HasField("pending_application_downlink") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("pending_application_downlink")
		x.PendingApplicationDownlink.MarshalProtoJSON(s.WithField("pending_application_downlink"))
	}
	if len(x.QueuedResponses) > 0 || s.HasField("queued_responses") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("queued_responses")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.QueuedResponses {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("queued_responses"))
		}
		s.WriteArrayEnd()
	}
	if len(x.PendingRequests) > 0 || s.HasField("pending_requests") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("pending_requests")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.PendingRequests {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("pending_requests"))
		}
		s.WriteArrayEnd()
	}
	if x.QueuedJoinAccept != nil || s.HasField("queued_join_accept") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("queued_join_accept")
		x.QueuedJoinAccept.MarshalProtoJSON(s.WithField("queued_join_accept"))
	}
	if x.PendingJoinRequest != nil || s.HasField("pending_join_request") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("pending_join_request")
		x.PendingJoinRequest.MarshalProtoJSON(s.WithField("pending_join_request"))
	}
	if x.RxWindowsAvailable || s.HasField("rx_windows_available") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rx_windows_available")
		s.WriteBool(x.RxWindowsAvailable)
	}
	if len(x.RecentUplinks) > 0 || s.HasField("recent_uplinks") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("recent_uplinks")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.RecentUplinks {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("recent_uplinks"))
		}
		s.WriteArrayEnd()
	}
	if len(x.RecentDownlinks) > 0 || s.HasField("recent_downlinks") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("recent_downlinks")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.RecentDownlinks {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("recent_downlinks"))
		}
		s.WriteArrayEnd()
	}
	if x.LastNetworkInitiatedDownlinkAt != nil || s.HasField("last_network_initiated_downlink_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_network_initiated_downlink_at")
		if x.LastNetworkInitiatedDownlinkAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.LastNetworkInitiatedDownlinkAt)
		}
	}
	if len(x.RejectedAdrDataRateIndexes) > 0 || s.HasField("rejected_adr_data_rate_indexes") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rejected_adr_data_rate_indexes")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.RejectedAdrDataRateIndexes {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s)
		}
		s.WriteArrayEnd()
	}
	if len(x.RejectedAdrTxPowerIndexes) > 0 || s.HasField("rejected_adr_tx_power_indexes") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rejected_adr_tx_power_indexes")
		s.WriteUint32Array(x.RejectedAdrTxPowerIndexes)
	}
	if len(x.RejectedFrequencies) > 0 || s.HasField("rejected_frequencies") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rejected_frequencies")
		s.WriteUint64Array(x.RejectedFrequencies)
	}
	if x.LastDownlinkAt != nil || s.HasField("last_downlink_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_downlink_at")
		if x.LastDownlinkAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.LastDownlinkAt)
		}
	}
	if x.RejectedDataRateRanges != nil || s.HasField("rejected_data_rate_ranges") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("rejected_data_rate_ranges")
		s.WriteObjectStart()
		var wroteElement bool
		for k, v := range x.RejectedDataRateRanges {
			s.WriteMoreIf(&wroteElement)
			s.WriteObjectUint64Field(k)
			v.MarshalProtoJSON(s.WithField("rejected_data_rate_ranges"))
		}
		s.WriteObjectEnd()
	}
	if x.LastAdrChangeFCntUp != 0 || s.HasField("last_adr_change_f_cnt_up") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_adr_change_f_cnt_up")
		s.WriteUint32(x.LastAdrChangeFCntUp)
	}
	if len(x.RecentMacCommandIdentifiers) > 0 || s.HasField("recent_mac_command_identifiers") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("recent_mac_command_identifiers")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.RecentMacCommandIdentifiers {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s)
		}
		s.WriteArrayEnd()
	}
	if x.PendingRelayDownlink != nil || s.HasField("pending_relay_downlink") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("pending_relay_downlink")
		// NOTE: RelayForwardDownlinkReq does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.PendingRelayDownlink)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the MACState to JSON.
func (x *MACState) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the MACState message from JSON.
func (x *MACState) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "current_parameters", "currentParameters":
			if s.ReadNil() {
				x.CurrentParameters = nil
				return
			}
			x.CurrentParameters = &MACParameters{}
			x.CurrentParameters.UnmarshalProtoJSON(s.WithField("current_parameters", true))
		case "desired_parameters", "desiredParameters":
			if s.ReadNil() {
				x.DesiredParameters = nil
				return
			}
			x.DesiredParameters = &MACParameters{}
			x.DesiredParameters.UnmarshalProtoJSON(s.WithField("desired_parameters", true))
		case "device_class", "deviceClass":
			s.AddField("device_class")
			x.DeviceClass.UnmarshalProtoJSON(s)
		case "lorawan_version", "lorawanVersion":
			s.AddField("lorawan_version")
			x.LorawanVersion.UnmarshalProtoJSON(s)
		case "last_confirmed_downlink_at", "lastConfirmedDownlinkAt":
			s.AddField("last_confirmed_downlink_at")
			if s.ReadNil() {
				x.LastConfirmedDownlinkAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.LastConfirmedDownlinkAt = v
		case "last_dev_status_f_cnt_up", "lastDevStatusFCntUp":
			s.AddField("last_dev_status_f_cnt_up")
			x.LastDevStatusFCntUp = s.ReadUint32()
		case "ping_slot_periodicity", "pingSlotPeriodicity":
			s.AddField("ping_slot_periodicity")
			if s.ReadNil() {
				x.PingSlotPeriodicity = nil
				return
			}
			x.PingSlotPeriodicity = &PingSlotPeriodValue{}
			x.PingSlotPeriodicity.UnmarshalProtoJSON(s.WithField("ping_slot_periodicity", false))
		case "pending_application_downlink", "pendingApplicationDownlink":
			if s.ReadNil() {
				x.PendingApplicationDownlink = nil
				return
			}
			x.PendingApplicationDownlink = &ApplicationDownlink{}
			x.PendingApplicationDownlink.UnmarshalProtoJSON(s.WithField("pending_application_downlink", true))
		case "queued_responses", "queuedResponses":
			s.AddField("queued_responses")
			if s.ReadNil() {
				x.QueuedResponses = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.QueuedResponses = append(x.QueuedResponses, nil)
					return
				}
				v := &MACCommand{}
				v.UnmarshalProtoJSON(s.WithField("queued_responses", false))
				if s.Err() != nil {
					return
				}
				x.QueuedResponses = append(x.QueuedResponses, v)
			})
		case "pending_requests", "pendingRequests":
			s.AddField("pending_requests")
			if s.ReadNil() {
				x.PendingRequests = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.PendingRequests = append(x.PendingRequests, nil)
					return
				}
				v := &MACCommand{}
				v.UnmarshalProtoJSON(s.WithField("pending_requests", false))
				if s.Err() != nil {
					return
				}
				x.PendingRequests = append(x.PendingRequests, v)
			})
		case "queued_join_accept", "queuedJoinAccept":
			if s.ReadNil() {
				x.QueuedJoinAccept = nil
				return
			}
			x.QueuedJoinAccept = &MACState_JoinAccept{}
			x.QueuedJoinAccept.UnmarshalProtoJSON(s.WithField("queued_join_accept", true))
		case "pending_join_request", "pendingJoinRequest":
			if s.ReadNil() {
				x.PendingJoinRequest = nil
				return
			}
			x.PendingJoinRequest = &MACState_JoinRequest{}
			x.PendingJoinRequest.UnmarshalProtoJSON(s.WithField("pending_join_request", true))
		case "rx_windows_available", "rxWindowsAvailable":
			s.AddField("rx_windows_available")
			x.RxWindowsAvailable = s.ReadBool()
		case "recent_uplinks", "recentUplinks":
			s.AddField("recent_uplinks")
			if s.ReadNil() {
				x.RecentUplinks = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.RecentUplinks = append(x.RecentUplinks, nil)
					return
				}
				v := &MACState_UplinkMessage{}
				v.UnmarshalProtoJSON(s.WithField("recent_uplinks", false))
				if s.Err() != nil {
					return
				}
				x.RecentUplinks = append(x.RecentUplinks, v)
			})
		case "recent_downlinks", "recentDownlinks":
			s.AddField("recent_downlinks")
			if s.ReadNil() {
				x.RecentDownlinks = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.RecentDownlinks = append(x.RecentDownlinks, nil)
					return
				}
				v := &MACState_DownlinkMessage{}
				v.UnmarshalProtoJSON(s.WithField("recent_downlinks", false))
				if s.Err() != nil {
					return
				}
				x.RecentDownlinks = append(x.RecentDownlinks, v)
			})
		case "last_network_initiated_downlink_at", "lastNetworkInitiatedDownlinkAt":
			s.AddField("last_network_initiated_downlink_at")
			if s.ReadNil() {
				x.LastNetworkInitiatedDownlinkAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.LastNetworkInitiatedDownlinkAt = v
		case "rejected_adr_data_rate_indexes", "rejectedAdrDataRateIndexes":
			s.AddField("rejected_adr_data_rate_indexes")
			if s.ReadNil() {
				x.RejectedAdrDataRateIndexes = nil
				return
			}
			s.ReadArray(func() {
				var v DataRateIndex
				v.UnmarshalProtoJSON(s)
				x.RejectedAdrDataRateIndexes = append(x.RejectedAdrDataRateIndexes, v)
			})
		case "rejected_adr_tx_power_indexes", "rejectedAdrTxPowerIndexes":
			s.AddField("rejected_adr_tx_power_indexes")
			if s.ReadNil() {
				x.RejectedAdrTxPowerIndexes = nil
				return
			}
			x.RejectedAdrTxPowerIndexes = s.ReadUint32Array()
		case "rejected_frequencies", "rejectedFrequencies":
			s.AddField("rejected_frequencies")
			if s.ReadNil() {
				x.RejectedFrequencies = nil
				return
			}
			x.RejectedFrequencies = s.ReadUint64Array()
		case "last_downlink_at", "lastDownlinkAt":
			s.AddField("last_downlink_at")
			if s.ReadNil() {
				x.LastDownlinkAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.LastDownlinkAt = v
		case "rejected_data_rate_ranges", "rejectedDataRateRanges":
			s.AddField("rejected_data_rate_ranges")
			if s.ReadNil() {
				x.RejectedDataRateRanges = nil
				return
			}
			x.RejectedDataRateRanges = make(map[uint64]*MACState_DataRateRanges)
			s.ReadUint64Map(func(key uint64) {
				var v MACState_DataRateRanges
				v.UnmarshalProtoJSON(s)
				x.RejectedDataRateRanges[key] = &v
			})
		case "last_adr_change_f_cnt_up", "lastAdrChangeFCntUp":
			s.AddField("last_adr_change_f_cnt_up")
			x.LastAdrChangeFCntUp = s.ReadUint32()
		case "recent_mac_command_identifiers", "recentMacCommandIdentifiers":
			s.AddField("recent_mac_command_identifiers")
			if s.ReadNil() {
				x.RecentMacCommandIdentifiers = nil
				return
			}
			s.ReadArray(func() {
				var v MACCommandIdentifier
				v.UnmarshalProtoJSON(s)
				x.RecentMacCommandIdentifiers = append(x.RecentMacCommandIdentifiers, v)
			})
		case "pending_relay_downlink", "pendingRelayDownlink":
			s.AddField("pending_relay_downlink")
			if s.ReadNil() {
				x.PendingRelayDownlink = nil
				return
			}
			// NOTE: RelayForwardDownlinkReq does not seem to implement UnmarshalProtoJSON.
			var v RelayForwardDownlinkReq
			golang.UnmarshalMessage(s, &v)
			x.PendingRelayDownlink = &v
		}
	})
}

// UnmarshalJSON unmarshals the MACState from JSON.
func (x *MACState) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the EndDevice message to JSON.
func (x *EndDevice) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Ids != nil || s.HasField("ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("ids")
		x.Ids.MarshalProtoJSON(s.WithField("ids"))
	}
	if x.CreatedAt != nil || s.HasField("created_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("created_at")
		if x.CreatedAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.CreatedAt)
		}
	}
	if x.UpdatedAt != nil || s.HasField("updated_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("updated_at")
		if x.UpdatedAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.UpdatedAt)
		}
	}
	if x.Name != "" || s.HasField("name") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("name")
		s.WriteString(x.Name)
	}
	if x.Description != "" || s.HasField("description") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("description")
		s.WriteString(x.Description)
	}
	if x.Attributes != nil || s.HasField("attributes") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("attributes")
		s.WriteObjectStart()
		var wroteElement bool
		for k, v := range x.Attributes {
			s.WriteMoreIf(&wroteElement)
			s.WriteObjectStringField(k)
			s.WriteString(v)
		}
		s.WriteObjectEnd()
	}
	if x.VersionIds != nil || s.HasField("version_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("version_ids")
		// NOTE: EndDeviceVersionIdentifiers does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.VersionIds)
	}
	if x.ServiceProfileId != "" || s.HasField("service_profile_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("service_profile_id")
		s.WriteString(x.ServiceProfileId)
	}
	if x.NetworkServerAddress != "" || s.HasField("network_server_address") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("network_server_address")
		s.WriteString(x.NetworkServerAddress)
	}
	if x.NetworkServerKekLabel != "" || s.HasField("network_server_kek_label") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("network_server_kek_label")
		s.WriteString(x.NetworkServerKekLabel)
	}
	if x.ApplicationServerAddress != "" || s.HasField("application_server_address") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("application_server_address")
		s.WriteString(x.ApplicationServerAddress)
	}
	if x.ApplicationServerKekLabel != "" || s.HasField("application_server_kek_label") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("application_server_kek_label")
		s.WriteString(x.ApplicationServerKekLabel)
	}
	if x.ApplicationServerId != "" || s.HasField("application_server_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("application_server_id")
		s.WriteString(x.ApplicationServerId)
	}
	if x.JoinServerAddress != "" || s.HasField("join_server_address") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("join_server_address")
		s.WriteString(x.JoinServerAddress)
	}
	if x.Locations != nil || s.HasField("locations") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("locations")
		s.WriteObjectStart()
		var wroteElement bool
		for k, v := range x.Locations {
			s.WriteMoreIf(&wroteElement)
			s.WriteObjectStringField(k)
			v.MarshalProtoJSON(s.WithField("locations"))
		}
		s.WriteObjectEnd()
	}
	if x.Picture != nil || s.HasField("picture") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("picture")
		// NOTE: Picture does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.Picture)
	}
	if x.SupportsClassB || s.HasField("supports_class_b") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("supports_class_b")
		s.WriteBool(x.SupportsClassB)
	}
	if x.SupportsClassC || s.HasField("supports_class_c") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("supports_class_c")
		s.WriteBool(x.SupportsClassC)
	}
	if x.LorawanVersion != 0 || s.HasField("lorawan_version") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("lorawan_version")
		x.LorawanVersion.MarshalProtoJSON(s)
	}
	if x.LorawanPhyVersion != 0 || s.HasField("lorawan_phy_version") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("lorawan_phy_version")
		x.LorawanPhyVersion.MarshalProtoJSON(s)
	}
	if x.FrequencyPlanId != "" || s.HasField("frequency_plan_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("frequency_plan_id")
		s.WriteString(x.FrequencyPlanId)
	}
	if x.MinFrequency != 0 || s.HasField("min_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("min_frequency")
		s.WriteUint64(x.MinFrequency)
	}
	if x.MaxFrequency != 0 || s.HasField("max_frequency") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("max_frequency")
		s.WriteUint64(x.MaxFrequency)
	}
	if x.SupportsJoin || s.HasField("supports_join") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("supports_join")
		s.WriteBool(x.SupportsJoin)
	}
	if x.ResetsJoinNonces || s.HasField("resets_join_nonces") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("resets_join_nonces")
		s.WriteBool(x.ResetsJoinNonces)
	}
	if x.RootKeys != nil || s.HasField("root_keys") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("root_keys")
		x.RootKeys.MarshalProtoJSON(s.WithField("root_keys"))
	}
	if len(x.NetId) > 0 || s.HasField("net_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("net_id")
		types.MarshalHEXBytes(s.WithField("net_id"), x.NetId)
	}
	if x.MacSettings != nil || s.HasField("mac_settings") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("mac_settings")
		x.MacSettings.MarshalProtoJSON(s.WithField("mac_settings"))
	}
	if x.MacState != nil || s.HasField("mac_state") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("mac_state")
		x.MacState.MarshalProtoJSON(s.WithField("mac_state"))
	}
	if x.PendingMacState != nil || s.HasField("pending_mac_state") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("pending_mac_state")
		x.PendingMacState.MarshalProtoJSON(s.WithField("pending_mac_state"))
	}
	if x.Session != nil || s.HasField("session") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("session")
		x.Session.MarshalProtoJSON(s.WithField("session"))
	}
	if x.PendingSession != nil || s.HasField("pending_session") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("pending_session")
		x.PendingSession.MarshalProtoJSON(s.WithField("pending_session"))
	}
	if x.LastDevNonce != 0 || s.HasField("last_dev_nonce") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_dev_nonce")
		s.WriteUint32(x.LastDevNonce)
	}
	if len(x.UsedDevNonces) > 0 || s.HasField("used_dev_nonces") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("used_dev_nonces")
		s.WriteUint32Array(x.UsedDevNonces)
	}
	if x.LastJoinNonce != 0 || s.HasField("last_join_nonce") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_join_nonce")
		s.WriteUint32(x.LastJoinNonce)
	}
	if x.LastRjCount_0 != 0 || s.HasField("last_rj_count_0") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_rj_count_0")
		s.WriteUint32(x.LastRjCount_0)
	}
	if x.LastRjCount_1 != 0 || s.HasField("last_rj_count_1") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_rj_count_1")
		s.WriteUint32(x.LastRjCount_1)
	}
	if x.LastDevStatusReceivedAt != nil || s.HasField("last_dev_status_received_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_dev_status_received_at")
		if x.LastDevStatusReceivedAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.LastDevStatusReceivedAt)
		}
	}
	if x.PowerState != 0 || s.HasField("power_state") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("power_state")
		x.PowerState.MarshalProtoJSON(s)
	}
	if x.BatteryPercentage != nil || s.HasField("battery_percentage") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("battery_percentage")
		if x.BatteryPercentage == nil {
			s.WriteNil()
		} else {
			s.WriteFloat32(x.BatteryPercentage.Value)
		}
	}
	if x.DownlinkMargin != 0 || s.HasField("downlink_margin") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("downlink_margin")
		s.WriteInt32(x.DownlinkMargin)
	}
	if len(x.QueuedApplicationDownlinks) > 0 || s.HasField("queued_application_downlinks") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("queued_application_downlinks")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.QueuedApplicationDownlinks {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("queued_application_downlinks"))
		}
		s.WriteArrayEnd()
	}
	if x.Formatters != nil || s.HasField("formatters") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("formatters")
		x.Formatters.MarshalProtoJSON(s.WithField("formatters"))
	}
	if x.ProvisionerId != "" || s.HasField("provisioner_id") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("provisioner_id")
		s.WriteString(x.ProvisionerId)
	}
	if x.ProvisioningData != nil || s.HasField("provisioning_data") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("provisioning_data")
		if x.ProvisioningData == nil {
			s.WriteNil()
		} else {
			golang.MarshalStruct(s, x.ProvisioningData)
		}
	}
	if x.Multicast || s.HasField("multicast") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("multicast")
		s.WriteBool(x.Multicast)
	}
	if x.ClaimAuthenticationCode != nil || s.HasField("claim_authentication_code") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("claim_authentication_code")
		// NOTE: EndDeviceAuthenticationCode does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.ClaimAuthenticationCode)
	}
	if x.SkipPayloadCrypto || s.HasField("skip_payload_crypto") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("skip_payload_crypto")
		s.WriteBool(x.SkipPayloadCrypto)
	}
	if x.SkipPayloadCryptoOverride != nil || s.HasField("skip_payload_crypto_override") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("skip_payload_crypto_override")
		if x.SkipPayloadCryptoOverride == nil {
			s.WriteNil()
		} else {
			s.WriteBool(x.SkipPayloadCryptoOverride.Value)
		}
	}
	if x.ActivatedAt != nil || s.HasField("activated_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("activated_at")
		if x.ActivatedAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.ActivatedAt)
		}
	}
	if x.LastSeenAt != nil || s.HasField("last_seen_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_seen_at")
		if x.LastSeenAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.LastSeenAt)
		}
	}
	if x.SerialNumber != "" || s.HasField("serial_number") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("serial_number")
		s.WriteString(x.SerialNumber)
	}
	if x.LoraAllianceProfileIds != nil || s.HasField("lora_alliance_profile_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("lora_alliance_profile_ids")
		// NOTE: LoRaAllianceProfileIdentifiers does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.LoraAllianceProfileIds)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the EndDevice to JSON.
func (x *EndDevice) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the EndDevice message from JSON.
func (x *EndDevice) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "ids":
			if s.ReadNil() {
				x.Ids = nil
				return
			}
			x.Ids = &EndDeviceIdentifiers{}
			x.Ids.UnmarshalProtoJSON(s.WithField("ids", true))
		case "created_at", "createdAt":
			s.AddField("created_at")
			if s.ReadNil() {
				x.CreatedAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.CreatedAt = v
		case "updated_at", "updatedAt":
			s.AddField("updated_at")
			if s.ReadNil() {
				x.UpdatedAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.UpdatedAt = v
		case "name":
			s.AddField("name")
			x.Name = s.ReadString()
		case "description":
			s.AddField("description")
			x.Description = s.ReadString()
		case "attributes":
			s.AddField("attributes")
			if s.ReadNil() {
				x.Attributes = nil
				return
			}
			x.Attributes = make(map[string]string)
			s.ReadStringMap(func(key string) {
				x.Attributes[key] = s.ReadString()
			})
		case "version_ids", "versionIds":
			s.AddField("version_ids")
			if s.ReadNil() {
				x.VersionIds = nil
				return
			}
			// NOTE: EndDeviceVersionIdentifiers does not seem to implement UnmarshalProtoJSON.
			var v EndDeviceVersionIdentifiers
			golang.UnmarshalMessage(s, &v)
			x.VersionIds = &v
		case "service_profile_id", "serviceProfileId":
			s.AddField("service_profile_id")
			x.ServiceProfileId = s.ReadString()
		case "network_server_address", "networkServerAddress":
			s.AddField("network_server_address")
			x.NetworkServerAddress = s.ReadString()
		case "network_server_kek_label", "networkServerKekLabel":
			s.AddField("network_server_kek_label")
			x.NetworkServerKekLabel = s.ReadString()
		case "application_server_address", "applicationServerAddress":
			s.AddField("application_server_address")
			x.ApplicationServerAddress = s.ReadString()
		case "application_server_kek_label", "applicationServerKekLabel":
			s.AddField("application_server_kek_label")
			x.ApplicationServerKekLabel = s.ReadString()
		case "application_server_id", "applicationServerId":
			s.AddField("application_server_id")
			x.ApplicationServerId = s.ReadString()
		case "join_server_address", "joinServerAddress":
			s.AddField("join_server_address")
			x.JoinServerAddress = s.ReadString()
		case "locations":
			s.AddField("locations")
			if s.ReadNil() {
				x.Locations = nil
				return
			}
			x.Locations = make(map[string]*Location)
			s.ReadStringMap(func(key string) {
				var v Location
				v.UnmarshalProtoJSON(s)
				x.Locations[key] = &v
			})
		case "picture":
			s.AddField("picture")
			if s.ReadNil() {
				x.Picture = nil
				return
			}
			// NOTE: Picture does not seem to implement UnmarshalProtoJSON.
			var v Picture
			golang.UnmarshalMessage(s, &v)
			x.Picture = &v
		case "supports_class_b", "supportsClassB":
			s.AddField("supports_class_b")
			x.SupportsClassB = s.ReadBool()
		case "supports_class_c", "supportsClassC":
			s.AddField("supports_class_c")
			x.SupportsClassC = s.ReadBool()
		case "lorawan_version", "lorawanVersion":
			s.AddField("lorawan_version")
			x.LorawanVersion.UnmarshalProtoJSON(s)
		case "lorawan_phy_version", "lorawanPhyVersion":
			s.AddField("lorawan_phy_version")
			x.LorawanPhyVersion.UnmarshalProtoJSON(s)
		case "frequency_plan_id", "frequencyPlanId":
			s.AddField("frequency_plan_id")
			x.FrequencyPlanId = s.ReadString()
		case "min_frequency", "minFrequency":
			s.AddField("min_frequency")
			x.MinFrequency = s.ReadUint64()
		case "max_frequency", "maxFrequency":
			s.AddField("max_frequency")
			x.MaxFrequency = s.ReadUint64()
		case "supports_join", "supportsJoin":
			s.AddField("supports_join")
			x.SupportsJoin = s.ReadBool()
		case "resets_join_nonces", "resetsJoinNonces":
			s.AddField("resets_join_nonces")
			x.ResetsJoinNonces = s.ReadBool()
		case "root_keys", "rootKeys":
			if s.ReadNil() {
				x.RootKeys = nil
				return
			}
			x.RootKeys = &RootKeys{}
			x.RootKeys.UnmarshalProtoJSON(s.WithField("root_keys", true))
		case "net_id", "netId":
			s.AddField("net_id")
			x.NetId = types.Unmarshal3Bytes(s.WithField("net_id", false))
		case "mac_settings", "macSettings":
			if s.ReadNil() {
				x.MacSettings = nil
				return
			}
			x.MacSettings = &MACSettings{}
			x.MacSettings.UnmarshalProtoJSON(s.WithField("mac_settings", true))
		case "mac_state", "macState":
			if s.ReadNil() {
				x.MacState = nil
				return
			}
			x.MacState = &MACState{}
			x.MacState.UnmarshalProtoJSON(s.WithField("mac_state", true))
		case "pending_mac_state", "pendingMacState":
			if s.ReadNil() {
				x.PendingMacState = nil
				return
			}
			x.PendingMacState = &MACState{}
			x.PendingMacState.UnmarshalProtoJSON(s.WithField("pending_mac_state", true))
		case "session":
			if s.ReadNil() {
				x.Session = nil
				return
			}
			x.Session = &Session{}
			x.Session.UnmarshalProtoJSON(s.WithField("session", true))
		case "pending_session", "pendingSession":
			if s.ReadNil() {
				x.PendingSession = nil
				return
			}
			x.PendingSession = &Session{}
			x.PendingSession.UnmarshalProtoJSON(s.WithField("pending_session", true))
		case "last_dev_nonce", "lastDevNonce":
			s.AddField("last_dev_nonce")
			x.LastDevNonce = s.ReadUint32()
		case "used_dev_nonces", "usedDevNonces":
			s.AddField("used_dev_nonces")
			if s.ReadNil() {
				x.UsedDevNonces = nil
				return
			}
			x.UsedDevNonces = s.ReadUint32Array()
		case "last_join_nonce", "lastJoinNonce":
			s.AddField("last_join_nonce")
			x.LastJoinNonce = s.ReadUint32()
		case "last_rj_count_0", "lastRjCount0":
			s.AddField("last_rj_count_0")
			x.LastRjCount_0 = s.ReadUint32()
		case "last_rj_count_1", "lastRjCount1":
			s.AddField("last_rj_count_1")
			x.LastRjCount_1 = s.ReadUint32()
		case "last_dev_status_received_at", "lastDevStatusReceivedAt":
			s.AddField("last_dev_status_received_at")
			if s.ReadNil() {
				x.LastDevStatusReceivedAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.LastDevStatusReceivedAt = v
		case "power_state", "powerState":
			s.AddField("power_state")
			x.PowerState.UnmarshalProtoJSON(s)
		case "battery_percentage", "batteryPercentage":
			s.AddField("battery_percentage")
			if s.ReadNil() {
				x.BatteryPercentage = nil
				return
			}
			v := s.ReadWrappedFloat32()
			if s.Err() != nil {
				return
			}
			x.BatteryPercentage = &wrapperspb.FloatValue{Value: v}
		case "downlink_margin", "downlinkMargin":
			s.AddField("downlink_margin")
			x.DownlinkMargin = s.ReadInt32()
		case "queued_application_downlinks", "queuedApplicationDownlinks":
			s.AddField("queued_application_downlinks")
			if s.ReadNil() {
				x.QueuedApplicationDownlinks = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.QueuedApplicationDownlinks = append(x.QueuedApplicationDownlinks, nil)
					return
				}
				v := &ApplicationDownlink{}
				v.UnmarshalProtoJSON(s.WithField("queued_application_downlinks", false))
				if s.Err() != nil {
					return
				}
				x.QueuedApplicationDownlinks = append(x.QueuedApplicationDownlinks, v)
			})
		case "formatters":
			if s.ReadNil() {
				x.Formatters = nil
				return
			}
			x.Formatters = &MessagePayloadFormatters{}
			x.Formatters.UnmarshalProtoJSON(s.WithField("formatters", true))
		case "provisioner_id", "provisionerId":
			s.AddField("provisioner_id")
			x.ProvisionerId = s.ReadString()
		case "provisioning_data", "provisioningData":
			s.AddField("provisioning_data")
			if s.ReadNil() {
				x.ProvisioningData = nil
				return
			}
			v := golang.UnmarshalStruct(s)
			if s.Err() != nil {
				return
			}
			x.ProvisioningData = v
		case "multicast":
			s.AddField("multicast")
			x.Multicast = s.ReadBool()
		case "claim_authentication_code", "claimAuthenticationCode":
			s.AddField("claim_authentication_code")
			if s.ReadNil() {
				x.ClaimAuthenticationCode = nil
				return
			}
			// NOTE: EndDeviceAuthenticationCode does not seem to implement UnmarshalProtoJSON.
			var v EndDeviceAuthenticationCode
			golang.UnmarshalMessage(s, &v)
			x.ClaimAuthenticationCode = &v
		case "skip_payload_crypto", "skipPayloadCrypto":
			s.AddField("skip_payload_crypto")
			x.SkipPayloadCrypto = s.ReadBool()
		case "skip_payload_crypto_override", "skipPayloadCryptoOverride":
			s.AddField("skip_payload_crypto_override")
			if s.ReadNil() {
				x.SkipPayloadCryptoOverride = nil
				return
			}
			v := s.ReadWrappedBool()
			if s.Err() != nil {
				return
			}
			x.SkipPayloadCryptoOverride = &wrapperspb.BoolValue{Value: v}
		case "activated_at", "activatedAt":
			s.AddField("activated_at")
			if s.ReadNil() {
				x.ActivatedAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.ActivatedAt = v
		case "last_seen_at", "lastSeenAt":
			s.AddField("last_seen_at")
			if s.ReadNil() {
				x.LastSeenAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.LastSeenAt = v
		case "serial_number", "serialNumber":
			s.AddField("serial_number")
			x.SerialNumber = s.ReadString()
		case "lora_alliance_profile_ids", "loraAllianceProfileIds":
			s.AddField("lora_alliance_profile_ids")
			if s.ReadNil() {
				x.LoraAllianceProfileIds = nil
				return
			}
			// NOTE: LoRaAllianceProfileIdentifiers does not seem to implement UnmarshalProtoJSON.
			var v LoRaAllianceProfileIdentifiers
			golang.UnmarshalMessage(s, &v)
			x.LoraAllianceProfileIds = &v
		}
	})
}

// UnmarshalJSON unmarshals the EndDevice from JSON.
func (x *EndDevice) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the EndDevices message to JSON.
func (x *EndDevices) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.EndDevices) > 0 || s.HasField("end_devices") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("end_devices")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.EndDevices {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("end_devices"))
		}
		s.WriteArrayEnd()
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the EndDevices to JSON.
func (x *EndDevices) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the EndDevices message from JSON.
func (x *EndDevices) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "end_devices", "endDevices":
			s.AddField("end_devices")
			if s.ReadNil() {
				x.EndDevices = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.EndDevices = append(x.EndDevices, nil)
					return
				}
				v := &EndDevice{}
				v.UnmarshalProtoJSON(s.WithField("end_devices", false))
				if s.Err() != nil {
					return
				}
				x.EndDevices = append(x.EndDevices, v)
			})
		}
	})
}

// UnmarshalJSON unmarshals the EndDevices from JSON.
func (x *EndDevices) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the DevAddrPrefix message to JSON.
func (x *DevAddrPrefix) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.DevAddr) > 0 || s.HasField("dev_addr") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("dev_addr")
		types.MarshalHEXBytes(s.WithField("dev_addr"), x.DevAddr)
	}
	if x.Length != 0 || s.HasField("length") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("length")
		s.WriteUint32(x.Length)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the DevAddrPrefix to JSON.
func (x *DevAddrPrefix) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the DevAddrPrefix message from JSON.
func (x *DevAddrPrefix) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "dev_addr", "devAddr":
			s.AddField("dev_addr")
			x.DevAddr = types.Unmarshal4Bytes(s.WithField("dev_addr", false))
		case "length":
			s.AddField("length")
			x.Length = s.ReadUint32()
		}
	})
}

// UnmarshalJSON unmarshals the DevAddrPrefix from JSON.
func (x *DevAddrPrefix) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the CreateEndDeviceRequest message to JSON.
func (x *CreateEndDeviceRequest) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.EndDevice != nil || s.HasField("end_device") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("end_device")
		x.EndDevice.MarshalProtoJSON(s.WithField("end_device"))
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the CreateEndDeviceRequest to JSON.
func (x *CreateEndDeviceRequest) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the CreateEndDeviceRequest message from JSON.
func (x *CreateEndDeviceRequest) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "end_device", "endDevice":
			if s.ReadNil() {
				x.EndDevice = nil
				return
			}
			x.EndDevice = &EndDevice{}
			x.EndDevice.UnmarshalProtoJSON(s.WithField("end_device", true))
		}
	})
}

// UnmarshalJSON unmarshals the CreateEndDeviceRequest from JSON.
func (x *CreateEndDeviceRequest) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the UpdateEndDeviceRequest message to JSON.
func (x *UpdateEndDeviceRequest) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.EndDevice != nil || s.HasField("end_device") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("end_device")
		x.EndDevice.MarshalProtoJSON(s.WithField("end_device"))
	}
	if x.FieldMask != nil || s.HasField("field_mask") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("field_mask")
		if x.FieldMask == nil {
			s.WriteNil()
		} else {
			golang.MarshalLegacyFieldMask(s, x.FieldMask)
		}
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the UpdateEndDeviceRequest to JSON.
func (x *UpdateEndDeviceRequest) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the UpdateEndDeviceRequest message from JSON.
func (x *UpdateEndDeviceRequest) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "end_device", "endDevice":
			if s.ReadNil() {
				x.EndDevice = nil
				return
			}
			x.EndDevice = &EndDevice{}
			x.EndDevice.UnmarshalProtoJSON(s.WithField("end_device", true))
		case "field_mask", "fieldMask":
			s.AddField("field_mask")
			if s.ReadNil() {
				x.FieldMask = nil
				return
			}
			v := golang.UnmarshalFieldMask(s)
			if s.Err() != nil {
				return
			}
			x.FieldMask = v
		}
	})
}

// UnmarshalJSON unmarshals the UpdateEndDeviceRequest from JSON.
func (x *UpdateEndDeviceRequest) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate message to JSON.
func (x *BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.Ids != nil || s.HasField("ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("ids")
		x.Ids.MarshalProtoJSON(s.WithField("ids"))
	}
	if x.LastSeenAt != nil || s.HasField("last_seen_at") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("last_seen_at")
		if x.LastSeenAt == nil {
			s.WriteNil()
		} else {
			golang.MarshalTimestamp(s, x.LastSeenAt)
		}
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate to JSON.
func (x *BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate message from JSON.
func (x *BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "ids":
			if s.ReadNil() {
				x.Ids = nil
				return
			}
			x.Ids = &EndDeviceIdentifiers{}
			x.Ids.UnmarshalProtoJSON(s.WithField("ids", true))
		case "last_seen_at", "lastSeenAt":
			s.AddField("last_seen_at")
			if s.ReadNil() {
				x.LastSeenAt = nil
				return
			}
			v := golang.UnmarshalTimestamp(s)
			if s.Err() != nil {
				return
			}
			x.LastSeenAt = v
		}
	})
}

// UnmarshalJSON unmarshals the BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate from JSON.
func (x *BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the BatchUpdateEndDeviceLastSeenRequest message to JSON.
func (x *BatchUpdateEndDeviceLastSeenRequest) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.Updates) > 0 || s.HasField("updates") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("updates")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.Updates {
			s.WriteMoreIf(&wroteElement)
			element.MarshalProtoJSON(s.WithField("updates"))
		}
		s.WriteArrayEnd()
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the BatchUpdateEndDeviceLastSeenRequest to JSON.
func (x *BatchUpdateEndDeviceLastSeenRequest) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the BatchUpdateEndDeviceLastSeenRequest message from JSON.
func (x *BatchUpdateEndDeviceLastSeenRequest) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "updates":
			s.AddField("updates")
			if s.ReadNil() {
				x.Updates = nil
				return
			}
			s.ReadArray(func() {
				if s.ReadNil() {
					x.Updates = append(x.Updates, nil)
					return
				}
				v := &BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate{}
				v.UnmarshalProtoJSON(s.WithField("updates", false))
				if s.Err() != nil {
					return
				}
				x.Updates = append(x.Updates, v)
			})
		}
	})
}

// UnmarshalJSON unmarshals the BatchUpdateEndDeviceLastSeenRequest from JSON.
func (x *BatchUpdateEndDeviceLastSeenRequest) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the GetEndDeviceRequest message to JSON.
func (x *GetEndDeviceRequest) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.EndDeviceIds != nil || s.HasField("end_device_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("end_device_ids")
		x.EndDeviceIds.MarshalProtoJSON(s.WithField("end_device_ids"))
	}
	if x.FieldMask != nil || s.HasField("field_mask") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("field_mask")
		if x.FieldMask == nil {
			s.WriteNil()
		} else {
			golang.MarshalLegacyFieldMask(s, x.FieldMask)
		}
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the GetEndDeviceRequest to JSON.
func (x *GetEndDeviceRequest) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the GetEndDeviceRequest message from JSON.
func (x *GetEndDeviceRequest) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "end_device_ids", "endDeviceIds":
			if s.ReadNil() {
				x.EndDeviceIds = nil
				return
			}
			x.EndDeviceIds = &EndDeviceIdentifiers{}
			x.EndDeviceIds.UnmarshalProtoJSON(s.WithField("end_device_ids", true))
		case "field_mask", "fieldMask":
			s.AddField("field_mask")
			if s.ReadNil() {
				x.FieldMask = nil
				return
			}
			v := golang.UnmarshalFieldMask(s)
			if s.Err() != nil {
				return
			}
			x.FieldMask = v
		}
	})
}

// UnmarshalJSON unmarshals the GetEndDeviceRequest from JSON.
func (x *GetEndDeviceRequest) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the GetEndDeviceIdentifiersForEUIsRequest message to JSON.
func (x *GetEndDeviceIdentifiersForEUIsRequest) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if len(x.JoinEui) > 0 || s.HasField("join_eui") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("join_eui")
		types.MarshalHEXBytes(s.WithField("join_eui"), x.JoinEui)
	}
	if len(x.DevEui) > 0 || s.HasField("dev_eui") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("dev_eui")
		types.MarshalHEXBytes(s.WithField("dev_eui"), x.DevEui)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the GetEndDeviceIdentifiersForEUIsRequest to JSON.
func (x *GetEndDeviceIdentifiersForEUIsRequest) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the GetEndDeviceIdentifiersForEUIsRequest message from JSON.
func (x *GetEndDeviceIdentifiersForEUIsRequest) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "join_eui", "joinEui":
			s.AddField("join_eui")
			x.JoinEui = types.Unmarshal8Bytes(s.WithField("join_eui", false))
		case "dev_eui", "devEui":
			s.AddField("dev_eui")
			x.DevEui = types.Unmarshal8Bytes(s.WithField("dev_eui", false))
		}
	})
}

// UnmarshalJSON unmarshals the GetEndDeviceIdentifiersForEUIsRequest from JSON.
func (x *GetEndDeviceIdentifiersForEUIsRequest) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ListEndDevicesRequest message to JSON.
func (x *ListEndDevicesRequest) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.ApplicationIds != nil || s.HasField("application_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("application_ids")
		// NOTE: ApplicationIdentifiers does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.ApplicationIds)
	}
	if x.FieldMask != nil || s.HasField("field_mask") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("field_mask")
		if x.FieldMask == nil {
			s.WriteNil()
		} else {
			golang.MarshalLegacyFieldMask(s, x.FieldMask)
		}
	}
	if x.Order != "" || s.HasField("order") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("order")
		s.WriteString(x.Order)
	}
	if x.Limit != 0 || s.HasField("limit") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("limit")
		s.WriteUint32(x.Limit)
	}
	if x.Page != 0 || s.HasField("page") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("page")
		s.WriteUint32(x.Page)
	}
	if len(x.Filters) > 0 || s.HasField("filters") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("filters")
		s.WriteArrayStart()
		var wroteElement bool
		for _, element := range x.Filters {
			s.WriteMoreIf(&wroteElement)
			// NOTE: ListEndDevicesRequest_Filter does not seem to implement MarshalProtoJSON.
			golang.MarshalMessage(s, element)
		}
		s.WriteArrayEnd()
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ListEndDevicesRequest to JSON.
func (x *ListEndDevicesRequest) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ListEndDevicesRequest message from JSON.
func (x *ListEndDevicesRequest) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "application_ids", "applicationIds":
			s.AddField("application_ids")
			if s.ReadNil() {
				x.ApplicationIds = nil
				return
			}
			// NOTE: ApplicationIdentifiers does not seem to implement UnmarshalProtoJSON.
			var v ApplicationIdentifiers
			golang.UnmarshalMessage(s, &v)
			x.ApplicationIds = &v
		case "field_mask", "fieldMask":
			s.AddField("field_mask")
			if s.ReadNil() {
				x.FieldMask = nil
				return
			}
			v := golang.UnmarshalFieldMask(s)
			if s.Err() != nil {
				return
			}
			x.FieldMask = v
		case "order":
			s.AddField("order")
			x.Order = s.ReadString()
		case "limit":
			s.AddField("limit")
			x.Limit = s.ReadUint32()
		case "page":
			s.AddField("page")
			x.Page = s.ReadUint32()
		case "filters":
			s.AddField("filters")
			if s.ReadNil() {
				x.Filters = nil
				return
			}
			s.ReadArray(func() {
				// NOTE: ListEndDevicesRequest_Filter does not seem to implement UnmarshalProtoJSON.
				var v ListEndDevicesRequest_Filter
				golang.UnmarshalMessage(s, &v)
				x.Filters = append(x.Filters, &v)
			})
		}
	})
}

// UnmarshalJSON unmarshals the ListEndDevicesRequest from JSON.
func (x *ListEndDevicesRequest) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the SetEndDeviceRequest message to JSON.
func (x *SetEndDeviceRequest) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.EndDevice != nil || s.HasField("end_device") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("end_device")
		x.EndDevice.MarshalProtoJSON(s.WithField("end_device"))
	}
	if x.FieldMask != nil || s.HasField("field_mask") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("field_mask")
		if x.FieldMask == nil {
			s.WriteNil()
		} else {
			golang.MarshalLegacyFieldMask(s, x.FieldMask)
		}
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the SetEndDeviceRequest to JSON.
func (x *SetEndDeviceRequest) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the SetEndDeviceRequest message from JSON.
func (x *SetEndDeviceRequest) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "end_device", "endDevice":
			if s.ReadNil() {
				x.EndDevice = nil
				return
			}
			x.EndDevice = &EndDevice{}
			x.EndDevice.UnmarshalProtoJSON(s.WithField("end_device", true))
		case "field_mask", "fieldMask":
			s.AddField("field_mask")
			if s.ReadNil() {
				x.FieldMask = nil
				return
			}
			v := golang.UnmarshalFieldMask(s)
			if s.Err() != nil {
				return
			}
			x.FieldMask = v
		}
	})
}

// UnmarshalJSON unmarshals the SetEndDeviceRequest from JSON.
func (x *SetEndDeviceRequest) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the ResetAndGetEndDeviceRequest message to JSON.
func (x *ResetAndGetEndDeviceRequest) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.EndDeviceIds != nil || s.HasField("end_device_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("end_device_ids")
		x.EndDeviceIds.MarshalProtoJSON(s.WithField("end_device_ids"))
	}
	if x.FieldMask != nil || s.HasField("field_mask") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("field_mask")
		if x.FieldMask == nil {
			s.WriteNil()
		} else {
			golang.MarshalLegacyFieldMask(s, x.FieldMask)
		}
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the ResetAndGetEndDeviceRequest to JSON.
func (x *ResetAndGetEndDeviceRequest) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the ResetAndGetEndDeviceRequest message from JSON.
func (x *ResetAndGetEndDeviceRequest) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "end_device_ids", "endDeviceIds":
			if s.ReadNil() {
				x.EndDeviceIds = nil
				return
			}
			x.EndDeviceIds = &EndDeviceIdentifiers{}
			x.EndDeviceIds.UnmarshalProtoJSON(s.WithField("end_device_ids", true))
		case "field_mask", "fieldMask":
			s.AddField("field_mask")
			if s.ReadNil() {
				x.FieldMask = nil
				return
			}
			v := golang.UnmarshalFieldMask(s)
			if s.Err() != nil {
				return
			}
			x.FieldMask = v
		}
	})
}

// UnmarshalJSON unmarshals the ResetAndGetEndDeviceRequest from JSON.
func (x *ResetAndGetEndDeviceRequest) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the EndDeviceTemplate message to JSON.
func (x *EndDeviceTemplate) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.EndDevice != nil || s.HasField("end_device") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("end_device")
		x.EndDevice.MarshalProtoJSON(s.WithField("end_device"))
	}
	if x.FieldMask != nil || s.HasField("field_mask") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("field_mask")
		if x.FieldMask == nil {
			s.WriteNil()
		} else {
			golang.MarshalLegacyFieldMask(s, x.FieldMask)
		}
	}
	if x.MappingKey != "" || s.HasField("mapping_key") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("mapping_key")
		s.WriteString(x.MappingKey)
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the EndDeviceTemplate to JSON.
func (x *EndDeviceTemplate) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the EndDeviceTemplate message from JSON.
func (x *EndDeviceTemplate) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "end_device", "endDevice":
			if s.ReadNil() {
				x.EndDevice = nil
				return
			}
			x.EndDevice = &EndDevice{}
			x.EndDevice.UnmarshalProtoJSON(s.WithField("end_device", true))
		case "field_mask", "fieldMask":
			s.AddField("field_mask")
			if s.ReadNil() {
				x.FieldMask = nil
				return
			}
			v := golang.UnmarshalFieldMask(s)
			if s.Err() != nil {
				return
			}
			x.FieldMask = v
		case "mapping_key", "mappingKey":
			s.AddField("mapping_key")
			x.MappingKey = s.ReadString()
		}
	})
}

// UnmarshalJSON unmarshals the EndDeviceTemplate from JSON.
func (x *EndDeviceTemplate) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}

// MarshalProtoJSON marshals the BatchGetEndDevicesRequest message to JSON.
func (x *BatchGetEndDevicesRequest) MarshalProtoJSON(s *jsonplugin.MarshalState) {
	if x == nil {
		s.WriteNil()
		return
	}
	s.WriteObjectStart()
	var wroteField bool
	if x.ApplicationIds != nil || s.HasField("application_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("application_ids")
		// NOTE: ApplicationIdentifiers does not seem to implement MarshalProtoJSON.
		golang.MarshalMessage(s, x.ApplicationIds)
	}
	if len(x.DeviceIds) > 0 || s.HasField("device_ids") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("device_ids")
		s.WriteStringArray(x.DeviceIds)
	}
	if x.FieldMask != nil || s.HasField("field_mask") {
		s.WriteMoreIf(&wroteField)
		s.WriteObjectField("field_mask")
		if x.FieldMask == nil {
			s.WriteNil()
		} else {
			golang.MarshalLegacyFieldMask(s, x.FieldMask)
		}
	}
	s.WriteObjectEnd()
}

// MarshalJSON marshals the BatchGetEndDevicesRequest to JSON.
func (x *BatchGetEndDevicesRequest) MarshalJSON() ([]byte, error) {
	return jsonplugin.DefaultMarshalerConfig.Marshal(x)
}

// UnmarshalProtoJSON unmarshals the BatchGetEndDevicesRequest message from JSON.
func (x *BatchGetEndDevicesRequest) UnmarshalProtoJSON(s *jsonplugin.UnmarshalState) {
	if s.ReadNil() {
		return
	}
	s.ReadObject(func(key string) {
		switch key {
		default:
			s.ReadAny() // ignore unknown field
		case "application_ids", "applicationIds":
			s.AddField("application_ids")
			if s.ReadNil() {
				x.ApplicationIds = nil
				return
			}
			// NOTE: ApplicationIdentifiers does not seem to implement UnmarshalProtoJSON.
			var v ApplicationIdentifiers
			golang.UnmarshalMessage(s, &v)
			x.ApplicationIds = &v
		case "device_ids", "deviceIds":
			s.AddField("device_ids")
			if s.ReadNil() {
				x.DeviceIds = nil
				return
			}
			x.DeviceIds = s.ReadStringArray()
		case "field_mask", "fieldMask":
			s.AddField("field_mask")
			if s.ReadNil() {
				x.FieldMask = nil
				return
			}
			v := golang.UnmarshalFieldMask(s)
			if s.Err() != nil {
				return
			}
			x.FieldMask = v
		}
	})
}

// UnmarshalJSON unmarshals the BatchGetEndDevicesRequest from JSON.
func (x *BatchGetEndDevicesRequest) UnmarshalJSON(b []byte) error {
	return jsonplugin.DefaultUnmarshalerConfig.Unmarshal(b, x)
}
