// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on Session with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *Session) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SessionFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "dev_addr":

			if len(m.GetDevAddr()) > 0 {

				if len(m.GetDevAddr()) != 4 {
					return SessionValidationError{
						field:  "dev_addr",
						reason: "value length must be 4 bytes",
					}
				}

			}

		case "keys":

			if m.GetKeys() == nil {
				return SessionValidationError{
					field:  "keys",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetKeys()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SessionValidationError{
						field:  "keys",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "last_f_cnt_up":
			// no validation rules for LastFCntUp
		case "last_n_f_cnt_down":
			// no validation rules for LastNFCntDown
		case "last_a_f_cnt_down":
			// no validation rules for LastAFCntDown
		case "last_conf_f_cnt_down":
			// no validation rules for LastConfFCntDown
		case "started_at":

			if v, ok := interface{}(m.GetStartedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SessionValidationError{
						field:  "started_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "queued_application_downlinks":

			for idx, item := range m.GetQueuedApplicationDownlinks() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return SessionValidationError{
							field:  fmt.Sprintf("queued_application_downlinks[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return SessionValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// SessionValidationError is the validation error returned by
// Session.ValidateFields if the designated constraints aren't met.
type SessionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SessionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SessionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SessionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SessionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SessionValidationError) ErrorName() string { return "SessionValidationError" }

// Error satisfies the builtin error interface
func (e SessionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSession.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SessionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SessionValidationError{}

// ValidateFields checks the field values on BoolValue with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *BoolValue) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BoolValueFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "value":
			// no validation rules for Value
		default:
			return BoolValueValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BoolValueValidationError is the validation error returned by
// BoolValue.ValidateFields if the designated constraints aren't met.
type BoolValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BoolValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BoolValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BoolValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BoolValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BoolValueValidationError) ErrorName() string { return "BoolValueValidationError" }

// Error satisfies the builtin error interface
func (e BoolValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBoolValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BoolValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BoolValueValidationError{}

// ValidateFields checks the field values on ServingRelayForwardingLimits with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ServingRelayForwardingLimits) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ServingRelayForwardingLimitsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "reset_behavior":
			// no validation rules for ResetBehavior
		case "join_requests":

			if v, ok := interface{}(m.GetJoinRequests()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ServingRelayForwardingLimitsValidationError{
						field:  "join_requests",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "notifications":

			if v, ok := interface{}(m.GetNotifications()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ServingRelayForwardingLimitsValidationError{
						field:  "notifications",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "uplink_messages":

			if v, ok := interface{}(m.GetUplinkMessages()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ServingRelayForwardingLimitsValidationError{
						field:  "uplink_messages",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "overall":

			if v, ok := interface{}(m.GetOverall()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ServingRelayForwardingLimitsValidationError{
						field:  "overall",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ServingRelayForwardingLimitsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ServingRelayForwardingLimitsValidationError is the validation error returned
// by ServingRelayForwardingLimits.ValidateFields if the designated
// constraints aren't met.
type ServingRelayForwardingLimitsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ServingRelayForwardingLimitsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ServingRelayForwardingLimitsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ServingRelayForwardingLimitsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ServingRelayForwardingLimitsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ServingRelayForwardingLimitsValidationError) ErrorName() string {
	return "ServingRelayForwardingLimitsValidationError"
}

// Error satisfies the builtin error interface
func (e ServingRelayForwardingLimitsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sServingRelayForwardingLimits.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ServingRelayForwardingLimitsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ServingRelayForwardingLimitsValidationError{}

// ValidateFields checks the field values on RelayUplinkForwardingRule with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RelayUplinkForwardingRule) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RelayUplinkForwardingRuleFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "limits":

			if v, ok := interface{}(m.GetLimits()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return RelayUplinkForwardingRuleValidationError{
						field:  "limits",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "last_w_f_cnt":
			// no validation rules for LastWFCnt
		case "device_id":

			if m.GetDeviceId() != "" {

				if utf8.RuneCountInString(m.GetDeviceId()) > 36 {
					return RelayUplinkForwardingRuleValidationError{
						field:  "device_id",
						reason: "value length must be at most 36 runes",
					}
				}

				if !_RelayUplinkForwardingRule_DeviceId_Pattern.MatchString(m.GetDeviceId()) {
					return RelayUplinkForwardingRuleValidationError{
						field:  "device_id",
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

			}

		case "session_key_id":
			// no validation rules for SessionKeyId
		default:
			return RelayUplinkForwardingRuleValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RelayUplinkForwardingRuleValidationError is the validation error returned by
// RelayUplinkForwardingRule.ValidateFields if the designated constraints
// aren't met.
type RelayUplinkForwardingRuleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelayUplinkForwardingRuleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelayUplinkForwardingRuleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelayUplinkForwardingRuleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelayUplinkForwardingRuleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelayUplinkForwardingRuleValidationError) ErrorName() string {
	return "RelayUplinkForwardingRuleValidationError"
}

// Error satisfies the builtin error interface
func (e RelayUplinkForwardingRuleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelayUplinkForwardingRule.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelayUplinkForwardingRuleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelayUplinkForwardingRuleValidationError{}

var _RelayUplinkForwardingRule_DeviceId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on ServingRelayParameters with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ServingRelayParameters) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ServingRelayParametersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "second_channel":

			if v, ok := interface{}(m.GetSecondChannel()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ServingRelayParametersValidationError{
						field:  "second_channel",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "default_channel_index":

			if m.GetDefaultChannelIndex() > 255 {
				return ServingRelayParametersValidationError{
					field:  "default_channel_index",
					reason: "value must be less than or equal to 255",
				}
			}

		case "cad_periodicity":

			if _, ok := RelayCADPeriodicity_name[int32(m.GetCadPeriodicity())]; !ok {
				return ServingRelayParametersValidationError{
					field:  "cad_periodicity",
					reason: "value must be one of the defined enum values",
				}
			}

		case "uplink_forwarding_rules":

			if len(m.GetUplinkForwardingRules()) > 16 {
				return ServingRelayParametersValidationError{
					field:  "uplink_forwarding_rules",
					reason: "value must contain no more than 16 item(s)",
				}
			}

			for idx, item := range m.GetUplinkForwardingRules() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ServingRelayParametersValidationError{
							field:  fmt.Sprintf("uplink_forwarding_rules[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "limits":

			if v, ok := interface{}(m.GetLimits()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ServingRelayParametersValidationError{
						field:  "limits",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ServingRelayParametersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ServingRelayParametersValidationError is the validation error returned by
// ServingRelayParameters.ValidateFields if the designated constraints aren't met.
type ServingRelayParametersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ServingRelayParametersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ServingRelayParametersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ServingRelayParametersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ServingRelayParametersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ServingRelayParametersValidationError) ErrorName() string {
	return "ServingRelayParametersValidationError"
}

// Error satisfies the builtin error interface
func (e ServingRelayParametersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sServingRelayParameters.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ServingRelayParametersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ServingRelayParametersValidationError{}

// ValidateFields checks the field values on ServedRelayParameters with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ServedRelayParameters) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ServedRelayParametersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "backoff":

			if m.GetBackoff() > 63 {
				return ServedRelayParametersValidationError{
					field:  "backoff",
					reason: "value must be less than or equal to 63",
				}
			}

		case "second_channel":

			if v, ok := interface{}(m.GetSecondChannel()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ServedRelayParametersValidationError{
						field:  "second_channel",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "serving_device_id":

			if utf8.RuneCountInString(m.GetServingDeviceId()) > 36 {
				return ServedRelayParametersValidationError{
					field:  "serving_device_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_ServedRelayParameters_ServingDeviceId_Pattern.MatchString(m.GetServingDeviceId()) {
				return ServedRelayParametersValidationError{
					field:  "serving_device_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "mode":
			if m.Mode == nil {
				return ServedRelayParametersValidationError{
					field:  "mode",
					reason: "value is required",
				}
			}
			if len(subs) == 0 {
				subs = []string{
					"always", "dynamic", "end_device_controlled",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "always":
					w, ok := m.Mode.(*ServedRelayParameters_Always)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetAlways()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ServedRelayParametersValidationError{
								field:  "always",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "dynamic":
					w, ok := m.Mode.(*ServedRelayParameters_Dynamic)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDynamic()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ServedRelayParametersValidationError{
								field:  "dynamic",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "end_device_controlled":
					w, ok := m.Mode.(*ServedRelayParameters_EndDeviceControlled)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetEndDeviceControlled()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ServedRelayParametersValidationError{
								field:  "end_device_controlled",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return ServedRelayParametersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ServedRelayParametersValidationError is the validation error returned by
// ServedRelayParameters.ValidateFields if the designated constraints aren't met.
type ServedRelayParametersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ServedRelayParametersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ServedRelayParametersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ServedRelayParametersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ServedRelayParametersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ServedRelayParametersValidationError) ErrorName() string {
	return "ServedRelayParametersValidationError"
}

// Error satisfies the builtin error interface
func (e ServedRelayParametersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sServedRelayParameters.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ServedRelayParametersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ServedRelayParametersValidationError{}

var _ServedRelayParameters_ServingDeviceId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on RelayParameters with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RelayParameters) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RelayParametersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "mode":
			if m.Mode == nil {
				return RelayParametersValidationError{
					field:  "mode",
					reason: "value is required",
				}
			}
			if len(subs) == 0 {
				subs = []string{
					"serving", "served",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "serving":
					w, ok := m.Mode.(*RelayParameters_Serving)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetServing()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return RelayParametersValidationError{
								field:  "serving",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "served":
					w, ok := m.Mode.(*RelayParameters_Served)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetServed()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return RelayParametersValidationError{
								field:  "served",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return RelayParametersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RelayParametersValidationError is the validation error returned by
// RelayParameters.ValidateFields if the designated constraints aren't met.
type RelayParametersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelayParametersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelayParametersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelayParametersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelayParametersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelayParametersValidationError) ErrorName() string { return "RelayParametersValidationError" }

// Error satisfies the builtin error interface
func (e RelayParametersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelayParameters.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelayParametersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelayParametersValidationError{}

// ValidateFields checks the field values on ServingRelaySettings with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ServingRelaySettings) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ServingRelaySettingsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "second_channel":

			if v, ok := interface{}(m.GetSecondChannel()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ServingRelaySettingsValidationError{
						field:  "second_channel",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "default_channel_index":

			if wrapper := m.GetDefaultChannelIndex(); wrapper != nil {

				if wrapper.GetValue() > 255 {
					return ServingRelaySettingsValidationError{
						field:  "default_channel_index",
						reason: "value must be less than or equal to 255",
					}
				}

			}

		case "cad_periodicity":

			if _, ok := RelayCADPeriodicity_name[int32(m.GetCadPeriodicity())]; !ok {
				return ServingRelaySettingsValidationError{
					field:  "cad_periodicity",
					reason: "value must be one of the defined enum values",
				}
			}

		case "uplink_forwarding_rules":

			if len(m.GetUplinkForwardingRules()) > 16 {
				return ServingRelaySettingsValidationError{
					field:  "uplink_forwarding_rules",
					reason: "value must contain no more than 16 item(s)",
				}
			}

			for idx, item := range m.GetUplinkForwardingRules() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ServingRelaySettingsValidationError{
							field:  fmt.Sprintf("uplink_forwarding_rules[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "limits":

			if v, ok := interface{}(m.GetLimits()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ServingRelaySettingsValidationError{
						field:  "limits",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ServingRelaySettingsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ServingRelaySettingsValidationError is the validation error returned by
// ServingRelaySettings.ValidateFields if the designated constraints aren't met.
type ServingRelaySettingsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ServingRelaySettingsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ServingRelaySettingsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ServingRelaySettingsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ServingRelaySettingsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ServingRelaySettingsValidationError) ErrorName() string {
	return "ServingRelaySettingsValidationError"
}

// Error satisfies the builtin error interface
func (e ServingRelaySettingsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sServingRelaySettings.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ServingRelaySettingsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ServingRelaySettingsValidationError{}

// ValidateFields checks the field values on ServedRelaySettings with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ServedRelaySettings) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ServedRelaySettingsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "backoff":

			if wrapper := m.GetBackoff(); wrapper != nil {

				if wrapper.GetValue() > 63 {
					return ServedRelaySettingsValidationError{
						field:  "backoff",
						reason: "value must be less than or equal to 63",
					}
				}

			}

		case "second_channel":

			if v, ok := interface{}(m.GetSecondChannel()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ServedRelaySettingsValidationError{
						field:  "second_channel",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "serving_device_id":

			if utf8.RuneCountInString(m.GetServingDeviceId()) > 36 {
				return ServedRelaySettingsValidationError{
					field:  "serving_device_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_ServedRelaySettings_ServingDeviceId_Pattern.MatchString(m.GetServingDeviceId()) {
				return ServedRelaySettingsValidationError{
					field:  "serving_device_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "mode":
			if m.Mode == nil {
				return ServedRelaySettingsValidationError{
					field:  "mode",
					reason: "value is required",
				}
			}
			if len(subs) == 0 {
				subs = []string{
					"always", "dynamic", "end_device_controlled",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "always":
					w, ok := m.Mode.(*ServedRelaySettings_Always)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetAlways()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ServedRelaySettingsValidationError{
								field:  "always",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "dynamic":
					w, ok := m.Mode.(*ServedRelaySettings_Dynamic)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDynamic()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ServedRelaySettingsValidationError{
								field:  "dynamic",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "end_device_controlled":
					w, ok := m.Mode.(*ServedRelaySettings_EndDeviceControlled)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetEndDeviceControlled()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ServedRelaySettingsValidationError{
								field:  "end_device_controlled",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return ServedRelaySettingsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ServedRelaySettingsValidationError is the validation error returned by
// ServedRelaySettings.ValidateFields if the designated constraints aren't met.
type ServedRelaySettingsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ServedRelaySettingsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ServedRelaySettingsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ServedRelaySettingsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ServedRelaySettingsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ServedRelaySettingsValidationError) ErrorName() string {
	return "ServedRelaySettingsValidationError"
}

// Error satisfies the builtin error interface
func (e ServedRelaySettingsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sServedRelaySettings.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ServedRelaySettingsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ServedRelaySettingsValidationError{}

var _ServedRelaySettings_ServingDeviceId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on RelaySettings with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RelaySettings) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = RelaySettingsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "mode":
			if m.Mode == nil {
				return RelaySettingsValidationError{
					field:  "mode",
					reason: "value is required",
				}
			}
			if len(subs) == 0 {
				subs = []string{
					"serving", "served",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "serving":
					w, ok := m.Mode.(*RelaySettings_Serving)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetServing()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return RelaySettingsValidationError{
								field:  "serving",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "served":
					w, ok := m.Mode.(*RelaySettings_Served)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetServed()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return RelaySettingsValidationError{
								field:  "served",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return RelaySettingsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// RelaySettingsValidationError is the validation error returned by
// RelaySettings.ValidateFields if the designated constraints aren't met.
type RelaySettingsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelaySettingsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelaySettingsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelaySettingsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelaySettingsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelaySettingsValidationError) ErrorName() string { return "RelaySettingsValidationError" }

// Error satisfies the builtin error interface
func (e RelaySettingsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelaySettings.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelaySettingsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelaySettingsValidationError{}

// ValidateFields checks the field values on MACParameters with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACParameters) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACParametersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "max_eirp":
			// no validation rules for MaxEirp
		case "adr_data_rate_index":

			if _, ok := DataRateIndex_name[int32(m.GetAdrDataRateIndex())]; !ok {
				return MACParametersValidationError{
					field:  "adr_data_rate_index",
					reason: "value must be one of the defined enum values",
				}
			}

		case "adr_tx_power_index":

			if m.GetAdrTxPowerIndex() > 15 {
				return MACParametersValidationError{
					field:  "adr_tx_power_index",
					reason: "value must be less than or equal to 15",
				}
			}

		case "adr_nb_trans":

			if m.GetAdrNbTrans() > 15 {
				return MACParametersValidationError{
					field:  "adr_nb_trans",
					reason: "value must be less than or equal to 15",
				}
			}

		case "adr_ack_limit":
			// no validation rules for AdrAckLimit
		case "adr_ack_delay":
			// no validation rules for AdrAckDelay
		case "rx1_delay":

			if _, ok := RxDelay_name[int32(m.GetRx1Delay())]; !ok {
				return MACParametersValidationError{
					field:  "rx1_delay",
					reason: "value must be one of the defined enum values",
				}
			}

		case "rx1_data_rate_offset":

			if _, ok := DataRateOffset_name[int32(m.GetRx1DataRateOffset())]; !ok {
				return MACParametersValidationError{
					field:  "rx1_data_rate_offset",
					reason: "value must be one of the defined enum values",
				}
			}

		case "rx2_data_rate_index":

			if _, ok := DataRateIndex_name[int32(m.GetRx2DataRateIndex())]; !ok {
				return MACParametersValidationError{
					field:  "rx2_data_rate_index",
					reason: "value must be one of the defined enum values",
				}
			}

		case "rx2_frequency":

			if m.GetRx2Frequency() < 100000 {
				return MACParametersValidationError{
					field:  "rx2_frequency",
					reason: "value must be greater than or equal to 100000",
				}
			}

		case "max_duty_cycle":

			if _, ok := AggregatedDutyCycle_name[int32(m.GetMaxDutyCycle())]; !ok {
				return MACParametersValidationError{
					field:  "max_duty_cycle",
					reason: "value must be one of the defined enum values",
				}
			}

		case "rejoin_time_periodicity":

			if _, ok := RejoinTimeExponent_name[int32(m.GetRejoinTimePeriodicity())]; !ok {
				return MACParametersValidationError{
					field:  "rejoin_time_periodicity",
					reason: "value must be one of the defined enum values",
				}
			}

		case "rejoin_count_periodicity":

			if _, ok := RejoinCountExponent_name[int32(m.GetRejoinCountPeriodicity())]; !ok {
				return MACParametersValidationError{
					field:  "rejoin_count_periodicity",
					reason: "value must be one of the defined enum values",
				}
			}

		case "ping_slot_frequency":

			if val := m.GetPingSlotFrequency(); val > 0 && val < 100000 {
				return MACParametersValidationError{
					field:  "ping_slot_frequency",
					reason: "value must be outside range (0, 100000)",
				}
			}

		case "ping_slot_data_rate_index":
			// no validation rules for PingSlotDataRateIndex
		case "beacon_frequency":

			if val := m.GetBeaconFrequency(); val > 0 && val < 100000 {
				return MACParametersValidationError{
					field:  "beacon_frequency",
					reason: "value must be outside range (0, 100000)",
				}
			}

		case "channels":

			if len(m.GetChannels()) < 1 {
				return MACParametersValidationError{
					field:  "channels",
					reason: "value must contain at least 1 item(s)",
				}
			}

			for idx, item := range m.GetChannels() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return MACParametersValidationError{
							field:  fmt.Sprintf("channels[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "uplink_dwell_time":

			if v, ok := interface{}(m.GetUplinkDwellTime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACParametersValidationError{
						field:  "uplink_dwell_time",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_dwell_time":

			if v, ok := interface{}(m.GetDownlinkDwellTime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACParametersValidationError{
						field:  "downlink_dwell_time",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "adr_ack_limit_exponent":

			if v, ok := interface{}(m.GetAdrAckLimitExponent()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACParametersValidationError{
						field:  "adr_ack_limit_exponent",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "adr_ack_delay_exponent":

			if v, ok := interface{}(m.GetAdrAckDelayExponent()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACParametersValidationError{
						field:  "adr_ack_delay_exponent",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "ping_slot_data_rate_index_value":

			if v, ok := interface{}(m.GetPingSlotDataRateIndexValue()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACParametersValidationError{
						field:  "ping_slot_data_rate_index_value",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "relay":

			if v, ok := interface{}(m.GetRelay()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACParametersValidationError{
						field:  "relay",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return MACParametersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACParametersValidationError is the validation error returned by
// MACParameters.ValidateFields if the designated constraints aren't met.
type MACParametersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACParametersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACParametersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACParametersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACParametersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACParametersValidationError) ErrorName() string { return "MACParametersValidationError" }

// Error satisfies the builtin error interface
func (e MACParametersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACParameters.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACParametersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACParametersValidationError{}

// ValidateFields checks the field values on EndDeviceVersion with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *EndDeviceVersion) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceVersionFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return EndDeviceVersionValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceVersionValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "lorawan_version":

			if _, ok := MACVersion_name[int32(m.GetLorawanVersion())]; !ok {
				return EndDeviceVersionValidationError{
					field:  "lorawan_version",
					reason: "value must be one of the defined enum values",
				}
			}

		case "lorawan_phy_version":

			if _, ok := PHYVersion_name[int32(m.GetLorawanPhyVersion())]; !ok {
				return EndDeviceVersionValidationError{
					field:  "lorawan_phy_version",
					reason: "value must be one of the defined enum values",
				}
			}

		case "frequency_plan_id":

			if utf8.RuneCountInString(m.GetFrequencyPlanId()) > 64 {
				return EndDeviceVersionValidationError{
					field:  "frequency_plan_id",
					reason: "value length must be at most 64 runes",
				}
			}

		case "photos":

			if len(m.GetPhotos()) > 10 {
				return EndDeviceVersionValidationError{
					field:  "photos",
					reason: "value must contain no more than 10 item(s)",
				}
			}

		case "supports_class_b":
			// no validation rules for SupportsClassB
		case "supports_class_c":
			// no validation rules for SupportsClassC
		case "default_mac_settings":

			if v, ok := interface{}(m.GetDefaultMacSettings()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceVersionValidationError{
						field:  "default_mac_settings",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "min_frequency":
			// no validation rules for MinFrequency
		case "max_frequency":
			// no validation rules for MaxFrequency
		case "supports_join":
			// no validation rules for SupportsJoin
		case "resets_join_nonces":
			// no validation rules for ResetsJoinNonces
		case "default_formatters":

			if m.GetDefaultFormatters() == nil {
				return EndDeviceVersionValidationError{
					field:  "default_formatters",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetDefaultFormatters()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceVersionValidationError{
						field:  "default_formatters",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return EndDeviceVersionValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceVersionValidationError is the validation error returned by
// EndDeviceVersion.ValidateFields if the designated constraints aren't met.
type EndDeviceVersionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceVersionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceVersionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceVersionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceVersionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceVersionValidationError) ErrorName() string { return "EndDeviceVersionValidationError" }

// Error satisfies the builtin error interface
func (e EndDeviceVersionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceVersion.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceVersionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceVersionValidationError{}

// ValidateFields checks the field values on ADRSettings with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *ADRSettings) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ADRSettingsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "mode":
			if len(subs) == 0 {
				subs = []string{
					"static", "dynamic", "disabled",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "static":
					w, ok := m.Mode.(*ADRSettings_Static)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetStatic()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ADRSettingsValidationError{
								field:  "static",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "dynamic":
					w, ok := m.Mode.(*ADRSettings_Dynamic)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDynamic()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ADRSettingsValidationError{
								field:  "dynamic",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "disabled":
					w, ok := m.Mode.(*ADRSettings_Disabled)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDisabled()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ADRSettingsValidationError{
								field:  "disabled",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return ADRSettingsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ADRSettingsValidationError is the validation error returned by
// ADRSettings.ValidateFields if the designated constraints aren't met.
type ADRSettingsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ADRSettingsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ADRSettingsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ADRSettingsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ADRSettingsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ADRSettingsValidationError) ErrorName() string { return "ADRSettingsValidationError" }

// Error satisfies the builtin error interface
func (e ADRSettingsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sADRSettings.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ADRSettingsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ADRSettingsValidationError{}

// ValidateFields checks the field values on MACSettings with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *MACSettings) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACSettingsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "class_b_timeout":

			if v, ok := interface{}(m.GetClassBTimeout()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "class_b_timeout",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "ping_slot_periodicity":

			if v, ok := interface{}(m.GetPingSlotPeriodicity()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "ping_slot_periodicity",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "ping_slot_data_rate_index":

			if v, ok := interface{}(m.GetPingSlotDataRateIndex()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "ping_slot_data_rate_index",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "ping_slot_frequency":

			if v, ok := interface{}(m.GetPingSlotFrequency()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "ping_slot_frequency",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "beacon_frequency":

			if v, ok := interface{}(m.GetBeaconFrequency()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "beacon_frequency",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "class_c_timeout":

			if v, ok := interface{}(m.GetClassCTimeout()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "class_c_timeout",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "rx1_delay":

			if v, ok := interface{}(m.GetRx1Delay()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "rx1_delay",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "rx1_data_rate_offset":

			if v, ok := interface{}(m.GetRx1DataRateOffset()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "rx1_data_rate_offset",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "rx2_data_rate_index":

			if v, ok := interface{}(m.GetRx2DataRateIndex()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "rx2_data_rate_index",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "rx2_frequency":

			if v, ok := interface{}(m.GetRx2Frequency()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "rx2_frequency",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "factory_preset_frequencies":

			if len(m.GetFactoryPresetFrequencies()) > 96 {
				return MACSettingsValidationError{
					field:  "factory_preset_frequencies",
					reason: "value must contain no more than 96 item(s)",
				}
			}

		case "max_duty_cycle":

			if v, ok := interface{}(m.GetMaxDutyCycle()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "max_duty_cycle",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "supports_32_bit_f_cnt":

			if v, ok := interface{}(m.GetSupports_32BitFCnt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "supports_32_bit_f_cnt",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "use_adr":

			if v, ok := interface{}(m.GetUseAdr()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "use_adr",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "adr_margin":

			if v, ok := interface{}(m.GetAdrMargin()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "adr_margin",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "resets_f_cnt":

			if v, ok := interface{}(m.GetResetsFCnt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "resets_f_cnt",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "status_time_periodicity":

			if v, ok := interface{}(m.GetStatusTimePeriodicity()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "status_time_periodicity",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "status_count_periodicity":

			if v, ok := interface{}(m.GetStatusCountPeriodicity()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "status_count_periodicity",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "desired_rx1_delay":

			if v, ok := interface{}(m.GetDesiredRx1Delay()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "desired_rx1_delay",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "desired_rx1_data_rate_offset":

			if v, ok := interface{}(m.GetDesiredRx1DataRateOffset()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "desired_rx1_data_rate_offset",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "desired_rx2_data_rate_index":

			if v, ok := interface{}(m.GetDesiredRx2DataRateIndex()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "desired_rx2_data_rate_index",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "desired_rx2_frequency":

			if v, ok := interface{}(m.GetDesiredRx2Frequency()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "desired_rx2_frequency",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "desired_max_duty_cycle":

			if v, ok := interface{}(m.GetDesiredMaxDutyCycle()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "desired_max_duty_cycle",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "desired_adr_ack_limit_exponent":

			if v, ok := interface{}(m.GetDesiredAdrAckLimitExponent()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "desired_adr_ack_limit_exponent",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "desired_adr_ack_delay_exponent":

			if v, ok := interface{}(m.GetDesiredAdrAckDelayExponent()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "desired_adr_ack_delay_exponent",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "desired_ping_slot_data_rate_index":

			if v, ok := interface{}(m.GetDesiredPingSlotDataRateIndex()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "desired_ping_slot_data_rate_index",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "desired_ping_slot_frequency":

			if v, ok := interface{}(m.GetDesiredPingSlotFrequency()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "desired_ping_slot_frequency",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "desired_beacon_frequency":

			if v, ok := interface{}(m.GetDesiredBeaconFrequency()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "desired_beacon_frequency",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "desired_max_eirp":

			if v, ok := interface{}(m.GetDesiredMaxEirp()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "desired_max_eirp",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "class_b_c_downlink_interval":

			if v, ok := interface{}(m.GetClassBCDownlinkInterval()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "class_b_c_downlink_interval",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "uplink_dwell_time":

			if v, ok := interface{}(m.GetUplinkDwellTime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "uplink_dwell_time",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_dwell_time":

			if v, ok := interface{}(m.GetDownlinkDwellTime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "downlink_dwell_time",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "adr":

			if v, ok := interface{}(m.GetAdr()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "adr",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "schedule_downlinks":

			if v, ok := interface{}(m.GetScheduleDownlinks()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "schedule_downlinks",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "relay":

			if v, ok := interface{}(m.GetRelay()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "relay",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "desired_relay":

			if v, ok := interface{}(m.GetDesiredRelay()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsValidationError{
						field:  "desired_relay",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return MACSettingsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACSettingsValidationError is the validation error returned by
// MACSettings.ValidateFields if the designated constraints aren't met.
type MACSettingsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACSettingsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACSettingsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACSettingsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACSettingsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACSettingsValidationError) ErrorName() string { return "MACSettingsValidationError" }

// Error satisfies the builtin error interface
func (e MACSettingsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACSettings.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACSettingsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACSettingsValidationError{}

// ValidateFields checks the field values on MACSettingsProfile with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACSettingsProfile) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACSettingsProfileFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return MACSettingsProfileValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsProfileValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "mac_settings":

			if m.GetMacSettings() == nil {
				return MACSettingsProfileValidationError{
					field:  "mac_settings",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetMacSettings()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACSettingsProfileValidationError{
						field:  "mac_settings",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return MACSettingsProfileValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACSettingsProfileValidationError is the validation error returned by
// MACSettingsProfile.ValidateFields if the designated constraints aren't met.
type MACSettingsProfileValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACSettingsProfileValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACSettingsProfileValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACSettingsProfileValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACSettingsProfileValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACSettingsProfileValidationError) ErrorName() string {
	return "MACSettingsProfileValidationError"
}

// Error satisfies the builtin error interface
func (e MACSettingsProfileValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACSettingsProfile.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACSettingsProfileValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACSettingsProfileValidationError{}

// ValidateFields checks the field values on MACState with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *MACState) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACStateFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "current_parameters":

			if m.GetCurrentParameters() == nil {
				return MACStateValidationError{
					field:  "current_parameters",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetCurrentParameters()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACStateValidationError{
						field:  "current_parameters",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "desired_parameters":

			if m.GetDesiredParameters() == nil {
				return MACStateValidationError{
					field:  "desired_parameters",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetDesiredParameters()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACStateValidationError{
						field:  "desired_parameters",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "device_class":

			if _, ok := Class_name[int32(m.GetDeviceClass())]; !ok {
				return MACStateValidationError{
					field:  "device_class",
					reason: "value must be one of the defined enum values",
				}
			}

		case "lorawan_version":

			if _, ok := MACVersion_name[int32(m.GetLorawanVersion())]; !ok {
				return MACStateValidationError{
					field:  "lorawan_version",
					reason: "value must be one of the defined enum values",
				}
			}

		case "last_confirmed_downlink_at":

			if v, ok := interface{}(m.GetLastConfirmedDownlinkAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACStateValidationError{
						field:  "last_confirmed_downlink_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "last_dev_status_f_cnt_up":
			// no validation rules for LastDevStatusFCntUp
		case "ping_slot_periodicity":

			if v, ok := interface{}(m.GetPingSlotPeriodicity()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACStateValidationError{
						field:  "ping_slot_periodicity",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "pending_application_downlink":

			if v, ok := interface{}(m.GetPendingApplicationDownlink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACStateValidationError{
						field:  "pending_application_downlink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "queued_responses":

			for idx, item := range m.GetQueuedResponses() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return MACStateValidationError{
							field:  fmt.Sprintf("queued_responses[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "pending_requests":

			for idx, item := range m.GetPendingRequests() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return MACStateValidationError{
							field:  fmt.Sprintf("pending_requests[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "queued_join_accept":

			if v, ok := interface{}(m.GetQueuedJoinAccept()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACStateValidationError{
						field:  "queued_join_accept",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "pending_join_request":

			if v, ok := interface{}(m.GetPendingJoinRequest()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACStateValidationError{
						field:  "pending_join_request",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "rx_windows_available":
			// no validation rules for RxWindowsAvailable
		case "recent_uplinks":

			for idx, item := range m.GetRecentUplinks() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return MACStateValidationError{
							field:  fmt.Sprintf("recent_uplinks[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "recent_downlinks":

			for idx, item := range m.GetRecentDownlinks() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return MACStateValidationError{
							field:  fmt.Sprintf("recent_downlinks[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "last_network_initiated_downlink_at":

			if v, ok := interface{}(m.GetLastNetworkInitiatedDownlinkAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACStateValidationError{
						field:  "last_network_initiated_downlink_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "rejected_adr_data_rate_indexes":

			if len(m.GetRejectedAdrDataRateIndexes()) > 15 {
				return MACStateValidationError{
					field:  "rejected_adr_data_rate_indexes",
					reason: "value must contain no more than 15 item(s)",
				}
			}

			for idx, item := range m.GetRejectedAdrDataRateIndexes() {
				_, _ = idx, item

				if _, ok := DataRateIndex_name[int32(item)]; !ok {
					return MACStateValidationError{
						field:  fmt.Sprintf("rejected_adr_data_rate_indexes[%v]", idx),
						reason: "value must be one of the defined enum values",
					}
				}

			}

		case "rejected_adr_tx_power_indexes":

			if len(m.GetRejectedAdrTxPowerIndexes()) > 15 {
				return MACStateValidationError{
					field:  "rejected_adr_tx_power_indexes",
					reason: "value must contain no more than 15 item(s)",
				}
			}

			for idx, item := range m.GetRejectedAdrTxPowerIndexes() {
				_, _ = idx, item

				if item > 15 {
					return MACStateValidationError{
						field:  fmt.Sprintf("rejected_adr_tx_power_indexes[%v]", idx),
						reason: "value must be less than or equal to 15",
					}
				}

			}

		case "rejected_frequencies":

			for idx, item := range m.GetRejectedFrequencies() {
				_, _ = idx, item

				if item < 100000 {
					return MACStateValidationError{
						field:  fmt.Sprintf("rejected_frequencies[%v]", idx),
						reason: "value must be greater than or equal to 100000",
					}
				}

			}

		case "last_downlink_at":

			if v, ok := interface{}(m.GetLastDownlinkAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACStateValidationError{
						field:  "last_downlink_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "rejected_data_rate_ranges":

			for key, val := range m.GetRejectedDataRateRanges() {
				_ = val

				// no validation rules for RejectedDataRateRanges[key]

				if v, ok := interface{}(val).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return MACStateValidationError{
							field:  fmt.Sprintf("rejected_data_rate_ranges[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "last_adr_change_f_cnt_up":
			// no validation rules for LastAdrChangeFCntUp
		case "recent_mac_command_identifiers":

		case "pending_relay_downlink":

			if v, ok := interface{}(m.GetPendingRelayDownlink()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACStateValidationError{
						field:  "pending_relay_downlink",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return MACStateValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACStateValidationError is the validation error returned by
// MACState.ValidateFields if the designated constraints aren't met.
type MACStateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACStateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACStateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACStateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACStateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACStateValidationError) ErrorName() string { return "MACStateValidationError" }

// Error satisfies the builtin error interface
func (e MACStateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACState.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACStateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACStateValidationError{}

// ValidateFields checks the field values on EndDeviceAuthenticationCode with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *EndDeviceAuthenticationCode) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceAuthenticationCodeFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "value":

			if !_EndDeviceAuthenticationCode_Value_Pattern.MatchString(m.GetValue()) {
				return EndDeviceAuthenticationCodeValidationError{
					field:  "value",
					reason: "value does not match regex pattern \"^[a-zA-Z0-9]{1,32}$\"",
				}
			}

		case "valid_from":

			if v, ok := interface{}(m.GetValidFrom()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceAuthenticationCodeValidationError{
						field:  "valid_from",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "valid_to":

			if v, ok := interface{}(m.GetValidTo()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceAuthenticationCodeValidationError{
						field:  "valid_to",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return EndDeviceAuthenticationCodeValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceAuthenticationCodeValidationError is the validation error returned
// by EndDeviceAuthenticationCode.ValidateFields if the designated constraints
// aren't met.
type EndDeviceAuthenticationCodeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceAuthenticationCodeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceAuthenticationCodeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceAuthenticationCodeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceAuthenticationCodeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceAuthenticationCodeValidationError) ErrorName() string {
	return "EndDeviceAuthenticationCodeValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceAuthenticationCodeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceAuthenticationCode.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceAuthenticationCodeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceAuthenticationCodeValidationError{}

var _EndDeviceAuthenticationCode_Value_Pattern = regexp.MustCompile("^[a-zA-Z0-9]{1,32}$")

// ValidateFields checks the field values on EndDevice with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *EndDevice) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return EndDeviceValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "created_at":

			if v, ok := interface{}(m.GetCreatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "created_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "name":

			if utf8.RuneCountInString(m.GetName()) > 50 {
				return EndDeviceValidationError{
					field:  "name",
					reason: "value length must be at most 50 runes",
				}
			}

		case "description":

			if utf8.RuneCountInString(m.GetDescription()) > 2000 {
				return EndDeviceValidationError{
					field:  "description",
					reason: "value length must be at most 2000 runes",
				}
			}

		case "attributes":

			if len(m.GetAttributes()) > 10 {
				return EndDeviceValidationError{
					field:  "attributes",
					reason: "value must contain no more than 10 pair(s)",
				}
			}

			for key, val := range m.GetAttributes() {
				_ = val

				if utf8.RuneCountInString(key) > 36 {
					return EndDeviceValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value length must be at most 36 runes",
					}
				}

				if !_EndDevice_Attributes_Pattern.MatchString(key) {
					return EndDeviceValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

				if utf8.RuneCountInString(val) > 200 {
					return EndDeviceValidationError{
						field:  fmt.Sprintf("attributes[%v]", key),
						reason: "value length must be at most 200 runes",
					}
				}

			}

		case "version_ids":

			if v, ok := interface{}(m.GetVersionIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "version_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "service_profile_id":

			if utf8.RuneCountInString(m.GetServiceProfileId()) > 64 {
				return EndDeviceValidationError{
					field:  "service_profile_id",
					reason: "value length must be at most 64 runes",
				}
			}

		case "network_server_address":

			if !_EndDevice_NetworkServerAddress_Pattern.MatchString(m.GetNetworkServerAddress()) {
				return EndDeviceValidationError{
					field:  "network_server_address",
					reason: "value does not match regex pattern \"^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\\\-]*[a-zA-Z0-9])\\\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$\"",
				}
			}

		case "network_server_kek_label":

			if utf8.RuneCountInString(m.GetNetworkServerKekLabel()) > 2048 {
				return EndDeviceValidationError{
					field:  "network_server_kek_label",
					reason: "value length must be at most 2048 runes",
				}
			}

		case "application_server_address":

			if !_EndDevice_ApplicationServerAddress_Pattern.MatchString(m.GetApplicationServerAddress()) {
				return EndDeviceValidationError{
					field:  "application_server_address",
					reason: "value does not match regex pattern \"^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\\\-]*[a-zA-Z0-9])\\\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$\"",
				}
			}

		case "application_server_kek_label":

			if utf8.RuneCountInString(m.GetApplicationServerKekLabel()) > 2048 {
				return EndDeviceValidationError{
					field:  "application_server_kek_label",
					reason: "value length must be at most 2048 runes",
				}
			}

		case "application_server_id":

			if utf8.RuneCountInString(m.GetApplicationServerId()) > 100 {
				return EndDeviceValidationError{
					field:  "application_server_id",
					reason: "value length must be at most 100 runes",
				}
			}

		case "join_server_address":

			if !_EndDevice_JoinServerAddress_Pattern.MatchString(m.GetJoinServerAddress()) {
				return EndDeviceValidationError{
					field:  "join_server_address",
					reason: "value does not match regex pattern \"^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\\\-]*[a-zA-Z0-9])\\\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$\"",
				}
			}

		case "locations":

			for key, val := range m.GetLocations() {
				_ = val

				if utf8.RuneCountInString(key) > 36 {
					return EndDeviceValidationError{
						field:  fmt.Sprintf("locations[%v]", key),
						reason: "value length must be at most 36 runes",
					}
				}

				if !_EndDevice_Locations_Pattern.MatchString(key) {
					return EndDeviceValidationError{
						field:  fmt.Sprintf("locations[%v]", key),
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

				if v, ok := interface{}(val).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return EndDeviceValidationError{
							field:  fmt.Sprintf("locations[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "picture":

			if v, ok := interface{}(m.GetPicture()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "picture",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "supports_class_b":
			// no validation rules for SupportsClassB
		case "supports_class_c":
			// no validation rules for SupportsClassC
		case "lorawan_version":

			if _, ok := MACVersion_name[int32(m.GetLorawanVersion())]; !ok {
				return EndDeviceValidationError{
					field:  "lorawan_version",
					reason: "value must be one of the defined enum values",
				}
			}

		case "lorawan_phy_version":

			if _, ok := PHYVersion_name[int32(m.GetLorawanPhyVersion())]; !ok {
				return EndDeviceValidationError{
					field:  "lorawan_phy_version",
					reason: "value must be one of the defined enum values",
				}
			}

		case "frequency_plan_id":

			if utf8.RuneCountInString(m.GetFrequencyPlanId()) > 64 {
				return EndDeviceValidationError{
					field:  "frequency_plan_id",
					reason: "value length must be at most 64 runes",
				}
			}

		case "min_frequency":
			// no validation rules for MinFrequency
		case "max_frequency":
			// no validation rules for MaxFrequency
		case "supports_join":
			// no validation rules for SupportsJoin
		case "resets_join_nonces":
			// no validation rules for ResetsJoinNonces
		case "root_keys":

			if v, ok := interface{}(m.GetRootKeys()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "root_keys",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "net_id":

			if len(m.GetNetId()) > 0 {

				if len(m.GetNetId()) != 3 {
					return EndDeviceValidationError{
						field:  "net_id",
						reason: "value length must be 3 bytes",
					}
				}

			}

		case "mac_settings":

			if v, ok := interface{}(m.GetMacSettings()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "mac_settings",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "mac_state":

			if v, ok := interface{}(m.GetMacState()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "mac_state",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "pending_mac_state":

			if v, ok := interface{}(m.GetPendingMacState()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "pending_mac_state",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "session":

			if v, ok := interface{}(m.GetSession()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "session",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "pending_session":

			if v, ok := interface{}(m.GetPendingSession()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "pending_session",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "last_dev_nonce":
			// no validation rules for LastDevNonce
		case "used_dev_nonces":

		case "last_join_nonce":
			// no validation rules for LastJoinNonce
		case "last_rj_count_0":
			// no validation rules for LastRjCount_0
		case "last_rj_count_1":
			// no validation rules for LastRjCount_1
		case "last_dev_status_received_at":

			if v, ok := interface{}(m.GetLastDevStatusReceivedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "last_dev_status_received_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "power_state":

			if _, ok := PowerState_name[int32(m.GetPowerState())]; !ok {
				return EndDeviceValidationError{
					field:  "power_state",
					reason: "value must be one of the defined enum values",
				}
			}

		case "battery_percentage":

			if wrapper := m.GetBatteryPercentage(); wrapper != nil {

				if val := wrapper.GetValue(); val < 0 || val > 1 {
					return EndDeviceValidationError{
						field:  "battery_percentage",
						reason: "value must be inside range [0, 1]",
					}
				}

			}

		case "downlink_margin":
			// no validation rules for DownlinkMargin
		case "queued_application_downlinks":

			for idx, item := range m.GetQueuedApplicationDownlinks() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return EndDeviceValidationError{
							field:  fmt.Sprintf("queued_application_downlinks[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "formatters":

			if v, ok := interface{}(m.GetFormatters()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "formatters",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "provisioner_id":

			if utf8.RuneCountInString(m.GetProvisionerId()) > 36 {
				return EndDeviceValidationError{
					field:  "provisioner_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_EndDevice_ProvisionerId_Pattern.MatchString(m.GetProvisionerId()) {
				return EndDeviceValidationError{
					field:  "provisioner_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$|^$\"",
				}
			}

		case "provisioning_data":

			if v, ok := interface{}(m.GetProvisioningData()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "provisioning_data",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "multicast":
			// no validation rules for Multicast
		case "claim_authentication_code":

			if v, ok := interface{}(m.GetClaimAuthenticationCode()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "claim_authentication_code",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "skip_payload_crypto":
			// no validation rules for SkipPayloadCrypto
		case "skip_payload_crypto_override":

			if v, ok := interface{}(m.GetSkipPayloadCryptoOverride()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "skip_payload_crypto_override",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "activated_at":

			if v, ok := interface{}(m.GetActivatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "activated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "last_seen_at":

			if v, ok := interface{}(m.GetLastSeenAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "last_seen_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "serial_number":

			if m.GetSerialNumber() != "" {

				if utf8.RuneCountInString(m.GetSerialNumber()) > 36 {
					return EndDeviceValidationError{
						field:  "serial_number",
						reason: "value length must be at most 36 runes",
					}
				}

				if !_EndDevice_SerialNumber_Pattern.MatchString(m.GetSerialNumber()) {
					return EndDeviceValidationError{
						field:  "serial_number",
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

			}

		case "lora_alliance_profile_ids":

			if v, ok := interface{}(m.GetLoraAllianceProfileIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceValidationError{
						field:  "lora_alliance_profile_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return EndDeviceValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceValidationError is the validation error returned by
// EndDevice.ValidateFields if the designated constraints aren't met.
type EndDeviceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceValidationError) ErrorName() string { return "EndDeviceValidationError" }

// Error satisfies the builtin error interface
func (e EndDeviceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDevice.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceValidationError{}

var _EndDevice_Attributes_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

var _EndDevice_NetworkServerAddress_Pattern = regexp.MustCompile("^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$")

var _EndDevice_ApplicationServerAddress_Pattern = regexp.MustCompile("^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$")

var _EndDevice_JoinServerAddress_Pattern = regexp.MustCompile("^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$")

var _EndDevice_Locations_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

var _EndDevice_ProvisionerId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$|^$")

var _EndDevice_SerialNumber_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on EndDevices with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *EndDevices) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDevicesFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "end_devices":

			for idx, item := range m.GetEndDevices() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return EndDevicesValidationError{
							field:  fmt.Sprintf("end_devices[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return EndDevicesValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDevicesValidationError is the validation error returned by
// EndDevices.ValidateFields if the designated constraints aren't met.
type EndDevicesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDevicesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDevicesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDevicesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDevicesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDevicesValidationError) ErrorName() string { return "EndDevicesValidationError" }

// Error satisfies the builtin error interface
func (e EndDevicesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDevices.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDevicesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDevicesValidationError{}

// ValidateFields checks the field values on DevAddrPrefix with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DevAddrPrefix) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DevAddrPrefixFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "dev_addr":

			if len(m.GetDevAddr()) > 0 {

				if len(m.GetDevAddr()) != 4 {
					return DevAddrPrefixValidationError{
						field:  "dev_addr",
						reason: "value length must be 4 bytes",
					}
				}

			}

		case "length":
			// no validation rules for Length
		default:
			return DevAddrPrefixValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DevAddrPrefixValidationError is the validation error returned by
// DevAddrPrefix.ValidateFields if the designated constraints aren't met.
type DevAddrPrefixValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DevAddrPrefixValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DevAddrPrefixValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DevAddrPrefixValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DevAddrPrefixValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DevAddrPrefixValidationError) ErrorName() string { return "DevAddrPrefixValidationError" }

// Error satisfies the builtin error interface
func (e DevAddrPrefixValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDevAddrPrefix.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DevAddrPrefixValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DevAddrPrefixValidationError{}

// ValidateFields checks the field values on CreateEndDeviceRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *CreateEndDeviceRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CreateEndDeviceRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "end_device":

			if m.GetEndDevice() == nil {
				return CreateEndDeviceRequestValidationError{
					field:  "end_device",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEndDevice()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return CreateEndDeviceRequestValidationError{
						field:  "end_device",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return CreateEndDeviceRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CreateEndDeviceRequestValidationError is the validation error returned by
// CreateEndDeviceRequest.ValidateFields if the designated constraints aren't met.
type CreateEndDeviceRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateEndDeviceRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateEndDeviceRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateEndDeviceRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateEndDeviceRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateEndDeviceRequestValidationError) ErrorName() string {
	return "CreateEndDeviceRequestValidationError"
}

// Error satisfies the builtin error interface
func (e CreateEndDeviceRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateEndDeviceRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateEndDeviceRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateEndDeviceRequestValidationError{}

// ValidateFields checks the field values on UpdateEndDeviceRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UpdateEndDeviceRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = UpdateEndDeviceRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "end_device":

			if m.GetEndDevice() == nil {
				return UpdateEndDeviceRequestValidationError{
					field:  "end_device",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEndDevice()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateEndDeviceRequestValidationError{
						field:  "end_device",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return UpdateEndDeviceRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return UpdateEndDeviceRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// UpdateEndDeviceRequestValidationError is the validation error returned by
// UpdateEndDeviceRequest.ValidateFields if the designated constraints aren't met.
type UpdateEndDeviceRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpdateEndDeviceRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpdateEndDeviceRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpdateEndDeviceRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpdateEndDeviceRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpdateEndDeviceRequestValidationError) ErrorName() string {
	return "UpdateEndDeviceRequestValidationError"
}

// Error satisfies the builtin error interface
func (e UpdateEndDeviceRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpdateEndDeviceRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpdateEndDeviceRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpdateEndDeviceRequestValidationError{}

// ValidateFields checks the field values on
// BatchUpdateEndDeviceLastSeenRequest with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *BatchUpdateEndDeviceLastSeenRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BatchUpdateEndDeviceLastSeenRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "updates":

			for idx, item := range m.GetUpdates() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return BatchUpdateEndDeviceLastSeenRequestValidationError{
							field:  fmt.Sprintf("updates[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return BatchUpdateEndDeviceLastSeenRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BatchUpdateEndDeviceLastSeenRequestValidationError is the validation error
// returned by BatchUpdateEndDeviceLastSeenRequest.ValidateFields if the
// designated constraints aren't met.
type BatchUpdateEndDeviceLastSeenRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BatchUpdateEndDeviceLastSeenRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BatchUpdateEndDeviceLastSeenRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BatchUpdateEndDeviceLastSeenRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BatchUpdateEndDeviceLastSeenRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BatchUpdateEndDeviceLastSeenRequestValidationError) ErrorName() string {
	return "BatchUpdateEndDeviceLastSeenRequestValidationError"
}

// Error satisfies the builtin error interface
func (e BatchUpdateEndDeviceLastSeenRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBatchUpdateEndDeviceLastSeenRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BatchUpdateEndDeviceLastSeenRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BatchUpdateEndDeviceLastSeenRequestValidationError{}

// ValidateFields checks the field values on GetEndDeviceRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetEndDeviceRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetEndDeviceRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "end_device_ids":

			if m.GetEndDeviceIds() == nil {
				return GetEndDeviceRequestValidationError{
					field:  "end_device_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEndDeviceIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetEndDeviceRequestValidationError{
						field:  "end_device_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetEndDeviceRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetEndDeviceRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetEndDeviceRequestValidationError is the validation error returned by
// GetEndDeviceRequest.ValidateFields if the designated constraints aren't met.
type GetEndDeviceRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetEndDeviceRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetEndDeviceRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetEndDeviceRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetEndDeviceRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetEndDeviceRequestValidationError) ErrorName() string {
	return "GetEndDeviceRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetEndDeviceRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetEndDeviceRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetEndDeviceRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetEndDeviceRequestValidationError{}

// ValidateFields checks the field values on
// GetEndDeviceIdentifiersForEUIsRequest with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *GetEndDeviceIdentifiersForEUIsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetEndDeviceIdentifiersForEUIsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "join_eui":

			if len(m.GetJoinEui()) > 0 {

				if len(m.GetJoinEui()) != 8 {
					return GetEndDeviceIdentifiersForEUIsRequestValidationError{
						field:  "join_eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		case "dev_eui":

			if len(m.GetDevEui()) > 0 {

				if len(m.GetDevEui()) != 8 {
					return GetEndDeviceIdentifiersForEUIsRequestValidationError{
						field:  "dev_eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		default:
			return GetEndDeviceIdentifiersForEUIsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetEndDeviceIdentifiersForEUIsRequestValidationError is the validation error
// returned by GetEndDeviceIdentifiersForEUIsRequest.ValidateFields if the
// designated constraints aren't met.
type GetEndDeviceIdentifiersForEUIsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetEndDeviceIdentifiersForEUIsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetEndDeviceIdentifiersForEUIsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetEndDeviceIdentifiersForEUIsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetEndDeviceIdentifiersForEUIsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetEndDeviceIdentifiersForEUIsRequestValidationError) ErrorName() string {
	return "GetEndDeviceIdentifiersForEUIsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetEndDeviceIdentifiersForEUIsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetEndDeviceIdentifiersForEUIsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetEndDeviceIdentifiersForEUIsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetEndDeviceIdentifiersForEUIsRequestValidationError{}

// ValidateFields checks the field values on ListEndDevicesRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ListEndDevicesRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListEndDevicesRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListEndDevicesRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListEndDevicesRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "order":

			if _, ok := _ListEndDevicesRequest_Order_InLookup[m.GetOrder()]; !ok {
				return ListEndDevicesRequestValidationError{
					field:  "order",
					reason: "value must be in list [ device_id -device_id join_eui -join_eui dev_eui -dev_eui name -name description -description created_at -created_at last_seen_at -last_seen_at]",
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListEndDevicesRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "filters":

			for idx, item := range m.GetFilters() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ListEndDevicesRequestValidationError{
							field:  fmt.Sprintf("filters[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ListEndDevicesRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListEndDevicesRequestValidationError is the validation error returned by
// ListEndDevicesRequest.ValidateFields if the designated constraints aren't met.
type ListEndDevicesRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListEndDevicesRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListEndDevicesRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListEndDevicesRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListEndDevicesRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListEndDevicesRequestValidationError) ErrorName() string {
	return "ListEndDevicesRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListEndDevicesRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListEndDevicesRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListEndDevicesRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListEndDevicesRequestValidationError{}

var _ListEndDevicesRequest_Order_InLookup = map[string]struct{}{
	"":              {},
	"device_id":     {},
	"-device_id":    {},
	"join_eui":      {},
	"-join_eui":     {},
	"dev_eui":       {},
	"-dev_eui":      {},
	"name":          {},
	"-name":         {},
	"description":   {},
	"-description":  {},
	"created_at":    {},
	"-created_at":   {},
	"last_seen_at":  {},
	"-last_seen_at": {},
}

// ValidateFields checks the field values on SetEndDeviceRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *SetEndDeviceRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SetEndDeviceRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "end_device":

			if m.GetEndDevice() == nil {
				return SetEndDeviceRequestValidationError{
					field:  "end_device",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEndDevice()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetEndDeviceRequestValidationError{
						field:  "end_device",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetEndDeviceRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return SetEndDeviceRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// SetEndDeviceRequestValidationError is the validation error returned by
// SetEndDeviceRequest.ValidateFields if the designated constraints aren't met.
type SetEndDeviceRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SetEndDeviceRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SetEndDeviceRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SetEndDeviceRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SetEndDeviceRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SetEndDeviceRequestValidationError) ErrorName() string {
	return "SetEndDeviceRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SetEndDeviceRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSetEndDeviceRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SetEndDeviceRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SetEndDeviceRequestValidationError{}

// ValidateFields checks the field values on ResetAndGetEndDeviceRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ResetAndGetEndDeviceRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ResetAndGetEndDeviceRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "end_device_ids":

			if m.GetEndDeviceIds() == nil {
				return ResetAndGetEndDeviceRequestValidationError{
					field:  "end_device_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEndDeviceIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ResetAndGetEndDeviceRequestValidationError{
						field:  "end_device_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ResetAndGetEndDeviceRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ResetAndGetEndDeviceRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ResetAndGetEndDeviceRequestValidationError is the validation error returned
// by ResetAndGetEndDeviceRequest.ValidateFields if the designated constraints
// aren't met.
type ResetAndGetEndDeviceRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ResetAndGetEndDeviceRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ResetAndGetEndDeviceRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ResetAndGetEndDeviceRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ResetAndGetEndDeviceRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ResetAndGetEndDeviceRequestValidationError) ErrorName() string {
	return "ResetAndGetEndDeviceRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ResetAndGetEndDeviceRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sResetAndGetEndDeviceRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ResetAndGetEndDeviceRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ResetAndGetEndDeviceRequestValidationError{}

// ValidateFields checks the field values on EndDeviceTemplate with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *EndDeviceTemplate) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceTemplateFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "end_device":

			if m.GetEndDevice() == nil {
				return EndDeviceTemplateValidationError{
					field:  "end_device",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEndDevice()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceTemplateValidationError{
						field:  "end_device",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceTemplateValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "mapping_key":

			if utf8.RuneCountInString(m.GetMappingKey()) > 100 {
				return EndDeviceTemplateValidationError{
					field:  "mapping_key",
					reason: "value length must be at most 100 runes",
				}
			}

		default:
			return EndDeviceTemplateValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceTemplateValidationError is the validation error returned by
// EndDeviceTemplate.ValidateFields if the designated constraints aren't met.
type EndDeviceTemplateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceTemplateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceTemplateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceTemplateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceTemplateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceTemplateValidationError) ErrorName() string {
	return "EndDeviceTemplateValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceTemplateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceTemplate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceTemplateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceTemplateValidationError{}

// ValidateFields checks the field values on EndDeviceTemplateFormat with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *EndDeviceTemplateFormat) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceTemplateFormatFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "name":

			if utf8.RuneCountInString(m.GetName()) > 100 {
				return EndDeviceTemplateFormatValidationError{
					field:  "name",
					reason: "value length must be at most 100 runes",
				}
			}

		case "description":

			if utf8.RuneCountInString(m.GetDescription()) > 200 {
				return EndDeviceTemplateFormatValidationError{
					field:  "description",
					reason: "value length must be at most 200 runes",
				}
			}

		case "file_extensions":

			if len(m.GetFileExtensions()) > 100 {
				return EndDeviceTemplateFormatValidationError{
					field:  "file_extensions",
					reason: "value must contain no more than 100 item(s)",
				}
			}

			_EndDeviceTemplateFormat_FileExtensions_Unique := make(map[string]struct{}, len(m.GetFileExtensions()))

			for idx, item := range m.GetFileExtensions() {
				_, _ = idx, item

				if _, exists := _EndDeviceTemplateFormat_FileExtensions_Unique[item]; exists {
					return EndDeviceTemplateFormatValidationError{
						field:  fmt.Sprintf("file_extensions[%v]", idx),
						reason: "repeated value must contain unique items",
					}
				} else {
					_EndDeviceTemplateFormat_FileExtensions_Unique[item] = struct{}{}
				}

				if !_EndDeviceTemplateFormat_FileExtensions_Pattern.MatchString(item) {
					return EndDeviceTemplateFormatValidationError{
						field:  fmt.Sprintf("file_extensions[%v]", idx),
						reason: "value does not match regex pattern \"^(?:\\\\.[a-z0-9]{1,16}){1,2}$\"",
					}
				}

			}

		default:
			return EndDeviceTemplateFormatValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceTemplateFormatValidationError is the validation error returned by
// EndDeviceTemplateFormat.ValidateFields if the designated constraints aren't met.
type EndDeviceTemplateFormatValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceTemplateFormatValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceTemplateFormatValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceTemplateFormatValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceTemplateFormatValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceTemplateFormatValidationError) ErrorName() string {
	return "EndDeviceTemplateFormatValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceTemplateFormatValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceTemplateFormat.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceTemplateFormatValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceTemplateFormatValidationError{}

var _EndDeviceTemplateFormat_FileExtensions_Pattern = regexp.MustCompile("^(?:\\.[a-z0-9]{1,16}){1,2}$")

// ValidateFields checks the field values on EndDeviceTemplateFormats with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *EndDeviceTemplateFormats) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceTemplateFormatsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "formats":

			for key, val := range m.GetFormats() {
				_ = val

				if utf8.RuneCountInString(key) > 36 {
					return EndDeviceTemplateFormatsValidationError{
						field:  fmt.Sprintf("formats[%v]", key),
						reason: "value length must be at most 36 runes",
					}
				}

				if !_EndDeviceTemplateFormats_Formats_Pattern.MatchString(key) {
					return EndDeviceTemplateFormatsValidationError{
						field:  fmt.Sprintf("formats[%v]", key),
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

				if v, ok := interface{}(val).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return EndDeviceTemplateFormatsValidationError{
							field:  fmt.Sprintf("formats[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return EndDeviceTemplateFormatsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceTemplateFormatsValidationError is the validation error returned by
// EndDeviceTemplateFormats.ValidateFields if the designated constraints
// aren't met.
type EndDeviceTemplateFormatsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceTemplateFormatsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceTemplateFormatsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceTemplateFormatsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceTemplateFormatsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceTemplateFormatsValidationError) ErrorName() string {
	return "EndDeviceTemplateFormatsValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceTemplateFormatsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceTemplateFormats.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceTemplateFormatsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceTemplateFormatsValidationError{}

var _EndDeviceTemplateFormats_Formats_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on ConvertEndDeviceTemplateRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ConvertEndDeviceTemplateRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ConvertEndDeviceTemplateRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "format_id":

			if utf8.RuneCountInString(m.GetFormatId()) > 36 {
				return ConvertEndDeviceTemplateRequestValidationError{
					field:  "format_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_ConvertEndDeviceTemplateRequest_FormatId_Pattern.MatchString(m.GetFormatId()) {
				return ConvertEndDeviceTemplateRequestValidationError{
					field:  "format_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "data":
			// no validation rules for Data
		case "end_device_version_ids":

			if v, ok := interface{}(m.GetEndDeviceVersionIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ConvertEndDeviceTemplateRequestValidationError{
						field:  "end_device_version_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ConvertEndDeviceTemplateRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ConvertEndDeviceTemplateRequestValidationError is the validation error
// returned by ConvertEndDeviceTemplateRequest.ValidateFields if the
// designated constraints aren't met.
type ConvertEndDeviceTemplateRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ConvertEndDeviceTemplateRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ConvertEndDeviceTemplateRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ConvertEndDeviceTemplateRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ConvertEndDeviceTemplateRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ConvertEndDeviceTemplateRequestValidationError) ErrorName() string {
	return "ConvertEndDeviceTemplateRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ConvertEndDeviceTemplateRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConvertEndDeviceTemplateRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ConvertEndDeviceTemplateRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ConvertEndDeviceTemplateRequestValidationError{}

var _ConvertEndDeviceTemplateRequest_FormatId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on BatchDeleteEndDevicesRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *BatchDeleteEndDevicesRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BatchDeleteEndDevicesRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return BatchDeleteEndDevicesRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BatchDeleteEndDevicesRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "device_ids":

			if l := len(m.GetDeviceIds()); l < 1 || l > 20 {
				return BatchDeleteEndDevicesRequestValidationError{
					field:  "device_ids",
					reason: "value must contain between 1 and 20 items, inclusive",
				}
			}

			for idx, item := range m.GetDeviceIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 36 {
					return BatchDeleteEndDevicesRequestValidationError{
						field:  fmt.Sprintf("device_ids[%v]", idx),
						reason: "value length must be at most 36 runes",
					}
				}

				if !_BatchDeleteEndDevicesRequest_DeviceIds_Pattern.MatchString(item) {
					return BatchDeleteEndDevicesRequestValidationError{
						field:  fmt.Sprintf("device_ids[%v]", idx),
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

			}

		default:
			return BatchDeleteEndDevicesRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BatchDeleteEndDevicesRequestValidationError is the validation error returned
// by BatchDeleteEndDevicesRequest.ValidateFields if the designated
// constraints aren't met.
type BatchDeleteEndDevicesRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BatchDeleteEndDevicesRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BatchDeleteEndDevicesRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BatchDeleteEndDevicesRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BatchDeleteEndDevicesRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BatchDeleteEndDevicesRequestValidationError) ErrorName() string {
	return "BatchDeleteEndDevicesRequestValidationError"
}

// Error satisfies the builtin error interface
func (e BatchDeleteEndDevicesRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBatchDeleteEndDevicesRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BatchDeleteEndDevicesRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BatchDeleteEndDevicesRequestValidationError{}

var _BatchDeleteEndDevicesRequest_DeviceIds_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on BatchGetEndDevicesRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *BatchGetEndDevicesRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BatchGetEndDevicesRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return BatchGetEndDevicesRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BatchGetEndDevicesRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "device_ids":

			if l := len(m.GetDeviceIds()); l < 1 || l > 20 {
				return BatchGetEndDevicesRequestValidationError{
					field:  "device_ids",
					reason: "value must contain between 1 and 20 items, inclusive",
				}
			}

			for idx, item := range m.GetDeviceIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 36 {
					return BatchGetEndDevicesRequestValidationError{
						field:  fmt.Sprintf("device_ids[%v]", idx),
						reason: "value length must be at most 36 runes",
					}
				}

				if !_BatchGetEndDevicesRequest_DeviceIds_Pattern.MatchString(item) {
					return BatchGetEndDevicesRequestValidationError{
						field:  fmt.Sprintf("device_ids[%v]", idx),
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BatchGetEndDevicesRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return BatchGetEndDevicesRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BatchGetEndDevicesRequestValidationError is the validation error returned by
// BatchGetEndDevicesRequest.ValidateFields if the designated constraints
// aren't met.
type BatchGetEndDevicesRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BatchGetEndDevicesRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BatchGetEndDevicesRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BatchGetEndDevicesRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BatchGetEndDevicesRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BatchGetEndDevicesRequestValidationError) ErrorName() string {
	return "BatchGetEndDevicesRequestValidationError"
}

// Error satisfies the builtin error interface
func (e BatchGetEndDevicesRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBatchGetEndDevicesRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BatchGetEndDevicesRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BatchGetEndDevicesRequestValidationError{}

var _BatchGetEndDevicesRequest_DeviceIds_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on MACParameters_Channel with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACParameters_Channel) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACParameters_ChannelFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "uplink_frequency":

			if val := m.GetUplinkFrequency(); val > 0 && val < 100000 {
				return MACParameters_ChannelValidationError{
					field:  "uplink_frequency",
					reason: "value must be outside range (0, 100000)",
				}
			}

		case "downlink_frequency":

			if m.GetDownlinkFrequency() < 100000 {
				return MACParameters_ChannelValidationError{
					field:  "downlink_frequency",
					reason: "value must be greater than or equal to 100000",
				}
			}

		case "min_data_rate_index":

			if _, ok := DataRateIndex_name[int32(m.GetMinDataRateIndex())]; !ok {
				return MACParameters_ChannelValidationError{
					field:  "min_data_rate_index",
					reason: "value must be one of the defined enum values",
				}
			}

		case "max_data_rate_index":

			if _, ok := DataRateIndex_name[int32(m.GetMaxDataRateIndex())]; !ok {
				return MACParameters_ChannelValidationError{
					field:  "max_data_rate_index",
					reason: "value must be one of the defined enum values",
				}
			}

		case "enable_uplink":
			// no validation rules for EnableUplink
		default:
			return MACParameters_ChannelValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACParameters_ChannelValidationError is the validation error returned by
// MACParameters_Channel.ValidateFields if the designated constraints aren't met.
type MACParameters_ChannelValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACParameters_ChannelValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACParameters_ChannelValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACParameters_ChannelValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACParameters_ChannelValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACParameters_ChannelValidationError) ErrorName() string {
	return "MACParameters_ChannelValidationError"
}

// Error satisfies the builtin error interface
func (e MACParameters_ChannelValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACParameters_Channel.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACParameters_ChannelValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACParameters_ChannelValidationError{}

// ValidateFields checks the field values on ADRSettings_StaticMode with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ADRSettings_StaticMode) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ADRSettings_StaticModeFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "data_rate_index":

			if _, ok := DataRateIndex_name[int32(m.GetDataRateIndex())]; !ok {
				return ADRSettings_StaticModeValidationError{
					field:  "data_rate_index",
					reason: "value must be one of the defined enum values",
				}
			}

		case "tx_power_index":

			if m.GetTxPowerIndex() > 15 {
				return ADRSettings_StaticModeValidationError{
					field:  "tx_power_index",
					reason: "value must be less than or equal to 15",
				}
			}

		case "nb_trans":

			if val := m.GetNbTrans(); val < 1 || val > 15 {
				return ADRSettings_StaticModeValidationError{
					field:  "nb_trans",
					reason: "value must be inside range [1, 15]",
				}
			}

		default:
			return ADRSettings_StaticModeValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ADRSettings_StaticModeValidationError is the validation error returned by
// ADRSettings_StaticMode.ValidateFields if the designated constraints aren't met.
type ADRSettings_StaticModeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ADRSettings_StaticModeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ADRSettings_StaticModeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ADRSettings_StaticModeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ADRSettings_StaticModeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ADRSettings_StaticModeValidationError) ErrorName() string {
	return "ADRSettings_StaticModeValidationError"
}

// Error satisfies the builtin error interface
func (e ADRSettings_StaticModeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sADRSettings_StaticMode.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ADRSettings_StaticModeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ADRSettings_StaticModeValidationError{}

// ValidateFields checks the field values on ADRSettings_DynamicMode with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ADRSettings_DynamicMode) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ADRSettings_DynamicModeFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "margin":

			if v, ok := interface{}(m.GetMargin()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicModeValidationError{
						field:  "margin",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "min_data_rate_index":

			if v, ok := interface{}(m.GetMinDataRateIndex()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicModeValidationError{
						field:  "min_data_rate_index",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "max_data_rate_index":

			if v, ok := interface{}(m.GetMaxDataRateIndex()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicModeValidationError{
						field:  "max_data_rate_index",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "min_tx_power_index":

			if wrapper := m.GetMinTxPowerIndex(); wrapper != nil {

				if wrapper.GetValue() > 15 {
					return ADRSettings_DynamicModeValidationError{
						field:  "min_tx_power_index",
						reason: "value must be less than or equal to 15",
					}
				}

			}

		case "max_tx_power_index":

			if wrapper := m.GetMaxTxPowerIndex(); wrapper != nil {

				if wrapper.GetValue() > 15 {
					return ADRSettings_DynamicModeValidationError{
						field:  "max_tx_power_index",
						reason: "value must be less than or equal to 15",
					}
				}

			}

		case "min_nb_trans":

			if wrapper := m.GetMinNbTrans(); wrapper != nil {

				if val := wrapper.GetValue(); val < 1 || val > 3 {
					return ADRSettings_DynamicModeValidationError{
						field:  "min_nb_trans",
						reason: "value must be inside range [1, 3]",
					}
				}

			}

		case "max_nb_trans":

			if wrapper := m.GetMaxNbTrans(); wrapper != nil {

				if val := wrapper.GetValue(); val < 1 || val > 3 {
					return ADRSettings_DynamicModeValidationError{
						field:  "max_nb_trans",
						reason: "value must be inside range [1, 3]",
					}
				}

			}

		case "channel_steering":

			if v, ok := interface{}(m.GetChannelSteering()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicModeValidationError{
						field:  "channel_steering",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "overrides":

			if v, ok := interface{}(m.GetOverrides()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicModeValidationError{
						field:  "overrides",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ADRSettings_DynamicModeValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ADRSettings_DynamicModeValidationError is the validation error returned by
// ADRSettings_DynamicMode.ValidateFields if the designated constraints aren't met.
type ADRSettings_DynamicModeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ADRSettings_DynamicModeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ADRSettings_DynamicModeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ADRSettings_DynamicModeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ADRSettings_DynamicModeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ADRSettings_DynamicModeValidationError) ErrorName() string {
	return "ADRSettings_DynamicModeValidationError"
}

// Error satisfies the builtin error interface
func (e ADRSettings_DynamicModeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sADRSettings_DynamicMode.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ADRSettings_DynamicModeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ADRSettings_DynamicModeValidationError{}

// ValidateFields checks the field values on ADRSettings_DisabledMode with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ADRSettings_DisabledMode) ValidateFields(paths ...string) error {
	if len(paths) > 0 {
		return fmt.Errorf("message ADRSettings_DisabledMode has no fields, but paths %s were specified", paths)
	}
	return nil
}

// ADRSettings_DisabledModeValidationError is the validation error returned by
// ADRSettings_DisabledMode.ValidateFields if the designated constraints
// aren't met.
type ADRSettings_DisabledModeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ADRSettings_DisabledModeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ADRSettings_DisabledModeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ADRSettings_DisabledModeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ADRSettings_DisabledModeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ADRSettings_DisabledModeValidationError) ErrorName() string {
	return "ADRSettings_DisabledModeValidationError"
}

// Error satisfies the builtin error interface
func (e ADRSettings_DisabledModeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sADRSettings_DisabledMode.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ADRSettings_DisabledModeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ADRSettings_DisabledModeValidationError{}

// ValidateFields checks the field values on
// ADRSettings_DynamicMode_ChannelSteeringSettings with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *ADRSettings_DynamicMode_ChannelSteeringSettings) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ADRSettings_DynamicMode_ChannelSteeringSettingsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "mode":
			if len(subs) == 0 {
				subs = []string{
					"lora_narrow", "disabled",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "lora_narrow":
					w, ok := m.Mode.(*ADRSettings_DynamicMode_ChannelSteeringSettings_LoraNarrow)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetLoraNarrow()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ADRSettings_DynamicMode_ChannelSteeringSettingsValidationError{
								field:  "lora_narrow",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "disabled":
					w, ok := m.Mode.(*ADRSettings_DynamicMode_ChannelSteeringSettings_Disabled)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetDisabled()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ADRSettings_DynamicMode_ChannelSteeringSettingsValidationError{
								field:  "disabled",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return ADRSettings_DynamicMode_ChannelSteeringSettingsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ADRSettings_DynamicMode_ChannelSteeringSettingsValidationError is the
// validation error returned by
// ADRSettings_DynamicMode_ChannelSteeringSettings.ValidateFields if the
// designated constraints aren't met.
type ADRSettings_DynamicMode_ChannelSteeringSettingsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ADRSettings_DynamicMode_ChannelSteeringSettingsValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e ADRSettings_DynamicMode_ChannelSteeringSettingsValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e ADRSettings_DynamicMode_ChannelSteeringSettingsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ADRSettings_DynamicMode_ChannelSteeringSettingsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ADRSettings_DynamicMode_ChannelSteeringSettingsValidationError) ErrorName() string {
	return "ADRSettings_DynamicMode_ChannelSteeringSettingsValidationError"
}

// Error satisfies the builtin error interface
func (e ADRSettings_DynamicMode_ChannelSteeringSettingsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sADRSettings_DynamicMode_ChannelSteeringSettings.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ADRSettings_DynamicMode_ChannelSteeringSettingsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ADRSettings_DynamicMode_ChannelSteeringSettingsValidationError{}

// ValidateFields checks the field values on
// ADRSettings_DynamicMode_PerDataRateIndexOverride with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *ADRSettings_DynamicMode_PerDataRateIndexOverride) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ADRSettings_DynamicMode_PerDataRateIndexOverrideFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "min_nb_trans":

			if wrapper := m.GetMinNbTrans(); wrapper != nil {

				if val := wrapper.GetValue(); val < 1 || val > 3 {
					return ADRSettings_DynamicMode_PerDataRateIndexOverrideValidationError{
						field:  "min_nb_trans",
						reason: "value must be inside range [1, 3]",
					}
				}

			}

		case "max_nb_trans":

			if wrapper := m.GetMaxNbTrans(); wrapper != nil {

				if val := wrapper.GetValue(); val < 1 || val > 3 {
					return ADRSettings_DynamicMode_PerDataRateIndexOverrideValidationError{
						field:  "max_nb_trans",
						reason: "value must be inside range [1, 3]",
					}
				}

			}

		default:
			return ADRSettings_DynamicMode_PerDataRateIndexOverrideValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ADRSettings_DynamicMode_PerDataRateIndexOverrideValidationError is the
// validation error returned by
// ADRSettings_DynamicMode_PerDataRateIndexOverride.ValidateFields if the
// designated constraints aren't met.
type ADRSettings_DynamicMode_PerDataRateIndexOverrideValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ADRSettings_DynamicMode_PerDataRateIndexOverrideValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e ADRSettings_DynamicMode_PerDataRateIndexOverrideValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e ADRSettings_DynamicMode_PerDataRateIndexOverrideValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e ADRSettings_DynamicMode_PerDataRateIndexOverrideValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ADRSettings_DynamicMode_PerDataRateIndexOverrideValidationError) ErrorName() string {
	return "ADRSettings_DynamicMode_PerDataRateIndexOverrideValidationError"
}

// Error satisfies the builtin error interface
func (e ADRSettings_DynamicMode_PerDataRateIndexOverrideValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sADRSettings_DynamicMode_PerDataRateIndexOverride.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ADRSettings_DynamicMode_PerDataRateIndexOverrideValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ADRSettings_DynamicMode_PerDataRateIndexOverrideValidationError{}

// ValidateFields checks the field values on ADRSettings_DynamicMode_Overrides
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ADRSettings_DynamicMode_Overrides) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ADRSettings_DynamicMode_OverridesFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "data_rate_0":

			if v, ok := interface{}(m.GetDataRate_0()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_0",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_1":

			if v, ok := interface{}(m.GetDataRate_1()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_1",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_2":

			if v, ok := interface{}(m.GetDataRate_2()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_2",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_3":

			if v, ok := interface{}(m.GetDataRate_3()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_3",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_4":

			if v, ok := interface{}(m.GetDataRate_4()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_4",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_5":

			if v, ok := interface{}(m.GetDataRate_5()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_5",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_6":

			if v, ok := interface{}(m.GetDataRate_6()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_6",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_7":

			if v, ok := interface{}(m.GetDataRate_7()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_7",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_8":

			if v, ok := interface{}(m.GetDataRate_8()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_8",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_9":

			if v, ok := interface{}(m.GetDataRate_9()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_9",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_10":

			if v, ok := interface{}(m.GetDataRate_10()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_10",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_11":

			if v, ok := interface{}(m.GetDataRate_11()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_11",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_12":

			if v, ok := interface{}(m.GetDataRate_12()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_12",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_13":

			if v, ok := interface{}(m.GetDataRate_13()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_13",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_14":

			if v, ok := interface{}(m.GetDataRate_14()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_14",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "data_rate_15":

			if v, ok := interface{}(m.GetDataRate_15()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ADRSettings_DynamicMode_OverridesValidationError{
						field:  "data_rate_15",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ADRSettings_DynamicMode_OverridesValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ADRSettings_DynamicMode_OverridesValidationError is the validation error
// returned by ADRSettings_DynamicMode_Overrides.ValidateFields if the
// designated constraints aren't met.
type ADRSettings_DynamicMode_OverridesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ADRSettings_DynamicMode_OverridesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ADRSettings_DynamicMode_OverridesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ADRSettings_DynamicMode_OverridesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ADRSettings_DynamicMode_OverridesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ADRSettings_DynamicMode_OverridesValidationError) ErrorName() string {
	return "ADRSettings_DynamicMode_OverridesValidationError"
}

// Error satisfies the builtin error interface
func (e ADRSettings_DynamicMode_OverridesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sADRSettings_DynamicMode_Overrides.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ADRSettings_DynamicMode_OverridesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ADRSettings_DynamicMode_OverridesValidationError{}

// ValidateFields checks the field values on
// ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode) ValidateFields(paths ...string) error {
	if len(paths) > 0 {
		return fmt.Errorf("message ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode has no fields, but paths %s were specified", paths)
	}
	return nil
}

// ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowModeValidationError
// is the validation error returned by
// ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode.ValidateFields
// if the designated constraints aren't met.
type ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowModeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowModeValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowModeValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowModeValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowModeValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowModeValidationError) ErrorName() string {
	return "ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowModeValidationError"
}

// Error satisfies the builtin error interface
func (e ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowModeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowModeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowModeValidationError{}

// ValidateFields checks the field values on
// ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode) ValidateFields(paths ...string) error {
	if len(paths) > 0 {
		return fmt.Errorf("message ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode has no fields, but paths %s were specified", paths)
	}
	return nil
}

// ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledModeValidationError
// is the validation error returned by
// ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode.ValidateFields
// if the designated constraints aren't met.
type ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledModeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledModeValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledModeValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledModeValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledModeValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledModeValidationError) ErrorName() string {
	return "ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledModeValidationError"
}

// Error satisfies the builtin error interface
func (e ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledModeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledModeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledModeValidationError{}

// ValidateFields checks the field values on MACState_JoinRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACState_JoinRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACState_JoinRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "downlink_settings":

			if m.GetDownlinkSettings() == nil {
				return MACState_JoinRequestValidationError{
					field:  "downlink_settings",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetDownlinkSettings()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACState_JoinRequestValidationError{
						field:  "downlink_settings",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "rx_delay":

			if _, ok := RxDelay_name[int32(m.GetRxDelay())]; !ok {
				return MACState_JoinRequestValidationError{
					field:  "rx_delay",
					reason: "value must be one of the defined enum values",
				}
			}

		case "cf_list":

			if v, ok := interface{}(m.GetCfList()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACState_JoinRequestValidationError{
						field:  "cf_list",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return MACState_JoinRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACState_JoinRequestValidationError is the validation error returned by
// MACState_JoinRequest.ValidateFields if the designated constraints aren't met.
type MACState_JoinRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACState_JoinRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACState_JoinRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACState_JoinRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACState_JoinRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACState_JoinRequestValidationError) ErrorName() string {
	return "MACState_JoinRequestValidationError"
}

// Error satisfies the builtin error interface
func (e MACState_JoinRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACState_JoinRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACState_JoinRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACState_JoinRequestValidationError{}

// ValidateFields checks the field values on MACState_JoinAccept with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACState_JoinAccept) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACState_JoinAcceptFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "payload":

			if l := len(m.GetPayload()); l < 17 || l > 33 {
				return MACState_JoinAcceptValidationError{
					field:  "payload",
					reason: "value length must be between 17 and 33 bytes, inclusive",
				}
			}

		case "request":

			if m.GetRequest() == nil {
				return MACState_JoinAcceptValidationError{
					field:  "request",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetRequest()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACState_JoinAcceptValidationError{
						field:  "request",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "keys":

			if m.GetKeys() == nil {
				return MACState_JoinAcceptValidationError{
					field:  "keys",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetKeys()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACState_JoinAcceptValidationError{
						field:  "keys",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "correlation_ids":

			for idx, item := range m.GetCorrelationIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 100 {
					return MACState_JoinAcceptValidationError{
						field:  fmt.Sprintf("correlation_ids[%v]", idx),
						reason: "value length must be at most 100 runes",
					}
				}

			}

		case "dev_addr":

			if len(m.GetDevAddr()) > 0 {

				if len(m.GetDevAddr()) != 4 {
					return MACState_JoinAcceptValidationError{
						field:  "dev_addr",
						reason: "value length must be 4 bytes",
					}
				}

			}

		case "net_id":

			if len(m.GetNetId()) > 0 {

				if len(m.GetNetId()) != 3 {
					return MACState_JoinAcceptValidationError{
						field:  "net_id",
						reason: "value length must be 3 bytes",
					}
				}

			}

		default:
			return MACState_JoinAcceptValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACState_JoinAcceptValidationError is the validation error returned by
// MACState_JoinAccept.ValidateFields if the designated constraints aren't met.
type MACState_JoinAcceptValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACState_JoinAcceptValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACState_JoinAcceptValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACState_JoinAcceptValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACState_JoinAcceptValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACState_JoinAcceptValidationError) ErrorName() string {
	return "MACState_JoinAcceptValidationError"
}

// Error satisfies the builtin error interface
func (e MACState_JoinAcceptValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACState_JoinAccept.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACState_JoinAcceptValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACState_JoinAcceptValidationError{}

// ValidateFields checks the field values on MACState_UplinkMessage with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACState_UplinkMessage) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACState_UplinkMessageFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "payload":

			if m.GetPayload() == nil {
				return MACState_UplinkMessageValidationError{
					field:  "payload",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetPayload()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACState_UplinkMessageValidationError{
						field:  "payload",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "settings":

			if m.GetSettings() == nil {
				return MACState_UplinkMessageValidationError{
					field:  "settings",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetSettings()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACState_UplinkMessageValidationError{
						field:  "settings",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "rx_metadata":

			for idx, item := range m.GetRxMetadata() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return MACState_UplinkMessageValidationError{
							field:  fmt.Sprintf("rx_metadata[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "received_at":

			if v, ok := interface{}(m.GetReceivedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACState_UplinkMessageValidationError{
						field:  "received_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "correlation_ids":

			for idx, item := range m.GetCorrelationIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 100 {
					return MACState_UplinkMessageValidationError{
						field:  fmt.Sprintf("correlation_ids[%v]", idx),
						reason: "value length must be at most 100 runes",
					}
				}

			}

		case "device_channel_index":

			if m.GetDeviceChannelIndex() > 255 {
				return MACState_UplinkMessageValidationError{
					field:  "device_channel_index",
					reason: "value must be less than or equal to 255",
				}
			}

		default:
			return MACState_UplinkMessageValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACState_UplinkMessageValidationError is the validation error returned by
// MACState_UplinkMessage.ValidateFields if the designated constraints aren't met.
type MACState_UplinkMessageValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACState_UplinkMessageValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACState_UplinkMessageValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACState_UplinkMessageValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACState_UplinkMessageValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACState_UplinkMessageValidationError) ErrorName() string {
	return "MACState_UplinkMessageValidationError"
}

// Error satisfies the builtin error interface
func (e MACState_UplinkMessageValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACState_UplinkMessage.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACState_UplinkMessageValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACState_UplinkMessageValidationError{}

// ValidateFields checks the field values on MACState_DownlinkMessage with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACState_DownlinkMessage) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACState_DownlinkMessageFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "payload":

			if v, ok := interface{}(m.GetPayload()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACState_DownlinkMessageValidationError{
						field:  "payload",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "correlation_ids":

			for idx, item := range m.GetCorrelationIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 100 {
					return MACState_DownlinkMessageValidationError{
						field:  fmt.Sprintf("correlation_ids[%v]", idx),
						reason: "value length must be at most 100 runes",
					}
				}

			}

		default:
			return MACState_DownlinkMessageValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACState_DownlinkMessageValidationError is the validation error returned by
// MACState_DownlinkMessage.ValidateFields if the designated constraints
// aren't met.
type MACState_DownlinkMessageValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACState_DownlinkMessageValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACState_DownlinkMessageValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACState_DownlinkMessageValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACState_DownlinkMessageValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACState_DownlinkMessageValidationError) ErrorName() string {
	return "MACState_DownlinkMessageValidationError"
}

// Error satisfies the builtin error interface
func (e MACState_DownlinkMessageValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACState_DownlinkMessage.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACState_DownlinkMessageValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACState_DownlinkMessageValidationError{}

// ValidateFields checks the field values on MACState_DataRateRange with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACState_DataRateRange) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACState_DataRateRangeFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "min_data_rate_index":

			if _, ok := DataRateIndex_name[int32(m.GetMinDataRateIndex())]; !ok {
				return MACState_DataRateRangeValidationError{
					field:  "min_data_rate_index",
					reason: "value must be one of the defined enum values",
				}
			}

		case "max_data_rate_index":

			if _, ok := DataRateIndex_name[int32(m.GetMaxDataRateIndex())]; !ok {
				return MACState_DataRateRangeValidationError{
					field:  "max_data_rate_index",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACState_DataRateRangeValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACState_DataRateRangeValidationError is the validation error returned by
// MACState_DataRateRange.ValidateFields if the designated constraints aren't met.
type MACState_DataRateRangeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACState_DataRateRangeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACState_DataRateRangeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACState_DataRateRangeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACState_DataRateRangeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACState_DataRateRangeValidationError) ErrorName() string {
	return "MACState_DataRateRangeValidationError"
}

// Error satisfies the builtin error interface
func (e MACState_DataRateRangeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACState_DataRateRange.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACState_DataRateRangeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACState_DataRateRangeValidationError{}

// ValidateFields checks the field values on MACState_DataRateRanges with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACState_DataRateRanges) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACState_DataRateRangesFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ranges":

			if len(m.GetRanges()) < 1 {
				return MACState_DataRateRangesValidationError{
					field:  "ranges",
					reason: "value must contain at least 1 item(s)",
				}
			}

			for idx, item := range m.GetRanges() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return MACState_DataRateRangesValidationError{
							field:  fmt.Sprintf("ranges[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return MACState_DataRateRangesValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACState_DataRateRangesValidationError is the validation error returned by
// MACState_DataRateRanges.ValidateFields if the designated constraints aren't met.
type MACState_DataRateRangesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACState_DataRateRangesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACState_DataRateRangesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACState_DataRateRangesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACState_DataRateRangesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACState_DataRateRangesValidationError) ErrorName() string {
	return "MACState_DataRateRangesValidationError"
}

// Error satisfies the builtin error interface
func (e MACState_DataRateRangesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACState_DataRateRanges.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACState_DataRateRangesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACState_DataRateRangesValidationError{}

// ValidateFields checks the field values on MACState_UplinkMessage_TxSettings
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *MACState_UplinkMessage_TxSettings) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACState_UplinkMessage_TxSettingsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "data_rate":

			if m.GetDataRate() == nil {
				return MACState_UplinkMessage_TxSettingsValidationError{
					field:  "data_rate",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetDataRate()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACState_UplinkMessage_TxSettingsValidationError{
						field:  "data_rate",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return MACState_UplinkMessage_TxSettingsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACState_UplinkMessage_TxSettingsValidationError is the validation error
// returned by MACState_UplinkMessage_TxSettings.ValidateFields if the
// designated constraints aren't met.
type MACState_UplinkMessage_TxSettingsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACState_UplinkMessage_TxSettingsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACState_UplinkMessage_TxSettingsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACState_UplinkMessage_TxSettingsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACState_UplinkMessage_TxSettingsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACState_UplinkMessage_TxSettingsValidationError) ErrorName() string {
	return "MACState_UplinkMessage_TxSettingsValidationError"
}

// Error satisfies the builtin error interface
func (e MACState_UplinkMessage_TxSettingsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACState_UplinkMessage_TxSettings.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACState_UplinkMessage_TxSettingsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACState_UplinkMessage_TxSettingsValidationError{}

// ValidateFields checks the field values on MACState_UplinkMessage_RxMetadata
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *MACState_UplinkMessage_RxMetadata) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACState_UplinkMessage_RxMetadataFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return MACState_UplinkMessage_RxMetadataValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACState_UplinkMessage_RxMetadataValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "channel_rssi":
			// no validation rules for ChannelRssi
		case "snr":
			// no validation rules for Snr
		case "downlink_path_constraint":

			if _, ok := DownlinkPathConstraint_name[int32(m.GetDownlinkPathConstraint())]; !ok {
				return MACState_UplinkMessage_RxMetadataValidationError{
					field:  "downlink_path_constraint",
					reason: "value must be one of the defined enum values",
				}
			}

		case "uplink_token":
			// no validation rules for UplinkToken
		case "packet_broker":

			if v, ok := interface{}(m.GetPacketBroker()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACState_UplinkMessage_RxMetadataValidationError{
						field:  "packet_broker",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "relay":

			if v, ok := interface{}(m.GetRelay()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACState_UplinkMessage_RxMetadataValidationError{
						field:  "relay",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return MACState_UplinkMessage_RxMetadataValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACState_UplinkMessage_RxMetadataValidationError is the validation error
// returned by MACState_UplinkMessage_RxMetadata.ValidateFields if the
// designated constraints aren't met.
type MACState_UplinkMessage_RxMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACState_UplinkMessage_RxMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACState_UplinkMessage_RxMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACState_UplinkMessage_RxMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACState_UplinkMessage_RxMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACState_UplinkMessage_RxMetadataValidationError) ErrorName() string {
	return "MACState_UplinkMessage_RxMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e MACState_UplinkMessage_RxMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACState_UplinkMessage_RxMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACState_UplinkMessage_RxMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACState_UplinkMessage_RxMetadataValidationError{}

// ValidateFields checks the field values on
// MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata) ValidateFields(paths ...string) error {
	if len(paths) > 0 {
		return fmt.Errorf("message MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata has no fields, but paths %s were specified", paths)
	}
	return nil
}

// MACState_UplinkMessage_RxMetadata_PacketBrokerMetadataValidationError is the
// validation error returned by
// MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata.ValidateFields if
// the designated constraints aren't met.
type MACState_UplinkMessage_RxMetadata_PacketBrokerMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACState_UplinkMessage_RxMetadata_PacketBrokerMetadataValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e MACState_UplinkMessage_RxMetadata_PacketBrokerMetadataValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e MACState_UplinkMessage_RxMetadata_PacketBrokerMetadataValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e MACState_UplinkMessage_RxMetadata_PacketBrokerMetadataValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e MACState_UplinkMessage_RxMetadata_PacketBrokerMetadataValidationError) ErrorName() string {
	return "MACState_UplinkMessage_RxMetadata_PacketBrokerMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e MACState_UplinkMessage_RxMetadata_PacketBrokerMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACState_UplinkMessage_RxMetadata_PacketBrokerMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACState_UplinkMessage_RxMetadata_PacketBrokerMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACState_UplinkMessage_RxMetadata_PacketBrokerMetadataValidationError{}

// ValidateFields checks the field values on
// MACState_UplinkMessage_RxMetadata_RelayMetadata with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *MACState_UplinkMessage_RxMetadata_RelayMetadata) ValidateFields(paths ...string) error {
	if len(paths) > 0 {
		return fmt.Errorf("message MACState_UplinkMessage_RxMetadata_RelayMetadata has no fields, but paths %s were specified", paths)
	}
	return nil
}

// MACState_UplinkMessage_RxMetadata_RelayMetadataValidationError is the
// validation error returned by
// MACState_UplinkMessage_RxMetadata_RelayMetadata.ValidateFields if the
// designated constraints aren't met.
type MACState_UplinkMessage_RxMetadata_RelayMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACState_UplinkMessage_RxMetadata_RelayMetadataValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e MACState_UplinkMessage_RxMetadata_RelayMetadataValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e MACState_UplinkMessage_RxMetadata_RelayMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACState_UplinkMessage_RxMetadata_RelayMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACState_UplinkMessage_RxMetadata_RelayMetadataValidationError) ErrorName() string {
	return "MACState_UplinkMessage_RxMetadata_RelayMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e MACState_UplinkMessage_RxMetadata_RelayMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACState_UplinkMessage_RxMetadata_RelayMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACState_UplinkMessage_RxMetadata_RelayMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACState_UplinkMessage_RxMetadata_RelayMetadataValidationError{}

// ValidateFields checks the field values on MACState_DownlinkMessage_Message
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *MACState_DownlinkMessage_Message) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACState_DownlinkMessage_MessageFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "m_hdr":

			if m.GetMHdr() == nil {
				return MACState_DownlinkMessage_MessageValidationError{
					field:  "m_hdr",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetMHdr()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACState_DownlinkMessage_MessageValidationError{
						field:  "m_hdr",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "mac_payload":

			if v, ok := interface{}(m.GetMacPayload()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MACState_DownlinkMessage_MessageValidationError{
						field:  "mac_payload",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return MACState_DownlinkMessage_MessageValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACState_DownlinkMessage_MessageValidationError is the validation error
// returned by MACState_DownlinkMessage_Message.ValidateFields if the
// designated constraints aren't met.
type MACState_DownlinkMessage_MessageValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACState_DownlinkMessage_MessageValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACState_DownlinkMessage_MessageValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACState_DownlinkMessage_MessageValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACState_DownlinkMessage_MessageValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACState_DownlinkMessage_MessageValidationError) ErrorName() string {
	return "MACState_DownlinkMessage_MessageValidationError"
}

// Error satisfies the builtin error interface
func (e MACState_DownlinkMessage_MessageValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACState_DownlinkMessage_Message.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACState_DownlinkMessage_MessageValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACState_DownlinkMessage_MessageValidationError{}

// ValidateFields checks the field values on
// MACState_DownlinkMessage_Message_MHDR with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *MACState_DownlinkMessage_Message_MHDR) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACState_DownlinkMessage_Message_MHDRFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "m_type":

			if _, ok := MType_name[int32(m.GetMType())]; !ok {
				return MACState_DownlinkMessage_Message_MHDRValidationError{
					field:  "m_type",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return MACState_DownlinkMessage_Message_MHDRValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACState_DownlinkMessage_Message_MHDRValidationError is the validation error
// returned by MACState_DownlinkMessage_Message_MHDR.ValidateFields if the
// designated constraints aren't met.
type MACState_DownlinkMessage_Message_MHDRValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACState_DownlinkMessage_Message_MHDRValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACState_DownlinkMessage_Message_MHDRValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACState_DownlinkMessage_Message_MHDRValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACState_DownlinkMessage_Message_MHDRValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACState_DownlinkMessage_Message_MHDRValidationError) ErrorName() string {
	return "MACState_DownlinkMessage_Message_MHDRValidationError"
}

// Error satisfies the builtin error interface
func (e MACState_DownlinkMessage_Message_MHDRValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACState_DownlinkMessage_Message_MHDR.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACState_DownlinkMessage_Message_MHDRValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACState_DownlinkMessage_Message_MHDRValidationError{}

// ValidateFields checks the field values on
// MACState_DownlinkMessage_Message_MACPayload with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *MACState_DownlinkMessage_Message_MACPayload) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MACState_DownlinkMessage_Message_MACPayloadFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "f_port":

			if m.GetFPort() > 255 {
				return MACState_DownlinkMessage_Message_MACPayloadValidationError{
					field:  "f_port",
					reason: "value must be less than or equal to 255",
				}
			}

		case "full_f_cnt":
			// no validation rules for FullFCnt
		default:
			return MACState_DownlinkMessage_Message_MACPayloadValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MACState_DownlinkMessage_Message_MACPayloadValidationError is the validation
// error returned by
// MACState_DownlinkMessage_Message_MACPayload.ValidateFields if the
// designated constraints aren't met.
type MACState_DownlinkMessage_Message_MACPayloadValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MACState_DownlinkMessage_Message_MACPayloadValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MACState_DownlinkMessage_Message_MACPayloadValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MACState_DownlinkMessage_Message_MACPayloadValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MACState_DownlinkMessage_Message_MACPayloadValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MACState_DownlinkMessage_Message_MACPayloadValidationError) ErrorName() string {
	return "MACState_DownlinkMessage_Message_MACPayloadValidationError"
}

// Error satisfies the builtin error interface
func (e MACState_DownlinkMessage_Message_MACPayloadValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMACState_DownlinkMessage_Message_MACPayload.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MACState_DownlinkMessage_Message_MACPayloadValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MACState_DownlinkMessage_Message_MACPayloadValidationError{}

// ValidateFields checks the field values on
// BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "last_seen_at":

			if v, ok := interface{}(m.GetLastSeenAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError{
						field:  "last_seen_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError
// is the validation error returned by
// BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate.ValidateFields
// if the designated constraints aren't met.
type BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError) ErrorName() string {
	return "BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError"
}

// Error satisfies the builtin error interface
func (e BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdateValidationError{}

// ValidateFields checks the field values on ListEndDevicesRequest_Filter with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ListEndDevicesRequest_Filter) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListEndDevicesRequest_FilterFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "field":
			if len(subs) == 0 {
				subs = []string{
					"updated_since",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "updated_since":
					w, ok := m.Field.(*ListEndDevicesRequest_Filter_UpdatedSince)
					if !ok || w == nil {
						continue
					}

					if t := m.GetUpdatedSince(); t != nil {
						ts, err := t.AsTime(), t.CheckValid()
						if err != nil {
							return ListEndDevicesRequest_FilterValidationError{
								field:  "updated_since",
								reason: "value is not a valid timestamp",
								cause:  err,
							}
						}

						now := time.Now()

						if ts.Sub(now) >= 0 {
							return ListEndDevicesRequest_FilterValidationError{
								field:  "updated_since",
								reason: "value must be less than now",
							}
						}

					}

				}
			}
		default:
			return ListEndDevicesRequest_FilterValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListEndDevicesRequest_FilterValidationError is the validation error returned
// by ListEndDevicesRequest_Filter.ValidateFields if the designated
// constraints aren't met.
type ListEndDevicesRequest_FilterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListEndDevicesRequest_FilterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListEndDevicesRequest_FilterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListEndDevicesRequest_FilterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListEndDevicesRequest_FilterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListEndDevicesRequest_FilterValidationError) ErrorName() string {
	return "ListEndDevicesRequest_FilterValidationError"
}

// Error satisfies the builtin error interface
func (e ListEndDevicesRequest_FilterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListEndDevicesRequest_Filter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListEndDevicesRequest_FilterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListEndDevicesRequest_FilterValidationError{}
