// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/end_device.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Power state of the device.
type PowerState int32

const (
	PowerState_POWER_UNKNOWN  PowerState = 0
	PowerState_POWER_BATTERY  PowerState = 1
	PowerState_POWER_EXTERNAL PowerState = 2
)

// Enum value maps for PowerState.
var (
	PowerState_name = map[int32]string{
		0: "POWER_UNKNOWN",
		1: "POWER_BATTERY",
		2: "POWER_EXTERNAL",
	}
	PowerState_value = map[string]int32{
		"POWER_UNKNOWN":  0,
		"POWER_BATTERY":  1,
		"POWER_EXTERNAL": 2,
	}
)

func (x PowerState) Enum() *PowerState {
	p := new(PowerState)
	*p = x
	return p
}

func (x PowerState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PowerState) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_end_device_proto_enumTypes[0].Descriptor()
}

func (PowerState) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_end_device_proto_enumTypes[0]
}

func (x PowerState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PowerState.Descriptor instead.
func (PowerState) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{0}
}

type Session struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device Address, issued by the Network Server or chosen by device manufacturer in case of testing range (beginning with 00-03).
	// Known by Network Server, Application Server and Join Server. Owned by Network Server.
	DevAddr []byte       `protobuf:"bytes,2,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	Keys    *SessionKeys `protobuf:"bytes,3,opt,name=keys,proto3" json:"keys,omitempty"`
	// Last uplink frame counter value used. Network Server only. Application Server assumes the Network Server checked it.
	LastFCntUp uint32 `protobuf:"varint,4,opt,name=last_f_cnt_up,json=lastFCntUp,proto3" json:"last_f_cnt_up,omitempty"`
	// Last network downlink frame counter value used. Network Server only.
	LastNFCntDown uint32 `protobuf:"varint,5,opt,name=last_n_f_cnt_down,json=lastNFCntDown,proto3" json:"last_n_f_cnt_down,omitempty"`
	// Last application downlink frame counter value used. Application Server only.
	LastAFCntDown uint32 `protobuf:"varint,6,opt,name=last_a_f_cnt_down,json=lastAFCntDown,proto3" json:"last_a_f_cnt_down,omitempty"`
	// Frame counter of the last confirmed downlink message sent. Network Server only.
	LastConfFCntDown uint32 `protobuf:"varint,7,opt,name=last_conf_f_cnt_down,json=lastConfFCntDown,proto3" json:"last_conf_f_cnt_down,omitempty"`
	// Time when the session started. Network Server only.
	StartedAt *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	// Queued Application downlink messages. Stored in Application Server and Network Server.
	QueuedApplicationDownlinks []*ApplicationDownlink `protobuf:"bytes,9,rep,name=queued_application_downlinks,json=queuedApplicationDownlinks,proto3" json:"queued_application_downlinks,omitempty"`
}

func (x *Session) Reset() {
	*x = Session{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Session) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Session) ProtoMessage() {}

func (x *Session) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Session.ProtoReflect.Descriptor instead.
func (*Session) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{0}
}

func (x *Session) GetDevAddr() []byte {
	if x != nil {
		return x.DevAddr
	}
	return nil
}

func (x *Session) GetKeys() *SessionKeys {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *Session) GetLastFCntUp() uint32 {
	if x != nil {
		return x.LastFCntUp
	}
	return 0
}

func (x *Session) GetLastNFCntDown() uint32 {
	if x != nil {
		return x.LastNFCntDown
	}
	return 0
}

func (x *Session) GetLastAFCntDown() uint32 {
	if x != nil {
		return x.LastAFCntDown
	}
	return 0
}

func (x *Session) GetLastConfFCntDown() uint32 {
	if x != nil {
		return x.LastConfFCntDown
	}
	return 0
}

func (x *Session) GetStartedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.StartedAt
	}
	return nil
}

func (x *Session) GetQueuedApplicationDownlinks() []*ApplicationDownlink {
	if x != nil {
		return x.QueuedApplicationDownlinks
	}
	return nil
}

type BoolValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value bool `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *BoolValue) Reset() {
	*x = BoolValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoolValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoolValue) ProtoMessage() {}

func (x *BoolValue) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoolValue.ProtoReflect.Descriptor instead.
func (*BoolValue) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{1}
}

func (x *BoolValue) GetValue() bool {
	if x != nil {
		return x.Value
	}
	return false
}

type ServingRelayForwardingLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reset behavior of the buckets upon limit update.
	ResetBehavior RelayResetLimitCounter `protobuf:"varint,1,opt,name=reset_behavior,json=resetBehavior,proto3,enum=ttn.lorawan.v3.RelayResetLimitCounter" json:"reset_behavior,omitempty"`
	// Bucket configuration for join requests.
	// If unset, no individual limits will apply to join requests, but the relay overall limitations will apply.
	JoinRequests *RelayForwardLimits `protobuf:"bytes,2,opt,name=join_requests,json=joinRequests,proto3" json:"join_requests,omitempty"`
	// Bucket configuration for unknown device notifications.
	// If unset, no individual limits will apply to unknown end device notifications, but the relay overall
	// limitations will still apply.
	Notifications *RelayForwardLimits `protobuf:"bytes,3,opt,name=notifications,proto3" json:"notifications,omitempty"`
	// Bucket configuration for uplink messages across all served end devices.
	// If unset, no individual limits will apply to uplink messages across all served end devices, but the relay
	// overall limitations will still apply.
	UplinkMessages *RelayForwardLimits `protobuf:"bytes,4,opt,name=uplink_messages,json=uplinkMessages,proto3" json:"uplink_messages,omitempty"`
	// Bucket configuration for all relay messages.
	// If unset, no overall limits will apply to the relay, but individual limitations will still apply.
	Overall *RelayForwardLimits `protobuf:"bytes,5,opt,name=overall,proto3" json:"overall,omitempty"`
}

func (x *ServingRelayForwardingLimits) Reset() {
	*x = ServingRelayForwardingLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServingRelayForwardingLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServingRelayForwardingLimits) ProtoMessage() {}

func (x *ServingRelayForwardingLimits) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServingRelayForwardingLimits.ProtoReflect.Descriptor instead.
func (*ServingRelayForwardingLimits) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{2}
}

func (x *ServingRelayForwardingLimits) GetResetBehavior() RelayResetLimitCounter {
	if x != nil {
		return x.ResetBehavior
	}
	return RelayResetLimitCounter_RELAY_RESET_LIMIT_COUNTER_ZERO
}

func (x *ServingRelayForwardingLimits) GetJoinRequests() *RelayForwardLimits {
	if x != nil {
		return x.JoinRequests
	}
	return nil
}

func (x *ServingRelayForwardingLimits) GetNotifications() *RelayForwardLimits {
	if x != nil {
		return x.Notifications
	}
	return nil
}

func (x *ServingRelayForwardingLimits) GetUplinkMessages() *RelayForwardLimits {
	if x != nil {
		return x.UplinkMessages
	}
	return nil
}

func (x *ServingRelayForwardingLimits) GetOverall() *RelayForwardLimits {
	if x != nil {
		return x.Overall
	}
	return nil
}

type RelayUplinkForwardingRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bucket configuration for the served end device.
	// If unset, no individual limits will apply to the end device, but the relay global limitations will apply.
	Limits *RelayUplinkForwardLimits `protobuf:"bytes,1,opt,name=limits,proto3" json:"limits,omitempty"`
	// Last wake on radio frame counter used by the served end device.
	LastWFCnt uint32 `protobuf:"varint,2,opt,name=last_w_f_cnt,json=lastWFCnt,proto3" json:"last_w_f_cnt,omitempty"`
	// End device identifier of the served end device.
	DeviceId string `protobuf:"bytes,3,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// Session key ID of the session keys used to derive the root relay session key.
	SessionKeyId []byte `protobuf:"bytes,4,opt,name=session_key_id,json=sessionKeyId,proto3" json:"session_key_id,omitempty"`
}

func (x *RelayUplinkForwardingRule) Reset() {
	*x = RelayUplinkForwardingRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelayUplinkForwardingRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelayUplinkForwardingRule) ProtoMessage() {}

func (x *RelayUplinkForwardingRule) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelayUplinkForwardingRule.ProtoReflect.Descriptor instead.
func (*RelayUplinkForwardingRule) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{3}
}

func (x *RelayUplinkForwardingRule) GetLimits() *RelayUplinkForwardLimits {
	if x != nil {
		return x.Limits
	}
	return nil
}

func (x *RelayUplinkForwardingRule) GetLastWFCnt() uint32 {
	if x != nil {
		return x.LastWFCnt
	}
	return 0
}

func (x *RelayUplinkForwardingRule) GetDeviceId() string {
	if x != nil {
		return x.DeviceId
	}
	return ""
}

func (x *RelayUplinkForwardingRule) GetSessionKeyId() []byte {
	if x != nil {
		return x.SessionKeyId
	}
	return nil
}

type ServingRelayParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Second wake on radio channel configuration.
	SecondChannel *RelaySecondChannel `protobuf:"bytes,1,opt,name=second_channel,json=secondChannel,proto3" json:"second_channel,omitempty"`
	// Index of the default wake on radio channel.
	DefaultChannelIndex uint32 `protobuf:"varint,2,opt,name=default_channel_index,json=defaultChannelIndex,proto3" json:"default_channel_index,omitempty"`
	// Channel activity detection periodicity.
	CadPeriodicity RelayCADPeriodicity `protobuf:"varint,3,opt,name=cad_periodicity,json=cadPeriodicity,proto3,enum=ttn.lorawan.v3.RelayCADPeriodicity" json:"cad_periodicity,omitempty"`
	// Configured uplink forwarding rules.
	UplinkForwardingRules []*RelayUplinkForwardingRule `protobuf:"bytes,4,rep,name=uplink_forwarding_rules,json=uplinkForwardingRules,proto3" json:"uplink_forwarding_rules,omitempty"`
	// Configured forwarding limits.
	// If unset, the default value from Network Server configuration will be used.
	Limits *ServingRelayForwardingLimits `protobuf:"bytes,5,opt,name=limits,proto3" json:"limits,omitempty"`
}

func (x *ServingRelayParameters) Reset() {
	*x = ServingRelayParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServingRelayParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServingRelayParameters) ProtoMessage() {}

func (x *ServingRelayParameters) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServingRelayParameters.ProtoReflect.Descriptor instead.
func (*ServingRelayParameters) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{4}
}

func (x *ServingRelayParameters) GetSecondChannel() *RelaySecondChannel {
	if x != nil {
		return x.SecondChannel
	}
	return nil
}

func (x *ServingRelayParameters) GetDefaultChannelIndex() uint32 {
	if x != nil {
		return x.DefaultChannelIndex
	}
	return 0
}

func (x *ServingRelayParameters) GetCadPeriodicity() RelayCADPeriodicity {
	if x != nil {
		return x.CadPeriodicity
	}
	return RelayCADPeriodicity_RELAY_CAD_PERIODICITY_1_SECOND
}

func (x *ServingRelayParameters) GetUplinkForwardingRules() []*RelayUplinkForwardingRule {
	if x != nil {
		return x.UplinkForwardingRules
	}
	return nil
}

func (x *ServingRelayParameters) GetLimits() *ServingRelayForwardingLimits {
	if x != nil {
		return x.Limits
	}
	return nil
}

type ServedRelayParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Mode:
	//	*ServedRelayParameters_Always
	//	*ServedRelayParameters_Dynamic
	//	*ServedRelayParameters_EndDeviceControlled
	Mode isServedRelayParameters_Mode `protobuf_oneof:"mode"`
	// Number of wake on radio frames to be sent without an acknowledgement before sending the uplink message directly.
	Backoff uint32 `protobuf:"varint,4,opt,name=backoff,proto3" json:"backoff,omitempty"`
	// Second wake on radio channel configuration.
	SecondChannel *RelaySecondChannel `protobuf:"bytes,5,opt,name=second_channel,json=secondChannel,proto3" json:"second_channel,omitempty"`
	// End device identifier of the serving end device.
	ServingDeviceId string `protobuf:"bytes,6,opt,name=serving_device_id,json=servingDeviceId,proto3" json:"serving_device_id,omitempty"`
}

func (x *ServedRelayParameters) Reset() {
	*x = ServedRelayParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServedRelayParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServedRelayParameters) ProtoMessage() {}

func (x *ServedRelayParameters) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServedRelayParameters.ProtoReflect.Descriptor instead.
func (*ServedRelayParameters) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{5}
}

func (m *ServedRelayParameters) GetMode() isServedRelayParameters_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (x *ServedRelayParameters) GetAlways() *RelayEndDeviceAlwaysMode {
	if x, ok := x.GetMode().(*ServedRelayParameters_Always); ok {
		return x.Always
	}
	return nil
}

func (x *ServedRelayParameters) GetDynamic() *RelayEndDeviceDynamicMode {
	if x, ok := x.GetMode().(*ServedRelayParameters_Dynamic); ok {
		return x.Dynamic
	}
	return nil
}

func (x *ServedRelayParameters) GetEndDeviceControlled() *RelayEndDeviceControlledMode {
	if x, ok := x.GetMode().(*ServedRelayParameters_EndDeviceControlled); ok {
		return x.EndDeviceControlled
	}
	return nil
}

func (x *ServedRelayParameters) GetBackoff() uint32 {
	if x != nil {
		return x.Backoff
	}
	return 0
}

func (x *ServedRelayParameters) GetSecondChannel() *RelaySecondChannel {
	if x != nil {
		return x.SecondChannel
	}
	return nil
}

func (x *ServedRelayParameters) GetServingDeviceId() string {
	if x != nil {
		return x.ServingDeviceId
	}
	return ""
}

type isServedRelayParameters_Mode interface {
	isServedRelayParameters_Mode()
}

type ServedRelayParameters_Always struct {
	// The end device will always attempt to use the relay mode in order to send uplink messages.
	Always *RelayEndDeviceAlwaysMode `protobuf:"bytes,1,opt,name=always,proto3,oneof"`
}

type ServedRelayParameters_Dynamic struct {
	// The end device will attempt to use relay mode only after a number of uplink messages have been sent without
	// receiving a valid a downlink message.
	Dynamic *RelayEndDeviceDynamicMode `protobuf:"bytes,2,opt,name=dynamic,proto3,oneof"`
}

type ServedRelayParameters_EndDeviceControlled struct {
	// The end device will control when it uses the relay mode. This is the default mode.
	EndDeviceControlled *RelayEndDeviceControlledMode `protobuf:"bytes,3,opt,name=end_device_controlled,json=endDeviceControlled,proto3,oneof"`
}

func (*ServedRelayParameters_Always) isServedRelayParameters_Mode() {}

func (*ServedRelayParameters_Dynamic) isServedRelayParameters_Mode() {}

func (*ServedRelayParameters_EndDeviceControlled) isServedRelayParameters_Mode() {}

// RelayParameters represent the parameters of a relay.
// This is used internally by the Network Server.
type RelayParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Mode:
	//	*RelayParameters_Serving
	//	*RelayParameters_Served
	Mode isRelayParameters_Mode `protobuf_oneof:"mode"`
}

func (x *RelayParameters) Reset() {
	*x = RelayParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelayParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelayParameters) ProtoMessage() {}

func (x *RelayParameters) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelayParameters.ProtoReflect.Descriptor instead.
func (*RelayParameters) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{6}
}

func (m *RelayParameters) GetMode() isRelayParameters_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (x *RelayParameters) GetServing() *ServingRelayParameters {
	if x, ok := x.GetMode().(*RelayParameters_Serving); ok {
		return x.Serving
	}
	return nil
}

func (x *RelayParameters) GetServed() *ServedRelayParameters {
	if x, ok := x.GetMode().(*RelayParameters_Served); ok {
		return x.Served
	}
	return nil
}

type isRelayParameters_Mode interface {
	isRelayParameters_Mode()
}

type RelayParameters_Serving struct {
	// Parameters related to a relay which is serving end devices.
	Serving *ServingRelayParameters `protobuf:"bytes,1,opt,name=serving,proto3,oneof"`
}

type RelayParameters_Served struct {
	// Parameters related to an end device served by a relay.
	Served *ServedRelayParameters `protobuf:"bytes,2,opt,name=served,proto3,oneof"`
}

func (*RelayParameters_Serving) isRelayParameters_Mode() {}

func (*RelayParameters_Served) isRelayParameters_Mode() {}

type ServingRelaySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Second wake on radio channel configuration.
	SecondChannel *RelaySecondChannel `protobuf:"bytes,1,opt,name=second_channel,json=secondChannel,proto3" json:"second_channel,omitempty"`
	// Index of the default wake on radio channel.
	// If unset, the default value from Network Server configuration will be used.
	DefaultChannelIndex *wrapperspb.UInt32Value `protobuf:"bytes,6,opt,name=default_channel_index,json=defaultChannelIndex,proto3" json:"default_channel_index,omitempty"`
	// Channel activity detection periodicity.
	CadPeriodicity RelayCADPeriodicity `protobuf:"varint,3,opt,name=cad_periodicity,json=cadPeriodicity,proto3,enum=ttn.lorawan.v3.RelayCADPeriodicity" json:"cad_periodicity,omitempty"`
	// Configured uplink forwarding rules.
	UplinkForwardingRules []*RelayUplinkForwardingRule `protobuf:"bytes,4,rep,name=uplink_forwarding_rules,json=uplinkForwardingRules,proto3" json:"uplink_forwarding_rules,omitempty"`
	// Configured forwarding limits.
	// If unset, the default value from Network Server configuration will be used.
	Limits *ServingRelayForwardingLimits `protobuf:"bytes,5,opt,name=limits,proto3" json:"limits,omitempty"`
}

func (x *ServingRelaySettings) Reset() {
	*x = ServingRelaySettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServingRelaySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServingRelaySettings) ProtoMessage() {}

func (x *ServingRelaySettings) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServingRelaySettings.ProtoReflect.Descriptor instead.
func (*ServingRelaySettings) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{7}
}

func (x *ServingRelaySettings) GetSecondChannel() *RelaySecondChannel {
	if x != nil {
		return x.SecondChannel
	}
	return nil
}

func (x *ServingRelaySettings) GetDefaultChannelIndex() *wrapperspb.UInt32Value {
	if x != nil {
		return x.DefaultChannelIndex
	}
	return nil
}

func (x *ServingRelaySettings) GetCadPeriodicity() RelayCADPeriodicity {
	if x != nil {
		return x.CadPeriodicity
	}
	return RelayCADPeriodicity_RELAY_CAD_PERIODICITY_1_SECOND
}

func (x *ServingRelaySettings) GetUplinkForwardingRules() []*RelayUplinkForwardingRule {
	if x != nil {
		return x.UplinkForwardingRules
	}
	return nil
}

func (x *ServingRelaySettings) GetLimits() *ServingRelayForwardingLimits {
	if x != nil {
		return x.Limits
	}
	return nil
}

type ServedRelaySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Mode:
	//	*ServedRelaySettings_Always
	//	*ServedRelaySettings_Dynamic
	//	*ServedRelaySettings_EndDeviceControlled
	Mode isServedRelaySettings_Mode `protobuf_oneof:"mode"`
	// Number of wake on radio frames to be sent without an acknowledgement before sending the uplink message directly.
	// If unset, the default value from Network Server configuration will be used.
	Backoff *wrapperspb.UInt32Value `protobuf:"bytes,7,opt,name=backoff,proto3" json:"backoff,omitempty"`
	// Second wake on radio channel configuration.
	SecondChannel *RelaySecondChannel `protobuf:"bytes,5,opt,name=second_channel,json=secondChannel,proto3" json:"second_channel,omitempty"`
	// End device identifier of the serving end device.
	ServingDeviceId string `protobuf:"bytes,6,opt,name=serving_device_id,json=servingDeviceId,proto3" json:"serving_device_id,omitempty"`
}

func (x *ServedRelaySettings) Reset() {
	*x = ServedRelaySettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServedRelaySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServedRelaySettings) ProtoMessage() {}

func (x *ServedRelaySettings) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServedRelaySettings.ProtoReflect.Descriptor instead.
func (*ServedRelaySettings) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{8}
}

func (m *ServedRelaySettings) GetMode() isServedRelaySettings_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (x *ServedRelaySettings) GetAlways() *RelayEndDeviceAlwaysMode {
	if x, ok := x.GetMode().(*ServedRelaySettings_Always); ok {
		return x.Always
	}
	return nil
}

func (x *ServedRelaySettings) GetDynamic() *RelayEndDeviceDynamicMode {
	if x, ok := x.GetMode().(*ServedRelaySettings_Dynamic); ok {
		return x.Dynamic
	}
	return nil
}

func (x *ServedRelaySettings) GetEndDeviceControlled() *RelayEndDeviceControlledMode {
	if x, ok := x.GetMode().(*ServedRelaySettings_EndDeviceControlled); ok {
		return x.EndDeviceControlled
	}
	return nil
}

func (x *ServedRelaySettings) GetBackoff() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Backoff
	}
	return nil
}

func (x *ServedRelaySettings) GetSecondChannel() *RelaySecondChannel {
	if x != nil {
		return x.SecondChannel
	}
	return nil
}

func (x *ServedRelaySettings) GetServingDeviceId() string {
	if x != nil {
		return x.ServingDeviceId
	}
	return ""
}

type isServedRelaySettings_Mode interface {
	isServedRelaySettings_Mode()
}

type ServedRelaySettings_Always struct {
	// The end device will always attempt to use the relay mode in order to send uplink messages.
	Always *RelayEndDeviceAlwaysMode `protobuf:"bytes,1,opt,name=always,proto3,oneof"`
}

type ServedRelaySettings_Dynamic struct {
	// The end device will attempt to use relay mode only after a number of uplink messages have been sent without
	// receiving a valid a downlink message.
	Dynamic *RelayEndDeviceDynamicMode `protobuf:"bytes,2,opt,name=dynamic,proto3,oneof"`
}

type ServedRelaySettings_EndDeviceControlled struct {
	// The end device will control when it uses the relay mode. This is the default mode.
	EndDeviceControlled *RelayEndDeviceControlledMode `protobuf:"bytes,3,opt,name=end_device_controlled,json=endDeviceControlled,proto3,oneof"`
}

func (*ServedRelaySettings_Always) isServedRelaySettings_Mode() {}

func (*ServedRelaySettings_Dynamic) isServedRelaySettings_Mode() {}

func (*ServedRelaySettings_EndDeviceControlled) isServedRelaySettings_Mode() {}

// RelaySettings represent the settings of a relay.
// This is used internally by the Network Server.
type RelaySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Mode:
	//	*RelaySettings_Serving
	//	*RelaySettings_Served
	Mode isRelaySettings_Mode `protobuf_oneof:"mode"`
}

func (x *RelaySettings) Reset() {
	*x = RelaySettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelaySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelaySettings) ProtoMessage() {}

func (x *RelaySettings) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelaySettings.ProtoReflect.Descriptor instead.
func (*RelaySettings) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{9}
}

func (m *RelaySettings) GetMode() isRelaySettings_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (x *RelaySettings) GetServing() *ServingRelaySettings {
	if x, ok := x.GetMode().(*RelaySettings_Serving); ok {
		return x.Serving
	}
	return nil
}

func (x *RelaySettings) GetServed() *ServedRelaySettings {
	if x, ok := x.GetMode().(*RelaySettings_Served); ok {
		return x.Served
	}
	return nil
}

type isRelaySettings_Mode interface {
	isRelaySettings_Mode()
}

type RelaySettings_Serving struct {
	Serving *ServingRelaySettings `protobuf:"bytes,1,opt,name=serving,proto3,oneof"`
}

type RelaySettings_Served struct {
	Served *ServedRelaySettings `protobuf:"bytes,2,opt,name=served,proto3,oneof"`
}

func (*RelaySettings_Serving) isRelaySettings_Mode() {}

func (*RelaySettings_Served) isRelaySettings_Mode() {}

// MACParameters represent the parameters of the device's MAC layer (active or desired).
// This is used internally by the Network Server.
type MACParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Maximum EIRP (dBm).
	MaxEirp float32 `protobuf:"fixed32,1,opt,name=max_eirp,json=maxEirp,proto3" json:"max_eirp,omitempty"`
	// ADR: data rate index to use.
	AdrDataRateIndex DataRateIndex `protobuf:"varint,4,opt,name=adr_data_rate_index,json=adrDataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"adr_data_rate_index,omitempty"`
	// ADR: transmission power index to use.
	AdrTxPowerIndex uint32 `protobuf:"varint,5,opt,name=adr_tx_power_index,json=adrTxPowerIndex,proto3" json:"adr_tx_power_index,omitempty"`
	// ADR: number of retransmissions.
	AdrNbTrans uint32 `protobuf:"varint,6,opt,name=adr_nb_trans,json=adrNbTrans,proto3" json:"adr_nb_trans,omitempty"`
	// ADR: number of messages to wait before setting ADRAckReq.
	// This field is deprecated, use adr_ack_limit_exponent instead.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/end_device.proto.
	AdrAckLimit uint32 `protobuf:"varint,7,opt,name=adr_ack_limit,json=adrAckLimit,proto3" json:"adr_ack_limit,omitempty"`
	// ADR: number of messages to wait after setting ADRAckReq and before changing TxPower or DataRate.
	// This field is deprecated, use adr_ack_delay_exponent instead.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/end_device.proto.
	AdrAckDelay uint32 `protobuf:"varint,8,opt,name=adr_ack_delay,json=adrAckDelay,proto3" json:"adr_ack_delay,omitempty"`
	// Rx1 delay (Rx2 delay is Rx1 delay + 1 second).
	Rx1Delay RxDelay `protobuf:"varint,9,opt,name=rx1_delay,json=rx1Delay,proto3,enum=ttn.lorawan.v3.RxDelay" json:"rx1_delay,omitempty"`
	// Data rate offset for Rx1.
	Rx1DataRateOffset DataRateOffset `protobuf:"varint,10,opt,name=rx1_data_rate_offset,json=rx1DataRateOffset,proto3,enum=ttn.lorawan.v3.DataRateOffset" json:"rx1_data_rate_offset,omitempty"`
	// Data rate index for Rx2.
	Rx2DataRateIndex DataRateIndex `protobuf:"varint,11,opt,name=rx2_data_rate_index,json=rx2DataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"rx2_data_rate_index,omitempty"`
	// Frequency for Rx2 (Hz).
	Rx2Frequency uint64 `protobuf:"varint,12,opt,name=rx2_frequency,json=rx2Frequency,proto3" json:"rx2_frequency,omitempty"`
	// Maximum uplink duty cycle (of all channels).
	MaxDutyCycle AggregatedDutyCycle `protobuf:"varint,13,opt,name=max_duty_cycle,json=maxDutyCycle,proto3,enum=ttn.lorawan.v3.AggregatedDutyCycle" json:"max_duty_cycle,omitempty"`
	// Time within which a rejoin-request must be sent.
	RejoinTimePeriodicity RejoinTimeExponent `protobuf:"varint,14,opt,name=rejoin_time_periodicity,json=rejoinTimePeriodicity,proto3,enum=ttn.lorawan.v3.RejoinTimeExponent" json:"rejoin_time_periodicity,omitempty"`
	// Message count within which a rejoin-request must be sent.
	RejoinCountPeriodicity RejoinCountExponent `protobuf:"varint,15,opt,name=rejoin_count_periodicity,json=rejoinCountPeriodicity,proto3,enum=ttn.lorawan.v3.RejoinCountExponent" json:"rejoin_count_periodicity,omitempty"`
	// Frequency of the class B ping slot (Hz).
	PingSlotFrequency uint64 `protobuf:"varint,16,opt,name=ping_slot_frequency,json=pingSlotFrequency,proto3" json:"ping_slot_frequency,omitempty"`
	// Data rate index of the class B ping slot.
	// This field is deprecated, use ping_slot_data_rate_index_value instead.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/end_device.proto.
	PingSlotDataRateIndex DataRateIndex `protobuf:"varint,17,opt,name=ping_slot_data_rate_index,json=pingSlotDataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"ping_slot_data_rate_index,omitempty"`
	// Frequency of the class B beacon (Hz).
	BeaconFrequency uint64 `protobuf:"varint,18,opt,name=beacon_frequency,json=beaconFrequency,proto3" json:"beacon_frequency,omitempty"`
	// Configured uplink channels and optionally Rx1 frequency.
	Channels []*MACParameters_Channel `protobuf:"bytes,19,rep,name=channels,proto3" json:"channels,omitempty"`
	// Whether uplink dwell time is set (400ms).
	// If unset, then the value is either unknown or irrelevant(Network Server cannot modify it).
	UplinkDwellTime *BoolValue `protobuf:"bytes,20,opt,name=uplink_dwell_time,json=uplinkDwellTime,proto3" json:"uplink_dwell_time,omitempty"`
	// Whether downlink dwell time is set (400ms).
	// If unset, then the value is either unknown or irrelevant(Network Server cannot modify it).
	DownlinkDwellTime *BoolValue `protobuf:"bytes,21,opt,name=downlink_dwell_time,json=downlinkDwellTime,proto3" json:"downlink_dwell_time,omitempty"`
	// ADR: number of messages to wait before setting ADRAckReq.
	AdrAckLimitExponent *ADRAckLimitExponentValue `protobuf:"bytes,22,opt,name=adr_ack_limit_exponent,json=adrAckLimitExponent,proto3" json:"adr_ack_limit_exponent,omitempty"`
	// ADR: number of messages to wait after setting ADRAckReq and before changing TxPower or DataRate.
	AdrAckDelayExponent *ADRAckDelayExponentValue `protobuf:"bytes,23,opt,name=adr_ack_delay_exponent,json=adrAckDelayExponent,proto3" json:"adr_ack_delay_exponent,omitempty"`
	// Data rate index of the class B ping slot.
	PingSlotDataRateIndexValue *DataRateIndexValue `protobuf:"bytes,24,opt,name=ping_slot_data_rate_index_value,json=pingSlotDataRateIndexValue,proto3" json:"ping_slot_data_rate_index_value,omitempty"`
	// Relay parameters.
	Relay *RelayParameters `protobuf:"bytes,25,opt,name=relay,proto3" json:"relay,omitempty"`
}

func (x *MACParameters) Reset() {
	*x = MACParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACParameters) ProtoMessage() {}

func (x *MACParameters) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACParameters.ProtoReflect.Descriptor instead.
func (*MACParameters) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{10}
}

func (x *MACParameters) GetMaxEirp() float32 {
	if x != nil {
		return x.MaxEirp
	}
	return 0
}

func (x *MACParameters) GetAdrDataRateIndex() DataRateIndex {
	if x != nil {
		return x.AdrDataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *MACParameters) GetAdrTxPowerIndex() uint32 {
	if x != nil {
		return x.AdrTxPowerIndex
	}
	return 0
}

func (x *MACParameters) GetAdrNbTrans() uint32 {
	if x != nil {
		return x.AdrNbTrans
	}
	return 0
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/end_device.proto.
func (x *MACParameters) GetAdrAckLimit() uint32 {
	if x != nil {
		return x.AdrAckLimit
	}
	return 0
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/end_device.proto.
func (x *MACParameters) GetAdrAckDelay() uint32 {
	if x != nil {
		return x.AdrAckDelay
	}
	return 0
}

func (x *MACParameters) GetRx1Delay() RxDelay {
	if x != nil {
		return x.Rx1Delay
	}
	return RxDelay_RX_DELAY_0
}

func (x *MACParameters) GetRx1DataRateOffset() DataRateOffset {
	if x != nil {
		return x.Rx1DataRateOffset
	}
	return DataRateOffset_DATA_RATE_OFFSET_0
}

func (x *MACParameters) GetRx2DataRateIndex() DataRateIndex {
	if x != nil {
		return x.Rx2DataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *MACParameters) GetRx2Frequency() uint64 {
	if x != nil {
		return x.Rx2Frequency
	}
	return 0
}

func (x *MACParameters) GetMaxDutyCycle() AggregatedDutyCycle {
	if x != nil {
		return x.MaxDutyCycle
	}
	return AggregatedDutyCycle_DUTY_CYCLE_1
}

func (x *MACParameters) GetRejoinTimePeriodicity() RejoinTimeExponent {
	if x != nil {
		return x.RejoinTimePeriodicity
	}
	return RejoinTimeExponent_REJOIN_TIME_0
}

func (x *MACParameters) GetRejoinCountPeriodicity() RejoinCountExponent {
	if x != nil {
		return x.RejoinCountPeriodicity
	}
	return RejoinCountExponent_REJOIN_COUNT_16
}

func (x *MACParameters) GetPingSlotFrequency() uint64 {
	if x != nil {
		return x.PingSlotFrequency
	}
	return 0
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/end_device.proto.
func (x *MACParameters) GetPingSlotDataRateIndex() DataRateIndex {
	if x != nil {
		return x.PingSlotDataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *MACParameters) GetBeaconFrequency() uint64 {
	if x != nil {
		return x.BeaconFrequency
	}
	return 0
}

func (x *MACParameters) GetChannels() []*MACParameters_Channel {
	if x != nil {
		return x.Channels
	}
	return nil
}

func (x *MACParameters) GetUplinkDwellTime() *BoolValue {
	if x != nil {
		return x.UplinkDwellTime
	}
	return nil
}

func (x *MACParameters) GetDownlinkDwellTime() *BoolValue {
	if x != nil {
		return x.DownlinkDwellTime
	}
	return nil
}

func (x *MACParameters) GetAdrAckLimitExponent() *ADRAckLimitExponentValue {
	if x != nil {
		return x.AdrAckLimitExponent
	}
	return nil
}

func (x *MACParameters) GetAdrAckDelayExponent() *ADRAckDelayExponentValue {
	if x != nil {
		return x.AdrAckDelayExponent
	}
	return nil
}

func (x *MACParameters) GetPingSlotDataRateIndexValue() *DataRateIndexValue {
	if x != nil {
		return x.PingSlotDataRateIndexValue
	}
	return nil
}

func (x *MACParameters) GetRelay() *RelayParameters {
	if x != nil {
		return x.Relay
	}
	return nil
}

// Template for creating end devices.
type EndDeviceVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version identifiers.
	Ids *EndDeviceVersionIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	// LoRaWAN MAC version.
	LorawanVersion MACVersion `protobuf:"varint,2,opt,name=lorawan_version,json=lorawanVersion,proto3,enum=ttn.lorawan.v3.MACVersion" json:"lorawan_version,omitempty"`
	// LoRaWAN PHY version.
	LorawanPhyVersion PHYVersion `protobuf:"varint,3,opt,name=lorawan_phy_version,json=lorawanPhyVersion,proto3,enum=ttn.lorawan.v3.PHYVersion" json:"lorawan_phy_version,omitempty"`
	// ID of the frequency plan used by this device.
	FrequencyPlanId string `protobuf:"bytes,4,opt,name=frequency_plan_id,json=frequencyPlanId,proto3" json:"frequency_plan_id,omitempty"`
	// Photos contains file names of device photos.
	Photos []string `protobuf:"bytes,5,rep,name=photos,proto3" json:"photos,omitempty"`
	// Whether the device supports class B.
	SupportsClassB bool `protobuf:"varint,6,opt,name=supports_class_b,json=supportsClassB,proto3" json:"supports_class_b,omitempty"`
	// Whether the device supports class C.
	SupportsClassC bool `protobuf:"varint,7,opt,name=supports_class_c,json=supportsClassC,proto3" json:"supports_class_c,omitempty"`
	// Default MAC layer settings of the device.
	DefaultMacSettings *MACSettings `protobuf:"bytes,8,opt,name=default_mac_settings,json=defaultMacSettings,proto3" json:"default_mac_settings,omitempty"`
	// Minimum frequency the device is capable of using (Hz).
	MinFrequency uint64 `protobuf:"varint,9,opt,name=min_frequency,json=minFrequency,proto3" json:"min_frequency,omitempty"`
	// Maximum frequency the device is capable of using (Hz).
	MaxFrequency uint64 `protobuf:"varint,10,opt,name=max_frequency,json=maxFrequency,proto3" json:"max_frequency,omitempty"`
	// The device supports join (it's OTAA).
	SupportsJoin bool `protobuf:"varint,11,opt,name=supports_join,json=supportsJoin,proto3" json:"supports_join,omitempty"`
	// Whether the device resets the join and dev nonces (not LoRaWAN compliant).
	ResetsJoinNonces bool `protobuf:"varint,12,opt,name=resets_join_nonces,json=resetsJoinNonces,proto3" json:"resets_join_nonces,omitempty"`
	// Default formatters defining the payload formats for this end device.
	DefaultFormatters *MessagePayloadFormatters `protobuf:"bytes,13,opt,name=default_formatters,json=defaultFormatters,proto3" json:"default_formatters,omitempty"`
}

func (x *EndDeviceVersion) Reset() {
	*x = EndDeviceVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceVersion) ProtoMessage() {}

func (x *EndDeviceVersion) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceVersion.ProtoReflect.Descriptor instead.
func (*EndDeviceVersion) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{11}
}

func (x *EndDeviceVersion) GetIds() *EndDeviceVersionIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *EndDeviceVersion) GetLorawanVersion() MACVersion {
	if x != nil {
		return x.LorawanVersion
	}
	return MACVersion_MAC_UNKNOWN
}

func (x *EndDeviceVersion) GetLorawanPhyVersion() PHYVersion {
	if x != nil {
		return x.LorawanPhyVersion
	}
	return PHYVersion_PHY_UNKNOWN
}

func (x *EndDeviceVersion) GetFrequencyPlanId() string {
	if x != nil {
		return x.FrequencyPlanId
	}
	return ""
}

func (x *EndDeviceVersion) GetPhotos() []string {
	if x != nil {
		return x.Photos
	}
	return nil
}

func (x *EndDeviceVersion) GetSupportsClassB() bool {
	if x != nil {
		return x.SupportsClassB
	}
	return false
}

func (x *EndDeviceVersion) GetSupportsClassC() bool {
	if x != nil {
		return x.SupportsClassC
	}
	return false
}

func (x *EndDeviceVersion) GetDefaultMacSettings() *MACSettings {
	if x != nil {
		return x.DefaultMacSettings
	}
	return nil
}

func (x *EndDeviceVersion) GetMinFrequency() uint64 {
	if x != nil {
		return x.MinFrequency
	}
	return 0
}

func (x *EndDeviceVersion) GetMaxFrequency() uint64 {
	if x != nil {
		return x.MaxFrequency
	}
	return 0
}

func (x *EndDeviceVersion) GetSupportsJoin() bool {
	if x != nil {
		return x.SupportsJoin
	}
	return false
}

func (x *EndDeviceVersion) GetResetsJoinNonces() bool {
	if x != nil {
		return x.ResetsJoinNonces
	}
	return false
}

func (x *EndDeviceVersion) GetDefaultFormatters() *MessagePayloadFormatters {
	if x != nil {
		return x.DefaultFormatters
	}
	return nil
}

// Adaptive Data Rate settings.
type ADRSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Mode:
	//	*ADRSettings_Static
	//	*ADRSettings_Dynamic
	//	*ADRSettings_Disabled
	Mode isADRSettings_Mode `protobuf_oneof:"mode"`
}

func (x *ADRSettings) Reset() {
	*x = ADRSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ADRSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ADRSettings) ProtoMessage() {}

func (x *ADRSettings) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ADRSettings.ProtoReflect.Descriptor instead.
func (*ADRSettings) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{12}
}

func (m *ADRSettings) GetMode() isADRSettings_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (x *ADRSettings) GetStatic() *ADRSettings_StaticMode {
	if x, ok := x.GetMode().(*ADRSettings_Static); ok {
		return x.Static
	}
	return nil
}

func (x *ADRSettings) GetDynamic() *ADRSettings_DynamicMode {
	if x, ok := x.GetMode().(*ADRSettings_Dynamic); ok {
		return x.Dynamic
	}
	return nil
}

func (x *ADRSettings) GetDisabled() *ADRSettings_DisabledMode {
	if x, ok := x.GetMode().(*ADRSettings_Disabled); ok {
		return x.Disabled
	}
	return nil
}

type isADRSettings_Mode interface {
	isADRSettings_Mode()
}

type ADRSettings_Static struct {
	Static *ADRSettings_StaticMode `protobuf:"bytes,1,opt,name=static,proto3,oneof"`
}

type ADRSettings_Dynamic struct {
	Dynamic *ADRSettings_DynamicMode `protobuf:"bytes,2,opt,name=dynamic,proto3,oneof"`
}

type ADRSettings_Disabled struct {
	Disabled *ADRSettings_DisabledMode `protobuf:"bytes,3,opt,name=disabled,proto3,oneof"`
}

func (*ADRSettings_Static) isADRSettings_Mode() {}

func (*ADRSettings_Dynamic) isADRSettings_Mode() {}

func (*ADRSettings_Disabled) isADRSettings_Mode() {}

type MACSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Maximum delay for the device to answer a MAC request or a confirmed downlink frame.
	// If unset, the default value from Network Server configuration will be used.
	ClassBTimeout *durationpb.Duration `protobuf:"bytes,1,opt,name=class_b_timeout,json=classBTimeout,proto3" json:"class_b_timeout,omitempty"`
	// Periodicity of the class B ping slot.
	// If unset, the default value from Network Server configuration will be used.
	PingSlotPeriodicity *PingSlotPeriodValue `protobuf:"bytes,2,opt,name=ping_slot_periodicity,json=pingSlotPeriodicity,proto3" json:"ping_slot_periodicity,omitempty"`
	// Data rate index of the class B ping slot.
	// If unset, the default value from Network Server configuration will be used.
	PingSlotDataRateIndex *DataRateIndexValue `protobuf:"bytes,3,opt,name=ping_slot_data_rate_index,json=pingSlotDataRateIndex,proto3" json:"ping_slot_data_rate_index,omitempty"`
	// Frequency of the class B ping slot (Hz).
	// If unset, the default value from Network Server configuration will be used.
	PingSlotFrequency *ZeroableFrequencyValue `protobuf:"bytes,4,opt,name=ping_slot_frequency,json=pingSlotFrequency,proto3" json:"ping_slot_frequency,omitempty"`
	// Frequency of the class B beacon (Hz).
	// If unset, the default value from Network Server configuration will be used.
	BeaconFrequency *ZeroableFrequencyValue `protobuf:"bytes,25,opt,name=beacon_frequency,json=beaconFrequency,proto3" json:"beacon_frequency,omitempty"`
	// Maximum delay for the device to answer a MAC request or a confirmed downlink frame.
	// If unset, the default value from Network Server configuration will be used.
	ClassCTimeout *durationpb.Duration `protobuf:"bytes,5,opt,name=class_c_timeout,json=classCTimeout,proto3" json:"class_c_timeout,omitempty"`
	// Class A Rx1 delay.
	// If unset, the default value from Network Server configuration or regional parameters specification will be used.
	Rx1Delay *RxDelayValue `protobuf:"bytes,6,opt,name=rx1_delay,json=rx1Delay,proto3" json:"rx1_delay,omitempty"`
	// Rx1 data rate offset.
	// If unset, the default value from Network Server configuration will be used.
	Rx1DataRateOffset *DataRateOffsetValue `protobuf:"bytes,7,opt,name=rx1_data_rate_offset,json=rx1DataRateOffset,proto3" json:"rx1_data_rate_offset,omitempty"`
	// Data rate index for Rx2.
	// If unset, the default value from Network Server configuration or regional parameters specification will be used.
	Rx2DataRateIndex *DataRateIndexValue `protobuf:"bytes,8,opt,name=rx2_data_rate_index,json=rx2DataRateIndex,proto3" json:"rx2_data_rate_index,omitempty"`
	// Frequency for Rx2 (Hz).
	// If unset, the default value from Network Server configuration or regional parameters specification will be used.
	Rx2Frequency *FrequencyValue `protobuf:"bytes,9,opt,name=rx2_frequency,json=rx2Frequency,proto3" json:"rx2_frequency,omitempty"`
	// List of factory-preset frequencies.
	// If unset, the default value from Network Server configuration or regional parameters specification will be used.
	FactoryPresetFrequencies []uint64 `protobuf:"varint,10,rep,packed,name=factory_preset_frequencies,json=factoryPresetFrequencies,proto3" json:"factory_preset_frequencies,omitempty"`
	// Maximum uplink duty cycle (of all channels).
	MaxDutyCycle *AggregatedDutyCycleValue `protobuf:"bytes,11,opt,name=max_duty_cycle,json=maxDutyCycle,proto3" json:"max_duty_cycle,omitempty"`
	// Whether the device supports 32-bit frame counters.
	// If unset, the default value from Network Server configuration will be used.
	Supports_32BitFCnt *BoolValue `protobuf:"bytes,12,opt,name=supports_32_bit_f_cnt,json=supports32BitFCnt,proto3" json:"supports_32_bit_f_cnt,omitempty"`
	// Whether the Network Server should use ADR for the device.
	// This field is deprecated, use adr_settings instead.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/end_device.proto.
	UseAdr *BoolValue `protobuf:"bytes,13,opt,name=use_adr,json=useAdr,proto3" json:"use_adr,omitempty"`
	// The ADR margin (dB) tells the network server how much margin it should add in ADR requests.
	// A bigger margin is less efficient, but gives a better chance of successful reception.
	// This field is deprecated, use adr_settings.dynamic.margin instead.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/end_device.proto.
	AdrMargin *wrapperspb.FloatValue `protobuf:"bytes,14,opt,name=adr_margin,json=adrMargin,proto3" json:"adr_margin,omitempty"`
	// Whether the device resets the frame counters (not LoRaWAN compliant).
	// If unset, the default value from Network Server configuration will be used.
	ResetsFCnt *BoolValue `protobuf:"bytes,15,opt,name=resets_f_cnt,json=resetsFCnt,proto3" json:"resets_f_cnt,omitempty"`
	// The interval after which a DevStatusReq MACCommand shall be sent.
	// If unset, the default value from Network Server configuration will be used.
	StatusTimePeriodicity *durationpb.Duration `protobuf:"bytes,16,opt,name=status_time_periodicity,json=statusTimePeriodicity,proto3" json:"status_time_periodicity,omitempty"`
	// Number of uplink messages after which a DevStatusReq MACCommand shall be sent.
	// If unset, the default value from Network Server configuration will be used.
	StatusCountPeriodicity *wrapperspb.UInt32Value `protobuf:"bytes,17,opt,name=status_count_periodicity,json=statusCountPeriodicity,proto3" json:"status_count_periodicity,omitempty"`
	// The Rx1 delay Network Server should configure device to use via MAC commands or Join-Accept.
	// If unset, the default value from Network Server configuration or regional parameters specification will be used.
	DesiredRx1Delay *RxDelayValue `protobuf:"bytes,18,opt,name=desired_rx1_delay,json=desiredRx1Delay,proto3" json:"desired_rx1_delay,omitempty"`
	// The Rx1 data rate offset Network Server should configure device to use via MAC commands or Join-Accept.
	// If unset, the default value from Network Server configuration will be used.
	DesiredRx1DataRateOffset *DataRateOffsetValue `protobuf:"bytes,19,opt,name=desired_rx1_data_rate_offset,json=desiredRx1DataRateOffset,proto3" json:"desired_rx1_data_rate_offset,omitempty"`
	// The Rx2 data rate index Network Server should configure device to use via MAC commands or Join-Accept.
	// If unset, the default value from frequency plan, Network Server configuration or regional parameters specification will be used.
	DesiredRx2DataRateIndex *DataRateIndexValue `protobuf:"bytes,20,opt,name=desired_rx2_data_rate_index,json=desiredRx2DataRateIndex,proto3" json:"desired_rx2_data_rate_index,omitempty"`
	// The Rx2 frequency index Network Server should configure device to use via MAC commands.
	// If unset, the default value from frequency plan, Network Server configuration or regional parameters specification will be used.
	DesiredRx2Frequency *FrequencyValue `protobuf:"bytes,21,opt,name=desired_rx2_frequency,json=desiredRx2Frequency,proto3" json:"desired_rx2_frequency,omitempty"`
	// The maximum uplink duty cycle (of all channels) Network Server should configure device to use via MAC commands.
	// If unset, the default value from Network Server configuration will be used.
	DesiredMaxDutyCycle *AggregatedDutyCycleValue `protobuf:"bytes,22,opt,name=desired_max_duty_cycle,json=desiredMaxDutyCycle,proto3" json:"desired_max_duty_cycle,omitempty"`
	// The ADR ACK limit Network Server should configure device to use via MAC commands.
	// If unset, the default value from Network Server configuration or regional parameters specification will be used.
	DesiredAdrAckLimitExponent *ADRAckLimitExponentValue `protobuf:"bytes,23,opt,name=desired_adr_ack_limit_exponent,json=desiredAdrAckLimitExponent,proto3" json:"desired_adr_ack_limit_exponent,omitempty"`
	// The ADR ACK delay Network Server should configure device to use via MAC commands.
	// If unset, the default value from Network Server configuration or regional parameters specification will be used.
	DesiredAdrAckDelayExponent *ADRAckDelayExponentValue `protobuf:"bytes,24,opt,name=desired_adr_ack_delay_exponent,json=desiredAdrAckDelayExponent,proto3" json:"desired_adr_ack_delay_exponent,omitempty"`
	// The data rate index of the class B ping slot Network Server should configure device to use via MAC commands.
	// If unset, the default value from Network Server configuration will be used.
	DesiredPingSlotDataRateIndex *DataRateIndexValue `protobuf:"bytes,27,opt,name=desired_ping_slot_data_rate_index,json=desiredPingSlotDataRateIndex,proto3" json:"desired_ping_slot_data_rate_index,omitempty"`
	// The frequency of the class B ping slot (Hz) Network Server should configure device to use via MAC commands.
	// If unset, the default value from Network Server configuration or regional parameters specification will be used.
	DesiredPingSlotFrequency *ZeroableFrequencyValue `protobuf:"bytes,28,opt,name=desired_ping_slot_frequency,json=desiredPingSlotFrequency,proto3" json:"desired_ping_slot_frequency,omitempty"`
	// The frequency of the class B beacon (Hz) Network Server should configure device to use via MAC commands.
	// If unset, the default value from Network Server configuration will be used.
	DesiredBeaconFrequency *ZeroableFrequencyValue `protobuf:"bytes,29,opt,name=desired_beacon_frequency,json=desiredBeaconFrequency,proto3" json:"desired_beacon_frequency,omitempty"`
	// Maximum EIRP (dBm).
	// If unset, the default value from regional parameters specification will be used.
	DesiredMaxEirp *DeviceEIRPValue `protobuf:"bytes,30,opt,name=desired_max_eirp,json=desiredMaxEirp,proto3" json:"desired_max_eirp,omitempty"`
	// The minimum duration passed before a network-initiated(e.g. Class B or C) downlink following an arbitrary downlink.
	ClassBCDownlinkInterval *durationpb.Duration `protobuf:"bytes,31,opt,name=class_b_c_downlink_interval,json=classBCDownlinkInterval,proto3" json:"class_b_c_downlink_interval,omitempty"`
	// Whether uplink dwell time is set (400ms).
	// If unset, the default value from Network Server configuration or regional parameters specification will be used.
	UplinkDwellTime *BoolValue `protobuf:"bytes,32,opt,name=uplink_dwell_time,json=uplinkDwellTime,proto3" json:"uplink_dwell_time,omitempty"`
	// Whether downlink dwell time is set (400ms).
	// If unset, the default value from Network Server configuration or regional parameters specification will be used.
	DownlinkDwellTime *BoolValue `protobuf:"bytes,33,opt,name=downlink_dwell_time,json=downlinkDwellTime,proto3" json:"downlink_dwell_time,omitempty"`
	// Adaptive Data Rate settings.
	// If unset, the default value from Network Server configuration or regional parameters specification will be used.
	Adr *ADRSettings `protobuf:"bytes,34,opt,name=adr,proto3" json:"adr,omitempty"`
	// Whether or not downlink messages should be scheduled.
	// This option can be used in order to disable any downlink interaction with the end device. It will affect all types
	// of downlink messages: data and MAC downlinks, and join accepts.
	ScheduleDownlinks *BoolValue `protobuf:"bytes,35,opt,name=schedule_downlinks,json=scheduleDownlinks,proto3" json:"schedule_downlinks,omitempty"`
	// The relay settings the end device is using.
	// If unset, the default value from Network Server configuration or regional parameters specification will be used.
	Relay *RelaySettings `protobuf:"bytes,36,opt,name=relay,proto3" json:"relay,omitempty"`
	// The relay settings the Network Server should configure device to use via MAC commands.
	// If unset, the default value from Network Server configuration or regional parameters specification will be used.
	DesiredRelay *RelaySettings `protobuf:"bytes,37,opt,name=desired_relay,json=desiredRelay,proto3" json:"desired_relay,omitempty"`
}

func (x *MACSettings) Reset() {
	*x = MACSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACSettings) ProtoMessage() {}

func (x *MACSettings) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACSettings.ProtoReflect.Descriptor instead.
func (*MACSettings) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{13}
}

func (x *MACSettings) GetClassBTimeout() *durationpb.Duration {
	if x != nil {
		return x.ClassBTimeout
	}
	return nil
}

func (x *MACSettings) GetPingSlotPeriodicity() *PingSlotPeriodValue {
	if x != nil {
		return x.PingSlotPeriodicity
	}
	return nil
}

func (x *MACSettings) GetPingSlotDataRateIndex() *DataRateIndexValue {
	if x != nil {
		return x.PingSlotDataRateIndex
	}
	return nil
}

func (x *MACSettings) GetPingSlotFrequency() *ZeroableFrequencyValue {
	if x != nil {
		return x.PingSlotFrequency
	}
	return nil
}

func (x *MACSettings) GetBeaconFrequency() *ZeroableFrequencyValue {
	if x != nil {
		return x.BeaconFrequency
	}
	return nil
}

func (x *MACSettings) GetClassCTimeout() *durationpb.Duration {
	if x != nil {
		return x.ClassCTimeout
	}
	return nil
}

func (x *MACSettings) GetRx1Delay() *RxDelayValue {
	if x != nil {
		return x.Rx1Delay
	}
	return nil
}

func (x *MACSettings) GetRx1DataRateOffset() *DataRateOffsetValue {
	if x != nil {
		return x.Rx1DataRateOffset
	}
	return nil
}

func (x *MACSettings) GetRx2DataRateIndex() *DataRateIndexValue {
	if x != nil {
		return x.Rx2DataRateIndex
	}
	return nil
}

func (x *MACSettings) GetRx2Frequency() *FrequencyValue {
	if x != nil {
		return x.Rx2Frequency
	}
	return nil
}

func (x *MACSettings) GetFactoryPresetFrequencies() []uint64 {
	if x != nil {
		return x.FactoryPresetFrequencies
	}
	return nil
}

func (x *MACSettings) GetMaxDutyCycle() *AggregatedDutyCycleValue {
	if x != nil {
		return x.MaxDutyCycle
	}
	return nil
}

func (x *MACSettings) GetSupports_32BitFCnt() *BoolValue {
	if x != nil {
		return x.Supports_32BitFCnt
	}
	return nil
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/end_device.proto.
func (x *MACSettings) GetUseAdr() *BoolValue {
	if x != nil {
		return x.UseAdr
	}
	return nil
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/end_device.proto.
func (x *MACSettings) GetAdrMargin() *wrapperspb.FloatValue {
	if x != nil {
		return x.AdrMargin
	}
	return nil
}

func (x *MACSettings) GetResetsFCnt() *BoolValue {
	if x != nil {
		return x.ResetsFCnt
	}
	return nil
}

func (x *MACSettings) GetStatusTimePeriodicity() *durationpb.Duration {
	if x != nil {
		return x.StatusTimePeriodicity
	}
	return nil
}

func (x *MACSettings) GetStatusCountPeriodicity() *wrapperspb.UInt32Value {
	if x != nil {
		return x.StatusCountPeriodicity
	}
	return nil
}

func (x *MACSettings) GetDesiredRx1Delay() *RxDelayValue {
	if x != nil {
		return x.DesiredRx1Delay
	}
	return nil
}

func (x *MACSettings) GetDesiredRx1DataRateOffset() *DataRateOffsetValue {
	if x != nil {
		return x.DesiredRx1DataRateOffset
	}
	return nil
}

func (x *MACSettings) GetDesiredRx2DataRateIndex() *DataRateIndexValue {
	if x != nil {
		return x.DesiredRx2DataRateIndex
	}
	return nil
}

func (x *MACSettings) GetDesiredRx2Frequency() *FrequencyValue {
	if x != nil {
		return x.DesiredRx2Frequency
	}
	return nil
}

func (x *MACSettings) GetDesiredMaxDutyCycle() *AggregatedDutyCycleValue {
	if x != nil {
		return x.DesiredMaxDutyCycle
	}
	return nil
}

func (x *MACSettings) GetDesiredAdrAckLimitExponent() *ADRAckLimitExponentValue {
	if x != nil {
		return x.DesiredAdrAckLimitExponent
	}
	return nil
}

func (x *MACSettings) GetDesiredAdrAckDelayExponent() *ADRAckDelayExponentValue {
	if x != nil {
		return x.DesiredAdrAckDelayExponent
	}
	return nil
}

func (x *MACSettings) GetDesiredPingSlotDataRateIndex() *DataRateIndexValue {
	if x != nil {
		return x.DesiredPingSlotDataRateIndex
	}
	return nil
}

func (x *MACSettings) GetDesiredPingSlotFrequency() *ZeroableFrequencyValue {
	if x != nil {
		return x.DesiredPingSlotFrequency
	}
	return nil
}

func (x *MACSettings) GetDesiredBeaconFrequency() *ZeroableFrequencyValue {
	if x != nil {
		return x.DesiredBeaconFrequency
	}
	return nil
}

func (x *MACSettings) GetDesiredMaxEirp() *DeviceEIRPValue {
	if x != nil {
		return x.DesiredMaxEirp
	}
	return nil
}

func (x *MACSettings) GetClassBCDownlinkInterval() *durationpb.Duration {
	if x != nil {
		return x.ClassBCDownlinkInterval
	}
	return nil
}

func (x *MACSettings) GetUplinkDwellTime() *BoolValue {
	if x != nil {
		return x.UplinkDwellTime
	}
	return nil
}

func (x *MACSettings) GetDownlinkDwellTime() *BoolValue {
	if x != nil {
		return x.DownlinkDwellTime
	}
	return nil
}

func (x *MACSettings) GetAdr() *ADRSettings {
	if x != nil {
		return x.Adr
	}
	return nil
}

func (x *MACSettings) GetScheduleDownlinks() *BoolValue {
	if x != nil {
		return x.ScheduleDownlinks
	}
	return nil
}

func (x *MACSettings) GetRelay() *RelaySettings {
	if x != nil {
		return x.Relay
	}
	return nil
}

func (x *MACSettings) GetDesiredRelay() *RelaySettings {
	if x != nil {
		return x.DesiredRelay
	}
	return nil
}

type MACSettingsProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Profile identifiers.
	Ids *MACSettingsProfileIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	// MAC settings.
	MacSettings *MACSettings `protobuf:"bytes,2,opt,name=mac_settings,json=macSettings,proto3" json:"mac_settings,omitempty"`
}

func (x *MACSettingsProfile) Reset() {
	*x = MACSettingsProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACSettingsProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACSettingsProfile) ProtoMessage() {}

func (x *MACSettingsProfile) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACSettingsProfile.ProtoReflect.Descriptor instead.
func (*MACSettingsProfile) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{14}
}

func (x *MACSettingsProfile) GetIds() *MACSettingsProfileIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *MACSettingsProfile) GetMacSettings() *MACSettings {
	if x != nil {
		return x.MacSettings
	}
	return nil
}

// MACState represents the state of MAC layer of the device.
// MACState is reset on each join for OTAA or ResetInd for ABP devices.
// This is used internally by the Network Server.
type MACState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Current LoRaWAN MAC parameters.
	CurrentParameters *MACParameters `protobuf:"bytes,1,opt,name=current_parameters,json=currentParameters,proto3" json:"current_parameters,omitempty"`
	// Desired LoRaWAN MAC parameters.
	DesiredParameters *MACParameters `protobuf:"bytes,2,opt,name=desired_parameters,json=desiredParameters,proto3" json:"desired_parameters,omitempty"`
	// Currently active LoRaWAN device class
	// - Device class is A by default
	// - If device sets ClassB bit in uplink, this will be set to B
	// - If device sent DeviceModeInd MAC message, this will be set to that value
	DeviceClass Class `protobuf:"varint,3,opt,name=device_class,json=deviceClass,proto3,enum=ttn.lorawan.v3.Class" json:"device_class,omitempty"`
	// LoRaWAN MAC version.
	LorawanVersion MACVersion `protobuf:"varint,4,opt,name=lorawan_version,json=lorawanVersion,proto3,enum=ttn.lorawan.v3.MACVersion" json:"lorawan_version,omitempty"`
	// Time when the last confirmed downlink message or MAC command was scheduled.
	LastConfirmedDownlinkAt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=last_confirmed_downlink_at,json=lastConfirmedDownlinkAt,proto3" json:"last_confirmed_downlink_at,omitempty"`
	// Frame counter value of last uplink containing DevStatusAns.
	LastDevStatusFCntUp uint32 `protobuf:"varint,6,opt,name=last_dev_status_f_cnt_up,json=lastDevStatusFCntUp,proto3" json:"last_dev_status_f_cnt_up,omitempty"`
	// Periodicity of the class B ping slot.
	PingSlotPeriodicity *PingSlotPeriodValue `protobuf:"bytes,7,opt,name=ping_slot_periodicity,json=pingSlotPeriodicity,proto3" json:"ping_slot_periodicity,omitempty"`
	// A confirmed application downlink, for which an acknowledgment is expected to arrive.
	PendingApplicationDownlink *ApplicationDownlink `protobuf:"bytes,8,opt,name=pending_application_downlink,json=pendingApplicationDownlink,proto3" json:"pending_application_downlink,omitempty"`
	// Queued MAC responses.
	// Regenerated on each uplink.
	QueuedResponses []*MACCommand `protobuf:"bytes,9,rep,name=queued_responses,json=queuedResponses,proto3" json:"queued_responses,omitempty"`
	// Pending MAC requests(i.e. sent requests, for which no response has been received yet).
	// Regenerated on each downlink.
	PendingRequests []*MACCommand `protobuf:"bytes,10,rep,name=pending_requests,json=pendingRequests,proto3" json:"pending_requests,omitempty"`
	// Queued join-accept.
	// Set each time a (re-)join request accept is received from Join Server and removed each time a downlink is scheduled.
	QueuedJoinAccept *MACState_JoinAccept `protobuf:"bytes,11,opt,name=queued_join_accept,json=queuedJoinAccept,proto3" json:"queued_join_accept,omitempty"`
	// Pending join request.
	// Set each time a join-accept is scheduled and removed each time an uplink is received from the device.
	PendingJoinRequest *MACState_JoinRequest `protobuf:"bytes,12,opt,name=pending_join_request,json=pendingJoinRequest,proto3" json:"pending_join_request,omitempty"`
	// Whether or not Rx windows are expected to be open.
	// Set to true every time an uplink is received.
	// Set to false every time a successful downlink scheduling attempt is made.
	RxWindowsAvailable bool `protobuf:"varint,13,opt,name=rx_windows_available,json=rxWindowsAvailable,proto3" json:"rx_windows_available,omitempty"`
	// Recent data uplink messages sorted by time.
	// The number of messages stored may depend on configuration.
	RecentUplinks []*MACState_UplinkMessage `protobuf:"bytes,14,rep,name=recent_uplinks,json=recentUplinks,proto3" json:"recent_uplinks,omitempty"`
	// Recent data downlink messages sorted by time.
	// The number of messages stored may depend on configuration.
	RecentDownlinks []*MACState_DownlinkMessage `protobuf:"bytes,15,rep,name=recent_downlinks,json=recentDownlinks,proto3" json:"recent_downlinks,omitempty"`
	// Time when the last network-initiated downlink message was scheduled.
	LastNetworkInitiatedDownlinkAt *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=last_network_initiated_downlink_at,json=lastNetworkInitiatedDownlinkAt,proto3" json:"last_network_initiated_downlink_at,omitempty"`
	// ADR Data rate index values rejected by the device.
	// Reset each time `current_parameters.channels` change.
	// Elements are sorted in ascending order.
	RejectedAdrDataRateIndexes []DataRateIndex `protobuf:"varint,17,rep,packed,name=rejected_adr_data_rate_indexes,json=rejectedAdrDataRateIndexes,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"rejected_adr_data_rate_indexes,omitempty"`
	// ADR TX output power index values rejected by the device.
	// Elements are sorted in ascending order.
	RejectedAdrTxPowerIndexes []uint32 `protobuf:"varint,18,rep,packed,name=rejected_adr_tx_power_indexes,json=rejectedAdrTxPowerIndexes,proto3" json:"rejected_adr_tx_power_indexes,omitempty"`
	// Frequencies rejected by the device.
	RejectedFrequencies []uint64 `protobuf:"varint,19,rep,packed,name=rejected_frequencies,json=rejectedFrequencies,proto3" json:"rejected_frequencies,omitempty"`
	// Time when the last downlink message was scheduled.
	LastDownlinkAt *timestamppb.Timestamp `protobuf:"bytes,20,opt,name=last_downlink_at,json=lastDownlinkAt,proto3" json:"last_downlink_at,omitempty"`
	// Data rate ranges rejected by the device per frequency.
	RejectedDataRateRanges map[uint64]*MACState_DataRateRanges `protobuf:"bytes,21,rep,name=rejected_data_rate_ranges,json=rejectedDataRateRanges,proto3" json:"rejected_data_rate_ranges,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Frame counter of uplink, which confirmed the last ADR parameter change.
	LastAdrChangeFCntUp uint32 `protobuf:"varint,22,opt,name=last_adr_change_f_cnt_up,json=lastAdrChangeFCntUp,proto3" json:"last_adr_change_f_cnt_up,omitempty"`
	// MAC command identifiers sent by the end device in the last received uplink.
	// The Network Server may choose to store only certain types of MAC
	// command identifiers in the underlying implementation.
	RecentMacCommandIdentifiers []MACCommandIdentifier `protobuf:"varint,23,rep,packed,name=recent_mac_command_identifiers,json=recentMacCommandIdentifiers,proto3,enum=ttn.lorawan.v3.MACCommandIdentifier" json:"recent_mac_command_identifiers,omitempty"`
	// Pending relay downlink contents.
	// The pending downlink will be scheduled to the relay in either Rx1 or Rx2.
	// The pending downlink will be cleared after the scheduling attempt.
	PendingRelayDownlink *RelayForwardDownlinkReq `protobuf:"bytes,24,opt,name=pending_relay_downlink,json=pendingRelayDownlink,proto3" json:"pending_relay_downlink,omitempty"`
}

func (x *MACState) Reset() {
	*x = MACState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACState) ProtoMessage() {}

func (x *MACState) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACState.ProtoReflect.Descriptor instead.
func (*MACState) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{15}
}

func (x *MACState) GetCurrentParameters() *MACParameters {
	if x != nil {
		return x.CurrentParameters
	}
	return nil
}

func (x *MACState) GetDesiredParameters() *MACParameters {
	if x != nil {
		return x.DesiredParameters
	}
	return nil
}

func (x *MACState) GetDeviceClass() Class {
	if x != nil {
		return x.DeviceClass
	}
	return Class_CLASS_A
}

func (x *MACState) GetLorawanVersion() MACVersion {
	if x != nil {
		return x.LorawanVersion
	}
	return MACVersion_MAC_UNKNOWN
}

func (x *MACState) GetLastConfirmedDownlinkAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastConfirmedDownlinkAt
	}
	return nil
}

func (x *MACState) GetLastDevStatusFCntUp() uint32 {
	if x != nil {
		return x.LastDevStatusFCntUp
	}
	return 0
}

func (x *MACState) GetPingSlotPeriodicity() *PingSlotPeriodValue {
	if x != nil {
		return x.PingSlotPeriodicity
	}
	return nil
}

func (x *MACState) GetPendingApplicationDownlink() *ApplicationDownlink {
	if x != nil {
		return x.PendingApplicationDownlink
	}
	return nil
}

func (x *MACState) GetQueuedResponses() []*MACCommand {
	if x != nil {
		return x.QueuedResponses
	}
	return nil
}

func (x *MACState) GetPendingRequests() []*MACCommand {
	if x != nil {
		return x.PendingRequests
	}
	return nil
}

func (x *MACState) GetQueuedJoinAccept() *MACState_JoinAccept {
	if x != nil {
		return x.QueuedJoinAccept
	}
	return nil
}

func (x *MACState) GetPendingJoinRequest() *MACState_JoinRequest {
	if x != nil {
		return x.PendingJoinRequest
	}
	return nil
}

func (x *MACState) GetRxWindowsAvailable() bool {
	if x != nil {
		return x.RxWindowsAvailable
	}
	return false
}

func (x *MACState) GetRecentUplinks() []*MACState_UplinkMessage {
	if x != nil {
		return x.RecentUplinks
	}
	return nil
}

func (x *MACState) GetRecentDownlinks() []*MACState_DownlinkMessage {
	if x != nil {
		return x.RecentDownlinks
	}
	return nil
}

func (x *MACState) GetLastNetworkInitiatedDownlinkAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastNetworkInitiatedDownlinkAt
	}
	return nil
}

func (x *MACState) GetRejectedAdrDataRateIndexes() []DataRateIndex {
	if x != nil {
		return x.RejectedAdrDataRateIndexes
	}
	return nil
}

func (x *MACState) GetRejectedAdrTxPowerIndexes() []uint32 {
	if x != nil {
		return x.RejectedAdrTxPowerIndexes
	}
	return nil
}

func (x *MACState) GetRejectedFrequencies() []uint64 {
	if x != nil {
		return x.RejectedFrequencies
	}
	return nil
}

func (x *MACState) GetLastDownlinkAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastDownlinkAt
	}
	return nil
}

func (x *MACState) GetRejectedDataRateRanges() map[uint64]*MACState_DataRateRanges {
	if x != nil {
		return x.RejectedDataRateRanges
	}
	return nil
}

func (x *MACState) GetLastAdrChangeFCntUp() uint32 {
	if x != nil {
		return x.LastAdrChangeFCntUp
	}
	return 0
}

func (x *MACState) GetRecentMacCommandIdentifiers() []MACCommandIdentifier {
	if x != nil {
		return x.RecentMacCommandIdentifiers
	}
	return nil
}

func (x *MACState) GetPendingRelayDownlink() *RelayForwardDownlinkReq {
	if x != nil {
		return x.PendingRelayDownlink
	}
	return nil
}

// Authentication code for end devices.
type EndDeviceAuthenticationCode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value     string                 `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	ValidFrom *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=valid_from,json=validFrom,proto3" json:"valid_from,omitempty"`
	ValidTo   *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=valid_to,json=validTo,proto3" json:"valid_to,omitempty"`
}

func (x *EndDeviceAuthenticationCode) Reset() {
	*x = EndDeviceAuthenticationCode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceAuthenticationCode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceAuthenticationCode) ProtoMessage() {}

func (x *EndDeviceAuthenticationCode) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceAuthenticationCode.ProtoReflect.Descriptor instead.
func (*EndDeviceAuthenticationCode) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{16}
}

func (x *EndDeviceAuthenticationCode) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *EndDeviceAuthenticationCode) GetValidFrom() *timestamppb.Timestamp {
	if x != nil {
		return x.ValidFrom
	}
	return nil
}

func (x *EndDeviceAuthenticationCode) GetValidTo() *timestamppb.Timestamp {
	if x != nil {
		return x.ValidTo
	}
	return nil
}

// Defines an End Device registration and its state on the network.
// The persistence of the EndDevice is divided between the Network Server, Application Server and Join Server.
// SDKs are responsible for combining (if desired) the three.
type EndDevice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids       *EndDeviceIdentifiers  `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Friendly name of the device. Stored in Entity Registry.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the device. Stored in Entity Registry.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Key-value attributes for this end device. Typically used for organizing end devices or for storing integration-specific data. Stored in Entity Registry.
	Attributes map[string]string `protobuf:"bytes,6,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Version Identifiers. Stored in Entity Registry, Network Server and Application Server.
	VersionIds *EndDeviceVersionIdentifiers `protobuf:"bytes,7,opt,name=version_ids,json=versionIds,proto3" json:"version_ids,omitempty"`
	// Default service profile. Stored in Entity Registry.
	ServiceProfileId string `protobuf:"bytes,8,opt,name=service_profile_id,json=serviceProfileId,proto3" json:"service_profile_id,omitempty"`
	// The address of the Network Server where this device is supposed to be registered.
	// Stored in Entity Registry and Join Server.
	// The typical format of the address is "host:port". If the port is omitted,
	// the normal port inference (with DNS lookup, otherwise defaults) is used.
	// The connection shall be established with transport layer security (TLS).
	// Custom certificate authorities may be configured out-of-band.
	NetworkServerAddress string `protobuf:"bytes,9,opt,name=network_server_address,json=networkServerAddress,proto3" json:"network_server_address,omitempty"`
	// The KEK label of the Network Server to use for wrapping network session keys.
	// Stored in Join Server.
	NetworkServerKekLabel string `protobuf:"bytes,47,opt,name=network_server_kek_label,json=networkServerKekLabel,proto3" json:"network_server_kek_label,omitempty"`
	// The address of the Application Server where this device is supposed to be registered.
	// Stored in Entity Registry and Join Server.
	// The typical format of the address is "host:port". If the port is omitted,
	// the normal port inference (with DNS lookup, otherwise defaults) is used.
	// The connection shall be established with transport layer security (TLS).
	// Custom certificate authorities may be configured out-of-band.
	ApplicationServerAddress string `protobuf:"bytes,10,opt,name=application_server_address,json=applicationServerAddress,proto3" json:"application_server_address,omitempty"`
	// The KEK label of the Application Server to use for wrapping the application session key.
	// Stored in Join Server.
	ApplicationServerKekLabel string `protobuf:"bytes,48,opt,name=application_server_kek_label,json=applicationServerKekLabel,proto3" json:"application_server_kek_label,omitempty"`
	// The AS-ID of the Application Server to use.
	// Stored in Join Server.
	ApplicationServerId string `protobuf:"bytes,49,opt,name=application_server_id,json=applicationServerId,proto3" json:"application_server_id,omitempty"`
	// The address of the Join Server where this device is supposed to be registered.
	// Stored in Entity Registry.
	// The typical format of the address is "host:port". If the port is omitted,
	// the normal port inference (with DNS lookup, otherwise defaults) is used.
	// The connection shall be established with transport layer security (TLS).
	// Custom certificate authorities may be configured out-of-band.
	JoinServerAddress string `protobuf:"bytes,11,opt,name=join_server_address,json=joinServerAddress,proto3" json:"join_server_address,omitempty"`
	// Location of the device. Stored in Entity Registry.
	Locations map[string]*Location `protobuf:"bytes,12,rep,name=locations,proto3" json:"locations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Stored in Entity Registry.
	Picture *Picture `protobuf:"bytes,50,opt,name=picture,proto3" json:"picture,omitempty"`
	// Whether the device supports class B.
	// Copied on creation from template identified by version_ids, if any or from the home Network Server device profile, if any.
	SupportsClassB bool `protobuf:"varint,13,opt,name=supports_class_b,json=supportsClassB,proto3" json:"supports_class_b,omitempty"`
	// Whether the device supports class C.
	// Copied on creation from template identified by version_ids, if any or from the home Network Server device profile, if any.
	SupportsClassC bool `protobuf:"varint,14,opt,name=supports_class_c,json=supportsClassC,proto3" json:"supports_class_c,omitempty"`
	// LoRaWAN MAC version. Stored in Network Server.
	// Copied on creation from template identified by version_ids, if any or from the home Network Server device profile, if any.
	LorawanVersion MACVersion `protobuf:"varint,15,opt,name=lorawan_version,json=lorawanVersion,proto3,enum=ttn.lorawan.v3.MACVersion" json:"lorawan_version,omitempty"`
	// LoRaWAN PHY version. Stored in Network Server.
	// Copied on creation from template identified by version_ids, if any or from the home Network Server device profile, if any.
	LorawanPhyVersion PHYVersion `protobuf:"varint,16,opt,name=lorawan_phy_version,json=lorawanPhyVersion,proto3,enum=ttn.lorawan.v3.PHYVersion" json:"lorawan_phy_version,omitempty"`
	// ID of the frequency plan used by this device.
	// Copied on creation from template identified by version_ids, if any or from the home Network Server device profile, if any.
	FrequencyPlanId string `protobuf:"bytes,17,opt,name=frequency_plan_id,json=frequencyPlanId,proto3" json:"frequency_plan_id,omitempty"`
	// Minimum frequency the device is capable of using (Hz). Stored in Network Server.
	// Copied on creation from template identified by version_ids, if any or from the home Network Server device profile, if any.
	MinFrequency uint64 `protobuf:"varint,18,opt,name=min_frequency,json=minFrequency,proto3" json:"min_frequency,omitempty"`
	// Maximum frequency the device is capable of using (Hz). Stored in Network Server.
	// Copied on creation from template identified by version_ids, if any or from the home Network Server device profile, if any.
	MaxFrequency uint64 `protobuf:"varint,19,opt,name=max_frequency,json=maxFrequency,proto3" json:"max_frequency,omitempty"`
	// The device supports join (it's OTAA).
	// Copied on creation from template identified by version_ids, if any or from the home Network Server device profile, if any.
	SupportsJoin bool `protobuf:"varint,20,opt,name=supports_join,json=supportsJoin,proto3" json:"supports_join,omitempty"`
	// Whether the device resets the join and dev nonces (not LoRaWAN compliant). Stored in Join Server.
	// Copied on creation from template identified by version_ids, if any or from the home Network Server device profile, if any.
	ResetsJoinNonces bool `protobuf:"varint,21,opt,name=resets_join_nonces,json=resetsJoinNonces,proto3" json:"resets_join_nonces,omitempty"`
	// Device root keys. Stored in Join Server.
	RootKeys *RootKeys `protobuf:"bytes,22,opt,name=root_keys,json=rootKeys,proto3" json:"root_keys,omitempty"`
	// Home NetID. Stored in Join Server.
	NetId []byte `protobuf:"bytes,23,opt,name=net_id,json=netId,proto3" json:"net_id,omitempty"`
	// Settings for how the Network Server handles MAC layer for this device. Stored in Network Server.
	MacSettings *MACSettings `protobuf:"bytes,24,opt,name=mac_settings,json=macSettings,proto3" json:"mac_settings,omitempty"`
	// MAC state of the device. Stored in Network Server.
	MacState *MACState `protobuf:"bytes,25,opt,name=mac_state,json=macState,proto3" json:"mac_state,omitempty"`
	// Pending MAC state of the device. Stored in Network Server.
	PendingMacState *MACState `protobuf:"bytes,44,opt,name=pending_mac_state,json=pendingMacState,proto3" json:"pending_mac_state,omitempty"`
	// Current session of the device. Stored in Network Server and Application Server.
	Session *Session `protobuf:"bytes,26,opt,name=session,proto3" json:"session,omitempty"`
	// Pending session. Stored in Network Server and Application Server until RekeyInd is received.
	PendingSession *Session `protobuf:"bytes,27,opt,name=pending_session,json=pendingSession,proto3" json:"pending_session,omitempty"`
	// Last DevNonce used.
	// This field is only used for devices using LoRaWAN version 1.1 and later.
	// Stored in Join Server.
	LastDevNonce uint32 `protobuf:"varint,28,opt,name=last_dev_nonce,json=lastDevNonce,proto3" json:"last_dev_nonce,omitempty"`
	// Used DevNonces sorted in ascending order.
	// This field is only used for devices using LoRaWAN versions preceding 1.1.
	// Stored in Join Server.
	UsedDevNonces []uint32 `protobuf:"varint,29,rep,packed,name=used_dev_nonces,json=usedDevNonces,proto3" json:"used_dev_nonces,omitempty"`
	// Last JoinNonce/AppNonce(for devices using LoRaWAN versions preceding 1.1) used.
	// Stored in Join Server.
	LastJoinNonce uint32 `protobuf:"varint,30,opt,name=last_join_nonce,json=lastJoinNonce,proto3" json:"last_join_nonce,omitempty"`
	// Last Rejoin counter value used (type 0/2).
	// Stored in Join Server.
	LastRjCount_0 uint32 `protobuf:"varint,31,opt,name=last_rj_count_0,json=lastRjCount0,proto3" json:"last_rj_count_0,omitempty"`
	// Last Rejoin counter value used (type 1).
	// Stored in Join Server.
	LastRjCount_1 uint32 `protobuf:"varint,32,opt,name=last_rj_count_1,json=lastRjCount1,proto3" json:"last_rj_count_1,omitempty"`
	// Time when last DevStatus MAC command was received.
	// Stored in Network Server.
	LastDevStatusReceivedAt *timestamppb.Timestamp `protobuf:"bytes,33,opt,name=last_dev_status_received_at,json=lastDevStatusReceivedAt,proto3" json:"last_dev_status_received_at,omitempty"`
	// The power state of the device; whether it is battery-powered or connected to an external power source.
	// Received via the DevStatus MAC command at status_received_at.
	// Stored in Network Server.
	PowerState PowerState `protobuf:"varint,34,opt,name=power_state,json=powerState,proto3,enum=ttn.lorawan.v3.PowerState" json:"power_state,omitempty"`
	// Latest-known battery percentage of the device.
	// Received via the DevStatus MAC command at last_dev_status_received_at or earlier.
	// Stored in Network Server.
	BatteryPercentage *wrapperspb.FloatValue `protobuf:"bytes,35,opt,name=battery_percentage,json=batteryPercentage,proto3" json:"battery_percentage,omitempty"`
	// Demodulation signal-to-noise ratio (dB).
	// Received via the DevStatus MAC command at last_dev_status_received_at.
	// Stored in Network Server.
	DownlinkMargin int32 `protobuf:"varint,36,opt,name=downlink_margin,json=downlinkMargin,proto3" json:"downlink_margin,omitempty"`
	// Queued Application downlink messages. Stored in Application Server,
	// which sets them on the Network Server.
	// This field is deprecated and is always set equal to session.queued_application_downlinks.
	QueuedApplicationDownlinks []*ApplicationDownlink `protobuf:"bytes,40,rep,name=queued_application_downlinks,json=queuedApplicationDownlinks,proto3" json:"queued_application_downlinks,omitempty"`
	// The payload formatters for this end device. Stored in Application Server.
	// Copied on creation from template identified by version_ids.
	Formatters *MessagePayloadFormatters `protobuf:"bytes,41,opt,name=formatters,proto3" json:"formatters,omitempty"`
	// ID of the provisioner. Stored in Join Server.
	ProvisionerId string `protobuf:"bytes,42,opt,name=provisioner_id,json=provisionerId,proto3" json:"provisioner_id,omitempty"`
	// Vendor-specific provisioning data. Stored in Join Server.
	ProvisioningData *structpb.Struct `protobuf:"bytes,43,opt,name=provisioning_data,json=provisioningData,proto3" json:"provisioning_data,omitempty"`
	// Indicates whether this device represents a multicast group.
	Multicast bool `protobuf:"varint,45,opt,name=multicast,proto3" json:"multicast,omitempty"`
	// Authentication code to claim ownership of the end device.
	// From TTS v3.21.0 this field is stored in the Identity Server.
	// For TTS versions < 3.21.0, this field is stored in the Join Server.
	// The value stored on the Identity Server takes precedence.
	ClaimAuthenticationCode *EndDeviceAuthenticationCode `protobuf:"bytes,46,opt,name=claim_authentication_code,json=claimAuthenticationCode,proto3" json:"claim_authentication_code,omitempty"`
	// Skip decryption of uplink payloads and encryption of downlink payloads.
	// This field is deprecated, use skip_payload_crypto_override instead.
	SkipPayloadCrypto bool `protobuf:"varint,51,opt,name=skip_payload_crypto,json=skipPayloadCrypto,proto3" json:"skip_payload_crypto,omitempty"`
	// Skip decryption of uplink payloads and encryption of downlink payloads.
	// This field overrides the application-level setting.
	SkipPayloadCryptoOverride *wrapperspb.BoolValue `protobuf:"bytes,52,opt,name=skip_payload_crypto_override,json=skipPayloadCryptoOverride,proto3" json:"skip_payload_crypto_override,omitempty"`
	// Timestamp when the device has been activated. Stored in the Entity Registry.
	// This field is set by the Application Server when an end device sends
	// its first uplink.
	// The Application Server will use the field in order to avoid repeated
	// calls to the Entity Registry.
	// The field cannot be unset once set.
	ActivatedAt *timestamppb.Timestamp `protobuf:"bytes,53,opt,name=activated_at,json=activatedAt,proto3" json:"activated_at,omitempty"`
	// Timestamp when a device uplink has been last observed.
	// This field is set by the Application Server and stored in the Identity Server.
	LastSeenAt             *timestamppb.Timestamp          `protobuf:"bytes,54,opt,name=last_seen_at,json=lastSeenAt,proto3" json:"last_seen_at,omitempty"`
	SerialNumber           string                          `protobuf:"bytes,55,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	LoraAllianceProfileIds *LoRaAllianceProfileIdentifiers `protobuf:"bytes,56,opt,name=lora_alliance_profile_ids,json=loraAllianceProfileIds,proto3" json:"lora_alliance_profile_ids,omitempty"`
}

func (x *EndDevice) Reset() {
	*x = EndDevice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDevice) ProtoMessage() {}

func (x *EndDevice) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDevice.ProtoReflect.Descriptor instead.
func (*EndDevice) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{17}
}

func (x *EndDevice) GetIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *EndDevice) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *EndDevice) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *EndDevice) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EndDevice) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EndDevice) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *EndDevice) GetVersionIds() *EndDeviceVersionIdentifiers {
	if x != nil {
		return x.VersionIds
	}
	return nil
}

func (x *EndDevice) GetServiceProfileId() string {
	if x != nil {
		return x.ServiceProfileId
	}
	return ""
}

func (x *EndDevice) GetNetworkServerAddress() string {
	if x != nil {
		return x.NetworkServerAddress
	}
	return ""
}

func (x *EndDevice) GetNetworkServerKekLabel() string {
	if x != nil {
		return x.NetworkServerKekLabel
	}
	return ""
}

func (x *EndDevice) GetApplicationServerAddress() string {
	if x != nil {
		return x.ApplicationServerAddress
	}
	return ""
}

func (x *EndDevice) GetApplicationServerKekLabel() string {
	if x != nil {
		return x.ApplicationServerKekLabel
	}
	return ""
}

func (x *EndDevice) GetApplicationServerId() string {
	if x != nil {
		return x.ApplicationServerId
	}
	return ""
}

func (x *EndDevice) GetJoinServerAddress() string {
	if x != nil {
		return x.JoinServerAddress
	}
	return ""
}

func (x *EndDevice) GetLocations() map[string]*Location {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *EndDevice) GetPicture() *Picture {
	if x != nil {
		return x.Picture
	}
	return nil
}

func (x *EndDevice) GetSupportsClassB() bool {
	if x != nil {
		return x.SupportsClassB
	}
	return false
}

func (x *EndDevice) GetSupportsClassC() bool {
	if x != nil {
		return x.SupportsClassC
	}
	return false
}

func (x *EndDevice) GetLorawanVersion() MACVersion {
	if x != nil {
		return x.LorawanVersion
	}
	return MACVersion_MAC_UNKNOWN
}

func (x *EndDevice) GetLorawanPhyVersion() PHYVersion {
	if x != nil {
		return x.LorawanPhyVersion
	}
	return PHYVersion_PHY_UNKNOWN
}

func (x *EndDevice) GetFrequencyPlanId() string {
	if x != nil {
		return x.FrequencyPlanId
	}
	return ""
}

func (x *EndDevice) GetMinFrequency() uint64 {
	if x != nil {
		return x.MinFrequency
	}
	return 0
}

func (x *EndDevice) GetMaxFrequency() uint64 {
	if x != nil {
		return x.MaxFrequency
	}
	return 0
}

func (x *EndDevice) GetSupportsJoin() bool {
	if x != nil {
		return x.SupportsJoin
	}
	return false
}

func (x *EndDevice) GetResetsJoinNonces() bool {
	if x != nil {
		return x.ResetsJoinNonces
	}
	return false
}

func (x *EndDevice) GetRootKeys() *RootKeys {
	if x != nil {
		return x.RootKeys
	}
	return nil
}

func (x *EndDevice) GetNetId() []byte {
	if x != nil {
		return x.NetId
	}
	return nil
}

func (x *EndDevice) GetMacSettings() *MACSettings {
	if x != nil {
		return x.MacSettings
	}
	return nil
}

func (x *EndDevice) GetMacState() *MACState {
	if x != nil {
		return x.MacState
	}
	return nil
}

func (x *EndDevice) GetPendingMacState() *MACState {
	if x != nil {
		return x.PendingMacState
	}
	return nil
}

func (x *EndDevice) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *EndDevice) GetPendingSession() *Session {
	if x != nil {
		return x.PendingSession
	}
	return nil
}

func (x *EndDevice) GetLastDevNonce() uint32 {
	if x != nil {
		return x.LastDevNonce
	}
	return 0
}

func (x *EndDevice) GetUsedDevNonces() []uint32 {
	if x != nil {
		return x.UsedDevNonces
	}
	return nil
}

func (x *EndDevice) GetLastJoinNonce() uint32 {
	if x != nil {
		return x.LastJoinNonce
	}
	return 0
}

func (x *EndDevice) GetLastRjCount_0() uint32 {
	if x != nil {
		return x.LastRjCount_0
	}
	return 0
}

func (x *EndDevice) GetLastRjCount_1() uint32 {
	if x != nil {
		return x.LastRjCount_1
	}
	return 0
}

func (x *EndDevice) GetLastDevStatusReceivedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastDevStatusReceivedAt
	}
	return nil
}

func (x *EndDevice) GetPowerState() PowerState {
	if x != nil {
		return x.PowerState
	}
	return PowerState_POWER_UNKNOWN
}

func (x *EndDevice) GetBatteryPercentage() *wrapperspb.FloatValue {
	if x != nil {
		return x.BatteryPercentage
	}
	return nil
}

func (x *EndDevice) GetDownlinkMargin() int32 {
	if x != nil {
		return x.DownlinkMargin
	}
	return 0
}

func (x *EndDevice) GetQueuedApplicationDownlinks() []*ApplicationDownlink {
	if x != nil {
		return x.QueuedApplicationDownlinks
	}
	return nil
}

func (x *EndDevice) GetFormatters() *MessagePayloadFormatters {
	if x != nil {
		return x.Formatters
	}
	return nil
}

func (x *EndDevice) GetProvisionerId() string {
	if x != nil {
		return x.ProvisionerId
	}
	return ""
}

func (x *EndDevice) GetProvisioningData() *structpb.Struct {
	if x != nil {
		return x.ProvisioningData
	}
	return nil
}

func (x *EndDevice) GetMulticast() bool {
	if x != nil {
		return x.Multicast
	}
	return false
}

func (x *EndDevice) GetClaimAuthenticationCode() *EndDeviceAuthenticationCode {
	if x != nil {
		return x.ClaimAuthenticationCode
	}
	return nil
}

func (x *EndDevice) GetSkipPayloadCrypto() bool {
	if x != nil {
		return x.SkipPayloadCrypto
	}
	return false
}

func (x *EndDevice) GetSkipPayloadCryptoOverride() *wrapperspb.BoolValue {
	if x != nil {
		return x.SkipPayloadCryptoOverride
	}
	return nil
}

func (x *EndDevice) GetActivatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ActivatedAt
	}
	return nil
}

func (x *EndDevice) GetLastSeenAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastSeenAt
	}
	return nil
}

func (x *EndDevice) GetSerialNumber() string {
	if x != nil {
		return x.SerialNumber
	}
	return ""
}

func (x *EndDevice) GetLoraAllianceProfileIds() *LoRaAllianceProfileIdentifiers {
	if x != nil {
		return x.LoraAllianceProfileIds
	}
	return nil
}

type EndDevices struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EndDevices []*EndDevice `protobuf:"bytes,1,rep,name=end_devices,json=endDevices,proto3" json:"end_devices,omitempty"`
}

func (x *EndDevices) Reset() {
	*x = EndDevices{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDevices) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDevices) ProtoMessage() {}

func (x *EndDevices) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDevices.ProtoReflect.Descriptor instead.
func (*EndDevices) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{18}
}

func (x *EndDevices) GetEndDevices() []*EndDevice {
	if x != nil {
		return x.EndDevices
	}
	return nil
}

type DevAddrPrefix struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DevAddr base.
	DevAddr []byte `protobuf:"bytes,1,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	// Number of most significant bits from dev_addr that are used as prefix.
	Length uint32 `protobuf:"varint,2,opt,name=length,proto3" json:"length,omitempty"`
}

func (x *DevAddrPrefix) Reset() {
	*x = DevAddrPrefix{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DevAddrPrefix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DevAddrPrefix) ProtoMessage() {}

func (x *DevAddrPrefix) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DevAddrPrefix.ProtoReflect.Descriptor instead.
func (*DevAddrPrefix) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{19}
}

func (x *DevAddrPrefix) GetDevAddr() []byte {
	if x != nil {
		return x.DevAddr
	}
	return nil
}

func (x *DevAddrPrefix) GetLength() uint32 {
	if x != nil {
		return x.Length
	}
	return 0
}

type CreateEndDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EndDevice *EndDevice `protobuf:"bytes,1,opt,name=end_device,json=endDevice,proto3" json:"end_device,omitempty"`
}

func (x *CreateEndDeviceRequest) Reset() {
	*x = CreateEndDeviceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEndDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEndDeviceRequest) ProtoMessage() {}

func (x *CreateEndDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEndDeviceRequest.ProtoReflect.Descriptor instead.
func (*CreateEndDeviceRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{20}
}

func (x *CreateEndDeviceRequest) GetEndDevice() *EndDevice {
	if x != nil {
		return x.EndDevice
	}
	return nil
}

type UpdateEndDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EndDevice *EndDevice `protobuf:"bytes,1,opt,name=end_device,json=endDevice,proto3" json:"end_device,omitempty"`
	// The names of the end device fields that should be updated.
	// See the API reference for which fields can be set on the different services.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *UpdateEndDeviceRequest) Reset() {
	*x = UpdateEndDeviceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEndDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEndDeviceRequest) ProtoMessage() {}

func (x *UpdateEndDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEndDeviceRequest.ProtoReflect.Descriptor instead.
func (*UpdateEndDeviceRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{21}
}

func (x *UpdateEndDeviceRequest) GetEndDevice() *EndDevice {
	if x != nil {
		return x.EndDevice
	}
	return nil
}

func (x *UpdateEndDeviceRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type BatchUpdateEndDeviceLastSeenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The last seen timestamp needs to be set per end device.
	Updates []*BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate `protobuf:"bytes,1,rep,name=updates,proto3" json:"updates,omitempty"`
}

func (x *BatchUpdateEndDeviceLastSeenRequest) Reset() {
	*x = BatchUpdateEndDeviceLastSeenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateEndDeviceLastSeenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateEndDeviceLastSeenRequest) ProtoMessage() {}

func (x *BatchUpdateEndDeviceLastSeenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateEndDeviceLastSeenRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdateEndDeviceLastSeenRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{22}
}

func (x *BatchUpdateEndDeviceLastSeenRequest) GetUpdates() []*BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate {
	if x != nil {
		return x.Updates
	}
	return nil
}

type GetEndDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EndDeviceIds *EndDeviceIdentifiers `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	// The names of the end device fields that should be returned.
	// See the API reference for which fields can be returned by the different services.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetEndDeviceRequest) Reset() {
	*x = GetEndDeviceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEndDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEndDeviceRequest) ProtoMessage() {}

func (x *GetEndDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEndDeviceRequest.ProtoReflect.Descriptor instead.
func (*GetEndDeviceRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{23}
}

func (x *GetEndDeviceRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *GetEndDeviceRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type GetEndDeviceIdentifiersForEUIsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JoinEui []byte `protobuf:"bytes,1,opt,name=join_eui,json=joinEui,proto3" json:"join_eui,omitempty"`
	DevEui  []byte `protobuf:"bytes,2,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
}

func (x *GetEndDeviceIdentifiersForEUIsRequest) Reset() {
	*x = GetEndDeviceIdentifiersForEUIsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEndDeviceIdentifiersForEUIsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEndDeviceIdentifiersForEUIsRequest) ProtoMessage() {}

func (x *GetEndDeviceIdentifiersForEUIsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEndDeviceIdentifiersForEUIsRequest.ProtoReflect.Descriptor instead.
func (*GetEndDeviceIdentifiersForEUIsRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{24}
}

func (x *GetEndDeviceIdentifiersForEUIsRequest) GetJoinEui() []byte {
	if x != nil {
		return x.JoinEui
	}
	return nil
}

func (x *GetEndDeviceIdentifiersForEUIsRequest) GetDevEui() []byte {
	if x != nil {
		return x.DevEui
	}
	return nil
}

type ListEndDevicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	// The names of the end device fields that should be returned.
	// See the API reference for which fields can be returned by the different services.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// Order the results by this field path (must be present in the field mask).
	// Default ordering is by ID. Prepend with a minus (-) to reverse the order.
	Order string `protobuf:"bytes,3,opt,name=order,proto3" json:"order,omitempty"`
	// Limit the number of results per page.
	Limit uint32 `protobuf:"varint,4,opt,name=limit,proto3" json:"limit,omitempty"`
	// Page number for pagination. 0 is interpreted as 1.
	Page    uint32                          `protobuf:"varint,5,opt,name=page,proto3" json:"page,omitempty"`
	Filters []*ListEndDevicesRequest_Filter `protobuf:"bytes,6,rep,name=filters,proto3" json:"filters,omitempty"`
}

func (x *ListEndDevicesRequest) Reset() {
	*x = ListEndDevicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEndDevicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEndDevicesRequest) ProtoMessage() {}

func (x *ListEndDevicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEndDevicesRequest.ProtoReflect.Descriptor instead.
func (*ListEndDevicesRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{25}
}

func (x *ListEndDevicesRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *ListEndDevicesRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

func (x *ListEndDevicesRequest) GetOrder() string {
	if x != nil {
		return x.Order
	}
	return ""
}

func (x *ListEndDevicesRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ListEndDevicesRequest) GetPage() uint32 {
	if x != nil {
		return x.Page
	}
	return 0
}

func (x *ListEndDevicesRequest) GetFilters() []*ListEndDevicesRequest_Filter {
	if x != nil {
		return x.Filters
	}
	return nil
}

type SetEndDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EndDevice *EndDevice `protobuf:"bytes,1,opt,name=end_device,json=endDevice,proto3" json:"end_device,omitempty"`
	// The names of the end device fields that should be updated.
	// See the API reference for which fields can be set on the different services.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *SetEndDeviceRequest) Reset() {
	*x = SetEndDeviceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetEndDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetEndDeviceRequest) ProtoMessage() {}

func (x *SetEndDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetEndDeviceRequest.ProtoReflect.Descriptor instead.
func (*SetEndDeviceRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{26}
}

func (x *SetEndDeviceRequest) GetEndDevice() *EndDevice {
	if x != nil {
		return x.EndDevice
	}
	return nil
}

func (x *SetEndDeviceRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type ResetAndGetEndDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EndDeviceIds *EndDeviceIdentifiers `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	// The names of the end device fields that should be returned.
	// See the API reference for which fields can be returned by the different services.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *ResetAndGetEndDeviceRequest) Reset() {
	*x = ResetAndGetEndDeviceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetAndGetEndDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetAndGetEndDeviceRequest) ProtoMessage() {}

func (x *ResetAndGetEndDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetAndGetEndDeviceRequest.ProtoReflect.Descriptor instead.
func (*ResetAndGetEndDeviceRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{27}
}

func (x *ResetAndGetEndDeviceRequest) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *ResetAndGetEndDeviceRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type EndDeviceTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EndDevice  *EndDevice             `protobuf:"bytes,1,opt,name=end_device,json=endDevice,proto3" json:"end_device,omitempty"`
	FieldMask  *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	MappingKey string                 `protobuf:"bytes,3,opt,name=mapping_key,json=mappingKey,proto3" json:"mapping_key,omitempty"`
}

func (x *EndDeviceTemplate) Reset() {
	*x = EndDeviceTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceTemplate) ProtoMessage() {}

func (x *EndDeviceTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceTemplate.ProtoReflect.Descriptor instead.
func (*EndDeviceTemplate) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{28}
}

func (x *EndDeviceTemplate) GetEndDevice() *EndDevice {
	if x != nil {
		return x.EndDevice
	}
	return nil
}

func (x *EndDeviceTemplate) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

func (x *EndDeviceTemplate) GetMappingKey() string {
	if x != nil {
		return x.MappingKey
	}
	return ""
}

type EndDeviceTemplateFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name           string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Description    string   `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	FileExtensions []string `protobuf:"bytes,3,rep,name=file_extensions,json=fileExtensions,proto3" json:"file_extensions,omitempty"`
}

func (x *EndDeviceTemplateFormat) Reset() {
	*x = EndDeviceTemplateFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceTemplateFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceTemplateFormat) ProtoMessage() {}

func (x *EndDeviceTemplateFormat) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceTemplateFormat.ProtoReflect.Descriptor instead.
func (*EndDeviceTemplateFormat) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{29}
}

func (x *EndDeviceTemplateFormat) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EndDeviceTemplateFormat) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EndDeviceTemplateFormat) GetFileExtensions() []string {
	if x != nil {
		return x.FileExtensions
	}
	return nil
}

type EndDeviceTemplateFormats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Formats map[string]*EndDeviceTemplateFormat `protobuf:"bytes,1,rep,name=formats,proto3" json:"formats,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *EndDeviceTemplateFormats) Reset() {
	*x = EndDeviceTemplateFormats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceTemplateFormats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceTemplateFormats) ProtoMessage() {}

func (x *EndDeviceTemplateFormats) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceTemplateFormats.ProtoReflect.Descriptor instead.
func (*EndDeviceTemplateFormats) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{30}
}

func (x *EndDeviceTemplateFormats) GetFormats() map[string]*EndDeviceTemplateFormat {
	if x != nil {
		return x.Formats
	}
	return nil
}

type ConvertEndDeviceTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the format.
	FormatId string `protobuf:"bytes,1,opt,name=format_id,json=formatId,proto3" json:"format_id,omitempty"`
	// Data to convert.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	// End device profile identifiers.
	EndDeviceVersionIds *EndDeviceVersionIdentifiers `protobuf:"bytes,3,opt,name=end_device_version_ids,json=endDeviceVersionIds,proto3" json:"end_device_version_ids,omitempty"`
}

func (x *ConvertEndDeviceTemplateRequest) Reset() {
	*x = ConvertEndDeviceTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConvertEndDeviceTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConvertEndDeviceTemplateRequest) ProtoMessage() {}

func (x *ConvertEndDeviceTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConvertEndDeviceTemplateRequest.ProtoReflect.Descriptor instead.
func (*ConvertEndDeviceTemplateRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{31}
}

func (x *ConvertEndDeviceTemplateRequest) GetFormatId() string {
	if x != nil {
		return x.FormatId
	}
	return ""
}

func (x *ConvertEndDeviceTemplateRequest) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *ConvertEndDeviceTemplateRequest) GetEndDeviceVersionIds() *EndDeviceVersionIdentifiers {
	if x != nil {
		return x.EndDeviceVersionIds
	}
	return nil
}

type BatchDeleteEndDevicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	DeviceIds      []string                `protobuf:"bytes,2,rep,name=device_ids,json=deviceIds,proto3" json:"device_ids,omitempty"`
}

func (x *BatchDeleteEndDevicesRequest) Reset() {
	*x = BatchDeleteEndDevicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeleteEndDevicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteEndDevicesRequest) ProtoMessage() {}

func (x *BatchDeleteEndDevicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteEndDevicesRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteEndDevicesRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{32}
}

func (x *BatchDeleteEndDevicesRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *BatchDeleteEndDevicesRequest) GetDeviceIds() []string {
	if x != nil {
		return x.DeviceIds
	}
	return nil
}

type BatchGetEndDevicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	DeviceIds      []string                `protobuf:"bytes,2,rep,name=device_ids,json=deviceIds,proto3" json:"device_ids,omitempty"`
	// The names of the end device fields that should be returned.
	// This mask is applied on all the end devices in the result.
	// See the API reference for which fields can be returned by the different services.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *BatchGetEndDevicesRequest) Reset() {
	*x = BatchGetEndDevicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetEndDevicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetEndDevicesRequest) ProtoMessage() {}

func (x *BatchGetEndDevicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetEndDevicesRequest.ProtoReflect.Descriptor instead.
func (*BatchGetEndDevicesRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{33}
}

func (x *BatchGetEndDevicesRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *BatchGetEndDevicesRequest) GetDeviceIds() []string {
	if x != nil {
		return x.DeviceIds
	}
	return nil
}

func (x *BatchGetEndDevicesRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type MACParameters_Channel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uplink frequency of the channel (Hz).
	UplinkFrequency uint64 `protobuf:"varint,1,opt,name=uplink_frequency,json=uplinkFrequency,proto3" json:"uplink_frequency,omitempty"`
	// Downlink frequency of the channel (Hz).
	DownlinkFrequency uint64 `protobuf:"varint,2,opt,name=downlink_frequency,json=downlinkFrequency,proto3" json:"downlink_frequency,omitempty"`
	// Index of the minimum data rate for uplink.
	MinDataRateIndex DataRateIndex `protobuf:"varint,3,opt,name=min_data_rate_index,json=minDataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"min_data_rate_index,omitempty"`
	// Index of the maximum data rate for uplink.
	MaxDataRateIndex DataRateIndex `protobuf:"varint,4,opt,name=max_data_rate_index,json=maxDataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"max_data_rate_index,omitempty"`
	// Channel can be used by device for uplink.
	EnableUplink bool `protobuf:"varint,5,opt,name=enable_uplink,json=enableUplink,proto3" json:"enable_uplink,omitempty"`
}

func (x *MACParameters_Channel) Reset() {
	*x = MACParameters_Channel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACParameters_Channel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACParameters_Channel) ProtoMessage() {}

func (x *MACParameters_Channel) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACParameters_Channel.ProtoReflect.Descriptor instead.
func (*MACParameters_Channel) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{10, 0}
}

func (x *MACParameters_Channel) GetUplinkFrequency() uint64 {
	if x != nil {
		return x.UplinkFrequency
	}
	return 0
}

func (x *MACParameters_Channel) GetDownlinkFrequency() uint64 {
	if x != nil {
		return x.DownlinkFrequency
	}
	return 0
}

func (x *MACParameters_Channel) GetMinDataRateIndex() DataRateIndex {
	if x != nil {
		return x.MinDataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *MACParameters_Channel) GetMaxDataRateIndex() DataRateIndex {
	if x != nil {
		return x.MaxDataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *MACParameters_Channel) GetEnableUplink() bool {
	if x != nil {
		return x.EnableUplink
	}
	return false
}

// Configuration options for static ADR.
type ADRSettings_StaticMode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data rate index to use.
	DataRateIndex DataRateIndex `protobuf:"varint,1,opt,name=data_rate_index,json=dataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"data_rate_index,omitempty"`
	// Transmission power index to use.
	TxPowerIndex uint32 `protobuf:"varint,2,opt,name=tx_power_index,json=txPowerIndex,proto3" json:"tx_power_index,omitempty"`
	// Number of retransmissions.
	NbTrans uint32 `protobuf:"varint,3,opt,name=nb_trans,json=nbTrans,proto3" json:"nb_trans,omitempty"`
}

func (x *ADRSettings_StaticMode) Reset() {
	*x = ADRSettings_StaticMode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ADRSettings_StaticMode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ADRSettings_StaticMode) ProtoMessage() {}

func (x *ADRSettings_StaticMode) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ADRSettings_StaticMode.ProtoReflect.Descriptor instead.
func (*ADRSettings_StaticMode) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{12, 0}
}

func (x *ADRSettings_StaticMode) GetDataRateIndex() DataRateIndex {
	if x != nil {
		return x.DataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *ADRSettings_StaticMode) GetTxPowerIndex() uint32 {
	if x != nil {
		return x.TxPowerIndex
	}
	return 0
}

func (x *ADRSettings_StaticMode) GetNbTrans() uint32 {
	if x != nil {
		return x.NbTrans
	}
	return 0
}

// Configuration options for dynamic ADR.
type ADRSettings_DynamicMode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ADR margin (dB) tells the network server how much margin it should add in ADR requests.
	// A bigger margin is less efficient, but gives a better chance of successful reception.
	// If unset, the default value from Network Server configuration will be used.
	Margin *wrapperspb.FloatValue `protobuf:"bytes,1,opt,name=margin,proto3" json:"margin,omitempty"`
	// Minimum data rate index.
	// If unset, the default value from Network Server configuration will be used.
	MinDataRateIndex *DataRateIndexValue `protobuf:"bytes,2,opt,name=min_data_rate_index,json=minDataRateIndex,proto3" json:"min_data_rate_index,omitempty"`
	// Maximum data rate index.
	// If unset, the default value from Network Server configuration will be used.
	MaxDataRateIndex *DataRateIndexValue `protobuf:"bytes,3,opt,name=max_data_rate_index,json=maxDataRateIndex,proto3" json:"max_data_rate_index,omitempty"`
	// Minimum transmission power index.
	// If unset, the default value from Network Server configuration will be used.
	MinTxPowerIndex *wrapperspb.UInt32Value `protobuf:"bytes,4,opt,name=min_tx_power_index,json=minTxPowerIndex,proto3" json:"min_tx_power_index,omitempty"`
	// Maximum transmission power index.
	// If unset, the default value from Network Server configuration will be used.
	MaxTxPowerIndex *wrapperspb.UInt32Value `protobuf:"bytes,5,opt,name=max_tx_power_index,json=maxTxPowerIndex,proto3" json:"max_tx_power_index,omitempty"`
	// Minimum number of retransmissions.
	// If unset, the default value from Network Server configuration will be used.
	MinNbTrans *wrapperspb.UInt32Value `protobuf:"bytes,6,opt,name=min_nb_trans,json=minNbTrans,proto3" json:"min_nb_trans,omitempty"`
	// Maximum number of retransmissions.
	// If unset, the default value from Network Server configuration will be used.
	MaxNbTrans      *wrapperspb.UInt32Value                          `protobuf:"bytes,7,opt,name=max_nb_trans,json=maxNbTrans,proto3" json:"max_nb_trans,omitempty"`
	ChannelSteering *ADRSettings_DynamicMode_ChannelSteeringSettings `protobuf:"bytes,8,opt,name=channel_steering,json=channelSteering,proto3" json:"channel_steering,omitempty"`
	Overrides       *ADRSettings_DynamicMode_Overrides               `protobuf:"bytes,9,opt,name=overrides,proto3" json:"overrides,omitempty"`
}

func (x *ADRSettings_DynamicMode) Reset() {
	*x = ADRSettings_DynamicMode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ADRSettings_DynamicMode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ADRSettings_DynamicMode) ProtoMessage() {}

func (x *ADRSettings_DynamicMode) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ADRSettings_DynamicMode.ProtoReflect.Descriptor instead.
func (*ADRSettings_DynamicMode) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{12, 1}
}

func (x *ADRSettings_DynamicMode) GetMargin() *wrapperspb.FloatValue {
	if x != nil {
		return x.Margin
	}
	return nil
}

func (x *ADRSettings_DynamicMode) GetMinDataRateIndex() *DataRateIndexValue {
	if x != nil {
		return x.MinDataRateIndex
	}
	return nil
}

func (x *ADRSettings_DynamicMode) GetMaxDataRateIndex() *DataRateIndexValue {
	if x != nil {
		return x.MaxDataRateIndex
	}
	return nil
}

func (x *ADRSettings_DynamicMode) GetMinTxPowerIndex() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MinTxPowerIndex
	}
	return nil
}

func (x *ADRSettings_DynamicMode) GetMaxTxPowerIndex() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxTxPowerIndex
	}
	return nil
}

func (x *ADRSettings_DynamicMode) GetMinNbTrans() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MinNbTrans
	}
	return nil
}

func (x *ADRSettings_DynamicMode) GetMaxNbTrans() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxNbTrans
	}
	return nil
}

func (x *ADRSettings_DynamicMode) GetChannelSteering() *ADRSettings_DynamicMode_ChannelSteeringSettings {
	if x != nil {
		return x.ChannelSteering
	}
	return nil
}

func (x *ADRSettings_DynamicMode) GetOverrides() *ADRSettings_DynamicMode_Overrides {
	if x != nil {
		return x.Overrides
	}
	return nil
}

// Configuration options for cases in which ADR is to be disabled
// completely.
type ADRSettings_DisabledMode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ADRSettings_DisabledMode) Reset() {
	*x = ADRSettings_DisabledMode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ADRSettings_DisabledMode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ADRSettings_DisabledMode) ProtoMessage() {}

func (x *ADRSettings_DisabledMode) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ADRSettings_DisabledMode.ProtoReflect.Descriptor instead.
func (*ADRSettings_DisabledMode) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{12, 2}
}

// EXPERIMENTAL: Channel steering settings.
type ADRSettings_DynamicMode_ChannelSteeringSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Mode:
	//	*ADRSettings_DynamicMode_ChannelSteeringSettings_LoraNarrow
	//	*ADRSettings_DynamicMode_ChannelSteeringSettings_Disabled
	Mode isADRSettings_DynamicMode_ChannelSteeringSettings_Mode `protobuf_oneof:"mode"`
}

func (x *ADRSettings_DynamicMode_ChannelSteeringSettings) Reset() {
	*x = ADRSettings_DynamicMode_ChannelSteeringSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ADRSettings_DynamicMode_ChannelSteeringSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ADRSettings_DynamicMode_ChannelSteeringSettings) ProtoMessage() {}

func (x *ADRSettings_DynamicMode_ChannelSteeringSettings) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ADRSettings_DynamicMode_ChannelSteeringSettings.ProtoReflect.Descriptor instead.
func (*ADRSettings_DynamicMode_ChannelSteeringSettings) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{12, 1, 0}
}

func (m *ADRSettings_DynamicMode_ChannelSteeringSettings) GetMode() isADRSettings_DynamicMode_ChannelSteeringSettings_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (x *ADRSettings_DynamicMode_ChannelSteeringSettings) GetLoraNarrow() *ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode {
	if x, ok := x.GetMode().(*ADRSettings_DynamicMode_ChannelSteeringSettings_LoraNarrow); ok {
		return x.LoraNarrow
	}
	return nil
}

func (x *ADRSettings_DynamicMode_ChannelSteeringSettings) GetDisabled() *ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode {
	if x, ok := x.GetMode().(*ADRSettings_DynamicMode_ChannelSteeringSettings_Disabled); ok {
		return x.Disabled
	}
	return nil
}

type isADRSettings_DynamicMode_ChannelSteeringSettings_Mode interface {
	isADRSettings_DynamicMode_ChannelSteeringSettings_Mode()
}

type ADRSettings_DynamicMode_ChannelSteeringSettings_LoraNarrow struct {
	LoraNarrow *ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode `protobuf:"bytes,1,opt,name=lora_narrow,json=loraNarrow,proto3,oneof"`
}

type ADRSettings_DynamicMode_ChannelSteeringSettings_Disabled struct {
	Disabled *ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode `protobuf:"bytes,2,opt,name=disabled,proto3,oneof"`
}

func (*ADRSettings_DynamicMode_ChannelSteeringSettings_LoraNarrow) isADRSettings_DynamicMode_ChannelSteeringSettings_Mode() {
}

func (*ADRSettings_DynamicMode_ChannelSteeringSettings_Disabled) isADRSettings_DynamicMode_ChannelSteeringSettings_Mode() {
}

// EXPERIMENTAL: Data rate index override settings.
type ADRSettings_DynamicMode_PerDataRateIndexOverride struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum number of retransmissions.
	// If unset, the default value from Network Server configuration will be used.
	MinNbTrans *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=min_nb_trans,json=minNbTrans,proto3" json:"min_nb_trans,omitempty"`
	// Maximum number of retransmissions.
	// If unset, the default value from Network Server configuration will be used.
	MaxNbTrans *wrapperspb.UInt32Value `protobuf:"bytes,4,opt,name=max_nb_trans,json=maxNbTrans,proto3" json:"max_nb_trans,omitempty"`
}

func (x *ADRSettings_DynamicMode_PerDataRateIndexOverride) Reset() {
	*x = ADRSettings_DynamicMode_PerDataRateIndexOverride{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ADRSettings_DynamicMode_PerDataRateIndexOverride) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ADRSettings_DynamicMode_PerDataRateIndexOverride) ProtoMessage() {}

func (x *ADRSettings_DynamicMode_PerDataRateIndexOverride) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ADRSettings_DynamicMode_PerDataRateIndexOverride.ProtoReflect.Descriptor instead.
func (*ADRSettings_DynamicMode_PerDataRateIndexOverride) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{12, 1, 1}
}

func (x *ADRSettings_DynamicMode_PerDataRateIndexOverride) GetMinNbTrans() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MinNbTrans
	}
	return nil
}

func (x *ADRSettings_DynamicMode_PerDataRateIndexOverride) GetMaxNbTrans() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxNbTrans
	}
	return nil
}

// EXPERIMENTAL: Configuration overrides.
type ADRSettings_DynamicMode_Overrides struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataRate_0  *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,1,opt,name=data_rate_0,json=dataRate0,proto3" json:"data_rate_0,omitempty"`
	DataRate_1  *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,2,opt,name=data_rate_1,json=dataRate1,proto3" json:"data_rate_1,omitempty"`
	DataRate_2  *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,3,opt,name=data_rate_2,json=dataRate2,proto3" json:"data_rate_2,omitempty"`
	DataRate_3  *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,4,opt,name=data_rate_3,json=dataRate3,proto3" json:"data_rate_3,omitempty"`
	DataRate_4  *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,5,opt,name=data_rate_4,json=dataRate4,proto3" json:"data_rate_4,omitempty"`
	DataRate_5  *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,6,opt,name=data_rate_5,json=dataRate5,proto3" json:"data_rate_5,omitempty"`
	DataRate_6  *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,7,opt,name=data_rate_6,json=dataRate6,proto3" json:"data_rate_6,omitempty"`
	DataRate_7  *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,8,opt,name=data_rate_7,json=dataRate7,proto3" json:"data_rate_7,omitempty"`
	DataRate_8  *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,9,opt,name=data_rate_8,json=dataRate8,proto3" json:"data_rate_8,omitempty"`
	DataRate_9  *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,10,opt,name=data_rate_9,json=dataRate9,proto3" json:"data_rate_9,omitempty"`
	DataRate_10 *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,11,opt,name=data_rate_10,json=dataRate10,proto3" json:"data_rate_10,omitempty"`
	DataRate_11 *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,12,opt,name=data_rate_11,json=dataRate11,proto3" json:"data_rate_11,omitempty"`
	DataRate_12 *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,13,opt,name=data_rate_12,json=dataRate12,proto3" json:"data_rate_12,omitempty"`
	DataRate_13 *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,14,opt,name=data_rate_13,json=dataRate13,proto3" json:"data_rate_13,omitempty"`
	DataRate_14 *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,15,opt,name=data_rate_14,json=dataRate14,proto3" json:"data_rate_14,omitempty"`
	DataRate_15 *ADRSettings_DynamicMode_PerDataRateIndexOverride `protobuf:"bytes,16,opt,name=data_rate_15,json=dataRate15,proto3" json:"data_rate_15,omitempty"`
}

func (x *ADRSettings_DynamicMode_Overrides) Reset() {
	*x = ADRSettings_DynamicMode_Overrides{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ADRSettings_DynamicMode_Overrides) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ADRSettings_DynamicMode_Overrides) ProtoMessage() {}

func (x *ADRSettings_DynamicMode_Overrides) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ADRSettings_DynamicMode_Overrides.ProtoReflect.Descriptor instead.
func (*ADRSettings_DynamicMode_Overrides) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{12, 1, 2}
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_0() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_0
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_1() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_1
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_2() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_2
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_3() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_3
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_4() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_4
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_5() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_5
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_6() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_6
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_7() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_7
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_8() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_8
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_9() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_9
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_10() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_10
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_11() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_11
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_12() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_12
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_13() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_13
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_14() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_14
	}
	return nil
}

func (x *ADRSettings_DynamicMode_Overrides) GetDataRate_15() *ADRSettings_DynamicMode_PerDataRateIndexOverride {
	if x != nil {
		return x.DataRate_15
	}
	return nil
}

// Configuration options for LoRa narrow channels steering.
// The narrow mode attempts to steer the end device towards
// using the LoRa modulated, 125kHz bandwidth channels.
type ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode) Reset() {
	*x = ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode) ProtoMessage() {}

func (x *ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode.ProtoReflect.Descriptor instead.
func (*ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{12, 1, 0, 0}
}

// Configuration options for cases in which ADR is not supposed to steer the end device
// to another set of channels.
type ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode) Reset() {
	*x = ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode) ProtoMessage() {}

func (x *ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode.ProtoReflect.Descriptor instead.
func (*ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{12, 1, 0, 1}
}

type MACState_JoinRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DownlinkSettings *DLSettings `protobuf:"bytes,6,opt,name=downlink_settings,json=downlinkSettings,proto3" json:"downlink_settings,omitempty"`
	RxDelay          RxDelay     `protobuf:"varint,7,opt,name=rx_delay,json=rxDelay,proto3,enum=ttn.lorawan.v3.RxDelay" json:"rx_delay,omitempty"`
	CfList           *CFList     `protobuf:"bytes,8,opt,name=cf_list,json=cfList,proto3" json:"cf_list,omitempty"`
}

func (x *MACState_JoinRequest) Reset() {
	*x = MACState_JoinRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACState_JoinRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACState_JoinRequest) ProtoMessage() {}

func (x *MACState_JoinRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACState_JoinRequest.ProtoReflect.Descriptor instead.
func (*MACState_JoinRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{15, 0}
}

func (x *MACState_JoinRequest) GetDownlinkSettings() *DLSettings {
	if x != nil {
		return x.DownlinkSettings
	}
	return nil
}

func (x *MACState_JoinRequest) GetRxDelay() RxDelay {
	if x != nil {
		return x.RxDelay
	}
	return RxDelay_RX_DELAY_0
}

func (x *MACState_JoinRequest) GetCfList() *CFList {
	if x != nil {
		return x.CfList
	}
	return nil
}

type MACState_JoinAccept struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Payload of the join-accept received from Join Server.
	Payload []byte                `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	Request *MACState_JoinRequest `protobuf:"bytes,2,opt,name=request,proto3" json:"request,omitempty"`
	// Network session keys associated with the join.
	Keys           *SessionKeys `protobuf:"bytes,3,opt,name=keys,proto3" json:"keys,omitempty"`
	CorrelationIds []string     `protobuf:"bytes,4,rep,name=correlation_ids,json=correlationIds,proto3" json:"correlation_ids,omitempty"`
	DevAddr        []byte       `protobuf:"bytes,5,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	NetId          []byte       `protobuf:"bytes,6,opt,name=net_id,json=netId,proto3" json:"net_id,omitempty"`
}

func (x *MACState_JoinAccept) Reset() {
	*x = MACState_JoinAccept{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACState_JoinAccept) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACState_JoinAccept) ProtoMessage() {}

func (x *MACState_JoinAccept) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACState_JoinAccept.ProtoReflect.Descriptor instead.
func (*MACState_JoinAccept) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{15, 1}
}

func (x *MACState_JoinAccept) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *MACState_JoinAccept) GetRequest() *MACState_JoinRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *MACState_JoinAccept) GetKeys() *SessionKeys {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *MACState_JoinAccept) GetCorrelationIds() []string {
	if x != nil {
		return x.CorrelationIds
	}
	return nil
}

func (x *MACState_JoinAccept) GetDevAddr() []byte {
	if x != nil {
		return x.DevAddr
	}
	return nil
}

func (x *MACState_JoinAccept) GetNetId() []byte {
	if x != nil {
		return x.NetId
	}
	return nil
}

// A minimal UplinkMessage definition which is binary compatible with the top level UplinkMessage message.
// Used for type safe recent uplink storage.
type MACState_UplinkMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Payload            *Message                             `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	Settings           *MACState_UplinkMessage_TxSettings   `protobuf:"bytes,4,opt,name=settings,proto3" json:"settings,omitempty"`
	RxMetadata         []*MACState_UplinkMessage_RxMetadata `protobuf:"bytes,5,rep,name=rx_metadata,json=rxMetadata,proto3" json:"rx_metadata,omitempty"`
	ReceivedAt         *timestamppb.Timestamp               `protobuf:"bytes,6,opt,name=received_at,json=receivedAt,proto3" json:"received_at,omitempty"`
	CorrelationIds     []string                             `protobuf:"bytes,7,rep,name=correlation_ids,json=correlationIds,proto3" json:"correlation_ids,omitempty"`
	DeviceChannelIndex uint32                               `protobuf:"varint,9,opt,name=device_channel_index,json=deviceChannelIndex,proto3" json:"device_channel_index,omitempty"`
}

func (x *MACState_UplinkMessage) Reset() {
	*x = MACState_UplinkMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACState_UplinkMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACState_UplinkMessage) ProtoMessage() {}

func (x *MACState_UplinkMessage) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACState_UplinkMessage.ProtoReflect.Descriptor instead.
func (*MACState_UplinkMessage) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{15, 2}
}

func (x *MACState_UplinkMessage) GetPayload() *Message {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *MACState_UplinkMessage) GetSettings() *MACState_UplinkMessage_TxSettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *MACState_UplinkMessage) GetRxMetadata() []*MACState_UplinkMessage_RxMetadata {
	if x != nil {
		return x.RxMetadata
	}
	return nil
}

func (x *MACState_UplinkMessage) GetReceivedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ReceivedAt
	}
	return nil
}

func (x *MACState_UplinkMessage) GetCorrelationIds() []string {
	if x != nil {
		return x.CorrelationIds
	}
	return nil
}

func (x *MACState_UplinkMessage) GetDeviceChannelIndex() uint32 {
	if x != nil {
		return x.DeviceChannelIndex
	}
	return 0
}

// A minimal DownlinkMessage definition which is binary compatible with the top level DownlinkMessage message.
// Used for type safe recent downlink storage.
type MACState_DownlinkMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Payload        *MACState_DownlinkMessage_Message `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	CorrelationIds []string                          `protobuf:"bytes,6,rep,name=correlation_ids,json=correlationIds,proto3" json:"correlation_ids,omitempty"`
}

func (x *MACState_DownlinkMessage) Reset() {
	*x = MACState_DownlinkMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACState_DownlinkMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACState_DownlinkMessage) ProtoMessage() {}

func (x *MACState_DownlinkMessage) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACState_DownlinkMessage.ProtoReflect.Descriptor instead.
func (*MACState_DownlinkMessage) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{15, 3}
}

func (x *MACState_DownlinkMessage) GetPayload() *MACState_DownlinkMessage_Message {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *MACState_DownlinkMessage) GetCorrelationIds() []string {
	if x != nil {
		return x.CorrelationIds
	}
	return nil
}

type MACState_DataRateRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinDataRateIndex DataRateIndex `protobuf:"varint,1,opt,name=min_data_rate_index,json=minDataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"min_data_rate_index,omitempty"`
	MaxDataRateIndex DataRateIndex `protobuf:"varint,2,opt,name=max_data_rate_index,json=maxDataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"max_data_rate_index,omitempty"`
}

func (x *MACState_DataRateRange) Reset() {
	*x = MACState_DataRateRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACState_DataRateRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACState_DataRateRange) ProtoMessage() {}

func (x *MACState_DataRateRange) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACState_DataRateRange.ProtoReflect.Descriptor instead.
func (*MACState_DataRateRange) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{15, 4}
}

func (x *MACState_DataRateRange) GetMinDataRateIndex() DataRateIndex {
	if x != nil {
		return x.MinDataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *MACState_DataRateRange) GetMaxDataRateIndex() DataRateIndex {
	if x != nil {
		return x.MaxDataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

type MACState_DataRateRanges struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ranges []*MACState_DataRateRange `protobuf:"bytes,1,rep,name=ranges,proto3" json:"ranges,omitempty"`
}

func (x *MACState_DataRateRanges) Reset() {
	*x = MACState_DataRateRanges{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACState_DataRateRanges) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACState_DataRateRanges) ProtoMessage() {}

func (x *MACState_DataRateRanges) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACState_DataRateRanges.ProtoReflect.Descriptor instead.
func (*MACState_DataRateRanges) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{15, 5}
}

func (x *MACState_DataRateRanges) GetRanges() []*MACState_DataRateRange {
	if x != nil {
		return x.Ranges
	}
	return nil
}

type MACState_UplinkMessage_TxSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataRate *DataRate `protobuf:"bytes,1,opt,name=data_rate,json=dataRate,proto3" json:"data_rate,omitempty"`
}

func (x *MACState_UplinkMessage_TxSettings) Reset() {
	*x = MACState_UplinkMessage_TxSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACState_UplinkMessage_TxSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACState_UplinkMessage_TxSettings) ProtoMessage() {}

func (x *MACState_UplinkMessage_TxSettings) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACState_UplinkMessage_TxSettings.ProtoReflect.Descriptor instead.
func (*MACState_UplinkMessage_TxSettings) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{15, 2, 0}
}

func (x *MACState_UplinkMessage_TxSettings) GetDataRate() *DataRate {
	if x != nil {
		return x.DataRate
	}
	return nil
}

type MACState_UplinkMessage_RxMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds             *GatewayIdentifiers                                     `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	ChannelRssi            float32                                                 `protobuf:"fixed32,9,opt,name=channel_rssi,json=channelRssi,proto3" json:"channel_rssi,omitempty"`
	Snr                    float32                                                 `protobuf:"fixed32,11,opt,name=snr,proto3" json:"snr,omitempty"`
	DownlinkPathConstraint DownlinkPathConstraint                                  `protobuf:"varint,14,opt,name=downlink_path_constraint,json=downlinkPathConstraint,proto3,enum=ttn.lorawan.v3.DownlinkPathConstraint" json:"downlink_path_constraint,omitempty"`
	UplinkToken            []byte                                                  `protobuf:"bytes,15,opt,name=uplink_token,json=uplinkToken,proto3" json:"uplink_token,omitempty"`
	PacketBroker           *MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata `protobuf:"bytes,18,opt,name=packet_broker,json=packetBroker,proto3" json:"packet_broker,omitempty"`
	Relay                  *MACState_UplinkMessage_RxMetadata_RelayMetadata        `protobuf:"bytes,23,opt,name=relay,proto3" json:"relay,omitempty"`
}

func (x *MACState_UplinkMessage_RxMetadata) Reset() {
	*x = MACState_UplinkMessage_RxMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACState_UplinkMessage_RxMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACState_UplinkMessage_RxMetadata) ProtoMessage() {}

func (x *MACState_UplinkMessage_RxMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACState_UplinkMessage_RxMetadata.ProtoReflect.Descriptor instead.
func (*MACState_UplinkMessage_RxMetadata) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{15, 2, 1}
}

func (x *MACState_UplinkMessage_RxMetadata) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *MACState_UplinkMessage_RxMetadata) GetChannelRssi() float32 {
	if x != nil {
		return x.ChannelRssi
	}
	return 0
}

func (x *MACState_UplinkMessage_RxMetadata) GetSnr() float32 {
	if x != nil {
		return x.Snr
	}
	return 0
}

func (x *MACState_UplinkMessage_RxMetadata) GetDownlinkPathConstraint() DownlinkPathConstraint {
	if x != nil {
		return x.DownlinkPathConstraint
	}
	return DownlinkPathConstraint_DOWNLINK_PATH_CONSTRAINT_NONE
}

func (x *MACState_UplinkMessage_RxMetadata) GetUplinkToken() []byte {
	if x != nil {
		return x.UplinkToken
	}
	return nil
}

func (x *MACState_UplinkMessage_RxMetadata) GetPacketBroker() *MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata {
	if x != nil {
		return x.PacketBroker
	}
	return nil
}

func (x *MACState_UplinkMessage_RxMetadata) GetRelay() *MACState_UplinkMessage_RxMetadata_RelayMetadata {
	if x != nil {
		return x.Relay
	}
	return nil
}

type MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata) Reset() {
	*x = MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata) ProtoMessage() {}

func (x *MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata.ProtoReflect.Descriptor instead.
func (*MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{15, 2, 1, 0}
}

type MACState_UplinkMessage_RxMetadata_RelayMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MACState_UplinkMessage_RxMetadata_RelayMetadata) Reset() {
	*x = MACState_UplinkMessage_RxMetadata_RelayMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACState_UplinkMessage_RxMetadata_RelayMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACState_UplinkMessage_RxMetadata_RelayMetadata) ProtoMessage() {}

func (x *MACState_UplinkMessage_RxMetadata_RelayMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACState_UplinkMessage_RxMetadata_RelayMetadata.ProtoReflect.Descriptor instead.
func (*MACState_UplinkMessage_RxMetadata_RelayMetadata) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{15, 2, 1, 1}
}

type MACState_DownlinkMessage_Message struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MHdr       *MACState_DownlinkMessage_Message_MHDR       `protobuf:"bytes,1,opt,name=m_hdr,json=mHdr,proto3" json:"m_hdr,omitempty"`
	MacPayload *MACState_DownlinkMessage_Message_MACPayload `protobuf:"bytes,3,opt,name=mac_payload,json=macPayload,proto3" json:"mac_payload,omitempty"`
}

func (x *MACState_DownlinkMessage_Message) Reset() {
	*x = MACState_DownlinkMessage_Message{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACState_DownlinkMessage_Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACState_DownlinkMessage_Message) ProtoMessage() {}

func (x *MACState_DownlinkMessage_Message) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACState_DownlinkMessage_Message.ProtoReflect.Descriptor instead.
func (*MACState_DownlinkMessage_Message) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{15, 3, 0}
}

func (x *MACState_DownlinkMessage_Message) GetMHdr() *MACState_DownlinkMessage_Message_MHDR {
	if x != nil {
		return x.MHdr
	}
	return nil
}

func (x *MACState_DownlinkMessage_Message) GetMacPayload() *MACState_DownlinkMessage_Message_MACPayload {
	if x != nil {
		return x.MacPayload
	}
	return nil
}

type MACState_DownlinkMessage_Message_MHDR struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MType MType `protobuf:"varint,1,opt,name=m_type,json=mType,proto3,enum=ttn.lorawan.v3.MType" json:"m_type,omitempty"`
}

func (x *MACState_DownlinkMessage_Message_MHDR) Reset() {
	*x = MACState_DownlinkMessage_Message_MHDR{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACState_DownlinkMessage_Message_MHDR) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACState_DownlinkMessage_Message_MHDR) ProtoMessage() {}

func (x *MACState_DownlinkMessage_Message_MHDR) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACState_DownlinkMessage_Message_MHDR.ProtoReflect.Descriptor instead.
func (*MACState_DownlinkMessage_Message_MHDR) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{15, 3, 0, 0}
}

func (x *MACState_DownlinkMessage_Message_MHDR) GetMType() MType {
	if x != nil {
		return x.MType
	}
	return MType_JOIN_REQUEST
}

type MACState_DownlinkMessage_Message_MACPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FPort    uint32 `protobuf:"varint,2,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	FullFCnt uint32 `protobuf:"varint,5,opt,name=full_f_cnt,json=fullFCnt,proto3" json:"full_f_cnt,omitempty"`
}

func (x *MACState_DownlinkMessage_Message_MACPayload) Reset() {
	*x = MACState_DownlinkMessage_Message_MACPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MACState_DownlinkMessage_Message_MACPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MACState_DownlinkMessage_Message_MACPayload) ProtoMessage() {}

func (x *MACState_DownlinkMessage_Message_MACPayload) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MACState_DownlinkMessage_Message_MACPayload.ProtoReflect.Descriptor instead.
func (*MACState_DownlinkMessage_Message_MACPayload) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{15, 3, 0, 1}
}

func (x *MACState_DownlinkMessage_Message_MACPayload) GetFPort() uint32 {
	if x != nil {
		return x.FPort
	}
	return 0
}

func (x *MACState_DownlinkMessage_Message_MACPayload) GetFullFCnt() uint32 {
	if x != nil {
		return x.FullFCnt
	}
	return 0
}

type BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids        *EndDeviceIdentifiers  `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	LastSeenAt *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=last_seen_at,json=lastSeenAt,proto3" json:"last_seen_at,omitempty"`
}

func (x *BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate) Reset() {
	*x = BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate) ProtoMessage() {}

func (x *BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate.ProtoReflect.Descriptor instead.
func (*BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{22, 0}
}

func (x *BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate) GetIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate) GetLastSeenAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastSeenAt
	}
	return nil
}

// Filter end devices by fields.
type ListEndDevicesRequest_Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Field:
	//	*ListEndDevicesRequest_Filter_UpdatedSince
	Field isListEndDevicesRequest_Filter_Field `protobuf_oneof:"field"`
}

func (x *ListEndDevicesRequest_Filter) Reset() {
	*x = ListEndDevicesRequest_Filter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEndDevicesRequest_Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEndDevicesRequest_Filter) ProtoMessage() {}

func (x *ListEndDevicesRequest_Filter) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_end_device_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEndDevicesRequest_Filter.ProtoReflect.Descriptor instead.
func (*ListEndDevicesRequest_Filter) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_end_device_proto_rawDescGZIP(), []int{25, 0}
}

func (m *ListEndDevicesRequest_Filter) GetField() isListEndDevicesRequest_Filter_Field {
	if m != nil {
		return m.Field
	}
	return nil
}

func (x *ListEndDevicesRequest_Filter) GetUpdatedSince() *timestamppb.Timestamp {
	if x, ok := x.GetField().(*ListEndDevicesRequest_Filter_UpdatedSince); ok {
		return x.UpdatedSince
	}
	return nil
}

type isListEndDevicesRequest_Filter_Field interface {
	isListEndDevicesRequest_Filter_Field()
}

type ListEndDevicesRequest_Filter_UpdatedSince struct {
	UpdatedSince *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=updated_since,json=updatedSince,proto3,oneof"`
}

func (*ListEndDevicesRequest_Filter_UpdatedSince) isListEndDevicesRequest_Filter_Field() {}

var File_ttn_lorawan_v3_end_device_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_end_device_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x0e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f,
	0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x21, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x66, 0x6c,
	0x61, 0x67, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x2f, 0x6a, 0x73, 0x6f, 0x6e, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2f, 0x76, 0x33, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1c, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d,
	0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x74,
	0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x74, 0x74,
	0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x69, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x8d, 0x06, 0x0a, 0x07, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0xed, 0x02, 0x0a, 0x08, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x42, 0xd1, 0x02, 0x92, 0x41, 0x19, 0x4a, 0x0a, 0x22, 0x32, 0x36, 0x30, 0x30, 0x41,
	0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x04, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a,
	0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x34, 0x42, 0x79, 0x74, 0x65,
	0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d,
	0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x34, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d,
	0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61, 0x63,
	0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x07, 0x64, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x12,
	0x39, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x21, 0x0a, 0x0d, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x5f, 0x75, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x46, 0x43, 0x6e, 0x74, 0x55, 0x70, 0x12, 0x28, 0x0a,
	0x11, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6e, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x5f, 0x64, 0x6f,
	0x77, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x6c, 0x61, 0x73, 0x74, 0x4e, 0x46,
	0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x12, 0x28, 0x0a, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x5f,
	0x61, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x0d, 0x6c, 0x61, 0x73, 0x74, 0x41, 0x46, 0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77,
	0x6e, 0x12, 0x2e, 0x0a, 0x14, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x5f, 0x66,
	0x5f, 0x63, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x10, 0x6c, 0x61, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x46, 0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77,
	0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x65, 0x0a, 0x1c,
	0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x09, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x1a, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69,
	0x6e, 0x6b, 0x73, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x4a, 0x04, 0x08,
	0x01, 0x10, 0x02, 0x22, 0x33, 0x0a, 0x09, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x10, 0xea, 0xaa, 0x19, 0x02, 0x18, 0x01, 0xf2, 0xaa,
	0x19, 0x06, 0x08, 0x01, 0x10, 0x01, 0x18, 0x01, 0x22, 0x95, 0x03, 0x0a, 0x1c, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x4d, 0x0a, 0x0e, 0x72, 0x65, 0x73,
	0x65, 0x74, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x73, 0x65, 0x74, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x65, 0x74,
	0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12, 0x47, 0x0a, 0x0d, 0x6a, 0x6f, 0x69, 0x6e,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x73, 0x52, 0x0c, 0x6a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x12, 0x48, 0x0a, 0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x46,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0d, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4b, 0x0a, 0x0f, 0x75,
	0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x46, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0e, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x3c, 0x0a, 0x07, 0x6f, 0x76, 0x65, 0x72,
	0x61, 0x6c, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79,
	0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x07, 0x6f,
	0x76, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01,
	0x22, 0xf7, 0x01, 0x0a, 0x19, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x40,
	0x0a, 0x06, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x06, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73,
	0x12, 0x1f, 0x0a, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x77, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x6c, 0x61, 0x73, 0x74, 0x57, 0x46, 0x43, 0x6e,
	0x74, 0x12, 0x47, 0x0a, 0x09, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x42, 0x27, 0x72, 0x25, 0x18, 0x24, 0x32, 0x1e, 0x5e,
	0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b,
	0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0xd0, 0x01, 0x01,
	0x52, 0x08, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x49, 0x64,
	0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0xb6, 0x03, 0x0a, 0x16, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x49, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x12, 0x3c, 0x0a, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xff, 0x01, 0x52, 0x13, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x56,
	0x0a, 0x0f, 0x63, 0x61, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x41,
	0x44, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0e, 0x63, 0x61, 0x64, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x12, 0x6b, 0x0a, 0x17, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x5f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70,
	0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75,
	0x6c, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x10, 0x52, 0x15, 0x75, 0x70,
	0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75,
	0x6c, 0x65, 0x73, 0x12, 0x44, 0x0a, 0x06, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x6c, 0x61,
	0x79, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x73, 0x52, 0x06, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08,
	0x01, 0x10, 0x01, 0x22, 0xe2, 0x03, 0x0a, 0x15, 0x53, 0x65, 0x72, 0x76, 0x65, 0x64, 0x52, 0x65,
	0x6c, 0x61, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x42, 0x0a,
	0x06, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x6c, 0x77,
	0x61, 0x79, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x06, 0x61, 0x6c, 0x77, 0x61, 0x79,
	0x73, 0x12, 0x45, 0x0a, 0x07, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52,
	0x07, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x12, 0x62, 0x0a, 0x15, 0x65, 0x6e, 0x64, 0x5f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x64, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x13, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x07,
	0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa,
	0x42, 0x04, 0x2a, 0x02, 0x18, 0x3f, 0x52, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x12,
	0x49, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x0d, 0x73, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x53, 0x0a, 0x11, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x42, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e,
	0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f,
	0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x0f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x3a,
	0x0a, 0xf2, 0xaa, 0x19, 0x06, 0x08, 0x01, 0x10, 0x01, 0x20, 0x01, 0x42, 0x0b, 0x0a, 0x04, 0x6d,
	0x6f, 0x64, 0x65, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x22, 0xaf, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x6c,
	0x61, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x42, 0x0a, 0x07,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67,
	0x12, 0x3f, 0x0a, 0x06, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x64, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52, 0x06, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x64, 0x3a, 0x0a, 0xf2, 0xaa, 0x19, 0x06, 0x08, 0x01, 0x10, 0x01, 0x20, 0x01, 0x42, 0x0b, 0x0a,
	0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x22, 0xd8, 0x03, 0x0a, 0x14, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x49, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c,
	0x61, 0x79, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52,
	0x0d, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x5a,
	0x0a, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0x2a, 0x03, 0x18, 0xff, 0x01, 0x52, 0x13, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x56, 0x0a, 0x0f, 0x63, 0x61,
	0x64, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x43, 0x41, 0x44, 0x50, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x0e, 0x63, 0x61, 0x64, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x69,
	0x74, 0x79, 0x12, 0x6b, 0x0a, 0x17, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x66, 0x6f, 0x72,
	0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x10, 0x52, 0x15, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12,
	0x44, 0x0a, 0x06, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x46, 0x6f, 0x72,
	0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x06, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x4a,
	0x04, 0x08, 0x02, 0x10, 0x03, 0x22, 0x84, 0x04, 0x0a, 0x13, 0x53, 0x65, 0x72, 0x76, 0x65, 0x64,
	0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x42, 0x0a,
	0x06, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x6c, 0x77,
	0x61, 0x79, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x06, 0x61, 0x6c, 0x77, 0x61, 0x79,
	0x73, 0x12, 0x45, 0x0a, 0x07, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52,
	0x07, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x12, 0x62, 0x0a, 0x15, 0x65, 0x6e, 0x64, 0x5f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x64, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x13, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x12, 0x3f, 0x0a, 0x07,
	0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0xfa, 0x42, 0x04,
	0x2a, 0x02, 0x18, 0x3f, 0x52, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x12, 0x49, 0x0a,
	0x0e, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x53, 0x0a, 0x11, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x6e, 0x67, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x42, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b,
	0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61,
	0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x0f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x3a, 0x0a, 0xf2,
	0xaa, 0x19, 0x06, 0x08, 0x01, 0x10, 0x01, 0x20, 0x01, 0x42, 0x0b, 0x0a, 0x04, 0x6d, 0x6f, 0x64,
	0x65, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x22, 0xa9, 0x01, 0x0a,
	0x0d, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40,
	0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67,
	0x12, 0x3d, 0x0a, 0x06, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x64, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x06, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x3a,
	0x0a, 0xf2, 0xaa, 0x19, 0x06, 0x08, 0x01, 0x10, 0x01, 0x20, 0x01, 0x42, 0x0b, 0x0a, 0x04, 0x6d,
	0x6f, 0x64, 0x65, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x22, 0xfc, 0x0f, 0x0a, 0x0d, 0x4d, 0x41, 0x43,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x61,
	0x78, 0x5f, 0x65, 0x69, 0x72, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x07, 0x6d, 0x61,
	0x78, 0x45, 0x69, 0x72, 0x70, 0x12, 0x56, 0x0a, 0x13, 0x61, 0x64, 0x72, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x10, 0x61, 0x64, 0x72,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x34, 0x0a,
	0x12, 0x61, 0x64, 0x72, 0x5f, 0x74, 0x78, 0x5f, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02,
	0x18, 0x0f, 0x52, 0x0f, 0x61, 0x64, 0x72, 0x54, 0x78, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x29, 0x0a, 0x0c, 0x61, 0x64, 0x72, 0x5f, 0x6e, 0x62, 0x5f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02,
	0x18, 0x0f, 0x52, 0x0a, 0x61, 0x64, 0x72, 0x4e, 0x62, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x12, 0x26,
	0x0a, 0x0d, 0x61, 0x64, 0x72, 0x5f, 0x61, 0x63, 0x6b, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0b, 0x61, 0x64, 0x72, 0x41, 0x63,
	0x6b, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x26, 0x0a, 0x0d, 0x61, 0x64, 0x72, 0x5f, 0x61, 0x63,
	0x6b, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0b, 0x61, 0x64, 0x72, 0x41, 0x63, 0x6b, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x3e,
	0x0a, 0x09, 0x72, 0x78, 0x31, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x17, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x52, 0x78, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x72, 0x78, 0x31, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x59,
	0x0a, 0x14, 0x72, 0x78, 0x31, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x11, 0x72, 0x78, 0x31, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x61, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x56, 0x0a, 0x13, 0x72, 0x78, 0x32,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x10, 0x72, 0x78, 0x32, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x12, 0x2e, 0x0a, 0x0d, 0x72, 0x78, 0x32, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x04, 0x42, 0x09, 0xfa, 0x42, 0x06, 0x32, 0x04, 0x28,
	0xa0, 0x8d, 0x06, 0x52, 0x0c, 0x72, 0x78, 0x32, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x12, 0x53, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x75, 0x74, 0x79, 0x5f, 0x63, 0x79,
	0x63, 0x6c, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x65, 0x64, 0x44, 0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x44, 0x75, 0x74,
	0x79, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x64, 0x0a, 0x17, 0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74,
	0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x15, 0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x54, 0x69, 0x6d,
	0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x12, 0x67, 0x0a, 0x18,
	0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x70, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x78, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x16, 0x72,
	0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64,
	0x69, 0x63, 0x69, 0x74, 0x79, 0x12, 0x3b, 0x0a, 0x13, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6c,
	0x6f, 0x74, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x04, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x32, 0x06, 0x18, 0x00, 0x28, 0xa0, 0x8d, 0x06, 0x52,
	0x11, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x12, 0x5b, 0x0a, 0x19, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x42, 0x02, 0x18, 0x01, 0x52, 0x15, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x6c,
	0x6f, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x36, 0x0a, 0x10, 0x62, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x18, 0x12, 0x20, 0x01, 0x28, 0x04, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x32, 0x06,
	0x18, 0x00, 0x28, 0xa0, 0x8d, 0x06, 0x52, 0x0f, 0x62, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x46, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x4b, 0x0a, 0x08, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x73, 0x18, 0x13, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x08, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x73, 0x12, 0x45, 0x0a, 0x11, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x64,
	0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x75, 0x70, 0x6c, 0x69,
	0x6e, 0x6b, 0x44, 0x77, 0x65, 0x6c, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x13, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x64, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x44, 0x77, 0x65,
	0x6c, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x16, 0x61, 0x64, 0x72, 0x5f, 0x61, 0x63,
	0x6b, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x41, 0x63, 0x6b, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x13, 0x61, 0x64, 0x72, 0x41, 0x63, 0x6b, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x45, 0x78, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x16, 0x61, 0x64, 0x72, 0x5f, 0x61, 0x63, 0x6b,
	0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18,
	0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x41, 0x63, 0x6b, 0x44, 0x65, 0x6c,
	0x61, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x13, 0x61, 0x64, 0x72, 0x41, 0x63, 0x6b, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x78, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x12, 0x67, 0x0a, 0x1f, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6c, 0x6f,
	0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x1a, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x35, 0x0a,
	0x05, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65,
	0x6c, 0x61, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x05, 0x72,
	0x65, 0x6c, 0x61, 0x79, 0x1a, 0xda, 0x02, 0x0a, 0x07, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x12, 0x36, 0x0a, 0x10, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x32,
	0x06, 0x18, 0x00, 0x28, 0xa0, 0x8d, 0x06, 0x52, 0x0f, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x38, 0x0a, 0x12, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x04, 0x42, 0x09, 0xfa, 0x42, 0x06, 0x32, 0x04, 0x28, 0xa0, 0x8d, 0x06, 0x52,
	0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x12, 0x56, 0x0a, 0x13, 0x6d, 0x69, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x10, 0x6d, 0x69, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x56, 0x0a, 0x13, 0x6d, 0x61,
	0x78, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x10, 0x6d, 0x61, 0x78, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x75, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10,
	0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x4a, 0x04, 0x08, 0x02, 0x10,
	0x03, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x22, 0xfa, 0x05, 0x0a, 0x10, 0x45, 0x6e, 0x64, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x03,
	0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x4d, 0x0a, 0x0f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x4d, 0x41, 0x43, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x0e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x13, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x5f,
	0x70, 0x68, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x50, 0x48, 0x59, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x11, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x50, 0x68, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x11, 0x66, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x40, 0x52, 0x0f,
	0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x6c, 0x61, 0x6e, 0x49, 0x64, 0x12,
	0x20, 0x0a, 0x06, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x0a, 0x52, 0x06, 0x70, 0x68, 0x6f, 0x74, 0x6f,
	0x73, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x5f, 0x62, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x12, 0x28, 0x0a, 0x10, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x63, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x43, 0x12, 0x4d, 0x0a, 0x14, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x6d, 0x61, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4d, 0x61, 0x63, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x5f, 0x66, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x6d, 0x69, 0x6e,
	0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x78,
	0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0c, 0x6d, 0x61, 0x78, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x23,
	0x0a, 0x0d, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x6a, 0x6f, 0x69, 0x6e, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x4a,
	0x6f, 0x69, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x65, 0x74, 0x73, 0x5f, 0x6a, 0x6f,
	0x69, 0x6e, 0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x10, 0x72, 0x65, 0x73, 0x65, 0x74, 0x73, 0x4a, 0x6f, 0x69, 0x6e, 0x4e, 0x6f, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x61, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x11, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x74, 0x65, 0x72, 0x73, 0x22, 0xb3, 0x1a, 0x0a, 0x0b, 0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x12, 0x43, 0x0a, 0x07, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65,
	0x48, 0x00, 0x52, 0x07, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x12, 0x46, 0x0a, 0x08, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41,
	0x44, 0x52, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x1a, 0xbc, 0x01, 0x0a, 0x0a, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x4f, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x2d, 0x0a, 0x0e, 0x74, 0x78, 0x5f, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x5f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42, 0x04,
	0x2a, 0x02, 0x18, 0x0f, 0x52, 0x0c, 0x74, 0x78, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x12, 0x24, 0x0a, 0x08, 0x6e, 0x62, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0d, 0x42, 0x09, 0xfa, 0x42, 0x06, 0x2a, 0x04, 0x18, 0x0f, 0x28, 0x01, 0x52,
	0x07, 0x6e, 0x62, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01,
	0x10, 0x01, 0x1a, 0xe7, 0x16, 0x0a, 0x0b, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x33, 0x0a, 0x06, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x06, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x12, 0x51, 0x0a, 0x13, 0x6d, 0x69, 0x6e, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x6d, 0x69, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x51, 0x0a, 0x13, 0x6d, 0x61,
	0x78, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x6d, 0x61, 0x78,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x52, 0x0a,
	0x12, 0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x78, 0x5f, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74,
	0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x18, 0x0f,
	0x52, 0x0f, 0x6d, 0x69, 0x6e, 0x54, 0x78, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x12, 0x52, 0x0a, 0x12, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x78, 0x5f, 0x70, 0x6f, 0x77, 0x65,
	0x72, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0xfa, 0x42, 0x04,
	0x2a, 0x02, 0x18, 0x0f, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x54, 0x78, 0x50, 0x6f, 0x77, 0x65, 0x72,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x49, 0x0a, 0x0c, 0x6d, 0x69, 0x6e, 0x5f, 0x6e, 0x62, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49,
	0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x09, 0xfa, 0x42, 0x06, 0x2a, 0x04,
	0x18, 0x03, 0x28, 0x01, 0x52, 0x0a, 0x6d, 0x69, 0x6e, 0x4e, 0x62, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x12, 0x49, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x62, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x09, 0xfa, 0x42, 0x06, 0x2a, 0x04, 0x18, 0x03, 0x28, 0x01, 0x52,
	0x0a, 0x6d, 0x61, 0x78, 0x4e, 0x62, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x12, 0x6a, 0x0a, 0x10, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x73, 0x74, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x2e, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x53, 0x74, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x53,
	0x74, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x4f, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d,
	0x6f, 0x64, 0x65, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x52, 0x09, 0x6f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x1a, 0xc2, 0x02, 0x0a, 0x17, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x53, 0x74, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x71, 0x0a, 0x0b, 0x6c, 0x6f, 0x72, 0x61, 0x5f, 0x6e, 0x61, 0x72,
	0x72, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f,
	0x64, 0x65, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x53, 0x74, 0x65, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x4c, 0x6f, 0x52, 0x61, 0x4e,
	0x61, 0x72, 0x72, 0x6f, 0x77, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x6c, 0x6f, 0x72,
	0x61, 0x4e, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x12, 0x6a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f,
	0x64, 0x65, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x53, 0x74, 0x65, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x1a, 0x1a, 0x0a, 0x0e, 0x4c, 0x6f, 0x52, 0x61, 0x4e, 0x61, 0x72, 0x72, 0x6f,
	0x77, 0x4d, 0x6f, 0x64, 0x65, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x1a,
	0x18, 0x0a, 0x0c, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x3a,
	0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x3a, 0x0a, 0xf2, 0xaa, 0x19, 0x06, 0x08,
	0x01, 0x10, 0x01, 0x20, 0x01, 0x42, 0x06, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x1a, 0xee, 0x01,
	0x0a, 0x18, 0x50, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x49, 0x0a, 0x0c, 0x6d, 0x69,
	0x6e, 0x5f, 0x6e, 0x62, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x09,
	0xfa, 0x42, 0x06, 0x2a, 0x04, 0x18, 0x03, 0x28, 0x01, 0x52, 0x0a, 0x6d, 0x69, 0x6e, 0x4e, 0x62,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x12, 0x49, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x62, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49,
	0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x09, 0xfa, 0x42, 0x06, 0x2a, 0x04,
	0x18, 0x03, 0x28, 0x01, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x4e, 0x62, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02,
	0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x52, 0x12, 0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x78, 0x5f, 0x70,
	0x6f, 0x77, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x12, 0x6d, 0x61, 0x78, 0x5f,
	0x74, 0x78, 0x5f, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x1a, 0xc1,
	0x0c, 0x0a, 0x09, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x0b,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x30, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44,
	0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x30, 0x12, 0x60,
	0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x31, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x2e, 0x50, 0x65, 0x72,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x31,
	0x12, 0x60, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x32, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x2e, 0x50,
	0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74,
	0x65, 0x32, 0x12, 0x60, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f,
	0x33, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65,
	0x2e, 0x50, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x61, 0x74, 0x65, 0x33, 0x12, 0x60, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74,
	0x65, 0x5f, 0x34, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f,
	0x64, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x61, 0x74, 0x65, 0x34, 0x12, 0x60, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x5f, 0x35, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63,
	0x4d, 0x6f, 0x64, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x09, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x35, 0x12, 0x60, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x36, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41,
	0x44, 0x52, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d,
	0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52,
	0x09, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x36, 0x12, 0x60, 0x0a, 0x0b, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x37, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x37, 0x12, 0x60, 0x0a, 0x0b,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x38, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44,
	0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x38, 0x12, 0x60,
	0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x39, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x2e, 0x50, 0x65, 0x72,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x39,
	0x12, 0x62, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x31, 0x30,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x2e,
	0x50, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61,
	0x74, 0x65, 0x31, 0x30, 0x12, 0x62, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74,
	0x65, 0x5f, 0x31, 0x31, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d,
	0x6f, 0x64, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x0a, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x31, 0x31, 0x12, 0x62, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x31, 0x32, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x31, 0x32, 0x12, 0x62, 0x0a, 0x0c,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x31, 0x33, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x40, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x31, 0x33,
	0x12, 0x62, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x31, 0x34,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x2e,
	0x50, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61,
	0x74, 0x65, 0x31, 0x34, 0x12, 0x62, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74,
	0x65, 0x5f, 0x31, 0x35, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4d,
	0x6f, 0x64, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x0a, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x31, 0x35, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01,
	0x10, 0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x1a, 0x18, 0x0a, 0x0c,
	0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x3a, 0x08, 0xf2, 0xaa,
	0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x3a, 0x0a, 0xf2, 0xaa, 0x19, 0x06, 0x08, 0x01, 0x10, 0x01,
	0x20, 0x01, 0x42, 0x06, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0xeb, 0x16, 0x0a, 0x0b, 0x4d,
	0x41, 0x43, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x41, 0x0a, 0x0f, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x5f, 0x62, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d,
	0x63, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x57, 0x0a,
	0x15, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x69,
	0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x13, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x12, 0x5c, 0x0a, 0x19, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x6c, 0x6f, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x70,
	0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x12, 0x56, 0x0a, 0x13, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6c, 0x6f,
	0x74, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x5a, 0x65, 0x72, 0x6f, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x70, 0x69, 0x6e, 0x67, 0x53,
	0x6c, 0x6f, 0x74, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x51, 0x0a, 0x10,
	0x62, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x5a, 0x65, 0x72, 0x6f, 0x61, 0x62, 0x6c, 0x65,
	0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f,
	0x62, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12,
	0x41, 0x0a, 0x0f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x63, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x43, 0x54, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x12, 0x39, 0x0a, 0x09, 0x72, 0x78, 0x31, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x78, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x08, 0x72, 0x78, 0x31, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x54, 0x0a,
	0x14, 0x72, 0x78, 0x31, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x61, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x11, 0x72, 0x78, 0x31, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x4f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x12, 0x51, 0x0a, 0x13, 0x72, 0x78, 0x32, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x72, 0x78, 0x32, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x43, 0x0a, 0x0d, 0x72, 0x78, 0x32, 0x5f, 0x66, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x46,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x72,
	0x78, 0x32, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x46, 0x0a, 0x1a, 0x66,
	0x61, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x66, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x04, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x60, 0x52, 0x18, 0x66, 0x61, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x50, 0x72, 0x65, 0x73, 0x65, 0x74, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x69, 0x65, 0x73, 0x12, 0x4e, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x75, 0x74, 0x79, 0x5f,
	0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x44, 0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x44, 0x75, 0x74, 0x79, 0x43, 0x79,
	0x63, 0x6c, 0x65, 0x12, 0x4b, 0x0a, 0x15, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f,
	0x33, 0x32, 0x5f, 0x62, 0x69, 0x74, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x33, 0x32, 0x42, 0x69, 0x74, 0x46, 0x43, 0x6e, 0x74,
	0x12, 0x36, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x72, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x06, 0x75, 0x73, 0x65, 0x41, 0x64, 0x72, 0x12, 0x3e, 0x0a, 0x0a, 0x61, 0x64, 0x72, 0x5f,
	0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x61,
	0x64, 0x72, 0x4d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x12, 0x3b, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x65,
	0x74, 0x73, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x74,
	0x73, 0x46, 0x43, 0x6e, 0x74, 0x12, 0x51, 0x0a, 0x17, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74, 0x79,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x15, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x50, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x12, 0x56, 0x0a, 0x18, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69,
	0x63, 0x69, 0x74, 0x79, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e,
	0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74, 0x79,
	0x12, 0x48, 0x0a, 0x11, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x78, 0x31, 0x5f,
	0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x78, 0x44,
	0x65, 0x6c, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x69, 0x72,
	0x65, 0x64, 0x52, 0x78, 0x31, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x63, 0x0a, 0x1c, 0x64, 0x65,
	0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x78, 0x31, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x52, 0x78,
	0x31, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12,
	0x60, 0x0a, 0x1b, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x78, 0x32, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65,
	0x64, 0x52, 0x78, 0x32, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x12, 0x52, 0x0a, 0x15, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x78, 0x32,
	0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x13, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x52, 0x78, 0x32, 0x46, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x5d, 0x0a, 0x16, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64,
	0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x75, 0x74, 0x79, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18,
	0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65,
	0x64, 0x44, 0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x13, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4d, 0x61, 0x78, 0x44, 0x75, 0x74, 0x79, 0x43,
	0x79, 0x63, 0x6c, 0x65, 0x12, 0x6c, 0x0a, 0x1e, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f,
	0x61, 0x64, 0x72, 0x5f, 0x61, 0x63, 0x6b, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x65, 0x78,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44,
	0x52, 0x41, 0x63, 0x6b, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1a, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x41,
	0x64, 0x72, 0x41, 0x63, 0x6b, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x12, 0x6c, 0x0a, 0x1e, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x64,
	0x72, 0x5f, 0x61, 0x63, 0x6b, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x41,
	0x63, 0x6b, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x1a, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x41, 0x64, 0x72,
	0x41, 0x63, 0x6b, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x12, 0x6b, 0x0a, 0x21, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x70, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x1c, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x50, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x65, 0x0a,
	0x1b, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6c,
	0x6f, 0x74, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x1c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x5a, 0x65, 0x72, 0x6f, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x64, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x50, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x46, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x12, 0x60, 0x0a, 0x18, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f,
	0x62, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x5a, 0x65, 0x72, 0x6f, 0x61, 0x62, 0x6c, 0x65,
	0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x42, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x46, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x49, 0x0a, 0x10, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65,
	0x64, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x69, 0x72, 0x70, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x45, 0x49, 0x52, 0x50, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0e, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4d, 0x61, 0x78, 0x45, 0x69, 0x72,
	0x70, 0x12, 0x57, 0x0a, 0x1b, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x62, 0x5f, 0x63, 0x5f, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
	0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x17, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x43, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69,
	0x6e, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x45, 0x0a, 0x11, 0x75, 0x70,
	0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x64, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0f, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x44, 0x77, 0x65, 0x6c, 0x6c, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x49, 0x0a, 0x13, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x64, 0x77,
	0x65, 0x6c, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c,
	0x69, 0x6e, 0x6b, 0x44, 0x77, 0x65, 0x6c, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x03,
	0x61, 0x64, 0x72, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x44, 0x52, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x03, 0x61, 0x64, 0x72, 0x12, 0x48, 0x0a, 0x12, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b,
	0x73, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x11, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x33, 0x0a, 0x05, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x24,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x05, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x42, 0x0a, 0x0d, 0x64, 0x65,
	0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x25, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x0c, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x3a, 0x08,
	0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0xbb, 0x01, 0x0a, 0x12, 0x4d, 0x41, 0x43,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12,
	0x51, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41,
	0x43, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x10, 0xfa, 0x42, 0x05,
	0x8a, 0x01, 0x02, 0x10, 0x01, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x28, 0x01, 0x52, 0x03, 0x69,
	0x64, 0x73, 0x12, 0x48, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x0b, 0x6d, 0x61, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x08, 0xf2, 0xaa,
	0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0xef, 0x29, 0x0a, 0x08, 0x4d, 0x41, 0x43, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x56, 0x0a, 0x12, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4d, 0x41, 0x43, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x11, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x56, 0x0a, 0x12, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x11, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x42, 0x0a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x4d, 0x0a, 0x0f, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4d, 0x41, 0x43, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x1a, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e,
	0x6b, 0x5f, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x17, 0x6c, 0x61, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x72, 0x6d, 0x65, 0x64, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x41, 0x74, 0x12,
	0x35, 0x0a, 0x18, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x64, 0x65, 0x76, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x5f, 0x75, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x13, 0x6c, 0x61, 0x73, 0x74, 0x44, 0x65, 0x76, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x46, 0x43, 0x6e, 0x74, 0x55, 0x70, 0x12, 0x57, 0x0a, 0x15, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x6c, 0x6f, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x50,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x70, 0x69, 0x6e, 0x67,
	0x53, 0x6c, 0x6f, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x69, 0x74, 0x79, 0x12,
	0x65, 0x0a, 0x1c, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x1a, 0x70, 0x65, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x45, 0x0a, 0x10, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64,
	0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x0f, 0x71, 0x75,
	0x65, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x45, 0x0a,
	0x10, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x43, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x52, 0x0f, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x12, 0x51, 0x0a, 0x12, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x5f, 0x6a,
	0x6f, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4a, 0x6f, 0x69, 0x6e, 0x41,
	0x63, 0x63, 0x65, 0x70, 0x74, 0x52, 0x10, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x4a, 0x6f, 0x69,
	0x6e, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x12, 0x56, 0x0a, 0x14, 0x70, 0x65, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e,
	0x4a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x12, 0x70, 0x65, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x30, 0x0a, 0x14, 0x72, 0x78, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x5f, 0x61, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x72,
	0x78, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x12, 0x4d, 0x0a, 0x0e, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x70, 0x6c, 0x69,
	0x6e, 0x6b, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x2e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x52, 0x0d, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x73,
	0x12, 0x53, 0x0a, 0x10, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c,
	0x69, 0x6e, 0x6b, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x52, 0x0f, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x66, 0x0a, 0x22, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x61, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x1e, 0x6c,
	0x61, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61,
	0x74, 0x65, 0x64, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x41, 0x74, 0x12, 0x72, 0x0a,
	0x1e, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x64, 0x72, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x18,
	0x11, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x42, 0x0f, 0xfa, 0x42, 0x0c, 0x92, 0x01, 0x09, 0x10, 0x0f, 0x22, 0x05,
	0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x1a, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41,
	0x64, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65,
	0x73, 0x12, 0x50, 0x0a, 0x1d, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x64,
	0x72, 0x5f, 0x74, 0x78, 0x5f, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x65, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0d, 0x42, 0x0e, 0xfa, 0x42, 0x0b, 0x92, 0x01, 0x08,
	0x10, 0x0f, 0x22, 0x04, 0x2a, 0x02, 0x18, 0x0f, 0x52, 0x19, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x41, 0x64, 0x72, 0x54, 0x78, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x14, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f,
	0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x13, 0x20, 0x03, 0x28,
	0x04, 0x42, 0x0e, 0xfa, 0x42, 0x0b, 0x92, 0x01, 0x08, 0x22, 0x06, 0x32, 0x04, 0x28, 0xa0, 0x8d,
	0x06, 0x52, 0x13, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x46, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x44, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x61, 0x74, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x6c, 0x61,
	0x73, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x41, 0x74, 0x12, 0x6f, 0x0a, 0x19,
	0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61,
	0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x15, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4d, 0x41, 0x43, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x16, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x35, 0x0a,
	0x18, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x61, 0x64, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x5f, 0x75, 0x70, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x13, 0x6c, 0x61, 0x73, 0x74, 0x41, 0x64, 0x72, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x46, 0x43,
	0x6e, 0x74, 0x55, 0x70, 0x12, 0x69, 0x0a, 0x1e, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x6d,
	0x61, 0x63, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41,
	0x43, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x52, 0x1b, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x63, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12,
	0x5d, 0x0a, 0x16, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x79,
	0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x52, 0x14, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x1a, 0x83,
	0x02, 0x0a, 0x0b, 0x4a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51,
	0x0a, 0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x4c, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x10, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x3c, 0x0a, 0x08, 0x72, 0x78, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x78, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x07, 0x72, 0x78, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12,
	0x2f, 0x0a, 0x07, 0x63, 0x66, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x43, 0x46, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x06, 0x63, 0x66, 0x4c, 0x69, 0x73, 0x74,
	0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02,
	0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x4a, 0x04, 0x08, 0x04,
	0x10, 0x05, 0x4a, 0x04, 0x08, 0x05, 0x10, 0x06, 0x4a, 0x04, 0x08, 0x09, 0x10, 0x0a, 0x4a, 0x04,
	0x08, 0x0a, 0x10, 0x0b, 0x1a, 0xd1, 0x07, 0x0a, 0x0a, 0x4a, 0x6f, 0x69, 0x6e, 0x41, 0x63, 0x63,
	0x65, 0x70, 0x74, 0x12, 0x23, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x42, 0x09, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x10, 0x11, 0x18, 0x21, 0x52,
	0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x48, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x2e, 0x4a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x35, 0x0a,
	0x0f, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0c, 0xfa, 0x42, 0x09, 0x92, 0x01, 0x06, 0x22, 0x04,
	0x72, 0x02, 0x18, 0x64, 0x52, 0x0e, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x73, 0x12, 0xed, 0x02, 0x0a, 0x08, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xd1, 0x02, 0x92, 0x41, 0x19, 0x4a, 0x0a, 0x22,
	0x32, 0x36, 0x30, 0x30, 0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x04, 0x70, 0x01, 0xea,
	0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c,
	0x34, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e,
	0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f,
	0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c,
	0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65,
	0x77, 0x34, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e,
	0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f,
	0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c,
	0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65,
	0x74, 0x45, 0x78, 0x61, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x07, 0x64, 0x65, 0x76,
	0x41, 0x64, 0x64, 0x72, 0x12, 0xe7, 0x02, 0x0a, 0x06, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xcf, 0x02, 0x92, 0x41, 0x17, 0x4a, 0x08, 0x22, 0x30, 0x30,
	0x30, 0x30, 0x31, 0x33, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x03, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01,
	0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x33, 0x42, 0x79, 0x74,
	0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63,
	0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e, 0x65, 0x77, 0x33, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x63,
	0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x61,
	0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x05, 0x6e, 0x65, 0x74, 0x49, 0x64, 0x3a, 0x08,
	0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x1a, 0xf3, 0x08, 0x0a, 0x0d, 0x55, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3b, 0x0a, 0x07, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x07,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x57, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x2e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x54, 0x78, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x52, 0x0a, 0x0b, 0x72, 0x78, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e,
	0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x52, 0x78,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0a, 0x72, 0x78, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64,
	0x5f, 0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x41,
	0x74, 0x12, 0x35, 0x0a, 0x0f, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0c, 0xfa, 0x42, 0x09, 0x92,
	0x01, 0x06, 0x22, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x0e, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x3a, 0x0a, 0x14, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xff, 0x01,
	0x52, 0x12, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x1a, 0x53, 0x0a, 0x0a, 0x54, 0x78, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x3f, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x61, 0x74, 0x65, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x0a, 0x1a, 0xda, 0x04, 0x0a, 0x0a, 0x52, 0x78,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4d, 0x0a, 0x0b, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x5f, 0x72, 0x73, 0x73, 0x69, 0x18, 0x09, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0b, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x73, 0x73, 0x69, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x6e,
	0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x02, 0x52, 0x03, 0x73, 0x6e, 0x72, 0x12, 0x6a, 0x0a, 0x18,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x63, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x16, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x43, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x75, 0x70, 0x6c, 0x69,
	0x6e, 0x6b, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b,
	0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x6b, 0x0a, 0x0d, 0x70,
	0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x46, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x55, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x52, 0x78, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b,
	0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0c, 0x70, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x05, 0x72, 0x65, 0x6c, 0x61,
	0x79, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x2e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x52, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x05, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x1a,
	0x1c, 0x0a, 0x14, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x0b, 0x1a, 0x15, 0x0a,
	0x0d, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x04,
	0x08, 0x01, 0x10, 0x04, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x09, 0x4a, 0x04, 0x08, 0x0a, 0x10, 0x0b,
	0x4a, 0x04, 0x08, 0x0c, 0x10, 0x0d, 0x4a, 0x04, 0x08, 0x0d, 0x10, 0x0e, 0x4a, 0x04, 0x08, 0x10,
	0x10, 0x11, 0x4a, 0x04, 0x08, 0x11, 0x10, 0x12, 0x4a, 0x04, 0x08, 0x13, 0x10, 0x14, 0x4a, 0x04,
	0x08, 0x14, 0x10, 0x15, 0x4a, 0x04, 0x08, 0x15, 0x10, 0x16, 0x4a, 0x04, 0x08, 0x16, 0x10, 0x17,
	0x4a, 0x04, 0x08, 0x63, 0x10, 0x64, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x4a, 0x04, 0x08, 0x03,
	0x10, 0x04, 0x4a, 0x04, 0x08, 0x08, 0x10, 0x09, 0x4a, 0x04, 0x08, 0x0a, 0x10, 0x0b, 0x1a, 0x97,
	0x04, 0x0a, 0x0f, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x4a, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x35,
	0x0a, 0x0f, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0c, 0xfa, 0x42, 0x09, 0x92, 0x01, 0x06, 0x22,
	0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x0e, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x73, 0x1a, 0xee, 0x02, 0x0a, 0x07, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x54, 0x0a, 0x05, 0x6d, 0x5f, 0x68, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c,
	0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x2e, 0x4d, 0x48, 0x44, 0x52, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x04, 0x6d, 0x48, 0x64, 0x72, 0x12, 0x5c, 0x0a, 0x0b, 0x6d, 0x61, 0x63, 0x5f, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41,
	0x43, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x4d,
	0x41, 0x43, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x0a, 0x6d, 0x61, 0x63, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x1a, 0x44, 0x0a, 0x04, 0x4d, 0x48, 0x44, 0x52, 0x12, 0x36, 0x0a,
	0x06, 0x6d, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05,
	0x6d, 0x54, 0x79, 0x70, 0x65, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x1a, 0x5d, 0x0a, 0x0a, 0x4d,
	0x41, 0x43, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1f, 0x0a, 0x06, 0x66, 0x5f, 0x70,
	0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03,
	0x18, 0xff, 0x01, 0x52, 0x05, 0x66, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x1c, 0x0a, 0x0a, 0x66, 0x75,
	0x6c, 0x6c, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08,
	0x66, 0x75, 0x6c, 0x6c, 0x46, 0x43, 0x6e, 0x74, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x4a, 0x04,
	0x08, 0x03, 0x10, 0x04, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03,
	0x4a, 0x04, 0x08, 0x04, 0x10, 0x08, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x4a, 0x04, 0x08, 0x03,
	0x10, 0x06, 0x4a, 0x04, 0x08, 0x07, 0x10, 0x08, 0x1a, 0xc9, 0x01, 0x0a, 0x0d, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x56, 0x0a, 0x13, 0x6d, 0x69,
	0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x10, 0x6d, 0x69, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x12, 0x56, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x10, 0x6d, 0x61, 0x78, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04,
	0x08, 0x01, 0x10, 0x01, 0x1a, 0x64, 0x0a, 0x0e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x06, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x06, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x1a, 0x72, 0x0a, 0x1b, 0x52, 0x65,
	0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x08,
	0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0xcb, 0x01, 0x0a, 0x1b, 0x45, 0x6e, 0x64,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1a, 0xfa, 0x42, 0x17, 0x72, 0x15, 0x32, 0x13,
	0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x7b, 0x31, 0x2c, 0x33,
	0x32, 0x7d, 0x24, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x46, 0x72, 0x6f, 0x6d, 0x12, 0x35, 0x0a, 0x08, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x74,
	0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x07, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x54, 0x6f, 0x3a, 0x08, 0xf2, 0xaa,
	0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x22, 0xd7, 0x21, 0x0a, 0x09, 0x45, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x48, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x10, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10,
	0x01, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x28, 0x01, 0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x43,
	0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x08,
	0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x00, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x41, 0x74, 0x12, 0x43, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x00, 0x52, 0x09, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x1b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x32, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72,
	0x03, 0x18, 0xd0, 0x0f, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x80, 0x01, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x35, 0xfa, 0x42, 0x32, 0x9a, 0x01, 0x2f, 0x10, 0x0a, 0x22, 0x24, 0x72, 0x22, 0x18,
	0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b,
	0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d,
	0x24, 0x2a, 0x05, 0x72, 0x03, 0x18, 0xc8, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x73, 0x12, 0x35, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07,
	0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x40, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0xc5, 0x01, 0x0a, 0x16, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x8e, 0x01, 0xfa, 0x42, 0x8a,
	0x01, 0x72, 0x87, 0x01, 0x32, 0x84, 0x01, 0x5e, 0x28, 0x3f, 0x3a, 0x28, 0x3f, 0x3a, 0x5b, 0x61,
	0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x7c, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d,
	0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5c,
	0x2d, 0x5d, 0x2a, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x5c,
	0x2e, 0x29, 0x2a, 0x28, 0x3f, 0x3a, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39,
	0x5d, 0x7c, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x41, 0x2d,
	0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5c, 0x2d, 0x5d, 0x2a, 0x5b, 0x41, 0x2d, 0x5a, 0x61,
	0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x28, 0x3f, 0x3a, 0x3a, 0x5b, 0x30, 0x2d, 0x39, 0x5d,
	0x7b, 0x31, 0x2c, 0x35, 0x7d, 0x29, 0x3f, 0x24, 0x7c, 0x5e, 0x24, 0x52, 0x14, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x41, 0x0a, 0x18, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x6b, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x2f, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x18, 0x80, 0x10, 0x52, 0x15, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4b, 0x65, 0x6b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x12, 0xcd, 0x01, 0x0a, 0x1a, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x8e, 0x01, 0xfa, 0x42, 0x8a, 0x01,
	0x72, 0x87, 0x01, 0x32, 0x84, 0x01, 0x5e, 0x28, 0x3f, 0x3a, 0x28, 0x3f, 0x3a, 0x5b, 0x61, 0x2d,
	0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x7c, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a,
	0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5c, 0x2d,
	0x5d, 0x2a, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x5c, 0x2e,
	0x29, 0x2a, 0x28, 0x3f, 0x3a, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d,
	0x7c, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x41, 0x2d, 0x5a,
	0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5c, 0x2d, 0x5d, 0x2a, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d,
	0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x28, 0x3f, 0x3a, 0x3a, 0x5b, 0x30, 0x2d, 0x39, 0x5d, 0x7b,
	0x31, 0x2c, 0x35, 0x7d, 0x29, 0x3f, 0x24, 0x7c, 0x5e, 0x24, 0x52, 0x18, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x12, 0x49, 0x0a, 0x1c, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x6b, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x18, 0x30, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72,
	0x03, 0x18, 0x80, 0x10, 0x52, 0x19, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4b, 0x65, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12,
	0x3b, 0x0a, 0x15, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x31, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07,
	0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x13, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x49, 0x64, 0x12, 0xbf, 0x01, 0x0a,
	0x13, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x8e, 0x01, 0xfa, 0x42, 0x8a,
	0x01, 0x72, 0x87, 0x01, 0x32, 0x84, 0x01, 0x5e, 0x28, 0x3f, 0x3a, 0x28, 0x3f, 0x3a, 0x5b, 0x61,
	0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x7c, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d,
	0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5c,
	0x2d, 0x5d, 0x2a, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x5c,
	0x2e, 0x29, 0x2a, 0x28, 0x3f, 0x3a, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39,
	0x5d, 0x7c, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x41, 0x2d,
	0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5c, 0x2d, 0x5d, 0x2a, 0x5b, 0x41, 0x2d, 0x5a, 0x61,
	0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x28, 0x3f, 0x3a, 0x3a, 0x5b, 0x30, 0x2d, 0x39, 0x5d,
	0x7b, 0x31, 0x2c, 0x35, 0x7d, 0x29, 0x3f, 0x24, 0x7c, 0x5e, 0x24, 0x52, 0x11, 0x6a, 0x6f, 0x69,
	0x6e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x74,
	0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x2c, 0xfa, 0x42, 0x29,
	0x9a, 0x01, 0x26, 0x22, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a,
	0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30,
	0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x31, 0x0a, 0x07, 0x70, 0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18,
	0x32, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x07,
	0x70, 0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x62, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x42, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x5f, 0x63, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x43, 0x12, 0x4d, 0x0a, 0x0f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x13, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x5f, 0x70, 0x68, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x48, 0x59, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x11, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x50, 0x68, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x33, 0x0a, 0x11, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x70, 0x6c,
	0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04,
	0x72, 0x02, 0x18, 0x40, 0x52, 0x0f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x50,
	0x6c, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x5f, 0x66, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x12, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x6d, 0x69,
	0x6e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61,
	0x78, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12,
	0x23, 0x0a, 0x0d, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x6a, 0x6f, 0x69, 0x6e,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x4a, 0x6f, 0x69, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x65, 0x74, 0x73, 0x5f, 0x6a,
	0x6f, 0x69, 0x6e, 0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x10, 0x72, 0x65, 0x73, 0x65, 0x74, 0x73, 0x4a, 0x6f, 0x69, 0x6e, 0x4e, 0x6f, 0x6e, 0x63,
	0x65, 0x73, 0x12, 0x35, 0x0a, 0x09, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18,
	0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x6f, 0x6f, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x52,
	0x08, 0x72, 0x6f, 0x6f, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x12, 0xe7, 0x02, 0x0a, 0x06, 0x6e, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xcf, 0x02, 0x92, 0x41, 0x17,
	0x4a, 0x08, 0x22, 0x30, 0x30, 0x30, 0x30, 0x31, 0x33, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02,
	0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x03, 0x70, 0x01,
	0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45,
	0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b,
	0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61,
	0x6c, 0x33, 0x42, 0x79, 0x74, 0x65, 0x73, 0xf2, 0xaa, 0x19, 0xa0, 0x01, 0x1a, 0x4e, 0x67, 0x6f,
	0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63,
	0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x4e,
	0x65, 0x77, 0x33, 0x42, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6c, 0x61, 0x67, 0x22, 0x4e, 0x67, 0x6f,
	0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x74, 0x74, 0x6e, 0x2d, 0x6c, 0x77, 0x2d, 0x63,
	0x6c, 0x69, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2e, 0x47,
	0x65, 0x74, 0x45, 0x78, 0x61, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x05, 0x6e, 0x65,
	0x74, 0x49, 0x64, 0x12, 0x3e, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x35, 0x0a, 0x09, 0x6d, 0x61, 0x63, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x08, 0x6d, 0x61, 0x63, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x44, 0x0a, 0x11, 0x70, 0x65,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x61, 0x63, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x2c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x41, 0x43, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x0f, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x61, 0x63, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x31, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x1a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0f, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x64, 0x65,
	0x76, 0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x6c,
	0x61, 0x73, 0x74, 0x44, 0x65, 0x76, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x75,
	0x73, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x1d,
	0x20, 0x03, 0x28, 0x0d, 0x52, 0x0d, 0x75, 0x73, 0x65, 0x64, 0x44, 0x65, 0x76, 0x4e, 0x6f, 0x6e,
	0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6a, 0x6f, 0x69, 0x6e,
	0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x6c, 0x61,
	0x73, 0x74, 0x4a, 0x6f, 0x69, 0x6e, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0f, 0x6c,
	0x61, 0x73, 0x74, 0x5f, 0x72, 0x6a, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x30, 0x18, 0x1f,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x52, 0x6a, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x30, 0x12, 0x25, 0x0a, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x6a, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x31, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x6c, 0x61, 0x73,
	0x74, 0x52, 0x6a, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x31, 0x12, 0x58, 0x0a, 0x1b, 0x6c, 0x61, 0x73,
	0x74, 0x5f, 0x64, 0x65, 0x76, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x72, 0x65, 0x63,
	0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x17, 0x6c, 0x61, 0x73, 0x74,
	0x44, 0x65, 0x76, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65,
	0x64, 0x41, 0x74, 0x12, 0x4b, 0x0a, 0x0b, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x0e, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0xf2, 0xaa,
	0x19, 0x02, 0x10, 0x00, 0x52, 0x0a, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x5b, 0x0a, 0x12, 0x62, 0x61, 0x74, 0x74, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0f, 0xfa, 0x42, 0x0c, 0x0a, 0x0a,
	0x1d, 0x00, 0x00, 0x80, 0x3f, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x52, 0x11, 0x62, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x79, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x12, 0x27, 0x0a,
	0x0f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e,
	0x18, 0x24, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b,
	0x4d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x12, 0x65, 0x0a, 0x1c, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64,
	0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x6f, 0x77,
	0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x28, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e,
	0x6b, 0x52, 0x1a, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x48, 0x0a,
	0x0a, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x73, 0x18, 0x29, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0a, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x73, 0x12, 0x51, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xfa, 0x42, 0x27, 0x72, 0x25, 0x18, 0x24, 0x32, 0x21, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30,
	0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d,
	0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x7c, 0x5e, 0x24, 0x52, 0x0d, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x11, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x2b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x10,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x1c, 0x0a, 0x09, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74, 0x18, 0x2d, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x09, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74, 0x12, 0x67,
	0x0a, 0x19, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x2e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68,
	0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x17,
	0x63, 0x6c, 0x61, 0x69, 0x6d, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x6b, 0x69, 0x70, 0x5f,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x18, 0x33,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x73, 0x6b, 0x69, 0x70, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x12, 0x5b, 0x0a, 0x1c, 0x73, 0x6b, 0x69, 0x70, 0x5f,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x34, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x19, 0x73, 0x6b, 0x69, 0x70, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x12, 0x3d, 0x0a, 0x0c, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x61, 0x74, 0x18, 0x35, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x64, 0x41, 0x74, 0x12, 0x3c, 0x0a, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x65, 0x65, 0x6e,
	0x5f, 0x61, 0x74, 0x18, 0x36, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x65, 0x65, 0x6e, 0x41,
	0x74, 0x12, 0x4f, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x18, 0x37, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x42, 0x27, 0x72, 0x25, 0x18,
	0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b,
	0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d,
	0x24, 0xd0, 0x01, 0x01, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x12, 0x69, 0x0a, 0x19, 0x6c, 0x6f, 0x72, 0x61, 0x5f, 0x61, 0x6c, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x38, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x6f, 0x52, 0x61, 0x41, 0x6c, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x16, 0x6c, 0x6f, 0x72, 0x61, 0x41, 0x6c, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x73, 0x1a, 0x3d, 0x0a,
	0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x56, 0x0a, 0x0e,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x2e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x18, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x4a, 0x04,
	0x08, 0x25, 0x10, 0x26, 0x4a, 0x04, 0x08, 0x26, 0x10, 0x27, 0x4a, 0x04, 0x08, 0x27, 0x10, 0x28,
	0x22, 0x48, 0x0a, 0x0a, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x3a,
	0x0a, 0x0b, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x0a,
	0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x22, 0xf2, 0x01, 0x0a, 0x0d, 0x44,
	0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0xc8, 0x01, 0x0a,
	0x08, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42,
	0xac, 0x01, 0x92, 0x41, 0x19, 0x4a, 0x0a, 0x22, 0x32, 0x36, 0x30, 0x30, 0x41, 0x42, 0x43, 0x44,
	0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42,
	0x06, 0x7a, 0x04, 0x68, 0x04, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f,
	0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61,
	0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67,
	0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55,
	0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x34, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x07,
	0x64, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74,
	0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22,
	0x5c, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x0a, 0x65, 0x6e, 0x64,
	0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45,
	0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x22, 0x97, 0x01,
	0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x0a, 0x65, 0x6e, 0x64, 0x5f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x39, 0x0a, 0x0a,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa8, 0x02, 0x0a, 0x23, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x4c, 0x61, 0x73, 0x74, 0x53, 0x65, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x65, 0x0a, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x4b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x61, 0x73, 0x74, 0x53, 0x65, 0x65, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4c,
	0x61, 0x73, 0x74, 0x53, 0x65, 0x65, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x07, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x1a, 0x99, 0x01, 0x0a, 0x17, 0x45, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x4c, 0x61, 0x73, 0x74, 0x53, 0x65, 0x65, 0x6e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x12, 0x40, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x03, 0x69, 0x64, 0x73, 0x12, 0x3c, 0x0a, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x65, 0x65,
	0x6e, 0x5f, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x65, 0x65, 0x6e,
	0x41, 0x74, 0x22, 0xa6, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x65, 0x6e,
	0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73,
	0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xcb, 0x03, 0x0a, 0x25,
	0x47, 0x65, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x46, 0x6f, 0x72, 0x45, 0x55, 0x49, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0xd0, 0x01, 0x0a, 0x08, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x65,
	0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xb4, 0x01, 0x92, 0x41, 0x21, 0x4a, 0x12,
	0x22, 0x37, 0x30, 0x42, 0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30, 0x41, 0x42, 0x43,
	0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa,
	0x42, 0x06, 0x7a, 0x04, 0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67,
	0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d,
	0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f,
	0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e,
	0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52,
	0x07, 0x6a, 0x6f, 0x69, 0x6e, 0x45, 0x75, 0x69, 0x12, 0xce, 0x01, 0x0a, 0x07, 0x64, 0x65, 0x76,
	0x5f, 0x65, 0x75, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xb4, 0x01, 0x92, 0x41, 0x21,
	0x4a, 0x12, 0x22, 0x37, 0x30, 0x42, 0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30, 0x41,
	0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a,
	0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69, 0x22, 0xbf, 0x04, 0x0a, 0x15, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12,
	0xbd, 0x01, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0xa6, 0x01, 0xfa, 0x42, 0xa2, 0x01, 0x72, 0x9f, 0x01, 0x52, 0x00, 0x52, 0x09, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x52, 0x0a, 0x2d, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x52, 0x08, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x65, 0x75, 0x69, 0x52, 0x09, 0x2d, 0x6a,
	0x6f, 0x69, 0x6e, 0x5f, 0x65, 0x75, 0x69, 0x52, 0x07, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69,
	0x52, 0x08, 0x2d, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x52, 0x05, 0x2d, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x2d, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x52, 0x0b,
	0x2d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x52, 0x0c, 0x6c, 0x61, 0x73,
	0x74, 0x5f, 0x73, 0x65, 0x65, 0x6e, 0x5f, 0x61, 0x74, 0x52, 0x0d, 0x2d, 0x6c, 0x61, 0x73, 0x74,
	0x5f, 0x73, 0x65, 0x65, 0x6e, 0x5f, 0x61, 0x74, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x12,
	0x1e, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xe8, 0x07, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x70, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x70,
	0x61, 0x67, 0x65, 0x12, 0x46, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x5e, 0x0a, 0x06, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4b, 0x0a, 0x0d, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x08, 0xfa, 0x42, 0x05, 0xb2, 0x01, 0x02,
	0x38, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x53, 0x69, 0x6e,
	0x63, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x22, 0x94, 0x01, 0x0a, 0x13,
	0x53, 0x65, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x0a, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x09, 0x65, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0xae, 0x01, 0x0a, 0x1b, 0x52, 0x65, 0x73, 0x65, 0x74, 0x41, 0x6e, 0x64, 0x47,
	0x65, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0xbc, 0x01, 0x0a, 0x11, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x42, 0x0a, 0x0a, 0x65, 0x6e, 0x64,
	0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45,
	0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x39, 0x0a,
	0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x28, 0x0a, 0x0b, 0x6d, 0x61, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa,
	0x42, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x0a, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x4b,
	0x65, 0x79, 0x22, 0xb8, 0x01, 0x0a, 0x17, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1b,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42,
	0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x18, 0xc8, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x2b, 0xfa, 0x42, 0x28, 0x92, 0x01, 0x25, 0x10, 0x64, 0x18, 0x01, 0x22, 0x1f, 0x72, 0x1d,
	0x32, 0x1b, 0x5e, 0x28, 0x3f, 0x3a, 0x5c, 0x2e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d,
	0x7b, 0x31, 0x2c, 0x31, 0x36, 0x7d, 0x29, 0x7b, 0x31, 0x2c, 0x32, 0x7d, 0x24, 0x52, 0x0e, 0x66,
	0x69, 0x6c, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xfe, 0x01,
	0x0a, 0x18, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x12, 0x7d, 0x0a, 0x07, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x73, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x2c, 0xfa, 0x42, 0x29, 0x9a, 0x01, 0x26, 0x22, 0x24, 0x72, 0x22, 0x18, 0x24,
	0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d,
	0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24,
	0x52, 0x07, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x1a, 0x63, 0x0a, 0x0c, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xdd,
	0x01, 0x0a, 0x1f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x09, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x42, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e,
	0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f,
	0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x08,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x60, 0x0a, 0x16,
	0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x13, 0x65, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x22, 0xca,
	0x01, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x59, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x4f, 0x0a, 0x0a, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x30,
	0xfa, 0x42, 0x2d, 0x92, 0x01, 0x2a, 0x08, 0x01, 0x10, 0x14, 0x22, 0x24, 0x72, 0x22, 0x18, 0x24,
	0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d,
	0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24,
	0x52, 0x09, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x22, 0xa8, 0x02, 0x0a, 0x19,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0f, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x73, 0x12, 0x4f, 0x0a, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x30, 0xfa, 0x42, 0x2d, 0x92, 0x01, 0x2a,
	0x08, 0x01, 0x10, 0x14, 0x22, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d,
	0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a,
	0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x09, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x4a, 0x04, 0x08, 0x05, 0x10, 0x06, 0x4a, 0x04, 0x08, 0x06,
	0x10, 0x07, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x52, 0x04, 0x70, 0x61, 0x67, 0x65, 0x2a, 0x55, 0x0a, 0x0a, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x4f, 0x57, 0x45, 0x52, 0x5f, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x4f, 0x57, 0x45, 0x52,
	0x5f, 0x42, 0x41, 0x54, 0x54, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x4f,
	0x57, 0x45, 0x52, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x1a, 0x0d,
	0xea, 0xaa, 0x19, 0x09, 0x18, 0x01, 0x2a, 0x05, 0x50, 0x4f, 0x57, 0x45, 0x52, 0x42, 0x31, 0x5a,
	0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_end_device_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_end_device_proto_rawDescData = file_ttn_lorawan_v3_end_device_proto_rawDesc
)

func file_ttn_lorawan_v3_end_device_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_end_device_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_end_device_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_end_device_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_end_device_proto_rawDescData
}

var file_ttn_lorawan_v3_end_device_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_ttn_lorawan_v3_end_device_proto_msgTypes = make([]protoimpl.MessageInfo, 62)
var file_ttn_lorawan_v3_end_device_proto_goTypes = []interface{}{
	(PowerState)(0),                                          // 0: ttn.lorawan.v3.PowerState
	(*Session)(nil),                                          // 1: ttn.lorawan.v3.Session
	(*BoolValue)(nil),                                        // 2: ttn.lorawan.v3.BoolValue
	(*ServingRelayForwardingLimits)(nil),                     // 3: ttn.lorawan.v3.ServingRelayForwardingLimits
	(*RelayUplinkForwardingRule)(nil),                        // 4: ttn.lorawan.v3.RelayUplinkForwardingRule
	(*ServingRelayParameters)(nil),                           // 5: ttn.lorawan.v3.ServingRelayParameters
	(*ServedRelayParameters)(nil),                            // 6: ttn.lorawan.v3.ServedRelayParameters
	(*RelayParameters)(nil),                                  // 7: ttn.lorawan.v3.RelayParameters
	(*ServingRelaySettings)(nil),                             // 8: ttn.lorawan.v3.ServingRelaySettings
	(*ServedRelaySettings)(nil),                              // 9: ttn.lorawan.v3.ServedRelaySettings
	(*RelaySettings)(nil),                                    // 10: ttn.lorawan.v3.RelaySettings
	(*MACParameters)(nil),                                    // 11: ttn.lorawan.v3.MACParameters
	(*EndDeviceVersion)(nil),                                 // 12: ttn.lorawan.v3.EndDeviceVersion
	(*ADRSettings)(nil),                                      // 13: ttn.lorawan.v3.ADRSettings
	(*MACSettings)(nil),                                      // 14: ttn.lorawan.v3.MACSettings
	(*MACSettingsProfile)(nil),                               // 15: ttn.lorawan.v3.MACSettingsProfile
	(*MACState)(nil),                                         // 16: ttn.lorawan.v3.MACState
	(*EndDeviceAuthenticationCode)(nil),                      // 17: ttn.lorawan.v3.EndDeviceAuthenticationCode
	(*EndDevice)(nil),                                        // 18: ttn.lorawan.v3.EndDevice
	(*EndDevices)(nil),                                       // 19: ttn.lorawan.v3.EndDevices
	(*DevAddrPrefix)(nil),                                    // 20: ttn.lorawan.v3.DevAddrPrefix
	(*CreateEndDeviceRequest)(nil),                           // 21: ttn.lorawan.v3.CreateEndDeviceRequest
	(*UpdateEndDeviceRequest)(nil),                           // 22: ttn.lorawan.v3.UpdateEndDeviceRequest
	(*BatchUpdateEndDeviceLastSeenRequest)(nil),              // 23: ttn.lorawan.v3.BatchUpdateEndDeviceLastSeenRequest
	(*GetEndDeviceRequest)(nil),                              // 24: ttn.lorawan.v3.GetEndDeviceRequest
	(*GetEndDeviceIdentifiersForEUIsRequest)(nil),            // 25: ttn.lorawan.v3.GetEndDeviceIdentifiersForEUIsRequest
	(*ListEndDevicesRequest)(nil),                            // 26: ttn.lorawan.v3.ListEndDevicesRequest
	(*SetEndDeviceRequest)(nil),                              // 27: ttn.lorawan.v3.SetEndDeviceRequest
	(*ResetAndGetEndDeviceRequest)(nil),                      // 28: ttn.lorawan.v3.ResetAndGetEndDeviceRequest
	(*EndDeviceTemplate)(nil),                                // 29: ttn.lorawan.v3.EndDeviceTemplate
	(*EndDeviceTemplateFormat)(nil),                          // 30: ttn.lorawan.v3.EndDeviceTemplateFormat
	(*EndDeviceTemplateFormats)(nil),                         // 31: ttn.lorawan.v3.EndDeviceTemplateFormats
	(*ConvertEndDeviceTemplateRequest)(nil),                  // 32: ttn.lorawan.v3.ConvertEndDeviceTemplateRequest
	(*BatchDeleteEndDevicesRequest)(nil),                     // 33: ttn.lorawan.v3.BatchDeleteEndDevicesRequest
	(*BatchGetEndDevicesRequest)(nil),                        // 34: ttn.lorawan.v3.BatchGetEndDevicesRequest
	(*MACParameters_Channel)(nil),                            // 35: ttn.lorawan.v3.MACParameters.Channel
	(*ADRSettings_StaticMode)(nil),                           // 36: ttn.lorawan.v3.ADRSettings.StaticMode
	(*ADRSettings_DynamicMode)(nil),                          // 37: ttn.lorawan.v3.ADRSettings.DynamicMode
	(*ADRSettings_DisabledMode)(nil),                         // 38: ttn.lorawan.v3.ADRSettings.DisabledMode
	(*ADRSettings_DynamicMode_ChannelSteeringSettings)(nil),  // 39: ttn.lorawan.v3.ADRSettings.DynamicMode.ChannelSteeringSettings
	(*ADRSettings_DynamicMode_PerDataRateIndexOverride)(nil), // 40: ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	(*ADRSettings_DynamicMode_Overrides)(nil),                // 41: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides
	(*ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode)(nil), // 42: ttn.lorawan.v3.ADRSettings.DynamicMode.ChannelSteeringSettings.LoRaNarrowMode
	(*ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode)(nil),   // 43: ttn.lorawan.v3.ADRSettings.DynamicMode.ChannelSteeringSettings.DisabledMode
	(*MACState_JoinRequest)(nil),                                           // 44: ttn.lorawan.v3.MACState.JoinRequest
	(*MACState_JoinAccept)(nil),                                            // 45: ttn.lorawan.v3.MACState.JoinAccept
	(*MACState_UplinkMessage)(nil),                                         // 46: ttn.lorawan.v3.MACState.UplinkMessage
	(*MACState_DownlinkMessage)(nil),                                       // 47: ttn.lorawan.v3.MACState.DownlinkMessage
	(*MACState_DataRateRange)(nil),                                         // 48: ttn.lorawan.v3.MACState.DataRateRange
	(*MACState_DataRateRanges)(nil),                                        // 49: ttn.lorawan.v3.MACState.DataRateRanges
	nil,                                                                    // 50: ttn.lorawan.v3.MACState.RejectedDataRateRangesEntry
	(*MACState_UplinkMessage_TxSettings)(nil),                              // 51: ttn.lorawan.v3.MACState.UplinkMessage.TxSettings
	(*MACState_UplinkMessage_RxMetadata)(nil),                              // 52: ttn.lorawan.v3.MACState.UplinkMessage.RxMetadata
	(*MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata)(nil),         // 53: ttn.lorawan.v3.MACState.UplinkMessage.RxMetadata.PacketBrokerMetadata
	(*MACState_UplinkMessage_RxMetadata_RelayMetadata)(nil),                // 54: ttn.lorawan.v3.MACState.UplinkMessage.RxMetadata.RelayMetadata
	(*MACState_DownlinkMessage_Message)(nil),                               // 55: ttn.lorawan.v3.MACState.DownlinkMessage.Message
	(*MACState_DownlinkMessage_Message_MHDR)(nil),                          // 56: ttn.lorawan.v3.MACState.DownlinkMessage.Message.MHDR
	(*MACState_DownlinkMessage_Message_MACPayload)(nil),                    // 57: ttn.lorawan.v3.MACState.DownlinkMessage.Message.MACPayload
	nil, // 58: ttn.lorawan.v3.EndDevice.AttributesEntry
	nil, // 59: ttn.lorawan.v3.EndDevice.LocationsEntry
	(*BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate)(nil), // 60: ttn.lorawan.v3.BatchUpdateEndDeviceLastSeenRequest.EndDeviceLastSeenUpdate
	(*ListEndDevicesRequest_Filter)(nil),                                // 61: ttn.lorawan.v3.ListEndDevicesRequest.Filter
	nil,                                                                 // 62: ttn.lorawan.v3.EndDeviceTemplateFormats.FormatsEntry
	(*SessionKeys)(nil),                                                 // 63: ttn.lorawan.v3.SessionKeys
	(*timestamppb.Timestamp)(nil),                                       // 64: google.protobuf.Timestamp
	(*ApplicationDownlink)(nil),                                         // 65: ttn.lorawan.v3.ApplicationDownlink
	(RelayResetLimitCounter)(0),                                         // 66: ttn.lorawan.v3.RelayResetLimitCounter
	(*RelayForwardLimits)(nil),                                          // 67: ttn.lorawan.v3.RelayForwardLimits
	(*RelayUplinkForwardLimits)(nil),                                    // 68: ttn.lorawan.v3.RelayUplinkForwardLimits
	(*RelaySecondChannel)(nil),                                          // 69: ttn.lorawan.v3.RelaySecondChannel
	(RelayCADPeriodicity)(0),                                            // 70: ttn.lorawan.v3.RelayCADPeriodicity
	(*RelayEndDeviceAlwaysMode)(nil),                                    // 71: ttn.lorawan.v3.RelayEndDeviceAlwaysMode
	(*RelayEndDeviceDynamicMode)(nil),                                   // 72: ttn.lorawan.v3.RelayEndDeviceDynamicMode
	(*RelayEndDeviceControlledMode)(nil),                                // 73: ttn.lorawan.v3.RelayEndDeviceControlledMode
	(*wrapperspb.UInt32Value)(nil),                                      // 74: google.protobuf.UInt32Value
	(DataRateIndex)(0),                                                  // 75: ttn.lorawan.v3.DataRateIndex
	(RxDelay)(0),                                                        // 76: ttn.lorawan.v3.RxDelay
	(DataRateOffset)(0),                                                 // 77: ttn.lorawan.v3.DataRateOffset
	(AggregatedDutyCycle)(0),                                            // 78: ttn.lorawan.v3.AggregatedDutyCycle
	(RejoinTimeExponent)(0),                                             // 79: ttn.lorawan.v3.RejoinTimeExponent
	(RejoinCountExponent)(0),                                            // 80: ttn.lorawan.v3.RejoinCountExponent
	(*ADRAckLimitExponentValue)(nil),                                    // 81: ttn.lorawan.v3.ADRAckLimitExponentValue
	(*ADRAckDelayExponentValue)(nil),                                    // 82: ttn.lorawan.v3.ADRAckDelayExponentValue
	(*DataRateIndexValue)(nil),                                          // 83: ttn.lorawan.v3.DataRateIndexValue
	(*EndDeviceVersionIdentifiers)(nil),                                 // 84: ttn.lorawan.v3.EndDeviceVersionIdentifiers
	(MACVersion)(0),                                                     // 85: ttn.lorawan.v3.MACVersion
	(PHYVersion)(0),                                                     // 86: ttn.lorawan.v3.PHYVersion
	(*MessagePayloadFormatters)(nil),                                    // 87: ttn.lorawan.v3.MessagePayloadFormatters
	(*durationpb.Duration)(nil),                                         // 88: google.protobuf.Duration
	(*PingSlotPeriodValue)(nil),                                         // 89: ttn.lorawan.v3.PingSlotPeriodValue
	(*ZeroableFrequencyValue)(nil),                                      // 90: ttn.lorawan.v3.ZeroableFrequencyValue
	(*RxDelayValue)(nil),                                                // 91: ttn.lorawan.v3.RxDelayValue
	(*DataRateOffsetValue)(nil),                                         // 92: ttn.lorawan.v3.DataRateOffsetValue
	(*FrequencyValue)(nil),                                              // 93: ttn.lorawan.v3.FrequencyValue
	(*AggregatedDutyCycleValue)(nil),                                    // 94: ttn.lorawan.v3.AggregatedDutyCycleValue
	(*wrapperspb.FloatValue)(nil),                                       // 95: google.protobuf.FloatValue
	(*DeviceEIRPValue)(nil),                                             // 96: ttn.lorawan.v3.DeviceEIRPValue
	(*MACSettingsProfileIdentifiers)(nil),                               // 97: ttn.lorawan.v3.MACSettingsProfileIdentifiers
	(Class)(0),                                                          // 98: ttn.lorawan.v3.Class
	(*MACCommand)(nil),                                                  // 99: ttn.lorawan.v3.MACCommand
	(MACCommandIdentifier)(0),                                           // 100: ttn.lorawan.v3.MACCommandIdentifier
	(*RelayForwardDownlinkReq)(nil),                                     // 101: ttn.lorawan.v3.RelayForwardDownlinkReq
	(*EndDeviceIdentifiers)(nil),                                        // 102: ttn.lorawan.v3.EndDeviceIdentifiers
	(*Picture)(nil),                                                     // 103: ttn.lorawan.v3.Picture
	(*RootKeys)(nil),                                                    // 104: ttn.lorawan.v3.RootKeys
	(*structpb.Struct)(nil),                                             // 105: google.protobuf.Struct
	(*wrapperspb.BoolValue)(nil),                                        // 106: google.protobuf.BoolValue
	(*LoRaAllianceProfileIdentifiers)(nil),                              // 107: ttn.lorawan.v3.LoRaAllianceProfileIdentifiers
	(*fieldmaskpb.FieldMask)(nil),                                       // 108: google.protobuf.FieldMask
	(*ApplicationIdentifiers)(nil),                                      // 109: ttn.lorawan.v3.ApplicationIdentifiers
	(*DLSettings)(nil),                                                  // 110: ttn.lorawan.v3.DLSettings
	(*CFList)(nil),                                                      // 111: ttn.lorawan.v3.CFList
	(*Message)(nil),                                                     // 112: ttn.lorawan.v3.Message
	(*DataRate)(nil),                                                    // 113: ttn.lorawan.v3.DataRate
	(*GatewayIdentifiers)(nil),                                          // 114: ttn.lorawan.v3.GatewayIdentifiers
	(DownlinkPathConstraint)(0),                                         // 115: ttn.lorawan.v3.DownlinkPathConstraint
	(MType)(0),                                                          // 116: ttn.lorawan.v3.MType
	(*Location)(nil),                                                    // 117: ttn.lorawan.v3.Location
}
var file_ttn_lorawan_v3_end_device_proto_depIdxs = []int32{
	63,  // 0: ttn.lorawan.v3.Session.keys:type_name -> ttn.lorawan.v3.SessionKeys
	64,  // 1: ttn.lorawan.v3.Session.started_at:type_name -> google.protobuf.Timestamp
	65,  // 2: ttn.lorawan.v3.Session.queued_application_downlinks:type_name -> ttn.lorawan.v3.ApplicationDownlink
	66,  // 3: ttn.lorawan.v3.ServingRelayForwardingLimits.reset_behavior:type_name -> ttn.lorawan.v3.RelayResetLimitCounter
	67,  // 4: ttn.lorawan.v3.ServingRelayForwardingLimits.join_requests:type_name -> ttn.lorawan.v3.RelayForwardLimits
	67,  // 5: ttn.lorawan.v3.ServingRelayForwardingLimits.notifications:type_name -> ttn.lorawan.v3.RelayForwardLimits
	67,  // 6: ttn.lorawan.v3.ServingRelayForwardingLimits.uplink_messages:type_name -> ttn.lorawan.v3.RelayForwardLimits
	67,  // 7: ttn.lorawan.v3.ServingRelayForwardingLimits.overall:type_name -> ttn.lorawan.v3.RelayForwardLimits
	68,  // 8: ttn.lorawan.v3.RelayUplinkForwardingRule.limits:type_name -> ttn.lorawan.v3.RelayUplinkForwardLimits
	69,  // 9: ttn.lorawan.v3.ServingRelayParameters.second_channel:type_name -> ttn.lorawan.v3.RelaySecondChannel
	70,  // 10: ttn.lorawan.v3.ServingRelayParameters.cad_periodicity:type_name -> ttn.lorawan.v3.RelayCADPeriodicity
	4,   // 11: ttn.lorawan.v3.ServingRelayParameters.uplink_forwarding_rules:type_name -> ttn.lorawan.v3.RelayUplinkForwardingRule
	3,   // 12: ttn.lorawan.v3.ServingRelayParameters.limits:type_name -> ttn.lorawan.v3.ServingRelayForwardingLimits
	71,  // 13: ttn.lorawan.v3.ServedRelayParameters.always:type_name -> ttn.lorawan.v3.RelayEndDeviceAlwaysMode
	72,  // 14: ttn.lorawan.v3.ServedRelayParameters.dynamic:type_name -> ttn.lorawan.v3.RelayEndDeviceDynamicMode
	73,  // 15: ttn.lorawan.v3.ServedRelayParameters.end_device_controlled:type_name -> ttn.lorawan.v3.RelayEndDeviceControlledMode
	69,  // 16: ttn.lorawan.v3.ServedRelayParameters.second_channel:type_name -> ttn.lorawan.v3.RelaySecondChannel
	5,   // 17: ttn.lorawan.v3.RelayParameters.serving:type_name -> ttn.lorawan.v3.ServingRelayParameters
	6,   // 18: ttn.lorawan.v3.RelayParameters.served:type_name -> ttn.lorawan.v3.ServedRelayParameters
	69,  // 19: ttn.lorawan.v3.ServingRelaySettings.second_channel:type_name -> ttn.lorawan.v3.RelaySecondChannel
	74,  // 20: ttn.lorawan.v3.ServingRelaySettings.default_channel_index:type_name -> google.protobuf.UInt32Value
	70,  // 21: ttn.lorawan.v3.ServingRelaySettings.cad_periodicity:type_name -> ttn.lorawan.v3.RelayCADPeriodicity
	4,   // 22: ttn.lorawan.v3.ServingRelaySettings.uplink_forwarding_rules:type_name -> ttn.lorawan.v3.RelayUplinkForwardingRule
	3,   // 23: ttn.lorawan.v3.ServingRelaySettings.limits:type_name -> ttn.lorawan.v3.ServingRelayForwardingLimits
	71,  // 24: ttn.lorawan.v3.ServedRelaySettings.always:type_name -> ttn.lorawan.v3.RelayEndDeviceAlwaysMode
	72,  // 25: ttn.lorawan.v3.ServedRelaySettings.dynamic:type_name -> ttn.lorawan.v3.RelayEndDeviceDynamicMode
	73,  // 26: ttn.lorawan.v3.ServedRelaySettings.end_device_controlled:type_name -> ttn.lorawan.v3.RelayEndDeviceControlledMode
	74,  // 27: ttn.lorawan.v3.ServedRelaySettings.backoff:type_name -> google.protobuf.UInt32Value
	69,  // 28: ttn.lorawan.v3.ServedRelaySettings.second_channel:type_name -> ttn.lorawan.v3.RelaySecondChannel
	8,   // 29: ttn.lorawan.v3.RelaySettings.serving:type_name -> ttn.lorawan.v3.ServingRelaySettings
	9,   // 30: ttn.lorawan.v3.RelaySettings.served:type_name -> ttn.lorawan.v3.ServedRelaySettings
	75,  // 31: ttn.lorawan.v3.MACParameters.adr_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	76,  // 32: ttn.lorawan.v3.MACParameters.rx1_delay:type_name -> ttn.lorawan.v3.RxDelay
	77,  // 33: ttn.lorawan.v3.MACParameters.rx1_data_rate_offset:type_name -> ttn.lorawan.v3.DataRateOffset
	75,  // 34: ttn.lorawan.v3.MACParameters.rx2_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	78,  // 35: ttn.lorawan.v3.MACParameters.max_duty_cycle:type_name -> ttn.lorawan.v3.AggregatedDutyCycle
	79,  // 36: ttn.lorawan.v3.MACParameters.rejoin_time_periodicity:type_name -> ttn.lorawan.v3.RejoinTimeExponent
	80,  // 37: ttn.lorawan.v3.MACParameters.rejoin_count_periodicity:type_name -> ttn.lorawan.v3.RejoinCountExponent
	75,  // 38: ttn.lorawan.v3.MACParameters.ping_slot_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	35,  // 39: ttn.lorawan.v3.MACParameters.channels:type_name -> ttn.lorawan.v3.MACParameters.Channel
	2,   // 40: ttn.lorawan.v3.MACParameters.uplink_dwell_time:type_name -> ttn.lorawan.v3.BoolValue
	2,   // 41: ttn.lorawan.v3.MACParameters.downlink_dwell_time:type_name -> ttn.lorawan.v3.BoolValue
	81,  // 42: ttn.lorawan.v3.MACParameters.adr_ack_limit_exponent:type_name -> ttn.lorawan.v3.ADRAckLimitExponentValue
	82,  // 43: ttn.lorawan.v3.MACParameters.adr_ack_delay_exponent:type_name -> ttn.lorawan.v3.ADRAckDelayExponentValue
	83,  // 44: ttn.lorawan.v3.MACParameters.ping_slot_data_rate_index_value:type_name -> ttn.lorawan.v3.DataRateIndexValue
	7,   // 45: ttn.lorawan.v3.MACParameters.relay:type_name -> ttn.lorawan.v3.RelayParameters
	84,  // 46: ttn.lorawan.v3.EndDeviceVersion.ids:type_name -> ttn.lorawan.v3.EndDeviceVersionIdentifiers
	85,  // 47: ttn.lorawan.v3.EndDeviceVersion.lorawan_version:type_name -> ttn.lorawan.v3.MACVersion
	86,  // 48: ttn.lorawan.v3.EndDeviceVersion.lorawan_phy_version:type_name -> ttn.lorawan.v3.PHYVersion
	14,  // 49: ttn.lorawan.v3.EndDeviceVersion.default_mac_settings:type_name -> ttn.lorawan.v3.MACSettings
	87,  // 50: ttn.lorawan.v3.EndDeviceVersion.default_formatters:type_name -> ttn.lorawan.v3.MessagePayloadFormatters
	36,  // 51: ttn.lorawan.v3.ADRSettings.static:type_name -> ttn.lorawan.v3.ADRSettings.StaticMode
	37,  // 52: ttn.lorawan.v3.ADRSettings.dynamic:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode
	38,  // 53: ttn.lorawan.v3.ADRSettings.disabled:type_name -> ttn.lorawan.v3.ADRSettings.DisabledMode
	88,  // 54: ttn.lorawan.v3.MACSettings.class_b_timeout:type_name -> google.protobuf.Duration
	89,  // 55: ttn.lorawan.v3.MACSettings.ping_slot_periodicity:type_name -> ttn.lorawan.v3.PingSlotPeriodValue
	83,  // 56: ttn.lorawan.v3.MACSettings.ping_slot_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndexValue
	90,  // 57: ttn.lorawan.v3.MACSettings.ping_slot_frequency:type_name -> ttn.lorawan.v3.ZeroableFrequencyValue
	90,  // 58: ttn.lorawan.v3.MACSettings.beacon_frequency:type_name -> ttn.lorawan.v3.ZeroableFrequencyValue
	88,  // 59: ttn.lorawan.v3.MACSettings.class_c_timeout:type_name -> google.protobuf.Duration
	91,  // 60: ttn.lorawan.v3.MACSettings.rx1_delay:type_name -> ttn.lorawan.v3.RxDelayValue
	92,  // 61: ttn.lorawan.v3.MACSettings.rx1_data_rate_offset:type_name -> ttn.lorawan.v3.DataRateOffsetValue
	83,  // 62: ttn.lorawan.v3.MACSettings.rx2_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndexValue
	93,  // 63: ttn.lorawan.v3.MACSettings.rx2_frequency:type_name -> ttn.lorawan.v3.FrequencyValue
	94,  // 64: ttn.lorawan.v3.MACSettings.max_duty_cycle:type_name -> ttn.lorawan.v3.AggregatedDutyCycleValue
	2,   // 65: ttn.lorawan.v3.MACSettings.supports_32_bit_f_cnt:type_name -> ttn.lorawan.v3.BoolValue
	2,   // 66: ttn.lorawan.v3.MACSettings.use_adr:type_name -> ttn.lorawan.v3.BoolValue
	95,  // 67: ttn.lorawan.v3.MACSettings.adr_margin:type_name -> google.protobuf.FloatValue
	2,   // 68: ttn.lorawan.v3.MACSettings.resets_f_cnt:type_name -> ttn.lorawan.v3.BoolValue
	88,  // 69: ttn.lorawan.v3.MACSettings.status_time_periodicity:type_name -> google.protobuf.Duration
	74,  // 70: ttn.lorawan.v3.MACSettings.status_count_periodicity:type_name -> google.protobuf.UInt32Value
	91,  // 71: ttn.lorawan.v3.MACSettings.desired_rx1_delay:type_name -> ttn.lorawan.v3.RxDelayValue
	92,  // 72: ttn.lorawan.v3.MACSettings.desired_rx1_data_rate_offset:type_name -> ttn.lorawan.v3.DataRateOffsetValue
	83,  // 73: ttn.lorawan.v3.MACSettings.desired_rx2_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndexValue
	93,  // 74: ttn.lorawan.v3.MACSettings.desired_rx2_frequency:type_name -> ttn.lorawan.v3.FrequencyValue
	94,  // 75: ttn.lorawan.v3.MACSettings.desired_max_duty_cycle:type_name -> ttn.lorawan.v3.AggregatedDutyCycleValue
	81,  // 76: ttn.lorawan.v3.MACSettings.desired_adr_ack_limit_exponent:type_name -> ttn.lorawan.v3.ADRAckLimitExponentValue
	82,  // 77: ttn.lorawan.v3.MACSettings.desired_adr_ack_delay_exponent:type_name -> ttn.lorawan.v3.ADRAckDelayExponentValue
	83,  // 78: ttn.lorawan.v3.MACSettings.desired_ping_slot_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndexValue
	90,  // 79: ttn.lorawan.v3.MACSettings.desired_ping_slot_frequency:type_name -> ttn.lorawan.v3.ZeroableFrequencyValue
	90,  // 80: ttn.lorawan.v3.MACSettings.desired_beacon_frequency:type_name -> ttn.lorawan.v3.ZeroableFrequencyValue
	96,  // 81: ttn.lorawan.v3.MACSettings.desired_max_eirp:type_name -> ttn.lorawan.v3.DeviceEIRPValue
	88,  // 82: ttn.lorawan.v3.MACSettings.class_b_c_downlink_interval:type_name -> google.protobuf.Duration
	2,   // 83: ttn.lorawan.v3.MACSettings.uplink_dwell_time:type_name -> ttn.lorawan.v3.BoolValue
	2,   // 84: ttn.lorawan.v3.MACSettings.downlink_dwell_time:type_name -> ttn.lorawan.v3.BoolValue
	13,  // 85: ttn.lorawan.v3.MACSettings.adr:type_name -> ttn.lorawan.v3.ADRSettings
	2,   // 86: ttn.lorawan.v3.MACSettings.schedule_downlinks:type_name -> ttn.lorawan.v3.BoolValue
	10,  // 87: ttn.lorawan.v3.MACSettings.relay:type_name -> ttn.lorawan.v3.RelaySettings
	10,  // 88: ttn.lorawan.v3.MACSettings.desired_relay:type_name -> ttn.lorawan.v3.RelaySettings
	97,  // 89: ttn.lorawan.v3.MACSettingsProfile.ids:type_name -> ttn.lorawan.v3.MACSettingsProfileIdentifiers
	14,  // 90: ttn.lorawan.v3.MACSettingsProfile.mac_settings:type_name -> ttn.lorawan.v3.MACSettings
	11,  // 91: ttn.lorawan.v3.MACState.current_parameters:type_name -> ttn.lorawan.v3.MACParameters
	11,  // 92: ttn.lorawan.v3.MACState.desired_parameters:type_name -> ttn.lorawan.v3.MACParameters
	98,  // 93: ttn.lorawan.v3.MACState.device_class:type_name -> ttn.lorawan.v3.Class
	85,  // 94: ttn.lorawan.v3.MACState.lorawan_version:type_name -> ttn.lorawan.v3.MACVersion
	64,  // 95: ttn.lorawan.v3.MACState.last_confirmed_downlink_at:type_name -> google.protobuf.Timestamp
	89,  // 96: ttn.lorawan.v3.MACState.ping_slot_periodicity:type_name -> ttn.lorawan.v3.PingSlotPeriodValue
	65,  // 97: ttn.lorawan.v3.MACState.pending_application_downlink:type_name -> ttn.lorawan.v3.ApplicationDownlink
	99,  // 98: ttn.lorawan.v3.MACState.queued_responses:type_name -> ttn.lorawan.v3.MACCommand
	99,  // 99: ttn.lorawan.v3.MACState.pending_requests:type_name -> ttn.lorawan.v3.MACCommand
	45,  // 100: ttn.lorawan.v3.MACState.queued_join_accept:type_name -> ttn.lorawan.v3.MACState.JoinAccept
	44,  // 101: ttn.lorawan.v3.MACState.pending_join_request:type_name -> ttn.lorawan.v3.MACState.JoinRequest
	46,  // 102: ttn.lorawan.v3.MACState.recent_uplinks:type_name -> ttn.lorawan.v3.MACState.UplinkMessage
	47,  // 103: ttn.lorawan.v3.MACState.recent_downlinks:type_name -> ttn.lorawan.v3.MACState.DownlinkMessage
	64,  // 104: ttn.lorawan.v3.MACState.last_network_initiated_downlink_at:type_name -> google.protobuf.Timestamp
	75,  // 105: ttn.lorawan.v3.MACState.rejected_adr_data_rate_indexes:type_name -> ttn.lorawan.v3.DataRateIndex
	64,  // 106: ttn.lorawan.v3.MACState.last_downlink_at:type_name -> google.protobuf.Timestamp
	50,  // 107: ttn.lorawan.v3.MACState.rejected_data_rate_ranges:type_name -> ttn.lorawan.v3.MACState.RejectedDataRateRangesEntry
	100, // 108: ttn.lorawan.v3.MACState.recent_mac_command_identifiers:type_name -> ttn.lorawan.v3.MACCommandIdentifier
	101, // 109: ttn.lorawan.v3.MACState.pending_relay_downlink:type_name -> ttn.lorawan.v3.RelayForwardDownlinkReq
	64,  // 110: ttn.lorawan.v3.EndDeviceAuthenticationCode.valid_from:type_name -> google.protobuf.Timestamp
	64,  // 111: ttn.lorawan.v3.EndDeviceAuthenticationCode.valid_to:type_name -> google.protobuf.Timestamp
	102, // 112: ttn.lorawan.v3.EndDevice.ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	64,  // 113: ttn.lorawan.v3.EndDevice.created_at:type_name -> google.protobuf.Timestamp
	64,  // 114: ttn.lorawan.v3.EndDevice.updated_at:type_name -> google.protobuf.Timestamp
	58,  // 115: ttn.lorawan.v3.EndDevice.attributes:type_name -> ttn.lorawan.v3.EndDevice.AttributesEntry
	84,  // 116: ttn.lorawan.v3.EndDevice.version_ids:type_name -> ttn.lorawan.v3.EndDeviceVersionIdentifiers
	59,  // 117: ttn.lorawan.v3.EndDevice.locations:type_name -> ttn.lorawan.v3.EndDevice.LocationsEntry
	103, // 118: ttn.lorawan.v3.EndDevice.picture:type_name -> ttn.lorawan.v3.Picture
	85,  // 119: ttn.lorawan.v3.EndDevice.lorawan_version:type_name -> ttn.lorawan.v3.MACVersion
	86,  // 120: ttn.lorawan.v3.EndDevice.lorawan_phy_version:type_name -> ttn.lorawan.v3.PHYVersion
	104, // 121: ttn.lorawan.v3.EndDevice.root_keys:type_name -> ttn.lorawan.v3.RootKeys
	14,  // 122: ttn.lorawan.v3.EndDevice.mac_settings:type_name -> ttn.lorawan.v3.MACSettings
	16,  // 123: ttn.lorawan.v3.EndDevice.mac_state:type_name -> ttn.lorawan.v3.MACState
	16,  // 124: ttn.lorawan.v3.EndDevice.pending_mac_state:type_name -> ttn.lorawan.v3.MACState
	1,   // 125: ttn.lorawan.v3.EndDevice.session:type_name -> ttn.lorawan.v3.Session
	1,   // 126: ttn.lorawan.v3.EndDevice.pending_session:type_name -> ttn.lorawan.v3.Session
	64,  // 127: ttn.lorawan.v3.EndDevice.last_dev_status_received_at:type_name -> google.protobuf.Timestamp
	0,   // 128: ttn.lorawan.v3.EndDevice.power_state:type_name -> ttn.lorawan.v3.PowerState
	95,  // 129: ttn.lorawan.v3.EndDevice.battery_percentage:type_name -> google.protobuf.FloatValue
	65,  // 130: ttn.lorawan.v3.EndDevice.queued_application_downlinks:type_name -> ttn.lorawan.v3.ApplicationDownlink
	87,  // 131: ttn.lorawan.v3.EndDevice.formatters:type_name -> ttn.lorawan.v3.MessagePayloadFormatters
	105, // 132: ttn.lorawan.v3.EndDevice.provisioning_data:type_name -> google.protobuf.Struct
	17,  // 133: ttn.lorawan.v3.EndDevice.claim_authentication_code:type_name -> ttn.lorawan.v3.EndDeviceAuthenticationCode
	106, // 134: ttn.lorawan.v3.EndDevice.skip_payload_crypto_override:type_name -> google.protobuf.BoolValue
	64,  // 135: ttn.lorawan.v3.EndDevice.activated_at:type_name -> google.protobuf.Timestamp
	64,  // 136: ttn.lorawan.v3.EndDevice.last_seen_at:type_name -> google.protobuf.Timestamp
	107, // 137: ttn.lorawan.v3.EndDevice.lora_alliance_profile_ids:type_name -> ttn.lorawan.v3.LoRaAllianceProfileIdentifiers
	18,  // 138: ttn.lorawan.v3.EndDevices.end_devices:type_name -> ttn.lorawan.v3.EndDevice
	18,  // 139: ttn.lorawan.v3.CreateEndDeviceRequest.end_device:type_name -> ttn.lorawan.v3.EndDevice
	18,  // 140: ttn.lorawan.v3.UpdateEndDeviceRequest.end_device:type_name -> ttn.lorawan.v3.EndDevice
	108, // 141: ttn.lorawan.v3.UpdateEndDeviceRequest.field_mask:type_name -> google.protobuf.FieldMask
	60,  // 142: ttn.lorawan.v3.BatchUpdateEndDeviceLastSeenRequest.updates:type_name -> ttn.lorawan.v3.BatchUpdateEndDeviceLastSeenRequest.EndDeviceLastSeenUpdate
	102, // 143: ttn.lorawan.v3.GetEndDeviceRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	108, // 144: ttn.lorawan.v3.GetEndDeviceRequest.field_mask:type_name -> google.protobuf.FieldMask
	109, // 145: ttn.lorawan.v3.ListEndDevicesRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	108, // 146: ttn.lorawan.v3.ListEndDevicesRequest.field_mask:type_name -> google.protobuf.FieldMask
	61,  // 147: ttn.lorawan.v3.ListEndDevicesRequest.filters:type_name -> ttn.lorawan.v3.ListEndDevicesRequest.Filter
	18,  // 148: ttn.lorawan.v3.SetEndDeviceRequest.end_device:type_name -> ttn.lorawan.v3.EndDevice
	108, // 149: ttn.lorawan.v3.SetEndDeviceRequest.field_mask:type_name -> google.protobuf.FieldMask
	102, // 150: ttn.lorawan.v3.ResetAndGetEndDeviceRequest.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	108, // 151: ttn.lorawan.v3.ResetAndGetEndDeviceRequest.field_mask:type_name -> google.protobuf.FieldMask
	18,  // 152: ttn.lorawan.v3.EndDeviceTemplate.end_device:type_name -> ttn.lorawan.v3.EndDevice
	108, // 153: ttn.lorawan.v3.EndDeviceTemplate.field_mask:type_name -> google.protobuf.FieldMask
	62,  // 154: ttn.lorawan.v3.EndDeviceTemplateFormats.formats:type_name -> ttn.lorawan.v3.EndDeviceTemplateFormats.FormatsEntry
	84,  // 155: ttn.lorawan.v3.ConvertEndDeviceTemplateRequest.end_device_version_ids:type_name -> ttn.lorawan.v3.EndDeviceVersionIdentifiers
	109, // 156: ttn.lorawan.v3.BatchDeleteEndDevicesRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	109, // 157: ttn.lorawan.v3.BatchGetEndDevicesRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	108, // 158: ttn.lorawan.v3.BatchGetEndDevicesRequest.field_mask:type_name -> google.protobuf.FieldMask
	75,  // 159: ttn.lorawan.v3.MACParameters.Channel.min_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	75,  // 160: ttn.lorawan.v3.MACParameters.Channel.max_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	75,  // 161: ttn.lorawan.v3.ADRSettings.StaticMode.data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	95,  // 162: ttn.lorawan.v3.ADRSettings.DynamicMode.margin:type_name -> google.protobuf.FloatValue
	83,  // 163: ttn.lorawan.v3.ADRSettings.DynamicMode.min_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndexValue
	83,  // 164: ttn.lorawan.v3.ADRSettings.DynamicMode.max_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndexValue
	74,  // 165: ttn.lorawan.v3.ADRSettings.DynamicMode.min_tx_power_index:type_name -> google.protobuf.UInt32Value
	74,  // 166: ttn.lorawan.v3.ADRSettings.DynamicMode.max_tx_power_index:type_name -> google.protobuf.UInt32Value
	74,  // 167: ttn.lorawan.v3.ADRSettings.DynamicMode.min_nb_trans:type_name -> google.protobuf.UInt32Value
	74,  // 168: ttn.lorawan.v3.ADRSettings.DynamicMode.max_nb_trans:type_name -> google.protobuf.UInt32Value
	39,  // 169: ttn.lorawan.v3.ADRSettings.DynamicMode.channel_steering:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.ChannelSteeringSettings
	41,  // 170: ttn.lorawan.v3.ADRSettings.DynamicMode.overrides:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides
	42,  // 171: ttn.lorawan.v3.ADRSettings.DynamicMode.ChannelSteeringSettings.lora_narrow:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.ChannelSteeringSettings.LoRaNarrowMode
	43,  // 172: ttn.lorawan.v3.ADRSettings.DynamicMode.ChannelSteeringSettings.disabled:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.ChannelSteeringSettings.DisabledMode
	74,  // 173: ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride.min_nb_trans:type_name -> google.protobuf.UInt32Value
	74,  // 174: ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride.max_nb_trans:type_name -> google.protobuf.UInt32Value
	40,  // 175: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_0:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 176: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_1:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 177: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_2:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 178: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_3:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 179: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_4:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 180: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_5:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 181: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_6:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 182: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_7:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 183: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_8:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 184: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_9:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 185: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_10:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 186: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_11:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 187: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_12:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 188: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_13:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 189: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_14:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	40,  // 190: ttn.lorawan.v3.ADRSettings.DynamicMode.Overrides.data_rate_15:type_name -> ttn.lorawan.v3.ADRSettings.DynamicMode.PerDataRateIndexOverride
	110, // 191: ttn.lorawan.v3.MACState.JoinRequest.downlink_settings:type_name -> ttn.lorawan.v3.DLSettings
	76,  // 192: ttn.lorawan.v3.MACState.JoinRequest.rx_delay:type_name -> ttn.lorawan.v3.RxDelay
	111, // 193: ttn.lorawan.v3.MACState.JoinRequest.cf_list:type_name -> ttn.lorawan.v3.CFList
	44,  // 194: ttn.lorawan.v3.MACState.JoinAccept.request:type_name -> ttn.lorawan.v3.MACState.JoinRequest
	63,  // 195: ttn.lorawan.v3.MACState.JoinAccept.keys:type_name -> ttn.lorawan.v3.SessionKeys
	112, // 196: ttn.lorawan.v3.MACState.UplinkMessage.payload:type_name -> ttn.lorawan.v3.Message
	51,  // 197: ttn.lorawan.v3.MACState.UplinkMessage.settings:type_name -> ttn.lorawan.v3.MACState.UplinkMessage.TxSettings
	52,  // 198: ttn.lorawan.v3.MACState.UplinkMessage.rx_metadata:type_name -> ttn.lorawan.v3.MACState.UplinkMessage.RxMetadata
	64,  // 199: ttn.lorawan.v3.MACState.UplinkMessage.received_at:type_name -> google.protobuf.Timestamp
	55,  // 200: ttn.lorawan.v3.MACState.DownlinkMessage.payload:type_name -> ttn.lorawan.v3.MACState.DownlinkMessage.Message
	75,  // 201: ttn.lorawan.v3.MACState.DataRateRange.min_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	75,  // 202: ttn.lorawan.v3.MACState.DataRateRange.max_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	48,  // 203: ttn.lorawan.v3.MACState.DataRateRanges.ranges:type_name -> ttn.lorawan.v3.MACState.DataRateRange
	49,  // 204: ttn.lorawan.v3.MACState.RejectedDataRateRangesEntry.value:type_name -> ttn.lorawan.v3.MACState.DataRateRanges
	113, // 205: ttn.lorawan.v3.MACState.UplinkMessage.TxSettings.data_rate:type_name -> ttn.lorawan.v3.DataRate
	114, // 206: ttn.lorawan.v3.MACState.UplinkMessage.RxMetadata.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	115, // 207: ttn.lorawan.v3.MACState.UplinkMessage.RxMetadata.downlink_path_constraint:type_name -> ttn.lorawan.v3.DownlinkPathConstraint
	53,  // 208: ttn.lorawan.v3.MACState.UplinkMessage.RxMetadata.packet_broker:type_name -> ttn.lorawan.v3.MACState.UplinkMessage.RxMetadata.PacketBrokerMetadata
	54,  // 209: ttn.lorawan.v3.MACState.UplinkMessage.RxMetadata.relay:type_name -> ttn.lorawan.v3.MACState.UplinkMessage.RxMetadata.RelayMetadata
	56,  // 210: ttn.lorawan.v3.MACState.DownlinkMessage.Message.m_hdr:type_name -> ttn.lorawan.v3.MACState.DownlinkMessage.Message.MHDR
	57,  // 211: ttn.lorawan.v3.MACState.DownlinkMessage.Message.mac_payload:type_name -> ttn.lorawan.v3.MACState.DownlinkMessage.Message.MACPayload
	116, // 212: ttn.lorawan.v3.MACState.DownlinkMessage.Message.MHDR.m_type:type_name -> ttn.lorawan.v3.MType
	117, // 213: ttn.lorawan.v3.EndDevice.LocationsEntry.value:type_name -> ttn.lorawan.v3.Location
	102, // 214: ttn.lorawan.v3.BatchUpdateEndDeviceLastSeenRequest.EndDeviceLastSeenUpdate.ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	64,  // 215: ttn.lorawan.v3.BatchUpdateEndDeviceLastSeenRequest.EndDeviceLastSeenUpdate.last_seen_at:type_name -> google.protobuf.Timestamp
	64,  // 216: ttn.lorawan.v3.ListEndDevicesRequest.Filter.updated_since:type_name -> google.protobuf.Timestamp
	30,  // 217: ttn.lorawan.v3.EndDeviceTemplateFormats.FormatsEntry.value:type_name -> ttn.lorawan.v3.EndDeviceTemplateFormat
	218, // [218:218] is the sub-list for method output_type
	218, // [218:218] is the sub-list for method input_type
	218, // [218:218] is the sub-list for extension type_name
	218, // [218:218] is the sub-list for extension extendee
	0,   // [0:218] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_end_device_proto_init() }
func file_ttn_lorawan_v3_end_device_proto_init() {
	if File_ttn_lorawan_v3_end_device_proto != nil {
		return
	}
	file_ttn_lorawan_v3_enums_proto_init()
	file_ttn_lorawan_v3_identifiers_proto_init()
	file_ttn_lorawan_v3_keys_proto_init()
	file_ttn_lorawan_v3_lorawan_proto_init()
	file_ttn_lorawan_v3_messages_proto_init()
	file_ttn_lorawan_v3_metadata_proto_init()
	file_ttn_lorawan_v3_picture_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_end_device_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Session); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BoolValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServingRelayForwardingLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelayUplinkForwardingRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServingRelayParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServedRelayParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelayParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServingRelaySettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServedRelaySettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelaySettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ADRSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACSettingsProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceAuthenticationCode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDevice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDevices); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DevAddrPrefix); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEndDeviceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEndDeviceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateEndDeviceLastSeenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEndDeviceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEndDeviceIdentifiersForEUIsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEndDevicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetEndDeviceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetAndGetEndDeviceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceTemplateFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceTemplateFormats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConvertEndDeviceTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeleteEndDevicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetEndDevicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACParameters_Channel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ADRSettings_StaticMode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ADRSettings_DynamicMode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ADRSettings_DisabledMode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ADRSettings_DynamicMode_ChannelSteeringSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ADRSettings_DynamicMode_PerDataRateIndexOverride); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ADRSettings_DynamicMode_Overrides); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ADRSettings_DynamicMode_ChannelSteeringSettings_LoRaNarrowMode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ADRSettings_DynamicMode_ChannelSteeringSettings_DisabledMode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACState_JoinRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACState_JoinAccept); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACState_UplinkMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACState_DownlinkMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACState_DataRateRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACState_DataRateRanges); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACState_UplinkMessage_TxSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACState_UplinkMessage_RxMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACState_UplinkMessage_RxMetadata_PacketBrokerMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACState_UplinkMessage_RxMetadata_RelayMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACState_DownlinkMessage_Message); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACState_DownlinkMessage_Message_MHDR); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MACState_DownlinkMessage_Message_MACPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateEndDeviceLastSeenRequest_EndDeviceLastSeenUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_end_device_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEndDevicesRequest_Filter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_ttn_lorawan_v3_end_device_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*ServedRelayParameters_Always)(nil),
		(*ServedRelayParameters_Dynamic)(nil),
		(*ServedRelayParameters_EndDeviceControlled)(nil),
	}
	file_ttn_lorawan_v3_end_device_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*RelayParameters_Serving)(nil),
		(*RelayParameters_Served)(nil),
	}
	file_ttn_lorawan_v3_end_device_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*ServedRelaySettings_Always)(nil),
		(*ServedRelaySettings_Dynamic)(nil),
		(*ServedRelaySettings_EndDeviceControlled)(nil),
	}
	file_ttn_lorawan_v3_end_device_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*RelaySettings_Serving)(nil),
		(*RelaySettings_Served)(nil),
	}
	file_ttn_lorawan_v3_end_device_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*ADRSettings_Static)(nil),
		(*ADRSettings_Dynamic)(nil),
		(*ADRSettings_Disabled)(nil),
	}
	file_ttn_lorawan_v3_end_device_proto_msgTypes[38].OneofWrappers = []interface{}{
		(*ADRSettings_DynamicMode_ChannelSteeringSettings_LoraNarrow)(nil),
		(*ADRSettings_DynamicMode_ChannelSteeringSettings_Disabled)(nil),
	}
	file_ttn_lorawan_v3_end_device_proto_msgTypes[60].OneofWrappers = []interface{}{
		(*ListEndDevicesRequest_Filter_UpdatedSince)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_end_device_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   62,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ttn_lorawan_v3_end_device_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_end_device_proto_depIdxs,
		EnumInfos:         file_ttn_lorawan_v3_end_device_proto_enumTypes,
		MessageInfos:      file_ttn_lorawan_v3_end_device_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_end_device_proto = out.File
	file_ttn_lorawan_v3_end_device_proto_rawDesc = nil
	file_ttn_lorawan_v3_end_device_proto_goTypes = nil
	file_ttn_lorawan_v3_end_device_proto_depIdxs = nil
}
