// Copyright © 2023 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.1
// source: ttn/lorawan/v3/email_validation.proto

package ttnpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	EmailValidationRegistry_RequestValidation_FullMethodName = "/ttn.lorawan.v3.EmailValidationRegistry/RequestValidation"
	EmailValidationRegistry_Validate_FullMethodName          = "/ttn.lorawan.v3.EmailValidationRegistry/Validate"
)

// EmailValidationRegistryClient is the client API for EmailValidationRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EmailValidationRegistryClient interface {
	// Request validation for the non-validated contact info for the given entity.
	RequestValidation(ctx context.Context, in *UserIdentifiers, opts ...grpc.CallOption) (*EmailValidation, error)
	// Validate confirms a contact info validation.
	Validate(ctx context.Context, in *ValidateEmailRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type emailValidationRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewEmailValidationRegistryClient(cc grpc.ClientConnInterface) EmailValidationRegistryClient {
	return &emailValidationRegistryClient{cc}
}

func (c *emailValidationRegistryClient) RequestValidation(ctx context.Context, in *UserIdentifiers, opts ...grpc.CallOption) (*EmailValidation, error) {
	out := new(EmailValidation)
	err := c.cc.Invoke(ctx, EmailValidationRegistry_RequestValidation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *emailValidationRegistryClient) Validate(ctx context.Context, in *ValidateEmailRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, EmailValidationRegistry_Validate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EmailValidationRegistryServer is the server API for EmailValidationRegistry service.
// All implementations must embed UnimplementedEmailValidationRegistryServer
// for forward compatibility
type EmailValidationRegistryServer interface {
	// Request validation for the non-validated contact info for the given entity.
	RequestValidation(context.Context, *UserIdentifiers) (*EmailValidation, error)
	// Validate confirms a contact info validation.
	Validate(context.Context, *ValidateEmailRequest) (*emptypb.Empty, error)
	mustEmbedUnimplementedEmailValidationRegistryServer()
}

// UnimplementedEmailValidationRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedEmailValidationRegistryServer struct {
}

func (UnimplementedEmailValidationRegistryServer) RequestValidation(context.Context, *UserIdentifiers) (*EmailValidation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RequestValidation not implemented")
}
func (UnimplementedEmailValidationRegistryServer) Validate(context.Context, *ValidateEmailRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Validate not implemented")
}
func (UnimplementedEmailValidationRegistryServer) mustEmbedUnimplementedEmailValidationRegistryServer() {
}

// UnsafeEmailValidationRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EmailValidationRegistryServer will
// result in compilation errors.
type UnsafeEmailValidationRegistryServer interface {
	mustEmbedUnimplementedEmailValidationRegistryServer()
}

func RegisterEmailValidationRegistryServer(s grpc.ServiceRegistrar, srv EmailValidationRegistryServer) {
	s.RegisterService(&EmailValidationRegistry_ServiceDesc, srv)
}

func _EmailValidationRegistry_RequestValidation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EmailValidationRegistryServer).RequestValidation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EmailValidationRegistry_RequestValidation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EmailValidationRegistryServer).RequestValidation(ctx, req.(*UserIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _EmailValidationRegistry_Validate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateEmailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EmailValidationRegistryServer).Validate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EmailValidationRegistry_Validate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EmailValidationRegistryServer).Validate(ctx, req.(*ValidateEmailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// EmailValidationRegistry_ServiceDesc is the grpc.ServiceDesc for EmailValidationRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var EmailValidationRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.EmailValidationRegistry",
	HandlerType: (*EmailValidationRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RequestValidation",
			Handler:    _EmailValidationRegistry_RequestValidation_Handler,
		},
		{
			MethodName: "Validate",
			Handler:    _EmailValidationRegistry_Validate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/email_validation.proto",
}
