// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on EndDeviceBrand with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *EndDeviceBrand) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceBrandFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "brand_id":

			if utf8.RuneCountInString(m.GetBrandId()) > 36 {
				return EndDeviceBrandValidationError{
					field:  "brand_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_EndDeviceBrand_BrandId_Pattern.MatchString(m.GetBrandId()) {
				return EndDeviceBrandValidationError{
					field:  "brand_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "name":
			// no validation rules for Name
		case "private_enterprise_number":
			// no validation rules for PrivateEnterpriseNumber
		case "organization_unique_identifiers":

			for idx, item := range m.GetOrganizationUniqueIdentifiers() {
				_, _ = idx, item

				if !_EndDeviceBrand_OrganizationUniqueIdentifiers_Pattern.MatchString(item) {
					return EndDeviceBrandValidationError{
						field:  fmt.Sprintf("organization_unique_identifiers[%v]", idx),
						reason: "value does not match regex pattern \"[0-9A-F]{6}\"",
					}
				}

			}

		case "lora_alliance_vendor_id":
			// no validation rules for LoraAllianceVendorId
		case "website":

			if m.GetWebsite() != "" {

				if uri, err := url.Parse(m.GetWebsite()); err != nil {
					return EndDeviceBrandValidationError{
						field:  "website",
						reason: "value must be a valid URI",
						cause:  err,
					}
				} else if !uri.IsAbs() {
					return EndDeviceBrandValidationError{
						field:  "website",
						reason: "value must be absolute",
					}
				}

			}

		case "email":

			if m.GetEmail() != "" {

				if err := m._validateEmail(m.GetEmail()); err != nil {
					return EndDeviceBrandValidationError{
						field:  "email",
						reason: "value must be a valid email address",
						cause:  err,
					}
				}

			}

		case "logo":

			if !_EndDeviceBrand_Logo_Pattern.MatchString(m.GetLogo()) {
				return EndDeviceBrandValidationError{
					field:  "logo",
					reason: "value does not match regex pattern \"^$|^(([a-z0-9-]+\\\\/)+)?([a-z0-9_-]+\\\\.)+(png|svg)$\"",
				}
			}

		default:
			return EndDeviceBrandValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

func (m *EndDeviceBrand) _validateHostname(host string) error {
	s := strings.ToLower(strings.TrimSuffix(host, "."))

	if len(host) > 253 {
		return errors.New("hostname cannot exceed 253 characters")
	}

	for _, part := range strings.Split(s, ".") {
		if l := len(part); l == 0 || l > 63 {
			return errors.New("hostname part must be non-empty and cannot exceed 63 characters")
		}

		if part[0] == '-' {
			return errors.New("hostname parts cannot begin with hyphens")
		}

		if part[len(part)-1] == '-' {
			return errors.New("hostname parts cannot end with hyphens")
		}

		for _, r := range part {
			if (r < 'a' || r > 'z') && (r < '0' || r > '9') && r != '-' {
				return fmt.Errorf("hostname parts can only contain alphanumeric characters or hyphens, got %q", string(r))
			}
		}
	}

	return nil
}

func (m *EndDeviceBrand) _validateEmail(addr string) error {
	a, err := mail.ParseAddress(addr)
	if err != nil {
		return err
	}
	addr = a.Address

	if len(addr) > 254 {
		return errors.New("email addresses cannot exceed 254 characters")
	}

	parts := strings.SplitN(addr, "@", 2)

	if len(parts[0]) > 64 {
		return errors.New("email address local phrase cannot exceed 64 characters")
	}

	return m._validateHostname(parts[1])
}

// EndDeviceBrandValidationError is the validation error returned by
// EndDeviceBrand.ValidateFields if the designated constraints aren't met.
type EndDeviceBrandValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceBrandValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceBrandValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceBrandValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceBrandValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceBrandValidationError) ErrorName() string { return "EndDeviceBrandValidationError" }

// Error satisfies the builtin error interface
func (e EndDeviceBrandValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceBrand.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceBrandValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceBrandValidationError{}

var _EndDeviceBrand_BrandId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

var _EndDeviceBrand_OrganizationUniqueIdentifiers_Pattern = regexp.MustCompile("[0-9A-F]{6}")

var _EndDeviceBrand_Logo_Pattern = regexp.MustCompile("^$|^(([a-z0-9-]+\\/)+)?([a-z0-9_-]+\\.)+(png|svg)$")

// ValidateFields checks the field values on EndDeviceModel with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *EndDeviceModel) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceModelFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "brand_id":

			if utf8.RuneCountInString(m.GetBrandId()) > 36 {
				return EndDeviceModelValidationError{
					field:  "brand_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_EndDeviceModel_BrandId_Pattern.MatchString(m.GetBrandId()) {
				return EndDeviceModelValidationError{
					field:  "brand_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "model_id":

			if utf8.RuneCountInString(m.GetModelId()) > 36 {
				return EndDeviceModelValidationError{
					field:  "model_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_EndDeviceModel_ModelId_Pattern.MatchString(m.GetModelId()) {
				return EndDeviceModelValidationError{
					field:  "model_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "name":
			// no validation rules for Name
		case "description":
			// no validation rules for Description
		case "hardware_versions":

			for idx, item := range m.GetHardwareVersions() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return EndDeviceModelValidationError{
							field:  fmt.Sprintf("hardware_versions[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "firmware_versions":

			for idx, item := range m.GetFirmwareVersions() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return EndDeviceModelValidationError{
							field:  fmt.Sprintf("firmware_versions[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "sensors":

			_EndDeviceModel_Sensors_Unique := make(map[string]struct{}, len(m.GetSensors()))

			for idx, item := range m.GetSensors() {
				_, _ = idx, item

				if _, exists := _EndDeviceModel_Sensors_Unique[item]; exists {
					return EndDeviceModelValidationError{
						field:  fmt.Sprintf("sensors[%v]", idx),
						reason: "repeated value must contain unique items",
					}
				} else {
					_EndDeviceModel_Sensors_Unique[item] = struct{}{}
				}

				// no validation rules for Sensors[idx]
			}

		case "dimensions":

			if v, ok := interface{}(m.GetDimensions()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModelValidationError{
						field:  "dimensions",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "weight":

			if v, ok := interface{}(m.GetWeight()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModelValidationError{
						field:  "weight",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "battery":

			if v, ok := interface{}(m.GetBattery()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModelValidationError{
						field:  "battery",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "operating_conditions":

			if v, ok := interface{}(m.GetOperatingConditions()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModelValidationError{
						field:  "operating_conditions",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "ip_code":
			// no validation rules for IpCode
		case "key_provisioning":

			_EndDeviceModel_KeyProvisioning_Unique := make(map[KeyProvisioning]struct{}, len(m.GetKeyProvisioning()))

			for idx, item := range m.GetKeyProvisioning() {
				_, _ = idx, item

				if _, exists := _EndDeviceModel_KeyProvisioning_Unique[item]; exists {
					return EndDeviceModelValidationError{
						field:  fmt.Sprintf("key_provisioning[%v]", idx),
						reason: "repeated value must contain unique items",
					}
				} else {
					_EndDeviceModel_KeyProvisioning_Unique[item] = struct{}{}
				}

				if _, ok := KeyProvisioning_name[int32(item)]; !ok {
					return EndDeviceModelValidationError{
						field:  fmt.Sprintf("key_provisioning[%v]", idx),
						reason: "value must be one of the defined enum values",
					}
				}

			}

		case "key_security":

			if _, ok := KeySecurity_name[int32(m.GetKeySecurity())]; !ok {
				return EndDeviceModelValidationError{
					field:  "key_security",
					reason: "value must be one of the defined enum values",
				}
			}

		case "photos":

			if v, ok := interface{}(m.GetPhotos()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModelValidationError{
						field:  "photos",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "videos":

			if v, ok := interface{}(m.GetVideos()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModelValidationError{
						field:  "videos",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "product_url":

			if m.GetProductUrl() != "" {

				if uri, err := url.Parse(m.GetProductUrl()); err != nil {
					return EndDeviceModelValidationError{
						field:  "product_url",
						reason: "value must be a valid URI",
						cause:  err,
					}
				} else if !uri.IsAbs() {
					return EndDeviceModelValidationError{
						field:  "product_url",
						reason: "value must be absolute",
					}
				}

			}

		case "datasheet_url":

			if m.GetDatasheetUrl() != "" {

				if uri, err := url.Parse(m.GetDatasheetUrl()); err != nil {
					return EndDeviceModelValidationError{
						field:  "datasheet_url",
						reason: "value must be a valid URI",
						cause:  err,
					}
				} else if !uri.IsAbs() {
					return EndDeviceModelValidationError{
						field:  "datasheet_url",
						reason: "value must be absolute",
					}
				}

			}

		case "resellers":

			for idx, item := range m.GetResellers() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return EndDeviceModelValidationError{
							field:  fmt.Sprintf("resellers[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "compliances":

			if v, ok := interface{}(m.GetCompliances()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModelValidationError{
						field:  "compliances",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "additional_radios":

			_EndDeviceModel_AdditionalRadios_Unique := make(map[string]struct{}, len(m.GetAdditionalRadios()))

			for idx, item := range m.GetAdditionalRadios() {
				_, _ = idx, item

				if _, exists := _EndDeviceModel_AdditionalRadios_Unique[item]; exists {
					return EndDeviceModelValidationError{
						field:  fmt.Sprintf("additional_radios[%v]", idx),
						reason: "repeated value must contain unique items",
					}
				} else {
					_EndDeviceModel_AdditionalRadios_Unique[item] = struct{}{}
				}

				// no validation rules for AdditionalRadios[idx]
			}

		default:
			return EndDeviceModelValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceModelValidationError is the validation error returned by
// EndDeviceModel.ValidateFields if the designated constraints aren't met.
type EndDeviceModelValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceModelValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceModelValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceModelValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceModelValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceModelValidationError) ErrorName() string { return "EndDeviceModelValidationError" }

// Error satisfies the builtin error interface
func (e EndDeviceModelValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceModel.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceModelValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceModelValidationError{}

var _EndDeviceModel_BrandId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

var _EndDeviceModel_ModelId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on GetEndDeviceBrandRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetEndDeviceBrandRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetEndDeviceBrandRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetEndDeviceBrandRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "brand_id":

			if utf8.RuneCountInString(m.GetBrandId()) > 36 {
				return GetEndDeviceBrandRequestValidationError{
					field:  "brand_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_GetEndDeviceBrandRequest_BrandId_Pattern.MatchString(m.GetBrandId()) {
				return GetEndDeviceBrandRequestValidationError{
					field:  "brand_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetEndDeviceBrandRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetEndDeviceBrandRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetEndDeviceBrandRequestValidationError is the validation error returned by
// GetEndDeviceBrandRequest.ValidateFields if the designated constraints
// aren't met.
type GetEndDeviceBrandRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetEndDeviceBrandRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetEndDeviceBrandRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetEndDeviceBrandRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetEndDeviceBrandRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetEndDeviceBrandRequestValidationError) ErrorName() string {
	return "GetEndDeviceBrandRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetEndDeviceBrandRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetEndDeviceBrandRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetEndDeviceBrandRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetEndDeviceBrandRequestValidationError{}

var _GetEndDeviceBrandRequest_BrandId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on ListEndDeviceBrandsRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ListEndDeviceBrandsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListEndDeviceBrandsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListEndDeviceBrandsRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListEndDeviceBrandsRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "order_by":

			if _, ok := _ListEndDeviceBrandsRequest_OrderBy_InLookup[m.GetOrderBy()]; !ok {
				return ListEndDeviceBrandsRequestValidationError{
					field:  "order_by",
					reason: "value must be in list [ brand_id -brand_id name -name]",
				}
			}

		case "search":

			if utf8.RuneCountInString(m.GetSearch()) > 100 {
				return ListEndDeviceBrandsRequestValidationError{
					field:  "search",
					reason: "value length must be at most 100 runes",
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListEndDeviceBrandsRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ListEndDeviceBrandsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListEndDeviceBrandsRequestValidationError is the validation error returned
// by ListEndDeviceBrandsRequest.ValidateFields if the designated constraints
// aren't met.
type ListEndDeviceBrandsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListEndDeviceBrandsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListEndDeviceBrandsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListEndDeviceBrandsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListEndDeviceBrandsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListEndDeviceBrandsRequestValidationError) ErrorName() string {
	return "ListEndDeviceBrandsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListEndDeviceBrandsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListEndDeviceBrandsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListEndDeviceBrandsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListEndDeviceBrandsRequestValidationError{}

var _ListEndDeviceBrandsRequest_OrderBy_InLookup = map[string]struct{}{
	"":          {},
	"brand_id":  {},
	"-brand_id": {},
	"name":      {},
	"-name":     {},
}

// ValidateFields checks the field values on GetEndDeviceModelRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetEndDeviceModelRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetEndDeviceModelRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetEndDeviceModelRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "brand_id":

			if utf8.RuneCountInString(m.GetBrandId()) > 36 {
				return GetEndDeviceModelRequestValidationError{
					field:  "brand_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_GetEndDeviceModelRequest_BrandId_Pattern.MatchString(m.GetBrandId()) {
				return GetEndDeviceModelRequestValidationError{
					field:  "brand_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "model_id":

			if utf8.RuneCountInString(m.GetModelId()) > 36 {
				return GetEndDeviceModelRequestValidationError{
					field:  "model_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_GetEndDeviceModelRequest_ModelId_Pattern.MatchString(m.GetModelId()) {
				return GetEndDeviceModelRequestValidationError{
					field:  "model_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetEndDeviceModelRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetEndDeviceModelRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetEndDeviceModelRequestValidationError is the validation error returned by
// GetEndDeviceModelRequest.ValidateFields if the designated constraints
// aren't met.
type GetEndDeviceModelRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetEndDeviceModelRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetEndDeviceModelRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetEndDeviceModelRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetEndDeviceModelRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetEndDeviceModelRequestValidationError) ErrorName() string {
	return "GetEndDeviceModelRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetEndDeviceModelRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetEndDeviceModelRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetEndDeviceModelRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetEndDeviceModelRequestValidationError{}

var _GetEndDeviceModelRequest_BrandId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

var _GetEndDeviceModelRequest_ModelId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on ListEndDeviceModelsRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ListEndDeviceModelsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListEndDeviceModelsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListEndDeviceModelsRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "brand_id":

			if utf8.RuneCountInString(m.GetBrandId()) > 36 {
				return ListEndDeviceModelsRequestValidationError{
					field:  "brand_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_ListEndDeviceModelsRequest_BrandId_Pattern.MatchString(m.GetBrandId()) {
				return ListEndDeviceModelsRequestValidationError{
					field:  "brand_id",
					reason: "value does not match regex pattern \"^([a-z0-9](?:[-]?[a-z0-9]){2,}|)?$\"",
				}
			}

		case "limit":

			if m.GetLimit() > 1000 {
				return ListEndDeviceModelsRequestValidationError{
					field:  "limit",
					reason: "value must be less than or equal to 1000",
				}
			}

		case "page":
			// no validation rules for Page
		case "order_by":

			if _, ok := _ListEndDeviceModelsRequest_OrderBy_InLookup[m.GetOrderBy()]; !ok {
				return ListEndDeviceModelsRequestValidationError{
					field:  "order_by",
					reason: "value must be in list [ brand_id -brand_id model_id -model_id name -name]",
				}
			}

		case "search":

			if utf8.RuneCountInString(m.GetSearch()) > 100 {
				return ListEndDeviceModelsRequestValidationError{
					field:  "search",
					reason: "value length must be at most 100 runes",
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListEndDeviceModelsRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ListEndDeviceModelsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListEndDeviceModelsRequestValidationError is the validation error returned
// by ListEndDeviceModelsRequest.ValidateFields if the designated constraints
// aren't met.
type ListEndDeviceModelsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListEndDeviceModelsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListEndDeviceModelsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListEndDeviceModelsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListEndDeviceModelsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListEndDeviceModelsRequestValidationError) ErrorName() string {
	return "ListEndDeviceModelsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListEndDeviceModelsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListEndDeviceModelsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListEndDeviceModelsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListEndDeviceModelsRequestValidationError{}

var _ListEndDeviceModelsRequest_BrandId_Pattern = regexp.MustCompile("^([a-z0-9](?:[-]?[a-z0-9]){2,}|)?$")

var _ListEndDeviceModelsRequest_OrderBy_InLookup = map[string]struct{}{
	"":          {},
	"brand_id":  {},
	"-brand_id": {},
	"model_id":  {},
	"-model_id": {},
	"name":      {},
	"-name":     {},
}

// ValidateFields checks the field values on GetTemplateRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetTemplateRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetTemplateRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetTemplateRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "version_ids":

			if v, ok := interface{}(m.GetVersionIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetTemplateRequestValidationError{
						field:  "version_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "end_device_profile_ids":

			if v, ok := interface{}(m.GetEndDeviceProfileIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetTemplateRequestValidationError{
						field:  "end_device_profile_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetTemplateRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetTemplateRequestValidationError is the validation error returned by
// GetTemplateRequest.ValidateFields if the designated constraints aren't met.
type GetTemplateRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetTemplateRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetTemplateRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetTemplateRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetTemplateRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetTemplateRequestValidationError) ErrorName() string {
	return "GetTemplateRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetTemplateRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetTemplateRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetTemplateRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetTemplateRequestValidationError{}

// ValidateFields checks the field values on GetPayloadFormatterRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *GetPayloadFormatterRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetPayloadFormatterRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetPayloadFormatterRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "version_ids":

			if v, ok := interface{}(m.GetVersionIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetPayloadFormatterRequestValidationError{
						field:  "version_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetPayloadFormatterRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetPayloadFormatterRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetPayloadFormatterRequestValidationError is the validation error returned
// by GetPayloadFormatterRequest.ValidateFields if the designated constraints
// aren't met.
type GetPayloadFormatterRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetPayloadFormatterRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetPayloadFormatterRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetPayloadFormatterRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetPayloadFormatterRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetPayloadFormatterRequestValidationError) ErrorName() string {
	return "GetPayloadFormatterRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetPayloadFormatterRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetPayloadFormatterRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetPayloadFormatterRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetPayloadFormatterRequestValidationError{}

// ValidateFields checks the field values on ListEndDeviceBrandsResponse with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ListEndDeviceBrandsResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListEndDeviceBrandsResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "brands":

			for idx, item := range m.GetBrands() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ListEndDeviceBrandsResponseValidationError{
							field:  fmt.Sprintf("brands[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ListEndDeviceBrandsResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListEndDeviceBrandsResponseValidationError is the validation error returned
// by ListEndDeviceBrandsResponse.ValidateFields if the designated constraints
// aren't met.
type ListEndDeviceBrandsResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListEndDeviceBrandsResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListEndDeviceBrandsResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListEndDeviceBrandsResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListEndDeviceBrandsResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListEndDeviceBrandsResponseValidationError) ErrorName() string {
	return "ListEndDeviceBrandsResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ListEndDeviceBrandsResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListEndDeviceBrandsResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListEndDeviceBrandsResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListEndDeviceBrandsResponseValidationError{}

// ValidateFields checks the field values on ListEndDeviceModelsResponse with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ListEndDeviceModelsResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListEndDeviceModelsResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "models":

			for idx, item := range m.GetModels() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ListEndDeviceModelsResponseValidationError{
							field:  fmt.Sprintf("models[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ListEndDeviceModelsResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListEndDeviceModelsResponseValidationError is the validation error returned
// by ListEndDeviceModelsResponse.ValidateFields if the designated constraints
// aren't met.
type ListEndDeviceModelsResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListEndDeviceModelsResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListEndDeviceModelsResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListEndDeviceModelsResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListEndDeviceModelsResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListEndDeviceModelsResponseValidationError) ErrorName() string {
	return "ListEndDeviceModelsResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ListEndDeviceModelsResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListEndDeviceModelsResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListEndDeviceModelsResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListEndDeviceModelsResponseValidationError{}

// ValidateFields checks the field values on EncodedMessagePayload with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *EncodedMessagePayload) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EncodedMessagePayloadFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "f_port":

			if m.GetFPort() > 255 {
				return EncodedMessagePayloadValidationError{
					field:  "f_port",
					reason: "value must be less than or equal to 255",
				}
			}

		case "frm_payload":
			// no validation rules for FrmPayload
		case "warnings":

			if len(m.GetWarnings()) > 10 {
				return EncodedMessagePayloadValidationError{
					field:  "warnings",
					reason: "value must contain no more than 10 item(s)",
				}
			}

			for idx, item := range m.GetWarnings() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 100 {
					return EncodedMessagePayloadValidationError{
						field:  fmt.Sprintf("warnings[%v]", idx),
						reason: "value length must be at most 100 runes",
					}
				}

			}

		case "errors":

			if len(m.GetErrors()) > 10 {
				return EncodedMessagePayloadValidationError{
					field:  "errors",
					reason: "value must contain no more than 10 item(s)",
				}
			}

			for idx, item := range m.GetErrors() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 100 {
					return EncodedMessagePayloadValidationError{
						field:  fmt.Sprintf("errors[%v]", idx),
						reason: "value length must be at most 100 runes",
					}
				}

			}

		default:
			return EncodedMessagePayloadValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EncodedMessagePayloadValidationError is the validation error returned by
// EncodedMessagePayload.ValidateFields if the designated constraints aren't met.
type EncodedMessagePayloadValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EncodedMessagePayloadValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EncodedMessagePayloadValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EncodedMessagePayloadValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EncodedMessagePayloadValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EncodedMessagePayloadValidationError) ErrorName() string {
	return "EncodedMessagePayloadValidationError"
}

// Error satisfies the builtin error interface
func (e EncodedMessagePayloadValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEncodedMessagePayload.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EncodedMessagePayloadValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EncodedMessagePayloadValidationError{}

// ValidateFields checks the field values on DecodedMessagePayload with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DecodedMessagePayload) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = DecodedMessagePayloadFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "data":

			if v, ok := interface{}(m.GetData()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return DecodedMessagePayloadValidationError{
						field:  "data",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "warnings":

			if len(m.GetWarnings()) > 10 {
				return DecodedMessagePayloadValidationError{
					field:  "warnings",
					reason: "value must contain no more than 10 item(s)",
				}
			}

			for idx, item := range m.GetWarnings() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 100 {
					return DecodedMessagePayloadValidationError{
						field:  fmt.Sprintf("warnings[%v]", idx),
						reason: "value length must be at most 100 runes",
					}
				}

			}

		case "errors":

			if len(m.GetErrors()) > 10 {
				return DecodedMessagePayloadValidationError{
					field:  "errors",
					reason: "value must contain no more than 10 item(s)",
				}
			}

			for idx, item := range m.GetErrors() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 100 {
					return DecodedMessagePayloadValidationError{
						field:  fmt.Sprintf("errors[%v]", idx),
						reason: "value length must be at most 100 runes",
					}
				}

			}

		default:
			return DecodedMessagePayloadValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// DecodedMessagePayloadValidationError is the validation error returned by
// DecodedMessagePayload.ValidateFields if the designated constraints aren't met.
type DecodedMessagePayloadValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DecodedMessagePayloadValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DecodedMessagePayloadValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DecodedMessagePayloadValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DecodedMessagePayloadValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DecodedMessagePayloadValidationError) ErrorName() string {
	return "DecodedMessagePayloadValidationError"
}

// Error satisfies the builtin error interface
func (e DecodedMessagePayloadValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDecodedMessagePayload.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DecodedMessagePayloadValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DecodedMessagePayloadValidationError{}

// ValidateFields checks the field values on MessagePayloadDecoder with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MessagePayloadDecoder) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MessagePayloadDecoderFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "formatter":

			if _, ok := PayloadFormatter_name[int32(m.GetFormatter())]; !ok {
				return MessagePayloadDecoderValidationError{
					field:  "formatter",
					reason: "value must be one of the defined enum values",
				}
			}

		case "formatter_parameter":
			// no validation rules for FormatterParameter
		case "codec_id":

			if utf8.RuneCountInString(m.GetCodecId()) > 36 {
				return MessagePayloadDecoderValidationError{
					field:  "codec_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_MessagePayloadDecoder_CodecId_Pattern.MatchString(m.GetCodecId()) {
				return MessagePayloadDecoderValidationError{
					field:  "codec_id",
					reason: "value does not match regex pattern \"^([a-z0-9](?:[-]?[a-z0-9]){2,}|)?$\"",
				}
			}

		case "examples":

			if len(m.GetExamples()) > 20 {
				return MessagePayloadDecoderValidationError{
					field:  "examples",
					reason: "value must contain no more than 20 item(s)",
				}
			}

			for idx, item := range m.GetExamples() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return MessagePayloadDecoderValidationError{
							field:  fmt.Sprintf("examples[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return MessagePayloadDecoderValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MessagePayloadDecoderValidationError is the validation error returned by
// MessagePayloadDecoder.ValidateFields if the designated constraints aren't met.
type MessagePayloadDecoderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MessagePayloadDecoderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MessagePayloadDecoderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MessagePayloadDecoderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MessagePayloadDecoderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MessagePayloadDecoderValidationError) ErrorName() string {
	return "MessagePayloadDecoderValidationError"
}

// Error satisfies the builtin error interface
func (e MessagePayloadDecoderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMessagePayloadDecoder.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MessagePayloadDecoderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MessagePayloadDecoderValidationError{}

var _MessagePayloadDecoder_CodecId_Pattern = regexp.MustCompile("^([a-z0-9](?:[-]?[a-z0-9]){2,}|)?$")

// ValidateFields checks the field values on MessagePayloadEncoder with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *MessagePayloadEncoder) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MessagePayloadEncoderFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "formatter":

			if _, ok := PayloadFormatter_name[int32(m.GetFormatter())]; !ok {
				return MessagePayloadEncoderValidationError{
					field:  "formatter",
					reason: "value must be one of the defined enum values",
				}
			}

		case "formatter_parameter":
			// no validation rules for FormatterParameter
		case "codec_id":

			if utf8.RuneCountInString(m.GetCodecId()) > 36 {
				return MessagePayloadEncoderValidationError{
					field:  "codec_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_MessagePayloadEncoder_CodecId_Pattern.MatchString(m.GetCodecId()) {
				return MessagePayloadEncoderValidationError{
					field:  "codec_id",
					reason: "value does not match regex pattern \"^([a-z0-9](?:[-]?[a-z0-9]){2,}|)?$\"",
				}
			}

		case "examples":

			if len(m.GetExamples()) > 20 {
				return MessagePayloadEncoderValidationError{
					field:  "examples",
					reason: "value must contain no more than 20 item(s)",
				}
			}

			for idx, item := range m.GetExamples() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return MessagePayloadEncoderValidationError{
							field:  fmt.Sprintf("examples[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return MessagePayloadEncoderValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MessagePayloadEncoderValidationError is the validation error returned by
// MessagePayloadEncoder.ValidateFields if the designated constraints aren't met.
type MessagePayloadEncoderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MessagePayloadEncoderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MessagePayloadEncoderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MessagePayloadEncoderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MessagePayloadEncoderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MessagePayloadEncoderValidationError) ErrorName() string {
	return "MessagePayloadEncoderValidationError"
}

// Error satisfies the builtin error interface
func (e MessagePayloadEncoderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMessagePayloadEncoder.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MessagePayloadEncoderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MessagePayloadEncoderValidationError{}

var _MessagePayloadEncoder_CodecId_Pattern = regexp.MustCompile("^([a-z0-9](?:[-]?[a-z0-9]){2,}|)?$")

// ValidateFields checks the field values on EndDeviceModel_HardwareVersion
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *EndDeviceModel_HardwareVersion) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceModel_HardwareVersionFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "version":
			// no validation rules for Version
		case "numeric":
			// no validation rules for Numeric
		case "part_number":
			// no validation rules for PartNumber
		default:
			return EndDeviceModel_HardwareVersionValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceModel_HardwareVersionValidationError is the validation error
// returned by EndDeviceModel_HardwareVersion.ValidateFields if the designated
// constraints aren't met.
type EndDeviceModel_HardwareVersionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceModel_HardwareVersionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceModel_HardwareVersionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceModel_HardwareVersionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceModel_HardwareVersionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceModel_HardwareVersionValidationError) ErrorName() string {
	return "EndDeviceModel_HardwareVersionValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceModel_HardwareVersionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceModel_HardwareVersion.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceModel_HardwareVersionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceModel_HardwareVersionValidationError{}

// ValidateFields checks the field values on EndDeviceModel_FirmwareVersion
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *EndDeviceModel_FirmwareVersion) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceModel_FirmwareVersionFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "version":
			// no validation rules for Version
		case "numeric":
			// no validation rules for Numeric
		case "supported_hardware_versions":

			_EndDeviceModel_FirmwareVersion_SupportedHardwareVersions_Unique := make(map[string]struct{}, len(m.GetSupportedHardwareVersions()))

			for idx, item := range m.GetSupportedHardwareVersions() {
				_, _ = idx, item

				if _, exists := _EndDeviceModel_FirmwareVersion_SupportedHardwareVersions_Unique[item]; exists {
					return EndDeviceModel_FirmwareVersionValidationError{
						field:  fmt.Sprintf("supported_hardware_versions[%v]", idx),
						reason: "repeated value must contain unique items",
					}
				} else {
					_EndDeviceModel_FirmwareVersion_SupportedHardwareVersions_Unique[item] = struct{}{}
				}

				// no validation rules for SupportedHardwareVersions[idx]
			}

		case "profiles":

			for key, val := range m.GetProfiles() {
				_ = val

				// no validation rules for Profiles[key]

				if v, ok := interface{}(val).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return EndDeviceModel_FirmwareVersionValidationError{
							field:  fmt.Sprintf("profiles[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return EndDeviceModel_FirmwareVersionValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceModel_FirmwareVersionValidationError is the validation error
// returned by EndDeviceModel_FirmwareVersion.ValidateFields if the designated
// constraints aren't met.
type EndDeviceModel_FirmwareVersionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceModel_FirmwareVersionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceModel_FirmwareVersionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceModel_FirmwareVersionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceModel_FirmwareVersionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceModel_FirmwareVersionValidationError) ErrorName() string {
	return "EndDeviceModel_FirmwareVersionValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceModel_FirmwareVersionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceModel_FirmwareVersion.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceModel_FirmwareVersionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceModel_FirmwareVersionValidationError{}

// ValidateFields checks the field values on EndDeviceModel_Dimensions with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *EndDeviceModel_Dimensions) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceModel_DimensionsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "width":

			if v, ok := interface{}(m.GetWidth()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModel_DimensionsValidationError{
						field:  "width",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "height":

			if v, ok := interface{}(m.GetHeight()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModel_DimensionsValidationError{
						field:  "height",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "diameter":

			if v, ok := interface{}(m.GetDiameter()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModel_DimensionsValidationError{
						field:  "diameter",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "length":

			if v, ok := interface{}(m.GetLength()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModel_DimensionsValidationError{
						field:  "length",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return EndDeviceModel_DimensionsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceModel_DimensionsValidationError is the validation error returned by
// EndDeviceModel_Dimensions.ValidateFields if the designated constraints
// aren't met.
type EndDeviceModel_DimensionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceModel_DimensionsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceModel_DimensionsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceModel_DimensionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceModel_DimensionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceModel_DimensionsValidationError) ErrorName() string {
	return "EndDeviceModel_DimensionsValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceModel_DimensionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceModel_Dimensions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceModel_DimensionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceModel_DimensionsValidationError{}

// ValidateFields checks the field values on EndDeviceModel_Battery with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *EndDeviceModel_Battery) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceModel_BatteryFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "replaceable":

			if v, ok := interface{}(m.GetReplaceable()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModel_BatteryValidationError{
						field:  "replaceable",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "type":
			// no validation rules for Type
		default:
			return EndDeviceModel_BatteryValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceModel_BatteryValidationError is the validation error returned by
// EndDeviceModel_Battery.ValidateFields if the designated constraints aren't met.
type EndDeviceModel_BatteryValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceModel_BatteryValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceModel_BatteryValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceModel_BatteryValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceModel_BatteryValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceModel_BatteryValidationError) ErrorName() string {
	return "EndDeviceModel_BatteryValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceModel_BatteryValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceModel_Battery.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceModel_BatteryValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceModel_BatteryValidationError{}

// ValidateFields checks the field values on EndDeviceModel_OperatingConditions
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *EndDeviceModel_OperatingConditions) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceModel_OperatingConditionsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "temperature":

			if v, ok := interface{}(m.GetTemperature()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModel_OperatingConditionsValidationError{
						field:  "temperature",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "relative_humidity":

			if v, ok := interface{}(m.GetRelativeHumidity()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModel_OperatingConditionsValidationError{
						field:  "relative_humidity",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return EndDeviceModel_OperatingConditionsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceModel_OperatingConditionsValidationError is the validation error
// returned by EndDeviceModel_OperatingConditions.ValidateFields if the
// designated constraints aren't met.
type EndDeviceModel_OperatingConditionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceModel_OperatingConditionsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceModel_OperatingConditionsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceModel_OperatingConditionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceModel_OperatingConditionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceModel_OperatingConditionsValidationError) ErrorName() string {
	return "EndDeviceModel_OperatingConditionsValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceModel_OperatingConditionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceModel_OperatingConditions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceModel_OperatingConditionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceModel_OperatingConditionsValidationError{}

// ValidateFields checks the field values on EndDeviceModel_Photos with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *EndDeviceModel_Photos) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceModel_PhotosFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "main":

			if !_EndDeviceModel_Photos_Main_Pattern.MatchString(m.GetMain()) {
				return EndDeviceModel_PhotosValidationError{
					field:  "main",
					reason: "value does not match regex pattern \"^$|^(([a-z0-9-]+\\\\/)+)?([a-z0-9_-]+\\\\.)+(png|jpg|jpeg)$\"",
				}
			}

		case "other":

			_EndDeviceModel_Photos_Other_Unique := make(map[string]struct{}, len(m.GetOther()))

			for idx, item := range m.GetOther() {
				_, _ = idx, item

				if _, exists := _EndDeviceModel_Photos_Other_Unique[item]; exists {
					return EndDeviceModel_PhotosValidationError{
						field:  fmt.Sprintf("other[%v]", idx),
						reason: "repeated value must contain unique items",
					}
				} else {
					_EndDeviceModel_Photos_Other_Unique[item] = struct{}{}
				}

				if !_EndDeviceModel_Photos_Other_Pattern.MatchString(item) {
					return EndDeviceModel_PhotosValidationError{
						field:  fmt.Sprintf("other[%v]", idx),
						reason: "value does not match regex pattern \"^$|^(([a-z0-9-]+\\\\/)+)?([a-z0-9_-]+\\\\.)+(png|jpg|jpeg)$\"",
					}
				}

			}

		default:
			return EndDeviceModel_PhotosValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceModel_PhotosValidationError is the validation error returned by
// EndDeviceModel_Photos.ValidateFields if the designated constraints aren't met.
type EndDeviceModel_PhotosValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceModel_PhotosValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceModel_PhotosValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceModel_PhotosValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceModel_PhotosValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceModel_PhotosValidationError) ErrorName() string {
	return "EndDeviceModel_PhotosValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceModel_PhotosValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceModel_Photos.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceModel_PhotosValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceModel_PhotosValidationError{}

var _EndDeviceModel_Photos_Main_Pattern = regexp.MustCompile("^$|^(([a-z0-9-]+\\/)+)?([a-z0-9_-]+\\.)+(png|jpg|jpeg)$")

var _EndDeviceModel_Photos_Other_Pattern = regexp.MustCompile("^$|^(([a-z0-9-]+\\/)+)?([a-z0-9_-]+\\.)+(png|jpg|jpeg)$")

// ValidateFields checks the field values on EndDeviceModel_Videos with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *EndDeviceModel_Videos) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceModel_VideosFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "main":

			if !_EndDeviceModel_Videos_Main_Pattern.MatchString(m.GetMain()) {
				return EndDeviceModel_VideosValidationError{
					field:  "main",
					reason: "value does not match regex pattern \"^(?:https?:\\\\/\\\\/(?:www\\\\.)?youtu(?:be\\\\.com\\\\/watch\\\\?v=|\\\\.be\\\\/)(?:[\\\\w\\\\-_]*)(?:&(amp;)?[\\\\w\\\\?=]*)?)$|^(?:https?:\\\\/\\\\/(?:www\\\\.)?vimeo\\\\.com\\\\/(?:channels\\\\/(?:\\\\w+\\\\/)?|groups\\\\/([^\\\\/]*)\\\\/videos\\\\/|)(?:\\\\d+)(?:|\\\\/\\\\?))$\"",
				}
			}

		case "other":

			_EndDeviceModel_Videos_Other_Unique := make(map[string]struct{}, len(m.GetOther()))

			for idx, item := range m.GetOther() {
				_, _ = idx, item

				if _, exists := _EndDeviceModel_Videos_Other_Unique[item]; exists {
					return EndDeviceModel_VideosValidationError{
						field:  fmt.Sprintf("other[%v]", idx),
						reason: "repeated value must contain unique items",
					}
				} else {
					_EndDeviceModel_Videos_Other_Unique[item] = struct{}{}
				}

				if !_EndDeviceModel_Videos_Other_Pattern.MatchString(item) {
					return EndDeviceModel_VideosValidationError{
						field:  fmt.Sprintf("other[%v]", idx),
						reason: "value does not match regex pattern \"^(?:https?:\\\\/\\\\/(?:www\\\\.)?youtu(?:be\\\\.com\\\\/watch\\\\?v=|\\\\.be\\\\/)(?:[\\\\w\\\\-_]*)(?:&(amp;)?[\\\\w\\\\?=]*)?)$|^(?:https?:\\\\/\\\\/(?:www\\\\.)?vimeo\\\\.com\\\\/(?:channels\\\\/(?:\\\\w+\\\\/)?|groups\\\\/([^\\\\/]*)\\\\/videos\\\\/|)(?:\\\\d+)(?:|\\\\/\\\\?))$\"",
					}
				}

			}

		default:
			return EndDeviceModel_VideosValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceModel_VideosValidationError is the validation error returned by
// EndDeviceModel_Videos.ValidateFields if the designated constraints aren't met.
type EndDeviceModel_VideosValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceModel_VideosValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceModel_VideosValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceModel_VideosValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceModel_VideosValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceModel_VideosValidationError) ErrorName() string {
	return "EndDeviceModel_VideosValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceModel_VideosValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceModel_Videos.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceModel_VideosValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceModel_VideosValidationError{}

var _EndDeviceModel_Videos_Main_Pattern = regexp.MustCompile("^(?:https?:\\/\\/(?:www\\.)?youtu(?:be\\.com\\/watch\\?v=|\\.be\\/)(?:[\\w\\-_]*)(?:&(amp;)?[\\w\\?=]*)?)$|^(?:https?:\\/\\/(?:www\\.)?vimeo\\.com\\/(?:channels\\/(?:\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|)(?:\\d+)(?:|\\/\\?))$")

var _EndDeviceModel_Videos_Other_Pattern = regexp.MustCompile("^(?:https?:\\/\\/(?:www\\.)?youtu(?:be\\.com\\/watch\\?v=|\\.be\\/)(?:[\\w\\-_]*)(?:&(amp;)?[\\w\\?=]*)?)$|^(?:https?:\\/\\/(?:www\\.)?vimeo\\.com\\/(?:channels\\/(?:\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|)(?:\\d+)(?:|\\/\\?))$")

// ValidateFields checks the field values on EndDeviceModel_Reseller with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *EndDeviceModel_Reseller) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceModel_ResellerFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "name":
			// no validation rules for Name
		case "region":

		case "url":

			if m.GetUrl() != "" {

				if uri, err := url.Parse(m.GetUrl()); err != nil {
					return EndDeviceModel_ResellerValidationError{
						field:  "url",
						reason: "value must be a valid URI",
						cause:  err,
					}
				} else if !uri.IsAbs() {
					return EndDeviceModel_ResellerValidationError{
						field:  "url",
						reason: "value must be absolute",
					}
				}

			}

		default:
			return EndDeviceModel_ResellerValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceModel_ResellerValidationError is the validation error returned by
// EndDeviceModel_Reseller.ValidateFields if the designated constraints aren't met.
type EndDeviceModel_ResellerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceModel_ResellerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceModel_ResellerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceModel_ResellerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceModel_ResellerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceModel_ResellerValidationError) ErrorName() string {
	return "EndDeviceModel_ResellerValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceModel_ResellerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceModel_Reseller.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceModel_ResellerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceModel_ResellerValidationError{}

// ValidateFields checks the field values on EndDeviceModel_Compliances with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *EndDeviceModel_Compliances) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceModel_CompliancesFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "safety":

			for idx, item := range m.GetSafety() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return EndDeviceModel_CompliancesValidationError{
							field:  fmt.Sprintf("safety[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "radio_equipment":

			for idx, item := range m.GetRadioEquipment() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return EndDeviceModel_CompliancesValidationError{
							field:  fmt.Sprintf("radio_equipment[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return EndDeviceModel_CompliancesValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceModel_CompliancesValidationError is the validation error returned
// by EndDeviceModel_Compliances.ValidateFields if the designated constraints
// aren't met.
type EndDeviceModel_CompliancesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceModel_CompliancesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceModel_CompliancesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceModel_CompliancesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceModel_CompliancesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceModel_CompliancesValidationError) ErrorName() string {
	return "EndDeviceModel_CompliancesValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceModel_CompliancesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceModel_Compliances.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceModel_CompliancesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceModel_CompliancesValidationError{}

// ValidateFields checks the field values on
// EndDeviceModel_FirmwareVersion_Profile with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *EndDeviceModel_FirmwareVersion_Profile) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceModel_FirmwareVersion_ProfileFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "vendor_id":

			if utf8.RuneCountInString(m.GetVendorId()) > 36 {
				return EndDeviceModel_FirmwareVersion_ProfileValidationError{
					field:  "vendor_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_EndDeviceModel_FirmwareVersion_Profile_VendorId_Pattern.MatchString(m.GetVendorId()) {
				return EndDeviceModel_FirmwareVersion_ProfileValidationError{
					field:  "vendor_id",
					reason: "value does not match regex pattern \"^$|^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "profile_id":

			if utf8.RuneCountInString(m.GetProfileId()) > 36 {
				return EndDeviceModel_FirmwareVersion_ProfileValidationError{
					field:  "profile_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_EndDeviceModel_FirmwareVersion_Profile_ProfileId_Pattern.MatchString(m.GetProfileId()) {
				return EndDeviceModel_FirmwareVersion_ProfileValidationError{
					field:  "profile_id",
					reason: "value does not match regex pattern \"^$|^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "lorawan_certified":
			// no validation rules for LorawanCertified
		case "codec_id":

			if utf8.RuneCountInString(m.GetCodecId()) > 36 {
				return EndDeviceModel_FirmwareVersion_ProfileValidationError{
					field:  "codec_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_EndDeviceModel_FirmwareVersion_Profile_CodecId_Pattern.MatchString(m.GetCodecId()) {
				return EndDeviceModel_FirmwareVersion_ProfileValidationError{
					field:  "codec_id",
					reason: "value does not match regex pattern \"^$|^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		default:
			return EndDeviceModel_FirmwareVersion_ProfileValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceModel_FirmwareVersion_ProfileValidationError is the validation
// error returned by EndDeviceModel_FirmwareVersion_Profile.ValidateFields if
// the designated constraints aren't met.
type EndDeviceModel_FirmwareVersion_ProfileValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceModel_FirmwareVersion_ProfileValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceModel_FirmwareVersion_ProfileValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceModel_FirmwareVersion_ProfileValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceModel_FirmwareVersion_ProfileValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceModel_FirmwareVersion_ProfileValidationError) ErrorName() string {
	return "EndDeviceModel_FirmwareVersion_ProfileValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceModel_FirmwareVersion_ProfileValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceModel_FirmwareVersion_Profile.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceModel_FirmwareVersion_ProfileValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceModel_FirmwareVersion_ProfileValidationError{}

var _EndDeviceModel_FirmwareVersion_Profile_VendorId_Pattern = regexp.MustCompile("^$|^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

var _EndDeviceModel_FirmwareVersion_Profile_ProfileId_Pattern = regexp.MustCompile("^$|^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

var _EndDeviceModel_FirmwareVersion_Profile_CodecId_Pattern = regexp.MustCompile("^$|^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on
// EndDeviceModel_OperatingConditions_Limits with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *EndDeviceModel_OperatingConditions_Limits) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceModel_OperatingConditions_LimitsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "min":

			if v, ok := interface{}(m.GetMin()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModel_OperatingConditions_LimitsValidationError{
						field:  "min",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "max":

			if v, ok := interface{}(m.GetMax()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return EndDeviceModel_OperatingConditions_LimitsValidationError{
						field:  "max",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return EndDeviceModel_OperatingConditions_LimitsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceModel_OperatingConditions_LimitsValidationError is the validation
// error returned by EndDeviceModel_OperatingConditions_Limits.ValidateFields
// if the designated constraints aren't met.
type EndDeviceModel_OperatingConditions_LimitsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceModel_OperatingConditions_LimitsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceModel_OperatingConditions_LimitsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceModel_OperatingConditions_LimitsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceModel_OperatingConditions_LimitsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceModel_OperatingConditions_LimitsValidationError) ErrorName() string {
	return "EndDeviceModel_OperatingConditions_LimitsValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceModel_OperatingConditions_LimitsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceModel_OperatingConditions_Limits.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceModel_OperatingConditions_LimitsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceModel_OperatingConditions_LimitsValidationError{}

// ValidateFields checks the field values on
// EndDeviceModel_Compliances_Compliance with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *EndDeviceModel_Compliances_Compliance) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = EndDeviceModel_Compliances_ComplianceFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "body":
			// no validation rules for Body
		case "norm":
			// no validation rules for Norm
		case "standard":
			// no validation rules for Standard
		case "version":
			// no validation rules for Version
		default:
			return EndDeviceModel_Compliances_ComplianceValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// EndDeviceModel_Compliances_ComplianceValidationError is the validation error
// returned by EndDeviceModel_Compliances_Compliance.ValidateFields if the
// designated constraints aren't met.
type EndDeviceModel_Compliances_ComplianceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndDeviceModel_Compliances_ComplianceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndDeviceModel_Compliances_ComplianceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndDeviceModel_Compliances_ComplianceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndDeviceModel_Compliances_ComplianceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndDeviceModel_Compliances_ComplianceValidationError) ErrorName() string {
	return "EndDeviceModel_Compliances_ComplianceValidationError"
}

// Error satisfies the builtin error interface
func (e EndDeviceModel_Compliances_ComplianceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndDeviceModel_Compliances_Compliance.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndDeviceModel_Compliances_ComplianceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndDeviceModel_Compliances_ComplianceValidationError{}

// ValidateFields checks the field values on
// GetTemplateRequest_EndDeviceProfileIdentifiers with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *GetTemplateRequest_EndDeviceProfileIdentifiers) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetTemplateRequest_EndDeviceProfileIdentifiersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "vendor_id":

			if m.GetVendorId() < 1 {
				return GetTemplateRequest_EndDeviceProfileIdentifiersValidationError{
					field:  "vendor_id",
					reason: "value must be greater than or equal to 1",
				}
			}

		case "vendor_profile_id":
			// no validation rules for VendorProfileId
		default:
			return GetTemplateRequest_EndDeviceProfileIdentifiersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetTemplateRequest_EndDeviceProfileIdentifiersValidationError is the
// validation error returned by
// GetTemplateRequest_EndDeviceProfileIdentifiers.ValidateFields if the
// designated constraints aren't met.
type GetTemplateRequest_EndDeviceProfileIdentifiersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetTemplateRequest_EndDeviceProfileIdentifiersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetTemplateRequest_EndDeviceProfileIdentifiersValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e GetTemplateRequest_EndDeviceProfileIdentifiersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetTemplateRequest_EndDeviceProfileIdentifiersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetTemplateRequest_EndDeviceProfileIdentifiersValidationError) ErrorName() string {
	return "GetTemplateRequest_EndDeviceProfileIdentifiersValidationError"
}

// Error satisfies the builtin error interface
func (e GetTemplateRequest_EndDeviceProfileIdentifiersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetTemplateRequest_EndDeviceProfileIdentifiers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetTemplateRequest_EndDeviceProfileIdentifiersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetTemplateRequest_EndDeviceProfileIdentifiersValidationError{}

// ValidateFields checks the field values on MessagePayloadDecoder_Example with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *MessagePayloadDecoder_Example) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MessagePayloadDecoder_ExampleFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "description":

			if utf8.RuneCountInString(m.GetDescription()) > 200 {
				return MessagePayloadDecoder_ExampleValidationError{
					field:  "description",
					reason: "value length must be at most 200 runes",
				}
			}

		case "input":

			if v, ok := interface{}(m.GetInput()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MessagePayloadDecoder_ExampleValidationError{
						field:  "input",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "output":

			if v, ok := interface{}(m.GetOutput()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MessagePayloadDecoder_ExampleValidationError{
						field:  "output",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return MessagePayloadDecoder_ExampleValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MessagePayloadDecoder_ExampleValidationError is the validation error
// returned by MessagePayloadDecoder_Example.ValidateFields if the designated
// constraints aren't met.
type MessagePayloadDecoder_ExampleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MessagePayloadDecoder_ExampleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MessagePayloadDecoder_ExampleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MessagePayloadDecoder_ExampleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MessagePayloadDecoder_ExampleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MessagePayloadDecoder_ExampleValidationError) ErrorName() string {
	return "MessagePayloadDecoder_ExampleValidationError"
}

// Error satisfies the builtin error interface
func (e MessagePayloadDecoder_ExampleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMessagePayloadDecoder_Example.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MessagePayloadDecoder_ExampleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MessagePayloadDecoder_ExampleValidationError{}

// ValidateFields checks the field values on MessagePayloadEncoder_Example with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *MessagePayloadEncoder_Example) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = MessagePayloadEncoder_ExampleFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "description":

			if utf8.RuneCountInString(m.GetDescription()) > 200 {
				return MessagePayloadEncoder_ExampleValidationError{
					field:  "description",
					reason: "value length must be at most 200 runes",
				}
			}

		case "input":

			if v, ok := interface{}(m.GetInput()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MessagePayloadEncoder_ExampleValidationError{
						field:  "input",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "output":

			if v, ok := interface{}(m.GetOutput()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return MessagePayloadEncoder_ExampleValidationError{
						field:  "output",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return MessagePayloadEncoder_ExampleValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// MessagePayloadEncoder_ExampleValidationError is the validation error
// returned by MessagePayloadEncoder_Example.ValidateFields if the designated
// constraints aren't met.
type MessagePayloadEncoder_ExampleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MessagePayloadEncoder_ExampleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MessagePayloadEncoder_ExampleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MessagePayloadEncoder_ExampleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MessagePayloadEncoder_ExampleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MessagePayloadEncoder_ExampleValidationError) ErrorName() string {
	return "MessagePayloadEncoder_ExampleValidationError"
}

// Error satisfies the builtin error interface
func (e MessagePayloadEncoder_ExampleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMessagePayloadEncoder_Example.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MessagePayloadEncoder_ExampleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MessagePayloadEncoder_ExampleValidationError{}
