// Copyright © 2020 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/devicerepository.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type KeyProvisioning int32

const (
	// Unknown Key Provisioning.
	KeyProvisioning_KEY_PROVISIONING_UNKNOWN KeyProvisioning = 0
	// Custom Key Provisioning.
	KeyProvisioning_KEY_PROVISIONING_CUSTOM KeyProvisioning = 1
	// Key Provisioning from the Global Join Server.
	KeyProvisioning_KEY_PROVISIONING_JOIN_SERVER KeyProvisioning = 2
	// Key Provisioning from Manifest.
	KeyProvisioning_KEY_PROVISIONING_MANIFEST KeyProvisioning = 3
)

// Enum value maps for KeyProvisioning.
var (
	KeyProvisioning_name = map[int32]string{
		0: "KEY_PROVISIONING_UNKNOWN",
		1: "KEY_PROVISIONING_CUSTOM",
		2: "KEY_PROVISIONING_JOIN_SERVER",
		3: "KEY_PROVISIONING_MANIFEST",
	}
	KeyProvisioning_value = map[string]int32{
		"KEY_PROVISIONING_UNKNOWN":     0,
		"KEY_PROVISIONING_CUSTOM":      1,
		"KEY_PROVISIONING_JOIN_SERVER": 2,
		"KEY_PROVISIONING_MANIFEST":    3,
	}
)

func (x KeyProvisioning) Enum() *KeyProvisioning {
	p := new(KeyProvisioning)
	*p = x
	return p
}

func (x KeyProvisioning) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KeyProvisioning) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_devicerepository_proto_enumTypes[0].Descriptor()
}

func (KeyProvisioning) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_devicerepository_proto_enumTypes[0]
}

func (x KeyProvisioning) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KeyProvisioning.Descriptor instead.
func (KeyProvisioning) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{0}
}

type KeySecurity int32

const (
	// Unknown key security.
	KeySecurity_KEY_SECURITY_UNKNOWN KeySecurity = 0
	// No key security.
	KeySecurity_KEY_SECURITY_NONE KeySecurity = 1
	// Read Protected key security.
	KeySecurity_KEY_SECURITY_READ_PROTECTED KeySecurity = 2
	// Key security using the Security Element.
	KeySecurity_KEY_SECURITY_SECURE_ELEMENT KeySecurity = 3
)

// Enum value maps for KeySecurity.
var (
	KeySecurity_name = map[int32]string{
		0: "KEY_SECURITY_UNKNOWN",
		1: "KEY_SECURITY_NONE",
		2: "KEY_SECURITY_READ_PROTECTED",
		3: "KEY_SECURITY_SECURE_ELEMENT",
	}
	KeySecurity_value = map[string]int32{
		"KEY_SECURITY_UNKNOWN":        0,
		"KEY_SECURITY_NONE":           1,
		"KEY_SECURITY_READ_PROTECTED": 2,
		"KEY_SECURITY_SECURE_ELEMENT": 3,
	}
)

func (x KeySecurity) Enum() *KeySecurity {
	p := new(KeySecurity)
	*p = x
	return p
}

func (x KeySecurity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KeySecurity) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_devicerepository_proto_enumTypes[1].Descriptor()
}

func (KeySecurity) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_devicerepository_proto_enumTypes[1]
}

func (x KeySecurity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KeySecurity.Descriptor instead.
func (KeySecurity) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{1}
}

type EndDeviceBrand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Brand identifier, as specified in the Device Repository.
	BrandId string `protobuf:"bytes,1,opt,name=brand_id,json=brandId,proto3" json:"brand_id,omitempty"`
	// Brand name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Private Enterprise Number (PEN) assigned by IANA.
	PrivateEnterpriseNumber uint32 `protobuf:"varint,3,opt,name=private_enterprise_number,json=privateEnterpriseNumber,proto3" json:"private_enterprise_number,omitempty"`
	// Organization Unique Identifiers (OUI) assigned by IEEE.
	OrganizationUniqueIdentifiers []string `protobuf:"bytes,4,rep,name=organization_unique_identifiers,json=organizationUniqueIdentifiers,proto3" json:"organization_unique_identifiers,omitempty"`
	// VendorID managed by the LoRa Alliance, as defined in TR005.
	LoraAllianceVendorId uint32 `protobuf:"varint,5,opt,name=lora_alliance_vendor_id,json=loraAllianceVendorId,proto3" json:"lora_alliance_vendor_id,omitempty"`
	// Brand website URL.
	Website string `protobuf:"bytes,6,opt,name=website,proto3" json:"website,omitempty"`
	// Contact email address.
	Email string `protobuf:"bytes,7,opt,name=email,proto3" json:"email,omitempty"`
	// Path to brand logo.
	Logo string `protobuf:"bytes,8,opt,name=logo,proto3" json:"logo,omitempty"`
}

func (x *EndDeviceBrand) Reset() {
	*x = EndDeviceBrand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceBrand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceBrand) ProtoMessage() {}

func (x *EndDeviceBrand) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceBrand.ProtoReflect.Descriptor instead.
func (*EndDeviceBrand) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{0}
}

func (x *EndDeviceBrand) GetBrandId() string {
	if x != nil {
		return x.BrandId
	}
	return ""
}

func (x *EndDeviceBrand) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EndDeviceBrand) GetPrivateEnterpriseNumber() uint32 {
	if x != nil {
		return x.PrivateEnterpriseNumber
	}
	return 0
}

func (x *EndDeviceBrand) GetOrganizationUniqueIdentifiers() []string {
	if x != nil {
		return x.OrganizationUniqueIdentifiers
	}
	return nil
}

func (x *EndDeviceBrand) GetLoraAllianceVendorId() uint32 {
	if x != nil {
		return x.LoraAllianceVendorId
	}
	return 0
}

func (x *EndDeviceBrand) GetWebsite() string {
	if x != nil {
		return x.Website
	}
	return ""
}

func (x *EndDeviceBrand) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *EndDeviceBrand) GetLogo() string {
	if x != nil {
		return x.Logo
	}
	return ""
}

type EndDeviceModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Brand identifier, as defined in the Device Repository.
	BrandId string `protobuf:"bytes,1,opt,name=brand_id,json=brandId,proto3" json:"brand_id,omitempty"`
	// Model identifier, as defined in the Device Repository.
	ModelId string `protobuf:"bytes,2,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
	// Model name, as defined in the Device Repository.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Model description.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Available hardware versions.
	HardwareVersions []*EndDeviceModel_HardwareVersion `protobuf:"bytes,5,rep,name=hardware_versions,json=hardwareVersions,proto3" json:"hardware_versions,omitempty"`
	// Available firmware versions.
	FirmwareVersions []*EndDeviceModel_FirmwareVersion `protobuf:"bytes,6,rep,name=firmware_versions,json=firmwareVersions,proto3" json:"firmware_versions,omitempty"`
	// List of sensors included in the device.
	Sensors []string `protobuf:"bytes,7,rep,name=sensors,proto3" json:"sensors,omitempty"`
	// Device dimensions.
	Dimensions *EndDeviceModel_Dimensions `protobuf:"bytes,8,opt,name=dimensions,proto3" json:"dimensions,omitempty"`
	// Device weight (gram).
	Weight *wrapperspb.FloatValue `protobuf:"bytes,9,opt,name=weight,proto3" json:"weight,omitempty"`
	// Device battery information.
	Battery *EndDeviceModel_Battery `protobuf:"bytes,10,opt,name=battery,proto3" json:"battery,omitempty"`
	// Device operating conditions.
	OperatingConditions *EndDeviceModel_OperatingConditions `protobuf:"bytes,11,opt,name=operating_conditions,json=operatingConditions,proto3" json:"operating_conditions,omitempty"`
	// Device IP rating code.
	IpCode string `protobuf:"bytes,12,opt,name=ip_code,json=ipCode,proto3" json:"ip_code,omitempty"`
	// Supported key provisioning methods.
	KeyProvisioning []KeyProvisioning `protobuf:"varint,13,rep,packed,name=key_provisioning,json=keyProvisioning,proto3,enum=ttn.lorawan.v3.KeyProvisioning" json:"key_provisioning,omitempty"`
	// Device key security.
	KeySecurity KeySecurity `protobuf:"varint,14,opt,name=key_security,json=keySecurity,proto3,enum=ttn.lorawan.v3.KeySecurity" json:"key_security,omitempty"`
	// Device photos.
	Photos *EndDeviceModel_Photos `protobuf:"bytes,15,opt,name=photos,proto3" json:"photos,omitempty"`
	// Device videos.
	Videos *EndDeviceModel_Videos `protobuf:"bytes,16,opt,name=videos,proto3" json:"videos,omitempty"`
	// Device information page URL.
	ProductUrl string `protobuf:"bytes,17,opt,name=product_url,json=productUrl,proto3" json:"product_url,omitempty"`
	// Device datasheet URL.
	DatasheetUrl string `protobuf:"bytes,18,opt,name=datasheet_url,json=datasheetUrl,proto3" json:"datasheet_url,omitempty"`
	// Reseller URLs.
	Resellers []*EndDeviceModel_Reseller `protobuf:"bytes,19,rep,name=resellers,proto3" json:"resellers,omitempty"`
	// List of standards the device is compliant with.
	Compliances *EndDeviceModel_Compliances `protobuf:"bytes,20,opt,name=compliances,proto3" json:"compliances,omitempty"`
	// List of any additional radios included in the device.
	AdditionalRadios []string `protobuf:"bytes,21,rep,name=additional_radios,json=additionalRadios,proto3" json:"additional_radios,omitempty"`
}

func (x *EndDeviceModel) Reset() {
	*x = EndDeviceModel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceModel) ProtoMessage() {}

func (x *EndDeviceModel) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceModel.ProtoReflect.Descriptor instead.
func (*EndDeviceModel) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{1}
}

func (x *EndDeviceModel) GetBrandId() string {
	if x != nil {
		return x.BrandId
	}
	return ""
}

func (x *EndDeviceModel) GetModelId() string {
	if x != nil {
		return x.ModelId
	}
	return ""
}

func (x *EndDeviceModel) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EndDeviceModel) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EndDeviceModel) GetHardwareVersions() []*EndDeviceModel_HardwareVersion {
	if x != nil {
		return x.HardwareVersions
	}
	return nil
}

func (x *EndDeviceModel) GetFirmwareVersions() []*EndDeviceModel_FirmwareVersion {
	if x != nil {
		return x.FirmwareVersions
	}
	return nil
}

func (x *EndDeviceModel) GetSensors() []string {
	if x != nil {
		return x.Sensors
	}
	return nil
}

func (x *EndDeviceModel) GetDimensions() *EndDeviceModel_Dimensions {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *EndDeviceModel) GetWeight() *wrapperspb.FloatValue {
	if x != nil {
		return x.Weight
	}
	return nil
}

func (x *EndDeviceModel) GetBattery() *EndDeviceModel_Battery {
	if x != nil {
		return x.Battery
	}
	return nil
}

func (x *EndDeviceModel) GetOperatingConditions() *EndDeviceModel_OperatingConditions {
	if x != nil {
		return x.OperatingConditions
	}
	return nil
}

func (x *EndDeviceModel) GetIpCode() string {
	if x != nil {
		return x.IpCode
	}
	return ""
}

func (x *EndDeviceModel) GetKeyProvisioning() []KeyProvisioning {
	if x != nil {
		return x.KeyProvisioning
	}
	return nil
}

func (x *EndDeviceModel) GetKeySecurity() KeySecurity {
	if x != nil {
		return x.KeySecurity
	}
	return KeySecurity_KEY_SECURITY_UNKNOWN
}

func (x *EndDeviceModel) GetPhotos() *EndDeviceModel_Photos {
	if x != nil {
		return x.Photos
	}
	return nil
}

func (x *EndDeviceModel) GetVideos() *EndDeviceModel_Videos {
	if x != nil {
		return x.Videos
	}
	return nil
}

func (x *EndDeviceModel) GetProductUrl() string {
	if x != nil {
		return x.ProductUrl
	}
	return ""
}

func (x *EndDeviceModel) GetDatasheetUrl() string {
	if x != nil {
		return x.DatasheetUrl
	}
	return ""
}

func (x *EndDeviceModel) GetResellers() []*EndDeviceModel_Reseller {
	if x != nil {
		return x.Resellers
	}
	return nil
}

func (x *EndDeviceModel) GetCompliances() *EndDeviceModel_Compliances {
	if x != nil {
		return x.Compliances
	}
	return nil
}

func (x *EndDeviceModel) GetAdditionalRadios() []string {
	if x != nil {
		return x.AdditionalRadios
	}
	return nil
}

type GetEndDeviceBrandRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Application identifiers.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/devicerepository.proto.
	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	// Brand identifier, as defined in the Device Repository.
	BrandId string `protobuf:"bytes,2,opt,name=brand_id,json=brandId,proto3" json:"brand_id,omitempty"`
	// Field mask paths.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetEndDeviceBrandRequest) Reset() {
	*x = GetEndDeviceBrandRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEndDeviceBrandRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEndDeviceBrandRequest) ProtoMessage() {}

func (x *GetEndDeviceBrandRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEndDeviceBrandRequest.ProtoReflect.Descriptor instead.
func (*GetEndDeviceBrandRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{2}
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/devicerepository.proto.
func (x *GetEndDeviceBrandRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *GetEndDeviceBrandRequest) GetBrandId() string {
	if x != nil {
		return x.BrandId
	}
	return ""
}

func (x *GetEndDeviceBrandRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type ListEndDeviceBrandsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Application identifiers.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/devicerepository.proto.
	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	// Limit the number of results per page.
	Limit uint32 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	// Page number for pagination. 0 is interpreted as 1.
	Page uint32 `protobuf:"varint,3,opt,name=page,proto3" json:"page,omitempty"`
	// Order (for pagination)
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Search for brands matching a query string.
	Search string `protobuf:"bytes,5,opt,name=search,proto3" json:"search,omitempty"`
	// Field mask paths.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,6,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *ListEndDeviceBrandsRequest) Reset() {
	*x = ListEndDeviceBrandsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEndDeviceBrandsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEndDeviceBrandsRequest) ProtoMessage() {}

func (x *ListEndDeviceBrandsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEndDeviceBrandsRequest.ProtoReflect.Descriptor instead.
func (*ListEndDeviceBrandsRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{3}
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/devicerepository.proto.
func (x *ListEndDeviceBrandsRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *ListEndDeviceBrandsRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ListEndDeviceBrandsRequest) GetPage() uint32 {
	if x != nil {
		return x.Page
	}
	return 0
}

func (x *ListEndDeviceBrandsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListEndDeviceBrandsRequest) GetSearch() string {
	if x != nil {
		return x.Search
	}
	return ""
}

func (x *ListEndDeviceBrandsRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type GetEndDeviceModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Application identifiers.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/devicerepository.proto.
	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	// Brand identifier, as defined in the Device Repository.
	BrandId string `protobuf:"bytes,2,opt,name=brand_id,json=brandId,proto3" json:"brand_id,omitempty"`
	// Model identifier, as defined in the Device Repository.
	ModelId string `protobuf:"bytes,3,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
	// Field mask paths.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetEndDeviceModelRequest) Reset() {
	*x = GetEndDeviceModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEndDeviceModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEndDeviceModelRequest) ProtoMessage() {}

func (x *GetEndDeviceModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEndDeviceModelRequest.ProtoReflect.Descriptor instead.
func (*GetEndDeviceModelRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{4}
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/devicerepository.proto.
func (x *GetEndDeviceModelRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *GetEndDeviceModelRequest) GetBrandId() string {
	if x != nil {
		return x.BrandId
	}
	return ""
}

func (x *GetEndDeviceModelRequest) GetModelId() string {
	if x != nil {
		return x.ModelId
	}
	return ""
}

func (x *GetEndDeviceModelRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type ListEndDeviceModelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Application identifiers.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/devicerepository.proto.
	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	// List end devices from a specific brand.
	BrandId string `protobuf:"bytes,2,opt,name=brand_id,json=brandId,proto3" json:"brand_id,omitempty"`
	// Limit the number of results per page.
	Limit uint32 `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
	// Page number for pagination. 0 is interpreted as 1.
	Page uint32 `protobuf:"varint,4,opt,name=page,proto3" json:"page,omitempty"`
	// Order end devices
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// List end devices matching a query string.
	Search string `protobuf:"bytes,6,opt,name=search,proto3" json:"search,omitempty"`
	// Field mask paths.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,7,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *ListEndDeviceModelsRequest) Reset() {
	*x = ListEndDeviceModelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEndDeviceModelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEndDeviceModelsRequest) ProtoMessage() {}

func (x *ListEndDeviceModelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEndDeviceModelsRequest.ProtoReflect.Descriptor instead.
func (*ListEndDeviceModelsRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{5}
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/devicerepository.proto.
func (x *ListEndDeviceModelsRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *ListEndDeviceModelsRequest) GetBrandId() string {
	if x != nil {
		return x.BrandId
	}
	return ""
}

func (x *ListEndDeviceModelsRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ListEndDeviceModelsRequest) GetPage() uint32 {
	if x != nil {
		return x.Page
	}
	return 0
}

func (x *ListEndDeviceModelsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListEndDeviceModelsRequest) GetSearch() string {
	if x != nil {
		return x.Search
	}
	return ""
}

func (x *ListEndDeviceModelsRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type GetTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Application identifiers.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/devicerepository.proto.
	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	// End device version information.
	// Use either EndDeviceVersionIdentifiers or EndDeviceProfileIdentifiers.
	VersionIds *EndDeviceVersionIdentifiers `protobuf:"bytes,2,opt,name=version_ids,json=versionIds,proto3" json:"version_ids,omitempty"`
	// End device profile identifiers.
	EndDeviceProfileIds *GetTemplateRequest_EndDeviceProfileIdentifiers `protobuf:"bytes,3,opt,name=end_device_profile_ids,json=endDeviceProfileIds,proto3" json:"end_device_profile_ids,omitempty"`
}

func (x *GetTemplateRequest) Reset() {
	*x = GetTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTemplateRequest) ProtoMessage() {}

func (x *GetTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTemplateRequest.ProtoReflect.Descriptor instead.
func (*GetTemplateRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{6}
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/devicerepository.proto.
func (x *GetTemplateRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *GetTemplateRequest) GetVersionIds() *EndDeviceVersionIdentifiers {
	if x != nil {
		return x.VersionIds
	}
	return nil
}

func (x *GetTemplateRequest) GetEndDeviceProfileIds() *GetTemplateRequest_EndDeviceProfileIdentifiers {
	if x != nil {
		return x.EndDeviceProfileIds
	}
	return nil
}

type GetPayloadFormatterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Application identifiers.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/devicerepository.proto.
	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	// End device version information.
	VersionIds *EndDeviceVersionIdentifiers `protobuf:"bytes,2,opt,name=version_ids,json=versionIds,proto3" json:"version_ids,omitempty"`
	// Field mask paths.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetPayloadFormatterRequest) Reset() {
	*x = GetPayloadFormatterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPayloadFormatterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPayloadFormatterRequest) ProtoMessage() {}

func (x *GetPayloadFormatterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPayloadFormatterRequest.ProtoReflect.Descriptor instead.
func (*GetPayloadFormatterRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{7}
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/devicerepository.proto.
func (x *GetPayloadFormatterRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *GetPayloadFormatterRequest) GetVersionIds() *EndDeviceVersionIdentifiers {
	if x != nil {
		return x.VersionIds
	}
	return nil
}

func (x *GetPayloadFormatterRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type ListEndDeviceBrandsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Brands []*EndDeviceBrand `protobuf:"bytes,1,rep,name=brands,proto3" json:"brands,omitempty"`
}

func (x *ListEndDeviceBrandsResponse) Reset() {
	*x = ListEndDeviceBrandsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEndDeviceBrandsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEndDeviceBrandsResponse) ProtoMessage() {}

func (x *ListEndDeviceBrandsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEndDeviceBrandsResponse.ProtoReflect.Descriptor instead.
func (*ListEndDeviceBrandsResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{8}
}

func (x *ListEndDeviceBrandsResponse) GetBrands() []*EndDeviceBrand {
	if x != nil {
		return x.Brands
	}
	return nil
}

type ListEndDeviceModelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Models []*EndDeviceModel `protobuf:"bytes,1,rep,name=models,proto3" json:"models,omitempty"`
}

func (x *ListEndDeviceModelsResponse) Reset() {
	*x = ListEndDeviceModelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEndDeviceModelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEndDeviceModelsResponse) ProtoMessage() {}

func (x *ListEndDeviceModelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEndDeviceModelsResponse.ProtoReflect.Descriptor instead.
func (*ListEndDeviceModelsResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{9}
}

func (x *ListEndDeviceModelsResponse) GetModels() []*EndDeviceModel {
	if x != nil {
		return x.Models
	}
	return nil
}

type EncodedMessagePayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FPort      uint32   `protobuf:"varint,1,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	FrmPayload []byte   `protobuf:"bytes,2,opt,name=frm_payload,json=frmPayload,proto3" json:"frm_payload,omitempty"`
	Warnings   []string `protobuf:"bytes,3,rep,name=warnings,proto3" json:"warnings,omitempty"`
	Errors     []string `protobuf:"bytes,4,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *EncodedMessagePayload) Reset() {
	*x = EncodedMessagePayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EncodedMessagePayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncodedMessagePayload) ProtoMessage() {}

func (x *EncodedMessagePayload) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncodedMessagePayload.ProtoReflect.Descriptor instead.
func (*EncodedMessagePayload) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{10}
}

func (x *EncodedMessagePayload) GetFPort() uint32 {
	if x != nil {
		return x.FPort
	}
	return 0
}

func (x *EncodedMessagePayload) GetFrmPayload() []byte {
	if x != nil {
		return x.FrmPayload
	}
	return nil
}

func (x *EncodedMessagePayload) GetWarnings() []string {
	if x != nil {
		return x.Warnings
	}
	return nil
}

func (x *EncodedMessagePayload) GetErrors() []string {
	if x != nil {
		return x.Errors
	}
	return nil
}

type DecodedMessagePayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Data     *structpb.Struct `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	Warnings []string         `protobuf:"bytes,2,rep,name=warnings,proto3" json:"warnings,omitempty"`
	Errors   []string         `protobuf:"bytes,3,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *DecodedMessagePayload) Reset() {
	*x = DecodedMessagePayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DecodedMessagePayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DecodedMessagePayload) ProtoMessage() {}

func (x *DecodedMessagePayload) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DecodedMessagePayload.ProtoReflect.Descriptor instead.
func (*DecodedMessagePayload) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{11}
}

func (x *DecodedMessagePayload) GetData() *structpb.Struct {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *DecodedMessagePayload) GetWarnings() []string {
	if x != nil {
		return x.Warnings
	}
	return nil
}

func (x *DecodedMessagePayload) GetErrors() []string {
	if x != nil {
		return x.Errors
	}
	return nil
}

type MessagePayloadDecoder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Payload formatter type.
	Formatter PayloadFormatter `protobuf:"varint,1,opt,name=formatter,proto3,enum=ttn.lorawan.v3.PayloadFormatter" json:"formatter,omitempty"`
	// Parameter for the formatter, must be set together.
	FormatterParameter string                           `protobuf:"bytes,2,opt,name=formatter_parameter,json=formatterParameter,proto3" json:"formatter_parameter,omitempty"`
	CodecId            string                           `protobuf:"bytes,3,opt,name=codec_id,json=codecId,proto3" json:"codec_id,omitempty"`
	Examples           []*MessagePayloadDecoder_Example `protobuf:"bytes,4,rep,name=examples,proto3" json:"examples,omitempty"`
}

func (x *MessagePayloadDecoder) Reset() {
	*x = MessagePayloadDecoder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessagePayloadDecoder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessagePayloadDecoder) ProtoMessage() {}

func (x *MessagePayloadDecoder) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessagePayloadDecoder.ProtoReflect.Descriptor instead.
func (*MessagePayloadDecoder) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{12}
}

func (x *MessagePayloadDecoder) GetFormatter() PayloadFormatter {
	if x != nil {
		return x.Formatter
	}
	return PayloadFormatter_FORMATTER_NONE
}

func (x *MessagePayloadDecoder) GetFormatterParameter() string {
	if x != nil {
		return x.FormatterParameter
	}
	return ""
}

func (x *MessagePayloadDecoder) GetCodecId() string {
	if x != nil {
		return x.CodecId
	}
	return ""
}

func (x *MessagePayloadDecoder) GetExamples() []*MessagePayloadDecoder_Example {
	if x != nil {
		return x.Examples
	}
	return nil
}

type MessagePayloadEncoder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Payload formatter type.
	Formatter PayloadFormatter `protobuf:"varint,1,opt,name=formatter,proto3,enum=ttn.lorawan.v3.PayloadFormatter" json:"formatter,omitempty"`
	// Parameter for the formatter, must be set together.
	FormatterParameter string                           `protobuf:"bytes,2,opt,name=formatter_parameter,json=formatterParameter,proto3" json:"formatter_parameter,omitempty"`
	CodecId            string                           `protobuf:"bytes,3,opt,name=codec_id,json=codecId,proto3" json:"codec_id,omitempty"`
	Examples           []*MessagePayloadEncoder_Example `protobuf:"bytes,4,rep,name=examples,proto3" json:"examples,omitempty"`
}

func (x *MessagePayloadEncoder) Reset() {
	*x = MessagePayloadEncoder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessagePayloadEncoder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessagePayloadEncoder) ProtoMessage() {}

func (x *MessagePayloadEncoder) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessagePayloadEncoder.ProtoReflect.Descriptor instead.
func (*MessagePayloadEncoder) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{13}
}

func (x *MessagePayloadEncoder) GetFormatter() PayloadFormatter {
	if x != nil {
		return x.Formatter
	}
	return PayloadFormatter_FORMATTER_NONE
}

func (x *MessagePayloadEncoder) GetFormatterParameter() string {
	if x != nil {
		return x.FormatterParameter
	}
	return ""
}

func (x *MessagePayloadEncoder) GetCodecId() string {
	if x != nil {
		return x.CodecId
	}
	return ""
}

func (x *MessagePayloadEncoder) GetExamples() []*MessagePayloadEncoder_Example {
	if x != nil {
		return x.Examples
	}
	return nil
}

type EndDeviceModel_HardwareVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Hardware version string.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Numberic hardware revision number.
	Numeric uint32 `protobuf:"varint,2,opt,name=numeric,proto3" json:"numeric,omitempty"`
	// Hardware part number.
	PartNumber string `protobuf:"bytes,3,opt,name=part_number,json=partNumber,proto3" json:"part_number,omitempty"`
}

func (x *EndDeviceModel_HardwareVersion) Reset() {
	*x = EndDeviceModel_HardwareVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceModel_HardwareVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceModel_HardwareVersion) ProtoMessage() {}

func (x *EndDeviceModel_HardwareVersion) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceModel_HardwareVersion.ProtoReflect.Descriptor instead.
func (*EndDeviceModel_HardwareVersion) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{1, 0}
}

func (x *EndDeviceModel_HardwareVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *EndDeviceModel_HardwareVersion) GetNumeric() uint32 {
	if x != nil {
		return x.Numeric
	}
	return 0
}

func (x *EndDeviceModel_HardwareVersion) GetPartNumber() string {
	if x != nil {
		return x.PartNumber
	}
	return ""
}

type EndDeviceModel_FirmwareVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Firmware version string.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Numeric firmware revision number.
	Numeric uint32 `protobuf:"varint,2,opt,name=numeric,proto3" json:"numeric,omitempty"`
	// Hardware versions supported by this firmware version.
	SupportedHardwareVersions []string `protobuf:"bytes,3,rep,name=supported_hardware_versions,json=supportedHardwareVersions,proto3" json:"supported_hardware_versions,omitempty"`
	// Device profiles for each supported region (band).
	Profiles map[string]*EndDeviceModel_FirmwareVersion_Profile `protobuf:"bytes,4,rep,name=profiles,proto3" json:"profiles,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *EndDeviceModel_FirmwareVersion) Reset() {
	*x = EndDeviceModel_FirmwareVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceModel_FirmwareVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceModel_FirmwareVersion) ProtoMessage() {}

func (x *EndDeviceModel_FirmwareVersion) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceModel_FirmwareVersion.ProtoReflect.Descriptor instead.
func (*EndDeviceModel_FirmwareVersion) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{1, 1}
}

func (x *EndDeviceModel_FirmwareVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *EndDeviceModel_FirmwareVersion) GetNumeric() uint32 {
	if x != nil {
		return x.Numeric
	}
	return 0
}

func (x *EndDeviceModel_FirmwareVersion) GetSupportedHardwareVersions() []string {
	if x != nil {
		return x.SupportedHardwareVersions
	}
	return nil
}

func (x *EndDeviceModel_FirmwareVersion) GetProfiles() map[string]*EndDeviceModel_FirmwareVersion_Profile {
	if x != nil {
		return x.Profiles
	}
	return nil
}

type EndDeviceModel_Dimensions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device width (mm).
	Width *wrapperspb.FloatValue `protobuf:"bytes,1,opt,name=width,proto3" json:"width,omitempty"`
	// Device height (mm).
	Height *wrapperspb.FloatValue `protobuf:"bytes,2,opt,name=height,proto3" json:"height,omitempty"`
	// Device diameter (mm).
	Diameter *wrapperspb.FloatValue `protobuf:"bytes,3,opt,name=diameter,proto3" json:"diameter,omitempty"`
	// Device length (mm).
	Length *wrapperspb.FloatValue `protobuf:"bytes,4,opt,name=length,proto3" json:"length,omitempty"`
}

func (x *EndDeviceModel_Dimensions) Reset() {
	*x = EndDeviceModel_Dimensions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceModel_Dimensions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceModel_Dimensions) ProtoMessage() {}

func (x *EndDeviceModel_Dimensions) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceModel_Dimensions.ProtoReflect.Descriptor instead.
func (*EndDeviceModel_Dimensions) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{1, 2}
}

func (x *EndDeviceModel_Dimensions) GetWidth() *wrapperspb.FloatValue {
	if x != nil {
		return x.Width
	}
	return nil
}

func (x *EndDeviceModel_Dimensions) GetHeight() *wrapperspb.FloatValue {
	if x != nil {
		return x.Height
	}
	return nil
}

func (x *EndDeviceModel_Dimensions) GetDiameter() *wrapperspb.FloatValue {
	if x != nil {
		return x.Diameter
	}
	return nil
}

func (x *EndDeviceModel_Dimensions) GetLength() *wrapperspb.FloatValue {
	if x != nil {
		return x.Length
	}
	return nil
}

type EndDeviceModel_Battery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the device battery can be replaced.
	Replaceable *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=replaceable,proto3" json:"replaceable,omitempty"`
	// Battery type.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *EndDeviceModel_Battery) Reset() {
	*x = EndDeviceModel_Battery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceModel_Battery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceModel_Battery) ProtoMessage() {}

func (x *EndDeviceModel_Battery) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceModel_Battery.ProtoReflect.Descriptor instead.
func (*EndDeviceModel_Battery) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{1, 3}
}

func (x *EndDeviceModel_Battery) GetReplaceable() *wrapperspb.BoolValue {
	if x != nil {
		return x.Replaceable
	}
	return nil
}

func (x *EndDeviceModel_Battery) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

type EndDeviceModel_OperatingConditions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Temperature operating conditions (Celsius).
	Temperature *EndDeviceModel_OperatingConditions_Limits `protobuf:"bytes,1,opt,name=temperature,proto3" json:"temperature,omitempty"`
	// Relative humidity operating conditions (Fraction, in range [0, 1]).
	RelativeHumidity *EndDeviceModel_OperatingConditions_Limits `protobuf:"bytes,2,opt,name=relative_humidity,json=relativeHumidity,proto3" json:"relative_humidity,omitempty"`
}

func (x *EndDeviceModel_OperatingConditions) Reset() {
	*x = EndDeviceModel_OperatingConditions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceModel_OperatingConditions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceModel_OperatingConditions) ProtoMessage() {}

func (x *EndDeviceModel_OperatingConditions) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceModel_OperatingConditions.ProtoReflect.Descriptor instead.
func (*EndDeviceModel_OperatingConditions) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{1, 4}
}

func (x *EndDeviceModel_OperatingConditions) GetTemperature() *EndDeviceModel_OperatingConditions_Limits {
	if x != nil {
		return x.Temperature
	}
	return nil
}

func (x *EndDeviceModel_OperatingConditions) GetRelativeHumidity() *EndDeviceModel_OperatingConditions_Limits {
	if x != nil {
		return x.RelativeHumidity
	}
	return nil
}

type EndDeviceModel_Photos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Main device photo.
	Main string `protobuf:"bytes,1,opt,name=main,proto3" json:"main,omitempty"`
	// List of other device photos.
	Other []string `protobuf:"bytes,2,rep,name=other,proto3" json:"other,omitempty"`
}

func (x *EndDeviceModel_Photos) Reset() {
	*x = EndDeviceModel_Photos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceModel_Photos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceModel_Photos) ProtoMessage() {}

func (x *EndDeviceModel_Photos) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceModel_Photos.ProtoReflect.Descriptor instead.
func (*EndDeviceModel_Photos) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{1, 5}
}

func (x *EndDeviceModel_Photos) GetMain() string {
	if x != nil {
		return x.Main
	}
	return ""
}

func (x *EndDeviceModel_Photos) GetOther() []string {
	if x != nil {
		return x.Other
	}
	return nil
}

type EndDeviceModel_Videos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Link to main device video.
	Main string `protobuf:"bytes,1,opt,name=main,proto3" json:"main,omitempty"`
	// Links to other device videos.
	Other []string `protobuf:"bytes,2,rep,name=other,proto3" json:"other,omitempty"`
}

func (x *EndDeviceModel_Videos) Reset() {
	*x = EndDeviceModel_Videos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceModel_Videos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceModel_Videos) ProtoMessage() {}

func (x *EndDeviceModel_Videos) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceModel_Videos.ProtoReflect.Descriptor instead.
func (*EndDeviceModel_Videos) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{1, 6}
}

func (x *EndDeviceModel_Videos) GetMain() string {
	if x != nil {
		return x.Main
	}
	return ""
}

func (x *EndDeviceModel_Videos) GetOther() []string {
	if x != nil {
		return x.Other
	}
	return nil
}

type EndDeviceModel_Reseller struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reseller name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Reseller regions.
	Region []string `protobuf:"bytes,2,rep,name=region,proto3" json:"region,omitempty"`
	// Reseller URL.
	Url string `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *EndDeviceModel_Reseller) Reset() {
	*x = EndDeviceModel_Reseller{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceModel_Reseller) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceModel_Reseller) ProtoMessage() {}

func (x *EndDeviceModel_Reseller) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceModel_Reseller.ProtoReflect.Descriptor instead.
func (*EndDeviceModel_Reseller) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{1, 7}
}

func (x *EndDeviceModel_Reseller) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EndDeviceModel_Reseller) GetRegion() []string {
	if x != nil {
		return x.Region
	}
	return nil
}

func (x *EndDeviceModel_Reseller) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

type EndDeviceModel_Compliances struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of safety standards the device is compliant with.
	Safety []*EndDeviceModel_Compliances_Compliance `protobuf:"bytes,1,rep,name=safety,proto3" json:"safety,omitempty"`
	// List of radio equipment standards the device is compliant with.
	RadioEquipment []*EndDeviceModel_Compliances_Compliance `protobuf:"bytes,2,rep,name=radio_equipment,json=radioEquipment,proto3" json:"radio_equipment,omitempty"`
}

func (x *EndDeviceModel_Compliances) Reset() {
	*x = EndDeviceModel_Compliances{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceModel_Compliances) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceModel_Compliances) ProtoMessage() {}

func (x *EndDeviceModel_Compliances) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceModel_Compliances.ProtoReflect.Descriptor instead.
func (*EndDeviceModel_Compliances) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{1, 8}
}

func (x *EndDeviceModel_Compliances) GetSafety() []*EndDeviceModel_Compliances_Compliance {
	if x != nil {
		return x.Safety
	}
	return nil
}

func (x *EndDeviceModel_Compliances) GetRadioEquipment() []*EndDeviceModel_Compliances_Compliance {
	if x != nil {
		return x.RadioEquipment
	}
	return nil
}

type EndDeviceModel_FirmwareVersion_Profile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Vendor ID of the profile, as defined in the Device Repository.
	// If this value is set, the profile is loaded from this vendor's folder.
	// If this value is not set, the profile is loaded from the current (end device's) vendor.
	VendorId string `protobuf:"bytes,4,opt,name=vendor_id,json=vendorId,proto3" json:"vendor_id,omitempty"`
	// Profile identifier, as defined in the Device Repository.
	ProfileId string `protobuf:"bytes,1,opt,name=profile_id,json=profileId,proto3" json:"profile_id,omitempty"`
	// Whether the device is LoRaWAN certified.
	LorawanCertified bool `protobuf:"varint,2,opt,name=lorawan_certified,json=lorawanCertified,proto3" json:"lorawan_certified,omitempty"`
	// Payload formatter codec identifier, as defined in the Device Repository.
	CodecId string `protobuf:"bytes,3,opt,name=codec_id,json=codecId,proto3" json:"codec_id,omitempty"`
}

func (x *EndDeviceModel_FirmwareVersion_Profile) Reset() {
	*x = EndDeviceModel_FirmwareVersion_Profile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceModel_FirmwareVersion_Profile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceModel_FirmwareVersion_Profile) ProtoMessage() {}

func (x *EndDeviceModel_FirmwareVersion_Profile) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceModel_FirmwareVersion_Profile.ProtoReflect.Descriptor instead.
func (*EndDeviceModel_FirmwareVersion_Profile) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{1, 1, 0}
}

func (x *EndDeviceModel_FirmwareVersion_Profile) GetVendorId() string {
	if x != nil {
		return x.VendorId
	}
	return ""
}

func (x *EndDeviceModel_FirmwareVersion_Profile) GetProfileId() string {
	if x != nil {
		return x.ProfileId
	}
	return ""
}

func (x *EndDeviceModel_FirmwareVersion_Profile) GetLorawanCertified() bool {
	if x != nil {
		return x.LorawanCertified
	}
	return false
}

func (x *EndDeviceModel_FirmwareVersion_Profile) GetCodecId() string {
	if x != nil {
		return x.CodecId
	}
	return ""
}

type EndDeviceModel_OperatingConditions_Limits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Min value of operating conditions range.
	Min *wrapperspb.FloatValue `protobuf:"bytes,1,opt,name=min,proto3" json:"min,omitempty"`
	// Max value of operating conditions range.
	Max *wrapperspb.FloatValue `protobuf:"bytes,2,opt,name=max,proto3" json:"max,omitempty"`
}

func (x *EndDeviceModel_OperatingConditions_Limits) Reset() {
	*x = EndDeviceModel_OperatingConditions_Limits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceModel_OperatingConditions_Limits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceModel_OperatingConditions_Limits) ProtoMessage() {}

func (x *EndDeviceModel_OperatingConditions_Limits) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceModel_OperatingConditions_Limits.ProtoReflect.Descriptor instead.
func (*EndDeviceModel_OperatingConditions_Limits) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{1, 4, 0}
}

func (x *EndDeviceModel_OperatingConditions_Limits) GetMin() *wrapperspb.FloatValue {
	if x != nil {
		return x.Min
	}
	return nil
}

func (x *EndDeviceModel_OperatingConditions_Limits) GetMax() *wrapperspb.FloatValue {
	if x != nil {
		return x.Max
	}
	return nil
}

type EndDeviceModel_Compliances_Compliance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Body     string `protobuf:"bytes,1,opt,name=body,proto3" json:"body,omitempty"`
	Norm     string `protobuf:"bytes,2,opt,name=norm,proto3" json:"norm,omitempty"`
	Standard string `protobuf:"bytes,3,opt,name=standard,proto3" json:"standard,omitempty"`
	Version  string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *EndDeviceModel_Compliances_Compliance) Reset() {
	*x = EndDeviceModel_Compliances_Compliance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndDeviceModel_Compliances_Compliance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndDeviceModel_Compliances_Compliance) ProtoMessage() {}

func (x *EndDeviceModel_Compliances_Compliance) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndDeviceModel_Compliances_Compliance.ProtoReflect.Descriptor instead.
func (*EndDeviceModel_Compliances_Compliance) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{1, 8, 0}
}

func (x *EndDeviceModel_Compliances_Compliance) GetBody() string {
	if x != nil {
		return x.Body
	}
	return ""
}

func (x *EndDeviceModel_Compliances_Compliance) GetNorm() string {
	if x != nil {
		return x.Norm
	}
	return ""
}

func (x *EndDeviceModel_Compliances_Compliance) GetStandard() string {
	if x != nil {
		return x.Standard
	}
	return ""
}

func (x *EndDeviceModel_Compliances_Compliance) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Identifiers to uniquely identify a LoRaWAN end device profile.
type GetTemplateRequest_EndDeviceProfileIdentifiers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// VendorID managed by the LoRa Alliance, as defined in TR005.
	VendorId uint32 `protobuf:"varint,1,opt,name=vendor_id,json=vendorId,proto3" json:"vendor_id,omitempty"`
	// ID of the LoRaWAN end device profile assigned by the vendor.
	VendorProfileId uint32 `protobuf:"varint,2,opt,name=vendor_profile_id,json=vendorProfileId,proto3" json:"vendor_profile_id,omitempty"`
}

func (x *GetTemplateRequest_EndDeviceProfileIdentifiers) Reset() {
	*x = GetTemplateRequest_EndDeviceProfileIdentifiers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTemplateRequest_EndDeviceProfileIdentifiers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTemplateRequest_EndDeviceProfileIdentifiers) ProtoMessage() {}

func (x *GetTemplateRequest_EndDeviceProfileIdentifiers) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTemplateRequest_EndDeviceProfileIdentifiers.ProtoReflect.Descriptor instead.
func (*GetTemplateRequest_EndDeviceProfileIdentifiers) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{6, 0}
}

func (x *GetTemplateRequest_EndDeviceProfileIdentifiers) GetVendorId() uint32 {
	if x != nil {
		return x.VendorId
	}
	return 0
}

func (x *GetTemplateRequest_EndDeviceProfileIdentifiers) GetVendorProfileId() uint32 {
	if x != nil {
		return x.VendorProfileId
	}
	return 0
}

type MessagePayloadDecoder_Example struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Description string                 `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	Input       *EncodedMessagePayload `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	Output      *DecodedMessagePayload `protobuf:"bytes,3,opt,name=output,proto3" json:"output,omitempty"`
}

func (x *MessagePayloadDecoder_Example) Reset() {
	*x = MessagePayloadDecoder_Example{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessagePayloadDecoder_Example) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessagePayloadDecoder_Example) ProtoMessage() {}

func (x *MessagePayloadDecoder_Example) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessagePayloadDecoder_Example.ProtoReflect.Descriptor instead.
func (*MessagePayloadDecoder_Example) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{12, 0}
}

func (x *MessagePayloadDecoder_Example) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *MessagePayloadDecoder_Example) GetInput() *EncodedMessagePayload {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *MessagePayloadDecoder_Example) GetOutput() *DecodedMessagePayload {
	if x != nil {
		return x.Output
	}
	return nil
}

type MessagePayloadEncoder_Example struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Description string                 `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	Input       *DecodedMessagePayload `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	Output      *EncodedMessagePayload `protobuf:"bytes,3,opt,name=output,proto3" json:"output,omitempty"`
}

func (x *MessagePayloadEncoder_Example) Reset() {
	*x = MessagePayloadEncoder_Example{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessagePayloadEncoder_Example) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessagePayloadEncoder_Example) ProtoMessage() {}

func (x *MessagePayloadEncoder_Example) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_devicerepository_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessagePayloadEncoder_Example.ProtoReflect.Descriptor instead.
func (*MessagePayloadEncoder_Example) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP(), []int{13, 0}
}

func (x *MessagePayloadEncoder_Example) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *MessagePayloadEncoder_Example) GetInput() *DecodedMessagePayload {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *MessagePayloadEncoder_Example) GetOutput() *EncodedMessagePayload {
	if x != nil {
		return x.Output
	}
	return nil
}

var File_ttn_lorawan_v3_devicerepository_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_devicerepository_proto_rawDesc = []byte{
	0x0a, 0x25, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65,
	0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x2f, 0x6a, 0x73, 0x6f, 0x6e, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x74, 0x74, 0x6e, 0x2f,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xd2, 0x03, 0x0a, 0x0e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x42, 0x72, 0x61, 0x6e, 0x64, 0x12, 0x42, 0x0a, 0x08, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x42, 0x24, 0x72, 0x22, 0x18, 0x24,
	0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d,
	0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24,
	0x52, 0x07, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a,
	0x19, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x17, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x5f, 0x0a, 0x1f, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65,
	0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x17, 0xfa, 0x42, 0x14, 0x92, 0x01, 0x11, 0x22, 0x0f, 0x72, 0x0d, 0x32, 0x0b,
	0x5b, 0x30, 0x2d, 0x39, 0x41, 0x2d, 0x46, 0x5d, 0x7b, 0x36, 0x7d, 0x52, 0x1d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x35, 0x0a, 0x17, 0x6c, 0x6f,
	0x72, 0x61, 0x5f, 0x61, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x76, 0x65, 0x6e, 0x64,
	0x6f, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x14, 0x6c, 0x6f, 0x72,
	0x61, 0x41, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x49,
	0x64, 0x12, 0x25, 0x0a, 0x07, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72, 0x06, 0xd0, 0x01, 0x01, 0x88, 0x01, 0x01, 0x52,
	0x07, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69,
	0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0xfa, 0x42, 0x07, 0x72, 0x05, 0xd0, 0x01,
	0x01, 0x60, 0x01, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x4b, 0x0a, 0x04, 0x6c, 0x6f,
	0x67, 0x6f, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xfa, 0x42, 0x34, 0x72, 0x32, 0x32,
	0x30, 0x5e, 0x24, 0x7c, 0x5e, 0x28, 0x28, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x2d, 0x5d,
	0x2b, 0x5c, 0x2f, 0x29, 0x2b, 0x29, 0x3f, 0x28, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5f,
	0x2d, 0x5d, 0x2b, 0x5c, 0x2e, 0x29, 0x2b, 0x28, 0x70, 0x6e, 0x67, 0x7c, 0x73, 0x76, 0x67, 0x29,
	0x24, 0x52, 0x04, 0x6c, 0x6f, 0x67, 0x6f, 0x22, 0xcb, 0x1d, 0x0a, 0x0e, 0x45, 0x6e, 0x64, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x42, 0x0a, 0x08, 0x62, 0x72,
	0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x42,
	0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d,
	0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29,
	0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x07, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x49, 0x64, 0x12, 0x42,
	0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x27, 0xfa, 0x42, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a,
	0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30,
	0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x11, 0x68, 0x61, 0x72, 0x64,
	0x77, 0x61, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x48, 0x61, 0x72, 0x64, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x10, 0x68, 0x61, 0x72, 0x64, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5b, 0x0a, 0x11, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x10, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x22, 0x0a, 0x07, 0x73, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x18, 0x01, 0x52, 0x07, 0x73,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x73, 0x12, 0x49, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x33, 0x0a, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x40, 0x0a, 0x07, 0x62, 0x61, 0x74, 0x74, 0x65, 0x72,
	0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x42, 0x61, 0x74, 0x74, 0x65, 0x72, 0x79, 0x52,
	0x07, 0x62, 0x61, 0x74, 0x74, 0x65, 0x72, 0x79, 0x12, 0x65, 0x0a, 0x14, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x13, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x17, 0x0a, 0x07, 0x69, 0x70, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x69, 0x70, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x5b, 0x0a, 0x10, 0x6b, 0x65, 0x79, 0x5f,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x0d, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4b, 0x65, 0x79, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x42, 0x0f, 0xfa, 0x42, 0x0c, 0x92, 0x01, 0x09, 0x18, 0x01, 0x22, 0x05, 0x82,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x0f, 0x6b, 0x65, 0x79, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x48, 0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4b, 0x65, 0x79,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x0b, 0x6b, 0x65, 0x79, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x12,
	0x3d, 0x0a, 0x06, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x52, 0x06, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x12, 0x3d,
	0x0a, 0x06, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x73, 0x52, 0x06, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x12, 0x2c, 0x0a,
	0x0b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72, 0x06, 0xd0, 0x01, 0x01, 0x88, 0x01, 0x01, 0x52,
	0x0a, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x55, 0x72, 0x6c, 0x12, 0x30, 0x0a, 0x0d, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x68, 0x65, 0x65, 0x74, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72, 0x06, 0xd0, 0x01, 0x01, 0x88, 0x01, 0x01, 0x52,
	0x0c, 0x64, 0x61, 0x74, 0x61, 0x73, 0x68, 0x65, 0x65, 0x74, 0x55, 0x72, 0x6c, 0x12, 0x45, 0x0a,
	0x09, 0x72, 0x65, 0x73, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x73, 0x18, 0x13, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x52, 0x65, 0x73, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x52, 0x09, 0x72, 0x65, 0x73, 0x65, 0x6c,
	0x6c, 0x65, 0x72, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x12, 0x35, 0x0a, 0x11, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x5f, 0x72, 0x61, 0x64, 0x69, 0x6f, 0x73, 0x18, 0x15, 0x20, 0x03, 0x28, 0x09, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x92, 0x01, 0x02, 0x18, 0x01, 0x52, 0x10, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x52, 0x61, 0x64, 0x69, 0x6f, 0x73, 0x1a, 0x66, 0x0a, 0x0f, 0x48, 0x61, 0x72,
	0x64, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69,
	0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63,
	0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x1a, 0xf2, 0x04, 0x0a, 0x0f, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x18, 0x0a, 0x07, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x07, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x12, 0x48, 0x0a, 0x1b, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x68, 0x61, 0x72, 0x64, 0x77, 0x61, 0x72, 0x65, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x18, 0x01, 0x52, 0x19, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x48, 0x61, 0x72, 0x64, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x58, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x1a, 0x91, 0x02,
	0x0a, 0x07, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x47, 0x0a, 0x09, 0x76, 0x65, 0x6e,
	0x64, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x42,
	0x27, 0x72, 0x25, 0x18, 0x24, 0x32, 0x21, 0x5e, 0x24, 0x7c, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30,
	0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d,
	0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x08, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72,
	0x49, 0x64, 0x12, 0x49, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x42, 0x27, 0x72, 0x25, 0x18, 0x24, 0x32,
	0x21, 0x5e, 0x24, 0x7c, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a,
	0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c,
	0x7d, 0x24, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x2b, 0x0a,
	0x11, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x12, 0x45, 0x0a, 0x08, 0x63, 0x6f,
	0x64, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x42,
	0x27, 0x72, 0x25, 0x18, 0x24, 0x32, 0x21, 0x5e, 0x24, 0x7c, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30,
	0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d,
	0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x07, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x49,
	0x64, 0x1a, 0x73, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x4c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0xe2, 0x01, 0x0a, 0x0a, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x31, 0x0a, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x33, 0x0a, 0x06, 0x68, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x37, 0x0a,
	0x08, 0x64, 0x69, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x64, 0x69,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x33, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x1a, 0x5b, 0x0a, 0x07, 0x42,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x79, 0x12, 0x3c, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f,
	0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0xc2, 0x02, 0x0a, 0x13, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x5b, 0x0a, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73,
	0x52, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x66, 0x0a,
	0x11, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x68, 0x75, 0x6d, 0x69, 0x64, 0x69,
	0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x73, 0x52, 0x10, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x48, 0x75, 0x6d,
	0x69, 0x64, 0x69, 0x74, 0x79, 0x1a, 0x66, 0x0a, 0x06, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12,
	0x2d, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x6d, 0x69, 0x6e, 0x12, 0x2d,
	0x0a, 0x03, 0x6d, 0x61, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c,
	0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x6d, 0x61, 0x78, 0x1a, 0xb5, 0x01,
	0x0a, 0x06, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x12, 0x50, 0x0a, 0x04, 0x6d, 0x61, 0x69, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3c, 0xfa, 0x42, 0x39, 0x72, 0x37, 0x32, 0x35, 0x5e,
	0x24, 0x7c, 0x5e, 0x28, 0x28, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x2d, 0x5d, 0x2b, 0x5c,
	0x2f, 0x29, 0x2b, 0x29, 0x3f, 0x28, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5f, 0x2d, 0x5d,
	0x2b, 0x5c, 0x2e, 0x29, 0x2b, 0x28, 0x70, 0x6e, 0x67, 0x7c, 0x6a, 0x70, 0x67, 0x7c, 0x6a, 0x70,
	0x65, 0x67, 0x29, 0x24, 0x52, 0x04, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x59, 0x0a, 0x05, 0x6f, 0x74,
	0x68, 0x65, 0x72, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x43, 0xfa, 0x42, 0x40, 0x92, 0x01,
	0x3d, 0x18, 0x01, 0x22, 0x39, 0x72, 0x37, 0x32, 0x35, 0x5e, 0x24, 0x7c, 0x5e, 0x28, 0x28, 0x5b,
	0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x2d, 0x5d, 0x2b, 0x5c, 0x2f, 0x29, 0x2b, 0x29, 0x3f, 0x28,
	0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5f, 0x2d, 0x5d, 0x2b, 0x5c, 0x2e, 0x29, 0x2b, 0x28,
	0x70, 0x6e, 0x67, 0x7c, 0x6a, 0x70, 0x67, 0x7c, 0x6a, 0x70, 0x65, 0x67, 0x29, 0x24, 0x52, 0x05,
	0x6f, 0x74, 0x68, 0x65, 0x72, 0x1a, 0xeb, 0x03, 0x0a, 0x06, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x73,
	0x12, 0xe9, 0x01, 0x0a, 0x04, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0xd4, 0x01, 0xfa, 0x42, 0xd0, 0x01, 0x72, 0xcd, 0x01, 0x32, 0xca, 0x01, 0x5e, 0x28, 0x3f, 0x3a,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3f, 0x3a, 0x5c, 0x2f, 0x5c, 0x2f, 0x28, 0x3f, 0x3a, 0x77, 0x77,
	0x77, 0x5c, 0x2e, 0x29, 0x3f, 0x79, 0x6f, 0x75, 0x74, 0x75, 0x28, 0x3f, 0x3a, 0x62, 0x65, 0x5c,
	0x2e, 0x63, 0x6f, 0x6d, 0x5c, 0x2f, 0x77, 0x61, 0x74, 0x63, 0x68, 0x5c, 0x3f, 0x76, 0x3d, 0x7c,
	0x5c, 0x2e, 0x62, 0x65, 0x5c, 0x2f, 0x29, 0x28, 0x3f, 0x3a, 0x5b, 0x5c, 0x77, 0x5c, 0x2d, 0x5f,
	0x5d, 0x2a, 0x29, 0x28, 0x3f, 0x3a, 0x26, 0x28, 0x61, 0x6d, 0x70, 0x3b, 0x29, 0x3f, 0x5b, 0x5c,
	0x77, 0x5c, 0x3f, 0x3d, 0x5d, 0x2a, 0x29, 0x3f, 0x29, 0x24, 0x7c, 0x5e, 0x28, 0x3f, 0x3a, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3f, 0x3a, 0x5c, 0x2f, 0x5c, 0x2f, 0x28, 0x3f, 0x3a, 0x77, 0x77, 0x77,
	0x5c, 0x2e, 0x29, 0x3f, 0x76, 0x69, 0x6d, 0x65, 0x6f, 0x5c, 0x2e, 0x63, 0x6f, 0x6d, 0x5c, 0x2f,
	0x28, 0x3f, 0x3a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x5c, 0x2f, 0x28, 0x3f, 0x3a,
	0x5c, 0x77, 0x2b, 0x5c, 0x2f, 0x29, 0x3f, 0x7c, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x5c, 0x2f,
	0x28, 0x5b, 0x5e, 0x5c, 0x2f, 0x5d, 0x2a, 0x29, 0x5c, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73,
	0x5c, 0x2f, 0x7c, 0x29, 0x28, 0x3f, 0x3a, 0x5c, 0x64, 0x2b, 0x29, 0x28, 0x3f, 0x3a, 0x7c, 0x5c,
	0x2f, 0x5c, 0x3f, 0x29, 0x29, 0x24, 0x52, 0x04, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0xf4, 0x01, 0x0a,
	0x05, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0xdd, 0x01, 0xfa,
	0x42, 0xd9, 0x01, 0x92, 0x01, 0xd5, 0x01, 0x18, 0x01, 0x22, 0xd0, 0x01, 0x72, 0xcd, 0x01, 0x32,
	0xca, 0x01, 0x5e, 0x28, 0x3f, 0x3a, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3f, 0x3a, 0x5c, 0x2f, 0x5c,
	0x2f, 0x28, 0x3f, 0x3a, 0x77, 0x77, 0x77, 0x5c, 0x2e, 0x29, 0x3f, 0x79, 0x6f, 0x75, 0x74, 0x75,
	0x28, 0x3f, 0x3a, 0x62, 0x65, 0x5c, 0x2e, 0x63, 0x6f, 0x6d, 0x5c, 0x2f, 0x77, 0x61, 0x74, 0x63,
	0x68, 0x5c, 0x3f, 0x76, 0x3d, 0x7c, 0x5c, 0x2e, 0x62, 0x65, 0x5c, 0x2f, 0x29, 0x28, 0x3f, 0x3a,
	0x5b, 0x5c, 0x77, 0x5c, 0x2d, 0x5f, 0x5d, 0x2a, 0x29, 0x28, 0x3f, 0x3a, 0x26, 0x28, 0x61, 0x6d,
	0x70, 0x3b, 0x29, 0x3f, 0x5b, 0x5c, 0x77, 0x5c, 0x3f, 0x3d, 0x5d, 0x2a, 0x29, 0x3f, 0x29, 0x24,
	0x7c, 0x5e, 0x28, 0x3f, 0x3a, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3f, 0x3a, 0x5c, 0x2f, 0x5c, 0x2f,
	0x28, 0x3f, 0x3a, 0x77, 0x77, 0x77, 0x5c, 0x2e, 0x29, 0x3f, 0x76, 0x69, 0x6d, 0x65, 0x6f, 0x5c,
	0x2e, 0x63, 0x6f, 0x6d, 0x5c, 0x2f, 0x28, 0x3f, 0x3a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x73, 0x5c, 0x2f, 0x28, 0x3f, 0x3a, 0x5c, 0x77, 0x2b, 0x5c, 0x2f, 0x29, 0x3f, 0x7c, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x5c, 0x2f, 0x28, 0x5b, 0x5e, 0x5c, 0x2f, 0x5d, 0x2a, 0x29, 0x5c, 0x2f,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x5c, 0x2f, 0x7c, 0x29, 0x28, 0x3f, 0x3a, 0x5c, 0x64, 0x2b,
	0x29, 0x28, 0x3f, 0x3a, 0x7c, 0x5c, 0x2f, 0x5c, 0x3f, 0x29, 0x29, 0x24, 0x52, 0x05, 0x6f, 0x74,
	0x68, 0x65, 0x72, 0x1a, 0x55, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x03, 0x75,
	0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72, 0x06, 0xd0,
	0x01, 0x01, 0x88, 0x01, 0x01, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x1a, 0xa8, 0x02, 0x0a, 0x0b, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x06, 0x73, 0x61,
	0x66, 0x65, 0x74, 0x79, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c,
	0x69, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x06, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x12, 0x5e, 0x0a, 0x0f, 0x72, 0x61, 0x64,
	0x69, 0x6f, 0x5f, 0x65, 0x71, 0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x0e, 0x72, 0x61, 0x64, 0x69, 0x6f,
	0x45, 0x71, 0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x6a, 0x0a, 0x0a, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x6f, 0x72, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x6f, 0x72, 0x6d, 0x12,
	0x1a, 0x0a, 0x08, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xee, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x64,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x53, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x42, 0x0a, 0x08, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x42, 0x24, 0x72, 0x22,
	0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a,
	0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c,
	0x7d, 0x24, 0x52, 0x07, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xc7, 0x02, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x1e, 0x0a, 0x05, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03,
	0x18, 0xe8, 0x07, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61,
	0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x61, 0x67, 0x65, 0x12, 0x44,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xfa, 0x42, 0x26, 0x72, 0x24, 0x52, 0x00, 0x52, 0x08, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x5f, 0x69, 0x64, 0x52, 0x09, 0x2d, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x52, 0x05, 0x2d, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x07, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x12, 0x1f, 0x0a, 0x06, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x06, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0xb2, 0x02, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a,
	0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x73, 0x12, 0x42, 0x0a, 0x08, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x42, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e, 0x5e,
	0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b,
	0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x07, 0x62,
	0x72, 0x61, 0x6e, 0x64, 0x49, 0x64, 0x12, 0x42, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x42, 0x24, 0x72, 0x22, 0x18,
	0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b,
	0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d,
	0x24, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa4, 0x03, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x46, 0x0a, 0x08, 0x62, 0x72, 0x61,
	0x6e, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xfa, 0x42, 0x28,
	0x72, 0x26, 0x18, 0x24, 0x32, 0x22, 0x5e, 0x28, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d,
	0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29,
	0x7b, 0x32, 0x2c, 0x7d, 0x7c, 0x29, 0x3f, 0x24, 0x52, 0x07, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x49,
	0x64, 0x12, 0x1e, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xe8, 0x07, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x04, 0x70, 0x61, 0x67, 0x65, 0x12, 0x59, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3e, 0xfa, 0x42, 0x3b, 0x72, 0x39, 0x52, 0x00,
	0x52, 0x08, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x52, 0x09, 0x2d, 0x62, 0x72, 0x61,
	0x6e, 0x64, 0x5f, 0x69, 0x64, 0x52, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x52,
	0x09, 0x2d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x52, 0x05, 0x2d, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x12, 0x1f, 0x0a, 0x06, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x06, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x9d, 0x03, 0x0a,
	0x12, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45,
	0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x73, 0x0a, 0x16, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x13, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x73, 0x1a, 0x6f, 0x0a, 0x1b, 0x45,
	0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x24, 0x0a, 0x09, 0x76, 0x65,
	0x6e, 0x64, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa,
	0x42, 0x04, 0x2a, 0x02, 0x28, 0x01, 0x52, 0x08, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x49, 0x64,
	0x12, 0x2a, 0x0a, 0x11, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x76, 0x65, 0x6e,
	0x64, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x22, 0xfa, 0x01, 0x0a,
	0x1a, 0x47, 0x65, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x0f, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73,
	0x12, 0x4c, 0x0a, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x73, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x39,
	0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x55, 0x0a, 0x1b, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x36, 0x0a, 0x06, 0x62, 0x72, 0x61, 0x6e,
	0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x52, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73,
	0x22, 0x55, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x36, 0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x22, 0xad, 0x01, 0x0a, 0x15, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x12, 0x1f, 0x0a, 0x06, 0x66, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xff, 0x01, 0x52, 0x05, 0x66, 0x50, 0x6f,
	0x72, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x72, 0x6d, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x66, 0x72, 0x6d, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x12, 0x2a, 0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0e, 0xfa, 0x42, 0x0b, 0x92, 0x01, 0x08, 0x10, 0x0a, 0x22,
	0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x26, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x0e, 0xfa, 0x42, 0x0b, 0x92, 0x01, 0x08, 0x10, 0x0a, 0x22, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52,
	0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x98, 0x01, 0x0a, 0x15, 0x44, 0x65, 0x63, 0x6f,
	0x64, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x12, 0x2b, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2a,
	0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x0e, 0xfa, 0x42, 0x0b, 0x92, 0x01, 0x08, 0x10, 0x0a, 0x22, 0x04, 0x72, 0x02, 0x18, 0x64,
	0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x06, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0e, 0xfa, 0x42, 0x0b, 0x92,
	0x01, 0x08, 0x10, 0x0a, 0x22, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x73, 0x22, 0xe3, 0x03, 0x0a, 0x15, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x12, 0x48, 0x0a, 0x09,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x20, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65,
	0x72, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x09, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x12, 0x2f, 0x0a, 0x13, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x74, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x12, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x46, 0x0a, 0x08, 0x63, 0x6f, 0x64, 0x65, 0x63,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xfa, 0x42, 0x28, 0x72, 0x26,
	0x18, 0x24, 0x32, 0x22, 0x5e, 0x28, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f,
	0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32,
	0x2c, 0x7d, 0x7c, 0x29, 0x3f, 0x24, 0x52, 0x07, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x49, 0x64, 0x12,
	0x53, 0x0a, 0x08, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x14, 0x52, 0x08, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x73, 0x1a, 0xb1, 0x01, 0x0a, 0x07, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x12, 0x2a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x18, 0xc8, 0x01, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x05,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x63,
	0x6f, 0x64, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x63, 0x6f, 0x64,
	0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x22, 0xe3, 0x03, 0x0a, 0x15, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x45, 0x6e, 0x63, 0x6f, 0x64,
	0x65, 0x72, 0x12, 0x48, 0x0a, 0x09, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x09, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x12, 0x2f, 0x0a, 0x13,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x74, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x46, 0x0a,
	0x08, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2b, 0xfa, 0x42, 0x28, 0x72, 0x26, 0x18, 0x24, 0x32, 0x22, 0x5e, 0x28, 0x5b, 0x61, 0x2d, 0x7a,
	0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30,
	0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x7c, 0x29, 0x3f, 0x24, 0x52, 0x07, 0x63, 0x6f,
	0x64, 0x65, 0x63, 0x49, 0x64, 0x12, 0x53, 0x0a, 0x08, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x45,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x14,
	0x52, 0x08, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x1a, 0xb1, 0x01, 0x0a, 0x07, 0x45,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x2a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05,
	0x72, 0x03, 0x18, 0xc8, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12,
	0x3d, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2a, 0xe7,
	0x01, 0x0a, 0x0f, 0x4b, 0x65, 0x79, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x12, 0x2b, 0x0a, 0x18, 0x4b, 0x45, 0x59, 0x5f, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53,
	0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00,
	0x1a, 0x0d, 0xea, 0xaa, 0x19, 0x09, 0x0a, 0x07, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x12,
	0x29, 0x0a, 0x17, 0x4b, 0x45, 0x59, 0x5f, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e,
	0x49, 0x4e, 0x47, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x01, 0x1a, 0x0c, 0xea, 0xaa,
	0x19, 0x08, 0x0a, 0x06, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x12, 0x33, 0x0a, 0x1c, 0x4b, 0x45,
	0x59, 0x5f, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x4a,
	0x4f, 0x49, 0x4e, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x02, 0x1a, 0x11, 0xea, 0xaa,
	0x19, 0x0d, 0x0a, 0x0b, 0x6a, 0x6f, 0x69, 0x6e, 0x20, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12,
	0x2d, 0x0a, 0x19, 0x4b, 0x45, 0x59, 0x5f, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e,
	0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x41, 0x4e, 0x49, 0x46, 0x45, 0x53, 0x54, 0x10, 0x03, 0x1a, 0x0e,
	0xea, 0xaa, 0x19, 0x0a, 0x0a, 0x08, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x1a, 0x18,
	0xea, 0xaa, 0x19, 0x14, 0x18, 0x01, 0x2a, 0x10, 0x4b, 0x45, 0x59, 0x5f, 0x50, 0x52, 0x4f, 0x56,
	0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x2a, 0xdd, 0x01, 0x0a, 0x0b, 0x4b, 0x65, 0x79,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x12, 0x27, 0x0a, 0x14, 0x4b, 0x45, 0x59, 0x5f,
	0x53, 0x45, 0x43, 0x55, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x10, 0x00, 0x1a, 0x0d, 0xea, 0xaa, 0x19, 0x09, 0x0a, 0x07, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77,
	0x6e, 0x12, 0x21, 0x0a, 0x11, 0x4b, 0x45, 0x59, 0x5f, 0x53, 0x45, 0x43, 0x55, 0x52, 0x49, 0x54,
	0x59, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x1a, 0x0a, 0xea, 0xaa, 0x19, 0x06, 0x0a, 0x04,
	0x6e, 0x6f, 0x6e, 0x65, 0x12, 0x35, 0x0a, 0x1b, 0x4b, 0x45, 0x59, 0x5f, 0x53, 0x45, 0x43, 0x55,
	0x52, 0x49, 0x54, 0x59, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x45, 0x43,
	0x54, 0x45, 0x44, 0x10, 0x02, 0x1a, 0x14, 0xea, 0xaa, 0x19, 0x10, 0x0a, 0x0e, 0x72, 0x65, 0x61,
	0x64, 0x20, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x12, 0x35, 0x0a, 0x1b, 0x4b,
	0x45, 0x59, 0x5f, 0x53, 0x45, 0x43, 0x55, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x53, 0x45, 0x43, 0x55,
	0x52, 0x45, 0x5f, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x03, 0x1a, 0x14, 0xea, 0xaa,
	0x19, 0x10, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x1a, 0x14, 0xea, 0xaa, 0x19, 0x10, 0x18, 0x01, 0x2a, 0x0c, 0x4b, 0x45, 0x59, 0x5f,
	0x53, 0x45, 0x43, 0x55, 0x52, 0x49, 0x54, 0x59, 0x32, 0xf2, 0x17, 0x0a, 0x10, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0xb5, 0x01,
	0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x12, 0x2a, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x72, 0x61, 0x6e, 0x64,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x5a, 0x3a, 0x12,
	0x38, 0x2f, 0x64, 0x72, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x12, 0x0a, 0x2f, 0x64, 0x72, 0x2f, 0x62,
	0x72, 0x61, 0x6e, 0x64, 0x73, 0x12, 0xba, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x42, 0x72, 0x61,
	0x6e, 0x64, 0x12, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x42, 0x72, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x22, 0x64, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x5e, 0x5a, 0x45, 0x12, 0x43, 0x2f, 0x64, 0x72, 0x2f, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73,
	0x2f, 0x7b, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x15, 0x2f, 0x64, 0x72,
	0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x7b, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69,
	0x64, 0x7d, 0x12, 0xa5, 0x02, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x73, 0x12, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xbd, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0xb6, 0x01, 0x5a, 0x1e, 0x12, 0x1c, 0x2f, 0x64, 0x72, 0x2f, 0x62, 0x72, 0x61, 0x6e,
	0x64, 0x73, 0x2f, 0x7b, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x5a, 0x3a, 0x12, 0x38, 0x2f, 0x64, 0x72, 0x2f, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x5a, 0x4c, 0x12, 0x4a, 0x2f, 0x64, 0x72, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x7b, 0x62, 0x72,
	0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x0a,
	0x2f, 0x64, 0x72, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0xe0, 0x01, 0x0a, 0x08, 0x47,
	0x65, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x64, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x22, 0x89, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x82, 0x01, 0x5a, 0x57, 0x12, 0x55, 0x2f,
	0x64, 0x72, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73,
	0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x7b, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x5f, 0x69, 0x64, 0x7d, 0x12, 0x27, 0x2f, 0x64, 0x72, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73,
	0x2f, 0x7b, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x9c, 0x05,
	0x0a, 0x0b, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x22, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47,
	0x65, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x21, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x22, 0xc5, 0x04, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xbe, 0x04, 0x5a, 0x6d,
	0x12, 0x6b, 0x2f, 0x64, 0x72, 0x2f, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x65,
	0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64,
	0x73, 0x2e, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5a, 0xae, 0x01,
	0x12, 0xab, 0x01, 0x2f, 0x64, 0x72, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x66, 0x69,
	0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x62, 0x61, 0x6e,
	0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5a, 0x9c,
	0x01, 0x12, 0x99, 0x01, 0x2f, 0x64, 0x72, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x65,
	0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x5f, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64,
	0x73, 0x2e, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x7d, 0x2f,
	0x64, 0x72, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x73, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7b,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x66, 0x69, 0x72, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x7b, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x62, 0x61, 0x6e, 0x64, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0xc2, 0x03, 0x0a,
	0x10, 0x47, 0x65, 0x74, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x65,
	0x72, 0x12, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x22, 0xda, 0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd3, 0x02, 0x5a, 0xbf,
	0x01, 0x12, 0xbc, 0x01, 0x2f, 0x64, 0x72, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x7b, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x66,
	0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x62, 0x61,
	0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x2f, 0x64, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x72,
	0x12, 0x8e, 0x01, 0x2f, 0x64, 0x72, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x7b, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e,
	0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x62,
	0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x2f, 0x64, 0x65, 0x63, 0x6f, 0x64, 0x65,
	0x72, 0x12, 0xc8, 0x03, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e,
	0x6b, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x12, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x22, 0xde, 0x02, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0xd7, 0x02, 0x5a, 0xc1, 0x01, 0x12, 0xbe, 0x01, 0x2f, 0x64, 0x72, 0x2f, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x72, 0x61,
	0x6e, 0x64, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73,
	0x2e, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x73, 0x2e, 0x62, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e,
	0x6b, 0x2f, 0x64, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x12, 0x90, 0x01, 0x2f, 0x64, 0x72, 0x2f,
	0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x73, 0x2e, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x73, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7b, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x62, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x2f, 0x64, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x12, 0xc8, 0x03, 0x0a,
	0x12, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x65, 0x72, 0x12, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x25, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x45,
	0x6e, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x22, 0xde, 0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd7, 0x02,
	0x5a, 0xc1, 0x01, 0x12, 0xbe, 0x01, 0x2f, 0x64, 0x72, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x7b,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x62, 0x72, 0x61, 0x6e,
	0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73,
	0x2e, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e,
	0x62, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x73, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x2f, 0x65, 0x6e, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x12, 0x90, 0x01, 0x2f, 0x64, 0x72, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x62,
	0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f,
	0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x73, 0x2e, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x73, 0x2e, 0x62, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x2f,
	0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x1a, 0x64, 0x92, 0x41, 0x61, 0x12, 0x5f, 0x47, 0x65,
	0x74, 0x20, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x6e,
	0x20, 0x4c, 0x6f, 0x52, 0x61, 0x57, 0x41, 0x4e, 0x20, 0x65, 0x6e, 0x64, 0x20, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x20, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x2c, 0x20, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x20, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x42, 0x31, 0x5a,
	0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_devicerepository_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_devicerepository_proto_rawDescData = file_ttn_lorawan_v3_devicerepository_proto_rawDesc
)

func file_ttn_lorawan_v3_devicerepository_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_devicerepository_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_devicerepository_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_devicerepository_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_devicerepository_proto_rawDescData
}

var file_ttn_lorawan_v3_devicerepository_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_ttn_lorawan_v3_devicerepository_proto_msgTypes = make([]protoimpl.MessageInfo, 30)
var file_ttn_lorawan_v3_devicerepository_proto_goTypes = []interface{}{
	(KeyProvisioning)(0),                           // 0: ttn.lorawan.v3.KeyProvisioning
	(KeySecurity)(0),                               // 1: ttn.lorawan.v3.KeySecurity
	(*EndDeviceBrand)(nil),                         // 2: ttn.lorawan.v3.EndDeviceBrand
	(*EndDeviceModel)(nil),                         // 3: ttn.lorawan.v3.EndDeviceModel
	(*GetEndDeviceBrandRequest)(nil),               // 4: ttn.lorawan.v3.GetEndDeviceBrandRequest
	(*ListEndDeviceBrandsRequest)(nil),             // 5: ttn.lorawan.v3.ListEndDeviceBrandsRequest
	(*GetEndDeviceModelRequest)(nil),               // 6: ttn.lorawan.v3.GetEndDeviceModelRequest
	(*ListEndDeviceModelsRequest)(nil),             // 7: ttn.lorawan.v3.ListEndDeviceModelsRequest
	(*GetTemplateRequest)(nil),                     // 8: ttn.lorawan.v3.GetTemplateRequest
	(*GetPayloadFormatterRequest)(nil),             // 9: ttn.lorawan.v3.GetPayloadFormatterRequest
	(*ListEndDeviceBrandsResponse)(nil),            // 10: ttn.lorawan.v3.ListEndDeviceBrandsResponse
	(*ListEndDeviceModelsResponse)(nil),            // 11: ttn.lorawan.v3.ListEndDeviceModelsResponse
	(*EncodedMessagePayload)(nil),                  // 12: ttn.lorawan.v3.EncodedMessagePayload
	(*DecodedMessagePayload)(nil),                  // 13: ttn.lorawan.v3.DecodedMessagePayload
	(*MessagePayloadDecoder)(nil),                  // 14: ttn.lorawan.v3.MessagePayloadDecoder
	(*MessagePayloadEncoder)(nil),                  // 15: ttn.lorawan.v3.MessagePayloadEncoder
	(*EndDeviceModel_HardwareVersion)(nil),         // 16: ttn.lorawan.v3.EndDeviceModel.HardwareVersion
	(*EndDeviceModel_FirmwareVersion)(nil),         // 17: ttn.lorawan.v3.EndDeviceModel.FirmwareVersion
	(*EndDeviceModel_Dimensions)(nil),              // 18: ttn.lorawan.v3.EndDeviceModel.Dimensions
	(*EndDeviceModel_Battery)(nil),                 // 19: ttn.lorawan.v3.EndDeviceModel.Battery
	(*EndDeviceModel_OperatingConditions)(nil),     // 20: ttn.lorawan.v3.EndDeviceModel.OperatingConditions
	(*EndDeviceModel_Photos)(nil),                  // 21: ttn.lorawan.v3.EndDeviceModel.Photos
	(*EndDeviceModel_Videos)(nil),                  // 22: ttn.lorawan.v3.EndDeviceModel.Videos
	(*EndDeviceModel_Reseller)(nil),                // 23: ttn.lorawan.v3.EndDeviceModel.Reseller
	(*EndDeviceModel_Compliances)(nil),             // 24: ttn.lorawan.v3.EndDeviceModel.Compliances
	(*EndDeviceModel_FirmwareVersion_Profile)(nil), // 25: ttn.lorawan.v3.EndDeviceModel.FirmwareVersion.Profile
	nil, // 26: ttn.lorawan.v3.EndDeviceModel.FirmwareVersion.ProfilesEntry
	(*EndDeviceModel_OperatingConditions_Limits)(nil),      // 27: ttn.lorawan.v3.EndDeviceModel.OperatingConditions.Limits
	(*EndDeviceModel_Compliances_Compliance)(nil),          // 28: ttn.lorawan.v3.EndDeviceModel.Compliances.Compliance
	(*GetTemplateRequest_EndDeviceProfileIdentifiers)(nil), // 29: ttn.lorawan.v3.GetTemplateRequest.EndDeviceProfileIdentifiers
	(*MessagePayloadDecoder_Example)(nil),                  // 30: ttn.lorawan.v3.MessagePayloadDecoder.Example
	(*MessagePayloadEncoder_Example)(nil),                  // 31: ttn.lorawan.v3.MessagePayloadEncoder.Example
	(*wrapperspb.FloatValue)(nil),                          // 32: google.protobuf.FloatValue
	(*ApplicationIdentifiers)(nil),                         // 33: ttn.lorawan.v3.ApplicationIdentifiers
	(*fieldmaskpb.FieldMask)(nil),                          // 34: google.protobuf.FieldMask
	(*EndDeviceVersionIdentifiers)(nil),                    // 35: ttn.lorawan.v3.EndDeviceVersionIdentifiers
	(*structpb.Struct)(nil),                                // 36: google.protobuf.Struct
	(PayloadFormatter)(0),                                  // 37: ttn.lorawan.v3.PayloadFormatter
	(*wrapperspb.BoolValue)(nil),                           // 38: google.protobuf.BoolValue
	(*EndDeviceTemplate)(nil),                              // 39: ttn.lorawan.v3.EndDeviceTemplate
}
var file_ttn_lorawan_v3_devicerepository_proto_depIdxs = []int32{
	16, // 0: ttn.lorawan.v3.EndDeviceModel.hardware_versions:type_name -> ttn.lorawan.v3.EndDeviceModel.HardwareVersion
	17, // 1: ttn.lorawan.v3.EndDeviceModel.firmware_versions:type_name -> ttn.lorawan.v3.EndDeviceModel.FirmwareVersion
	18, // 2: ttn.lorawan.v3.EndDeviceModel.dimensions:type_name -> ttn.lorawan.v3.EndDeviceModel.Dimensions
	32, // 3: ttn.lorawan.v3.EndDeviceModel.weight:type_name -> google.protobuf.FloatValue
	19, // 4: ttn.lorawan.v3.EndDeviceModel.battery:type_name -> ttn.lorawan.v3.EndDeviceModel.Battery
	20, // 5: ttn.lorawan.v3.EndDeviceModel.operating_conditions:type_name -> ttn.lorawan.v3.EndDeviceModel.OperatingConditions
	0,  // 6: ttn.lorawan.v3.EndDeviceModel.key_provisioning:type_name -> ttn.lorawan.v3.KeyProvisioning
	1,  // 7: ttn.lorawan.v3.EndDeviceModel.key_security:type_name -> ttn.lorawan.v3.KeySecurity
	21, // 8: ttn.lorawan.v3.EndDeviceModel.photos:type_name -> ttn.lorawan.v3.EndDeviceModel.Photos
	22, // 9: ttn.lorawan.v3.EndDeviceModel.videos:type_name -> ttn.lorawan.v3.EndDeviceModel.Videos
	23, // 10: ttn.lorawan.v3.EndDeviceModel.resellers:type_name -> ttn.lorawan.v3.EndDeviceModel.Reseller
	24, // 11: ttn.lorawan.v3.EndDeviceModel.compliances:type_name -> ttn.lorawan.v3.EndDeviceModel.Compliances
	33, // 12: ttn.lorawan.v3.GetEndDeviceBrandRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	34, // 13: ttn.lorawan.v3.GetEndDeviceBrandRequest.field_mask:type_name -> google.protobuf.FieldMask
	33, // 14: ttn.lorawan.v3.ListEndDeviceBrandsRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	34, // 15: ttn.lorawan.v3.ListEndDeviceBrandsRequest.field_mask:type_name -> google.protobuf.FieldMask
	33, // 16: ttn.lorawan.v3.GetEndDeviceModelRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	34, // 17: ttn.lorawan.v3.GetEndDeviceModelRequest.field_mask:type_name -> google.protobuf.FieldMask
	33, // 18: ttn.lorawan.v3.ListEndDeviceModelsRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	34, // 19: ttn.lorawan.v3.ListEndDeviceModelsRequest.field_mask:type_name -> google.protobuf.FieldMask
	33, // 20: ttn.lorawan.v3.GetTemplateRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	35, // 21: ttn.lorawan.v3.GetTemplateRequest.version_ids:type_name -> ttn.lorawan.v3.EndDeviceVersionIdentifiers
	29, // 22: ttn.lorawan.v3.GetTemplateRequest.end_device_profile_ids:type_name -> ttn.lorawan.v3.GetTemplateRequest.EndDeviceProfileIdentifiers
	33, // 23: ttn.lorawan.v3.GetPayloadFormatterRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	35, // 24: ttn.lorawan.v3.GetPayloadFormatterRequest.version_ids:type_name -> ttn.lorawan.v3.EndDeviceVersionIdentifiers
	34, // 25: ttn.lorawan.v3.GetPayloadFormatterRequest.field_mask:type_name -> google.protobuf.FieldMask
	2,  // 26: ttn.lorawan.v3.ListEndDeviceBrandsResponse.brands:type_name -> ttn.lorawan.v3.EndDeviceBrand
	3,  // 27: ttn.lorawan.v3.ListEndDeviceModelsResponse.models:type_name -> ttn.lorawan.v3.EndDeviceModel
	36, // 28: ttn.lorawan.v3.DecodedMessagePayload.data:type_name -> google.protobuf.Struct
	37, // 29: ttn.lorawan.v3.MessagePayloadDecoder.formatter:type_name -> ttn.lorawan.v3.PayloadFormatter
	30, // 30: ttn.lorawan.v3.MessagePayloadDecoder.examples:type_name -> ttn.lorawan.v3.MessagePayloadDecoder.Example
	37, // 31: ttn.lorawan.v3.MessagePayloadEncoder.formatter:type_name -> ttn.lorawan.v3.PayloadFormatter
	31, // 32: ttn.lorawan.v3.MessagePayloadEncoder.examples:type_name -> ttn.lorawan.v3.MessagePayloadEncoder.Example
	26, // 33: ttn.lorawan.v3.EndDeviceModel.FirmwareVersion.profiles:type_name -> ttn.lorawan.v3.EndDeviceModel.FirmwareVersion.ProfilesEntry
	32, // 34: ttn.lorawan.v3.EndDeviceModel.Dimensions.width:type_name -> google.protobuf.FloatValue
	32, // 35: ttn.lorawan.v3.EndDeviceModel.Dimensions.height:type_name -> google.protobuf.FloatValue
	32, // 36: ttn.lorawan.v3.EndDeviceModel.Dimensions.diameter:type_name -> google.protobuf.FloatValue
	32, // 37: ttn.lorawan.v3.EndDeviceModel.Dimensions.length:type_name -> google.protobuf.FloatValue
	38, // 38: ttn.lorawan.v3.EndDeviceModel.Battery.replaceable:type_name -> google.protobuf.BoolValue
	27, // 39: ttn.lorawan.v3.EndDeviceModel.OperatingConditions.temperature:type_name -> ttn.lorawan.v3.EndDeviceModel.OperatingConditions.Limits
	27, // 40: ttn.lorawan.v3.EndDeviceModel.OperatingConditions.relative_humidity:type_name -> ttn.lorawan.v3.EndDeviceModel.OperatingConditions.Limits
	28, // 41: ttn.lorawan.v3.EndDeviceModel.Compliances.safety:type_name -> ttn.lorawan.v3.EndDeviceModel.Compliances.Compliance
	28, // 42: ttn.lorawan.v3.EndDeviceModel.Compliances.radio_equipment:type_name -> ttn.lorawan.v3.EndDeviceModel.Compliances.Compliance
	25, // 43: ttn.lorawan.v3.EndDeviceModel.FirmwareVersion.ProfilesEntry.value:type_name -> ttn.lorawan.v3.EndDeviceModel.FirmwareVersion.Profile
	32, // 44: ttn.lorawan.v3.EndDeviceModel.OperatingConditions.Limits.min:type_name -> google.protobuf.FloatValue
	32, // 45: ttn.lorawan.v3.EndDeviceModel.OperatingConditions.Limits.max:type_name -> google.protobuf.FloatValue
	12, // 46: ttn.lorawan.v3.MessagePayloadDecoder.Example.input:type_name -> ttn.lorawan.v3.EncodedMessagePayload
	13, // 47: ttn.lorawan.v3.MessagePayloadDecoder.Example.output:type_name -> ttn.lorawan.v3.DecodedMessagePayload
	13, // 48: ttn.lorawan.v3.MessagePayloadEncoder.Example.input:type_name -> ttn.lorawan.v3.DecodedMessagePayload
	12, // 49: ttn.lorawan.v3.MessagePayloadEncoder.Example.output:type_name -> ttn.lorawan.v3.EncodedMessagePayload
	5,  // 50: ttn.lorawan.v3.DeviceRepository.ListBrands:input_type -> ttn.lorawan.v3.ListEndDeviceBrandsRequest
	4,  // 51: ttn.lorawan.v3.DeviceRepository.GetBrand:input_type -> ttn.lorawan.v3.GetEndDeviceBrandRequest
	7,  // 52: ttn.lorawan.v3.DeviceRepository.ListModels:input_type -> ttn.lorawan.v3.ListEndDeviceModelsRequest
	6,  // 53: ttn.lorawan.v3.DeviceRepository.GetModel:input_type -> ttn.lorawan.v3.GetEndDeviceModelRequest
	8,  // 54: ttn.lorawan.v3.DeviceRepository.GetTemplate:input_type -> ttn.lorawan.v3.GetTemplateRequest
	9,  // 55: ttn.lorawan.v3.DeviceRepository.GetUplinkDecoder:input_type -> ttn.lorawan.v3.GetPayloadFormatterRequest
	9,  // 56: ttn.lorawan.v3.DeviceRepository.GetDownlinkDecoder:input_type -> ttn.lorawan.v3.GetPayloadFormatterRequest
	9,  // 57: ttn.lorawan.v3.DeviceRepository.GetDownlinkEncoder:input_type -> ttn.lorawan.v3.GetPayloadFormatterRequest
	10, // 58: ttn.lorawan.v3.DeviceRepository.ListBrands:output_type -> ttn.lorawan.v3.ListEndDeviceBrandsResponse
	2,  // 59: ttn.lorawan.v3.DeviceRepository.GetBrand:output_type -> ttn.lorawan.v3.EndDeviceBrand
	11, // 60: ttn.lorawan.v3.DeviceRepository.ListModels:output_type -> ttn.lorawan.v3.ListEndDeviceModelsResponse
	3,  // 61: ttn.lorawan.v3.DeviceRepository.GetModel:output_type -> ttn.lorawan.v3.EndDeviceModel
	39, // 62: ttn.lorawan.v3.DeviceRepository.GetTemplate:output_type -> ttn.lorawan.v3.EndDeviceTemplate
	14, // 63: ttn.lorawan.v3.DeviceRepository.GetUplinkDecoder:output_type -> ttn.lorawan.v3.MessagePayloadDecoder
	14, // 64: ttn.lorawan.v3.DeviceRepository.GetDownlinkDecoder:output_type -> ttn.lorawan.v3.MessagePayloadDecoder
	15, // 65: ttn.lorawan.v3.DeviceRepository.GetDownlinkEncoder:output_type -> ttn.lorawan.v3.MessagePayloadEncoder
	58, // [58:66] is the sub-list for method output_type
	50, // [50:58] is the sub-list for method input_type
	50, // [50:50] is the sub-list for extension type_name
	50, // [50:50] is the sub-list for extension extendee
	0,  // [0:50] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_devicerepository_proto_init() }
func file_ttn_lorawan_v3_devicerepository_proto_init() {
	if File_ttn_lorawan_v3_devicerepository_proto != nil {
		return
	}
	file_ttn_lorawan_v3_end_device_proto_init()
	file_ttn_lorawan_v3_identifiers_proto_init()
	file_ttn_lorawan_v3_messages_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceBrand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceModel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEndDeviceBrandRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEndDeviceBrandsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEndDeviceModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEndDeviceModelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPayloadFormatterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEndDeviceBrandsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEndDeviceModelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EncodedMessagePayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DecodedMessagePayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessagePayloadDecoder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessagePayloadEncoder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceModel_HardwareVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceModel_FirmwareVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceModel_Dimensions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceModel_Battery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceModel_OperatingConditions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceModel_Photos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceModel_Videos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceModel_Reseller); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceModel_Compliances); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceModel_FirmwareVersion_Profile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceModel_OperatingConditions_Limits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndDeviceModel_Compliances_Compliance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTemplateRequest_EndDeviceProfileIdentifiers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessagePayloadDecoder_Example); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_devicerepository_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessagePayloadEncoder_Example); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_devicerepository_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   30,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_ttn_lorawan_v3_devicerepository_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_devicerepository_proto_depIdxs,
		EnumInfos:         file_ttn_lorawan_v3_devicerepository_proto_enumTypes,
		MessageInfos:      file_ttn_lorawan_v3_devicerepository_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_devicerepository_proto = out.File
	file_ttn_lorawan_v3_devicerepository_proto_rawDesc = nil
	file_ttn_lorawan_v3_devicerepository_proto_goTypes = nil
	file_ttn_lorawan_v3_devicerepository_proto_depIdxs = nil
}
