// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on ClaimEndDeviceRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ClaimEndDeviceRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ClaimEndDeviceRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "target_application_ids":

			if m.GetTargetApplicationIds() == nil {
				return ClaimEndDeviceRequestValidationError{
					field:  "target_application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetTargetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ClaimEndDeviceRequestValidationError{
						field:  "target_application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "target_device_id":

			if utf8.RuneCountInString(m.GetTargetDeviceId()) > 36 {
				return ClaimEndDeviceRequestValidationError{
					field:  "target_device_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_ClaimEndDeviceRequest_TargetDeviceId_Pattern.MatchString(m.GetTargetDeviceId()) {
				return ClaimEndDeviceRequestValidationError{
					field:  "target_device_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$|^$\"",
				}
			}

		case "source_device":
			if m.SourceDevice == nil {
				return ClaimEndDeviceRequestValidationError{
					field:  "source_device",
					reason: "value is required",
				}
			}
			if len(subs) == 0 {
				subs = []string{
					"authenticated_identifiers", "qr_code",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "authenticated_identifiers":
					w, ok := m.SourceDevice.(*ClaimEndDeviceRequest_AuthenticatedIdentifiers_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetAuthenticatedIdentifiers()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ClaimEndDeviceRequestValidationError{
								field:  "authenticated_identifiers",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "qr_code":
					w, ok := m.SourceDevice.(*ClaimEndDeviceRequest_QrCode)
					if !ok || w == nil {
						continue
					}

					if l := len(m.GetQrCode()); l < 0 || l > 1024 {
						return ClaimEndDeviceRequestValidationError{
							field:  "qr_code",
							reason: "value length must be between 0 and 1024 bytes, inclusive",
						}
					}

				}
			}
		default:
			return ClaimEndDeviceRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ClaimEndDeviceRequestValidationError is the validation error returned by
// ClaimEndDeviceRequest.ValidateFields if the designated constraints aren't met.
type ClaimEndDeviceRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ClaimEndDeviceRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ClaimEndDeviceRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ClaimEndDeviceRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ClaimEndDeviceRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ClaimEndDeviceRequestValidationError) ErrorName() string {
	return "ClaimEndDeviceRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ClaimEndDeviceRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sClaimEndDeviceRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ClaimEndDeviceRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ClaimEndDeviceRequestValidationError{}

var _ClaimEndDeviceRequest_TargetDeviceId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$|^$")

// ValidateFields checks the field values on AuthorizeApplicationRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *AuthorizeApplicationRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = AuthorizeApplicationRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return AuthorizeApplicationRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return AuthorizeApplicationRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "api_key":

			if l := utf8.RuneCountInString(m.GetApiKey()); l < 1 || l > 128 {
				return AuthorizeApplicationRequestValidationError{
					field:  "api_key",
					reason: "value length must be between 1 and 128 runes, inclusive",
				}
			}

		default:
			return AuthorizeApplicationRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// AuthorizeApplicationRequestValidationError is the validation error returned
// by AuthorizeApplicationRequest.ValidateFields if the designated constraints
// aren't met.
type AuthorizeApplicationRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AuthorizeApplicationRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AuthorizeApplicationRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AuthorizeApplicationRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AuthorizeApplicationRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AuthorizeApplicationRequestValidationError) ErrorName() string {
	return "AuthorizeApplicationRequestValidationError"
}

// Error satisfies the builtin error interface
func (e AuthorizeApplicationRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAuthorizeApplicationRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AuthorizeApplicationRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AuthorizeApplicationRequestValidationError{}

// ValidateFields checks the field values on GetInfoByJoinEUIRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetInfoByJoinEUIRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetInfoByJoinEUIRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "join_eui":

			if len(m.GetJoinEui()) > 0 {

				if len(m.GetJoinEui()) != 8 {
					return GetInfoByJoinEUIRequestValidationError{
						field:  "join_eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		default:
			return GetInfoByJoinEUIRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetInfoByJoinEUIRequestValidationError is the validation error returned by
// GetInfoByJoinEUIRequest.ValidateFields if the designated constraints aren't met.
type GetInfoByJoinEUIRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetInfoByJoinEUIRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetInfoByJoinEUIRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetInfoByJoinEUIRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetInfoByJoinEUIRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetInfoByJoinEUIRequestValidationError) ErrorName() string {
	return "GetInfoByJoinEUIRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetInfoByJoinEUIRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetInfoByJoinEUIRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetInfoByJoinEUIRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetInfoByJoinEUIRequestValidationError{}

// ValidateFields checks the field values on GetInfoByJoinEUIResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetInfoByJoinEUIResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetInfoByJoinEUIResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "join_eui":

			if len(m.GetJoinEui()) > 0 {

				if len(m.GetJoinEui()) != 8 {
					return GetInfoByJoinEUIResponseValidationError{
						field:  "join_eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		case "supports_claiming":
			// no validation rules for SupportsClaiming
		default:
			return GetInfoByJoinEUIResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetInfoByJoinEUIResponseValidationError is the validation error returned by
// GetInfoByJoinEUIResponse.ValidateFields if the designated constraints
// aren't met.
type GetInfoByJoinEUIResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetInfoByJoinEUIResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetInfoByJoinEUIResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetInfoByJoinEUIResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetInfoByJoinEUIResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetInfoByJoinEUIResponseValidationError) ErrorName() string {
	return "GetInfoByJoinEUIResponseValidationError"
}

// Error satisfies the builtin error interface
func (e GetInfoByJoinEUIResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetInfoByJoinEUIResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetInfoByJoinEUIResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetInfoByJoinEUIResponseValidationError{}

// ValidateFields checks the field values on GetInfoByJoinEUIsRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetInfoByJoinEUIsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetInfoByJoinEUIsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "requests":

			if len(m.GetRequests()) > 20 {
				return GetInfoByJoinEUIsRequestValidationError{
					field:  "requests",
					reason: "value must contain no more than 20 item(s)",
				}
			}

			for idx, item := range m.GetRequests() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return GetInfoByJoinEUIsRequestValidationError{
							field:  fmt.Sprintf("requests[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return GetInfoByJoinEUIsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetInfoByJoinEUIsRequestValidationError is the validation error returned by
// GetInfoByJoinEUIsRequest.ValidateFields if the designated constraints
// aren't met.
type GetInfoByJoinEUIsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetInfoByJoinEUIsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetInfoByJoinEUIsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetInfoByJoinEUIsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetInfoByJoinEUIsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetInfoByJoinEUIsRequestValidationError) ErrorName() string {
	return "GetInfoByJoinEUIsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetInfoByJoinEUIsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetInfoByJoinEUIsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetInfoByJoinEUIsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetInfoByJoinEUIsRequestValidationError{}

// ValidateFields checks the field values on GetInfoByJoinEUIsResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetInfoByJoinEUIsResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetInfoByJoinEUIsResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "infos":

			for idx, item := range m.GetInfos() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return GetInfoByJoinEUIsResponseValidationError{
							field:  fmt.Sprintf("infos[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return GetInfoByJoinEUIsResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetInfoByJoinEUIsResponseValidationError is the validation error returned by
// GetInfoByJoinEUIsResponse.ValidateFields if the designated constraints
// aren't met.
type GetInfoByJoinEUIsResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetInfoByJoinEUIsResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetInfoByJoinEUIsResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetInfoByJoinEUIsResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetInfoByJoinEUIsResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetInfoByJoinEUIsResponseValidationError) ErrorName() string {
	return "GetInfoByJoinEUIsResponseValidationError"
}

// Error satisfies the builtin error interface
func (e GetInfoByJoinEUIsResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetInfoByJoinEUIsResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetInfoByJoinEUIsResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetInfoByJoinEUIsResponseValidationError{}

// ValidateFields checks the field values on GetClaimStatusResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetClaimStatusResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetClaimStatusResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "end_device_ids":

			if m.GetEndDeviceIds() == nil {
				return GetClaimStatusResponseValidationError{
					field:  "end_device_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetEndDeviceIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetClaimStatusResponseValidationError{
						field:  "end_device_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "home_net_id":

			if len(m.GetHomeNetId()) > 0 {

				if len(m.GetHomeNetId()) != 3 {
					return GetClaimStatusResponseValidationError{
						field:  "home_net_id",
						reason: "value length must be 3 bytes",
					}
				}

			}

		case "home_ns_id":

			if len(m.GetHomeNsId()) > 0 {

				if len(m.GetHomeNsId()) != 8 {
					return GetClaimStatusResponseValidationError{
						field:  "home_ns_id",
						reason: "value length must be 8 bytes",
					}
				}

			}

		case "vendor_specific":

			if v, ok := interface{}(m.GetVendorSpecific()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetClaimStatusResponseValidationError{
						field:  "vendor_specific",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetClaimStatusResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetClaimStatusResponseValidationError is the validation error returned by
// GetClaimStatusResponse.ValidateFields if the designated constraints aren't met.
type GetClaimStatusResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetClaimStatusResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetClaimStatusResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetClaimStatusResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetClaimStatusResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetClaimStatusResponseValidationError) ErrorName() string {
	return "GetClaimStatusResponseValidationError"
}

// Error satisfies the builtin error interface
func (e GetClaimStatusResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetClaimStatusResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetClaimStatusResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetClaimStatusResponseValidationError{}

// ValidateFields checks the field values on BatchUnclaimEndDevicesRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *BatchUnclaimEndDevicesRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BatchUnclaimEndDevicesRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return BatchUnclaimEndDevicesRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BatchUnclaimEndDevicesRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "device_ids":

			if l := len(m.GetDeviceIds()); l < 1 || l > 20 {
				return BatchUnclaimEndDevicesRequestValidationError{
					field:  "device_ids",
					reason: "value must contain between 1 and 20 items, inclusive",
				}
			}

			for idx, item := range m.GetDeviceIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 36 {
					return BatchUnclaimEndDevicesRequestValidationError{
						field:  fmt.Sprintf("device_ids[%v]", idx),
						reason: "value length must be at most 36 runes",
					}
				}

				if !_BatchUnclaimEndDevicesRequest_DeviceIds_Pattern.MatchString(item) {
					return BatchUnclaimEndDevicesRequestValidationError{
						field:  fmt.Sprintf("device_ids[%v]", idx),
						reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
					}
				}

			}

		default:
			return BatchUnclaimEndDevicesRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BatchUnclaimEndDevicesRequestValidationError is the validation error
// returned by BatchUnclaimEndDevicesRequest.ValidateFields if the designated
// constraints aren't met.
type BatchUnclaimEndDevicesRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BatchUnclaimEndDevicesRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BatchUnclaimEndDevicesRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BatchUnclaimEndDevicesRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BatchUnclaimEndDevicesRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BatchUnclaimEndDevicesRequestValidationError) ErrorName() string {
	return "BatchUnclaimEndDevicesRequestValidationError"
}

// Error satisfies the builtin error interface
func (e BatchUnclaimEndDevicesRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBatchUnclaimEndDevicesRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BatchUnclaimEndDevicesRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BatchUnclaimEndDevicesRequestValidationError{}

var _BatchUnclaimEndDevicesRequest_DeviceIds_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on BatchUnclaimEndDevicesResponse
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *BatchUnclaimEndDevicesResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BatchUnclaimEndDevicesResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BatchUnclaimEndDevicesResponseValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "failed":

			for key, val := range m.GetFailed() {
				_ = val

				// no validation rules for Failed[key]

				if v, ok := interface{}(val).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return BatchUnclaimEndDevicesResponseValidationError{
							field:  fmt.Sprintf("failed[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return BatchUnclaimEndDevicesResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BatchUnclaimEndDevicesResponseValidationError is the validation error
// returned by BatchUnclaimEndDevicesResponse.ValidateFields if the designated
// constraints aren't met.
type BatchUnclaimEndDevicesResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BatchUnclaimEndDevicesResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BatchUnclaimEndDevicesResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BatchUnclaimEndDevicesResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BatchUnclaimEndDevicesResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BatchUnclaimEndDevicesResponseValidationError) ErrorName() string {
	return "BatchUnclaimEndDevicesResponseValidationError"
}

// Error satisfies the builtin error interface
func (e BatchUnclaimEndDevicesResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBatchUnclaimEndDevicesResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BatchUnclaimEndDevicesResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BatchUnclaimEndDevicesResponseValidationError{}

// ValidateFields checks the field values on CUPSRedirection with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *CUPSRedirection) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CUPSRedirectionFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "target_cups_uri":

			if utf8.RuneCountInString(m.GetTargetCupsUri()) > 256 {
				return CUPSRedirectionValidationError{
					field:  "target_cups_uri",
					reason: "value length must be at most 256 runes",
				}
			}

			if uri, err := url.Parse(m.GetTargetCupsUri()); err != nil {
				return CUPSRedirectionValidationError{
					field:  "target_cups_uri",
					reason: "value must be a valid URI",
					cause:  err,
				}
			} else if !uri.IsAbs() {
				return CUPSRedirectionValidationError{
					field:  "target_cups_uri",
					reason: "value must be absolute",
				}
			}

			if !_CUPSRedirection_TargetCupsUri_Pattern.MatchString(m.GetTargetCupsUri()) {
				return CUPSRedirectionValidationError{
					field:  "target_cups_uri",
					reason: "value does not match regex pattern \"^https\"",
				}
			}

		case "current_gateway_key":

			if utf8.RuneCountInString(m.GetCurrentGatewayKey()) > 2048 {
				return CUPSRedirectionValidationError{
					field:  "current_gateway_key",
					reason: "value length must be at most 2048 runes",
				}
			}

		case "target_cups_trust":
			// no validation rules for TargetCupsTrust
		case "gateway_credentials":
			if len(subs) == 0 {
				subs = []string{
					"client_tls", "auth_token",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "client_tls":
					w, ok := m.GatewayCredentials.(*CUPSRedirection_ClientTls)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetClientTls()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return CUPSRedirectionValidationError{
								field:  "client_tls",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "auth_token":
					w, ok := m.GatewayCredentials.(*CUPSRedirection_AuthToken)
					if !ok || w == nil {
						continue
					}

					if utf8.RuneCountInString(m.GetAuthToken()) > 2048 {
						return CUPSRedirectionValidationError{
							field:  "auth_token",
							reason: "value length must be at most 2048 runes",
						}
					}

				}
			}
		default:
			return CUPSRedirectionValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CUPSRedirectionValidationError is the validation error returned by
// CUPSRedirection.ValidateFields if the designated constraints aren't met.
type CUPSRedirectionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CUPSRedirectionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CUPSRedirectionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CUPSRedirectionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CUPSRedirectionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CUPSRedirectionValidationError) ErrorName() string { return "CUPSRedirectionValidationError" }

// Error satisfies the builtin error interface
func (e CUPSRedirectionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCUPSRedirection.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CUPSRedirectionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CUPSRedirectionValidationError{}

var _CUPSRedirection_TargetCupsUri_Pattern = regexp.MustCompile("^https")

// ValidateFields checks the field values on ClaimGatewayRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ClaimGatewayRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ClaimGatewayRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "collaborator":

			if m.GetCollaborator() == nil {
				return ClaimGatewayRequestValidationError{
					field:  "collaborator",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetCollaborator()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ClaimGatewayRequestValidationError{
						field:  "collaborator",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "target_gateway_id":

			if utf8.RuneCountInString(m.GetTargetGatewayId()) > 36 {
				return ClaimGatewayRequestValidationError{
					field:  "target_gateway_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_ClaimGatewayRequest_TargetGatewayId_Pattern.MatchString(m.GetTargetGatewayId()) {
				return ClaimGatewayRequestValidationError{
					field:  "target_gateway_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$|^$\"",
				}
			}

		case "target_gateway_server_address":

			if !_ClaimGatewayRequest_TargetGatewayServerAddress_Pattern.MatchString(m.GetTargetGatewayServerAddress()) {
				return ClaimGatewayRequestValidationError{
					field:  "target_gateway_server_address",
					reason: "value does not match regex pattern \"^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\\\-]*[a-zA-Z0-9])\\\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$\"",
				}
			}

		case "cups_redirection":

			if v, ok := interface{}(m.GetCupsRedirection()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ClaimGatewayRequestValidationError{
						field:  "cups_redirection",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "target_frequency_plan_id":

			if utf8.RuneCountInString(m.GetTargetFrequencyPlanId()) > 64 {
				return ClaimGatewayRequestValidationError{
					field:  "target_frequency_plan_id",
					reason: "value length must be at most 64 runes",
				}
			}

		case "target_frequency_plan_ids":

			if len(m.GetTargetFrequencyPlanIds()) > 8 {
				return ClaimGatewayRequestValidationError{
					field:  "target_frequency_plan_ids",
					reason: "value must contain no more than 8 item(s)",
				}
			}

			for idx, item := range m.GetTargetFrequencyPlanIds() {
				_, _ = idx, item

				if utf8.RuneCountInString(item) > 64 {
					return ClaimGatewayRequestValidationError{
						field:  fmt.Sprintf("target_frequency_plan_ids[%v]", idx),
						reason: "value length must be at most 64 runes",
					}
				}

			}

		case "source_gateway":
			if m.SourceGateway == nil {
				return ClaimGatewayRequestValidationError{
					field:  "source_gateway",
					reason: "value is required",
				}
			}
			if len(subs) == 0 {
				subs = []string{
					"authenticated_identifiers", "qr_code",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "authenticated_identifiers":
					w, ok := m.SourceGateway.(*ClaimGatewayRequest_AuthenticatedIdentifiers_)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetAuthenticatedIdentifiers()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ClaimGatewayRequestValidationError{
								field:  "authenticated_identifiers",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "qr_code":
					w, ok := m.SourceGateway.(*ClaimGatewayRequest_QrCode)
					if !ok || w == nil {
						continue
					}

					if l := len(m.GetQrCode()); l < 0 || l > 1024 {
						return ClaimGatewayRequestValidationError{
							field:  "qr_code",
							reason: "value length must be between 0 and 1024 bytes, inclusive",
						}
					}

				}
			}
		default:
			return ClaimGatewayRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ClaimGatewayRequestValidationError is the validation error returned by
// ClaimGatewayRequest.ValidateFields if the designated constraints aren't met.
type ClaimGatewayRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ClaimGatewayRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ClaimGatewayRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ClaimGatewayRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ClaimGatewayRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ClaimGatewayRequestValidationError) ErrorName() string {
	return "ClaimGatewayRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ClaimGatewayRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sClaimGatewayRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ClaimGatewayRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ClaimGatewayRequestValidationError{}

var _ClaimGatewayRequest_TargetGatewayId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$|^$")

var _ClaimGatewayRequest_TargetGatewayServerAddress_Pattern = regexp.MustCompile("^(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*(?:[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])(?::[0-9]{1,5})?$|^$")

// ValidateFields checks the field values on AuthorizeGatewayRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *AuthorizeGatewayRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = AuthorizeGatewayRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_ids":

			if m.GetGatewayIds() == nil {
				return AuthorizeGatewayRequestValidationError{
					field:  "gateway_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetGatewayIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return AuthorizeGatewayRequestValidationError{
						field:  "gateway_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "api_key":

			if utf8.RuneCountInString(m.GetApiKey()) < 1 {
				return AuthorizeGatewayRequestValidationError{
					field:  "api_key",
					reason: "value length must be at least 1 runes",
				}
			}

		default:
			return AuthorizeGatewayRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// AuthorizeGatewayRequestValidationError is the validation error returned by
// AuthorizeGatewayRequest.ValidateFields if the designated constraints aren't met.
type AuthorizeGatewayRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AuthorizeGatewayRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AuthorizeGatewayRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AuthorizeGatewayRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AuthorizeGatewayRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AuthorizeGatewayRequestValidationError) ErrorName() string {
	return "AuthorizeGatewayRequestValidationError"
}

// Error satisfies the builtin error interface
func (e AuthorizeGatewayRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAuthorizeGatewayRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AuthorizeGatewayRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AuthorizeGatewayRequestValidationError{}

// ValidateFields checks the field values on GetInfoByGatewayEUIRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *GetInfoByGatewayEUIRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetInfoByGatewayEUIRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "eui":

			if len(m.GetEui()) > 0 {

				if len(m.GetEui()) != 8 {
					return GetInfoByGatewayEUIRequestValidationError{
						field:  "eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		default:
			return GetInfoByGatewayEUIRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetInfoByGatewayEUIRequestValidationError is the validation error returned
// by GetInfoByGatewayEUIRequest.ValidateFields if the designated constraints
// aren't met.
type GetInfoByGatewayEUIRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetInfoByGatewayEUIRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetInfoByGatewayEUIRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetInfoByGatewayEUIRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetInfoByGatewayEUIRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetInfoByGatewayEUIRequestValidationError) ErrorName() string {
	return "GetInfoByGatewayEUIRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetInfoByGatewayEUIRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetInfoByGatewayEUIRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetInfoByGatewayEUIRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetInfoByGatewayEUIRequestValidationError{}

// ValidateFields checks the field values on GetInfoByGatewayEUIResponse with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *GetInfoByGatewayEUIResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetInfoByGatewayEUIResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "eui":

			if len(m.GetEui()) > 0 {

				if len(m.GetEui()) != 8 {
					return GetInfoByGatewayEUIResponseValidationError{
						field:  "eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		case "supports_claiming":
			// no validation rules for SupportsClaiming
		case "is_managed":
			// no validation rules for IsManaged
		default:
			return GetInfoByGatewayEUIResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetInfoByGatewayEUIResponseValidationError is the validation error returned
// by GetInfoByGatewayEUIResponse.ValidateFields if the designated constraints
// aren't met.
type GetInfoByGatewayEUIResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetInfoByGatewayEUIResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetInfoByGatewayEUIResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetInfoByGatewayEUIResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetInfoByGatewayEUIResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetInfoByGatewayEUIResponseValidationError) ErrorName() string {
	return "GetInfoByGatewayEUIResponseValidationError"
}

// Error satisfies the builtin error interface
func (e GetInfoByGatewayEUIResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetInfoByGatewayEUIResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetInfoByGatewayEUIResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetInfoByGatewayEUIResponseValidationError{}

// ValidateFields checks the field values on
// ClaimEndDeviceRequest_AuthenticatedIdentifiers with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *ClaimEndDeviceRequest_AuthenticatedIdentifiers) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ClaimEndDeviceRequest_AuthenticatedIdentifiersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "join_eui":

			if len(m.GetJoinEui()) > 0 {

				if len(m.GetJoinEui()) != 8 {
					return ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError{
						field:  "join_eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		case "dev_eui":

			if len(m.GetDevEui()) > 0 {

				if len(m.GetDevEui()) != 8 {
					return ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError{
						field:  "dev_eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		case "authentication_code":

			if !_ClaimEndDeviceRequest_AuthenticatedIdentifiers_AuthenticationCode_Pattern.MatchString(m.GetAuthenticationCode()) {
				return ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError{
					field:  "authentication_code",
					reason: "value does not match regex pattern \"^[A-Z0-9]{1,32}$\"",
				}
			}

		default:
			return ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError is the
// validation error returned by
// ClaimEndDeviceRequest_AuthenticatedIdentifiers.ValidateFields if the
// designated constraints aren't met.
type ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError) ErrorName() string {
	return "ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError"
}

// Error satisfies the builtin error interface
func (e ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sClaimEndDeviceRequest_AuthenticatedIdentifiers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ClaimEndDeviceRequest_AuthenticatedIdentifiersValidationError{}

var _ClaimEndDeviceRequest_AuthenticatedIdentifiers_AuthenticationCode_Pattern = regexp.MustCompile("^[A-Z0-9]{1,32}$")

// ValidateFields checks the field values on
// GetClaimStatusResponse_VendorSpecific with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *GetClaimStatusResponse_VendorSpecific) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetClaimStatusResponse_VendorSpecificFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "organization_unique_identifier":
			// no validation rules for OrganizationUniqueIdentifier
		case "data":

			if v, ok := interface{}(m.GetData()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetClaimStatusResponse_VendorSpecificValidationError{
						field:  "data",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetClaimStatusResponse_VendorSpecificValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetClaimStatusResponse_VendorSpecificValidationError is the validation error
// returned by GetClaimStatusResponse_VendorSpecific.ValidateFields if the
// designated constraints aren't met.
type GetClaimStatusResponse_VendorSpecificValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetClaimStatusResponse_VendorSpecificValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetClaimStatusResponse_VendorSpecificValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetClaimStatusResponse_VendorSpecificValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetClaimStatusResponse_VendorSpecificValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetClaimStatusResponse_VendorSpecificValidationError) ErrorName() string {
	return "GetClaimStatusResponse_VendorSpecificValidationError"
}

// Error satisfies the builtin error interface
func (e GetClaimStatusResponse_VendorSpecificValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetClaimStatusResponse_VendorSpecific.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetClaimStatusResponse_VendorSpecificValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetClaimStatusResponse_VendorSpecificValidationError{}

// ValidateFields checks the field values on CUPSRedirection_ClientTLS with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *CUPSRedirection_ClientTLS) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = CUPSRedirection_ClientTLSFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "cert":

			if len(m.GetCert()) > 8192 {
				return CUPSRedirection_ClientTLSValidationError{
					field:  "cert",
					reason: "value length must be at most 8192 bytes",
				}
			}

		case "key":

			if len(m.GetKey()) > 8192 {
				return CUPSRedirection_ClientTLSValidationError{
					field:  "key",
					reason: "value length must be at most 8192 bytes",
				}
			}

		default:
			return CUPSRedirection_ClientTLSValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// CUPSRedirection_ClientTLSValidationError is the validation error returned by
// CUPSRedirection_ClientTLS.ValidateFields if the designated constraints
// aren't met.
type CUPSRedirection_ClientTLSValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CUPSRedirection_ClientTLSValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CUPSRedirection_ClientTLSValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CUPSRedirection_ClientTLSValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CUPSRedirection_ClientTLSValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CUPSRedirection_ClientTLSValidationError) ErrorName() string {
	return "CUPSRedirection_ClientTLSValidationError"
}

// Error satisfies the builtin error interface
func (e CUPSRedirection_ClientTLSValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCUPSRedirection_ClientTLS.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CUPSRedirection_ClientTLSValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CUPSRedirection_ClientTLSValidationError{}

// ValidateFields checks the field values on
// ClaimGatewayRequest_AuthenticatedIdentifiers with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *ClaimGatewayRequest_AuthenticatedIdentifiers) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ClaimGatewayRequest_AuthenticatedIdentifiersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "gateway_eui":

			if len(m.GetGatewayEui()) > 0 {

				if len(m.GetGatewayEui()) != 8 {
					return ClaimGatewayRequest_AuthenticatedIdentifiersValidationError{
						field:  "gateway_eui",
						reason: "value length must be 8 bytes",
					}
				}

			}

		case "authentication_code":

			if len(m.GetAuthenticationCode()) > 2048 {
				return ClaimGatewayRequest_AuthenticatedIdentifiersValidationError{
					field:  "authentication_code",
					reason: "value length must be at most 2048 bytes",
				}
			}

		default:
			return ClaimGatewayRequest_AuthenticatedIdentifiersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ClaimGatewayRequest_AuthenticatedIdentifiersValidationError is the
// validation error returned by
// ClaimGatewayRequest_AuthenticatedIdentifiers.ValidateFields if the
// designated constraints aren't met.
type ClaimGatewayRequest_AuthenticatedIdentifiersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ClaimGatewayRequest_AuthenticatedIdentifiersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ClaimGatewayRequest_AuthenticatedIdentifiersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ClaimGatewayRequest_AuthenticatedIdentifiersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ClaimGatewayRequest_AuthenticatedIdentifiersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ClaimGatewayRequest_AuthenticatedIdentifiersValidationError) ErrorName() string {
	return "ClaimGatewayRequest_AuthenticatedIdentifiersValidationError"
}

// Error satisfies the builtin error interface
func (e ClaimGatewayRequest_AuthenticatedIdentifiersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sClaimGatewayRequest_AuthenticatedIdentifiers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ClaimGatewayRequest_AuthenticatedIdentifiersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ClaimGatewayRequest_AuthenticatedIdentifiersValidationError{}
