// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/deviceclaimingserver.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ClaimEndDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SourceDevice:
	//	*ClaimEndDeviceRequest_AuthenticatedIdentifiers_
	//	*ClaimEndDeviceRequest_QrCode
	SourceDevice isClaimEndDeviceRequest_SourceDevice `protobuf_oneof:"source_device"`
	// Application identifiers of the target end device.
	TargetApplicationIds *ApplicationIdentifiers `protobuf:"bytes,3,opt,name=target_application_ids,json=targetApplicationIds,proto3" json:"target_application_ids,omitempty"`
	// End device ID of the target end device. If empty, use the source device ID.
	TargetDeviceId string `protobuf:"bytes,4,opt,name=target_device_id,json=targetDeviceId,proto3" json:"target_device_id,omitempty"`
}

func (x *ClaimEndDeviceRequest) Reset() {
	*x = ClaimEndDeviceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClaimEndDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClaimEndDeviceRequest) ProtoMessage() {}

func (x *ClaimEndDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClaimEndDeviceRequest.ProtoReflect.Descriptor instead.
func (*ClaimEndDeviceRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{0}
}

func (m *ClaimEndDeviceRequest) GetSourceDevice() isClaimEndDeviceRequest_SourceDevice {
	if m != nil {
		return m.SourceDevice
	}
	return nil
}

func (x *ClaimEndDeviceRequest) GetAuthenticatedIdentifiers() *ClaimEndDeviceRequest_AuthenticatedIdentifiers {
	if x, ok := x.GetSourceDevice().(*ClaimEndDeviceRequest_AuthenticatedIdentifiers_); ok {
		return x.AuthenticatedIdentifiers
	}
	return nil
}

func (x *ClaimEndDeviceRequest) GetQrCode() []byte {
	if x, ok := x.GetSourceDevice().(*ClaimEndDeviceRequest_QrCode); ok {
		return x.QrCode
	}
	return nil
}

func (x *ClaimEndDeviceRequest) GetTargetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.TargetApplicationIds
	}
	return nil
}

func (x *ClaimEndDeviceRequest) GetTargetDeviceId() string {
	if x != nil {
		return x.TargetDeviceId
	}
	return ""
}

type isClaimEndDeviceRequest_SourceDevice interface {
	isClaimEndDeviceRequest_SourceDevice()
}

type ClaimEndDeviceRequest_AuthenticatedIdentifiers_ struct {
	// Authenticated identifiers.
	AuthenticatedIdentifiers *ClaimEndDeviceRequest_AuthenticatedIdentifiers `protobuf:"bytes,1,opt,name=authenticated_identifiers,json=authenticatedIdentifiers,proto3,oneof"`
}

type ClaimEndDeviceRequest_QrCode struct {
	// Raw QR code contents.
	QrCode []byte `protobuf:"bytes,2,opt,name=qr_code,json=qrCode,proto3,oneof"`
}

func (*ClaimEndDeviceRequest_AuthenticatedIdentifiers_) isClaimEndDeviceRequest_SourceDevice() {}

func (*ClaimEndDeviceRequest_QrCode) isClaimEndDeviceRequest_SourceDevice() {}

// DEPRECATED: Device claiming that transfers devices between applications is no longer supported and will be removed
// in a future version of The Things Stack.
type AuthorizeApplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	ApiKey         string                  `protobuf:"bytes,2,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty"`
}

func (x *AuthorizeApplicationRequest) Reset() {
	*x = AuthorizeApplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizeApplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizeApplicationRequest) ProtoMessage() {}

func (x *AuthorizeApplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizeApplicationRequest.ProtoReflect.Descriptor instead.
func (*AuthorizeApplicationRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{1}
}

func (x *AuthorizeApplicationRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *AuthorizeApplicationRequest) GetApiKey() string {
	if x != nil {
		return x.ApiKey
	}
	return ""
}

type GetInfoByJoinEUIRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JoinEui []byte `protobuf:"bytes,1,opt,name=join_eui,json=joinEui,proto3" json:"join_eui,omitempty"`
}

func (x *GetInfoByJoinEUIRequest) Reset() {
	*x = GetInfoByJoinEUIRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInfoByJoinEUIRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInfoByJoinEUIRequest) ProtoMessage() {}

func (x *GetInfoByJoinEUIRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInfoByJoinEUIRequest.ProtoReflect.Descriptor instead.
func (*GetInfoByJoinEUIRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{2}
}

func (x *GetInfoByJoinEUIRequest) GetJoinEui() []byte {
	if x != nil {
		return x.JoinEui
	}
	return nil
}

type GetInfoByJoinEUIResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JoinEui []byte `protobuf:"bytes,1,opt,name=join_eui,json=joinEui,proto3" json:"join_eui,omitempty"`
	// If set, this Join EUI is available for claiming on one of the configured Join Servers.
	SupportsClaiming bool `protobuf:"varint,2,opt,name=supports_claiming,json=supportsClaiming,proto3" json:"supports_claiming,omitempty"`
}

func (x *GetInfoByJoinEUIResponse) Reset() {
	*x = GetInfoByJoinEUIResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInfoByJoinEUIResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInfoByJoinEUIResponse) ProtoMessage() {}

func (x *GetInfoByJoinEUIResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInfoByJoinEUIResponse.ProtoReflect.Descriptor instead.
func (*GetInfoByJoinEUIResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{3}
}

func (x *GetInfoByJoinEUIResponse) GetJoinEui() []byte {
	if x != nil {
		return x.JoinEui
	}
	return nil
}

func (x *GetInfoByJoinEUIResponse) GetSupportsClaiming() bool {
	if x != nil {
		return x.SupportsClaiming
	}
	return false
}

type GetInfoByJoinEUIsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Requests []*GetInfoByJoinEUIRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *GetInfoByJoinEUIsRequest) Reset() {
	*x = GetInfoByJoinEUIsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInfoByJoinEUIsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInfoByJoinEUIsRequest) ProtoMessage() {}

func (x *GetInfoByJoinEUIsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInfoByJoinEUIsRequest.ProtoReflect.Descriptor instead.
func (*GetInfoByJoinEUIsRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{4}
}

func (x *GetInfoByJoinEUIsRequest) GetRequests() []*GetInfoByJoinEUIRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

type GetInfoByJoinEUIsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Infos []*GetInfoByJoinEUIResponse `protobuf:"bytes,1,rep,name=infos,proto3" json:"infos,omitempty"`
}

func (x *GetInfoByJoinEUIsResponse) Reset() {
	*x = GetInfoByJoinEUIsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInfoByJoinEUIsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInfoByJoinEUIsResponse) ProtoMessage() {}

func (x *GetInfoByJoinEUIsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInfoByJoinEUIsResponse.ProtoReflect.Descriptor instead.
func (*GetInfoByJoinEUIsResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{5}
}

func (x *GetInfoByJoinEUIsResponse) GetInfos() []*GetInfoByJoinEUIResponse {
	if x != nil {
		return x.Infos
	}
	return nil
}

type GetClaimStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EndDeviceIds   *EndDeviceIdentifiers                  `protobuf:"bytes,1,opt,name=end_device_ids,json=endDeviceIds,proto3" json:"end_device_ids,omitempty"`
	HomeNetId      []byte                                 `protobuf:"bytes,2,opt,name=home_net_id,json=homeNetId,proto3" json:"home_net_id,omitempty"`
	HomeNsId       []byte                                 `protobuf:"bytes,3,opt,name=home_ns_id,json=homeNsId,proto3" json:"home_ns_id,omitempty"`
	VendorSpecific *GetClaimStatusResponse_VendorSpecific `protobuf:"bytes,4,opt,name=vendor_specific,json=vendorSpecific,proto3" json:"vendor_specific,omitempty"`
}

func (x *GetClaimStatusResponse) Reset() {
	*x = GetClaimStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetClaimStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClaimStatusResponse) ProtoMessage() {}

func (x *GetClaimStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClaimStatusResponse.ProtoReflect.Descriptor instead.
func (*GetClaimStatusResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{6}
}

func (x *GetClaimStatusResponse) GetEndDeviceIds() *EndDeviceIdentifiers {
	if x != nil {
		return x.EndDeviceIds
	}
	return nil
}

func (x *GetClaimStatusResponse) GetHomeNetId() []byte {
	if x != nil {
		return x.HomeNetId
	}
	return nil
}

func (x *GetClaimStatusResponse) GetHomeNsId() []byte {
	if x != nil {
		return x.HomeNsId
	}
	return nil
}

func (x *GetClaimStatusResponse) GetVendorSpecific() *GetClaimStatusResponse_VendorSpecific {
	if x != nil {
		return x.VendorSpecific
	}
	return nil
}

type BatchUnclaimEndDevicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	DeviceIds      []string                `protobuf:"bytes,2,rep,name=device_ids,json=deviceIds,proto3" json:"device_ids,omitempty"`
}

func (x *BatchUnclaimEndDevicesRequest) Reset() {
	*x = BatchUnclaimEndDevicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUnclaimEndDevicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUnclaimEndDevicesRequest) ProtoMessage() {}

func (x *BatchUnclaimEndDevicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUnclaimEndDevicesRequest.ProtoReflect.Descriptor instead.
func (*BatchUnclaimEndDevicesRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{7}
}

func (x *BatchUnclaimEndDevicesRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *BatchUnclaimEndDevicesRequest) GetDeviceIds() []string {
	if x != nil {
		return x.DeviceIds
	}
	return nil
}

type BatchUnclaimEndDevicesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	// End devices that could not be unclaimed.
	// The key is the device ID.
	Failed map[string]*ErrorDetails `protobuf:"bytes,2,rep,name=failed,proto3" json:"failed,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BatchUnclaimEndDevicesResponse) Reset() {
	*x = BatchUnclaimEndDevicesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUnclaimEndDevicesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUnclaimEndDevicesResponse) ProtoMessage() {}

func (x *BatchUnclaimEndDevicesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUnclaimEndDevicesResponse.ProtoReflect.Descriptor instead.
func (*BatchUnclaimEndDevicesResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{8}
}

func (x *BatchUnclaimEndDevicesResponse) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *BatchUnclaimEndDevicesResponse) GetFailed() map[string]*ErrorDetails {
	if x != nil {
		return x.Failed
	}
	return nil
}

// DEPRECATED: This message is deprecated and will be removed in a future version of The Things Stack.
//
// Deprecated: Marked as deprecated in ttn/lorawan/v3/deviceclaimingserver.proto.
type CUPSRedirection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CUPS URI for LoRa Basics Station CUPS redirection.
	TargetCupsUri string `protobuf:"bytes,1,opt,name=target_cups_uri,json=targetCupsUri,proto3" json:"target_cups_uri,omitempty"`
	// The key set in the gateway to authenticate itself.
	CurrentGatewayKey string `protobuf:"bytes,2,opt,name=current_gateway_key,json=currentGatewayKey,proto3" json:"current_gateway_key,omitempty"`
	// Optional PEM encoded CA Root certificate. If this field is empty, DCS will attempt to dial the Target CUPS server and fetch the CA.
	TargetCupsTrust []byte `protobuf:"bytes,3,opt,name=target_cups_trust,json=targetCupsTrust,proto3" json:"target_cups_trust,omitempty"`
	// CUPS Credentials for the gateway.
	//
	// Types that are assignable to GatewayCredentials:
	//	*CUPSRedirection_ClientTls
	//	*CUPSRedirection_AuthToken
	GatewayCredentials isCUPSRedirection_GatewayCredentials `protobuf_oneof:"gateway_credentials"`
}

func (x *CUPSRedirection) Reset() {
	*x = CUPSRedirection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CUPSRedirection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CUPSRedirection) ProtoMessage() {}

func (x *CUPSRedirection) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CUPSRedirection.ProtoReflect.Descriptor instead.
func (*CUPSRedirection) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{9}
}

func (x *CUPSRedirection) GetTargetCupsUri() string {
	if x != nil {
		return x.TargetCupsUri
	}
	return ""
}

func (x *CUPSRedirection) GetCurrentGatewayKey() string {
	if x != nil {
		return x.CurrentGatewayKey
	}
	return ""
}

func (x *CUPSRedirection) GetTargetCupsTrust() []byte {
	if x != nil {
		return x.TargetCupsTrust
	}
	return nil
}

func (m *CUPSRedirection) GetGatewayCredentials() isCUPSRedirection_GatewayCredentials {
	if m != nil {
		return m.GatewayCredentials
	}
	return nil
}

func (x *CUPSRedirection) GetClientTls() *CUPSRedirection_ClientTLS {
	if x, ok := x.GetGatewayCredentials().(*CUPSRedirection_ClientTls); ok {
		return x.ClientTls
	}
	return nil
}

func (x *CUPSRedirection) GetAuthToken() string {
	if x, ok := x.GetGatewayCredentials().(*CUPSRedirection_AuthToken); ok {
		return x.AuthToken
	}
	return ""
}

type isCUPSRedirection_GatewayCredentials interface {
	isCUPSRedirection_GatewayCredentials()
}

type CUPSRedirection_ClientTls struct {
	// TODO: Support mTLS (https://github.com/TheThingsNetwork/lorawan-stack/issues/137)
	ClientTls *CUPSRedirection_ClientTLS `protobuf:"bytes,4,opt,name=client_tls,json=clientTls,proto3,oneof"`
}

type CUPSRedirection_AuthToken struct {
	// The Device Claiming Server will fill this field with a The Things Stack API Key.
	AuthToken string `protobuf:"bytes,5,opt,name=auth_token,json=authToken,proto3,oneof"`
}

func (*CUPSRedirection_ClientTls) isCUPSRedirection_GatewayCredentials() {}

func (*CUPSRedirection_AuthToken) isCUPSRedirection_GatewayCredentials() {}

type ClaimGatewayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SourceGateway:
	//	*ClaimGatewayRequest_AuthenticatedIdentifiers_
	//	*ClaimGatewayRequest_QrCode
	SourceGateway isClaimGatewayRequest_SourceGateway `protobuf_oneof:"source_gateway"`
	// Collaborator to grant all rights on the target gateway.
	Collaborator *OrganizationOrUserIdentifiers `protobuf:"bytes,3,opt,name=collaborator,proto3" json:"collaborator,omitempty"`
	// Gateway ID for the target gateway. This must be a unique value.
	// If this is not set, the target ID for the target gateway will be set to `<gateway-eui>`.
	TargetGatewayId string `protobuf:"bytes,4,opt,name=target_gateway_id,json=targetGatewayId,proto3" json:"target_gateway_id,omitempty"`
	// Target Gateway Server Address for the target gateway.
	TargetGatewayServerAddress string `protobuf:"bytes,5,opt,name=target_gateway_server_address,json=targetGatewayServerAddress,proto3" json:"target_gateway_server_address,omitempty"`
	// Parameters to set CUPS redirection for the gateway.
	// DEPRECATED: This field is deprecated and will be removed in a future version of The Things Stack.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/deviceclaimingserver.proto.
	CupsRedirection *CUPSRedirection `protobuf:"bytes,6,opt,name=cups_redirection,json=cupsRedirection,proto3" json:"cups_redirection,omitempty"`
	// Frequency plan ID of the target gateway.
	// TODO: Remove this field (https://github.com/TheThingsIndustries/lorawan-stack/issues/4024)
	// DEPRECATED: Use target_frequency_plan_ids instead.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/deviceclaimingserver.proto.
	TargetFrequencyPlanId string `protobuf:"bytes,7,opt,name=target_frequency_plan_id,json=targetFrequencyPlanId,proto3" json:"target_frequency_plan_id,omitempty"`
	// Frequency plan IDs of the target gateway.
	TargetFrequencyPlanIds []string `protobuf:"bytes,8,rep,name=target_frequency_plan_ids,json=targetFrequencyPlanIds,proto3" json:"target_frequency_plan_ids,omitempty"`
}

func (x *ClaimGatewayRequest) Reset() {
	*x = ClaimGatewayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClaimGatewayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClaimGatewayRequest) ProtoMessage() {}

func (x *ClaimGatewayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClaimGatewayRequest.ProtoReflect.Descriptor instead.
func (*ClaimGatewayRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{10}
}

func (m *ClaimGatewayRequest) GetSourceGateway() isClaimGatewayRequest_SourceGateway {
	if m != nil {
		return m.SourceGateway
	}
	return nil
}

func (x *ClaimGatewayRequest) GetAuthenticatedIdentifiers() *ClaimGatewayRequest_AuthenticatedIdentifiers {
	if x, ok := x.GetSourceGateway().(*ClaimGatewayRequest_AuthenticatedIdentifiers_); ok {
		return x.AuthenticatedIdentifiers
	}
	return nil
}

func (x *ClaimGatewayRequest) GetQrCode() []byte {
	if x, ok := x.GetSourceGateway().(*ClaimGatewayRequest_QrCode); ok {
		return x.QrCode
	}
	return nil
}

func (x *ClaimGatewayRequest) GetCollaborator() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.Collaborator
	}
	return nil
}

func (x *ClaimGatewayRequest) GetTargetGatewayId() string {
	if x != nil {
		return x.TargetGatewayId
	}
	return ""
}

func (x *ClaimGatewayRequest) GetTargetGatewayServerAddress() string {
	if x != nil {
		return x.TargetGatewayServerAddress
	}
	return ""
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/deviceclaimingserver.proto.
func (x *ClaimGatewayRequest) GetCupsRedirection() *CUPSRedirection {
	if x != nil {
		return x.CupsRedirection
	}
	return nil
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/deviceclaimingserver.proto.
func (x *ClaimGatewayRequest) GetTargetFrequencyPlanId() string {
	if x != nil {
		return x.TargetFrequencyPlanId
	}
	return ""
}

func (x *ClaimGatewayRequest) GetTargetFrequencyPlanIds() []string {
	if x != nil {
		return x.TargetFrequencyPlanIds
	}
	return nil
}

type isClaimGatewayRequest_SourceGateway interface {
	isClaimGatewayRequest_SourceGateway()
}

type ClaimGatewayRequest_AuthenticatedIdentifiers_ struct {
	AuthenticatedIdentifiers *ClaimGatewayRequest_AuthenticatedIdentifiers `protobuf:"bytes,1,opt,name=authenticated_identifiers,json=authenticatedIdentifiers,proto3,oneof"`
}

type ClaimGatewayRequest_QrCode struct {
	QrCode []byte `protobuf:"bytes,2,opt,name=qr_code,json=qrCode,proto3,oneof"`
}

func (*ClaimGatewayRequest_AuthenticatedIdentifiers_) isClaimGatewayRequest_SourceGateway() {}

func (*ClaimGatewayRequest_QrCode) isClaimGatewayRequest_SourceGateway() {}

type AuthorizeGatewayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayIds *GatewayIdentifiers `protobuf:"bytes,1,opt,name=gateway_ids,json=gatewayIds,proto3" json:"gateway_ids,omitempty"`
	ApiKey     string              `protobuf:"bytes,2,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty"`
}

func (x *AuthorizeGatewayRequest) Reset() {
	*x = AuthorizeGatewayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizeGatewayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizeGatewayRequest) ProtoMessage() {}

func (x *AuthorizeGatewayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizeGatewayRequest.ProtoReflect.Descriptor instead.
func (*AuthorizeGatewayRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{11}
}

func (x *AuthorizeGatewayRequest) GetGatewayIds() *GatewayIdentifiers {
	if x != nil {
		return x.GatewayIds
	}
	return nil
}

func (x *AuthorizeGatewayRequest) GetApiKey() string {
	if x != nil {
		return x.ApiKey
	}
	return ""
}

type GetInfoByGatewayEUIRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Eui []byte `protobuf:"bytes,1,opt,name=eui,proto3" json:"eui,omitempty"`
}

func (x *GetInfoByGatewayEUIRequest) Reset() {
	*x = GetInfoByGatewayEUIRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInfoByGatewayEUIRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInfoByGatewayEUIRequest) ProtoMessage() {}

func (x *GetInfoByGatewayEUIRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInfoByGatewayEUIRequest.ProtoReflect.Descriptor instead.
func (*GetInfoByGatewayEUIRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{12}
}

func (x *GetInfoByGatewayEUIRequest) GetEui() []byte {
	if x != nil {
		return x.Eui
	}
	return nil
}

type GetInfoByGatewayEUIResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Eui              []byte `protobuf:"bytes,1,opt,name=eui,proto3" json:"eui,omitempty"`
	SupportsClaiming bool   `protobuf:"varint,2,opt,name=supports_claiming,json=supportsClaiming,proto3" json:"supports_claiming,omitempty"`
	// Indicates whether the gateway is a managed gateway.
	// If true, when the gateway is successfully claimed, it can be managed with ManagedGatewayConfigurationService.
	IsManaged bool `protobuf:"varint,3,opt,name=is_managed,json=isManaged,proto3" json:"is_managed,omitempty"`
}

func (x *GetInfoByGatewayEUIResponse) Reset() {
	*x = GetInfoByGatewayEUIResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInfoByGatewayEUIResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInfoByGatewayEUIResponse) ProtoMessage() {}

func (x *GetInfoByGatewayEUIResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInfoByGatewayEUIResponse.ProtoReflect.Descriptor instead.
func (*GetInfoByGatewayEUIResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{13}
}

func (x *GetInfoByGatewayEUIResponse) GetEui() []byte {
	if x != nil {
		return x.Eui
	}
	return nil
}

func (x *GetInfoByGatewayEUIResponse) GetSupportsClaiming() bool {
	if x != nil {
		return x.SupportsClaiming
	}
	return false
}

func (x *GetInfoByGatewayEUIResponse) GetIsManaged() bool {
	if x != nil {
		return x.IsManaged
	}
	return false
}

type ClaimEndDeviceRequest_AuthenticatedIdentifiers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// JoinEUI (or AppEUI) of the device to claim.
	JoinEui []byte `protobuf:"bytes,1,opt,name=join_eui,json=joinEui,proto3" json:"join_eui,omitempty"`
	// DevEUI of the device to claim.
	DevEui []byte `protobuf:"bytes,2,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Authentication code to prove ownership.
	// In the LoRa Alliance TR005 specification, this equals the OwnerToken.
	AuthenticationCode string `protobuf:"bytes,3,opt,name=authentication_code,json=authenticationCode,proto3" json:"authentication_code,omitempty"`
}

func (x *ClaimEndDeviceRequest_AuthenticatedIdentifiers) Reset() {
	*x = ClaimEndDeviceRequest_AuthenticatedIdentifiers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClaimEndDeviceRequest_AuthenticatedIdentifiers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClaimEndDeviceRequest_AuthenticatedIdentifiers) ProtoMessage() {}

func (x *ClaimEndDeviceRequest_AuthenticatedIdentifiers) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClaimEndDeviceRequest_AuthenticatedIdentifiers.ProtoReflect.Descriptor instead.
func (*ClaimEndDeviceRequest_AuthenticatedIdentifiers) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ClaimEndDeviceRequest_AuthenticatedIdentifiers) GetJoinEui() []byte {
	if x != nil {
		return x.JoinEui
	}
	return nil
}

func (x *ClaimEndDeviceRequest_AuthenticatedIdentifiers) GetDevEui() []byte {
	if x != nil {
		return x.DevEui
	}
	return nil
}

func (x *ClaimEndDeviceRequest_AuthenticatedIdentifiers) GetAuthenticationCode() string {
	if x != nil {
		return x.AuthenticationCode
	}
	return ""
}

type GetClaimStatusResponse_VendorSpecific struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	OrganizationUniqueIdentifier uint32 `protobuf:"varint,1,opt,name=organization_unique_identifier,json=organizationUniqueIdentifier,proto3" json:"organization_unique_identifier,omitempty"`
	// Vendor Specific data in JSON format.
	Data *structpb.Struct `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *GetClaimStatusResponse_VendorSpecific) Reset() {
	*x = GetClaimStatusResponse_VendorSpecific{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetClaimStatusResponse_VendorSpecific) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClaimStatusResponse_VendorSpecific) ProtoMessage() {}

func (x *GetClaimStatusResponse_VendorSpecific) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClaimStatusResponse_VendorSpecific.ProtoReflect.Descriptor instead.
func (*GetClaimStatusResponse_VendorSpecific) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{6, 0}
}

func (x *GetClaimStatusResponse_VendorSpecific) GetOrganizationUniqueIdentifier() uint32 {
	if x != nil {
		return x.OrganizationUniqueIdentifier
	}
	return 0
}

func (x *GetClaimStatusResponse_VendorSpecific) GetData() *structpb.Struct {
	if x != nil {
		return x.Data
	}
	return nil
}

type CUPSRedirection_ClientTLS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PEM encoded Client Certificate.
	Cert []byte `protobuf:"bytes,1,opt,name=cert,proto3" json:"cert,omitempty"`
	// PEM encoded Client Private Key.
	Key []byte `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *CUPSRedirection_ClientTLS) Reset() {
	*x = CUPSRedirection_ClientTLS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CUPSRedirection_ClientTLS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CUPSRedirection_ClientTLS) ProtoMessage() {}

func (x *CUPSRedirection_ClientTLS) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CUPSRedirection_ClientTLS.ProtoReflect.Descriptor instead.
func (*CUPSRedirection_ClientTLS) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{9, 0}
}

func (x *CUPSRedirection_ClientTLS) GetCert() []byte {
	if x != nil {
		return x.Cert
	}
	return nil
}

func (x *CUPSRedirection_ClientTLS) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

type ClaimGatewayRequest_AuthenticatedIdentifiers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GatewayEui         []byte `protobuf:"bytes,1,opt,name=gateway_eui,json=gatewayEui,proto3" json:"gateway_eui,omitempty"`
	AuthenticationCode []byte `protobuf:"bytes,2,opt,name=authentication_code,json=authenticationCode,proto3" json:"authentication_code,omitempty"`
}

func (x *ClaimGatewayRequest_AuthenticatedIdentifiers) Reset() {
	*x = ClaimGatewayRequest_AuthenticatedIdentifiers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClaimGatewayRequest_AuthenticatedIdentifiers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClaimGatewayRequest_AuthenticatedIdentifiers) ProtoMessage() {}

func (x *ClaimGatewayRequest_AuthenticatedIdentifiers) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClaimGatewayRequest_AuthenticatedIdentifiers.ProtoReflect.Descriptor instead.
func (*ClaimGatewayRequest_AuthenticatedIdentifiers) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP(), []int{10, 0}
}

func (x *ClaimGatewayRequest_AuthenticatedIdentifiers) GetGatewayEui() []byte {
	if x != nil {
		return x.GatewayEui
	}
	return nil
}

func (x *ClaimGatewayRequest_AuthenticatedIdentifiers) GetAuthenticationCode() []byte {
	if x != nil {
		return x.AuthenticationCode
	}
	return nil
}

var File_ttn_lorawan_v3_deviceclaimingserver_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDesc = []byte{
	0x0a, 0x29, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e,
	0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f,
	0x6a, 0x73, 0x6f, 0x6e, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f,
	0x76, 0x33, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd2, 0x07,
	0x0a, 0x15, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7d, 0x0a, 0x19, 0x61, 0x75, 0x74, 0x68, 0x65,
	0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6c, 0x61, 0x69,
	0x6d, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52, 0x18, 0x61, 0x75,
	0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x25, 0x0a, 0x07, 0x71, 0x72, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x0a, 0xfa, 0x42, 0x07, 0x7a, 0x05, 0x10, 0x00,
	0x18, 0x80, 0x08, 0x48, 0x00, 0x52, 0x06, 0x71, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x66, 0x0a,
	0x16, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x54, 0x0a, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xfa, 0x42, 0x27, 0x72, 0x25, 0x18, 0x24, 0x32, 0x21, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30,
	0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d,
	0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x7c, 0x5e, 0x24, 0x52, 0x0e, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x1a, 0x88, 0x04, 0x0a, 0x18,
	0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0xd0, 0x01, 0x0a, 0x08, 0x6a, 0x6f, 0x69,
	0x6e, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xb4, 0x01, 0x92, 0x41,
	0x21, 0x4a, 0x12, 0x22, 0x37, 0x30, 0x42, 0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30,
	0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01,
	0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x52, 0x07, 0x6a, 0x6f, 0x69, 0x6e, 0x45, 0x75, 0x69, 0x12, 0xce, 0x01, 0x0a, 0x07,
	0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xb4, 0x01,
	0x92, 0x41, 0x21, 0x4a, 0x12, 0x22, 0x37, 0x30, 0x42, 0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30,
	0x30, 0x30, 0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19,
	0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69, 0x12, 0x48, 0x0a, 0x13,
	0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x17, 0xfa, 0x42, 0x14, 0x72, 0x12,
	0x32, 0x10, 0x5e, 0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x7b, 0x31, 0x2c, 0x33, 0x32,
	0x7d, 0x24, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x14, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x4a, 0x04, 0x08, 0x05,
	0x10, 0x06, 0x4a, 0x04, 0x08, 0x06, 0x10, 0x07, 0x4a, 0x04, 0x08, 0x07, 0x10, 0x08, 0x4a, 0x04,
	0x08, 0x08, 0x10, 0x09, 0x4a, 0x04, 0x08, 0x09, 0x10, 0x0a, 0x4a, 0x04, 0x08, 0x0a, 0x10, 0x0b,
	0x4a, 0x04, 0x08, 0x0b, 0x10, 0x0c, 0x4a, 0x04, 0x08, 0x0c, 0x10, 0x0d, 0x4a, 0x04, 0x08, 0x0d,
	0x10, 0x0e, 0x22, 0x9d, 0x01, 0x0a, 0x1b, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x59, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0e, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x23, 0x0a,
	0x07, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a,
	0xfa, 0x42, 0x07, 0x72, 0x05, 0x10, 0x01, 0x18, 0x80, 0x01, 0x52, 0x06, 0x61, 0x70, 0x69, 0x4b,
	0x65, 0x79, 0x22, 0xec, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x79,
	0x4a, 0x6f, 0x69, 0x6e, 0x45, 0x55, 0x49, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0xd0,
	0x01, 0x0a, 0x08, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x42, 0xb4, 0x01, 0x92, 0x41, 0x21, 0x4a, 0x12, 0x22, 0x37, 0x30, 0x42, 0x33, 0x44, 0x35,
	0x37, 0x45, 0x44, 0x30, 0x30, 0x30, 0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2,
	0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x08, 0x70,
	0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b,
	0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48,
	0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70,
	0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68,
	0x61, 0x6c, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x07, 0x6a, 0x6f, 0x69, 0x6e, 0x45, 0x75,
	0x69, 0x22, 0x9a, 0x02, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x79, 0x4a,
	0x6f, 0x69, 0x6e, 0x45, 0x55, 0x49, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0xd0,
	0x01, 0x0a, 0x08, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x42, 0xb4, 0x01, 0x92, 0x41, 0x21, 0x4a, 0x12, 0x22, 0x37, 0x30, 0x42, 0x33, 0x44, 0x35,
	0x37, 0x45, 0x44, 0x30, 0x30, 0x30, 0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2,
	0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x08, 0x70,
	0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b,
	0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48,
	0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70,
	0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68,
	0x61, 0x6c, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x07, 0x6a, 0x6f, 0x69, 0x6e, 0x45, 0x75,
	0x69, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x63, 0x6c,
	0x61, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x22, 0x69,
	0x0a, 0x18, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x79, 0x4a, 0x6f, 0x69, 0x6e, 0x45,
	0x55, 0x49, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65,
	0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x79, 0x4a, 0x6f, 0x69, 0x6e, 0x45, 0x55, 0x49, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x14, 0x52,
	0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x5b, 0x0a, 0x19, 0x47, 0x65, 0x74,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x79, 0x4a, 0x6f, 0x69, 0x6e, 0x45, 0x55, 0x49, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x05, 0x69, 0x6e, 0x66, 0x6f, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x79,
	0x4a, 0x6f, 0x69, 0x6e, 0x45, 0x55, 0x49, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52,
	0x05, 0x69, 0x6e, 0x66, 0x6f, 0x73, 0x22, 0xf8, 0x05, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x6c,
	0x61, 0x69, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x54, 0x0a, 0x0e, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0xcb, 0x01, 0x0a, 0x0b, 0x68, 0x6f, 0x6d, 0x65,
	0x5f, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xaa, 0x01,
	0x92, 0x41, 0x17, 0x4a, 0x08, 0x22, 0x30, 0x30, 0x30, 0x30, 0x31, 0x33, 0x22, 0x9a, 0x02, 0x01,
	0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68,
	0x03, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65,
	0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f,
	0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61,
	0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68,
	0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33,
	0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72,
	0x73, 0x68, 0x61, 0x6c, 0x33, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x09, 0x68, 0x6f, 0x6d, 0x65,
	0x4e, 0x65, 0x74, 0x49, 0x64, 0x12, 0xd3, 0x01, 0x0a, 0x0a, 0x68, 0x6f, 0x6d, 0x65, 0x5f, 0x6e,
	0x73, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xb4, 0x01, 0x92, 0x41, 0x21,
	0x4a, 0x12, 0x22, 0x37, 0x30, 0x42, 0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30, 0x41,
	0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a,
	0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x52, 0x08, 0x68, 0x6f, 0x6d, 0x65, 0x4e, 0x73, 0x49, 0x64, 0x12, 0x5e, 0x0a, 0x0f, 0x76,
	0x65, 0x6e, 0x64, 0x6f, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x56, 0x65, 0x6e,
	0x64, 0x6f, 0x72, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x52, 0x0e, 0x76, 0x65, 0x6e,
	0x64, 0x6f, 0x72, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x1a, 0x83, 0x01, 0x0a, 0x0e,
	0x56, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x12, 0x44,
	0x0a, 0x1e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75,
	0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x1c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x04, 0x64, 0x61, 0x74,
	0x61, 0x22, 0xcb, 0x01, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x6e, 0x63, 0x6c, 0x61,
	0x69, 0x6d, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0e,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x4f,
	0x0a, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x30, 0xfa, 0x42, 0x2d, 0x92, 0x01, 0x2a, 0x08, 0x01, 0x10, 0x14, 0x22, 0x24,
	0x72, 0x22, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28,
	0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b,
	0x32, 0x2c, 0x7d, 0x24, 0x52, 0x09, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x22,
	0x9e, 0x02, 0x0a, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x6e, 0x63, 0x6c, 0x61, 0x69, 0x6d,
	0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x73, 0x12, 0x52, 0x0a, 0x06, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x6e, 0x63, 0x6c, 0x61, 0x69,
	0x6d, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x1a, 0x57, 0x0a, 0x0b, 0x46, 0x61, 0x69, 0x6c, 0x65,
	0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x32, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x8d, 0x03, 0x0a, 0x0f, 0x43, 0x55, 0x50, 0x53, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63,
	0x75, 0x70, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x13, 0xfa,
	0x42, 0x10, 0x72, 0x0e, 0x18, 0x80, 0x02, 0x32, 0x06, 0x5e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x88,
	0x01, 0x01, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x75, 0x70, 0x73, 0x55, 0x72,
	0x69, 0x12, 0x38, 0x0a, 0x13, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x72, 0x03, 0x18, 0x80, 0x10, 0x52, 0x11, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x2a, 0x0a, 0x11, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x75, 0x70, 0x73, 0x5f, 0x74, 0x72, 0x75, 0x73, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x75,
	0x70, 0x73, 0x54, 0x72, 0x75, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x55, 0x50,
	0x53, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x54, 0x4c, 0x53, 0x48, 0x00, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x54, 0x6c, 0x73, 0x12, 0x29, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x18, 0x80,
	0x10, 0x48, 0x00, 0x52, 0x09, 0x61, 0x75, 0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a, 0x45,
	0x0a, 0x09, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54, 0x4c, 0x53, 0x12, 0x1c, 0x0a, 0x04, 0x63,
	0x65, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x7a, 0x03,
	0x18, 0x80, 0x40, 0x52, 0x04, 0x63, 0x65, 0x72, 0x74, 0x12, 0x1a, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x7a, 0x03, 0x18, 0x80, 0x40,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x3a, 0x02, 0x18, 0x01, 0x42, 0x15, 0x0a, 0x13, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73,
	0x22, 0xec, 0x08, 0x0a, 0x13, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7b, 0x0a, 0x19, 0x61, 0x75, 0x74, 0x68,
	0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6c, 0x61,
	0x69, 0x6d, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52, 0x18, 0x61, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x25, 0x0a, 0x07, 0x71, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x0a, 0xfa, 0x42, 0x07, 0x7a, 0x05, 0x10, 0x00, 0x18,
	0x80, 0x08, 0x48, 0x00, 0x52, 0x06, 0x71, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x5b, 0x0a, 0x0c,
	0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x63, 0x6f, 0x6c,
	0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x56, 0x0a, 0x11, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x42, 0x27, 0x72, 0x25, 0x18, 0x24, 0x32, 0x21, 0x5e,
	0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b,
	0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x7c, 0x5e, 0x24,
	0x52, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49,
	0x64, 0x12, 0xd2, 0x01, 0x0a, 0x1d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x8e, 0x01, 0xfa, 0x42, 0x8a, 0x01,
	0x72, 0x87, 0x01, 0x32, 0x84, 0x01, 0x5e, 0x28, 0x3f, 0x3a, 0x28, 0x3f, 0x3a, 0x5b, 0x61, 0x2d,
	0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x7c, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a,
	0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5c, 0x2d,
	0x5d, 0x2a, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x5c, 0x2e,
	0x29, 0x2a, 0x28, 0x3f, 0x3a, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d,
	0x7c, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x41, 0x2d, 0x5a,
	0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5c, 0x2d, 0x5d, 0x2a, 0x5b, 0x41, 0x2d, 0x5a, 0x61, 0x2d,
	0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x28, 0x3f, 0x3a, 0x3a, 0x5b, 0x30, 0x2d, 0x39, 0x5d, 0x7b,
	0x31, 0x2c, 0x35, 0x7d, 0x29, 0x3f, 0x24, 0x7c, 0x5e, 0x24, 0x52, 0x1a, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x4e, 0x0a, 0x10, 0x63, 0x75, 0x70, 0x73, 0x5f, 0x72,
	0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x43, 0x55, 0x50, 0x53, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0f, 0x63, 0x75, 0x70, 0x73, 0x52, 0x65, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x18, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18,
	0x40, 0x18, 0x01, 0x52, 0x15, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x50, 0x6c, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x19, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x70,
	0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x42, 0x10, 0xfa,
	0x42, 0x0d, 0x92, 0x01, 0x0a, 0x08, 0x00, 0x10, 0x08, 0x22, 0x04, 0x72, 0x02, 0x18, 0x40, 0x52,
	0x16, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x50, 0x6c, 0x61, 0x6e, 0x49, 0x64, 0x73, 0x1a, 0xae, 0x02, 0x0a, 0x18, 0x41, 0x75, 0x74, 0x68,
	0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x12, 0xd6, 0x01, 0x0a, 0x0b, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xb4, 0x01, 0x92, 0x41, 0x21,
	0x4a, 0x12, 0x22, 0x37, 0x30, 0x42, 0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30, 0x41,
	0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a,
	0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x52, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x45, 0x75, 0x69, 0x12, 0x39, 0x0a,
	0x13, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x7a,
	0x03, 0x18, 0x80, 0x10, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x15, 0x0a, 0x0e, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x22,
	0x8a, 0x01, 0x0a, 0x17, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x73, 0x12, 0x20, 0x0a, 0x07, 0x61, 0x70,
	0x69, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04,
	0x72, 0x02, 0x10, 0x01, 0x52, 0x06, 0x61, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x22, 0xe6, 0x01, 0x0a,
	0x1a, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x79, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x45, 0x55, 0x49, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0xc7, 0x01, 0x0a, 0x03,
	0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0xb4, 0x01, 0x92, 0x41, 0x21, 0x4a,
	0x12, 0x22, 0x37, 0x30, 0x42, 0x33, 0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30, 0x41, 0x42,
	0x43, 0x44, 0x22, 0x9a, 0x02, 0x01, 0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68, 0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f,
	0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e,
	0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12,
	0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x52, 0x03, 0x65, 0x75, 0x69, 0x22, 0xb3, 0x02, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x42, 0x79, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x45, 0x55, 0x49, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0xc7, 0x01, 0x0a, 0x03, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x42, 0xb4, 0x01, 0x92, 0x41, 0x21, 0x4a, 0x12, 0x22, 0x37, 0x30, 0x42, 0x33,
	0x44, 0x35, 0x37, 0x45, 0x44, 0x30, 0x30, 0x30, 0x41, 0x42, 0x43, 0x44, 0x22, 0x9a, 0x02, 0x01,
	0x07, 0xa2, 0x02, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0xfa, 0x42, 0x06, 0x7a, 0x04, 0x68,
	0x08, 0x70, 0x01, 0xea, 0xaa, 0x19, 0x82, 0x01, 0x0a, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65,
	0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f,
	0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61,
	0x6c, 0x48, 0x45, 0x58, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3f, 0x67, 0x6f, 0x2e, 0x74, 0x68,
	0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33,
	0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x72,
	0x73, 0x68, 0x61, 0x6c, 0x38, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x03, 0x65, 0x75, 0x69, 0x12,
	0x2b, 0x0a, 0x11, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x63, 0x6c, 0x61, 0x69,
	0x6d, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x12, 0x1d, 0x0a, 0x0a,
	0x69, 0x73, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x09, 0x69, 0x73, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x32, 0xc2, 0x07, 0x0a, 0x17,
	0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x69, 0x6e,
	0x67, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x6c, 0x0a, 0x05, 0x43, 0x6c, 0x61, 0x69, 0x6d,
	0x12, 0x25, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x22, 0x16, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x10, 0x3a, 0x01, 0x2a, 0x22, 0x0b, 0x2f, 0x65, 0x64, 0x63, 0x73, 0x2f,
	0x63, 0x6c, 0x61, 0x69, 0x6d, 0x12, 0x91, 0x01, 0x0a, 0x07, 0x55, 0x6e, 0x63, 0x6c, 0x61, 0x69,
	0x6d, 0x12, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x2a, 0x40, 0x2f, 0x65, 0x64, 0x63, 0x73, 0x2f, 0x63,
	0x6c, 0x61, 0x69, 0x6d, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x82, 0x01, 0x0a, 0x10, 0x47, 0x65,
	0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x79, 0x4a, 0x6f, 0x69, 0x6e, 0x45, 0x55, 0x49, 0x12, 0x27,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x47, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x79, 0x4a, 0x6f, 0x69, 0x6e, 0x45, 0x55, 0x49,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x42, 0x79, 0x4a, 0x6f, 0x69, 0x6e, 0x45, 0x55, 0x49, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x1b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x15, 0x3a, 0x01, 0x2a, 0x22, 0x10, 0x2f, 0x65,
	0x64, 0x63, 0x73, 0x2f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x2f, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0xa8,
	0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x24, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x1a, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x61, 0x69,
	0x6d, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x65, 0x64, 0x63, 0x73, 0x2f, 0x63,
	0x6c, 0x61, 0x69, 0x6d, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0xa5, 0x01, 0x0a, 0x14, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a,
	0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x65, 0x64, 0x63, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x12, 0x8f, 0x01, 0x0a, 0x16, 0x55, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x35, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x65, 0x64, 0x63, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x1a, 0x3b, 0x92, 0x41, 0x38, 0x12, 0x36, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x20, 0x65, 0x6e, 0x64, 0x20, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x20, 0x6f, 0x6e, 0x20, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x20, 0x4a, 0x6f, 0x69, 0x6e, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x2e,
	0x32, 0xa3, 0x03, 0x0a, 0x1c, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x12, 0xac, 0x01, 0x0a, 0x07, 0x55, 0x6e, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x12, 0x2d, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x55, 0x6e, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x45, 0x6e, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x55, 0x6e, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x45, 0x6e, 0x64, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3c, 0x2a, 0x3a, 0x2f, 0x65, 0x64, 0x63, 0x73, 0x2f, 0x63, 0x6c, 0x61, 0x69,
	0x6d, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x12, 0x8b, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x79, 0x4a, 0x6f,
	0x69, 0x6e, 0x45, 0x55, 0x49, 0x73, 0x12, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42,
	0x79, 0x4a, 0x6f, 0x69, 0x6e, 0x45, 0x55, 0x49, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x79, 0x4a, 0x6f, 0x69, 0x6e, 0x45,
	0x55, 0x49, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x21, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x1b, 0x3a, 0x01, 0x2a, 0x22, 0x16, 0x2f, 0x65, 0x64, 0x63, 0x73, 0x2f, 0x63, 0x6c,
	0x61, 0x69, 0x6d, 0x2f, 0x69, 0x6e, 0x66, 0x6f, 0x2f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x1a, 0x46,
	0x92, 0x41, 0x43, 0x12, 0x41, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x20, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x20, 0x6f, 0x66,
	0x20, 0x65, 0x6e, 0x64, 0x20, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x20, 0x6f, 0x6e, 0x20,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x20, 0x4a, 0x6f, 0x69, 0x6e, 0x20, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x73, 0x2e, 0x32, 0xbc, 0x05, 0x0a, 0x15, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x12, 0x68, 0x0a, 0x05, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x12, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6c, 0x61, 0x69, 0x6d,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x73, 0x22, 0x16, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x10, 0x3a, 0x01, 0x2a, 0x22, 0x0b, 0x2f,
	0x67, 0x63, 0x6c, 0x73, 0x2f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x12, 0x67, 0x0a, 0x07, 0x55, 0x6e,
	0x63, 0x6c, 0x61, 0x69, 0x6d, 0x12, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x20, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1a, 0x2a, 0x18, 0x2f, 0x67, 0x63, 0x6c, 0x73,
	0x2f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x2f, 0x7b, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f,
	0x69, 0x64, 0x7d, 0x12, 0x8b, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42,
	0x79, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x45, 0x55, 0x49, 0x12, 0x2a, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x79, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x45, 0x55, 0x49,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x42, 0x79, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x45, 0x55, 0x49, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x15, 0x3a, 0x01, 0x2a, 0x22,
	0x10, 0x2f, 0x67, 0x63, 0x6c, 0x73, 0x2f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x2f, 0x69, 0x6e, 0x66,
	0x6f, 0x12, 0x94, 0x01, 0x0a, 0x10, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a,
	0x01, 0x2a, 0x22, 0x31, 0x2f, 0x67, 0x63, 0x6c, 0x73, 0x2f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x73, 0x2f, 0x7b, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x2e,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x88, 0x02, 0x01, 0x12, 0x82, 0x01, 0x0a, 0x12, 0x55, 0x6e, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12,
	0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x30, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x27, 0x2a, 0x25, 0x2f, 0x67, 0x63, 0x6c, 0x73, 0x2f, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x73, 0x2f, 0x7b, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x88, 0x02, 0x01, 0x1a, 0x26, 0x92,
	0x41, 0x23, 0x12, 0x21, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x20, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x20, 0x63, 0x6c,
	0x61, 0x69, 0x6d, 0x73, 0x2e, 0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70,
	0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescData = file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDesc
)

func file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDescData
}

var file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_ttn_lorawan_v3_deviceclaimingserver_proto_goTypes = []interface{}{
	(*ClaimEndDeviceRequest)(nil),                          // 0: ttn.lorawan.v3.ClaimEndDeviceRequest
	(*AuthorizeApplicationRequest)(nil),                    // 1: ttn.lorawan.v3.AuthorizeApplicationRequest
	(*GetInfoByJoinEUIRequest)(nil),                        // 2: ttn.lorawan.v3.GetInfoByJoinEUIRequest
	(*GetInfoByJoinEUIResponse)(nil),                       // 3: ttn.lorawan.v3.GetInfoByJoinEUIResponse
	(*GetInfoByJoinEUIsRequest)(nil),                       // 4: ttn.lorawan.v3.GetInfoByJoinEUIsRequest
	(*GetInfoByJoinEUIsResponse)(nil),                      // 5: ttn.lorawan.v3.GetInfoByJoinEUIsResponse
	(*GetClaimStatusResponse)(nil),                         // 6: ttn.lorawan.v3.GetClaimStatusResponse
	(*BatchUnclaimEndDevicesRequest)(nil),                  // 7: ttn.lorawan.v3.BatchUnclaimEndDevicesRequest
	(*BatchUnclaimEndDevicesResponse)(nil),                 // 8: ttn.lorawan.v3.BatchUnclaimEndDevicesResponse
	(*CUPSRedirection)(nil),                                // 9: ttn.lorawan.v3.CUPSRedirection
	(*ClaimGatewayRequest)(nil),                            // 10: ttn.lorawan.v3.ClaimGatewayRequest
	(*AuthorizeGatewayRequest)(nil),                        // 11: ttn.lorawan.v3.AuthorizeGatewayRequest
	(*GetInfoByGatewayEUIRequest)(nil),                     // 12: ttn.lorawan.v3.GetInfoByGatewayEUIRequest
	(*GetInfoByGatewayEUIResponse)(nil),                    // 13: ttn.lorawan.v3.GetInfoByGatewayEUIResponse
	(*ClaimEndDeviceRequest_AuthenticatedIdentifiers)(nil), // 14: ttn.lorawan.v3.ClaimEndDeviceRequest.AuthenticatedIdentifiers
	(*GetClaimStatusResponse_VendorSpecific)(nil),          // 15: ttn.lorawan.v3.GetClaimStatusResponse.VendorSpecific
	nil,                               // 16: ttn.lorawan.v3.BatchUnclaimEndDevicesResponse.FailedEntry
	(*CUPSRedirection_ClientTLS)(nil), // 17: ttn.lorawan.v3.CUPSRedirection.ClientTLS
	(*ClaimGatewayRequest_AuthenticatedIdentifiers)(nil), // 18: ttn.lorawan.v3.ClaimGatewayRequest.AuthenticatedIdentifiers
	(*ApplicationIdentifiers)(nil),                       // 19: ttn.lorawan.v3.ApplicationIdentifiers
	(*EndDeviceIdentifiers)(nil),                         // 20: ttn.lorawan.v3.EndDeviceIdentifiers
	(*OrganizationOrUserIdentifiers)(nil),                // 21: ttn.lorawan.v3.OrganizationOrUserIdentifiers
	(*GatewayIdentifiers)(nil),                           // 22: ttn.lorawan.v3.GatewayIdentifiers
	(*structpb.Struct)(nil),                              // 23: google.protobuf.Struct
	(*ErrorDetails)(nil),                                 // 24: ttn.lorawan.v3.ErrorDetails
	(*emptypb.Empty)(nil),                                // 25: google.protobuf.Empty
}
var file_ttn_lorawan_v3_deviceclaimingserver_proto_depIdxs = []int32{
	14, // 0: ttn.lorawan.v3.ClaimEndDeviceRequest.authenticated_identifiers:type_name -> ttn.lorawan.v3.ClaimEndDeviceRequest.AuthenticatedIdentifiers
	19, // 1: ttn.lorawan.v3.ClaimEndDeviceRequest.target_application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	19, // 2: ttn.lorawan.v3.AuthorizeApplicationRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	2,  // 3: ttn.lorawan.v3.GetInfoByJoinEUIsRequest.requests:type_name -> ttn.lorawan.v3.GetInfoByJoinEUIRequest
	3,  // 4: ttn.lorawan.v3.GetInfoByJoinEUIsResponse.infos:type_name -> ttn.lorawan.v3.GetInfoByJoinEUIResponse
	20, // 5: ttn.lorawan.v3.GetClaimStatusResponse.end_device_ids:type_name -> ttn.lorawan.v3.EndDeviceIdentifiers
	15, // 6: ttn.lorawan.v3.GetClaimStatusResponse.vendor_specific:type_name -> ttn.lorawan.v3.GetClaimStatusResponse.VendorSpecific
	19, // 7: ttn.lorawan.v3.BatchUnclaimEndDevicesRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	19, // 8: ttn.lorawan.v3.BatchUnclaimEndDevicesResponse.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	16, // 9: ttn.lorawan.v3.BatchUnclaimEndDevicesResponse.failed:type_name -> ttn.lorawan.v3.BatchUnclaimEndDevicesResponse.FailedEntry
	17, // 10: ttn.lorawan.v3.CUPSRedirection.client_tls:type_name -> ttn.lorawan.v3.CUPSRedirection.ClientTLS
	18, // 11: ttn.lorawan.v3.ClaimGatewayRequest.authenticated_identifiers:type_name -> ttn.lorawan.v3.ClaimGatewayRequest.AuthenticatedIdentifiers
	21, // 12: ttn.lorawan.v3.ClaimGatewayRequest.collaborator:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	9,  // 13: ttn.lorawan.v3.ClaimGatewayRequest.cups_redirection:type_name -> ttn.lorawan.v3.CUPSRedirection
	22, // 14: ttn.lorawan.v3.AuthorizeGatewayRequest.gateway_ids:type_name -> ttn.lorawan.v3.GatewayIdentifiers
	23, // 15: ttn.lorawan.v3.GetClaimStatusResponse.VendorSpecific.data:type_name -> google.protobuf.Struct
	24, // 16: ttn.lorawan.v3.BatchUnclaimEndDevicesResponse.FailedEntry.value:type_name -> ttn.lorawan.v3.ErrorDetails
	0,  // 17: ttn.lorawan.v3.EndDeviceClaimingServer.Claim:input_type -> ttn.lorawan.v3.ClaimEndDeviceRequest
	20, // 18: ttn.lorawan.v3.EndDeviceClaimingServer.Unclaim:input_type -> ttn.lorawan.v3.EndDeviceIdentifiers
	2,  // 19: ttn.lorawan.v3.EndDeviceClaimingServer.GetInfoByJoinEUI:input_type -> ttn.lorawan.v3.GetInfoByJoinEUIRequest
	20, // 20: ttn.lorawan.v3.EndDeviceClaimingServer.GetClaimStatus:input_type -> ttn.lorawan.v3.EndDeviceIdentifiers
	1,  // 21: ttn.lorawan.v3.EndDeviceClaimingServer.AuthorizeApplication:input_type -> ttn.lorawan.v3.AuthorizeApplicationRequest
	19, // 22: ttn.lorawan.v3.EndDeviceClaimingServer.UnauthorizeApplication:input_type -> ttn.lorawan.v3.ApplicationIdentifiers
	7,  // 23: ttn.lorawan.v3.EndDeviceBatchClaimingServer.Unclaim:input_type -> ttn.lorawan.v3.BatchUnclaimEndDevicesRequest
	4,  // 24: ttn.lorawan.v3.EndDeviceBatchClaimingServer.GetInfoByJoinEUIs:input_type -> ttn.lorawan.v3.GetInfoByJoinEUIsRequest
	10, // 25: ttn.lorawan.v3.GatewayClaimingServer.Claim:input_type -> ttn.lorawan.v3.ClaimGatewayRequest
	22, // 26: ttn.lorawan.v3.GatewayClaimingServer.Unclaim:input_type -> ttn.lorawan.v3.GatewayIdentifiers
	12, // 27: ttn.lorawan.v3.GatewayClaimingServer.GetInfoByGatewayEUI:input_type -> ttn.lorawan.v3.GetInfoByGatewayEUIRequest
	11, // 28: ttn.lorawan.v3.GatewayClaimingServer.AuthorizeGateway:input_type -> ttn.lorawan.v3.AuthorizeGatewayRequest
	22, // 29: ttn.lorawan.v3.GatewayClaimingServer.UnauthorizeGateway:input_type -> ttn.lorawan.v3.GatewayIdentifiers
	20, // 30: ttn.lorawan.v3.EndDeviceClaimingServer.Claim:output_type -> ttn.lorawan.v3.EndDeviceIdentifiers
	25, // 31: ttn.lorawan.v3.EndDeviceClaimingServer.Unclaim:output_type -> google.protobuf.Empty
	3,  // 32: ttn.lorawan.v3.EndDeviceClaimingServer.GetInfoByJoinEUI:output_type -> ttn.lorawan.v3.GetInfoByJoinEUIResponse
	6,  // 33: ttn.lorawan.v3.EndDeviceClaimingServer.GetClaimStatus:output_type -> ttn.lorawan.v3.GetClaimStatusResponse
	25, // 34: ttn.lorawan.v3.EndDeviceClaimingServer.AuthorizeApplication:output_type -> google.protobuf.Empty
	25, // 35: ttn.lorawan.v3.EndDeviceClaimingServer.UnauthorizeApplication:output_type -> google.protobuf.Empty
	8,  // 36: ttn.lorawan.v3.EndDeviceBatchClaimingServer.Unclaim:output_type -> ttn.lorawan.v3.BatchUnclaimEndDevicesResponse
	5,  // 37: ttn.lorawan.v3.EndDeviceBatchClaimingServer.GetInfoByJoinEUIs:output_type -> ttn.lorawan.v3.GetInfoByJoinEUIsResponse
	22, // 38: ttn.lorawan.v3.GatewayClaimingServer.Claim:output_type -> ttn.lorawan.v3.GatewayIdentifiers
	25, // 39: ttn.lorawan.v3.GatewayClaimingServer.Unclaim:output_type -> google.protobuf.Empty
	13, // 40: ttn.lorawan.v3.GatewayClaimingServer.GetInfoByGatewayEUI:output_type -> ttn.lorawan.v3.GetInfoByGatewayEUIResponse
	25, // 41: ttn.lorawan.v3.GatewayClaimingServer.AuthorizeGateway:output_type -> google.protobuf.Empty
	25, // 42: ttn.lorawan.v3.GatewayClaimingServer.UnauthorizeGateway:output_type -> google.protobuf.Empty
	30, // [30:43] is the sub-list for method output_type
	17, // [17:30] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_deviceclaimingserver_proto_init() }
func file_ttn_lorawan_v3_deviceclaimingserver_proto_init() {
	if File_ttn_lorawan_v3_deviceclaimingserver_proto != nil {
		return
	}
	file_ttn_lorawan_v3_error_proto_init()
	file_ttn_lorawan_v3_identifiers_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClaimEndDeviceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthorizeApplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInfoByJoinEUIRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInfoByJoinEUIResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInfoByJoinEUIsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInfoByJoinEUIsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetClaimStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUnclaimEndDevicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUnclaimEndDevicesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CUPSRedirection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClaimGatewayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthorizeGatewayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInfoByGatewayEUIRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInfoByGatewayEUIResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClaimEndDeviceRequest_AuthenticatedIdentifiers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetClaimStatusResponse_VendorSpecific); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CUPSRedirection_ClientTLS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClaimGatewayRequest_AuthenticatedIdentifiers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ClaimEndDeviceRequest_AuthenticatedIdentifiers_)(nil),
		(*ClaimEndDeviceRequest_QrCode)(nil),
	}
	file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*CUPSRedirection_ClientTls)(nil),
		(*CUPSRedirection_AuthToken)(nil),
	}
	file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*ClaimGatewayRequest_AuthenticatedIdentifiers_)(nil),
		(*ClaimGatewayRequest_QrCode)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   3,
		},
		GoTypes:           file_ttn_lorawan_v3_deviceclaimingserver_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_deviceclaimingserver_proto_depIdxs,
		MessageInfos:      file_ttn_lorawan_v3_deviceclaimingserver_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_deviceclaimingserver_proto = out.File
	file_ttn_lorawan_v3_deviceclaimingserver_proto_rawDesc = nil
	file_ttn_lorawan_v3_deviceclaimingserver_proto_goTypes = nil
	file_ttn_lorawan_v3_deviceclaimingserver_proto_depIdxs = nil
}
