// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.1
// source: ttn/lorawan/v3/contact_info.proto

package ttnpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ContactInfoRegistry_RequestValidation_FullMethodName = "/ttn.lorawan.v3.ContactInfoRegistry/RequestValidation"
	ContactInfoRegistry_Validate_FullMethodName          = "/ttn.lorawan.v3.ContactInfoRegistry/Validate"
)

// ContactInfoRegistryClient is the client API for ContactInfoRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ContactInfoRegistryClient interface {
	// Request validation for the non-validated contact info for the given entity.
	RequestValidation(ctx context.Context, in *EntityIdentifiers, opts ...grpc.CallOption) (*ContactInfoValidation, error)
	// Validate confirms a contact info validation.
	Validate(ctx context.Context, in *ContactInfoValidation, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type contactInfoRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewContactInfoRegistryClient(cc grpc.ClientConnInterface) ContactInfoRegistryClient {
	return &contactInfoRegistryClient{cc}
}

func (c *contactInfoRegistryClient) RequestValidation(ctx context.Context, in *EntityIdentifiers, opts ...grpc.CallOption) (*ContactInfoValidation, error) {
	out := new(ContactInfoValidation)
	err := c.cc.Invoke(ctx, ContactInfoRegistry_RequestValidation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contactInfoRegistryClient) Validate(ctx context.Context, in *ContactInfoValidation, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ContactInfoRegistry_Validate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ContactInfoRegistryServer is the server API for ContactInfoRegistry service.
// All implementations must embed UnimplementedContactInfoRegistryServer
// for forward compatibility
type ContactInfoRegistryServer interface {
	// Request validation for the non-validated contact info for the given entity.
	RequestValidation(context.Context, *EntityIdentifiers) (*ContactInfoValidation, error)
	// Validate confirms a contact info validation.
	Validate(context.Context, *ContactInfoValidation) (*emptypb.Empty, error)
	mustEmbedUnimplementedContactInfoRegistryServer()
}

// UnimplementedContactInfoRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedContactInfoRegistryServer struct {
}

func (UnimplementedContactInfoRegistryServer) RequestValidation(context.Context, *EntityIdentifiers) (*ContactInfoValidation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RequestValidation not implemented")
}
func (UnimplementedContactInfoRegistryServer) Validate(context.Context, *ContactInfoValidation) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Validate not implemented")
}
func (UnimplementedContactInfoRegistryServer) mustEmbedUnimplementedContactInfoRegistryServer() {}

// UnsafeContactInfoRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ContactInfoRegistryServer will
// result in compilation errors.
type UnsafeContactInfoRegistryServer interface {
	mustEmbedUnimplementedContactInfoRegistryServer()
}

func RegisterContactInfoRegistryServer(s grpc.ServiceRegistrar, srv ContactInfoRegistryServer) {
	s.RegisterService(&ContactInfoRegistry_ServiceDesc, srv)
}

func _ContactInfoRegistry_RequestValidation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EntityIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactInfoRegistryServer).RequestValidation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactInfoRegistry_RequestValidation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactInfoRegistryServer).RequestValidation(ctx, req.(*EntityIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContactInfoRegistry_Validate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContactInfoValidation)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContactInfoRegistryServer).Validate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContactInfoRegistry_Validate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContactInfoRegistryServer).Validate(ctx, req.(*ContactInfoValidation))
	}
	return interceptor(ctx, in, info, handler)
}

// ContactInfoRegistry_ServiceDesc is the grpc.ServiceDesc for ContactInfoRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ContactInfoRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.ContactInfoRegistry",
	HandlerType: (*ContactInfoRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RequestValidation",
			Handler:    _ContactInfoRegistry_RequestValidation_Handler,
		},
		{
			MethodName: "Validate",
			Handler:    _ContactInfoRegistry_Validate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/contact_info.proto",
}
