// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on ListFrequencyPlansRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ListFrequencyPlansRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListFrequencyPlansRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "base_frequency":
			// no validation rules for BaseFrequency
		case "band_id":
			// no validation rules for BandId
		case "gateways_only":
			// no validation rules for GatewaysOnly
		default:
			return ListFrequencyPlansRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListFrequencyPlansRequestValidationError is the validation error returned by
// ListFrequencyPlansRequest.ValidateFields if the designated constraints
// aren't met.
type ListFrequencyPlansRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListFrequencyPlansRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListFrequencyPlansRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListFrequencyPlansRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListFrequencyPlansRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListFrequencyPlansRequestValidationError) ErrorName() string {
	return "ListFrequencyPlansRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListFrequencyPlansRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListFrequencyPlansRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListFrequencyPlansRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListFrequencyPlansRequestValidationError{}

// ValidateFields checks the field values on FrequencyPlanDescription with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *FrequencyPlanDescription) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = FrequencyPlanDescriptionFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "id":
			// no validation rules for Id
		case "base_id":
			// no validation rules for BaseId
		case "name":
			// no validation rules for Name
		case "base_frequency":
			// no validation rules for BaseFrequency
		case "band_id":
			// no validation rules for BandId
		default:
			return FrequencyPlanDescriptionValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// FrequencyPlanDescriptionValidationError is the validation error returned by
// FrequencyPlanDescription.ValidateFields if the designated constraints
// aren't met.
type FrequencyPlanDescriptionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FrequencyPlanDescriptionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FrequencyPlanDescriptionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FrequencyPlanDescriptionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FrequencyPlanDescriptionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FrequencyPlanDescriptionValidationError) ErrorName() string {
	return "FrequencyPlanDescriptionValidationError"
}

// Error satisfies the builtin error interface
func (e FrequencyPlanDescriptionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFrequencyPlanDescription.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FrequencyPlanDescriptionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FrequencyPlanDescriptionValidationError{}

// ValidateFields checks the field values on ListFrequencyPlansResponse with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ListFrequencyPlansResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListFrequencyPlansResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "frequency_plans":

			for idx, item := range m.GetFrequencyPlans() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ListFrequencyPlansResponseValidationError{
							field:  fmt.Sprintf("frequency_plans[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ListFrequencyPlansResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListFrequencyPlansResponseValidationError is the validation error returned
// by ListFrequencyPlansResponse.ValidateFields if the designated constraints
// aren't met.
type ListFrequencyPlansResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListFrequencyPlansResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListFrequencyPlansResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListFrequencyPlansResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListFrequencyPlansResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListFrequencyPlansResponseValidationError) ErrorName() string {
	return "ListFrequencyPlansResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ListFrequencyPlansResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListFrequencyPlansResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListFrequencyPlansResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListFrequencyPlansResponseValidationError{}

// ValidateFields checks the field values on GetPhyVersionsRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetPhyVersionsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetPhyVersionsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "band_id":
			// no validation rules for BandId
		default:
			return GetPhyVersionsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetPhyVersionsRequestValidationError is the validation error returned by
// GetPhyVersionsRequest.ValidateFields if the designated constraints aren't met.
type GetPhyVersionsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetPhyVersionsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetPhyVersionsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetPhyVersionsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetPhyVersionsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetPhyVersionsRequestValidationError) ErrorName() string {
	return "GetPhyVersionsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetPhyVersionsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetPhyVersionsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetPhyVersionsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetPhyVersionsRequestValidationError{}

// ValidateFields checks the field values on GetPhyVersionsResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *GetPhyVersionsResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetPhyVersionsResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "version_info":

			for idx, item := range m.GetVersionInfo() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return GetPhyVersionsResponseValidationError{
							field:  fmt.Sprintf("version_info[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return GetPhyVersionsResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetPhyVersionsResponseValidationError is the validation error returned by
// GetPhyVersionsResponse.ValidateFields if the designated constraints aren't met.
type GetPhyVersionsResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetPhyVersionsResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetPhyVersionsResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetPhyVersionsResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetPhyVersionsResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetPhyVersionsResponseValidationError) ErrorName() string {
	return "GetPhyVersionsResponseValidationError"
}

// Error satisfies the builtin error interface
func (e GetPhyVersionsResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetPhyVersionsResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetPhyVersionsResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetPhyVersionsResponseValidationError{}

// ValidateFields checks the field values on ListBandsRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ListBandsRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListBandsRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "band_id":
			// no validation rules for BandId
		case "phy_version":

			if _, ok := PHYVersion_name[int32(m.GetPhyVersion())]; !ok {
				return ListBandsRequestValidationError{
					field:  "phy_version",
					reason: "value must be one of the defined enum values",
				}
			}

		default:
			return ListBandsRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListBandsRequestValidationError is the validation error returned by
// ListBandsRequest.ValidateFields if the designated constraints aren't met.
type ListBandsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListBandsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListBandsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListBandsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListBandsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListBandsRequestValidationError) ErrorName() string { return "ListBandsRequestValidationError" }

// Error satisfies the builtin error interface
func (e ListBandsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListBandsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListBandsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListBandsRequestValidationError{}

// ValidateFields checks the field values on BandDescription with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *BandDescription) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BandDescriptionFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "id":
			// no validation rules for Id
		case "beacon":

			if v, ok := interface{}(m.GetBeacon()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescriptionValidationError{
						field:  "beacon",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "ping_slot_frequencies":

		case "max_uplink_channels":
			// no validation rules for MaxUplinkChannels
		case "uplink_channels":

			for idx, item := range m.GetUplinkChannels() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return BandDescriptionValidationError{
							field:  fmt.Sprintf("uplink_channels[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "max_downlink_channels":
			// no validation rules for MaxDownlinkChannels
		case "downlink_channels":

			for idx, item := range m.GetDownlinkChannels() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return BandDescriptionValidationError{
							field:  fmt.Sprintf("downlink_channels[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "sub_bands":

			for idx, item := range m.GetSubBands() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return BandDescriptionValidationError{
							field:  fmt.Sprintf("sub_bands[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "data_rates":

			for key, val := range m.GetDataRates() {
				_ = val

				// no validation rules for DataRates[key]

				if v, ok := interface{}(val).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return BandDescriptionValidationError{
							field:  fmt.Sprintf("data_rates[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "freq_multiplier":
			// no validation rules for FreqMultiplier
		case "implements_cf_list":
			// no validation rules for ImplementsCfList
		case "cf_list_type":
			// no validation rules for CfListType
		case "receive_delay_1":

			if v, ok := interface{}(m.GetReceiveDelay_1()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescriptionValidationError{
						field:  "receive_delay_1",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "receive_delay_2":

			if v, ok := interface{}(m.GetReceiveDelay_2()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescriptionValidationError{
						field:  "receive_delay_2",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "join_accept_delay_1":

			if v, ok := interface{}(m.GetJoinAcceptDelay_1()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescriptionValidationError{
						field:  "join_accept_delay_1",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "join_accept_delay_2":

			if v, ok := interface{}(m.GetJoinAcceptDelay_2()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescriptionValidationError{
						field:  "join_accept_delay_2",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "max_fcnt_gap":
			// no validation rules for MaxFcntGap
		case "supports_dynamic_adr":
			// no validation rules for SupportsDynamicAdr
		case "adr_ack_limit":
			// no validation rules for AdrAckLimit
		case "min_retransmit_timeout":

			if v, ok := interface{}(m.GetMinRetransmitTimeout()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescriptionValidationError{
						field:  "min_retransmit_timeout",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "max_retransmit_timeout":

			if v, ok := interface{}(m.GetMaxRetransmitTimeout()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescriptionValidationError{
						field:  "max_retransmit_timeout",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "tx_offset":

		case "max_adr_data_rate_index":
			// no validation rules for MaxAdrDataRateIndex
		case "relay_forward_delay":

			if v, ok := interface{}(m.GetRelayForwardDelay()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescriptionValidationError{
						field:  "relay_forward_delay",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "relay_receive_delay":

			if v, ok := interface{}(m.GetRelayReceiveDelay()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescriptionValidationError{
						field:  "relay_receive_delay",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "tx_param_setup_req_support":
			// no validation rules for TxParamSetupReqSupport
		case "default_max_eirp":
			// no validation rules for DefaultMaxEirp
		case "default_rx2_parameters":

			if v, ok := interface{}(m.GetDefaultRx2Parameters()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescriptionValidationError{
						field:  "default_rx2_parameters",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "boot_dwell_time":

			if v, ok := interface{}(m.GetBootDwellTime()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescriptionValidationError{
						field:  "boot_dwell_time",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "relay":

			if v, ok := interface{}(m.GetRelay()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescriptionValidationError{
						field:  "relay",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return BandDescriptionValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BandDescriptionValidationError is the validation error returned by
// BandDescription.ValidateFields if the designated constraints aren't met.
type BandDescriptionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BandDescriptionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BandDescriptionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BandDescriptionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BandDescriptionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BandDescriptionValidationError) ErrorName() string { return "BandDescriptionValidationError" }

// Error satisfies the builtin error interface
func (e BandDescriptionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBandDescription.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BandDescriptionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BandDescriptionValidationError{}

// ValidateFields checks the field values on ListBandsResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ListBandsResponse) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListBandsResponseFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "descriptions":

			for key, val := range m.GetDescriptions() {
				_ = val

				// no validation rules for Descriptions[key]

				if v, ok := interface{}(val).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ListBandsResponseValidationError{
							field:  fmt.Sprintf("descriptions[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ListBandsResponseValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListBandsResponseValidationError is the validation error returned by
// ListBandsResponse.ValidateFields if the designated constraints aren't met.
type ListBandsResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListBandsResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListBandsResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListBandsResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListBandsResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListBandsResponseValidationError) ErrorName() string {
	return "ListBandsResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ListBandsResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListBandsResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListBandsResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListBandsResponseValidationError{}

// ValidateFields checks the field values on GetPhyVersionsResponse_VersionInfo
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *GetPhyVersionsResponse_VersionInfo) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetPhyVersionsResponse_VersionInfoFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "band_id":
			// no validation rules for BandId
		case "phy_versions":

		default:
			return GetPhyVersionsResponse_VersionInfoValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetPhyVersionsResponse_VersionInfoValidationError is the validation error
// returned by GetPhyVersionsResponse_VersionInfo.ValidateFields if the
// designated constraints aren't met.
type GetPhyVersionsResponse_VersionInfoValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetPhyVersionsResponse_VersionInfoValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetPhyVersionsResponse_VersionInfoValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetPhyVersionsResponse_VersionInfoValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetPhyVersionsResponse_VersionInfoValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetPhyVersionsResponse_VersionInfoValidationError) ErrorName() string {
	return "GetPhyVersionsResponse_VersionInfoValidationError"
}

// Error satisfies the builtin error interface
func (e GetPhyVersionsResponse_VersionInfoValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetPhyVersionsResponse_VersionInfo.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetPhyVersionsResponse_VersionInfoValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetPhyVersionsResponse_VersionInfoValidationError{}

// ValidateFields checks the field values on BandDescription_Beacon with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *BandDescription_Beacon) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BandDescription_BeaconFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "data_rate_index":
			// no validation rules for DataRateIndex
		case "coding_rate":
			// no validation rules for CodingRate
		case "frequencies":

		default:
			return BandDescription_BeaconValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BandDescription_BeaconValidationError is the validation error returned by
// BandDescription_Beacon.ValidateFields if the designated constraints aren't met.
type BandDescription_BeaconValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BandDescription_BeaconValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BandDescription_BeaconValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BandDescription_BeaconValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BandDescription_BeaconValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BandDescription_BeaconValidationError) ErrorName() string {
	return "BandDescription_BeaconValidationError"
}

// Error satisfies the builtin error interface
func (e BandDescription_BeaconValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBandDescription_Beacon.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BandDescription_BeaconValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BandDescription_BeaconValidationError{}

// ValidateFields checks the field values on BandDescription_Channel with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *BandDescription_Channel) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BandDescription_ChannelFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "frequency":
			// no validation rules for Frequency
		case "min_data_rate":
			// no validation rules for MinDataRate
		case "max_data_rate":
			// no validation rules for MaxDataRate
		default:
			return BandDescription_ChannelValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BandDescription_ChannelValidationError is the validation error returned by
// BandDescription_Channel.ValidateFields if the designated constraints aren't met.
type BandDescription_ChannelValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BandDescription_ChannelValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BandDescription_ChannelValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BandDescription_ChannelValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BandDescription_ChannelValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BandDescription_ChannelValidationError) ErrorName() string {
	return "BandDescription_ChannelValidationError"
}

// Error satisfies the builtin error interface
func (e BandDescription_ChannelValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBandDescription_Channel.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BandDescription_ChannelValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BandDescription_ChannelValidationError{}

// ValidateFields checks the field values on BandDescription_SubBandParameters
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *BandDescription_SubBandParameters) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BandDescription_SubBandParametersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "min_frequency":
			// no validation rules for MinFrequency
		case "max_frequency":
			// no validation rules for MaxFrequency
		case "duty_cycle":
			// no validation rules for DutyCycle
		case "max_eirp":
			// no validation rules for MaxEirp
		default:
			return BandDescription_SubBandParametersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BandDescription_SubBandParametersValidationError is the validation error
// returned by BandDescription_SubBandParameters.ValidateFields if the
// designated constraints aren't met.
type BandDescription_SubBandParametersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BandDescription_SubBandParametersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BandDescription_SubBandParametersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BandDescription_SubBandParametersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BandDescription_SubBandParametersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BandDescription_SubBandParametersValidationError) ErrorName() string {
	return "BandDescription_SubBandParametersValidationError"
}

// Error satisfies the builtin error interface
func (e BandDescription_SubBandParametersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBandDescription_SubBandParameters.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BandDescription_SubBandParametersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BandDescription_SubBandParametersValidationError{}

// ValidateFields checks the field values on BandDescription_BandDataRate with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *BandDescription_BandDataRate) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BandDescription_BandDataRateFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "rate":

			if v, ok := interface{}(m.GetRate()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescription_BandDataRateValidationError{
						field:  "rate",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return BandDescription_BandDataRateValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BandDescription_BandDataRateValidationError is the validation error returned
// by BandDescription_BandDataRate.ValidateFields if the designated
// constraints aren't met.
type BandDescription_BandDataRateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BandDescription_BandDataRateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BandDescription_BandDataRateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BandDescription_BandDataRateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BandDescription_BandDataRateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BandDescription_BandDataRateValidationError) ErrorName() string {
	return "BandDescription_BandDataRateValidationError"
}

// Error satisfies the builtin error interface
func (e BandDescription_BandDataRateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBandDescription_BandDataRate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BandDescription_BandDataRateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BandDescription_BandDataRateValidationError{}

// ValidateFields checks the field values on BandDescription_Rx2Parameters with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *BandDescription_Rx2Parameters) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BandDescription_Rx2ParametersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "data_rate_index":
			// no validation rules for DataRateIndex
		case "frequency":
			// no validation rules for Frequency
		default:
			return BandDescription_Rx2ParametersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BandDescription_Rx2ParametersValidationError is the validation error
// returned by BandDescription_Rx2Parameters.ValidateFields if the designated
// constraints aren't met.
type BandDescription_Rx2ParametersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BandDescription_Rx2ParametersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BandDescription_Rx2ParametersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BandDescription_Rx2ParametersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BandDescription_Rx2ParametersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BandDescription_Rx2ParametersValidationError) ErrorName() string {
	return "BandDescription_Rx2ParametersValidationError"
}

// Error satisfies the builtin error interface
func (e BandDescription_Rx2ParametersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBandDescription_Rx2Parameters.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BandDescription_Rx2ParametersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BandDescription_Rx2ParametersValidationError{}

// ValidateFields checks the field values on BandDescription_DwellTime with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *BandDescription_DwellTime) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BandDescription_DwellTimeFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "uplinks":

			if v, ok := interface{}(m.GetUplinks()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescription_DwellTimeValidationError{
						field:  "uplinks",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlinks":

			if v, ok := interface{}(m.GetDownlinks()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return BandDescription_DwellTimeValidationError{
						field:  "downlinks",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return BandDescription_DwellTimeValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BandDescription_DwellTimeValidationError is the validation error returned by
// BandDescription_DwellTime.ValidateFields if the designated constraints
// aren't met.
type BandDescription_DwellTimeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BandDescription_DwellTimeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BandDescription_DwellTimeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BandDescription_DwellTimeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BandDescription_DwellTimeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BandDescription_DwellTimeValidationError) ErrorName() string {
	return "BandDescription_DwellTimeValidationError"
}

// Error satisfies the builtin error interface
func (e BandDescription_DwellTimeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBandDescription_DwellTime.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BandDescription_DwellTimeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BandDescription_DwellTimeValidationError{}

// ValidateFields checks the field values on BandDescription_RelayParameters
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *BandDescription_RelayParameters) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BandDescription_RelayParametersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "wor_channels":

			for idx, item := range m.GetWorChannels() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return BandDescription_RelayParametersValidationError{
							field:  fmt.Sprintf("wor_channels[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return BandDescription_RelayParametersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BandDescription_RelayParametersValidationError is the validation error
// returned by BandDescription_RelayParameters.ValidateFields if the
// designated constraints aren't met.
type BandDescription_RelayParametersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BandDescription_RelayParametersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BandDescription_RelayParametersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BandDescription_RelayParametersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BandDescription_RelayParametersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BandDescription_RelayParametersValidationError) ErrorName() string {
	return "BandDescription_RelayParametersValidationError"
}

// Error satisfies the builtin error interface
func (e BandDescription_RelayParametersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBandDescription_RelayParameters.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BandDescription_RelayParametersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BandDescription_RelayParametersValidationError{}

// ValidateFields checks the field values on
// BandDescription_RelayParameters_RelayWORChannel with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *BandDescription_RelayParameters_RelayWORChannel) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = BandDescription_RelayParameters_RelayWORChannelFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "frequency":
			// no validation rules for Frequency
		case "ack_frequency":
			// no validation rules for AckFrequency
		case "data_rate_index":
			// no validation rules for DataRateIndex
		default:
			return BandDescription_RelayParameters_RelayWORChannelValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// BandDescription_RelayParameters_RelayWORChannelValidationError is the
// validation error returned by
// BandDescription_RelayParameters_RelayWORChannel.ValidateFields if the
// designated constraints aren't met.
type BandDescription_RelayParameters_RelayWORChannelValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BandDescription_RelayParameters_RelayWORChannelValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e BandDescription_RelayParameters_RelayWORChannelValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e BandDescription_RelayParameters_RelayWORChannelValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BandDescription_RelayParameters_RelayWORChannelValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BandDescription_RelayParameters_RelayWORChannelValidationError) ErrorName() string {
	return "BandDescription_RelayParameters_RelayWORChannelValidationError"
}

// Error satisfies the builtin error interface
func (e BandDescription_RelayParameters_RelayWORChannelValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBandDescription_RelayParameters_RelayWORChannel.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BandDescription_RelayParameters_RelayWORChannelValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BandDescription_RelayParameters_RelayWORChannelValidationError{}

// ValidateFields checks the field values on
// ListBandsResponse_VersionedBandDescription with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *ListBandsResponse_VersionedBandDescription) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListBandsResponse_VersionedBandDescriptionFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "band":

			for key, val := range m.GetBand() {
				_ = val

				// no validation rules for Band[key]

				if v, ok := interface{}(val).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ListBandsResponse_VersionedBandDescriptionValidationError{
							field:  fmt.Sprintf("band[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ListBandsResponse_VersionedBandDescriptionValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListBandsResponse_VersionedBandDescriptionValidationError is the validation
// error returned by ListBandsResponse_VersionedBandDescription.ValidateFields
// if the designated constraints aren't met.
type ListBandsResponse_VersionedBandDescriptionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListBandsResponse_VersionedBandDescriptionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListBandsResponse_VersionedBandDescriptionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListBandsResponse_VersionedBandDescriptionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListBandsResponse_VersionedBandDescriptionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListBandsResponse_VersionedBandDescriptionValidationError) ErrorName() string {
	return "ListBandsResponse_VersionedBandDescriptionValidationError"
}

// Error satisfies the builtin error interface
func (e ListBandsResponse_VersionedBandDescriptionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListBandsResponse_VersionedBandDescription.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListBandsResponse_VersionedBandDescriptionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListBandsResponse_VersionedBandDescriptionValidationError{}
