// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/configuration_services.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ListFrequencyPlansRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional base frequency in MHz for hardware support (433, 470, 868 or 915)
	BaseFrequency uint32 `protobuf:"varint,1,opt,name=base_frequency,json=baseFrequency,proto3" json:"base_frequency,omitempty"`
	// Optional Band ID to filter the results.
	BandId string `protobuf:"bytes,2,opt,name=band_id,json=bandId,proto3" json:"band_id,omitempty"`
	// Optional field to include only gateway related results.
	GatewaysOnly bool `protobuf:"varint,3,opt,name=gateways_only,json=gatewaysOnly,proto3" json:"gateways_only,omitempty"`
}

func (x *ListFrequencyPlansRequest) Reset() {
	*x = ListFrequencyPlansRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFrequencyPlansRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFrequencyPlansRequest) ProtoMessage() {}

func (x *ListFrequencyPlansRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFrequencyPlansRequest.ProtoReflect.Descriptor instead.
func (*ListFrequencyPlansRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{0}
}

func (x *ListFrequencyPlansRequest) GetBaseFrequency() uint32 {
	if x != nil {
		return x.BaseFrequency
	}
	return 0
}

func (x *ListFrequencyPlansRequest) GetBandId() string {
	if x != nil {
		return x.BandId
	}
	return ""
}

func (x *ListFrequencyPlansRequest) GetGatewaysOnly() bool {
	if x != nil {
		return x.GatewaysOnly
	}
	return false
}

type FrequencyPlanDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The ID of the frequency that the current frequency plan is based on.
	BaseId string `protobuf:"bytes,2,opt,name=base_id,json=baseId,proto3" json:"base_id,omitempty"`
	Name   string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Base frequency in MHz for hardware support (433, 470, 868 or 915)
	BaseFrequency uint32 `protobuf:"varint,4,opt,name=base_frequency,json=baseFrequency,proto3" json:"base_frequency,omitempty"`
	BandId        string `protobuf:"bytes,5,opt,name=band_id,json=bandId,proto3" json:"band_id,omitempty"`
}

func (x *FrequencyPlanDescription) Reset() {
	*x = FrequencyPlanDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FrequencyPlanDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FrequencyPlanDescription) ProtoMessage() {}

func (x *FrequencyPlanDescription) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FrequencyPlanDescription.ProtoReflect.Descriptor instead.
func (*FrequencyPlanDescription) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{1}
}

func (x *FrequencyPlanDescription) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *FrequencyPlanDescription) GetBaseId() string {
	if x != nil {
		return x.BaseId
	}
	return ""
}

func (x *FrequencyPlanDescription) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FrequencyPlanDescription) GetBaseFrequency() uint32 {
	if x != nil {
		return x.BaseFrequency
	}
	return 0
}

func (x *FrequencyPlanDescription) GetBandId() string {
	if x != nil {
		return x.BandId
	}
	return ""
}

type ListFrequencyPlansResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FrequencyPlans []*FrequencyPlanDescription `protobuf:"bytes,1,rep,name=frequency_plans,json=frequencyPlans,proto3" json:"frequency_plans,omitempty"`
}

func (x *ListFrequencyPlansResponse) Reset() {
	*x = ListFrequencyPlansResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFrequencyPlansResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFrequencyPlansResponse) ProtoMessage() {}

func (x *ListFrequencyPlansResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFrequencyPlansResponse.ProtoReflect.Descriptor instead.
func (*ListFrequencyPlansResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{2}
}

func (x *ListFrequencyPlansResponse) GetFrequencyPlans() []*FrequencyPlanDescription {
	if x != nil {
		return x.FrequencyPlans
	}
	return nil
}

type GetPhyVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional Band ID to filter the results.
	// If unused, all supported Bands and their versions are returned.
	BandId string `protobuf:"bytes,1,opt,name=band_id,json=bandId,proto3" json:"band_id,omitempty"`
}

func (x *GetPhyVersionsRequest) Reset() {
	*x = GetPhyVersionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPhyVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPhyVersionsRequest) ProtoMessage() {}

func (x *GetPhyVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPhyVersionsRequest.ProtoReflect.Descriptor instead.
func (*GetPhyVersionsRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{3}
}

func (x *GetPhyVersionsRequest) GetBandId() string {
	if x != nil {
		return x.BandId
	}
	return ""
}

type GetPhyVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	VersionInfo []*GetPhyVersionsResponse_VersionInfo `protobuf:"bytes,2,rep,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
}

func (x *GetPhyVersionsResponse) Reset() {
	*x = GetPhyVersionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPhyVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPhyVersionsResponse) ProtoMessage() {}

func (x *GetPhyVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPhyVersionsResponse.ProtoReflect.Descriptor instead.
func (*GetPhyVersionsResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{4}
}

func (x *GetPhyVersionsResponse) GetVersionInfo() []*GetPhyVersionsResponse_VersionInfo {
	if x != nil {
		return x.VersionInfo
	}
	return nil
}

type ListBandsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional Band ID to filter the results.
	// If unused, all supported Bands are returned.
	BandId string `protobuf:"bytes,1,opt,name=band_id,json=bandId,proto3" json:"band_id,omitempty"`
	// Optional PHY version to filter the results.
	// If unused, all supported versions are returned.
	PhyVersion PHYVersion `protobuf:"varint,2,opt,name=phy_version,json=phyVersion,proto3,enum=ttn.lorawan.v3.PHYVersion" json:"phy_version,omitempty"`
}

func (x *ListBandsRequest) Reset() {
	*x = ListBandsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBandsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBandsRequest) ProtoMessage() {}

func (x *ListBandsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBandsRequest.ProtoReflect.Descriptor instead.
func (*ListBandsRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{5}
}

func (x *ListBandsRequest) GetBandId() string {
	if x != nil {
		return x.BandId
	}
	return ""
}

func (x *ListBandsRequest) GetPhyVersion() PHYVersion {
	if x != nil {
		return x.PhyVersion
	}
	return PHYVersion_PHY_UNKNOWN
}

type BandDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id                     string                                   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Beacon                 *BandDescription_Beacon                  `protobuf:"bytes,2,opt,name=beacon,proto3" json:"beacon,omitempty"`
	PingSlotFrequencies    []uint64                                 `protobuf:"varint,32,rep,packed,name=ping_slot_frequencies,json=pingSlotFrequencies,proto3" json:"ping_slot_frequencies,omitempty"`
	MaxUplinkChannels      uint32                                   `protobuf:"varint,4,opt,name=max_uplink_channels,json=maxUplinkChannels,proto3" json:"max_uplink_channels,omitempty"`
	UplinkChannels         []*BandDescription_Channel               `protobuf:"bytes,5,rep,name=uplink_channels,json=uplinkChannels,proto3" json:"uplink_channels,omitempty"`
	MaxDownlinkChannels    uint32                                   `protobuf:"varint,6,opt,name=max_downlink_channels,json=maxDownlinkChannels,proto3" json:"max_downlink_channels,omitempty"`
	DownlinkChannels       []*BandDescription_Channel               `protobuf:"bytes,7,rep,name=downlink_channels,json=downlinkChannels,proto3" json:"downlink_channels,omitempty"`
	SubBands               []*BandDescription_SubBandParameters     `protobuf:"bytes,8,rep,name=sub_bands,json=subBands,proto3" json:"sub_bands,omitempty"`
	DataRates              map[uint32]*BandDescription_BandDataRate `protobuf:"bytes,9,rep,name=data_rates,json=dataRates,proto3" json:"data_rates,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	FreqMultiplier         uint64                                   `protobuf:"varint,10,opt,name=freq_multiplier,json=freqMultiplier,proto3" json:"freq_multiplier,omitempty"`
	ImplementsCfList       bool                                     `protobuf:"varint,11,opt,name=implements_cf_list,json=implementsCfList,proto3" json:"implements_cf_list,omitempty"`
	CfListType             CFListType                               `protobuf:"varint,12,opt,name=cf_list_type,json=cfListType,proto3,enum=ttn.lorawan.v3.CFListType" json:"cf_list_type,omitempty"`
	ReceiveDelay_1         *durationpb.Duration                     `protobuf:"bytes,13,opt,name=receive_delay_1,json=receiveDelay1,proto3" json:"receive_delay_1,omitempty"`
	ReceiveDelay_2         *durationpb.Duration                     `protobuf:"bytes,14,opt,name=receive_delay_2,json=receiveDelay2,proto3" json:"receive_delay_2,omitempty"`
	JoinAcceptDelay_1      *durationpb.Duration                     `protobuf:"bytes,15,opt,name=join_accept_delay_1,json=joinAcceptDelay1,proto3" json:"join_accept_delay_1,omitempty"`
	JoinAcceptDelay_2      *durationpb.Duration                     `protobuf:"bytes,16,opt,name=join_accept_delay_2,json=joinAcceptDelay2,proto3" json:"join_accept_delay_2,omitempty"`
	MaxFcntGap             uint64                                   `protobuf:"varint,17,opt,name=max_fcnt_gap,json=maxFcntGap,proto3" json:"max_fcnt_gap,omitempty"`
	SupportsDynamicAdr     bool                                     `protobuf:"varint,18,opt,name=supports_dynamic_adr,json=supportsDynamicAdr,proto3" json:"supports_dynamic_adr,omitempty"`
	AdrAckLimit            ADRAckLimitExponent                      `protobuf:"varint,19,opt,name=adr_ack_limit,json=adrAckLimit,proto3,enum=ttn.lorawan.v3.ADRAckLimitExponent" json:"adr_ack_limit,omitempty"`
	MinRetransmitTimeout   *durationpb.Duration                     `protobuf:"bytes,20,opt,name=min_retransmit_timeout,json=minRetransmitTimeout,proto3" json:"min_retransmit_timeout,omitempty"`
	MaxRetransmitTimeout   *durationpb.Duration                     `protobuf:"bytes,21,opt,name=max_retransmit_timeout,json=maxRetransmitTimeout,proto3" json:"max_retransmit_timeout,omitempty"`
	TxOffset               []float32                                `protobuf:"fixed32,22,rep,packed,name=tx_offset,json=txOffset,proto3" json:"tx_offset,omitempty"`
	MaxAdrDataRateIndex    DataRateIndex                            `protobuf:"varint,23,opt,name=max_adr_data_rate_index,json=maxAdrDataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"max_adr_data_rate_index,omitempty"`
	RelayForwardDelay      *durationpb.Duration                     `protobuf:"bytes,34,opt,name=relay_forward_delay,json=relayForwardDelay,proto3" json:"relay_forward_delay,omitempty"`
	RelayReceiveDelay      *durationpb.Duration                     `protobuf:"bytes,35,opt,name=relay_receive_delay,json=relayReceiveDelay,proto3" json:"relay_receive_delay,omitempty"`
	TxParamSetupReqSupport bool                                     `protobuf:"varint,24,opt,name=tx_param_setup_req_support,json=txParamSetupReqSupport,proto3" json:"tx_param_setup_req_support,omitempty"`
	DefaultMaxEirp         float32                                  `protobuf:"fixed32,25,opt,name=default_max_eirp,json=defaultMaxEirp,proto3" json:"default_max_eirp,omitempty"`
	DefaultRx2Parameters   *BandDescription_Rx2Parameters           `protobuf:"bytes,30,opt,name=default_rx2_parameters,json=defaultRx2Parameters,proto3" json:"default_rx2_parameters,omitempty"`
	BootDwellTime          *BandDescription_DwellTime               `protobuf:"bytes,31,opt,name=boot_dwell_time,json=bootDwellTime,proto3" json:"boot_dwell_time,omitempty"`
	Relay                  *BandDescription_RelayParameters         `protobuf:"bytes,33,opt,name=relay,proto3" json:"relay,omitempty"`
}

func (x *BandDescription) Reset() {
	*x = BandDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BandDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BandDescription) ProtoMessage() {}

func (x *BandDescription) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BandDescription.ProtoReflect.Descriptor instead.
func (*BandDescription) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{6}
}

func (x *BandDescription) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *BandDescription) GetBeacon() *BandDescription_Beacon {
	if x != nil {
		return x.Beacon
	}
	return nil
}

func (x *BandDescription) GetPingSlotFrequencies() []uint64 {
	if x != nil {
		return x.PingSlotFrequencies
	}
	return nil
}

func (x *BandDescription) GetMaxUplinkChannels() uint32 {
	if x != nil {
		return x.MaxUplinkChannels
	}
	return 0
}

func (x *BandDescription) GetUplinkChannels() []*BandDescription_Channel {
	if x != nil {
		return x.UplinkChannels
	}
	return nil
}

func (x *BandDescription) GetMaxDownlinkChannels() uint32 {
	if x != nil {
		return x.MaxDownlinkChannels
	}
	return 0
}

func (x *BandDescription) GetDownlinkChannels() []*BandDescription_Channel {
	if x != nil {
		return x.DownlinkChannels
	}
	return nil
}

func (x *BandDescription) GetSubBands() []*BandDescription_SubBandParameters {
	if x != nil {
		return x.SubBands
	}
	return nil
}

func (x *BandDescription) GetDataRates() map[uint32]*BandDescription_BandDataRate {
	if x != nil {
		return x.DataRates
	}
	return nil
}

func (x *BandDescription) GetFreqMultiplier() uint64 {
	if x != nil {
		return x.FreqMultiplier
	}
	return 0
}

func (x *BandDescription) GetImplementsCfList() bool {
	if x != nil {
		return x.ImplementsCfList
	}
	return false
}

func (x *BandDescription) GetCfListType() CFListType {
	if x != nil {
		return x.CfListType
	}
	return CFListType_FREQUENCIES
}

func (x *BandDescription) GetReceiveDelay_1() *durationpb.Duration {
	if x != nil {
		return x.ReceiveDelay_1
	}
	return nil
}

func (x *BandDescription) GetReceiveDelay_2() *durationpb.Duration {
	if x != nil {
		return x.ReceiveDelay_2
	}
	return nil
}

func (x *BandDescription) GetJoinAcceptDelay_1() *durationpb.Duration {
	if x != nil {
		return x.JoinAcceptDelay_1
	}
	return nil
}

func (x *BandDescription) GetJoinAcceptDelay_2() *durationpb.Duration {
	if x != nil {
		return x.JoinAcceptDelay_2
	}
	return nil
}

func (x *BandDescription) GetMaxFcntGap() uint64 {
	if x != nil {
		return x.MaxFcntGap
	}
	return 0
}

func (x *BandDescription) GetSupportsDynamicAdr() bool {
	if x != nil {
		return x.SupportsDynamicAdr
	}
	return false
}

func (x *BandDescription) GetAdrAckLimit() ADRAckLimitExponent {
	if x != nil {
		return x.AdrAckLimit
	}
	return ADRAckLimitExponent_ADR_ACK_LIMIT_1
}

func (x *BandDescription) GetMinRetransmitTimeout() *durationpb.Duration {
	if x != nil {
		return x.MinRetransmitTimeout
	}
	return nil
}

func (x *BandDescription) GetMaxRetransmitTimeout() *durationpb.Duration {
	if x != nil {
		return x.MaxRetransmitTimeout
	}
	return nil
}

func (x *BandDescription) GetTxOffset() []float32 {
	if x != nil {
		return x.TxOffset
	}
	return nil
}

func (x *BandDescription) GetMaxAdrDataRateIndex() DataRateIndex {
	if x != nil {
		return x.MaxAdrDataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *BandDescription) GetRelayForwardDelay() *durationpb.Duration {
	if x != nil {
		return x.RelayForwardDelay
	}
	return nil
}

func (x *BandDescription) GetRelayReceiveDelay() *durationpb.Duration {
	if x != nil {
		return x.RelayReceiveDelay
	}
	return nil
}

func (x *BandDescription) GetTxParamSetupReqSupport() bool {
	if x != nil {
		return x.TxParamSetupReqSupport
	}
	return false
}

func (x *BandDescription) GetDefaultMaxEirp() float32 {
	if x != nil {
		return x.DefaultMaxEirp
	}
	return 0
}

func (x *BandDescription) GetDefaultRx2Parameters() *BandDescription_Rx2Parameters {
	if x != nil {
		return x.DefaultRx2Parameters
	}
	return nil
}

func (x *BandDescription) GetBootDwellTime() *BandDescription_DwellTime {
	if x != nil {
		return x.BootDwellTime
	}
	return nil
}

func (x *BandDescription) GetRelay() *BandDescription_RelayParameters {
	if x != nil {
		return x.Relay
	}
	return nil
}

type ListBandsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Descriptions map[string]*ListBandsResponse_VersionedBandDescription `protobuf:"bytes,1,rep,name=descriptions,proto3" json:"descriptions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ListBandsResponse) Reset() {
	*x = ListBandsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBandsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBandsResponse) ProtoMessage() {}

func (x *ListBandsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBandsResponse.ProtoReflect.Descriptor instead.
func (*ListBandsResponse) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{7}
}

func (x *ListBandsResponse) GetDescriptions() map[string]*ListBandsResponse_VersionedBandDescription {
	if x != nil {
		return x.Descriptions
	}
	return nil
}

type GetPhyVersionsResponse_VersionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BandId      string       `protobuf:"bytes,1,opt,name=band_id,json=bandId,proto3" json:"band_id,omitempty"`
	PhyVersions []PHYVersion `protobuf:"varint,2,rep,packed,name=phy_versions,json=phyVersions,proto3,enum=ttn.lorawan.v3.PHYVersion" json:"phy_versions,omitempty"`
}

func (x *GetPhyVersionsResponse_VersionInfo) Reset() {
	*x = GetPhyVersionsResponse_VersionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPhyVersionsResponse_VersionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPhyVersionsResponse_VersionInfo) ProtoMessage() {}

func (x *GetPhyVersionsResponse_VersionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPhyVersionsResponse_VersionInfo.ProtoReflect.Descriptor instead.
func (*GetPhyVersionsResponse_VersionInfo) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{4, 0}
}

func (x *GetPhyVersionsResponse_VersionInfo) GetBandId() string {
	if x != nil {
		return x.BandId
	}
	return ""
}

func (x *GetPhyVersionsResponse_VersionInfo) GetPhyVersions() []PHYVersion {
	if x != nil {
		return x.PhyVersions
	}
	return nil
}

type BandDescription_Beacon struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataRateIndex DataRateIndex `protobuf:"varint,1,opt,name=data_rate_index,json=dataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"data_rate_index,omitempty"`
	CodingRate    string        `protobuf:"bytes,2,opt,name=coding_rate,json=codingRate,proto3" json:"coding_rate,omitempty"`
	Frequencies   []uint64      `protobuf:"varint,5,rep,packed,name=frequencies,proto3" json:"frequencies,omitempty"`
}

func (x *BandDescription_Beacon) Reset() {
	*x = BandDescription_Beacon{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BandDescription_Beacon) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BandDescription_Beacon) ProtoMessage() {}

func (x *BandDescription_Beacon) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BandDescription_Beacon.ProtoReflect.Descriptor instead.
func (*BandDescription_Beacon) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{6, 0}
}

func (x *BandDescription_Beacon) GetDataRateIndex() DataRateIndex {
	if x != nil {
		return x.DataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *BandDescription_Beacon) GetCodingRate() string {
	if x != nil {
		return x.CodingRate
	}
	return ""
}

func (x *BandDescription_Beacon) GetFrequencies() []uint64 {
	if x != nil {
		return x.Frequencies
	}
	return nil
}

type BandDescription_Channel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Frequency   uint64        `protobuf:"varint,1,opt,name=frequency,proto3" json:"frequency,omitempty"`
	MinDataRate DataRateIndex `protobuf:"varint,2,opt,name=min_data_rate,json=minDataRate,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"min_data_rate,omitempty"`
	MaxDataRate DataRateIndex `protobuf:"varint,3,opt,name=max_data_rate,json=maxDataRate,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"max_data_rate,omitempty"`
}

func (x *BandDescription_Channel) Reset() {
	*x = BandDescription_Channel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BandDescription_Channel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BandDescription_Channel) ProtoMessage() {}

func (x *BandDescription_Channel) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BandDescription_Channel.ProtoReflect.Descriptor instead.
func (*BandDescription_Channel) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{6, 1}
}

func (x *BandDescription_Channel) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *BandDescription_Channel) GetMinDataRate() DataRateIndex {
	if x != nil {
		return x.MinDataRate
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *BandDescription_Channel) GetMaxDataRate() DataRateIndex {
	if x != nil {
		return x.MaxDataRate
	}
	return DataRateIndex_DATA_RATE_0
}

type BandDescription_SubBandParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinFrequency uint64  `protobuf:"varint,1,opt,name=min_frequency,json=minFrequency,proto3" json:"min_frequency,omitempty"`
	MaxFrequency uint64  `protobuf:"varint,2,opt,name=max_frequency,json=maxFrequency,proto3" json:"max_frequency,omitempty"`
	DutyCycle    float32 `protobuf:"fixed32,3,opt,name=duty_cycle,json=dutyCycle,proto3" json:"duty_cycle,omitempty"`
	MaxEirp      float32 `protobuf:"fixed32,4,opt,name=max_eirp,json=maxEirp,proto3" json:"max_eirp,omitempty"`
}

func (x *BandDescription_SubBandParameters) Reset() {
	*x = BandDescription_SubBandParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BandDescription_SubBandParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BandDescription_SubBandParameters) ProtoMessage() {}

func (x *BandDescription_SubBandParameters) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BandDescription_SubBandParameters.ProtoReflect.Descriptor instead.
func (*BandDescription_SubBandParameters) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{6, 2}
}

func (x *BandDescription_SubBandParameters) GetMinFrequency() uint64 {
	if x != nil {
		return x.MinFrequency
	}
	return 0
}

func (x *BandDescription_SubBandParameters) GetMaxFrequency() uint64 {
	if x != nil {
		return x.MaxFrequency
	}
	return 0
}

func (x *BandDescription_SubBandParameters) GetDutyCycle() float32 {
	if x != nil {
		return x.DutyCycle
	}
	return 0
}

func (x *BandDescription_SubBandParameters) GetMaxEirp() float32 {
	if x != nil {
		return x.MaxEirp
	}
	return 0
}

type BandDescription_BandDataRate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Rate *DataRate `protobuf:"bytes,1,opt,name=rate,proto3" json:"rate,omitempty"`
}

func (x *BandDescription_BandDataRate) Reset() {
	*x = BandDescription_BandDataRate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BandDescription_BandDataRate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BandDescription_BandDataRate) ProtoMessage() {}

func (x *BandDescription_BandDataRate) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BandDescription_BandDataRate.ProtoReflect.Descriptor instead.
func (*BandDescription_BandDataRate) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{6, 3}
}

func (x *BandDescription_BandDataRate) GetRate() *DataRate {
	if x != nil {
		return x.Rate
	}
	return nil
}

type BandDescription_Rx2Parameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataRateIndex DataRateIndex `protobuf:"varint,1,opt,name=data_rate_index,json=dataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"data_rate_index,omitempty"`
	Frequency     uint64        `protobuf:"varint,2,opt,name=frequency,proto3" json:"frequency,omitempty"`
}

func (x *BandDescription_Rx2Parameters) Reset() {
	*x = BandDescription_Rx2Parameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BandDescription_Rx2Parameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BandDescription_Rx2Parameters) ProtoMessage() {}

func (x *BandDescription_Rx2Parameters) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BandDescription_Rx2Parameters.ProtoReflect.Descriptor instead.
func (*BandDescription_Rx2Parameters) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{6, 5}
}

func (x *BandDescription_Rx2Parameters) GetDataRateIndex() DataRateIndex {
	if x != nil {
		return x.DataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

func (x *BandDescription_Rx2Parameters) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

type BandDescription_DwellTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Uplinks   *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=uplinks,proto3" json:"uplinks,omitempty"`
	Downlinks *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=downlinks,proto3" json:"downlinks,omitempty"`
}

func (x *BandDescription_DwellTime) Reset() {
	*x = BandDescription_DwellTime{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BandDescription_DwellTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BandDescription_DwellTime) ProtoMessage() {}

func (x *BandDescription_DwellTime) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BandDescription_DwellTime.ProtoReflect.Descriptor instead.
func (*BandDescription_DwellTime) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{6, 6}
}

func (x *BandDescription_DwellTime) GetUplinks() *wrapperspb.BoolValue {
	if x != nil {
		return x.Uplinks
	}
	return nil
}

func (x *BandDescription_DwellTime) GetDownlinks() *wrapperspb.BoolValue {
	if x != nil {
		return x.Downlinks
	}
	return nil
}

type BandDescription_RelayParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	WorChannels []*BandDescription_RelayParameters_RelayWORChannel `protobuf:"bytes,1,rep,name=wor_channels,json=worChannels,proto3" json:"wor_channels,omitempty"`
}

func (x *BandDescription_RelayParameters) Reset() {
	*x = BandDescription_RelayParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BandDescription_RelayParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BandDescription_RelayParameters) ProtoMessage() {}

func (x *BandDescription_RelayParameters) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BandDescription_RelayParameters.ProtoReflect.Descriptor instead.
func (*BandDescription_RelayParameters) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{6, 7}
}

func (x *BandDescription_RelayParameters) GetWorChannels() []*BandDescription_RelayParameters_RelayWORChannel {
	if x != nil {
		return x.WorChannels
	}
	return nil
}

type BandDescription_RelayParameters_RelayWORChannel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Frequency     uint64        `protobuf:"varint,1,opt,name=frequency,proto3" json:"frequency,omitempty"`
	AckFrequency  uint64        `protobuf:"varint,2,opt,name=ack_frequency,json=ackFrequency,proto3" json:"ack_frequency,omitempty"`
	DataRateIndex DataRateIndex `protobuf:"varint,3,opt,name=data_rate_index,json=dataRateIndex,proto3,enum=ttn.lorawan.v3.DataRateIndex" json:"data_rate_index,omitempty"`
}

func (x *BandDescription_RelayParameters_RelayWORChannel) Reset() {
	*x = BandDescription_RelayParameters_RelayWORChannel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BandDescription_RelayParameters_RelayWORChannel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BandDescription_RelayParameters_RelayWORChannel) ProtoMessage() {}

func (x *BandDescription_RelayParameters_RelayWORChannel) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BandDescription_RelayParameters_RelayWORChannel.ProtoReflect.Descriptor instead.
func (*BandDescription_RelayParameters_RelayWORChannel) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{6, 7, 0}
}

func (x *BandDescription_RelayParameters_RelayWORChannel) GetFrequency() uint64 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *BandDescription_RelayParameters_RelayWORChannel) GetAckFrequency() uint64 {
	if x != nil {
		return x.AckFrequency
	}
	return 0
}

func (x *BandDescription_RelayParameters_RelayWORChannel) GetDataRateIndex() DataRateIndex {
	if x != nil {
		return x.DataRateIndex
	}
	return DataRateIndex_DATA_RATE_0
}

type ListBandsResponse_VersionedBandDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Band map[string]*BandDescription `protobuf:"bytes,1,rep,name=band,proto3" json:"band,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ListBandsResponse_VersionedBandDescription) Reset() {
	*x = ListBandsResponse_VersionedBandDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBandsResponse_VersionedBandDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBandsResponse_VersionedBandDescription) ProtoMessage() {}

func (x *ListBandsResponse_VersionedBandDescription) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_configuration_services_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBandsResponse_VersionedBandDescription.ProtoReflect.Descriptor instead.
func (*ListBandsResponse_VersionedBandDescription) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP(), []int{7, 0}
}

func (x *ListBandsResponse_VersionedBandDescription) GetBand() map[string]*BandDescription {
	if x != nil {
		return x.Band
	}
	return nil
}

var File_ttn_lorawan_v3_configuration_services_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_configuration_services_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61,
	0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76,
	0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x74, 0x68, 0x65,
	0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8a, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x62, 0x61, 0x73,
	0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x62, 0x61,
	0x6e, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x61, 0x6e,
	0x64, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x5f,
	0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x73, 0x4f, 0x6e, 0x6c, 0x79, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00,
	0x10, 0x01, 0x22, 0x97, 0x01, 0x0a, 0x18, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x50, 0x6c, 0x61, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x17, 0x0a, 0x07, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x62, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x62, 0x61, 0x73, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x62, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x61, 0x6e, 0x64, 0x49, 0x64, 0x22, 0x6f, 0x0a, 0x1a,
	0x4c, 0x69, 0x73, 0x74, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x6c, 0x61,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x0f, 0x66, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x6c,
	0x61, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x66,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x22, 0x3a, 0x0a,
	0x15, 0x47, 0x65, 0x74, 0x50, 0x68, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x62, 0x61, 0x6e, 0x64, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x61, 0x6e, 0x64, 0x49, 0x64, 0x3a,
	0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x01, 0x22, 0xd6, 0x01, 0x0a, 0x16, 0x47, 0x65,
	0x74, 0x50, 0x68, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x0c, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x50,
	0x68, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0x65, 0x0a, 0x0b, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x17, 0x0a, 0x07, 0x62, 0x61,
	0x6e, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x61, 0x6e,
	0x64, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x0c, 0x70, 0x68, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x48, 0x59, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x70, 0x68, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0x7c, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x6e, 0x64, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x62, 0x61, 0x6e, 0x64, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x61, 0x6e, 0x64, 0x49, 0x64, 0x12,
	0x45, 0x0a, 0x0b, 0x70, 0x68, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x48, 0x59, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x70, 0x68, 0x79, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x01,
	0x22, 0xdd, 0x18, 0x0a, 0x0f, 0x42, 0x61, 0x6e, 0x64, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x3e, 0x0a, 0x06, 0x62, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x6e, 0x64, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x52, 0x06, 0x62, 0x65,
	0x61, 0x63, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x15, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6c, 0x6f,
	0x74, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x20, 0x20,
	0x03, 0x28, 0x04, 0x52, 0x13, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x6c, 0x6f, 0x74, 0x46, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f,
	0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x50, 0x0a, 0x0f, 0x75, 0x70, 0x6c, 0x69,
	0x6e, 0x6b, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x42, 0x61, 0x6e, 0x64, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x0e, 0x75, 0x70, 0x6c, 0x69,
	0x6e, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x6d, 0x61,
	0x78, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x54,
	0x0a, 0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x6e, 0x64, 0x44,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x52, 0x10, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x73, 0x12, 0x4e, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x5f, 0x62, 0x61, 0x6e, 0x64,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x6e, 0x64, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x62, 0x42, 0x61, 0x6e, 0x64,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x08, 0x73, 0x75, 0x62, 0x42,
	0x61, 0x6e, 0x64, 0x73, 0x12, 0x4d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74,
	0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x6e, 0x64, 0x44, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61,
	0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61,
	0x74, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x66, 0x72, 0x65, 0x71, 0x5f, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x66, 0x72,
	0x65, 0x71, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x12, 0x2c, 0x0a, 0x12,
	0x69, 0x6d, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x66, 0x5f, 0x6c, 0x69,
	0x73, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x43, 0x66, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x0c, 0x63, 0x66,
	0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x43, 0x46, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x63, 0x66,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x41, 0x0a, 0x0f, 0x72, 0x65, 0x63, 0x65,
	0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x31, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x72, 0x65,
	0x63, 0x65, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x31, 0x12, 0x41, 0x0a, 0x0f, 0x72,
	0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x32, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0d, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x32, 0x12, 0x48,
	0x0a, 0x13, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x5f, 0x64, 0x65,
	0x6c, 0x61, 0x79, 0x5f, 0x31, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6a, 0x6f, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65,
	0x70, 0x74, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x31, 0x12, 0x48, 0x0a, 0x13, 0x6a, 0x6f, 0x69, 0x6e,
	0x5f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x32, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x10, 0x6a, 0x6f, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x44, 0x65, 0x6c, 0x61,
	0x79, 0x32, 0x12, 0x20, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x66, 0x63, 0x6e, 0x74, 0x5f, 0x67,
	0x61, 0x70, 0x18, 0x11, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x46, 0x63, 0x6e,
	0x74, 0x47, 0x61, 0x70, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x5f, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x61, 0x64, 0x72, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x12, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x44, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x41, 0x64, 0x72, 0x12, 0x47, 0x0a, 0x0d, 0x61, 0x64, 0x72, 0x5f, 0x61, 0x63,
	0x6b, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41,
	0x44, 0x52, 0x41, 0x63, 0x6b, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x52, 0x0b, 0x61, 0x64, 0x72, 0x41, 0x63, 0x6b, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12,
	0x4f, 0x0a, 0x16, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x6d, 0x69, 0x6e, 0x52,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x12, 0x4f, 0x0a, 0x16, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d,
	0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x6d, 0x61, 0x78,
	0x52, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x78, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x16,
	0x20, 0x03, 0x28, 0x02, 0x52, 0x08, 0x74, 0x78, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x53,
	0x0a, 0x17, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x64, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x13,
	0x6d, 0x61, 0x78, 0x41, 0x64, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x49, 0x0a, 0x13, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x66, 0x6f, 0x72,
	0x77, 0x61, 0x72, 0x64, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x72, 0x65, 0x6c,
	0x61, 0x79, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x49,
	0x0a, 0x13, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x5f,
	0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x63,
	0x65, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x3a, 0x0a, 0x1a, 0x74, 0x78, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x73, 0x65, 0x74, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x71, 0x5f,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x18, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x74,
	0x78, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x75, 0x70, 0x52, 0x65, 0x71, 0x53, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x69, 0x72, 0x70, 0x18, 0x19, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x0e, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4d, 0x61, 0x78, 0x45, 0x69, 0x72, 0x70, 0x12,
	0x63, 0x0a, 0x16, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x72, 0x78, 0x32, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x42, 0x61, 0x6e, 0x64, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x52, 0x78, 0x32, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x14,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x78, 0x32, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x12, 0x51, 0x0a, 0x0f, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x77, 0x65,
	0x6c, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42,
	0x61, 0x6e, 0x64, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44,
	0x77, 0x65, 0x6c, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x0d, 0x62, 0x6f, 0x6f, 0x74, 0x44, 0x77,
	0x65, 0x6c, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x05, 0x72, 0x65, 0x6c, 0x61, 0x79,
	0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x6e, 0x64, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x05, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x1a, 0x9e,
	0x01, 0x0a, 0x06, 0x42, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x0f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x74,
	0x65, 0x12, 0x20, 0x0a, 0x0b, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x04, 0x52, 0x0b, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x69, 0x65, 0x73, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x1a,
	0xad, 0x01, 0x0a, 0x07, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x66,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09,
	0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x41, 0x0a, 0x0d, 0x6d, 0x69, 0x6e,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52,
	0x0b, 0x6d, 0x69, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x12, 0x41, 0x0a, 0x0d,
	0x6d, 0x61, 0x78, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x1a,
	0x97, 0x01, 0x0a, 0x11, 0x53, 0x75, 0x62, 0x42, 0x61, 0x6e, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x5f, 0x66, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x6d, 0x69,
	0x6e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61,
	0x78, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12,
	0x1d, 0x0a, 0x0a, 0x64, 0x75, 0x74, 0x79, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x09, 0x64, 0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x19,
	0x0a, 0x08, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x69, 0x72, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x07, 0x6d, 0x61, 0x78, 0x45, 0x69, 0x72, 0x70, 0x1a, 0x42, 0x0a, 0x0c, 0x42, 0x61, 0x6e,
	0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x12, 0x2c, 0x0a, 0x04, 0x72, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74,
	0x65, 0x52, 0x04, 0x72, 0x61, 0x74, 0x65, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x1a, 0x6a, 0x0a,
	0x0e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x42, 0x61, 0x6e, 0x64, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x42, 0x61, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x74, 0x0a, 0x0d, 0x52, 0x78, 0x32,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x45, 0x0a, 0x0f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x1a,
	0x7b, 0x0a, 0x09, 0x44, 0x77, 0x65, 0x6c, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x07,
	0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x75, 0x70, 0x6c, 0x69, 0x6e,
	0x6b, 0x73, 0x12, 0x38, 0x0a, 0x09, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x09, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x1a, 0x93, 0x02, 0x0a,
	0x0f, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x62, 0x0a, 0x0c, 0x77, 0x6f, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x6e, 0x64, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x57, 0x4f, 0x52,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x0b, 0x77, 0x6f, 0x72, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x73, 0x1a, 0x9b, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x57, 0x4f,
	0x52, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x66, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x63, 0x6b, 0x5f, 0x66, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x61,
	0x63, 0x6b, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x45, 0x0a, 0x0f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x52, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x4a, 0x04, 0x08, 0x1a, 0x10, 0x1b, 0x4a, 0x04,
	0x08, 0x1b, 0x10, 0x1c, 0x4a, 0x04, 0x08, 0x1c, 0x10, 0x1d, 0x4a, 0x04, 0x08, 0x1d, 0x10, 0x1e,
	0x22, 0xba, 0x03, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x6e, 0x64, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x0c, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x61, 0x6e, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0c, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0xce, 0x01, 0x0a, 0x18, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x42, 0x61, 0x6e,
	0x64, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x04,
	0x62, 0x61, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x42, 0x61, 0x6e, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x42, 0x61, 0x6e, 0x64, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x6e, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x04, 0x62, 0x61, 0x6e, 0x64, 0x1a, 0x58, 0x0a, 0x09, 0x42, 0x61, 0x6e, 0x64, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x35, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x6e, 0x64, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x7b, 0x0a, 0x11, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x50, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x6e, 0x64,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x65, 0x64, 0x42, 0x61, 0x6e, 0x64, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x32, 0xa5, 0x04,
	0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x93, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x12, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x26, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x20, 0x12, 0x1e, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x2d,
	0x70, 0x6c, 0x61, 0x6e, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x50, 0x68, 0x79,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x68, 0x79,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x47, 0x65, 0x74, 0x50, 0x68, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x23, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x12,
	0x1b, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x70, 0x68, 0x79, 0x2d, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xc0, 0x01, 0x0a,
	0x09, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x6e, 0x64, 0x73, 0x12, 0x20, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x42, 0x61, 0x6e, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x61, 0x6e, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x68, 0x5a, 0x20, 0x12, 0x1e, 0x2f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x62, 0x61, 0x6e, 0x64, 0x73, 0x2f,
	0x7b, 0x62, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x5a, 0x2e, 0x12, 0x2c, 0x2f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x62, 0x61, 0x6e, 0x64,
	0x73, 0x2f, 0x7b, 0x62, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7b, 0x70, 0x68, 0x79,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x12, 0x14, 0x2f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x62, 0x61, 0x6e, 0x64, 0x73, 0x1a,
	0x34, 0x92, 0x41, 0x31, 0x12, 0x2f, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x20, 0x4c,
	0x6f, 0x52, 0x61, 0x57, 0x41, 0x4e, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70,
	0x6b, 0x67, 0x2f, 0x74, 0x74, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_configuration_services_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_configuration_services_proto_rawDescData = file_ttn_lorawan_v3_configuration_services_proto_rawDesc
)

func file_ttn_lorawan_v3_configuration_services_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_configuration_services_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_configuration_services_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_configuration_services_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_configuration_services_proto_rawDescData
}

var file_ttn_lorawan_v3_configuration_services_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_ttn_lorawan_v3_configuration_services_proto_goTypes = []interface{}{
	(*ListFrequencyPlansRequest)(nil),                       // 0: ttn.lorawan.v3.ListFrequencyPlansRequest
	(*FrequencyPlanDescription)(nil),                        // 1: ttn.lorawan.v3.FrequencyPlanDescription
	(*ListFrequencyPlansResponse)(nil),                      // 2: ttn.lorawan.v3.ListFrequencyPlansResponse
	(*GetPhyVersionsRequest)(nil),                           // 3: ttn.lorawan.v3.GetPhyVersionsRequest
	(*GetPhyVersionsResponse)(nil),                          // 4: ttn.lorawan.v3.GetPhyVersionsResponse
	(*ListBandsRequest)(nil),                                // 5: ttn.lorawan.v3.ListBandsRequest
	(*BandDescription)(nil),                                 // 6: ttn.lorawan.v3.BandDescription
	(*ListBandsResponse)(nil),                               // 7: ttn.lorawan.v3.ListBandsResponse
	(*GetPhyVersionsResponse_VersionInfo)(nil),              // 8: ttn.lorawan.v3.GetPhyVersionsResponse.VersionInfo
	(*BandDescription_Beacon)(nil),                          // 9: ttn.lorawan.v3.BandDescription.Beacon
	(*BandDescription_Channel)(nil),                         // 10: ttn.lorawan.v3.BandDescription.Channel
	(*BandDescription_SubBandParameters)(nil),               // 11: ttn.lorawan.v3.BandDescription.SubBandParameters
	(*BandDescription_BandDataRate)(nil),                    // 12: ttn.lorawan.v3.BandDescription.BandDataRate
	nil,                                                     // 13: ttn.lorawan.v3.BandDescription.DataRatesEntry
	(*BandDescription_Rx2Parameters)(nil),                   // 14: ttn.lorawan.v3.BandDescription.Rx2Parameters
	(*BandDescription_DwellTime)(nil),                       // 15: ttn.lorawan.v3.BandDescription.DwellTime
	(*BandDescription_RelayParameters)(nil),                 // 16: ttn.lorawan.v3.BandDescription.RelayParameters
	(*BandDescription_RelayParameters_RelayWORChannel)(nil), // 17: ttn.lorawan.v3.BandDescription.RelayParameters.RelayWORChannel
	(*ListBandsResponse_VersionedBandDescription)(nil),      // 18: ttn.lorawan.v3.ListBandsResponse.VersionedBandDescription
	nil,                          // 19: ttn.lorawan.v3.ListBandsResponse.DescriptionsEntry
	nil,                          // 20: ttn.lorawan.v3.ListBandsResponse.VersionedBandDescription.BandEntry
	(PHYVersion)(0),              // 21: ttn.lorawan.v3.PHYVersion
	(CFListType)(0),              // 22: ttn.lorawan.v3.CFListType
	(*durationpb.Duration)(nil),  // 23: google.protobuf.Duration
	(ADRAckLimitExponent)(0),     // 24: ttn.lorawan.v3.ADRAckLimitExponent
	(DataRateIndex)(0),           // 25: ttn.lorawan.v3.DataRateIndex
	(*DataRate)(nil),             // 26: ttn.lorawan.v3.DataRate
	(*wrapperspb.BoolValue)(nil), // 27: google.protobuf.BoolValue
}
var file_ttn_lorawan_v3_configuration_services_proto_depIdxs = []int32{
	1,  // 0: ttn.lorawan.v3.ListFrequencyPlansResponse.frequency_plans:type_name -> ttn.lorawan.v3.FrequencyPlanDescription
	8,  // 1: ttn.lorawan.v3.GetPhyVersionsResponse.version_info:type_name -> ttn.lorawan.v3.GetPhyVersionsResponse.VersionInfo
	21, // 2: ttn.lorawan.v3.ListBandsRequest.phy_version:type_name -> ttn.lorawan.v3.PHYVersion
	9,  // 3: ttn.lorawan.v3.BandDescription.beacon:type_name -> ttn.lorawan.v3.BandDescription.Beacon
	10, // 4: ttn.lorawan.v3.BandDescription.uplink_channels:type_name -> ttn.lorawan.v3.BandDescription.Channel
	10, // 5: ttn.lorawan.v3.BandDescription.downlink_channels:type_name -> ttn.lorawan.v3.BandDescription.Channel
	11, // 6: ttn.lorawan.v3.BandDescription.sub_bands:type_name -> ttn.lorawan.v3.BandDescription.SubBandParameters
	13, // 7: ttn.lorawan.v3.BandDescription.data_rates:type_name -> ttn.lorawan.v3.BandDescription.DataRatesEntry
	22, // 8: ttn.lorawan.v3.BandDescription.cf_list_type:type_name -> ttn.lorawan.v3.CFListType
	23, // 9: ttn.lorawan.v3.BandDescription.receive_delay_1:type_name -> google.protobuf.Duration
	23, // 10: ttn.lorawan.v3.BandDescription.receive_delay_2:type_name -> google.protobuf.Duration
	23, // 11: ttn.lorawan.v3.BandDescription.join_accept_delay_1:type_name -> google.protobuf.Duration
	23, // 12: ttn.lorawan.v3.BandDescription.join_accept_delay_2:type_name -> google.protobuf.Duration
	24, // 13: ttn.lorawan.v3.BandDescription.adr_ack_limit:type_name -> ttn.lorawan.v3.ADRAckLimitExponent
	23, // 14: ttn.lorawan.v3.BandDescription.min_retransmit_timeout:type_name -> google.protobuf.Duration
	23, // 15: ttn.lorawan.v3.BandDescription.max_retransmit_timeout:type_name -> google.protobuf.Duration
	25, // 16: ttn.lorawan.v3.BandDescription.max_adr_data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	23, // 17: ttn.lorawan.v3.BandDescription.relay_forward_delay:type_name -> google.protobuf.Duration
	23, // 18: ttn.lorawan.v3.BandDescription.relay_receive_delay:type_name -> google.protobuf.Duration
	14, // 19: ttn.lorawan.v3.BandDescription.default_rx2_parameters:type_name -> ttn.lorawan.v3.BandDescription.Rx2Parameters
	15, // 20: ttn.lorawan.v3.BandDescription.boot_dwell_time:type_name -> ttn.lorawan.v3.BandDescription.DwellTime
	16, // 21: ttn.lorawan.v3.BandDescription.relay:type_name -> ttn.lorawan.v3.BandDescription.RelayParameters
	19, // 22: ttn.lorawan.v3.ListBandsResponse.descriptions:type_name -> ttn.lorawan.v3.ListBandsResponse.DescriptionsEntry
	21, // 23: ttn.lorawan.v3.GetPhyVersionsResponse.VersionInfo.phy_versions:type_name -> ttn.lorawan.v3.PHYVersion
	25, // 24: ttn.lorawan.v3.BandDescription.Beacon.data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	25, // 25: ttn.lorawan.v3.BandDescription.Channel.min_data_rate:type_name -> ttn.lorawan.v3.DataRateIndex
	25, // 26: ttn.lorawan.v3.BandDescription.Channel.max_data_rate:type_name -> ttn.lorawan.v3.DataRateIndex
	26, // 27: ttn.lorawan.v3.BandDescription.BandDataRate.rate:type_name -> ttn.lorawan.v3.DataRate
	12, // 28: ttn.lorawan.v3.BandDescription.DataRatesEntry.value:type_name -> ttn.lorawan.v3.BandDescription.BandDataRate
	25, // 29: ttn.lorawan.v3.BandDescription.Rx2Parameters.data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	27, // 30: ttn.lorawan.v3.BandDescription.DwellTime.uplinks:type_name -> google.protobuf.BoolValue
	27, // 31: ttn.lorawan.v3.BandDescription.DwellTime.downlinks:type_name -> google.protobuf.BoolValue
	17, // 32: ttn.lorawan.v3.BandDescription.RelayParameters.wor_channels:type_name -> ttn.lorawan.v3.BandDescription.RelayParameters.RelayWORChannel
	25, // 33: ttn.lorawan.v3.BandDescription.RelayParameters.RelayWORChannel.data_rate_index:type_name -> ttn.lorawan.v3.DataRateIndex
	20, // 34: ttn.lorawan.v3.ListBandsResponse.VersionedBandDescription.band:type_name -> ttn.lorawan.v3.ListBandsResponse.VersionedBandDescription.BandEntry
	18, // 35: ttn.lorawan.v3.ListBandsResponse.DescriptionsEntry.value:type_name -> ttn.lorawan.v3.ListBandsResponse.VersionedBandDescription
	6,  // 36: ttn.lorawan.v3.ListBandsResponse.VersionedBandDescription.BandEntry.value:type_name -> ttn.lorawan.v3.BandDescription
	0,  // 37: ttn.lorawan.v3.Configuration.ListFrequencyPlans:input_type -> ttn.lorawan.v3.ListFrequencyPlansRequest
	3,  // 38: ttn.lorawan.v3.Configuration.GetPhyVersions:input_type -> ttn.lorawan.v3.GetPhyVersionsRequest
	5,  // 39: ttn.lorawan.v3.Configuration.ListBands:input_type -> ttn.lorawan.v3.ListBandsRequest
	2,  // 40: ttn.lorawan.v3.Configuration.ListFrequencyPlans:output_type -> ttn.lorawan.v3.ListFrequencyPlansResponse
	4,  // 41: ttn.lorawan.v3.Configuration.GetPhyVersions:output_type -> ttn.lorawan.v3.GetPhyVersionsResponse
	7,  // 42: ttn.lorawan.v3.Configuration.ListBands:output_type -> ttn.lorawan.v3.ListBandsResponse
	40, // [40:43] is the sub-list for method output_type
	37, // [37:40] is the sub-list for method input_type
	37, // [37:37] is the sub-list for extension type_name
	37, // [37:37] is the sub-list for extension extendee
	0,  // [0:37] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_configuration_services_proto_init() }
func file_ttn_lorawan_v3_configuration_services_proto_init() {
	if File_ttn_lorawan_v3_configuration_services_proto != nil {
		return
	}
	file_ttn_lorawan_v3_lorawan_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFrequencyPlansRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FrequencyPlanDescription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFrequencyPlansResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPhyVersionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPhyVersionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBandsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BandDescription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBandsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPhyVersionsResponse_VersionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BandDescription_Beacon); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BandDescription_Channel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BandDescription_SubBandParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BandDescription_BandDataRate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BandDescription_Rx2Parameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BandDescription_DwellTime); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BandDescription_RelayParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BandDescription_RelayParameters_RelayWORChannel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_configuration_services_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBandsResponse_VersionedBandDescription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_configuration_services_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_ttn_lorawan_v3_configuration_services_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_configuration_services_proto_depIdxs,
		MessageInfos:      file_ttn_lorawan_v3_configuration_services_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_configuration_services_proto = out.File
	file_ttn_lorawan_v3_configuration_services_proto_rawDesc = nil
	file_ttn_lorawan_v3_configuration_services_proto_goTypes = nil
	file_ttn_lorawan_v3_configuration_services_proto_depIdxs = nil
}
