// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/client.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/TheThingsIndustries/protoc-gen-go-json/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The OAuth2 flows an OAuth client can use to get an access token.
type GrantType int32

const (
	// Grant type used to exchange an authorization code for an access token.
	GrantType_GRANT_AUTHORIZATION_CODE GrantType = 0
	// Grant type used to exchange a user ID and password for an access token.
	GrantType_GRANT_PASSWORD GrantType = 1
	// Grant type used to exchange a refresh token for an access token.
	GrantType_GRANT_REFRESH_TOKEN GrantType = 2
)

// Enum value maps for GrantType.
var (
	GrantType_name = map[int32]string{
		0: "GRANT_AUTHORIZATION_CODE",
		1: "GRANT_PASSWORD",
		2: "GRANT_REFRESH_TOKEN",
	}
	GrantType_value = map[string]int32{
		"GRANT_AUTHORIZATION_CODE": 0,
		"GRANT_PASSWORD":           1,
		"GRANT_REFRESH_TOKEN":      2,
	}
)

func (x GrantType) Enum() *GrantType {
	p := new(GrantType)
	*p = x
	return p
}

func (x GrantType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GrantType) Descriptor() protoreflect.EnumDescriptor {
	return file_ttn_lorawan_v3_client_proto_enumTypes[0].Descriptor()
}

func (GrantType) Type() protoreflect.EnumType {
	return &file_ttn_lorawan_v3_client_proto_enumTypes[0]
}

func (x GrantType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GrantType.Descriptor instead.
func (GrantType) EnumDescriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_client_proto_rawDescGZIP(), []int{0}
}

// An OAuth client on the network.
type Client struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifiers of the OAuth client. These are public and can be seen by any authenticated user in the network.
	Ids *ClientIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	// When the OAuth client was created. This information is public and can be seen by any authenticated user in the network.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// When the OAuth client was last updated. This information is public and can be seen by any authenticated user in the network.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// When the OAuth client was deleted. This information is public and can be seen by any authenticated user in the network.
	DeletedAt *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// The name of the OAuth client. This information is public and can be seen by any authenticated user in the network.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// A description for the OAuth client. This information is public and can be seen by any authenticated user in the network.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Key-value attributes for this client. Typically used for organizing clients or for storing integration-specific data.
	Attributes map[string]string `protobuf:"bytes,6,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Contact information for this client. Typically used to indicate who to contact with technical/security questions about the application.
	// This information is public and can be seen by any authenticated user in the network.
	// This field is deprecated. Use administrative_contact and technical_contact instead.
	//
	// Deprecated: Marked as deprecated in ttn/lorawan/v3/client.proto.
	ContactInfo           []*ContactInfo                 `protobuf:"bytes,7,rep,name=contact_info,json=contactInfo,proto3" json:"contact_info,omitempty"`
	AdministrativeContact *OrganizationOrUserIdentifiers `protobuf:"bytes,18,opt,name=administrative_contact,json=administrativeContact,proto3" json:"administrative_contact,omitempty"`
	TechnicalContact      *OrganizationOrUserIdentifiers `protobuf:"bytes,19,opt,name=technical_contact,json=technicalContact,proto3" json:"technical_contact,omitempty"`
	// The client secret is only visible to collaborators of the client.
	Secret string `protobuf:"bytes,8,opt,name=secret,proto3" json:"secret,omitempty"`
	// The allowed redirect URIs against which authorization requests are checked.
	// If the authorization request does not pass a redirect URI, the first one
	// from this list is taken.
	// This information is public and can be seen by any authenticated user in the network.
	RedirectUris []string `protobuf:"bytes,9,rep,name=redirect_uris,json=redirectUris,proto3" json:"redirect_uris,omitempty"`
	// The allowed logout redirect URIs against which client initiated logout
	// requests are checked. If the authorization request does not pass a redirect
	// URI, the first one from this list is taken.
	// This information is public and can be seen by any authenticated user in the network.
	LogoutRedirectUris []string `protobuf:"bytes,15,rep,name=logout_redirect_uris,json=logoutRedirectUris,proto3" json:"logout_redirect_uris,omitempty"`
	// The reviewing state of the client.
	// This information is public and can be seen by any authenticated user in the network.
	// This field can only be modified by admins.
	// If state_description is not updated when updating state, state_description is cleared.
	State State `protobuf:"varint,10,opt,name=state,proto3,enum=ttn.lorawan.v3.State" json:"state,omitempty"`
	// A description for the state field.
	// This field can only be modified by admins, and should typically only be updated
	// when also updating `state`.
	StateDescription string `protobuf:"bytes,17,opt,name=state_description,json=stateDescription,proto3" json:"state_description,omitempty"`
	// If set, the authorization page will be skipped.
	// This information is public and can be seen by any authenticated user in the network.
	// This field can only be modified by admins.
	SkipAuthorization bool `protobuf:"varint,11,opt,name=skip_authorization,json=skipAuthorization,proto3" json:"skip_authorization,omitempty"`
	// If set, the authorization page will show endorsement.
	// This information is public and can be seen by any authenticated user in the network.
	// This field can only be modified by admins.
	Endorsed bool `protobuf:"varint,12,opt,name=endorsed,proto3" json:"endorsed,omitempty"`
	// OAuth flows that can be used for the client to get a token.
	// This information is public and can be seen by any authenticated user in the network.
	// After a client is created, this field can only be modified by admins.
	Grants []GrantType `protobuf:"varint,13,rep,packed,name=grants,proto3,enum=ttn.lorawan.v3.GrantType" json:"grants,omitempty"`
	// Rights denotes what rights the client will have access to.
	// This information is public and can be seen by any authenticated user in the network.
	// Users that previously authorized this client will have to re-authorize the
	// client after rights are added to this list.
	Rights []Right `protobuf:"varint,14,rep,packed,name=rights,proto3,enum=ttn.lorawan.v3.Right" json:"rights,omitempty"`
}

func (x *Client) Reset() {
	*x = Client{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_client_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Client) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Client) ProtoMessage() {}

func (x *Client) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_client_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Client.ProtoReflect.Descriptor instead.
func (*Client) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_client_proto_rawDescGZIP(), []int{0}
}

func (x *Client) GetIds() *ClientIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *Client) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Client) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *Client) GetDeletedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.DeletedAt
	}
	return nil
}

func (x *Client) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Client) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Client) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// Deprecated: Marked as deprecated in ttn/lorawan/v3/client.proto.
func (x *Client) GetContactInfo() []*ContactInfo {
	if x != nil {
		return x.ContactInfo
	}
	return nil
}

func (x *Client) GetAdministrativeContact() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.AdministrativeContact
	}
	return nil
}

func (x *Client) GetTechnicalContact() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.TechnicalContact
	}
	return nil
}

func (x *Client) GetSecret() string {
	if x != nil {
		return x.Secret
	}
	return ""
}

func (x *Client) GetRedirectUris() []string {
	if x != nil {
		return x.RedirectUris
	}
	return nil
}

func (x *Client) GetLogoutRedirectUris() []string {
	if x != nil {
		return x.LogoutRedirectUris
	}
	return nil
}

func (x *Client) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_REQUESTED
}

func (x *Client) GetStateDescription() string {
	if x != nil {
		return x.StateDescription
	}
	return ""
}

func (x *Client) GetSkipAuthorization() bool {
	if x != nil {
		return x.SkipAuthorization
	}
	return false
}

func (x *Client) GetEndorsed() bool {
	if x != nil {
		return x.Endorsed
	}
	return false
}

func (x *Client) GetGrants() []GrantType {
	if x != nil {
		return x.Grants
	}
	return nil
}

func (x *Client) GetRights() []Right {
	if x != nil {
		return x.Rights
	}
	return nil
}

type Clients struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Clients []*Client `protobuf:"bytes,1,rep,name=clients,proto3" json:"clients,omitempty"`
}

func (x *Clients) Reset() {
	*x = Clients{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_client_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Clients) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Clients) ProtoMessage() {}

func (x *Clients) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_client_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Clients.ProtoReflect.Descriptor instead.
func (*Clients) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_client_proto_rawDescGZIP(), []int{1}
}

func (x *Clients) GetClients() []*Client {
	if x != nil {
		return x.Clients
	}
	return nil
}

type GetClientRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientIds *ClientIdentifiers `protobuf:"bytes,1,opt,name=client_ids,json=clientIds,proto3" json:"client_ids,omitempty"`
	// The names of the client fields that should be returned.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetClientRequest) Reset() {
	*x = GetClientRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_client_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetClientRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClientRequest) ProtoMessage() {}

func (x *GetClientRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_client_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClientRequest.ProtoReflect.Descriptor instead.
func (*GetClientRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_client_proto_rawDescGZIP(), []int{2}
}

func (x *GetClientRequest) GetClientIds() *ClientIdentifiers {
	if x != nil {
		return x.ClientIds
	}
	return nil
}

func (x *GetClientRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type ListClientsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// By default we list all OAuth clients the caller has rights on.
	// Set the user or the organization (not both) to instead list the OAuth clients
	// where the user or organization is collaborator on.
	Collaborator *OrganizationOrUserIdentifiers `protobuf:"bytes,1,opt,name=collaborator,proto3" json:"collaborator,omitempty"`
	// The names of the client fields that should be returned.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// Order the results by this field path (must be present in the field mask).
	// Default ordering is by ID. Prepend with a minus (-) to reverse the order.
	Order string `protobuf:"bytes,3,opt,name=order,proto3" json:"order,omitempty"`
	// Limit the number of results per page.
	Limit uint32 `protobuf:"varint,4,opt,name=limit,proto3" json:"limit,omitempty"`
	// Page number for pagination. 0 is interpreted as 1.
	Page uint32 `protobuf:"varint,5,opt,name=page,proto3" json:"page,omitempty"`
	// Only return recently deleted clients.
	Deleted bool `protobuf:"varint,6,opt,name=deleted,proto3" json:"deleted,omitempty"`
}

func (x *ListClientsRequest) Reset() {
	*x = ListClientsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_client_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListClientsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClientsRequest) ProtoMessage() {}

func (x *ListClientsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_client_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClientsRequest.ProtoReflect.Descriptor instead.
func (*ListClientsRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_client_proto_rawDescGZIP(), []int{3}
}

func (x *ListClientsRequest) GetCollaborator() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.Collaborator
	}
	return nil
}

func (x *ListClientsRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

func (x *ListClientsRequest) GetOrder() string {
	if x != nil {
		return x.Order
	}
	return ""
}

func (x *ListClientsRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ListClientsRequest) GetPage() uint32 {
	if x != nil {
		return x.Page
	}
	return 0
}

func (x *ListClientsRequest) GetDeleted() bool {
	if x != nil {
		return x.Deleted
	}
	return false
}

type CreateClientRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Client *Client `protobuf:"bytes,1,opt,name=client,proto3" json:"client,omitempty"`
	// Collaborator to grant all rights on the newly created client.
	Collaborator *OrganizationOrUserIdentifiers `protobuf:"bytes,2,opt,name=collaborator,proto3" json:"collaborator,omitempty"`
}

func (x *CreateClientRequest) Reset() {
	*x = CreateClientRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_client_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateClientRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateClientRequest) ProtoMessage() {}

func (x *CreateClientRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_client_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateClientRequest.ProtoReflect.Descriptor instead.
func (*CreateClientRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_client_proto_rawDescGZIP(), []int{4}
}

func (x *CreateClientRequest) GetClient() *Client {
	if x != nil {
		return x.Client
	}
	return nil
}

func (x *CreateClientRequest) GetCollaborator() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.Collaborator
	}
	return nil
}

type UpdateClientRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Client *Client `protobuf:"bytes,1,opt,name=client,proto3" json:"client,omitempty"`
	// The names of the client fields that should be updated.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *UpdateClientRequest) Reset() {
	*x = UpdateClientRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_client_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateClientRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateClientRequest) ProtoMessage() {}

func (x *UpdateClientRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_client_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateClientRequest.ProtoReflect.Descriptor instead.
func (*UpdateClientRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_client_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateClientRequest) GetClient() *Client {
	if x != nil {
		return x.Client
	}
	return nil
}

func (x *UpdateClientRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type ListClientCollaboratorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientIds *ClientIdentifiers `protobuf:"bytes,1,opt,name=client_ids,json=clientIds,proto3" json:"client_ids,omitempty"`
	// Limit the number of results per page.
	Limit uint32 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	// Page number for pagination. 0 is interpreted as 1.
	Page uint32 `protobuf:"varint,3,opt,name=page,proto3" json:"page,omitempty"`
	// Order the results by this field path (must be present in the field mask).
	// Default ordering is by ID. Prepend with a minus (-) to reverse the order.
	Order string `protobuf:"bytes,4,opt,name=order,proto3" json:"order,omitempty"`
}

func (x *ListClientCollaboratorsRequest) Reset() {
	*x = ListClientCollaboratorsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_client_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListClientCollaboratorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClientCollaboratorsRequest) ProtoMessage() {}

func (x *ListClientCollaboratorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_client_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClientCollaboratorsRequest.ProtoReflect.Descriptor instead.
func (*ListClientCollaboratorsRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_client_proto_rawDescGZIP(), []int{6}
}

func (x *ListClientCollaboratorsRequest) GetClientIds() *ClientIdentifiers {
	if x != nil {
		return x.ClientIds
	}
	return nil
}

func (x *ListClientCollaboratorsRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ListClientCollaboratorsRequest) GetPage() uint32 {
	if x != nil {
		return x.Page
	}
	return 0
}

func (x *ListClientCollaboratorsRequest) GetOrder() string {
	if x != nil {
		return x.Order
	}
	return ""
}

type GetClientCollaboratorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientIds    *ClientIdentifiers             `protobuf:"bytes,1,opt,name=client_ids,json=clientIds,proto3" json:"client_ids,omitempty"`
	Collaborator *OrganizationOrUserIdentifiers `protobuf:"bytes,2,opt,name=collaborator,proto3" json:"collaborator,omitempty"`
}

func (x *GetClientCollaboratorRequest) Reset() {
	*x = GetClientCollaboratorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_client_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetClientCollaboratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClientCollaboratorRequest) ProtoMessage() {}

func (x *GetClientCollaboratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_client_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClientCollaboratorRequest.ProtoReflect.Descriptor instead.
func (*GetClientCollaboratorRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_client_proto_rawDescGZIP(), []int{7}
}

func (x *GetClientCollaboratorRequest) GetClientIds() *ClientIdentifiers {
	if x != nil {
		return x.ClientIds
	}
	return nil
}

func (x *GetClientCollaboratorRequest) GetCollaborator() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.Collaborator
	}
	return nil
}

type SetClientCollaboratorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientIds    *ClientIdentifiers `protobuf:"bytes,1,opt,name=client_ids,json=clientIds,proto3" json:"client_ids,omitempty"`
	Collaborator *Collaborator      `protobuf:"bytes,2,opt,name=collaborator,proto3" json:"collaborator,omitempty"`
}

func (x *SetClientCollaboratorRequest) Reset() {
	*x = SetClientCollaboratorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_client_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetClientCollaboratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetClientCollaboratorRequest) ProtoMessage() {}

func (x *SetClientCollaboratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_client_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetClientCollaboratorRequest.ProtoReflect.Descriptor instead.
func (*SetClientCollaboratorRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_client_proto_rawDescGZIP(), []int{8}
}

func (x *SetClientCollaboratorRequest) GetClientIds() *ClientIdentifiers {
	if x != nil {
		return x.ClientIds
	}
	return nil
}

func (x *SetClientCollaboratorRequest) GetCollaborator() *Collaborator {
	if x != nil {
		return x.Collaborator
	}
	return nil
}

type DeleteClientCollaboratorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientIds       *ClientIdentifiers             `protobuf:"bytes,1,opt,name=client_ids,json=clientIds,proto3" json:"client_ids,omitempty"`
	CollaboratorIds *OrganizationOrUserIdentifiers `protobuf:"bytes,2,opt,name=collaborator_ids,json=collaboratorIds,proto3" json:"collaborator_ids,omitempty"`
}

func (x *DeleteClientCollaboratorRequest) Reset() {
	*x = DeleteClientCollaboratorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_client_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteClientCollaboratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteClientCollaboratorRequest) ProtoMessage() {}

func (x *DeleteClientCollaboratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_client_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteClientCollaboratorRequest.ProtoReflect.Descriptor instead.
func (*DeleteClientCollaboratorRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_client_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteClientCollaboratorRequest) GetClientIds() *ClientIdentifiers {
	if x != nil {
		return x.ClientIds
	}
	return nil
}

func (x *DeleteClientCollaboratorRequest) GetCollaboratorIds() *OrganizationOrUserIdentifiers {
	if x != nil {
		return x.CollaboratorIds
	}
	return nil
}

var File_ttn_lorawan_v3_client_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_client_proto_rawDesc = []byte{
	0x0a, 0x1b, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x21, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67,
	0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x6a,
	0x73, 0x6f, 0x6e, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x91, 0x0a, 0x0a,
	0x06, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x10, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10,
	0x01, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x28, 0x01, 0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x43,
	0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x08,
	0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x00, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x41, 0x74, 0x12, 0x43, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x00, 0x52, 0x09, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x43, 0x0a, 0x0a, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01,
	0x10, 0x00, 0x52, 0x09, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x1b, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04,
	0x72, 0x02, 0x18, 0x32, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x18, 0xd0, 0x0f, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7d, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x35, 0xfa, 0x42, 0x32, 0x9a, 0x01, 0x2f, 0x10, 0x0a, 0x22, 0x24, 0x72, 0x22,
	0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a,
	0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c,
	0x7d, 0x24, 0x2a, 0x05, 0x72, 0x03, 0x18, 0xc8, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x0a, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02,
	0x10, 0x0a, 0x18, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x64, 0x0a, 0x16, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73,
	0x52, 0x15, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x12, 0x5a, 0x0a, 0x11, 0x74, 0x65, 0x63, 0x68, 0x6e,
	0x69, 0x63, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x52, 0x10, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x12, 0x20, 0x0a, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x18, 0x80, 0x01, 0x52, 0x06, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x34, 0x0a, 0x0d, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0f, 0xfa, 0x42,
	0x0c, 0x92, 0x01, 0x09, 0x10, 0x0a, 0x22, 0x05, 0x72, 0x03, 0x18, 0x80, 0x01, 0x52, 0x0c, 0x72,
	0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55, 0x72, 0x69, 0x73, 0x12, 0x41, 0x0a, 0x14, 0x6c,
	0x6f, 0x67, 0x6f, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75,
	0x72, 0x69, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0f, 0xfa, 0x42, 0x0c, 0x92, 0x01,
	0x09, 0x10, 0x0a, 0x22, 0x05, 0x72, 0x03, 0x18, 0x80, 0x01, 0x52, 0x12, 0x6c, 0x6f, 0x67, 0x6f,
	0x75, 0x74, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55, 0x72, 0x69, 0x73, 0x12, 0x35,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x35, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x18, 0x80, 0x01, 0x52, 0x10, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x12,
	0x73, 0x6b, 0x69, 0x70, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x73, 0x6b, 0x69, 0x70, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x6f, 0x72, 0x73, 0x65, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x65,
	0x6e, 0x64, 0x6f, 0x72, 0x73, 0x65, 0x64, 0x12, 0x40, 0x0a, 0x06, 0x67, 0x72, 0x61, 0x6e, 0x74,
	0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x0d, 0xfa, 0x42, 0x0a, 0x92, 0x01, 0x07, 0x22, 0x05, 0x82, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x06, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x3c, 0x0a, 0x06, 0x72, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x69, 0x67, 0x68, 0x74,
	0x42, 0x0d, 0xfa, 0x42, 0x0a, 0x92, 0x01, 0x07, 0x22, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x06, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01,
	0x22, 0x3b, 0x0a, 0x07, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x30, 0x0a, 0x07, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x99, 0x01,
	0x0a, 0x10, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4a, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x39,
	0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xde, 0x02, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x59, 0x0a, 0x0c, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72,
	0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x06, 0xf2, 0xaa, 0x19, 0x02, 0x28, 0x01, 0x52, 0x0c, 0x63,
	0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x39, 0x0a, 0x0a, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x5a, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x44, 0xfa, 0x42, 0x41, 0x72, 0x3f, 0x52, 0x00, 0x52, 0x09,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x52, 0x0a, 0x2d, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x05, 0x2d, 0x6e, 0x61,
	0x6d, 0x65, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x52, 0x0b,
	0x2d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x52, 0x05, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xe8, 0x07, 0x52, 0x05, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x04, 0x70, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x01, 0x22, 0xac, 0x01, 0x0a, 0x13, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x38, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x06, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x0c,
	0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x63, 0x6f, 0x6c,
	0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0x8a, 0x01, 0x0a, 0x13, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x38, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x06, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xd9, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x0a, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x1e, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x2a, 0x03, 0x18, 0xe8, 0x07, 0x52, 0x05,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x61, 0x67, 0x65, 0x12, 0x37, 0x0a, 0x05, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xfa, 0x42, 0x1e, 0x72, 0x1c, 0x52,
	0x00, 0x52, 0x02, 0x69, 0x64, 0x52, 0x03, 0x2d, 0x69, 0x64, 0x52, 0x07, 0x2d, 0x72, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x52, 0x06, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x52, 0x05, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x22, 0xc7, 0x01, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12,
	0x5b, 0x0a, 0x0c, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c,
	0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0xb6, 0x01, 0x0a,
	0x1c, 0x53, 0x65, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x61, 0x62,
	0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a,
	0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x09,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x4a, 0x0a, 0x0c, 0x63, 0x6f, 0x6c,
	0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0xd1, 0x01, 0x0a, 0x1f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x0a, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x62, 0x0a, 0x10, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0f, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62,
	0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x49, 0x64, 0x73, 0x2a, 0x65, 0x0a, 0x09, 0x47, 0x72, 0x61,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x5f,
	0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f,
	0x44, 0x45, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x5f, 0x50, 0x41,
	0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x47, 0x52, 0x41, 0x4e,
	0x54, 0x5f, 0x52, 0x45, 0x46, 0x52, 0x45, 0x53, 0x48, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10,
	0x02, 0x1a, 0x0d, 0xea, 0xaa, 0x19, 0x09, 0x18, 0x01, 0x2a, 0x05, 0x47, 0x52, 0x41, 0x4e, 0x54,
	0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74,
	0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_client_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_client_proto_rawDescData = file_ttn_lorawan_v3_client_proto_rawDesc
)

func file_ttn_lorawan_v3_client_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_client_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_client_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_client_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_client_proto_rawDescData
}

var file_ttn_lorawan_v3_client_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_ttn_lorawan_v3_client_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_ttn_lorawan_v3_client_proto_goTypes = []interface{}{
	(GrantType)(0),                          // 0: ttn.lorawan.v3.GrantType
	(*Client)(nil),                          // 1: ttn.lorawan.v3.Client
	(*Clients)(nil),                         // 2: ttn.lorawan.v3.Clients
	(*GetClientRequest)(nil),                // 3: ttn.lorawan.v3.GetClientRequest
	(*ListClientsRequest)(nil),              // 4: ttn.lorawan.v3.ListClientsRequest
	(*CreateClientRequest)(nil),             // 5: ttn.lorawan.v3.CreateClientRequest
	(*UpdateClientRequest)(nil),             // 6: ttn.lorawan.v3.UpdateClientRequest
	(*ListClientCollaboratorsRequest)(nil),  // 7: ttn.lorawan.v3.ListClientCollaboratorsRequest
	(*GetClientCollaboratorRequest)(nil),    // 8: ttn.lorawan.v3.GetClientCollaboratorRequest
	(*SetClientCollaboratorRequest)(nil),    // 9: ttn.lorawan.v3.SetClientCollaboratorRequest
	(*DeleteClientCollaboratorRequest)(nil), // 10: ttn.lorawan.v3.DeleteClientCollaboratorRequest
	nil,                                     // 11: ttn.lorawan.v3.Client.AttributesEntry
	(*ClientIdentifiers)(nil),               // 12: ttn.lorawan.v3.ClientIdentifiers
	(*timestamppb.Timestamp)(nil),           // 13: google.protobuf.Timestamp
	(*ContactInfo)(nil),                     // 14: ttn.lorawan.v3.ContactInfo
	(*OrganizationOrUserIdentifiers)(nil),   // 15: ttn.lorawan.v3.OrganizationOrUserIdentifiers
	(State)(0),                              // 16: ttn.lorawan.v3.State
	(Right)(0),                              // 17: ttn.lorawan.v3.Right
	(*fieldmaskpb.FieldMask)(nil),           // 18: google.protobuf.FieldMask
	(*Collaborator)(nil),                    // 19: ttn.lorawan.v3.Collaborator
}
var file_ttn_lorawan_v3_client_proto_depIdxs = []int32{
	12, // 0: ttn.lorawan.v3.Client.ids:type_name -> ttn.lorawan.v3.ClientIdentifiers
	13, // 1: ttn.lorawan.v3.Client.created_at:type_name -> google.protobuf.Timestamp
	13, // 2: ttn.lorawan.v3.Client.updated_at:type_name -> google.protobuf.Timestamp
	13, // 3: ttn.lorawan.v3.Client.deleted_at:type_name -> google.protobuf.Timestamp
	11, // 4: ttn.lorawan.v3.Client.attributes:type_name -> ttn.lorawan.v3.Client.AttributesEntry
	14, // 5: ttn.lorawan.v3.Client.contact_info:type_name -> ttn.lorawan.v3.ContactInfo
	15, // 6: ttn.lorawan.v3.Client.administrative_contact:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	15, // 7: ttn.lorawan.v3.Client.technical_contact:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	16, // 8: ttn.lorawan.v3.Client.state:type_name -> ttn.lorawan.v3.State
	0,  // 9: ttn.lorawan.v3.Client.grants:type_name -> ttn.lorawan.v3.GrantType
	17, // 10: ttn.lorawan.v3.Client.rights:type_name -> ttn.lorawan.v3.Right
	1,  // 11: ttn.lorawan.v3.Clients.clients:type_name -> ttn.lorawan.v3.Client
	12, // 12: ttn.lorawan.v3.GetClientRequest.client_ids:type_name -> ttn.lorawan.v3.ClientIdentifiers
	18, // 13: ttn.lorawan.v3.GetClientRequest.field_mask:type_name -> google.protobuf.FieldMask
	15, // 14: ttn.lorawan.v3.ListClientsRequest.collaborator:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	18, // 15: ttn.lorawan.v3.ListClientsRequest.field_mask:type_name -> google.protobuf.FieldMask
	1,  // 16: ttn.lorawan.v3.CreateClientRequest.client:type_name -> ttn.lorawan.v3.Client
	15, // 17: ttn.lorawan.v3.CreateClientRequest.collaborator:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	1,  // 18: ttn.lorawan.v3.UpdateClientRequest.client:type_name -> ttn.lorawan.v3.Client
	18, // 19: ttn.lorawan.v3.UpdateClientRequest.field_mask:type_name -> google.protobuf.FieldMask
	12, // 20: ttn.lorawan.v3.ListClientCollaboratorsRequest.client_ids:type_name -> ttn.lorawan.v3.ClientIdentifiers
	12, // 21: ttn.lorawan.v3.GetClientCollaboratorRequest.client_ids:type_name -> ttn.lorawan.v3.ClientIdentifiers
	15, // 22: ttn.lorawan.v3.GetClientCollaboratorRequest.collaborator:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	12, // 23: ttn.lorawan.v3.SetClientCollaboratorRequest.client_ids:type_name -> ttn.lorawan.v3.ClientIdentifiers
	19, // 24: ttn.lorawan.v3.SetClientCollaboratorRequest.collaborator:type_name -> ttn.lorawan.v3.Collaborator
	12, // 25: ttn.lorawan.v3.DeleteClientCollaboratorRequest.client_ids:type_name -> ttn.lorawan.v3.ClientIdentifiers
	15, // 26: ttn.lorawan.v3.DeleteClientCollaboratorRequest.collaborator_ids:type_name -> ttn.lorawan.v3.OrganizationOrUserIdentifiers
	27, // [27:27] is the sub-list for method output_type
	27, // [27:27] is the sub-list for method input_type
	27, // [27:27] is the sub-list for extension type_name
	27, // [27:27] is the sub-list for extension extendee
	0,  // [0:27] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_client_proto_init() }
func file_ttn_lorawan_v3_client_proto_init() {
	if File_ttn_lorawan_v3_client_proto != nil {
		return
	}
	file_ttn_lorawan_v3_contact_info_proto_init()
	file_ttn_lorawan_v3_enums_proto_init()
	file_ttn_lorawan_v3_identifiers_proto_init()
	file_ttn_lorawan_v3_rights_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_client_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Client); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_client_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Clients); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_client_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetClientRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_client_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListClientsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_client_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateClientRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_client_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateClientRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_client_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListClientCollaboratorsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_client_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetClientCollaboratorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_client_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetClientCollaboratorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_client_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteClientCollaboratorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_client_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ttn_lorawan_v3_client_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_client_proto_depIdxs,
		EnumInfos:         file_ttn_lorawan_v3_client_proto_enumTypes,
		MessageInfos:      file_ttn_lorawan_v3_client_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_client_proto = out.File
	file_ttn_lorawan_v3_client_proto_rawDesc = nil
	file_ttn_lorawan_v3_client_proto_goTypes = nil
	file_ttn_lorawan_v3_client_proto_depIdxs = nil
}
