// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.1
// source: ttn/lorawan/v3/applicationserver_web.proto

package ttnpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ApplicationWebhookRegistry_GetFormats_FullMethodName    = "/ttn.lorawan.v3.ApplicationWebhookRegistry/GetFormats"
	ApplicationWebhookRegistry_GetTemplate_FullMethodName   = "/ttn.lorawan.v3.ApplicationWebhookRegistry/GetTemplate"
	ApplicationWebhookRegistry_ListTemplates_FullMethodName = "/ttn.lorawan.v3.ApplicationWebhookRegistry/ListTemplates"
	ApplicationWebhookRegistry_Get_FullMethodName           = "/ttn.lorawan.v3.ApplicationWebhookRegistry/Get"
	ApplicationWebhookRegistry_List_FullMethodName          = "/ttn.lorawan.v3.ApplicationWebhookRegistry/List"
	ApplicationWebhookRegistry_Set_FullMethodName           = "/ttn.lorawan.v3.ApplicationWebhookRegistry/Set"
	ApplicationWebhookRegistry_Delete_FullMethodName        = "/ttn.lorawan.v3.ApplicationWebhookRegistry/Delete"
)

// ApplicationWebhookRegistryClient is the client API for ApplicationWebhookRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ApplicationWebhookRegistryClient interface {
	GetFormats(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ApplicationWebhookFormats, error)
	GetTemplate(ctx context.Context, in *GetApplicationWebhookTemplateRequest, opts ...grpc.CallOption) (*ApplicationWebhookTemplate, error)
	ListTemplates(ctx context.Context, in *ListApplicationWebhookTemplatesRequest, opts ...grpc.CallOption) (*ApplicationWebhookTemplates, error)
	Get(ctx context.Context, in *GetApplicationWebhookRequest, opts ...grpc.CallOption) (*ApplicationWebhook, error)
	List(ctx context.Context, in *ListApplicationWebhooksRequest, opts ...grpc.CallOption) (*ApplicationWebhooks, error)
	Set(ctx context.Context, in *SetApplicationWebhookRequest, opts ...grpc.CallOption) (*ApplicationWebhook, error)
	Delete(ctx context.Context, in *ApplicationWebhookIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type applicationWebhookRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewApplicationWebhookRegistryClient(cc grpc.ClientConnInterface) ApplicationWebhookRegistryClient {
	return &applicationWebhookRegistryClient{cc}
}

func (c *applicationWebhookRegistryClient) GetFormats(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*ApplicationWebhookFormats, error) {
	out := new(ApplicationWebhookFormats)
	err := c.cc.Invoke(ctx, ApplicationWebhookRegistry_GetFormats_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationWebhookRegistryClient) GetTemplate(ctx context.Context, in *GetApplicationWebhookTemplateRequest, opts ...grpc.CallOption) (*ApplicationWebhookTemplate, error) {
	out := new(ApplicationWebhookTemplate)
	err := c.cc.Invoke(ctx, ApplicationWebhookRegistry_GetTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationWebhookRegistryClient) ListTemplates(ctx context.Context, in *ListApplicationWebhookTemplatesRequest, opts ...grpc.CallOption) (*ApplicationWebhookTemplates, error) {
	out := new(ApplicationWebhookTemplates)
	err := c.cc.Invoke(ctx, ApplicationWebhookRegistry_ListTemplates_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationWebhookRegistryClient) Get(ctx context.Context, in *GetApplicationWebhookRequest, opts ...grpc.CallOption) (*ApplicationWebhook, error) {
	out := new(ApplicationWebhook)
	err := c.cc.Invoke(ctx, ApplicationWebhookRegistry_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationWebhookRegistryClient) List(ctx context.Context, in *ListApplicationWebhooksRequest, opts ...grpc.CallOption) (*ApplicationWebhooks, error) {
	out := new(ApplicationWebhooks)
	err := c.cc.Invoke(ctx, ApplicationWebhookRegistry_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationWebhookRegistryClient) Set(ctx context.Context, in *SetApplicationWebhookRequest, opts ...grpc.CallOption) (*ApplicationWebhook, error) {
	out := new(ApplicationWebhook)
	err := c.cc.Invoke(ctx, ApplicationWebhookRegistry_Set_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationWebhookRegistryClient) Delete(ctx context.Context, in *ApplicationWebhookIdentifiers, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ApplicationWebhookRegistry_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApplicationWebhookRegistryServer is the server API for ApplicationWebhookRegistry service.
// All implementations must embed UnimplementedApplicationWebhookRegistryServer
// for forward compatibility
type ApplicationWebhookRegistryServer interface {
	GetFormats(context.Context, *emptypb.Empty) (*ApplicationWebhookFormats, error)
	GetTemplate(context.Context, *GetApplicationWebhookTemplateRequest) (*ApplicationWebhookTemplate, error)
	ListTemplates(context.Context, *ListApplicationWebhookTemplatesRequest) (*ApplicationWebhookTemplates, error)
	Get(context.Context, *GetApplicationWebhookRequest) (*ApplicationWebhook, error)
	List(context.Context, *ListApplicationWebhooksRequest) (*ApplicationWebhooks, error)
	Set(context.Context, *SetApplicationWebhookRequest) (*ApplicationWebhook, error)
	Delete(context.Context, *ApplicationWebhookIdentifiers) (*emptypb.Empty, error)
	mustEmbedUnimplementedApplicationWebhookRegistryServer()
}

// UnimplementedApplicationWebhookRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedApplicationWebhookRegistryServer struct {
}

func (UnimplementedApplicationWebhookRegistryServer) GetFormats(context.Context, *emptypb.Empty) (*ApplicationWebhookFormats, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFormats not implemented")
}
func (UnimplementedApplicationWebhookRegistryServer) GetTemplate(context.Context, *GetApplicationWebhookTemplateRequest) (*ApplicationWebhookTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTemplate not implemented")
}
func (UnimplementedApplicationWebhookRegistryServer) ListTemplates(context.Context, *ListApplicationWebhookTemplatesRequest) (*ApplicationWebhookTemplates, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTemplates not implemented")
}
func (UnimplementedApplicationWebhookRegistryServer) Get(context.Context, *GetApplicationWebhookRequest) (*ApplicationWebhook, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedApplicationWebhookRegistryServer) List(context.Context, *ListApplicationWebhooksRequest) (*ApplicationWebhooks, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedApplicationWebhookRegistryServer) Set(context.Context, *SetApplicationWebhookRequest) (*ApplicationWebhook, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Set not implemented")
}
func (UnimplementedApplicationWebhookRegistryServer) Delete(context.Context, *ApplicationWebhookIdentifiers) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedApplicationWebhookRegistryServer) mustEmbedUnimplementedApplicationWebhookRegistryServer() {
}

// UnsafeApplicationWebhookRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ApplicationWebhookRegistryServer will
// result in compilation errors.
type UnsafeApplicationWebhookRegistryServer interface {
	mustEmbedUnimplementedApplicationWebhookRegistryServer()
}

func RegisterApplicationWebhookRegistryServer(s grpc.ServiceRegistrar, srv ApplicationWebhookRegistryServer) {
	s.RegisterService(&ApplicationWebhookRegistry_ServiceDesc, srv)
}

func _ApplicationWebhookRegistry_GetFormats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationWebhookRegistryServer).GetFormats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationWebhookRegistry_GetFormats_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationWebhookRegistryServer).GetFormats(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationWebhookRegistry_GetTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationWebhookTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationWebhookRegistryServer).GetTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationWebhookRegistry_GetTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationWebhookRegistryServer).GetTemplate(ctx, req.(*GetApplicationWebhookTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationWebhookRegistry_ListTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApplicationWebhookTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationWebhookRegistryServer).ListTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationWebhookRegistry_ListTemplates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationWebhookRegistryServer).ListTemplates(ctx, req.(*ListApplicationWebhookTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationWebhookRegistry_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationWebhookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationWebhookRegistryServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationWebhookRegistry_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationWebhookRegistryServer).Get(ctx, req.(*GetApplicationWebhookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationWebhookRegistry_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApplicationWebhooksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationWebhookRegistryServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationWebhookRegistry_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationWebhookRegistryServer).List(ctx, req.(*ListApplicationWebhooksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationWebhookRegistry_Set_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetApplicationWebhookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationWebhookRegistryServer).Set(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationWebhookRegistry_Set_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationWebhookRegistryServer).Set(ctx, req.(*SetApplicationWebhookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationWebhookRegistry_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationWebhookIdentifiers)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationWebhookRegistryServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ApplicationWebhookRegistry_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationWebhookRegistryServer).Delete(ctx, req.(*ApplicationWebhookIdentifiers))
	}
	return interceptor(ctx, in, info, handler)
}

// ApplicationWebhookRegistry_ServiceDesc is the grpc.ServiceDesc for ApplicationWebhookRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ApplicationWebhookRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "ttn.lorawan.v3.ApplicationWebhookRegistry",
	HandlerType: (*ApplicationWebhookRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetFormats",
			Handler:    _ApplicationWebhookRegistry_GetFormats_Handler,
		},
		{
			MethodName: "GetTemplate",
			Handler:    _ApplicationWebhookRegistry_GetTemplate_Handler,
		},
		{
			MethodName: "ListTemplates",
			Handler:    _ApplicationWebhookRegistry_ListTemplates_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _ApplicationWebhookRegistry_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ApplicationWebhookRegistry_List_Handler,
		},
		{
			MethodName: "Set",
			Handler:    _ApplicationWebhookRegistry_Set_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ApplicationWebhookRegistry_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ttn/lorawan/v3/applicationserver_web.proto",
}
