// Code generated by protoc-gen-fieldmask. DO NOT EDIT.

package ttnpb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// ValidateFields checks the field values on ApplicationWebhookIdentifiers with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ApplicationWebhookIdentifiers) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationWebhookIdentifiersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return ApplicationWebhookIdentifiersValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookIdentifiersValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "webhook_id":

			if utf8.RuneCountInString(m.GetWebhookId()) > 36 {
				return ApplicationWebhookIdentifiersValidationError{
					field:  "webhook_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_ApplicationWebhookIdentifiers_WebhookId_Pattern.MatchString(m.GetWebhookId()) {
				return ApplicationWebhookIdentifiersValidationError{
					field:  "webhook_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		default:
			return ApplicationWebhookIdentifiersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationWebhookIdentifiersValidationError is the validation error
// returned by ApplicationWebhookIdentifiers.ValidateFields if the designated
// constraints aren't met.
type ApplicationWebhookIdentifiersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationWebhookIdentifiersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationWebhookIdentifiersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationWebhookIdentifiersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationWebhookIdentifiersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationWebhookIdentifiersValidationError) ErrorName() string {
	return "ApplicationWebhookIdentifiersValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationWebhookIdentifiersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationWebhookIdentifiers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationWebhookIdentifiersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationWebhookIdentifiersValidationError{}

var _ApplicationWebhookIdentifiers_WebhookId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on
// ApplicationWebhookTemplateIdentifiers with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *ApplicationWebhookTemplateIdentifiers) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationWebhookTemplateIdentifiersFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "template_id":

			if utf8.RuneCountInString(m.GetTemplateId()) > 36 {
				return ApplicationWebhookTemplateIdentifiersValidationError{
					field:  "template_id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_ApplicationWebhookTemplateIdentifiers_TemplateId_Pattern.MatchString(m.GetTemplateId()) {
				return ApplicationWebhookTemplateIdentifiersValidationError{
					field:  "template_id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		default:
			return ApplicationWebhookTemplateIdentifiersValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationWebhookTemplateIdentifiersValidationError is the validation error
// returned by ApplicationWebhookTemplateIdentifiers.ValidateFields if the
// designated constraints aren't met.
type ApplicationWebhookTemplateIdentifiersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationWebhookTemplateIdentifiersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationWebhookTemplateIdentifiersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationWebhookTemplateIdentifiersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationWebhookTemplateIdentifiersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationWebhookTemplateIdentifiersValidationError) ErrorName() string {
	return "ApplicationWebhookTemplateIdentifiersValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationWebhookTemplateIdentifiersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationWebhookTemplateIdentifiers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationWebhookTemplateIdentifiersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationWebhookTemplateIdentifiersValidationError{}

var _ApplicationWebhookTemplateIdentifiers_TemplateId_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on ApplicationWebhookTemplateField
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ApplicationWebhookTemplateField) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationWebhookTemplateFieldFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "id":

			if utf8.RuneCountInString(m.GetId()) > 36 {
				return ApplicationWebhookTemplateFieldValidationError{
					field:  "id",
					reason: "value length must be at most 36 runes",
				}
			}

			if !_ApplicationWebhookTemplateField_Id_Pattern.MatchString(m.GetId()) {
				return ApplicationWebhookTemplateFieldValidationError{
					field:  "id",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "name":

			if utf8.RuneCountInString(m.GetName()) > 20 {
				return ApplicationWebhookTemplateFieldValidationError{
					field:  "name",
					reason: "value length must be at most 20 runes",
				}
			}

		case "description":

			if utf8.RuneCountInString(m.GetDescription()) > 100 {
				return ApplicationWebhookTemplateFieldValidationError{
					field:  "description",
					reason: "value length must be at most 100 runes",
				}
			}

		case "secret":
			// no validation rules for Secret
		case "default_value":

			if utf8.RuneCountInString(m.GetDefaultValue()) > 100 {
				return ApplicationWebhookTemplateFieldValidationError{
					field:  "default_value",
					reason: "value length must be at most 100 runes",
				}
			}

		case "optional":
			// no validation rules for Optional
		default:
			return ApplicationWebhookTemplateFieldValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationWebhookTemplateFieldValidationError is the validation error
// returned by ApplicationWebhookTemplateField.ValidateFields if the
// designated constraints aren't met.
type ApplicationWebhookTemplateFieldValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationWebhookTemplateFieldValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationWebhookTemplateFieldValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationWebhookTemplateFieldValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationWebhookTemplateFieldValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationWebhookTemplateFieldValidationError) ErrorName() string {
	return "ApplicationWebhookTemplateFieldValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationWebhookTemplateFieldValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationWebhookTemplateField.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationWebhookTemplateFieldValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationWebhookTemplateFieldValidationError{}

var _ApplicationWebhookTemplateField_Id_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on ApplicationWebhookTemplate with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ApplicationWebhookTemplate) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationWebhookTemplateFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return ApplicationWebhookTemplateValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookTemplateValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "name":

			if utf8.RuneCountInString(m.GetName()) > 20 {
				return ApplicationWebhookTemplateValidationError{
					field:  "name",
					reason: "value length must be at most 20 runes",
				}
			}

		case "description":

			if utf8.RuneCountInString(m.GetDescription()) > 100 {
				return ApplicationWebhookTemplateValidationError{
					field:  "description",
					reason: "value length must be at most 100 runes",
				}
			}

		case "logo_url":

			if uri, err := url.Parse(m.GetLogoUrl()); err != nil {
				return ApplicationWebhookTemplateValidationError{
					field:  "logo_url",
					reason: "value must be a valid URI",
					cause:  err,
				}
			} else if !uri.IsAbs() {
				return ApplicationWebhookTemplateValidationError{
					field:  "logo_url",
					reason: "value must be absolute",
				}
			}

		case "info_url":

			if uri, err := url.Parse(m.GetInfoUrl()); err != nil {
				return ApplicationWebhookTemplateValidationError{
					field:  "info_url",
					reason: "value must be a valid URI",
					cause:  err,
				}
			} else if !uri.IsAbs() {
				return ApplicationWebhookTemplateValidationError{
					field:  "info_url",
					reason: "value must be absolute",
				}
			}

		case "documentation_url":

			if uri, err := url.Parse(m.GetDocumentationUrl()); err != nil {
				return ApplicationWebhookTemplateValidationError{
					field:  "documentation_url",
					reason: "value must be a valid URI",
					cause:  err,
				}
			} else if !uri.IsAbs() {
				return ApplicationWebhookTemplateValidationError{
					field:  "documentation_url",
					reason: "value must be absolute",
				}
			}

		case "base_url":

			if uri, err := url.Parse(m.GetBaseUrl()); err != nil {
				return ApplicationWebhookTemplateValidationError{
					field:  "base_url",
					reason: "value must be a valid URI",
					cause:  err,
				}
			} else if !uri.IsAbs() {
				return ApplicationWebhookTemplateValidationError{
					field:  "base_url",
					reason: "value must be absolute",
				}
			}

		case "headers":

			if len(m.GetHeaders()) > 50 {
				return ApplicationWebhookTemplateValidationError{
					field:  "headers",
					reason: "value must contain no more than 50 pair(s)",
				}
			}

			for key, val := range m.GetHeaders() {
				_ = val

				if utf8.RuneCountInString(key) > 64 {
					return ApplicationWebhookTemplateValidationError{
						field:  fmt.Sprintf("headers[%v]", key),
						reason: "value length must be at most 64 runes",
					}
				}

				if utf8.RuneCountInString(val) > 256 {
					return ApplicationWebhookTemplateValidationError{
						field:  fmt.Sprintf("headers[%v]", key),
						reason: "value length must be at most 256 runes",
					}
				}

			}

		case "format":

			if utf8.RuneCountInString(m.GetFormat()) > 20 {
				return ApplicationWebhookTemplateValidationError{
					field:  "format",
					reason: "value length must be at most 20 runes",
				}
			}

			if !_ApplicationWebhookTemplate_Format_Pattern.MatchString(m.GetFormat()) {
				return ApplicationWebhookTemplateValidationError{
					field:  "format",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "fields":

			for idx, item := range m.GetFields() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationWebhookTemplateValidationError{
							field:  fmt.Sprintf("fields[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		case "create_downlink_api_key":
			// no validation rules for CreateDownlinkApiKey
		case "uplink_message":

			if v, ok := interface{}(m.GetUplinkMessage()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookTemplateValidationError{
						field:  "uplink_message",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "uplink_normalized":

			if v, ok := interface{}(m.GetUplinkNormalized()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookTemplateValidationError{
						field:  "uplink_normalized",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "join_accept":

			if v, ok := interface{}(m.GetJoinAccept()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookTemplateValidationError{
						field:  "join_accept",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_ack":

			if v, ok := interface{}(m.GetDownlinkAck()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookTemplateValidationError{
						field:  "downlink_ack",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_nack":

			if v, ok := interface{}(m.GetDownlinkNack()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookTemplateValidationError{
						field:  "downlink_nack",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_sent":

			if v, ok := interface{}(m.GetDownlinkSent()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookTemplateValidationError{
						field:  "downlink_sent",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_failed":

			if v, ok := interface{}(m.GetDownlinkFailed()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookTemplateValidationError{
						field:  "downlink_failed",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_queued":

			if v, ok := interface{}(m.GetDownlinkQueued()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookTemplateValidationError{
						field:  "downlink_queued",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_queue_invalidated":

			if v, ok := interface{}(m.GetDownlinkQueueInvalidated()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookTemplateValidationError{
						field:  "downlink_queue_invalidated",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "location_solved":

			if v, ok := interface{}(m.GetLocationSolved()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookTemplateValidationError{
						field:  "location_solved",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "service_data":

			if v, ok := interface{}(m.GetServiceData()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookTemplateValidationError{
						field:  "service_data",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookTemplateValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ApplicationWebhookTemplateValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationWebhookTemplateValidationError is the validation error returned
// by ApplicationWebhookTemplate.ValidateFields if the designated constraints
// aren't met.
type ApplicationWebhookTemplateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationWebhookTemplateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationWebhookTemplateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationWebhookTemplateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationWebhookTemplateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationWebhookTemplateValidationError) ErrorName() string {
	return "ApplicationWebhookTemplateValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationWebhookTemplateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationWebhookTemplate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationWebhookTemplateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationWebhookTemplateValidationError{}

var _ApplicationWebhookTemplate_Format_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on ApplicationWebhookTemplates with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ApplicationWebhookTemplates) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationWebhookTemplatesFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "templates":

			for idx, item := range m.GetTemplates() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationWebhookTemplatesValidationError{
							field:  fmt.Sprintf("templates[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ApplicationWebhookTemplatesValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationWebhookTemplatesValidationError is the validation error returned
// by ApplicationWebhookTemplates.ValidateFields if the designated constraints
// aren't met.
type ApplicationWebhookTemplatesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationWebhookTemplatesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationWebhookTemplatesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationWebhookTemplatesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationWebhookTemplatesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationWebhookTemplatesValidationError) ErrorName() string {
	return "ApplicationWebhookTemplatesValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationWebhookTemplatesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationWebhookTemplates.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationWebhookTemplatesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationWebhookTemplatesValidationError{}

// ValidateFields checks the field values on ApplicationWebhookHealth with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationWebhookHealth) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationWebhookHealthFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "status":
			if len(subs) == 0 {
				subs = []string{
					"healthy", "unhealthy",
				}
			}
			for name, subs := range _processPaths(subs) {
				_ = subs
				switch name {
				case "healthy":
					w, ok := m.Status.(*ApplicationWebhookHealth_Healthy)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetHealthy()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationWebhookHealthValidationError{
								field:  "healthy",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				case "unhealthy":
					w, ok := m.Status.(*ApplicationWebhookHealth_Unhealthy)
					if !ok || w == nil {
						continue
					}

					if v, ok := interface{}(m.GetUnhealthy()).(interface{ ValidateFields(...string) error }); ok {
						if err := v.ValidateFields(subs...); err != nil {
							return ApplicationWebhookHealthValidationError{
								field:  "unhealthy",
								reason: "embedded message failed validation",
								cause:  err,
							}
						}
					}

				}
			}
		default:
			return ApplicationWebhookHealthValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationWebhookHealthValidationError is the validation error returned by
// ApplicationWebhookHealth.ValidateFields if the designated constraints
// aren't met.
type ApplicationWebhookHealthValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationWebhookHealthValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationWebhookHealthValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationWebhookHealthValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationWebhookHealthValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationWebhookHealthValidationError) ErrorName() string {
	return "ApplicationWebhookHealthValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationWebhookHealthValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationWebhookHealth.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationWebhookHealthValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationWebhookHealthValidationError{}

// ValidateFields checks the field values on ApplicationWebhook with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationWebhook) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationWebhookFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return ApplicationWebhookValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "created_at":

			if v, ok := interface{}(m.GetCreatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "created_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "updated_at":

			if v, ok := interface{}(m.GetUpdatedAt()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "updated_at",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "base_url":

			if uri, err := url.Parse(m.GetBaseUrl()); err != nil {
				return ApplicationWebhookValidationError{
					field:  "base_url",
					reason: "value must be a valid URI",
					cause:  err,
				}
			} else if !uri.IsAbs() {
				return ApplicationWebhookValidationError{
					field:  "base_url",
					reason: "value must be absolute",
				}
			}

		case "headers":

			if len(m.GetHeaders()) > 50 {
				return ApplicationWebhookValidationError{
					field:  "headers",
					reason: "value must contain no more than 50 pair(s)",
				}
			}

			for key, val := range m.GetHeaders() {
				_ = val

				if utf8.RuneCountInString(key) > 64 {
					return ApplicationWebhookValidationError{
						field:  fmt.Sprintf("headers[%v]", key),
						reason: "value length must be at most 64 runes",
					}
				}

				if utf8.RuneCountInString(val) > 4096 {
					return ApplicationWebhookValidationError{
						field:  fmt.Sprintf("headers[%v]", key),
						reason: "value length must be at most 4096 runes",
					}
				}

			}

		case "format":

			if utf8.RuneCountInString(m.GetFormat()) > 20 {
				return ApplicationWebhookValidationError{
					field:  "format",
					reason: "value length must be at most 20 runes",
				}
			}

			if !_ApplicationWebhook_Format_Pattern.MatchString(m.GetFormat()) {
				return ApplicationWebhookValidationError{
					field:  "format",
					reason: "value does not match regex pattern \"^[a-z0-9](?:[-]?[a-z0-9]){2,}$\"",
				}
			}

		case "template_ids":

			if v, ok := interface{}(m.GetTemplateIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "template_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "template_fields":
			// no validation rules for TemplateFields
		case "downlink_api_key":

			if utf8.RuneCountInString(m.GetDownlinkApiKey()) > 128 {
				return ApplicationWebhookValidationError{
					field:  "downlink_api_key",
					reason: "value length must be at most 128 runes",
				}
			}

		case "uplink_message":

			if v, ok := interface{}(m.GetUplinkMessage()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "uplink_message",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "uplink_normalized":

			if v, ok := interface{}(m.GetUplinkNormalized()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "uplink_normalized",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "join_accept":

			if v, ok := interface{}(m.GetJoinAccept()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "join_accept",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_ack":

			if v, ok := interface{}(m.GetDownlinkAck()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "downlink_ack",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_nack":

			if v, ok := interface{}(m.GetDownlinkNack()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "downlink_nack",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_sent":

			if v, ok := interface{}(m.GetDownlinkSent()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "downlink_sent",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_failed":

			if v, ok := interface{}(m.GetDownlinkFailed()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "downlink_failed",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_queued":

			if v, ok := interface{}(m.GetDownlinkQueued()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "downlink_queued",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "downlink_queue_invalidated":

			if v, ok := interface{}(m.GetDownlinkQueueInvalidated()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "downlink_queue_invalidated",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "location_solved":

			if v, ok := interface{}(m.GetLocationSolved()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "location_solved",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "service_data":

			if v, ok := interface{}(m.GetServiceData()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "service_data",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "health_status":

			if v, ok := interface{}(m.GetHealthStatus()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "health_status",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "paused":
			// no validation rules for Paused
		default:
			return ApplicationWebhookValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationWebhookValidationError is the validation error returned by
// ApplicationWebhook.ValidateFields if the designated constraints aren't met.
type ApplicationWebhookValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationWebhookValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationWebhookValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationWebhookValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationWebhookValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationWebhookValidationError) ErrorName() string {
	return "ApplicationWebhookValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationWebhookValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationWebhook.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationWebhookValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationWebhookValidationError{}

var _ApplicationWebhook_Format_Pattern = regexp.MustCompile("^[a-z0-9](?:[-]?[a-z0-9]){2,}$")

// ValidateFields checks the field values on ApplicationWebhooks with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationWebhooks) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationWebhooksFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "webhooks":

			for idx, item := range m.GetWebhooks() {
				_, _ = idx, item

				if v, ok := interface{}(item).(interface{ ValidateFields(...string) error }); ok {
					if err := v.ValidateFields(subs...); err != nil {
						return ApplicationWebhooksValidationError{
							field:  fmt.Sprintf("webhooks[%v]", idx),
							reason: "embedded message failed validation",
							cause:  err,
						}
					}
				}

			}

		default:
			return ApplicationWebhooksValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationWebhooksValidationError is the validation error returned by
// ApplicationWebhooks.ValidateFields if the designated constraints aren't met.
type ApplicationWebhooksValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationWebhooksValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationWebhooksValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationWebhooksValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationWebhooksValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationWebhooksValidationError) ErrorName() string {
	return "ApplicationWebhooksValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationWebhooksValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationWebhooks.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationWebhooksValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationWebhooksValidationError{}

// ValidateFields checks the field values on ApplicationWebhookFormats with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationWebhookFormats) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationWebhookFormatsFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "formats":
			// no validation rules for Formats
		default:
			return ApplicationWebhookFormatsValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationWebhookFormatsValidationError is the validation error returned by
// ApplicationWebhookFormats.ValidateFields if the designated constraints
// aren't met.
type ApplicationWebhookFormatsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationWebhookFormatsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationWebhookFormatsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationWebhookFormatsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationWebhookFormatsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationWebhookFormatsValidationError) ErrorName() string {
	return "ApplicationWebhookFormatsValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationWebhookFormatsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationWebhookFormats.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationWebhookFormatsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationWebhookFormatsValidationError{}

// ValidateFields checks the field values on GetApplicationWebhookRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *GetApplicationWebhookRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetApplicationWebhookRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return GetApplicationWebhookRequestValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationWebhookRequestValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationWebhookRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetApplicationWebhookRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetApplicationWebhookRequestValidationError is the validation error returned
// by GetApplicationWebhookRequest.ValidateFields if the designated
// constraints aren't met.
type GetApplicationWebhookRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetApplicationWebhookRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetApplicationWebhookRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetApplicationWebhookRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetApplicationWebhookRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetApplicationWebhookRequestValidationError) ErrorName() string {
	return "GetApplicationWebhookRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetApplicationWebhookRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetApplicationWebhookRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetApplicationWebhookRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetApplicationWebhookRequestValidationError{}

// ValidateFields checks the field values on ListApplicationWebhooksRequest
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ListApplicationWebhooksRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListApplicationWebhooksRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "application_ids":

			if m.GetApplicationIds() == nil {
				return ListApplicationWebhooksRequestValidationError{
					field:  "application_ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetApplicationIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListApplicationWebhooksRequestValidationError{
						field:  "application_ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListApplicationWebhooksRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ListApplicationWebhooksRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListApplicationWebhooksRequestValidationError is the validation error
// returned by ListApplicationWebhooksRequest.ValidateFields if the designated
// constraints aren't met.
type ListApplicationWebhooksRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListApplicationWebhooksRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListApplicationWebhooksRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListApplicationWebhooksRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListApplicationWebhooksRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListApplicationWebhooksRequestValidationError) ErrorName() string {
	return "ListApplicationWebhooksRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListApplicationWebhooksRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListApplicationWebhooksRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListApplicationWebhooksRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListApplicationWebhooksRequestValidationError{}

// ValidateFields checks the field values on SetApplicationWebhookRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *SetApplicationWebhookRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = SetApplicationWebhookRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "webhook":

			if m.GetWebhook() == nil {
				return SetApplicationWebhookRequestValidationError{
					field:  "webhook",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetWebhook()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetApplicationWebhookRequestValidationError{
						field:  "webhook",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return SetApplicationWebhookRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return SetApplicationWebhookRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// SetApplicationWebhookRequestValidationError is the validation error returned
// by SetApplicationWebhookRequest.ValidateFields if the designated
// constraints aren't met.
type SetApplicationWebhookRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SetApplicationWebhookRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SetApplicationWebhookRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SetApplicationWebhookRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SetApplicationWebhookRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SetApplicationWebhookRequestValidationError) ErrorName() string {
	return "SetApplicationWebhookRequestValidationError"
}

// Error satisfies the builtin error interface
func (e SetApplicationWebhookRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSetApplicationWebhookRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SetApplicationWebhookRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SetApplicationWebhookRequestValidationError{}

// ValidateFields checks the field values on
// GetApplicationWebhookTemplateRequest with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *GetApplicationWebhookTemplateRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = GetApplicationWebhookTemplateRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "ids":

			if m.GetIds() == nil {
				return GetApplicationWebhookTemplateRequestValidationError{
					field:  "ids",
					reason: "value is required",
				}
			}

			if v, ok := interface{}(m.GetIds()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationWebhookTemplateRequestValidationError{
						field:  "ids",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return GetApplicationWebhookTemplateRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return GetApplicationWebhookTemplateRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// GetApplicationWebhookTemplateRequestValidationError is the validation error
// returned by GetApplicationWebhookTemplateRequest.ValidateFields if the
// designated constraints aren't met.
type GetApplicationWebhookTemplateRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetApplicationWebhookTemplateRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetApplicationWebhookTemplateRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetApplicationWebhookTemplateRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetApplicationWebhookTemplateRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetApplicationWebhookTemplateRequestValidationError) ErrorName() string {
	return "GetApplicationWebhookTemplateRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetApplicationWebhookTemplateRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetApplicationWebhookTemplateRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetApplicationWebhookTemplateRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetApplicationWebhookTemplateRequestValidationError{}

// ValidateFields checks the field values on
// ListApplicationWebhookTemplatesRequest with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *ListApplicationWebhookTemplatesRequest) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ListApplicationWebhookTemplatesRequestFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "field_mask":

			if v, ok := interface{}(m.GetFieldMask()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ListApplicationWebhookTemplatesRequestValidationError{
						field:  "field_mask",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ListApplicationWebhookTemplatesRequestValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ListApplicationWebhookTemplatesRequestValidationError is the validation
// error returned by ListApplicationWebhookTemplatesRequest.ValidateFields if
// the designated constraints aren't met.
type ListApplicationWebhookTemplatesRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListApplicationWebhookTemplatesRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListApplicationWebhookTemplatesRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListApplicationWebhookTemplatesRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListApplicationWebhookTemplatesRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListApplicationWebhookTemplatesRequestValidationError) ErrorName() string {
	return "ListApplicationWebhookTemplatesRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListApplicationWebhookTemplatesRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListApplicationWebhookTemplatesRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListApplicationWebhookTemplatesRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListApplicationWebhookTemplatesRequestValidationError{}

// ValidateFields checks the field values on ApplicationWebhookTemplate_Message
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ApplicationWebhookTemplate_Message) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationWebhookTemplate_MessageFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "path":

			if utf8.RuneCountInString(m.GetPath()) > 64 {
				return ApplicationWebhookTemplate_MessageValidationError{
					field:  "path",
					reason: "value length must be at most 64 runes",
				}
			}

		default:
			return ApplicationWebhookTemplate_MessageValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationWebhookTemplate_MessageValidationError is the validation error
// returned by ApplicationWebhookTemplate_Message.ValidateFields if the
// designated constraints aren't met.
type ApplicationWebhookTemplate_MessageValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationWebhookTemplate_MessageValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationWebhookTemplate_MessageValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationWebhookTemplate_MessageValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationWebhookTemplate_MessageValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationWebhookTemplate_MessageValidationError) ErrorName() string {
	return "ApplicationWebhookTemplate_MessageValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationWebhookTemplate_MessageValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationWebhookTemplate_Message.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationWebhookTemplate_MessageValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationWebhookTemplate_MessageValidationError{}

// ValidateFields checks the field values on
// ApplicationWebhookHealth_WebhookHealthStatusHealthy with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *ApplicationWebhookHealth_WebhookHealthStatusHealthy) ValidateFields(paths ...string) error {
	if len(paths) > 0 {
		return fmt.Errorf("message ApplicationWebhookHealth_WebhookHealthStatusHealthy has no fields, but paths %s were specified", paths)
	}
	return nil
}

// ApplicationWebhookHealth_WebhookHealthStatusHealthyValidationError is the
// validation error returned by
// ApplicationWebhookHealth_WebhookHealthStatusHealthy.ValidateFields if the
// designated constraints aren't met.
type ApplicationWebhookHealth_WebhookHealthStatusHealthyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationWebhookHealth_WebhookHealthStatusHealthyValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e ApplicationWebhookHealth_WebhookHealthStatusHealthyValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e ApplicationWebhookHealth_WebhookHealthStatusHealthyValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e ApplicationWebhookHealth_WebhookHealthStatusHealthyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationWebhookHealth_WebhookHealthStatusHealthyValidationError) ErrorName() string {
	return "ApplicationWebhookHealth_WebhookHealthStatusHealthyValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationWebhookHealth_WebhookHealthStatusHealthyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationWebhookHealth_WebhookHealthStatusHealthy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationWebhookHealth_WebhookHealthStatusHealthyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationWebhookHealth_WebhookHealthStatusHealthyValidationError{}

// ValidateFields checks the field values on
// ApplicationWebhookHealth_WebhookHealthStatusUnhealthy with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ApplicationWebhookHealth_WebhookHealthStatusUnhealthy) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationWebhookHealth_WebhookHealthStatusUnhealthyFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "failed_attempts":
			// no validation rules for FailedAttempts
		case "last_failed_attempt_at":

			if m.GetLastFailedAttemptAt() == nil {
				return ApplicationWebhookHealth_WebhookHealthStatusUnhealthyValidationError{
					field:  "last_failed_attempt_at",
					reason: "value is required",
				}
			}

		case "last_failed_attempt_details":

			if v, ok := interface{}(m.GetLastFailedAttemptDetails()).(interface{ ValidateFields(...string) error }); ok {
				if err := v.ValidateFields(subs...); err != nil {
					return ApplicationWebhookHealth_WebhookHealthStatusUnhealthyValidationError{
						field:  "last_failed_attempt_details",
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		default:
			return ApplicationWebhookHealth_WebhookHealthStatusUnhealthyValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationWebhookHealth_WebhookHealthStatusUnhealthyValidationError is the
// validation error returned by
// ApplicationWebhookHealth_WebhookHealthStatusUnhealthy.ValidateFields if the
// designated constraints aren't met.
type ApplicationWebhookHealth_WebhookHealthStatusUnhealthyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationWebhookHealth_WebhookHealthStatusUnhealthyValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e ApplicationWebhookHealth_WebhookHealthStatusUnhealthyValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e ApplicationWebhookHealth_WebhookHealthStatusUnhealthyValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e ApplicationWebhookHealth_WebhookHealthStatusUnhealthyValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e ApplicationWebhookHealth_WebhookHealthStatusUnhealthyValidationError) ErrorName() string {
	return "ApplicationWebhookHealth_WebhookHealthStatusUnhealthyValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationWebhookHealth_WebhookHealthStatusUnhealthyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationWebhookHealth_WebhookHealthStatusUnhealthy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationWebhookHealth_WebhookHealthStatusUnhealthyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationWebhookHealth_WebhookHealthStatusUnhealthyValidationError{}

// ValidateFields checks the field values on ApplicationWebhook_Message with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *ApplicationWebhook_Message) ValidateFields(paths ...string) error {
	if m == nil {
		return nil
	}

	if len(paths) == 0 {
		paths = ApplicationWebhook_MessageFieldPathsNested
	}

	for name, subs := range _processPaths(append(paths[:0:0], paths...)) {
		_ = subs
		switch name {
		case "path":

			if utf8.RuneCountInString(m.GetPath()) > 64 {
				return ApplicationWebhook_MessageValidationError{
					field:  "path",
					reason: "value length must be at most 64 runes",
				}
			}

		default:
			return ApplicationWebhook_MessageValidationError{
				field:  name,
				reason: "invalid field path",
			}
		}
	}
	return nil
}

// ApplicationWebhook_MessageValidationError is the validation error returned
// by ApplicationWebhook_Message.ValidateFields if the designated constraints
// aren't met.
type ApplicationWebhook_MessageValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApplicationWebhook_MessageValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApplicationWebhook_MessageValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApplicationWebhook_MessageValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApplicationWebhook_MessageValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApplicationWebhook_MessageValidationError) ErrorName() string {
	return "ApplicationWebhook_MessageValidationError"
}

// Error satisfies the builtin error interface
func (e ApplicationWebhook_MessageValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApplicationWebhook_Message.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApplicationWebhook_MessageValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApplicationWebhook_MessageValidationError{}
