// Copyright © 2019 The Things Network Foundation, The Things Industries B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.1
// source: ttn/lorawan/v3/applicationserver_web.proto

package ttnpb

import (
	_ "github.com/TheThingsIndustries/protoc-gen-go-flags/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ApplicationWebhookIdentifiers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	WebhookId      string                  `protobuf:"bytes,2,opt,name=webhook_id,json=webhookId,proto3" json:"webhook_id,omitempty"`
}

func (x *ApplicationWebhookIdentifiers) Reset() {
	*x = ApplicationWebhookIdentifiers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationWebhookIdentifiers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationWebhookIdentifiers) ProtoMessage() {}

func (x *ApplicationWebhookIdentifiers) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationWebhookIdentifiers.ProtoReflect.Descriptor instead.
func (*ApplicationWebhookIdentifiers) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{0}
}

func (x *ApplicationWebhookIdentifiers) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *ApplicationWebhookIdentifiers) GetWebhookId() string {
	if x != nil {
		return x.WebhookId
	}
	return ""
}

type ApplicationWebhookTemplateIdentifiers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TemplateId string `protobuf:"bytes,1,opt,name=template_id,json=templateId,proto3" json:"template_id,omitempty"`
}

func (x *ApplicationWebhookTemplateIdentifiers) Reset() {
	*x = ApplicationWebhookTemplateIdentifiers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationWebhookTemplateIdentifiers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationWebhookTemplateIdentifiers) ProtoMessage() {}

func (x *ApplicationWebhookTemplateIdentifiers) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationWebhookTemplateIdentifiers.ProtoReflect.Descriptor instead.
func (*ApplicationWebhookTemplateIdentifiers) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{1}
}

func (x *ApplicationWebhookTemplateIdentifiers) GetTemplateId() string {
	if x != nil {
		return x.TemplateId
	}
	return ""
}

// ApplicationWebhookTemplateField represents a custom field that needs to be filled by the user in order to use the template.
// A field can be an API key, an username or password, or any custom platform specific field (such as region).
// The fields are meant to be replaced inside the URLs and headers when the webhook is created.
type ApplicationWebhookTemplateField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id          string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name        string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Secret decides if the field should be shown in plain-text or should stay hidden.
	Secret       bool   `protobuf:"varint,4,opt,name=secret,proto3" json:"secret,omitempty"`
	DefaultValue string `protobuf:"bytes,5,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	Optional     bool   `protobuf:"varint,6,opt,name=optional,proto3" json:"optional,omitempty"`
}

func (x *ApplicationWebhookTemplateField) Reset() {
	*x = ApplicationWebhookTemplateField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationWebhookTemplateField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationWebhookTemplateField) ProtoMessage() {}

func (x *ApplicationWebhookTemplateField) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationWebhookTemplateField.ProtoReflect.Descriptor instead.
func (*ApplicationWebhookTemplateField) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{2}
}

func (x *ApplicationWebhookTemplateField) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ApplicationWebhookTemplateField) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ApplicationWebhookTemplateField) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ApplicationWebhookTemplateField) GetSecret() bool {
	if x != nil {
		return x.Secret
	}
	return false
}

func (x *ApplicationWebhookTemplateField) GetDefaultValue() string {
	if x != nil {
		return x.DefaultValue
	}
	return ""
}

func (x *ApplicationWebhookTemplateField) GetOptional() bool {
	if x != nil {
		return x.Optional
	}
	return false
}

type ApplicationWebhookTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids              *ApplicationWebhookTemplateIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	Name             string                                 `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Description      string                                 `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	LogoUrl          string                                 `protobuf:"bytes,4,opt,name=logo_url,json=logoUrl,proto3" json:"logo_url,omitempty"`
	InfoUrl          string                                 `protobuf:"bytes,5,opt,name=info_url,json=infoUrl,proto3" json:"info_url,omitempty"`
	DocumentationUrl string                                 `protobuf:"bytes,6,opt,name=documentation_url,json=documentationUrl,proto3" json:"documentation_url,omitempty"`
	// The base URL of the template. Can contain template fields, in RFC 6570 format.
	BaseUrl string `protobuf:"bytes,7,opt,name=base_url,json=baseUrl,proto3" json:"base_url,omitempty"`
	// The HTTP headers used by the template. Both the key and the value can contain template fields.
	Headers map[string]string                  `protobuf:"bytes,8,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Format  string                             `protobuf:"bytes,9,opt,name=format,proto3" json:"format,omitempty"`
	Fields  []*ApplicationWebhookTemplateField `protobuf:"bytes,10,rep,name=fields,proto3" json:"fields,omitempty"`
	// Control the creation of the downlink queue operations API key.
	CreateDownlinkApiKey     bool                                `protobuf:"varint,19,opt,name=create_downlink_api_key,json=createDownlinkApiKey,proto3" json:"create_downlink_api_key,omitempty"`
	UplinkMessage            *ApplicationWebhookTemplate_Message `protobuf:"bytes,11,opt,name=uplink_message,json=uplinkMessage,proto3" json:"uplink_message,omitempty"`
	UplinkNormalized         *ApplicationWebhookTemplate_Message `protobuf:"bytes,23,opt,name=uplink_normalized,json=uplinkNormalized,proto3" json:"uplink_normalized,omitempty"`
	JoinAccept               *ApplicationWebhookTemplate_Message `protobuf:"bytes,12,opt,name=join_accept,json=joinAccept,proto3" json:"join_accept,omitempty"`
	DownlinkAck              *ApplicationWebhookTemplate_Message `protobuf:"bytes,13,opt,name=downlink_ack,json=downlinkAck,proto3" json:"downlink_ack,omitempty"`
	DownlinkNack             *ApplicationWebhookTemplate_Message `protobuf:"bytes,14,opt,name=downlink_nack,json=downlinkNack,proto3" json:"downlink_nack,omitempty"`
	DownlinkSent             *ApplicationWebhookTemplate_Message `protobuf:"bytes,15,opt,name=downlink_sent,json=downlinkSent,proto3" json:"downlink_sent,omitempty"`
	DownlinkFailed           *ApplicationWebhookTemplate_Message `protobuf:"bytes,16,opt,name=downlink_failed,json=downlinkFailed,proto3" json:"downlink_failed,omitempty"`
	DownlinkQueued           *ApplicationWebhookTemplate_Message `protobuf:"bytes,17,opt,name=downlink_queued,json=downlinkQueued,proto3" json:"downlink_queued,omitempty"`
	DownlinkQueueInvalidated *ApplicationWebhookTemplate_Message `protobuf:"bytes,21,opt,name=downlink_queue_invalidated,json=downlinkQueueInvalidated,proto3" json:"downlink_queue_invalidated,omitempty"`
	LocationSolved           *ApplicationWebhookTemplate_Message `protobuf:"bytes,18,opt,name=location_solved,json=locationSolved,proto3" json:"location_solved,omitempty"`
	ServiceData              *ApplicationWebhookTemplate_Message `protobuf:"bytes,20,opt,name=service_data,json=serviceData,proto3" json:"service_data,omitempty"`
	FieldMask                *fieldmaskpb.FieldMask              `protobuf:"bytes,22,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *ApplicationWebhookTemplate) Reset() {
	*x = ApplicationWebhookTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationWebhookTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationWebhookTemplate) ProtoMessage() {}

func (x *ApplicationWebhookTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationWebhookTemplate.ProtoReflect.Descriptor instead.
func (*ApplicationWebhookTemplate) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{3}
}

func (x *ApplicationWebhookTemplate) GetIds() *ApplicationWebhookTemplateIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *ApplicationWebhookTemplate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ApplicationWebhookTemplate) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ApplicationWebhookTemplate) GetLogoUrl() string {
	if x != nil {
		return x.LogoUrl
	}
	return ""
}

func (x *ApplicationWebhookTemplate) GetInfoUrl() string {
	if x != nil {
		return x.InfoUrl
	}
	return ""
}

func (x *ApplicationWebhookTemplate) GetDocumentationUrl() string {
	if x != nil {
		return x.DocumentationUrl
	}
	return ""
}

func (x *ApplicationWebhookTemplate) GetBaseUrl() string {
	if x != nil {
		return x.BaseUrl
	}
	return ""
}

func (x *ApplicationWebhookTemplate) GetHeaders() map[string]string {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *ApplicationWebhookTemplate) GetFormat() string {
	if x != nil {
		return x.Format
	}
	return ""
}

func (x *ApplicationWebhookTemplate) GetFields() []*ApplicationWebhookTemplateField {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *ApplicationWebhookTemplate) GetCreateDownlinkApiKey() bool {
	if x != nil {
		return x.CreateDownlinkApiKey
	}
	return false
}

func (x *ApplicationWebhookTemplate) GetUplinkMessage() *ApplicationWebhookTemplate_Message {
	if x != nil {
		return x.UplinkMessage
	}
	return nil
}

func (x *ApplicationWebhookTemplate) GetUplinkNormalized() *ApplicationWebhookTemplate_Message {
	if x != nil {
		return x.UplinkNormalized
	}
	return nil
}

func (x *ApplicationWebhookTemplate) GetJoinAccept() *ApplicationWebhookTemplate_Message {
	if x != nil {
		return x.JoinAccept
	}
	return nil
}

func (x *ApplicationWebhookTemplate) GetDownlinkAck() *ApplicationWebhookTemplate_Message {
	if x != nil {
		return x.DownlinkAck
	}
	return nil
}

func (x *ApplicationWebhookTemplate) GetDownlinkNack() *ApplicationWebhookTemplate_Message {
	if x != nil {
		return x.DownlinkNack
	}
	return nil
}

func (x *ApplicationWebhookTemplate) GetDownlinkSent() *ApplicationWebhookTemplate_Message {
	if x != nil {
		return x.DownlinkSent
	}
	return nil
}

func (x *ApplicationWebhookTemplate) GetDownlinkFailed() *ApplicationWebhookTemplate_Message {
	if x != nil {
		return x.DownlinkFailed
	}
	return nil
}

func (x *ApplicationWebhookTemplate) GetDownlinkQueued() *ApplicationWebhookTemplate_Message {
	if x != nil {
		return x.DownlinkQueued
	}
	return nil
}

func (x *ApplicationWebhookTemplate) GetDownlinkQueueInvalidated() *ApplicationWebhookTemplate_Message {
	if x != nil {
		return x.DownlinkQueueInvalidated
	}
	return nil
}

func (x *ApplicationWebhookTemplate) GetLocationSolved() *ApplicationWebhookTemplate_Message {
	if x != nil {
		return x.LocationSolved
	}
	return nil
}

func (x *ApplicationWebhookTemplate) GetServiceData() *ApplicationWebhookTemplate_Message {
	if x != nil {
		return x.ServiceData
	}
	return nil
}

func (x *ApplicationWebhookTemplate) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type ApplicationWebhookTemplates struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Templates []*ApplicationWebhookTemplate `protobuf:"bytes,1,rep,name=templates,proto3" json:"templates,omitempty"`
}

func (x *ApplicationWebhookTemplates) Reset() {
	*x = ApplicationWebhookTemplates{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationWebhookTemplates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationWebhookTemplates) ProtoMessage() {}

func (x *ApplicationWebhookTemplates) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationWebhookTemplates.ProtoReflect.Descriptor instead.
func (*ApplicationWebhookTemplates) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{4}
}

func (x *ApplicationWebhookTemplates) GetTemplates() []*ApplicationWebhookTemplate {
	if x != nil {
		return x.Templates
	}
	return nil
}

type ApplicationWebhookHealth struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Status:
	//	*ApplicationWebhookHealth_Healthy
	//	*ApplicationWebhookHealth_Unhealthy
	Status isApplicationWebhookHealth_Status `protobuf_oneof:"status"`
}

func (x *ApplicationWebhookHealth) Reset() {
	*x = ApplicationWebhookHealth{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationWebhookHealth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationWebhookHealth) ProtoMessage() {}

func (x *ApplicationWebhookHealth) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationWebhookHealth.ProtoReflect.Descriptor instead.
func (*ApplicationWebhookHealth) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{5}
}

func (m *ApplicationWebhookHealth) GetStatus() isApplicationWebhookHealth_Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (x *ApplicationWebhookHealth) GetHealthy() *ApplicationWebhookHealth_WebhookHealthStatusHealthy {
	if x, ok := x.GetStatus().(*ApplicationWebhookHealth_Healthy); ok {
		return x.Healthy
	}
	return nil
}

func (x *ApplicationWebhookHealth) GetUnhealthy() *ApplicationWebhookHealth_WebhookHealthStatusUnhealthy {
	if x, ok := x.GetStatus().(*ApplicationWebhookHealth_Unhealthy); ok {
		return x.Unhealthy
	}
	return nil
}

type isApplicationWebhookHealth_Status interface {
	isApplicationWebhookHealth_Status()
}

type ApplicationWebhookHealth_Healthy struct {
	Healthy *ApplicationWebhookHealth_WebhookHealthStatusHealthy `protobuf:"bytes,1,opt,name=healthy,proto3,oneof"`
}

type ApplicationWebhookHealth_Unhealthy struct {
	Unhealthy *ApplicationWebhookHealth_WebhookHealthStatusUnhealthy `protobuf:"bytes,2,opt,name=unhealthy,proto3,oneof"`
}

func (*ApplicationWebhookHealth_Healthy) isApplicationWebhookHealth_Status() {}

func (*ApplicationWebhookHealth_Unhealthy) isApplicationWebhookHealth_Status() {}

type ApplicationWebhook struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids       *ApplicationWebhookIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	CreatedAt *timestamppb.Timestamp         `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	UpdatedAt *timestamppb.Timestamp         `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Base URL to which the message's path is appended.
	BaseUrl string `protobuf:"bytes,4,opt,name=base_url,json=baseUrl,proto3" json:"base_url,omitempty"`
	// HTTP headers to use.
	Headers map[string]string `protobuf:"bytes,5,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The format to use for the body.
	// Supported values depend on the Application Server configuration.
	Format string `protobuf:"bytes,6,opt,name=format,proto3" json:"format,omitempty"`
	// The ID of the template that was used to create the Webhook.
	TemplateIds *ApplicationWebhookTemplateIdentifiers `protobuf:"bytes,15,opt,name=template_ids,json=templateIds,proto3" json:"template_ids,omitempty"`
	// The value of the fields used by the template. Maps field.id to the value.
	TemplateFields map[string]string `protobuf:"bytes,16,rep,name=template_fields,json=templateFields,proto3" json:"template_fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The API key to be used for downlink queue operations.
	// The field is provided for convenience reasons, and can contain API keys with additional rights (albeit this is discouraged).
	DownlinkApiKey           string                      `protobuf:"bytes,17,opt,name=downlink_api_key,json=downlinkApiKey,proto3" json:"downlink_api_key,omitempty"`
	UplinkMessage            *ApplicationWebhook_Message `protobuf:"bytes,7,opt,name=uplink_message,json=uplinkMessage,proto3" json:"uplink_message,omitempty"`
	UplinkNormalized         *ApplicationWebhook_Message `protobuf:"bytes,22,opt,name=uplink_normalized,json=uplinkNormalized,proto3" json:"uplink_normalized,omitempty"`
	JoinAccept               *ApplicationWebhook_Message `protobuf:"bytes,8,opt,name=join_accept,json=joinAccept,proto3" json:"join_accept,omitempty"`
	DownlinkAck              *ApplicationWebhook_Message `protobuf:"bytes,9,opt,name=downlink_ack,json=downlinkAck,proto3" json:"downlink_ack,omitempty"`
	DownlinkNack             *ApplicationWebhook_Message `protobuf:"bytes,10,opt,name=downlink_nack,json=downlinkNack,proto3" json:"downlink_nack,omitempty"`
	DownlinkSent             *ApplicationWebhook_Message `protobuf:"bytes,11,opt,name=downlink_sent,json=downlinkSent,proto3" json:"downlink_sent,omitempty"`
	DownlinkFailed           *ApplicationWebhook_Message `protobuf:"bytes,12,opt,name=downlink_failed,json=downlinkFailed,proto3" json:"downlink_failed,omitempty"`
	DownlinkQueued           *ApplicationWebhook_Message `protobuf:"bytes,13,opt,name=downlink_queued,json=downlinkQueued,proto3" json:"downlink_queued,omitempty"`
	DownlinkQueueInvalidated *ApplicationWebhook_Message `protobuf:"bytes,19,opt,name=downlink_queue_invalidated,json=downlinkQueueInvalidated,proto3" json:"downlink_queue_invalidated,omitempty"`
	LocationSolved           *ApplicationWebhook_Message `protobuf:"bytes,14,opt,name=location_solved,json=locationSolved,proto3" json:"location_solved,omitempty"`
	ServiceData              *ApplicationWebhook_Message `protobuf:"bytes,18,opt,name=service_data,json=serviceData,proto3" json:"service_data,omitempty"`
	HealthStatus             *ApplicationWebhookHealth   `protobuf:"bytes,20,opt,name=health_status,json=healthStatus,proto3" json:"health_status,omitempty"`
	FieldMask                *fieldmaskpb.FieldMask      `protobuf:"bytes,21,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// Set to temporarily pause forwarding uplink data to this end point and receiving downlinks from this end point.
	Paused bool `protobuf:"varint,24,opt,name=paused,proto3" json:"paused,omitempty"`
}

func (x *ApplicationWebhook) Reset() {
	*x = ApplicationWebhook{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationWebhook) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationWebhook) ProtoMessage() {}

func (x *ApplicationWebhook) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationWebhook.ProtoReflect.Descriptor instead.
func (*ApplicationWebhook) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{6}
}

func (x *ApplicationWebhook) GetIds() *ApplicationWebhookIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *ApplicationWebhook) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *ApplicationWebhook) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *ApplicationWebhook) GetBaseUrl() string {
	if x != nil {
		return x.BaseUrl
	}
	return ""
}

func (x *ApplicationWebhook) GetHeaders() map[string]string {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *ApplicationWebhook) GetFormat() string {
	if x != nil {
		return x.Format
	}
	return ""
}

func (x *ApplicationWebhook) GetTemplateIds() *ApplicationWebhookTemplateIdentifiers {
	if x != nil {
		return x.TemplateIds
	}
	return nil
}

func (x *ApplicationWebhook) GetTemplateFields() map[string]string {
	if x != nil {
		return x.TemplateFields
	}
	return nil
}

func (x *ApplicationWebhook) GetDownlinkApiKey() string {
	if x != nil {
		return x.DownlinkApiKey
	}
	return ""
}

func (x *ApplicationWebhook) GetUplinkMessage() *ApplicationWebhook_Message {
	if x != nil {
		return x.UplinkMessage
	}
	return nil
}

func (x *ApplicationWebhook) GetUplinkNormalized() *ApplicationWebhook_Message {
	if x != nil {
		return x.UplinkNormalized
	}
	return nil
}

func (x *ApplicationWebhook) GetJoinAccept() *ApplicationWebhook_Message {
	if x != nil {
		return x.JoinAccept
	}
	return nil
}

func (x *ApplicationWebhook) GetDownlinkAck() *ApplicationWebhook_Message {
	if x != nil {
		return x.DownlinkAck
	}
	return nil
}

func (x *ApplicationWebhook) GetDownlinkNack() *ApplicationWebhook_Message {
	if x != nil {
		return x.DownlinkNack
	}
	return nil
}

func (x *ApplicationWebhook) GetDownlinkSent() *ApplicationWebhook_Message {
	if x != nil {
		return x.DownlinkSent
	}
	return nil
}

func (x *ApplicationWebhook) GetDownlinkFailed() *ApplicationWebhook_Message {
	if x != nil {
		return x.DownlinkFailed
	}
	return nil
}

func (x *ApplicationWebhook) GetDownlinkQueued() *ApplicationWebhook_Message {
	if x != nil {
		return x.DownlinkQueued
	}
	return nil
}

func (x *ApplicationWebhook) GetDownlinkQueueInvalidated() *ApplicationWebhook_Message {
	if x != nil {
		return x.DownlinkQueueInvalidated
	}
	return nil
}

func (x *ApplicationWebhook) GetLocationSolved() *ApplicationWebhook_Message {
	if x != nil {
		return x.LocationSolved
	}
	return nil
}

func (x *ApplicationWebhook) GetServiceData() *ApplicationWebhook_Message {
	if x != nil {
		return x.ServiceData
	}
	return nil
}

func (x *ApplicationWebhook) GetHealthStatus() *ApplicationWebhookHealth {
	if x != nil {
		return x.HealthStatus
	}
	return nil
}

func (x *ApplicationWebhook) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

func (x *ApplicationWebhook) GetPaused() bool {
	if x != nil {
		return x.Paused
	}
	return false
}

type ApplicationWebhooks struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Webhooks []*ApplicationWebhook `protobuf:"bytes,1,rep,name=webhooks,proto3" json:"webhooks,omitempty"`
}

func (x *ApplicationWebhooks) Reset() {
	*x = ApplicationWebhooks{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationWebhooks) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationWebhooks) ProtoMessage() {}

func (x *ApplicationWebhooks) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationWebhooks.ProtoReflect.Descriptor instead.
func (*ApplicationWebhooks) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{7}
}

func (x *ApplicationWebhooks) GetWebhooks() []*ApplicationWebhook {
	if x != nil {
		return x.Webhooks
	}
	return nil
}

type ApplicationWebhookFormats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Format and description.
	Formats map[string]string `protobuf:"bytes,1,rep,name=formats,proto3" json:"formats,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ApplicationWebhookFormats) Reset() {
	*x = ApplicationWebhookFormats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationWebhookFormats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationWebhookFormats) ProtoMessage() {}

func (x *ApplicationWebhookFormats) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationWebhookFormats.ProtoReflect.Descriptor instead.
func (*ApplicationWebhookFormats) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{8}
}

func (x *ApplicationWebhookFormats) GetFormats() map[string]string {
	if x != nil {
		return x.Formats
	}
	return nil
}

type GetApplicationWebhookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids       *ApplicationWebhookIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	FieldMask *fieldmaskpb.FieldMask         `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetApplicationWebhookRequest) Reset() {
	*x = GetApplicationWebhookRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetApplicationWebhookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetApplicationWebhookRequest) ProtoMessage() {}

func (x *GetApplicationWebhookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetApplicationWebhookRequest.ProtoReflect.Descriptor instead.
func (*GetApplicationWebhookRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{9}
}

func (x *GetApplicationWebhookRequest) GetIds() *ApplicationWebhookIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *GetApplicationWebhookRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type ListApplicationWebhooksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApplicationIds *ApplicationIdentifiers `protobuf:"bytes,1,opt,name=application_ids,json=applicationIds,proto3" json:"application_ids,omitempty"`
	FieldMask      *fieldmaskpb.FieldMask  `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *ListApplicationWebhooksRequest) Reset() {
	*x = ListApplicationWebhooksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListApplicationWebhooksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListApplicationWebhooksRequest) ProtoMessage() {}

func (x *ListApplicationWebhooksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListApplicationWebhooksRequest.ProtoReflect.Descriptor instead.
func (*ListApplicationWebhooksRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{10}
}

func (x *ListApplicationWebhooksRequest) GetApplicationIds() *ApplicationIdentifiers {
	if x != nil {
		return x.ApplicationIds
	}
	return nil
}

func (x *ListApplicationWebhooksRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type SetApplicationWebhookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Webhook   *ApplicationWebhook    `protobuf:"bytes,1,opt,name=webhook,proto3" json:"webhook,omitempty"`
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *SetApplicationWebhookRequest) Reset() {
	*x = SetApplicationWebhookRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetApplicationWebhookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetApplicationWebhookRequest) ProtoMessage() {}

func (x *SetApplicationWebhookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetApplicationWebhookRequest.ProtoReflect.Descriptor instead.
func (*SetApplicationWebhookRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{11}
}

func (x *SetApplicationWebhookRequest) GetWebhook() *ApplicationWebhook {
	if x != nil {
		return x.Webhook
	}
	return nil
}

func (x *SetApplicationWebhookRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type GetApplicationWebhookTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids       *ApplicationWebhookTemplateIdentifiers `protobuf:"bytes,1,opt,name=ids,proto3" json:"ids,omitempty"`
	FieldMask *fieldmaskpb.FieldMask                 `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetApplicationWebhookTemplateRequest) Reset() {
	*x = GetApplicationWebhookTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetApplicationWebhookTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetApplicationWebhookTemplateRequest) ProtoMessage() {}

func (x *GetApplicationWebhookTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetApplicationWebhookTemplateRequest.ProtoReflect.Descriptor instead.
func (*GetApplicationWebhookTemplateRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{12}
}

func (x *GetApplicationWebhookTemplateRequest) GetIds() *ApplicationWebhookTemplateIdentifiers {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *GetApplicationWebhookTemplateRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type ListApplicationWebhookTemplatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *ListApplicationWebhookTemplatesRequest) Reset() {
	*x = ListApplicationWebhookTemplatesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListApplicationWebhookTemplatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListApplicationWebhookTemplatesRequest) ProtoMessage() {}

func (x *ListApplicationWebhookTemplatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListApplicationWebhookTemplatesRequest.ProtoReflect.Descriptor instead.
func (*ListApplicationWebhookTemplatesRequest) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{13}
}

func (x *ListApplicationWebhookTemplatesRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type ApplicationWebhookTemplate_Message struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to append to the base URL. Can contain template fields, in RFC 6570 format.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *ApplicationWebhookTemplate_Message) Reset() {
	*x = ApplicationWebhookTemplate_Message{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationWebhookTemplate_Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationWebhookTemplate_Message) ProtoMessage() {}

func (x *ApplicationWebhookTemplate_Message) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationWebhookTemplate_Message.ProtoReflect.Descriptor instead.
func (*ApplicationWebhookTemplate_Message) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{3, 1}
}

func (x *ApplicationWebhookTemplate_Message) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

type ApplicationWebhookHealth_WebhookHealthStatusHealthy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ApplicationWebhookHealth_WebhookHealthStatusHealthy) Reset() {
	*x = ApplicationWebhookHealth_WebhookHealthStatusHealthy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationWebhookHealth_WebhookHealthStatusHealthy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationWebhookHealth_WebhookHealthStatusHealthy) ProtoMessage() {}

func (x *ApplicationWebhookHealth_WebhookHealthStatusHealthy) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationWebhookHealth_WebhookHealthStatusHealthy.ProtoReflect.Descriptor instead.
func (*ApplicationWebhookHealth_WebhookHealthStatusHealthy) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{5, 0}
}

type ApplicationWebhookHealth_WebhookHealthStatusUnhealthy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FailedAttempts           uint64                 `protobuf:"varint,1,opt,name=failed_attempts,json=failedAttempts,proto3" json:"failed_attempts,omitempty"`
	LastFailedAttemptAt      *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=last_failed_attempt_at,json=lastFailedAttemptAt,proto3" json:"last_failed_attempt_at,omitempty"`
	LastFailedAttemptDetails *ErrorDetails          `protobuf:"bytes,3,opt,name=last_failed_attempt_details,json=lastFailedAttemptDetails,proto3" json:"last_failed_attempt_details,omitempty"`
}

func (x *ApplicationWebhookHealth_WebhookHealthStatusUnhealthy) Reset() {
	*x = ApplicationWebhookHealth_WebhookHealthStatusUnhealthy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationWebhookHealth_WebhookHealthStatusUnhealthy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationWebhookHealth_WebhookHealthStatusUnhealthy) ProtoMessage() {}

func (x *ApplicationWebhookHealth_WebhookHealthStatusUnhealthy) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationWebhookHealth_WebhookHealthStatusUnhealthy.ProtoReflect.Descriptor instead.
func (*ApplicationWebhookHealth_WebhookHealthStatusUnhealthy) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{5, 1}
}

func (x *ApplicationWebhookHealth_WebhookHealthStatusUnhealthy) GetFailedAttempts() uint64 {
	if x != nil {
		return x.FailedAttempts
	}
	return 0
}

func (x *ApplicationWebhookHealth_WebhookHealthStatusUnhealthy) GetLastFailedAttemptAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastFailedAttemptAt
	}
	return nil
}

func (x *ApplicationWebhookHealth_WebhookHealthStatusUnhealthy) GetLastFailedAttemptDetails() *ErrorDetails {
	if x != nil {
		return x.LastFailedAttemptDetails
	}
	return nil
}

type ApplicationWebhook_Message struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to append to the base URL.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *ApplicationWebhook_Message) Reset() {
	*x = ApplicationWebhook_Message{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationWebhook_Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationWebhook_Message) ProtoMessage() {}

func (x *ApplicationWebhook_Message) ProtoReflect() protoreflect.Message {
	mi := &file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationWebhook_Message.ProtoReflect.Descriptor instead.
func (*ApplicationWebhook_Message) Descriptor() ([]byte, []int) {
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP(), []int{6, 2}
}

func (x *ApplicationWebhook_Message) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

var File_ttn_lorawan_v3_applicationserver_web_proto protoreflect.FileDescriptor

var file_ttn_lorawan_v3_applicationserver_web_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x74, 0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33,
	0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x5f, 0x77, 0x65, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32,
	0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x74, 0x68, 0x65, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x74,
	0x74, 0x6e, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x74, 0x74, 0x6e, 0x2f, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2f, 0x76, 0x33, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcc, 0x01, 0x0a, 0x1d, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x59, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x73, 0x12, 0x46, 0x0a, 0x0a, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x42, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e,
	0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f,
	0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x09,
	0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x49, 0x64, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08,
	0x01, 0x10, 0x01, 0x22, 0x7b, 0x0a, 0x25, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x48, 0x0a, 0x0b,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x27, 0xfa, 0x42, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d,
	0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a,
	0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x0a, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x49, 0x64, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01,
	0x22, 0x84, 0x02, 0x0a, 0x1f, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x12, 0x37, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x27, 0xfa, 0x42, 0x24, 0x72, 0x22, 0x18, 0x24, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a,
	0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30,
	0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1b, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04,
	0x72, 0x02, 0x18, 0x14, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x2c, 0x0a,
	0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x64, 0x52, 0x0c, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x22, 0xa1, 0x0e, 0x0a, 0x1a, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x51, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x1b, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18, 0x14,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04,
	0x72, 0x02, 0x18, 0x64, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x23, 0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x6f, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x88, 0x01, 0x01, 0x52, 0x07, 0x6c,
	0x6f, 0x67, 0x6f, 0x55, 0x72, 0x6c, 0x12, 0x23, 0x0a, 0x08, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x75,
	0x72, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x88,
	0x01, 0x01, 0x52, 0x07, 0x69, 0x6e, 0x66, 0x6f, 0x55, 0x72, 0x6c, 0x12, 0x35, 0x0a, 0x11, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x6c,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x88, 0x01, 0x01,
	0x52, 0x10, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55,
	0x72, 0x6c, 0x12, 0x23, 0x0a, 0x08, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x88, 0x01, 0x01, 0x52, 0x07,
	0x62, 0x61, 0x73, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x68, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x15, 0xfa, 0x42, 0x12, 0x9a, 0x01, 0x0f, 0x10, 0x32, 0x22, 0x04, 0x72, 0x02, 0x18,
	0x40, 0x2a, 0x05, 0x72, 0x03, 0x18, 0x80, 0x02, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x12, 0x3f, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x27, 0xfa, 0x42, 0x24, 0x72, 0x22, 0x18, 0x14, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d,
	0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a,
	0x30, 0x2d, 0x39, 0x5d, 0x29, 0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x35, 0x0a, 0x17, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x61,
	0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x41, 0x70, 0x69, 0x4b,
	0x65, 0x79, 0x12, 0x59, 0x0a, 0x0e, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d,
	0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x5f, 0x0a,
	0x11, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x64, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x10, 0x75, 0x70,
	0x6c, 0x69, 0x6e, 0x6b, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x12, 0x53,
	0x0a, 0x0b, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0a, 0x6a, 0x6f, 0x69, 0x6e, 0x41, 0x63, 0x63,
	0x65, 0x70, 0x74, 0x12, 0x55, 0x0a, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f,
	0x61, 0x63, 0x6b, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0b, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x41, 0x63, 0x6b, 0x12, 0x57, 0x0a, 0x0d, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6e, 0x61, 0x63, 0x6b, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x4e,
	0x61, 0x63, 0x6b, 0x12, 0x57, 0x0a, 0x0d, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f,
	0x73, 0x65, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0c,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x53, 0x65, 0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x0f,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0e, 0x64, 0x6f, 0x77, 0x6e, 0x6c,
	0x69, 0x6e, 0x6b, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x0f, 0x64, 0x6f, 0x77,
	0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0e, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b,
	0x51, 0x75, 0x65, 0x75, 0x65, 0x64, 0x12, 0x70, 0x0a, 0x1a, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69,
	0x6e, 0x6b, 0x5f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x64, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x18,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x51, 0x75, 0x65, 0x75, 0x65, 0x49, 0x6e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x0f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x6f, 0x6c, 0x76, 0x65, 0x64, 0x12, 0x55, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x39, 0x0a, 0x0a,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x1a, 0x3a, 0x0a, 0x0c, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x1a, 0x26, 0x0a, 0x07, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1b,
	0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42,
	0x04, 0x72, 0x02, 0x18, 0x40, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x67, 0x0a, 0x1b, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f,
	0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x09, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f,
	0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x09, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x22, 0xaa, 0x04, 0x0a, 0x18, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x12, 0x5f, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x43, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x57, 0x65, 0x62,
	0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x48, 0x00, 0x52, 0x07, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x79, 0x12, 0x65, 0x0a, 0x09, 0x75, 0x6e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x55, 0x6e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x48, 0x00, 0x52, 0x09,
	0x75, 0x6e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x1a, 0x26, 0x0a, 0x1a, 0x57, 0x65, 0x62,
	0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10,
	0x00, 0x1a, 0x89, 0x02, 0x0a, 0x1c, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x55, 0x6e, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x74,
	0x65, 0x6d, 0x70, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x66, 0x61, 0x69,
	0x6c, 0x65, 0x64, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x12, 0x59, 0x0a, 0x16, 0x6c,
	0x61, 0x73, 0x74, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d,
	0x70, 0x74, 0x5f, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x08, 0xfa, 0x42, 0x05, 0xb2, 0x01, 0x02, 0x08,
	0x01, 0x52, 0x13, 0x6c, 0x61, 0x73, 0x74, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x41, 0x74, 0x74,
	0x65, 0x6d, 0x70, 0x74, 0x41, 0x74, 0x12, 0x5b, 0x0a, 0x1b, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x66,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x18, 0x6c, 0x61, 0x73, 0x74, 0x46,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x00, 0x3a, 0x08, 0xf2,
	0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x00, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x22, 0xb4, 0x0f, 0x0a, 0x12, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x12, 0x51, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x73, 0x42, 0x10, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0xf2, 0xaa,
	0x19, 0x04, 0x08, 0x00, 0x28, 0x01, 0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x43, 0x0a, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x08, 0xf2, 0xaa, 0x19,
	0x04, 0x08, 0x00, 0x10, 0x00, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74,
	0x12, 0x43, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x00, 0x10, 0x00, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x23, 0x0a, 0x08, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x72,
	0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x88, 0x01,
	0x01, 0x52, 0x07, 0x62, 0x61, 0x73, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x60, 0x0a, 0x07, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x15, 0xfa, 0x42,
	0x12, 0x9a, 0x01, 0x0f, 0x10, 0x32, 0x22, 0x04, 0x72, 0x02, 0x18, 0x40, 0x2a, 0x05, 0x72, 0x03,
	0x18, 0x80, 0x20, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x3f, 0x0a, 0x06,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x42,
	0x24, 0x72, 0x22, 0x18, 0x14, 0x32, 0x1e, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d,
	0x28, 0x3f, 0x3a, 0x5b, 0x2d, 0x5d, 0x3f, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x29,
	0x7b, 0x32, 0x2c, 0x7d, 0x24, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x58, 0x0a,
	0x0c, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x0b, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x49, 0x64, 0x73, 0x12, 0x5f, 0x0a, 0x0f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62,
	0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x32, 0x0a, 0x10, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x18, 0x80, 0x01, 0x52, 0x0e, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x41, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x12, 0x51, 0x0a, 0x0e,
	0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x0d, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x57, 0x0a, 0x11, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e,
	0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x10, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x4e, 0x6f,
	0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x12, 0x4b, 0x0a, 0x0b, 0x6a, 0x6f, 0x69, 0x6e,
	0x5f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f,
	0x6b, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0a, 0x6a, 0x6f, 0x69, 0x6e, 0x41,
	0x63, 0x63, 0x65, 0x70, 0x74, 0x12, 0x4d, 0x0a, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e,
	0x6b, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0b, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e,
	0x6b, 0x41, 0x63, 0x6b, 0x12, 0x4f, 0x0a, 0x0d, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b,
	0x5f, 0x6e, 0x61, 0x63, 0x6b, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74,
	0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e,
	0x6b, 0x4e, 0x61, 0x63, 0x6b, 0x12, 0x4f, 0x0a, 0x0d, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e,
	0x6b, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74,
	0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69,
	0x6e, 0x6b, 0x53, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x0f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69,
	0x6e, 0x6b, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68,
	0x6f, 0x6f, 0x6b, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0e, 0x64, 0x6f, 0x77,
	0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x12, 0x53, 0x0a, 0x0f, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x0e, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x51, 0x75, 0x65, 0x75, 0x65, 0x64,
	0x12, 0x68, 0x0a, 0x1a, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x71, 0x75, 0x65,
	0x75, 0x65, 0x5f, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x18, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x51, 0x75, 0x65, 0x75, 0x65, 0x49,
	0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x12, 0x53, 0x0a, 0x0f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61,
	0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x12,
	0x4d, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x4d,
	0x0a, 0x0d, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x52,
	0x0c, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x39, 0x0a,
	0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x15, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x75, 0x73,
	0x65, 0x64, 0x18, 0x18, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x70, 0x61, 0x75, 0x73, 0x65, 0x64,
	0x1a, 0x3a, 0x0a, 0x0c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x41, 0x0a, 0x13,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0x30, 0x0a, 0x07, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x18,
	0x40, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10,
	0x01, 0x3a, 0x08, 0xf2, 0xaa, 0x19, 0x04, 0x08, 0x01, 0x10, 0x01, 0x4a, 0x04, 0x08, 0x17, 0x10,
	0x18, 0x52, 0x05, 0x71, 0x75, 0x65, 0x75, 0x65, 0x22, 0x55, 0x0a, 0x13, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x12,
	0x3e, 0x0a, 0x08, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x08, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x22,
	0xa9, 0x01, 0x0a, 0x19, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x12, 0x50, 0x0a,
	0x07, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f,
	0x6f, 0x6b, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x1a,
	0x3a, 0x0a, 0x0c, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa4, 0x01, 0x0a, 0x1c,
	0x47, 0x65, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x03,
	0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0xb6, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73,
	0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa1, 0x01, 0x0a, 0x1c,
	0x53, 0x65, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x07,
	0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f,
	0x6b, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x07, 0x77, 0x65, 0x62,
	0x68, 0x6f, 0x6f, 0x6b, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0xb4, 0x01, 0x0a, 0x24, 0x47, 0x65, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x63, 0x0a, 0x26, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x32, 0xb2, 0x09, 0x0a, 0x1a,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f,
	0x6f, 0x6b, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x12, 0x6c, 0x0a, 0x0a, 0x47, 0x65,
	0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x1a, 0x29, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62,
	0x68, 0x6f, 0x6f, 0x6b, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x22, 0x1b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x15, 0x12, 0x13, 0x2f, 0x61, 0x73, 0x2f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x2d, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x12, 0xa0, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x34, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c,
	0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a,
	0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f,
	0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x2f, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x29, 0x12, 0x27, 0x2f, 0x61, 0x73, 0x2f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2d,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x64, 0x73, 0x2e, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x93, 0x01, 0x0a, 0x0d,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0x36, 0x2e,
	0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61,
	0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x22, 0x1d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x17, 0x12, 0x15, 0x2f, 0x61, 0x73, 0x2f,
	0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2d, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x12, 0xa3, 0x01, 0x0a, 0x03, 0x47, 0x65, 0x74, 0x12, 0x2c, 0x2e, 0x74, 0x74, 0x6e, 0x2e,
	0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f,
	0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x22, 0x4a, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x61, 0x73, 0x2f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x73, 0x2f, 0x7b, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7b, 0x69, 0x64, 0x73, 0x2e, 0x77, 0x65, 0x62, 0x68,
	0x6f, 0x6f, 0x6b, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x92, 0x01, 0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x2e, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x23, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62,
	0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f,
	0x61, 0x73, 0x2f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0xf8, 0x01, 0x0a,
	0x03, 0x53, 0x65, 0x74, 0x12, 0x2c, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77,
	0x61, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x22, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x22, 0x9e, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x97, 0x01,
	0x3a, 0x01, 0x2a, 0x5a, 0x3e, 0x3a, 0x01, 0x2a, 0x22, 0x39, 0x2f, 0x61, 0x73, 0x2f, 0x77, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x7b, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e,
	0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x7d, 0x1a, 0x52, 0x2f, 0x61, 0x73, 0x2f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x73, 0x2f, 0x7b, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x69, 0x64, 0x73, 0x2e, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x2e, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7b,
	0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x69, 0x64, 0x73, 0x2e, 0x77, 0x65, 0x62, 0x68,
	0x6f, 0x6f, 0x6b, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x93, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x12, 0x2d, 0x2e, 0x74, 0x74, 0x6e, 0x2e, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3c, 0x2a, 0x3a, 0x2f, 0x61, 0x73, 0x2f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x2f,
	0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73,
	0x2e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x7b, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x69, 0x64, 0x7d, 0x1a, 0x21, 0x92,
	0x41, 0x1e, 0x12, 0x1c, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x20, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x2e,
	0x42, 0x31, 0x5a, 0x2f, 0x67, 0x6f, 0x2e, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6f, 0x72, 0x61, 0x77, 0x61, 0x6e,
	0x2d, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x74,
	0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ttn_lorawan_v3_applicationserver_web_proto_rawDescOnce sync.Once
	file_ttn_lorawan_v3_applicationserver_web_proto_rawDescData = file_ttn_lorawan_v3_applicationserver_web_proto_rawDesc
)

func file_ttn_lorawan_v3_applicationserver_web_proto_rawDescGZIP() []byte {
	file_ttn_lorawan_v3_applicationserver_web_proto_rawDescOnce.Do(func() {
		file_ttn_lorawan_v3_applicationserver_web_proto_rawDescData = protoimpl.X.CompressGZIP(file_ttn_lorawan_v3_applicationserver_web_proto_rawDescData)
	})
	return file_ttn_lorawan_v3_applicationserver_web_proto_rawDescData
}

var file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_ttn_lorawan_v3_applicationserver_web_proto_goTypes = []interface{}{
	(*ApplicationWebhookIdentifiers)(nil),          // 0: ttn.lorawan.v3.ApplicationWebhookIdentifiers
	(*ApplicationWebhookTemplateIdentifiers)(nil),  // 1: ttn.lorawan.v3.ApplicationWebhookTemplateIdentifiers
	(*ApplicationWebhookTemplateField)(nil),        // 2: ttn.lorawan.v3.ApplicationWebhookTemplateField
	(*ApplicationWebhookTemplate)(nil),             // 3: ttn.lorawan.v3.ApplicationWebhookTemplate
	(*ApplicationWebhookTemplates)(nil),            // 4: ttn.lorawan.v3.ApplicationWebhookTemplates
	(*ApplicationWebhookHealth)(nil),               // 5: ttn.lorawan.v3.ApplicationWebhookHealth
	(*ApplicationWebhook)(nil),                     // 6: ttn.lorawan.v3.ApplicationWebhook
	(*ApplicationWebhooks)(nil),                    // 7: ttn.lorawan.v3.ApplicationWebhooks
	(*ApplicationWebhookFormats)(nil),              // 8: ttn.lorawan.v3.ApplicationWebhookFormats
	(*GetApplicationWebhookRequest)(nil),           // 9: ttn.lorawan.v3.GetApplicationWebhookRequest
	(*ListApplicationWebhooksRequest)(nil),         // 10: ttn.lorawan.v3.ListApplicationWebhooksRequest
	(*SetApplicationWebhookRequest)(nil),           // 11: ttn.lorawan.v3.SetApplicationWebhookRequest
	(*GetApplicationWebhookTemplateRequest)(nil),   // 12: ttn.lorawan.v3.GetApplicationWebhookTemplateRequest
	(*ListApplicationWebhookTemplatesRequest)(nil), // 13: ttn.lorawan.v3.ListApplicationWebhookTemplatesRequest
	nil, // 14: ttn.lorawan.v3.ApplicationWebhookTemplate.HeadersEntry
	(*ApplicationWebhookTemplate_Message)(nil),                    // 15: ttn.lorawan.v3.ApplicationWebhookTemplate.Message
	(*ApplicationWebhookHealth_WebhookHealthStatusHealthy)(nil),   // 16: ttn.lorawan.v3.ApplicationWebhookHealth.WebhookHealthStatusHealthy
	(*ApplicationWebhookHealth_WebhookHealthStatusUnhealthy)(nil), // 17: ttn.lorawan.v3.ApplicationWebhookHealth.WebhookHealthStatusUnhealthy
	nil,                                // 18: ttn.lorawan.v3.ApplicationWebhook.HeadersEntry
	nil,                                // 19: ttn.lorawan.v3.ApplicationWebhook.TemplateFieldsEntry
	(*ApplicationWebhook_Message)(nil), // 20: ttn.lorawan.v3.ApplicationWebhook.Message
	nil,                                // 21: ttn.lorawan.v3.ApplicationWebhookFormats.FormatsEntry
	(*ApplicationIdentifiers)(nil),     // 22: ttn.lorawan.v3.ApplicationIdentifiers
	(*fieldmaskpb.FieldMask)(nil),      // 23: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),      // 24: google.protobuf.Timestamp
	(*ErrorDetails)(nil),               // 25: ttn.lorawan.v3.ErrorDetails
	(*emptypb.Empty)(nil),              // 26: google.protobuf.Empty
}
var file_ttn_lorawan_v3_applicationserver_web_proto_depIdxs = []int32{
	22, // 0: ttn.lorawan.v3.ApplicationWebhookIdentifiers.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	1,  // 1: ttn.lorawan.v3.ApplicationWebhookTemplate.ids:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplateIdentifiers
	14, // 2: ttn.lorawan.v3.ApplicationWebhookTemplate.headers:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplate.HeadersEntry
	2,  // 3: ttn.lorawan.v3.ApplicationWebhookTemplate.fields:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplateField
	15, // 4: ttn.lorawan.v3.ApplicationWebhookTemplate.uplink_message:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplate.Message
	15, // 5: ttn.lorawan.v3.ApplicationWebhookTemplate.uplink_normalized:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplate.Message
	15, // 6: ttn.lorawan.v3.ApplicationWebhookTemplate.join_accept:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplate.Message
	15, // 7: ttn.lorawan.v3.ApplicationWebhookTemplate.downlink_ack:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplate.Message
	15, // 8: ttn.lorawan.v3.ApplicationWebhookTemplate.downlink_nack:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplate.Message
	15, // 9: ttn.lorawan.v3.ApplicationWebhookTemplate.downlink_sent:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplate.Message
	15, // 10: ttn.lorawan.v3.ApplicationWebhookTemplate.downlink_failed:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplate.Message
	15, // 11: ttn.lorawan.v3.ApplicationWebhookTemplate.downlink_queued:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplate.Message
	15, // 12: ttn.lorawan.v3.ApplicationWebhookTemplate.downlink_queue_invalidated:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplate.Message
	15, // 13: ttn.lorawan.v3.ApplicationWebhookTemplate.location_solved:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplate.Message
	15, // 14: ttn.lorawan.v3.ApplicationWebhookTemplate.service_data:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplate.Message
	23, // 15: ttn.lorawan.v3.ApplicationWebhookTemplate.field_mask:type_name -> google.protobuf.FieldMask
	3,  // 16: ttn.lorawan.v3.ApplicationWebhookTemplates.templates:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplate
	16, // 17: ttn.lorawan.v3.ApplicationWebhookHealth.healthy:type_name -> ttn.lorawan.v3.ApplicationWebhookHealth.WebhookHealthStatusHealthy
	17, // 18: ttn.lorawan.v3.ApplicationWebhookHealth.unhealthy:type_name -> ttn.lorawan.v3.ApplicationWebhookHealth.WebhookHealthStatusUnhealthy
	0,  // 19: ttn.lorawan.v3.ApplicationWebhook.ids:type_name -> ttn.lorawan.v3.ApplicationWebhookIdentifiers
	24, // 20: ttn.lorawan.v3.ApplicationWebhook.created_at:type_name -> google.protobuf.Timestamp
	24, // 21: ttn.lorawan.v3.ApplicationWebhook.updated_at:type_name -> google.protobuf.Timestamp
	18, // 22: ttn.lorawan.v3.ApplicationWebhook.headers:type_name -> ttn.lorawan.v3.ApplicationWebhook.HeadersEntry
	1,  // 23: ttn.lorawan.v3.ApplicationWebhook.template_ids:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplateIdentifiers
	19, // 24: ttn.lorawan.v3.ApplicationWebhook.template_fields:type_name -> ttn.lorawan.v3.ApplicationWebhook.TemplateFieldsEntry
	20, // 25: ttn.lorawan.v3.ApplicationWebhook.uplink_message:type_name -> ttn.lorawan.v3.ApplicationWebhook.Message
	20, // 26: ttn.lorawan.v3.ApplicationWebhook.uplink_normalized:type_name -> ttn.lorawan.v3.ApplicationWebhook.Message
	20, // 27: ttn.lorawan.v3.ApplicationWebhook.join_accept:type_name -> ttn.lorawan.v3.ApplicationWebhook.Message
	20, // 28: ttn.lorawan.v3.ApplicationWebhook.downlink_ack:type_name -> ttn.lorawan.v3.ApplicationWebhook.Message
	20, // 29: ttn.lorawan.v3.ApplicationWebhook.downlink_nack:type_name -> ttn.lorawan.v3.ApplicationWebhook.Message
	20, // 30: ttn.lorawan.v3.ApplicationWebhook.downlink_sent:type_name -> ttn.lorawan.v3.ApplicationWebhook.Message
	20, // 31: ttn.lorawan.v3.ApplicationWebhook.downlink_failed:type_name -> ttn.lorawan.v3.ApplicationWebhook.Message
	20, // 32: ttn.lorawan.v3.ApplicationWebhook.downlink_queued:type_name -> ttn.lorawan.v3.ApplicationWebhook.Message
	20, // 33: ttn.lorawan.v3.ApplicationWebhook.downlink_queue_invalidated:type_name -> ttn.lorawan.v3.ApplicationWebhook.Message
	20, // 34: ttn.lorawan.v3.ApplicationWebhook.location_solved:type_name -> ttn.lorawan.v3.ApplicationWebhook.Message
	20, // 35: ttn.lorawan.v3.ApplicationWebhook.service_data:type_name -> ttn.lorawan.v3.ApplicationWebhook.Message
	5,  // 36: ttn.lorawan.v3.ApplicationWebhook.health_status:type_name -> ttn.lorawan.v3.ApplicationWebhookHealth
	23, // 37: ttn.lorawan.v3.ApplicationWebhook.field_mask:type_name -> google.protobuf.FieldMask
	6,  // 38: ttn.lorawan.v3.ApplicationWebhooks.webhooks:type_name -> ttn.lorawan.v3.ApplicationWebhook
	21, // 39: ttn.lorawan.v3.ApplicationWebhookFormats.formats:type_name -> ttn.lorawan.v3.ApplicationWebhookFormats.FormatsEntry
	0,  // 40: ttn.lorawan.v3.GetApplicationWebhookRequest.ids:type_name -> ttn.lorawan.v3.ApplicationWebhookIdentifiers
	23, // 41: ttn.lorawan.v3.GetApplicationWebhookRequest.field_mask:type_name -> google.protobuf.FieldMask
	22, // 42: ttn.lorawan.v3.ListApplicationWebhooksRequest.application_ids:type_name -> ttn.lorawan.v3.ApplicationIdentifiers
	23, // 43: ttn.lorawan.v3.ListApplicationWebhooksRequest.field_mask:type_name -> google.protobuf.FieldMask
	6,  // 44: ttn.lorawan.v3.SetApplicationWebhookRequest.webhook:type_name -> ttn.lorawan.v3.ApplicationWebhook
	23, // 45: ttn.lorawan.v3.SetApplicationWebhookRequest.field_mask:type_name -> google.protobuf.FieldMask
	1,  // 46: ttn.lorawan.v3.GetApplicationWebhookTemplateRequest.ids:type_name -> ttn.lorawan.v3.ApplicationWebhookTemplateIdentifiers
	23, // 47: ttn.lorawan.v3.GetApplicationWebhookTemplateRequest.field_mask:type_name -> google.protobuf.FieldMask
	23, // 48: ttn.lorawan.v3.ListApplicationWebhookTemplatesRequest.field_mask:type_name -> google.protobuf.FieldMask
	24, // 49: ttn.lorawan.v3.ApplicationWebhookHealth.WebhookHealthStatusUnhealthy.last_failed_attempt_at:type_name -> google.protobuf.Timestamp
	25, // 50: ttn.lorawan.v3.ApplicationWebhookHealth.WebhookHealthStatusUnhealthy.last_failed_attempt_details:type_name -> ttn.lorawan.v3.ErrorDetails
	26, // 51: ttn.lorawan.v3.ApplicationWebhookRegistry.GetFormats:input_type -> google.protobuf.Empty
	12, // 52: ttn.lorawan.v3.ApplicationWebhookRegistry.GetTemplate:input_type -> ttn.lorawan.v3.GetApplicationWebhookTemplateRequest
	13, // 53: ttn.lorawan.v3.ApplicationWebhookRegistry.ListTemplates:input_type -> ttn.lorawan.v3.ListApplicationWebhookTemplatesRequest
	9,  // 54: ttn.lorawan.v3.ApplicationWebhookRegistry.Get:input_type -> ttn.lorawan.v3.GetApplicationWebhookRequest
	10, // 55: ttn.lorawan.v3.ApplicationWebhookRegistry.List:input_type -> ttn.lorawan.v3.ListApplicationWebhooksRequest
	11, // 56: ttn.lorawan.v3.ApplicationWebhookRegistry.Set:input_type -> ttn.lorawan.v3.SetApplicationWebhookRequest
	0,  // 57: ttn.lorawan.v3.ApplicationWebhookRegistry.Delete:input_type -> ttn.lorawan.v3.ApplicationWebhookIdentifiers
	8,  // 58: ttn.lorawan.v3.ApplicationWebhookRegistry.GetFormats:output_type -> ttn.lorawan.v3.ApplicationWebhookFormats
	3,  // 59: ttn.lorawan.v3.ApplicationWebhookRegistry.GetTemplate:output_type -> ttn.lorawan.v3.ApplicationWebhookTemplate
	4,  // 60: ttn.lorawan.v3.ApplicationWebhookRegistry.ListTemplates:output_type -> ttn.lorawan.v3.ApplicationWebhookTemplates
	6,  // 61: ttn.lorawan.v3.ApplicationWebhookRegistry.Get:output_type -> ttn.lorawan.v3.ApplicationWebhook
	7,  // 62: ttn.lorawan.v3.ApplicationWebhookRegistry.List:output_type -> ttn.lorawan.v3.ApplicationWebhooks
	6,  // 63: ttn.lorawan.v3.ApplicationWebhookRegistry.Set:output_type -> ttn.lorawan.v3.ApplicationWebhook
	26, // 64: ttn.lorawan.v3.ApplicationWebhookRegistry.Delete:output_type -> google.protobuf.Empty
	58, // [58:65] is the sub-list for method output_type
	51, // [51:58] is the sub-list for method input_type
	51, // [51:51] is the sub-list for extension type_name
	51, // [51:51] is the sub-list for extension extendee
	0,  // [0:51] is the sub-list for field type_name
}

func init() { file_ttn_lorawan_v3_applicationserver_web_proto_init() }
func file_ttn_lorawan_v3_applicationserver_web_proto_init() {
	if File_ttn_lorawan_v3_applicationserver_web_proto != nil {
		return
	}
	file_ttn_lorawan_v3_error_proto_init()
	file_ttn_lorawan_v3_identifiers_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationWebhookIdentifiers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationWebhookTemplateIdentifiers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationWebhookTemplateField); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationWebhookTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationWebhookTemplates); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationWebhookHealth); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationWebhook); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationWebhooks); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationWebhookFormats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetApplicationWebhookRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListApplicationWebhooksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetApplicationWebhookRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetApplicationWebhookTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListApplicationWebhookTemplatesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationWebhookTemplate_Message); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationWebhookHealth_WebhookHealthStatusHealthy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationWebhookHealth_WebhookHealthStatusUnhealthy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationWebhook_Message); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*ApplicationWebhookHealth_Healthy)(nil),
		(*ApplicationWebhookHealth_Unhealthy)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ttn_lorawan_v3_applicationserver_web_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_ttn_lorawan_v3_applicationserver_web_proto_goTypes,
		DependencyIndexes: file_ttn_lorawan_v3_applicationserver_web_proto_depIdxs,
		MessageInfos:      file_ttn_lorawan_v3_applicationserver_web_proto_msgTypes,
	}.Build()
	File_ttn_lorawan_v3_applicationserver_web_proto = out.File
	file_ttn_lorawan_v3_applicationserver_web_proto_rawDesc = nil
	file_ttn_lorawan_v3_applicationserver_web_proto_goTypes = nil
	file_ttn_lorawan_v3_applicationserver_web_proto_depIdxs = nil
}
